// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Collections.Generic;
using System.IO;

// DIRECTIONS:
//    This file isn't very robust and makes several assumptions
//    You can execute it by calling "csi .\GenerateTests.csx"
//
//    csi can be found under the <repo-root>\tools\net46\roslyn directory
//    It must be run such from the directory that contains the csx script
//
//    New tests can be generated from the template by adding an entry to the
//    appropriate Inputs array below.
//
//    You can support a new Isa by creating a new array and adding a new
//    "ProcessInputs" call at the bottom of the script.

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector64Inputs = new []
{
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),

    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector64_1Inputs = new []
{
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8" }),

    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()" }),

    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "7", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "0", ["ConsumeValues"] = "values[0]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "3", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "1", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "7", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "1", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "3", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "1", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "0", ["ConsumeValues"] = "values[0]" }),

    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0]" }),

    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0]" }),

    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0]" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector128Inputs = new []
{
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),

    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector128_1Inputs = new []
{
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16" }),

    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()" }),

    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector256Inputs = new []
{
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),

    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector256_1Inputs = new []
{
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32" }),

    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()" }),

    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "31", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "31", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] NotSupportedInputs = new []
{
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Zero",                      ["TargetType"] = "Vector64<bool>",    ["Source"] = "Vector64<bool>",             ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Boolean",  ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64ByteAsGeneric_Boolean",     ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<byte>)",    ["Method"] = "As<byte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64DoubleAsGeneric_Boolean",   ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<double>)",  ["Method"] = "As<double, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int16AsGeneric_Boolean",    ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<short>)",   ["Method"] = "As<short, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int32AsGeneric_Boolean",    ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<int>)",     ["Method"] = "As<int, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int64AsGeneric_Boolean",    ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<long>)",    ["Method"] = "As<long, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64SByteAsGeneric_Boolean",    ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<sbyte>)",   ["Method"] = "As<sbyte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64SingleAsGeneric_Boolean",   ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<float>)",   ["Method"] = "As<float, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt16AsGeneric_Boolean",   ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<ushort>)",  ["Method"] = "As<ushort, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt32AsGeneric_Boolean",   ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<uint>)",    ["Method"] = "As<uint, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt64AsGeneric_Boolean",   ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<ulong>)",   ["Method"] = "As<ulong, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Byte",     ["TargetType"] = "Vector64<byte>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Double",   ["TargetType"] = "Vector64<double>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Int16",    ["TargetType"] = "Vector64<short>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Int32",    ["TargetType"] = "Vector64<int>",     ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Int64",    ["TargetType"] = "Vector64<long>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_SByte",    ["TargetType"] = "Vector64<sbyte>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Single",   ["TargetType"] = "Vector64<float>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_UInt16",   ["TargetType"] = "Vector64<ushort>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_UInt32",   ["TargetType"] = "Vector64<uint>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_UInt64",   ["TargetType"] = "Vector64<ulong>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsByte",             ["TargetType"] = "Vector64<byte>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsDouble",           ["TargetType"] = "Vector64<double>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsInt16",            ["TargetType"] = "Vector64<short>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsInt32",            ["TargetType"] = "Vector64<int>",     ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsInt64",            ["TargetType"] = "Vector64<long>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsSByte",            ["TargetType"] = "Vector64<sbyte>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsSingle",           ["TargetType"] = "Vector64<float>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsUInt16",           ["TargetType"] = "Vector64<ushort>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsUInt32",           ["TargetType"] = "Vector64<uint>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsUInt64",           ["TargetType"] = "Vector64<ulong>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64GetElementNegativeOne",     ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64GetElement0",               ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64GetElementMaxValue",        ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64WithElementNegativeOne",    ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "WithElement(-1, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64WithElement0",              ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "WithElement(0, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64WithElementMaxValue",       ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "WithElement(int.MaxValue, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64ToScalar",                  ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64ToVector128",               ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToVector128()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64ToVector128Unsafe",         ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToVector128Unsafe()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64ToString",                  ["TargetType"] = "string",            ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Zero",                     ["TargetType"] = "Vector128<bool>",   ["Source"] = "Vector128<bool>",            ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Boolean", ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128ByteAsGeneric_Boolean",    ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<byte>)",   ["Method"] = "As<byte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128DoubleAsGeneric_Boolean",  ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<double>)", ["Method"] = "As<double, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int16AsGeneric_Boolean",   ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<short>)",  ["Method"] = "As<short, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int32AsGeneric_Boolean",   ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<int>)",    ["Method"] = "As<int, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int64AsGeneric_Boolean",   ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<long>)",   ["Method"] = "As<long, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128SByteAsGeneric_Boolean",   ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<sbyte>)",  ["Method"] = "As<sbyte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128SingleAsGeneric_Boolean",  ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<float>)",  ["Method"] = "As<float, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt16AsGeneric_Boolean",  ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<ushort>)", ["Method"] = "As<ushort, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt32AsGeneric_Boolean",  ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<uint>)",   ["Method"] = "As<uint, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt64AsGeneric_Boolean",  ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<ulong>)",  ["Method"] = "As<ulong, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Byte",    ["TargetType"] = "Vector128<byte>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Double",  ["TargetType"] = "Vector128<double>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Int16",   ["TargetType"] = "Vector128<short>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Int32",   ["TargetType"] = "Vector128<int>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Int64",   ["TargetType"] = "Vector128<long>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_SByte",   ["TargetType"] = "Vector128<sbyte>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Single",  ["TargetType"] = "Vector128<float>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_UInt16",  ["TargetType"] = "Vector128<ushort>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_UInt32",  ["TargetType"] = "Vector128<uint>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_UInt64",  ["TargetType"] = "Vector128<ulong>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsByte",            ["TargetType"] = "Vector128<byte>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsDouble",          ["TargetType"] = "Vector128<double>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsInt16",           ["TargetType"] = "Vector128<short>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsInt32",           ["TargetType"] = "Vector128<int>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsInt64",           ["TargetType"] = "Vector128<long>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsSByte",           ["TargetType"] = "Vector128<sbyte>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsSingle",          ["TargetType"] = "Vector128<float>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsUInt16",          ["TargetType"] = "Vector128<ushort>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsUInt32",          ["TargetType"] = "Vector128<uint>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsUInt64",          ["TargetType"] = "Vector128<ulong>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128GetElementNegativeOne",    ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128GetElement0",              ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128GetElementMaxValue",       ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128WithElementNegativeOne",   ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithElement(-1, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128WithElement0",             ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithElement(0, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128WithElementMaxValue",      ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithElement(int.MaxValue, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128GetLower",                 ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetLower()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128WithLower",                ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithLower(default(Vector64<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128GetUpper",                 ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetUpper()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128WithUpper",                ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithUpper(default(Vector64<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128ToScalar",                 ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128ToVector256",              ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToVector256()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128ToVector256Unsafe",        ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToVector256Unsafe()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128ToString",                 ["TargetType"] = "string",            ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Zero",                     ["TargetType"] = "Vector256<bool>",   ["Source"] = "Vector256<bool>",            ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Boolean", ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256ByteAsGeneric_Boolean",    ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<byte>)",   ["Method"] = "As<byte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256DoubleAsGeneric_Boolean",  ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<double>)", ["Method"] = "As<double, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int16AsGeneric_Boolean",   ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<short>)",  ["Method"] = "As<short, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int32AsGeneric_Boolean",   ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<int>)",    ["Method"] = "As<int, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int64AsGeneric_Boolean",   ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<long>)",   ["Method"] = "As<long, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256SByteAsGeneric_Boolean",   ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<sbyte>)",  ["Method"] = "As<sbyte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256SingleAsGeneric_Boolean",  ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<float>)",  ["Method"] = "As<float, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt16AsGeneric_Boolean",  ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<ushort>)", ["Method"] = "As<ushort, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt32AsGeneric_Boolean",  ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<uint>)",   ["Method"] = "As<uint, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt64AsGeneric_Boolean",  ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<ulong>)",  ["Method"] = "As<ulong, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Byte",    ["TargetType"] = "Vector256<byte>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Double",  ["TargetType"] = "Vector256<double>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Int16",   ["TargetType"] = "Vector256<short>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Int32",   ["TargetType"] = "Vector256<int>",    ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Int64",   ["TargetType"] = "Vector256<long>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_SByte",   ["TargetType"] = "Vector256<sbyte>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Single",  ["TargetType"] = "Vector256<float>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_UInt16",  ["TargetType"] = "Vector256<ushort>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_UInt32",  ["TargetType"] = "Vector256<uint>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_UInt64",  ["TargetType"] = "Vector256<ulong>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsByte",            ["TargetType"] = "Vector256<byte>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsDouble",          ["TargetType"] = "Vector256<double>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsInt16",           ["TargetType"] = "Vector256<short>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsInt32",           ["TargetType"] = "Vector256<int>",    ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsInt64",           ["TargetType"] = "Vector256<long>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsSByte",           ["TargetType"] = "Vector256<sbyte>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsSingle",          ["TargetType"] = "Vector256<float>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsUInt16",          ["TargetType"] = "Vector256<ushort>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsUInt32",          ["TargetType"] = "Vector256<uint>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsUInt64",          ["TargetType"] = "Vector256<ulong>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256GetElementNegativeOne",    ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256GetElement0",              ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256GetElementMaxValue",       ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256WithElementNegativeOne",   ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithElement(-1, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256WithElement0",             ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithElement(0, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256WithElementMaxValue",      ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithElement(int.MaxValue, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256GetLower",                 ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetLower()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256WithLower",                ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithLower(default(Vector128<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256GetUpper",                 ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetUpper()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256WithUpper",                ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithUpper(default(Vector128<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256ToScalar",                 ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256ToString",                 ["TargetType"] = "string",            ["Source"] = "default(Vector256<bool>)",   ["Method"] = "ToString()" }),
};

private static void ProcessInputs(string groupName, (string templateFileName, Dictionary<string, string> templateData)[] inputs)
{
    var testListFileName = Path.Combine("..", groupName, $"Program.{groupName}.cs");

    using (var testListFile = new StreamWriter(testListFileName, append: false))
    {
        testListFile.WriteLine(@"// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.General
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {");

        foreach (var input in inputs)
        {
            ProcessInput(testListFile, groupName, input);
        }

        testListFile.WriteLine(@"            };
        }
    }
}");
    }
}

private static void ProcessInput(StreamWriter testListFile, string groupName, (string templateFileName, Dictionary<string, string> templateData) input)
{
    var testName = "";

    // Ex: ["Add.Single"] = AddSingle
    if (input.templateFileName == "VectorCreateElementTest.template")
    {
        testName = $"{input.templateData["Method"]}Element.{input.templateData["BaseType"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}Element{input.templateData["BaseType"]},");
    }
    else if (input.templateFileName == "VectorCreateVectorTest.template")
    {
        testName = $"{input.templateData["Method"]}Vector.{input.templateData["BaseType"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}Vector{input.templateData["BaseType"]},");
    }
    else if (input.templateFileName == "VectorGetAndWithElementTest.template")
    {
        testName = $"{input.templateData["Method"]}.{input.templateData["BaseType"]}.{input.templateData["Imm"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}{input.templateData["BaseType"]}{input.templateData["Imm"]},");
    }
    else if (input.templateFileName == "VectorNotSupportedTest.template")
    {
        testName = input.templateData["Name"];
        testListFile.WriteLine($@"                [""{testName}""] = {testName},");
    }
    else
    {
        testName = $"{input.templateData["Method"]}.{input.templateData["BaseType"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}{input.templateData["BaseType"]},");
    }

    var testFileName = Path.Combine("..", groupName, $"{testName}.cs");
    var template = File.ReadAllText(input.templateFileName);

    foreach (var kvp in input.templateData)
    {
        template = template.Replace($"{{{kvp.Key}}}", kvp.Value);
    }

    File.WriteAllText(testFileName, template);
}

ProcessInputs("Vector64", Vector64Inputs);
ProcessInputs("Vector64_1", Vector64_1Inputs);
ProcessInputs("Vector128", Vector128Inputs);
ProcessInputs("Vector128_1", Vector128_1Inputs);
ProcessInputs("Vector256", Vector256Inputs);
ProcessInputs("Vector256_1", Vector256_1Inputs);
ProcessInputs("NotSupported", NotSupportedInputs);
