# System.Web.UI.WebControls

``` diff
+namespace System.Web.UI.WebControls {
+    public class AccessDataSource : SqlDataSource {
+        public AccessDataSource();
+        public AccessDataSource(string dataFile, string selectCommand);
+        public override string ConnectionString { get; set; }
+        public string DataFile { get; set; }
+        public override string ProviderName { get; set; }
+        public override string SqlCacheDependency { get; set; }
+        protected override SqlDataSourceView CreateDataSourceView(string viewName);
+        protected override DbProviderFactory GetDbProviderFactory();
+    }
+    public class AccessDataSourceView : SqlDataSourceView {
+        public AccessDataSourceView(AccessDataSource owner, string name, HttpContext context);
+        protected internal override IEnumerable ExecuteSelect(DataSourceSelectArguments arguments);
+    }
+    public class AdCreatedEventArgs : EventArgs {
+        public AdCreatedEventArgs(IDictionary adProperties);
+        public IDictionary AdProperties { get; }
+        public string AlternateText { get; set; }
+        public string ImageUrl { get; set; }
+        public string NavigateUrl { get; set; }
+    }
+    public delegate void AdCreatedEventHandler(object sender, AdCreatedEventArgs e);
+    public class AdRotator : DataBoundControl {
+        public AdRotator();
+        public string AdvertisementFile { get; set; }
+        public string AlternateTextField { get; set; }
+        public override FontInfo Font { get; }
+        public string ImageUrlField { get; set; }
+        public string KeywordFilter { get; set; }
+        public string NavigateUrlField { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public string Target { get; set; }
+        public override string UniqueID { get; }
+        public event AdCreatedEventHandler AdCreated;
+        protected virtual void OnAdCreated(AdCreatedEventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected internal override void PerformDataBinding(IEnumerable data);
+        protected override void PerformSelect();
+        protected internal override void Render(HtmlTextWriter writer);
+    }
+    public class AssociatedControlConverter : ControlIDConverter {
+        public AssociatedControlConverter();
+        protected override bool FilterControl(Control control);
+    }
+    public class AuthenticateEventArgs : EventArgs {
+        public AuthenticateEventArgs();
+        public AuthenticateEventArgs(bool authenticated);
+        public bool Authenticated { get; set; }
+    }
+    public delegate void AuthenticateEventHandler(object sender, AuthenticateEventArgs e);
+    public enum AutoCompleteType {
+        BusinessCity = 23,
+        BusinessCountryRegion = 24,
+        BusinessFax = 25,
+        BusinessPhone = 26,
+        BusinessState = 27,
+        BusinessStreetAddress = 28,
+        BusinessUrl = 29,
+        BusinessZipCode = 30,
+        Cellular = 2,
+        Company = 3,
+        Department = 4,
+        Disabled = 1,
+        DisplayName = 5,
+        Email = 6,
+        Enabled = 32,
+        FirstName = 7,
+        Gender = 8,
+        HomeCity = 9,
+        HomeCountryRegion = 10,
+        HomeFax = 11,
+        Homepage = 16,
+        HomePhone = 12,
+        HomeState = 13,
+        HomeStreetAddress = 14,
+        HomeZipCode = 15,
+        JobTitle = 17,
+        LastName = 18,
+        MiddleName = 19,
+        None = 0,
+        Notes = 20,
+        Office = 21,
+        Pager = 22,
+        Search = 31,
+    }
+    public abstract class AutoFieldsGenerator : IAutoFieldGenerator, IStateManager {
+        protected AutoFieldsGenerator();
+        protected internal List<AutoGeneratedFieldProperties> AutoGeneratedFieldProperties { get; }
+        public Nullable<bool> AutoGenerateEnumFields { get; set; }
+        protected bool IsTrackingViewState { get; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        protected virtual AutoGeneratedField CreateAutoGeneratedFieldFromFieldProperties(AutoGeneratedFieldProperties fieldProperties);
+        public abstract List<AutoGeneratedField> CreateAutoGeneratedFields(object dataItem, Control control);
+        public virtual ICollection GenerateFields(Control control);
+        protected virtual void LoadViewState(object savedState);
+        protected virtual object SaveViewState();
+        void System.Web.UI.IStateManager.LoadViewState(object savedState);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        protected virtual void TrackViewState();
+    }
+    public sealed class AutoGeneratedField : BoundField {
+        public AutoGeneratedField(string dataField);
+        public override bool ConvertEmptyStringToNull { get; set; }
+        public override string DataFormatString { get; set; }
+        public Type DataType { get; set; }
+        public override bool InsertVisible { get; set; }
+        protected override void CopyProperties(DataControlField newField);
+        protected override DataControlField CreateField();
+        public override void ExtractValuesFromCell(IOrderedDictionary dictionary, DataControlFieldCell cell, DataControlRowState rowState, bool includeReadOnly);
+        protected override object GetDesignTimeValue();
+        protected override void InitializeDataCell(DataControlFieldCell cell, DataControlRowState rowState);
+        protected override void OnDataBindField(object sender, EventArgs e);
+        public override void ValidateSupportsCallback();
+    }
+    public sealed class AutoGeneratedFieldProperties : IStateManager {
+        public AutoGeneratedFieldProperties();
+        public string DataField { get; set; }
+        public bool IsReadOnly { get; set; }
+        public string Name { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public Type Type { get; set; }
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+    }
+    public abstract class BaseCompareValidator : BaseValidator {
+        protected BaseCompareValidator();
+        public bool CultureInvariantValues { get; set; }
+        protected static int CutoffYear { get; }
+        public ValidationDataType Type { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        public static bool CanConvert(string text, ValidationDataType type);
+        public static bool CanConvert(string text, ValidationDataType type, bool cultureInvariant);
+        protected static bool Compare(string leftText, bool cultureInvariantLeftText, string rightText, bool cultureInvariantRightText, ValidationCompareOperator op, ValidationDataType type);
+        protected static bool Compare(string leftText, string rightText, ValidationCompareOperator op, ValidationDataType type);
+        protected static bool Convert(string text, ValidationDataType type, bool cultureInvariant, out object value);
+        protected static bool Convert(string text, ValidationDataType type, out object value);
+        protected override bool DetermineRenderUplevel();
+        protected static string GetDateElementOrder();
+        protected static int GetFullYear(int shortYear);
+    }
+    public abstract class BaseDataBoundControl : WebControl {
+        protected BaseDataBoundControl();
+        public virtual object DataSource { get; set; }
+        public virtual string DataSourceID { get; set; }
+        protected bool Initialized { get; }
+        protected bool IsBoundUsingDataSourceID { get; }
+        protected internal bool IsDataBindingAutomatic { get; }
+        protected virtual bool IsUsingModelBinders { get; }
+        protected bool RequiresDataBinding { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        public event EventHandler DataBound;
+        protected void ConfirmInitState();
+        public override void DataBind();
+        protected virtual void EnsureDataBound();
+        protected virtual void OnDataBound(EventArgs e);
+        protected virtual void OnDataPropertyChanged();
+        protected internal override void OnInit(EventArgs e);
+        protected virtual void OnPagePreLoad(object sender, EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected abstract void PerformSelect();
+        protected abstract void ValidateDataSource(object dataSource);
+    }
+    public abstract class BaseDataList : WebControl {
+        protected BaseDataList();
+        public virtual string Caption { get; set; }
+        public virtual TableCaptionAlign CaptionAlign { get; set; }
+        public virtual int CellPadding { get; set; }
+        public virtual int CellSpacing { get; set; }
+        public override ControlCollection Controls { get; }
+        public virtual string DataKeyField { get; set; }
+        public DataKeyCollection DataKeys { get; }
+        protected ArrayList DataKeysArray { get; }
+        public string DataMember { get; set; }
+        public virtual object DataSource { get; set; }
+        public virtual string DataSourceID { get; set; }
+        public virtual GridLines GridLines { get; set; }
+        public virtual HorizontalAlign HorizontalAlign { get; set; }
+        protected bool Initialized { get; }
+        protected bool IsBoundUsingDataSourceID { get; }
+        protected bool RequiresDataBinding { get; set; }
+        protected DataSourceSelectArguments SelectArguments { get; }
+        public override bool SupportsDisabledAttribute { get; }
+        public virtual bool UseAccessibleHeader { get; set; }
+        public event EventHandler SelectedIndexChanged;
+        protected override void AddParsedSubObject(object obj);
+        protected internal override void CreateChildControls();
+        protected abstract void CreateControlHierarchy(bool useDataSource);
+        protected virtual DataSourceSelectArguments CreateDataSourceSelectArguments();
+        public override void DataBind();
+        protected void EnsureDataBound();
+        protected virtual IEnumerable GetData();
+        public static bool IsBindableType(Type type);
+        protected override void OnDataBinding(EventArgs e);
+        protected virtual void OnDataPropertyChanged();
+        protected virtual void OnDataSourceViewChanged(object sender, EventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void OnLoad(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void OnSelectedIndexChanged(EventArgs e);
+        protected internal abstract void PrepareControlHierarchy();
+        protected internal override void Render(HtmlTextWriter writer);
+    }
+    public abstract class BaseValidator : Label, IValidator {
+        protected BaseValidator();
+        public override string AssociatedControlID { get; set; }
+        public string ControlToValidate { get; set; }
+        public ValidatorDisplay Display { get; set; }
+        public bool EnableClientScript { get; set; }
+        public override bool Enabled { get; set; }
+        public string ErrorMessage { get; set; }
+        public override Color ForeColor { get; set; }
+        protected bool IsUnobtrusive { get; }
+        public bool IsValid { get; set; }
+        protected bool PropertiesValid { get; }
+        protected bool RenderUplevel { get; }
+        public bool SetFocusOnError { get; set; }
+        public override string Text { get; set; }
+        public virtual string ValidationGroup { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected void CheckControlValidationProperty(string name, string propertyName);
+        protected virtual bool ControlPropertiesValid();
+        protected virtual bool DetermineRenderUplevel();
+        protected abstract bool EvaluateIsValid();
+        protected string GetControlRenderID(string name);
+        protected string GetControlValidationValue(string name);
+        public static PropertyDescriptor GetValidationProperty(object component);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected internal override void OnUnload(EventArgs e);
+        protected void RegisterValidatorCommonScript();
+        protected virtual void RegisterValidatorDeclaration();
+        protected internal override void Render(HtmlTextWriter writer);
+        public void Validate();
+    }
+    public enum BorderStyle {
+        Dashed = 3,
+        Dotted = 2,
+        Double = 5,
+        Groove = 6,
+        Inset = 8,
+        None = 1,
+        NotSet = 0,
+        Outset = 9,
+        Ridge = 7,
+        Solid = 4,
+    }
+    public class BoundColumn : DataGridColumn {
+        public static readonly string thisExpr;
+        public BoundColumn();
+        public virtual string DataField { get; set; }
+        public virtual string DataFormatString { get; set; }
+        public virtual bool ReadOnly { get; set; }
+        protected virtual string FormatDataValue(object dataValue);
+        public override void Initialize();
+        public override void InitializeCell(TableCell cell, int columnIndex, ListItemType itemType);
+    }
+    public class BoundField : DataControlField {
+        public static readonly string ThisExpression;
+        public BoundField();
+        public virtual bool ApplyFormatInEditMode { get; set; }
+        public virtual bool ConvertEmptyStringToNull { get; set; }
+        public virtual string DataField { get; set; }
+        public virtual string DataFormatString { get; set; }
+        public override string HeaderText { get; set; }
+        public virtual bool HtmlEncode { get; set; }
+        public virtual bool HtmlEncodeFormatString { get; set; }
+        public virtual string NullDisplayText { get; set; }
+        public virtual bool ReadOnly { get; set; }
+        protected virtual bool SupportsHtmlEncode { get; }
+        public new ValidateRequestMode ValidateRequestMode { get; set; }
+        protected override void CopyProperties(DataControlField newField);
+        protected override DataControlField CreateField();
+        public override void ExtractValuesFromCell(IOrderedDictionary dictionary, DataControlFieldCell cell, DataControlRowState rowState, bool includeReadOnly);
+        protected virtual string FormatDataValue(object dataValue, bool encode);
+        protected virtual object GetDesignTimeValue();
+        protected virtual object GetValue(Control controlContainer);
+        public override bool Initialize(bool enableSorting, Control control);
+        public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex);
+        protected virtual void InitializeDataCell(DataControlFieldCell cell, DataControlRowState rowState);
+        protected override void LoadViewState(object state);
+        protected virtual void OnDataBindField(object sender, EventArgs e);
+        public override void ValidateSupportsCallback();
+    }
+    public class BulletedList : ListControl, IPostBackEventHandler {
+        public BulletedList();
+        public override bool AutoPostBack { get; set; }
+        public virtual string BulletImageUrl { get; set; }
+        public virtual BulletStyle BulletStyle { get; set; }
+        public override ControlCollection Controls { get; }
+        public virtual BulletedListDisplayMode DisplayMode { get; set; }
+        public virtual int FirstBulletNumber { get; set; }
+        public virtual bool RenderWhenDataEmpty { get; set; }
+        public override int SelectedIndex { get; set; }
+        public override ListItem SelectedItem { get; }
+        public override string SelectedValue { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public virtual string Target { get; set; }
+        public override string Text { get; set; }
+        public event BulletedListEventHandler Click;
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected virtual void OnClick(BulletedListEventArgs e);
+        protected virtual void RaisePostBackEvent(string eventArgument);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected virtual void RenderBulletText(ListItem item, int index, HtmlTextWriter writer);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+    }
+    public enum BulletedListDisplayMode {
+        HyperLink = 1,
+        LinkButton = 2,
+        Text = 0,
+    }
+    public class BulletedListEventArgs : EventArgs {
+        public BulletedListEventArgs(int index);
+        public int Index { get; }
+    }
+    public delegate void BulletedListEventHandler(object sender, BulletedListEventArgs e);
+    public enum BulletStyle {
+        Circle = 7,
+        CustomImage = 9,
+        Disc = 6,
+        LowerAlpha = 2,
+        LowerRoman = 4,
+        NotSet = 0,
+        Numbered = 1,
+        Square = 8,
+        UpperAlpha = 3,
+        UpperRoman = 5,
+    }
+    public class Button : WebControl, IButtonControl, IPostBackEventHandler {
+        public Button();
+        public virtual bool CausesValidation { get; set; }
+        public string CommandArgument { get; set; }
+        public string CommandName { get; set; }
+        public virtual string OnClientClick { get; set; }
+        public virtual string PostBackUrl { get; set; }
+        public string Text { get; set; }
+        public virtual bool UseSubmitBehavior { get; set; }
+        public virtual string ValidationGroup { get; set; }
+        public event EventHandler Click;
+        public event CommandEventHandler Command;
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected virtual PostBackOptions GetPostBackOptions();
+        protected virtual void OnClick(EventArgs e);
+        protected virtual void OnCommand(CommandEventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void RaisePostBackEvent(string eventArgument);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+    }
+    public class ButtonColumn : DataGridColumn {
+        public ButtonColumn();
+        public virtual ButtonColumnType ButtonType { get; set; }
+        public virtual bool CausesValidation { get; set; }
+        public virtual string CommandName { get; set; }
+        public virtual string DataTextField { get; set; }
+        public virtual string DataTextFormatString { get; set; }
+        public virtual string Text { get; set; }
+        public virtual string ValidationGroup { get; set; }
+        protected virtual string FormatDataTextValue(object dataTextValue);
+        public override void Initialize();
+        public override void InitializeCell(TableCell cell, int columnIndex, ListItemType itemType);
+    }
+    public enum ButtonColumnType {
+        LinkButton = 0,
+        PushButton = 1,
+    }
+    public class ButtonField : ButtonFieldBase {
+        public ButtonField();
+        public virtual string CommandName { get; set; }
+        public virtual string DataTextField { get; set; }
+        public virtual string DataTextFormatString { get; set; }
+        public virtual string ImageUrl { get; set; }
+        public virtual string Text { get; set; }
+        protected override void CopyProperties(DataControlField newField);
+        protected override DataControlField CreateField();
+        protected virtual string FormatDataTextValue(object dataTextValue);
+        public override bool Initialize(bool sortingEnabled, Control control);
+        public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex);
+        public override void ValidateSupportsCallback();
+    }
+    public abstract class ButtonFieldBase : DataControlField {
+        protected ButtonFieldBase();
+        public virtual ButtonType ButtonType { get; set; }
+        public virtual bool CausesValidation { get; set; }
+        public override bool ShowHeader { get; set; }
+        public virtual string ValidationGroup { get; set; }
+        protected override void CopyProperties(DataControlField newField);
+    }
+    public enum ButtonType {
+        Button = 0,
+        Image = 1,
+        Link = 2,
+    }
+    public class Calendar : WebControl, IPostBackEventHandler {
+        public Calendar();
+        public virtual string Caption { get; set; }
+        public virtual TableCaptionAlign CaptionAlign { get; set; }
+        public int CellPadding { get; set; }
+        public int CellSpacing { get; set; }
+        public TableItemStyle DayHeaderStyle { get; }
+        public DayNameFormat DayNameFormat { get; set; }
+        public TableItemStyle DayStyle { get; }
+        public FirstDayOfWeek FirstDayOfWeek { get; set; }
+        public string NextMonthText { get; set; }
+        public NextPrevFormat NextPrevFormat { get; set; }
+        public TableItemStyle NextPrevStyle { get; }
+        public TableItemStyle OtherMonthDayStyle { get; }
+        public string PrevMonthText { get; set; }
+        public DateTime SelectedDate { get; set; }
+        public SelectedDatesCollection SelectedDates { get; }
+        public TableItemStyle SelectedDayStyle { get; }
+        public CalendarSelectionMode SelectionMode { get; set; }
+        public string SelectMonthText { get; set; }
+        public TableItemStyle SelectorStyle { get; }
+        public string SelectWeekText { get; set; }
+        public bool ShowDayHeader { get; set; }
+        public bool ShowGridLines { get; set; }
+        public bool ShowNextPrevMonth { get; set; }
+        public bool ShowTitle { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        public TitleFormat TitleFormat { get; set; }
+        public TableItemStyle TitleStyle { get; }
+        public TableItemStyle TodayDayStyle { get; }
+        public DateTime TodaysDate { get; set; }
+        public virtual bool UseAccessibleHeader { get; set; }
+        public DateTime VisibleDate { get; set; }
+        public TableItemStyle WeekendDayStyle { get; }
+        public event DayRenderEventHandler DayRender;
+        public event EventHandler SelectionChanged;
+        public event MonthChangedEventHandler VisibleMonthChanged;
+        protected override ControlCollection CreateControlCollection();
+        protected bool HasWeekSelectors(CalendarSelectionMode selectionMode);
+        protected override void LoadViewState(object savedState);
+        protected virtual void OnDayRender(TableCell cell, CalendarDay day);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void OnSelectionChanged();
+        protected virtual void OnVisibleMonthChanged(DateTime newDate, DateTime previousDate);
+        protected virtual void RaisePostBackEvent(string eventArgument);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected override object SaveViewState();
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+        protected override void TrackViewState();
+    }
+    public class CalendarDay {
+        public CalendarDay(DateTime date, bool isWeekend, bool isToday, bool isSelected, bool isOtherMonth, string dayNumberText);
+        public DateTime Date { get; }
+        public string DayNumberText { get; }
+        public bool IsOtherMonth { get; }
+        public bool IsSelectable { get; set; }
+        public bool IsSelected { get; }
+        public bool IsToday { get; }
+        public bool IsWeekend { get; }
+    }
+    public enum CalendarSelectionMode {
+        Day = 1,
+        DayWeek = 2,
+        DayWeekMonth = 3,
+        None = 0,
+    }
+    public class CallingDataMethodsEventArgs : EventArgs {
+        public CallingDataMethodsEventArgs();
+        public object DataMethodsObject { get; set; }
+        public Type DataMethodsType { get; set; }
+    }
+    public delegate void CallingDataMethodsEventHandler(object sender, CallingDataMethodsEventArgs e);
+    public class ChangePassword : CompositeControl, IBorderPaddingControl, INamingContainer, IRenderOuterTableControl {
+        public static readonly string CancelButtonCommandName;
+        public static readonly string ChangePasswordButtonCommandName;
+        public static readonly string ContinueButtonCommandName;
+        public ChangePassword();
+        public virtual int BorderPadding { get; set; }
+        public virtual string CancelButtonImageUrl { get; set; }
+        public Style CancelButtonStyle { get; }
+        public virtual string CancelButtonText { get; set; }
+        public virtual ButtonType CancelButtonType { get; set; }
+        public virtual string CancelDestinationPageUrl { get; set; }
+        public virtual string ChangePasswordButtonImageUrl { get; set; }
+        public Style ChangePasswordButtonStyle { get; }
+        public virtual string ChangePasswordButtonText { get; set; }
+        public virtual ButtonType ChangePasswordButtonType { get; set; }
+        public virtual string ChangePasswordFailureText { get; set; }
+        public virtual ITemplate ChangePasswordTemplate { get; set; }
+        public Control ChangePasswordTemplateContainer { get; }
+        public virtual string ChangePasswordTitleText { get; set; }
+        public virtual string ConfirmNewPassword { get; }
+        public virtual string ConfirmNewPasswordLabelText { get; set; }
+        public virtual string ConfirmPasswordCompareErrorMessage { get; set; }
+        public virtual string ConfirmPasswordRequiredErrorMessage { get; set; }
+        public virtual string ContinueButtonImageUrl { get; set; }
+        public Style ContinueButtonStyle { get; }
+        public virtual string ContinueButtonText { get; set; }
+        public virtual ButtonType ContinueButtonType { get; set; }
+        public virtual string ContinueDestinationPageUrl { get; set; }
+        public virtual string CreateUserIconUrl { get; set; }
+        public virtual string CreateUserText { get; set; }
+        public virtual string CreateUserUrl { get; set; }
+        public virtual string CurrentPassword { get; }
+        public virtual bool DisplayUserName { get; set; }
+        public virtual string EditProfileIconUrl { get; set; }
+        public virtual string EditProfileText { get; set; }
+        public virtual string EditProfileUrl { get; set; }
+        public TableItemStyle FailureTextStyle { get; }
+        public virtual string HelpPageIconUrl { get; set; }
+        public virtual string HelpPageText { get; set; }
+        public virtual string HelpPageUrl { get; set; }
+        public TableItemStyle HyperLinkStyle { get; }
+        public virtual string InstructionText { get; set; }
+        public TableItemStyle InstructionTextStyle { get; }
+        public TableItemStyle LabelStyle { get; }
+        public MailDefinition MailDefinition { get; }
+        public virtual string MembershipProvider { get; set; }
+        public virtual string NewPassword { get; }
+        public virtual string NewPasswordLabelText { get; set; }
+        public virtual string NewPasswordRegularExpression { get; set; }
+        public virtual string NewPasswordRegularExpressionErrorMessage { get; set; }
+        public virtual string NewPasswordRequiredErrorMessage { get; set; }
+        public TableItemStyle PasswordHintStyle { get; }
+        public virtual string PasswordHintText { get; set; }
+        public virtual string PasswordLabelText { get; set; }
+        public virtual string PasswordRecoveryIconUrl { get; set; }
+        public virtual string PasswordRecoveryText { get; set; }
+        public virtual string PasswordRecoveryUrl { get; set; }
+        public virtual string PasswordRequiredErrorMessage { get; set; }
+        public virtual bool RenderOuterTable { get; set; }
+        public virtual string SuccessPageUrl { get; set; }
+        public virtual ITemplate SuccessTemplate { get; set; }
+        public Control SuccessTemplateContainer { get; }
+        public virtual string SuccessText { get; set; }
+        public TableItemStyle SuccessTextStyle { get; }
+        public virtual string SuccessTitleText { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public Style TextBoxStyle { get; }
+        public TableItemStyle TitleTextStyle { get; }
+        public virtual string UserName { get; set; }
+        public virtual string UserNameLabelText { get; set; }
+        public virtual string UserNameRequiredErrorMessage { get; set; }
+        public Style ValidatorTextStyle { get; }
+        public event EventHandler CancelButtonClick;
+        public event EventHandler ChangedPassword;
+        public event EventHandler ChangePasswordError;
+        public event LoginCancelEventHandler ChangingPassword;
+        public event EventHandler ContinueButtonClick;
+        public event MailMessageEventHandler SendingMail;
+        public event SendMailErrorEventHandler SendMailError;
+        protected internal override void CreateChildControls();
+        protected internal override void LoadControlState(object savedState);
+        protected override void LoadViewState(object savedState);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected virtual void OnCancelButtonClick(EventArgs e);
+        protected virtual void OnChangedPassword(EventArgs e);
+        protected virtual void OnChangePasswordError(EventArgs e);
+        protected virtual void OnChangingPassword(LoginCancelEventArgs e);
+        protected virtual void OnContinueButtonClick(EventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void OnSendingMail(MailMessageEventArgs e);
+        protected virtual void OnSendMailError(SendMailErrorEventArgs e);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected internal override object SaveControlState();
+        protected override object SaveViewState();
+        protected override void SetDesignModeState(IDictionary data);
+        protected override void TrackViewState();
+    }
+    public class CheckBox : WebControl, ICheckBoxControl, IPostBackDataHandler {
+        public CheckBox();
+        public virtual bool AutoPostBack { get; set; }
+        public virtual bool CausesValidation { get; set; }
+        public virtual bool Checked { get; set; }
+        public AttributeCollection InputAttributes { get; }
+        public AttributeCollection LabelAttributes { get; }
+        public virtual string Text { get; set; }
+        public virtual TextAlign TextAlign { get; set; }
+        public virtual string ValidationGroup { get; set; }
+        public event EventHandler CheckedChanged;
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected virtual bool LoadPostData(string postDataKey, NameValueCollection postCollection);
+        protected override void LoadViewState(object savedState);
+        protected virtual void OnCheckedChanged(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void RaisePostDataChangedEvent();
+        protected internal override void Render(HtmlTextWriter writer);
+        protected override object SaveViewState();
+        bool System.Web.UI.IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection);
+        void System.Web.UI.IPostBackDataHandler.RaisePostDataChangedEvent();
+        protected override void TrackViewState();
+    }
+    public class CheckBoxField : BoundField {
+        public CheckBoxField();
+        public override bool ApplyFormatInEditMode { get; set; }
+        public override bool ConvertEmptyStringToNull { get; set; }
+        public override string DataField { get; set; }
+        public override string DataFormatString { get; set; }
+        public override bool HtmlEncode { get; set; }
+        public override bool HtmlEncodeFormatString { get; set; }
+        public override string NullDisplayText { get; set; }
+        protected override bool SupportsHtmlEncode { get; }
+        public virtual string Text { get; set; }
+        protected override void CopyProperties(DataControlField newField);
+        protected override DataControlField CreateField();
+        public override void ExtractValuesFromCell(IOrderedDictionary dictionary, DataControlFieldCell cell, DataControlRowState rowState, bool includeReadOnly);
+        protected override object GetDesignTimeValue();
+        protected override void InitializeDataCell(DataControlFieldCell cell, DataControlRowState rowState);
+        protected override void OnDataBindField(object sender, EventArgs e);
+        public override void ValidateSupportsCallback();
+    }
+    public class CheckBoxList : ListControl, INamingContainer, IPostBackDataHandler, IRepeatInfoUser {
+        public CheckBoxList();
+        public virtual int CellPadding { get; set; }
+        public virtual int CellSpacing { get; set; }
+        protected virtual bool HasFooter { get; }
+        protected virtual bool HasHeader { get; }
+        protected virtual bool HasSeparators { get; }
+        public virtual bool RenderWhenDataEmpty { get; set; }
+        public virtual int RepeatColumns { get; set; }
+        public virtual RepeatDirection RepeatDirection { get; set; }
+        protected virtual int RepeatedItemCount { get; }
+        public virtual RepeatLayout RepeatLayout { get; set; }
+        bool System.Web.UI.WebControls.IRepeatInfoUser.HasFooter { get; }
+        bool System.Web.UI.WebControls.IRepeatInfoUser.HasHeader { get; }
+        bool System.Web.UI.WebControls.IRepeatInfoUser.HasSeparators { get; }
+        int System.Web.UI.WebControls.IRepeatInfoUser.RepeatedItemCount { get; }
+        public virtual TextAlign TextAlign { get; set; }
+        protected override Style CreateControlStyle();
+        protected override Control FindControl(string id, int pathOffset);
+        protected virtual Style GetItemStyle(ListItemType itemType, int repeatIndex);
+        protected virtual bool LoadPostData(string postDataKey, NameValueCollection postCollection);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void RaisePostDataChangedEvent();
+        protected internal override void Render(HtmlTextWriter writer);
+        protected virtual void RenderItem(ListItemType itemType, int repeatIndex, RepeatInfo repeatInfo, HtmlTextWriter writer);
+        bool System.Web.UI.IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection);
+        void System.Web.UI.IPostBackDataHandler.RaisePostDataChangedEvent();
+        Style System.Web.UI.WebControls.IRepeatInfoUser.GetItemStyle(ListItemType itemType, int repeatIndex);
+        void System.Web.UI.WebControls.IRepeatInfoUser.RenderItem(ListItemType itemType, int repeatIndex, RepeatInfo repeatInfo, HtmlTextWriter writer);
+    }
+    public sealed class CircleHotSpot : HotSpot {
+        public CircleHotSpot();
+        protected internal override string MarkupName { get; }
+        public int Radius { get; set; }
+        public int X { get; set; }
+        public int Y { get; set; }
+        public override string GetCoordinates();
+    }
+    public class CommandEventArgs : EventArgs {
+        public CommandEventArgs(string commandName, object argument);
+        public CommandEventArgs(CommandEventArgs e);
+        public object CommandArgument { get; }
+        public string CommandName { get; }
+    }
+    public delegate void CommandEventHandler(object sender, CommandEventArgs e);
+    public class CommandField : ButtonFieldBase {
+        public CommandField();
+        public virtual string CancelImageUrl { get; set; }
+        public virtual string CancelText { get; set; }
+        public override bool CausesValidation { get; set; }
+        public virtual string DeleteImageUrl { get; set; }
+        public virtual string DeleteText { get; set; }
+        public virtual string EditImageUrl { get; set; }
+        public virtual string EditText { get; set; }
+        public virtual string InsertImageUrl { get; set; }
+        public virtual string InsertText { get; set; }
+        public virtual string NewImageUrl { get; set; }
+        public virtual string NewText { get; set; }
+        public virtual string SelectImageUrl { get; set; }
+        public virtual string SelectText { get; set; }
+        public virtual bool ShowCancelButton { get; set; }
+        public virtual bool ShowDeleteButton { get; set; }
+        public virtual bool ShowEditButton { get; set; }
+        public virtual bool ShowInsertButton { get; set; }
+        public virtual bool ShowSelectButton { get; set; }
+        public virtual string UpdateImageUrl { get; set; }
+        public virtual string UpdateText { get; set; }
+        protected override void CopyProperties(DataControlField newField);
+        protected override DataControlField CreateField();
+        public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex);
+        public override void ValidateSupportsCallback();
+    }
+    public class CompareValidator : BaseCompareValidator {
+        public CompareValidator();
+        public string ControlToCompare { get; set; }
+        public ValidationCompareOperator Operator { get; set; }
+        public string ValueToCompare { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override bool ControlPropertiesValid();
+        protected override bool EvaluateIsValid();
+    }
+    public sealed class CompleteWizardStep : TemplatedWizardStep {
+        public CompleteWizardStep();
+        public override WizardStepType StepType { get; set; }
+        public override string Title { get; set; }
+    }
+    public abstract class CompositeControl : WebControl, ICompositeControlDesignerAccessor, INamingContainer {
+        protected CompositeControl();
+        public override ControlCollection Controls { get; }
+        public override bool SupportsDisabledAttribute { get; }
+        public override void DataBind();
+        protected virtual void RecreateChildControls();
+        protected internal override void Render(HtmlTextWriter writer);
+        void System.Web.UI.WebControls.ICompositeControlDesignerAccessor.RecreateChildControls();
+    }
+    public abstract class CompositeDataBoundControl : DataBoundControl, INamingContainer {
+        protected CompositeDataBoundControl();
+        public override ControlCollection Controls { get; }
+        protected internal string DeleteMethod { get; set; }
+        protected internal string InsertMethod { get; set; }
+        protected override bool IsUsingModelBinders { get; }
+        protected internal string UpdateMethod { get; set; }
+        protected internal override void CreateChildControls();
+        protected abstract int CreateChildControls(IEnumerable dataSource, bool dataBinding);
+        protected internal override void PerformDataBinding(IEnumerable data);
+    }
+    public class Content : Control, INamingContainer, INonBindingContainer {
+        public Content();
+        public string ContentPlaceHolderID { get; set; }
+        public new event EventHandler DataBinding;
+        public new event EventHandler Disposed;
+        public new event EventHandler Init;
+        public new event EventHandler Load;
+        public new event EventHandler PreRender;
+        public new event EventHandler Unload;
+    }
+    public enum ContentDirection {
+        LeftToRight = 1,
+        NotSet = 0,
+        RightToLeft = 2,
+    }
+    public class ContentPlaceHolder : Control, INamingContainer, INonBindingContainer {
+        public ContentPlaceHolder();
+    }
+    public abstract class ContextDataSource : QueryableDataSource {
+        protected ContextDataSource();
+        public virtual string ContextTypeName { get; set; }
+        protected string EntitySetName { get; set; }
+        public virtual string EntityTypeName { get; set; }
+    }
+    public class ContextDataSourceContextData {
+        public ContextDataSourceContextData();
+        public ContextDataSourceContextData(object context);
+        public object Context { get; set; }
+        public object EntitySet { get; set; }
+    }
+    public abstract class ContextDataSourceView : QueryableDataSourceView {
+        protected static readonly object EventContextCreated;
+        protected static readonly object EventContextCreating;
+        protected static readonly object EventContextDisposing;
+        protected ContextDataSourceView(DataSourceControl owner, string viewName, HttpContext context);
+        protected object Context { get; set; }
+        public virtual Type ContextType { get; }
+        public virtual string ContextTypeName { get; set; }
+        protected object EntitySet { get; private set; }
+        public string EntitySetName { get; set; }
+        protected Type EntitySetType { get; }
+        protected override Type EntityType { get; }
+        public string EntityTypeName { get; set; }
+        protected virtual ContextDataSourceContextData CreateContext(DataSourceOperation operation);
+        protected void DisposeContext();
+        protected virtual void DisposeContext(object dataContext);
+        protected override int ExecuteDelete(IDictionary keys, IDictionary oldValues);
+        protected override int ExecuteInsert(IDictionary values);
+        protected override int ExecuteUpdate(IDictionary keys, IDictionary values, IDictionary oldValues);
+        protected virtual Type GetDataObjectType(Type type);
+        protected virtual Type GetEntitySetType();
+        protected override object GetSource(QueryContext context);
+    }
+    public class ControlIDConverter : StringConverter {
+        public ControlIDConverter();
+        protected virtual bool FilterControl(Control control);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+    }
+    public class ControlParameter : Parameter {
+        public ControlParameter();
+        public ControlParameter(string name, DbType dbType, string controlID, string propertyName);
+        public ControlParameter(string name, string controlID);
+        public ControlParameter(string name, string controlID, string propertyName);
+        public ControlParameter(string name, TypeCode type, string controlID, string propertyName);
+        protected ControlParameter(ControlParameter original);
+        public string ControlID { get; set; }
+        public string PropertyName { get; set; }
+        protected override Parameter Clone();
+        protected internal override object Evaluate(HttpContext context, Control control);
+    }
+    public class ControlPropertyNameConverter : StringConverter {
+        public ControlPropertyNameConverter();
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+    }
+    public class CookieParameter : Parameter {
+        public CookieParameter();
+        public CookieParameter(string name, DbType dbType, string cookieName);
+        public CookieParameter(string name, string cookieName);
+        public CookieParameter(string name, TypeCode type, string cookieName);
+        protected CookieParameter(CookieParameter original);
+        public string CookieName { get; set; }
+        public bool ValidateInput { get; set; }
+        protected override Parameter Clone();
+        protected internal override object Evaluate(HttpContext context, Control control);
+    }
+    public class CreateUserErrorEventArgs : EventArgs {
+        public CreateUserErrorEventArgs(MembershipCreateStatus s);
+        public MembershipCreateStatus CreateUserError { get; set; }
+    }
+    public delegate void CreateUserErrorEventHandler(object sender, CreateUserErrorEventArgs e);
+    public class CreateUserWizard : Wizard {
+        public static readonly string ContinueButtonCommandName;
+        public CreateUserWizard();
+        public override int ActiveStepIndex { get; set; }
+        public virtual string Answer { get; set; }
+        public virtual string AnswerLabelText { get; set; }
+        public virtual string AnswerRequiredErrorMessage { get; set; }
+        public virtual bool AutoGeneratePassword { get; set; }
+        public CompleteWizardStep CompleteStep { get; }
+        public virtual string CompleteSuccessText { get; set; }
+        public TableItemStyle CompleteSuccessTextStyle { get; }
+        public virtual string ConfirmPassword { get; }
+        public virtual string ConfirmPasswordCompareErrorMessage { get; set; }
+        public virtual string ConfirmPasswordLabelText { get; set; }
+        public virtual string ConfirmPasswordRequiredErrorMessage { get; set; }
+        public virtual string ContinueButtonImageUrl { get; set; }
+        public Style ContinueButtonStyle { get; }
+        public virtual string ContinueButtonText { get; set; }
+        public virtual ButtonType ContinueButtonType { get; set; }
+        public virtual string ContinueDestinationPageUrl { get; set; }
+        public virtual string CreateUserButtonImageUrl { get; set; }
+        public Style CreateUserButtonStyle { get; }
+        public virtual string CreateUserButtonText { get; set; }
+        public virtual ButtonType CreateUserButtonType { get; set; }
+        public CreateUserWizardStep CreateUserStep { get; }
+        public virtual bool DisableCreatedUser { get; set; }
+        public override bool DisplaySideBar { get; set; }
+        public virtual string DuplicateEmailErrorMessage { get; set; }
+        public virtual string DuplicateUserNameErrorMessage { get; set; }
+        public virtual string EditProfileIconUrl { get; set; }
+        public virtual string EditProfileText { get; set; }
+        public virtual string EditProfileUrl { get; set; }
+        public virtual string Email { get; set; }
+        public virtual string EmailLabelText { get; set; }
+        public virtual string EmailRegularExpression { get; set; }
+        public virtual string EmailRegularExpressionErrorMessage { get; set; }
+        public virtual string EmailRequiredErrorMessage { get; set; }
+        public TableItemStyle ErrorMessageStyle { get; }
+        public virtual string HelpPageIconUrl { get; set; }
+        public virtual string HelpPageText { get; set; }
+        public virtual string HelpPageUrl { get; set; }
+        public TableItemStyle HyperLinkStyle { get; }
+        public virtual string InstructionText { get; set; }
+        public TableItemStyle InstructionTextStyle { get; }
+        public virtual string InvalidAnswerErrorMessage { get; set; }
+        public virtual string InvalidEmailErrorMessage { get; set; }
+        public virtual string InvalidPasswordErrorMessage { get; set; }
+        public virtual string InvalidQuestionErrorMessage { get; set; }
+        public TableItemStyle LabelStyle { get; }
+        public virtual bool LoginCreatedUser { get; set; }
+        public MailDefinition MailDefinition { get; }
+        public virtual string MembershipProvider { get; set; }
+        public virtual string Password { get; }
+        public TableItemStyle PasswordHintStyle { get; }
+        public virtual string PasswordHintText { get; set; }
+        public virtual string PasswordLabelText { get; set; }
+        public virtual string PasswordRegularExpression { get; set; }
+        public virtual string PasswordRegularExpressionErrorMessage { get; set; }
+        public virtual string PasswordRequiredErrorMessage { get; set; }
+        public virtual string Question { get; set; }
+        protected internal bool QuestionAndAnswerRequired { get; }
+        public virtual string QuestionLabelText { get; set; }
+        public virtual string QuestionRequiredErrorMessage { get; set; }
+        public virtual bool RequireEmail { get; set; }
+        public override string SkipLinkText { get; set; }
+        public Style TextBoxStyle { get; }
+        public TableItemStyle TitleTextStyle { get; }
+        public virtual string UnknownErrorMessage { get; set; }
+        public virtual string UserName { get; set; }
+        public virtual string UserNameLabelText { get; set; }
+        public virtual string UserNameRequiredErrorMessage { get; set; }
+        public Style ValidatorTextStyle { get; }
+        public override WizardStepCollection WizardSteps { get; }
+        public event EventHandler ContinueButtonClick;
+        public event EventHandler CreatedUser;
+        public event CreateUserErrorEventHandler CreateUserError;
+        public event LoginCancelEventHandler CreatingUser;
+        public event MailMessageEventHandler SendingMail;
+        public event SendMailErrorEventHandler SendMailError;
+        protected internal override void CreateChildControls();
+        protected override IDictionary GetDesignModeState();
+        protected override void LoadViewState(object savedState);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected virtual void OnContinueButtonClick(EventArgs e);
+        protected virtual void OnCreatedUser(EventArgs e);
+        protected virtual void OnCreateUserError(CreateUserErrorEventArgs e);
+        protected virtual void OnCreatingUser(LoginCancelEventArgs e);
+        protected override void OnNextButtonClick(WizardNavigationEventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void OnSendingMail(MailMessageEventArgs e);
+        protected virtual void OnSendMailError(SendMailErrorEventArgs e);
+        protected override object SaveViewState();
+        protected override void SetDesignModeState(IDictionary data);
+        protected override void TrackViewState();
+    }
+    public sealed class CreateUserWizardStep : TemplatedWizardStep {
+        public CreateUserWizardStep();
+        public override bool AllowReturn { get; set; }
+        public override WizardStepType StepType { get; set; }
+        public override string Title { get; set; }
+    }
+    public class CreatingModelDataSourceEventArgs : EventArgs {
+        public CreatingModelDataSourceEventArgs();
+        public ModelDataSource ModelDataSource { get; set; }
+    }
+    public delegate void CreatingModelDataSourceEventHandler(object sender, CreatingModelDataSourceEventArgs e);
+    public class CustomValidator : BaseValidator {
+        public CustomValidator();
+        public string ClientValidationFunction { get; set; }
+        public bool ValidateEmptyText { get; set; }
+        public event ServerValidateEventHandler ServerValidate;
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override bool ControlPropertiesValid();
+        protected override bool EvaluateIsValid();
+        protected virtual bool OnServerValidate(string value);
+    }
+    public abstract class DataBoundControl : BaseDataBoundControl {
+        protected DataBoundControl();
+        public virtual string DataMember { get; set; }
+        public override string DataSourceID { get; set; }
+        public IDataSource DataSourceObject { get; }
+        protected override bool IsUsingModelBinders { get; }
+        public virtual string ItemType { get; set; }
+        protected DataSourceSelectArguments SelectArguments { get; }
+        public virtual string SelectMethod { get; set; }
+        public event CallingDataMethodsEventHandler CallingDataMethods;
+        public event CreatingModelDataSourceEventHandler CreatingModelDataSource;
+        protected virtual DataSourceSelectArguments CreateDataSourceSelectArguments();
+        protected virtual DataSourceView GetData();
+        protected virtual IDataSource GetDataSource();
+        protected override void LoadViewState(object savedState);
+        protected void MarkAsDataBound();
+        protected virtual void OnCreatingModelDataSource(CreatingModelDataSourceEventArgs e);
+        protected override void OnDataPropertyChanged();
+        protected virtual void OnDataSourceViewChanged(object sender, EventArgs e);
+        protected internal override void OnLoad(EventArgs e);
+        protected override void OnPagePreLoad(object sender, EventArgs e);
+        protected internal virtual void PerformDataBinding(IEnumerable data);
+        protected override void PerformSelect();
+        protected override object SaveViewState();
+        protected override void TrackViewState();
+        protected override void ValidateDataSource(object dataSource);
+    }
+    public enum DataBoundControlMode {
+        Edit = 1,
+        Insert = 2,
+        ReadOnly = 0,
+    }
+    public enum DataControlCellType {
+        DataCell = 2,
+        Footer = 1,
+        Header = 0,
+    }
+    public sealed class DataControlCommands {
+        public const string CancelCommandName = "Cancel";
+        public const string DeleteCommandName = "Delete";
+        public const string EditCommandName = "Edit";
+        public const string FirstPageCommandArgument = "First";
+        public const string InsertCommandName = "Insert";
+        public const string LastPageCommandArgument = "Last";
+        public const string NewCommandName = "New";
+        public const string NextPageCommandArgument = "Next";
+        public const string PageCommandName = "Page";
+        public const string PreviousPageCommandArgument = "Prev";
+        public const string SelectCommandName = "Select";
+        public const string SortCommandName = "Sort";
+        public const string UpdateCommandName = "Update";
+    }
+    public abstract class DataControlField : IDataSourceViewSchemaAccessor, IStateManager {
+        protected DataControlField();
+        public virtual string AccessibleHeaderText { get; set; }
+        protected Control Control { get; }
+        public Style ControlStyle { get; }
+        protected bool DesignMode { get; }
+        public TableItemStyle FooterStyle { get; }
+        public virtual string FooterText { get; set; }
+        public virtual string HeaderImageUrl { get; set; }
+        public TableItemStyle HeaderStyle { get; }
+        public virtual string HeaderText { get; set; }
+        public virtual bool InsertVisible { get; set; }
+        protected bool IsTrackingViewState { get; }
+        public TableItemStyle ItemStyle { get; }
+        public virtual bool ShowHeader { get; set; }
+        public virtual string SortExpression { get; set; }
+        object System.Web.UI.IDataSourceViewSchemaAccessor.DataSourceViewSchema { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        protected internal virtual ValidateRequestMode ValidateRequestMode { get; set; }
+        protected StateBag ViewState { get; }
+        public bool Visible { get; set; }
+        protected internal DataControlField CloneField();
+        protected virtual void CopyProperties(DataControlField newField);
+        protected abstract DataControlField CreateField();
+        public virtual void ExtractValuesFromCell(IOrderedDictionary dictionary, DataControlFieldCell cell, DataControlRowState rowState, bool includeReadOnly);
+        public virtual bool Initialize(bool sortingEnabled, Control control);
+        public virtual void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex);
+        protected virtual void LoadViewState(object savedState);
+        protected virtual void OnFieldChanged();
+        protected virtual object SaveViewState();
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        public override string ToString();
+        protected virtual void TrackViewState();
+        public virtual void ValidateSupportsCallback();
+    }
+    public class DataControlFieldCell : TableCell {
+        protected DataControlFieldCell(HtmlTextWriterTag tagKey, DataControlField containingField);
+        public DataControlFieldCell(DataControlField containingField);
+        public DataControlField ContainingField { get; }
+        public override ValidateRequestMode ValidateRequestMode { get; set; }
+    }
+    public sealed class DataControlFieldCollection : StateManagedCollection {
+        public DataControlFieldCollection();
+        public DataControlField this[int index] { get; }
+        public event EventHandler FieldsChanged;
+        public void Add(DataControlField field);
+        public DataControlFieldCollection CloneFields();
+        public bool Contains(DataControlField field);
+        public void CopyTo(DataControlField[] array, int index);
+        protected override object CreateKnownType(int index);
+        protected override Type[] GetKnownTypes();
+        public int IndexOf(DataControlField field);
+        public void Insert(int index, DataControlField field);
+        protected override void OnClearComplete();
+        protected override void OnInsertComplete(int index, object value);
+        protected override void OnRemoveComplete(int index, object value);
+        protected override void OnValidate(object o);
+        public void Remove(DataControlField field);
+        public void RemoveAt(int index);
+        protected override void SetDirtyObject(object o);
+    }
+    public class DataControlFieldHeaderCell : DataControlFieldCell {
+        public DataControlFieldHeaderCell(DataControlField containingField);
+        public virtual string AbbreviatedText { get; set; }
+        public virtual TableHeaderScope Scope { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+    }
+    public enum DataControlRowState {
+        Alternate = 1,
+        Edit = 4,
+        Insert = 8,
+        Normal = 0,
+        Selected = 2,
+    }
+    public enum DataControlRowType {
+        DataRow = 2,
+        EmptyDataRow = 5,
+        Footer = 1,
+        Header = 0,
+        Pager = 4,
+        Separator = 3,
+    }
+    public class DataGrid : BaseDataList, INamingContainer {
+        public const string CancelCommandName = "Cancel";
+        public const string DeleteCommandName = "Delete";
+        public const string EditCommandName = "Edit";
+        public const string NextPageCommandArgument = "Next";
+        public const string PageCommandName = "Page";
+        public const string PrevPageCommandArgument = "Prev";
+        public const string SelectCommandName = "Select";
+        public const string SortCommandName = "Sort";
+        public const string UpdateCommandName = "Update";
+        public DataGrid();
+        public virtual bool AllowCustomPaging { get; set; }
+        public virtual bool AllowPaging { get; set; }
+        public virtual bool AllowSorting { get; set; }
+        public virtual TableItemStyle AlternatingItemStyle { get; }
+        public virtual bool AutoGenerateColumns { get; set; }
+        public virtual string BackImageUrl { get; set; }
+        public virtual DataGridColumnCollection Columns { get; }
+        public int CurrentPageIndex { get; set; }
+        public virtual int EditItemIndex { get; set; }
+        public virtual TableItemStyle EditItemStyle { get; }
+        public virtual TableItemStyle FooterStyle { get; }
+        public virtual TableItemStyle HeaderStyle { get; }
+        public virtual DataGridItemCollection Items { get; }
+        public virtual TableItemStyle ItemStyle { get; }
+        public int PageCount { get; }
+        public virtual DataGridPagerStyle PagerStyle { get; }
+        public virtual int PageSize { get; set; }
+        public virtual int SelectedIndex { get; set; }
+        public virtual DataGridItem SelectedItem { get; }
+        public virtual TableItemStyle SelectedItemStyle { get; }
+        public virtual bool ShowFooter { get; set; }
+        public virtual bool ShowHeader { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public virtual int VirtualItemCount { get; set; }
+        public event DataGridCommandEventHandler CancelCommand;
+        public event DataGridCommandEventHandler DeleteCommand;
+        public event DataGridCommandEventHandler EditCommand;
+        public event DataGridCommandEventHandler ItemCommand;
+        public event DataGridItemEventHandler ItemCreated;
+        public event DataGridItemEventHandler ItemDataBound;
+        public event DataGridPageChangedEventHandler PageIndexChanged;
+        public event DataGridSortCommandEventHandler SortCommand;
+        public event DataGridCommandEventHandler UpdateCommand;
+        protected virtual ArrayList CreateColumnSet(PagedDataSource dataSource, bool useDataSource);
+        protected override void CreateControlHierarchy(bool useDataSource);
+        protected override Style CreateControlStyle();
+        protected virtual DataGridItem CreateItem(int itemIndex, int dataSourceIndex, ListItemType itemType);
+        protected virtual void InitializeItem(DataGridItem item, DataGridColumn[] columns);
+        protected virtual void InitializePager(DataGridItem item, int columnSpan, PagedDataSource pagedDataSource);
+        protected override void LoadViewState(object savedState);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected virtual void OnCancelCommand(DataGridCommandEventArgs e);
+        protected virtual void OnDeleteCommand(DataGridCommandEventArgs e);
+        protected virtual void OnEditCommand(DataGridCommandEventArgs e);
+        protected virtual void OnItemCommand(DataGridCommandEventArgs e);
+        protected virtual void OnItemCreated(DataGridItemEventArgs e);
+        protected virtual void OnItemDataBound(DataGridItemEventArgs e);
+        protected virtual void OnPageIndexChanged(DataGridPageChangedEventArgs e);
+        protected virtual void OnSortCommand(DataGridSortCommandEventArgs e);
+        protected virtual void OnUpdateCommand(DataGridCommandEventArgs e);
+        protected internal override void PrepareControlHierarchy();
+        protected override object SaveViewState();
+        protected override void TrackViewState();
+    }
+    public abstract class DataGridColumn : IStateManager {
+        protected DataGridColumn();
+        protected bool DesignMode { get; }
+        public virtual TableItemStyle FooterStyle { get; }
+        public virtual string FooterText { get; set; }
+        public virtual string HeaderImageUrl { get; set; }
+        public virtual TableItemStyle HeaderStyle { get; }
+        public virtual string HeaderText { get; set; }
+        protected bool IsTrackingViewState { get; }
+        public virtual TableItemStyle ItemStyle { get; }
+        protected DataGrid Owner { get; }
+        public virtual string SortExpression { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        protected StateBag ViewState { get; }
+        public bool Visible { get; set; }
+        public virtual void Initialize();
+        public virtual void InitializeCell(TableCell cell, int columnIndex, ListItemType itemType);
+        protected virtual void LoadViewState(object savedState);
+        protected virtual void OnColumnChanged();
+        protected virtual object SaveViewState();
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        public override string ToString();
+        protected virtual void TrackViewState();
+    }
+    public sealed class DataGridColumnCollection : ICollection, IEnumerable, IStateManager {
+        public DataGridColumnCollection(DataGrid owner, ArrayList columns);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public DataGridColumn this[int index] { get; }
+        public void Add(DataGridColumn column);
+        public void AddAt(int index, DataGridColumn column);
+        public void Clear();
+        public void CopyTo(Array array, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(DataGridColumn column);
+        public void Remove(DataGridColumn column);
+        public void RemoveAt(int index);
+        void System.Web.UI.IStateManager.LoadViewState(object savedState);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+    }
+    public class DataGridCommandEventArgs : CommandEventArgs {
+        public DataGridCommandEventArgs(DataGridItem item, object commandSource, CommandEventArgs originalArgs);
+        public object CommandSource { get; }
+        public DataGridItem Item { get; }
+    }
+    public delegate void DataGridCommandEventHandler(object source, DataGridCommandEventArgs e);
+    public class DataGridItem : TableRow, IDataItemContainer, INamingContainer {
+        public DataGridItem(int itemIndex, int dataSetIndex, ListItemType itemType);
+        public virtual object DataItem { get; set; }
+        public virtual int DataSetIndex { get; }
+        public virtual int ItemIndex { get; }
+        public virtual ListItemType ItemType { get; }
+        object System.Web.UI.IDataItemContainer.DataItem { get; }
+        int System.Web.UI.IDataItemContainer.DataItemIndex { get; }
+        int System.Web.UI.IDataItemContainer.DisplayIndex { get; }
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected internal virtual void SetItemType(ListItemType itemType);
+    }
+    public class DataGridItemCollection : ICollection, IEnumerable {
+        public DataGridItemCollection(ArrayList items);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        public DataGridItem this[int index] { get; }
+        public void CopyTo(Array array, int index);
+        public IEnumerator GetEnumerator();
+    }
+    public class DataGridItemEventArgs : EventArgs {
+        public DataGridItemEventArgs(DataGridItem item);
+        public DataGridItem Item { get; }
+    }
+    public delegate void DataGridItemEventHandler(object sender, DataGridItemEventArgs e);
+    public class DataGridPageChangedEventArgs : EventArgs {
+        public DataGridPageChangedEventArgs(object commandSource, int newPageIndex);
+        public object CommandSource { get; }
+        public int NewPageIndex { get; }
+    }
+    public delegate void DataGridPageChangedEventHandler(object source, DataGridPageChangedEventArgs e);
+    public sealed class DataGridPagerStyle : TableItemStyle {
+        public PagerMode Mode { get; set; }
+        public string NextPageText { get; set; }
+        public int PageButtonCount { get; set; }
+        public PagerPosition Position { get; set; }
+        public string PrevPageText { get; set; }
+        public bool Visible { get; set; }
+        public override void CopyFrom(Style s);
+        public override void MergeWith(Style s);
+        public override void Reset();
+    }
+    public class DataGridSortCommandEventArgs : EventArgs {
+        public DataGridSortCommandEventArgs(object commandSource, DataGridCommandEventArgs dce);
+        public object CommandSource { get; }
+        public string SortExpression { get; }
+    }
+    public delegate void DataGridSortCommandEventHandler(object source, DataGridSortCommandEventArgs e);
+    public class DataKey : IEquatable<DataKey>, IStateManager {
+        public DataKey(IOrderedDictionary keyTable);
+        public DataKey(IOrderedDictionary keyTable, string[] keyNames);
+        protected virtual bool IsTrackingViewState { get; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public virtual object this[int index] { get; }
+        public virtual object this[string name] { get; }
+        public virtual object Value { get; }
+        public virtual IOrderedDictionary Values { get; }
+        public bool Equals(DataKey other);
+        protected virtual void LoadViewState(object state);
+        protected virtual object SaveViewState();
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        protected virtual void TrackViewState();
+    }
+    public sealed class DataKeyArray : ICollection, IEnumerable, IStateManager {
+        public DataKeyArray(ArrayList keys);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public DataKey this[int index] { get; }
+        public void CopyTo(DataKey[] array, int index);
+        public IEnumerator GetEnumerator();
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+    }
+    public sealed class DataKeyCollection : ICollection, IEnumerable {
+        public DataKeyCollection(ArrayList keys);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        public object this[int index] { get; }
+        public void CopyTo(Array array, int index);
+        public IEnumerator GetEnumerator();
+    }
+    public class DataList : BaseDataList, INamingContainer, IRepeatInfoUser, IWizardSideBarListControl {
+        public const string CancelCommandName = "Cancel";
+        public const string DeleteCommandName = "Delete";
+        public const string EditCommandName = "Edit";
+        public const string SelectCommandName = "Select";
+        public const string UpdateCommandName = "Update";
+        public DataList();
+        public virtual TableItemStyle AlternatingItemStyle { get; }
+        public virtual ITemplate AlternatingItemTemplate { get; set; }
+        public virtual int EditItemIndex { get; set; }
+        public virtual TableItemStyle EditItemStyle { get; }
+        public virtual ITemplate EditItemTemplate { get; set; }
+        public virtual bool ExtractTemplateRows { get; set; }
+        public virtual TableItemStyle FooterStyle { get; }
+        public virtual ITemplate FooterTemplate { get; set; }
+        public override GridLines GridLines { get; set; }
+        public virtual TableItemStyle HeaderStyle { get; }
+        public virtual ITemplate HeaderTemplate { get; set; }
+        public virtual DataListItemCollection Items { get; }
+        public virtual TableItemStyle ItemStyle { get; }
+        public virtual ITemplate ItemTemplate { get; set; }
+        public virtual int RepeatColumns { get; set; }
+        public virtual RepeatDirection RepeatDirection { get; set; }
+        public virtual RepeatLayout RepeatLayout { get; set; }
+        public virtual int SelectedIndex { get; set; }
+        public virtual DataListItem SelectedItem { get; }
+        public virtual TableItemStyle SelectedItemStyle { get; }
+        public virtual ITemplate SelectedItemTemplate { get; set; }
+        public object SelectedValue { get; }
+        public virtual TableItemStyle SeparatorStyle { get; }
+        public virtual ITemplate SeparatorTemplate { get; set; }
+        public virtual bool ShowFooter { get; set; }
+        public virtual bool ShowHeader { get; set; }
+        bool System.Web.UI.WebControls.IRepeatInfoUser.HasFooter { get; }
+        bool System.Web.UI.WebControls.IRepeatInfoUser.HasHeader { get; }
+        bool System.Web.UI.WebControls.IRepeatInfoUser.HasSeparators { get; }
+        int System.Web.UI.WebControls.IRepeatInfoUser.RepeatedItemCount { get; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public event DataListCommandEventHandler CancelCommand;
+        public event DataListCommandEventHandler DeleteCommand;
+        public event DataListCommandEventHandler EditCommand;
+        public event DataListCommandEventHandler ItemCommand;
+        public event DataListItemEventHandler ItemCreated;
+        public event DataListItemEventHandler ItemDataBound;
+        public event DataListCommandEventHandler UpdateCommand;
+        protected override void CreateControlHierarchy(bool useDataSource);
+        protected override Style CreateControlStyle();
+        protected virtual DataListItem CreateItem(int itemIndex, ListItemType itemType);
+        protected virtual void InitializeItem(DataListItem item);
+        protected override void LoadViewState(object savedState);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected virtual void OnCancelCommand(DataListCommandEventArgs e);
+        protected virtual void OnDeleteCommand(DataListCommandEventArgs e);
+        protected virtual void OnEditCommand(DataListCommandEventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected virtual void OnItemCommand(DataListCommandEventArgs e);
+        protected virtual void OnItemCreated(DataListItemEventArgs e);
+        protected virtual void OnItemDataBound(DataListItemEventArgs e);
+        protected virtual void OnUpdateCommand(DataListCommandEventArgs e);
+        protected internal override void PrepareControlHierarchy();
+        protected internal override void RenderContents(HtmlTextWriter writer);
+        protected override object SaveViewState();
+        Style System.Web.UI.WebControls.IRepeatInfoUser.GetItemStyle(ListItemType itemType, int repeatIndex);
+        void System.Web.UI.WebControls.IRepeatInfoUser.RenderItem(ListItemType itemType, int repeatIndex, RepeatInfo repeatInfo, HtmlTextWriter writer);
+        protected override void TrackViewState();
+    }
+    public class DataListCommandEventArgs : CommandEventArgs {
+        public DataListCommandEventArgs(DataListItem item, object commandSource, CommandEventArgs originalArgs);
+        public object CommandSource { get; }
+        public DataListItem Item { get; }
+    }
+    public delegate void DataListCommandEventHandler(object source, DataListCommandEventArgs e);
+    public class DataListItem : WebControl, IDataItemContainer, INamingContainer {
+        public DataListItem(int itemIndex, ListItemType itemType);
+        public virtual object DataItem { get; set; }
+        public virtual int ItemIndex { get; }
+        public virtual ListItemType ItemType { get; }
+        public override bool SupportsDisabledAttribute { get; }
+        object System.Web.UI.IDataItemContainer.DataItem { get; }
+        int System.Web.UI.IDataItemContainer.DataItemIndex { get; }
+        int System.Web.UI.IDataItemContainer.DisplayIndex { get; }
+        protected override Style CreateControlStyle();
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        public virtual void RenderItem(HtmlTextWriter writer, bool extractRows, bool tableLayout);
+        protected internal virtual void SetItemType(ListItemType itemType);
+    }
+    public sealed class DataListItemCollection : ICollection, IEnumerable {
+        public DataListItemCollection(ArrayList items);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        public DataListItem this[int index] { get; }
+        public void CopyTo(Array array, int index);
+        public IEnumerator GetEnumerator();
+    }
+    public class DataListItemEventArgs : EventArgs {
+        public DataListItemEventArgs(DataListItem item);
+        public DataListItem Item { get; }
+    }
+    public delegate void DataListItemEventHandler(object sender, DataListItemEventArgs e);
+    public class DataPager : Control, IAttributeAccessor, ICompositeControlDesignerAccessor, INamingContainer {
+        public DataPager();
+        public AttributeCollection Attributes { get; }
+        public override ControlCollection Controls { get; }
+        public virtual DataPagerFieldCollection Fields { get; }
+        public int MaximumRows { get; }
+        public virtual string PagedControlID { get; set; }
+        public int PageSize { get; set; }
+        public string QueryStringField { get; set; }
+        public int StartRowIndex { get; }
+        protected virtual HtmlTextWriterTag TagKey { get; }
+        public int TotalRowCount { get; }
+        protected virtual void AddAttributesToRender(HtmlTextWriter writer);
+        protected virtual void ConnectToEvents(IPageableItemContainer container);
+        protected virtual void CreatePagerFields();
+        public override void DataBind();
+        protected virtual IPageableItemContainer FindPageableItemContainer();
+        protected internal override void LoadControlState(object savedState);
+        protected override void LoadViewState(object savedState);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void OnLoad(EventArgs e);
+        protected virtual void OnTotalRowCountAvailable(object sender, PageEventArgs e);
+        protected virtual void RecreateChildControls();
+        protected internal override void Render(HtmlTextWriter writer);
+        public virtual void RenderBeginTag(HtmlTextWriter writer);
+        protected virtual void RenderContents(HtmlTextWriter writer);
+        protected internal override object SaveControlState();
+        protected override object SaveViewState();
+        public virtual void SetPageProperties(int startRowIndex, int maximumRows, bool databind);
+        string System.Web.UI.IAttributeAccessor.GetAttribute(string name);
+        void System.Web.UI.IAttributeAccessor.SetAttribute(string name, string value);
+        void System.Web.UI.WebControls.ICompositeControlDesignerAccessor.RecreateChildControls();
+        protected override void TrackViewState();
+    }
+    public class DataPagerCommandEventArgs : CommandEventArgs {
+        public DataPagerCommandEventArgs(DataPagerField pagerField, int totalRowCount, CommandEventArgs originalArgs, DataPagerFieldItem item);
+        public DataPagerFieldItem Item { get; }
+        public int NewMaximumRows { get; set; }
+        public int NewStartRowIndex { get; set; }
+        public DataPagerField PagerField { get; }
+        public int TotalRowCount { get; }
+    }
+    public abstract class DataPagerField : IStateManager {
+        protected DataPagerField();
+        protected DataPager DataPager { get; }
+        protected bool IsTrackingViewState { get; }
+        protected bool QueryStringHandled { get; set; }
+        protected string QueryStringValue { get; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        protected StateBag ViewState { get; }
+        public bool Visible { get; set; }
+        protected internal DataPagerField CloneField();
+        protected virtual void CopyProperties(DataPagerField newField);
+        public abstract void CreateDataPagers(DataPagerFieldItem container, int startRowIndex, int maximumRows, int totalRowCount, int fieldIndex);
+        protected abstract DataPagerField CreateField();
+        protected string GetQueryStringNavigateUrl(int pageNumber);
+        public abstract void HandleEvent(CommandEventArgs e);
+        protected virtual void LoadViewState(object savedState);
+        protected virtual void OnFieldChanged();
+        protected virtual object SaveViewState();
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        protected virtual void TrackViewState();
+    }
+    public class DataPagerFieldCollection : StateManagedCollection {
+        public DataPagerFieldCollection(DataPager dataPager);
+        public DataPagerField this[int index] { get; }
+        public event EventHandler FieldsChanged;
+        public void Add(DataPagerField field);
+        public DataPagerFieldCollection CloneFields(DataPager pager);
+        public bool Contains(DataPagerField field);
+        public void CopyTo(DataPagerField[] array, int index);
+        protected override object CreateKnownType(int index);
+        protected override Type[] GetKnownTypes();
+        public int IndexOf(DataPagerField field);
+        public void Insert(int index, DataPagerField field);
+        protected override void OnClearComplete();
+        protected override void OnInsertComplete(int index, object value);
+        protected override void OnRemoveComplete(int index, object value);
+        protected override void OnValidate(object o);
+        public void Remove(DataPagerField field);
+        public void RemoveAt(int index);
+        protected override void SetDirtyObject(object o);
+    }
+    public class DataPagerFieldCommandEventArgs : CommandEventArgs {
+        public DataPagerFieldCommandEventArgs(DataPagerFieldItem item, object commandSource, CommandEventArgs originalArgs);
+        public object CommandSource { get; }
+        public DataPagerFieldItem Item { get; }
+    }
+    public class DataPagerFieldItem : Control, INamingContainer, INonBindingContainer {
+        public DataPagerFieldItem(DataPagerField field, DataPager pager);
+        public DataPager Pager { get; }
+        public DataPagerField PagerField { get; }
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+    }
+    public class DataSourceSelectResultProcessingOptions {
+        public DataSourceSelectResultProcessingOptions();
+        public bool AutoPage { get; set; }
+        public bool AutoSort { get; set; }
+        public Type ModelType { get; set; }
+    }
+    public enum DayNameFormat {
+        FirstLetter = 2,
+        FirstTwoLetters = 3,
+        Full = 0,
+        Short = 1,
+        Shortest = 4,
+    }
+    public sealed class DayRenderEventArgs {
+        public DayRenderEventArgs(TableCell cell, CalendarDay day);
+        public DayRenderEventArgs(TableCell cell, CalendarDay day, string selectUrl);
+        public TableCell Cell { get; }
+        public CalendarDay Day { get; }
+        public string SelectUrl { get; }
+    }
+    public delegate void DayRenderEventHandler(object sender, DayRenderEventArgs e);
+    public class DetailsView : CompositeDataBoundControl, ICallbackContainer, ICallbackEventHandler, IDataBoundControl, IDataBoundItemControl, IDataItemContainer, IFieldControl, INamingContainer, IPostBackContainer, IPostBackEventHandler {
+        public DetailsView();
+        public virtual bool AllowPaging { get; set; }
+        public TableItemStyle AlternatingRowStyle { get; }
+        public virtual bool AutoGenerateDeleteButton { get; set; }
+        public virtual bool AutoGenerateEditButton { get; set; }
+        public virtual bool AutoGenerateInsertButton { get; set; }
+        public virtual bool AutoGenerateRows { get; set; }
+        public virtual string BackImageUrl { get; set; }
+        public virtual DetailsViewRow BottomPagerRow { get; }
+        public virtual string Caption { get; set; }
+        public virtual TableCaptionAlign CaptionAlign { get; set; }
+        public virtual int CellPadding { get; set; }
+        public virtual int CellSpacing { get; set; }
+        public TableItemStyle CommandRowStyle { get; }
+        public DetailsViewMode CurrentMode { get; }
+        public virtual object DataItem { get; }
+        public int DataItemCount { get; }
+        public virtual int DataItemIndex { get; }
+        public virtual DataKey DataKey { get; }
+        public virtual string[] DataKeyNames { get; set; }
+        public virtual DetailsViewMode DefaultMode { get; set; }
+        public virtual new string DeleteMethod { get; set; }
+        public TableItemStyle EditRowStyle { get; }
+        public TableItemStyle EmptyDataRowStyle { get; }
+        public virtual ITemplate EmptyDataTemplate { get; set; }
+        public virtual string EmptyDataText { get; set; }
+        public virtual bool EnableModelValidation { get; set; }
+        public virtual bool EnablePagingCallbacks { get; set; }
+        public TableItemStyle FieldHeaderStyle { get; }
+        public virtual DataControlFieldCollection Fields { get; }
+        public virtual DetailsViewRow FooterRow { get; }
+        public TableItemStyle FooterStyle { get; }
+        public virtual ITemplate FooterTemplate { get; set; }
+        public virtual string FooterText { get; set; }
+        public virtual GridLines GridLines { get; set; }
+        public virtual DetailsViewRow HeaderRow { get; }
+        public TableItemStyle HeaderStyle { get; }
+        public virtual ITemplate HeaderTemplate { get; set; }
+        public virtual string HeaderText { get; set; }
+        public virtual HorizontalAlign HorizontalAlign { get; set; }
+        public virtual new string InsertMethod { get; set; }
+        public TableItemStyle InsertRowStyle { get; }
+        public virtual int PageCount { get; }
+        public virtual int PageIndex { get; set; }
+        public virtual PagerSettings PagerSettings { get; }
+        public TableItemStyle PagerStyle { get; }
+        public virtual ITemplate PagerTemplate { get; set; }
+        public virtual DetailsViewRowCollection Rows { get; }
+        public IAutoFieldGenerator RowsGenerator { get; set; }
+        public TableItemStyle RowStyle { get; }
+        public object SelectedValue { get; }
+        int System.Web.UI.IDataItemContainer.DataItemIndex { get; }
+        int System.Web.UI.IDataItemContainer.DisplayIndex { get; }
+        string[] System.Web.UI.WebControls.IDataBoundControl.DataKeyNames { get; set; }
+        string System.Web.UI.WebControls.IDataBoundControl.DataMember { get; set; }
+        object System.Web.UI.WebControls.IDataBoundControl.DataSource { get; set; }
+        string System.Web.UI.WebControls.IDataBoundControl.DataSourceID { get; set; }
+        IDataSource System.Web.UI.WebControls.IDataBoundControl.DataSourceObject { get; }
+        DataKey System.Web.UI.WebControls.IDataBoundItemControl.DataKey { get; }
+        DataBoundControlMode System.Web.UI.WebControls.IDataBoundItemControl.Mode { get; }
+        IAutoFieldGenerator System.Web.UI.WebControls.IFieldControl.FieldsGenerator { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public virtual DetailsViewRow TopPagerRow { get; }
+        public virtual new string UpdateMethod { get; set; }
+        public event DetailsViewCommandEventHandler ItemCommand;
+        public event EventHandler ItemCreated;
+        public event DetailsViewDeletedEventHandler ItemDeleted;
+        public event DetailsViewDeleteEventHandler ItemDeleting;
+        public event DetailsViewInsertedEventHandler ItemInserted;
+        public event DetailsViewInsertEventHandler ItemInserting;
+        public event DetailsViewUpdatedEventHandler ItemUpdated;
+        public event DetailsViewUpdateEventHandler ItemUpdating;
+        public event EventHandler ModeChanged;
+        public event DetailsViewModeEventHandler ModeChanging;
+        public event EventHandler PageIndexChanged;
+        public event DetailsViewPageEventHandler PageIndexChanging;
+        public void ChangeMode(DetailsViewMode newMode);
+        protected virtual AutoGeneratedField CreateAutoGeneratedRow(AutoGeneratedFieldProperties fieldProperties);
+        protected virtual ICollection CreateAutoGeneratedRows(object dataItem);
+        protected override int CreateChildControls(IEnumerable dataSource, bool dataBinding);
+        protected override Style CreateControlStyle();
+        protected override DataSourceSelectArguments CreateDataSourceSelectArguments();
+        protected virtual ICollection CreateFieldSet(object dataItem, bool useDataSource);
+        protected virtual DetailsViewRow CreateRow(int rowIndex, DataControlRowType rowType, DataControlRowState rowState);
+        protected virtual Table CreateTable();
+        public sealed override void DataBind();
+        public virtual void DeleteItem();
+        protected override void EnsureDataBound();
+        protected virtual void ExtractRowValues(IOrderedDictionary fieldValues, bool includeReadOnlyFields, bool includeKeys);
+        protected virtual string GetCallbackResult();
+        protected virtual string GetCallbackScript(IButtonControl buttonControl, string argument);
+        protected virtual void InitializePager(DetailsViewRow row, PagedDataSource pagedDataSource);
+        protected virtual void InitializeRow(DetailsViewRow row, DataControlField field);
+        public virtual void InsertItem(bool causesValidation);
+        public virtual bool IsBindableType(Type type);
+        protected internal override void LoadControlState(object savedState);
+        protected override void LoadViewState(object savedState);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected override void OnDataSourceViewChanged(object sender, EventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected virtual void OnItemCommand(DetailsViewCommandEventArgs e);
+        protected virtual void OnItemCreated(EventArgs e);
+        protected virtual void OnItemDeleted(DetailsViewDeletedEventArgs e);
+        protected virtual void OnItemDeleting(DetailsViewDeleteEventArgs e);
+        protected virtual void OnItemInserted(DetailsViewInsertedEventArgs e);
+        protected virtual void OnItemInserting(DetailsViewInsertEventArgs e);
+        protected virtual void OnItemUpdated(DetailsViewUpdatedEventArgs e);
+        protected virtual void OnItemUpdating(DetailsViewUpdateEventArgs e);
+        protected virtual void OnModeChanged(EventArgs e);
+        protected virtual void OnModeChanging(DetailsViewModeEventArgs e);
+        protected virtual void OnPageIndexChanged(EventArgs e);
+        protected virtual void OnPageIndexChanging(DetailsViewPageEventArgs e);
+        protected override void OnPagePreLoad(object sender, EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected internal override void PerformDataBinding(IEnumerable data);
+        protected internal virtual void PrepareControlHierarchy();
+        protected virtual void RaiseCallbackEvent(string eventArgument);
+        protected virtual void RaisePostBackEvent(string eventArgument);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected internal override object SaveControlState();
+        protected override object SaveViewState();
+        public void SetPageIndex(int index);
+        string System.Web.UI.ICallbackEventHandler.GetCallbackResult();
+        void System.Web.UI.ICallbackEventHandler.RaiseCallbackEvent(string eventArgument);
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+        string System.Web.UI.WebControls.ICallbackContainer.GetCallbackScript(IButtonControl buttonControl, string argument);
+        PostBackOptions System.Web.UI.WebControls.IPostBackContainer.GetPostBackOptions(IButtonControl buttonControl);
+        protected override void TrackViewState();
+        public virtual void UpdateItem(bool causesValidation);
+    }
+    public class DetailsViewCommandEventArgs : CommandEventArgs {
+        public DetailsViewCommandEventArgs(object commandSource, CommandEventArgs originalArgs);
+        public object CommandSource { get; }
+        public bool Handled { get; set; }
+    }
+    public delegate void DetailsViewCommandEventHandler(object sender, DetailsViewCommandEventArgs e);
+    public class DetailsViewDeletedEventArgs : EventArgs {
+        public DetailsViewDeletedEventArgs(int affectedRows, Exception e);
+        public int AffectedRows { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary Values { get; }
+    }
+    public delegate void DetailsViewDeletedEventHandler(object sender, DetailsViewDeletedEventArgs e);
+    public class DetailsViewDeleteEventArgs : CancelEventArgs {
+        public DetailsViewDeleteEventArgs(int rowIndex);
+        public IOrderedDictionary Keys { get; }
+        public int RowIndex { get; }
+        public IOrderedDictionary Values { get; }
+    }
+    public delegate void DetailsViewDeleteEventHandler(object sender, DetailsViewDeleteEventArgs e);
+    public class DetailsViewInsertedEventArgs : EventArgs {
+        public DetailsViewInsertedEventArgs(int affectedRows, Exception e);
+        public int AffectedRows { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public bool KeepInInsertMode { get; set; }
+        public IOrderedDictionary Values { get; }
+    }
+    public delegate void DetailsViewInsertedEventHandler(object sender, DetailsViewInsertedEventArgs e);
+    public class DetailsViewInsertEventArgs : CancelEventArgs {
+        public DetailsViewInsertEventArgs(object commandArgument);
+        public object CommandArgument { get; }
+        public IOrderedDictionary Values { get; }
+    }
+    public delegate void DetailsViewInsertEventHandler(object sender, DetailsViewInsertEventArgs e);
+    public enum DetailsViewMode {
+        Edit = 1,
+        Insert = 2,
+        ReadOnly = 0,
+    }
+    public class DetailsViewModeEventArgs : CancelEventArgs {
+        public DetailsViewModeEventArgs(DetailsViewMode mode, bool cancelingEdit);
+        public bool CancelingEdit { get; }
+        public DetailsViewMode NewMode { get; set; }
+    }
+    public delegate void DetailsViewModeEventHandler(object sender, DetailsViewModeEventArgs e);
+    public class DetailsViewPageEventArgs : CancelEventArgs {
+        public DetailsViewPageEventArgs(int newPageIndex);
+        public int NewPageIndex { get; set; }
+    }
+    public delegate void DetailsViewPageEventHandler(object sender, DetailsViewPageEventArgs e);
+    public class DetailsViewPagerRow : DetailsViewRow, INamingContainer, INonBindingContainer {
+        public DetailsViewPagerRow(int rowIndex, DataControlRowType rowType, DataControlRowState rowState);
+    }
+    public class DetailsViewRow : TableRow {
+        public DetailsViewRow(int rowIndex, DataControlRowType rowType, DataControlRowState rowState);
+        public virtual int RowIndex { get; }
+        public virtual DataControlRowState RowState { get; }
+        public virtual DataControlRowType RowType { get; }
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+    }
+    public class DetailsViewRowCollection : ICollection, IEnumerable {
+        public DetailsViewRowCollection(ArrayList rows);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        public DetailsViewRow this[int index] { get; }
+        public void CopyTo(DetailsViewRow[] array, int index);
+        public IEnumerator GetEnumerator();
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+    }
+    public class DetailsViewRowsGenerator : AutoFieldsGenerator {
+        public DetailsViewRowsGenerator();
+        public override List<AutoGeneratedField> CreateAutoGeneratedFields(object dataItem, Control control);
+    }
+    public class DetailsViewUpdatedEventArgs : EventArgs {
+        public DetailsViewUpdatedEventArgs(int affectedRows, Exception e);
+        public int AffectedRows { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public bool KeepInEditMode { get; set; }
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary NewValues { get; }
+        public IOrderedDictionary OldValues { get; }
+    }
+    public delegate void DetailsViewUpdatedEventHandler(object sender, DetailsViewUpdatedEventArgs e);
+    public class DetailsViewUpdateEventArgs : CancelEventArgs {
+        public DetailsViewUpdateEventArgs(object commandArgument);
+        public object CommandArgument { get; }
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary NewValues { get; }
+        public IOrderedDictionary OldValues { get; }
+    }
+    public delegate void DetailsViewUpdateEventHandler(object sender, DetailsViewUpdateEventArgs e);
+    public class DropDownList : ListControl, IPostBackDataHandler {
+        public DropDownList();
+        public override Color BorderColor { get; set; }
+        public override BorderStyle BorderStyle { get; set; }
+        public override Unit BorderWidth { get; set; }
+        public override int SelectedIndex { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override ControlCollection CreateControlCollection();
+        protected virtual bool LoadPostData(string postDataKey, NameValueCollection postCollection);
+        protected virtual void RaisePostDataChangedEvent();
+        bool System.Web.UI.IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection);
+        void System.Web.UI.IPostBackDataHandler.RaisePostDataChangedEvent();
+        protected internal override void VerifyMultiSelect();
+    }
+    public class EditCommandColumn : DataGridColumn {
+        public EditCommandColumn();
+        public virtual ButtonColumnType ButtonType { get; set; }
+        public virtual string CancelText { get; set; }
+        public virtual bool CausesValidation { get; set; }
+        public virtual string EditText { get; set; }
+        public virtual string UpdateText { get; set; }
+        public virtual string ValidationGroup { get; set; }
+        public override void InitializeCell(TableCell cell, int columnIndex, ListItemType itemType);
+    }
+    public sealed class EmbeddedMailObject {
+        public EmbeddedMailObject();
+        public EmbeddedMailObject(string name, string path);
+        public string Name { get; set; }
+        public string Path { get; set; }
+    }
+    public sealed class EmbeddedMailObjectsCollection : CollectionBase {
+        public EmbeddedMailObjectsCollection();
+        public EmbeddedMailObject this[int index] { get; set; }
+        public int Add(EmbeddedMailObject value);
+        public bool Contains(EmbeddedMailObject value);
+        public void CopyTo(EmbeddedMailObject[] array, int index);
+        public int IndexOf(EmbeddedMailObject value);
+        public void Insert(int index, EmbeddedMailObject value);
+        protected override void OnValidate(object value);
+        public void Remove(EmbeddedMailObject value);
+    }
+    public class EntityDataSource : DataSourceControl, IDataSource, IDynamicDataSource, IQueryableDataSource {
+        public EntityDataSource();
+        public EntityDataSource(EntityConnection connection);
+        public bool AutoGenerateOrderByClause { get; set; }
+        public bool AutoGenerateWhereClause { get; set; }
+        public bool AutoPage { get; set; }
+        public bool AutoSort { get; set; }
+        public ParameterCollection CommandParameters { get; }
+        public string CommandText { get; set; }
+        public string ConnectionString { get; set; }
+        public Type ContextType { get; set; }
+        public string ContextTypeName { get; set; }
+        public string DefaultContainerName { get; set; }
+        public ParameterCollection DeleteParameters { get; }
+        public bool EnableDelete { get; set; }
+        public bool EnableFlattening { get; set; }
+        public bool EnableInsert { get; set; }
+        public bool EnableUpdate { get; set; }
+        public string EntitySetName { get; set; }
+        public string EntityTypeFilter { get; set; }
+        public string GroupBy { get; set; }
+        public string Include { get; set; }
+        public ParameterCollection InsertParameters { get; }
+        public string OrderBy { get; set; }
+        public ParameterCollection OrderByParameters { get; }
+        public string Select { get; set; }
+        public ParameterCollection SelectParameters { get; }
+        public bool StoreOriginalValuesInViewState { get; set; }
+        public ParameterCollection UpdateParameters { get; }
+        public string Where { get; set; }
+        public ParameterCollection WhereParameters { get; }
+        public event EventHandler<EntityDataSourceContextCreatedEventArgs> ContextCreated;
+        public event EventHandler<EntityDataSourceContextCreatingEventArgs> ContextCreating;
+        public event EventHandler<EntityDataSourceContextDisposingEventArgs> ContextDisposing;
+        public event EventHandler<EntityDataSourceChangedEventArgs> Deleted;
+        public event EventHandler<EntityDataSourceChangingEventArgs> Deleting;
+        public event EventHandler<EntityDataSourceChangedEventArgs> Inserted;
+        public event EventHandler<EntityDataSourceChangingEventArgs> Inserting;
+        public event EventHandler<QueryCreatedEventArgs> QueryCreated;
+        public event EventHandler<EntityDataSourceSelectedEventArgs> Selected;
+        public event EventHandler<EntityDataSourceSelectingEventArgs> Selecting;
+        event EventHandler<DynamicValidatorEventArgs> System.Web.DynamicData.IDynamicDataSource.Exception;
+        public event EventHandler<EntityDataSourceChangedEventArgs> Updated;
+        public event EventHandler<EntityDataSourceChangingEventArgs> Updating;
+        protected virtual EntityDataSourceView CreateView();
+        protected override DataSourceView GetView(string viewName);
+        protected override ICollection GetViewNames();
+        protected override void LoadControlState(object savedState);
+        protected override void OnInit(EventArgs e);
+        protected override void OnUnload(EventArgs e);
+        protected override object SaveControlState();
+        void System.Web.UI.WebControls.IQueryableDataSource.RaiseViewChanged();
+        protected override void TrackViewState();
+    }
+    public class EntityDataSourceChangedEventArgs : EventArgs {
+        public ObjectContext Context { get; }
+        public object Entity { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+    }
+    public class EntityDataSourceChangingEventArgs : CancelEventArgs {
+        public ObjectContext Context { get; }
+        public object Entity { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+    }
+    public class EntityDataSourceContextCreatedEventArgs : EventArgs {
+        public ObjectContext Context { get; }
+    }
+    public class EntityDataSourceContextCreatingEventArgs : EventArgs {
+        public ObjectContext Context { get; set; }
+    }
+    public class EntityDataSourceContextDisposingEventArgs : CancelEventArgs {
+        public ObjectContext Context { get; }
+    }
+    public class EntityDataSourceSelectedEventArgs : EventArgs {
+        public ObjectContext Context { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public IEnumerable Results { get; }
+        public DataSourceSelectArguments SelectArguments { get; }
+        public int TotalRowCount { get; }
+    }
+    public class EntityDataSourceSelectingEventArgs : CancelEventArgs {
+        public EntityDataSource DataSource { get; }
+        public DataSourceSelectArguments SelectArguments { get; }
+    }
+    public sealed class EntityDataSourceValidationException : Exception, IDynamicValidatorException {
+        public EntityDataSourceValidationException();
+        public EntityDataSourceValidationException(string message);
+        public EntityDataSourceValidationException(string message, Exception innerException);
+        IDictionary<string, Exception> System.Web.DynamicData.IDynamicValidatorException.InnerExceptions { get; }
+    }
+    public class EntityDataSourceView : DataSourceView, IStateManager {
+        public EntityDataSourceView(EntityDataSource owner, string viewName);
+        public override bool CanDelete { get; }
+        public override bool CanInsert { get; }
+        public override bool CanPage { get; }
+        public override bool CanRetrieveTotalRowCount { get; }
+        public override bool CanSort { get; }
+        public override bool CanUpdate { get; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public event EventHandler<EntityDataSourceContextCreatedEventArgs> ContextCreated;
+        public event EventHandler<EntityDataSourceContextCreatingEventArgs> ContextCreating;
+        public event EventHandler<EntityDataSourceContextDisposingEventArgs> ContextDisposing;
+        public event EventHandler<EntityDataSourceChangedEventArgs> Deleted;
+        public event EventHandler<EntityDataSourceChangingEventArgs> Deleting;
+        public event EventHandler<DynamicValidatorEventArgs> Exception;
+        public event EventHandler<EntityDataSourceChangedEventArgs> Inserted;
+        public event EventHandler<EntityDataSourceChangingEventArgs> Inserting;
+        public event EventHandler<QueryCreatedEventArgs> QueryCreated;
+        public event EventHandler<EntityDataSourceSelectedEventArgs> Selected;
+        public event EventHandler<EntityDataSourceSelectingEventArgs> Selecting;
+        public event EventHandler<EntityDataSourceChangedEventArgs> Updated;
+        public event EventHandler<EntityDataSourceChangingEventArgs> Updating;
+        protected override int ExecuteDelete(IDictionary keys, IDictionary oldValues);
+        protected override int ExecuteInsert(IDictionary values);
+        protected override IEnumerable ExecuteSelect(DataSourceSelectArguments arguments);
+        protected override int ExecuteUpdate(IDictionary keys, IDictionary values, IDictionary oldValues);
+        public DataTable GetViewSchema();
+        void System.Web.UI.IStateManager.LoadViewState(object savedState);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+    }
+    public class FileUpload : WebControl {
+        public FileUpload();
+        public virtual bool AllowMultiple { get; set; }
+        public byte[] FileBytes { get; }
+        public Stream FileContent { get; }
+        public string FileName { get; }
+        public bool HasFile { get; }
+        public bool HasFiles { get; }
+        public HttpPostedFile PostedFile { get; }
+        public IList<HttpPostedFile> PostedFiles { get; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected internal override void OnPreRender(EventArgs e);
+        protected internal override void Render(HtmlTextWriter writer);
+        public void SaveAs(string filename);
+    }
+    public enum FirstDayOfWeek {
+        Default = 7,
+        Friday = 5,
+        Monday = 1,
+        Saturday = 6,
+        Sunday = 0,
+        Thursday = 4,
+        Tuesday = 2,
+        Wednesday = 3,
+    }
+    public sealed class FontInfo {
+        public bool Bold { get; set; }
+        public bool Italic { get; set; }
+        public string Name { get; set; }
+        public string[] Names { get; set; }
+        public bool Overline { get; set; }
+        public FontUnit Size { get; set; }
+        public bool Strikeout { get; set; }
+        public bool Underline { get; set; }
+        public void ClearDefaults();
+        public void CopyFrom(FontInfo f);
+        public void MergeWith(FontInfo f);
+        public bool ShouldSerializeNames();
+        public override string ToString();
+    }
+    public class FontNamesConverter : TypeConverter {
+        public FontNamesConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public enum FontSize {
+        AsUnit = 1,
+        Large = 8,
+        Larger = 3,
+        Medium = 7,
+        NotSet = 0,
+        Small = 6,
+        Smaller = 2,
+        XLarge = 9,
+        XSmall = 5,
+        XXLarge = 10,
+        XXSmall = 4,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct FontUnit {
+        public static readonly FontUnit Empty;
+        public static readonly FontUnit Large;
+        public static readonly FontUnit Larger;
+        public static readonly FontUnit Medium;
+        public static readonly FontUnit Small;
+        public static readonly FontUnit Smaller;
+        public static readonly FontUnit XLarge;
+        public static readonly FontUnit XSmall;
+        public static readonly FontUnit XXLarge;
+        public static readonly FontUnit XXSmall;
+        public FontUnit(double value);
+        public FontUnit(double value, UnitType type);
+        public FontUnit(int value);
+        public FontUnit(string value);
+        public FontUnit(string value, CultureInfo culture);
+        public FontUnit(FontSize type);
+        public FontUnit(Unit value);
+        public bool IsEmpty { get; }
+        public FontSize Type { get; }
+        public Unit Unit { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(FontUnit left, FontUnit right);
+        public static implicit operator FontUnit (int n);
+        public static bool operator !=(FontUnit left, FontUnit right);
+        public static FontUnit Parse(string s);
+        public static FontUnit Parse(string s, CultureInfo culture);
+        public static FontUnit Point(int n);
+        public override string ToString();
+        public string ToString(CultureInfo culture);
+        public string ToString(IFormatProvider formatProvider);
+    }
+    public class FontUnitConverter : TypeConverter {
+        public FontUnitConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+    }
+    public class FormParameter : Parameter {
+        public FormParameter();
+        public FormParameter(string name, DbType dbType, string formField);
+        public FormParameter(string name, string formField);
+        public FormParameter(string name, TypeCode type, string formField);
+        protected FormParameter(FormParameter original);
+        public string FormField { get; set; }
+        public bool ValidateInput { get; set; }
+        protected override Parameter Clone();
+        protected internal override object Evaluate(HttpContext context, Control control);
+    }
+    public class FormView : CompositeDataBoundControl, IDataBoundControl, IDataBoundItemControl, IDataItemContainer, INamingContainer, IPostBackContainer, IPostBackEventHandler, IRenderOuterTableControl {
+        public FormView();
+        public virtual bool AllowPaging { get; set; }
+        public virtual string BackImageUrl { get; set; }
+        public virtual FormViewRow BottomPagerRow { get; }
+        public virtual string Caption { get; set; }
+        public virtual TableCaptionAlign CaptionAlign { get; set; }
+        public virtual int CellPadding { get; set; }
+        public virtual int CellSpacing { get; set; }
+        public FormViewMode CurrentMode { get; }
+        public virtual object DataItem { get; }
+        public int DataItemCount { get; }
+        public virtual int DataItemIndex { get; }
+        public virtual DataKey DataKey { get; }
+        public virtual string[] DataKeyNames { get; set; }
+        public virtual FormViewMode DefaultMode { get; set; }
+        public virtual new string DeleteMethod { get; set; }
+        public virtual ITemplate EditItemTemplate { get; set; }
+        public TableItemStyle EditRowStyle { get; }
+        public TableItemStyle EmptyDataRowStyle { get; }
+        public virtual ITemplate EmptyDataTemplate { get; set; }
+        public virtual string EmptyDataText { get; set; }
+        public virtual bool EnableModelValidation { get; set; }
+        public virtual FormViewRow FooterRow { get; }
+        public TableItemStyle FooterStyle { get; }
+        public virtual ITemplate FooterTemplate { get; set; }
+        public virtual string FooterText { get; set; }
+        public virtual GridLines GridLines { get; set; }
+        public virtual FormViewRow HeaderRow { get; }
+        public TableItemStyle HeaderStyle { get; }
+        public virtual ITemplate HeaderTemplate { get; set; }
+        public virtual string HeaderText { get; set; }
+        public virtual HorizontalAlign HorizontalAlign { get; set; }
+        public virtual ITemplate InsertItemTemplate { get; set; }
+        public virtual new string InsertMethod { get; set; }
+        public TableItemStyle InsertRowStyle { get; }
+        public virtual ITemplate ItemTemplate { get; set; }
+        public virtual int PageCount { get; }
+        public virtual int PageIndex { get; set; }
+        public virtual PagerSettings PagerSettings { get; }
+        public TableItemStyle PagerStyle { get; }
+        public virtual ITemplate PagerTemplate { get; set; }
+        public virtual bool RenderOuterTable { get; set; }
+        public virtual FormViewRow Row { get; }
+        public TableItemStyle RowStyle { get; }
+        public object SelectedValue { get; }
+        int System.Web.UI.IDataItemContainer.DataItemIndex { get; }
+        int System.Web.UI.IDataItemContainer.DisplayIndex { get; }
+        string[] System.Web.UI.WebControls.IDataBoundControl.DataKeyNames { get; set; }
+        string System.Web.UI.WebControls.IDataBoundControl.DataMember { get; set; }
+        object System.Web.UI.WebControls.IDataBoundControl.DataSource { get; set; }
+        string System.Web.UI.WebControls.IDataBoundControl.DataSourceID { get; set; }
+        IDataSource System.Web.UI.WebControls.IDataBoundControl.DataSourceObject { get; }
+        DataKey System.Web.UI.WebControls.IDataBoundItemControl.DataKey { get; }
+        DataBoundControlMode System.Web.UI.WebControls.IDataBoundItemControl.Mode { get; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public virtual FormViewRow TopPagerRow { get; }
+        public virtual new string UpdateMethod { get; set; }
+        public event FormViewCommandEventHandler ItemCommand;
+        public event EventHandler ItemCreated;
+        public event FormViewDeletedEventHandler ItemDeleted;
+        public event FormViewDeleteEventHandler ItemDeleting;
+        public event FormViewInsertedEventHandler ItemInserted;
+        public event FormViewInsertEventHandler ItemInserting;
+        public event FormViewUpdatedEventHandler ItemUpdated;
+        public event FormViewUpdateEventHandler ItemUpdating;
+        public event EventHandler ModeChanged;
+        public event FormViewModeEventHandler ModeChanging;
+        public event EventHandler PageIndexChanged;
+        public event FormViewPageEventHandler PageIndexChanging;
+        public void ChangeMode(FormViewMode newMode);
+        protected override int CreateChildControls(IEnumerable dataSource, bool dataBinding);
+        protected override Style CreateControlStyle();
+        protected override DataSourceSelectArguments CreateDataSourceSelectArguments();
+        protected virtual FormViewRow CreateRow(int itemIndex, DataControlRowType rowType, DataControlRowState rowState);
+        protected virtual Table CreateTable();
+        public sealed override void DataBind();
+        public virtual void DeleteItem();
+        protected override void EnsureDataBound();
+        protected virtual void ExtractRowValues(IOrderedDictionary fieldValues, bool includeKeys);
+        protected virtual void InitializePager(FormViewRow row, PagedDataSource pagedDataSource);
+        protected virtual void InitializeRow(FormViewRow row);
+        public virtual void InsertItem(bool causesValidation);
+        public virtual bool IsBindableType(Type type);
+        protected internal override void LoadControlState(object savedState);
+        protected override void LoadViewState(object savedState);
+        protected internal virtual string ModifiedOuterTableStylePropertyName();
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected virtual void OnItemCommand(FormViewCommandEventArgs e);
+        protected virtual void OnItemCreated(EventArgs e);
+        protected virtual void OnItemDeleted(FormViewDeletedEventArgs e);
+        protected virtual void OnItemDeleting(FormViewDeleteEventArgs e);
+        protected virtual void OnItemInserted(FormViewInsertedEventArgs e);
+        protected virtual void OnItemInserting(FormViewInsertEventArgs e);
+        protected virtual void OnItemUpdated(FormViewUpdatedEventArgs e);
+        protected virtual void OnItemUpdating(FormViewUpdateEventArgs e);
+        protected virtual void OnModeChanged(EventArgs e);
+        protected virtual void OnModeChanging(FormViewModeEventArgs e);
+        protected virtual void OnPageIndexChanged(EventArgs e);
+        protected virtual void OnPageIndexChanging(FormViewPageEventArgs e);
+        protected internal override void PerformDataBinding(IEnumerable data);
+        protected internal virtual void PrepareControlHierarchy();
+        protected virtual void RaisePostBackEvent(string eventArgument);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected internal override object SaveControlState();
+        protected override object SaveViewState();
+        public void SetPageIndex(int index);
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+        PostBackOptions System.Web.UI.WebControls.IPostBackContainer.GetPostBackOptions(IButtonControl buttonControl);
+        protected override void TrackViewState();
+        public virtual void UpdateItem(bool causesValidation);
+    }
+    public class FormViewCommandEventArgs : CommandEventArgs {
+        public FormViewCommandEventArgs(object commandSource, CommandEventArgs originalArgs);
+        public object CommandSource { get; }
+        public bool Handled { get; set; }
+    }
+    public delegate void FormViewCommandEventHandler(object sender, FormViewCommandEventArgs e);
+    public class FormViewDeletedEventArgs : EventArgs {
+        public FormViewDeletedEventArgs(int affectedRows, Exception e);
+        public int AffectedRows { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary Values { get; }
+    }
+    public delegate void FormViewDeletedEventHandler(object sender, FormViewDeletedEventArgs e);
+    public class FormViewDeleteEventArgs : CancelEventArgs {
+        public FormViewDeleteEventArgs(int rowIndex);
+        public IOrderedDictionary Keys { get; }
+        public int RowIndex { get; }
+        public IOrderedDictionary Values { get; }
+    }
+    public delegate void FormViewDeleteEventHandler(object sender, FormViewDeleteEventArgs e);
+    public class FormViewInsertedEventArgs : EventArgs {
+        public FormViewInsertedEventArgs(int affectedRows, Exception e);
+        public int AffectedRows { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public bool KeepInInsertMode { get; set; }
+        public IOrderedDictionary Values { get; }
+    }
+    public delegate void FormViewInsertedEventHandler(object sender, FormViewInsertedEventArgs e);
+    public class FormViewInsertEventArgs : CancelEventArgs {
+        public FormViewInsertEventArgs(object commandArgument);
+        public object CommandArgument { get; }
+        public IOrderedDictionary Values { get; }
+    }
+    public delegate void FormViewInsertEventHandler(object sender, FormViewInsertEventArgs e);
+    public enum FormViewMode {
+        Edit = 1,
+        Insert = 2,
+        ReadOnly = 0,
+    }
+    public class FormViewModeEventArgs : CancelEventArgs {
+        public FormViewModeEventArgs(FormViewMode mode, bool cancelingEdit);
+        public bool CancelingEdit { get; }
+        public FormViewMode NewMode { get; set; }
+    }
+    public delegate void FormViewModeEventHandler(object sender, FormViewModeEventArgs e);
+    public class FormViewPageEventArgs : CancelEventArgs {
+        public FormViewPageEventArgs(int newPageIndex);
+        public int NewPageIndex { get; set; }
+    }
+    public delegate void FormViewPageEventHandler(object sender, FormViewPageEventArgs e);
+    public class FormViewPagerRow : FormViewRow, INamingContainer, INonBindingContainer {
+        public FormViewPagerRow(int rowIndex, DataControlRowType rowType, DataControlRowState rowState);
+    }
+    public class FormViewRow : TableRow {
+        public FormViewRow(int itemIndex, DataControlRowType rowType, DataControlRowState rowState);
+        public virtual int ItemIndex { get; }
+        public virtual DataControlRowState RowState { get; }
+        public virtual DataControlRowType RowType { get; }
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected internal override void Render(HtmlTextWriter writer);
+    }
+    public class FormViewUpdatedEventArgs : EventArgs {
+        public FormViewUpdatedEventArgs(int affectedRows, Exception e);
+        public int AffectedRows { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public bool KeepInEditMode { get; set; }
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary NewValues { get; }
+        public IOrderedDictionary OldValues { get; }
+    }
+    public delegate void FormViewUpdatedEventHandler(object sender, FormViewUpdatedEventArgs e);
+    public class FormViewUpdateEventArgs : CancelEventArgs {
+        public FormViewUpdateEventArgs(object commandArgument);
+        public object CommandArgument { get; }
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary NewValues { get; }
+        public IOrderedDictionary OldValues { get; }
+    }
+    public delegate void FormViewUpdateEventHandler(object sender, FormViewUpdateEventArgs e);
+    public enum GridLines {
+        Both = 3,
+        Horizontal = 1,
+        None = 0,
+        Vertical = 2,
+    }
+    public class GridView : CompositeDataBoundControl, ICallbackContainer, ICallbackEventHandler, IDataBoundControl, IDataBoundListControl, IDataKeysControl, IFieldControl, IPersistedSelector, IPostBackContainer, IPostBackEventHandler {
+        public GridView();
+        public virtual bool AllowCustomPaging { get; set; }
+        public virtual bool AllowPaging { get; set; }
+        public virtual bool AllowSorting { get; set; }
+        public TableItemStyle AlternatingRowStyle { get; }
+        public virtual bool AutoGenerateColumns { get; set; }
+        public virtual bool AutoGenerateDeleteButton { get; set; }
+        public virtual bool AutoGenerateEditButton { get; set; }
+        public virtual bool AutoGenerateSelectButton { get; set; }
+        public virtual string BackImageUrl { get; set; }
+        public virtual GridViewRow BottomPagerRow { get; }
+        public virtual string Caption { get; set; }
+        public virtual TableCaptionAlign CaptionAlign { get; set; }
+        public virtual int CellPadding { get; set; }
+        public virtual int CellSpacing { get; set; }
+        public virtual string[] ClientIDRowSuffix { get; set; }
+        public DataKeyArray ClientIDRowSuffixDataKeys { get; }
+        public virtual DataControlFieldCollection Columns { get; }
+        public IAutoFieldGenerator ColumnsGenerator { get; set; }
+        public virtual string[] DataKeyNames { get; set; }
+        public virtual DataKeyArray DataKeys { get; }
+        public virtual new string DeleteMethod { get; set; }
+        public virtual int EditIndex { get; set; }
+        public TableItemStyle EditRowStyle { get; }
+        public TableItemStyle EmptyDataRowStyle { get; }
+        public virtual ITemplate EmptyDataTemplate { get; set; }
+        public virtual string EmptyDataText { get; set; }
+        public virtual bool EnableModelValidation { get; set; }
+        public virtual bool EnablePersistedSelection { get; set; }
+        public virtual bool EnableSortingAndPagingCallbacks { get; set; }
+        public virtual GridViewRow FooterRow { get; }
+        public TableItemStyle FooterStyle { get; }
+        public virtual GridLines GridLines { get; set; }
+        public virtual GridViewRow HeaderRow { get; }
+        public TableItemStyle HeaderStyle { get; }
+        public virtual HorizontalAlign HorizontalAlign { get; set; }
+        public virtual int PageCount { get; }
+        public virtual int PageIndex { get; set; }
+        public virtual PagerSettings PagerSettings { get; }
+        public TableItemStyle PagerStyle { get; }
+        public virtual ITemplate PagerTemplate { get; set; }
+        public virtual int PageSize { get; set; }
+        public virtual string RowHeaderColumn { get; set; }
+        public virtual GridViewRowCollection Rows { get; }
+        public TableItemStyle RowStyle { get; }
+        public virtual DataKey SelectedDataKey { get; }
+        public virtual int SelectedIndex { get; set; }
+        public virtual DataKey SelectedPersistedDataKey { get; set; }
+        public virtual GridViewRow SelectedRow { get; }
+        public TableItemStyle SelectedRowStyle { get; }
+        public object SelectedValue { get; }
+        public virtual bool ShowFooter { get; set; }
+        public virtual bool ShowHeader { get; set; }
+        public virtual bool ShowHeaderWhenEmpty { get; set; }
+        public virtual SortDirection SortDirection { get; }
+        public TableItemStyle SortedAscendingCellStyle { get; }
+        public TableItemStyle SortedAscendingHeaderStyle { get; }
+        public TableItemStyle SortedDescendingCellStyle { get; }
+        public TableItemStyle SortedDescendingHeaderStyle { get; }
+        public virtual string SortExpression { get; }
+        DataKeyArray System.Web.UI.IDataKeysControl.ClientIDRowSuffixDataKeys { get; }
+        string[] System.Web.UI.WebControls.IDataBoundControl.DataKeyNames { get; set; }
+        string System.Web.UI.WebControls.IDataBoundControl.DataMember { get; set; }
+        object System.Web.UI.WebControls.IDataBoundControl.DataSource { get; set; }
+        string System.Web.UI.WebControls.IDataBoundControl.DataSourceID { get; set; }
+        IDataSource System.Web.UI.WebControls.IDataBoundControl.DataSourceObject { get; }
+        string[] System.Web.UI.WebControls.IDataBoundListControl.ClientIDRowSuffix { get; set; }
+        DataKeyArray System.Web.UI.WebControls.IDataBoundListControl.DataKeys { get; }
+        bool System.Web.UI.WebControls.IDataBoundListControl.EnablePersistedSelection { get; set; }
+        DataKey System.Web.UI.WebControls.IDataBoundListControl.SelectedDataKey { get; }
+        int System.Web.UI.WebControls.IDataBoundListControl.SelectedIndex { get; set; }
+        IAutoFieldGenerator System.Web.UI.WebControls.IFieldControl.FieldsGenerator { get; set; }
+        DataKey System.Web.UI.WebControls.IPersistedSelector.DataKey { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public virtual GridViewRow TopPagerRow { get; }
+        public virtual new string UpdateMethod { get; set; }
+        public virtual bool UseAccessibleHeader { get; set; }
+        public virtual int VirtualItemCount { get; set; }
+        public event EventHandler PageIndexChanged;
+        public event GridViewPageEventHandler PageIndexChanging;
+        public event GridViewCancelEditEventHandler RowCancelingEdit;
+        public event GridViewCommandEventHandler RowCommand;
+        public event GridViewRowEventHandler RowCreated;
+        public event GridViewRowEventHandler RowDataBound;
+        public event GridViewDeletedEventHandler RowDeleted;
+        public event GridViewDeleteEventHandler RowDeleting;
+        public event GridViewEditEventHandler RowEditing;
+        public event GridViewUpdatedEventHandler RowUpdated;
+        public event GridViewUpdateEventHandler RowUpdating;
+        public event EventHandler SelectedIndexChanged;
+        public event GridViewSelectEventHandler SelectedIndexChanging;
+        public event EventHandler Sorted;
+        public event GridViewSortEventHandler Sorting;
+        protected virtual AutoGeneratedField CreateAutoGeneratedColumn(AutoGeneratedFieldProperties fieldProperties);
+        protected override int CreateChildControls(IEnumerable dataSource, bool dataBinding);
+        protected virtual Table CreateChildTable();
+        protected virtual ICollection CreateColumns(PagedDataSource dataSource, bool useDataSource);
+        protected override Style CreateControlStyle();
+        protected override DataSourceSelectArguments CreateDataSourceSelectArguments();
+        protected virtual GridViewRow CreateRow(int rowIndex, int dataSourceIndex, DataControlRowType rowType, DataControlRowState rowState);
+        public sealed override void DataBind();
+        public virtual void DeleteRow(int rowIndex);
+        protected virtual void ExtractRowValues(IOrderedDictionary fieldValues, GridViewRow row, bool includeReadOnlyFields, bool includePrimaryKey);
+        protected virtual string GetCallbackResult();
+        protected virtual string GetCallbackScript(IButtonControl buttonControl, string argument);
+        protected virtual void InitializePager(GridViewRow row, int columnSpan, PagedDataSource pagedDataSource);
+        protected virtual void InitializeRow(GridViewRow row, DataControlField[] fields);
+        public virtual bool IsBindableType(Type type);
+        protected internal override void LoadControlState(object savedState);
+        protected override void LoadViewState(object savedState);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected override void OnDataPropertyChanged();
+        protected override void OnDataSourceViewChanged(object sender, EventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected virtual void OnPageIndexChanged(EventArgs e);
+        protected virtual void OnPageIndexChanging(GridViewPageEventArgs e);
+        protected override void OnPagePreLoad(object sender, EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void OnRowCancelingEdit(GridViewCancelEditEventArgs e);
+        protected virtual void OnRowCommand(GridViewCommandEventArgs e);
+        protected virtual void OnRowCreated(GridViewRowEventArgs e);
+        protected virtual void OnRowDataBound(GridViewRowEventArgs e);
+        protected virtual void OnRowDeleted(GridViewDeletedEventArgs e);
+        protected virtual void OnRowDeleting(GridViewDeleteEventArgs e);
+        protected virtual void OnRowEditing(GridViewEditEventArgs e);
+        protected virtual void OnRowUpdated(GridViewUpdatedEventArgs e);
+        protected virtual void OnRowUpdating(GridViewUpdateEventArgs e);
+        protected virtual void OnSelectedIndexChanged(EventArgs e);
+        protected virtual void OnSelectedIndexChanging(GridViewSelectEventArgs e);
+        protected virtual void OnSorted(EventArgs e);
+        protected virtual void OnSorting(GridViewSortEventArgs e);
+        protected internal override void PerformDataBinding(IEnumerable data);
+        protected internal virtual void PrepareControlHierarchy();
+        protected virtual void RaiseCallbackEvent(string eventArgument);
+        protected virtual void RaisePostBackEvent(string eventArgument);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected internal override object SaveControlState();
+        protected override object SaveViewState();
+        public void SelectRow(int rowIndex);
+        public void SetEditRow(int rowIndex);
+        public void SetPageIndex(int rowIndex);
+        public virtual void Sort(string sortExpression, SortDirection sortDirection);
+        string System.Web.UI.ICallbackEventHandler.GetCallbackResult();
+        void System.Web.UI.ICallbackEventHandler.RaiseCallbackEvent(string eventArgument);
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+        string System.Web.UI.WebControls.ICallbackContainer.GetCallbackScript(IButtonControl buttonControl, string argument);
+        PostBackOptions System.Web.UI.WebControls.IPostBackContainer.GetPostBackOptions(IButtonControl buttonControl);
+        protected override void TrackViewState();
+        public virtual void UpdateRow(int rowIndex, bool causesValidation);
+    }
+    public class GridViewCancelEditEventArgs : CancelEventArgs {
+        public GridViewCancelEditEventArgs(int rowIndex);
+        public int RowIndex { get; }
+    }
+    public delegate void GridViewCancelEditEventHandler(object sender, GridViewCancelEditEventArgs e);
+    public class GridViewColumnsGenerator : AutoFieldsGenerator {
+        public GridViewColumnsGenerator();
+        public override List<AutoGeneratedField> CreateAutoGeneratedFields(object dataObject, Control control);
+    }
+    public class GridViewCommandEventArgs : CommandEventArgs {
+        public GridViewCommandEventArgs(object commandSource, CommandEventArgs originalArgs);
+        public GridViewCommandEventArgs(GridViewRow row, object commandSource, CommandEventArgs originalArgs);
+        public object CommandSource { get; }
+        public bool Handled { get; set; }
+    }
+    public delegate void GridViewCommandEventHandler(object sender, GridViewCommandEventArgs e);
+    public class GridViewDeletedEventArgs : EventArgs {
+        public GridViewDeletedEventArgs(int affectedRows, Exception e);
+        public int AffectedRows { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary Values { get; }
+    }
+    public delegate void GridViewDeletedEventHandler(object sender, GridViewDeletedEventArgs e);
+    public class GridViewDeleteEventArgs : CancelEventArgs {
+        public GridViewDeleteEventArgs(int rowIndex);
+        public IOrderedDictionary Keys { get; }
+        public int RowIndex { get; }
+        public IOrderedDictionary Values { get; }
+    }
+    public delegate void GridViewDeleteEventHandler(object sender, GridViewDeleteEventArgs e);
+    public class GridViewEditEventArgs : CancelEventArgs {
+        public GridViewEditEventArgs(int newEditIndex);
+        public int NewEditIndex { get; set; }
+    }
+    public delegate void GridViewEditEventHandler(object sender, GridViewEditEventArgs e);
+    public class GridViewPageEventArgs : CancelEventArgs {
+        public GridViewPageEventArgs(int newPageIndex);
+        public int NewPageIndex { get; set; }
+    }
+    public delegate void GridViewPageEventHandler(object sender, GridViewPageEventArgs e);
+    public class GridViewRow : TableRow, IDataItemContainer, INamingContainer {
+        public GridViewRow(int rowIndex, int dataItemIndex, DataControlRowType rowType, DataControlRowState rowState);
+        public virtual object DataItem { get; set; }
+        public virtual int DataItemIndex { get; }
+        public virtual int RowIndex { get; }
+        public virtual DataControlRowState RowState { get; set; }
+        public virtual DataControlRowType RowType { get; set; }
+        object System.Web.UI.IDataItemContainer.DataItem { get; }
+        int System.Web.UI.IDataItemContainer.DataItemIndex { get; }
+        int System.Web.UI.IDataItemContainer.DisplayIndex { get; }
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+    }
+    public class GridViewRowCollection : ICollection, IEnumerable {
+        public GridViewRowCollection(ArrayList rows);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        public GridViewRow this[int index] { get; }
+        public void CopyTo(GridViewRow[] array, int index);
+        public IEnumerator GetEnumerator();
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+    }
+    public class GridViewRowEventArgs : EventArgs {
+        public GridViewRowEventArgs(GridViewRow row);
+        public GridViewRow Row { get; }
+    }
+    public delegate void GridViewRowEventHandler(object sender, GridViewRowEventArgs e);
+    public class GridViewSelectEventArgs : CancelEventArgs {
+        public GridViewSelectEventArgs(int newSelectedIndex);
+        public int NewSelectedIndex { get; set; }
+    }
+    public delegate void GridViewSelectEventHandler(object sender, GridViewSelectEventArgs e);
+    public class GridViewSortEventArgs : CancelEventArgs {
+        public GridViewSortEventArgs(string sortExpression, SortDirection sortDirection);
+        public SortDirection SortDirection { get; set; }
+        public string SortExpression { get; set; }
+    }
+    public delegate void GridViewSortEventHandler(object sender, GridViewSortEventArgs e);
+    public class GridViewUpdatedEventArgs : EventArgs {
+        public GridViewUpdatedEventArgs(int affectedRows, Exception e);
+        public int AffectedRows { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public bool KeepInEditMode { get; set; }
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary NewValues { get; }
+        public IOrderedDictionary OldValues { get; }
+    }
+    public delegate void GridViewUpdatedEventHandler(object sender, GridViewUpdatedEventArgs e);
+    public class GridViewUpdateEventArgs : CancelEventArgs {
+        public GridViewUpdateEventArgs(int rowIndex);
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary NewValues { get; }
+        public IOrderedDictionary OldValues { get; }
+        public int RowIndex { get; }
+    }
+    public delegate void GridViewUpdateEventHandler(object sender, GridViewUpdateEventArgs e);
+    public class HiddenField : Control, IPostBackDataHandler {
+        public HiddenField();
+        public override bool EnableTheming { get; set; }
+        public override string SkinID { get; set; }
+        public virtual string Value { get; set; }
+        public event EventHandler ValueChanged;
+        protected override ControlCollection CreateControlCollection();
+        public override void Focus();
+        protected virtual bool LoadPostData(string postDataKey, NameValueCollection postCollection);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void OnValueChanged(EventArgs e);
+        protected virtual void RaisePostDataChangedEvent();
+        protected internal override void Render(HtmlTextWriter writer);
+        bool System.Web.UI.IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection);
+        void System.Web.UI.IPostBackDataHandler.RaisePostDataChangedEvent();
+    }
+    public abstract class HierarchicalDataBoundControl : BaseDataBoundControl {
+        protected HierarchicalDataBoundControl();
+        public override string DataSourceID { get; set; }
+        protected virtual HierarchicalDataSourceView GetData(string viewPath);
+        protected virtual IHierarchicalDataSource GetDataSource();
+        protected void MarkAsDataBound();
+        protected override void OnDataPropertyChanged();
+        protected virtual void OnDataSourceChanged(object sender, EventArgs e);
+        protected internal override void OnLoad(EventArgs e);
+        protected override void OnPagePreLoad(object sender, EventArgs e);
+        protected internal virtual void PerformDataBinding();
+        protected override void PerformSelect();
+        protected override void ValidateDataSource(object dataSource);
+    }
+    public enum HorizontalAlign {
+        Center = 2,
+        Justify = 4,
+        Left = 1,
+        NotSet = 0,
+        Right = 3,
+    }
+    public abstract class HotSpot : IStateManager {
+        protected HotSpot();
+        public virtual string AccessKey { get; set; }
+        public virtual string AlternateText { get; set; }
+        public virtual HotSpotMode HotSpotMode { get; set; }
+        protected virtual bool IsTrackingViewState { get; }
+        protected internal abstract string MarkupName { get; }
+        public string NavigateUrl { get; set; }
+        public string PostBackValue { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public virtual short TabIndex { get; set; }
+        public virtual string Target { get; set; }
+        protected StateBag ViewState { get; }
+        public abstract string GetCoordinates();
+        protected virtual void LoadViewState(object savedState);
+        protected virtual object SaveViewState();
+        void System.Web.UI.IStateManager.LoadViewState(object savedState);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        public override string ToString();
+        protected virtual void TrackViewState();
+    }
+    public sealed class HotSpotCollection : StateManagedCollection {
+        public HotSpotCollection();
+        public HotSpot this[int index] { get; }
+        public int Add(HotSpot spot);
+        protected override object CreateKnownType(int index);
+        protected override Type[] GetKnownTypes();
+        public void Insert(int index, HotSpot spot);
+        protected override void OnValidate(object o);
+        public void Remove(HotSpot spot);
+        public void RemoveAt(int index);
+        protected override void SetDirtyObject(object o);
+    }
+    public enum HotSpotMode {
+        Inactive = 3,
+        Navigate = 1,
+        NotSet = 0,
+        PostBack = 2,
+    }
+    public class HyperLink : WebControl {
+        public HyperLink();
+        public virtual Unit ImageHeight { get; set; }
+        public virtual string ImageUrl { get; set; }
+        public virtual Unit ImageWidth { get; set; }
+        public string NavigateUrl { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        public string Target { get; set; }
+        public virtual string Text { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override void AddParsedSubObject(object obj);
+        protected override void LoadViewState(object savedState);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+    }
+    public class HyperLinkColumn : DataGridColumn {
+        public HyperLinkColumn();
+        public virtual string DataNavigateUrlField { get; set; }
+        public virtual string DataNavigateUrlFormatString { get; set; }
+        public virtual string DataTextField { get; set; }
+        public virtual string DataTextFormatString { get; set; }
+        public virtual string NavigateUrl { get; set; }
+        public virtual string Target { get; set; }
+        public virtual string Text { get; set; }
+        protected virtual string FormatDataNavigateUrlValue(object dataUrlValue);
+        protected virtual string FormatDataTextValue(object dataTextValue);
+        public override void Initialize();
+        public override void InitializeCell(TableCell cell, int columnIndex, ListItemType itemType);
+    }
+    public class HyperLinkControlBuilder : ControlBuilder {
+        public HyperLinkControlBuilder();
+        public override bool AllowWhitespaceLiterals();
+    }
+    public class HyperLinkField : DataControlField {
+        public HyperLinkField();
+        public virtual string[] DataNavigateUrlFields { get; set; }
+        public virtual string DataNavigateUrlFormatString { get; set; }
+        public virtual string DataTextField { get; set; }
+        public virtual string DataTextFormatString { get; set; }
+        public virtual string NavigateUrl { get; set; }
+        public virtual string Target { get; set; }
+        public virtual string Text { get; set; }
+        protected override void CopyProperties(DataControlField newField);
+        protected override DataControlField CreateField();
+        protected virtual string FormatDataNavigateUrlValue(object[] dataUrlValues);
+        protected virtual string FormatDataTextValue(object dataTextValue);
+        public override bool Initialize(bool enableSorting, Control control);
+        public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex);
+        public override void ValidateSupportsCallback();
+    }
+    public interface IButtonControl {
+        bool CausesValidation { get; set; }
+        string CommandArgument { get; set; }
+        string CommandName { get; set; }
+        string PostBackUrl { get; set; }
+        string Text { get; set; }
+        string ValidationGroup { get; set; }
+        event EventHandler Click;
+        event CommandEventHandler Command;
+    }
+    public interface ICallbackContainer {
+        string GetCallbackScript(IButtonControl buttonControl, string argument);
+    }
+    public interface ICompositeControlDesignerAccessor {
+        void RecreateChildControls();
+    }
+    public interface IDataBoundControl {
+        string[] DataKeyNames { get; set; }
+        string DataMember { get; set; }
+        object DataSource { get; set; }
+        string DataSourceID { get; set; }
+        IDataSource DataSourceObject { get; }
+    }
+    public interface IDataBoundItemControl : IDataBoundControl {
+        DataKey DataKey { get; }
+        DataBoundControlMode Mode { get; }
+    }
+    public interface IDataBoundListControl : IDataBoundControl {
+        string[] ClientIDRowSuffix { get; set; }
+        DataKeyArray DataKeys { get; }
+        bool EnablePersistedSelection { get; set; }
+        DataKey SelectedDataKey { get; }
+        int SelectedIndex { get; set; }
+    }
+    public interface IFieldControl {
+        IAutoFieldGenerator FieldsGenerator { get; set; }
+    }
+    public class Image : WebControl {
+        public Image();
+        public virtual string AlternateText { get; set; }
+        public virtual string DescriptionUrl { get; set; }
+        public override bool Enabled { get; set; }
+        public override FontInfo Font { get; }
+        public virtual bool GenerateEmptyAlternateText { get; set; }
+        public virtual ImageAlign ImageAlign { get; set; }
+        public virtual string ImageUrl { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+    }
+    public enum ImageAlign {
+        AbsBottom = 7,
+        AbsMiddle = 8,
+        Baseline = 3,
+        Bottom = 6,
+        Left = 1,
+        Middle = 5,
+        NotSet = 0,
+        Right = 2,
+        TextTop = 9,
+        Top = 4,
+    }
+    public class ImageButton : Image, IButtonControl, IPostBackDataHandler, IPostBackEventHandler {
+        public ImageButton();
+        public virtual bool CausesValidation { get; set; }
+        public string CommandArgument { get; set; }
+        public string CommandName { get; set; }
+        public override bool Enabled { get; set; }
+        public override bool GenerateEmptyAlternateText { get; set; }
+        public virtual string OnClientClick { get; set; }
+        public virtual string PostBackUrl { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        string System.Web.UI.WebControls.IButtonControl.Text { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        protected virtual string Text { get; set; }
+        public virtual string ValidationGroup { get; set; }
+        public event ImageClickEventHandler Click;
+        public event CommandEventHandler Command;
+        event EventHandler System.Web.UI.WebControls.IButtonControl.Click;
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected virtual PostBackOptions GetPostBackOptions();
+        protected virtual bool LoadPostData(string postDataKey, NameValueCollection postCollection);
+        protected virtual void OnClick(ImageClickEventArgs e);
+        protected virtual void OnCommand(CommandEventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void RaisePostBackEvent(string eventArgument);
+        protected virtual void RaisePostDataChangedEvent();
+        bool System.Web.UI.IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection);
+        void System.Web.UI.IPostBackDataHandler.RaisePostDataChangedEvent();
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+    }
+    public class ImageField : DataControlField {
+        public static readonly string ThisExpression;
+        public ImageField();
+        public virtual string AlternateText { get; set; }
+        public virtual bool ConvertEmptyStringToNull { get; set; }
+        public virtual string DataAlternateTextField { get; set; }
+        public virtual string DataAlternateTextFormatString { get; set; }
+        public virtual string DataImageUrlField { get; set; }
+        public virtual string DataImageUrlFormatString { get; set; }
+        public virtual string NullDisplayText { get; set; }
+        public virtual string NullImageUrl { get; set; }
+        public virtual bool ReadOnly { get; set; }
+        protected override void CopyProperties(DataControlField newField);
+        protected override DataControlField CreateField();
+        public override void ExtractValuesFromCell(IOrderedDictionary dictionary, DataControlFieldCell cell, DataControlRowState rowState, bool includeReadOnly);
+        protected virtual string FormatImageUrlValue(object dataValue);
+        protected virtual string GetDesignTimeValue();
+        protected virtual string GetFormattedAlternateText(Control controlContainer);
+        protected virtual object GetValue(Control controlContainer, string fieldName, ref PropertyDescriptor cachedDescriptor);
+        public override bool Initialize(bool enableSorting, Control control);
+        public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex);
+        protected virtual void InitializeDataCell(DataControlFieldCell cell, DataControlRowState rowState);
+        protected virtual void OnDataBindField(object sender, EventArgs e);
+        public override void ValidateSupportsCallback();
+    }
+    public class ImageMap : Image, IPostBackEventHandler {
+        public ImageMap();
+        public override bool Enabled { get; set; }
+        public virtual HotSpotMode HotSpotMode { get; set; }
+        public HotSpotCollection HotSpots { get; }
+        public virtual string Target { get; set; }
+        public event ImageMapEventHandler Click;
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override void LoadViewState(object savedState);
+        protected virtual void OnClick(ImageMapEventArgs e);
+        protected virtual void RaisePostBackEvent(string eventArgument);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected override object SaveViewState();
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+        protected override void TrackViewState();
+    }
+    public class ImageMapEventArgs : EventArgs {
+        public ImageMapEventArgs(string value);
+        public string PostBackValue { get; }
+    }
+    public delegate void ImageMapEventHandler(object sender, ImageMapEventArgs e);
+    public enum InsertItemPosition {
+        FirstItem = 1,
+        LastItem = 2,
+        None = 0,
+    }
+    public interface IPageableItemContainer {
+        int MaximumRows { get; }
+        int StartRowIndex { get; }
+        event EventHandler<PageEventArgs> TotalRowCountAvailable;
+        void SetPageProperties(int startRowIndex, int maximumRows, bool databind);
+    }
+    public interface IPersistedSelector {
+        DataKey DataKey { get; set; }
+    }
+    public interface IPostBackContainer {
+        PostBackOptions GetPostBackOptions(IButtonControl buttonControl);
+    }
+    public interface IQueryableDataSource : IDataSource {
+        event EventHandler<QueryCreatedEventArgs> QueryCreated;
+        void RaiseViewChanged();
+    }
+    public interface IRepeatInfoUser {
+        bool HasFooter { get; }
+        bool HasHeader { get; }
+        bool HasSeparators { get; }
+        int RepeatedItemCount { get; }
+        Style GetItemStyle(ListItemType itemType, int repeatIndex);
+        void RenderItem(ListItemType itemType, int repeatIndex, RepeatInfo repeatInfo, HtmlTextWriter writer);
+    }
+    public class Label : WebControl, ITextControl {
+        public Label();
+        public virtual string AssociatedControlID { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public virtual string Text { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override void AddParsedSubObject(object obj);
+        protected override void LoadViewState(object savedState);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+    }
+    public class LabelControlBuilder : ControlBuilder {
+        public LabelControlBuilder();
+        public override bool AllowWhitespaceLiterals();
+    }
+    public class LinkButton : WebControl, IButtonControl, IPostBackEventHandler {
+        public LinkButton();
+        public virtual bool CausesValidation { get; set; }
+        public string CommandArgument { get; set; }
+        public string CommandName { get; set; }
+        public virtual string OnClientClick { get; set; }
+        public virtual string PostBackUrl { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        public virtual string Text { get; set; }
+        public virtual string ValidationGroup { get; set; }
+        public event EventHandler Click;
+        public event CommandEventHandler Command;
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override void AddParsedSubObject(object obj);
+        protected virtual PostBackOptions GetPostBackOptions();
+        protected override void LoadViewState(object savedState);
+        protected virtual void OnClick(EventArgs e);
+        protected virtual void OnCommand(CommandEventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void RaisePostBackEvent(string eventArgument);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+    }
+    public class LinkButtonControlBuilder : ControlBuilder {
+        public LinkButtonControlBuilder();
+        public override bool AllowWhitespaceLiterals();
+    }
+    public class LinqDataSource : ContextDataSource, IDataSource, IDynamicDataSource {
+        public LinqDataSource();
+        public bool AutoGenerateOrderByClause { get; set; }
+        public bool AutoGenerateWhereClause { get; set; }
+        public bool AutoPage { get; set; }
+        public bool AutoSort { get; set; }
+        public override string ContextTypeName { get; set; }
+        public ParameterCollection DeleteParameters { get; }
+        public bool EnableDelete { get; set; }
+        public bool EnableInsert { get; set; }
+        public bool EnableObjectTracking { get; set; }
+        public bool EnableUpdate { get; set; }
+        public string GroupBy { get; set; }
+        public ParameterCollection GroupByParameters { get; }
+        public ParameterCollection InsertParameters { get; }
+        public string OrderBy { get; set; }
+        public ParameterCollection OrderByParameters { get; }
+        public string OrderGroupsBy { get; set; }
+        public ParameterCollection OrderGroupsByParameters { get; }
+        public string Select { get; set; }
+        public ParameterCollection SelectParameters { get; }
+        public bool StoreOriginalValuesInViewState { get; set; }
+        Type System.Web.DynamicData.IDynamicDataSource.ContextType { get; set; }
+        string System.Web.DynamicData.IDynamicDataSource.EntitySetName { get; set; }
+        public string TableName { get; set; }
+        public ParameterCollection UpdateParameters { get; }
+        public string Where { get; set; }
+        public ParameterCollection WhereParameters { get; }
+        public event EventHandler<LinqDataSourceStatusEventArgs> ContextCreated;
+        public event EventHandler<LinqDataSourceContextEventArgs> ContextCreating;
+        public event EventHandler<LinqDataSourceDisposeEventArgs> ContextDisposing;
+        public event EventHandler<LinqDataSourceStatusEventArgs> Deleted;
+        public event EventHandler<LinqDataSourceDeleteEventArgs> Deleting;
+        public event EventHandler<LinqDataSourceStatusEventArgs> Inserted;
+        public event EventHandler<LinqDataSourceInsertEventArgs> Inserting;
+        public event EventHandler<LinqDataSourceStatusEventArgs> Selected;
+        public event EventHandler<LinqDataSourceSelectEventArgs> Selecting;
+        event EventHandler<DynamicValidatorEventArgs> System.Web.DynamicData.IDynamicDataSource.Exception;
+        public event EventHandler<LinqDataSourceStatusEventArgs> Updated;
+        public event EventHandler<LinqDataSourceUpdateEventArgs> Updating;
+        protected override QueryableDataSourceView CreateQueryableView();
+        protected virtual LinqDataSourceView CreateView();
+        public int Delete(IDictionary keys, IDictionary oldValues);
+        public int Insert(IDictionary values);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void OnUnload(EventArgs e);
+        public int Update(IDictionary keys, IDictionary values, IDictionary oldValues);
+    }
+    public class LinqDataSourceContextEventArgs : EventArgs {
+        public LinqDataSourceContextEventArgs();
+        public LinqDataSourceContextEventArgs(DataSourceOperation operation);
+        public object ObjectInstance { get; set; }
+        public DataSourceOperation Operation { get; }
+    }
+    public class LinqDataSourceDeleteEventArgs : CancelEventArgs {
+        public LinqDataSourceDeleteEventArgs(object originalObject);
+        public LinqDataSourceDeleteEventArgs(LinqDataSourceValidationException exception);
+        public LinqDataSourceValidationException Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public object OriginalObject { get; }
+    }
+    public class LinqDataSourceDisposeEventArgs : CancelEventArgs {
+        public LinqDataSourceDisposeEventArgs(object instance);
+        public object ObjectInstance { get; }
+    }
+    public class LinqDataSourceInsertEventArgs : CancelEventArgs {
+        public LinqDataSourceInsertEventArgs(object newObject);
+        public LinqDataSourceInsertEventArgs(LinqDataSourceValidationException exception);
+        public LinqDataSourceValidationException Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public object NewObject { get; }
+    }
+    public class LinqDataSourceSelectEventArgs : CancelEventArgs {
+        public LinqDataSourceSelectEventArgs(DataSourceSelectArguments arguments, IDictionary<string, object> whereParameters, IOrderedDictionary orderByParameters, IDictionary<string, object> groupByParameters, IDictionary<string, object> orderGroupsByParameters, IDictionary<string, object> selectParameters);
+        public DataSourceSelectArguments Arguments { get; }
+        public IDictionary<string, object> GroupByParameters { get; }
+        public IOrderedDictionary OrderByParameters { get; }
+        public IDictionary<string, object> OrderGroupsByParameters { get; }
+        public object Result { get; set; }
+        public IDictionary<string, object> SelectParameters { get; }
+        public IDictionary<string, object> WhereParameters { get; }
+    }
+    public class LinqDataSourceStatusEventArgs : EventArgs {
+        public LinqDataSourceStatusEventArgs(Exception exception);
+        public LinqDataSourceStatusEventArgs(object result);
+        public LinqDataSourceStatusEventArgs(object result, int totalRowCount);
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public object Result { get; }
+        public int TotalRowCount { get; }
+    }
+    public class LinqDataSourceUpdateEventArgs : CancelEventArgs {
+        public LinqDataSourceUpdateEventArgs(object originalObject, object newObject);
+        public LinqDataSourceUpdateEventArgs(LinqDataSourceValidationException exception);
+        public LinqDataSourceValidationException Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public object NewObject { get; }
+        public object OriginalObject { get; }
+    }
+    public class LinqDataSourceValidationException : Exception, IDynamicValidatorException, ISerializable {
+        public LinqDataSourceValidationException();
+        protected LinqDataSourceValidationException(SerializationInfo info, StreamingContext context);
+        public LinqDataSourceValidationException(string message);
+        public LinqDataSourceValidationException(string message, IDictionary<string, Exception> innerExceptions);
+        public LinqDataSourceValidationException(string message, Exception innerException);
+        public IDictionary<string, Exception> InnerExceptions { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public class LinqDataSourceView : ContextDataSourceView {
+        public LinqDataSourceView(LinqDataSource owner, string name, HttpContext context);
+        public override bool CanDelete { get; }
+        public override bool CanInsert { get; }
+        public override bool CanPage { get; }
+        public override bool CanRetrieveTotalRowCount { get; }
+        public override bool CanSort { get; }
+        public override bool CanUpdate { get; }
+        public override Type ContextType { get; }
+        public override string ContextTypeName { get; set; }
+        public bool EnableDelete { get; set; }
+        public bool EnableInsert { get; set; }
+        public bool EnableObjectTracking { get; set; }
+        public bool EnableUpdate { get; set; }
+        public bool StoreOriginalValuesInViewState { get; set; }
+        public string TableName { get; set; }
+        public event EventHandler<LinqDataSourceStatusEventArgs> ContextCreated;
+        public event EventHandler<LinqDataSourceContextEventArgs> ContextCreating;
+        public event EventHandler<LinqDataSourceDisposeEventArgs> ContextDisposing;
+        public event EventHandler<LinqDataSourceStatusEventArgs> Deleted;
+        public event EventHandler<LinqDataSourceDeleteEventArgs> Deleting;
+        public event EventHandler<LinqDataSourceStatusEventArgs> Inserted;
+        public event EventHandler<LinqDataSourceInsertEventArgs> Inserting;
+        public event EventHandler<LinqDataSourceStatusEventArgs> Selected;
+        public event EventHandler<LinqDataSourceSelectEventArgs> Selecting;
+        public event EventHandler<LinqDataSourceStatusEventArgs> Updated;
+        public event EventHandler<LinqDataSourceUpdateEventArgs> Updating;
+        protected virtual object CreateContext(Type contextType);
+        protected override ContextDataSourceContextData CreateContext(DataSourceOperation operation);
+        protected virtual void DeleteDataObject(object dataContext, object table, object oldDataObject);
+        protected override int DeleteObject(object oldEntity);
+        protected override void DisposeContext(object dataContext);
+        protected override int ExecuteDelete(IDictionary keys, IDictionary oldValues);
+        protected override int ExecuteInsert(IDictionary values);
+        protected internal override IEnumerable ExecuteSelect(DataSourceSelectArguments arguments);
+        protected override int ExecuteUpdate(IDictionary keys, IDictionary values, IDictionary oldValues);
+        protected override object GetSource(QueryContext context);
+        protected virtual MemberInfo GetTableMemberInfo(Type contextType);
+        protected override void HandleValidationErrors(IDictionary<string, Exception> errors, DataSourceOperation operation);
+        protected virtual void InsertDataObject(object dataContext, object table, object newDataObject);
+        protected override int InsertObject(object newEntity);
+        protected virtual void OnContextCreated(LinqDataSourceStatusEventArgs e);
+        protected virtual void OnContextCreating(LinqDataSourceContextEventArgs e);
+        protected virtual void OnContextDisposing(LinqDataSourceDisposeEventArgs e);
+        protected virtual void OnDeleted(LinqDataSourceStatusEventArgs e);
+        protected virtual void OnDeleting(LinqDataSourceDeleteEventArgs e);
+        protected virtual void OnException(DynamicValidatorEventArgs e);
+        protected virtual void OnInserted(LinqDataSourceStatusEventArgs e);
+        protected virtual void OnInserting(LinqDataSourceInsertEventArgs e);
+        protected virtual void OnSelected(LinqDataSourceStatusEventArgs e);
+        protected virtual void OnSelecting(LinqDataSourceSelectEventArgs e);
+        protected virtual void OnUpdated(LinqDataSourceStatusEventArgs e);
+        protected virtual void OnUpdating(LinqDataSourceUpdateEventArgs e);
+        protected virtual void ResetDataObject(object table, object dataObject);
+        public IEnumerable Select(DataSourceSelectArguments arguments);
+        protected override void StoreOriginalValues(IList results);
+        protected virtual void UpdateDataObject(object dataContext, object table, object oldDataObject, object newDataObject);
+        protected override int UpdateObject(object oldEntity, object newEntity);
+        protected virtual void ValidateContextType(Type contextType, bool selecting);
+        protected virtual void ValidateDeleteSupported(IDictionary keys, IDictionary oldValues);
+        protected virtual void ValidateEditSupported();
+        protected virtual void ValidateInsertSupported(IDictionary values);
+        protected virtual void ValidateTableType(Type tableType, bool selecting);
+        protected virtual void ValidateUpdateSupported(IDictionary keys, IDictionary values, IDictionary oldValues);
+    }
+    public class ListBox : ListControl, IPostBackDataHandler {
+        public ListBox();
+        public override Color BorderColor { get; set; }
+        public override BorderStyle BorderStyle { get; set; }
+        public override Unit BorderWidth { get; set; }
+        public virtual int Rows { get; set; }
+        public virtual ListSelectionMode SelectionMode { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        public virtual int[] GetSelectedIndices();
+        protected virtual bool LoadPostData(string postDataKey, NameValueCollection postCollection);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void RaisePostDataChangedEvent();
+        bool System.Web.UI.IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection);
+        void System.Web.UI.IPostBackDataHandler.RaisePostDataChangedEvent();
+    }
+    public abstract class ListControl : DataBoundControl, IEditableTextControl, ITextControl {
+        public ListControl();
+        public virtual bool AppendDataBoundItems { get; set; }
+        public virtual bool AutoPostBack { get; set; }
+        public virtual bool CausesValidation { get; set; }
+        public virtual string DataTextField { get; set; }
+        public virtual string DataTextFormatString { get; set; }
+        public virtual string DataValueField { get; set; }
+        public virtual ListItemCollection Items { get; }
+        public virtual int SelectedIndex { get; set; }
+        public virtual ListItem SelectedItem { get; }
+        public virtual string SelectedValue { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public virtual string Text { get; set; }
+        public virtual string ValidationGroup { get; set; }
+        public event EventHandler SelectedIndexChanged;
+        public event EventHandler TextChanged;
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        public virtual void ClearSelection();
+        protected override void LoadViewState(object savedState);
+        protected override void OnDataBinding(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void OnSelectedIndexChanged(EventArgs e);
+        protected virtual void OnTextChanged(EventArgs e);
+        protected internal override void PerformDataBinding(IEnumerable dataSource);
+        protected override void PerformSelect();
+        protected internal override void RenderContents(HtmlTextWriter writer);
+        protected override object SaveViewState();
+        protected void SetPostDataSelection(int selectedIndex);
+        protected override void TrackViewState();
+        protected internal virtual void VerifyMultiSelect();
+    }
+    public sealed class ListItem : IAttributeAccessor, IParserAccessor, IStateManager {
+        public ListItem();
+        public ListItem(string text);
+        public ListItem(string text, string value);
+        public ListItem(string text, string value, bool enabled);
+        public AttributeCollection Attributes { get; }
+        public bool Enabled { get; set; }
+        public bool Selected { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public string Text { get; set; }
+        public string Value { get; set; }
+        public override bool Equals(object o);
+        public static ListItem FromString(string s);
+        public override int GetHashCode();
+        string System.Web.UI.IAttributeAccessor.GetAttribute(string name);
+        void System.Web.UI.IAttributeAccessor.SetAttribute(string name, string value);
+        void System.Web.UI.IParserAccessor.AddParsedSubObject(object obj);
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        public override string ToString();
+    }
+    public sealed class ListItemCollection : ICollection, IEnumerable, IList, IStateManager {
+        public ListItemCollection();
+        public int Capacity { get; set; }
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public ListItem this[int index] { get; }
+        public void Add(string item);
+        public void Add(ListItem item);
+        public void AddRange(ListItem[] items);
+        public void Clear();
+        public bool Contains(ListItem item);
+        public void CopyTo(Array array, int index);
+        public ListItem FindByText(string text);
+        public ListItem FindByValue(string value);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(ListItem item);
+        public void Insert(int index, string item);
+        public void Insert(int index, ListItem item);
+        public void Remove(string item);
+        public void Remove(ListItem item);
+        public void RemoveAt(int index);
+        int System.Collections.IList.Add(object item);
+        bool System.Collections.IList.Contains(object item);
+        int System.Collections.IList.IndexOf(object item);
+        void System.Collections.IList.Insert(int index, object item);
+        void System.Collections.IList.Remove(object item);
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+    }
+    public class ListItemControlBuilder : ControlBuilder {
+        public ListItemControlBuilder();
+        public override bool AllowWhitespaceLiterals();
+        public override bool HtmlDecodeLiterals();
+    }
+    public enum ListItemType {
+        AlternatingItem = 3,
+        EditItem = 5,
+        Footer = 1,
+        Header = 0,
+        Item = 2,
+        Pager = 7,
+        SelectedItem = 4,
+        Separator = 6,
+    }
+    public enum ListSelectionMode {
+        Multiple = 1,
+        Single = 0,
+    }
+    public class ListView : DataBoundControl, IDataBoundControl, IDataBoundListControl, IDataKeysControl, INamingContainer, IPageableItemContainer, IPersistedSelector, IWizardSideBarListControl {
+        public ListView();
+        public override string AccessKey { get; set; }
+        public virtual ITemplate AlternatingItemTemplate { get; set; }
+        public override Color BackColor { get; set; }
+        public override Color BorderColor { get; set; }
+        public override BorderStyle BorderStyle { get; set; }
+        public override Unit BorderWidth { get; set; }
+        public virtual string[] ClientIDRowSuffix { get; set; }
+        public DataKeyArray ClientIDRowSuffixDataKeys { get; }
+        public override ControlCollection Controls { get; }
+        public virtual bool ConvertEmptyStringToNull { get; set; }
+        public override string CssClass { get; set; }
+        public virtual string[] DataKeyNames { get; set; }
+        public virtual DataKeyArray DataKeys { get; }
+        public virtual string DeleteMethod { get; set; }
+        public virtual int EditIndex { get; set; }
+        public virtual ListViewItem EditItem { get; }
+        public virtual ITemplate EditItemTemplate { get; set; }
+        public virtual ITemplate EmptyDataTemplate { get; set; }
+        public virtual ITemplate EmptyItemTemplate { get; set; }
+        public virtual bool EnableModelValidation { get; set; }
+        public virtual bool EnablePersistedSelection { get; set; }
+        public override FontInfo Font { get; }
+        public override Color ForeColor { get; set; }
+        public virtual int GroupItemCount { get; set; }
+        public virtual string GroupPlaceholderID { get; set; }
+        public virtual ITemplate GroupSeparatorTemplate { get; set; }
+        public virtual ITemplate GroupTemplate { get; set; }
+        public override Unit Height { get; set; }
+        public virtual ListViewItem InsertItem { get; }
+        public virtual InsertItemPosition InsertItemPosition { get; set; }
+        public virtual ITemplate InsertItemTemplate { get; set; }
+        public virtual string InsertMethod { get; set; }
+        protected override bool IsUsingModelBinders { get; }
+        public virtual string ItemPlaceholderID { get; set; }
+        public virtual IList<ListViewDataItem> Items { get; }
+        public virtual ITemplate ItemSeparatorTemplate { get; set; }
+        public virtual ITemplate ItemTemplate { get; set; }
+        public virtual ITemplate LayoutTemplate { get; set; }
+        protected virtual int MaximumRows { get; }
+        public virtual DataKey SelectedDataKey { get; }
+        public virtual int SelectedIndex { get; set; }
+        public virtual ITemplate SelectedItemTemplate { get; set; }
+        public virtual DataKey SelectedPersistedDataKey { get; set; }
+        public object SelectedValue { get; }
+        public virtual SortDirection SortDirection { get; }
+        public virtual string SortExpression { get; }
+        protected virtual int StartRowIndex { get; }
+        DataKeyArray System.Web.UI.IDataKeysControl.ClientIDRowSuffixDataKeys { get; }
+        string[] System.Web.UI.WebControls.IDataBoundControl.DataKeyNames { get; set; }
+        string System.Web.UI.WebControls.IDataBoundControl.DataMember { get; set; }
+        object System.Web.UI.WebControls.IDataBoundControl.DataSource { get; set; }
+        string System.Web.UI.WebControls.IDataBoundControl.DataSourceID { get; set; }
+        IDataSource System.Web.UI.WebControls.IDataBoundControl.DataSourceObject { get; }
+        string[] System.Web.UI.WebControls.IDataBoundListControl.ClientIDRowSuffix { get; set; }
+        DataKeyArray System.Web.UI.WebControls.IDataBoundListControl.DataKeys { get; }
+        bool System.Web.UI.WebControls.IDataBoundListControl.EnablePersistedSelection { get; set; }
+        DataKey System.Web.UI.WebControls.IDataBoundListControl.SelectedDataKey { get; }
+        int System.Web.UI.WebControls.IDataBoundListControl.SelectedIndex { get; set; }
+        int System.Web.UI.WebControls.IPageableItemContainer.MaximumRows { get; }
+        int System.Web.UI.WebControls.IPageableItemContainer.StartRowIndex { get; }
+        DataKey System.Web.UI.WebControls.IPersistedSelector.DataKey { get; set; }
+        public override short TabIndex { get; set; }
+        public override string ToolTip { get; set; }
+        public virtual string UpdateMethod { get; set; }
+        public override Unit Width { get; set; }
+        public event EventHandler<ListViewCancelEventArgs> ItemCanceling;
+        public event EventHandler<ListViewCommandEventArgs> ItemCommand;
+        public event EventHandler<ListViewItemEventArgs> ItemCreated;
+        public event EventHandler<ListViewItemEventArgs> ItemDataBound;
+        public event EventHandler<ListViewDeletedEventArgs> ItemDeleted;
+        public event EventHandler<ListViewDeleteEventArgs> ItemDeleting;
+        public event EventHandler<ListViewEditEventArgs> ItemEditing;
+        public event EventHandler<ListViewInsertedEventArgs> ItemInserted;
+        public event EventHandler<ListViewInsertEventArgs> ItemInserting;
+        public event EventHandler<ListViewUpdatedEventArgs> ItemUpdated;
+        public event EventHandler<ListViewUpdateEventArgs> ItemUpdating;
+        public event EventHandler LayoutCreated;
+        public event EventHandler PagePropertiesChanged;
+        public event EventHandler<PagePropertiesChangingEventArgs> PagePropertiesChanging;
+        public event EventHandler SelectedIndexChanged;
+        public event EventHandler<ListViewSelectEventArgs> SelectedIndexChanging;
+        public event EventHandler Sorted;
+        public event EventHandler<ListViewSortEventArgs> Sorting;
+        event EventHandler<PageEventArgs> System.Web.UI.WebControls.IPageableItemContainer.TotalRowCountAvailable;
+        protected virtual void AddControlToContainer(Control control, Control container, int addLocation);
+        protected internal override void CreateChildControls();
+        protected virtual int CreateChildControls(IEnumerable dataSource, bool dataBinding);
+        protected override Style CreateControlStyle();
+        protected virtual ListViewDataItem CreateDataItem(int dataItemIndex, int displayIndex);
+        protected override DataSourceSelectArguments CreateDataSourceSelectArguments();
+        protected virtual void CreateEmptyDataItem();
+        protected virtual ListViewItem CreateEmptyItem();
+        protected virtual ListViewItem CreateInsertItem();
+        protected virtual ListViewItem CreateItem(ListViewItemType itemType);
+        protected virtual IList<ListViewDataItem> CreateItemsInGroups(ListViewPagedDataSource dataSource, bool dataBinding, InsertItemPosition insertPosition, ArrayList keyArray);
+        protected virtual IList<ListViewDataItem> CreateItemsWithoutGroups(ListViewPagedDataSource dataSource, bool dataBinding, InsertItemPosition insertPosition, ArrayList keyArray);
+        protected virtual void CreateLayoutTemplate();
+        protected virtual void CreateSuffixArrayList(ListViewPagedDataSource dataSource, ArrayList suffixArray);
+        public virtual void DeleteItem(int itemIndex);
+        protected virtual void EnsureLayoutTemplate();
+        public virtual void ExtractItemValues(IOrderedDictionary itemValues, ListViewItem item, bool includePrimaryKey);
+        protected virtual Control FindPlaceholder(string containerID, Control container);
+        public virtual void InsertNewItem(bool causesValidation);
+        protected virtual void InstantiateEmptyDataTemplate(Control container);
+        protected virtual void InstantiateEmptyItemTemplate(Control container);
+        protected virtual void InstantiateGroupSeparatorTemplate(Control container);
+        protected virtual void InstantiateGroupTemplate(Control container);
+        protected virtual void InstantiateInsertItemTemplate(Control container);
+        protected virtual void InstantiateItemSeparatorTemplate(Control container);
+        protected virtual void InstantiateItemTemplate(Control container, int displayIndex);
+        protected internal override void LoadControlState(object savedState);
+        protected override void LoadViewState(object savedState);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected virtual void OnItemCanceling(ListViewCancelEventArgs e);
+        protected virtual void OnItemCommand(ListViewCommandEventArgs e);
+        protected virtual void OnItemCreated(ListViewItemEventArgs e);
+        protected virtual void OnItemDataBound(ListViewItemEventArgs e);
+        protected virtual void OnItemDeleted(ListViewDeletedEventArgs e);
+        protected virtual void OnItemDeleting(ListViewDeleteEventArgs e);
+        protected virtual void OnItemEditing(ListViewEditEventArgs e);
+        protected virtual void OnItemInserted(ListViewInsertedEventArgs e);
+        protected virtual void OnItemInserting(ListViewInsertEventArgs e);
+        protected virtual void OnItemUpdated(ListViewUpdatedEventArgs e);
+        protected virtual void OnItemUpdating(ListViewUpdateEventArgs e);
+        protected virtual void OnLayoutCreated(EventArgs e);
+        protected virtual void OnPagePropertiesChanged(EventArgs e);
+        protected virtual void OnPagePropertiesChanging(PagePropertiesChangingEventArgs e);
+        protected virtual void OnSelectedIndexChanged(EventArgs e);
+        protected virtual void OnSelectedIndexChanging(ListViewSelectEventArgs e);
+        protected virtual void OnSorted(EventArgs e);
+        protected virtual void OnSorting(ListViewSortEventArgs e);
+        protected virtual void OnTotalRowCountAvailable(PageEventArgs e);
+        protected internal override void PerformDataBinding(IEnumerable data);
+        protected override void PerformSelect();
+        protected virtual void RemoveItems();
+        protected internal override void Render(HtmlTextWriter writer);
+        protected internal override object SaveControlState();
+        protected override object SaveViewState();
+        public void SelectItem(int rowIndex);
+        public void SetEditItem(int rowIndex);
+        protected virtual void SetPageProperties(int startRowIndex, int maximumRows, bool databind);
+        public virtual void Sort(string sortExpression, SortDirection sortDirection);
+        void System.Web.UI.WebControls.IPageableItemContainer.SetPageProperties(int startRowIndex, int maximumRows, bool databind);
+        public virtual void UpdateItem(int itemIndex, bool causesValidation);
+    }
+    public class ListViewCancelEventArgs : CancelEventArgs {
+        public ListViewCancelEventArgs(int itemIndex, ListViewCancelMode cancelMode);
+        public ListViewCancelMode CancelMode { get; }
+        public int ItemIndex { get; }
+    }
+    public enum ListViewCancelMode {
+        CancelingEdit = 0,
+        CancelingInsert = 1,
+    }
+    public class ListViewCommandEventArgs : CommandEventArgs {
+        public ListViewCommandEventArgs(ListViewItem item, object commandSource, CommandEventArgs originalArgs);
+        public object CommandSource { get; }
+        public bool Handled { get; set; }
+        public ListViewItem Item { get; }
+    }
+    public class ListViewDataItem : ListViewItem {
+        public ListViewDataItem(int dataItemIndex, int displayIndex);
+        public override object DataItem { get; set; }
+        public override int DataItemIndex { get; }
+        public override int DisplayIndex { get; }
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+    }
+    public class ListViewDeletedEventArgs : EventArgs {
+        public ListViewDeletedEventArgs(int affectedRows, Exception exception);
+        public int AffectedRows { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary Values { get; }
+    }
+    public class ListViewDeleteEventArgs : CancelEventArgs {
+        public ListViewDeleteEventArgs(int itemIndex);
+        public int ItemIndex { get; }
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary Values { get; }
+    }
+    public class ListViewEditEventArgs : CancelEventArgs {
+        public ListViewEditEventArgs(int newEditIndex);
+        public int NewEditIndex { get; }
+    }
+    public class ListViewInsertedEventArgs : EventArgs {
+        public ListViewInsertedEventArgs(int affectedRows, Exception exception);
+        public int AffectedRows { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public bool KeepInInsertMode { get; set; }
+        public IOrderedDictionary Values { get; }
+    }
+    public class ListViewInsertEventArgs : CancelEventArgs {
+        public ListViewInsertEventArgs(ListViewItem item);
+        public ListViewItem Item { get; }
+        public IOrderedDictionary Values { get; }
+    }
+    public class ListViewItem : Control, IDataItemContainer, INamingContainer {
+        public ListViewItem(ListViewItemType itemType);
+        public virtual object DataItem { get; set; }
+        public virtual int DataItemIndex { get; }
+        public virtual int DisplayIndex { get; }
+        public ListViewItemType ItemType { get; }
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+    }
+    public class ListViewItemEventArgs : EventArgs {
+        public ListViewItemEventArgs(ListViewItem item);
+        public ListViewItem Item { get; }
+    }
+    public enum ListViewItemType {
+        DataItem = 0,
+        EmptyItem = 2,
+        InsertItem = 1,
+    }
+    public class ListViewPagedDataSource : ICollection, IEnumerable, ITypedList {
+        public ListViewPagedDataSource();
+        public bool AllowServerPaging { get; set; }
+        public int Count { get; }
+        public IEnumerable DataSource { get; set; }
+        public int DataSourceCount { get; }
+        public bool IsReadOnly { get; }
+        public bool IsServerPagingEnabled { get; }
+        public bool IsSynchronized { get; }
+        public int MaximumRows { get; set; }
+        public int StartRowIndex { get; set; }
+        public object SyncRoot { get; }
+        public int TotalRowCount { get; set; }
+        public void CopyTo(Array array, int index);
+        public IEnumerator GetEnumerator();
+        public PropertyDescriptorCollection GetItemProperties(PropertyDescriptor[] listAccessors);
+        public string GetListName(PropertyDescriptor[] listAccessors);
+    }
+    public class ListViewSelectEventArgs : CancelEventArgs {
+        public ListViewSelectEventArgs(int newSelectedIndex);
+        public int NewSelectedIndex { get; set; }
+    }
+    public class ListViewSortEventArgs : CancelEventArgs {
+        public ListViewSortEventArgs(string sortExpression, SortDirection sortDirection);
+        public SortDirection SortDirection { get; set; }
+        public string SortExpression { get; set; }
+    }
+    public class ListViewUpdatedEventArgs : EventArgs {
+        public ListViewUpdatedEventArgs(int affectedRows, Exception exception);
+        public int AffectedRows { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public bool KeepInEditMode { get; set; }
+        public IOrderedDictionary NewValues { get; }
+        public IOrderedDictionary OldValues { get; }
+    }
+    public class ListViewUpdateEventArgs : CancelEventArgs {
+        public ListViewUpdateEventArgs(int itemIndex);
+        public int ItemIndex { get; }
+        public IOrderedDictionary Keys { get; }
+        public IOrderedDictionary NewValues { get; }
+        public IOrderedDictionary OldValues { get; }
+    }
+    public class Literal : Control, ITextControl {
+        public Literal();
+        public LiteralMode Mode { get; set; }
+        public string Text { get; set; }
+        protected override void AddParsedSubObject(object obj);
+        protected override ControlCollection CreateControlCollection();
+        public override void Focus();
+        protected internal override void Render(HtmlTextWriter writer);
+    }
+    public class LiteralControlBuilder : ControlBuilder {
+        public LiteralControlBuilder();
+        public override bool AllowWhitespaceLiterals();
+        public override void AppendLiteralString(string s);
+        public override void AppendSubBuilder(ControlBuilder subBuilder);
+    }
+    public enum LiteralMode {
+        Encode = 2,
+        PassThrough = 1,
+        Transform = 0,
+    }
+    public class Localize : Literal {
+        public Localize();
+    }
+    public class Login : CompositeControl, IBorderPaddingControl, IRenderOuterTableControl {
+        public static readonly string LoginButtonCommandName;
+        public Login();
+        public virtual int BorderPadding { get; set; }
+        public TableItemStyle CheckBoxStyle { get; }
+        public virtual string CreateUserIconUrl { get; set; }
+        public virtual string CreateUserText { get; set; }
+        public virtual string CreateUserUrl { get; set; }
+        public virtual string DestinationPageUrl { get; set; }
+        public virtual bool DisplayRememberMe { get; set; }
+        public virtual LoginFailureAction FailureAction { get; set; }
+        public virtual string FailureText { get; set; }
+        public TableItemStyle FailureTextStyle { get; }
+        public virtual string HelpPageIconUrl { get; set; }
+        public virtual string HelpPageText { get; set; }
+        public virtual string HelpPageUrl { get; set; }
+        public TableItemStyle HyperLinkStyle { get; }
+        public virtual string InstructionText { get; set; }
+        public TableItemStyle InstructionTextStyle { get; }
+        public TableItemStyle LabelStyle { get; }
+        public virtual ITemplate LayoutTemplate { get; set; }
+        public virtual string LoginButtonImageUrl { get; set; }
+        public Style LoginButtonStyle { get; }
+        public virtual string LoginButtonText { get; set; }
+        public virtual ButtonType LoginButtonType { get; set; }
+        public virtual string MembershipProvider { get; set; }
+        public virtual Orientation Orientation { get; set; }
+        public virtual string Password { get; }
+        public virtual string PasswordLabelText { get; set; }
+        public virtual string PasswordRecoveryIconUrl { get; set; }
+        public virtual string PasswordRecoveryText { get; set; }
+        public virtual string PasswordRecoveryUrl { get; set; }
+        public virtual string PasswordRequiredErrorMessage { get; set; }
+        public virtual bool RememberMeSet { get; set; }
+        public virtual string RememberMeText { get; set; }
+        public virtual bool RenderOuterTable { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public Style TextBoxStyle { get; }
+        public virtual LoginTextLayout TextLayout { get; set; }
+        public virtual string TitleText { get; set; }
+        public TableItemStyle TitleTextStyle { get; }
+        public virtual string UserName { get; set; }
+        public virtual string UserNameLabelText { get; set; }
+        public virtual string UserNameRequiredErrorMessage { get; set; }
+        public Style ValidatorTextStyle { get; }
+        public virtual bool VisibleWhenLoggedIn { get; set; }
+        public event AuthenticateEventHandler Authenticate;
+        public event EventHandler LoggedIn;
+        public event LoginCancelEventHandler LoggingIn;
+        public event EventHandler LoginError;
+        protected internal override void CreateChildControls();
+        protected override void LoadViewState(object savedState);
+        protected virtual void OnAuthenticate(AuthenticateEventArgs e);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected virtual void OnLoggedIn(EventArgs e);
+        protected virtual void OnLoggingIn(LoginCancelEventArgs e);
+        protected virtual void OnLoginError(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected override object SaveViewState();
+        protected override void SetDesignModeState(IDictionary data);
+        protected override void TrackViewState();
+    }
+    public class LoginCancelEventArgs : EventArgs {
+        public LoginCancelEventArgs();
+        public LoginCancelEventArgs(bool cancel);
+        public bool Cancel { get; set; }
+    }
+    public delegate void LoginCancelEventHandler(object sender, LoginCancelEventArgs e);
+    public enum LoginFailureAction {
+        RedirectToLoginPage = 1,
+        Refresh = 0,
+    }
+    public class LoginName : WebControl {
+        public LoginName();
+        public virtual string FormatString { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        protected internal override void Render(HtmlTextWriter writer);
+        public override void RenderBeginTag(HtmlTextWriter writer);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+        public override void RenderEndTag(HtmlTextWriter writer);
+    }
+    public class LoginStatus : CompositeControl {
+        public LoginStatus();
+        public virtual string LoginImageUrl { get; set; }
+        public virtual string LoginText { get; set; }
+        public virtual LogoutAction LogoutAction { get; set; }
+        public virtual string LogoutImageUrl { get; set; }
+        public virtual string LogoutPageUrl { get; set; }
+        public virtual string LogoutText { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public event EventHandler LoggedOut;
+        public event LoginCancelEventHandler LoggingOut;
+        protected internal override void CreateChildControls();
+        protected virtual void OnLoggedOut(EventArgs e);
+        protected virtual void OnLoggingOut(LoginCancelEventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+        protected override void SetDesignModeState(IDictionary data);
+    }
+    public enum LoginTextLayout {
+        TextOnLeft = 0,
+        TextOnTop = 1,
+    }
+    public class LoginView : Control, INamingContainer {
+        public LoginView();
+        public virtual ITemplate AnonymousTemplate { get; set; }
+        public override ControlCollection Controls { get; }
+        public override bool EnableTheming { get; set; }
+        public virtual ITemplate LoggedInTemplate { get; set; }
+        public virtual RoleGroupCollection RoleGroups { get; }
+        public override string SkinID { get; set; }
+        public event EventHandler ViewChanged;
+        public event EventHandler ViewChanging;
+        protected internal override void CreateChildControls();
+        public override void DataBind();
+        public override void Focus();
+        protected internal override void LoadControlState(object savedState);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void OnViewChanged(EventArgs e);
+        protected virtual void OnViewChanging(EventArgs e);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected internal override object SaveControlState();
+        protected override void SetDesignModeState(IDictionary data);
+    }
+    public enum LogoutAction {
+        Redirect = 1,
+        RedirectToLoginPage = 2,
+        Refresh = 0,
+    }
+    public sealed class MailDefinition : IStateManager {
+        public MailDefinition();
+        public string BodyFileName { get; set; }
+        public string CC { get; set; }
+        public EmbeddedMailObjectsCollection EmbeddedObjects { get; }
+        public string From { get; set; }
+        public bool IsBodyHtml { get; set; }
+        public MailPriority Priority { get; set; }
+        public string Subject { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public MailMessage CreateMailMessage(string recipients, IDictionary replacements, string body, Control owner);
+        public MailMessage CreateMailMessage(string recipients, IDictionary replacements, Control owner);
+        void System.Web.UI.IStateManager.LoadViewState(object savedState);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+    }
+    public class MailMessageEventArgs : LoginCancelEventArgs {
+        public MailMessageEventArgs(MailMessage message);
+        public MailMessage Message { get; }
+    }
+    public delegate void MailMessageEventHandler(object sender, MailMessageEventArgs e);
+    public class Menu : HierarchicalDataBoundControl, INamingContainer, IPostBackEventHandler {
+        public static readonly string MenuItemClickCommandName;
+        public Menu();
+        public override ControlCollection Controls { get; }
+        public MenuItemBindingCollection DataBindings { get; }
+        public int DisappearAfter { get; set; }
+        public string DynamicBottomSeparatorImageUrl { get; set; }
+        public bool DynamicEnableDefaultPopOutImage { get; set; }
+        public int DynamicHorizontalOffset { get; set; }
+        public Style DynamicHoverStyle { get; }
+        public string DynamicItemFormatString { get; set; }
+        public ITemplate DynamicItemTemplate { get; set; }
+        public MenuItemStyle DynamicMenuItemStyle { get; }
+        public SubMenuStyle DynamicMenuStyle { get; }
+        public string DynamicPopOutImageTextFormatString { get; set; }
+        public string DynamicPopOutImageUrl { get; set; }
+        public MenuItemStyle DynamicSelectedStyle { get; }
+        public string DynamicTopSeparatorImageUrl { get; set; }
+        public int DynamicVerticalOffset { get; set; }
+        public bool IncludeStyleBlock { get; set; }
+        public MenuItemCollection Items { get; }
+        public bool ItemWrap { get; set; }
+        public MenuItemStyleCollection LevelMenuItemStyles { get; }
+        public MenuItemStyleCollection LevelSelectedStyles { get; }
+        public SubMenuStyleCollection LevelSubMenuStyles { get; }
+        public int MaximumDynamicDisplayLevels { get; set; }
+        public Orientation Orientation { get; set; }
+        public char PathSeparator { get; set; }
+        public MenuRenderingMode RenderingMode { get; set; }
+        public string ScrollDownImageUrl { get; set; }
+        public string ScrollDownText { get; set; }
+        public string ScrollUpImageUrl { get; set; }
+        public string ScrollUpText { get; set; }
+        public MenuItem SelectedItem { get; }
+        public string SelectedValue { get; }
+        public string SkipLinkText { get; set; }
+        public string StaticBottomSeparatorImageUrl { get; set; }
+        public int StaticDisplayLevels { get; set; }
+        public bool StaticEnableDefaultPopOutImage { get; set; }
+        public Style StaticHoverStyle { get; }
+        public string StaticItemFormatString { get; set; }
+        public ITemplate StaticItemTemplate { get; set; }
+        public MenuItemStyle StaticMenuItemStyle { get; }
+        public SubMenuStyle StaticMenuStyle { get; }
+        public string StaticPopOutImageTextFormatString { get; set; }
+        public string StaticPopOutImageUrl { get; set; }
+        public MenuItemStyle StaticSelectedStyle { get; }
+        public Unit StaticSubMenuIndent { get; set; }
+        public string StaticTopSeparatorImageUrl { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public string Target { get; set; }
+        public event MenuEventHandler MenuItemClick;
+        public event MenuEventHandler MenuItemDataBound;
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected internal override void CreateChildControls();
+        public sealed override void DataBind();
+        protected override void EnsureDataBound();
+        public MenuItem FindItem(string valuePath);
+        protected override IDictionary GetDesignModeState();
+        protected internal override void LoadControlState(object savedState);
+        protected override void LoadViewState(object state);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected override void OnDataBinding(EventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected virtual void OnMenuItemClick(MenuEventArgs e);
+        protected virtual void OnMenuItemDataBound(MenuEventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected internal override void PerformDataBinding();
+        protected internal virtual void RaisePostBackEvent(string eventArgument);
+        protected internal override void Render(HtmlTextWriter writer);
+        public override void RenderBeginTag(HtmlTextWriter writer);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+        public override void RenderEndTag(HtmlTextWriter writer);
+        protected internal override object SaveControlState();
+        protected override object SaveViewState();
+        protected override void SetDesignModeState(IDictionary data);
+        protected void SetItemDataBound(MenuItem node, bool dataBound);
+        protected void SetItemDataItem(MenuItem node, object dataItem);
+        protected void SetItemDataPath(MenuItem node, string dataPath);
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+        protected override void TrackViewState();
+    }
+    public sealed class MenuEventArgs : CommandEventArgs {
+        public MenuEventArgs(MenuItem item);
+        public MenuEventArgs(MenuItem item, object commandSource, CommandEventArgs originalArgs);
+        public object CommandSource { get; }
+        public MenuItem Item { get; }
+    }
+    public delegate void MenuEventHandler(object sender, MenuEventArgs e);
+    public sealed class MenuItem : ICloneable, IStateManager {
+        public MenuItem();
+        public MenuItem(string text);
+        public MenuItem(string text, string value);
+        public MenuItem(string text, string value, string imageUrl);
+        public MenuItem(string text, string value, string imageUrl, string navigateUrl);
+        public MenuItem(string text, string value, string imageUrl, string navigateUrl, string target);
+        public MenuItemCollection ChildItems { get; }
+        public bool DataBound { get; }
+        public object DataItem { get; }
+        public string DataPath { get; }
+        public int Depth { get; }
+        public bool Enabled { get; set; }
+        public string ImageUrl { get; set; }
+        public string NavigateUrl { get; set; }
+        public MenuItem Parent { get; }
+        public string PopOutImageUrl { get; set; }
+        public bool Selectable { get; set; }
+        public bool Selected { get; set; }
+        public string SeparatorImageUrl { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public string Target { get; set; }
+        public string Text { get; set; }
+        public string ToolTip { get; set; }
+        public string Value { get; set; }
+        public string ValuePath { get; }
+        object System.ICloneable.Clone();
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+    }
+    public sealed class MenuItemBinding : ICloneable, IDataSourceViewSchemaAccessor, IStateManager {
+        public MenuItemBinding();
+        public string DataMember { get; set; }
+        public int Depth { get; set; }
+        public bool Enabled { get; set; }
+        public string EnabledField { get; set; }
+        public string FormatString { get; set; }
+        public string ImageUrl { get; set; }
+        public string ImageUrlField { get; set; }
+        public string NavigateUrl { get; set; }
+        public string NavigateUrlField { get; set; }
+        public string PopOutImageUrl { get; set; }
+        public string PopOutImageUrlField { get; set; }
+        public bool Selectable { get; set; }
+        public string SelectableField { get; set; }
+        public string SeparatorImageUrl { get; set; }
+        public string SeparatorImageUrlField { get; set; }
+        object System.Web.UI.IDataSourceViewSchemaAccessor.DataSourceViewSchema { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public string Target { get; set; }
+        public string TargetField { get; set; }
+        public string Text { get; set; }
+        public string TextField { get; set; }
+        public string ToolTip { get; set; }
+        public string ToolTipField { get; set; }
+        public string Value { get; set; }
+        public string ValueField { get; set; }
+        object System.ICloneable.Clone();
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        public override string ToString();
+    }
+    public sealed class MenuItemBindingCollection : StateManagedCollection {
+        public MenuItemBinding this[int i] { get; set; }
+        public int Add(MenuItemBinding binding);
+        public bool Contains(MenuItemBinding binding);
+        public void CopyTo(MenuItemBinding[] array, int index);
+        protected override object CreateKnownType(int index);
+        protected override Type[] GetKnownTypes();
+        public int IndexOf(MenuItemBinding value);
+        public void Insert(int index, MenuItemBinding binding);
+        protected override void OnClear();
+        protected override void OnRemoveComplete(int index, object value);
+        protected override void OnValidate(object value);
+        public void Remove(MenuItemBinding binding);
+        public void RemoveAt(int index);
+        protected override void SetDirtyObject(object o);
+    }
+    public sealed class MenuItemCollection : ICollection, IEnumerable, IStateManager {
+        public MenuItemCollection();
+        public MenuItemCollection(MenuItem owner);
+        public int Count { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public MenuItem this[int index] { get; }
+        public void Add(MenuItem child);
+        public void AddAt(int index, MenuItem child);
+        public void Clear();
+        public bool Contains(MenuItem c);
+        public void CopyTo(Array array, int index);
+        public void CopyTo(MenuItem[] array, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(MenuItem value);
+        public void Remove(MenuItem value);
+        public void RemoveAt(int index);
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+    }
+    public sealed class MenuItemStyle : Style {
+        public MenuItemStyle();
+        public MenuItemStyle(StateBag bag);
+        public Unit HorizontalPadding { get; set; }
+        public Unit ItemSpacing { get; set; }
+        public Unit VerticalPadding { get; set; }
+        public override void CopyFrom(Style s);
+        protected override void FillStyleAttributes(CssStyleCollection attributes, IUrlResolutionService urlResolver);
+        public override void MergeWith(Style s);
+        public override void Reset();
+    }
+    public sealed class MenuItemStyleCollection : StateManagedCollection {
+        public MenuItemStyle this[int i] { get; set; }
+        public int Add(MenuItemStyle style);
+        public bool Contains(MenuItemStyle style);
+        public void CopyTo(MenuItemStyle[] styleArray, int index);
+        protected override object CreateKnownType(int index);
+        protected override Type[] GetKnownTypes();
+        public int IndexOf(MenuItemStyle style);
+        public void Insert(int index, MenuItemStyle style);
+        protected override void OnInsert(int index, object value);
+        public void Remove(MenuItemStyle style);
+        public void RemoveAt(int index);
+        protected override void SetDirtyObject(object o);
+    }
+    public sealed class MenuItemTemplateContainer : Control, IDataItemContainer, INamingContainer {
+        public MenuItemTemplateContainer(int itemIndex, MenuItem dataItem);
+        public object DataItem { get; set; }
+        public int ItemIndex { get; }
+        object System.Web.UI.IDataItemContainer.DataItem { get; }
+        int System.Web.UI.IDataItemContainer.DataItemIndex { get; }
+        int System.Web.UI.IDataItemContainer.DisplayIndex { get; }
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+    }
+    public enum MenuRenderingMode {
+        Default = 0,
+        List = 2,
+        Table = 1,
+    }
+    public class ModelDataMethodResult {
+        public ModelDataMethodResult(object returnValue, OrderedDictionary outputParameters);
+        public OrderedDictionary OutputParameters { get; }
+        public object ReturnValue { get; private set; }
+    }
+    public class ModelDataSource : IDataSource, IStateManager {
+        public ModelDataSource(Control dataControl);
+        public Control DataControl { get; private set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public virtual ModelDataSourceView View { get; }
+        public event CallingDataMethodsEventHandler CallingDataMethods;
+        event EventHandler System.Web.UI.IDataSource.DataSourceChanged;
+        protected virtual bool IsTrackingViewState();
+        protected virtual void LoadViewState(object savedState);
+        protected virtual object SaveViewState();
+        DataSourceView System.Web.UI.IDataSource.GetView(string viewName);
+        ICollection System.Web.UI.IDataSource.GetViewNames();
+        void System.Web.UI.IStateManager.LoadViewState(object savedState);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        protected virtual void TrackViewState();
+        public void UpdateProperties(string modelTypeName, string selectMethod);
+        public void UpdateProperties(string modelTypeName, string selectMethod, string updateMethod, string insertMethod, string deleteMethod, string dataKeyName);
+    }
+    public class ModelDataSourceMethod {
+        public ModelDataSourceMethod(object instance, MethodInfo methodInfo);
+        public object Instance { get; internal set; }
+        public MethodInfo MethodInfo { get; private set; }
+        public OrderedDictionary Parameters { get; }
+    }
+    public class ModelDataSourceView : DataSourceView, IStateManager {
+        public ModelDataSourceView(ModelDataSource owner);
+        public override bool CanDelete { get; }
+        public override bool CanInsert { get; }
+        public override bool CanPage { get; }
+        public override bool CanRetrieveTotalRowCount { get; }
+        public override bool CanSort { get; }
+        public override bool CanUpdate { get; }
+        public string DataKeyName { get; internal set; }
+        public string DeleteMethod { get; internal set; }
+        public string InsertMethod { get; internal set; }
+        public string ModelTypeName { get; internal set; }
+        public string SelectMethod { get; internal set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public string UpdateMethod { get; internal set; }
+        public event CallingDataMethodsEventHandler CallingDataMethods;
+        protected virtual IEnumerable CreateSelectResult(object result);
+        public override void Delete(IDictionary keys, IDictionary oldValues, DataSourceViewOperationCallback callback);
+        protected virtual ModelDataSourceMethod EvaluateDeleteMethodParameters(IDictionary keys, IDictionary oldValues);
+        protected virtual ModelDataSourceMethod EvaluateInsertMethodParameters(IDictionary values);
+        protected virtual void EvaluateMethodParameters(DataSourceOperation dataSourceOperation, ModelDataSourceMethod modelDataSourceMethod, IDictionary controlValues);
+        protected virtual void EvaluateMethodParameters(DataSourceOperation dataSourceOperation, ModelDataSourceMethod modelDataSourceMethod, IDictionary controlValues, bool isPageLoadComplete);
+        protected virtual ModelDataSourceMethod EvaluateSelectMethodParameters(DataSourceSelectArguments arguments, out DataSourceSelectResultProcessingOptions selectResultProcessingOptions);
+        protected virtual ModelDataSourceMethod EvaluateUpdateMethodParameters(IDictionary keys, IDictionary values, IDictionary oldValues);
+        protected override int ExecuteDelete(IDictionary keys, IDictionary oldValues);
+        protected override int ExecuteInsert(IDictionary values);
+        protected internal override IEnumerable ExecuteSelect(DataSourceSelectArguments arguments);
+        protected override int ExecuteUpdate(IDictionary keys, IDictionary values, IDictionary oldValues);
+        protected virtual ModelDataSourceMethod FindMethod(string methodName);
+        protected virtual object GetDeleteMethodResult(IDictionary keys, IDictionary oldValues);
+        protected virtual object GetInsertMethodResult(IDictionary values);
+        protected virtual object GetSelectMethodResult(DataSourceSelectArguments arguments);
+        protected virtual object GetUpdateMethodResult(IDictionary keys, IDictionary values, IDictionary oldValues);
+        public override void Insert(IDictionary values, DataSourceViewOperationCallback callback);
+        protected virtual ModelDataMethodResult InvokeMethod(ModelDataSourceMethod method);
+        protected virtual bool IsTrackingViewState();
+        protected virtual void LoadViewState(object savedState);
+        protected virtual void OnCallingDataMethods(CallingDataMethodsEventArgs e);
+        protected virtual object ProcessSelectMethodResult(DataSourceSelectArguments arguments, DataSourceSelectResultProcessingOptions selectResultProcessingOptions, ModelDataMethodResult result);
+        protected virtual object SaveViewState();
+        public override void Select(DataSourceSelectArguments arguments, DataSourceViewSelectCallback callback);
+        void System.Web.UI.IStateManager.LoadViewState(object savedState);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        protected virtual void TrackViewState();
+        public override void Update(IDictionary keys, IDictionary values, IDictionary oldValues, DataSourceViewOperationCallback callback);
+        public void UpdateProperties(string modelTypeName, string selectMethod, string updateMethod, string insertMethod, string deleteMethod, string dataKeyName);
+    }
+    public class ModelErrorMessage : Label {
+        public ModelErrorMessage();
+        public override string AssociatedControlID { get; set; }
+        public string ModelStateKey { get; set; }
+        public bool SetFocusOnError { get; set; }
+        public override string Text { get; set; }
+        protected internal override void OnPreRender(EventArgs e);
+    }
+    public class ModelMethodContext {
+        public ModelMethodContext(Page page);
+        public static ModelMethodContext Current { get; }
+        public ModelStateDictionary ModelState { get; }
+        public virtual bool TryUpdateModel<TModel>(TModel model) where TModel : class;
+        public virtual bool TryUpdateModel<TModel>(TModel model, IValueProvider valueProvider) where TModel : class;
+        public virtual void UpdateModel<TModel>(TModel model) where TModel : class;
+        public virtual void UpdateModel<TModel>(TModel model, IValueProvider valueProvider) where TModel : class;
+    }
+    public class MonthChangedEventArgs {
+        public MonthChangedEventArgs(DateTime newDate, DateTime previousDate);
+        public DateTime NewDate { get; }
+        public DateTime PreviousDate { get; }
+    }
+    public delegate void MonthChangedEventHandler(object sender, MonthChangedEventArgs e);
+    public class MultiView : Control {
+        public static readonly string NextViewCommandName;
+        public static readonly string PreviousViewCommandName;
+        public static readonly string SwitchViewByIDCommandName;
+        public static readonly string SwitchViewByIndexCommandName;
+        public MultiView();
+        public virtual int ActiveViewIndex { get; set; }
+        public override bool EnableTheming { get; set; }
+        public virtual ViewCollection Views { get; }
+        public event EventHandler ActiveViewChanged;
+        protected override void AddParsedSubObject(object obj);
+        protected override ControlCollection CreateControlCollection();
+        public View GetActiveView();
+        protected internal override void LoadControlState(object state);
+        protected virtual void OnActiveViewChanged(EventArgs e);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void RemovedControl(Control ctl);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected internal override object SaveControlState();
+        public void SetActiveView(View view);
+    }
+    public class MultiViewControlBuilder : ControlBuilder {
+        public MultiViewControlBuilder();
+        public override void AppendSubBuilder(ControlBuilder subBuilder);
+    }
+    public enum NextPrevFormat {
+        CustomText = 0,
+        FullMonth = 2,
+        ShortMonth = 1,
+    }
+    public class NextPreviousPagerField : DataPagerField {
+        public NextPreviousPagerField();
+        public string ButtonCssClass { get; set; }
+        public ButtonType ButtonType { get; set; }
+        public string FirstPageImageUrl { get; set; }
+        public string FirstPageText { get; set; }
+        public string LastPageImageUrl { get; set; }
+        public string LastPageText { get; set; }
+        public string NextPageImageUrl { get; set; }
+        public string NextPageText { get; set; }
+        public string PreviousPageImageUrl { get; set; }
+        public string PreviousPageText { get; set; }
+        public bool RenderDisabledButtonsAsLabels { get; set; }
+        public bool RenderNonBreakingSpacesBetweenControls { get; set; }
+        public bool ShowFirstPageButton { get; set; }
+        public bool ShowLastPageButton { get; set; }
+        public bool ShowNextPageButton { get; set; }
+        public bool ShowPreviousPageButton { get; set; }
+        protected override void CopyProperties(DataPagerField newField);
+        public override void CreateDataPagers(DataPagerFieldItem container, int startRowIndex, int maximumRows, int totalRowCount, int fieldIndex);
+        protected override DataPagerField CreateField();
+        public override bool Equals(object o);
+        public override int GetHashCode();
+        public override void HandleEvent(CommandEventArgs e);
+    }
+    public class NumericPagerField : DataPagerField {
+        public NumericPagerField();
+        public int ButtonCount { get; set; }
+        public ButtonType ButtonType { get; set; }
+        public string CurrentPageLabelCssClass { get; set; }
+        public string NextPageImageUrl { get; set; }
+        public string NextPageText { get; set; }
+        public string NextPreviousButtonCssClass { get; set; }
+        public string NumericButtonCssClass { get; set; }
+        public string PreviousPageImageUrl { get; set; }
+        public string PreviousPageText { get; set; }
+        public bool RenderNonBreakingSpacesBetweenControls { get; set; }
+        protected override void CopyProperties(DataPagerField newField);
+        public override void CreateDataPagers(DataPagerFieldItem container, int startRowIndex, int maximumRows, int totalRowCount, int fieldIndex);
+        protected override DataPagerField CreateField();
+        public override bool Equals(object o);
+        public override int GetHashCode();
+        public override void HandleEvent(CommandEventArgs e);
+    }
+    public class ObjectDataSource : DataSourceControl {
+        public ObjectDataSource();
+        public ObjectDataSource(string typeName, string selectMethod);
+        public virtual int CacheDuration { get; set; }
+        public virtual DataSourceCacheExpiry CacheExpirationPolicy { get; set; }
+        public virtual string CacheKeyDependency { get; set; }
+        public ConflictOptions ConflictDetection { get; set; }
+        public bool ConvertNullToDBNull { get; set; }
+        public string DataObjectTypeName { get; set; }
+        public string DeleteMethod { get; set; }
+        public ParameterCollection DeleteParameters { get; }
+        public virtual bool EnableCaching { get; set; }
+        public bool EnablePaging { get; set; }
+        public string FilterExpression { get; set; }
+        public ParameterCollection FilterParameters { get; }
+        public string InsertMethod { get; set; }
+        public ParameterCollection InsertParameters { get; }
+        public string MaximumRowsParameterName { get; set; }
+        public string OldValuesParameterFormatString { get; set; }
+        public ParsingCulture ParsingCulture { get; set; }
+        public string SelectCountMethod { get; set; }
+        public string SelectMethod { get; set; }
+        public ParameterCollection SelectParameters { get; }
+        public string SortParameterName { get; set; }
+        public virtual string SqlCacheDependency { get; set; }
+        public string StartRowIndexParameterName { get; set; }
+        public string TypeName { get; set; }
+        public string UpdateMethod { get; set; }
+        public ParameterCollection UpdateParameters { get; }
+        public event ObjectDataSourceStatusEventHandler Deleted;
+        public event ObjectDataSourceMethodEventHandler Deleting;
+        public event ObjectDataSourceFilteringEventHandler Filtering;
+        public event ObjectDataSourceStatusEventHandler Inserted;
+        public event ObjectDataSourceMethodEventHandler Inserting;
+        public event ObjectDataSourceObjectEventHandler ObjectCreated;
+        public event ObjectDataSourceObjectEventHandler ObjectCreating;
+        public event ObjectDataSourceDisposingEventHandler ObjectDisposing;
+        public event ObjectDataSourceStatusEventHandler Selected;
+        public event ObjectDataSourceSelectingEventHandler Selecting;
+        public event ObjectDataSourceStatusEventHandler Updated;
+        public event ObjectDataSourceMethodEventHandler Updating;
+        public int Delete();
+        protected override DataSourceView GetView(string viewName);
+        protected override ICollection GetViewNames();
+        public int Insert();
+        protected override void LoadViewState(object savedState);
+        protected internal override void OnInit(EventArgs e);
+        protected override object SaveViewState();
+        public IEnumerable Select();
+        protected override void TrackViewState();
+        public int Update();
+    }
+    public class ObjectDataSourceDisposingEventArgs : CancelEventArgs {
+        public ObjectDataSourceDisposingEventArgs(object objectInstance);
+        public object ObjectInstance { get; }
+    }
+    public delegate void ObjectDataSourceDisposingEventHandler(object sender, ObjectDataSourceDisposingEventArgs e);
+    public class ObjectDataSourceEventArgs : EventArgs {
+        public ObjectDataSourceEventArgs(object objectInstance);
+        public object ObjectInstance { get; set; }
+    }
+    public class ObjectDataSourceFilteringEventArgs : CancelEventArgs {
+        public ObjectDataSourceFilteringEventArgs(IOrderedDictionary parameterValues);
+        public IOrderedDictionary ParameterValues { get; }
+    }
+    public delegate void ObjectDataSourceFilteringEventHandler(object sender, ObjectDataSourceFilteringEventArgs e);
+    public class ObjectDataSourceMethodEventArgs : CancelEventArgs {
+        public ObjectDataSourceMethodEventArgs(IOrderedDictionary inputParameters);
+        public IOrderedDictionary InputParameters { get; }
+    }
+    public delegate void ObjectDataSourceMethodEventHandler(object sender, ObjectDataSourceMethodEventArgs e);
+    public delegate void ObjectDataSourceObjectEventHandler(object sender, ObjectDataSourceEventArgs e);
+    public class ObjectDataSourceSelectingEventArgs : ObjectDataSourceMethodEventArgs {
+        public ObjectDataSourceSelectingEventArgs(IOrderedDictionary inputParameters, DataSourceSelectArguments arguments, bool executingSelectCount);
+        public DataSourceSelectArguments Arguments { get; }
+        public bool ExecutingSelectCount { get; }
+    }
+    public delegate void ObjectDataSourceSelectingEventHandler(object sender, ObjectDataSourceSelectingEventArgs e);
+    public class ObjectDataSourceStatusEventArgs : EventArgs {
+        public ObjectDataSourceStatusEventArgs(object returnValue, IDictionary outputParameters);
+        public ObjectDataSourceStatusEventArgs(object returnValue, IDictionary outputParameters, Exception exception);
+        public int AffectedRows { get; set; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+        public IDictionary OutputParameters { get; }
+        public object ReturnValue { get; }
+    }
+    public delegate void ObjectDataSourceStatusEventHandler(object sender, ObjectDataSourceStatusEventArgs e);
+    public class ObjectDataSourceView : DataSourceView, IStateManager {
+        public ObjectDataSourceView(ObjectDataSource owner, string name, HttpContext context);
+        public override bool CanDelete { get; }
+        public override bool CanInsert { get; }
+        public override bool CanPage { get; }
+        public override bool CanRetrieveTotalRowCount { get; }
+        public override bool CanSort { get; }
+        public override bool CanUpdate { get; }
+        public ConflictOptions ConflictDetection { get; set; }
+        public bool ConvertNullToDBNull { get; set; }
+        public string DataObjectTypeName { get; set; }
+        public string DeleteMethod { get; set; }
+        public ParameterCollection DeleteParameters { get; }
+        public bool EnablePaging { get; set; }
+        public string FilterExpression { get; set; }
+        public ParameterCollection FilterParameters { get; }
+        public string InsertMethod { get; set; }
+        public ParameterCollection InsertParameters { get; }
+        protected bool IsTrackingViewState { get; }
+        public string MaximumRowsParameterName { get; set; }
+        public string OldValuesParameterFormatString { get; set; }
+        public ParsingCulture ParsingCulture { get; set; }
+        public string SelectCountMethod { get; set; }
+        public string SelectMethod { get; set; }
+        public ParameterCollection SelectParameters { get; }
+        public string SortParameterName { get; set; }
+        public string StartRowIndexParameterName { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public string TypeName { get; set; }
+        public string UpdateMethod { get; set; }
+        public ParameterCollection UpdateParameters { get; }
+        public event ObjectDataSourceStatusEventHandler Deleted;
+        public event ObjectDataSourceMethodEventHandler Deleting;
+        public event ObjectDataSourceFilteringEventHandler Filtering;
+        public event ObjectDataSourceStatusEventHandler Inserted;
+        public event ObjectDataSourceMethodEventHandler Inserting;
+        public event ObjectDataSourceObjectEventHandler ObjectCreated;
+        public event ObjectDataSourceObjectEventHandler ObjectCreating;
+        public event ObjectDataSourceDisposingEventHandler ObjectDisposing;
+        public event ObjectDataSourceStatusEventHandler Selected;
+        public event ObjectDataSourceSelectingEventHandler Selecting;
+        public event ObjectDataSourceStatusEventHandler Updated;
+        public event ObjectDataSourceMethodEventHandler Updating;
+        public int Delete(IDictionary keys, IDictionary oldValues);
+        protected override int ExecuteDelete(IDictionary keys, IDictionary oldValues);
+        protected override int ExecuteInsert(IDictionary values);
+        protected internal override IEnumerable ExecuteSelect(DataSourceSelectArguments arguments);
+        protected override int ExecuteUpdate(IDictionary keys, IDictionary values, IDictionary oldValues);
+        public int Insert(IDictionary values);
+        protected virtual void LoadViewState(object savedState);
+        protected virtual void OnDeleted(ObjectDataSourceStatusEventArgs e);
+        protected virtual void OnDeleting(ObjectDataSourceMethodEventArgs e);
+        protected virtual void OnFiltering(ObjectDataSourceFilteringEventArgs e);
+        protected virtual void OnInserted(ObjectDataSourceStatusEventArgs e);
+        protected virtual void OnInserting(ObjectDataSourceMethodEventArgs e);
+        protected virtual void OnObjectCreated(ObjectDataSourceEventArgs e);
+        protected virtual void OnObjectCreating(ObjectDataSourceEventArgs e);
+        protected virtual void OnObjectDisposing(ObjectDataSourceDisposingEventArgs e);
+        protected virtual void OnSelected(ObjectDataSourceStatusEventArgs e);
+        protected virtual void OnSelecting(ObjectDataSourceSelectingEventArgs e);
+        protected virtual void OnUpdated(ObjectDataSourceStatusEventArgs e);
+        protected virtual void OnUpdating(ObjectDataSourceMethodEventArgs e);
+        protected virtual object SaveViewState();
+        public IEnumerable Select(DataSourceSelectArguments arguments);
+        void System.Web.UI.IStateManager.LoadViewState(object savedState);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        protected virtual void TrackViewState();
+        public int Update(IDictionary keys, IDictionary values, IDictionary oldValues);
+    }
+    public enum Orientation {
+        Horizontal = 0,
+        Vertical = 1,
+    }
+    public sealed class PagedDataSource : ICollection, IEnumerable, ITypedList {
+        public PagedDataSource();
+        public bool AllowCustomPaging { get; set; }
+        public bool AllowPaging { get; set; }
+        public bool AllowServerPaging { get; set; }
+        public int Count { get; }
+        public int CurrentPageIndex { get; set; }
+        public IEnumerable DataSource { get; set; }
+        public int DataSourceCount { get; }
+        public int FirstIndexInPage { get; }
+        public bool IsCustomPagingEnabled { get; }
+        public bool IsFirstPage { get; }
+        public bool IsLastPage { get; }
+        public bool IsPagingEnabled { get; }
+        public bool IsReadOnly { get; }
+        public bool IsServerPagingEnabled { get; }
+        public bool IsSynchronized { get; }
+        public int PageCount { get; }
+        public int PageSize { get; set; }
+        public object SyncRoot { get; }
+        public int VirtualCount { get; set; }
+        public void CopyTo(Array array, int index);
+        public IEnumerator GetEnumerator();
+        public PropertyDescriptorCollection GetItemProperties(PropertyDescriptor[] listAccessors);
+        public string GetListName(PropertyDescriptor[] listAccessors);
+    }
+    public class PageEventArgs : EventArgs {
+        public PageEventArgs(int startRowIndex, int maximumRows, int totalRowCount);
+        public int MaximumRows { get; }
+        public int StartRowIndex { get; }
+        public int TotalRowCount { get; }
+    }
+    public class PagePropertiesChangingEventArgs : EventArgs {
+        public PagePropertiesChangingEventArgs(int startRowIndex, int maximumRows);
+        public int MaximumRows { get; }
+        public int StartRowIndex { get; }
+    }
+    public enum PagerButtons {
+        NextPrevious = 0,
+        NextPreviousFirstLast = 2,
+        Numeric = 1,
+        NumericFirstLast = 3,
+    }
+    public enum PagerMode {
+        NextPrev = 0,
+        NumericPages = 1,
+    }
+    public enum PagerPosition {
+        Bottom = 0,
+        Top = 1,
+        TopAndBottom = 2,
+    }
+    public sealed class PagerSettings : IStateManager {
+        public PagerSettings();
+        public string FirstPageImageUrl { get; set; }
+        public string FirstPageText { get; set; }
+        public string LastPageImageUrl { get; set; }
+        public string LastPageText { get; set; }
+        public PagerButtons Mode { get; set; }
+        public string NextPageImageUrl { get; set; }
+        public string NextPageText { get; set; }
+        public int PageButtonCount { get; set; }
+        public PagerPosition Position { get; set; }
+        public string PreviousPageImageUrl { get; set; }
+        public string PreviousPageText { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public bool Visible { get; set; }
+        public event EventHandler PropertyChanged;
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        public override string ToString();
+    }
+    public class Panel : WebControl {
+        public Panel();
+        public virtual string BackImageUrl { get; set; }
+        public virtual string DefaultButton { get; set; }
+        public virtual ContentDirection Direction { get; set; }
+        public virtual string GroupingText { get; set; }
+        public virtual HorizontalAlign HorizontalAlign { get; set; }
+        public virtual ScrollBars ScrollBars { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        public virtual bool Wrap { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override Style CreateControlStyle();
+        public override void RenderBeginTag(HtmlTextWriter writer);
+        public override void RenderEndTag(HtmlTextWriter writer);
+    }
+    public class PanelStyle : Style {
+        public PanelStyle(StateBag bag);
+        public virtual string BackImageUrl { get; set; }
+        public virtual ContentDirection Direction { get; set; }
+        public virtual HorizontalAlign HorizontalAlign { get; set; }
+        public virtual ScrollBars ScrollBars { get; set; }
+        public virtual bool Wrap { get; set; }
+        public override void CopyFrom(Style s);
+        public override void MergeWith(Style s);
+        public override void Reset();
+    }
+    public class Parameter : ICloneable, IStateManager {
+        public Parameter();
+        public Parameter(string name);
+        public Parameter(string name, DbType dbType);
+        public Parameter(string name, DbType dbType, string defaultValue);
+        public Parameter(string name, TypeCode type);
+        public Parameter(string name, TypeCode type, string defaultValue);
+        protected Parameter(Parameter original);
+        public bool ConvertEmptyStringToNull { get; set; }
+        public DbType DbType { get; set; }
+        public string DefaultValue { get; set; }
+        public ParameterDirection Direction { get; set; }
+        protected bool IsTrackingViewState { get; }
+        public string Name { get; set; }
+        public int Size { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public TypeCode Type { get; set; }
+        protected StateBag ViewState { get; }
+        protected virtual Parameter Clone();
+        public static TypeCode ConvertDbTypeToTypeCode(DbType dbType);
+        public static DbType ConvertTypeCodeToDbType(TypeCode typeCode);
+        protected internal virtual object Evaluate(HttpContext context, Control control);
+        public DbType GetDatabaseType();
+        protected virtual void LoadViewState(object savedState);
+        protected void OnParameterChanged();
+        protected virtual object SaveViewState();
+        protected internal virtual void SetDirty();
+        object System.ICloneable.Clone();
+        void System.Web.UI.IStateManager.LoadViewState(object savedState);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        public override string ToString();
+        protected virtual void TrackViewState();
+    }
+    public class ParameterCollection : StateManagedCollection {
+        public ParameterCollection();
+        public Parameter this[int index] { get; set; }
+        public Parameter this[string name] { get; set; }
+        public event EventHandler ParametersChanged;
+        public int Add(string name, DbType dbType, string value);
+        public int Add(string name, string value);
+        public int Add(string name, TypeCode type, string value);
+        public int Add(Parameter parameter);
+        public bool Contains(Parameter parameter);
+        public void CopyTo(Parameter[] parameterArray, int index);
+        protected override object CreateKnownType(int index);
+        protected override Type[] GetKnownTypes();
+        public IOrderedDictionary GetValues(HttpContext context, Control control);
+        public int IndexOf(Parameter parameter);
+        public void Insert(int index, Parameter parameter);
+        protected override void OnClearComplete();
+        protected override void OnInsert(int index, object value);
+        protected override void OnInsertComplete(int index, object value);
+        protected virtual void OnParametersChanged(EventArgs e);
+        protected override void OnRemoveComplete(int index, object value);
+        protected override void OnValidate(object o);
+        public void Remove(Parameter parameter);
+        public void RemoveAt(int index);
+        protected override void SetDirtyObject(object o);
+        public void UpdateValues(HttpContext context, Control control);
+    }
+    public enum ParsingCulture {
+        Current = 1,
+        Invariant = 0,
+    }
+    public class PasswordRecovery : CompositeControl, IBorderPaddingControl, IRenderOuterTableControl {
+        public static readonly string SubmitButtonCommandName;
+        public PasswordRecovery();
+        public virtual string Answer { get; }
+        public virtual string AnswerLabelText { get; set; }
+        public virtual string AnswerRequiredErrorMessage { get; set; }
+        public virtual int BorderPadding { get; set; }
+        public TableItemStyle FailureTextStyle { get; }
+        public virtual string GeneralFailureText { get; set; }
+        public virtual string HelpPageIconUrl { get; set; }
+        public virtual string HelpPageText { get; set; }
+        public virtual string HelpPageUrl { get; set; }
+        public TableItemStyle HyperLinkStyle { get; }
+        public TableItemStyle InstructionTextStyle { get; }
+        public TableItemStyle LabelStyle { get; }
+        public MailDefinition MailDefinition { get; }
+        public virtual string MembershipProvider { get; set; }
+        public virtual string Question { get; private set; }
+        public virtual string QuestionFailureText { get; set; }
+        public virtual string QuestionInstructionText { get; set; }
+        public virtual string QuestionLabelText { get; set; }
+        public virtual ITemplate QuestionTemplate { get; set; }
+        public Control QuestionTemplateContainer { get; }
+        public virtual string QuestionTitleText { get; set; }
+        public virtual bool RenderOuterTable { get; set; }
+        public virtual string SubmitButtonImageUrl { get; set; }
+        public Style SubmitButtonStyle { get; }
+        public virtual string SubmitButtonText { get; set; }
+        public virtual ButtonType SubmitButtonType { get; set; }
+        public virtual string SuccessPageUrl { get; set; }
+        public virtual ITemplate SuccessTemplate { get; set; }
+        public Control SuccessTemplateContainer { get; }
+        public virtual string SuccessText { get; set; }
+        public TableItemStyle SuccessTextStyle { get; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public Style TextBoxStyle { get; }
+        public virtual LoginTextLayout TextLayout { get; set; }
+        public TableItemStyle TitleTextStyle { get; }
+        public virtual string UserName { get; set; }
+        public virtual string UserNameFailureText { get; set; }
+        public virtual string UserNameInstructionText { get; set; }
+        public virtual string UserNameLabelText { get; set; }
+        public virtual string UserNameRequiredErrorMessage { get; set; }
+        public virtual ITemplate UserNameTemplate { get; set; }
+        public Control UserNameTemplateContainer { get; }
+        public virtual string UserNameTitleText { get; set; }
+        public Style ValidatorTextStyle { get; }
+        public event EventHandler AnswerLookupError;
+        public event MailMessageEventHandler SendingMail;
+        public event SendMailErrorEventHandler SendMailError;
+        public event EventHandler UserLookupError;
+        public event LoginCancelEventHandler VerifyingAnswer;
+        public event LoginCancelEventHandler VerifyingUser;
+        protected internal override void CreateChildControls();
+        protected internal override void LoadControlState(object savedState);
+        protected override void LoadViewState(object savedState);
+        protected virtual void OnAnswerLookupError(EventArgs e);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void OnSendingMail(MailMessageEventArgs e);
+        protected virtual void OnSendMailError(SendMailErrorEventArgs e);
+        protected virtual void OnUserLookupError(EventArgs e);
+        protected virtual void OnVerifyingAnswer(LoginCancelEventArgs e);
+        protected virtual void OnVerifyingUser(LoginCancelEventArgs e);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected internal override object SaveControlState();
+        protected override object SaveViewState();
+        protected override void SetDesignModeState(IDictionary data);
+        protected override void TrackViewState();
+    }
+    public enum PathDirection {
+        CurrentToRoot = 1,
+        RootToCurrent = 0,
+    }
+    public class PlaceHolder : Control {
+        public PlaceHolder();
+        public override bool EnableTheming { get; set; }
+    }
+    public class PlaceHolderControlBuilder : ControlBuilder {
+        public PlaceHolderControlBuilder();
+        public override bool AllowWhitespaceLiterals();
+    }
+    public sealed class PolygonHotSpot : HotSpot {
+        public PolygonHotSpot();
+        public string Coordinates { get; set; }
+        protected internal override string MarkupName { get; }
+        public override string GetCoordinates();
+    }
+    public class ProfileParameter : Parameter {
+        public ProfileParameter();
+        public ProfileParameter(string name, DbType dbType, string propertyName);
+        public ProfileParameter(string name, string propertyName);
+        public ProfileParameter(string name, TypeCode type, string propertyName);
+        protected ProfileParameter(ProfileParameter original);
+        public string PropertyName { get; set; }
+        protected override Parameter Clone();
+        protected internal override object Evaluate(HttpContext context, Control control);
+    }
+    public abstract class QueryableDataSource : DataSourceControl, IDataSource, IQueryableDataSource {
+        protected QueryableDataSource();
+        public event EventHandler<QueryCreatedEventArgs> QueryCreated;
+        protected abstract QueryableDataSourceView CreateQueryableView();
+        protected override DataSourceView GetView(string viewName);
+        protected override ICollection GetViewNames();
+        protected override void LoadViewState(object savedState);
+        protected internal override void OnInit(EventArgs e);
+        public void RaiseViewChanged();
+        protected override object SaveViewState();
+        protected override void TrackViewState();
+        protected virtual void UpdateParameterVales();
+    }
+    public class QueryableDataSourceEditData {
+        public QueryableDataSourceEditData();
+        public object NewDataObject { get; set; }
+        public object OriginalDataObject { get; set; }
+    }
+    public abstract class QueryableDataSourceView : DataSourceView, IStateManager {
+        protected static readonly object EventSelected;
+        protected static readonly object EventSelecting;
+        protected QueryableDataSourceView(DataSourceControl owner, string viewName, HttpContext context);
+        public bool AutoGenerateOrderByClause { get; set; }
+        public bool AutoGenerateWhereClause { get; set; }
+        public virtual bool AutoPage { get; set; }
+        public virtual bool AutoSort { get; set; }
+        public override bool CanDelete { get; }
+        public override bool CanInsert { get; }
+        public override bool CanPage { get; }
+        public override bool CanRetrieveTotalRowCount { get; }
+        public override bool CanSort { get; }
+        public override bool CanUpdate { get; }
+        public virtual ParameterCollection DeleteParameters { get; }
+        protected abstract Type EntityType { get; }
+        public virtual string GroupBy { get; set; }
+        public virtual ParameterCollection GroupByParameters { get; }
+        public virtual ParameterCollection InsertParameters { get; }
+        protected bool IsTrackingViewState { get; }
+        public virtual string OrderBy { get; set; }
+        public virtual ParameterCollection OrderByParameters { get; }
+        public virtual string OrderGroupsBy { get; set; }
+        public virtual ParameterCollection OrderGroupsByParameters { get; }
+        public virtual string SelectNew { get; set; }
+        public virtual ParameterCollection SelectNewParameters { get; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public virtual ParameterCollection UpdateParameters { get; }
+        public virtual string Where { get; set; }
+        public virtual ParameterCollection WhereParameters { get; }
+        public event EventHandler<QueryCreatedEventArgs> QueryCreated;
+        protected QueryableDataSourceEditData BuildDeleteObject(IDictionary keys, IDictionary oldValues, IDictionary<string, Exception> validationErrors);
+        protected QueryableDataSourceEditData BuildInsertObject(IDictionary values, IDictionary<string, Exception> validationErrors);
+        protected virtual IQueryable BuildQuery(DataSourceSelectArguments arguments);
+        protected QueryableDataSourceEditData BuildUpdateObjects(IDictionary keys, IDictionary values, IDictionary oldValues, IDictionary<string, Exception> validationErrors);
+        protected void ClearOriginalValues();
+        protected QueryContext CreateQueryContext(DataSourceSelectArguments arguments);
+        public int Delete(IDictionary keys, IDictionary oldValues);
+        protected virtual int DeleteObject(object oldEntity);
+        protected override int ExecuteDelete(IDictionary keys, IDictionary oldValues);
+        protected override int ExecuteInsert(IDictionary values);
+        protected IQueryable ExecutePaging(IQueryable source, QueryContext context);
+        protected virtual IQueryable ExecuteQuery(IQueryable source, QueryContext context);
+        protected IQueryable ExecuteQueryExpressions(IQueryable source, QueryContext context);
+        protected internal override IEnumerable ExecuteSelect(DataSourceSelectArguments arguments);
+        protected IQueryable ExecuteSorting(IQueryable source, QueryContext context);
+        protected override int ExecuteUpdate(IDictionary keys, IDictionary values, IDictionary oldValues);
+        protected virtual IDictionary GetOriginalValues(IDictionary keys);
+        protected abstract object GetSource(QueryContext context);
+        protected abstract void HandleValidationErrors(IDictionary<string, Exception> errors, DataSourceOperation operation);
+        public int Insert(IDictionary values);
+        protected virtual int InsertObject(object newEntity);
+        protected virtual void LoadViewState(object savedState);
+        protected virtual void OnQueryCreated(QueryCreatedEventArgs e);
+        protected void OnQueryParametersChanged(object sender, EventArgs e);
+        public void RaiseViewChanged();
+        protected virtual object SaveViewState();
+        protected virtual void StoreOriginalValues(IList results);
+        protected void StoreOriginalValues(IList results, Func<PropertyDescriptor, bool> include);
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        protected virtual void TrackViewState();
+        public int Update(IDictionary keys, IDictionary values, IDictionary oldValues);
+        protected virtual int UpdateObject(object oldEntity, object newEntity);
+    }
+    public class QueryContext {
+        public QueryContext(IDictionary<string, object> whereParameters, IDictionary<string, object> orderGroupsByParameters, IOrderedDictionary orderByParameters, IDictionary<string, object> groupByParameters, IDictionary<string, object> selectParameters, DataSourceSelectArguments arguments);
+        public DataSourceSelectArguments Arguments { get; private set; }
+        public IDictionary<string, object> GroupByParameters { get; private set; }
+        public IOrderedDictionary OrderByParameters { get; private set; }
+        public IDictionary<string, object> OrderGroupsByParameters { get; private set; }
+        public IDictionary<string, object> SelectParameters { get; private set; }
+        public IDictionary<string, object> WhereParameters { get; private set; }
+    }
+    public class QueryCreatedEventArgs : EventArgs {
+        public QueryCreatedEventArgs(IQueryable query);
+        public IQueryable Query { get; set; }
+    }
+    public class QueryExtender : Control {
+        public QueryExtender();
+        public virtual IQueryableDataSource DataSource { get; }
+        public DataSourceExpressionCollection Expressions { get; }
+        public virtual string TargetControlID { get; set; }
+        protected override void LoadViewState(object savedState);
+        protected internal override void OnInit(EventArgs e);
+        protected override object SaveViewState();
+        protected override void TrackViewState();
+    }
+    public static class QueryExtensions {
+        public static IQueryable<T> SortBy<T>(this IQueryable<T> source, string sortExpression) where T : class;
+    }
+    public class QueryStringParameter : Parameter {
+        public QueryStringParameter();
+        public QueryStringParameter(string name, DbType dbType, string queryStringField);
+        public QueryStringParameter(string name, string queryStringField);
+        public QueryStringParameter(string name, TypeCode type, string queryStringField);
+        protected QueryStringParameter(QueryStringParameter original);
+        public string QueryStringField { get; set; }
+        public bool ValidateInput { get; set; }
+        protected override Parameter Clone();
+        protected internal override object Evaluate(HttpContext context, Control control);
+    }
+    public class RadioButton : CheckBox, IPostBackDataHandler {
+        public RadioButton();
+        public virtual string GroupName { get; set; }
+        protected override bool LoadPostData(string postDataKey, NameValueCollection postCollection);
+        protected internal override void OnPreRender(EventArgs e);
+        protected override void RaisePostDataChangedEvent();
+        bool System.Web.UI.IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection);
+        void System.Web.UI.IPostBackDataHandler.RaisePostDataChangedEvent();
+    }
+    public class RadioButtonList : ListControl, INamingContainer, IPostBackDataHandler, IRepeatInfoUser {
+        public RadioButtonList();
+        public virtual int CellPadding { get; set; }
+        public virtual int CellSpacing { get; set; }
+        protected virtual bool HasFooter { get; }
+        protected virtual bool HasHeader { get; }
+        protected virtual bool HasSeparators { get; }
+        public virtual bool RenderWhenDataEmpty { get; set; }
+        public virtual int RepeatColumns { get; set; }
+        public virtual RepeatDirection RepeatDirection { get; set; }
+        protected virtual int RepeatedItemCount { get; }
+        public virtual RepeatLayout RepeatLayout { get; set; }
+        bool System.Web.UI.WebControls.IRepeatInfoUser.HasFooter { get; }
+        bool System.Web.UI.WebControls.IRepeatInfoUser.HasHeader { get; }
+        bool System.Web.UI.WebControls.IRepeatInfoUser.HasSeparators { get; }
+        int System.Web.UI.WebControls.IRepeatInfoUser.RepeatedItemCount { get; }
+        public virtual TextAlign TextAlign { get; set; }
+        protected override Style CreateControlStyle();
+        protected override Control FindControl(string id, int pathOffset);
+        protected virtual Style GetItemStyle(ListItemType itemType, int repeatIndex);
+        protected virtual bool LoadPostData(string postDataKey, NameValueCollection postCollection);
+        protected internal override void OnInit(EventArgs e);
+        protected virtual void RaisePostDataChangedEvent();
+        protected internal override void Render(HtmlTextWriter writer);
+        protected virtual void RenderItem(ListItemType itemType, int repeatIndex, RepeatInfo repeatInfo, HtmlTextWriter writer);
+        bool System.Web.UI.IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection);
+        void System.Web.UI.IPostBackDataHandler.RaisePostDataChangedEvent();
+        Style System.Web.UI.WebControls.IRepeatInfoUser.GetItemStyle(ListItemType itemType, int repeatIndex);
+        void System.Web.UI.WebControls.IRepeatInfoUser.RenderItem(ListItemType itemType, int repeatIndex, RepeatInfo repeatInfo, HtmlTextWriter writer);
+    }
+    public class RangeValidator : BaseCompareValidator {
+        public RangeValidator();
+        public string MaximumValue { get; set; }
+        public string MinimumValue { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override bool ControlPropertiesValid();
+        protected override bool EvaluateIsValid();
+    }
+    public sealed class RectangleHotSpot : HotSpot {
+        public RectangleHotSpot();
+        public int Bottom { get; set; }
+        public int Left { get; set; }
+        protected internal override string MarkupName { get; }
+        public int Right { get; set; }
+        public int Top { get; set; }
+        public override string GetCoordinates();
+    }
+    public class RegularExpressionValidator : BaseValidator {
+        public RegularExpressionValidator();
+        public Nullable<int> MatchTimeout { get; set; }
+        public string ValidationExpression { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override bool EvaluateIsValid();
+    }
+    public enum RepeatDirection {
+        Horizontal = 0,
+        Vertical = 1,
+    }
+    public class Repeater : Control, INamingContainer {
+        public Repeater();
+        public virtual ITemplate AlternatingItemTemplate { get; set; }
+        public override ControlCollection Controls { get; }
+        public virtual string DataMember { get; set; }
+        public virtual object DataSource { get; set; }
+        public virtual string DataSourceID { get; set; }
+        public override bool EnableTheming { get; set; }
+        public virtual ITemplate FooterTemplate { get; set; }
+        public virtual ITemplate HeaderTemplate { get; set; }
+        protected bool Initialized { get; }
+        protected bool IsBoundUsingDataSourceID { get; }
+        protected bool IsDataBindingAutomatic { get; }
+        public virtual RepeaterItemCollection Items { get; }
+        public virtual ITemplate ItemTemplate { get; set; }
+        public virtual string ItemType { get; set; }
+        protected bool RequiresDataBinding { get; set; }
+        protected DataSourceSelectArguments SelectArguments { get; }
+        public virtual string SelectMethod { get; set; }
+        public virtual ITemplate SeparatorTemplate { get; set; }
+        public event CallingDataMethodsEventHandler CallingDataMethods;
+        public event CreatingModelDataSourceEventHandler CreatingModelDataSource;
+        public event RepeaterCommandEventHandler ItemCommand;
+        public event RepeaterItemEventHandler ItemCreated;
+        public event RepeaterItemEventHandler ItemDataBound;
+        protected internal override void CreateChildControls();
+        protected virtual void CreateControlHierarchy(bool useDataSource);
+        protected virtual DataSourceSelectArguments CreateDataSourceSelectArguments();
+        protected virtual RepeaterItem CreateItem(int itemIndex, ListItemType itemType);
+        public override void DataBind();
+        protected void EnsureDataBound();
+        protected virtual IEnumerable GetData();
+        protected virtual void InitializeItem(RepeaterItem item);
+        protected override void LoadViewState(object savedState);
+        protected override bool OnBubbleEvent(object sender, EventArgs e);
+        protected virtual void OnCreatingModelDataSource(CreatingModelDataSourceEventArgs e);
+        protected override void OnDataBinding(EventArgs e);
+        protected virtual void OnDataPropertyChanged();
+        protected virtual void OnDataSourceViewChanged(object sender, EventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected virtual void OnItemCommand(RepeaterCommandEventArgs e);
+        protected virtual void OnItemCreated(RepeaterItemEventArgs e);
+        protected virtual void OnItemDataBound(RepeaterItemEventArgs e);
+        protected internal override void OnLoad(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected override object SaveViewState();
+        protected override void TrackViewState();
+    }
+    public class RepeaterCommandEventArgs : CommandEventArgs {
+        public RepeaterCommandEventArgs(RepeaterItem item, object commandSource, CommandEventArgs originalArgs);
+        public object CommandSource { get; }
+        public RepeaterItem Item { get; }
+    }
+    public delegate void RepeaterCommandEventHandler(object source, RepeaterCommandEventArgs e);
+    public class RepeaterItem : Control, IDataItemContainer, INamingContainer {
+        public RepeaterItem(int itemIndex, ListItemType itemType);
+        public virtual object DataItem { get; set; }
+        public virtual int ItemIndex { get; }
+        public virtual ListItemType ItemType { get; }
+        int System.Web.UI.IDataItemContainer.DataItemIndex { get; }
+        int System.Web.UI.IDataItemContainer.DisplayIndex { get; }
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+    }
+    public sealed class RepeaterItemCollection : ICollection, IEnumerable {
+        public RepeaterItemCollection(ArrayList items);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        public RepeaterItem this[int index] { get; }
+        public void CopyTo(Array array, int index);
+        public IEnumerator GetEnumerator();
+    }
+    public class RepeaterItemEventArgs : EventArgs {
+        public RepeaterItemEventArgs(RepeaterItem item);
+        public RepeaterItem Item { get; }
+    }
+    public delegate void RepeaterItemEventHandler(object sender, RepeaterItemEventArgs e);
+    public sealed class RepeatInfo {
+        public RepeatInfo();
+        public string Caption { get; set; }
+        public TableCaptionAlign CaptionAlign { get; set; }
+        public bool OuterTableImplied { get; set; }
+        public int RepeatColumns { get; set; }
+        public RepeatDirection RepeatDirection { get; set; }
+        public RepeatLayout RepeatLayout { get; set; }
+        public bool UseAccessibleHeader { get; set; }
+        public void RenderRepeater(HtmlTextWriter writer, IRepeatInfoUser user, Style controlStyle, WebControl baseControl);
+    }
+    public enum RepeatLayout {
+        Flow = 1,
+        OrderedList = 3,
+        Table = 0,
+        UnorderedList = 2,
+    }
+    public class RequiredFieldValidator : BaseValidator {
+        public RequiredFieldValidator();
+        public string InitialValue { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override bool EvaluateIsValid();
+    }
+    public sealed class RoleGroup {
+        public RoleGroup();
+        public ITemplate ContentTemplate { get; set; }
+        public string[] Roles { get; set; }
+        public bool ContainsUser(IPrincipal user);
+        public override string ToString();
+    }
+    public sealed class RoleGroupCollection : CollectionBase {
+        public RoleGroupCollection();
+        public RoleGroup this[int index] { get; }
+        public void Add(RoleGroup group);
+        public bool Contains(RoleGroup group);
+        public void CopyTo(RoleGroup[] array, int index);
+        public RoleGroup GetMatchingRoleGroup(IPrincipal user);
+        public int IndexOf(RoleGroup group);
+        public void Insert(int index, RoleGroup group);
+        protected override void OnValidate(object value);
+        public void Remove(RoleGroup group);
+    }
+    public class RouteParameter : Parameter {
+        public RouteParameter();
+        public RouteParameter(string name, DbType dbType, string routeKey);
+        public RouteParameter(string name, string routeKey);
+        public RouteParameter(string name, TypeCode type, string routeKey);
+        protected RouteParameter(RouteParameter original);
+        public string RouteKey { get; set; }
+        protected override Parameter Clone();
+        protected internal override object Evaluate(HttpContext context, Control control);
+    }
+    public enum ScrollBars {
+        Auto = 4,
+        Both = 3,
+        Horizontal = 1,
+        None = 0,
+        Vertical = 2,
+    }
+    public sealed class SelectedDatesCollection : ICollection, IEnumerable {
+        public SelectedDatesCollection(ArrayList dateList);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        public DateTime this[int index] { get; }
+        public void Add(DateTime date);
+        public void Clear();
+        public bool Contains(DateTime date);
+        public void CopyTo(Array array, int index);
+        public IEnumerator GetEnumerator();
+        public void Remove(DateTime date);
+        public void SelectRange(DateTime fromDate, DateTime toDate);
+    }
+    public sealed class SelectResult {
+        public SelectResult(int totalRowCount, IEnumerable results);
+        public IEnumerable Results { get; private set; }
+        public int TotalRowCount { get; private set; }
+    }
+    public class SendMailErrorEventArgs : EventArgs {
+        public SendMailErrorEventArgs(Exception e);
+        public Exception Exception { get; set; }
+        public bool Handled { get; set; }
+    }
+    public delegate void SendMailErrorEventHandler(object sender, SendMailErrorEventArgs e);
+    public class ServerValidateEventArgs : EventArgs {
+        public ServerValidateEventArgs(string value, bool isValid);
+        public bool IsValid { get; set; }
+        public string Value { get; }
+    }
+    public delegate void ServerValidateEventHandler(object source, ServerValidateEventArgs args);
+    public class SessionParameter : Parameter {
+        public SessionParameter();
+        public SessionParameter(string name, DbType dbType, string sessionField);
+        public SessionParameter(string name, string sessionField);
+        public SessionParameter(string name, TypeCode type, string sessionField);
+        protected SessionParameter(SessionParameter original);
+        public string SessionField { get; set; }
+        protected override Parameter Clone();
+        protected internal override object Evaluate(HttpContext context, Control control);
+    }
+    public class SiteMapDataSource : HierarchicalDataSourceControl, IDataSource, IListSource {
+        public SiteMapDataSource();
+        public virtual bool ContainsListCollection { get; }
+        public SiteMapProvider Provider { get; set; }
+        public virtual bool ShowStartingNode { get; set; }
+        public virtual string SiteMapProvider { get; set; }
+        public virtual bool StartFromCurrentNode { get; set; }
+        public virtual int StartingNodeOffset { get; set; }
+        public virtual string StartingNodeUrl { get; set; }
+        bool System.ComponentModel.IListSource.ContainsListCollection { get; }
+        event EventHandler System.Web.UI.IDataSource.DataSourceChanged;
+        protected override HierarchicalDataSourceView GetHierarchicalView(string viewPath);
+        public virtual IList GetList();
+        public virtual DataSourceView GetView(string viewName);
+        public virtual ICollection GetViewNames();
+        IList System.ComponentModel.IListSource.GetList();
+        DataSourceView System.Web.UI.IDataSource.GetView(string viewName);
+        ICollection System.Web.UI.IDataSource.GetViewNames();
+    }
+    public class SiteMapDataSourceView : DataSourceView {
+        public SiteMapDataSourceView(SiteMapDataSource owner, string name, SiteMapNode node);
+        public SiteMapDataSourceView(SiteMapDataSource owner, string name, SiteMapNodeCollection collection);
+        protected internal override IEnumerable ExecuteSelect(DataSourceSelectArguments arguments);
+        protected override void OnDataSourceViewChanged(EventArgs e);
+        public IEnumerable Select(DataSourceSelectArguments arguments);
+    }
+    public class SiteMapHierarchicalDataSourceView : HierarchicalDataSourceView {
+        public SiteMapHierarchicalDataSourceView(SiteMapNode node);
+        public SiteMapHierarchicalDataSourceView(SiteMapNodeCollection collection);
+        public override IHierarchicalEnumerable Select();
+    }
+    public class SiteMapNodeItem : WebControl, IDataItemContainer, INamingContainer {
+        public SiteMapNodeItem(int itemIndex, SiteMapNodeItemType itemType);
+        public virtual int ItemIndex { get; }
+        public virtual SiteMapNodeItemType ItemType { get; }
+        public virtual SiteMapNode SiteMapNode { get; set; }
+        object System.Web.UI.IDataItemContainer.DataItem { get; }
+        int System.Web.UI.IDataItemContainer.DataItemIndex { get; }
+        int System.Web.UI.IDataItemContainer.DisplayIndex { get; }
+        protected internal virtual void SetItemType(SiteMapNodeItemType itemType);
+    }
+    public class SiteMapNodeItemEventArgs : EventArgs {
+        public SiteMapNodeItemEventArgs(SiteMapNodeItem item);
+        public SiteMapNodeItem Item { get; }
+    }
+    public delegate void SiteMapNodeItemEventHandler(object sender, SiteMapNodeItemEventArgs e);
+    public enum SiteMapNodeItemType {
+        Current = 2,
+        Parent = 1,
+        PathSeparator = 3,
+        Root = 0,
+    }
+    public class SiteMapPath : CompositeControl {
+        public SiteMapPath();
+        public Style CurrentNodeStyle { get; }
+        public virtual ITemplate CurrentNodeTemplate { get; set; }
+        public Style NodeStyle { get; }
+        public virtual ITemplate NodeTemplate { get; set; }
+        public virtual int ParentLevelsDisplayed { get; set; }
+        public virtual PathDirection PathDirection { get; set; }
+        public virtual string PathSeparator { get; set; }
+        public Style PathSeparatorStyle { get; }
+        public virtual ITemplate PathSeparatorTemplate { get; set; }
+        public SiteMapProvider Provider { get; set; }
+        public virtual bool RenderCurrentNodeAsLink { get; set; }
+        public Style RootNodeStyle { get; }
+        public virtual ITemplate RootNodeTemplate { get; set; }
+        public virtual bool ShowToolTips { get; set; }
+        public virtual string SiteMapProvider { get; set; }
+        public virtual string SkipLinkText { get; set; }
+        public event SiteMapNodeItemEventHandler ItemCreated;
+        public event SiteMapNodeItemEventHandler ItemDataBound;
+        protected internal override void CreateChildControls();
+        protected virtual void CreateControlHierarchy();
+        public override void DataBind();
+        protected virtual void InitializeItem(SiteMapNodeItem item);
+        protected override void LoadViewState(object savedState);
+        protected override void OnDataBinding(EventArgs e);
+        protected virtual void OnItemCreated(SiteMapNodeItemEventArgs e);
+        protected virtual void OnItemDataBound(SiteMapNodeItemEventArgs e);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+        protected override object SaveViewState();
+        protected override void TrackViewState();
+    }
+    public enum SortDirection {
+        Ascending = 0,
+        Descending = 1,
+    }
+    public class SqlDataSource : DataSourceControl {
+        public SqlDataSource();
+        public SqlDataSource(string connectionString, string selectCommand);
+        public SqlDataSource(string providerName, string connectionString, string selectCommand);
+        public virtual int CacheDuration { get; set; }
+        public virtual DataSourceCacheExpiry CacheExpirationPolicy { get; set; }
+        public virtual string CacheKeyDependency { get; set; }
+        public virtual bool CancelSelectOnNullParameter { get; set; }
+        public ConflictOptions ConflictDetection { get; set; }
+        public virtual string ConnectionString { get; set; }
+        public SqlDataSourceMode DataSourceMode { get; set; }
+        public string DeleteCommand { get; set; }
+        public SqlDataSourceCommandType DeleteCommandType { get; set; }
+        public ParameterCollection DeleteParameters { get; }
+        public virtual bool EnableCaching { get; set; }
+        public string FilterExpression { get; set; }
+        public ParameterCollection FilterParameters { get; }
+        public string InsertCommand { get; set; }
+        public SqlDataSourceCommandType InsertCommandType { get; set; }
+        public ParameterCollection InsertParameters { get; }
+        public string OldValuesParameterFormatString { get; set; }
+        public virtual string ProviderName { get; set; }
+        public string SelectCommand { get; set; }
+        public SqlDataSourceCommandType SelectCommandType { get; set; }
+        public ParameterCollection SelectParameters { get; }
+        public string SortParameterName { get; set; }
+        public virtual string SqlCacheDependency { get; set; }
+        public string UpdateCommand { get; set; }
+        public SqlDataSourceCommandType UpdateCommandType { get; set; }
+        public ParameterCollection UpdateParameters { get; }
+        public event SqlDataSourceStatusEventHandler Deleted;
+        public event SqlDataSourceCommandEventHandler Deleting;
+        public event SqlDataSourceFilteringEventHandler Filtering;
+        public event SqlDataSourceStatusEventHandler Inserted;
+        public event SqlDataSourceCommandEventHandler Inserting;
+        public event SqlDataSourceStatusEventHandler Selected;
+        public event SqlDataSourceSelectingEventHandler Selecting;
+        public event SqlDataSourceStatusEventHandler Updated;
+        public event SqlDataSourceCommandEventHandler Updating;
+        protected virtual SqlDataSourceView CreateDataSourceView(string viewName);
+        public int Delete();
+        protected virtual DbProviderFactory GetDbProviderFactory();
+        protected override DataSourceView GetView(string viewName);
+        protected override ICollection GetViewNames();
+        public int Insert();
+        protected override void LoadViewState(object savedState);
+        protected internal override void OnInit(EventArgs e);
+        protected override object SaveViewState();
+        public IEnumerable Select(DataSourceSelectArguments arguments);
+        protected override void TrackViewState();
+        public int Update();
+    }
+    public class SqlDataSourceCommandEventArgs : CancelEventArgs {
+        public SqlDataSourceCommandEventArgs(DbCommand command);
+        public DbCommand Command { get; }
+    }
+    public delegate void SqlDataSourceCommandEventHandler(object sender, SqlDataSourceCommandEventArgs e);
+    public enum SqlDataSourceCommandType {
+        StoredProcedure = 1,
+        Text = 0,
+    }
+    public class SqlDataSourceFilteringEventArgs : CancelEventArgs {
+        public SqlDataSourceFilteringEventArgs(IOrderedDictionary parameterValues);
+        public IOrderedDictionary ParameterValues { get; }
+    }
+    public delegate void SqlDataSourceFilteringEventHandler(object sender, SqlDataSourceFilteringEventArgs e);
+    public enum SqlDataSourceMode {
+        DataReader = 0,
+        DataSet = 1,
+    }
+    public class SqlDataSourceSelectingEventArgs : SqlDataSourceCommandEventArgs {
+        public SqlDataSourceSelectingEventArgs(DbCommand command, DataSourceSelectArguments arguments);
+        public DataSourceSelectArguments Arguments { get; }
+    }
+    public delegate void SqlDataSourceSelectingEventHandler(object sender, SqlDataSourceSelectingEventArgs e);
+    public class SqlDataSourceStatusEventArgs : EventArgs {
+        public SqlDataSourceStatusEventArgs(DbCommand command, int affectedRows, Exception exception);
+        public int AffectedRows { get; }
+        public DbCommand Command { get; }
+        public Exception Exception { get; }
+        public bool ExceptionHandled { get; set; }
+    }
+    public delegate void SqlDataSourceStatusEventHandler(object sender, SqlDataSourceStatusEventArgs e);
+    public class SqlDataSourceView : DataSourceView, IStateManager {
+        public SqlDataSourceView(SqlDataSource owner, string name, HttpContext context);
+        public bool CancelSelectOnNullParameter { get; set; }
+        public override bool CanDelete { get; }
+        public override bool CanInsert { get; }
+        public override bool CanPage { get; }
+        public override bool CanRetrieveTotalRowCount { get; }
+        public override bool CanSort { get; }
+        public override bool CanUpdate { get; }
+        public ConflictOptions ConflictDetection { get; set; }
+        public string DeleteCommand { get; set; }
+        public SqlDataSourceCommandType DeleteCommandType { get; set; }
+        public ParameterCollection DeleteParameters { get; }
+        public string FilterExpression { get; set; }
+        public ParameterCollection FilterParameters { get; }
+        public string InsertCommand { get; set; }
+        public SqlDataSourceCommandType InsertCommandType { get; set; }
+        public ParameterCollection InsertParameters { get; }
+        protected bool IsTrackingViewState { get; }
+        public string OldValuesParameterFormatString { get; set; }
+        protected virtual string ParameterPrefix { get; }
+        public string SelectCommand { get; set; }
+        public SqlDataSourceCommandType SelectCommandType { get; set; }
+        public ParameterCollection SelectParameters { get; }
+        public string SortParameterName { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public string UpdateCommand { get; set; }
+        public SqlDataSourceCommandType UpdateCommandType { get; set; }
+        public ParameterCollection UpdateParameters { get; }
+        public event SqlDataSourceStatusEventHandler Deleted;
+        public event SqlDataSourceCommandEventHandler Deleting;
+        public event SqlDataSourceFilteringEventHandler Filtering;
+        public event SqlDataSourceStatusEventHandler Inserted;
+        public event SqlDataSourceCommandEventHandler Inserting;
+        public event SqlDataSourceStatusEventHandler Selected;
+        public event SqlDataSourceSelectingEventHandler Selecting;
+        public event SqlDataSourceStatusEventHandler Updated;
+        public event SqlDataSourceCommandEventHandler Updating;
+        public int Delete(IDictionary keys, IDictionary oldValues);
+        protected override int ExecuteDelete(IDictionary keys, IDictionary oldValues);
+        protected override int ExecuteInsert(IDictionary values);
+        protected internal override IEnumerable ExecuteSelect(DataSourceSelectArguments arguments);
+        protected override int ExecuteUpdate(IDictionary keys, IDictionary values, IDictionary oldValues);
+        public int Insert(IDictionary values);
+        protected virtual void LoadViewState(object savedState);
+        protected virtual void OnDeleted(SqlDataSourceStatusEventArgs e);
+        protected virtual void OnDeleting(SqlDataSourceCommandEventArgs e);
+        protected virtual void OnFiltering(SqlDataSourceFilteringEventArgs e);
+        protected virtual void OnInserted(SqlDataSourceStatusEventArgs e);
+        protected virtual void OnInserting(SqlDataSourceCommandEventArgs e);
+        protected virtual void OnSelected(SqlDataSourceStatusEventArgs e);
+        protected virtual void OnSelecting(SqlDataSourceSelectingEventArgs e);
+        protected virtual void OnUpdated(SqlDataSourceStatusEventArgs e);
+        protected virtual void OnUpdating(SqlDataSourceCommandEventArgs e);
+        protected internal override void RaiseUnsupportedCapabilityError(DataSourceCapabilities capability);
+        protected virtual object SaveViewState();
+        public IEnumerable Select(DataSourceSelectArguments arguments);
+        void System.Web.UI.IStateManager.LoadViewState(object savedState);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        protected virtual void TrackViewState();
+        public int Update(IDictionary keys, IDictionary values, IDictionary oldValues);
+    }
+    public class StringArrayConverter : TypeConverter {
+        public StringArrayConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public class Style : Component, IStateManager {
+        public Style();
+        public Style(StateBag bag);
+        public Color BackColor { get; set; }
+        public Color BorderColor { get; set; }
+        public BorderStyle BorderStyle { get; set; }
+        public Unit BorderWidth { get; set; }
+        public string CssClass { get; set; }
+        public FontInfo Font { get; }
+        public Color ForeColor { get; set; }
+        public Unit Height { get; set; }
+        public virtual bool IsEmpty { get; }
+        protected bool IsTrackingViewState { get; }
+        public string RegisteredCssClass { get; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        protected internal StateBag ViewState { get; }
+        public Unit Width { get; set; }
+        public void AddAttributesToRender(HtmlTextWriter writer);
+        public virtual void AddAttributesToRender(HtmlTextWriter writer, WebControl owner);
+        public virtual void CopyFrom(Style s);
+        protected virtual void FillStyleAttributes(CssStyleCollection attributes, IUrlResolutionService urlResolver);
+        public CssStyleCollection GetStyleAttributes(IUrlResolutionService urlResolver);
+        protected internal void LoadViewState(object state);
+        public virtual void MergeWith(Style s);
+        public virtual void Reset();
+        protected internal virtual object SaveViewState();
+        protected internal virtual void SetBit(int bit);
+        public void SetDirty();
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        protected internal virtual void TrackViewState();
+    }
+    public class StyleCollection : StateManagedCollection {
+        public Style this[int i] { get; set; }
+        public int Add(Style style);
+        public bool Contains(Style style);
+        public void CopyTo(Style[] styleArray, int index);
+        protected override object CreateKnownType(int index);
+        protected override Type[] GetKnownTypes();
+        public int IndexOf(Style style);
+        public void Insert(int index, Style style);
+        public void Remove(Style style);
+        public void RemoveAt(int index);
+        protected override void SetDirtyObject(object o);
+    }
+    public class SubMenuStyle : Style, ICustomTypeDescriptor {
+        public SubMenuStyle();
+        public SubMenuStyle(StateBag bag);
+        public Unit HorizontalPadding { get; set; }
+        public Unit VerticalPadding { get; set; }
+        public override void CopyFrom(Style s);
+        protected override void FillStyleAttributes(CssStyleCollection attributes, IUrlResolutionService urlResolver);
+        public override void MergeWith(Style s);
+        public override void Reset();
+        AttributeCollection System.ComponentModel.ICustomTypeDescriptor.GetAttributes();
+        string System.ComponentModel.ICustomTypeDescriptor.GetClassName();
+        string System.ComponentModel.ICustomTypeDescriptor.GetComponentName();
+        TypeConverter System.ComponentModel.ICustomTypeDescriptor.GetConverter();
+        EventDescriptor System.ComponentModel.ICustomTypeDescriptor.GetDefaultEvent();
+        PropertyDescriptor System.ComponentModel.ICustomTypeDescriptor.GetDefaultProperty();
+        object System.ComponentModel.ICustomTypeDescriptor.GetEditor(Type editorBaseType);
+        EventDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetEvents();
+        EventDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetEvents(Attribute[] attributes);
+        PropertyDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetProperties();
+        PropertyDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetProperties(Attribute[] attributes);
+        object System.ComponentModel.ICustomTypeDescriptor.GetPropertyOwner(PropertyDescriptor pd);
+    }
+    public class SubMenuStyleCollection : StateManagedCollection {
+        public SubMenuStyle this[int i] { get; set; }
+        public int Add(SubMenuStyle style);
+        public bool Contains(SubMenuStyle style);
+        public void CopyTo(SubMenuStyle[] styleArray, int index);
+        protected override object CreateKnownType(int index);
+        protected override Type[] GetKnownTypes();
+        public int IndexOf(SubMenuStyle style);
+        public void Insert(int index, SubMenuStyle style);
+        protected override void OnInsert(int index, object value);
+        public void Remove(SubMenuStyle style);
+        public void RemoveAt(int index);
+        protected override void SetDirtyObject(object o);
+    }
+    public class Substitution : Control {
+        public Substitution();
+        public virtual string MethodName { get; set; }
+        protected override ControlCollection CreateControlCollection();
+        protected internal override void OnPreRender(EventArgs e);
+        protected internal override void Render(HtmlTextWriter writer);
+    }
+    public class Table : WebControl, IPostBackEventHandler {
+        public Table();
+        public virtual string BackImageUrl { get; set; }
+        public virtual string Caption { get; set; }
+        public virtual TableCaptionAlign CaptionAlign { get; set; }
+        public virtual int CellPadding { get; set; }
+        public virtual int CellSpacing { get; set; }
+        public virtual GridLines GridLines { get; set; }
+        public virtual HorizontalAlign HorizontalAlign { get; set; }
+        public virtual TableRowCollection Rows { get; }
+        public override bool SupportsDisabledAttribute { get; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override ControlCollection CreateControlCollection();
+        protected override Style CreateControlStyle();
+        protected virtual void RaisePostBackEvent(string argument);
+        public override void RenderBeginTag(HtmlTextWriter writer);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+        protected class RowControlCollection : ControlCollection {
+            public override void Add(Control child);
+            public override void AddAt(int index, Control child);
+        }
+    }
+    public enum TableCaptionAlign {
+        Bottom = 2,
+        Left = 3,
+        NotSet = 0,
+        Right = 4,
+        Top = 1,
+    }
+    public class TableCell : WebControl {
+        public TableCell();
+        public virtual string[] AssociatedHeaderCellID { get; set; }
+        public virtual int ColumnSpan { get; set; }
+        public virtual HorizontalAlign HorizontalAlign { get; set; }
+        public virtual int RowSpan { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        public virtual string Text { get; set; }
+        public virtual VerticalAlign VerticalAlign { get; set; }
+        public virtual bool Wrap { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override void AddParsedSubObject(object obj);
+        protected override Style CreateControlStyle();
+        protected internal override void RenderContents(HtmlTextWriter writer);
+    }
+    public sealed class TableCellCollection : ICollection, IEnumerable, IList {
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public TableCell this[int index] { get; }
+        public int Add(TableCell cell);
+        public void AddAt(int index, TableCell cell);
+        public void AddRange(TableCell[] cells);
+        public void Clear();
+        public void CopyTo(Array array, int index);
+        public int GetCellIndex(TableCell cell);
+        public IEnumerator GetEnumerator();
+        public void Remove(TableCell cell);
+        public void RemoveAt(int index);
+        int System.Collections.IList.Add(object o);
+        bool System.Collections.IList.Contains(object o);
+        int System.Collections.IList.IndexOf(object o);
+        void System.Collections.IList.Insert(int index, object o);
+        void System.Collections.IList.Remove(object o);
+    }
+    public class TableCellControlBuilder : ControlBuilder {
+        public TableCellControlBuilder();
+        public override bool AllowWhitespaceLiterals();
+    }
+    public class TableFooterRow : TableRow {
+        public TableFooterRow();
+    }
+    public class TableHeaderCell : TableCell {
+        public TableHeaderCell();
+        public virtual string AbbreviatedText { get; set; }
+        public virtual string[] CategoryText { get; set; }
+        public virtual TableHeaderScope Scope { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+    }
+    public class TableHeaderRow : TableRow {
+        public TableHeaderRow();
+    }
+    public enum TableHeaderScope {
+        Column = 2,
+        NotSet = 0,
+        Row = 1,
+    }
+    public class TableItemStyle : Style {
+        public TableItemStyle();
+        public TableItemStyle(StateBag bag);
+        public virtual HorizontalAlign HorizontalAlign { get; set; }
+        public virtual VerticalAlign VerticalAlign { get; set; }
+        public virtual bool Wrap { get; set; }
+        public override void AddAttributesToRender(HtmlTextWriter writer, WebControl owner);
+        public override void CopyFrom(Style s);
+        public override void MergeWith(Style s);
+        public override void Reset();
+    }
+    public class TableRow : WebControl {
+        public TableRow();
+        public virtual TableCellCollection Cells { get; }
+        public virtual HorizontalAlign HorizontalAlign { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        public virtual TableRowSection TableSection { get; set; }
+        public virtual VerticalAlign VerticalAlign { get; set; }
+        protected override ControlCollection CreateControlCollection();
+        protected override Style CreateControlStyle();
+        protected class CellControlCollection : ControlCollection {
+            public override void Add(Control child);
+            public override void AddAt(int index, Control child);
+        }
+    }
+    public sealed class TableRowCollection : ICollection, IEnumerable, IList {
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public TableRow this[int index] { get; }
+        public int Add(TableRow row);
+        public void AddAt(int index, TableRow row);
+        public void AddRange(TableRow[] rows);
+        public void Clear();
+        public void CopyTo(Array array, int index);
+        public IEnumerator GetEnumerator();
+        public int GetRowIndex(TableRow row);
+        public void Remove(TableRow row);
+        public void RemoveAt(int index);
+        int System.Collections.IList.Add(object o);
+        bool System.Collections.IList.Contains(object o);
+        int System.Collections.IList.IndexOf(object o);
+        void System.Collections.IList.Insert(int index, object o);
+        void System.Collections.IList.Remove(object o);
+    }
+    public enum TableRowSection {
+        TableBody = 1,
+        TableFooter = 2,
+        TableHeader = 0,
+    }
+    public class TableSectionStyle : Style {
+        public TableSectionStyle();
+        public bool Visible { get; set; }
+    }
+    public class TableStyle : Style {
+        public TableStyle();
+        public TableStyle(StateBag bag);
+        public virtual string BackImageUrl { get; set; }
+        public virtual int CellPadding { get; set; }
+        public virtual int CellSpacing { get; set; }
+        public virtual GridLines GridLines { get; set; }
+        public virtual HorizontalAlign HorizontalAlign { get; set; }
+        public override void AddAttributesToRender(HtmlTextWriter writer, WebControl owner);
+        public override void CopyFrom(Style s);
+        protected override void FillStyleAttributes(CssStyleCollection attributes, IUrlResolutionService urlResolver);
+        public override void MergeWith(Style s);
+        public override void Reset();
+    }
+    public class TargetConverter : StringConverter {
+        public TargetConverter();
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+    }
+    public class TemplateColumn : DataGridColumn {
+        public TemplateColumn();
+        public virtual ITemplate EditItemTemplate { get; set; }
+        public virtual ITemplate FooterTemplate { get; set; }
+        public virtual ITemplate HeaderTemplate { get; set; }
+        public virtual ITemplate ItemTemplate { get; set; }
+        public override void InitializeCell(TableCell cell, int columnIndex, ListItemType itemType);
+    }
+    public class TemplatedWizardStep : WizardStepBase {
+        public TemplatedWizardStep();
+        public virtual ITemplate ContentTemplate { get; set; }
+        public Control ContentTemplateContainer { get; internal set; }
+        public virtual ITemplate CustomNavigationTemplate { get; set; }
+        public Control CustomNavigationTemplateContainer { get; internal set; }
+        public override string SkinID { get; set; }
+    }
+    public class TemplateField : DataControlField {
+        public TemplateField();
+        public virtual ITemplate AlternatingItemTemplate { get; set; }
+        public virtual bool ConvertEmptyStringToNull { get; set; }
+        public virtual ITemplate EditItemTemplate { get; set; }
+        public virtual ITemplate FooterTemplate { get; set; }
+        public virtual ITemplate HeaderTemplate { get; set; }
+        public virtual ITemplate InsertItemTemplate { get; set; }
+        public virtual ITemplate ItemTemplate { get; set; }
+        public new ValidateRequestMode ValidateRequestMode { get; set; }
+        protected override void CopyProperties(DataControlField newField);
+        protected override DataControlField CreateField();
+        public override void ExtractValuesFromCell(IOrderedDictionary dictionary, DataControlFieldCell cell, DataControlRowState rowState, bool includeReadOnly);
+        public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex);
+        public override void ValidateSupportsCallback();
+    }
+    public class TemplatePagerField : DataPagerField {
+        public TemplatePagerField();
+        public virtual ITemplate PagerTemplate { get; set; }
+        public event EventHandler<DataPagerCommandEventArgs> PagerCommand;
+        protected override void CopyProperties(DataPagerField newField);
+        public override void CreateDataPagers(DataPagerFieldItem container, int startRowIndex, int maximumRows, int totalRowCount, int fieldIndex);
+        protected override DataPagerField CreateField();
+        public override void HandleEvent(CommandEventArgs e);
+        protected virtual void OnPagerCommand(DataPagerCommandEventArgs e);
+    }
+    public enum TextAlign {
+        Left = 1,
+        Right = 2,
+    }
+    public class TextBox : WebControl, IEditableTextControl, IPostBackDataHandler, ITextControl {
+        public TextBox();
+        public virtual AutoCompleteType AutoCompleteType { get; set; }
+        public virtual bool AutoPostBack { get; set; }
+        public virtual bool CausesValidation { get; set; }
+        public virtual int Columns { get; set; }
+        public virtual int MaxLength { get; set; }
+        public virtual bool ReadOnly { get; set; }
+        public virtual int Rows { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public virtual string Text { get; set; }
+        public virtual TextBoxMode TextMode { get; set; }
+        public virtual string ValidationGroup { get; set; }
+        public virtual bool Wrap { get; set; }
+        public event EventHandler TextChanged;
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected override void AddParsedSubObject(object obj);
+        protected virtual bool LoadPostData(string postDataKey, NameValueCollection postCollection);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void OnTextChanged(EventArgs e);
+        protected virtual void RaisePostDataChangedEvent();
+        protected internal override void Render(HtmlTextWriter writer);
+        protected override object SaveViewState();
+        bool System.Web.UI.IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection);
+        void System.Web.UI.IPostBackDataHandler.RaisePostDataChangedEvent();
+    }
+    public class TextBoxControlBuilder : ControlBuilder {
+        public TextBoxControlBuilder();
+        public override bool AllowWhitespaceLiterals();
+        public override bool HtmlDecodeLiterals();
+    }
+    public enum TextBoxMode {
+        Color = 3,
+        Date = 4,
+        DateTime = 5,
+        DateTimeLocal = 6,
+        Email = 7,
+        Month = 8,
+        MultiLine = 1,
+        Number = 9,
+        Password = 2,
+        Phone = 12,
+        Range = 10,
+        Search = 11,
+        SingleLine = 0,
+        Time = 13,
+        Url = 14,
+        Week = 15,
+    }
+    public enum TitleFormat {
+        Month = 0,
+        MonthYear = 1,
+    }
+    public class TreeNode : ICloneable, IStateManager {
+        public TreeNode();
+        public TreeNode(string text);
+        public TreeNode(string text, string value);
+        public TreeNode(string text, string value, string imageUrl);
+        public TreeNode(string text, string value, string imageUrl, string navigateUrl, string target);
+        protected internal TreeNode(TreeView owner, bool isRoot);
+        public bool Checked { get; set; }
+        public TreeNodeCollection ChildNodes { get; }
+        public bool DataBound { get; }
+        public object DataItem { get; }
+        public string DataPath { get; }
+        public int Depth { get; }
+        public Nullable<bool> Expanded { get; set; }
+        public string ImageToolTip { get; set; }
+        public string ImageUrl { get; set; }
+        protected bool IsTrackingViewState { get; }
+        public string NavigateUrl { get; set; }
+        public TreeNode Parent { get; }
+        public bool PopulateOnDemand { get; set; }
+        public TreeNodeSelectAction SelectAction { get; set; }
+        public bool Selected { get; set; }
+        public Nullable<bool> ShowCheckBox { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public string Target { get; set; }
+        public string Text { get; set; }
+        public string ToolTip { get; set; }
+        public string Value { get; set; }
+        public string ValuePath { get; }
+        protected virtual object Clone();
+        public void Collapse();
+        public void CollapseAll();
+        public void Expand();
+        public void ExpandAll();
+        protected virtual void LoadViewState(object state);
+        protected virtual void RenderPostText(HtmlTextWriter writer);
+        protected virtual void RenderPreText(HtmlTextWriter writer);
+        protected virtual object SaveViewState();
+        public void Select();
+        object System.ICloneable.Clone();
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        public void ToggleExpandState();
+        protected void TrackViewState();
+    }
+    public sealed class TreeNodeBinding : ICloneable, IDataSourceViewSchemaAccessor, IStateManager {
+        public TreeNodeBinding();
+        public string DataMember { get; set; }
+        public int Depth { get; set; }
+        public string FormatString { get; set; }
+        public string ImageToolTip { get; set; }
+        public string ImageToolTipField { get; set; }
+        public string ImageUrl { get; set; }
+        public string ImageUrlField { get; set; }
+        public string NavigateUrl { get; set; }
+        public string NavigateUrlField { get; set; }
+        public bool PopulateOnDemand { get; set; }
+        public TreeNodeSelectAction SelectAction { get; set; }
+        public Nullable<bool> ShowCheckBox { get; set; }
+        object System.Web.UI.IDataSourceViewSchemaAccessor.DataSourceViewSchema { get; set; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public string Target { get; set; }
+        public string TargetField { get; set; }
+        public string Text { get; set; }
+        public string TextField { get; set; }
+        public string ToolTip { get; set; }
+        public string ToolTipField { get; set; }
+        public string Value { get; set; }
+        public string ValueField { get; set; }
+        object System.ICloneable.Clone();
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+        public override string ToString();
+    }
+    public sealed class TreeNodeBindingCollection : StateManagedCollection {
+        public TreeNodeBinding this[int i] { get; set; }
+        public int Add(TreeNodeBinding binding);
+        public bool Contains(TreeNodeBinding binding);
+        public void CopyTo(TreeNodeBinding[] bindingArray, int index);
+        protected override object CreateKnownType(int index);
+        protected override Type[] GetKnownTypes();
+        public int IndexOf(TreeNodeBinding binding);
+        public void Insert(int index, TreeNodeBinding binding);
+        protected override void OnClear();
+        protected override void OnRemoveComplete(int index, object value);
+        protected override void OnValidate(object value);
+        public void Remove(TreeNodeBinding binding);
+        public void RemoveAt(int index);
+        protected override void SetDirtyObject(object o);
+    }
+    public sealed class TreeNodeCollection : ICollection, IEnumerable, IStateManager {
+        public TreeNodeCollection();
+        public TreeNodeCollection(TreeNode owner);
+        public int Count { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        bool System.Web.UI.IStateManager.IsTrackingViewState { get; }
+        public TreeNode this[int index] { get; }
+        public void Add(TreeNode child);
+        public void AddAt(int index, TreeNode child);
+        public void Clear();
+        public bool Contains(TreeNode c);
+        public void CopyTo(TreeNode[] nodeArray, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(TreeNode value);
+        public void Remove(TreeNode value);
+        public void RemoveAt(int index);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        void System.Web.UI.IStateManager.LoadViewState(object state);
+        object System.Web.UI.IStateManager.SaveViewState();
+        void System.Web.UI.IStateManager.TrackViewState();
+    }
+    public sealed class TreeNodeEventArgs : EventArgs {
+        public TreeNodeEventArgs(TreeNode node);
+        public TreeNode Node { get; }
+    }
+    public delegate void TreeNodeEventHandler(object sender, TreeNodeEventArgs e);
+    public enum TreeNodeSelectAction {
+        Expand = 1,
+        None = 3,
+        Select = 0,
+        SelectExpand = 2,
+    }
+    public sealed class TreeNodeStyle : Style {
+        public TreeNodeStyle();
+        public TreeNodeStyle(StateBag bag);
+        public Unit ChildNodesPadding { get; set; }
+        public Unit HorizontalPadding { get; set; }
+        public string ImageUrl { get; set; }
+        public Unit NodeSpacing { get; set; }
+        public Unit VerticalPadding { get; set; }
+        public override void CopyFrom(Style s);
+        protected override void FillStyleAttributes(CssStyleCollection attributes, IUrlResolutionService urlResolver);
+        public override void MergeWith(Style s);
+        public override void Reset();
+    }
+    public sealed class TreeNodeStyleCollection : StateManagedCollection {
+        public TreeNodeStyle this[int i] { get; set; }
+        public int Add(TreeNodeStyle style);
+        public bool Contains(TreeNodeStyle style);
+        public void CopyTo(TreeNodeStyle[] styleArray, int index);
+        protected override object CreateKnownType(int index);
+        protected override Type[] GetKnownTypes();
+        public int IndexOf(TreeNodeStyle style);
+        public void Insert(int index, TreeNodeStyle style);
+        protected override void OnInsert(int index, object value);
+        public void Remove(TreeNodeStyle style);
+        public void RemoveAt(int index);
+        protected override void SetDirtyObject(object o);
+    }
+    public enum TreeNodeTypes {
+        All = 7,
+        Leaf = 4,
+        None = 0,
+        Parent = 2,
+        Root = 1,
+    }
+    public class TreeView : HierarchicalDataBoundControl, ICallbackEventHandler, IPostBackDataHandler, IPostBackEventHandler {
+        public TreeView();
+        public bool AutoGenerateDataBindings { get; set; }
+        public TreeNodeCollection CheckedNodes { get; }
+        public string CollapseImageToolTip { get; set; }
+        public string CollapseImageUrl { get; set; }
+        public TreeNodeBindingCollection DataBindings { get; }
+        public bool EnableClientScript { get; set; }
+        public int ExpandDepth { get; set; }
+        public string ExpandImageToolTip { get; set; }
+        public string ExpandImageUrl { get; set; }
+        public Style HoverNodeStyle { get; }
+        public TreeViewImageSet ImageSet { get; set; }
+        public TreeNodeStyle LeafNodeStyle { get; }
+        public TreeNodeStyleCollection LevelStyles { get; }
+        public string LineImagesFolder { get; set; }
+        public int MaxDataBindDepth { get; set; }
+        public int NodeIndent { get; set; }
+        public TreeNodeCollection Nodes { get; }
+        public TreeNodeStyle NodeStyle { get; }
+        public bool NodeWrap { get; set; }
+        public string NoExpandImageUrl { get; set; }
+        public TreeNodeStyle ParentNodeStyle { get; }
+        public char PathSeparator { get; set; }
+        public bool PopulateNodesFromClient { get; set; }
+        public TreeNodeStyle RootNodeStyle { get; }
+        public TreeNode SelectedNode { get; }
+        public TreeNodeStyle SelectedNodeStyle { get; }
+        public string SelectedValue { get; }
+        public TreeNodeTypes ShowCheckBoxes { get; set; }
+        public bool ShowExpandCollapse { get; set; }
+        public bool ShowLines { get; set; }
+        public string SkipLinkText { get; set; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public string Target { get; set; }
+        public override bool Visible { get; set; }
+        public event EventHandler SelectedNodeChanged;
+        public event TreeNodeEventHandler TreeNodeCheckChanged;
+        public event TreeNodeEventHandler TreeNodeCollapsed;
+        public event TreeNodeEventHandler TreeNodeDataBound;
+        public event TreeNodeEventHandler TreeNodeExpanded;
+        public event TreeNodeEventHandler TreeNodePopulate;
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        public void CollapseAll();
+        protected override ControlCollection CreateControlCollection();
+        protected internal virtual TreeNode CreateNode();
+        public sealed override void DataBind();
+        public void ExpandAll();
+        public TreeNode FindNode(string valuePath);
+        protected virtual string GetCallbackResult();
+        protected virtual bool LoadPostData(string postDataKey, NameValueCollection postCollection);
+        protected override void LoadViewState(object state);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected virtual void OnSelectedNodeChanged(EventArgs e);
+        protected virtual void OnTreeNodeCheckChanged(TreeNodeEventArgs e);
+        protected virtual void OnTreeNodeCollapsed(TreeNodeEventArgs e);
+        protected virtual void OnTreeNodeDataBound(TreeNodeEventArgs e);
+        protected virtual void OnTreeNodeExpanded(TreeNodeEventArgs e);
+        protected virtual void OnTreeNodePopulate(TreeNodeEventArgs e);
+        protected internal override void PerformDataBinding();
+        protected virtual void RaiseCallbackEvent(string eventArgument);
+        protected virtual void RaisePostBackEvent(string eventArgument);
+        protected virtual void RaisePostDataChangedEvent();
+        public override void RenderBeginTag(HtmlTextWriter writer);
+        protected internal override void RenderContents(HtmlTextWriter writer);
+        public override void RenderEndTag(HtmlTextWriter writer);
+        protected override object SaveViewState();
+        protected void SetNodeDataBound(TreeNode node, bool dataBound);
+        protected void SetNodeDataItem(TreeNode node, object dataItem);
+        protected void SetNodeDataPath(TreeNode node, string dataPath);
+        string System.Web.UI.ICallbackEventHandler.GetCallbackResult();
+        void System.Web.UI.ICallbackEventHandler.RaiseCallbackEvent(string eventArgument);
+        bool System.Web.UI.IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection);
+        void System.Web.UI.IPostBackDataHandler.RaisePostDataChangedEvent();
+        void System.Web.UI.IPostBackEventHandler.RaisePostBackEvent(string eventArgument);
+        protected override void TrackViewState();
+    }
+    public enum TreeViewImageSet {
+        Arrows = 10,
+        BulletedList = 6,
+        BulletedList2 = 7,
+        BulletedList3 = 8,
+        BulletedList4 = 9,
+        Contacts = 12,
+        Custom = 0,
+        Events = 14,
+        Faq = 15,
+        Inbox = 13,
+        Msdn = 2,
+        News = 11,
+        Simple = 4,
+        Simple2 = 5,
+        WindowsHelp = 3,
+        XPFileExplorer = 1,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Unit {
+        public static readonly Unit Empty;
+        public Unit(double value);
+        public Unit(double value, UnitType type);
+        public Unit(int value);
+        public Unit(string value);
+        public Unit(string value, CultureInfo culture);
+        public bool IsEmpty { get; }
+        public UnitType Type { get; }
+        public double Value { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(Unit left, Unit right);
+        public static implicit operator Unit (int n);
+        public static bool operator !=(Unit left, Unit right);
+        public static Unit Parse(string s);
+        public static Unit Parse(string s, CultureInfo culture);
+        public static Unit Percentage(double n);
+        public static Unit Pixel(int n);
+        public static Unit Point(int n);
+        public override string ToString();
+        public string ToString(CultureInfo culture);
+        public string ToString(IFormatProvider formatProvider);
+    }
+    public class UnitConverter : TypeConverter {
+        public UnitConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public enum UnitType {
+        Cm = 6,
+        Em = 8,
+        Ex = 9,
+        Inch = 4,
+        Mm = 5,
+        Percentage = 7,
+        Pica = 3,
+        Pixel = 1,
+        Point = 2,
+    }
+    public class ValidatedControlConverter : ControlIDConverter {
+        public ValidatedControlConverter();
+        protected override bool FilterControl(Control control);
+    }
+    public enum ValidationCompareOperator {
+        DataTypeCheck = 6,
+        Equal = 0,
+        GreaterThan = 2,
+        GreaterThanEqual = 3,
+        LessThan = 4,
+        LessThanEqual = 5,
+        NotEqual = 1,
+    }
+    public enum ValidationDataType {
+        Currency = 4,
+        Date = 3,
+        Double = 2,
+        Integer = 1,
+        String = 0,
+    }
+    public class ValidationSummary : WebControl {
+        public ValidationSummary();
+        public ValidationSummaryDisplayMode DisplayMode { get; set; }
+        public bool EnableClientScript { get; set; }
+        public override Color ForeColor { get; set; }
+        public string HeaderText { get; set; }
+        public bool ShowMessageBox { get; set; }
+        public bool ShowModelStateErrors { get; set; }
+        public bool ShowSummary { get; set; }
+        public bool ShowValidationErrors { get; set; }
+        public override bool SupportsDisabledAttribute { get; }
+        public virtual string ValidationGroup { get; set; }
+        protected override void AddAttributesToRender(HtmlTextWriter writer);
+        protected internal override void OnInit(EventArgs e);
+        protected internal override void OnPreRender(EventArgs e);
+        protected internal override void Render(HtmlTextWriter writer);
+    }
+    public enum ValidationSummaryDisplayMode {
+        BulletList = 1,
+        List = 0,
+        SingleParagraph = 2,
+    }
+    public enum ValidatorDisplay {
+        Dynamic = 2,
+        None = 0,
+        Static = 1,
+    }
+    public enum VerticalAlign {
+        Bottom = 3,
+        Middle = 2,
+        NotSet = 0,
+        Top = 1,
+    }
+    public class View : Control {
+        public View();
+        public override bool EnableTheming { get; set; }
+        public override bool Visible { get; set; }
+        public event EventHandler Activate;
+        public event EventHandler Deactivate;
+        protected internal virtual void OnActivate(EventArgs e);
+        protected internal virtual void OnDeactivate(EventArgs e);
+    }
+    public class ViewCollection : ControlCollection {
+        public ViewCollection(Control owner);
+        public new View this[int i] { get; }
+        public override void Add(Control v);
+        public override void AddAt(int index, Control v);
+    }
+    public class WebColorConverter : ColorConverter {
+        public WebColorConverter();
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public class WebControl : Control, IAttributeAccessor {
+        protected WebControl();
+        protected WebControl(string tag);
+        public WebControl(HtmlTextWriterTag tag);
+        public virtual string AccessKey { get; set; }
+        public AttributeCollection Attributes { get; }
+        public virtual Color BackColor { get; set; }
+        public virtual Color BorderColor { get; set; }
+        public virtual BorderStyle BorderStyle { get; set; }
+        public virtual Unit BorderWidth { get; set; }
+        public Style ControlStyle { get; }
+        public bool ControlStyleCreated { get; }
+        public virtual string CssClass { get; set; }
+        public static string DisabledCssClass { get; set; }
+        public virtual bool Enabled { get; set; }
+        public override bool EnableTheming { get; set; }
+        public virtual FontInfo Font { get; }
+        public virtual Color ForeColor { get; set; }
+        public bool HasAttributes { get; }
+        public virtual Unit Height { get; set; }
+        protected internal bool IsEnabled { get; }
+        public override string SkinID { get; set; }
+        public CssStyleCollection Style { get; }
+        public virtual bool SupportsDisabledAttribute { get; }
+        public virtual short TabIndex { get; set; }
+        protected virtual HtmlTextWriterTag TagKey { get; }
+        protected virtual string TagName { get; }
+        public virtual string ToolTip { get; set; }
+        public virtual Unit Width { get; set; }
+        protected virtual void AddAttributesToRender(HtmlTextWriter writer);
+        public void ApplyStyle(Style s);
+        public void CopyBaseAttributes(WebControl controlSrc);
+        protected virtual Style CreateControlStyle();
+        protected override void LoadViewState(object savedState);
+        public void MergeStyle(Style s);
+        protected internal override void Render(HtmlTextWriter writer);
+        public virtual void RenderBeginTag(HtmlTextWriter writer);
+        protected internal virtual void RenderContents(HtmlTextWriter writer);
+        public virtual void RenderEndTag(HtmlTextWriter writer);
+        protected override object SaveViewState();
+        string System.Web.UI.IAttributeAccessor.GetAttribute(string name);
+        void System.Web.UI.IAttributeAccessor.SetAttribute(string name, string value);
+        protected override void TrackViewState();
+    }
+    public class Wizard : CompositeControl {
+        protected static readonly string CancelButtonID;
+        public static readonly string CancelCommandName;
+        protected static readonly string CustomFinishButtonID;
+        protected static readonly string CustomNextButtonID;
+        protected static readonly string CustomPreviousButtonID;
+        protected static readonly string DataListID;
+        protected static readonly string FinishButtonID;
+        protected static readonly string FinishPreviousButtonID;
+        public static readonly string HeaderPlaceholderId;
+        public static readonly string MoveCompleteCommandName;
+        public static readonly string MoveNextCommandName;
+        public static readonly string MovePreviousCommandName;
+        public static readonly string MoveToCommandName;
+        public static readonly string NavigationPlaceholderId;
+        protected static readonly string SideBarButtonID;
+        public static readonly string SideBarPlaceholderId;
+        protected static readonly string StartNextButtonID;
+        protected static readonly string StepNextButtonID;
+        protected static readonly string StepPreviousButtonID;
+        public static readonly string WizardStepPlaceholderId;
+        public Wizard();
+        public WizardStepBase ActiveStep { get; }
+        public virtual int ActiveStepIndex { get; set; }
+        public virtual string CancelButtonImageUrl { get; set; }
+        public Style CancelButtonStyle { get; }
+        public virtual string CancelButtonText { get; set; }
+        public virtual ButtonType CancelButtonType { get; set; }
+        public virtual string CancelDestinationPageUrl { get; set; }
+        public virtual int CellPadding { get; set; }
+        public virtual int CellSpacing { get; set; }
+        public virtual bool DisplayCancelButton { get; set; }
+        public virtual bool DisplaySideBar { get; set; }
+        public virtual string FinishCompleteButtonImageUrl { get; set; }
+        public Style FinishCompleteButtonStyle { get; }
+        public virtual string FinishCompleteButtonText { get; set; }
+        public virtual ButtonType FinishCompleteButtonType { get; set; }
+        public virtual string FinishDestinationPageUrl { get; set; }
+        public virtual ITemplate FinishNavigationTemplate { get; set; }
+        public virtual string FinishPreviousButtonImageUrl { get; set; }
+        public Style FinishPreviousButtonStyle { get; }
+        public virtual string FinishPreviousButtonText { get; set; }
+        public virtual ButtonType FinishPreviousButtonType { get; set; }
+        public TableItemStyle HeaderStyle { get; }
+        public virtual ITemplate HeaderTemplate { get; set; }
+        public virtual string HeaderText { get; set; }
+        public virtual ITemplate LayoutTemplate { get; set; }
+        public Style NavigationButtonStyle { get; }
+        public TableItemStyle NavigationStyle { get; }
+        public Style SideBarButtonStyle { get; }
+        public TableItemStyle SideBarStyle { get; }
+        public virtual ITemplate SideBarTemplate { get; set; }
+        public virtual string SkipLinkText { get; set; }
+        public virtual ITemplate StartNavigationTemplate { get; set; }
+        public virtual string StartNextButtonImageUrl { get; set; }
+        public Style StartNextButtonStyle { get; }
+        public virtual string StartNextButtonText { get; set; }
+        public virtual ButtonType StartNextButtonType { get; set; }
+        public virtual ITemplate StepNavigationTemplate { get; set; }
+        public virtual string StepNextButtonImageUrl { get; set; }
+        public Style StepNextButtonStyle { get; }
+        public virtual string StepNextButtonText { get; set; }
+        public virtual ButtonType StepNextButtonType { get; set; }
+        public virtual string StepPreviousButtonImageUrl { get; set; }
+        public Style StepPreviousButtonStyle { get; }
+        public virtual string StepPreviousButtonText { get; set; }
+        public virtual ButtonType StepPreviousButtonType { get; set; }
+        public TableItemStyle StepStyle { get; }
+        protected override HtmlTextWriterTag TagKey { get; }
+        public virtual WizardStepCollection WizardSteps { get; }
+        public event EventHandler ActiveStepChanged;
+        public event EventHandler CancelButtonClick;
+        public event WizardNavigationEventHandler FinishButtonClick;
+        public event WizardNavigationEventHandler NextButtonClick;
+        public event WizardNavigationEventHandler PreviousButtonClick;
+        public virtual event WizardNavigationEventHandler SideBarButtonClick;
+        protected virtual bool AllowNavigationToStep(int index);
+        protected internal override void CreateChildControls();
+        protected override ControlCollection CreateControlCollection();
+        protected virtual void CreateControlHierarchy();
+        protected override Style CreateControlStyle();
+        protected override IDictionary GetDesignModeState();
+        public ICollection GetHistory();
+        public WizardStepType GetStepType(WizardStepBase wizardStep, int index);
+        protected internal override void LoadControlState(object state);
+        protected override void LoadViewState(object savedState);
+        public void MoveTo(WizardStepBase wizardStep);
+        protected virtual void OnActiveStepChanged(object source, EventArgs e);
+        protected override bool OnBubbleEvent(object source, EventArgs e);
+        protected virtual void OnCancelButtonClick(EventArgs e);
+        protected virtual void OnFinishButtonClick(WizardNavigationEventArgs e);
+        protected internal override void OnInit(EventArgs e);
+        protected virtual void OnNextButtonClick(WizardNavigationEventArgs e);
+        protected virtual void OnPreviousButtonClick(WizardNavigationEventArgs e);
+        protected virtual void OnSideBarButtonClick(WizardNavigationEventArgs e);
+        protected internal void RegisterCommandEvents(IButtonControl button);
+        protected internal override void Render(HtmlTextWriter writer);
+        protected internal override object SaveControlState();
+        protected override object SaveViewState();
+        protected override void TrackViewState();
+    }
+    public class WizardNavigationEventArgs : EventArgs {
+        public WizardNavigationEventArgs(int currentStepIndex, int nextStepIndex);
+        public bool Cancel { get; set; }
+        public int CurrentStepIndex { get; }
+        public int NextStepIndex { get; }
+    }
+    public delegate void WizardNavigationEventHandler(object sender, WizardNavigationEventArgs e);
+    public sealed class WizardStep : WizardStepBase {
+        public WizardStep();
+    }
+    public abstract class WizardStepBase : View {
+        protected WizardStepBase();
+        public virtual bool AllowReturn { get; set; }
+        public override bool EnableTheming { get; set; }
+        public override string ID { get; set; }
+        public virtual string Name { get; }
+        public virtual WizardStepType StepType { get; set; }
+        public virtual string Title { get; set; }
+        public Wizard Wizard { get; }
+        protected override void LoadViewState(object savedState);
+        protected internal override void OnLoad(EventArgs e);
+        protected internal override void RenderChildren(HtmlTextWriter writer);
+    }
+    public sealed class WizardStepCollection : ICollection, IEnumerable, IList {
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public WizardStepBase this[int index] { get; }
+        public void Add(WizardStepBase wizardStep);
+        public void AddAt(int index, WizardStepBase wizardStep);
+        public void Clear();
+        public bool Contains(WizardStepBase wizardStep);
+        public void CopyTo(WizardStepBase[] array, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(WizardStepBase wizardStep);
+        public void Insert(int index, WizardStepBase wizardStep);
+        public void Remove(WizardStepBase wizardStep);
+        public void RemoveAt(int index);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        int System.Collections.IList.Add(object value);
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+    }
+    public sealed class WizardStepControlBuilder : ControlBuilder {
+        public WizardStepControlBuilder();
+    }
+    public enum WizardStepType {
+        Auto = 0,
+        Complete = 1,
+        Finish = 2,
+        Start = 3,
+        Step = 4,
+    }
+    public class Xml : Control {
+        public Xml();
+        public override string ClientID { get; }
+        public override ControlCollection Controls { get; }
+        public XmlDocument Document { get; set; }
+        public string DocumentContent { get; set; }
+        public string DocumentSource { get; set; }
+        public override bool EnableTheming { get; set; }
+        public override string SkinID { get; set; }
+        public XslTransform Transform { get; set; }
+        public XsltArgumentList TransformArgumentList { get; set; }
+        public string TransformSource { get; set; }
+        public XPathNavigator XPathNavigator { get; set; }
+        protected override void AddParsedSubObject(object obj);
+        protected override ControlCollection CreateControlCollection();
+        public override Control FindControl(string id);
+        public override void Focus();
+        protected override IDictionary GetDesignModeState();
+        public override bool HasControls();
+        protected internal override void Render(HtmlTextWriter output);
+    }
+    public class XmlBuilder : ControlBuilder {
+        public XmlBuilder();
+        public override void AppendLiteralString(string s);
+        public override Type GetChildControlType(string tagName, IDictionary attribs);
+        public override bool NeedsTagInnerText();
+        public override void SetTagInnerText(string text);
+    }
+    public class XmlDataSource : HierarchicalDataSourceControl, IDataSource, IListSource {
+        public XmlDataSource();
+        public virtual int CacheDuration { get; set; }
+        public virtual DataSourceCacheExpiry CacheExpirationPolicy { get; set; }
+        public virtual string CacheKeyContext { get; set; }
+        public virtual string CacheKeyDependency { get; set; }
+        public virtual string Data { get; set; }
+        public virtual string DataFile { get; set; }
+        public virtual bool EnableCaching { get; set; }
+        bool System.ComponentModel.IListSource.ContainsListCollection { get; }
+        public virtual string Transform { get; set; }
+        public virtual XsltArgumentList TransformArgumentList { get; set; }
+        public virtual string TransformFile { get; set; }
+        public virtual string XPath { get; set; }
+        event EventHandler System.Web.UI.IDataSource.DataSourceChanged;
+        public event EventHandler Transforming;
+        protected override HierarchicalDataSourceView GetHierarchicalView(string viewPath);
+        public XmlDocument GetXmlDocument();
+        protected virtual void OnTransforming(EventArgs e);
+        public void Save();
+        IList System.ComponentModel.IListSource.GetList();
+        DataSourceView System.Web.UI.IDataSource.GetView(string viewName);
+        ICollection System.Web.UI.IDataSource.GetViewNames();
+    }
+    public sealed class XmlDataSourceView : DataSourceView {
+        public XmlDataSourceView(XmlDataSource owner, string name);
+        protected internal override IEnumerable ExecuteSelect(DataSourceSelectArguments arguments);
+        public IEnumerable Select(DataSourceSelectArguments arguments);
+    }
+    public class XmlHierarchicalDataSourceView : HierarchicalDataSourceView {
+        public override IHierarchicalEnumerable Select();
+    }
+}
```

