# System.Xml.Serialization

``` diff
 namespace System.Xml.Serialization {
+    public class XmlAnyAttributeAttribute : Attribute {
+        public XmlAnyAttributeAttribute();
+    }
+    public class XmlAnyElementAttribute : Attribute {
+        public XmlAnyElementAttribute();
+        public XmlAnyElementAttribute(string name);
+        public XmlAnyElementAttribute(string name, string ns);
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+        public int Order { get; set; }
+    }
+    public class XmlAnyElementAttributes : ICollection, IEnumerable, IList {
+        public XmlAnyElementAttributes();
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public XmlAnyElementAttribute this[int index] { get; set; }
+        public int Add(XmlAnyElementAttribute attribute);
+        public void Clear();
+        public bool Contains(XmlAnyElementAttribute attribute);
+        public void CopyTo(XmlAnyElementAttribute[] array, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(XmlAnyElementAttribute attribute);
+        public void Insert(int index, XmlAnyElementAttribute attribute);
+        public void Remove(XmlAnyElementAttribute attribute);
+        public void RemoveAt(int index);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        int System.Collections.IList.Add(object value);
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+    }
+    public class XmlArrayAttribute : Attribute {
+        public XmlArrayAttribute();
+        public XmlArrayAttribute(string elementName);
+        public string ElementName { get; set; }
+        public XmlSchemaForm Form { get; set; }
+        public bool IsNullable { get; set; }
+        public string Namespace { get; set; }
+        public int Order { get; set; }
+    }
+    public class XmlArrayItemAttribute : Attribute {
+        public XmlArrayItemAttribute();
+        public XmlArrayItemAttribute(string elementName);
+        public XmlArrayItemAttribute(string elementName, Type type);
+        public XmlArrayItemAttribute(Type type);
+        public string DataType { get; set; }
+        public string ElementName { get; set; }
+        public XmlSchemaForm Form { get; set; }
+        public bool IsNullable { get; set; }
+        public string Namespace { get; set; }
+        public int NestingLevel { get; set; }
+        public Type Type { get; set; }
+    }
+    public class XmlArrayItemAttributes : ICollection, IEnumerable, IList {
+        public XmlArrayItemAttributes();
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public XmlArrayItemAttribute this[int index] { get; set; }
+        public int Add(XmlArrayItemAttribute attribute);
+        public void Clear();
+        public bool Contains(XmlArrayItemAttribute attribute);
+        public void CopyTo(XmlArrayItemAttribute[] array, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(XmlArrayItemAttribute attribute);
+        public void Insert(int index, XmlArrayItemAttribute attribute);
+        public void Remove(XmlArrayItemAttribute attribute);
+        public void RemoveAt(int index);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        int System.Collections.IList.Add(object value);
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+    }
+    public class XmlAttributeAttribute : Attribute {
+        public XmlAttributeAttribute();
+        public XmlAttributeAttribute(string attributeName);
+        public XmlAttributeAttribute(string attributeName, Type type);
+        public XmlAttributeAttribute(Type type);
+        public string AttributeName { get; set; }
+        public string DataType { get; set; }
+        public XmlSchemaForm Form { get; set; }
+        public string Namespace { get; set; }
+        public Type Type { get; set; }
+    }
+    public class XmlAttributeOverrides {
+        public XmlAttributeOverrides();
+        public XmlAttributes this[Type type, string member] { get; }
+        public XmlAttributes this[Type type] { get; }
+        public void Add(Type type, string member, XmlAttributes attributes);
+        public void Add(Type type, XmlAttributes attributes);
+    }
+    public class XmlAttributes {
+        public XmlAttributes();
+        public XmlAnyAttributeAttribute XmlAnyAttribute { get; set; }
+        public XmlAnyElementAttributes XmlAnyElements { get; }
+        public XmlArrayAttribute XmlArray { get; set; }
+        public XmlArrayItemAttributes XmlArrayItems { get; }
+        public XmlAttributeAttribute XmlAttribute { get; set; }
+        public XmlChoiceIdentifierAttribute XmlChoiceIdentifier { get; }
+        public object XmlDefaultValue { get; set; }
+        public XmlElementAttributes XmlElements { get; }
+        public XmlEnumAttribute XmlEnum { get; set; }
+        public bool XmlIgnore { get; set; }
+        public bool Xmlns { get; set; }
+        public XmlRootAttribute XmlRoot { get; set; }
+        public XmlTextAttribute XmlText { get; set; }
+        public XmlTypeAttribute XmlType { get; set; }
+    }
+    public class XmlChoiceIdentifierAttribute : Attribute {
+        public XmlChoiceIdentifierAttribute();
+        public XmlChoiceIdentifierAttribute(string name);
+        public string MemberName { get; set; }
+    }
+    public class XmlElementAttribute : Attribute {
+        public XmlElementAttribute();
+        public XmlElementAttribute(string elementName);
+        public XmlElementAttribute(string elementName, Type type);
+        public XmlElementAttribute(Type type);
+        public string DataType { get; set; }
+        public string ElementName { get; set; }
+        public XmlSchemaForm Form { get; set; }
+        public bool IsNullable { get; set; }
+        public string Namespace { get; set; }
+        public int Order { get; set; }
+        public Type Type { get; set; }
+    }
+    public class XmlElementAttributes : ICollection, IEnumerable, IList {
+        public XmlElementAttributes();
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public XmlElementAttribute this[int index] { get; set; }
+        public int Add(XmlElementAttribute attribute);
+        public void Clear();
+        public bool Contains(XmlElementAttribute attribute);
+        public void CopyTo(XmlElementAttribute[] array, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(XmlElementAttribute attribute);
+        public void Insert(int index, XmlElementAttribute attribute);
+        public void Remove(XmlElementAttribute attribute);
+        public void RemoveAt(int index);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        int System.Collections.IList.Add(object value);
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+    }
+    public class XmlEnumAttribute : Attribute {
+        public XmlEnumAttribute();
+        public XmlEnumAttribute(string name);
+        public string Name { get; set; }
+    }
+    public class XmlIgnoreAttribute : Attribute {
+        public XmlIgnoreAttribute();
+    }
+    public class XmlIncludeAttribute : Attribute {
+        public XmlIncludeAttribute(Type type);
+        public Type Type { get; set; }
+    }
+    public class XmlNamespaceDeclarationsAttribute : Attribute {
+        public XmlNamespaceDeclarationsAttribute();
+    }
+    public class XmlRootAttribute : Attribute {
+        public XmlRootAttribute();
+        public XmlRootAttribute(string elementName);
+        public string DataType { get; set; }
+        public string ElementName { get; set; }
+        public bool IsNullable { get; set; }
+        public string Namespace { get; set; }
+    }
+    public class XmlSerializer {
+        protected XmlSerializer();
+        public XmlSerializer(Type type);
+        public XmlSerializer(Type type, string defaultNamespace);
+        public XmlSerializer(Type type, Type[] extraTypes);
+        public XmlSerializer(Type type, XmlAttributeOverrides overrides);
+        public XmlSerializer(Type type, XmlAttributeOverrides overrides, Type[] extraTypes, XmlRootAttribute root, string defaultNamespace);
+        public XmlSerializer(Type type, XmlRootAttribute root);
+        public virtual bool CanDeserialize(XmlReader xmlReader);
+        public object Deserialize(Stream stream);
+        public object Deserialize(TextReader textReader);
+        public object Deserialize(XmlReader xmlReader);
+        public static XmlSerializer[] FromTypes(Type[] types);
+        public void Serialize(Stream stream, object o);
+        public void Serialize(Stream stream, object o, XmlSerializerNamespaces namespaces);
+        public void Serialize(TextWriter textWriter, object o);
+        public void Serialize(TextWriter textWriter, object o, XmlSerializerNamespaces namespaces);
+        public void Serialize(XmlWriter xmlWriter, object o);
+        public void Serialize(XmlWriter xmlWriter, object o, XmlSerializerNamespaces namespaces);
+    }
+    public class XmlSerializerNamespaces {
+        public XmlSerializerNamespaces();
+        public XmlSerializerNamespaces(XmlSerializerNamespaces namespaces);
+        public XmlSerializerNamespaces(XmlQualifiedName[] namespaces);
+        public int Count { get; }
+        public void Add(string prefix, string ns);
+        public XmlQualifiedName[] ToArray();
+    }
+    public class XmlTextAttribute : Attribute {
+        public XmlTextAttribute();
+        public XmlTextAttribute(Type type);
+        public string DataType { get; set; }
+        public Type Type { get; set; }
+    }
+    public class XmlTypeAttribute : Attribute {
+        public XmlTypeAttribute();
+        public XmlTypeAttribute(string typeName);
+        public bool AnonymousType { get; set; }
+        public bool IncludeInSchema { get; set; }
+        public string Namespace { get; set; }
+        public string TypeName { get; set; }
+    }
 }
```

