namespace System.DirectoryServices
{
    public partial class ActiveDirectoryAccessRule : System.Security.AccessControl.ObjectAccessRule
    {
        public ActiveDirectoryAccessRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AccessControlType type) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryAccessRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryAccessRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryAccessRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AccessControlType type, System.Guid objectType) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryAccessRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AccessControlType type, System.Guid objectType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryAccessRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AccessControlType type, System.Guid objectType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectoryRights ActiveDirectoryRights { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectorySecurityInheritance InheritanceType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public partial class ActiveDirectoryAuditRule : System.Security.AccessControl.ObjectAuditRule
    {
        public ActiveDirectoryAuditRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AuditFlags auditFlags) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AuditFlags)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryAuditRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AuditFlags auditFlags, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AuditFlags)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryAuditRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AuditFlags auditFlags, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AuditFlags)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryAuditRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AuditFlags auditFlags, System.Guid objectType) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AuditFlags)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryAuditRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AuditFlags auditFlags, System.Guid objectType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AuditFlags)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryAuditRule(System.Security.Principal.IdentityReference identity, System.DirectoryServices.ActiveDirectoryRights adRights, System.Security.AccessControl.AuditFlags auditFlags, System.Guid objectType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(int), default(bool), default(System.Security.AccessControl.InheritanceFlags), default(System.Security.AccessControl.PropagationFlags), default(System.Guid), default(System.Guid), default(System.Security.AccessControl.AuditFlags)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectoryRights ActiveDirectoryRights { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectorySecurityInheritance InheritanceType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    [System.FlagsAttribute]
    public enum ActiveDirectoryRights
    {
        CreateChild = 1,
        DeleteChild = 2,
        ListChildren = 4,
        Self = 8,
        ReadProperty = 16,
        WriteProperty = 32,
        DeleteTree = 64,
        ListObject = 128,
        ExtendedRight = 256,
        Delete = 65536,
        ReadControl = 131072,
        GenericExecute = 131076,
        GenericWrite = 131112,
        GenericRead = 131220,
        WriteDacl = 262144,
        WriteOwner = 524288,
        GenericAll = 983551,
        Synchronize = 1048576,
        AccessSystemSecurity = 16777216,
    }
    public partial class ActiveDirectorySecurity : System.Security.AccessControl.DirectoryObjectSecurity
    {
        public ActiveDirectorySecurity() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.Type AccessRightType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override System.Type AccessRuleType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override System.Type AuditRuleType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public sealed override System.Security.AccessControl.AccessRule AccessRuleFactory(System.Security.Principal.IdentityReference identityReference, int accessMask, bool isInherited, System.Security.AccessControl.InheritanceFlags inheritanceFlags, System.Security.AccessControl.PropagationFlags propagationFlags, System.Security.AccessControl.AccessControlType type) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public sealed override System.Security.AccessControl.AccessRule AccessRuleFactory(System.Security.Principal.IdentityReference identityReference, int accessMask, bool isInherited, System.Security.AccessControl.InheritanceFlags inheritanceFlags, System.Security.AccessControl.PropagationFlags propagationFlags, System.Security.AccessControl.AccessControlType type, System.Guid objectGuid, System.Guid inheritedObjectGuid) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddAccessRule(System.DirectoryServices.ActiveDirectoryAccessRule rule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddAuditRule(System.DirectoryServices.ActiveDirectoryAuditRule rule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public sealed override System.Security.AccessControl.AuditRule AuditRuleFactory(System.Security.Principal.IdentityReference identityReference, int accessMask, bool isInherited, System.Security.AccessControl.InheritanceFlags inheritanceFlags, System.Security.AccessControl.PropagationFlags propagationFlags, System.Security.AccessControl.AuditFlags flags) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public sealed override System.Security.AccessControl.AuditRule AuditRuleFactory(System.Security.Principal.IdentityReference identityReference, int accessMask, bool isInherited, System.Security.AccessControl.InheritanceFlags inheritanceFlags, System.Security.AccessControl.PropagationFlags propagationFlags, System.Security.AccessControl.AuditFlags flags, System.Guid objectGuid, System.Guid inheritedObjectGuid) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override bool ModifyAccessRule(System.Security.AccessControl.AccessControlModification modification, System.Security.AccessControl.AccessRule rule, out bool modified) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override bool ModifyAuditRule(System.Security.AccessControl.AccessControlModification modification, System.Security.AccessControl.AuditRule rule, out bool modified) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override void PurgeAccessRules(System.Security.Principal.IdentityReference identity) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override void PurgeAuditRules(System.Security.Principal.IdentityReference identity) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RemoveAccess(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool RemoveAccessRule(System.DirectoryServices.ActiveDirectoryAccessRule rule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RemoveAccessRuleSpecific(System.DirectoryServices.ActiveDirectoryAccessRule rule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RemoveAudit(System.Security.Principal.IdentityReference identity) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool RemoveAuditRule(System.DirectoryServices.ActiveDirectoryAuditRule rule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RemoveAuditRuleSpecific(System.DirectoryServices.ActiveDirectoryAuditRule rule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void ResetAccessRule(System.DirectoryServices.ActiveDirectoryAccessRule rule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SetAccessRule(System.DirectoryServices.ActiveDirectoryAccessRule rule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SetAuditRule(System.DirectoryServices.ActiveDirectoryAuditRule rule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum ActiveDirectorySecurityInheritance
    {
        None = 0,
        All = 1,
        Descendents = 2,
        SelfAndChildren = 3,
        Children = 4,
    }
    [System.FlagsAttribute]
    public enum AuthenticationTypes
    {
        None = 0,
        Secure = 1,
        Encryption = 2,
        SecureSocketsLayer = 2,
        ReadonlyServer = 4,
        Anonymous = 16,
        FastBind = 32,
        Signing = 64,
        Sealing = 128,
        Delegation = 256,
        ServerBind = 512,
    }
    public sealed partial class CreateChildAccessRule : System.DirectoryServices.ActiveDirectoryAccessRule
    {
        public CreateChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public CreateChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public CreateChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public CreateChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.Guid childType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public CreateChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.Guid childType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public CreateChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.Guid childType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public sealed partial class DeleteChildAccessRule : System.DirectoryServices.ActiveDirectoryAccessRule
    {
        public DeleteChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DeleteChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DeleteChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DeleteChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.Guid childType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DeleteChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.Guid childType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DeleteChildAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.Guid childType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public sealed partial class DeleteTreeAccessRule : System.DirectoryServices.ActiveDirectoryAccessRule
    {
        public DeleteTreeAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DeleteTreeAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DeleteTreeAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum DereferenceAlias
    {
        Never = 0,
        InSearching = 1,
        FindingBaseObject = 2,
        Always = 3,
    }
    public partial class DirectoryEntries : System.Collections.IEnumerable
    {
        internal DirectoryEntries() { }
        public System.DirectoryServices.SchemaNameCollection SchemaFilter { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.DirectoryEntry Add(string name, string schemaClassName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry Find(string name) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry Find(string name, string schemaClassName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.Collections.IEnumerator GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Remove(System.DirectoryServices.DirectoryEntry entry) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class DirectoryEntry : System.ComponentModel.Component
    {
        public DirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryEntry(object adsObject) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryEntry(string path) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryEntry(string path, string username, string password) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryEntry(string path, string username, string password, System.DirectoryServices.AuthenticationTypes authenticationType) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        [System.ComponentModel.DefaultValueAttribute(System.DirectoryServices.AuthenticationTypes.Secure)]
        public System.DirectoryServices.AuthenticationTypes AuthenticationType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.DirectoryEntries Children { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Guid Guid { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string NativeGuid { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public object NativeObject { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectorySecurity ObjectSecurity { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.DirectoryEntryConfiguration Options { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.DirectoryEntry Parent { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(null)]
        public string Password { set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute("")]
        public string Path { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.PropertyCollection Properties { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string SchemaClassName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.DirectoryEntry SchemaEntry { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool UsePropertyCache { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(null)]
        public string Username { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Close() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CommitChanges() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry CopyTo(System.DirectoryServices.DirectoryEntry newParent) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry CopyTo(System.DirectoryServices.DirectoryEntry newParent, string newName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void DeleteTree() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void Dispose(bool disposing) { }
        public static bool Exists(string path) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public object Invoke(string methodName, params object[] args) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public object InvokeGet(string propertyName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void InvokeSet(string propertyName, params object[] args) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void MoveTo(System.DirectoryServices.DirectoryEntry newParent) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void MoveTo(System.DirectoryServices.DirectoryEntry newParent, string newName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RefreshCache() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RefreshCache(string[] propertyNames) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Rename(string newName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class DirectoryEntryConfiguration
    {
        internal DirectoryEntryConfiguration() { }
        public int PageSize { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.PasswordEncodingMethod PasswordEncoding { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int PasswordPort { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ReferralChasingOption Referral { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.SecurityMasks SecurityMasks { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string GetCurrentServerName() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool IsMutuallyAuthenticated() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SetUserNameQueryQuota(string accountName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class DirectorySearcher : System.ComponentModel.Component
    {
        public DirectorySearcher() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectorySearcher(System.DirectoryServices.DirectoryEntry searchRoot) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectorySearcher(System.DirectoryServices.DirectoryEntry searchRoot, string filter) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectorySearcher(System.DirectoryServices.DirectoryEntry searchRoot, string filter, string[] propertiesToLoad) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectorySearcher(System.DirectoryServices.DirectoryEntry searchRoot, string filter, string[] propertiesToLoad, System.DirectoryServices.SearchScope scope) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectorySearcher(string filter) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectorySearcher(string filter, string[] propertiesToLoad) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectorySearcher(string filter, string[] propertiesToLoad, System.DirectoryServices.SearchScope scope) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool Asynchronous { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute("")]
        public string AttributeScopeQuery { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool CacheResults { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.TimeSpan ClientTimeout { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(System.DirectoryServices.DereferenceAlias.Never)]
        public System.DirectoryServices.DereferenceAlias DerefAlias { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(null)]
        public System.DirectoryServices.DirectorySynchronization DirectorySynchronization { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(System.DirectoryServices.ExtendedDN.None)]
        public System.DirectoryServices.ExtendedDN ExtendedDN { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute("(objectClass=*)")]
        public string Filter { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(0)]
        public int PageSize { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Collections.Specialized.StringCollection PropertiesToLoad { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool PropertyNamesOnly { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(System.DirectoryServices.ReferralChasingOption.External)]
        public System.DirectoryServices.ReferralChasingOption ReferralChasing { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(null)]
        public System.DirectoryServices.DirectoryEntry SearchRoot { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(System.DirectoryServices.SearchScope.Subtree)]
        public System.DirectoryServices.SearchScope SearchScope { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(System.DirectoryServices.SecurityMasks.None)]
        public System.DirectoryServices.SecurityMasks SecurityMasks { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.TimeSpan ServerPageTimeLimit { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.TimeSpan ServerTimeLimit { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(0)]
        public int SizeLimit { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.TypeConverterAttribute(typeof(System.ComponentModel.ExpandableObjectConverter))]
        public System.DirectoryServices.SortOption Sort { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool Tombstone { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(null)]
        public System.DirectoryServices.DirectoryVirtualListView VirtualListView { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        protected override void Dispose(bool disposing) { }
        public System.DirectoryServices.SearchResultCollection FindAll() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.SearchResult FindOne() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class DirectoryServicesCOMException : System.Runtime.InteropServices.COMException, System.Runtime.Serialization.ISerializable
    {
        public DirectoryServicesCOMException() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected DirectoryServicesCOMException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryServicesCOMException(string message) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryServicesCOMException(string message, System.Exception inner) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int ExtendedError { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string ExtendedErrorMessage { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo serializationInfo, System.Runtime.Serialization.StreamingContext streamingContext) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public sealed partial class DirectoryServicesPermission : System.Security.Permissions.ResourcePermissionBase
    {
        public DirectoryServicesPermission() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryServicesPermission(System.DirectoryServices.DirectoryServicesPermissionAccess permissionAccess, string path) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryServicesPermission(System.DirectoryServices.DirectoryServicesPermissionEntry[] permissionAccessEntries) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryServicesPermission(System.Security.Permissions.PermissionState state) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryServicesPermissionEntryCollection PermissionEntries { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    [System.FlagsAttribute]
    public enum DirectoryServicesPermissionAccess
    {
        None = 0,
        Browse = 2,
        Write = 6,
    }
    [System.AttributeUsageAttribute(System.AttributeTargets.Assembly | System.AttributeTargets.Class | System.AttributeTargets.Constructor | System.AttributeTargets.Event | System.AttributeTargets.Method | System.AttributeTargets.Struct, AllowMultiple=true, Inherited=false)]
    public partial class DirectoryServicesPermissionAttribute : System.Security.Permissions.CodeAccessSecurityAttribute
    {
        public DirectoryServicesPermissionAttribute(System.Security.Permissions.SecurityAction action) : base (default(System.Security.Permissions.SecurityAction)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public string Path { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.DirectoryServicesPermissionAccess PermissionAccess { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override System.Security.IPermission CreatePermission() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class DirectoryServicesPermissionEntry
    {
        public DirectoryServicesPermissionEntry(System.DirectoryServices.DirectoryServicesPermissionAccess permissionAccess, string path) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public string Path { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.DirectoryServicesPermissionAccess PermissionAccess { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public partial class DirectoryServicesPermissionEntryCollection : System.Collections.CollectionBase
    {
        internal DirectoryServicesPermissionEntryCollection() { }
        public System.DirectoryServices.DirectoryServicesPermissionEntry this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int Add(System.DirectoryServices.DirectoryServicesPermissionEntry value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.DirectoryServicesPermissionEntryCollection value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.DirectoryServicesPermissionEntry[] value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool Contains(System.DirectoryServices.DirectoryServicesPermissionEntry value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.DirectoryServicesPermissionEntry[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.DirectoryServicesPermissionEntry value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Insert(int index, System.DirectoryServices.DirectoryServicesPermissionEntry value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnClear() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnInsert(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnRemove(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnSet(int index, object oldValue, object newValue) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Remove(System.DirectoryServices.DirectoryServicesPermissionEntry value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class DirectorySynchronization
    {
        public DirectorySynchronization() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectorySynchronization(byte[] cookie) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectorySynchronization(System.DirectoryServices.DirectorySynchronization sync) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectorySynchronization(System.DirectoryServices.DirectorySynchronizationOptions option) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectorySynchronization(System.DirectoryServices.DirectorySynchronizationOptions option, byte[] cookie) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        [System.ComponentModel.DefaultValueAttribute(System.DirectoryServices.DirectorySynchronizationOptions.None)]
        public System.DirectoryServices.DirectorySynchronizationOptions Option { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.DirectorySynchronization Copy() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public byte[] GetDirectorySynchronizationCookie() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void ResetDirectorySynchronizationCookie() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void ResetDirectorySynchronizationCookie(byte[] cookie) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    [System.FlagsAttribute]
    public enum DirectorySynchronizationOptions : long
    {
        None = (long)0,
        ObjectSecurity = (long)1,
        ParentsFirst = (long)2048,
        PublicDataOnly = (long)8192,
        IncrementalValues = (long)2147483648,
    }
    public partial class DirectoryVirtualListView
    {
        public DirectoryVirtualListView() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryVirtualListView(int afterCount) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryVirtualListView(int beforeCount, int afterCount, int offset) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryVirtualListView(int beforeCount, int afterCount, int offset, System.DirectoryServices.DirectoryVirtualListViewContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryVirtualListView(int beforeCount, int afterCount, string target) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryVirtualListView(int beforeCount, int afterCount, string target, System.DirectoryServices.DirectoryVirtualListViewContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        [System.ComponentModel.DefaultValueAttribute(0)]
        public int AfterCount { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(0)]
        public int ApproximateTotal { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(0)]
        public int BeforeCount { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(null)]
        public System.DirectoryServices.DirectoryVirtualListViewContext DirectoryVirtualListViewContext { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(0)]
        public int Offset { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute("")]
        public string Target { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(0)]
        public int TargetPercentage { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public partial class DirectoryVirtualListViewContext
    {
        public DirectoryVirtualListViewContext() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryVirtualListViewContext Copy() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum ExtendedDN
    {
        None = -1,
        HexString = 0,
        Standard = 1,
    }
    public sealed partial class ExtendedRightAccessRule : System.DirectoryServices.ActiveDirectoryAccessRule
    {
        public ExtendedRightAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ExtendedRightAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ExtendedRightAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ExtendedRightAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.Guid extendedRightType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ExtendedRightAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.Guid extendedRightType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ExtendedRightAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.Guid extendedRightType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public sealed partial class ListChildrenAccessRule : System.DirectoryServices.ActiveDirectoryAccessRule
    {
        public ListChildrenAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ListChildrenAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ListChildrenAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum PasswordEncodingMethod
    {
        PasswordEncodingSsl = 0,
        PasswordEncodingClear = 1,
    }
    public enum PropertyAccess
    {
        Read = 0,
        Write = 1,
    }
    public sealed partial class PropertyAccessRule : System.DirectoryServices.ActiveDirectoryAccessRule
    {
        public PropertyAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.PropertyAccess access) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public PropertyAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.PropertyAccess access, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public PropertyAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.PropertyAccess access, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public PropertyAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.PropertyAccess access, System.Guid propertyType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public PropertyAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.PropertyAccess access, System.Guid propertyType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public PropertyAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.PropertyAccess access, System.Guid propertyType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class PropertyCollection : System.Collections.ICollection, System.Collections.IDictionary, System.Collections.IEnumerable
    {
        internal PropertyCollection() { }
        public int Count { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.PropertyValueCollection this[string propertyName] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Collections.ICollection PropertyNames { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        bool System.Collections.ICollection.IsSynchronized { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        object System.Collections.ICollection.SyncRoot { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        bool System.Collections.IDictionary.IsFixedSize { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        bool System.Collections.IDictionary.IsReadOnly { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        object System.Collections.IDictionary.this[object key] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        System.Collections.ICollection System.Collections.IDictionary.Keys { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Collections.ICollection Values { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(string propertyName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.PropertyValueCollection[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.Collections.IDictionaryEnumerator GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        void System.Collections.ICollection.CopyTo(System.Array array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        void System.Collections.IDictionary.Add(object key, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        void System.Collections.IDictionary.Clear() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        bool System.Collections.IDictionary.Contains(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        void System.Collections.IDictionary.Remove(object key) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public sealed partial class PropertySetAccessRule : System.DirectoryServices.ActiveDirectoryAccessRule
    {
        public PropertySetAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.PropertyAccess access, System.Guid propertySetType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public PropertySetAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.PropertyAccess access, System.Guid propertySetType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public PropertySetAccessRule(System.Security.Principal.IdentityReference identity, System.Security.AccessControl.AccessControlType type, System.DirectoryServices.PropertyAccess access, System.Guid propertySetType, System.DirectoryServices.ActiveDirectorySecurityInheritance inheritanceType, System.Guid inheritedObjectType) : base (default(System.Security.Principal.IdentityReference), default(System.DirectoryServices.ActiveDirectoryRights), default(System.Security.AccessControl.AccessControlType)) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class PropertyValueCollection : System.Collections.CollectionBase
    {
        internal PropertyValueCollection() { }
        public object this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string PropertyName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public object Value { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int Add(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.PropertyValueCollection value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(object[] value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool Contains(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(object[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Insert(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnClearComplete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnInsertComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnRemoveComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnSetComplete(int index, object oldValue, object newValue) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Remove(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum ReferralChasingOption
    {
        None = 0,
        Subordinate = 32,
        External = 64,
        All = 96,
    }
    public partial class ResultPropertyCollection : System.Collections.DictionaryBase
    {
        internal ResultPropertyCollection() { }
        public System.DirectoryServices.ResultPropertyValueCollection this[string name] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Collections.ICollection PropertyNames { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Collections.ICollection Values { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(string propertyName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ResultPropertyValueCollection[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ResultPropertyValueCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ResultPropertyValueCollection() { }
        public object this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(object[] values, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class SchemaNameCollection : System.Collections.ICollection, System.Collections.IEnumerable, System.Collections.IList
    {
        internal SchemaNameCollection() { }
        public int Count { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        bool System.Collections.ICollection.IsSynchronized { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        object System.Collections.ICollection.SyncRoot { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        bool System.Collections.IList.IsFixedSize { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        bool System.Collections.IList.IsReadOnly { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        object System.Collections.IList.this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int Add(string value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.SchemaNameCollection value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(string[] value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Clear() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool Contains(string value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(string[] stringArray, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.Collections.IEnumerator GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(string value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Insert(int index, string value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Remove(string value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RemoveAt(int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        void System.Collections.ICollection.CopyTo(System.Array array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        int System.Collections.IList.Add(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        bool System.Collections.IList.Contains(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        int System.Collections.IList.IndexOf(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        void System.Collections.IList.Insert(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        void System.Collections.IList.Remove(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class SearchResult
    {
        internal SearchResult() { }
        public string Path { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ResultPropertyCollection Properties { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class SearchResultCollection : System.MarshalByRefObject, System.Collections.ICollection, System.Collections.IEnumerable, System.IDisposable
    {
        internal SearchResultCollection() { }
        public int Count { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.IntPtr Handle { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.SearchResult this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string[] PropertiesLoaded { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        bool System.Collections.ICollection.IsSynchronized { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        object System.Collections.ICollection.SyncRoot { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.SearchResult result) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.SearchResult[] results, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public System.Collections.IEnumerator GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.SearchResult result) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        void System.Collections.ICollection.CopyTo(System.Array array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum SearchScope
    {
        Base = 0,
        OneLevel = 1,
        Subtree = 2,
    }
    [System.FlagsAttribute]
    public enum SecurityMasks
    {
        None = 0,
        Owner = 1,
        Group = 2,
        Dacl = 4,
        Sacl = 8,
    }
    public enum SortDirection
    {
        Ascending = 0,
        Descending = 1,
    }
    [System.ComponentModel.TypeConverterAttribute(typeof(System.ComponentModel.ExpandableObjectConverter))]
    public partial class SortOption
    {
        public SortOption() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public SortOption(string propertyName, System.DirectoryServices.SortDirection direction) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        [System.ComponentModel.DefaultValueAttribute(System.DirectoryServices.SortDirection.Ascending)]
        public System.DirectoryServices.SortDirection Direction { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.ComponentModel.DefaultValueAttribute(null)]
        public string PropertyName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
}
namespace System.DirectoryServices.ActiveDirectory
{
    public partial class ActiveDirectoryInterSiteTransport : System.IDisposable
    {
        internal ActiveDirectoryInterSiteTransport() { }
        public bool BridgeAllSiteLinks { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool IgnoreReplicationSchedule { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReadOnlySiteLinkBridgeCollection SiteLinkBridges { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReadOnlySiteLinkCollection SiteLinks { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType TransportType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectoryInterSiteTransport FindByTransportType(System.DirectoryServices.ActiveDirectory.DirectoryContext context, System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType transport) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Save() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectoryObjectExistsException : System.Exception
    {
        public ActiveDirectoryObjectExistsException() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected ActiveDirectoryObjectExistsException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryObjectExistsException(string message) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryObjectExistsException(string message, System.Exception inner) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectoryObjectNotFoundException : System.Exception, System.Runtime.Serialization.ISerializable
    {
        public ActiveDirectoryObjectNotFoundException() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected ActiveDirectoryObjectNotFoundException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryObjectNotFoundException(string message) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryObjectNotFoundException(string message, System.Exception inner) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryObjectNotFoundException(string message, System.Type type, string name) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Type Type { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo serializationInfo, System.Runtime.Serialization.StreamingContext streamingContext) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectoryOperationException : System.Exception, System.Runtime.Serialization.ISerializable
    {
        public ActiveDirectoryOperationException() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected ActiveDirectoryOperationException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryOperationException(string message) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryOperationException(string message, System.Exception inner) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryOperationException(string message, System.Exception inner, int errorCode) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryOperationException(string message, int errorCode) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int ErrorCode { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo serializationInfo, System.Runtime.Serialization.StreamingContext streamingContext) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public abstract partial class ActiveDirectoryPartition : System.IDisposable
    {
        protected ActiveDirectoryPartition() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public abstract System.DirectoryServices.DirectoryEntry GetDirectoryEntry();
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectoryReplicationMetadata : System.Collections.DictionaryBase
    {
        internal ActiveDirectoryReplicationMetadata() { }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyStringCollection AttributeNames { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.AttributeMetadata this[string name] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.AttributeMetadataCollection Values { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(string attributeName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.AttributeMetadata[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum ActiveDirectoryRole
    {
        SchemaRole = 0,
        NamingRole = 1,
        PdcRole = 2,
        RidRole = 3,
        InfrastructureRole = 4,
    }
    public partial class ActiveDirectoryRoleCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ActiveDirectoryRoleCollection() { }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectoryRole this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ActiveDirectoryRole role) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ActiveDirectoryRole[] roles, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ActiveDirectoryRole role) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySchedule
    {
        public ActiveDirectorySchedule() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectorySchedule(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchedule schedule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool[,,] RawSchedule { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void ResetSchedule() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SetDailySchedule(System.DirectoryServices.ActiveDirectory.HourOfDay fromHour, System.DirectoryServices.ActiveDirectory.MinuteOfHour fromMinute, System.DirectoryServices.ActiveDirectory.HourOfDay toHour, System.DirectoryServices.ActiveDirectory.MinuteOfHour toMinute) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SetSchedule(System.DayOfWeek day, System.DirectoryServices.ActiveDirectory.HourOfDay fromHour, System.DirectoryServices.ActiveDirectory.MinuteOfHour fromMinute, System.DirectoryServices.ActiveDirectory.HourOfDay toHour, System.DirectoryServices.ActiveDirectory.MinuteOfHour toMinute) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SetSchedule(System.DayOfWeek[] days, System.DirectoryServices.ActiveDirectory.HourOfDay fromHour, System.DirectoryServices.ActiveDirectory.MinuteOfHour fromMinute, System.DirectoryServices.ActiveDirectory.HourOfDay toHour, System.DirectoryServices.ActiveDirectory.MinuteOfHour toMinute) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySchema : System.DirectoryServices.ActiveDirectory.ActiveDirectoryPartition
    {
        internal ActiveDirectorySchema() { }
        public System.DirectoryServices.ActiveDirectory.DirectoryServer SchemaRoleOwner { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        protected override void Dispose(bool disposing) { }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyActiveDirectorySchemaClassCollection FindAllClasses() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyActiveDirectorySchemaClassCollection FindAllClasses(System.DirectoryServices.ActiveDirectory.SchemaClassType type) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyActiveDirectorySchemaClassCollection FindAllDefunctClasses() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyActiveDirectorySchemaPropertyCollection FindAllDefunctProperties() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyActiveDirectorySchemaPropertyCollection FindAllProperties() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyActiveDirectorySchemaPropertyCollection FindAllProperties(System.DirectoryServices.ActiveDirectory.PropertyTypes type) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass FindClass(string ldapDisplayName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass FindDefunctClass(string commonName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty FindDefunctProperty(string commonName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty FindProperty(string ldapDisplayName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectorySchema GetCurrentSchema() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectorySchema GetSchema(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RefreshSchema() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySchemaClass : System.IDisposable
    {
        public ActiveDirectorySchemaClass(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string ldapDisplayName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClassCollection AuxiliaryClasses { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string CommonName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectorySecurity DefaultObjectSecurityDescriptor { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Description { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool IsDefunct { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaPropertyCollection MandatoryProperties { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Oid { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaPropertyCollection OptionalProperties { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyActiveDirectorySchemaClassCollection PossibleInferiors { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClassCollection PossibleSuperiors { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Guid SchemaGuid { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass SubClassOf { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.SchemaClassType Type { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass FindByName(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string ldapDisplayName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyActiveDirectorySchemaPropertyCollection GetAllProperties() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Save() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySchemaClassCollection : System.Collections.CollectionBase
    {
        internal ActiveDirectorySchemaClassCollection() { }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int Add(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass schemaClass) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClassCollection schemaClasses) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass[] schemaClasses) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ReadOnlyActiveDirectorySchemaClassCollection schemaClasses) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass schemaClass) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass[] schemaClasses, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass schemaClass) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Insert(int index, System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass schemaClass) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnClearComplete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnInsertComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnRemoveComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnSetComplete(int index, object oldValue, object newValue) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnValidate(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Remove(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass schemaClass) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySchemaProperty : System.IDisposable
    {
        public ActiveDirectorySchemaProperty(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string ldapDisplayName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public string CommonName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Description { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool IsDefunct { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool IsInAnr { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool IsIndexed { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool IsIndexedOverContainer { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool IsInGlobalCatalog { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool IsOnTombstonedObject { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool IsSingleValued { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool IsTupleIndexed { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty Link { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int? LinkId { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Oid { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int? RangeLower { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int? RangeUpper { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Guid SchemaGuid { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySyntax Syntax { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty FindByName(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string ldapDisplayName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Save() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySchemaPropertyCollection : System.Collections.CollectionBase
    {
        internal ActiveDirectorySchemaPropertyCollection() { }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int Add(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty schemaProperty) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaPropertyCollection properties) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty[] properties) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ReadOnlyActiveDirectorySchemaPropertyCollection properties) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty schemaProperty) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty[] properties, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty schemaProperty) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Insert(int index, System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty schemaProperty) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnClearComplete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnInsertComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnRemoveComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnSetComplete(int index, object oldValue, object newValue) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnValidate(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Remove(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty schemaProperty) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectoryServerDownException : System.Exception, System.Runtime.Serialization.ISerializable
    {
        public ActiveDirectoryServerDownException() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected ActiveDirectoryServerDownException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryServerDownException(string message) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryServerDownException(string message, System.Exception inner) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryServerDownException(string message, System.Exception inner, int errorCode, string name) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectoryServerDownException(string message, int errorCode, string name) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int ErrorCode { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override string Message { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo serializationInfo, System.Runtime.Serialization.StreamingContext streamingContext) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySite : System.IDisposable
    {
        public ActiveDirectorySite(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReadOnlySiteCollection AdjacentSites { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyDirectoryServerCollection BridgeheadServers { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DomainCollection Domains { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DirectoryServer InterSiteTopologyGenerator { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchedule IntraSiteReplicationSchedule { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Location { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteOptions Options { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DirectoryServerCollection PreferredRpcBridgeheadServers { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DirectoryServerCollection PreferredSmtpBridgeheadServers { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyDirectoryServerCollection Servers { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReadOnlySiteLinkCollection SiteLinks { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySubnetCollection Subnets { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Delete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectorySite FindByName(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectorySite GetComputerSite() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Save() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySiteCollection : System.Collections.CollectionBase
    {
        internal ActiveDirectorySiteCollection() { }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySite this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int Add(System.DirectoryServices.ActiveDirectory.ActiveDirectorySite site) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteCollection sites) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ActiveDirectorySite[] sites) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ActiveDirectorySite site) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ActiveDirectorySite[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ActiveDirectorySite site) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Insert(int index, System.DirectoryServices.ActiveDirectory.ActiveDirectorySite site) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnClearComplete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnInsertComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnRemoveComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnSetComplete(int index, object oldValue, object newValue) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnValidate(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Remove(System.DirectoryServices.ActiveDirectory.ActiveDirectorySite site) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySiteLink : System.IDisposable
    {
        public ActiveDirectorySiteLink(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteLinkName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectorySiteLink(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteLinkName, System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType transport) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectorySiteLink(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteLinkName, System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType transport, System.DirectoryServices.ActiveDirectory.ActiveDirectorySchedule schedule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int Cost { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool DataCompressionEnabled { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchedule InterSiteReplicationSchedule { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool NotificationEnabled { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool ReciprocalReplicationEnabled { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.TimeSpan ReplicationInterval { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteCollection Sites { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType TransportType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Delete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink FindByName(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteLinkName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink FindByName(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteLinkName, System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType transport) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Save() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySiteLinkBridge : System.IDisposable
    {
        public ActiveDirectorySiteLinkBridge(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string bridgeName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectorySiteLinkBridge(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string bridgeName, System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType transport) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLinkCollection SiteLinks { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType TransportType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Delete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLinkBridge FindByName(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string bridgeName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLinkBridge FindByName(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string bridgeName, System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType transport) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Save() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySiteLinkCollection : System.Collections.CollectionBase
    {
        internal ActiveDirectorySiteLinkCollection() { }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int Add(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink link) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLinkCollection links) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink[] links) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink link) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink link) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Insert(int index, System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink link) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnClearComplete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnInsertComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnRemoveComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnSetComplete(int index, object oldValue, object newValue) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnValidate(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Remove(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink link) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    [System.FlagsAttribute]
    public enum ActiveDirectorySiteOptions
    {
        None = 0,
        AutoTopologyDisabled = 1,
        TopologyCleanupDisabled = 2,
        AutoMinimumHopDisabled = 4,
        StaleServerDetectDisabled = 8,
        AutoInterSiteTopologyDisabled = 16,
        GroupMembershipCachingEnabled = 32,
        ForceKccWindows2003Behavior = 64,
        UseWindows2000IstgElection = 128,
        RandomBridgeHeaderServerSelectionDisabled = 256,
        UseHashingForReplicationSchedule = 512,
        RedundantServerTopologyEnabled = 1024,
    }
    public partial class ActiveDirectorySubnet : System.IDisposable
    {
        public ActiveDirectorySubnet(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string subnetName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ActiveDirectorySubnet(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string subnetName, string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public string Location { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySite Site { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Delete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public static System.DirectoryServices.ActiveDirectory.ActiveDirectorySubnet FindByName(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string subnetName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Save() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ActiveDirectorySubnetCollection : System.Collections.CollectionBase
    {
        internal ActiveDirectorySubnetCollection() { }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySubnet this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int Add(System.DirectoryServices.ActiveDirectory.ActiveDirectorySubnet subnet) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ActiveDirectorySubnetCollection subnets) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.ActiveDirectorySubnet[] subnets) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ActiveDirectorySubnet subnet) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ActiveDirectorySubnet[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ActiveDirectorySubnet subnet) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Insert(int index, System.DirectoryServices.ActiveDirectory.ActiveDirectorySubnet subnet) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnClear() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnClearComplete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnInsertComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnRemoveComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnSetComplete(int index, object oldValue, object newValue) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnValidate(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Remove(System.DirectoryServices.ActiveDirectory.ActiveDirectorySubnet subnet) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum ActiveDirectorySyntax
    {
        CaseExactString = 0,
        CaseIgnoreString = 1,
        NumericString = 2,
        DirectoryString = 3,
        OctetString = 4,
        SecurityDescriptor = 5,
        Int = 6,
        Int64 = 7,
        Bool = 8,
        Oid = 9,
        GeneralizedTime = 10,
        UtcTime = 11,
        DN = 12,
        DNWithBinary = 13,
        DNWithString = 14,
        Enumeration = 15,
        IA5String = 16,
        PrintableString = 17,
        Sid = 18,
        AccessPointDN = 19,
        ORName = 20,
        PresentationAddress = 21,
        ReplicaLink = 22,
    }
    public enum ActiveDirectoryTransportType
    {
        Rpc = 0,
        Smtp = 1,
    }
    public partial class AdamInstance : System.DirectoryServices.ActiveDirectory.DirectoryServer
    {
        internal AdamInstance() { }
        public System.DirectoryServices.ActiveDirectory.ConfigurationSet ConfigurationSet { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string DefaultPartition { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string HostName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override System.DirectoryServices.ActiveDirectory.ReplicationConnectionCollection InboundConnections { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override string IPAddress { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int LdapPort { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override System.DirectoryServices.ActiveDirectory.ReplicationConnectionCollection OutboundConnections { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.AdamRoleCollection Roles { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override string SiteName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int SslPort { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override System.DirectoryServices.ActiveDirectory.SyncUpdateCallback SyncFromAllServersCallback { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override void CheckReplicationConsistency() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void Dispose(bool disposing) { }
        public static System.DirectoryServices.ActiveDirectory.AdamInstanceCollection FindAll(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string partitionName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.AdamInstance FindOne(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string partitionName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.AdamInstance GetAdamInstance(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ReplicationNeighborCollection GetAllReplicationNeighbors() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ReplicationFailureCollection GetReplicationConnectionFailures() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ReplicationCursorCollection GetReplicationCursors(string partition) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ActiveDirectoryReplicationMetadata GetReplicationMetadata(string objectPath) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ReplicationNeighborCollection GetReplicationNeighbors(string partition) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ReplicationOperationInformation GetReplicationOperationInformation() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Save() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SeizeRoleOwnership(System.DirectoryServices.ActiveDirectory.AdamRole role) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override void SyncReplicaFromAllServers(string partition, System.DirectoryServices.ActiveDirectory.SyncFromAllServersOptions options) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override void SyncReplicaFromServer(string partition, string sourceServer) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void TransferRoleOwnership(System.DirectoryServices.ActiveDirectory.AdamRole role) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override void TriggerSyncReplicaFromNeighbors(string partition) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class AdamInstanceCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal AdamInstanceCollection() { }
        public System.DirectoryServices.ActiveDirectory.AdamInstance this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.AdamInstance adamInstance) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.AdamInstance[] adamInstances, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.AdamInstance adamInstance) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum AdamRole
    {
        SchemaRole = 0,
        NamingRole = 1,
    }
    public partial class AdamRoleCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal AdamRoleCollection() { }
        public System.DirectoryServices.ActiveDirectory.AdamRole this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.AdamRole role) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.AdamRole[] roles, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.AdamRole role) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ApplicationPartition : System.DirectoryServices.ActiveDirectory.ActiveDirectoryPartition
    {
        public ApplicationPartition(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string distinguishedName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ApplicationPartition(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string distinguishedName, string objectClass) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DirectoryServerCollection DirectoryServers { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string SecurityReferenceDomain { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Delete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void Dispose(bool disposing) { }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyDirectoryServerCollection FindAllDirectoryServers() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyDirectoryServerCollection FindAllDirectoryServers(string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyDirectoryServerCollection FindAllDiscoverableDirectoryServers() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyDirectoryServerCollection FindAllDiscoverableDirectoryServers(string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.ApplicationPartition FindByName(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string distinguishedName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DirectoryServer FindDirectoryServer() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DirectoryServer FindDirectoryServer(bool forceRediscovery) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DirectoryServer FindDirectoryServer(string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DirectoryServer FindDirectoryServer(string siteName, bool forceRediscovery) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.ApplicationPartition GetApplicationPartition(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Save() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ApplicationPartitionCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ApplicationPartitionCollection() { }
        public System.DirectoryServices.ActiveDirectory.ApplicationPartition this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ApplicationPartition applicationPartition) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ApplicationPartition[] applicationPartitions, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ApplicationPartition applicationPartition) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class AttributeMetadata
    {
        internal AttributeMetadata() { }
        public System.DateTime LastOriginatingChangeTime { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Guid LastOriginatingInvocationId { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public long LocalChangeUsn { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public long OriginatingChangeUsn { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string OriginatingServer { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int Version { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public partial class AttributeMetadataCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal AttributeMetadataCollection() { }
        public System.DirectoryServices.ActiveDirectory.AttributeMetadata this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.AttributeMetadata metadata) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.AttributeMetadata[] metadata, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.AttributeMetadata metadata) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ConfigurationSet
    {
        internal ConfigurationSet() { }
        public System.DirectoryServices.ActiveDirectory.AdamInstanceCollection AdamInstances { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ApplicationPartitionCollection ApplicationPartitions { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.AdamInstance NamingRoleOwner { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchema Schema { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.AdamInstance SchemaRoleOwner { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReadOnlySiteCollection Sites { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public System.DirectoryServices.ActiveDirectory.AdamInstance FindAdamInstance() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.AdamInstance FindAdamInstance(string partitionName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.AdamInstance FindAdamInstance(string partitionName, string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.AdamInstanceCollection FindAllAdamInstances() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.AdamInstanceCollection FindAllAdamInstances(string partitionName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.AdamInstanceCollection FindAllAdamInstances(string partitionName, string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.ConfigurationSet GetConfigurationSet(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReplicationSecurityLevel GetSecurityLevel() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SetSecurityLevel(System.DirectoryServices.ActiveDirectory.ReplicationSecurityLevel securityLevel) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class DirectoryContext
    {
        public DirectoryContext(System.DirectoryServices.ActiveDirectory.DirectoryContextType contextType) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryContext(System.DirectoryServices.ActiveDirectory.DirectoryContextType contextType, string name) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryContext(System.DirectoryServices.ActiveDirectory.DirectoryContextType contextType, string username, string password) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public DirectoryContext(System.DirectoryServices.ActiveDirectory.DirectoryContextType contextType, string name, string username, string password) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DirectoryContextType ContextType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string UserName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public enum DirectoryContextType
    {
        Domain = 0,
        Forest = 1,
        DirectoryServer = 2,
        ConfigurationSet = 3,
        ApplicationPartition = 4,
    }
    public abstract partial class DirectoryServer : System.IDisposable
    {
        protected DirectoryServer() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public abstract System.DirectoryServices.ActiveDirectory.ReplicationConnectionCollection InboundConnections { get; }
        public abstract string IPAddress { get; }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public abstract System.DirectoryServices.ActiveDirectory.ReplicationConnectionCollection OutboundConnections { get; }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyStringCollection Partitions { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public abstract string SiteName { get; }
        public abstract System.DirectoryServices.ActiveDirectory.SyncUpdateCallback SyncFromAllServersCallback { get; set; }
        public abstract void CheckReplicationConsistency();
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public abstract System.DirectoryServices.ActiveDirectory.ReplicationNeighborCollection GetAllReplicationNeighbors();
        public System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public abstract System.DirectoryServices.ActiveDirectory.ReplicationFailureCollection GetReplicationConnectionFailures();
        public abstract System.DirectoryServices.ActiveDirectory.ReplicationCursorCollection GetReplicationCursors(string partition);
        public abstract System.DirectoryServices.ActiveDirectory.ActiveDirectoryReplicationMetadata GetReplicationMetadata(string objectPath);
        public abstract System.DirectoryServices.ActiveDirectory.ReplicationNeighborCollection GetReplicationNeighbors(string partition);
        public abstract System.DirectoryServices.ActiveDirectory.ReplicationOperationInformation GetReplicationOperationInformation();
        public void MoveToAnotherSite(string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public abstract void SyncReplicaFromAllServers(string partition, System.DirectoryServices.ActiveDirectory.SyncFromAllServersOptions options);
        public abstract void SyncReplicaFromServer(string partition, string sourceServer);
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public abstract void TriggerSyncReplicaFromNeighbors(string partition);
    }
    public partial class DirectoryServerCollection : System.Collections.CollectionBase
    {
        internal DirectoryServerCollection() { }
        public System.DirectoryServices.ActiveDirectory.DirectoryServer this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int Add(System.DirectoryServices.ActiveDirectory.DirectoryServer server) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void AddRange(System.DirectoryServices.ActiveDirectory.DirectoryServer[] servers) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool Contains(System.DirectoryServices.ActiveDirectory.DirectoryServer server) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.DirectoryServer[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.DirectoryServer server) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Insert(int index, System.DirectoryServices.ActiveDirectory.DirectoryServer server) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnClear() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnClearComplete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnInsertComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnRemoveComplete(int index, object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnSetComplete(int index, object oldValue, object newValue) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void OnValidate(object value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Remove(System.DirectoryServices.ActiveDirectory.DirectoryServer server) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class Domain : System.DirectoryServices.ActiveDirectory.ActiveDirectoryPartition
    {
        internal Domain() { }
        public System.DirectoryServices.ActiveDirectory.DomainCollection Children { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DomainControllerCollection DomainControllers { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DomainMode DomainMode { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int DomainModeLevel { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.Forest Forest { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DomainController InfrastructureRoleOwner { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.Domain Parent { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DomainController PdcRoleOwner { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DomainController RidRoleOwner { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void CreateLocalSideOfTrustRelationship(string targetDomainName, System.DirectoryServices.ActiveDirectory.TrustDirection direction, string trustPassword) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CreateTrustRelationship(System.DirectoryServices.ActiveDirectory.Domain targetDomain, System.DirectoryServices.ActiveDirectory.TrustDirection direction) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void DeleteLocalSideOfTrustRelationship(string targetDomainName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void DeleteTrustRelationship(System.DirectoryServices.ActiveDirectory.Domain targetDomain) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DomainControllerCollection FindAllDiscoverableDomainControllers() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DomainControllerCollection FindAllDiscoverableDomainControllers(string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DomainControllerCollection FindAllDomainControllers() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DomainControllerCollection FindAllDomainControllers(string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DomainController FindDomainController() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DomainController FindDomainController(System.DirectoryServices.ActiveDirectory.LocatorOptions flag) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DomainController FindDomainController(string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.DomainController FindDomainController(string siteName, System.DirectoryServices.ActiveDirectory.LocatorOptions flag) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.TrustRelationshipInformationCollection GetAllTrustRelationships() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.Domain GetComputerDomain() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.Domain GetCurrentDomain() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.Domain GetDomain(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool GetSelectiveAuthenticationStatus(string targetDomainName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool GetSidFilteringStatus(string targetDomainName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.TrustRelationshipInformation GetTrustRelationship(string targetDomainName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RaiseDomainFunctionality(System.DirectoryServices.ActiveDirectory.DomainMode domainMode) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RaiseDomainFunctionalityLevel(int domainMode) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RepairTrustRelationship(System.DirectoryServices.ActiveDirectory.Domain targetDomain) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SetSelectiveAuthenticationStatus(string targetDomainName, bool enable) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SetSidFilteringStatus(string targetDomainName, bool enable) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void UpdateLocalSideOfTrustRelationship(string targetDomainName, System.DirectoryServices.ActiveDirectory.TrustDirection newTrustDirection, string newTrustPassword) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void UpdateLocalSideOfTrustRelationship(string targetDomainName, string newTrustPassword) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void UpdateTrustRelationship(System.DirectoryServices.ActiveDirectory.Domain targetDomain, System.DirectoryServices.ActiveDirectory.TrustDirection newTrustDirection) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void VerifyOutboundTrustRelationship(string targetDomainName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void VerifyTrustRelationship(System.DirectoryServices.ActiveDirectory.Domain targetDomain, System.DirectoryServices.ActiveDirectory.TrustDirection direction) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class DomainCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal DomainCollection() { }
        public System.DirectoryServices.ActiveDirectory.Domain this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.Domain domain) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.Domain[] domains, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.Domain domain) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    [System.FlagsAttribute]
    public enum DomainCollisionOptions
    {
        None = 0,
        SidDisabledByAdmin = 1,
        SidDisabledByConflict = 2,
        NetBiosNameDisabledByAdmin = 4,
        NetBiosNameDisabledByConflict = 8,
    }
    public partial class DomainController : System.DirectoryServices.ActiveDirectory.DirectoryServer
    {
        protected DomainController() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DateTime CurrentTime { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.Domain Domain { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.Forest Forest { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public long HighestCommittedUsn { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override System.DirectoryServices.ActiveDirectory.ReplicationConnectionCollection InboundConnections { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override string IPAddress { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string OSVersion { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override System.DirectoryServices.ActiveDirectory.ReplicationConnectionCollection OutboundConnections { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectoryRoleCollection Roles { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override string SiteName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override System.DirectoryServices.ActiveDirectory.SyncUpdateCallback SyncFromAllServersCallback { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override void CheckReplicationConsistency() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected override void Dispose(bool disposing) { }
        public virtual System.DirectoryServices.ActiveDirectory.GlobalCatalog EnableGlobalCatalog() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.DomainControllerCollection FindAll(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.DomainControllerCollection FindAll(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.DomainController FindOne(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.DomainController FindOne(System.DirectoryServices.ActiveDirectory.DirectoryContext context, System.DirectoryServices.ActiveDirectory.LocatorOptions flag) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.DomainController FindOne(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.DomainController FindOne(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteName, System.DirectoryServices.ActiveDirectory.LocatorOptions flag) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ReplicationNeighborCollection GetAllReplicationNeighbors() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public virtual System.DirectoryServices.DirectorySearcher GetDirectorySearcher() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.DomainController GetDomainController(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ReplicationFailureCollection GetReplicationConnectionFailures() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ReplicationCursorCollection GetReplicationCursors(string partition) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ActiveDirectoryReplicationMetadata GetReplicationMetadata(string objectPath) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ReplicationNeighborCollection GetReplicationNeighbors(string partition) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.ReplicationOperationInformation GetReplicationOperationInformation() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public virtual bool IsGlobalCatalog() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SeizeRoleOwnership(System.DirectoryServices.ActiveDirectory.ActiveDirectoryRole role) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override void SyncReplicaFromAllServers(string partition, System.DirectoryServices.ActiveDirectory.SyncFromAllServersOptions options) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override void SyncReplicaFromServer(string partition, string sourceServer) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void TransferRoleOwnership(System.DirectoryServices.ActiveDirectory.ActiveDirectoryRole role) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override void TriggerSyncReplicaFromNeighbors(string partition) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class DomainControllerCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal DomainControllerCollection() { }
        public System.DirectoryServices.ActiveDirectory.DomainController this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.DomainController domainController) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.DomainController[] domainControllers, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.DomainController domainController) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum DomainMode
    {
        Unknown = -1,
        Windows2000MixedDomain = 0,
        Windows2000NativeDomain = 1,
        Windows2003InterimDomain = 2,
        Windows2003Domain = 3,
        Windows2008Domain = 4,
        Windows2008R2Domain = 5,
        Windows8Domain = 6,
        Windows2012R2Domain = 7,
    }
    public partial class Forest : System.IDisposable
    {
        internal Forest() { }
        public System.DirectoryServices.ActiveDirectory.ApplicationPartitionCollection ApplicationPartitions { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DomainCollection Domains { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ForestMode ForestMode { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int ForestModeLevel { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.GlobalCatalogCollection GlobalCatalogs { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DomainController NamingRoleOwner { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.Domain RootDomain { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchema Schema { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DomainController SchemaRoleOwner { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReadOnlySiteCollection Sites { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void CreateLocalSideOfTrustRelationship(string targetForestName, System.DirectoryServices.ActiveDirectory.TrustDirection direction, string trustPassword) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CreateTrustRelationship(System.DirectoryServices.ActiveDirectory.Forest targetForest, System.DirectoryServices.ActiveDirectory.TrustDirection direction) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void DeleteLocalSideOfTrustRelationship(string targetForestName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void DeleteTrustRelationship(System.DirectoryServices.ActiveDirectory.Forest targetForest) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Dispose() { }
        protected void Dispose(bool disposing) { }
        public System.DirectoryServices.ActiveDirectory.GlobalCatalogCollection FindAllDiscoverableGlobalCatalogs() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.GlobalCatalogCollection FindAllDiscoverableGlobalCatalogs(string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.GlobalCatalogCollection FindAllGlobalCatalogs() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.GlobalCatalogCollection FindAllGlobalCatalogs(string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.GlobalCatalog FindGlobalCatalog() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.GlobalCatalog FindGlobalCatalog(System.DirectoryServices.ActiveDirectory.LocatorOptions flag) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.GlobalCatalog FindGlobalCatalog(string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.GlobalCatalog FindGlobalCatalog(string siteName, System.DirectoryServices.ActiveDirectory.LocatorOptions flag) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.TrustRelationshipInformationCollection GetAllTrustRelationships() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.Forest GetCurrentForest() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.Forest GetForest(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool GetSelectiveAuthenticationStatus(string targetForestName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public bool GetSidFilteringStatus(string targetForestName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ForestTrustRelationshipInformation GetTrustRelationship(string targetForestName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RaiseForestFunctionality(System.DirectoryServices.ActiveDirectory.ForestMode forestMode) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RaiseForestFunctionalityLevel(int forestMode) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void RepairTrustRelationship(System.DirectoryServices.ActiveDirectory.Forest targetForest) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SetSelectiveAuthenticationStatus(string targetForestName, bool enable) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void SetSidFilteringStatus(string targetForestName, bool enable) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void UpdateLocalSideOfTrustRelationship(string targetForestName, System.DirectoryServices.ActiveDirectory.TrustDirection newTrustDirection, string newTrustPassword) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void UpdateLocalSideOfTrustRelationship(string targetForestName, string newTrustPassword) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void UpdateTrustRelationship(System.DirectoryServices.ActiveDirectory.Forest targetForest, System.DirectoryServices.ActiveDirectory.TrustDirection newTrustDirection) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void VerifyOutboundTrustRelationship(string targetForestName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void VerifyTrustRelationship(System.DirectoryServices.ActiveDirectory.Forest targetForest, System.DirectoryServices.ActiveDirectory.TrustDirection direction) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum ForestMode
    {
        Unknown = -1,
        Windows2000Forest = 0,
        Windows2003InterimForest = 1,
        Windows2003Forest = 2,
        Windows2008Forest = 3,
        Windows2008R2Forest = 4,
        Windows8Forest = 5,
        Windows2012R2Forest = 6,
    }
    public partial class ForestTrustCollisionException : System.DirectoryServices.ActiveDirectory.ActiveDirectoryOperationException, System.Runtime.Serialization.ISerializable
    {
        public ForestTrustCollisionException() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected ForestTrustCollisionException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ForestTrustCollisionException(string message) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ForestTrustCollisionException(string message, System.Exception inner) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ForestTrustCollisionException(string message, System.Exception inner, System.DirectoryServices.ActiveDirectory.ForestTrustRelationshipCollisionCollection collisions) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ForestTrustRelationshipCollisionCollection Collisions { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo serializationInfo, System.Runtime.Serialization.StreamingContext streamingContext) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum ForestTrustCollisionType
    {
        TopLevelName = 0,
        Domain = 1,
        Other = 2,
    }
    public partial class ForestTrustDomainInfoCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ForestTrustDomainInfoCollection() { }
        public System.DirectoryServices.ActiveDirectory.ForestTrustDomainInformation this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ForestTrustDomainInformation information) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ForestTrustDomainInformation[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ForestTrustDomainInformation information) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ForestTrustDomainInformation
    {
        internal ForestTrustDomainInformation() { }
        public string DnsName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string DomainSid { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string NetBiosName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ForestTrustDomainStatus Status { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public enum ForestTrustDomainStatus
    {
        Enabled = 0,
        SidAdminDisabled = 1,
        SidConflictDisabled = 2,
        NetBiosNameAdminDisabled = 4,
        NetBiosNameConflictDisabled = 8,
    }
    public partial class ForestTrustRelationshipCollision
    {
        internal ForestTrustRelationshipCollision() { }
        public string CollisionRecord { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ForestTrustCollisionType CollisionType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.DomainCollisionOptions DomainCollisionOption { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.TopLevelNameCollisionOptions TopLevelNameCollisionOption { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public partial class ForestTrustRelationshipCollisionCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ForestTrustRelationshipCollisionCollection() { }
        public System.DirectoryServices.ActiveDirectory.ForestTrustRelationshipCollision this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ForestTrustRelationshipCollision collision) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ForestTrustRelationshipCollision[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ForestTrustRelationshipCollision collision) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ForestTrustRelationshipInformation : System.DirectoryServices.ActiveDirectory.TrustRelationshipInformation
    {
        internal ForestTrustRelationshipInformation() { }
        public System.Collections.Specialized.StringCollection ExcludedTopLevelNames { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.TopLevelNameCollection TopLevelNames { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ForestTrustDomainInfoCollection TrustedDomainInformation { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Save() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class GlobalCatalog : System.DirectoryServices.ActiveDirectory.DomainController
    {
        internal GlobalCatalog() { }
        public System.DirectoryServices.ActiveDirectory.DomainController DisableGlobalCatalog() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.ActiveDirectory.GlobalCatalog EnableGlobalCatalog() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static new System.DirectoryServices.ActiveDirectory.GlobalCatalogCollection FindAll(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static new System.DirectoryServices.ActiveDirectory.GlobalCatalogCollection FindAll(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReadOnlyActiveDirectorySchemaPropertyCollection FindAllProperties() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static new System.DirectoryServices.ActiveDirectory.GlobalCatalog FindOne(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static new System.DirectoryServices.ActiveDirectory.GlobalCatalog FindOne(System.DirectoryServices.ActiveDirectory.DirectoryContext context, System.DirectoryServices.ActiveDirectory.LocatorOptions flag) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static new System.DirectoryServices.ActiveDirectory.GlobalCatalog FindOne(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteName) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static new System.DirectoryServices.ActiveDirectory.GlobalCatalog FindOne(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string siteName, System.DirectoryServices.ActiveDirectory.LocatorOptions flag) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override System.DirectoryServices.DirectorySearcher GetDirectorySearcher() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public static System.DirectoryServices.ActiveDirectory.GlobalCatalog GetGlobalCatalog(System.DirectoryServices.ActiveDirectory.DirectoryContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override bool IsGlobalCatalog() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class GlobalCatalogCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal GlobalCatalogCollection() { }
        public System.DirectoryServices.ActiveDirectory.GlobalCatalog this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.GlobalCatalog globalCatalog) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.GlobalCatalog[] globalCatalogs, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.GlobalCatalog globalCatalog) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum HourOfDay
    {
        Zero = 0,
        One = 1,
        Two = 2,
        Three = 3,
        Four = 4,
        Five = 5,
        Six = 6,
        Seven = 7,
        Eight = 8,
        Nine = 9,
        Ten = 10,
        Eleven = 11,
        Twelve = 12,
        Thirteen = 13,
        Fourteen = 14,
        Fifteen = 15,
        Sixteen = 16,
        Seventeen = 17,
        Eighteen = 18,
        Nineteen = 19,
        Twenty = 20,
        TwentyOne = 21,
        TwentyTwo = 22,
        TwentyThree = 23,
    }
    [System.FlagsAttribute]
    public enum LocatorOptions : long
    {
        ForceRediscovery = (long)1,
        KdcRequired = (long)1024,
        TimeServerRequired = (long)2048,
        WriteableRequired = (long)4096,
        AvoidSelf = (long)16384,
    }
    public enum MinuteOfHour
    {
        Zero = 0,
        Fifteen = 15,
        Thirty = 30,
        FortyFive = 45,
    }
    public enum NotificationStatus
    {
        NoNotification = 0,
        IntraSiteOnly = 1,
        NotificationAlways = 2,
    }
    [System.FlagsAttribute]
    public enum PropertyTypes
    {
        Indexed = 2,
        InGlobalCatalog = 4,
    }
    public partial class ReadOnlyActiveDirectorySchemaClassCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReadOnlyActiveDirectorySchemaClassCollection() { }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass schemaClass) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass[] classes, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaClass schemaClass) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReadOnlyActiveDirectorySchemaPropertyCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReadOnlyActiveDirectorySchemaPropertyCollection() { }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty schemaProperty) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty[] properties, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ActiveDirectorySchemaProperty schemaProperty) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReadOnlyDirectoryServerCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReadOnlyDirectoryServerCollection() { }
        public System.DirectoryServices.ActiveDirectory.DirectoryServer this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.DirectoryServer directoryServer) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.DirectoryServer[] directoryServers, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.DirectoryServer directoryServer) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReadOnlySiteCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReadOnlySiteCollection() { }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySite this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ActiveDirectorySite site) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ActiveDirectorySite[] sites, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ActiveDirectorySite site) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReadOnlySiteLinkBridgeCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReadOnlySiteLinkBridgeCollection() { }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLinkBridge this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLinkBridge bridge) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLinkBridge[] bridges, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLinkBridge bridge) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReadOnlySiteLinkCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReadOnlySiteLinkCollection() { }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink link) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink[] links, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ActiveDirectorySiteLink link) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReadOnlyStringCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReadOnlyStringCollection() { }
        public string this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(string value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(string[] values, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(string value) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReplicationConnection : System.IDisposable
    {
        public ReplicationConnection(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string name, System.DirectoryServices.ActiveDirectory.DirectoryServer sourceServer) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ReplicationConnection(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string name, System.DirectoryServices.ActiveDirectory.DirectoryServer sourceServer, System.DirectoryServices.ActiveDirectory.ActiveDirectorySchedule schedule) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ReplicationConnection(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string name, System.DirectoryServices.ActiveDirectory.DirectoryServer sourceServer, System.DirectoryServices.ActiveDirectory.ActiveDirectorySchedule schedule, System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType transport) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public ReplicationConnection(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string name, System.DirectoryServices.ActiveDirectory.DirectoryServer sourceServer, System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType transport) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.NotificationStatus ChangeNotificationStatus { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool DataCompressionEnabled { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string DestinationServer { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Enabled { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool GeneratedByKcc { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool ReciprocalReplicationEnabled { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectorySchedule ReplicationSchedule { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool ReplicationScheduleOwnedByUser { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReplicationSpan ReplicationSpan { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string SourceServer { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType TransportType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public void Delete() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public static System.DirectoryServices.ActiveDirectory.ReplicationConnection FindByName(System.DirectoryServices.ActiveDirectory.DirectoryContext context, string name) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.DirectoryEntry GetDirectoryEntry() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void Save() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReplicationConnectionCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReplicationConnectionCollection() { }
        public System.DirectoryServices.ActiveDirectory.ReplicationConnection this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ReplicationConnection connection) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ReplicationConnection[] connections, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ReplicationConnection connection) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReplicationCursor
    {
        internal ReplicationCursor() { }
        public System.DateTime LastSuccessfulSyncTime { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string PartitionName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Guid SourceInvocationId { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string SourceServer { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public long UpToDatenessUsn { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public partial class ReplicationCursorCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReplicationCursorCollection() { }
        public System.DirectoryServices.ActiveDirectory.ReplicationCursor this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ReplicationCursor cursor) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ReplicationCursor[] values, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ReplicationCursor cursor) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReplicationFailure
    {
        internal ReplicationFailure() { }
        public int ConsecutiveFailureCount { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DateTime FirstFailureTime { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int LastErrorCode { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string LastErrorMessage { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string SourceServer { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public partial class ReplicationFailureCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReplicationFailureCollection() { }
        public System.DirectoryServices.ActiveDirectory.ReplicationFailure this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ReplicationFailure failure) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ReplicationFailure[] failures, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ReplicationFailure failure) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReplicationNeighbor
    {
        internal ReplicationNeighbor() { }
        public int ConsecutiveFailureCount { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DateTime LastAttemptedSync { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DateTime LastSuccessfulSync { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string LastSyncMessage { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int LastSyncResult { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string PartitionName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReplicationNeighbor.ReplicationNeighborOptions ReplicationNeighborOption { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.Guid SourceInvocationId { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string SourceServer { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ActiveDirectoryTransportType TransportType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public long UsnAttributeFilter { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public long UsnLastObjectChangeSynced { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        [System.FlagsAttribute]
        public enum ReplicationNeighborOptions : long
        {
            Writeable = (long)16,
            SyncOnStartup = (long)32,
            ScheduledSync = (long)64,
            UseInterSiteTransport = (long)128,
            TwoWaySync = (long)512,
            ReturnObjectParent = (long)2048,
            FullSyncInProgress = (long)65536,
            FullSyncNextPacket = (long)131072,
            NeverSynced = (long)2097152,
            Preempted = (long)16777216,
            IgnoreChangeNotifications = (long)67108864,
            DisableScheduledSync = (long)134217728,
            CompressChanges = (long)268435456,
            NoChangeNotifications = (long)536870912,
            PartialAttributeSet = (long)1073741824,
        }
    }
    public partial class ReplicationNeighborCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReplicationNeighborCollection() { }
        public System.DirectoryServices.ActiveDirectory.ReplicationNeighbor this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ReplicationNeighbor neighbor) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ReplicationNeighbor[] neighbors, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ReplicationNeighbor neighbor) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReplicationOperation
    {
        internal ReplicationOperation() { }
        public int OperationNumber { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReplicationOperationType OperationType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string PartitionName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int Priority { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string SourceServer { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DateTime TimeEnqueued { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public partial class ReplicationOperationCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal ReplicationOperationCollection() { }
        public System.DirectoryServices.ActiveDirectory.ReplicationOperation this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.ReplicationOperation operation) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.ReplicationOperation[] operations, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.ReplicationOperation operation) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public partial class ReplicationOperationInformation
    {
        public ReplicationOperationInformation() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.ReplicationOperation CurrentOperation { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DateTime OperationStartTime { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.ReplicationOperationCollection PendingOperations { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public enum ReplicationOperationType
    {
        Sync = 0,
        Add = 1,
        Delete = 2,
        Modify = 3,
        UpdateReference = 4,
    }
    public enum ReplicationSecurityLevel
    {
        NegotiatePassThrough = 0,
        Negotiate = 1,
        MutualAuthentication = 2,
    }
    public enum ReplicationSpan
    {
        IntraSite = 0,
        InterSite = 1,
    }
    public enum SchemaClassType
    {
        Type88 = 0,
        Structural = 1,
        Abstract = 2,
        Auxiliary = 3,
    }
    public enum SyncFromAllServersErrorCategory
    {
        ErrorContactingServer = 0,
        ErrorReplicating = 1,
        ServerUnreachable = 2,
    }
    public partial class SyncFromAllServersErrorInformation
    {
        internal SyncFromAllServersErrorInformation() { }
        public System.DirectoryServices.ActiveDirectory.SyncFromAllServersErrorCategory ErrorCategory { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public int ErrorCode { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string ErrorMessage { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string SourceServer { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string TargetServer { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public enum SyncFromAllServersEvent
    {
        Error = 0,
        SyncStarted = 1,
        SyncCompleted = 2,
        Finished = 3,
    }
    public partial class SyncFromAllServersOperationException : System.DirectoryServices.ActiveDirectory.ActiveDirectoryOperationException, System.Runtime.Serialization.ISerializable
    {
        public SyncFromAllServersOperationException() { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        protected SyncFromAllServersOperationException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public SyncFromAllServersOperationException(string message) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public SyncFromAllServersOperationException(string message, System.Exception inner) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public SyncFromAllServersOperationException(string message, System.Exception inner, System.DirectoryServices.ActiveDirectory.SyncFromAllServersErrorInformation[] errors) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public System.DirectoryServices.ActiveDirectory.SyncFromAllServersErrorInformation[] ErrorInformation { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo serializationInfo, System.Runtime.Serialization.StreamingContext streamingContext) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    [System.FlagsAttribute]
    public enum SyncFromAllServersOptions
    {
        None = 0,
        AbortIfServerUnavailable = 1,
        SyncAdjacentServerOnly = 2,
        CheckServerAlivenessOnly = 8,
        SkipInitialCheck = 16,
        PushChangeOutward = 32,
        CrossSite = 64,
    }
    public delegate bool SyncUpdateCallback(System.DirectoryServices.ActiveDirectory.SyncFromAllServersEvent eventType, string targetServer, string sourceServer, System.DirectoryServices.ActiveDirectory.SyncFromAllServersOperationException exception);
    public partial class TopLevelName
    {
        internal TopLevelName() { }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.TopLevelNameStatus Status { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } set { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public partial class TopLevelNameCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal TopLevelNameCollection() { }
        public System.DirectoryServices.ActiveDirectory.TopLevelName this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.TopLevelName name) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.TopLevelName[] names, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.TopLevelName name) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    [System.FlagsAttribute]
    public enum TopLevelNameCollisionOptions
    {
        None = 0,
        NewlyCreated = 1,
        DisabledByAdmin = 2,
        DisabledByConflict = 4,
    }
    public enum TopLevelNameStatus
    {
        Enabled = 0,
        NewlyCreated = 1,
        AdminDisabled = 2,
        ConflictDisabled = 4,
    }
    public enum TrustDirection
    {
        Inbound = 1,
        Outbound = 2,
        Bidirectional = 3,
    }
    public partial class TrustRelationshipInformation
    {
        internal TrustRelationshipInformation() { }
        public string SourceName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public string TargetName { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.TrustDirection TrustDirection { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public System.DirectoryServices.ActiveDirectory.TrustType TrustType { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
    }
    public partial class TrustRelationshipInformationCollection : System.Collections.ReadOnlyCollectionBase
    {
        internal TrustRelationshipInformationCollection() { }
        public System.DirectoryServices.ActiveDirectory.TrustRelationshipInformation this[int index] { get { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); } }
        public bool Contains(System.DirectoryServices.ActiveDirectory.TrustRelationshipInformation information) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public void CopyTo(System.DirectoryServices.ActiveDirectory.TrustRelationshipInformation[] array, int index) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
        public int IndexOf(System.DirectoryServices.ActiveDirectory.TrustRelationshipInformation information) { throw new System.PlatformNotSupportedException(System.SR.DirectoryServices_PlatformNotSupported); }
    }
    public enum TrustType
    {
        TreeRoot = 0,
        ParentChild = 1,
        CrossLink = 2,
        External = 3,
        Forest = 4,
        Kerberos = 5,
        Unknown = 6,
    }
}
