DEFAULT: all

.PHONY: install-sdk-lib

monocmd = $(shell which mono)
monocmddir = $(dir $(monocmd))
prefix = $(shell (cd $(monocmddir)/..; pwd))
thisdir = $(dir $(realpath $(lastword $(MAKEFILE_LIST))))
topdir = $(thisdir)../
builddir = $(topdir)
libdir = $(prefix)/lib/
bindir = $(prefix)/bin/
monobindir = $(bindir)
monolibdir = $(libdir)
monodir = $(monolibdir)mono

debugvars:
	@echo prefix=$(prefix)
	@echo topdir=$(topdir)
	@echo monodir=$(monodir)
	@echo monolibdir=$(monolibdir)
	@echo monobindir=$(monobindir)

TargetDotnetProfile = net40
Configuration = Release
DISTVERSION = 201011

# Version number mappings for various versions of FSharp.Core


ifeq (x-$(TargetDotnetProfile)-,x-net40-)

ifeq (x-$(FSharpCoreBackVersion)-,x--)
VERSION = 4.4.1.0
PKGINSTALL = yes
REFASSEMPATH = .NETFramework/v4.0
outsuffix = $(TargetDotnetProfile)
endif

ifeq (x-$(FSharpCoreBackVersion)-,x-3.0-)
VERSION = 4.3.0.0
REFASSEMPATH = .NETFramework/v4.0
outsuffix = fsharp30/$(TargetDotnetProfile)
endif

ifeq (x-$(FSharpCoreBackVersion)-,x-3.1-)
VERSION = 4.3.1.0
REFASSEMPATH = .NETFramework/v4.0
outsuffix = fsharp31/$(TargetDotnetProfile)
endif

ifeq (x-$(FSharpCoreBackVersion)-,x-4.0-)
VERSION = 4.4.0.0
REFASSEMPATH = .NETFramework/v4.0
outsuffix = fsharp40/$(TargetDotnetProfile)
endif

endif

ifeq (x-$(TargetDotnetProfile)-,x-monoandroid10+monotouch10+xamarinios10-)
VERSION = 3.98.41.0
outsuffix = $(TargetDotnetProfile)
endif


ifeq (x-$(TargetDotnetProfile)-,x-xamarinmacmobile-)
VERSION = 3.99.41.0
outsuffix = $(TargetDotnetProfile)
endif

ifeq (x-$(TargetDotnetProfile)-,x-portable47-)
VERSION = 3.47.41.0
PCLPATH = .NETPortable
outsuffix = $(TargetDotnetProfile)
endif

ifeq (x-$(TargetDotnetProfile)-,x-portable7-)
VERSION = 3.7.41.0
PCLPATH = .NETCore
outsuffix = $(TargetDotnetProfile)
endif

ifeq (x-$(TargetDotnetProfile)-,x-portable78-)
VERSION = 3.78.41.0
PCLPATH = .NETCore
outsuffix = $(TargetDotnetProfile)
endif

ifeq (x-$(TargetDotnetProfile)-,x-portable259-)
VERSION = 3.259.41.0
PCLPATH = .NETCore
outsuffix = $(TargetDotnetProfile)
endif


FSCORE_DELAY_SIGN_TOKEN = b03f5f7f11d50a3a
SIGN_TOKEN = f536804aa0eb945b

tmpdir = .libs/$(Configuration)/
outdir = $(builddir)$(Configuration)/$(outsuffix)/bin/

INSTALL = $(SHELL) $(topdir)/mono/install-sh
INSTALL_BIN = $(INSTALL) -c -m 755
INSTALL_LIB = $(INSTALL_BIN)

MSBUILD = msbuild

EXTRA_DIST = configure
NO_DIST = .gitignore lib/debug lib/proto lib/release


# Install .optdata/.sigdata if they exist (they go alongside FSharp.Core)
# Install the .Targets file. The XBuild targets file gets installed into the place(s) expected for standard F# project
# files. For F# 2.0 project files this is
#     /usr/lib/mono/Microsoft F#/v4.0/Microsoft.FSharp.Targets
# For F# 3.0 project files this is
#     /usr/lib/mono/Microsoft SDKs/F#/3.0/Framework/v4.0/Microsoft.FSharp.Targets
# For F# 3.1 project files this is
#     /usr/lib/mono/xbuild/Microsoft/VisualStudio/v12.0/FSharp/Microsoft.FSharp.Targets
# For F# 4.0 project files this is
#     /usr/lib/mono/xbuild/Microsoft/VisualStudio/v14.0/FSharp/Microsoft.FSharp.Targets
# For F# 4.1 project files this is
#     /usr/lib/mono/xbuild/Microsoft/VisualStudio/v15.0/FSharp/Microsoft.FSharp.Targets
# 
# Here 12.0/14.0/15.0 is 'VisualStudioVersion'. xbuild should set this to 11.0/12.0/14.0/15.0, copying MSBuild.
#
# We put the F# targets and link the SDK DLLs for all these locations
#
# We put a forwarding targets file into all three locations. We also put one in 
#     .../lib/mono/xbuild/Microsoft/VisualStudio/v/FSharp/Microsoft.FSharp.Targets
# since this is the location if 'xbuild' fails to set VisualStudioVersion.
#
install-sdk-lib:
	@echo "Installing $(ASSEMBLY)"
	@mkdir -p $(DESTDIR)$(monodir)/fsharp
	@if test "x$(DELAY_SIGN)" = "x1"; then \
	    echo "Signing $(outdir)$(ASSEMBLY) with Mono key"; \
	    $(monobindir)sn -q -R $(outdir)$(ASSEMBLY) $(topdir)mono/mono.snk; \
	fi
	@if test x-$(NAME) = x-FSharp.Compiler.Private; then \
	    echo "Installing extra dependency System.Collections.Immutable.dll to $(DESTDIR)$(monodir)/fsharp/"; \
	    $(INSTALL_LIB) $(outdir)System.Collections.Immutable.dll $(DESTDIR)$(monodir)/fsharp/; \
	    echo "Installing extra dependency System.Reflection.Metadata.dll to $(DESTDIR)$(monodir)/fsharp/"; \
	    $(INSTALL_LIB) $(outdir)System.Reflection.Metadata.dll $(DESTDIR)$(monodir)/fsharp/; \
	fi
	@if test x-$(NAME) = x-FSharp.Build; then \
	    echo "Installing Microsoft.FSharp.Targets and Microsoft.Portable.FSharp.Targets into install locations matching Visual Studio"; \
	    echo " --> $(DESTDIR)$(monodir)/fsharp/"; \
	    echo " --> $(DESTDIR)$(monodir)/Microsoft\ F#/v4.0/"; \
	    echo " --> $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/3.0/Framework/v4.0/"; \
	    echo " --> $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/3.1/Framework/v4.0/"; \
	    echo " --> $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/4.0/Framework/v4.0/"; \
	    echo " --> $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/4.1/Framework/v4.0/"; \
	    echo " --> $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v/FSharp/"; \
	    echo " --> $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v11.0/FSharp/"; \
	    echo " --> $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v12.0/FSharp/"; \
	    echo " --> $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v14.0/FSharp/"; \
	    echo " --> $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v15.0/FSharp/"; \
	    \
	    mkdir -p $(tmpdir); \
	    mkdir -p $(DESTDIR)$(monodir)/Microsoft\ F#/v4.0/; \
	    mkdir -p $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/3.0/Framework/v4.0/; \
	    mkdir -p $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/3.1/Framework/v4.0/; \
	    mkdir -p $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/4.0/Framework/v4.0/; \
	    mkdir -p $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/4.1/Framework/v4.0/; \
	    mkdir -p $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v/FSharp/; \
	    mkdir -p $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v11.0/FSharp/; \
	    mkdir -p $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v12.0/FSharp/; \
	    mkdir -p $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v14.0/FSharp/; \
	    mkdir -p $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v15.0/FSharp/; \
	    \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.Targets $(DESTDIR)$(monodir)/fsharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.Portable.FSharp.Targets $(DESTDIR)$(monodir)/fsharp/; \
	    \
	    echo '<Project xmlns="http://schemas.microsoft.com/developer/msbuild/2003">' > $(tmpdir)Microsoft.FSharp.Targets; \
	    echo '    <Import Project="$(monodir)/fsharp/Microsoft.FSharp.Targets" />' >> $(tmpdir)Microsoft.FSharp.Targets; \
	    echo '</Project>' >> $(tmpdir)Microsoft.FSharp.Targets; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.FSharp.Targets $(DESTDIR)$(monodir)/Microsoft\ F#/v4.0/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.FSharp.Targets $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/3.0/Framework/v4.0/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.FSharp.Targets $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/3.1/Framework/v4.0/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.FSharp.Targets $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/4.0/Framework/v4.0/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.FSharp.Targets $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/4.1/Framework/v4.0/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.FSharp.Targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v/FSharp/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.FSharp.Targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v11.0/FSharp/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.FSharp.Targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v12.0/FSharp/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.FSharp.Targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v14.0/FSharp/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.FSharp.Targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v15.0/FSharp/; \
	    \
	    echo '<Project xmlns="http://schemas.microsoft.com/developer/msbuild/2003">' > $(tmpdir)Microsoft.Portable.FSharp.Targets; \
	    echo '    <Import Project="$(monodir)/fsharp/Microsoft.Portable.FSharp.Targets" />' >> $(tmpdir)Microsoft.Portable.FSharp.Targets; \
		echo '</Project>' >> $(tmpdir)Microsoft.Portable.FSharp.Targets; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.Portable.FSharp.Targets $(DESTDIR)$(monodir)/Microsoft\ F#/v4.0/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.Portable.FSharp.Targets $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/3.0/Framework/v4.0/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.Portable.FSharp.Targets $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/3.1/Framework/v4.0/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.Portable.FSharp.Targets $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/4.0/Framework/v4.0/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.Portable.FSharp.Targets $(DESTDIR)$(monodir)/Microsoft\ SDKs/F#/4.1/Framework/v4.0/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.Portable.FSharp.Targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v/FSharp/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.Portable.FSharp.Targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v11.0/FSharp/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.Portable.FSharp.Targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v12.0/FSharp/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.Portable.FSharp.Targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v14.0/FSharp/; \
	    $(INSTALL_LIB) $(tmpdir)Microsoft.Portable.FSharp.Targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v15.0/FSharp/; \
	    \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.NetSdk.props $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.NetSdk.props $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v11.0/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.NetSdk.props $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v12.0/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.NetSdk.props $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v14.0/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.NetSdk.props $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v15.0/FSharp/; \
	    \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.NetSdk.targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.NetSdk.targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v11.0/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.NetSdk.targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v12.0/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.NetSdk.targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v14.0/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.NetSdk.targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v15.0/FSharp/; \
	    \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.Overrides.NetSdk.targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.Overrides.NetSdk.targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v11.0/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.Overrides.NetSdk.targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v12.0/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.Overrides.NetSdk.targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v14.0/FSharp/; \
	    $(INSTALL_LIB) $(outdir)Microsoft.FSharp.Overrides.NetSdk.targets $(DESTDIR)$(monodir)/xbuild/Microsoft/VisualStudio/v15.0/FSharp/; \
	fi
	@if test x-$(outsuffix) = x-net40; then \
	    if test -e $(outdir)$(NAME).dll; then \
			echo "Installing $(outdir)$(NAME).dll to $(DESTDIR)$(monodir)/fsharp/"; \
			mkdir -p $(DESTDIR)$(monodir)/fsharp/; \
			$(INSTALL_LIB) $(outdir)$(NAME).dll $(DESTDIR)$(monodir)/fsharp/; \
		fi; \
	    if test -e $(outdir)$(NAME).dll.config; then \
			echo "Installing $(outdir)$(NAME).dll to $(DESTDIR)$(monodir)/fsharp/"; \
			mkdir -p $(DESTDIR)$(monodir)/fsharp/; \
			$(INSTALL_LIB) $(outdir)$(NAME).dll.config $(DESTDIR)$(monodir)/fsharp/; \
		fi; \
	    if test -e $(outdir)$(NAME).xml; then \
			echo "Installing $(outdir)$(NAME).xml into $(DESTDIR)$(monodir)/fsharp/"; \
			mkdir -p $(DESTDIR)$(monodir)/fsharp/; \
			$(INSTALL_LIB) $(outdir)$(NAME).xml $(DESTDIR)$(monodir)/fsharp/; \
	    fi; \
	    if test -e $(outdir)$(NAME).sigdata; then \
			echo "Installing $(outdir)$(NAME).sigdata into $(DESTDIR)$(monodir)/fsharp/"; \
			mkdir -p $(DESTDIR)$(monodir)/fsharp/; \
			$(INSTALL_LIB) $(outdir)$(NAME).sigdata $(DESTDIR)$(monodir)/fsharp/; \
	    fi; \
	    if test -e $(outdir)$(NAME).optdata; then \
			echo "Installing $(outdir)$(NAME).optdata into $(DESTDIR)$(monodir)/fsharp/"; \
			mkdir -p $(DESTDIR)$(monodir)/fsharp/; \
			$(INSTALL_LIB) $(outdir)$(NAME).optdata $(DESTDIR)$(monodir)/fsharp/; \
	    fi; \
	fi
	@if test x-$(NAME) = x-FSharp.Core && test x-$(REFASSEMPATH) != x-; then \
			echo "Installing FSharp.Core $(VERSION) reference assembly into api location"; \
			echo " --> $(DESTDIR)$(monodir)/fsharp/api/$(REFASSEMPATH)/$(VERSION)"; \
			mkdir -p $(DESTDIR)$(monodir)/fsharp/api/$(REFASSEMPATH)/$(VERSION); \
			$(INSTALL_LIB) $(outdir)$(NAME).xml $(DESTDIR)$(monodir)/fsharp/api/$(REFASSEMPATH)/$(VERSION)/; \
			$(INSTALL_LIB) $(outdir)$(NAME).sigdata $(DESTDIR)$(monodir)/fsharp/api/$(REFASSEMPATH)/$(VERSION)/; \
			$(INSTALL_LIB) $(outdir)$(NAME).optdata $(DESTDIR)$(monodir)/fsharp/api/$(REFASSEMPATH)/$(VERSION)/; \
			$(INSTALL_LIB) $(outdir)$(NAME).dll $(DESTDIR)$(monodir)/fsharp/api/$(REFASSEMPATH)/$(VERSION)/; \
	fi
	@if test x-$(NAME) = x-FSharp.Core && test x-$(PCLPATH) != x-; then \
			echo "Installing FSharp.Core $(VERSION) reference assembly into api location"; \
			echo " --> $(DESTDIR)$(monodir)/fsharp/$(PCLPATH)/$(VERSION)"; \
			mkdir -p $(DESTDIR)$(monodir)/fsharp/api/$(PCLPATH)/$(VERSION); \
			$(INSTALL_LIB) $(outdir)$(NAME).xml $(DESTDIR)$(monodir)/fsharp/api/$(PCLPATH)/$(VERSION)/; \
			$(INSTALL_LIB) $(outdir)$(NAME).sigdata $(DESTDIR)$(monodir)/fsharp/api/$(PCLPATH)/$(VERSION)/; \
			$(INSTALL_LIB) $(outdir)$(NAME).optdata $(DESTDIR)$(monodir)/fsharp/api/$(PCLPATH)/$(VERSION)/; \
			$(INSTALL_LIB) $(outdir)$(NAME).dll $(DESTDIR)$(monodir)/fsharp/api/$(PCLPATH)/$(VERSION)/; \
	fi



# The binaries fsc.exe and fsi.exe only get installed for Mono 4.5 profile
# This also installs 'fsharpc' and 'fsharpi' and 'fsharpiAnyCpu'
install-bin:
	chmod +x $(outdir)$(ASSEMBLY)
	sed -e 's,[@]DIR[@],$(monodir)/fsharp,g' -e 's,[@]TOOL[@],$(ASSEMBLY),g' -e 's,[@]MONOBINDIR[@],$(monobindir),g' < $(topdir)mono/launcher > $(outdir)$(subst fs,fsharp,$(NAME))
	chmod +x $(outdir)$(subst fs,fsharp,$(NAME))
	@mkdir -p $(DESTDIR)$(monodir)/fsharp
	@mkdir -p $(DESTDIR)$(bindir)
	$(INSTALL_BIN) $(outdir)$(ASSEMBLY) $(DESTDIR)$(monodir)/fsharp
	$(INSTALL_BIN) $(outdir)$(ASSEMBLY).config $(DESTDIR)$(monodir)/fsharp
	$(INSTALL_BIN) $(outdir)$(subst fs,fsharp,$(NAME)) $(DESTDIR)$(bindir)


