# Staged release process

## Goal

Today, the release process is all baked into a single release definition, including validation checks, manual steps, etc. 
Also, it requires some pre-work by the PM to download the bits, order them and making sure they are available for the overall
process. With the data in BAR and commands supported by `darc` we can automate some of things.

Also, we would like to introduce the concept of "promotion". In order for a build to be shipped it would need to go
through several **rings**. Each ring has different types of validations. A build is only promoted if it passes all the 
validation checks.

## Release Rings

### Dev Ring (.NET Core 3 Dev channel)

1. Standard builds after merges into master branch
2. Sign produced packages by the build
3. Signing validation
4. Symbol publishing to symweb and MSDL
5. Symbol availability validation
6. Publish packages, installers, packages, etc. to dotnet feeds and MyGet
7. **(Future)** source build

**Promotion:** Tactics decision and coordinated activities driven by the repos to snap release branches from master and 
begin the release stabilization process. 

### Release Ring (.NET Core 3 Release channel)

1. Standard builds after merges into release/* branch
2. Sign produced packages by the build
3. Signing validation
4. Symbol publishing to symweb and MSDL
5. Symbol availability validation
6. Publish packages, installers, packages, etc. to dotnet feeds and MyGet

**Promotion:** 
1. Version is coherent 
2. Tactics approve this version
3. Move all related builds to the Release Validation channel

### Release Validation Ring (Release Validation channel)

1. No build required
2. Create Git Tags
3. Gather drop and send to CTI for validation
4. Take PRs to fix found issues, rinse and repeat
5. Redhat source build
6. Antares: set of zips used to deploy to Azure App Services for the SDK, Runtime and ASP. SDK and Runtime are generated by a 
post-build script. Zips are validated by the ASP team against an App Services test environment
7. Push packages to NuGet INT by pushing all the things that would end up in nuget.org
8. Stage final drop and binary validation making sure we have all that we need

**Promotion:**
1. CTI sign off
2. All the previous validation steps succeed
3. Tactics approve this version
4. Move all related builds to the Publish Release channel

### Final Release/Publish Ring (Publish Release channel)
 
1. No build required
2. Publish and validate to CDN
3. Publish and validate to NuGet
4. Publish and validate NuGet symbols
5. Publish and validate Linux distributions
6. Antares deployment*
7. Publish and validate Docker
8. Publish Docs

*Can run as a parallel task
