# Product KPIs (PKPIs)

This document describes product KPIs that can be used to determine the 'health' of
the overall product and its constituent repositories.

## Goals of PKPIs

Traditional KPIs used by the engineering services team measure metrics like service reliability,
service availability, queue wait times, etc. Analysis of the indicators (e.g.
against a baseline expected value) helps the engineering team determine whether
action needs to be taken to ensure that the product can build and ship on time.
For example, a spike in Helix queue times will affect how fast PRs can be
validated, which in turn affects how fast the product can iterate.

Though product KPIs bear limited resemblance to traditional service KPIs, the
goal is largely the same:

**Ensure that the product can iterate and ship quickly with high quality by
identifying problem areas early and often.**

## Metrics

The desired product KPI metrics are listed below, with the following fields:
- **Name** - Name of metric
- **Qualifier** - How is this metric broken out? For example, dependency update
  PR merge time broken out by input channel, or are all dependency update PRs
  aggregated per repo. Is this metric an aggregator of all repos underneath it?
  For example, staleness can be aggregated such that even if all direct inputs
  to a repository A are new, if those inputs have stale inputs, then A is viewed
  as stale.
- **Drives Action** - What action can be taken to improve the metric and thus
  improve the chances of shipping with high quality.

| Name | Qualifier | Indicates | Drives Action |
| ---- | --------- | --------- | ------------- |
| **Open Dependency Update PRs vs. Possible Dependency Update PRs** | Per Input Channel, Per Repo | A large number of open dependency update PRs indicates that dependencies are not flowing through the repository node. This may indicate that auto-merge is not available for the repository, that the repository owners are not keeping up with merging updates.<br/>The metric is qualified based on the input channel because the focus of the team shifts between channels at different stages of the product cycle. | Repository owner investigates open dependency update PRs and merges/fixes as needed |
| **Direct Product Dependency Staleness** | Per Output Channel, Per Repo | Measures the staleness of the direct *product* inputs of a repository, ignoring pinned dependencies. A dependency's staleness is measured against the latest version of the dependency applied to the input channel.<br/>For example, if the repository has dependency 'Foo.Bar', and 'Foo.Bar' is updated with a subscription to repo 'A' on channel 'Dev', then the dependency is not considered stale if repo A has produced no new builds containing Foo.Bar on channel Dev.<br/>A higher degree of staleness indicates that the repo is out of date vs. possible inputs, and there may be a higher possibility of surprise breaks when it does catch up. This indicator is more important in a day to day Dev channel, especially right before branching for a release. | Repository owner finds dependency update PRs for old dependencies and fixes/merges as needed.  If the PRs do not exist, the repository owner investigates why (missing subscription, etc.) |
| **Direct Toolset Dependency Staleness** | Per Output Channel, Per Repo | Measures the staleness of the direct *toolset* inputs of a repository, ignoring pinned dependencies. A dependency's staleness is measured against the latest version of the dependency applied to the input channel.<br/>For example, if the repository has dependency 'Foo.Bar', and 'Foo.Bar' is updated with a subscription to repo 'A' on channel 'Dev', then the dependency is not considered stale if repo A has produced no new builds containing Foo.Bar on channel Dev.<br/>A higher degree of staleness indicates that the repo is out of date vs. possible inputs, and there may be a higher possibility of surprise breaks when it does catch up. This indicator is often less important than product staleness, as toolset inputs are used largely for test and arcade dependencies. However, a very stale test-only dependency may be hiding some kind of breaking change that may only appear when the repository's outputs roll up into the SDK. | Repository owner finds dependency update PRs for old dependencies and fixes/merges as needed.  If the PRs do not exist, the repository owner investigates why (missing subscription, etc.) |
| **Transitive Product Staleness** | Per Output Channel, Per Repo | Measures the staleness of the direct *product* inputs of a repository, aggregated with the staleness of the dependencies of those inputs, onward down the repository dependency graph. Staleness calculations are broken at cycles.<br/>In contrast to direct dependency staleness, a repository may have a positive staleness score for its direct inputs. However, if those inputs have old dependencies, then the transitive product staleness will increase. A high degree of staleness indicates a higher possibility of breaks as inputs come up to date, that dependencies may not be smoothly flowing through a node, etc. | Repository owner walks dependency tree (in BARViz) to determine where the dependency update clogs are, then communicates with that repository owner to determine why dependencies aren't flowing |
| **Official Build Time** | Per Repo, Per default output channel | Measures the median build time of *successful* official builds of a branch that are applied by default to the specified channel. This should include time for retries. A large official build time indicates that it is slow to move dependencies through the node or get new outputs from the node, and that failures in the official build that require retries will be expensive, potentially putting ship schedules at risk. | Repository owner investigates official build time, determines why it has regressed, and develops a plan to mitigate it. |
| **Official Build Pass Rate** | Per Repo, Per default output channel | Measures the average 'without intervention' pass rate over the last N days of builds of a branch that are applied by default to the specified channel. A build that is retried after an initial failure counts as a failure. A low pass rate indicates that dependencies or new content will not flow easily through the node, potentially putting ship schedules at risk. | Repository owner investigates official build pass rate, determines why it has regressed, and develops a plan to mitigate it. |
| **Release Pipeline Time** | Per associated release pipeline | Measures the median amount of time for a successful run of a release pipeline associated with a specific channel. A slow release pipeline time indicates a risk to the flow of dependencies through the product.  | Engineering services team investigates why the release pipeline time has regressed and determines a plan of action |
| **Release Pipeline Pass Rate** | Per output channel | Measures the average pass rate of a release pipeline associated with a specific channel. The pass rate should be at or near 100% at all times. A low pass rate indicates a indicates a risk to the flow of dependencies through the product. | Engineering services team investigates why the release pipeline pass rate has regressed and determines a plan of action. |
| **Dependency Update PR Merge Time** | Per Repo, Per default output channel | Measures the median amount of time from dependency PR creation to dependency PR merge for PRs to branches that will apply to a specified default output channel once merged. A high merge time may indicate any number of issues, like the rate of incoming change is faster than the PR build time or that the PR pass rate is low, but generally indicates that dependencies will have trouble flowing through the node. | Repository owner determines why dependency update PRs are not merging quickly, potentially looking at other indicators to do so (ci pass rate, ci time, etc.). Perhaps update PRs are not being auto-merged. Repository owner develops a plan to decrease the merge time |
| **Dependency Update PR CI Time** | Per Repo, Per default output channel | Measures the median build time of *successful* PR builds targeting a branch that is applied by default to the specified channel. This should include time for retries. A large PR build time indicates that it is slow to move dependencies through the node or get new outputs from the node, and that failures in the official build that require retries will be expensive, potentially putting ship schedules at risk. This represents a subset of the PR merge time. | Repository owner investigates ci time, determines why it has regressed (or is high in the first place), and develops a plan to mitigate it. |
| **Dependency Update PR CI Pass Rate** | Per Repo, Per default output channel | Measures the average 'without intervention' pass rate over the last N days of dependency update PRs targeting a branch that is applied by default to the specified channel. A build that is retried after an initial failure counts as a failure. A low pass rate indicates that dependencies or will not flow easily through the node, potentially putting ship schedules at risk. This may mean that there are flaky tests, that the rate of breaking changes is high, etc. | Repository owner investigates ci pass rate, determines why it has regressed (or is high in the first place), and develops a plan to mitigate it. |
| **Existence of Product Dependency Cycles** | Per Channel | Indicates the existence/non-existence of cycles containing only product dependencies within the dependency flow graph. A cycle unbroken by toolset a toolset dependency indicates the product cannot be become coherent. | Coherency QB or repository owner that is part of the cycle investigates and determines how to break the cycle | 
| **Existence of Automated dependency Flow Cycles** | Per Channel | Indicates the existence/non-existence of cycles within the dependency flow graph that will flow without intervention. A subscription will flow without intervention if it is not disabled and its frequency is not 'none'. This metric is a shorthand way of saying that the product will never become coherent if 'real' product changes in the repositories are halted, potentially putting ship schedules at risk. In Dev channels, this is not an interesting metric. | For a release channel, the coherency QB and/or repository owner determines which subscriptions in the cycle do not need to flow automatically, and disables/changes update frequency as needed. |
| **Existence of cross-channel flow** | Per Channel | Indicates the existence/non-existence of flow that may enter the specified channel from another channel. If the other channel has a higher rate of change than the specified channel, then the product may not end up becoming coherent if left to its own devices. A good example of this is: A branch that applies to Release has a subscription to Arcade (on .NET Tools - Latest) that is set to update every day. Because branches applying to the release channel and arcade's master branch have different check-in policies during release shutdown time (arcade has a lower bar), it's likely that the arcade subscription will continue to generate changes on the release channel, potentially putting coherency at risk. The subscription causing cross-channel flow should be disabled or have its update rate set to "none". This metric is not as interesting in a dev channel. | For a release channel, the coherency QB and/or repository owner determines which repositories are contributing to the cross channel flow (using Darc/BARViz) and determines a plan of action (e.g. branch offending repos, turn off automated subscriptions contributing to the flow, etc.) |
| **Missing/Disabled Product Input Subscriptions** | Per Repo, Per Default Channel (input branch) | Indicates that a branch that applies to a default channel is missing inputs subscriptions for product dependencies, and thus coherency may not be able to be achieved. A subscription is not missing when dependencies are pinned or when they are tied via CoherentParentDependency attributes to other dependencies. Subscriptions that do not update automatically should also be viewed as disabled. Each dependency should be evaluated based on the assets produced by the last build applied to the input subscriptions. This metric is inexact. It's possible that a dependency missing a subscription now will be produced by the next build applied to a different subscription.  | Repository owner determines whether those input dependencies need to be marked as Pinned or whether subscriptions should be created/changed to update automatically |
| **Missing/Disabled Toolset Input Subscriptions** | Per Repo, Per Default Channel (input branch) | Indicates that a branch that applies to a default channel is missing inputs subscriptions for toolset dependencies. A subscription is not missing when dependencies are pinned or when they are tied via CoherentParentDependency attributes to other dependencies. Each dependency should be evaluated based on the assets produced by the last build applied to the input subscriptions. This metric is inexact. It's possible that a dependency missing a subscription now will be produced by the next build applied to a different subscription. | Repository owner determines whether those input dependencies need to be marked as Pinned or whether subscriptions should be created/changed to update automatically. In a release channel, this is not generally needed but should be evaluated on a case-by-case basis. |
| **Superfluous Input Subscriptions** | Per Repo, Per Default Channel (input branch) | Indicates that a branch that applies to a default channel has subscriptions that may do nothing. Each dependency should be evaluated based on the assets produced by the last build applied to the input subscriptions. This metric is inexact. It's possible that a subscription that looks superfluous now will produce a needed asset in the future. | Repository owner determines whether those subscriptions can be deleted. |
| **Conflicting Input Subscriptions** | Per Repo, Per Default Channel (input branch) | Indicates that a branch that applies to a default channel has subscriptions that produce the same asset. Each dependency should be evaluated based on the assets produced by the last build applied to the input subscriptions. This metric is inexact. It's possible that two currently conflicting subscriptions will not produce conflicting outputs in the future. Because outputs switching between repositories happens infrequently, this metric typically indicates an actual issue. | Repository owner determines whether both subscriptions are needed or whether one should be deleted. |
| **Time to Coherency** | Per Repo, Per default output channel | Time to coherency is an aggregated metric indicating that, if non-dependency flow changes were halted for all branches that apply by default to the specified channel, how long would it take for coherency to be achieved. It is possible for this value to be infinite if there are cycles that flow automatically. This metric is not static and is instead based on the current dependency graph state at the current node. This metric needs to take into account all of the times at the specified steps in the dependency flow process: official build time, release pipeline execution time, dependency flow graph shape, dependency update pr elapsed time, etc. | This metric can drive two primary actions: 1) Determining why time to coherency is long (look at other metrics to narrow) and develop a plan for improvement. 2) Determine lead time required for shipping. | 