﻿// <copyright file="TaskTimer.cs" company="Microsoft">
// Copyright © Microsoft. All Rights Reserved.
// </copyright>

namespace Microsoft.ApplicationInsights.Extensibility.Implementation
{
    using System;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Runs a task after a certain delay and log any error.
    /// </summary>
    [Obsolete("This class will be removed in the next major version. Application Insights base library wouldn't provide this functionality any longer.")]
    public class TaskTimer : IDisposable
    {
        /// <summary>
        /// Represents an infinite time span.
        /// </summary>
        public static readonly TimeSpan InfiniteTimeSpan = new TimeSpan(0, 0, 0, 0, Timeout.Infinite);

        private TaskTimerInternal internalTimer = new TaskTimerInternal();

        /// <summary>
        /// Gets or sets the delay before the task starts. 
        /// </summary>
        public TimeSpan Delay 
        { 
            get
            {
                return this.internalTimer.Delay;
            }

            set
            {
                this.internalTimer.Delay = value;
            }
        }

        /// <summary>
        /// Gets a value indicating whether value that indicates if a task has already started.
        /// </summary>
        public bool IsStarted
        {
            get { return this.internalTimer.IsStarted; }
        }

        /// <summary>
        /// Start the task.
        /// </summary>
        /// <param name="elapsed">The task to run.</param>
        public void Start(Func<Task> elapsed)
        {
            this.internalTimer.Start(elapsed);
        }

        /// <summary>
        /// Cancels the current task.
        /// </summary>
        public void Cancel()
        {
            this.internalTimer.Cancel();
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        public void Dispose()
        {
            this.internalTimer.Dispose();
        }
    }
}
