// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace System.Net.NetworkInformation
{
    /// <summary>
    /// Specified the list of Networking components that are supported on a Network Interface
    /// </summary>
    public enum NetworkInterfaceComponent
    {
        /// <summary>
        /// Internet Protocol version 4 is supported.
        /// </summary>
        IPv4,

        /// <summary>
        /// Internet Protocol version 6 is supported.
        /// </summary>
        IPv6
    }
}
