// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.X86
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["Add.Double"] = AddDouble,
                ["Add.Single"] = AddSingle,
                ["AddSubtract.Double"] = AddSubtractDouble,
                ["AddSubtract.Single"] = AddSubtractSingle,
                ["And.Double"] = AndDouble,
                ["And.Single"] = AndSingle,
                ["AndNot.Double"] = AndNotDouble,
                ["AndNot.Single"] = AndNotSingle,
                ["BlendVariable.Double"] = BlendVariableDouble,
                ["BlendVariable.Single"] = BlendVariableSingle,
                ["Ceiling.Double"] = CeilingDouble,
                ["Ceiling.Single"] = CeilingSingle,
                ["Divide.Double"] = DivideDouble,
                ["Divide.Single"] = DivideSingle,
                ["DuplicateEvenIndexed.Double"] = DuplicateEvenIndexedDouble,
                ["DuplicateEvenIndexed.Single"] = DuplicateEvenIndexedSingle,
                ["DuplicateOddIndexed.Single"] = DuplicateOddIndexedSingle,
                ["Extract.Byte.1"] = ExtractByte1,
                ["Extract.SByte.1"] = ExtractSByte1,
                ["Extract.Byte.20"] = ExtractByte20,
                ["Extract.SByte.20"] = ExtractSByte20,
                ["Extract.Byte.52"] = ExtractByte52,
                ["Extract.SByte.52"] = ExtractSByte52,
                ["Extract.Int16.1"] = ExtractInt161,
                ["Extract.UInt16.1"] = ExtractUInt161,
                ["Extract.Int16.11"] = ExtractInt1611,
                ["Extract.UInt16.11"] = ExtractUInt1611,
                ["Extract.Int16.27"] = ExtractInt1627,
                ["Extract.UInt16.27"] = ExtractUInt1627,
                ["Extract.Int32.1"] = ExtractInt321,
                ["Extract.UInt32.1"] = ExtractUInt321,
                ["Extract.Int32.6"] = ExtractInt326,
                ["Extract.UInt32.6"] = ExtractUInt326,
                ["Extract.Int32.22"] = ExtractInt3222,
                ["Extract.UInt32.22"] = ExtractUInt3222,
                ["Extract.Int64.1"] = ExtractInt641,
                ["Extract.UInt64.1"] = ExtractUInt641,
                ["Extract.Int64.3"] = ExtractInt643,
                ["Extract.UInt64.3"] = ExtractUInt643,
                ["Extract.Int64.19"] = ExtractInt6419,
                ["Extract.UInt64.19"] = ExtractUInt6419,
                ["ExtendToVector256.Byte"] = ExtendToVector256Byte,
                ["ExtendToVector256.Double"] = ExtendToVector256Double,
                ["ExtendToVector256.Int16"] = ExtendToVector256Int16,
                ["ExtendToVector256.Int32"] = ExtendToVector256Int32,
                ["ExtendToVector256.Int64"] = ExtendToVector256Int64,
                ["ExtendToVector256.SByte"] = ExtendToVector256SByte,
                ["ExtendToVector256.Single"] = ExtendToVector256Single,
                ["ExtendToVector256.UInt16"] = ExtendToVector256UInt16,
                ["ExtendToVector256.UInt32"] = ExtendToVector256UInt32,
                ["ExtendToVector256.UInt64"] = ExtendToVector256UInt64,
                ["ExtractVector128.Byte.1.Store"] = ExtractVector128Byte1Store,
                ["ExtractVector128.SByte.1.Store"] = ExtractVector128SByte1Store,
                ["ExtractVector128.Int16.1.Store"] = ExtractVector128Int161Store,
                ["ExtractVector128.UInt16.1.Store"] = ExtractVector128UInt161Store,
                ["ExtractVector128.Int32.1.Store"] = ExtractVector128Int321Store,
                ["ExtractVector128.UInt32.1.Store"] = ExtractVector128UInt321Store,
                ["ExtractVector128.Int64.1.Store"] = ExtractVector128Int641Store,
                ["ExtractVector128.UInt64.1.Store"] = ExtractVector128UInt641Store,
                ["ExtractVector128.Single.1.Store"] = ExtractVector128Single1Store,
                ["ExtractVector128.Double.1.Store"] = ExtractVector128Double1Store,
                ["Insert.Byte.1"] = InsertByte1,
                ["Insert.Byte.20"] = InsertByte20,
                ["Insert.SByte.1"] = InsertSByte1,
                ["Insert.SByte.20"] = InsertSByte20,
                ["Insert.Byte.52"] = InsertByte52,
                ["Insert.SByte.52"] = InsertSByte52,
                ["Insert.Int16.1"] = InsertInt161,
                ["Insert.Int16.11"] = InsertInt1611,
                ["Insert.UInt16.1"] = InsertUInt161,
                ["Insert.UInt16.11"] = InsertUInt1611,
                ["Insert.Int16.27"] = InsertInt1627,
                ["Insert.UInt16.27"] = InsertUInt1627,
                ["Insert.Int32.1"] = InsertInt321,
                ["Insert.Int32.6"] = InsertInt326,
                ["Insert.UInt32.1"] = InsertUInt321,
                ["Insert.UInt32.6"] = InsertUInt326,
                ["Insert.Int32.22"] = InsertInt3222,
                ["Insert.UInt32.22"] = InsertUInt3222,
                ["Insert.Int64.1"] = InsertInt641,
                ["Insert.Int64.3"] = InsertInt643,
                ["Insert.UInt64.1"] = InsertUInt641,
                ["Insert.UInt64.3"] = InsertUInt643,
                ["Insert.Int64.19"] = InsertInt6419,
                ["Insert.UInt64.19"] = InsertUInt6419,
                ["InsertVector128.Byte.1.Load"] = InsertVector128Byte1Load,
                ["InsertVector128.SByte.1.Load"] = InsertVector128SByte1Load,
                ["InsertVector128.Int16.1.Load"] = InsertVector128Int161Load,
                ["InsertVector128.UInt16.1.Load"] = InsertVector128UInt161Load,
                ["InsertVector128.Int32.1.Load"] = InsertVector128Int321Load,
                ["InsertVector128.UInt32.1.Load"] = InsertVector128UInt321Load,
                ["InsertVector128.Int64.1.Load"] = InsertVector128Int641Load,
                ["InsertVector128.UInt64.1.Load"] = InsertVector128UInt641Load,
                ["InsertVector128.Single.1.Load"] = InsertVector128Single1Load,
                ["InsertVector128.Double.1.Load"] = InsertVector128Double1Load,
                ["Floor.Double"] = FloorDouble,
                ["Floor.Single"] = FloorSingle,
                ["GetLowerHalf.Byte"] = GetLowerHalfByte,
                ["GetLowerHalf.Double"] = GetLowerHalfDouble,
                ["GetLowerHalf.Int16"] = GetLowerHalfInt16,
                ["GetLowerHalf.Int32"] = GetLowerHalfInt32,
                ["GetLowerHalf.Int64"] = GetLowerHalfInt64,
                ["GetLowerHalf.SByte"] = GetLowerHalfSByte,
                ["GetLowerHalf.Single"] = GetLowerHalfSingle,
                ["GetLowerHalf.UInt16"] = GetLowerHalfUInt16,
                ["GetLowerHalf.UInt32"] = GetLowerHalfUInt32,
                ["GetLowerHalf.UInt64"] = GetLowerHalfUInt64,
                ["Max.Double"] = MaxDouble,
                ["Max.Single"] = MaxSingle,
                ["Min.Double"] = MinDouble,
                ["Min.Single"] = MinSingle,
                ["Multiply.Double"] = MultiplyDouble,
                ["Multiply.Single"] = MultiplySingle,
                ["Or.Double"] = OrDouble,
                ["Or.Single"] = OrSingle,
                ["Permute.Single.1"] = PermuteSingle1,
                ["Permute.Double.1"] = PermuteDouble1,
                ["Permute.Single.2"] = PermuteSingle2,
                ["Permute.Double.2"] = PermuteDouble2,
                ["PermuteVar.Single"] = PermuteVarSingle,
                ["PermuteVar.Double"] = PermuteVarDouble,
                ["RoundCurrentDirection.Double"] = RoundCurrentDirectionDouble,
                ["RoundCurrentDirection.Single"] = RoundCurrentDirectionSingle,
                ["RoundToNearestInteger.Double"] = RoundToNearestIntegerDouble,
                ["RoundToNearestInteger.Single"] = RoundToNearestIntegerSingle,
                ["RoundToNegativeInfinity.Double"] = RoundToNegativeInfinityDouble,
                ["RoundToNegativeInfinity.Single"] = RoundToNegativeInfinitySingle,
                ["RoundToPositiveInfinity.Double"] = RoundToPositiveInfinityDouble,
                ["RoundToPositiveInfinity.Single"] = RoundToPositiveInfinitySingle,
                ["RoundToZero.Double"] = RoundToZeroDouble,
                ["RoundToZero.Single"] = RoundToZeroSingle,
                ["Shuffle.Single.1"] = ShuffleSingle1,
                ["Shuffle.Double.1"] = ShuffleDouble1,
                ["Subtract.Double"] = SubtractDouble,
                ["Subtract.Single"] = SubtractSingle,
                ["TestC.Byte"] = TestCByte,
                ["TestC.Int16"] = TestCInt16,
                ["TestC.Int32"] = TestCInt32,
                ["TestC.Int64"] = TestCInt64,
                ["TestC.SByte"] = TestCSByte,
                ["TestC.UInt16"] = TestCUInt16,
                ["TestC.UInt32"] = TestCUInt32,
                ["TestC.UInt64"] = TestCUInt64,
                ["TestNotZAndNotC.Byte"] = TestNotZAndNotCByte,
                ["TestNotZAndNotC.Int16"] = TestNotZAndNotCInt16,
                ["TestNotZAndNotC.Int32"] = TestNotZAndNotCInt32,
                ["TestNotZAndNotC.Int64"] = TestNotZAndNotCInt64,
                ["TestNotZAndNotC.SByte"] = TestNotZAndNotCSByte,
                ["TestNotZAndNotC.UInt16"] = TestNotZAndNotCUInt16,
                ["TestNotZAndNotC.UInt32"] = TestNotZAndNotCUInt32,
                ["TestNotZAndNotC.UInt64"] = TestNotZAndNotCUInt64,
                ["TestZ.Byte"] = TestZByte,
                ["TestZ.Int16"] = TestZInt16,
                ["TestZ.Int32"] = TestZInt32,
                ["TestZ.Int64"] = TestZInt64,
                ["TestZ.SByte"] = TestZSByte,
                ["TestZ.UInt16"] = TestZUInt16,
                ["TestZ.UInt32"] = TestZUInt32,
                ["TestZ.UInt64"] = TestZUInt64,
                ["Xor.Double"] = XorDouble,
                ["Xor.Single"] = XorSingle,
            };
        }
    }
}
