﻿// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.
// FxCop Suppression file
// To Use:
// Add module level suppressions to this file to have them suppressed in the assembly
//

using System.Diagnostics.CodeAnalysis;

#if CODE_ANALYSIS
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="0", Scope="module", Target="microsoft.build.tasks.core.dll", Justification="Already shipped several versions with a name like this")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="Microsoft.Build.Tasks.NativeMethods.GetCachePath(Microsoft.Build.Tasks.AssemblyCacheFlags,System.Text.StringBuilder,System.Int32@)", Scope="member", Target="Microsoft.Build.Tasks.GlobalAssemblyCache.#GetGacPath()", Justification="We do not use the method result we use one of the out parameters as a check instead. This is because the method can have a failed hresult but return a object in the out parameter.")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="Microsoft.Build.Tasks.IAssemblyCache.QueryAssemblyInfo(System.UInt32,System.String,Microsoft.Build.Tasks.ASSEMBLY_INFO@)", Scope="member", Target="Microsoft.Build.Tasks.GlobalAssemblyCache.#GetLocationImpl(Microsoft.Build.Shared.AssemblyNameExtension,System.String)", Justification="We do not use the method result we use one of the out parameters as a check instead. This is because the method can have a failed hresult but return a object in the out parameter.")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="Microsoft.Build.Tasks.NativeMethods.CreateAssemblyCache(Microsoft.Build.Tasks.IAssemblyCache@,System.UInt32)", Scope="member", Target="Microsoft.Build.Tasks.GlobalAssemblyCache.#GetLocationImpl(Microsoft.Build.Shared.AssemblyNameExtension,System.String)", Justification="We do not use the method result we use one of the out parameters as a check instead. This is because the method can have a failed hresult but return a object in the out parameter.")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="Microsoft.Build.Tasks.NativeMethods.CompareAssemblyIdentity(System.String,System.Boolean,System.String,System.Boolean,System.Boolean@,Microsoft.Build.Tasks.NativeMethods+AssemblyComparisonResult@)", Scope="member", Target="Microsoft.Build.Tasks.ReferenceTable.#ResolveAssemblyNameConflict(Microsoft.Build.Tasks.AssemblyNameReference,Microsoft.Build.Tasks.AssemblyNameReference)", Justification="We do use this")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.RequiresFramework35SP1Assembly", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.DeployManifest.XmlTrustUrlParameters", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.DeployManifest.DeploymentUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.DeployManifest.DeploymentUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.DeployManifest.XmlSupportUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.DeployManifest.XmlDisallowUrlActivation", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.DeployManifest.XmlDeploymentUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.DeployManifest.SupportUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ApplicationManifest.XmlSupportUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.GenerateApplicationManifest.SupportUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ApplicationManifest.XmlOSSupportUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ApplicationManifest.SupportUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ApplicationManifest.OSSupportUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.IBuildSettings.SupportUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.IBuildSettings.ComponentsUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.IBuildSettings.ApplicationUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.GenerateDeploymentManifest.SupportUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.GenerateDeploymentManifest.DeploymentUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.GenerateBootstrapper.SupportUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.GenerateBootstrapper.ComponentsUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.GenerateBootstrapper.ApplicationUrl", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1054:UriParametersShouldNotBeStrings", MessageId="0#", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ApplicationIdentity..ctor(System.String,Microsoft.Build.Tasks.Deployment.ManifestUtilities.AssemblyIdentity,Microsoft.Build.Tasks.Deployment.ManifestUtilities.AssemblyIdentity)", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1054:UriParametersShouldNotBeStrings", MessageId="0#", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ApplicationIdentity..ctor(System.String,System.String,System.String)", Justification="These are already public properties and parameters which cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.FormatUrl.OutputUrl", Justification="This is the input and output name of the format url task which are all public and cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.FormatUrl.InputUrl", Justification="This is the input and output name of the format url task which are all public and cannot be changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.SignFile.TimestampUrl", Justification="Do not want to change string to URI as this is a public property on a public task")]
[module: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.Invoke(System.Object,System.Int32,System.Int16,System.Runtime.InteropServices.ComTypes.DISPPARAMS&,System.IntPtr,System.IntPtr,System.Int32&):System.Void", MessageId="3#", Justification="Excluded until IFixedTypeInfo is replaced by ITypeInfo")]
[module: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.CreateInstance(System.Object,System.Guid&,System.Object&):System.Void", MessageId="1#", Justification="Excluded until IFixedTypeInfo is replaced by ITypeInfo")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.CreateInstance(System.Object,System.Guid&,System.Object&):System.Void", MessageId="pUnk", Justification="Excluded until IFixedTypeInfo is replaced by ITypeInfo")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetRefTypeInfo(System.IntPtr,Microsoft.Build.Tasks.IFixedTypeInfo&):System.Void", MessageId="hRef", Justification="Excluded until IFixedTypeInfo is replaced by ITypeInfo")]
[module: SuppressMessage("Microsoft.Usage",  "CA2208:InstantiateArgumentExceptionsCorrectly", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.AddResponseFileCommands(Microsoft.Build.Tasks.CommandLineBuilderExtension):System.Void", Justification="The argument parameter is Sources, this is correct as the exception is thrown if there is a problem with the Sources[0].ItemSpec. This parameter is on the class rather than the method.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:IdentifiersShouldNotContainTypeNames", Scope="member", Target="Microsoft.Build.Tasks.ToolTaskExtension.GetBoolParameterWithDefault(System.String,System.Boolean):System.Boolean", MessageId="bool", Justification="These are method that return supposed to return a language specific type. Also the method is public, has shipped and cannot be changed for compatibility reasons.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:IdentifiersShouldNotContainTypeNames", Scope="member", Target="Microsoft.Build.Tasks.ToolTaskExtension.GetIntParameterWithDefault(System.String,System.Int32):System.Int32", MessageId="int", Justification="These are method that return supposed to return a language specific type. Also the method is public, has shipped and cannot be changed for compatibility reasons.")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", MessageId="regasm", Justification="Are spelled correctly")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", MessageId="vcbuild", Justification="Are spelled correctly")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", MessageId="IDE's", Justification="Are spelled correctly")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="v", Justification="Casing is correct")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", Scope="member", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.IBuildSettings.LCID", MessageId="LCID", Justification="Casing is correct")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", Scope="member", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.IBuildSettings.FallbackLCID", MessageId="LCID", Justification="Casing is correct")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ProxyStub.IID", MessageId="IID", Justification="Casing is correct")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ProxyStub.XmlIID", MessageId="IID", Justification="Casing is correct")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="5", Justification="Are spelled correctly")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.FileReference.TypeLibs", MessageId="Libs", Justification="Are spelled correctly")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.FileReference.XmlTypeLibs", MessageId="Libs", Justification="Are spelled correctly")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ProxyStub.NumMethods", MessageId="Num", Justification="Are spelled correctly")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ProxyStub.XmlNumMethods", MessageId="Num", Justification="Are spelled correctly")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetRefTypeOfImplType(System.Int32,System.IntPtr&):System.Void", MessageId="Impl", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetImplTypeFlags(System.Int32,System.Runtime.InteropServices.ComTypes.IMPLTYPEFLAGS&):System.Void", MessageId="Impl", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetImplTypeFlags(System.Int32,System.Runtime.InteropServices.ComTypes.IMPLTYPEFLAGS&):System.Void", MessageId="p", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetDllEntry(System.Int32,System.Runtime.InteropServices.ComTypes.INVOKEKIND,System.IntPtr,System.IntPtr,System.IntPtr):System.Void", MessageId="Bstr", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetDllEntry(System.Int32,System.Runtime.InteropServices.ComTypes.INVOKEKIND,System.IntPtr,System.IntPtr,System.IntPtr):System.Void", MessageId="pw", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetDllEntry(System.Int32,System.Runtime.InteropServices.ComTypes.INVOKEKIND,System.IntPtr,System.IntPtr,System.IntPtr):System.Void", MessageId="memid", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetDllEntry(System.Int32,System.Runtime.InteropServices.ComTypes.INVOKEKIND,System.IntPtr,System.IntPtr,System.IntPtr):System.Void", MessageId="p", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.Invoke(System.Object,System.Int32,System.Int16,System.Runtime.InteropServices.ComTypes.DISPPARAMS&,System.IntPtr,System.IntPtr,System.Int32&):System.Void", MessageId="p", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.Invoke(System.Object,System.Int32,System.Int16,System.Runtime.InteropServices.ComTypes.DISPPARAMS&,System.IntPtr,System.IntPtr,System.Int32&):System.Void", MessageId="Excep", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.Invoke(System.Object,System.Int32,System.Int16,System.Runtime.InteropServices.ComTypes.DISPPARAMS&,System.IntPtr,System.IntPtr,System.Int32&):System.Void", MessageId="w", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.Invoke(System.Object,System.Int32,System.Int16,System.Runtime.InteropServices.ComTypes.DISPPARAMS&,System.IntPtr,System.IntPtr,System.Int32&):System.Void", MessageId="memid", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.Invoke(System.Object,System.Int32,System.Int16,System.Runtime.InteropServices.ComTypes.DISPPARAMS&,System.IntPtr,System.IntPtr,System.Int32&):System.Void", MessageId="Disp", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.Invoke(System.Object,System.Int32,System.Int16,System.Runtime.InteropServices.ComTypes.DISPPARAMS&,System.IntPtr,System.IntPtr,System.Int32&):System.Void", MessageId="Params", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.Invoke(System.Object,System.Int32,System.Int16,System.Runtime.InteropServices.ComTypes.DISPPARAMS&,System.IntPtr,System.IntPtr,System.Int32&):System.Void", MessageId="pu", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.ReleaseFuncDesc(System.IntPtr):System.Void", MessageId="Func", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.ReleaseFuncDesc(System.IntPtr):System.Void", MessageId="Desc", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.ReleaseFuncDesc(System.IntPtr):System.Void", MessageId="p", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetDocumentation(System.Int32,System.String&,System.String&,System.Int32&,System.String&):System.Void", MessageId="dw", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetDocumentation(System.Int32,System.String&,System.String&,System.Int32&,System.String&):System.Void", MessageId="str", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetIDsOfNames(System.String[],System.Int32,System.Int32[]):System.Void", MessageId="Mem", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetIDsOfNames(System.String[],System.Int32,System.Int32[]):System.Void", MessageId="c", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetIDsOfNames(System.String[],System.Int32,System.Int32[]):System.Void", MessageId="rgsz", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetIDsOfNames(System.String[],System.Int32,System.Int32[]):System.Void", MessageId="p", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetIDsOfNames(System.String[],System.Int32,System.Int32[]):System.Void", MessageId="IDs", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetContainingTypeLib(System.Runtime.InteropServices.ComTypes.ITypeLib&,System.Int32&):System.Void", MessageId="p", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetContainingTypeLib(System.Runtime.InteropServices.ComTypes.ITypeLib&,System.Int32&):System.Void", MessageId="TLB", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.AddressOfMember(System.Int32,System.Runtime.InteropServices.ComTypes.INVOKEKIND,System.IntPtr&):System.Void", MessageId="memid", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.AddressOfMember(System.Int32,System.Runtime.InteropServices.ComTypes.INVOKEKIND,System.IntPtr&):System.Void", MessageId="ppv", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.ReleaseTypeAttr(System.IntPtr):System.Void", MessageId="p", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.ReleaseTypeAttr(System.IntPtr):System.Void", MessageId="Attr", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.CreateInstance(System.Object,System.Guid&,System.Object&):System.Void", MessageId="Unk", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.CreateInstance(System.Object,System.Guid&,System.Object&):System.Void", MessageId="riid", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.CreateInstance(System.Object,System.Guid&,System.Object&):System.Void", MessageId="p", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.CreateInstance(System.Object,System.Guid&,System.Object&):System.Void", MessageId="ppv", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetFuncDesc(System.Int32,System.IntPtr&):System.Void", MessageId="Func", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetFuncDesc(System.Int32,System.IntPtr&):System.Void", MessageId="Desc", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetNames(System.Int32,System.String[],System.Int32,System.Int32&):System.Void", MessageId="Bstr", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetNames(System.Int32,System.String[],System.Int32,System.Int32&):System.Void", MessageId="c", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetNames(System.Int32,System.String[],System.Int32,System.Int32&):System.Void", MessageId="memid", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetNames(System.Int32,System.String[],System.Int32,System.Int32&):System.Void", MessageId="rg", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetMops(System.Int32,System.String&):System.Void", MessageId="Bstr", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetMops(System.Int32,System.String&):System.Void", MessageId="memid", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetMops(System.Int32,System.String&):System.Void", MessageId="p", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetTypeAttr(System.IntPtr&):System.Void", MessageId="Attr", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetRefTypeInfo(System.IntPtr,Microsoft.Build.Tasks.IFixedTypeInfo&):System.Void", MessageId="h", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.ReleaseVarDesc(System.IntPtr):System.Void", MessageId="Desc", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.ReleaseVarDesc(System.IntPtr):System.Void", MessageId="p", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.IFixedTypeInfo.GetVarDesc(System.Int32,System.IntPtr&):System.Void", MessageId="Desc", Justification="These are spelled and named in c++ syntax because it is a temporary fixed implementation of the ITypeInfo interface, when the interface is reverted to the original these suppression messages can go away.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.IBuildResults.ComponentFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.IBuildResults.Messages", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.Manifest.XmlFileReferences", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.Manifest.XmlAssemblyReferences", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.FileReference.TypeLibs", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.FileReference.XmlTypeLibs", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.FileReference.ComClasses", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.FileReference.ProxyStubs", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.FileReference.XmlComClasses", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.FileReference.XmlProxyStubs", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.AssemblyManifest.ExternalProxyStubs", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.AssemblyManifest.XmlExternalProxyStubs", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Design", "CA2210:AssembliesShouldHaveValidStrongNames", Justification="Our assemblies are delay signed.")]
[module: SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope="namespace", Target="Microsoft.Build.Tasks.Hosting", Justification="KCwalina explicitly asked us to move these types into their own namespace since they're not tasks.")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope="namespace", Target="Microsoft.Build.Tasks.Hosting", Justification="Microsoft.Build.Tasks.Hosting is approved.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="type", Target="Microsoft.Build.Tasks.Hosting.ICscHostObject2", MessageId="Csc", Justification="This is the name of the C# compiler and this interface is a wrapper over it.  Keeping the name.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="type", Target="Microsoft.Build.Tasks.Hosting.IVbcHostObject", MessageId="Vbc", Justification="VBC and CSC are spelled correctly.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:IdentifiersShouldNotContainTypeNames", Scope="member", Target="Microsoft.Build.Tasks.Hosting.IVbcHostObject.SetRemoveIntegerChecks(System.Boolean):System.Boolean", MessageId="0#", Justification="This parameter is not referring to a type, it's referring to a switch on the VBC compiler.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="type", Target="Microsoft.Build.Tasks.Hosting.ICscHostObject", MessageId="Csc", Justification="VBC and CSC are spelled correctly.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope="member", Target="Microsoft.Build.Tasks.Hosting.ICscHostObject.EndInitialization(System.String&,System.Int32&):System.Boolean", MessageId="0#", Justification="Method has multiple return values, so it must use out parameters.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope="member", Target="Microsoft.Build.Tasks.Hosting.ICscHostObject.EndInitialization(System.String&,System.Int32&):System.Boolean", MessageId="1#", Justification="Method has multiple return values, so it must use out parameters.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="type", Target="Microsoft.Build.Tasks.Hosting.IVbcHostObject2", MessageId="Vbc", Justification="Vbc is the correct spelling for the VB compiler.")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope="namespace", Target="Microsoft.Build.Tasks", Justification="Microsoft.Build.Tasks is an approved namespace according to http://ddwww/apps/apiowners/")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.GetFrameworkPath..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.LC.ReferencedAssemblies", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.LC.ReferencedAssemblies", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.LC.Sources", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.LC.Sources", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AssignProjectConfiguration.AssignedProjects", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.AssignProjectConfiguration.AssignedProjects", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AssignProjectConfiguration.UnassignedProjects", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.AssignProjectConfiguration.UnassignedProjects", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.AssignProjectConfiguration..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Naming", "CA1725:ParameterNamesShouldMatchBaseDeclaration", Scope="member", Target="Microsoft.Build.Tasks.CreateCSharpManifestResourceName.CreateManifestName(System.String,System.String,System.String,System.String,System.IO.Stream):System.String", MessageId="2#", Justification="Cannot change parameter names because that would break compat with reflection users, theoretically.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.RegisterAssembly.TypeLibFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.RegisterAssembly.TypeLibFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Naming", "CA1725:ParameterNamesShouldMatchBaseDeclaration", Scope="member", Target="Microsoft.Build.Tasks.RegisterAssembly.ResolveRef(System.Reflection.Assembly):System.Object", MessageId="0#", Justification="Cannot change parameter names because that would break compat with reflection users, theoretically.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.Tasks.RegisterAssembly.Register(System.String,System.String):System.Boolean", MessageId="System.Reflection.Assembly.LoadFrom", Justification="We need to call Assembly.LoadFrom here, it's by design.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.RegisterAssembly.Assemblies", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.RegisterAssembly.Assemblies", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.RegisterAssembly..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Naming", "CA1725:ParameterNamesShouldMatchBaseDeclaration", Scope="member", Target="Microsoft.Build.Tasks.RegisterAssembly.ReportEvent(System.Runtime.InteropServices.ExporterEventKind,System.Int32,System.String):System.Void", MessageId="0#", Justification="Cannot change parameter names because that would break compat with reflection users, theoretically.")]
[module: SuppressMessage("Microsoft.Naming", "CA1725:ParameterNamesShouldMatchBaseDeclaration", Scope="member", Target="Microsoft.Build.Tasks.RegisterAssembly.ReportEvent(System.Runtime.InteropServices.ExporterEventKind,System.Int32,System.String):System.Void", MessageId="1#", Justification="Cannot change parameter names because that would break compat with reflection users, theoretically.")]
[module: SuppressMessage("Microsoft.Naming", "CA1725:ParameterNamesShouldMatchBaseDeclaration", Scope="member", Target="Microsoft.Build.Tasks.RegisterAssembly.ReportEvent(System.Runtime.InteropServices.ExporterEventKind,System.Int32,System.String):System.Void", MessageId="2#", Justification="Cannot change parameter names because that would break compat with reflection users, theoretically.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.CreateProperty.ValueSetByTask", Justification="this is the msbuild task authoring model")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.CreateProperty.Value", Justification="this is the msbuild task authoring model")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.CreateProperty.Value", Justification="this is the msbuild task authoring model")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.CreateItem.Include", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.CreateItem.Include", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.CreateItem..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.CreateItem.AdditionalMetadata", Justification="msbuild task authoring model")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.CreateItem.AdditionalMetadata", Justification="msbuild task authoring model")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.CreateItem.Exclude", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.CreateItem.Exclude", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.GetAssemblyIdentity.AssemblyFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.GetAssemblyIdentity.AssemblyFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.GetAssemblyIdentity.Execute():System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.GetAssemblyIdentity.Assemblies", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.GetAssemblyIdentity.Assemblies", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ParseState..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.ResolvedFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.ResolvedFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.TypeLibNames", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.TypeLibNames", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.Execute():System.Boolean", Justification="In some situations the underlying wrapper generation code can throw a SystemException and there's nothing else we can do to prevent MSBuild from crashing.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.TypeLibFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.TypeLibFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.ResolvedAssemblyReferences", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.ResolvedAssemblyReferences", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.ResolvedModules", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.ResolvedModules", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReference.VerifyReferenceMetadataForNameItem(Microsoft.Build.Framework.ITaskItem,System.String&):System.Boolean", MessageId="System.Guid", Justification="The Guid is created and never used on purpose, to check if the passed-in guid is valid.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.DependentAssembly..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveNonMSBuildProjectOutput.ResolvedOutputPaths", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveNonMSBuildProjectOutput.ResolvedOutputPaths", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveNonMSBuildProjectOutput.UnresolvedProjectReferences", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveNonMSBuildProjectOutput.UnresolvedProjectReferences", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ResolveNonMSBuildProjectOutput..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.ResolveNonMSBuildProjectOutput.PreresolvedProjectOutputs", MessageId="Preresolved", Justification="Preresolved is spelled correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.SearchPaths", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.SearchPaths", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.AssemblyFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.AssemblyFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.Assemblies", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.Assemblies", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.ResolvedFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.RelatedFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.ResolvedDependencyFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.ScatterFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.SatelliteFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.SerializationAssemblyFiles")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.TargetFrameworkDirectories", Justification="This is the MSBuild task authoring model for Whidbey.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.TargetFrameworkDirectories", Justification="This is the MSBuild task authoring model for Whidbey.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.SuggestedRedirects", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.AllowedAssemblyExtensions", Justification="This is an appropriate design in this case.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.AllowedAssemblyExtensions", Justification="This is an appropriate design in this case.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.InstalledAssemblyTables", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.InstalledAssemblyTables", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.CandidateAssemblyFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.CandidateAssemblyFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.FilesWritten", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.FilesWritten", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.set_FilesWritten(Microsoft.Build.Framework.ITaskItem[]):System.Void", MessageId="value", Justification="This is an output only property so we have no use for the implicit value input parameter.  We cannot however remove the property set because this would be a breaking change.  Excluding instead.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.CopyLocalFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.SGen.SerializationAssembly", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.SGen.SerializationAssembly", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.SGen.References", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.SGen.References", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.Tasks.AspNetCompiler.MetabasePath", MessageId="Metabase", Justification="Metabase is spelled correctly - it's an IIS term")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.AssemblyInformation..ctor(System.String)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AssignTargetPath.Files", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.AssignTargetPath.Files", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AssignTargetPath.AssignedFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.AssignTargetPath..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ResolveComReferenceCache..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.CreateManifestResourceName.ManifestResourceNames", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.CreateManifestResourceName.Execute(Microsoft.Build.Tasks.CreateFileStream):System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.CreateManifestResourceName..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.CreateManifestResourceName.ResourceFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.CreateManifestResourceName.ResourceFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.MSBuild..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.MSBuild.Targets", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.MSBuild.Targets", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.MSBuild.TargetOutputs", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.Tasks.MSBuild.ExecuteTargets(Microsoft.Build.Framework.ITaskItem[],System.Collections.Hashtable,System.Collections.ArrayList,System.Boolean,System.Boolean,Microsoft.Build.Framework.IBuildEngine2,Microsoft.Build.Utilities.TaskLoggingHelper,System.Collections.ArrayList,System.Boolean,System.Boolean,System.String):System.Boolean", Justification="Refactoring would decrease readability")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.MSBuild.Projects", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.MSBuild.Projects", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.MSBuild.Properties", Justification="msbuild task authoring model")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.MSBuild.Properties", Justification="msbuild task authoring model")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.BindingRedirect..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1815:OverrideEqualsAndOperatorEqualsOnValueTypes", Scope="type", Target="Microsoft.Build.Tasks.ExtractedClassName", Justification="This is an internally used class and it doesn't need an implementation of Equals.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.AssemblyFoldersExResolver..ctor(System.String,Microsoft.Build.Tasks.GetAssemblyName,Microsoft.Build.Shared.FileExists,Microsoft.Build.Tasks.GetRegistrySubKeyNames,Microsoft.Build.Tasks.GetRegistrySubKeyDefaultValue)", Justification="Explicit initialization improves code readability.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.Tasks.AxReference.GenerateWrapper(Microsoft.Build.Tasks.ComReferenceWrapperInfo&):System.Boolean", MessageId="System.Reflection.Assembly.LoadFrom", Justification="We need to call Assembly.LoadFrom here, it's by design.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.Tasks.PiaReference.FindExistingWrapper(Microsoft.Build.Tasks.ComReferenceWrapperInfo&,System.DateTime):System.Boolean", MessageId="System.Reflection.Assembly.LoadFrom", Justification="We need to call Assembly.LoadFrom here, it's by design.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.GetFrameworkSdkPath..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ProcessResourceFiles+LineNumberStreamReader..ctor(System.IO.Stream)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ProcessResourceFiles+LineNumberStreamReader..ctor(System.String,System.Text.Encoding,System.Boolean)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Naming", "CA1725:ParameterNamesShouldMatchBaseDeclaration", Scope="member", Target="Microsoft.Build.Tasks.CreateVisualBasicManifestResourceName.CreateManifestName(System.String,System.String,System.String,System.String,System.IO.Stream):System.String", MessageId="2#", Justification="Cannot change parameter names because that would break compat with reflection users, theoretically.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.ResolveKeySource.ResolveAssemblyKey():System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope="member", Target="Microsoft.Build.Tasks.ResolveKeySource.ResolveAssemblyKey():System.Boolean", Justification="From comments:  We use ToLower(invariant) because this is what the native equivalent of this function (Create new key, or VC++ import-er). use as well and we want to keep the hash (and key container name the same) otherwise user could be prompt for a password twice.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ResolveKeySource..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.DisposableBase..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.ResolveVCProjectOutput.Execute():System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveVCProjectOutput.ResolvedOutputPaths", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveVCProjectOutput.ResolvedOutputPaths", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ResolveVCProjectOutput..cctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="Microsoft.Build.Tasks.ResolveVCProjectOutput.vcProjectEngineDll", Justification="It's not necessary to use a SafeHandle here - we load the dll just once and it's released automatically on process shutdown by the system.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveVCProjectOutput.ProjectReferences", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveVCProjectOutput.ProjectReferences", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.Tasks.ResolveVCProjectOutput.ResolveUsingVCEngineObjectModel(Microsoft.Build.Framework.ITaskItem,System.String,System.String&,System.String&):System.Boolean", Justification="Refactoring would cause increased complexity rather than decrease it")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.ResolveVCProjectOutput.ResolveUsingVCEngineObjectModel(Microsoft.Build.Framework.ITaskItem,System.String,System.String&,System.String&):System.Boolean", Justification="The exception is rethrown unless it's a known type.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ResolveVCProjectOutput..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.Tasks.ProcessResourceFiles.ReadTextResources(System.String):System.Void", Justification="Further reduction would degrade readability.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.ProcessResourceFiles.ProcessFile(System.String,System.String):System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.Tasks.ProcessResourceFiles.ResolveAssembly(System.Object,System.ResolveEventArgs):System.Reflection.Assembly", MessageId="System.Reflection.Assembly.LoadFile", Justification="This is by design.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.Tasks.ProcessResourceFiles.ResolveAssembly(System.Object,System.ResolveEventArgs):System.Reflection.Assembly", MessageId="System.Reflection.Assembly.LoadFrom", Justification="This is intentional.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ProcessResourceFiles..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.InstalledAssemblies..ctor(Microsoft.Build.Tasks.RedistList)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.VCBuild.Projects", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.VCBuild.Projects", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.VCBuild.Execute():System.Boolean", Justification="This exception is rethrown if it's not a known type.")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.Tasks.VCBuild.set_UserEnvironment(System.Boolean):System.Void", MessageId="value", Justification="This method only exists for backward compatibility and will be removed in a future release.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.VCBuild..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.VCBuild.AdditionalLibPaths", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.VCBuild.AdditionalLibPaths", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.VCBuild.get_EnvironmentOverride():System.Collections.Specialized.StringDictionary", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ComReference..cctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AL.SourceModules", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.AL.SourceModules", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AL.EmbedResources", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.AL.EmbedResources", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AL.LinkResources", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.AL.LinkResources", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AL.ResponseFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.AL.ResponseFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.WriteLinesToFile.Lines", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.WriteLinesToFile.Lines", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.WriteLinesToFile..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.WriteLinesToFile.Execute():System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="Microsoft.Build.Tasks.NativeMethods+CRYPTOAPI_BLOB", Justification="Allocation/deallocation of these structs is handled elsewhere.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="Microsoft.Build.Tasks.NativeMethods+CRYPTOAPI_BLOB.pbData", Justification="We will do this in Visual Studio 2008. In Whidbey we must still support the Everett runtime.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.RemoveDuplicates.Inputs", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.RemoveDuplicates.Inputs", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.RemoveDuplicates.Filtered", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.RemoveDuplicates.Filtered", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.RemoveDuplicates..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="type", Target="Microsoft.Build.Tasks.Vbc", MessageId="Vbc", Justification="These are named after the compiler tool, so they are spelled correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.Vbc.InitializeHostCompiler(Microsoft.Build.Tasks.Hosting.IVbcHostObject):System.Boolean")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.Vbc.InitializeHostCompiler(Microsoft.Build.Tasks.Hosting.IVbcHostObject):System.Boolean")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.Vbc..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Vbc.Imports", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.Vbc.Imports", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Exec.Outputs", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.Exec.Outputs", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.Exec..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Naming", "CA1721:PropertyNamesShouldNotMatchGetMethods", Scope="member", Target="Microsoft.Build.Tasks.Exec.WorkingDirectory", Justification="GetWorkingDirectory() is an overridden protected method and is reasonably named. The WorkingDirectory property is public and also reasonably named and has different users. In his particular scenario I think these names are the best and won't cause confusion.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.Tasks.AssemblyFoldersEx.FindDirectories(Microsoft.Win32.RegistryKey,System.String,System.String,System.String,System.String,System.String,Microsoft.Build.Tasks.GetRegistrySubKeyNames,Microsoft.Build.Tasks.GetRegistrySubKeyDefaultValue):System.Void", Justification="Further reduction would degrade readability.")]
[module: SuppressMessage("Microsoft.Naming", "CA1716:IdentifiersShouldNotMatchKeywords", Scope="type", Target="Microsoft.Build.Tasks.Delete", Justification="We want to use Delete for the name of the task, as it matches the DOS command and is what users will expect.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Delete.Files", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.Delete.Files", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Delete.DeletedFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.Delete.DeletedFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.Delete..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.Delete.Execute():System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.RemoveDir.RemovedDirectories", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.RemoveDir.RemovedDirectories", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.RemoveDir.RemoveReadOnlyAttributeRecursively(System.IO.DirectoryInfo):System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.RemoveDir.Directories", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.RemoveDir.Directories", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.RemoveDir.RemoveDirectory(Microsoft.Build.Framework.ITaskItem,System.Boolean,System.Boolean&):System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ResolveProjectBase..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope="member", Target="Microsoft.Build.Tasks.ResolveProjectBase.VerifyReferenceAttributes(Microsoft.Build.Framework.ITaskItem,System.String&):System.Boolean", MessageId="System.Guid", Justification="We're creating a Guid object from a string to confirm that the string is a valid GUID. The Guid structure provides no other way of checking this e.g. a TryParse() method. We don't actually need the Guid object for anything.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveProjectBase.ProjectReferences", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveProjectBase.ProjectReferences", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.CreateTemporaryVCProject.ReferenceGuids", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.CreateTemporaryVCProject.ReferenceGuids", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.CreateTemporaryVCProject.ReferenceAssemblies", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.CreateTemporaryVCProject.ReferenceAssemblies", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.CreateTemporaryVCProject.Execute():System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.LinkResources", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.LinkResources", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.AddModules", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.AddModules", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.Sources", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.Sources", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.set_TargetType(System.String):System.Void", Justification="This string is not being normalized but rather formatted to be used as a command line switch, where it is expected in lowercase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.Resources", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.Resources", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.ResponseFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.ResponseFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.AdditionalLibPaths", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.AdditionalLibPaths", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.References", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ManagedCompiler.References", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.SystemState..ctor(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.SystemState..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ResolutionSearchLocation..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource.ReadStateFile():System.Void", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource.FilesWritten", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource.FilesWritten", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource.Sources", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource.Sources", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource.Execute():System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource.NeedSeparateAppDomain():System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource.References", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource.References", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource.OutputResources", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.GenerateResource.OutputResources", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AssignCulture.AssignedFilesWithNoCulture", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AssignCulture.Files", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.AssignCulture.Files", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AssignCulture.AssignedFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AssignCulture.AssignedFilesWithCulture", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.AssignCulture.CultureNeutralAssignedFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.AssignCulture..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Touch.Files", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.Touch.Files", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Touch.TouchedFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.Touch.TouchedFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.Touch..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Copy.SourceFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.Copy.SourceFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Copy.DestinationFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.Copy.DestinationFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Copy.CopiedFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.Copy.Execute(Microsoft.Build.Tasks.CopyFile):System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.Copy..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.AxTlbBaseReference..ctor(Microsoft.Build.Utilities.TaskLoggingHelper,Microsoft.Build.Tasks.IComReferenceResolver,Microsoft.Build.Tasks.ComReferenceInfo,System.String,System.String,System.Boolean,System.String,System.String)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.Tasks.AxTlbBaseReference.IsWrapperUpToDate(Microsoft.Build.Tasks.ComReferenceWrapperInfo,System.DateTime):System.Boolean", MessageId="System.Reflection.Assembly.LoadFrom", Justification="We need to call Assembly.LoadFrom here, it's by design.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.UnregisterAssembly.TypeLibFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.UnregisterAssembly.TypeLibFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.Tasks.UnregisterAssembly.Unregister(System.String,System.String):System.Boolean", MessageId="System.Reflection.Assembly.LoadFrom", Justification="We need to call Assembly.LoadFrom here, it's by design.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.UnregisterAssembly.Assemblies", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.UnregisterAssembly.Assemblies", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.UnregisterAssembly..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.StateFileBase.SerializeCache(System.String,Microsoft.Build.Utilities.TaskLoggingHelper):System.Void", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.StateFileBase.DeleteFile(System.String,Microsoft.Build.Utilities.TaskLoggingHelper):System.Void", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.StateFileBase.DeserializeCache(System.String,Microsoft.Build.Utilities.TaskLoggingHelper,System.Type):Microsoft.Build.Tasks.StateFileBase", Justification="We log the exception as a warning, but a problem reading the cache file should never cause building to fail, so we continue.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.SystemState+FileState..ctor(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.SystemState+FileState..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="type", Target="Microsoft.Build.Tasks.Csc", MessageId="Csc", Justification="These are named after the compiler tool, so they are spelled correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.Csc..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.Csc.InitializeHostCompiler(Microsoft.Build.Tasks.Hosting.ICscHostObject):System.Boolean")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.Csc.InitializeHostCompiler(Microsoft.Build.Tasks.Hosting.ICscHostObject):System.Boolean")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.Reference..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.FindUnderPath.Files", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.FindUnderPath.Files", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.FindUnderPath.OutOfPath", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.FindUnderPath.OutOfPath", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.FindUnderPath.InPath", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.FindUnderPath.InPath", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.FindUnderPath..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.FindUnderPath.Execute():System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Naming", "CA1716:IdentifiersShouldNotMatchKeywords", Scope="type", Target="Microsoft.Build.Tasks.Error", Justification="This maps to an XML element name, so we need to use the name Error.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.DependencyFile..ctor(System.String)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.Tasks.AssemblyNamesTypeResolutionService.GetAssemblyByPath(System.String,System.Boolean):System.Reflection.Assembly", MessageId="System.Reflection.Assembly.LoadFrom", Justification="We need to call Assembly.LoadFrom in AssemblyNamesTypeResolutionService.GetAssemblyByPath to locate the assembly on disk.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.ReadLinesFromFile.Execute():System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ReadLinesFromFile..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ReadLinesFromFile.Lines", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ReadLinesFromFile.Lines", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="Microsoft.Build.Tasks.ASSEMBLYMETADATA", Justification="Allocation/deallocation of these structs is handled elsewhere.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="Microsoft.Build.Tasks.ASSEMBLYMETADATA.rpLocale", Justification="These pointers are incidental members of structures that aren't used.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="Microsoft.Build.Tasks.ASSEMBLYMETADATA.rOses", Justification="These pointers are incidental members of structures that aren't used.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="Microsoft.Build.Tasks.ASSEMBLYMETADATA.rpProcessors", Justification="These pointers are incidental members of structures that aren't used.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="Microsoft.Build.Tasks.NativeMethods.InvalidIntPtr", Justification="We will do this in Visual Studio 2008. In Whidbey we must still support the Everett runtime.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope="member", Target="Microsoft.Build.Tasks.NativeMethods.CompareAssemblyIdentity(System.String,System.Boolean,System.String,System.Boolean,System.Boolean&,Microsoft.Build.Tasks.NativeMethods+AssemblyComparisonResult&):System.Int32", Justification="This method CompareAssemblyIdentity does exist, in fusion.dll.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.CallTarget.Targets", Justification="msbuild task model necessitates this.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.CallTarget.Targets", Justification="msbuild task model necessitates this.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.CallTarget..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.CallTarget.TargetOutputs", Justification="msbuild task model necessitates this.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.MakeDir.Directories", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.MakeDir.Directories", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.MakeDir.DirectoriesCreated", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.Tasks.MakeDir.Execute():System.Boolean", Justification="A helper method rethrows non-IO exceptions, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.AppConfigException..ctor(System.String,System.String,System.Int32,System.Int32,System.Exception)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainedLooseEtcFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainedLooseEtcFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainingReferenceFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainingReferenceFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.NativeReferences", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.NativeReferences", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.AdditionalSearchPaths", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.AdditionalSearchPaths", Justification="All MSBuild tasks accept input and output item arrays this way. This is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainedComComponents", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainedComComponents", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainedPrerequisiteAssemblies", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainedPrerequisiteAssemblies", Justification="All MSBuild tasks accept input and output item arrays this way. This is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainedLooseTlbFiles", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainedLooseTlbFiles", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainedTypeLibraries", Justification="The MSBuild task model requires that we have read/write properties that are collections/arrays. Arrays are the only way to have strongly typed collections that build on Everett, and properties are used to map to XML attributes in the file format.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ContainedTypeLibraries", Justification="All MSBuild tasks accept and output item arrays this way, this is by design. Tasks are only called by the MSBuild engine, which will access them correctly.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.Tasks.ResolveNativeReference.ExtractFromManifest(Microsoft.Build.Framework.ITaskItem,System.String,System.Collections.Hashtable,System.Collections.Hashtable,System.Collections.Hashtable,System.Collections.Hashtable,System.Collections.Hashtable,System.Collections.Hashtable):System.Boolean", Justification="Complexity is only 26 (cutoff is 25), and further reductions would degrade readability.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.TlbReference..ctor(Microsoft.Build.Utilities.TaskLoggingHelper,Microsoft.Build.Tasks.IComReferenceResolver,Microsoft.Build.Tasks.ComReferenceInfo,System.String,System.String,System.Boolean,System.Boolean,System.String,System.String,System.Boolean)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.AssemblyRegistrationCache..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.LanguageParser.StreamMappedString..ctor(System.IO.Stream,System.Boolean,System.Int32)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.Shared.LanguageParser.CSharpTokenEnumerator.FindNextToken():System.Boolean", Justification="Reduced complexity from 170+ to less than 40 - further reductions would make the code less readable.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.LanguageParser.CSharpTokenEnumerator..ctor(System.IO.Stream,System.Boolean)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.LanguageParser.TokenEnumerator..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.Shared.LanguageParser.VisualBasicTokenEnumerator.FindNextToken():System.Boolean", Justification="Reduced complexity from 170+ to less than 40 - further reductions would make the code less readable.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.LanguageParser.VisualBasicTokenEnumerator..ctor(System.IO.Stream,System.Boolean)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.LanguageParser.VisualBasicTokenizer..ctor(System.IO.Stream,System.Boolean)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.LanguageParser.Token..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.LanguageParser.CSharpTokenizer..ctor(System.IO.Stream,System.Boolean)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.FileMatcher+Result..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Usage", "CA2205:UseManagedEquivalentsOfWin32Api", Scope="member", Target="NativeMethodsShared.GetCurrentDirectory(System.Int32,System.Text.StringBuilder):System.Int32", Justification="For performance reasons use unmanagedWin32 API. The managed one does extra security checks")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension..ctor(System.Reflection.AssemblyName)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension..ctor(System.String)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension..ctor(System.String,System.Boolean)", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Performance", "CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension..ctor()", Justification="We've chosen to retain these initializations because they improve the readability of the codebase.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.IsItemSpecModifier(System.String):System.Boolean", Justification="Further reduction would degrade readability.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.GetItemSpecModifier(System.String,System.String,System.String,System.Collections.Hashtable&):System.String", Justification="was excluded before.")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", MessageId="Metabase", Justification="These are correct spellings")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", MessageId="bootstrapper", Justification="These are correct spellings")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", MessageId="redist", Justification="These are correct spellings")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", MessageId="aximp", Justification="These are correct spellings")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", MessageId="tlbimp", Justification="These are correct spellings")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", MessageId="Resx", Justification="These are correct spellings")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.GenerateApplicationManifest.#ErrorReportUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.GenerateDeploymentManifest.#ErrorReportUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Naming","CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Scope="type", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.IProductBuilderCollection", Justification="These are public properties on public interfaces, these cannot have their name changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Naming","CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Scope="type", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.IProductCollection", Justification="These are public properties on public interfaces, these cannot have their name changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ApplicationManifest.#ErrorReportUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1008:EnumsShouldHaveZeroValue", Scope="type", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.AssemblyIdentity+FullNameFlags", Justification="These are public properties on public tasks, these cannot have their values changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1034:NestedTypesShouldNotBeVisible", Scope="type", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.AssemblyIdentity+FullNameFlags", Justification="These are public properties on public class, these cannot have their location changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ApplicationManifest.#XmlErrorReportUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="ClsId", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ComClass.#ClsId", Justification="These are public properties on public class, these cannot have their name changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="ClsId", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ComClass.#XmlClsId", Justification="These are public properties on public class, these cannot have their name changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.DeployManifest.#ErrorReportUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.DeployManifest.#XmlErrorReportUrl", Justification="These are public properties on public tasks, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Design","CA1059:MembersShouldNotExposeCertainConcreteTypes", MessageId="System.Xml.XmlNode", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.SecurityUtilities.#XmlToPermissionSet(System.Xml.XmlElement)", Justification="These are public functions on public classes, these cannot have their parameter changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Naming","CA1721:PropertyNamesShouldNotMatchGetMethods", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.AssemblyIdentity.#Type", Justification="hese are public properties on public class, these cannot have their type changed due to backwards compatibility")]
[module: SuppressMessage("Microsoft.Performance","CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ApplicationManifest.#XmlFileAssociations", Justification="Released API")]
[module: SuppressMessage("Microsoft.Performance","CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.DeployManifest.#XmlCompatibleFrameworks", Justification="Released API")]
[module: SuppressMessage("Microsoft.Globalization","CA1307:SpecifyStringComparison", MessageId="System.String.CompareTo(System.String)", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.Manifest+ReferenceComparer.#Compare(System.Object,System.Object)", Justification="this is an overloaded Compare method.")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="Microsoft.Build.Tasks.Deployment.ManifestUtilities.NativeMethods.EnumResourceNames(System.IntPtr,System.IntPtr,Microsoft.Build.Tasks.Deployment.ManifestUtilities.NativeMethods+EnumResNameProc,System.IntPtr)", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.EmbeddedManifestReader.#.ctor(System.String)")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ManifestReader.#Deserialize(System.String)")]
[module: SuppressMessage("Microsoft.Usage","CA2208:InstantiateArgumentExceptionsCorrectly", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.TrustInfo.#set_PermissionSet(System.Security.PermissionSet)")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="System.Globalization.CultureInfo", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.Util.#IsValidCulture(System.String)")]
[module: SuppressMessage("Microsoft.Usage","CA1816:CallGCSuppressFinalizeCorrectly", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.MetadataReader.#System.IDisposable.Dispose()")]
[module: SuppressMessage("Microsoft.Usage","CA1816:CallGCSuppressFinalizeCorrectly", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.MetadataReader.#System.IDisposable.Dispose()")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="System.IO.StreamReader", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.SecurityUtilities.#GetXmlElement(System.String,Microsoft.Build.Utilities.FrameworkName)")]
[module: SuppressMessage("Microsoft.Naming","CA1721:PropertyNamesShouldNotMatchGetMethods", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.OutputMessage.#Type")]
[module: SuppressMessage("Microsoft.Globalization","CA1307:SpecifyStringComparison", MessageId="System.String.CompareTo(System.String)", Scope="member", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.BootstrapperBuilder+GraphNodeNameComparer.#Compare(System.Object,System.Object)")]
[module: SuppressMessage("Microsoft.Globalization","CA1307:SpecifyStringComparison", MessageId="System.String.CompareTo(System.String)", Scope="member", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.BootstrapperBuilder.#GetOutputFolders(System.String[],System.String,System.String,Microsoft.Build.Tasks.Deployment.Bootstrapper.ComponentsLocation)")]
[module: SuppressMessage("Microsoft.Naming", "CA1718:AvoidLanguageSpecificTypeNamesInParameters", Scope = "member", Target = "Microsoft.Build.Tasks.Hosting.IVbcHostObject.SetRemoveIntegerChecks(System.Boolean):System.Boolean", MessageId = "0#")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "Microsoft.Build.Tasks.Hosting.IVbcHostObject.SetRemoveIntegerChecks(System.Boolean):System.Boolean", MessageId = "0#")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope = "member", Target = "Microsoft.Build.Tasks.GetFrameworkSdkPath.set_Path(System.String):System.Void", MessageId = "value")]
[module: SuppressMessage("Microsoft.Reliability", "CA2000:DisposeObjectsBeforeLosingScope", Scope = "member", Target = "Microsoft.Build.Tasks.ProcessResourceFiles.ReadResources(System.String,System.Boolean):System.Void")]
[module: SuppressMessage("Microsoft.Reliability", "CA2000:DisposeObjectsBeforeLosingScope", Scope = "member", Target = "Microsoft.Build.Tasks.ProcessResourceFiles.WriteResources(System.String):System.Void")]
[module: SuppressMessage("Microsoft.Reliability", "CA2000:DisposeObjectsBeforeLosingScope", Scope = "member", Target = "Microsoft.Build.Tasks.ProcessResourceFiles.WriteTextResources(System.String):System.Void")]
[module: SuppressMessage("Microsoft.Reliability", "CA2000:DisposeObjectsBeforeLosingScope", Scope = "member", Target = "Microsoft.Build.Tasks.Exec.CreateTemporaryBatchFile():System.Void")]
[module: SuppressMessage("Microsoft.Performance", "CA1807:AvoidUnnecessaryStringCreation", Scope = "member", Target = "Microsoft.Build.Tasks.ManagedCompiler.set_TargetType(System.String):System.Void", MessageId = "value")]
[module: SuppressMessage("Microsoft.Performance", "CA1807:AvoidUnnecessaryStringCreation", Scope = "member", Target = "Microsoft.Build.Tasks.ManagedCompiler.set_TargetType(System.String):System.Void", MessageId = "stack2")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope = "member", Target = "Microsoft.Build.Tasks.ManagedCompiler.set_TargetType(System.String):System.Void")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope = "member", Target = "Microsoft.Build.Shared.FileUtilities.GetItemSpecModifier(System.String,System.String,System.String,System.Collections.Generic.Dictionary`2<System.String,System.String>&):System.String")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope = "resource", Target = "Microsoft.Build.Tasks.Strings.resources", MessageId = "progid")]
[module: SuppressMessage("Microsoft.Performance","CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Xaml.CommandLineToolSwitch.#TaskItemArray")]
[module: SuppressMessage("Microsoft.Naming","CA1721:PropertyNamesShouldNotMatchGetMethods", Scope="member", Target="Microsoft.Build.Tasks.Xaml.CommandLineToolSwitch.#Type")]
[module: SuppressMessage("Microsoft.Globalization","CA2101:SpecifyMarshalingForPInvokeStringArguments", MessageId="4", Scope="member", Target="Microsoft.Build.Tasks.Xaml.XamlDataDrivenToolTask+XamlTaskNativeMethods.#SearchPath(System.String,System.String,System.String,System.Int32,System.Text.StringBuilder,System.IntPtr&)")]
[module: SuppressMessage("Microsoft.Performance","CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="Microsoft.Build.Tasks.Xaml.CommandLineToolSwitch.#StringList")]
[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.RequiresFramework35SP1Assembly.#ErrorReportUrl")]
[module: SuppressMessage("Microsoft.Performance","CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Utilities.CanonicalError+Parts.#.ctor()", Justification="clearer this way")]
[module: SuppressMessage("Microsoft.Performance","CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Runtime.Hosting.StrongNameHelpers.#.cctor()", Justification="we don't own this code")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="Microsoft.Runtime.Hosting.IClrStrongNameUsingIntPtr.StrongNameFreeBuffer(System.IntPtr)", Scope="member", Target="Microsoft.Runtime.Hosting.StrongNameHelpers.#StrongNameFreeBuffer(System.IntPtr)", Justification="we don't own this code")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="Assemblyfolders", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", Justification="it is correctly spelled")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Vbc", Scope="type", Target="Microsoft.Build.Tasks.Hosting.IVbcHostObject3", Justification="it is correctly spelled")]
[module: SuppressMessage("Microsoft.Usage","CA1801:ReviewUnusedParameters", MessageId="getRuntimeVersion", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.#SetTargetedRuntimeVersion(Microsoft.Build.Tasks.GetAssemblyRuntimeVersion)", Justification="used by tests")]
[module: SuppressMessage("Microsoft.Maintainability","CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.#Execute(Microsoft.Build.Shared.FileExists,Microsoft.Build.Shared.DirectoryExists,Microsoft.Build.Tasks.GetDirectories,Microsoft.Build.Tasks.GetAssemblyName,Microsoft.Build.Tasks.GetAssemblyMetadata,Microsoft.Build.Tasks.GetRegistrySubKeyNames,Microsoft.Build.Tasks.GetRegistrySubKeyDefaultValue,Microsoft.Build.Tasks.GetLastWriteTime,Microsoft.Build.Tasks.GetAssemblyRuntimeVersion)", Justification="Not going to rewrite it now")]
[module: SuppressMessage("Microsoft.Maintainability","CA1506:AvoidExcessiveClassCoupling", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.#Execute(Microsoft.Build.Shared.FileExists,Microsoft.Build.Shared.DirectoryExists,Microsoft.Build.Tasks.GetDirectories,Microsoft.Build.Tasks.GetAssemblyName,Microsoft.Build.Tasks.GetAssemblyMetadata,Microsoft.Build.Tasks.GetRegistrySubKeyNames,Microsoft.Build.Tasks.GetRegistrySubKeyDefaultValue,Microsoft.Build.Tasks.GetLastWriteTime,Microsoft.Build.Tasks.GetAssemblyRuntimeVersion)", Justification="Not going to rewrite it now")]
[module: SuppressMessage("Microsoft.Maintainability","CA1500:VariableNamesShouldNotMatchFieldNames", MessageId="getAssemblyRuntimeVersion", Scope="member", Target="Microsoft.Build.Tasks.SystemState.#CacheDelegate(Microsoft.Build.Tasks.GetAssemblyRuntimeVersion)", Justification="clearer")]
[module: SuppressMessage("Microsoft.Globalization","CA1309:UseOrdinalStringComparison", MessageId="System.Collections.SortedList.#ctor(System.Collections.IComparer,System.Int32)", Scope="member", Target="Microsoft.Build.Tasks.StronglyTypedResourceBuilder.#VerifyResourceNames(System.Collections.Generic.Dictionary`2<System.String,Microsoft.Build.Tasks.StronglyTypedResourceBuilder+ResourceData>,System.CodeDom.Compiler.CodeDomProvider,System.Collections.ArrayList,System.Collections.Hashtable&)", Justification="Inherited code don't want to change it")]
[module: SuppressMessage("Microsoft.Globalization","CA1309:UseOrdinalStringComparison", MessageId="System.Collections.Hashtable.#ctor(System.Int32,System.Collections.IEqualityComparer)", Scope="member", Target="Microsoft.Build.Tasks.StronglyTypedResourceBuilder.#VerifyResourceNames(System.Collections.Generic.Dictionary`2<System.String,Microsoft.Build.Tasks.StronglyTypedResourceBuilder+ResourceData>,System.CodeDom.Compiler.CodeDomProvider,System.Collections.ArrayList,System.Collections.Hashtable&)", Justification="Inherited code don't want to change it")]
[module: SuppressMessage("Microsoft.Maintainability","CA1506:AvoidExcessiveClassCoupling", Scope="member", Target="Microsoft.Build.Tasks.StronglyTypedResourceBuilder.#InternalCreate(System.Collections.Generic.Dictionary`2<System.String,Microsoft.Build.Tasks.StronglyTypedResourceBuilder+ResourceData>,System.String,System.String,System.String,System.CodeDom.Compiler.CodeDomProvider,System.Boolean,System.String[]&)", Justification="Inherited code don't want to change it")]
[module: SuppressMessage("Microsoft.Usage","CA1801:ReviewUnusedParameters", MessageId="supportsTryCatch", Scope="member", Target="Microsoft.Build.Tasks.StronglyTypedResourceBuilder.#EmitBasicClassMembers(System.CodeDom.CodeTypeDeclaration,System.String,System.String,System.String,System.Boolean,System.Boolean,System.Boolean)", Justification="Inherited code don't want to change it")]
[module: SuppressMessage("Microsoft.Maintainability","CA1506:AvoidExcessiveClassCoupling", Scope="member", Target="Microsoft.Build.Tasks.StronglyTypedResourceBuilder.#EmitBasicClassMembers(System.CodeDom.CodeTypeDeclaration,System.String,System.String,System.String,System.Boolean,System.Boolean,System.Boolean)", Justification="Inherited code don't want to change it")]
[module: SuppressMessage("Microsoft.Globalization","CA1309:UseOrdinalStringComparison", MessageId="System.Collections.Generic.Dictionary`2<System.String,Microsoft.Build.Tasks.StronglyTypedResourceBuilder+ResourceData>.#ctor(System.Collections.Generic.IEqualityComparer`1<System.String>)", Scope="member", Target="Microsoft.Build.Tasks.StronglyTypedResourceBuilder.#Create(System.String,System.String,System.String,System.String,System.CodeDom.Compiler.CodeDomProvider,System.Boolean,System.String[]&)", Justification="Inherited code don't want to change it")]
[module: SuppressMessage("Microsoft.Globalization","CA1309:UseOrdinalStringComparison", MessageId="System.Collections.Generic.Dictionary`2<System.String,Microsoft.Build.Tasks.StronglyTypedResourceBuilder+ResourceData>.#ctor(System.Collections.Generic.IEqualityComparer`1<System.String>)", Scope="member", Target="Microsoft.Build.Tasks.StronglyTypedResourceBuilder.#Create(System.Collections.IDictionary,System.String,System.String,System.String,System.CodeDom.Compiler.CodeDomProvider,System.Boolean,System.String[]&)", Justification="Inherited code don't want to change it")]
[module: SuppressMessage("Microsoft.Performance","CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.SRDescriptionAttribute.#.ctor(System.String)", Justification="Inherited code don't want to change it")]
[module: SuppressMessage("Microsoft.Performance","CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Tasks.SR.#.cctor()", Justification="Inherited code don't want to change it")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="resx", Scope="resource", Target="System.Design.resources", Justification="This is correct")]

[module: SuppressMessage("Microsoft.Design","CA1056:UriPropertiesShouldNotBeStrings", Scope="member", Target="Microsoft.Build.Tasks.RequiresFramework35SP1Assembly.#ErrorReportUrl")]
[module: SuppressMessage("Microsoft.Performance","CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Build.Utilities.CanonicalError+Parts.#.ctor()", Justification="clearer this way")]
[module: SuppressMessage("Microsoft.Performance","CA1805:DoNotInitializeUnnecessarily", Scope="member", Target="Microsoft.Runtime.Hosting.StrongNameHelpers.#.cctor()", Justification="we don't own this code")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="Microsoft.Runtime.Hosting.IClrStrongNameUsingIntPtr.StrongNameFreeBuffer(System.IntPtr)", Scope="member", Target="Microsoft.Runtime.Hosting.StrongNameHelpers.#StrongNameFreeBuffer(System.IntPtr)", Justification="we don't own this code")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="Assemblyfolders", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", Justification="it is correctly spelled")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Vbc", Scope="type", Target="Microsoft.Build.Tasks.Hosting.IVbcHostObject3", Justification="it is correctly spelled")]
[module: SuppressMessage("Microsoft.Usage","CA1801:ReviewUnusedParameters", MessageId="getRuntimeVersion", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.#SetTargetedRuntimeVersion(Microsoft.Build.Tasks.GetAssemblyRuntimeVersion)", Justification="used by tests")]
[module: SuppressMessage("Microsoft.Maintainability","CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.#Execute(Microsoft.Build.Shared.FileExists,Microsoft.Build.Shared.DirectoryExists,Microsoft.Build.Tasks.GetDirectories,Microsoft.Build.Tasks.GetAssemblyName,Microsoft.Build.Tasks.GetAssemblyMetadata,Microsoft.Build.Tasks.GetRegistrySubKeyNames,Microsoft.Build.Tasks.GetRegistrySubKeyDefaultValue,Microsoft.Build.Tasks.GetLastWriteTime,Microsoft.Build.Tasks.GetAssemblyRuntimeVersion)", Justification="Not going to rewrite it now")]
[module: SuppressMessage("Microsoft.Maintainability","CA1506:AvoidExcessiveClassCoupling", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.#Execute(Microsoft.Build.Shared.FileExists,Microsoft.Build.Shared.DirectoryExists,Microsoft.Build.Tasks.GetDirectories,Microsoft.Build.Tasks.GetAssemblyName,Microsoft.Build.Tasks.GetAssemblyMetadata,Microsoft.Build.Tasks.GetRegistrySubKeyNames,Microsoft.Build.Tasks.GetRegistrySubKeyDefaultValue,Microsoft.Build.Tasks.GetLastWriteTime,Microsoft.Build.Tasks.GetAssemblyRuntimeVersion)", Justification="Not going to rewrite it now")]
[module: SuppressMessage("Microsoft.Maintainability","CA1500:VariableNamesShouldNotMatchFieldNames", MessageId="getAssemblyRuntimeVersion", Scope="member", Target="Microsoft.Build.Tasks.SystemState.#CacheDelegate(Microsoft.Build.Tasks.GetAssemblyRuntimeVersion)", Justification="clearer")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="sn", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", Justification="sn.exe is the name of a program")]

[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#NormalizePath(System.String,System.String)", Justification="This is a shared class that this assembly doesn't use all the methods in.")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="foo", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", Justification="Used as an example")]
[module: SuppressMessage("Microsoft.Globalization","CA2101:SpecifyMarshalingForPInvokeStringArguments", MessageId="1", Scope="member", Target="System.Deployment.Internal.CodeSigning.Win32.#CertTimestampAuthenticodeLicense(System.Deployment.Internal.CodeSigning.Win32+CRYPT_DATA_BLOB&,System.String,System.Deployment.Internal.CodeSigning.Win32+CRYPT_DATA_BLOB&)", Justification="Not code owned by us")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="System.Deployment.Internal.CodeSigning.Win32.CertFreeAuthenticodeTimestamperInfo(System.Deployment.Internal.CodeSigning.Win32+AXL_TIMESTAMPER_INFO@)", Scope="member", Target="System.Deployment.Internal.CodeSigning.SignedCmiManifest.#VerifyLicense(System.Deployment.Internal.CodeSigning.CmiManifestVerifyFlags,System.Boolean)", Justification="Not code owned by us")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="System.Deployment.Internal.CodeSigning.Win32.CertFreeAuthenticodeSignerInfo(System.Deployment.Internal.CodeSigning.Win32+AXL_SIGNER_INFO@)", Scope="member", Target="System.Deployment.Internal.CodeSigning.SignedCmiManifest.#VerifyLicense(System.Deployment.Internal.CodeSigning.CmiManifestVerifyFlags,System.Boolean)", Justification="Not code owned by us")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Deployment.Internal.CodeSigning.ManifestSignedXml.#FindIdElement(System.Xml.XmlElement,System.String)", Justification="Not code owned by us")]
[module: SuppressMessage("Microsoft.Usage","CA2208:InstantiateArgumentExceptionsCorrectly", Scope="member", Target="System.Deployment.Internal.CodeSigning.CmiManifestSigner.#set_IncludeOption(System.Security.Cryptography.X509Certificates.X509IncludeOption)", Justification="Not code owned by us")]
[module: SuppressMessage("Microsoft.Usage","CA2208:InstantiateArgumentExceptionsCorrectly", Scope="member", Target="System.Deployment.Internal.CodeSigning.CmiManifestSigner.#set_Flag(System.Deployment.Internal.CodeSigning.CmiManifestSignerFlag)", Justification="Not code owned by us")]
[module: SuppressMessage("Microsoft.Globalization","CA1309:UseOrdinalStringComparison", MessageId="System.String.Compare(System.String,System.String,System.StringComparison)", Scope="member", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.BootstrapperBuilder.#BuildPackages(Microsoft.Build.Tasks.Deployment.Bootstrapper.BuildSettings,System.Xml.XmlElement,Microsoft.Build.Tasks.Deployment.Bootstrapper.ResourceUpdater,System.Collections.ArrayList,System.Collections.Hashtable)", Justification="vbcodev will look at these later")]
[module: SuppressMessage("Microsoft.Globalization","CA1305:SpecifyIFormatProvider", MessageId="System.String.Format(System.String,System.Object,System.Object)", Scope="member", Target="Microsoft.Build.Tasks.Deployment.Bootstrapper.ResourceUpdater.#UpdateResources(System.String,Microsoft.Build.Tasks.Deployment.Bootstrapper.BuildResults)", Justification="vbcodev will look at these later")]
[module: SuppressMessage("Microsoft.Globalization","CA1305:SpecifyIFormatProvider", MessageId="System.Int32.ToString(System.IFormatProvider)", Scope="member", Target="Microsoft.Build.Tasks.Deployment.ManifestUtilities.ApplicationManifest.#ValidateFileAssociations()", Justification="vbcodev will look at these later")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="System.Boolean.TryParse(System.String,System.Boolean@)", Scope="member", Target="Microsoft.Build.Tasks.GenerateManifestBase.#IsEmbedInteropEnabledForAssembly(Microsoft.Build.Framework.ITaskItem)", Justification="vbcodev will look at these later")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Csc", Scope="type", Target="Microsoft.Build.Tasks.Hosting.ICscHostObject3", Justification="csc is the name of the tool and spelled correctly")]

[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDK", Scope="member", Target="Microsoft.Build.Tasks.GetSDKReferenceFiles.#ResolvedSDKReferences", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDK", Scope="type", Target="Microsoft.Build.Tasks.GetSDKReferenceFiles", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDK", Scope="member", Target="Microsoft.Build.Tasks.GetInstalledSDKLocations.#SDKRegistryRoot", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDK", Scope="member", Target="Microsoft.Build.Tasks.GetInstalledSDKLocations.#SDKDirectoryRoot", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDKs", Scope="member", Target="Microsoft.Build.Tasks.GetInstalledSDKLocations.#InstalledSDKs", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDK", Scope="type", Target="Microsoft.Build.Tasks.GetInstalledSDKLocations", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDK", Scope="member", Target="Microsoft.Build.Tasks.ResolveAssemblyReference.#ResolvedSDKReferences", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDK", Scope="type", Target="Microsoft.Build.Tasks.ResolveSDKReference", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDKs", Scope="member", Target="Microsoft.Build.Tasks.ResolveSDKReference.#InstalledSDKs", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDK", Scope="member", Target="Microsoft.Build.Tasks.ResolveSDKReference.#ResolvedSDKReferences", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDK", Scope="member", Target="Microsoft.Build.Tasks.ResolveSDKReference.#SDKReferences", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDK", Scope="member", Target="Microsoft.Build.Tasks.ResolveSDKReference.#TargetedSDKArchitecture", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="SDK", Scope="member", Target="Microsoft.Build.Tasks.ResolveSDKReference.#TargetedSDKConfiguration", Justification="SDK is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="PDB", Scope="member", Target="Microsoft.Build.Tasks.WinMDExp.#InputPDBFile", Justification="PDB is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="PDB", Scope="member", Target="Microsoft.Build.Tasks.WinMDExp.#OutputPDBFile", Justification="PDB is the proper casing for this")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="System.Boolean.TryParse(System.String,System.Boolean@)", Scope="member", Target="Microsoft.Build.Tasks.GetSDKReferenceFiles+ResolvedReferenceAssembly.#.ctor(Microsoft.Build.Framework.ITaskItem,System.String)", Justification="copyLocal is false by default")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="VB", Scope="member", Target="Microsoft.Build.Tasks.Hosting.IVbcHostObject4.#SetVBRuntime(System.String)", Justification="VB is the proper casing for this")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Vbc", Scope="type", Target="Microsoft.Build.Tasks.Hosting.IVbcHostObject4", Justification="Vbc spelling is correct for this")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Vbc", Scope="type", Target="Microsoft.Build.Tasks.Hosting.IVbcHostObject5", Justification="Vbc spelling is correct for this")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Vbc", Scope="type", Target="Microsoft.Build.Tasks.Hosting.IVbcHostObjectFreeThreaded", Justification="Vbc spelling is correct for this")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="appx", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", Justification="APPX spelling is correct")]
[module: SuppressMessage("Microsoft.Usage","CA2227:CollectionPropertiesShouldBeReadOnly", Scope="member", Target="Microsoft.Build.Tasks.Xaml.CommandLineToolSwitch.#Arguments", Justification="It is ok for users to set the ICollection.")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="fwlink", Scope="resource", Target="Microsoft.Build.Tasks.Strings.resources", Justification="fwlink is part of a valid domain")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Csc", Scope="type", Target="Microsoft.Build.Tasks.Hosting.ICscHostObject4", Justification="Not worh breaking customers")]
#endif


