// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.
using System;

/// <summary>
/// MaxGeneration
/// </summary>
public class GCMaxGeneration
{
    #region Public Methods
    public bool RunTests()
    {
        bool retVal = true;

        TestLibrary.TestFramework.LogInformation("[Positive]");
        retVal = PosTest1() && retVal;

        return retVal;
    }

    #region Positive Test Cases
    public bool PosTest1()
    {
        bool retVal = true;

        TestLibrary.TestFramework.BeginScenario("PosTest1: Call MaxGeneration to get the max generation the system current supports");

        try
        {
            int gen = GC.MaxGeneration;

            if (gen == 0)
            {
                TestLibrary.TestFramework.LogError("001.1", "Call MaxGeneration to get the max generation the system current supports returns 0");
                TestLibrary.TestFramework.LogInformation("WARNING [LOCAL VARIABLE] gen = " + gen);
                retVal = false;
            }
        }
        catch (Exception e)
        {
            TestLibrary.TestFramework.LogError("001.0", "Unexpected exception: " + e);
            TestLibrary.TestFramework.LogInformation(e.StackTrace);
            retVal = false;
        }

        return retVal;
    }
    #endregion
    #endregion

    public static int Main()
    {
        GCMaxGeneration test = new GCMaxGeneration();

        TestLibrary.TestFramework.BeginTestCase("GCMaxGeneration");

        if (test.RunTests())
        {
            TestLibrary.TestFramework.EndTestCase();
            TestLibrary.TestFramework.LogInformation("PASS");
            return 100;
        }
        else
        {
            TestLibrary.TestFramework.EndTestCase();
            TestLibrary.TestFramework.LogInformation("FAIL");
            return 0;
        }
    }
}
