﻿namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.InheritBaseModel("2b131234-7959-458d-834f-2dc0769ce683")]
	[Microsoft.VisualStudio.Modeling.InheritBaseModel("be20b98c-bf95-4e41-96a9-f8f38b7e0c35")]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.MetaModelGuidString, "DesignerDefinitionObjectModel")]
	public  partial class DesignerDefinitionObjectModel : Microsoft.VisualStudio.Modeling.SubStore
	{
		#region DesignerDefinitionObjectModel's Generated MetaClass Code
		/// <summary>
		/// MetaModel Guid String
		/// </summary>
		public const System.String MetaModelGuidString = "d6d72f16-7925-493b-b393-5b60c29c589d";
		/// <summary>
		/// MetaModel Guid
		/// </summary>
		public static readonly System.Guid MetaModelGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.MetaModelGuidString);
		/// <summary>
		/// Default Constructor called by the IMS -- do not call directly
		/// </summary>
		public DesignerDefinitionObjectModel() : base()
		{
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public DesignerDefinitionObjectModel(Microsoft.VisualStudio.Modeling.Store store) : base(store.DefaultPartition, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.MetaModelGuid)
		{
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public DesignerDefinitionObjectModel(Microsoft.VisualStudio.Modeling.Partition partition) : base(partition, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.MetaModelGuid)
		{
		}
		#endregion

	}
	#region DesignerDefinitionObjectModel's ResourceManager Code
	public  partial class DesignerDefinitionObjectModel
	{
		private static System.Resources.ResourceManager resourceManager = null;
		/// <summary>
		/// The base name of this models resources.
		/// </summary>
		public const string ResourceBaseName = "Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel";
		/// <summary>
		/// Returns the SubStore's ResourceManager. If the ResourceManager does not already exist, then it is created.
		/// </summary>
		public override System.Resources.ResourceManager ResourceManager
		{
			get
			{
				return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.SingletonResourceManager;
			}
		}
		/// <summary>
		/// A internal object used for synchronization.
		/// </summary>
		private static object internalSyncObject;
		/// <summary>
		/// Gets the internal object used for synchronization.
		/// </summary>
		private static object InternalSyncObject 
		{
			get 
			{
				if (internalSyncObject == null) 
				{
					object o = new object();
					System.Threading.Interlocked.CompareExchange(ref internalSyncObject, o, null);
				}
				return internalSyncObject;
			}
		}
		/// <summary>
		/// Gets the Singleton ResourceManager for this SubStore
		/// </summary>
		public static System.Resources.ResourceManager SingletonResourceManager
		{
			get
			{
				if (Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.resourceManager == null)
				{
					lock (Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.InternalSyncObject)
					{
						if (Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.resourceManager == null)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.resourceManager = new System.Resources.ResourceManager(ResourceBaseName, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel).Assembly);
						}
					}
				}
				return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.resourceManager;
			}
		}
	}
	#endregion
	/// <summary>
	/// Copy closure visitor filter
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	public sealed class ExampleACopyClosure : Microsoft.VisualStudio.Modeling.IElementVisitorFilter
	{
		/// <summary>
		/// MetaRoles
		/// </summary>
		private System.Collections.Generic.Dictionary<System.Guid, System.Guid> metaRolesMember;
		/// <summary>
		/// Constructor
		/// </summary>
		public ExampleACopyClosure()
		{
			#region Initialize MetaData Table
			#endregion
		}
		/// <summary>
		/// Called to ask the filter if a particular relationship from a source element should be included in the traversal
		/// </summary>
		/// <param name="walker">ElementWalker traversing the model</param>
		/// <param name="sourceElement">Model Element playing the source role</param>
		/// <param name="sourceRoleInfo">MetaRoleInfo of the role that the source element is playing in the relationship</param>
		/// <param name="metaRelationshipInfo">MetaRelationshipInfo for the ElementLink in question</param>
		/// <param name="targetRelationship">Relationship in question</param>
		/// <returns>Yes if the relationship should be traversed</returns>
		public  Microsoft.VisualStudio.Modeling.VisitorFilterResult ShouldVisitRelationship(Microsoft.VisualStudio.Modeling.ElementWalker walker, Microsoft.VisualStudio.Modeling.ModelElement sourceElement, Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleInfo, Microsoft.VisualStudio.Modeling.MetaRelationshipInfo metaRelationshipInfo, Microsoft.VisualStudio.Modeling.ElementLink targetRelationship)
		{
			return this.MetaRoles.ContainsKey(sourceRoleInfo.Id) ? Microsoft.VisualStudio.Modeling.VisitorFilterResult.Yes : Microsoft.VisualStudio.Modeling.VisitorFilterResult.DoNotCare;
		}
		/// <summary>
		/// Called to ask the filter if a particular role player should be Visited during traversal
		/// </summary>
		/// <param name="walker">ElementWalker traversing the model</param>
		/// <param name="sourceElement">Model Element playing the source role</param>
		/// <param name="elementLink">Element Link that forms the relationship to the role player in question</param>
		/// <param name="targetRoleInfo">MetaRoleInfo of the target role</param>
		/// <param name="targetRolePlayer">Model Element that plays the target role in the relationship</param>
		/// <returns></returns>
		public  Microsoft.VisualStudio.Modeling.VisitorFilterResult ShouldVisitRolePlayer(Microsoft.VisualStudio.Modeling.ElementWalker walker, Microsoft.VisualStudio.Modeling.ModelElement sourceElement, Microsoft.VisualStudio.Modeling.ElementLink elementLink, Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleInfo, Microsoft.VisualStudio.Modeling.ModelElement targetRolePlayer)
		{
			foreach (Microsoft.VisualStudio.Modeling.MetaRoleInfo metaRoleInfo in elementLink.MetaRelationship.MetaRoles)
			{
				if (metaRoleInfo != targetRoleInfo && this.MetaRoles.ContainsKey(metaRoleInfo.Id))
				{
					return Microsoft.VisualStudio.Modeling.VisitorFilterResult.Yes;
				}
			}
			return Microsoft.VisualStudio.Modeling.VisitorFilterResult.DoNotCare;
		}
		/// <summary>
		/// MetaRoles
		/// </summary>
		private System.Collections.Generic.Dictionary<System.Guid, System.Guid> MetaRoles
		{
			get
			{
				if (this.metaRolesMember == null)
				{
					this.metaRolesMember = new System.Collections.Generic.Dictionary<System.Guid, System.Guid>();
				}
				return this.metaRolesMember;
			}
		}

	}
	/// <summary>
	/// Remove closure visitor filter
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	public sealed class ExampleARemoveClosure : Microsoft.VisualStudio.Modeling.IElementVisitorFilter
	{
		/// <summary>
		/// MetaRoles
		/// </summary>
		private System.Collections.Generic.Dictionary<System.Guid, System.Guid> metaRolesMember;
		/// <summary>
		/// Constructor
		/// </summary>
		public ExampleARemoveClosure()
		{
			#region Initialize MetaData Table
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.DiagramsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.DiagramsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.ShapesMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.ShapesMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.ConnectorsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.ConnectorsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ItemsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ItemsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.DiagramMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.DiagramMapsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.ShapeMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.ShapeMapsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.TextMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.TextMapsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.RootsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.RootsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.ChildCollectionsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.ChildCollectionsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertySetsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertySetsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.ChildNodesMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.ChildNodesMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.DefaultRenderingsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.DefaultRenderingsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.ConnectorMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.ConnectorMapsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.TextMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.TextMapsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.IconMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.IconMapsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.DecoratorsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.DecoratorsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.IconMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.IconMapsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.RolePropertiesMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.RolePropertiesMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay.StringToDisplayMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay.StringToDisplayMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.DecoratorsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.DecoratorsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral.ChoicesMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral.ChoicesMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty.ValuePropertyMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty.ValuePropertyMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.CompartmentMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.CompartmentMapsMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression.ValueExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression.ValueExpressionMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid);
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid);
			#endregion
		}
		/// <summary>
		/// Called to ask the filter if a particular relationship from a source element should be included in the traversal
		/// </summary>
		/// <param name="walker">ElementWalker that is traversing the model</param>
		/// <param name="sourceElement">Model Element playing the source role</param>
		/// <param name="sourceRoleInfo">MetaRoleInfo of the role that the source element is playing in the relationship</param>
		/// <param name="metaRelationshipInfo">MetaRelationshipInfo for the ElementLink in question</param>
		/// <param name="targetRelationship">Relationship in question</param>
		/// <returns>Yes if the relationship should be traversed</returns>
		public  Microsoft.VisualStudio.Modeling.VisitorFilterResult ShouldVisitRelationship(Microsoft.VisualStudio.Modeling.ElementWalker walker, Microsoft.VisualStudio.Modeling.ModelElement sourceElement, Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleInfo, Microsoft.VisualStudio.Modeling.MetaRelationshipInfo metaRelationshipInfo, Microsoft.VisualStudio.Modeling.ElementLink targetRelationship)
		{
			return Microsoft.VisualStudio.Modeling.VisitorFilterResult.Yes;
		}
		/// <summary>
		/// Called to ask the filter if a particular role player should be Visited during traversal
		/// </summary>
		/// <param name="walker">ElementWalker that is traversing the model</param>
		/// <param name="sourceElement">Model Element playing the source role</param>
		/// <param name="elementLink">Element Link that forms the relationship to the role player in question</param>
		/// <param name="targetRoleInfo">MetaRoleInfo of the target role</param>
		/// <param name="targetRolePlayer">Model Element that plays the target role in the relationship</param>
		/// <returns></returns>
		public  Microsoft.VisualStudio.Modeling.VisitorFilterResult ShouldVisitRolePlayer(Microsoft.VisualStudio.Modeling.ElementWalker walker, Microsoft.VisualStudio.Modeling.ModelElement sourceElement, Microsoft.VisualStudio.Modeling.ElementLink elementLink, Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleInfo, Microsoft.VisualStudio.Modeling.ModelElement targetRolePlayer)
		{
			return this.MetaRoles.ContainsKey(targetRoleInfo.Id) ? Microsoft.VisualStudio.Modeling.VisitorFilterResult.Yes : Microsoft.VisualStudio.Modeling.VisitorFilterResult.DoNotCare;
		}
		/// <summary>
		/// MetaRoles
		/// </summary>
		private System.Collections.Generic.Dictionary<System.Guid, System.Guid> MetaRoles
		{
			get
			{
				if (this.metaRolesMember == null)
				{
					this.metaRolesMember = new System.Collections.Generic.Dictionary<System.Guid, System.Guid>();
				}
				return this.metaRolesMember;
			}
		}

	}
	#region DesignerDefinitionObjectModel's Generated Closure Code
	public  partial class DesignerDefinitionObjectModel
	{
		/// <summary>
		/// CopyClosure cache
		/// </summary>
		private static Microsoft.VisualStudio.Modeling.IElementVisitorFilter copyClosureMember;
		/// <summary>
		/// RemoveClosure cache
		/// </summary>
		private static Microsoft.VisualStudio.Modeling.IElementVisitorFilter removeClosureMember;
		/// <summary>
		/// Returns an IElementVisitorFilter that corresponds to the ClosureType.
		/// </summary>
		/// <param name="type">closure type</param>
		/// <param name="rootElements">collection of root elements</param>
		/// <returns>IElementVisitorFilter or null</returns>
		public override Microsoft.VisualStudio.Modeling.IElementVisitorFilter GetClosureFilter(Microsoft.VisualStudio.Modeling.ClosureType type, System.Collections.ICollection rootElements)
		{
			switch (type)
			{
				case Microsoft.VisualStudio.Modeling.ClosureType.CopyClosure:
					return DesignerDefinitionObjectModel.CopyClosure;
				case Microsoft.VisualStudio.Modeling.ClosureType.RemoveClosure:
					return DesignerDefinitionObjectModel.RemoveClosure;
			}
			return base.GetClosureFilter(type, rootElements);
		}
		/// <summary>
		/// CopyClosure cache
		/// </summary>
		private static Microsoft.VisualStudio.Modeling.IElementVisitorFilter CopyClosure
		{
			get
			{
				if (DesignerDefinitionObjectModel.copyClosureMember == null)
				{
					DesignerDefinitionObjectModel.copyClosureMember = new ExampleACopyClosure();
				}
				return DesignerDefinitionObjectModel.copyClosureMember;
			}
		}
		/// <summary>
		/// RemoveClosure cache
		/// </summary>
		private static Microsoft.VisualStudio.Modeling.IElementVisitorFilter RemoveClosure
		{
			get
			{
				if (DesignerDefinitionObjectModel.removeClosureMember == null)
				{
					DesignerDefinitionObjectModel.removeClosureMember = new ExampleARemoveClosure();
				}
				return DesignerDefinitionObjectModel.removeClosureMember;
			}
		}
	}
	#endregion
	/// <summary>
	/// 
	/// </summary>
	public  partial class DesignerDefinitionObjectModel : Microsoft.VisualStudio.Modeling.SubStore
	{
		#region DesignerDefinitionObjectModel's AllGeneratedMetaModelTypes Code
		/// <summary>
		/// Virtual method that returns a collection of all types for metamodel 
		/// </summary>
		protected sealed override System.Type[] AllGeneratedMetaModelTypes()
		{
			System.Type[] typeArray = new System.Type[]
			{
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItemElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNodeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNodeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetailsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetailsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapse),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapseElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetailsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRenderingElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRenderingElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShapeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShapeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShapeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartmentElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathValueExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathValueExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathMelCollectionExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathMelCollectionExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleProperty),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.BooleanExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationBooleanExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationBooleanExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotationElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorerElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindowElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehaviorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapesElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectorsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolboxElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItemsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMapsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagramElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModelElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMapsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMapsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecoratorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShapeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRootsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClassElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollectionsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortPropertyElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSetElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClassElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptionsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplay),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplayElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroupsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroupsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroupsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRenderingElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRenderingElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodesElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRenderingElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartmentsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMapsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMapsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClassElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnectorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMapsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecoratorsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShapeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartmentElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnectorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecoratorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMapsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMapElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTargetElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShapeElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEndElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValueProperty),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValuePropertyElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRole),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRoleElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRolePropertiesElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplayElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClassElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClassElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClassElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModelElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyleElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecoratorsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteralElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIconElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValuePropertyElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMapsElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartment),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartmentElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpressionElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColorElementFactoryCreator),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation),
				typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationElementFactoryCreator),

			};
			return typeArray;
		}
		#endregion
	}
	/// <summary>
	/// 
	/// </summary>
	public  partial class DesignerDefinitionObjectModel : Microsoft.VisualStudio.Modeling.SubStore
	{
		#region DesignerDefinitionObjectModel's GeneratedReflectedMetaAttributes Code
		/// <summary>
		/// Virtual method that returns a collection of all fields for all types in metamodel DesignerDefinitionObjectModel
		/// </summary>
		protected sealed override Microsoft.VisualStudio.Modeling.MetaFieldInfo[] GeneratedReflectedMetaAttributes()
		{
			Microsoft.VisualStudio.Modeling.MetaFieldInfo[] typeArray = new Microsoft.VisualStudio.Modeling.MetaFieldInfo[]
			{
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "Namespace", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.NamespaceMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionNamespaceFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "DslName", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DslNameMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionDslNameFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "CompanyName", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.CompanyNameMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionCompanyNameFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "ProductName", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductNameMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionProductNameFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "PackageName", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.PackageNameMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionPackageNameFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "FileExtension", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.FileExtensionMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionFileExtensionFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "ProductVersion", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductVersionMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionProductVersionFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram), "MayUseAsRoot", Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MayUseAsRootMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.DiagramMayUseAsRootFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem), "CaptionId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.CaptionIdMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ToolboxItemCaptionIdFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem), "IconId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.IconIdMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ToolboxItemIconIdFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem), "Order", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.OrderMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ToolboxItemOrderFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem), "ContextSensitiveHelpId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ContextSensitiveHelpIdMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ToolboxItemContextSensitiveHelpIdFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode), "StructureAsXmlFromHere", Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.StructureAsXmlFromHereMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.ExplorerNodeStructureAsXmlFromHereFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode), "UseDefaultRendering", Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.UseDefaultRenderingMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.ElementNodeUseDefaultRenderingFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode), "SortOrder", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.SortOrderMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.CollectionNodeSortOrderFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode), "RenderCollectionNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.RenderCollectionNodeMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.CollectionNodeRenderCollectionNodeFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails), "Variability", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.VariabilityMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.DiagramElementDetailsVariabilityFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails), "Color", Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.ColorMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.ColorDetailsColorFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator), "Position", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.PositionMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.ShapeDecoratorPositionFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText), "DefaultTextId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.DefaultTextIdMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.ShapeTextDefaultTextIdFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon), "IconId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.IconIdMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.ShapeIconIconIdFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator), "Position", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.PositionMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.ConnectorDecoratorPositionFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText), "DefaultTextId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.DefaultTextIdMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.ConnectorTextDefaultTextIdFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon), "IconId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.IconIdMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.ConnectorIconIconIdFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails), "DashStyle", Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.DashStyleMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.DashStyleDetailsDashStyleFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering), "IconId", Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.IconIdMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.NodeRenderingIconIdFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering), "AppendClassNameToCaption", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.AppendClassNameToCaptionMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.ClassNodeRenderingAppendClassNameToCaptionFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering), "CaptionId", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.CaptionIdMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.CollectionNodeRenderingCaptionIdFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape), "InitialWidth", Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialWidthMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.OutlinedShapeInitialWidthFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape), "InitialHeight", Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialHeightMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.OutlinedShapeInitialHeightFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape), "Geometry", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.GeometryMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.CompartmentShapeGeometryFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape), "IsSingleCompartmentHeaderVisible", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.IsSingleCompartmentHeaderVisibleMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape), "Geometry", Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.GeometryMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.GeometryShapeGeometryFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape), "Path", Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.PathMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.PathShapePathFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape), "ImageId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.ImageIdMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.ImageShapeImageIdFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment), "CaptionId", Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.CaptionIdMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.CompartmentCaptionIdFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd), "ArrowStyle", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.ArrowStyleMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.ConnectorEndArrowStyleFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel), "FileName", Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.FileNameMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.ObjectModelFileNameFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathValueExpression), "ModelXPath", Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathValueExpression.ModelXPathMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathValueExpression.XPathValueExpressionModelXPathFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathMelCollectionExpression), "ModelXPath", Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathMelCollectionExpression.ModelXPathMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathMelCollectionExpression.XPathMelCollectionExpressionModelXPathFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleProperty), "ReadWriteState", Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleProperty.ReadWriteStateMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleProperty.RolePropertyReadWriteStateFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation), "Open", Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.OpenMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.ValidationOpenFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation), "Save", Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.SaveMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.ValidationSaveFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation), "Menu", Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.MenuMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.ValidationMenuFieldHandler)),
				new Microsoft.VisualStudio.Modeling.MetaFieldInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation), "Custom", Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.CustomMetaAttributeGuid, typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.ValidationCustomFieldHandler)),

			};
			return typeArray;
		}
		#endregion
	}
	/// <summary>
	/// 
	/// </summary>
	public  partial class DesignerDefinitionObjectModel : Microsoft.VisualStudio.Modeling.SubStore
	{
		#region DesignerDefinitionObjectModel's GeneratedReflectedMetaRoleAttributes Code
		/// <summary>
		/// Virtual method that returns a collection of all fields for all types in metamodel DesignerDefinitionObjectModel
		/// </summary>
		protected sealed override Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo[] GeneratedReflectedMetaRoles()
		{
			Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo[] typeArray = new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo[]
			{
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation), "Notation", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.DesignerDefinitionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer), "Explorer", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.DesignerDefinitionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow), "PropertiesWindow", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.DesignerDefinitionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior), "ValidationBehavior", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.DesignerDefinitionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams), "Diagrams", Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.DiagramsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams), "Notation", Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.NotationMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes), "Shapes", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.ShapesMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes), "Diagram", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.DiagramMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors), "Connectors", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.ConnectorsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors), "Diagram", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.DiagramMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox), "Toolbox", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox), "Diagram", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.DiagramMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems), "Items", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ItemsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems), "Toolbox", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ToolboxMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps), "DiagramMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.DiagramMapsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps), "Notation", Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.NotationMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram), "Diagram", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram), "DiagramMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel), "ObjectModels", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel.ObjectModelsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel.DesignerDefinitionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps), "ShapeMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.ShapeMapsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps), "DiagramMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.DiagramMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps), "TextMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.TextMapsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps), "ShapeMapClass", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.ShapeMapClassMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator), "TextDecorator", Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextDecoratorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator), "TextMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor), "FillColor", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor), "Shape", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.ShapeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape), "Shape", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape), "ShapeMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots), "Roots", Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.RootsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots), "Explorer", Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.ExplorerMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass), "ClassNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassNodeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections), "ChildCollections", Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.ChildCollectionsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections), "NodeType", Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.NodeTypeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty), "SortProperty", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.SortPropertyMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty), "CollectionNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.CollectionNodeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet), "PropertySets", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertySetsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet), "PropertiesWindow", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertiesWindowMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.ClassMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass), "PropertiesSet", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.PropertiesSetMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions), "ValuePropertiesToExclude", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions.ValuePropertiesToExcludeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions), "PropertiesSet", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions.PropertiesSetMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplay), "Role", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplay.RoleMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplay), "RoleProperties", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplay.RolePropertiesMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups), "ContextMenuGroups", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups.ContextMenuGroupsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups), "ValidationBehavior", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups.ValidationBehaviorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups), "LoadGroups", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups.LoadGroupsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups), "ValidationBehavior", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups.ValidationBehaviorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups), "SaveGroups", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups.SaveGroupsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups), "ValidationBehavior", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups.ValidationBehaviorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering), "Rendering", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering), "ClassNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.ClassNodeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering), "Rendering", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering), "CollectionNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.CollectionNodeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes), "ChildNodes", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.ChildNodesMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes), "CollectionNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.CollectionNodeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering), "DefaultRenderings", Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.DefaultRenderingsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering), "Explorer", Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.ExplorerMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments), "Compartments", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments), "CompartmentShape", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentShapeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps), "ConnectorMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.ConnectorMapsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps), "DiagramMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.DiagramMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps), "TextMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.TextMapsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.ConnectorMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ClassMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ConnectorMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps), "IconMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.IconMapsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps), "ShapeMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.ShapeMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators), "Decorators", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.DecoratorsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.ConnectorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape), "Shape", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape), "ShapeTool", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeToolMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment), "TextCompartment", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.TextCompartmentMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment), "CompartmentTextTool", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.CompartmentTextToolMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector), "ConnectorTool", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorToolMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor), "OutlineColor", Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor), "OutlinedShape", Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlinedShapeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator), "TextDecorator", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.TextDecoratorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator), "ConnectorTextMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.ConnectorTextMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps), "IconMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.IconMapsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.ConnectorMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap), "SourceMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.ConnectorMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap), "TargetMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.ConnectorMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget), "Target", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.ConnectorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape), "PermittedShapes", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape.PermittedShapesMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape), "ConnectorEnd", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape.ConnectorEndMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd), "Source", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.ConnectorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValueProperty), "ValueProperty", Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValueProperty.ValuePropertyMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValueProperty), "ModelValuePropertyExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValueProperty.ModelValuePropertyExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRole), "Role", Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRole.RoleMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRole), "ModelRoleExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRole.ModelRoleExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression), "MelCollectionExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression), "CollectionNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.CollectionNodeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression), "ModelNavigationExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression), "SourceMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.SourceMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression), "ModelNavigationExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression), "TargetMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.TargetMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression), "ValueExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression), "ShapeTextMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ShapeTextMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties), "RoleProperties", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.RolePropertiesMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties), "PropertySet", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.PropertySetMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay), "StringToDisplay", Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay.StringToDisplayMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay), "RoleProperty", Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay.RolePropertyMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.ClassMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass), "DiagramMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.DiagramMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression), "MelCollectionExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression), "ShapeMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.ShapeMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ClassMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass), "ShapeMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ShapeMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass), "ClassNodeRendering", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassNodeRenderingMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel), "Model", Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel.ModelMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel), "ObjectModel", Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel.ObjectModelMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle), "DashStyle", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.ConnectorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor), "Color", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ConnectorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression), "ValueExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression), "ConnectorTextMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ConnectorTextMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators), "Decorators", Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.DecoratorsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators), "Shape", Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.ShapeMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral), "Choices", Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral.ChoicesMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral), "EnumerationLiteralChoice", Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral.EnumerationLiteralChoiceMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon), "IconDecorator", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon), "IconMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty), "ValueProperty", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty.ValuePropertyMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty), "ValuePropertyBooleanExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty.ValuePropertyBooleanExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression), "VisibilityExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression), "ShapeIconMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.ShapeIconMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps), "CompartmentMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.CompartmentMapsMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps), "ShapeMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.ShapeMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartment), "Compartment", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartment.CompartmentMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartment), "CompartmentMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartment.CompartmentMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression), "MelCollectionExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression), "CompartmentMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression.CompartmentMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression), "ValueExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression.ValueExpressionMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression), "CompartmentMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression.CompartmentMapMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor), "CompartmentFillColor", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor), "Compartment", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor), "TitleFillColor", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor), "Compartment", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.CompartmentMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation), "Validation", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid),
				new Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.DesignerDefinitionMetaRoleGuid),

			};
			return typeArray;
		}
		#endregion
	}
}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.MetaClassGuidString, "DesignerDefinition")]
	public  partial class DesignerDefinition : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region DesignerDefinition's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "2ff5dcec-a1e3-45ce-aae1-dc61407dc27d";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.MetaClassGuidString);
		#endregion

		#region Namespace's Generated  Field Code
		#region Namespace's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String NamespaceMetaAttributeGuidString = "04772add-693d-47ad-b8dd-994a145091b2";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid NamespaceMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.NamespaceMetaAttributeGuidString);
		#endregion

		#region Namespace's Generated Property Code

		private System.String namespacePropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(DesignerDefinitionNamespaceFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.NamespaceMetaAttributeGuidString, "DesignerDefinition.Namespace")]
		public  System.String Namespace
		{
			get
			{
				return namespacePropertyStorage;
			}
		
			set
			{
				designerDefinitionNamespaceFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region DesignerDefinitionNamespaceFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for DesignerDefinition.Namespace field
		/// </summary>
		private static DesignerDefinitionNamespaceFieldHandler	designerDefinitionNamespaceFieldHandler	= DesignerDefinitionNamespaceFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for DesignerDefinition.Namespace
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class DesignerDefinitionNamespaceFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private DesignerDefinitionNamespaceFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the DesignerDefinition.Namespace field handler
			/// </summary>
			/// <value>DesignerDefinitionNamespaceFieldHandler</value>
			public static DesignerDefinitionNamespaceFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionNamespaceFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionNamespaceFieldHandler;
					}
					else
					{
						// The static constructor in DesignerDefinition will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionNamespaceFieldHandler, so just instantiate one and return it
						return new DesignerDefinitionNamespaceFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the DesignerDefinition.Namespace field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.NamespaceMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the DesignerDefinition</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element)
			{
				return element.namespacePropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.namespacePropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.namespacePropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region DslName's Generated  Field Code
		#region DslName's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String DslNameMetaAttributeGuidString = "06fd2c60-d69d-41bd-b609-9febe42ede1e";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid DslNameMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DslNameMetaAttributeGuidString);
		#endregion

		#region DslName's Generated Property Code

		private System.String dslNamePropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(DesignerDefinitionDslNameFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DslNameMetaAttributeGuidString, "DesignerDefinition.DslName")]
		public  System.String DslName
		{
			get
			{
				return dslNamePropertyStorage;
			}
		
			set
			{
				designerDefinitionDslNameFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region DesignerDefinitionDslNameFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for DesignerDefinition.DslName field
		/// </summary>
		private static DesignerDefinitionDslNameFieldHandler	designerDefinitionDslNameFieldHandler	= DesignerDefinitionDslNameFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for DesignerDefinition.DslName
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class DesignerDefinitionDslNameFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private DesignerDefinitionDslNameFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the DesignerDefinition.DslName field handler
			/// </summary>
			/// <value>DesignerDefinitionDslNameFieldHandler</value>
			public static DesignerDefinitionDslNameFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionDslNameFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionDslNameFieldHandler;
					}
					else
					{
						// The static constructor in DesignerDefinition will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionDslNameFieldHandler, so just instantiate one and return it
						return new DesignerDefinitionDslNameFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the DesignerDefinition.DslName field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DslNameMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the DesignerDefinition</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element)
			{
				return element.dslNamePropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.dslNamePropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.dslNamePropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region CompanyName's Generated  Field Code
		#region CompanyName's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String CompanyNameMetaAttributeGuidString = "c40a207c-7f79-4c43-9de6-b6375071a603";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid CompanyNameMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.CompanyNameMetaAttributeGuidString);
		#endregion

		#region CompanyName's Generated Property Code

		private System.String companyNamePropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(DesignerDefinitionCompanyNameFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.CompanyNameMetaAttributeGuidString, "DesignerDefinition.CompanyName")]
		public  System.String CompanyName
		{
			get
			{
				return companyNamePropertyStorage;
			}
		
			set
			{
				designerDefinitionCompanyNameFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region DesignerDefinitionCompanyNameFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for DesignerDefinition.CompanyName field
		/// </summary>
		private static DesignerDefinitionCompanyNameFieldHandler	designerDefinitionCompanyNameFieldHandler	= DesignerDefinitionCompanyNameFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for DesignerDefinition.CompanyName
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class DesignerDefinitionCompanyNameFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private DesignerDefinitionCompanyNameFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the DesignerDefinition.CompanyName field handler
			/// </summary>
			/// <value>DesignerDefinitionCompanyNameFieldHandler</value>
			public static DesignerDefinitionCompanyNameFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionCompanyNameFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionCompanyNameFieldHandler;
					}
					else
					{
						// The static constructor in DesignerDefinition will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionCompanyNameFieldHandler, so just instantiate one and return it
						return new DesignerDefinitionCompanyNameFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the DesignerDefinition.CompanyName field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.CompanyNameMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the DesignerDefinition</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element)
			{
				return element.companyNamePropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.companyNamePropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.companyNamePropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region ProductName's Generated  Field Code
		#region ProductName's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String ProductNameMetaAttributeGuidString = "5154d9e9-9fb4-453f-802f-3f62e38f5461";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid ProductNameMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductNameMetaAttributeGuidString);
		#endregion

		#region ProductName's Generated Property Code

		private System.String productNamePropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(DesignerDefinitionProductNameFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductNameMetaAttributeGuidString, "DesignerDefinition.ProductName")]
		public  System.String ProductName
		{
			get
			{
				return productNamePropertyStorage;
			}
		
			set
			{
				designerDefinitionProductNameFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region DesignerDefinitionProductNameFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for DesignerDefinition.ProductName field
		/// </summary>
		private static DesignerDefinitionProductNameFieldHandler	designerDefinitionProductNameFieldHandler	= DesignerDefinitionProductNameFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for DesignerDefinition.ProductName
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class DesignerDefinitionProductNameFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private DesignerDefinitionProductNameFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the DesignerDefinition.ProductName field handler
			/// </summary>
			/// <value>DesignerDefinitionProductNameFieldHandler</value>
			public static DesignerDefinitionProductNameFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductNameFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductNameFieldHandler;
					}
					else
					{
						// The static constructor in DesignerDefinition will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductNameFieldHandler, so just instantiate one and return it
						return new DesignerDefinitionProductNameFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the DesignerDefinition.ProductName field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductNameMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the DesignerDefinition</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element)
			{
				return element.productNamePropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.productNamePropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.productNamePropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region PackageName's Generated  Field Code
		#region PackageName's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String PackageNameMetaAttributeGuidString = "5b72fb5b-07f6-4573-aa4e-df0b6c39cac2";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid PackageNameMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.PackageNameMetaAttributeGuidString);
		#endregion

		#region PackageName's Generated Property Code

		private System.String packageNamePropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(DesignerDefinitionPackageNameFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.PackageNameMetaAttributeGuidString, "DesignerDefinition.PackageName")]
		public  System.String PackageName
		{
			get
			{
				return packageNamePropertyStorage;
			}
		
			set
			{
				designerDefinitionPackageNameFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region DesignerDefinitionPackageNameFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for DesignerDefinition.PackageName field
		/// </summary>
		private static DesignerDefinitionPackageNameFieldHandler	designerDefinitionPackageNameFieldHandler	= DesignerDefinitionPackageNameFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for DesignerDefinition.PackageName
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class DesignerDefinitionPackageNameFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private DesignerDefinitionPackageNameFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the DesignerDefinition.PackageName field handler
			/// </summary>
			/// <value>DesignerDefinitionPackageNameFieldHandler</value>
			public static DesignerDefinitionPackageNameFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionPackageNameFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionPackageNameFieldHandler;
					}
					else
					{
						// The static constructor in DesignerDefinition will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionPackageNameFieldHandler, so just instantiate one and return it
						return new DesignerDefinitionPackageNameFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the DesignerDefinition.PackageName field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.PackageNameMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the DesignerDefinition</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element)
			{
				return element.packageNamePropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.packageNamePropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.packageNamePropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region FileExtension's Generated  Field Code
		#region FileExtension's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String FileExtensionMetaAttributeGuidString = "18a27c6f-7b87-46ba-916c-8818fcd72aca";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid FileExtensionMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.FileExtensionMetaAttributeGuidString);
		#endregion

		#region FileExtension's Generated Property Code

		private System.String fileExtensionPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(DesignerDefinitionFileExtensionFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.FileExtensionMetaAttributeGuidString, "DesignerDefinition.FileExtension")]
		public  System.String FileExtension
		{
			get
			{
				return fileExtensionPropertyStorage;
			}
		
			set
			{
				designerDefinitionFileExtensionFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region DesignerDefinitionFileExtensionFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for DesignerDefinition.FileExtension field
		/// </summary>
		private static DesignerDefinitionFileExtensionFieldHandler	designerDefinitionFileExtensionFieldHandler	= DesignerDefinitionFileExtensionFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for DesignerDefinition.FileExtension
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class DesignerDefinitionFileExtensionFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private DesignerDefinitionFileExtensionFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the DesignerDefinition.FileExtension field handler
			/// </summary>
			/// <value>DesignerDefinitionFileExtensionFieldHandler</value>
			public static DesignerDefinitionFileExtensionFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionFileExtensionFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionFileExtensionFieldHandler;
					}
					else
					{
						// The static constructor in DesignerDefinition will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionFileExtensionFieldHandler, so just instantiate one and return it
						return new DesignerDefinitionFileExtensionFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the DesignerDefinition.FileExtension field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.FileExtensionMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the DesignerDefinition</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element)
			{
				return element.fileExtensionPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.fileExtensionPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.fileExtensionPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region ProductVersion's Generated  Field Code
		#region ProductVersion's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String ProductVersionMetaAttributeGuidString = "45388f23-d1f3-4c9f-a60a-84ee9dea0cae";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid ProductVersionMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductVersionMetaAttributeGuidString);
		#endregion

		#region ProductVersion's Generated Property Code

		private System.String productVersionPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(DesignerDefinitionProductVersionFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductVersionMetaAttributeGuidString, "DesignerDefinition.ProductVersion")]
		public  System.String ProductVersion
		{
			get
			{
				return productVersionPropertyStorage;
			}
		
			set
			{
				designerDefinitionProductVersionFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region DesignerDefinitionProductVersionFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for DesignerDefinition.ProductVersion field
		/// </summary>
		private static DesignerDefinitionProductVersionFieldHandler	designerDefinitionProductVersionFieldHandler	= DesignerDefinitionProductVersionFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for DesignerDefinition.ProductVersion
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class DesignerDefinitionProductVersionFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private DesignerDefinitionProductVersionFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the DesignerDefinition.ProductVersion field handler
			/// </summary>
			/// <value>DesignerDefinitionProductVersionFieldHandler</value>
			public static DesignerDefinitionProductVersionFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductVersionFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductVersionFieldHandler;
					}
					else
					{
						// The static constructor in DesignerDefinition will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductVersionFieldHandler, so just instantiate one and return it
						return new DesignerDefinitionProductVersionFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the DesignerDefinition.ProductVersion field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductVersionMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the DesignerDefinition</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element)
			{
				return element.productVersionPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.productVersionPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.productVersionPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region Notation's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation Notation
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.DesignerDefinitionMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.DesignerDefinitionMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation), newRoles);
				}
			}
		}
		#endregion
		#region Explorer's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer Explorer
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.DesignerDefinitionMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.DesignerDefinitionMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer), newRoles);
				}
			}
		}
		#endregion
		#region PropertiesWindow's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow PropertiesWindow
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.DesignerDefinitionMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.DesignerDefinitionMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow), newRoles);
				}
			}
		}
		#endregion
		#region ValidationBehavior's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior ValidationBehavior
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.DesignerDefinitionMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.DesignerDefinitionMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior), newRoles);
				}
			}
		}
		#endregion
		#region ObjectModels's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelMoveableCollection ObjectModels
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel.ObjectModelsMetaRoleGuid); }
		}
		#endregion
		#region Validation's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation Validation
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.DesignerDefinitionMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.DesignerDefinitionMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation), newRoles);
				}
			}
		}
		#endregion
	}
	#region DesignerDefinition's Generated Constructor Code
	public  partial class DesignerDefinition
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public DesignerDefinition(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DesignerDefinition CreateDesignerDefinition(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateDesignerDefinition(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DesignerDefinition CreateAndInitializeDesignerDefinition(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeDesignerDefinition(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public DesignerDefinition(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DesignerDefinition CreateDesignerDefinition(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (DesignerDefinition)partition.ElementFactory.CreateElement(typeof(DesignerDefinition));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DesignerDefinition CreateAndInitializeDesignerDefinition(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (DesignerDefinition)partition.ElementFactory.CreateElement(typeof(DesignerDefinition), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for DesignerDefinition
	/// <summary>
	/// DesignerDefinition Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition))]
	public sealed class DesignerDefinitionElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public DesignerDefinitionElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static DesignerDefinitionElementFactoryCreator Instance
		{
			get
			{
				return new DesignerDefinitionElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation.MetaClassGuidString, "Notation")]
	public  partial class Notation : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region Notation's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "eacaf516-4d26-4db4-8d0c-4ca057965032";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation.MetaClassGuidString);
		#endregion

		#region Diagrams's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMoveableCollection Diagrams
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.NotationMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.DiagramsMetaRoleGuid); }
		}
		#endregion
		#region DiagramMaps's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapMoveableCollection DiagramMaps
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.NotationMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.DiagramMapsMetaRoleGuid); }
		}
		#endregion
	}
	#region Notation's Generated Constructor Code
	public  partial class Notation
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public Notation(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Notation CreateNotation(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateNotation(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Notation CreateAndInitializeNotation(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeNotation(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public Notation(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Notation CreateNotation(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (Notation)partition.ElementFactory.CreateElement(typeof(Notation));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Notation CreateAndInitializeNotation(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (Notation)partition.ElementFactory.CreateElement(typeof(Notation), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for Notation
	/// <summary>
	/// Notation Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation))]
	public sealed class NotationElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public NotationElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static NotationElementFactoryCreator Instance
		{
			get
			{
				return new NotationElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer.MetaClassGuidString, "Explorer")]
	public  partial class Explorer : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region Explorer's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "ecb5fb7e-a561-417a-8109-c3db1c951f3b";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer.MetaClassGuidString);
		#endregion

		#region Roots's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNodeMoveableCollection Roots
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNodeMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.ExplorerMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.RootsMetaRoleGuid); }
		}
		#endregion
		#region DefaultRenderings's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingMoveableCollection DefaultRenderings
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.ExplorerMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.DefaultRenderingsMetaRoleGuid); }
		}
		#endregion
	}
	#region Explorer's Generated Constructor Code
	public  partial class Explorer
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public Explorer(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Explorer CreateExplorer(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateExplorer(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Explorer CreateAndInitializeExplorer(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeExplorer(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public Explorer(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Explorer CreateExplorer(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (Explorer)partition.ElementFactory.CreateElement(typeof(Explorer));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Explorer CreateAndInitializeExplorer(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (Explorer)partition.ElementFactory.CreateElement(typeof(Explorer), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for Explorer
	/// <summary>
	/// Explorer Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer))]
	public sealed class ExplorerElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ExplorerElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ExplorerElementFactoryCreator Instance
		{
			get
			{
				return new ExplorerElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow.MetaClassGuidString, "PropertiesWindow")]
	public  partial class PropertiesWindow : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region PropertiesWindow's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "519599a6-b3fa-4f36-8ab0-66bd3f404c02";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow.MetaClassGuidString);
		#endregion

		#region PropertySets's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetMoveableCollection PropertySets
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertiesWindowMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertySetsMetaRoleGuid); }
		}
		#endregion
	}
	#region PropertiesWindow's Generated Constructor Code
	public  partial class PropertiesWindow
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public PropertiesWindow(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PropertiesWindow CreatePropertiesWindow(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreatePropertiesWindow(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PropertiesWindow CreateAndInitializePropertiesWindow(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializePropertiesWindow(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public PropertiesWindow(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PropertiesWindow CreatePropertiesWindow(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (PropertiesWindow)partition.ElementFactory.CreateElement(typeof(PropertiesWindow));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PropertiesWindow CreateAndInitializePropertiesWindow(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (PropertiesWindow)partition.ElementFactory.CreateElement(typeof(PropertiesWindow), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for PropertiesWindow
	/// <summary>
	/// PropertiesWindow Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow))]
	public sealed class PropertiesWindowElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public PropertiesWindowElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static PropertiesWindowElementFactoryCreator Instance
		{
			get
			{
				return new PropertiesWindowElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior.MetaClassGuidString, "ValidationBehavior")]
	public  partial class ValidationBehavior : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ValidationBehavior's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "f3b20760-d336-4d03-9654-9c14bdfc3b70";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior.MetaClassGuidString);
		#endregion

		#region ContextMenuGroups's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection ContextMenuGroups
		{
			get { return new Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups.ValidationBehaviorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups.ContextMenuGroupsMetaRoleGuid); }
		}
		#endregion
		#region LoadGroups's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection LoadGroups
		{
			get { return new Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups.ValidationBehaviorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups.LoadGroupsMetaRoleGuid); }
		}
		#endregion
		#region SaveGroups's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection SaveGroups
		{
			get { return new Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups.ValidationBehaviorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups.SaveGroupsMetaRoleGuid); }
		}
		#endregion
	}
	#region Collection Classes for ValidationBehavior
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ValidationBehaviorMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ValidationBehaviorMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ValidationBehavior's Generated Constructor Code
	public  partial class ValidationBehavior
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ValidationBehavior(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ValidationBehavior CreateValidationBehavior(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateValidationBehavior(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ValidationBehavior CreateAndInitializeValidationBehavior(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeValidationBehavior(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ValidationBehavior(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ValidationBehavior CreateValidationBehavior(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ValidationBehavior)partition.ElementFactory.CreateElement(typeof(ValidationBehavior));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ValidationBehavior CreateAndInitializeValidationBehavior(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ValidationBehavior)partition.ElementFactory.CreateElement(typeof(ValidationBehavior), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ValidationBehavior
	/// <summary>
	/// ValidationBehavior Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior))]
	public sealed class ValidationBehaviorElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ValidationBehaviorElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ValidationBehaviorElementFactoryCreator Instance
		{
			get
			{
				return new ValidationBehaviorElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MetaClassGuidString, "Diagram")]
	public  partial class Diagram : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region Diagram's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "a90d74fc-204f-449c-acb2-d12bf9ad74c6";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MetaClassGuidString);
		#endregion

		#region MayUseAsRoot's Generated  Field Code
		#region MayUseAsRoot's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String MayUseAsRootMetaAttributeGuidString = "755d1580-bbaf-4eb5-956a-4fe535062d1e";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid MayUseAsRootMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MayUseAsRootMetaAttributeGuidString);
		#endregion

		#region MayUseAsRoot's Generated Property Code

		private System.Boolean mayUseAsRootPropertyStorage = false;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean=false)]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(DiagramMayUseAsRootFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MayUseAsRootMetaAttributeGuidString, "Diagram.MayUseAsRoot")]
		public  System.Boolean MayUseAsRoot
		{
			get
			{
				return mayUseAsRootPropertyStorage;
			}
		
			set
			{
				diagramMayUseAsRootFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region DiagramMayUseAsRootFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for Diagram.MayUseAsRoot field
		/// </summary>
		private static DiagramMayUseAsRootFieldHandler	diagramMayUseAsRootFieldHandler	= DiagramMayUseAsRootFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for Diagram.MayUseAsRoot
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class DiagramMayUseAsRootFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram,System.Boolean>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private DiagramMayUseAsRootFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the Diagram.MayUseAsRoot field handler
			/// </summary>
			/// <value>DiagramMayUseAsRootFieldHandler</value>
			public static DiagramMayUseAsRootFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.diagramMayUseAsRootFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.diagramMayUseAsRootFieldHandler;
					}
					else
					{
						// The static constructor in Diagram will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.diagramMayUseAsRootFieldHandler, so just instantiate one and return it
						return new DiagramMayUseAsRootFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the Diagram.MayUseAsRoot field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MayUseAsRootMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the Diagram</param>
			protected sealed override System.Boolean GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram element)
			{
				return element.mayUseAsRootPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram element, System.Boolean value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.Boolean oldValue)
			{
				oldValue = element.mayUseAsRootPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.mayUseAsRootPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region Shapes's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMoveableCollection Shapes
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.DiagramMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.ShapesMetaRoleGuid); }
		}
		#endregion
		#region Connectors's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMoveableCollection Connectors
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.DiagramMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.ConnectorsMetaRoleGuid); }
		}
		#endregion
		#region Toolbox's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox Toolbox
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.DiagramMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.DiagramMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.DiagramMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for Diagram
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class DiagramMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public DiagramMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region Diagram's Generated Constructor Code
	public  partial class Diagram
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public Diagram(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Diagram CreateDiagram(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateDiagram(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Diagram CreateAndInitializeDiagram(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeDiagram(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public Diagram(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Diagram CreateDiagram(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (Diagram)partition.ElementFactory.CreateElement(typeof(Diagram));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Diagram CreateAndInitializeDiagram(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (Diagram)partition.ElementFactory.CreateElement(typeof(Diagram), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for Diagram
	/// <summary>
	/// Diagram Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram))]
	public sealed class DiagramElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public DiagramElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static DiagramElementFactoryCreator Instance
		{
			get
			{
				return new DiagramElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector.MetaClassGuidString, "Connector")]
	public  partial class Connector : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region Connector's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "73315d51-3fc7-4436-aee2-16f6c51fc500";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector.MetaClassGuidString);
		#endregion

		#region Decorators's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorMoveableCollection Decorators
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.ConnectorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.DecoratorsMetaRoleGuid); }
		}
		#endregion
		#region Target's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd Target
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.ConnectorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.ConnectorMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.ConnectorMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget), newRoles);
				}
			}
		}
		#endregion
		#region Source's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd Source
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.ConnectorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.ConnectorMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.ConnectorMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd), newRoles);
				}
			}
		}
		#endregion
		#region DashStyle's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails DashStyle
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.ConnectorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.ConnectorMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.ConnectorMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle), newRoles);
				}
			}
		}
		#endregion
		#region Color's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails Color
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ConnectorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ConnectorMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ConnectorMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for Connector
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ConnectorMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ConnectorMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region Connector's Generated Constructor Code
	public  partial class Connector
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public Connector(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Connector CreateConnector(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateConnector(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Connector CreateAndInitializeConnector(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeConnector(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public Connector(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Connector CreateConnector(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (Connector)partition.ElementFactory.CreateElement(typeof(Connector));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Connector CreateAndInitializeConnector(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (Connector)partition.ElementFactory.CreateElement(typeof(Connector), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for Connector
	/// <summary>
	/// Connector Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector))]
	public sealed class ConnectorElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ConnectorElementFactoryCreator Instance
		{
			get
			{
				return new ConnectorElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox.MetaClassGuidString, "Toolbox")]
	public  partial class Toolbox : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region Toolbox's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "0f088991-551a-4545-969d-aa1f934caad5";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox.MetaClassGuidString);
		#endregion

		#region Items's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItemMoveableCollection Items
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItemMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ToolboxMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ItemsMetaRoleGuid); }
		}
		#endregion
	}
	#region Toolbox's Generated Constructor Code
	public  partial class Toolbox
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public Toolbox(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Toolbox CreateToolbox(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateToolbox(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Toolbox CreateAndInitializeToolbox(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeToolbox(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public Toolbox(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Toolbox CreateToolbox(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (Toolbox)partition.ElementFactory.CreateElement(typeof(Toolbox));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Toolbox CreateAndInitializeToolbox(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (Toolbox)partition.ElementFactory.CreateElement(typeof(Toolbox), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for Toolbox
	/// <summary>
	/// Toolbox Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox))]
	public sealed class ToolboxElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ToolboxElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ToolboxElementFactoryCreator Instance
		{
			get
			{
				return new ToolboxElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.MetaClassGuidString, "ToolboxItem")]
	public  partial class ToolboxItem : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ToolboxItem's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "2bff4b99-9dd8-48f1-b4a2-48e117613499";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.MetaClassGuidString);
		#endregion

		#region CaptionId's Generated  Field Code
		#region CaptionId's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String CaptionIdMetaAttributeGuidString = "c98b44b7-d1b9-44f6-95db-cee348110ee0";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid CaptionIdMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.CaptionIdMetaAttributeGuidString);
		#endregion

		#region CaptionId's Generated Property Code

		private System.String captionIdPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ToolboxItemCaptionIdFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.CaptionIdMetaAttributeGuidString, "ToolboxItem.CaptionId")]
		public  System.String CaptionId
		{
			get
			{
				return captionIdPropertyStorage;
			}
		
			set
			{
				toolboxItemCaptionIdFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ToolboxItemCaptionIdFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ToolboxItem.CaptionId field
		/// </summary>
		private static ToolboxItemCaptionIdFieldHandler	toolboxItemCaptionIdFieldHandler	= ToolboxItemCaptionIdFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ToolboxItem.CaptionId
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ToolboxItemCaptionIdFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ToolboxItemCaptionIdFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ToolboxItem.CaptionId field handler
			/// </summary>
			/// <value>ToolboxItemCaptionIdFieldHandler</value>
			public static ToolboxItemCaptionIdFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemCaptionIdFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemCaptionIdFieldHandler;
					}
					else
					{
						// The static constructor in ToolboxItem will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemCaptionIdFieldHandler, so just instantiate one and return it
						return new ToolboxItemCaptionIdFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ToolboxItem.CaptionId field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.CaptionIdMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ToolboxItem</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem element)
			{
				return element.captionIdPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.captionIdPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.captionIdPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region IconId's Generated  Field Code
		#region IconId's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String IconIdMetaAttributeGuidString = "45b2cedf-deee-403b-8887-a3ee828b86df";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid IconIdMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.IconIdMetaAttributeGuidString);
		#endregion

		#region IconId's Generated Property Code

		private System.String iconIdPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ToolboxItemIconIdFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.IconIdMetaAttributeGuidString, "ToolboxItem.IconId")]
		public  System.String IconId
		{
			get
			{
				return iconIdPropertyStorage;
			}
		
			set
			{
				toolboxItemIconIdFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ToolboxItemIconIdFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ToolboxItem.IconId field
		/// </summary>
		private static ToolboxItemIconIdFieldHandler	toolboxItemIconIdFieldHandler	= ToolboxItemIconIdFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ToolboxItem.IconId
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ToolboxItemIconIdFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ToolboxItemIconIdFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ToolboxItem.IconId field handler
			/// </summary>
			/// <value>ToolboxItemIconIdFieldHandler</value>
			public static ToolboxItemIconIdFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemIconIdFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemIconIdFieldHandler;
					}
					else
					{
						// The static constructor in ToolboxItem will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemIconIdFieldHandler, so just instantiate one and return it
						return new ToolboxItemIconIdFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ToolboxItem.IconId field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.IconIdMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ToolboxItem</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem element)
			{
				return element.iconIdPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.iconIdPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.iconIdPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region Order's Generated  Field Code
		#region Order's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String OrderMetaAttributeGuidString = "cc7f9f59-a4aa-4801-ae85-43b4347fe995";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid OrderMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.OrderMetaAttributeGuidString);
		#endregion

		#region Order's Generated Property Code

		private System.Int32 orderPropertyStorage = 0;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.IntegerDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ToolboxItemOrderFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.OrderMetaAttributeGuidString, "ToolboxItem.Order")]
		public  System.Int32 Order
		{
			get
			{
				return orderPropertyStorage;
			}
		
			set
			{
				toolboxItemOrderFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ToolboxItemOrderFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ToolboxItem.Order field
		/// </summary>
		private static ToolboxItemOrderFieldHandler	toolboxItemOrderFieldHandler	= ToolboxItemOrderFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ToolboxItem.Order
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ToolboxItemOrderFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem,System.Int32>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ToolboxItemOrderFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ToolboxItem.Order field handler
			/// </summary>
			/// <value>ToolboxItemOrderFieldHandler</value>
			public static ToolboxItemOrderFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemOrderFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemOrderFieldHandler;
					}
					else
					{
						// The static constructor in ToolboxItem will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemOrderFieldHandler, so just instantiate one and return it
						return new ToolboxItemOrderFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ToolboxItem.Order field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.OrderMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ToolboxItem</param>
			protected sealed override System.Int32 GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem element)
			{
				return element.orderPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem element, System.Int32 value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.Int32 oldValue)
			{
				oldValue = element.orderPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.orderPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region ContextSensitiveHelpId's Generated  Field Code
		#region ContextSensitiveHelpId's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String ContextSensitiveHelpIdMetaAttributeGuidString = "b761485c-ba69-406b-99b1-52a38b368b11";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid ContextSensitiveHelpIdMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ContextSensitiveHelpIdMetaAttributeGuidString);
		#endregion

		#region ContextSensitiveHelpId's Generated Property Code

		private System.String contextSensitiveHelpIdPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ToolboxItemContextSensitiveHelpIdFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ContextSensitiveHelpIdMetaAttributeGuidString, "ToolboxItem.ContextSensitiveHelpId")]
		public  System.String ContextSensitiveHelpId
		{
			get
			{
				return contextSensitiveHelpIdPropertyStorage;
			}
		
			set
			{
				toolboxItemContextSensitiveHelpIdFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ToolboxItemContextSensitiveHelpIdFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ToolboxItem.ContextSensitiveHelpId field
		/// </summary>
		private static ToolboxItemContextSensitiveHelpIdFieldHandler	toolboxItemContextSensitiveHelpIdFieldHandler	= ToolboxItemContextSensitiveHelpIdFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ToolboxItem.ContextSensitiveHelpId
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ToolboxItemContextSensitiveHelpIdFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ToolboxItemContextSensitiveHelpIdFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ToolboxItem.ContextSensitiveHelpId field handler
			/// </summary>
			/// <value>ToolboxItemContextSensitiveHelpIdFieldHandler</value>
			public static ToolboxItemContextSensitiveHelpIdFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemContextSensitiveHelpIdFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemContextSensitiveHelpIdFieldHandler;
					}
					else
					{
						// The static constructor in ToolboxItem will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemContextSensitiveHelpIdFieldHandler, so just instantiate one and return it
						return new ToolboxItemContextSensitiveHelpIdFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ToolboxItem.ContextSensitiveHelpId field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ContextSensitiveHelpIdMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ToolboxItem</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem element)
			{
				return element.contextSensitiveHelpIdPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.contextSensitiveHelpIdPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.contextSensitiveHelpIdPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region Collection Classes for ToolboxItem
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ToolboxItemMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ToolboxItemMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ToolboxItem's Generated Constructor Code
	public  partial class ToolboxItem
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ToolboxItem(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ToolboxItem CreateToolboxItem(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateToolboxItem(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ToolboxItem CreateAndInitializeToolboxItem(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeToolboxItem(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ToolboxItem(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ToolboxItem CreateToolboxItem(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ToolboxItem)partition.ElementFactory.CreateElement(typeof(ToolboxItem));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ToolboxItem CreateAndInitializeToolboxItem(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ToolboxItem)partition.ElementFactory.CreateElement(typeof(ToolboxItem), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ToolboxItem
	/// <summary>
	/// ToolboxItem Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem))]
	public sealed class ToolboxItemElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ToolboxItemElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ToolboxItemElementFactoryCreator Instance
		{
			get
			{
				return new ToolboxItemElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool.MetaClassGuidString, "ShapeTool")]
	public  partial class ShapeTool : Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem
	{
		#region ShapeTool's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "4dab8cfc-47de-441f-b81a-a3dec52650ed";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool.MetaClassGuidString);
		#endregion

		#region Shape's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape Shape
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeToolMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeToolMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeToolMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for ShapeTool
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ShapeToolMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ShapeToolMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ShapeTool's Generated Constructor Code
	public  partial class ShapeTool
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeTool(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeTool CreateShapeTool(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateShapeTool(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeTool CreateAndInitializeShapeTool(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeShapeTool(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeTool(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeTool CreateShapeTool(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ShapeTool)partition.ElementFactory.CreateElement(typeof(ShapeTool));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeTool CreateAndInitializeShapeTool(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ShapeTool)partition.ElementFactory.CreateElement(typeof(ShapeTool), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ShapeTool
	/// <summary>
	/// ShapeTool Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool))]
	public sealed class ShapeToolElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeToolElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ShapeToolElementFactoryCreator Instance
		{
			get
			{
				return new ShapeToolElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool.MetaClassGuidString, "ConnectorTool")]
	public  partial class ConnectorTool : Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem
	{
		#region ConnectorTool's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "1025fcea-8bad-47d2-b672-f16003031567";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool.MetaClassGuidString);
		#endregion

		#region Connector's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector Connector
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorToolMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorToolMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorToolMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for ConnectorTool
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ConnectorToolMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ConnectorToolMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ConnectorTool's Generated Constructor Code
	public  partial class ConnectorTool
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorTool(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorTool CreateConnectorTool(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateConnectorTool(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorTool CreateAndInitializeConnectorTool(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeConnectorTool(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorTool(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorTool CreateConnectorTool(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ConnectorTool)partition.ElementFactory.CreateElement(typeof(ConnectorTool));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorTool CreateAndInitializeConnectorTool(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ConnectorTool)partition.ElementFactory.CreateElement(typeof(ConnectorTool), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ConnectorTool
	/// <summary>
	/// ConnectorTool Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool))]
	public sealed class ConnectorToolElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorToolElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ConnectorToolElementFactoryCreator Instance
		{
			get
			{
				return new ConnectorToolElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool.MetaClassGuidString, "CompartmentTextTool")]
	public  partial class CompartmentTextTool : Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem
	{
		#region CompartmentTextTool's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "bc57e168-0c77-47f1-ad42-92930bde0313";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool.MetaClassGuidString);
		#endregion

		#region TextCompartment's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment TextCompartment
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.CompartmentTextToolMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.TextCompartmentMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.CompartmentTextToolMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.TextCompartmentMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.TextCompartmentMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.CompartmentTextToolMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for CompartmentTextTool
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class CompartmentTextToolMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public CompartmentTextToolMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region CompartmentTextTool's Generated Constructor Code
	public  partial class CompartmentTextTool
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public CompartmentTextTool(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CompartmentTextTool CreateCompartmentTextTool(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateCompartmentTextTool(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CompartmentTextTool CreateAndInitializeCompartmentTextTool(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeCompartmentTextTool(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public CompartmentTextTool(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CompartmentTextTool CreateCompartmentTextTool(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (CompartmentTextTool)partition.ElementFactory.CreateElement(typeof(CompartmentTextTool));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CompartmentTextTool CreateAndInitializeCompartmentTextTool(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (CompartmentTextTool)partition.ElementFactory.CreateElement(typeof(CompartmentTextTool), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for CompartmentTextTool
	/// <summary>
	/// CompartmentTextTool Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool))]
	public sealed class CompartmentTextToolElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public CompartmentTextToolElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static CompartmentTextToolElementFactoryCreator Instance
		{
			get
			{
				return new CompartmentTextToolElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap.MetaClassGuidString, "DiagramMap")]
	public  partial class DiagramMap : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region DiagramMap's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "2090ffe3-f004-4400-8d28-1e6969a8fb8a";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap.MetaClassGuidString);
		#endregion

		#region Diagram's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram Diagram
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram), newRoles);
				}
			}
		}
		#endregion
		#region ShapeMaps's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapMoveableCollection ShapeMaps
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.DiagramMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.ShapeMapsMetaRoleGuid); }
		}
		#endregion
		#region ConnectorMaps's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapMoveableCollection ConnectorMaps
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.DiagramMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.ConnectorMapsMetaRoleGuid); }
		}
		#endregion
		#region Class's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept Class
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.DiagramMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.ClassMetaRoleGuid, false) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.DiagramMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.ClassMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.ClassMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.DiagramMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for DiagramMap
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class DiagramMapMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public DiagramMapMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region DiagramMap's Generated Constructor Code
	public  partial class DiagramMap
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public DiagramMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DiagramMap CreateDiagramMap(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateDiagramMap(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DiagramMap CreateAndInitializeDiagramMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeDiagramMap(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public DiagramMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DiagramMap CreateDiagramMap(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (DiagramMap)partition.ElementFactory.CreateElement(typeof(DiagramMap));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DiagramMap CreateAndInitializeDiagramMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (DiagramMap)partition.ElementFactory.CreateElement(typeof(DiagramMap), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for DiagramMap
	/// <summary>
	/// DiagramMap Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap))]
	public sealed class DiagramMapElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public DiagramMapElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static DiagramMapElementFactoryCreator Instance
		{
			get
			{
				return new DiagramMapElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap.MetaClassGuidString, "ShapeMap")]
	public  partial class ShapeMap : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ShapeMap's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "4eaeb35e-8e1f-4cc8-8ad9-d59eeec97596";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap.MetaClassGuidString);
		#endregion

		#region TextMaps's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapMoveableCollection TextMaps
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.ShapeMapClassMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.TextMapsMetaRoleGuid); }
		}
		#endregion
		#region Shape's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape Shape
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape), newRoles);
				}
			}
		}
		#endregion
		#region IconMaps's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapMoveableCollection IconMaps
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.ShapeMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.IconMapsMetaRoleGuid); }
		}
		#endregion
		#region MelCollectionExpression's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression MelCollectionExpression
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.ShapeMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.ShapeMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.ShapeMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression), newRoles);
				}
			}
		}
		#endregion
		#region Class's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept Class
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ShapeMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ClassMetaRoleGuid, false) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ShapeMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ClassMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ClassMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ShapeMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass), newRoles);
				}
			}
		}
		#endregion
		#region CompartmentMaps's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapMoveableCollection CompartmentMaps
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.ShapeMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.CompartmentMapsMetaRoleGuid); }
		}
		#endregion
	}
	#region Collection Classes for ShapeMap
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ShapeMapMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ShapeMapMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ShapeMap's Generated Constructor Code
	public  partial class ShapeMap
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeMap CreateShapeMap(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateShapeMap(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeMap CreateAndInitializeShapeMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeShapeMap(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeMap CreateShapeMap(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ShapeMap)partition.ElementFactory.CreateElement(typeof(ShapeMap));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeMap CreateAndInitializeShapeMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ShapeMap)partition.ElementFactory.CreateElement(typeof(ShapeMap), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ShapeMap
	/// <summary>
	/// ShapeMap Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap))]
	public sealed class ShapeMapElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeMapElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ShapeMapElementFactoryCreator Instance
		{
			get
			{
				return new ShapeMapElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap.MetaClassGuidString, "ShapeTextMap")]
	public  partial class ShapeTextMap : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ShapeTextMap's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "1b25b523-20b5-45ba-9aeb-b0d939ff61e1";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap.MetaClassGuidString);
		#endregion

		#region TextDecorator's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText TextDecorator
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextDecoratorMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextDecoratorMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextDecoratorMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator), newRoles);
				}
			}
		}
		#endregion
		#region ValueExpression's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression ValueExpression
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ShapeTextMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ShapeTextMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ShapeTextMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for ShapeTextMap
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ShapeTextMapMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ShapeTextMapMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ShapeTextMap's Generated Constructor Code
	public  partial class ShapeTextMap
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeTextMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeTextMap CreateShapeTextMap(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateShapeTextMap(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeTextMap CreateAndInitializeShapeTextMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeShapeTextMap(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeTextMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeTextMap CreateShapeTextMap(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ShapeTextMap)partition.ElementFactory.CreateElement(typeof(ShapeTextMap));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeTextMap CreateAndInitializeShapeTextMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ShapeTextMap)partition.ElementFactory.CreateElement(typeof(ShapeTextMap), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ShapeTextMap
	/// <summary>
	/// ShapeTextMap Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap))]
	public sealed class ShapeTextMapElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeTextMapElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ShapeTextMapElementFactoryCreator Instance
		{
			get
			{
				return new ShapeTextMapElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.MetaClassGuidString, "ExplorerNode")]
	public  partial class ExplorerNode : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ExplorerNode's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "0952a8e9-577d-4032-aec5-2519b3566ed7";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.MetaClassGuidString);
		#endregion

		#region StructureAsXmlFromHere's Generated  Field Code
		#region StructureAsXmlFromHere's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String StructureAsXmlFromHereMetaAttributeGuidString = "09a1d4bf-4702-4d14-8f94-e4b5613f51d9";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid StructureAsXmlFromHereMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.StructureAsXmlFromHereMetaAttributeGuidString);
		#endregion

		#region StructureAsXmlFromHere's Generated Property Code

		private System.Boolean structureAsXmlFromHerePropertyStorage = false;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean=false)]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ExplorerNodeStructureAsXmlFromHereFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.StructureAsXmlFromHereMetaAttributeGuidString, "ExplorerNode.StructureAsXmlFromHere")]
		public  System.Boolean StructureAsXmlFromHere
		{
			get
			{
				return structureAsXmlFromHerePropertyStorage;
			}
		
			set
			{
				explorerNodeStructureAsXmlFromHereFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ExplorerNodeStructureAsXmlFromHereFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ExplorerNode.StructureAsXmlFromHere field
		/// </summary>
		private static ExplorerNodeStructureAsXmlFromHereFieldHandler	explorerNodeStructureAsXmlFromHereFieldHandler	= ExplorerNodeStructureAsXmlFromHereFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ExplorerNode.StructureAsXmlFromHere
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ExplorerNodeStructureAsXmlFromHereFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode,System.Boolean>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ExplorerNodeStructureAsXmlFromHereFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ExplorerNode.StructureAsXmlFromHere field handler
			/// </summary>
			/// <value>ExplorerNodeStructureAsXmlFromHereFieldHandler</value>
			public static ExplorerNodeStructureAsXmlFromHereFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.explorerNodeStructureAsXmlFromHereFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.explorerNodeStructureAsXmlFromHereFieldHandler;
					}
					else
					{
						// The static constructor in ExplorerNode will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.explorerNodeStructureAsXmlFromHereFieldHandler, so just instantiate one and return it
						return new ExplorerNodeStructureAsXmlFromHereFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ExplorerNode.StructureAsXmlFromHere field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.StructureAsXmlFromHereMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ExplorerNode</param>
			protected sealed override System.Boolean GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode element)
			{
				return element.structureAsXmlFromHerePropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode element, System.Boolean value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.Boolean oldValue)
			{
				oldValue = element.structureAsXmlFromHerePropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.structureAsXmlFromHerePropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region ExplorerNode's Generated Constructor Code
	public  partial class ExplorerNode
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ExplorerNode(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ExplorerNode CreateExplorerNode(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateExplorerNode(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ExplorerNode CreateAndInitializeExplorerNode(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeExplorerNode(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ExplorerNode(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ExplorerNode CreateExplorerNode(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ExplorerNode)partition.ElementFactory.CreateElement(typeof(ExplorerNode));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ExplorerNode CreateAndInitializeExplorerNode(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ExplorerNode)partition.ElementFactory.CreateElement(typeof(ExplorerNode), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ExplorerNode
	/// <summary>
	/// ExplorerNode Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode))]
	public sealed class ExplorerNodeElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ExplorerNodeElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ExplorerNodeElementFactoryCreator Instance
		{
			get
			{
				return new ExplorerNodeElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.MetaClassGuidString, "ElementNode")]
	public  partial class ElementNode : Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode
	{
		#region ElementNode's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "ae9bab28-935c-4608-a5d6-abbf04cbb685";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.MetaClassGuidString);
		#endregion

		#region UseDefaultRendering's Generated  Field Code
		#region UseDefaultRendering's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String UseDefaultRenderingMetaAttributeGuidString = "3e3cac93-b417-4b82-8a57-dae268177a21";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid UseDefaultRenderingMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.UseDefaultRenderingMetaAttributeGuidString);
		#endregion

		#region UseDefaultRendering's Generated Property Code

		private System.Boolean useDefaultRenderingPropertyStorage = false;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean=false)]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ElementNodeUseDefaultRenderingFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.UseDefaultRenderingMetaAttributeGuidString, "ElementNode.UseDefaultRendering")]
		public  System.Boolean UseDefaultRendering
		{
			get
			{
				return useDefaultRenderingPropertyStorage;
			}
		
			set
			{
				elementNodeUseDefaultRenderingFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ElementNodeUseDefaultRenderingFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ElementNode.UseDefaultRendering field
		/// </summary>
		private static ElementNodeUseDefaultRenderingFieldHandler	elementNodeUseDefaultRenderingFieldHandler	= ElementNodeUseDefaultRenderingFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ElementNode.UseDefaultRendering
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ElementNodeUseDefaultRenderingFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode,System.Boolean>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ElementNodeUseDefaultRenderingFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ElementNode.UseDefaultRendering field handler
			/// </summary>
			/// <value>ElementNodeUseDefaultRenderingFieldHandler</value>
			public static ElementNodeUseDefaultRenderingFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.elementNodeUseDefaultRenderingFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.elementNodeUseDefaultRenderingFieldHandler;
					}
					else
					{
						// The static constructor in ElementNode will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.elementNodeUseDefaultRenderingFieldHandler, so just instantiate one and return it
						return new ElementNodeUseDefaultRenderingFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ElementNode.UseDefaultRendering field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.UseDefaultRenderingMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ElementNode</param>
			protected sealed override System.Boolean GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode element)
			{
				return element.useDefaultRenderingPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode element, System.Boolean value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.Boolean oldValue)
			{
				oldValue = element.useDefaultRenderingPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.useDefaultRenderingPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region Class's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept Class
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassMetaRoleGuid, false) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassNodeMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassNodeMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass), newRoles);
				}
			}
		}
		#endregion
		#region ChildCollections's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeMoveableCollection ChildCollections
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.NodeTypeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.ChildCollectionsMetaRoleGuid); }
		}
		#endregion
		#region Rendering's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering Rendering
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.ClassNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.ClassNodeMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.ClassNodeMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for ElementNode
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ElementNodeMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ElementNodeMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ElementNode's Generated Constructor Code
	public  partial class ElementNode
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ElementNode(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ElementNode CreateElementNode(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateElementNode(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ElementNode CreateAndInitializeElementNode(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeElementNode(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ElementNode(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ElementNode CreateElementNode(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ElementNode)partition.ElementFactory.CreateElement(typeof(ElementNode));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ElementNode CreateAndInitializeElementNode(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ElementNode)partition.ElementFactory.CreateElement(typeof(ElementNode), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ElementNode
	/// <summary>
	/// ElementNode Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode))]
	public sealed class ElementNodeElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ElementNodeElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ElementNodeElementFactoryCreator Instance
		{
			get
			{
				return new ElementNodeElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.MetaClassGuidString, "CollectionNode")]
	public  partial class CollectionNode : Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode
	{
		#region CollectionNode's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "4e880f9d-751d-4cf9-a7c8-a3b781bc6be8";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.MetaClassGuidString);
		#endregion

		#region SortOrder's Generated  Field Code
		#region SortOrder's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String SortOrderMetaAttributeGuidString = "c52fa124-9672-4279-b734-85eb6a06b3a5";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid SortOrderMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.SortOrderMetaAttributeGuidString);
		#endregion

		#region SortOrder's Generated Property Code

		private Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder sortOrderPropertyStorage = Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder.Ascending;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType=typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder),DefaultEnumerationValueName="Ascending")]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(CollectionNodeSortOrderFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.SortOrderMetaAttributeGuidString, "CollectionNode.SortOrder")]
		public  Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder SortOrder
		{
			get
			{
				return sortOrderPropertyStorage;
			}
		
			set
			{
				collectionNodeSortOrderFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region CollectionNodeSortOrderFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for CollectionNode.SortOrder field
		/// </summary>
		private static CollectionNodeSortOrderFieldHandler	collectionNodeSortOrderFieldHandler	= CollectionNodeSortOrderFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for CollectionNode.SortOrder
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class CollectionNodeSortOrderFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode,Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private CollectionNodeSortOrderFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the CollectionNode.SortOrder field handler
			/// </summary>
			/// <value>CollectionNodeSortOrderFieldHandler</value>
			public static CollectionNodeSortOrderFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeSortOrderFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeSortOrderFieldHandler;
					}
					else
					{
						// The static constructor in CollectionNode will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeSortOrderFieldHandler, so just instantiate one and return it
						return new CollectionNodeSortOrderFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the CollectionNode.SortOrder field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.SortOrderMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the CollectionNode</param>
			protected sealed override Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode element)
			{
				return element.sortOrderPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode element, Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder oldValue)
			{
				oldValue = element.sortOrderPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.sortOrderPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region RenderCollectionNode's Generated  Field Code
		#region RenderCollectionNode's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String RenderCollectionNodeMetaAttributeGuidString = "cf1e93c2-1aed-4e71-9027-a35e3a6e2930";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid RenderCollectionNodeMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.RenderCollectionNodeMetaAttributeGuidString);
		#endregion

		#region RenderCollectionNode's Generated Property Code

		private System.Boolean renderCollectionNodePropertyStorage = false;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean=false)]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(CollectionNodeRenderCollectionNodeFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.RenderCollectionNodeMetaAttributeGuidString, "CollectionNode.RenderCollectionNode")]
		public  System.Boolean RenderCollectionNode
		{
			get
			{
				return renderCollectionNodePropertyStorage;
			}
		
			set
			{
				collectionNodeRenderCollectionNodeFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region CollectionNodeRenderCollectionNodeFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for CollectionNode.RenderCollectionNode field
		/// </summary>
		private static CollectionNodeRenderCollectionNodeFieldHandler	collectionNodeRenderCollectionNodeFieldHandler	= CollectionNodeRenderCollectionNodeFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for CollectionNode.RenderCollectionNode
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class CollectionNodeRenderCollectionNodeFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode,System.Boolean>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private CollectionNodeRenderCollectionNodeFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the CollectionNode.RenderCollectionNode field handler
			/// </summary>
			/// <value>CollectionNodeRenderCollectionNodeFieldHandler</value>
			public static CollectionNodeRenderCollectionNodeFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeRenderCollectionNodeFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeRenderCollectionNodeFieldHandler;
					}
					else
					{
						// The static constructor in CollectionNode will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeRenderCollectionNodeFieldHandler, so just instantiate one and return it
						return new CollectionNodeRenderCollectionNodeFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the CollectionNode.RenderCollectionNode field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.RenderCollectionNodeMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the CollectionNode</param>
			protected sealed override System.Boolean GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode element)
			{
				return element.renderCollectionNodePropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode element, System.Boolean value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.Boolean oldValue)
			{
				oldValue = element.renderCollectionNodePropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.renderCollectionNodePropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region SortProperty's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValueProperty SortProperty
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.CollectionNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.SortPropertyMetaRoleGuid, false) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValueProperty;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.CollectionNodeMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.SortPropertyMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValueProperty counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValueProperty;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.SortPropertyMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.CollectionNodeMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty), newRoles);
				}
			}
		}
		#endregion
		#region Rendering's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering Rendering
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.CollectionNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.CollectionNodeMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.CollectionNodeMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering), newRoles);
				}
			}
		}
		#endregion
		#region ChildNodes's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNodeMoveableCollection ChildNodes
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNodeMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.CollectionNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.ChildNodesMetaRoleGuid); }
		}
		#endregion
		#region MelCollectionExpression's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression MelCollectionExpression
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.CollectionNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.CollectionNodeMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.CollectionNodeMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for CollectionNode
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class CollectionNodeMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public CollectionNodeMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region CollectionNode's Generated Constructor Code
	public  partial class CollectionNode
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public CollectionNode(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CollectionNode CreateCollectionNode(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateCollectionNode(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CollectionNode CreateAndInitializeCollectionNode(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeCollectionNode(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public CollectionNode(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CollectionNode CreateCollectionNode(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (CollectionNode)partition.ElementFactory.CreateElement(typeof(CollectionNode));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CollectionNode CreateAndInitializeCollectionNode(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (CollectionNode)partition.ElementFactory.CreateElement(typeof(CollectionNode), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for CollectionNode
	/// <summary>
	/// CollectionNode Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode))]
	public sealed class CollectionNodeElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public CollectionNodeElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static CollectionNodeElementFactoryCreator Instance
		{
			get
			{
				return new CollectionNodeElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet.MetaClassGuidString, "PropertySet")]
	public  partial class PropertySet : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region PropertySet's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "6b79526d-08d3-4dc6-9da3-304f391d993d";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet.MetaClassGuidString);
		#endregion

		#region Class's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept Class
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.PropertiesSetMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.ClassMetaRoleGuid, false) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.PropertiesSetMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.ClassMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.ClassMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.PropertiesSetMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass), newRoles);
				}
			}
		}
		#endregion
		#region ValuePropertiesToExclude's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValuePropertyMoveableCollection ValuePropertiesToExclude
		{
			get { return new Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValuePropertyMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions.PropertiesSetMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions.ValuePropertiesToExcludeMetaRoleGuid); }
		}
		#endregion
		#region RoleProperties's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyMoveableCollection RoleProperties
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.PropertySetMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.RolePropertiesMetaRoleGuid); }
		}
		#endregion
	}
	#region Collection Classes for PropertySet
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class PropertySetMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public PropertySetMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region PropertySet's Generated Constructor Code
	public  partial class PropertySet
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public PropertySet(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PropertySet CreatePropertySet(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreatePropertySet(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PropertySet CreateAndInitializePropertySet(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializePropertySet(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public PropertySet(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PropertySet CreatePropertySet(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (PropertySet)partition.ElementFactory.CreateElement(typeof(PropertySet));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PropertySet CreateAndInitializePropertySet(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (PropertySet)partition.ElementFactory.CreateElement(typeof(PropertySet), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for PropertySet
	/// <summary>
	/// PropertySet Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet))]
	public sealed class PropertySetElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public PropertySetElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static PropertySetElementFactoryCreator Instance
		{
			get
			{
				return new PropertySetElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.MetaClassGuidString, "DiagramElementDetails")]
	public  partial class DiagramElementDetails : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region DiagramElementDetails's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "c00d63fe-07c7-4048-8905-d700bc1947c0";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.MetaClassGuidString);
		#endregion

		#region Variability's Generated  Field Code
		#region Variability's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String VariabilityMetaAttributeGuidString = "4972614f-e669-4090-b7aa-cac2e3b73527";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid VariabilityMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.VariabilityMetaAttributeGuidString);
		#endregion

		#region Variability's Generated Property Code

		private Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability variabilityPropertyStorage = Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability.Fixed;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType=typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability),DefaultEnumerationValueName="Fixed")]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(DiagramElementDetailsVariabilityFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.VariabilityMetaAttributeGuidString, "DiagramElementDetails.Variability")]
		public  Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability Variability
		{
			get
			{
				return variabilityPropertyStorage;
			}
		
			set
			{
				diagramElementDetailsVariabilityFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region DiagramElementDetailsVariabilityFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for DiagramElementDetails.Variability field
		/// </summary>
		private static DiagramElementDetailsVariabilityFieldHandler	diagramElementDetailsVariabilityFieldHandler	= DiagramElementDetailsVariabilityFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for DiagramElementDetails.Variability
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class DiagramElementDetailsVariabilityFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails,Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private DiagramElementDetailsVariabilityFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the DiagramElementDetails.Variability field handler
			/// </summary>
			/// <value>DiagramElementDetailsVariabilityFieldHandler</value>
			public static DiagramElementDetailsVariabilityFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.diagramElementDetailsVariabilityFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.diagramElementDetailsVariabilityFieldHandler;
					}
					else
					{
						// The static constructor in DiagramElementDetails will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.diagramElementDetailsVariabilityFieldHandler, so just instantiate one and return it
						return new DiagramElementDetailsVariabilityFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the DiagramElementDetails.Variability field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.VariabilityMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the DiagramElementDetails</param>
			protected sealed override Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails element)
			{
				return element.variabilityPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails element, Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability oldValue)
			{
				oldValue = element.variabilityPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.variabilityPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region DiagramElementDetails's Generated Constructor Code
	public  partial class DiagramElementDetails
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public DiagramElementDetails(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DiagramElementDetails CreateDiagramElementDetails(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateDiagramElementDetails(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DiagramElementDetails CreateAndInitializeDiagramElementDetails(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeDiagramElementDetails(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public DiagramElementDetails(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DiagramElementDetails CreateDiagramElementDetails(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (DiagramElementDetails)partition.ElementFactory.CreateElement(typeof(DiagramElementDetails));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DiagramElementDetails CreateAndInitializeDiagramElementDetails(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (DiagramElementDetails)partition.ElementFactory.CreateElement(typeof(DiagramElementDetails), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for DiagramElementDetails
	/// <summary>
	/// DiagramElementDetails Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails))]
	public sealed class DiagramElementDetailsElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public DiagramElementDetailsElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static DiagramElementDetailsElementFactoryCreator Instance
		{
			get
			{
				return new DiagramElementDetailsElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.MetaClassGuidString, "ColorDetails")]
	public  partial class ColorDetails : Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails
	{
		#region ColorDetails's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "adf78b62-0fc3-4fa7-93a0-9e713193beb1";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.MetaClassGuidString);
		#endregion

		#region Color's Generated  Field Code
		#region Color's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String ColorMetaAttributeGuidString = "e698fac4-70c2-4a24-b4ce-109689163f16";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid ColorMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.ColorMetaAttributeGuidString);
		#endregion

		#region Color's Generated Property Code

		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(CustomStorage=true, FieldHandlerType=typeof(ColorDetailsColorFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.ColorMetaAttributeGuidString, "ColorDetails.Color")]
		public  System.Drawing.Color Color
		{
			get
			{
				return colorDetailsColorFieldHandler.GetFieldValue(this);
			}
		
			set
			{
				colorDetailsColorFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ColorDetailsColorFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ColorDetails.Color field
		/// </summary>
		private static ColorDetailsColorFieldHandler	colorDetailsColorFieldHandler	= ColorDetailsColorFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ColorDetails.Color
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ColorDetailsColorFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementCustomStoredFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails,System.Drawing.Color>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ColorDetailsColorFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ColorDetails.Color field handler
			/// </summary>
			/// <value>ColorDetailsColorFieldHandler</value>
			public static ColorDetailsColorFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.colorDetailsColorFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.colorDetailsColorFieldHandler;
					}
					else
					{
						// The static constructor in ColorDetails will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.colorDetailsColorFieldHandler, so just instantiate one and return it
						return new ColorDetailsColorFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ColorDetails.Color field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.ColorMetaAttributeGuid;
				}
			}
		}
		#endregion
		#endregion
		
	}
	#region ColorDetails's Generated Constructor Code
	public  partial class ColorDetails
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ColorDetails(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ColorDetails CreateColorDetails(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateColorDetails(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ColorDetails CreateAndInitializeColorDetails(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeColorDetails(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ColorDetails(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ColorDetails CreateColorDetails(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ColorDetails)partition.ElementFactory.CreateElement(typeof(ColorDetails));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ColorDetails CreateAndInitializeColorDetails(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ColorDetails)partition.ElementFactory.CreateElement(typeof(ColorDetails), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ColorDetails
	/// <summary>
	/// ColorDetails Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails))]
	public sealed class ColorDetailsElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ColorDetailsElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ColorDetailsElementFactoryCreator Instance
		{
			get
			{
				return new ColorDetailsElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.MetaClassGuidString, "ShapeDecorator")]
	public  partial class ShapeDecorator : Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails
	{
		#region ShapeDecorator's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "7f690600-d53e-48c1-a0e6-b7683cd1082d";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.MetaClassGuidString);
		#endregion

		#region Position's Generated  Field Code
		#region Position's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String PositionMetaAttributeGuidString = "537b7e3d-274f-4861-8657-14e3357d49dd";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid PositionMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.PositionMetaAttributeGuidString);
		#endregion

		#region Position's Generated Property Code

		private Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition positionPropertyStorage = Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition.Center;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType=typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition),DefaultEnumerationValueName="Center")]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ShapeDecoratorPositionFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.PositionMetaAttributeGuidString, "ShapeDecorator.Position")]
		public  Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition Position
		{
			get
			{
				return positionPropertyStorage;
			}
		
			set
			{
				shapeDecoratorPositionFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ShapeDecoratorPositionFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ShapeDecorator.Position field
		/// </summary>
		private static ShapeDecoratorPositionFieldHandler	shapeDecoratorPositionFieldHandler	= ShapeDecoratorPositionFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ShapeDecorator.Position
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ShapeDecoratorPositionFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator,Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ShapeDecoratorPositionFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ShapeDecorator.Position field handler
			/// </summary>
			/// <value>ShapeDecoratorPositionFieldHandler</value>
			public static ShapeDecoratorPositionFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.shapeDecoratorPositionFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.shapeDecoratorPositionFieldHandler;
					}
					else
					{
						// The static constructor in ShapeDecorator will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.shapeDecoratorPositionFieldHandler, so just instantiate one and return it
						return new ShapeDecoratorPositionFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ShapeDecorator.Position field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.PositionMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ShapeDecorator</param>
			protected sealed override Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator element)
			{
				return element.positionPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator element, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition oldValue)
			{
				oldValue = element.positionPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.positionPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region Collection Classes for ShapeDecorator
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ShapeDecoratorMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ShapeDecoratorMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ShapeDecorator's Generated Constructor Code
	public  partial class ShapeDecorator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeDecorator(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeDecorator CreateShapeDecorator(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateShapeDecorator(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeDecorator CreateAndInitializeShapeDecorator(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeShapeDecorator(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeDecorator(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeDecorator CreateShapeDecorator(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ShapeDecorator)partition.ElementFactory.CreateElement(typeof(ShapeDecorator));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeDecorator CreateAndInitializeShapeDecorator(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ShapeDecorator)partition.ElementFactory.CreateElement(typeof(ShapeDecorator), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ShapeDecorator
	/// <summary>
	/// ShapeDecorator Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator))]
	public sealed class ShapeDecoratorElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeDecoratorElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ShapeDecoratorElementFactoryCreator Instance
		{
			get
			{
				return new ShapeDecoratorElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.MetaClassGuidString, "ShapeText")]
	public  partial class ShapeText : Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator
	{
		#region ShapeText's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "99272c48-c486-47ff-b057-93a91703ba93";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.MetaClassGuidString);
		#endregion

		#region DefaultTextId's Generated  Field Code
		#region DefaultTextId's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String DefaultTextIdMetaAttributeGuidString = "9f9e55ea-4cdb-49f6-ba74-908d2e614895";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid DefaultTextIdMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.DefaultTextIdMetaAttributeGuidString);
		#endregion

		#region DefaultTextId's Generated Property Code

		private System.String defaultTextIdPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ShapeTextDefaultTextIdFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.DefaultTextIdMetaAttributeGuidString, "ShapeText.DefaultTextId")]
		public  System.String DefaultTextId
		{
			get
			{
				return defaultTextIdPropertyStorage;
			}
		
			set
			{
				shapeTextDefaultTextIdFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ShapeTextDefaultTextIdFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ShapeText.DefaultTextId field
		/// </summary>
		private static ShapeTextDefaultTextIdFieldHandler	shapeTextDefaultTextIdFieldHandler	= ShapeTextDefaultTextIdFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ShapeText.DefaultTextId
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ShapeTextDefaultTextIdFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ShapeTextDefaultTextIdFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ShapeText.DefaultTextId field handler
			/// </summary>
			/// <value>ShapeTextDefaultTextIdFieldHandler</value>
			public static ShapeTextDefaultTextIdFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.shapeTextDefaultTextIdFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.shapeTextDefaultTextIdFieldHandler;
					}
					else
					{
						// The static constructor in ShapeText will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.shapeTextDefaultTextIdFieldHandler, so just instantiate one and return it
						return new ShapeTextDefaultTextIdFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ShapeText.DefaultTextId field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.DefaultTextIdMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ShapeText</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText element)
			{
				return element.defaultTextIdPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.defaultTextIdPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.defaultTextIdPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region ShapeText's Generated Constructor Code
	public  partial class ShapeText
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeText(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeText CreateShapeText(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateShapeText(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeText CreateAndInitializeShapeText(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeShapeText(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeText(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeText CreateShapeText(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ShapeText)partition.ElementFactory.CreateElement(typeof(ShapeText));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeText CreateAndInitializeShapeText(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ShapeText)partition.ElementFactory.CreateElement(typeof(ShapeText), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ShapeText
	/// <summary>
	/// ShapeText Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText))]
	public sealed class ShapeTextElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeTextElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ShapeTextElementFactoryCreator Instance
		{
			get
			{
				return new ShapeTextElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.MetaClassGuidString, "ShapeIcon")]
	public  partial class ShapeIcon : Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator
	{
		#region ShapeIcon's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "c67fc6bc-c353-40e3-af24-f6bb35b5441c";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.MetaClassGuidString);
		#endregion

		#region IconId's Generated  Field Code
		#region IconId's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String IconIdMetaAttributeGuidString = "cbf105bc-36a0-4f21-bbbd-f09cdbbdc932";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid IconIdMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.IconIdMetaAttributeGuidString);
		#endregion

		#region IconId's Generated Property Code

		private System.String iconIdPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ShapeIconIconIdFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.IconIdMetaAttributeGuidString, "ShapeIcon.IconId")]
		public  System.String IconId
		{
			get
			{
				return iconIdPropertyStorage;
			}
		
			set
			{
				shapeIconIconIdFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ShapeIconIconIdFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ShapeIcon.IconId field
		/// </summary>
		private static ShapeIconIconIdFieldHandler	shapeIconIconIdFieldHandler	= ShapeIconIconIdFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ShapeIcon.IconId
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ShapeIconIconIdFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ShapeIconIconIdFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ShapeIcon.IconId field handler
			/// </summary>
			/// <value>ShapeIconIconIdFieldHandler</value>
			public static ShapeIconIconIdFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.shapeIconIconIdFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.shapeIconIconIdFieldHandler;
					}
					else
					{
						// The static constructor in ShapeIcon will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.shapeIconIconIdFieldHandler, so just instantiate one and return it
						return new ShapeIconIconIdFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ShapeIcon.IconId field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.IconIdMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ShapeIcon</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon element)
			{
				return element.iconIdPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.iconIdPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.iconIdPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region ShapeIcon's Generated Constructor Code
	public  partial class ShapeIcon
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeIcon(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeIcon CreateShapeIcon(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateShapeIcon(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeIcon CreateAndInitializeShapeIcon(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeShapeIcon(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeIcon(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeIcon CreateShapeIcon(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ShapeIcon)partition.ElementFactory.CreateElement(typeof(ShapeIcon));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeIcon CreateAndInitializeShapeIcon(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ShapeIcon)partition.ElementFactory.CreateElement(typeof(ShapeIcon), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ShapeIcon
	/// <summary>
	/// ShapeIcon Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon))]
	public sealed class ShapeIconElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeIconElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ShapeIconElementFactoryCreator Instance
		{
			get
			{
				return new ShapeIconElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapse.MetaClassGuidString, "ExpandCollapse")]
	public  partial class ExpandCollapse : Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator
	{
		#region ExpandCollapse's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "7bd3c359-babd-4843-9a80-239fe5b50f92";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapse.MetaClassGuidString);
		#endregion

	}
	#region ExpandCollapse's Generated Constructor Code
	public  partial class ExpandCollapse
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ExpandCollapse(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ExpandCollapse CreateExpandCollapse(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateExpandCollapse(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ExpandCollapse CreateAndInitializeExpandCollapse(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeExpandCollapse(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ExpandCollapse(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ExpandCollapse CreateExpandCollapse(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ExpandCollapse)partition.ElementFactory.CreateElement(typeof(ExpandCollapse));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ExpandCollapse CreateAndInitializeExpandCollapse(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ExpandCollapse)partition.ElementFactory.CreateElement(typeof(ExpandCollapse), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ExpandCollapse
	/// <summary>
	/// ExpandCollapse Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapse))]
	public sealed class ExpandCollapseElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ExpandCollapseElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapse( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ExpandCollapseElementFactoryCreator Instance
		{
			get
			{
				return new ExpandCollapseElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.MetaClassGuidString, "ConnectorDecorator")]
	public  partial class ConnectorDecorator : Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails
	{
		#region ConnectorDecorator's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "2a56ecc0-172f-47aa-99ed-e9bdb09ba1ea";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.MetaClassGuidString);
		#endregion

		#region Position's Generated  Field Code
		#region Position's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String PositionMetaAttributeGuidString = "6ce604ef-1e7c-47f3-82db-821381ce129a";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid PositionMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.PositionMetaAttributeGuidString);
		#endregion

		#region Position's Generated Property Code

		private Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition positionPropertyStorage = Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition.CenterTop;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType=typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition),DefaultEnumerationValueName="CenterTop")]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ConnectorDecoratorPositionFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.PositionMetaAttributeGuidString, "ConnectorDecorator.Position")]
		public  Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition Position
		{
			get
			{
				return positionPropertyStorage;
			}
		
			set
			{
				connectorDecoratorPositionFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ConnectorDecoratorPositionFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ConnectorDecorator.Position field
		/// </summary>
		private static ConnectorDecoratorPositionFieldHandler	connectorDecoratorPositionFieldHandler	= ConnectorDecoratorPositionFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ConnectorDecorator.Position
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ConnectorDecoratorPositionFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator,Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ConnectorDecoratorPositionFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ConnectorDecorator.Position field handler
			/// </summary>
			/// <value>ConnectorDecoratorPositionFieldHandler</value>
			public static ConnectorDecoratorPositionFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.connectorDecoratorPositionFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.connectorDecoratorPositionFieldHandler;
					}
					else
					{
						// The static constructor in ConnectorDecorator will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.connectorDecoratorPositionFieldHandler, so just instantiate one and return it
						return new ConnectorDecoratorPositionFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ConnectorDecorator.Position field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.PositionMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ConnectorDecorator</param>
			protected sealed override Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator element)
			{
				return element.positionPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator element, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition oldValue)
			{
				oldValue = element.positionPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.positionPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region Collection Classes for ConnectorDecorator
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ConnectorDecoratorMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ConnectorDecoratorMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ConnectorDecorator's Generated Constructor Code
	public  partial class ConnectorDecorator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorDecorator(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorDecorator CreateConnectorDecorator(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateConnectorDecorator(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorDecorator CreateAndInitializeConnectorDecorator(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeConnectorDecorator(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorDecorator(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorDecorator CreateConnectorDecorator(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ConnectorDecorator)partition.ElementFactory.CreateElement(typeof(ConnectorDecorator));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorDecorator CreateAndInitializeConnectorDecorator(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ConnectorDecorator)partition.ElementFactory.CreateElement(typeof(ConnectorDecorator), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ConnectorDecorator
	/// <summary>
	/// ConnectorDecorator Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator))]
	public sealed class ConnectorDecoratorElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorDecoratorElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ConnectorDecoratorElementFactoryCreator Instance
		{
			get
			{
				return new ConnectorDecoratorElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.MetaClassGuidString, "ConnectorText")]
	public  partial class ConnectorText : Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator
	{
		#region ConnectorText's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "dd5cabab-3edf-45df-ab78-b3c108d301c6";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.MetaClassGuidString);
		#endregion

		#region DefaultTextId's Generated  Field Code
		#region DefaultTextId's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String DefaultTextIdMetaAttributeGuidString = "d4c00aad-f864-4e4c-ba54-8b9bab0ed8d9";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid DefaultTextIdMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.DefaultTextIdMetaAttributeGuidString);
		#endregion

		#region DefaultTextId's Generated Property Code

		private System.String defaultTextIdPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ConnectorTextDefaultTextIdFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.DefaultTextIdMetaAttributeGuidString, "ConnectorText.DefaultTextId")]
		public  System.String DefaultTextId
		{
			get
			{
				return defaultTextIdPropertyStorage;
			}
		
			set
			{
				connectorTextDefaultTextIdFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ConnectorTextDefaultTextIdFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ConnectorText.DefaultTextId field
		/// </summary>
		private static ConnectorTextDefaultTextIdFieldHandler	connectorTextDefaultTextIdFieldHandler	= ConnectorTextDefaultTextIdFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ConnectorText.DefaultTextId
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ConnectorTextDefaultTextIdFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ConnectorTextDefaultTextIdFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ConnectorText.DefaultTextId field handler
			/// </summary>
			/// <value>ConnectorTextDefaultTextIdFieldHandler</value>
			public static ConnectorTextDefaultTextIdFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.connectorTextDefaultTextIdFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.connectorTextDefaultTextIdFieldHandler;
					}
					else
					{
						// The static constructor in ConnectorText will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.connectorTextDefaultTextIdFieldHandler, so just instantiate one and return it
						return new ConnectorTextDefaultTextIdFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ConnectorText.DefaultTextId field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.DefaultTextIdMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ConnectorText</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText element)
			{
				return element.defaultTextIdPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.defaultTextIdPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.defaultTextIdPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region ConnectorText's Generated Constructor Code
	public  partial class ConnectorText
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorText(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorText CreateConnectorText(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateConnectorText(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorText CreateAndInitializeConnectorText(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeConnectorText(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorText(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorText CreateConnectorText(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ConnectorText)partition.ElementFactory.CreateElement(typeof(ConnectorText));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorText CreateAndInitializeConnectorText(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ConnectorText)partition.ElementFactory.CreateElement(typeof(ConnectorText), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ConnectorText
	/// <summary>
	/// ConnectorText Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText))]
	public sealed class ConnectorTextElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorTextElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ConnectorTextElementFactoryCreator Instance
		{
			get
			{
				return new ConnectorTextElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.MetaClassGuidString, "ConnectorIcon")]
	public  partial class ConnectorIcon : Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator
	{
		#region ConnectorIcon's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "c932c24c-58e7-413f-92f8-84a8a37d61b6";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.MetaClassGuidString);
		#endregion

		#region IconId's Generated  Field Code
		#region IconId's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String IconIdMetaAttributeGuidString = "160f03a2-3594-4a00-aadb-f4f7542015ee";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid IconIdMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.IconIdMetaAttributeGuidString);
		#endregion

		#region IconId's Generated Property Code

		private System.String iconIdPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ConnectorIconIconIdFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.IconIdMetaAttributeGuidString, "ConnectorIcon.IconId")]
		public  System.String IconId
		{
			get
			{
				return iconIdPropertyStorage;
			}
		
			set
			{
				connectorIconIconIdFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ConnectorIconIconIdFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ConnectorIcon.IconId field
		/// </summary>
		private static ConnectorIconIconIdFieldHandler	connectorIconIconIdFieldHandler	= ConnectorIconIconIdFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ConnectorIcon.IconId
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ConnectorIconIconIdFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ConnectorIconIconIdFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ConnectorIcon.IconId field handler
			/// </summary>
			/// <value>ConnectorIconIconIdFieldHandler</value>
			public static ConnectorIconIconIdFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.connectorIconIconIdFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.connectorIconIconIdFieldHandler;
					}
					else
					{
						// The static constructor in ConnectorIcon will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.connectorIconIconIdFieldHandler, so just instantiate one and return it
						return new ConnectorIconIconIdFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ConnectorIcon.IconId field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.IconIdMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ConnectorIcon</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon element)
			{
				return element.iconIdPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.iconIdPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.iconIdPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region ConnectorIcon's Generated Constructor Code
	public  partial class ConnectorIcon
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorIcon(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorIcon CreateConnectorIcon(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateConnectorIcon(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorIcon CreateAndInitializeConnectorIcon(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeConnectorIcon(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorIcon(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorIcon CreateConnectorIcon(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ConnectorIcon)partition.ElementFactory.CreateElement(typeof(ConnectorIcon));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorIcon CreateAndInitializeConnectorIcon(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ConnectorIcon)partition.ElementFactory.CreateElement(typeof(ConnectorIcon), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ConnectorIcon
	/// <summary>
	/// ConnectorIcon Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon))]
	public sealed class ConnectorIconElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorIconElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ConnectorIconElementFactoryCreator Instance
		{
			get
			{
				return new ConnectorIconElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.MetaClassGuidString, "DashStyleDetails")]
	public  partial class DashStyleDetails : Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails
	{
		#region DashStyleDetails's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "c1329e93-f6f4-4d1b-95ce-4654e4c79427";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.MetaClassGuidString);
		#endregion

		#region DashStyle's Generated  Field Code
		#region DashStyle's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String DashStyleMetaAttributeGuidString = "e98d5806-842b-4c87-85f8-2a7cd965389b";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid DashStyleMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.DashStyleMetaAttributeGuidString);
		#endregion

		#region DashStyle's Generated Property Code

		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(CustomStorage=true, FieldHandlerType=typeof(DashStyleDetailsDashStyleFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.DashStyleMetaAttributeGuidString, "DashStyleDetails.DashStyle")]
		public  System.Drawing.Drawing2D.DashStyle DashStyle
		{
			get
			{
				return dashStyleDetailsDashStyleFieldHandler.GetFieldValue(this);
			}
		
			set
			{
				dashStyleDetailsDashStyleFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region DashStyleDetailsDashStyleFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for DashStyleDetails.DashStyle field
		/// </summary>
		private static DashStyleDetailsDashStyleFieldHandler	dashStyleDetailsDashStyleFieldHandler	= DashStyleDetailsDashStyleFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for DashStyleDetails.DashStyle
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class DashStyleDetailsDashStyleFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementCustomStoredFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails,System.Drawing.Drawing2D.DashStyle>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private DashStyleDetailsDashStyleFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the DashStyleDetails.DashStyle field handler
			/// </summary>
			/// <value>DashStyleDetailsDashStyleFieldHandler</value>
			public static DashStyleDetailsDashStyleFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.dashStyleDetailsDashStyleFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.dashStyleDetailsDashStyleFieldHandler;
					}
					else
					{
						// The static constructor in DashStyleDetails will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.dashStyleDetailsDashStyleFieldHandler, so just instantiate one and return it
						return new DashStyleDetailsDashStyleFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the DashStyleDetails.DashStyle field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.DashStyleMetaAttributeGuid;
				}
			}
		}
		#endregion
		#endregion
		
	}
	#region DashStyleDetails's Generated Constructor Code
	public  partial class DashStyleDetails
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public DashStyleDetails(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DashStyleDetails CreateDashStyleDetails(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateDashStyleDetails(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DashStyleDetails CreateAndInitializeDashStyleDetails(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeDashStyleDetails(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public DashStyleDetails(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DashStyleDetails CreateDashStyleDetails(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (DashStyleDetails)partition.ElementFactory.CreateElement(typeof(DashStyleDetails));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static DashStyleDetails CreateAndInitializeDashStyleDetails(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (DashStyleDetails)partition.ElementFactory.CreateElement(typeof(DashStyleDetails), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for DashStyleDetails
	/// <summary>
	/// DashStyleDetails Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails))]
	public sealed class DashStyleDetailsElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public DashStyleDetailsElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static DashStyleDetailsElementFactoryCreator Instance
		{
			get
			{
				return new DashStyleDetailsElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.MetaClassGuidString, "NodeRendering")]
	public  partial class NodeRendering : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region NodeRendering's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "bc1d4e0c-65a8-4fad-a5a6-afa8d934cdba";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.MetaClassGuidString);
		#endregion

		#region IconId's Generated  Field Code
		#region IconId's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String IconIdMetaAttributeGuidString = "e989b98b-76cd-46a4-9888-670fd75a520d";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid IconIdMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.IconIdMetaAttributeGuidString);
		#endregion

		#region IconId's Generated Property Code

		private System.String iconIdPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(NodeRenderingIconIdFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.IconIdMetaAttributeGuidString, "NodeRendering.IconId")]
		public  System.String IconId
		{
			get
			{
				return iconIdPropertyStorage;
			}
		
			set
			{
				nodeRenderingIconIdFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region NodeRenderingIconIdFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for NodeRendering.IconId field
		/// </summary>
		private static NodeRenderingIconIdFieldHandler	nodeRenderingIconIdFieldHandler	= NodeRenderingIconIdFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for NodeRendering.IconId
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class NodeRenderingIconIdFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private NodeRenderingIconIdFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the NodeRendering.IconId field handler
			/// </summary>
			/// <value>NodeRenderingIconIdFieldHandler</value>
			public static NodeRenderingIconIdFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.nodeRenderingIconIdFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.nodeRenderingIconIdFieldHandler;
					}
					else
					{
						// The static constructor in NodeRendering will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.nodeRenderingIconIdFieldHandler, so just instantiate one and return it
						return new NodeRenderingIconIdFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the NodeRendering.IconId field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.IconIdMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the NodeRendering</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering element)
			{
				return element.iconIdPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.iconIdPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.iconIdPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region NodeRendering's Generated Constructor Code
	public  partial class NodeRendering
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public NodeRendering(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static NodeRendering CreateNodeRendering(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateNodeRendering(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static NodeRendering CreateAndInitializeNodeRendering(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeNodeRendering(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public NodeRendering(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static NodeRendering CreateNodeRendering(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (NodeRendering)partition.ElementFactory.CreateElement(typeof(NodeRendering));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static NodeRendering CreateAndInitializeNodeRendering(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (NodeRendering)partition.ElementFactory.CreateElement(typeof(NodeRendering), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for NodeRendering
	/// <summary>
	/// NodeRendering Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering))]
	public sealed class NodeRenderingElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public NodeRenderingElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static NodeRenderingElementFactoryCreator Instance
		{
			get
			{
				return new NodeRenderingElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.MetaClassGuidString, "ClassNodeRendering")]
	public  partial class ClassNodeRendering : Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering
	{
		#region ClassNodeRendering's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "effbaccc-31a5-428a-ac2f-4cd6fbcac0be";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.MetaClassGuidString);
		#endregion

		#region AppendClassNameToCaption's Generated  Field Code
		#region AppendClassNameToCaption's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String AppendClassNameToCaptionMetaAttributeGuidString = "2627af4e-9795-4f28-9a12-3df4295cca4b";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid AppendClassNameToCaptionMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.AppendClassNameToCaptionMetaAttributeGuidString);
		#endregion

		#region AppendClassNameToCaption's Generated Property Code

		private System.Boolean appendClassNameToCaptionPropertyStorage = false;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean=false)]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ClassNodeRenderingAppendClassNameToCaptionFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.AppendClassNameToCaptionMetaAttributeGuidString, "ClassNodeRendering.AppendClassNameToCaption")]
		public  System.Boolean AppendClassNameToCaption
		{
			get
			{
				return appendClassNameToCaptionPropertyStorage;
			}
		
			set
			{
				classNodeRenderingAppendClassNameToCaptionFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ClassNodeRenderingAppendClassNameToCaptionFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ClassNodeRendering.AppendClassNameToCaption field
		/// </summary>
		private static ClassNodeRenderingAppendClassNameToCaptionFieldHandler	classNodeRenderingAppendClassNameToCaptionFieldHandler	= ClassNodeRenderingAppendClassNameToCaptionFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ClassNodeRendering.AppendClassNameToCaption
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ClassNodeRenderingAppendClassNameToCaptionFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering,System.Boolean>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ClassNodeRenderingAppendClassNameToCaptionFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ClassNodeRendering.AppendClassNameToCaption field handler
			/// </summary>
			/// <value>ClassNodeRenderingAppendClassNameToCaptionFieldHandler</value>
			public static ClassNodeRenderingAppendClassNameToCaptionFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.classNodeRenderingAppendClassNameToCaptionFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.classNodeRenderingAppendClassNameToCaptionFieldHandler;
					}
					else
					{
						// The static constructor in ClassNodeRendering will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.classNodeRenderingAppendClassNameToCaptionFieldHandler, so just instantiate one and return it
						return new ClassNodeRenderingAppendClassNameToCaptionFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ClassNodeRendering.AppendClassNameToCaption field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.AppendClassNameToCaptionMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ClassNodeRendering</param>
			protected sealed override System.Boolean GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering element)
			{
				return element.appendClassNameToCaptionPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering element, System.Boolean value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.Boolean oldValue)
			{
				oldValue = element.appendClassNameToCaptionPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.appendClassNameToCaptionPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region Class's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept Class
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassNodeRenderingMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassMetaRoleGuid, false) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassNodeRenderingMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassNodeRenderingMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for ClassNodeRendering
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ClassNodeRenderingMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ClassNodeRenderingMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ClassNodeRendering's Generated Constructor Code
	public  partial class ClassNodeRendering
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ClassNodeRendering(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ClassNodeRendering CreateClassNodeRendering(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateClassNodeRendering(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ClassNodeRendering CreateAndInitializeClassNodeRendering(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeClassNodeRendering(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ClassNodeRendering(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ClassNodeRendering CreateClassNodeRendering(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ClassNodeRendering)partition.ElementFactory.CreateElement(typeof(ClassNodeRendering));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ClassNodeRendering CreateAndInitializeClassNodeRendering(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ClassNodeRendering)partition.ElementFactory.CreateElement(typeof(ClassNodeRendering), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ClassNodeRendering
	/// <summary>
	/// ClassNodeRendering Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering))]
	public sealed class ClassNodeRenderingElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ClassNodeRenderingElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ClassNodeRenderingElementFactoryCreator Instance
		{
			get
			{
				return new ClassNodeRenderingElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Description("CollectionNodeRenderingDescription", typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel), Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.ResourceBaseName)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.MetaClassGuidString, "CollectionNodeRendering")]
	public  partial class CollectionNodeRendering : Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering
	{
		#region CollectionNodeRendering's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "ae94a1bd-e622-493b-b1dd-1a3a9f87c8af";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.MetaClassGuidString);
		#endregion

		#region CaptionId's Generated  Field Code
		#region CaptionId's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String CaptionIdMetaAttributeGuidString = "a9ec4fe4-81a7-4dfb-af13-d6aa335021bc";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid CaptionIdMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.CaptionIdMetaAttributeGuidString);
		#endregion

		#region CaptionId's Generated Property Code

		private System.String captionIdPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(CollectionNodeRenderingCaptionIdFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.CaptionIdMetaAttributeGuidString, "CollectionNodeRendering.CaptionId")]
		public  System.String CaptionId
		{
			get
			{
				return captionIdPropertyStorage;
			}
		
			set
			{
				collectionNodeRenderingCaptionIdFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region CollectionNodeRenderingCaptionIdFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for CollectionNodeRendering.CaptionId field
		/// </summary>
		private static CollectionNodeRenderingCaptionIdFieldHandler	collectionNodeRenderingCaptionIdFieldHandler	= CollectionNodeRenderingCaptionIdFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for CollectionNodeRendering.CaptionId
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class CollectionNodeRenderingCaptionIdFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private CollectionNodeRenderingCaptionIdFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the CollectionNodeRendering.CaptionId field handler
			/// </summary>
			/// <value>CollectionNodeRenderingCaptionIdFieldHandler</value>
			public static CollectionNodeRenderingCaptionIdFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.collectionNodeRenderingCaptionIdFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.collectionNodeRenderingCaptionIdFieldHandler;
					}
					else
					{
						// The static constructor in CollectionNodeRendering will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.collectionNodeRenderingCaptionIdFieldHandler, so just instantiate one and return it
						return new CollectionNodeRenderingCaptionIdFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the CollectionNodeRendering.CaptionId field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.CaptionIdMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the CollectionNodeRendering</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering element)
			{
				return element.captionIdPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.captionIdPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.captionIdPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region CollectionNodeRendering's Generated Constructor Code
	public  partial class CollectionNodeRendering
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public CollectionNodeRendering(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CollectionNodeRendering CreateCollectionNodeRendering(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateCollectionNodeRendering(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CollectionNodeRendering CreateAndInitializeCollectionNodeRendering(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeCollectionNodeRendering(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public CollectionNodeRendering(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CollectionNodeRendering CreateCollectionNodeRendering(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (CollectionNodeRendering)partition.ElementFactory.CreateElement(typeof(CollectionNodeRendering));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CollectionNodeRendering CreateAndInitializeCollectionNodeRendering(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (CollectionNodeRendering)partition.ElementFactory.CreateElement(typeof(CollectionNodeRendering), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for CollectionNodeRendering
	/// <summary>
	/// CollectionNodeRendering Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering))]
	public sealed class CollectionNodeRenderingElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public CollectionNodeRenderingElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static CollectionNodeRenderingElementFactoryCreator Instance
		{
			get
			{
				return new CollectionNodeRenderingElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape.MetaClassGuidString, "Shape")]
	public  partial class Shape : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region Shape's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "e34e57c8-719f-496c-9816-4e6b8141e9e2";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape.MetaClassGuidString);
		#endregion

		#region Decorators's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorMoveableCollection Decorators
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.ShapeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.DecoratorsMetaRoleGuid); }
		}
		#endregion
	}
	#region Collection Classes for Shape
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ShapeMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ShapeMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region Shape's Generated Constructor Code
	public  partial class Shape
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public Shape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Shape CreateShape(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateShape(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Shape CreateAndInitializeShape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeShape(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public Shape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Shape CreateShape(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (Shape)partition.ElementFactory.CreateElement(typeof(Shape));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Shape CreateAndInitializeShape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (Shape)partition.ElementFactory.CreateElement(typeof(Shape), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for Shape
	/// <summary>
	/// Shape Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape))]
	public sealed class ShapeElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ShapeElementFactoryCreator Instance
		{
			get
			{
				return new ShapeElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.MetaClassGuidString, "OutlinedShape")]
	public  partial class OutlinedShape : Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape
	{
		#region OutlinedShape's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "7ee2c579-be66-4d3b-a73d-e955d01da083";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.MetaClassGuidString);
		#endregion

		#region InitialWidth's Generated  Field Code
		#region InitialWidth's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String InitialWidthMetaAttributeGuidString = "7b894222-bdd9-4c0a-b325-3c2ca060c25b";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid InitialWidthMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialWidthMetaAttributeGuidString);
		#endregion

		#region InitialWidth's Generated Property Code

		private System.Double initialWidthPropertyStorage = 0;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.DoubleDomainAttribute(MinValue=-1.79769313486232E+307,MaxValue=1.79769313486232E+307)]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(OutlinedShapeInitialWidthFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialWidthMetaAttributeGuidString, "OutlinedShape.InitialWidth")]
		public  System.Double InitialWidth
		{
			get
			{
				return initialWidthPropertyStorage;
			}
		
			set
			{
				outlinedShapeInitialWidthFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region OutlinedShapeInitialWidthFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for OutlinedShape.InitialWidth field
		/// </summary>
		private static OutlinedShapeInitialWidthFieldHandler	outlinedShapeInitialWidthFieldHandler	= OutlinedShapeInitialWidthFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for OutlinedShape.InitialWidth
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class OutlinedShapeInitialWidthFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape,System.Double>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private OutlinedShapeInitialWidthFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the OutlinedShape.InitialWidth field handler
			/// </summary>
			/// <value>OutlinedShapeInitialWidthFieldHandler</value>
			public static OutlinedShapeInitialWidthFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialWidthFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialWidthFieldHandler;
					}
					else
					{
						// The static constructor in OutlinedShape will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialWidthFieldHandler, so just instantiate one and return it
						return new OutlinedShapeInitialWidthFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the OutlinedShape.InitialWidth field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialWidthMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the OutlinedShape</param>
			protected sealed override System.Double GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape element)
			{
				return element.initialWidthPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape element, System.Double value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.Double oldValue)
			{
				oldValue = element.initialWidthPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.initialWidthPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region InitialHeight's Generated  Field Code
		#region InitialHeight's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String InitialHeightMetaAttributeGuidString = "58a1f843-ab41-43b7-826c-9af13e5a22b9";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid InitialHeightMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialHeightMetaAttributeGuidString);
		#endregion

		#region InitialHeight's Generated Property Code

		private System.Double initialHeightPropertyStorage = 0;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.DoubleDomainAttribute(MinValue=-1.79769313486232E+307,MaxValue=1.79769313486232E+307)]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(OutlinedShapeInitialHeightFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialHeightMetaAttributeGuidString, "OutlinedShape.InitialHeight")]
		public  System.Double InitialHeight
		{
			get
			{
				return initialHeightPropertyStorage;
			}
		
			set
			{
				outlinedShapeInitialHeightFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region OutlinedShapeInitialHeightFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for OutlinedShape.InitialHeight field
		/// </summary>
		private static OutlinedShapeInitialHeightFieldHandler	outlinedShapeInitialHeightFieldHandler	= OutlinedShapeInitialHeightFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for OutlinedShape.InitialHeight
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class OutlinedShapeInitialHeightFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape,System.Double>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private OutlinedShapeInitialHeightFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the OutlinedShape.InitialHeight field handler
			/// </summary>
			/// <value>OutlinedShapeInitialHeightFieldHandler</value>
			public static OutlinedShapeInitialHeightFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialHeightFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialHeightFieldHandler;
					}
					else
					{
						// The static constructor in OutlinedShape will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialHeightFieldHandler, so just instantiate one and return it
						return new OutlinedShapeInitialHeightFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the OutlinedShape.InitialHeight field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialHeightMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the OutlinedShape</param>
			protected sealed override System.Double GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape element)
			{
				return element.initialHeightPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape element, System.Double value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.Double oldValue)
			{
				oldValue = element.initialHeightPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.initialHeightPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region FillColor's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails FillColor
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.ShapeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.ShapeMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.ShapeMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor), newRoles);
				}
			}
		}
		#endregion
		#region OutlineColor's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails OutlineColor
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlinedShapeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlinedShapeMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlinedShapeMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor), newRoles);
				}
			}
		}
		#endregion
	}
	#region OutlinedShape's Generated Constructor Code
	public  partial class OutlinedShape
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public OutlinedShape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static OutlinedShape CreateOutlinedShape(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateOutlinedShape(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static OutlinedShape CreateAndInitializeOutlinedShape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeOutlinedShape(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public OutlinedShape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static OutlinedShape CreateOutlinedShape(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (OutlinedShape)partition.ElementFactory.CreateElement(typeof(OutlinedShape));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static OutlinedShape CreateAndInitializeOutlinedShape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (OutlinedShape)partition.ElementFactory.CreateElement(typeof(OutlinedShape), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for OutlinedShape
	/// <summary>
	/// OutlinedShape Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape))]
	public sealed class OutlinedShapeElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public OutlinedShapeElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static OutlinedShapeElementFactoryCreator Instance
		{
			get
			{
				return new OutlinedShapeElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.MetaClassGuidString, "CompartmentShape")]
	public  partial class CompartmentShape : Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape
	{
		#region CompartmentShape's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "c2e8313e-721e-4b5e-a6ff-edd28913d277";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.MetaClassGuidString);
		#endregion

		#region Geometry's Generated  Field Code
		#region Geometry's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String GeometryMetaAttributeGuidString = "e36d34b4-e96e-465c-b6f1-18530b47e975";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid GeometryMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.GeometryMetaAttributeGuidString);
		#endregion

		#region Geometry's Generated Property Code

		private Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry geometryPropertyStorage = Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry.Rectangle;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType=typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry),DefaultEnumerationValueName="Rectangle")]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(CompartmentShapeGeometryFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.GeometryMetaAttributeGuidString, "CompartmentShape.Geometry")]
		public  Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry Geometry
		{
			get
			{
				return geometryPropertyStorage;
			}
		
			set
			{
				compartmentShapeGeometryFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region CompartmentShapeGeometryFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for CompartmentShape.Geometry field
		/// </summary>
		private static CompartmentShapeGeometryFieldHandler	compartmentShapeGeometryFieldHandler	= CompartmentShapeGeometryFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for CompartmentShape.Geometry
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class CompartmentShapeGeometryFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape,Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private CompartmentShapeGeometryFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the CompartmentShape.Geometry field handler
			/// </summary>
			/// <value>CompartmentShapeGeometryFieldHandler</value>
			public static CompartmentShapeGeometryFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeGeometryFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeGeometryFieldHandler;
					}
					else
					{
						// The static constructor in CompartmentShape will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeGeometryFieldHandler, so just instantiate one and return it
						return new CompartmentShapeGeometryFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the CompartmentShape.Geometry field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.GeometryMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the CompartmentShape</param>
			protected sealed override Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape element)
			{
				return element.geometryPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape element, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry oldValue)
			{
				oldValue = element.geometryPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.geometryPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region IsSingleCompartmentHeaderVisible's Generated  Field Code
		#region IsSingleCompartmentHeaderVisible's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String IsSingleCompartmentHeaderVisibleMetaAttributeGuidString = "70776980-d542-46a9-8f48-9b9627fa4457";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid IsSingleCompartmentHeaderVisibleMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.IsSingleCompartmentHeaderVisibleMetaAttributeGuidString);
		#endregion

		#region IsSingleCompartmentHeaderVisible's Generated Property Code

		private System.Boolean isSingleCompartmentHeaderVisiblePropertyStorage = true;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean=true)]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.IsSingleCompartmentHeaderVisibleMetaAttributeGuidString, "CompartmentShape.IsSingleCompartmentHeaderVisible")]
		public  System.Boolean IsSingleCompartmentHeaderVisible
		{
			get
			{
				return isSingleCompartmentHeaderVisiblePropertyStorage;
			}
		
			set
			{
				compartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for CompartmentShape.IsSingleCompartmentHeaderVisible field
		/// </summary>
		private static CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler	compartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler	= CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for CompartmentShape.IsSingleCompartmentHeaderVisible
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape,System.Boolean>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the CompartmentShape.IsSingleCompartmentHeaderVisible field handler
			/// </summary>
			/// <value>CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler</value>
			public static CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler;
					}
					else
					{
						// The static constructor in CompartmentShape will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler, so just instantiate one and return it
						return new CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the CompartmentShape.IsSingleCompartmentHeaderVisible field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.IsSingleCompartmentHeaderVisibleMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the CompartmentShape</param>
			protected sealed override System.Boolean GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape element)
			{
				return element.isSingleCompartmentHeaderVisiblePropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape element, System.Boolean value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.Boolean oldValue)
			{
				oldValue = element.isSingleCompartmentHeaderVisiblePropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.isSingleCompartmentHeaderVisiblePropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region Compartments's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMoveableCollection Compartments
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentShapeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentsMetaRoleGuid); }
		}
		#endregion
	}
	#region CompartmentShape's Generated Constructor Code
	public  partial class CompartmentShape
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public CompartmentShape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CompartmentShape CreateCompartmentShape(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateCompartmentShape(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CompartmentShape CreateAndInitializeCompartmentShape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeCompartmentShape(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public CompartmentShape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CompartmentShape CreateCompartmentShape(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (CompartmentShape)partition.ElementFactory.CreateElement(typeof(CompartmentShape));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static CompartmentShape CreateAndInitializeCompartmentShape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (CompartmentShape)partition.ElementFactory.CreateElement(typeof(CompartmentShape), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for CompartmentShape
	/// <summary>
	/// CompartmentShape Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape))]
	public sealed class CompartmentShapeElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public CompartmentShapeElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static CompartmentShapeElementFactoryCreator Instance
		{
			get
			{
				return new CompartmentShapeElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.MetaClassGuidString, "GeometryShape")]
	public  partial class GeometryShape : Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape
	{
		#region GeometryShape's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "d55a03a6-9ff7-43f4-a43a-a92b01ca9a59";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.MetaClassGuidString);
		#endregion

		#region Geometry's Generated  Field Code
		#region Geometry's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String GeometryMetaAttributeGuidString = "c5313341-3475-4076-bf06-9debff59f5c7";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid GeometryMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.GeometryMetaAttributeGuidString);
		#endregion

		#region Geometry's Generated Property Code

		private Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry geometryPropertyStorage = Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry.Rectangle;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType=typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry),DefaultEnumerationValueName="Rectangle")]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(GeometryShapeGeometryFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.GeometryMetaAttributeGuidString, "GeometryShape.Geometry")]
		public  Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry Geometry
		{
			get
			{
				return geometryPropertyStorage;
			}
		
			set
			{
				geometryShapeGeometryFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region GeometryShapeGeometryFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for GeometryShape.Geometry field
		/// </summary>
		private static GeometryShapeGeometryFieldHandler	geometryShapeGeometryFieldHandler	= GeometryShapeGeometryFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for GeometryShape.Geometry
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class GeometryShapeGeometryFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape,Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private GeometryShapeGeometryFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the GeometryShape.Geometry field handler
			/// </summary>
			/// <value>GeometryShapeGeometryFieldHandler</value>
			public static GeometryShapeGeometryFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.geometryShapeGeometryFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.geometryShapeGeometryFieldHandler;
					}
					else
					{
						// The static constructor in GeometryShape will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.geometryShapeGeometryFieldHandler, so just instantiate one and return it
						return new GeometryShapeGeometryFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the GeometryShape.Geometry field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.GeometryMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the GeometryShape</param>
			protected sealed override Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape element)
			{
				return element.geometryPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape element, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry oldValue)
			{
				oldValue = element.geometryPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.geometryPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region GeometryShape's Generated Constructor Code
	public  partial class GeometryShape
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public GeometryShape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static GeometryShape CreateGeometryShape(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateGeometryShape(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static GeometryShape CreateAndInitializeGeometryShape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeGeometryShape(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public GeometryShape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static GeometryShape CreateGeometryShape(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (GeometryShape)partition.ElementFactory.CreateElement(typeof(GeometryShape));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static GeometryShape CreateAndInitializeGeometryShape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (GeometryShape)partition.ElementFactory.CreateElement(typeof(GeometryShape), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for GeometryShape
	/// <summary>
	/// GeometryShape Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape))]
	public sealed class GeometryShapeElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public GeometryShapeElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static GeometryShapeElementFactoryCreator Instance
		{
			get
			{
				return new GeometryShapeElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.MetaClassGuidString, "PathShape")]
	public  partial class PathShape : Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape
	{
		#region PathShape's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "88fa85a2-8823-4f9a-960e-9bdeb3ec32b9";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.MetaClassGuidString);
		#endregion

		#region Path's Generated  Field Code
		#region Path's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String PathMetaAttributeGuidString = "540ac62e-2348-4335-b52c-3dd2d4dd6f5d";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid PathMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.PathMetaAttributeGuidString);
		#endregion

		#region Path's Generated Property Code

		private System.String pathPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(PathShapePathFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.PathMetaAttributeGuidString, "PathShape.Path")]
		public  System.String Path
		{
			get
			{
				return pathPropertyStorage;
			}
		
			set
			{
				pathShapePathFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region PathShapePathFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for PathShape.Path field
		/// </summary>
		private static PathShapePathFieldHandler	pathShapePathFieldHandler	= PathShapePathFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for PathShape.Path
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class PathShapePathFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private PathShapePathFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the PathShape.Path field handler
			/// </summary>
			/// <value>PathShapePathFieldHandler</value>
			public static PathShapePathFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.pathShapePathFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.pathShapePathFieldHandler;
					}
					else
					{
						// The static constructor in PathShape will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.pathShapePathFieldHandler, so just instantiate one and return it
						return new PathShapePathFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the PathShape.Path field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.PathMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the PathShape</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape element)
			{
				return element.pathPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.pathPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.pathPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region PathShape's Generated Constructor Code
	public  partial class PathShape
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public PathShape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PathShape CreatePathShape(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreatePathShape(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PathShape CreateAndInitializePathShape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializePathShape(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public PathShape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PathShape CreatePathShape(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (PathShape)partition.ElementFactory.CreateElement(typeof(PathShape));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static PathShape CreateAndInitializePathShape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (PathShape)partition.ElementFactory.CreateElement(typeof(PathShape), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for PathShape
	/// <summary>
	/// PathShape Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape))]
	public sealed class PathShapeElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public PathShapeElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static PathShapeElementFactoryCreator Instance
		{
			get
			{
				return new PathShapeElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.MetaClassGuidString, "ImageShape")]
	public  partial class ImageShape : Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape
	{
		#region ImageShape's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "2fd998d7-a283-488c-b419-36fb9499ea6d";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.MetaClassGuidString);
		#endregion

		#region ImageId's Generated  Field Code
		#region ImageId's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String ImageIdMetaAttributeGuidString = "80af3308-7aee-49a4-8988-62c0fde35266";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid ImageIdMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.ImageIdMetaAttributeGuidString);
		#endregion

		#region ImageId's Generated Property Code

		private System.String imageIdPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ImageShapeImageIdFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.ImageIdMetaAttributeGuidString, "ImageShape.ImageId")]
		public  System.String ImageId
		{
			get
			{
				return imageIdPropertyStorage;
			}
		
			set
			{
				imageShapeImageIdFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ImageShapeImageIdFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ImageShape.ImageId field
		/// </summary>
		private static ImageShapeImageIdFieldHandler	imageShapeImageIdFieldHandler	= ImageShapeImageIdFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ImageShape.ImageId
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ImageShapeImageIdFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ImageShapeImageIdFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ImageShape.ImageId field handler
			/// </summary>
			/// <value>ImageShapeImageIdFieldHandler</value>
			public static ImageShapeImageIdFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.imageShapeImageIdFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.imageShapeImageIdFieldHandler;
					}
					else
					{
						// The static constructor in ImageShape will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.imageShapeImageIdFieldHandler, so just instantiate one and return it
						return new ImageShapeImageIdFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ImageShape.ImageId field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.ImageIdMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ImageShape</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape element)
			{
				return element.imageIdPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.imageIdPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.imageIdPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
	}
	#region ImageShape's Generated Constructor Code
	public  partial class ImageShape
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ImageShape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ImageShape CreateImageShape(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateImageShape(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ImageShape CreateAndInitializeImageShape(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeImageShape(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ImageShape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ImageShape CreateImageShape(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ImageShape)partition.ElementFactory.CreateElement(typeof(ImageShape));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ImageShape CreateAndInitializeImageShape(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ImageShape)partition.ElementFactory.CreateElement(typeof(ImageShape), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ImageShape
	/// <summary>
	/// ImageShape Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape))]
	public sealed class ImageShapeElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ImageShapeElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ImageShapeElementFactoryCreator Instance
		{
			get
			{
				return new ImageShapeElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.MetaClassGuidString, "Compartment")]
	public  partial class Compartment : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region Compartment's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "847c56b8-80a4-48e5-ba45-191742b3951f";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.MetaClassGuidString);
		#endregion

		#region CaptionId's Generated  Field Code
		#region CaptionId's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String CaptionIdMetaAttributeGuidString = "d3b8d6da-f6e8-4a43-8c86-9c9c1f20d076";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid CaptionIdMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.CaptionIdMetaAttributeGuidString);
		#endregion

		#region CaptionId's Generated Property Code

		private System.String captionIdPropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(CompartmentCaptionIdFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.CaptionIdMetaAttributeGuidString, "Compartment.CaptionId")]
		public  System.String CaptionId
		{
			get
			{
				return captionIdPropertyStorage;
			}
		
			set
			{
				compartmentCaptionIdFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region CompartmentCaptionIdFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for Compartment.CaptionId field
		/// </summary>
		private static CompartmentCaptionIdFieldHandler	compartmentCaptionIdFieldHandler	= CompartmentCaptionIdFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for Compartment.CaptionId
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class CompartmentCaptionIdFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private CompartmentCaptionIdFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the Compartment.CaptionId field handler
			/// </summary>
			/// <value>CompartmentCaptionIdFieldHandler</value>
			public static CompartmentCaptionIdFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.compartmentCaptionIdFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.compartmentCaptionIdFieldHandler;
					}
					else
					{
						// The static constructor in Compartment will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.compartmentCaptionIdFieldHandler, so just instantiate one and return it
						return new CompartmentCaptionIdFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the Compartment.CaptionId field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.CaptionIdMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the Compartment</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment element)
			{
				return element.captionIdPropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.captionIdPropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.captionIdPropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region CompartmentFillColor's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails CompartmentFillColor
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor), newRoles);
				}
			}
		}
		#endregion
		#region TitleFillColor's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails TitleFillColor
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.CompartmentMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.CompartmentMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.CompartmentMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for Compartment
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class CompartmentMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public CompartmentMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region Compartment's Generated Constructor Code
	public  partial class Compartment
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public Compartment(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Compartment CreateCompartment(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateCompartment(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Compartment CreateAndInitializeCompartment(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeCompartment(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public Compartment(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Compartment CreateCompartment(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (Compartment)partition.ElementFactory.CreateElement(typeof(Compartment));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static Compartment CreateAndInitializeCompartment(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (Compartment)partition.ElementFactory.CreateElement(typeof(Compartment), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for Compartment
	/// <summary>
	/// Compartment Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment))]
	public sealed class CompartmentElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public CompartmentElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static CompartmentElementFactoryCreator Instance
		{
			get
			{
				return new CompartmentElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment.MetaClassGuidString, "ListCompartment")]
	public  partial class ListCompartment : Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment
	{
		#region ListCompartment's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "fb230165-ac1f-43f9-a772-4988121a105e";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment.MetaClassGuidString);
		#endregion

	}
	#region ListCompartment's Generated Constructor Code
	public  partial class ListCompartment
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ListCompartment(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ListCompartment CreateListCompartment(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateListCompartment(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ListCompartment CreateAndInitializeListCompartment(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeListCompartment(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ListCompartment(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ListCompartment CreateListCompartment(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ListCompartment)partition.ElementFactory.CreateElement(typeof(ListCompartment));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ListCompartment CreateAndInitializeListCompartment(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ListCompartment)partition.ElementFactory.CreateElement(typeof(ListCompartment), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ListCompartment
	/// <summary>
	/// ListCompartment Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment))]
	public sealed class ListCompartmentElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ListCompartmentElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ListCompartmentElementFactoryCreator Instance
		{
			get
			{
				return new ListCompartmentElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap.MetaClassGuidString, "ConnectorMap")]
	public  partial class ConnectorMap : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ConnectorMap's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "bbb28f3c-7285-4019-9fd7-7846debc14fd";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap.MetaClassGuidString);
		#endregion

		#region TextMaps's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapMoveableCollection TextMaps
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.TextMapsMetaRoleGuid); }
		}
		#endregion
		#region Class's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlReferenceType Class
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ClassMetaRoleGuid, false) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlReferenceType;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ConnectorMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ClassMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlReferenceType counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlReferenceType;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ClassMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ConnectorMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass), newRoles);
				}
			}
		}
		#endregion
		#region Connector's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector Connector
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector), newRoles);
				}
			}
		}
		#endregion
		#region IconMaps's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMapMoveableCollection IconMaps
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMapMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.IconMapsMetaRoleGuid); }
		}
		#endregion
		#region SourceMap's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap SourceMap
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.ConnectorMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.ConnectorMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap), newRoles);
				}
			}
		}
		#endregion
		#region TargetMap's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap TargetMap
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.ConnectorMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.ConnectorMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for ConnectorMap
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ConnectorMapMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ConnectorMapMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ConnectorMap's Generated Constructor Code
	public  partial class ConnectorMap
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorMap CreateConnectorMap(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateConnectorMap(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorMap CreateAndInitializeConnectorMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeConnectorMap(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorMap CreateConnectorMap(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ConnectorMap)partition.ElementFactory.CreateElement(typeof(ConnectorMap));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorMap CreateAndInitializeConnectorMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ConnectorMap)partition.ElementFactory.CreateElement(typeof(ConnectorMap), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ConnectorMap
	/// <summary>
	/// ConnectorMap Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap))]
	public sealed class ConnectorMapElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorMapElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ConnectorMapElementFactoryCreator Instance
		{
			get
			{
				return new ConnectorMapElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap.MetaClassGuidString, "ShapeIconMap")]
	public  partial class ShapeIconMap : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ShapeIconMap's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "e5e016c5-3ecc-472f-b2a7-9f157cf301b6";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap.MetaClassGuidString);
		#endregion

		#region IconDecorator's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon IconDecorator
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon), newRoles);
				}
			}
		}
		#endregion
		#region VisibilityExpression's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.BooleanExpression VisibilityExpression
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.ShapeIconMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.BooleanExpression;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.ShapeIconMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.BooleanExpression counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.BooleanExpression;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.ShapeIconMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for ShapeIconMap
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ShapeIconMapMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ShapeIconMapMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ShapeIconMap's Generated Constructor Code
	public  partial class ShapeIconMap
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeIconMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeIconMap CreateShapeIconMap(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateShapeIconMap(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeIconMap CreateAndInitializeShapeIconMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeShapeIconMap(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeIconMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeIconMap CreateShapeIconMap(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ShapeIconMap)partition.ElementFactory.CreateElement(typeof(ShapeIconMap));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ShapeIconMap CreateAndInitializeShapeIconMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ShapeIconMap)partition.ElementFactory.CreateElement(typeof(ShapeIconMap), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ShapeIconMap
	/// <summary>
	/// ShapeIconMap Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap))]
	public sealed class ShapeIconMapElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ShapeIconMapElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ShapeIconMapElementFactoryCreator Instance
		{
			get
			{
				return new ShapeIconMapElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap.MetaClassGuidString, "ConnectorTextMap")]
	public  partial class ConnectorTextMap : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ConnectorTextMap's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "a5316d6a-41e7-4805-ace6-d7d4ad1cf84d";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap.MetaClassGuidString);
		#endregion

		#region TextDecorator's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText TextDecorator
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.ConnectorTextMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.TextDecoratorMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.ConnectorTextMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.TextDecoratorMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.TextDecoratorMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.ConnectorTextMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator), newRoles);
				}
			}
		}
		#endregion
		#region ValueExpression's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression ValueExpression
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ConnectorTextMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ConnectorTextMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ConnectorTextMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for ConnectorTextMap
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ConnectorTextMapMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ConnectorTextMapMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ConnectorTextMap's Generated Constructor Code
	public  partial class ConnectorTextMap
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorTextMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorTextMap CreateConnectorTextMap(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateConnectorTextMap(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorTextMap CreateAndInitializeConnectorTextMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeConnectorTextMap(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorTextMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorTextMap CreateConnectorTextMap(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ConnectorTextMap)partition.ElementFactory.CreateElement(typeof(ConnectorTextMap));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorTextMap CreateAndInitializeConnectorTextMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ConnectorTextMap)partition.ElementFactory.CreateElement(typeof(ConnectorTextMap), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ConnectorTextMap
	/// <summary>
	/// ConnectorTextMap Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap))]
	public sealed class ConnectorTextMapElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorTextMapElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ConnectorTextMapElementFactoryCreator Instance
		{
			get
			{
				return new ConnectorTextMapElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap.MetaClassGuidString, "ConnectorIconMap")]
	public  partial class ConnectorIconMap : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ConnectorIconMap's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "9092849f-6f1b-4d4d-aa4d-7b4ae5fe4ea7";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap.MetaClassGuidString);
		#endregion

	}
	#region Collection Classes for ConnectorIconMap
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ConnectorIconMapMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ConnectorIconMapMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ConnectorIconMap's Generated Constructor Code
	public  partial class ConnectorIconMap
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorIconMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorIconMap CreateConnectorIconMap(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateConnectorIconMap(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorIconMap CreateAndInitializeConnectorIconMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeConnectorIconMap(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorIconMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorIconMap CreateConnectorIconMap(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ConnectorIconMap)partition.ElementFactory.CreateElement(typeof(ConnectorIconMap));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorIconMap CreateAndInitializeConnectorIconMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ConnectorIconMap)partition.ElementFactory.CreateElement(typeof(ConnectorIconMap), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ConnectorIconMap
	/// <summary>
	/// ConnectorIconMap Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap))]
	public sealed class ConnectorIconMapElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorIconMapElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ConnectorIconMapElementFactoryCreator Instance
		{
			get
			{
				return new ConnectorIconMapElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap.MetaClassGuidString, "SourceMap")]
	public  partial class SourceMap : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region SourceMap's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "bf110281-98d4-4efb-a119-340b6c10bc90";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap.MetaClassGuidString);
		#endregion

		#region ModelNavigationExpression's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression ModelNavigationExpression
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.SourceMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.SourceMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.SourceMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression), newRoles);
				}
			}
		}
		#endregion
	}
	#region SourceMap's Generated Constructor Code
	public  partial class SourceMap
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public SourceMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static SourceMap CreateSourceMap(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateSourceMap(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static SourceMap CreateAndInitializeSourceMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeSourceMap(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public SourceMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static SourceMap CreateSourceMap(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (SourceMap)partition.ElementFactory.CreateElement(typeof(SourceMap));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static SourceMap CreateAndInitializeSourceMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (SourceMap)partition.ElementFactory.CreateElement(typeof(SourceMap), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for SourceMap
	/// <summary>
	/// SourceMap Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap))]
	public sealed class SourceMapElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public SourceMapElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static SourceMapElementFactoryCreator Instance
		{
			get
			{
				return new SourceMapElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap.MetaClassGuidString, "TargetMap")]
	public  partial class TargetMap : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region TargetMap's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "9daa3725-e189-4c20-934e-756cd6dfe6ae";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap.MetaClassGuidString);
		#endregion

		#region ModelNavigationExpression's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression ModelNavigationExpression
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.TargetMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid, false) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.TargetMapMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.TargetMapMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression), newRoles);
				}
			}
		}
		#endregion
	}
	#region TargetMap's Generated Constructor Code
	public  partial class TargetMap
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public TargetMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static TargetMap CreateTargetMap(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateTargetMap(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static TargetMap CreateAndInitializeTargetMap(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeTargetMap(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public TargetMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static TargetMap CreateTargetMap(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (TargetMap)partition.ElementFactory.CreateElement(typeof(TargetMap));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static TargetMap CreateAndInitializeTargetMap(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (TargetMap)partition.ElementFactory.CreateElement(typeof(TargetMap), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for TargetMap
	/// <summary>
	/// TargetMap Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap))]
	public sealed class TargetMapElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public TargetMapElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static TargetMapElementFactoryCreator Instance
		{
			get
			{
				return new TargetMapElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.MetaClassGuidString, "ConnectorEnd")]
	public  partial class ConnectorEnd : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ConnectorEnd's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "38b7173c-d645-4580-8568-582c94a2cf78";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.MetaClassGuidString);
		#endregion

		#region ArrowStyle's Generated  Field Code
		#region ArrowStyle's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String ArrowStyleMetaAttributeGuidString = "ea0fea73-fe43-4bd4-b6e7-a0287600fec7";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid ArrowStyleMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.ArrowStyleMetaAttributeGuidString);
		#endregion

		#region ArrowStyle's Generated Property Code

		private Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorArrowStyle arrowStylePropertyStorage = Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorArrowStyle.None;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType=typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorArrowStyle),DefaultEnumerationValueName="None")]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ConnectorEndArrowStyleFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.ArrowStyleMetaAttributeGuidString, "ConnectorEnd.ArrowStyle")]
		public  Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorArrowStyle ArrowStyle
		{
			get
			{
				return arrowStylePropertyStorage;
			}
		
			set
			{
				connectorEndArrowStyleFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ConnectorEndArrowStyleFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ConnectorEnd.ArrowStyle field
		/// </summary>
		private static ConnectorEndArrowStyleFieldHandler	connectorEndArrowStyleFieldHandler	= ConnectorEndArrowStyleFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ConnectorEnd.ArrowStyle
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ConnectorEndArrowStyleFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd,Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorArrowStyle>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ConnectorEndArrowStyleFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ConnectorEnd.ArrowStyle field handler
			/// </summary>
			/// <value>ConnectorEndArrowStyleFieldHandler</value>
			public static ConnectorEndArrowStyleFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.connectorEndArrowStyleFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.connectorEndArrowStyleFieldHandler;
					}
					else
					{
						// The static constructor in ConnectorEnd will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.connectorEndArrowStyleFieldHandler, so just instantiate one and return it
						return new ConnectorEndArrowStyleFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ConnectorEnd.ArrowStyle field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.ArrowStyleMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ConnectorEnd</param>
			protected sealed override Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorArrowStyle GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd element)
			{
				return element.arrowStylePropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd element, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorArrowStyle value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorArrowStyle oldValue)
			{
				oldValue = element.arrowStylePropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.arrowStylePropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region PermittedShapes's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMoveableCollection PermittedShapes
		{
			get { return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMoveableCollection(this, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape.ConnectorEndMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape.PermittedShapesMetaRoleGuid); }
		}
		#endregion
	}
	#region Collection Classes for ConnectorEnd
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ConnectorEndMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ConnectorEndMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ConnectorEnd's Generated Constructor Code
	public  partial class ConnectorEnd
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorEnd(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorEnd CreateConnectorEnd(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateConnectorEnd(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorEnd CreateAndInitializeConnectorEnd(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeConnectorEnd(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorEnd(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorEnd CreateConnectorEnd(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ConnectorEnd)partition.ElementFactory.CreateElement(typeof(ConnectorEnd));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ConnectorEnd CreateAndInitializeConnectorEnd(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ConnectorEnd)partition.ElementFactory.CreateElement(typeof(ConnectorEnd), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ConnectorEnd
	/// <summary>
	/// ConnectorEnd Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd))]
	public sealed class ConnectorEndElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ConnectorEndElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ConnectorEndElementFactoryCreator Instance
		{
			get
			{
				return new ConnectorEndElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled)]
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.MetaClassGuidString, "ObjectModel")]
	public  partial class ObjectModel : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ObjectModel's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "8a4f6d08-8e3e-4776-be9b-98d188083082";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.MetaClassGuidString);
		#endregion

		#region FileName's Generated  Field Code
		#region FileName's Generated  MetaAttribute Code
		/// <summary>
		/// MetaAttribute Guid String
		/// </summary>
		public const System.String FileNameMetaAttributeGuidString = "2a94ea2f-317b-4a70-b976-8177dbfa6670";

		/// <summary>
		/// MetaAttribute Guid
		/// </summary>
		public static readonly System.Guid FileNameMetaAttributeGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.FileNameMetaAttributeGuidString);
		#endregion

		#region FileName's Generated Property Code

		private System.String fileNamePropertyStorage = string.Empty;
		
		/// <summary>
		/// 
		/// </summary>
		[Microsoft.VisualStudio.Modeling.StringDomainAttribute]
		[Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType=typeof(ObjectModelFileNameFieldHandler))]
		[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.FileNameMetaAttributeGuidString, "ObjectModel.FileName")]
		public  System.String FileName
		{
			get
			{
				return fileNamePropertyStorage;
			}
		
			set
			{
				objectModelFileNameFieldHandler.SetFieldValue(this, value, false, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory);
			}
		}
		#endregion

		#region ObjectModelFileNameFieldHandler Generated Code
		/// <summary>
		/// FieldHandler for ObjectModel.FileName field
		/// </summary>
		private static ObjectModelFileNameFieldHandler	objectModelFileNameFieldHandler	= ObjectModelFileNameFieldHandler.Instance;

		/// <summary>
		/// Implement the field handler for ObjectModel.FileName
		/// </summary>
		[System.CLSCompliant(false)]
		public sealed partial class ObjectModelFileNameFieldHandler : Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler<Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel,System.String>
		{
			/// <summary>
			/// Constructor
			/// </summary>
			private ObjectModelFileNameFieldHandler() { }

			/// <summary>
			/// Returns the singleton instance of the ObjectModel.FileName field handler
			/// </summary>
			/// <value>ObjectModelFileNameFieldHandler</value>
			public static ObjectModelFileNameFieldHandler Instance
			{
				get
				{
					if (Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.objectModelFileNameFieldHandler != null)
					{
						return Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.objectModelFileNameFieldHandler;
					}
					else
					{
						// The static constructor in ObjectModel will assign this value to
						// Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.objectModelFileNameFieldHandler, so just instantiate one and return it
						return new ObjectModelFileNameFieldHandler();
					}
				}
			}

			/// <summary>
			/// Returns the meta attribute id for the ObjectModel.FileName field handler
			/// </summary>
			/// <value>Guid</value>
			public sealed override System.Guid Id
			{
				get
				{
					return Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.FileNameMetaAttributeGuid;
				}
			}
			/// <summary>
			/// Gets the value of the attribute as it exists in the element
			/// </summary>
			/// <param name="element">the ObjectModel</param>
			protected sealed override System.String GetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel element)
			{
				return element.fileNamePropertyStorage;
			}

			/// <summary>
			/// Sets the value into the element
			/// </summary>
			/// <param name="element">the element</param>
			/// <param name="value">new value</param>
			/// <param name="commandFactory">the command factory for this change</param>
			/// <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			/// <param name="oldValue">the old value before the change</param>
			/// <returns>true if the value actually changed</returns>
			protected sealed override bool SetValue(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel element, System.String value, Microsoft.VisualStudio.Modeling.CommandFactory commandFactory, bool allowDuplicates, ref System.String oldValue)
			{
				oldValue = element.fileNamePropertyStorage;
				if (allowDuplicates || oldValue != value)
				{
					OnValueChanging(element, oldValue, value);
					element.fileNamePropertyStorage = value;
					OnValueChanged(element, oldValue, value);
					return true;
				}
				return false;
			}
		
		}
		#endregion
		#endregion
		
		#region Model's Generated Accessor Code
		/// <summary>
		/// 
		/// </summary>
		public Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlModel Model
		{
			get
			{
				return this.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel.ObjectModelMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel.ModelMetaRoleGuid, false) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlModel;
			}
			set
			{
				bool sameRolePlayer = false;
				System.Collections.IList links = this.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel.ObjectModelMetaRoleGuid);
				if (links.Count > 0)
				{
					System.Diagnostics.Debug.Assert(1 == links.Count);
					Microsoft.VisualStudio.Modeling.MetaRoleInfo roleInfo = this.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel.ModelMetaRoleGuid);
					foreach (Microsoft.VisualStudio.Modeling.ElementLink link in links)
					{
						if (!link.IsRemoved)
						{
							Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlModel counterpart = link.GetRolePlayer(roleInfo) as Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlModel;
							if (counterpart != null && object.ReferenceEquals(counterpart, value))
							{
								sameRolePlayer = true;
							}
							else
							{
								link.Remove();
							}
							break;
						}
					}
				}
				if ((!sameRolePlayer) && (value != null))
				{
					Microsoft.VisualStudio.Modeling.RoleAssignment[] newRoles = new Microsoft.VisualStudio.Modeling.RoleAssignment[2];
					newRoles[0] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel.ModelMetaRoleGuid, value);
					newRoles[1] = new Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel.ObjectModelMetaRoleGuid, this);
					this.Partition.ElementFactory.CreateElementLink(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel), newRoles);
				}
			}
		}
		#endregion
	}
	#region Collection Classes for ObjectModel
	/// <summary>
	/// Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel Collection class, strongly-typed collection
	/// </summary>
	[System.CLSCompliant(true)]
	public sealed partial class ObjectModelMoveableCollection : Microsoft.VisualStudio.Modeling.IMoveableCollection
	{
		private Microsoft.VisualStudio.Modeling.ModelElement counterpartMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo sourceRoleMember;
		private Microsoft.VisualStudio.Modeling.MetaRoleInfo targetRoleMember;
		/// <summary>
		/// Counterpart
		/// </summary>
		public Microsoft.VisualStudio.Modeling.ModelElement Counterpart
		{
			get { return this.counterpartMember; }
		}
		/// <summary>
		/// Source Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo SourceRole
		{
			get { return this.sourceRoleMember; }
		}
		/// <summary>
		/// Target Role
		/// </summary>
		public Microsoft.VisualStudio.Modeling.MetaRoleInfo TargetRole
		{
			get { return this.targetRoleMember; }
		}
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="counterpart">Counterpart to create relationship with</param>
		/// <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		/// <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		public ObjectModelMoveableCollection(Microsoft.VisualStudio.Modeling.ModelElement counterpart, System.Guid sourceMetaRoleGuid, System.Guid targetMetaRoleGuid)
		{
			this.counterpartMember = counterpart;
			this.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid);
			this.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid);
		}
		/// <summary>
		/// Returns an enumerator that can iterate through a collection
		/// </summary>
		/// <returns>Enumerator</returns>
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).GetEnumerator();
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		void System.Collections.ICollection.CopyTo(System.Array array, System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).CopyTo(array, index);
		}
		/// <summary>
		/// When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		/// </summary>
		System.Int32 System.Collections.ICollection.Count
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Count; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		/// </summary>
		System.Boolean System.Collections.ICollection.IsSynchronized
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsSynchronized; }
		}
		/// <summary>
		/// When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		/// </summary>
		System.Object System.Collections.ICollection.SyncRoot
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).SyncRoot; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		/// </summary>
		System.Boolean System.Collections.IList.IsFixedSize
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsFixedSize; }
		}
		/// <summary>
		/// When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		/// </summary>
		System.Boolean System.Collections.IList.IsReadOnly
		{
			get { return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>object at that index</returns>
		System.Object System.Collections.IList.this[System.Int32 index]
		{
			get
			{
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				return list[index];
			}
			set
			{
				if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel))))
				{
					throw new System.InvalidCastException();
				}
				Microsoft.VisualStudio.Modeling.IMoveableCollection list = this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole);
				list[index] = value;
			}
		}
		/// <summary>
		/// When implemented by a class, adds an item to the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to add to the System.Collections.IList</param>
		/// <returns>index where object was added</returns>
		System.Int32 System.Collections.IList.Add(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Add(value);
		}
		/// <summary>
		/// When implemented by a class, removes all items from the System.Collections.IList
		/// </summary>
		void System.Collections.IList.Clear()
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Clear();
		}
		/// <summary>
		/// When implemented by a class, determines whether the System.Collections.IList has a specific value
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>true if object is contained, false otherwise</returns>
		System.Boolean System.Collections.IList.Contains(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Contains(value);
		}
		/// <summary>
		/// When implemented by a class, determines the index of a specific item in the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to locate in the System.Collections.IList</param>
		/// <returns>index of object</returns>
		System.Int32 System.Collections.IList.IndexOf(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel))))
			{
				throw new System.InvalidCastException();
			}
			return this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).IndexOf(value);
		}
		/// <summary>
		/// When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The System.Object to insert into the System.Collections.IList</param>
		void System.Collections.IList.Insert(System.Int32 index, System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Insert(index, value);
		}
		/// <summary>
		/// When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		/// </summary>
		/// <param name="value">The System.Object to remove from the System.Collections.IList</param>
		void System.Collections.IList.Remove(System.Object value)
		{
			if (value == null || (value.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel) && !value.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Remove(value);
		}
		/// <summary>
		/// When implemented by a class, removes the System.Collections.IList item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		void System.Collections.IList.RemoveAt(System.Int32 index)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(Microsoft.VisualStudio.Modeling.ModelElement rolePlayer, System.Int32 newPosition)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(rolePlayer, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		void Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.ModelElement rolePlayer)
		{
			if (rolePlayer == null || (rolePlayer.GetType() != typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel) && !rolePlayer.GetType().IsSubclassOf(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel))))
			{
				throw new System.InvalidCastException();
			}
			this.Counterpart.GetMoveableRolePlayers(this.SourceRole, this.TargetRole).ReplaceAt(position, rolePlayer);
		}
		/// <summary>
		/// When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		/// </summary>
		/// <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		/// <param name="index">The zero-based index in array at which copying begins</param>
		public void CopyTo(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel[] array, System.Int32 index)
		{
			((System.Collections.ICollection)this).CopyTo(array, index);
		}
		/// <summary>
		/// Gets the number of elements contained in the collection
		/// </summary>
		public System.Int32 Count
		{
			get { return ((System.Collections.ICollection)this).Count; }
		}
		/// <summary>
		/// Gets a value indicating whether the list is read-only
		/// </summary>
		public System.Boolean IsReadOnly
		{
			get { return ((System.Collections.IList)this).IsReadOnly; }
		}
		/// <summary>
		/// Indexed accessor
		/// </summary>
		/// <param name="index">Index to access</param>
		/// <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel at that index</returns>
		public Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel this[System.Int32 index]
		{
			get { return (Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel)(((System.Collections.IList)this)[index]); }
			set { ((System.Collections.IList)this)[index] = value as System.Object; }
		}
		/// <summary>
		/// Adds an item to the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel to add to the list</param>
		/// <returns>index where object was added</returns>
		public System.Int32 Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel value)
		{
			return ((System.Collections.IList)this).Add(value as System.Object);
		}
		/// <summary>
		/// Removes all items from the list
		/// </summary>
		public void Clear()
		{
			((System.Collections.IList)this).Clear();
		}
		/// <summary>
		/// Determines whether the list has a specific value
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel to locate in the list</param>
		/// <returns>true if object is contained, false otherwise</returns>
		public System.Boolean Contains(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel value)
		{
			return ((System.Collections.IList)this).Contains(value as System.Object);
		}
		/// <summary>
		/// Determines the index of a specific item in the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel to locate in the list</param>
		/// <returns>index of object</returns>
		public System.Int32 IndexOf(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel value)
		{
			return ((System.Collections.IList)this).IndexOf(value as System.Object);
		}
		/// <summary>
		/// Inserts an item to the list at the specified position
		/// </summary>
		/// <param name="index">The zero-based index at which the value should be inserted</param>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel to insert into the list</param>
		public void Insert(System.Int32 index, Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel value)
		{
			((System.Collections.IList)this).Insert(index, value as System.Object);
		}
		/// <summary>
		/// Removes the first occurrence of a specific object from the list
		/// </summary>
		/// <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel to remove from the list</param>
		public void Remove(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel value)
		{
			((System.Collections.IList)this).Remove(value as System.Object);
		}
		/// <summary>
		/// Removes the list item at the specified index
		/// </summary>
		/// <param name="index">The zero-based index of the item to remove</param>
		public void RemoveAt(System.Int32 index)
		{
			((System.Collections.IList)this).RemoveAt(index);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="rolePlayer">The role player to move</param>
		/// <param name="newPosition">The position to move to</param>
		public void Move(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel rolePlayer, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement, newPosition);
		}
		/// <summary>
		/// Move the roleplayer to the new position in the collection
		/// </summary>
		/// <param name="oldPosition">The position of the role player to move from</param>
		/// <param name="newPosition">The position of the role player to move to</param>
		public void Move(System.Int32 oldPosition, System.Int32 newPosition)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).Move(oldPosition, newPosition);
		}
		/// <summary>
		/// Insert a roleplayer in the specified location
		/// </summary>
		/// <param name="position">The index of the roleplayer that needs to be replaced</param>
		/// <param name="rolePlayer">The role player that will be inserted</param>
		public void ReplaceAt(System.Int32 position, Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel rolePlayer)
		{
			((Microsoft.VisualStudio.Modeling.IMoveableCollection)this).ReplaceAt(position, rolePlayer as Microsoft.VisualStudio.Modeling.ModelElement);
		}

	}
	#endregion

	#region ObjectModel's Generated Constructor Code
	public  partial class ObjectModel
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ObjectModel(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ObjectModel CreateObjectModel(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateObjectModel(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ObjectModel CreateAndInitializeObjectModel(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeObjectModel(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ObjectModel(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ObjectModel CreateObjectModel(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ObjectModel)partition.ElementFactory.CreateElement(typeof(ObjectModel));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ObjectModel CreateAndInitializeObjectModel(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ObjectModel)partition.ElementFactory.CreateElement(typeof(ObjectModel), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ObjectModel
	/// <summary>
	/// ObjectModel Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel))]
	public sealed class ObjectModelElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ObjectModelElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ObjectModelElementFactoryCreator Instance
		{
			get
			{
				return new ObjectModelElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression.MetaClassGuidString, "ModelNavigationExpression")]
	public  partial class ModelNavigationExpression : Microsoft.VisualStudio.Modeling.NamedElement
	{
		#region ModelNavigationExpression's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "b0c0ba16-f969-47c0-8ea2-00717a541f73";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression.MetaClassGuidString);
		#endregion

	}
	#region ModelNavigationExpression's Generated Constructor Code
	public  partial class ModelNavigationExpression
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ModelNavigationExpression(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ModelNavigationExpression CreateModelNavigationExpression(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateModelNavigationExpression(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ModelNavigationExpression CreateAndInitializeModelNavigationExpression(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeModelNavigationExpression(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ModelNavigationExpression(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ModelNavigationExpression CreateModelNavigationExpression(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ModelNavigationExpression)partition.ElementFactory.CreateElement(typeof(ModelNavigationExpression));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ModelNavigationExpression CreateAndInitializeModelNavigationExpression(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ModelNavigationExpression)partition.ElementFactory.CreateElement(typeof(ModelNavigationExpression), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ModelNavigationExpression
	/// <summary>
	/// ModelNavigationExpression Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression))]
	public sealed class ModelNavigationExpressionElementFactoryCreator : Microsoft.VisualStudio.Modeling.ElementFactoryCreator
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ModelNavigationExpressionElementFactoryCreator()
		{
		}
		/// <summary>
		/// Class Factory Create Method
		/// </summary>
		public override Microsoft.VisualStudio.Modeling.ModelElement Create(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
		{
			return new Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression( partition, bag );
		}
		/// <summary>
		/// Create an instance of the creator object
		/// </summary>
		public static ModelNavigationExpressionElementFactoryCreator Instance
		{
			get
			{
				return new ModelNavigationExpressionElementFactoryCreator();
			}
		}
	}
	#endregion

}
namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
{
	/// <summary>
	/// 
	/// </summary>
	[System.CLSCompliant(true)]
	[System.Serializable]
	[Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d")]
	[Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression.MetaClassGuidString, "ValueExpression")]
	public  partial class ValueExpression : Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression
	{
		#region ValueExpression's Generated MetaClass Code
		/// <summary>
		/// MetaClass Guid String
		/// </summary>
		public new const System.String MetaClassGuidString = "33569595-25a1-4341-aaf9-56f879fb660e";
		/// <summary>
		/// MetaClass Guid
		/// </summary>
		public static readonly new System.Guid MetaClassGuid = new System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression.MetaClassGuidString);
		#endregion

	}
	#region ValueExpression's Generated Constructor Code
	public  partial class ValueExpression
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public ValueExpression(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.ModelDataBag bag) : base(store.DefaultPartition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ValueExpression CreateValueExpression(Microsoft.VisualStudio.Modeling.Store store)
		{
			return CreateValueExpression(store.DefaultPartition);
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ValueExpression CreateAndInitializeValueExpression(Microsoft.VisualStudio.Modeling.Store store, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return CreateAndInitializeValueExpression(store.DefaultPartition, assignments);
		}
		/// <summary>
		/// Constructor
		/// </summary>
		public ValueExpression(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.ModelDataBag bag)
			: base(partition, bag)
		{
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ValueExpression CreateValueExpression(Microsoft.VisualStudio.Modeling.Partition partition)
		{
			return (ValueExpression)partition.ElementFactory.CreateElement(typeof(ValueExpression));
		}
		/// <summary>
		/// Class Factory
		/// </summary>
		public static ValueExpression CreateAndInitializeValueExpression(Microsoft.VisualStudio.Modeling.Partition partition, Microsoft.VisualStudio.Modeling.AttributeAssignment[] assignments)
		{
			return (ValueExpression)partition.ElementFactory.CreateElement(typeof(ValueExpression), assignments);
		}
	}
	#endregion
	#region Class Factory Creator for ValueExpression
	/// <summary>
	/// ValueExpression Class Factory Creator
	/// </summary>
	[Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(typeof(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression))]
	public sealed class ValueExpressionElementFactoryCreator : 