// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.
using System;

/// <summary>
/// ctor
/// </summary>
public class ExceptionCtor1
{
    #region Public Methods
    public bool RunTests()
    {
        bool retVal = true;

        TestLibrary.TestFramework.LogInformation("[Positive]");
        retVal = PosTest1() && retVal;

        return retVal;
    }

    #region Positive Test Cases
    public bool PosTest1()
    {
        bool retVal = true;

        TestLibrary.TestFramework.BeginScenario("PosTest1: Call ctor to construct a new Exception instance");

        try
        {
            Exception ex = new Exception();

            if (ex == null)
            {
                TestLibrary.TestFramework.LogError("001.1", "Calling ctor to construct a new Exception instance returns a null reference");
                retVal = false;
            }

            if (ex.InnerException != null)
            {
                TestLibrary.TestFramework.LogError("001.2", "Calling ctor to construct a new Exception instance returns an instance with InnerException is not a null reference");
                retVal = false;
            }
        }
        catch (Exception e)
        {
            TestLibrary.TestFramework.LogError("001.0", "Unexpected exception: " + e);
            TestLibrary.TestFramework.LogInformation(e.StackTrace);
            retVal = false;
        }

        return retVal;
    }
    #endregion
    #endregion

    public static int Main()
    {
        ExceptionCtor1 test = new ExceptionCtor1();

        TestLibrary.TestFramework.BeginTestCase("ExceptionCtor1");

        if (test.RunTests())
        {
            TestLibrary.TestFramework.EndTestCase();
            TestLibrary.TestFramework.LogInformation("PASS");
            return 100;
        }
        else
        {
            TestLibrary.TestFramework.EndTestCase();
            TestLibrary.TestFramework.LogInformation("FAIL");
            return 0;
        }
    }
}
