﻿' Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the Apache License, Version 2.0.  See License.txt in the project root for license information.

Imports System.Composition
Imports System.Threading
Imports Microsoft.CodeAnalysis.CodeRefactorings
Imports Microsoft.CodeAnalysis.MoveDeclarationNearReference
Imports Microsoft.CodeAnalysis.VisualBasic.Syntax

Namespace Microsoft.CodeAnalysis.VisualBasic.MoveDeclarationNearReference
    <ExportCodeRefactoringProvider(LanguageNames.VisualBasic, Name:=PredefinedCodeRefactoringProviderNames.MoveDeclarationNearReference), [Shared]>
    <ExtensionOrder(After:=PredefinedCodeRefactoringProviderNames.InlineTemporary)>
    Friend Class VisualBasicMoveDeclarationNearReferenceCodeRefactoringProvider
        Inherits AbstractMoveDeclarationNearReferenceCodeRefactoringProvider(Of
            VisualBasicMoveDeclarationNearReferenceCodeRefactoringProvider,
            StatementSyntax,
            LocalDeclarationStatementSyntax,
            VariableDeclaratorSyntax)

        Protected Overrides Function IsMeaningfulBlock(node As SyntaxNode) As Boolean
            Return TypeOf node Is LambdaExpressionSyntax OrElse
                   TypeOf node Is ForOrForEachBlockSyntax OrElse
                   TypeOf node Is WhileStatementSyntax OrElse
                   TypeOf node Is DoStatementSyntax OrElse
                   TypeOf node Is LoopStatementSyntax
        End Function

        Protected Overrides Function GetVariableDeclaratorSymbolNode(variableDeclarator As VariableDeclaratorSyntax) As SyntaxNode
            Return variableDeclarator.Names(0)
        End Function

        Protected Overrides Function IsValidVariableDeclarator(variableDeclarator As VariableDeclaratorSyntax) As Boolean
            Return variableDeclarator.Names.Count = 1
        End Function

        Protected Overrides Function GetIdentifierOfVariableDeclarator(variableDeclarator As VariableDeclaratorSyntax) As SyntaxToken
            Return variableDeclarator.Names(0).Identifier
        End Function

        Protected Overrides Function TypesAreCompatibleAsync(document As Document, localSymbol As ILocalSymbol, declarationStatement As LocalDeclarationStatementSyntax, right As SyntaxNode, cancellationToken As CancellationToken) As Task(Of Boolean)
            Return SpecializedTasks.True
        End Function
    End Class
End Namespace
