﻿// <auto-generated />

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using Microsoft.CodeAnalysis.Syntax.InternalSyntax;
using Roslyn.Utilities;


namespace Microsoft.CodeAnalysis.CSharp.Syntax
{
  /// <summary>Provides the base class from which the classes that represent name syntax nodes are derived. This is an abstract class.</summary>
  public abstract partial class NameSyntax : TypeSyntax
  {
    internal NameSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  /// <summary>Provides the base class from which the classes that represent simple name syntax nodes are derived. This is an abstract class.</summary>
  public abstract partial class SimpleNameSyntax : NameSyntax
  {
    internal SimpleNameSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the identifier of the simple name.</summary>
    public abstract SyntaxToken Identifier { get; }
  }

  /// <summary>Class which represents the syntax node for identifier name.</summary>
  public sealed partial class IdentifierNameSyntax : SimpleNameSyntax
  {
    internal IdentifierNameSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the keyword for the kind of the identifier name.</summary>
    public override SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IdentifierNameSyntax)this.Green).identifier, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitIdentifierName(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitIdentifierName(this);
    }

    public IdentifierNameSyntax Update(SyntaxToken identifier)
    {
        if (identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.IdentifierName(identifier);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public IdentifierNameSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(identifier);
    }
  }

  /// <summary>Class which represents the syntax node for qualified name.</summary>
  public sealed partial class QualifiedNameSyntax : NameSyntax
  {
    private NameSyntax left;
    private SimpleNameSyntax right;

    internal QualifiedNameSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>NameSyntax node representing the name on the left side of the dot token of the qualified name.</summary>
    public NameSyntax Left 
    {
        get
        {
            return this.GetRedAtZero(ref this.left);
        }
    }

    /// <summary>SyntaxToken representing the dot.</summary>
    public SyntaxToken DotToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.QualifiedNameSyntax)this.Green).dotToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>SimpleNameSyntax node representing the name on the right side of the dot token of the qualified name.</summary>
    public SimpleNameSyntax Right 
    {
        get
        {
            return this.GetRed(ref this.right, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.left);
            case 2: return this.GetRed(ref this.right, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.left;
            case 2: return this.right;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitQualifiedName(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitQualifiedName(this);
    }

    public QualifiedNameSyntax Update(NameSyntax left, SyntaxToken dotToken, SimpleNameSyntax right)
    {
        if (left != this.Left || dotToken != this.DotToken || right != this.Right)
        {
            var newNode = SyntaxFactory.QualifiedName(left, dotToken, right);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public QualifiedNameSyntax WithLeft(NameSyntax left)
    {
        return this.Update(left, this.DotToken, this.Right);
    }

    public QualifiedNameSyntax WithDotToken(SyntaxToken dotToken)
    {
        return this.Update(this.Left, dotToken, this.Right);
    }

    public QualifiedNameSyntax WithRight(SimpleNameSyntax right)
    {
        return this.Update(this.Left, this.DotToken, right);
    }
  }

  /// <summary>Class which represents the syntax node for generic name.</summary>
  public sealed partial class GenericNameSyntax : SimpleNameSyntax
  {
    private TypeArgumentListSyntax typeArgumentList;

    internal GenericNameSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the name of the identifier of the generic name.</summary>
    public override SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.GenericNameSyntax)this.Green).identifier, this.Position, 0); }
    }

    /// <summary>TypeArgumentListSyntax node representing the list of type arguments of the generic name.</summary>
    public TypeArgumentListSyntax TypeArgumentList 
    {
        get
        {
            return this.GetRed(ref this.typeArgumentList, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.typeArgumentList, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.typeArgumentList;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitGenericName(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitGenericName(this);
    }

    public GenericNameSyntax Update(SyntaxToken identifier, TypeArgumentListSyntax typeArgumentList)
    {
        if (identifier != this.Identifier || typeArgumentList != this.TypeArgumentList)
        {
            var newNode = SyntaxFactory.GenericName(identifier, typeArgumentList);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public GenericNameSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(identifier, this.TypeArgumentList);
    }

    public GenericNameSyntax WithTypeArgumentList(TypeArgumentListSyntax typeArgumentList)
    {
        return this.Update(this.Identifier, typeArgumentList);
    }

    public GenericNameSyntax AddTypeArgumentListArguments(params TypeSyntax[] items)
    {
        return this.WithTypeArgumentList(this.TypeArgumentList.WithArguments(this.TypeArgumentList.Arguments.AddRange(items)));
    }
  }

  /// <summary>Class which represents the syntax node for type argument list.</summary>
  public sealed partial class TypeArgumentListSyntax : CSharpSyntaxNode
  {
    private SyntaxNode arguments;

    internal TypeArgumentListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing less than.</summary>
    public SyntaxToken LessThanToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TypeArgumentListSyntax)this.Green).lessThanToken, this.Position, 0); }
    }

    /// <summary>SeparatedSyntaxList of TypeSyntax node representing the type arguments.</summary>
    public SeparatedSyntaxList<TypeSyntax> Arguments 
    {
        get
        {
            var red = this.GetRed(ref this.arguments, 1);
            if (red != null)
                return new SeparatedSyntaxList<TypeSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<TypeSyntax>);
        }
    }

    /// <summary>SyntaxToken representing greater than.</summary>
    public SyntaxToken GreaterThanToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TypeArgumentListSyntax)this.Green).greaterThanToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.arguments, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.arguments;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitTypeArgumentList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitTypeArgumentList(this);
    }

    public TypeArgumentListSyntax Update(SyntaxToken lessThanToken, SeparatedSyntaxList<TypeSyntax> arguments, SyntaxToken greaterThanToken)
    {
        if (lessThanToken != this.LessThanToken || arguments != this.Arguments || greaterThanToken != this.GreaterThanToken)
        {
            var newNode = SyntaxFactory.TypeArgumentList(lessThanToken, arguments, greaterThanToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public TypeArgumentListSyntax WithLessThanToken(SyntaxToken lessThanToken)
    {
        return this.Update(lessThanToken, this.Arguments, this.GreaterThanToken);
    }

    public TypeArgumentListSyntax WithArguments(SeparatedSyntaxList<TypeSyntax> arguments)
    {
        return this.Update(this.LessThanToken, arguments, this.GreaterThanToken);
    }

    public TypeArgumentListSyntax WithGreaterThanToken(SyntaxToken greaterThanToken)
    {
        return this.Update(this.LessThanToken, this.Arguments, greaterThanToken);
    }

    public TypeArgumentListSyntax AddArguments(params TypeSyntax[] items)
    {
        return this.WithArguments(this.Arguments.AddRange(items));
    }
  }

  /// <summary>Class which represents the syntax node for alias qualified name.</summary>
  public sealed partial class AliasQualifiedNameSyntax : NameSyntax
  {
    private IdentifierNameSyntax alias;
    private SimpleNameSyntax name;

    internal AliasQualifiedNameSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>IdentifierNameSyntax node representing the name of the alias</summary>
    public IdentifierNameSyntax Alias 
    {
        get
        {
            return this.GetRedAtZero(ref this.alias);
        }
    }

    /// <summary>SyntaxToken representing colon colon.</summary>
    public SyntaxToken ColonColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AliasQualifiedNameSyntax)this.Green).colonColonToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>SimpleNameSyntax node representing the name that is being alias qualified.</summary>
    public SimpleNameSyntax Name 
    {
        get
        {
            return this.GetRed(ref this.name, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.alias);
            case 2: return this.GetRed(ref this.name, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.alias;
            case 2: return this.name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAliasQualifiedName(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAliasQualifiedName(this);
    }

    public AliasQualifiedNameSyntax Update(IdentifierNameSyntax alias, SyntaxToken colonColonToken, SimpleNameSyntax name)
    {
        if (alias != this.Alias || colonColonToken != this.ColonColonToken || name != this.Name)
        {
            var newNode = SyntaxFactory.AliasQualifiedName(alias, colonColonToken, name);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AliasQualifiedNameSyntax WithAlias(IdentifierNameSyntax alias)
    {
        return this.Update(alias, this.ColonColonToken, this.Name);
    }

    public AliasQualifiedNameSyntax WithColonColonToken(SyntaxToken colonColonToken)
    {
        return this.Update(this.Alias, colonColonToken, this.Name);
    }

    public AliasQualifiedNameSyntax WithName(SimpleNameSyntax name)
    {
        return this.Update(this.Alias, this.ColonColonToken, name);
    }
  }

  /// <summary>Provides the base class from which the classes that represent type syntax nodes are derived. This is an abstract class.</summary>
  public abstract partial class TypeSyntax : ExpressionSyntax
  {
    internal TypeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  /// <summary>Class which represents the syntax node for predefined types.</summary>
  public sealed partial class PredefinedTypeSyntax : TypeSyntax
  {
    internal PredefinedTypeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken which represents the keyword corresponding to the predefined type.</summary>
    public SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PredefinedTypeSyntax)this.Green).keyword, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitPredefinedType(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitPredefinedType(this);
    }

    public PredefinedTypeSyntax Update(SyntaxToken keyword)
    {
        if (keyword != this.Keyword)
        {
            var newNode = SyntaxFactory.PredefinedType(keyword);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public PredefinedTypeSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword);
    }
  }

  /// <summary>Class which represents the syntax node for the array type.</summary>
  public sealed partial class ArrayTypeSyntax : TypeSyntax
  {
    private TypeSyntax elementType;
    private SyntaxNode rankSpecifiers;

    internal ArrayTypeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>TypeSyntax node representing the type of the element of the array.</summary>
    public TypeSyntax ElementType 
    {
        get
        {
            return this.GetRedAtZero(ref this.elementType);
        }
    }

    /// <summary>SyntaxList of ArrayRankSpecifierSyntax nodes representing the list of rank specifiers for the array.</summary>
    public SyntaxList<ArrayRankSpecifierSyntax> RankSpecifiers 
    {
        get
        {
            return new SyntaxList<ArrayRankSpecifierSyntax>(this.GetRed(ref this.rankSpecifiers, 1));
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.elementType);
            case 1: return this.GetRed(ref this.rankSpecifiers, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.elementType;
            case 1: return this.rankSpecifiers;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitArrayType(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitArrayType(this);
    }

    public ArrayTypeSyntax Update(TypeSyntax elementType, SyntaxList<ArrayRankSpecifierSyntax> rankSpecifiers)
    {
        if (elementType != this.ElementType || rankSpecifiers != this.RankSpecifiers)
        {
            var newNode = SyntaxFactory.ArrayType(elementType, rankSpecifiers);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ArrayTypeSyntax WithElementType(TypeSyntax elementType)
    {
        return this.Update(elementType, this.RankSpecifiers);
    }

    public ArrayTypeSyntax WithRankSpecifiers(SyntaxList<ArrayRankSpecifierSyntax> rankSpecifiers)
    {
        return this.Update(this.ElementType, rankSpecifiers);
    }

    public ArrayTypeSyntax AddRankSpecifiers(params ArrayRankSpecifierSyntax[] items)
    {
        return this.WithRankSpecifiers(this.RankSpecifiers.AddRange(items));
    }
  }

  public sealed partial class ArrayRankSpecifierSyntax : CSharpSyntaxNode
  {
    private SyntaxNode sizes;

    internal ArrayRankSpecifierSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OpenBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ArrayRankSpecifierSyntax)this.Green).openBracketToken, this.Position, 0); }
    }

    public SeparatedSyntaxList<ExpressionSyntax> Sizes 
    {
        get
        {
            var red = this.GetRed(ref this.sizes, 1);
            if (red != null)
                return new SeparatedSyntaxList<ExpressionSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<ExpressionSyntax>);
        }
    }

    public SyntaxToken CloseBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ArrayRankSpecifierSyntax)this.Green).closeBracketToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.sizes, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.sizes;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitArrayRankSpecifier(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitArrayRankSpecifier(this);
    }

    public ArrayRankSpecifierSyntax Update(SyntaxToken openBracketToken, SeparatedSyntaxList<ExpressionSyntax> sizes, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || sizes != this.Sizes || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.ArrayRankSpecifier(openBracketToken, sizes, closeBracketToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ArrayRankSpecifierSyntax WithOpenBracketToken(SyntaxToken openBracketToken)
    {
        return this.Update(openBracketToken, this.Sizes, this.CloseBracketToken);
    }

    public ArrayRankSpecifierSyntax WithSizes(SeparatedSyntaxList<ExpressionSyntax> sizes)
    {
        return this.Update(this.OpenBracketToken, sizes, this.CloseBracketToken);
    }

    public ArrayRankSpecifierSyntax WithCloseBracketToken(SyntaxToken closeBracketToken)
    {
        return this.Update(this.OpenBracketToken, this.Sizes, closeBracketToken);
    }

    public ArrayRankSpecifierSyntax AddSizes(params ExpressionSyntax[] items)
    {
        return this.WithSizes(this.Sizes.AddRange(items));
    }
  }

  /// <summary>Class which represents the syntax node for pointer type.</summary>
  public sealed partial class PointerTypeSyntax : TypeSyntax
  {
    private TypeSyntax elementType;

    internal PointerTypeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>TypeSyntax node that represents the element type of the pointer.</summary>
    public TypeSyntax ElementType 
    {
        get
        {
            return this.GetRedAtZero(ref this.elementType);
        }
    }

    /// <summary>SyntaxToken representing the asterisk.</summary>
    public SyntaxToken AsteriskToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PointerTypeSyntax)this.Green).asteriskToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.elementType);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.elementType;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitPointerType(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitPointerType(this);
    }

    public PointerTypeSyntax Update(TypeSyntax elementType, SyntaxToken asteriskToken)
    {
        if (elementType != this.ElementType || asteriskToken != this.AsteriskToken)
        {
            var newNode = SyntaxFactory.PointerType(elementType, asteriskToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public PointerTypeSyntax WithElementType(TypeSyntax elementType)
    {
        return this.Update(elementType, this.AsteriskToken);
    }

    public PointerTypeSyntax WithAsteriskToken(SyntaxToken asteriskToken)
    {
        return this.Update(this.ElementType, asteriskToken);
    }
  }

  /// <summary>Class which represents the syntax node for a nullable type.</summary>
  public sealed partial class NullableTypeSyntax : TypeSyntax
  {
    private TypeSyntax elementType;

    internal NullableTypeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>TypeSyntax node representing the type of the element.</summary>
    public TypeSyntax ElementType 
    {
        get
        {
            return this.GetRedAtZero(ref this.elementType);
        }
    }

    /// <summary>SyntaxToken representing the question mark.</summary>
    public SyntaxToken QuestionToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.NullableTypeSyntax)this.Green).questionToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.elementType);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.elementType;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitNullableType(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitNullableType(this);
    }

    public NullableTypeSyntax Update(TypeSyntax elementType, SyntaxToken questionToken)
    {
        if (elementType != this.ElementType || questionToken != this.QuestionToken)
        {
            var newNode = SyntaxFactory.NullableType(elementType, questionToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public NullableTypeSyntax WithElementType(TypeSyntax elementType)
    {
        return this.Update(elementType, this.QuestionToken);
    }

    public NullableTypeSyntax WithQuestionToken(SyntaxToken questionToken)
    {
        return this.Update(this.ElementType, questionToken);
    }
  }

  /// <summary>Class which represents the syntax node for tuple type.</summary>
  public sealed partial class TupleTypeSyntax : TypeSyntax
  {
    private SyntaxNode elements;

    internal TupleTypeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TupleTypeSyntax)this.Green).openParenToken, this.Position, 0); }
    }

    public SeparatedSyntaxList<TupleElementSyntax> Elements 
    {
        get
        {
            var red = this.GetRed(ref this.elements, 1);
            if (red != null)
                return new SeparatedSyntaxList<TupleElementSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<TupleElementSyntax>);
        }
    }

    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TupleTypeSyntax)this.Green).closeParenToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.elements, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.elements;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitTupleType(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitTupleType(this);
    }

    public TupleTypeSyntax Update(SyntaxToken openParenToken, SeparatedSyntaxList<TupleElementSyntax> elements, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || elements != this.Elements || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.TupleType(openParenToken, elements, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public TupleTypeSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(openParenToken, this.Elements, this.CloseParenToken);
    }

    public TupleTypeSyntax WithElements(SeparatedSyntaxList<TupleElementSyntax> elements)
    {
        return this.Update(this.OpenParenToken, elements, this.CloseParenToken);
    }

    public TupleTypeSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.OpenParenToken, this.Elements, closeParenToken);
    }

    public TupleTypeSyntax AddElements(params TupleElementSyntax[] items)
    {
        return this.WithElements(this.Elements.AddRange(items));
    }
  }

  /// <summary>Tuple type element.</summary>
  public sealed partial class TupleElementSyntax : CSharpSyntaxNode
  {
    private TypeSyntax type;

    internal TupleElementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the type of the tuple element.</summary>
    public TypeSyntax Type 
    {
        get
        {
            return this.GetRedAtZero(ref this.type);
        }
    }

    /// <summary>Gets the name of the tuple element.</summary>
    public SyntaxToken Identifier 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TupleElementSyntax)this.Green).identifier;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.type);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitTupleElement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitTupleElement(this);
    }

    public TupleElementSyntax Update(TypeSyntax type, SyntaxToken identifier)
    {
        if (type != this.Type || identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.TupleElement(type, identifier);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public TupleElementSyntax WithType(TypeSyntax type)
    {
        return this.Update(type, this.Identifier);
    }

    public TupleElementSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.Type, identifier);
    }
  }

  /// <summary>Class which represents a placeholder in the type argument list of an unbound generic type.</summary>
  public sealed partial class OmittedTypeArgumentSyntax : TypeSyntax
  {
    internal OmittedTypeArgumentSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the omitted type argument.</summary>
    public SyntaxToken OmittedTypeArgumentToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.OmittedTypeArgumentSyntax)this.Green).omittedTypeArgumentToken, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitOmittedTypeArgument(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitOmittedTypeArgument(this);
    }

    public OmittedTypeArgumentSyntax Update(SyntaxToken omittedTypeArgumentToken)
    {
        if (omittedTypeArgumentToken != this.OmittedTypeArgumentToken)
        {
            var newNode = SyntaxFactory.OmittedTypeArgument(omittedTypeArgumentToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public OmittedTypeArgumentSyntax WithOmittedTypeArgumentToken(SyntaxToken omittedTypeArgumentToken)
    {
        return this.Update(omittedTypeArgumentToken);
    }
  }

  /// <summary>The ref modifier of a method's return value or a local.</summary>
  public sealed partial class RefTypeSyntax : TypeSyntax
  {
    private TypeSyntax type;

    internal RefTypeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken RefKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RefTypeSyntax)this.Green).refKeyword, this.Position, 0); }
    }

    /// <summary>Gets the optional "readonly" keyword.</summary>
    public SyntaxToken ReadOnlyKeyword 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RefTypeSyntax)this.Green).readOnlyKeyword;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxToken);
        }
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.type, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRefType(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitRefType(this);
    }

    public RefTypeSyntax Update(SyntaxToken refKeyword, SyntaxToken readOnlyKeyword, TypeSyntax type)
    {
        if (refKeyword != this.RefKeyword || readOnlyKeyword != this.ReadOnlyKeyword || type != this.Type)
        {
            var newNode = SyntaxFactory.RefType(refKeyword, readOnlyKeyword, type);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public RefTypeSyntax WithRefKeyword(SyntaxToken refKeyword)
    {
        return this.Update(refKeyword, this.ReadOnlyKeyword, this.Type);
    }

    public RefTypeSyntax WithReadOnlyKeyword(SyntaxToken readOnlyKeyword)
    {
        return this.Update(this.RefKeyword, readOnlyKeyword, this.Type);
    }

    public RefTypeSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.RefKeyword, this.ReadOnlyKeyword, type);
    }
  }

  /// <summary>Provides the base class from which the classes that represent expression syntax nodes are derived. This is an abstract class.</summary>
  public abstract partial class ExpressionSyntax : CSharpSyntaxNode
  {
    internal ExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  /// <summary>Class which represents the syntax node for parenthesized expression.</summary>
  public sealed partial class ParenthesizedExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;

    internal ParenthesizedExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ParenthesizedExpressionSyntax)this.Green).openParenToken, this.Position, 0); }
    }

    /// <summary>ExpressionSyntax node representing the expression enclosed within the parenthesis.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 1);
        }
    }

    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ParenthesizedExpressionSyntax)this.Green).closeParenToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.expression, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitParenthesizedExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitParenthesizedExpression(this);
    }

    public ParenthesizedExpressionSyntax Update(SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ParenthesizedExpression(openParenToken, expression, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ParenthesizedExpressionSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(openParenToken, this.Expression, this.CloseParenToken);
    }

    public ParenthesizedExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.OpenParenToken, expression, this.CloseParenToken);
    }

    public ParenthesizedExpressionSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.OpenParenToken, this.Expression, closeParenToken);
    }
  }

  /// <summary>Class which represents the syntax node for tuple expression.</summary>
  public sealed partial class TupleExpressionSyntax : ExpressionSyntax
  {
    private SyntaxNode arguments;

    internal TupleExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TupleExpressionSyntax)this.Green).openParenToken, this.Position, 0); }
    }

    /// <summary>SeparatedSyntaxList of ArgumentSyntax representing the list of arguments.</summary>
    public SeparatedSyntaxList<ArgumentSyntax> Arguments 
    {
        get
        {
            var red = this.GetRed(ref this.arguments, 1);
            if (red != null)
                return new SeparatedSyntaxList<ArgumentSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<ArgumentSyntax>);
        }
    }

    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TupleExpressionSyntax)this.Green).closeParenToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.arguments, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.arguments;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitTupleExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitTupleExpression(this);
    }

    public TupleExpressionSyntax Update(SyntaxToken openParenToken, SeparatedSyntaxList<ArgumentSyntax> arguments, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || arguments != this.Arguments || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.TupleExpression(openParenToken, arguments, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public TupleExpressionSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(openParenToken, this.Arguments, this.CloseParenToken);
    }

    public TupleExpressionSyntax WithArguments(SeparatedSyntaxList<ArgumentSyntax> arguments)
    {
        return this.Update(this.OpenParenToken, arguments, this.CloseParenToken);
    }

    public TupleExpressionSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.OpenParenToken, this.Arguments, closeParenToken);
    }

    public TupleExpressionSyntax AddArguments(params ArgumentSyntax[] items)
    {
        return this.WithArguments(this.Arguments.AddRange(items));
    }
  }

  /// <summary>Class which represents the syntax node for prefix unary expression.</summary>
  public sealed partial class PrefixUnaryExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax operand;

    internal PrefixUnaryExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the kind of the operator of the prefix unary expression.</summary>
    public SyntaxToken OperatorToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PrefixUnaryExpressionSyntax)this.Green).operatorToken, this.Position, 0); }
    }

    /// <summary>ExpressionSyntax representing the operand of the prefix unary expression.</summary>
    public ExpressionSyntax Operand 
    {
        get
        {
            return this.GetRed(ref this.operand, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.operand, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.operand;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitPrefixUnaryExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitPrefixUnaryExpression(this);
    }

    public PrefixUnaryExpressionSyntax Update(SyntaxToken operatorToken, ExpressionSyntax operand)
    {
        if (operatorToken != this.OperatorToken || operand != this.Operand)
        {
            var newNode = SyntaxFactory.PrefixUnaryExpression(this.Kind(), operatorToken, operand);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public PrefixUnaryExpressionSyntax WithOperatorToken(SyntaxToken operatorToken)
    {
        return this.Update(operatorToken, this.Operand);
    }

    public PrefixUnaryExpressionSyntax WithOperand(ExpressionSyntax operand)
    {
        return this.Update(this.OperatorToken, operand);
    }
  }

  /// <summary>Class which represents the syntax node for an "await" expression.</summary>
  public sealed partial class AwaitExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;

    internal AwaitExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the kind "await" keyword.</summary>
    public SyntaxToken AwaitKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AwaitExpressionSyntax)this.Green).awaitKeyword, this.Position, 0); }
    }

    /// <summary>ExpressionSyntax representing the operand of the "await" operator.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.expression, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAwaitExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAwaitExpression(this);
    }

    public AwaitExpressionSyntax Update(SyntaxToken awaitKeyword, ExpressionSyntax expression)
    {
        if (awaitKeyword != this.AwaitKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.AwaitExpression(awaitKeyword, expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AwaitExpressionSyntax WithAwaitKeyword(SyntaxToken awaitKeyword)
    {
        return this.Update(awaitKeyword, this.Expression);
    }

    public AwaitExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.AwaitKeyword, expression);
    }
  }

  /// <summary>Class which represents the syntax node for postfix unary expression.</summary>
  public sealed partial class PostfixUnaryExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax operand;

    internal PostfixUnaryExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>ExpressionSyntax representing the operand of the postfix unary expression.</summary>
    public ExpressionSyntax Operand 
    {
        get
        {
            return this.GetRedAtZero(ref this.operand);
        }
    }

    /// <summary>SyntaxToken representing the kind of the operator of the postfix unary expression.</summary>
    public SyntaxToken OperatorToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PostfixUnaryExpressionSyntax)this.Green).operatorToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.operand);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.operand;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitPostfixUnaryExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitPostfixUnaryExpression(this);
    }

    public PostfixUnaryExpressionSyntax Update(ExpressionSyntax operand, SyntaxToken operatorToken)
    {
        if (operand != this.Operand || operatorToken != this.OperatorToken)
        {
            var newNode = SyntaxFactory.PostfixUnaryExpression(this.Kind(), operand, operatorToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public PostfixUnaryExpressionSyntax WithOperand(ExpressionSyntax operand)
    {
        return this.Update(operand, this.OperatorToken);
    }

    public PostfixUnaryExpressionSyntax WithOperatorToken(SyntaxToken operatorToken)
    {
        return this.Update(this.Operand, operatorToken);
    }
  }

  /// <summary>Class which represents the syntax node for member access expression.</summary>
  public sealed partial class MemberAccessExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;
    private SimpleNameSyntax name;

    internal MemberAccessExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>ExpressionSyntax node representing the object that the member belongs to.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRedAtZero(ref this.expression);
        }
    }

    /// <summary>SyntaxToken representing the kind of the operator in the member access expression.</summary>
    public SyntaxToken OperatorToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.MemberAccessExpressionSyntax)this.Green).operatorToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>SimpleNameSyntax node representing the member being accessed.</summary>
    public SimpleNameSyntax Name 
    {
        get
        {
            return this.GetRed(ref this.name, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.expression);
            case 2: return this.GetRed(ref this.name, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 2: return this.name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMemberAccessExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitMemberAccessExpression(this);
    }

    public MemberAccessExpressionSyntax Update(ExpressionSyntax expression, SyntaxToken operatorToken, SimpleNameSyntax name)
    {
        if (expression != this.Expression || operatorToken != this.OperatorToken || name != this.Name)
        {
            var newNode = SyntaxFactory.MemberAccessExpression(this.Kind(), expression, operatorToken, name);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MemberAccessExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(expression, this.OperatorToken, this.Name);
    }

    public MemberAccessExpressionSyntax WithOperatorToken(SyntaxToken operatorToken)
    {
        return this.Update(this.Expression, operatorToken, this.Name);
    }

    public MemberAccessExpressionSyntax WithName(SimpleNameSyntax name)
    {
        return this.Update(this.Expression, this.OperatorToken, name);
    }
  }

  /// <summary>Class which represents the syntax node for conditional access expression.</summary>
  public sealed partial class ConditionalAccessExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;
    private ExpressionSyntax whenNotNull;

    internal ConditionalAccessExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>ExpressionSyntax node representing the object conditionally accessed.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRedAtZero(ref this.expression);
        }
    }

    /// <summary>SyntaxToken representing the question mark.</summary>
    public SyntaxToken OperatorToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConditionalAccessExpressionSyntax)this.Green).operatorToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>ExpressionSyntax node representing the access expression to be executed when the object is not null.</summary>
    public ExpressionSyntax WhenNotNull 
    {
        get
        {
            return this.GetRed(ref this.whenNotNull, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.expression);
            case 2: return this.GetRed(ref this.whenNotNull, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 2: return this.whenNotNull;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitConditionalAccessExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitConditionalAccessExpression(this);
    }

    public ConditionalAccessExpressionSyntax Update(ExpressionSyntax expression, SyntaxToken operatorToken, ExpressionSyntax whenNotNull)
    {
        if (expression != this.Expression || operatorToken != this.OperatorToken || whenNotNull != this.WhenNotNull)
        {
            var newNode = SyntaxFactory.ConditionalAccessExpression(expression, operatorToken, whenNotNull);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ConditionalAccessExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(expression, this.OperatorToken, this.WhenNotNull);
    }

    public ConditionalAccessExpressionSyntax WithOperatorToken(SyntaxToken operatorToken)
    {
        return this.Update(this.Expression, operatorToken, this.WhenNotNull);
    }

    public ConditionalAccessExpressionSyntax WithWhenNotNull(ExpressionSyntax whenNotNull)
    {
        return this.Update(this.Expression, this.OperatorToken, whenNotNull);
    }
  }

  /// <summary>Class which represents the syntax node for member binding expression.</summary>
  public sealed partial class MemberBindingExpressionSyntax : ExpressionSyntax
  {
    private SimpleNameSyntax name;

    internal MemberBindingExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing dot.</summary>
    public SyntaxToken OperatorToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.MemberBindingExpressionSyntax)this.Green).operatorToken, this.Position, 0); }
    }

    /// <summary>SimpleNameSyntax node representing the member being bound to.</summary>
    public SimpleNameSyntax Name 
    {
        get
        {
            return this.GetRed(ref this.name, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.name, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMemberBindingExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitMemberBindingExpression(this);
    }

    public MemberBindingExpressionSyntax Update(SyntaxToken operatorToken, SimpleNameSyntax name)
    {
        if (operatorToken != this.OperatorToken || name != this.Name)
        {
            var newNode = SyntaxFactory.MemberBindingExpression(operatorToken, name);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MemberBindingExpressionSyntax WithOperatorToken(SyntaxToken operatorToken)
    {
        return this.Update(operatorToken, this.Name);
    }

    public MemberBindingExpressionSyntax WithName(SimpleNameSyntax name)
    {
        return this.Update(this.OperatorToken, name);
    }
  }

  /// <summary>Class which represents the syntax node for element binding expression.</summary>
  public sealed partial class ElementBindingExpressionSyntax : ExpressionSyntax
  {
    private BracketedArgumentListSyntax argumentList;

    internal ElementBindingExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>BracketedArgumentListSyntax node representing the list of arguments of the element binding expression.</summary>
    public BracketedArgumentListSyntax ArgumentList 
    {
        get
        {
            return this.GetRedAtZero(ref this.argumentList);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.argumentList);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.argumentList;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitElementBindingExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitElementBindingExpression(this);
    }

    public ElementBindingExpressionSyntax Update(BracketedArgumentListSyntax argumentList)
    {
        if (argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ElementBindingExpression(argumentList);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ElementBindingExpressionSyntax WithArgumentList(BracketedArgumentListSyntax argumentList)
    {
        return this.Update(argumentList);
    }

    public ElementBindingExpressionSyntax AddArgumentListArguments(params ArgumentSyntax[] items)
    {
        return this.WithArgumentList(this.ArgumentList.WithArguments(this.ArgumentList.Arguments.AddRange(items)));
    }
  }

  /// <summary>Class which represents the syntax node for implicit element access expression.</summary>
  public sealed partial class ImplicitElementAccessSyntax : ExpressionSyntax
  {
    private BracketedArgumentListSyntax argumentList;

    internal ImplicitElementAccessSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>BracketedArgumentListSyntax node representing the list of arguments of the implicit element access expression.</summary>
    public BracketedArgumentListSyntax ArgumentList 
    {
        get
        {
            return this.GetRedAtZero(ref this.argumentList);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.argumentList);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.argumentList;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitImplicitElementAccess(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitImplicitElementAccess(this);
    }

    public ImplicitElementAccessSyntax Update(BracketedArgumentListSyntax argumentList)
    {
        if (argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ImplicitElementAccess(argumentList);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ImplicitElementAccessSyntax WithArgumentList(BracketedArgumentListSyntax argumentList)
    {
        return this.Update(argumentList);
    }

    public ImplicitElementAccessSyntax AddArgumentListArguments(params ArgumentSyntax[] items)
    {
        return this.WithArgumentList(this.ArgumentList.WithArguments(this.ArgumentList.Arguments.AddRange(items)));
    }
  }

  /// <summary>Class which represents an expression that has a binary operator.</summary>
  public sealed partial class BinaryExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax left;
    private ExpressionSyntax right;

    internal BinaryExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>ExpressionSyntax node representing the expression on the left of the binary operator.</summary>
    public ExpressionSyntax Left 
    {
        get
        {
            return this.GetRedAtZero(ref this.left);
        }
    }

    /// <summary>SyntaxToken representing the operator of the binary expression.</summary>
    public SyntaxToken OperatorToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BinaryExpressionSyntax)this.Green).operatorToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>ExpressionSyntax node representing the expression on the right of the binary operator.</summary>
    public ExpressionSyntax Right 
    {
        get
        {
            return this.GetRed(ref this.right, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.left);
            case 2: return this.GetRed(ref this.right, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.left;
            case 2: return this.right;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitBinaryExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitBinaryExpression(this);
    }

    public BinaryExpressionSyntax Update(ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right)
    {
        if (left != this.Left || operatorToken != this.OperatorToken || right != this.Right)
        {
            var newNode = SyntaxFactory.BinaryExpression(this.Kind(), left, operatorToken, right);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public BinaryExpressionSyntax WithLeft(ExpressionSyntax left)
    {
        return this.Update(left, this.OperatorToken, this.Right);
    }

    public BinaryExpressionSyntax WithOperatorToken(SyntaxToken operatorToken)
    {
        return this.Update(this.Left, operatorToken, this.Right);
    }

    public BinaryExpressionSyntax WithRight(ExpressionSyntax right)
    {
        return this.Update(this.Left, this.OperatorToken, right);
    }
  }

  /// <summary>Class which represents an expression that has an assignment operator.</summary>
  public sealed partial class AssignmentExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax left;
    private ExpressionSyntax right;

    internal AssignmentExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>ExpressionSyntax node representing the expression on the left of the assignment operator.</summary>
    public ExpressionSyntax Left 
    {
        get
        {
            return this.GetRedAtZero(ref this.left);
        }
    }

    /// <summary>SyntaxToken representing the operator of the assignment expression.</summary>
    public SyntaxToken OperatorToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AssignmentExpressionSyntax)this.Green).operatorToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>ExpressionSyntax node representing the expression on the right of the assignment operator.</summary>
    public ExpressionSyntax Right 
    {
        get
        {
            return this.GetRed(ref this.right, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.left);
            case 2: return this.GetRed(ref this.right, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.left;
            case 2: return this.right;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAssignmentExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAssignmentExpression(this);
    }

    public AssignmentExpressionSyntax Update(ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right)
    {
        if (left != this.Left || operatorToken != this.OperatorToken || right != this.Right)
        {
            var newNode = SyntaxFactory.AssignmentExpression(this.Kind(), left, operatorToken, right);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AssignmentExpressionSyntax WithLeft(ExpressionSyntax left)
    {
        return this.Update(left, this.OperatorToken, this.Right);
    }

    public AssignmentExpressionSyntax WithOperatorToken(SyntaxToken operatorToken)
    {
        return this.Update(this.Left, operatorToken, this.Right);
    }

    public AssignmentExpressionSyntax WithRight(ExpressionSyntax right)
    {
        return this.Update(this.Left, this.OperatorToken, right);
    }
  }

  /// <summary>Class which represents the syntax node for conditional expression.</summary>
  public sealed partial class ConditionalExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax condition;
    private ExpressionSyntax whenTrue;
    private ExpressionSyntax whenFalse;

    internal ConditionalExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>ExpressionSyntax node representing the condition of the conditional expression.</summary>
    public ExpressionSyntax Condition 
    {
        get
        {
            return this.GetRedAtZero(ref this.condition);
        }
    }

    /// <summary>SyntaxToken representing the question mark.</summary>
    public SyntaxToken QuestionToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConditionalExpressionSyntax)this.Green).questionToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>ExpressionSyntax node representing the expression to be executed when the condition is true.</summary>
    public ExpressionSyntax WhenTrue 
    {
        get
        {
            return this.GetRed(ref this.whenTrue, 2);
        }
    }

    /// <summary>SyntaxToken representing the colon.</summary>
    public SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConditionalExpressionSyntax)this.Green).colonToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    /// <summary>ExpressionSyntax node representing the expression to be executed when the condition is false.</summary>
    public ExpressionSyntax WhenFalse 
    {
        get
        {
            return this.GetRed(ref this.whenFalse, 4);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.condition);
            case 2: return this.GetRed(ref this.whenTrue, 2);
            case 4: return this.GetRed(ref this.whenFalse, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.condition;
            case 2: return this.whenTrue;
            case 4: return this.whenFalse;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitConditionalExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitConditionalExpression(this);
    }

    public ConditionalExpressionSyntax Update(ExpressionSyntax condition, SyntaxToken questionToken, ExpressionSyntax whenTrue, SyntaxToken colonToken, ExpressionSyntax whenFalse)
    {
        if (condition != this.Condition || questionToken != this.QuestionToken || whenTrue != this.WhenTrue || colonToken != this.ColonToken || whenFalse != this.WhenFalse)
        {
            var newNode = SyntaxFactory.ConditionalExpression(condition, questionToken, whenTrue, colonToken, whenFalse);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ConditionalExpressionSyntax WithCondition(ExpressionSyntax condition)
    {
        return this.Update(condition, this.QuestionToken, this.WhenTrue, this.ColonToken, this.WhenFalse);
    }

    public ConditionalExpressionSyntax WithQuestionToken(SyntaxToken questionToken)
    {
        return this.Update(this.Condition, questionToken, this.WhenTrue, this.ColonToken, this.WhenFalse);
    }

    public ConditionalExpressionSyntax WithWhenTrue(ExpressionSyntax whenTrue)
    {
        return this.Update(this.Condition, this.QuestionToken, whenTrue, this.ColonToken, this.WhenFalse);
    }

    public ConditionalExpressionSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(this.Condition, this.QuestionToken, this.WhenTrue, colonToken, this.WhenFalse);
    }

    public ConditionalExpressionSyntax WithWhenFalse(ExpressionSyntax whenFalse)
    {
        return this.Update(this.Condition, this.QuestionToken, this.WhenTrue, this.ColonToken, whenFalse);
    }
  }

  /// <summary>Provides the base class from which the classes that represent instance expression syntax nodes are derived. This is an abstract class.</summary>
  public abstract partial class InstanceExpressionSyntax : ExpressionSyntax
  {
    internal InstanceExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  /// <summary>Class which represents the syntax node for a this expression.</summary>
  public sealed partial class ThisExpressionSyntax : InstanceExpressionSyntax
  {
    internal ThisExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the this keyword.</summary>
    public SyntaxToken Token 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ThisExpressionSyntax)this.Green).token, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitThisExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitThisExpression(this);
    }

    public ThisExpressionSyntax Update(SyntaxToken token)
    {
        if (token != this.Token)
        {
            var newNode = SyntaxFactory.ThisExpression(token);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ThisExpressionSyntax WithToken(SyntaxToken token)
    {
        return this.Update(token);
    }
  }

  /// <summary>Class which represents the syntax node for a base expression.</summary>
  public sealed partial class BaseExpressionSyntax : InstanceExpressionSyntax
  {
    internal BaseExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the base keyword.</summary>
    public SyntaxToken Token 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BaseExpressionSyntax)this.Green).token, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitBaseExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitBaseExpression(this);
    }

    public BaseExpressionSyntax Update(SyntaxToken token)
    {
        if (token != this.Token)
        {
            var newNode = SyntaxFactory.BaseExpression(token);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public BaseExpressionSyntax WithToken(SyntaxToken token)
    {
        return this.Update(token);
    }
  }

  /// <summary>Class which represents the syntax node for a literal expression.</summary>
  public sealed partial class LiteralExpressionSyntax : ExpressionSyntax
  {
    internal LiteralExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the keyword corresponding to the kind of the literal expression.</summary>
    public SyntaxToken Token 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LiteralExpressionSyntax)this.Green).token, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitLiteralExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitLiteralExpression(this);
    }

    public LiteralExpressionSyntax Update(SyntaxToken token)
    {
        if (token != this.Token)
        {
            var newNode = SyntaxFactory.LiteralExpression(this.Kind(), token);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public LiteralExpressionSyntax WithToken(SyntaxToken token)
    {
        return this.Update(token);
    }
  }

  /// <summary>Class which represents the syntax node for MakeRef expression.</summary>
  public sealed partial class MakeRefExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;

    internal MakeRefExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the MakeRefKeyword.</summary>
    public SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.MakeRefExpressionSyntax)this.Green).keyword, this.Position, 0); }
    }

    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.MakeRefExpressionSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>Argument of the primary function.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 2);
        }
    }

    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.MakeRefExpressionSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.expression, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMakeRefExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitMakeRefExpression(this);
    }

    public MakeRefExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.MakeRefExpression(keyword, openParenToken, expression, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MakeRefExpressionSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword, this.OpenParenToken, this.Expression, this.CloseParenToken);
    }

    public MakeRefExpressionSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.Keyword, openParenToken, this.Expression, this.CloseParenToken);
    }

    public MakeRefExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.Keyword, this.OpenParenToken, expression, this.CloseParenToken);
    }

    public MakeRefExpressionSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.Keyword, this.OpenParenToken, this.Expression, closeParenToken);
    }
  }

  /// <summary>Class which represents the syntax node for RefType expression.</summary>
  public sealed partial class RefTypeExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;

    internal RefTypeExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the RefTypeKeyword.</summary>
    public SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RefTypeExpressionSyntax)this.Green).keyword, this.Position, 0); }
    }

    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RefTypeExpressionSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>Argument of the primary function.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 2);
        }
    }

    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RefTypeExpressionSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.expression, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRefTypeExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitRefTypeExpression(this);
    }

    public RefTypeExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.RefTypeExpression(keyword, openParenToken, expression, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public RefTypeExpressionSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword, this.OpenParenToken, this.Expression, this.CloseParenToken);
    }

    public RefTypeExpressionSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.Keyword, openParenToken, this.Expression, this.CloseParenToken);
    }

    public RefTypeExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.Keyword, this.OpenParenToken, expression, this.CloseParenToken);
    }

    public RefTypeExpressionSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.Keyword, this.OpenParenToken, this.Expression, closeParenToken);
    }
  }

  /// <summary>Class which represents the syntax node for RefValue expression.</summary>
  public sealed partial class RefValueExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;
    private TypeSyntax type;

    internal RefValueExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the RefValueKeyword.</summary>
    public SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RefValueExpressionSyntax)this.Green).keyword, this.Position, 0); }
    }

    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RefValueExpressionSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>Typed reference expression.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 2);
        }
    }

    /// <summary>Comma separating the arguments.</summary>
    public SyntaxToken Comma 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RefValueExpressionSyntax)this.Green).comma, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    /// <summary>The type of the value.</summary>
    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 4);
        }
    }

    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RefValueExpressionSyntax)this.Green).closeParenToken, this.GetChildPosition(5), this.GetChildIndex(5)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.expression, 2);
            case 4: return this.GetRed(ref this.type, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.expression;
            case 4: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRefValueExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitRefValueExpression(this);
    }

    public RefValueExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken comma, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || comma != this.Comma || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.RefValueExpression(keyword, openParenToken, expression, comma, type, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public RefValueExpressionSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword, this.OpenParenToken, this.Expression, this.Comma, this.Type, this.CloseParenToken);
    }

    public RefValueExpressionSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.Keyword, openParenToken, this.Expression, this.Comma, this.Type, this.CloseParenToken);
    }

    public RefValueExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.Keyword, this.OpenParenToken, expression, this.Comma, this.Type, this.CloseParenToken);
    }

    public RefValueExpressionSyntax WithComma(SyntaxToken comma)
    {
        return this.Update(this.Keyword, this.OpenParenToken, this.Expression, comma, this.Type, this.CloseParenToken);
    }

    public RefValueExpressionSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.Keyword, this.OpenParenToken, this.Expression, this.Comma, type, this.CloseParenToken);
    }

    public RefValueExpressionSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.Keyword, this.OpenParenToken, this.Expression, this.Comma, this.Type, closeParenToken);
    }
  }

  /// <summary>Class which represents the syntax node for Checked or Unchecked expression.</summary>
  public sealed partial class CheckedExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;

    internal CheckedExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the checked or unchecked keyword.</summary>
    public SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CheckedExpressionSyntax)this.Green).keyword, this.Position, 0); }
    }

    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CheckedExpressionSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>Argument of the primary function.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 2);
        }
    }

    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CheckedExpressionSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.expression, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCheckedExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCheckedExpression(this);
    }

    public CheckedExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.CheckedExpression(this.Kind(), keyword, openParenToken, expression, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CheckedExpressionSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword, this.OpenParenToken, this.Expression, this.CloseParenToken);
    }

    public CheckedExpressionSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.Keyword, openParenToken, this.Expression, this.CloseParenToken);
    }

    public CheckedExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.Keyword, this.OpenParenToken, expression, this.CloseParenToken);
    }

    public CheckedExpressionSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.Keyword, this.OpenParenToken, this.Expression, closeParenToken);
    }
  }

  /// <summary>Class which represents the syntax node for Default expression.</summary>
  public sealed partial class DefaultExpressionSyntax : ExpressionSyntax
  {
    private TypeSyntax type;

    internal DefaultExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the DefaultKeyword.</summary>
    public SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DefaultExpressionSyntax)this.Green).keyword, this.Position, 0); }
    }

    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DefaultExpressionSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>Argument of the primary function.</summary>
    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 2);
        }
    }

    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DefaultExpressionSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.type, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitDefaultExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitDefaultExpression(this);
    }

    public DefaultExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.DefaultExpression(keyword, openParenToken, type, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public DefaultExpressionSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword, this.OpenParenToken, this.Type, this.CloseParenToken);
    }

    public DefaultExpressionSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.Keyword, openParenToken, this.Type, this.CloseParenToken);
    }

    public DefaultExpressionSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.Keyword, this.OpenParenToken, type, this.CloseParenToken);
    }

    public DefaultExpressionSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.Keyword, this.OpenParenToken, this.Type, closeParenToken);
    }
  }

  /// <summary>Class which represents the syntax node for TypeOf expression.</summary>
  public sealed partial class TypeOfExpressionSyntax : ExpressionSyntax
  {
    private TypeSyntax type;

    internal TypeOfExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the TypeOfKeyword.</summary>
    public SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TypeOfExpressionSyntax)this.Green).keyword, this.Position, 0); }
    }

    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TypeOfExpressionSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>The expression to return type of.</summary>
    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 2);
        }
    }

    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TypeOfExpressionSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.type, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitTypeOfExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitTypeOfExpression(this);
    }

    public TypeOfExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.TypeOfExpression(keyword, openParenToken, type, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public TypeOfExpressionSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword, this.OpenParenToken, this.Type, this.CloseParenToken);
    }

    public TypeOfExpressionSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.Keyword, openParenToken, this.Type, this.CloseParenToken);
    }

    public TypeOfExpressionSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.Keyword, this.OpenParenToken, type, this.CloseParenToken);
    }

    public TypeOfExpressionSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.Keyword, this.OpenParenToken, this.Type, closeParenToken);
    }
  }

  /// <summary>Class which represents the syntax node for SizeOf expression.</summary>
  public sealed partial class SizeOfExpressionSyntax : ExpressionSyntax
  {
    private TypeSyntax type;

    internal SizeOfExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the SizeOfKeyword.</summary>
    public SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SizeOfExpressionSyntax)this.Green).keyword, this.Position, 0); }
    }

    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SizeOfExpressionSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>Argument of the primary function.</summary>
    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 2);
        }
    }

    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SizeOfExpressionSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.type, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitSizeOfExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitSizeOfExpression(this);
    }

    public SizeOfExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.SizeOfExpression(keyword, openParenToken, type, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public SizeOfExpressionSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword, this.OpenParenToken, this.Type, this.CloseParenToken);
    }

    public SizeOfExpressionSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.Keyword, openParenToken, this.Type, this.CloseParenToken);
    }

    public SizeOfExpressionSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.Keyword, this.OpenParenToken, type, this.CloseParenToken);
    }

    public SizeOfExpressionSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.Keyword, this.OpenParenToken, this.Type, closeParenToken);
    }
  }

  /// <summary>Class which represents the syntax node for invocation expression.</summary>
  public sealed partial class InvocationExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;
    private ArgumentListSyntax argumentList;

    internal InvocationExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>ExpressionSyntax node representing the expression part of the invocation.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRedAtZero(ref this.expression);
        }
    }

    /// <summary>ArgumentListSyntax node representing the list of arguments of the invocation expression.</summary>
    public ArgumentListSyntax ArgumentList 
    {
        get
        {
            return this.GetRed(ref this.argumentList, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.expression);
            case 1: return this.GetRed(ref this.argumentList, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 1: return this.argumentList;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitInvocationExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitInvocationExpression(this);
    }

    public InvocationExpressionSyntax Update(ExpressionSyntax expression, ArgumentListSyntax argumentList)
    {
        if (expression != this.Expression || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.InvocationExpression(expression, argumentList);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public InvocationExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(expression, this.ArgumentList);
    }

    public InvocationExpressionSyntax WithArgumentList(ArgumentListSyntax argumentList)
    {
        return this.Update(this.Expression, argumentList);
    }

    public InvocationExpressionSyntax AddArgumentListArguments(params ArgumentSyntax[] items)
    {
        return this.WithArgumentList(this.ArgumentList.WithArguments(this.ArgumentList.Arguments.AddRange(items)));
    }
  }

  /// <summary>Class which represents the syntax node for element access expression.</summary>
  public sealed partial class ElementAccessExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;
    private BracketedArgumentListSyntax argumentList;

    internal ElementAccessExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>ExpressionSyntax node representing the expression which is accessing the element.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRedAtZero(ref this.expression);
        }
    }

    /// <summary>BracketedArgumentListSyntax node representing the list of arguments of the element access expression.</summary>
    public BracketedArgumentListSyntax ArgumentList 
    {
        get
        {
            return this.GetRed(ref this.argumentList, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.expression);
            case 1: return this.GetRed(ref this.argumentList, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 1: return this.argumentList;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitElementAccessExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitElementAccessExpression(this);
    }

    public ElementAccessExpressionSyntax Update(ExpressionSyntax expression, BracketedArgumentListSyntax argumentList)
    {
        if (expression != this.Expression || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ElementAccessExpression(expression, argumentList);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ElementAccessExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(expression, this.ArgumentList);
    }

    public ElementAccessExpressionSyntax WithArgumentList(BracketedArgumentListSyntax argumentList)
    {
        return this.Update(this.Expression, argumentList);
    }

    public ElementAccessExpressionSyntax AddArgumentListArguments(params ArgumentSyntax[] items)
    {
        return this.WithArgumentList(this.ArgumentList.WithArguments(this.ArgumentList.Arguments.AddRange(items)));
    }
  }

  /// <summary>Provides the base class from which the classes that represent argument list syntax nodes are derived. This is an abstract class.</summary>
  public abstract partial class BaseArgumentListSyntax : CSharpSyntaxNode
  {
    internal BaseArgumentListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>SeparatedSyntaxList of ArgumentSyntax nodes representing the list of arguments.</summary>
    public abstract SeparatedSyntaxList<ArgumentSyntax> Arguments { get; }
  }

  /// <summary>Class which represents the syntax node for the list of arguments.</summary>
  public sealed partial class ArgumentListSyntax : BaseArgumentListSyntax
  {
    private SyntaxNode arguments;

    internal ArgumentListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ArgumentListSyntax)this.Green).openParenToken, this.Position, 0); }
    }

    /// <summary>SeparatedSyntaxList of ArgumentSyntax representing the list of arguments.</summary>
    public override SeparatedSyntaxList<ArgumentSyntax> Arguments 
    {
        get
        {
            var red = this.GetRed(ref this.arguments, 1);
            if (red != null)
                return new SeparatedSyntaxList<ArgumentSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<ArgumentSyntax>);
        }
    }

    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ArgumentListSyntax)this.Green).closeParenToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.arguments, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.arguments;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitArgumentList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitArgumentList(this);
    }

    public ArgumentListSyntax Update(SyntaxToken openParenToken, SeparatedSyntaxList<ArgumentSyntax> arguments, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || arguments != this.Arguments || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ArgumentList(openParenToken, arguments, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ArgumentListSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(openParenToken, this.Arguments, this.CloseParenToken);
    }

    public ArgumentListSyntax WithArguments(SeparatedSyntaxList<ArgumentSyntax> arguments)
    {
        return this.Update(this.OpenParenToken, arguments, this.CloseParenToken);
    }

    public ArgumentListSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.OpenParenToken, this.Arguments, closeParenToken);
    }

    public ArgumentListSyntax AddArguments(params ArgumentSyntax[] items)
    {
        return this.WithArguments(this.Arguments.AddRange(items));
    }
  }

  /// <summary>Class which represents the syntax node for bracketed argument list.</summary>
  public sealed partial class BracketedArgumentListSyntax : BaseArgumentListSyntax
  {
    private SyntaxNode arguments;

    internal BracketedArgumentListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing open bracket.</summary>
    public SyntaxToken OpenBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BracketedArgumentListSyntax)this.Green).openBracketToken, this.Position, 0); }
    }

    /// <summary>SeparatedSyntaxList of ArgumentSyntax representing the list of arguments.</summary>
    public override SeparatedSyntaxList<ArgumentSyntax> Arguments 
    {
        get
        {
            var red = this.GetRed(ref this.arguments, 1);
            if (red != null)
                return new SeparatedSyntaxList<ArgumentSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<ArgumentSyntax>);
        }
    }

    /// <summary>SyntaxToken representing close bracket.</summary>
    public SyntaxToken CloseBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BracketedArgumentListSyntax)this.Green).closeBracketToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.arguments, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.arguments;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitBracketedArgumentList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitBracketedArgumentList(this);
    }

    public BracketedArgumentListSyntax Update(SyntaxToken openBracketToken, SeparatedSyntaxList<ArgumentSyntax> arguments, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || arguments != this.Arguments || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.BracketedArgumentList(openBracketToken, arguments, closeBracketToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public BracketedArgumentListSyntax WithOpenBracketToken(SyntaxToken openBracketToken)
    {
        return this.Update(openBracketToken, this.Arguments, this.CloseBracketToken);
    }

    public BracketedArgumentListSyntax WithArguments(SeparatedSyntaxList<ArgumentSyntax> arguments)
    {
        return this.Update(this.OpenBracketToken, arguments, this.CloseBracketToken);
    }

    public BracketedArgumentListSyntax WithCloseBracketToken(SyntaxToken closeBracketToken)
    {
        return this.Update(this.OpenBracketToken, this.Arguments, closeBracketToken);
    }

    public BracketedArgumentListSyntax AddArguments(params ArgumentSyntax[] items)
    {
        return this.WithArguments(this.Arguments.AddRange(items));
    }
  }

  /// <summary>Class which represents the syntax node for argument.</summary>
  public sealed partial class ArgumentSyntax : CSharpSyntaxNode
  {
    private NameColonSyntax nameColon;
    private ExpressionSyntax expression;

    internal ArgumentSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>NameColonSyntax node representing the optional name arguments.</summary>
    public NameColonSyntax NameColon 
    {
        get
        {
            return this.GetRedAtZero(ref this.nameColon);
        }
    }

    /// <summary>SyntaxToken representing the optional ref or out keyword.</summary>
    public SyntaxToken RefOrOutKeyword 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ArgumentSyntax)this.Green).refOrOutKeyword;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxToken);
        }
    }

    /// <summary>ExpressionSyntax node representing the argument.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.nameColon);
            case 2: return this.GetRed(ref this.expression, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.nameColon;
            case 2: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitArgument(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitArgument(this);
    }

    public ArgumentSyntax Update(NameColonSyntax nameColon, SyntaxToken refOrOutKeyword, ExpressionSyntax expression)
    {
        if (nameColon != this.NameColon || refOrOutKeyword != this.RefOrOutKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.Argument(nameColon, refOrOutKeyword, expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ArgumentSyntax WithNameColon(NameColonSyntax nameColon)
    {
        return this.Update(nameColon, this.RefOrOutKeyword, this.Expression);
    }

    public ArgumentSyntax WithRefOrOutKeyword(SyntaxToken refOrOutKeyword)
    {
        return this.Update(this.NameColon, refOrOutKeyword, this.Expression);
    }

    public ArgumentSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.NameColon, this.RefOrOutKeyword, expression);
    }
  }

  /// <summary>Class which represents the syntax node for name colon syntax.</summary>
  public sealed partial class NameColonSyntax : CSharpSyntaxNode
  {
    private IdentifierNameSyntax name;

    internal NameColonSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>IdentifierNameSyntax representing the identifier name.</summary>
    public IdentifierNameSyntax Name 
    {
        get
        {
            return this.GetRedAtZero(ref this.name);
        }
    }

    /// <summary>SyntaxToken representing colon.</summary>
    public SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.NameColonSyntax)this.Green).colonToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.name);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitNameColon(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitNameColon(this);
    }

    public NameColonSyntax Update(IdentifierNameSyntax name, SyntaxToken colonToken)
    {
        if (name != this.Name || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.NameColon(name, colonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public NameColonSyntax WithName(IdentifierNameSyntax name)
    {
        return this.Update(name, this.ColonToken);
    }

    public NameColonSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(this.Name, colonToken);
    }
  }

  /// <summary>Class which represents the syntax node for the variable declaration in an out var declaration or a deconstruction declaration.</summary>
  public sealed partial class DeclarationExpressionSyntax : ExpressionSyntax
  {
    private TypeSyntax type;
    private VariableDesignationSyntax designation;

    internal DeclarationExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRedAtZero(ref this.type);
        }
    }

    /// <summary>Declaration representing the variable declared in an out parameter or deconstruction.</summary>
    public VariableDesignationSyntax Designation 
    {
        get
        {
            return this.GetRed(ref this.designation, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.type);
            case 1: return this.GetRed(ref this.designation, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            case 1: return this.designation;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitDeclarationExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitDeclarationExpression(this);
    }

    public DeclarationExpressionSyntax Update(TypeSyntax type, VariableDesignationSyntax designation)
    {
        if (type != this.Type || designation != this.Designation)
        {
            var newNode = SyntaxFactory.DeclarationExpression(type, designation);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public DeclarationExpressionSyntax WithType(TypeSyntax type)
    {
        return this.Update(type, this.Designation);
    }

    public DeclarationExpressionSyntax WithDesignation(VariableDesignationSyntax designation)
    {
        return this.Update(this.Type, designation);
    }
  }

  /// <summary>Class which represents the syntax node for cast expression.</summary>
  public sealed partial class CastExpressionSyntax : ExpressionSyntax
  {
    private TypeSyntax type;
    private ExpressionSyntax expression;

    internal CastExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CastExpressionSyntax)this.Green).openParenToken, this.Position, 0); }
    }

    /// <summary>TypeSyntax node representing the type to which the expression is being cast.</summary>
    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 1);
        }
    }

    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CastExpressionSyntax)this.Green).closeParenToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    /// <summary>ExpressionSyntax node representing the expression that is being casted.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 3);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.type, 1);
            case 3: return this.GetRed(ref this.expression, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.type;
            case 3: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCastExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCastExpression(this);
    }

    public CastExpressionSyntax Update(SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, ExpressionSyntax expression)
    {
        if (openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.CastExpression(openParenToken, type, closeParenToken, expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CastExpressionSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(openParenToken, this.Type, this.CloseParenToken, this.Expression);
    }

    public CastExpressionSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.OpenParenToken, type, this.CloseParenToken, this.Expression);
    }

    public CastExpressionSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.OpenParenToken, this.Type, closeParenToken, this.Expression);
    }

    public CastExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.OpenParenToken, this.Type, this.CloseParenToken, expression);
    }
  }

  /// <summary>Provides the base class from which the classes that represent anonymous function expressions are derived.</summary>
  public abstract partial class AnonymousFunctionExpressionSyntax : ExpressionSyntax
  {
    internal AnonymousFunctionExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>Gets the "async" token.</summary>
    public abstract SyntaxToken AsyncKeyword { get; }

    /// <summary>ExpressionSyntax or BlockSyntax representing the body of the lambda expression.</summary>
    public abstract CSharpSyntaxNode Body { get; }
  }

  /// <summary>Class which represents the syntax node for anonymous method expression.</summary>
  public sealed partial class AnonymousMethodExpressionSyntax : AnonymousFunctionExpressionSyntax
  {
    private ParameterListSyntax parameterList;
    private CSharpSyntaxNode body;

    internal AnonymousMethodExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the "async" token.</summary>
    public override SyntaxToken AsyncKeyword 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AnonymousMethodExpressionSyntax)this.Green).asyncKeyword;
            if (slot != null)
                return new SyntaxToken(this, slot, this.Position, 0);

            return default(SyntaxToken);
        }
    }

    /// <summary>SyntaxToken representing the delegate keyword.</summary>
    public SyntaxToken DelegateKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AnonymousMethodExpressionSyntax)this.Green).delegateKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>List of parameters of the anonymous method expression, or null if there no parameters are specified.</summary>
    public ParameterListSyntax ParameterList 
    {
        get
        {
            return this.GetRed(ref this.parameterList, 2);
        }
    }

    /// <summary>BlockSyntax node representing the body of the anonymous method.</summary>
    public override CSharpSyntaxNode Body 
    {
        get
        {
            return this.GetRed(ref this.body, 3);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.parameterList, 2);
            case 3: return this.GetRed(ref this.body, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.parameterList;
            case 3: return this.body;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAnonymousMethodExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAnonymousMethodExpression(this);
    }

    public AnonymousMethodExpressionSyntax Update(SyntaxToken asyncKeyword, SyntaxToken delegateKeyword, ParameterListSyntax parameterList, CSharpSyntaxNode body)
    {
        if (asyncKeyword != this.AsyncKeyword || delegateKeyword != this.DelegateKeyword || parameterList != this.ParameterList || body != this.Body)
        {
            var newNode = SyntaxFactory.AnonymousMethodExpression(asyncKeyword, delegateKeyword, parameterList, body);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AnonymousMethodExpressionSyntax WithAsyncKeyword(SyntaxToken asyncKeyword)
    {
        return this.Update(asyncKeyword, this.DelegateKeyword, this.ParameterList, this.Body);
    }

    public AnonymousMethodExpressionSyntax WithDelegateKeyword(SyntaxToken delegateKeyword)
    {
        return this.Update(this.AsyncKeyword, delegateKeyword, this.ParameterList, this.Body);
    }

    public AnonymousMethodExpressionSyntax WithParameterList(ParameterListSyntax parameterList)
    {
        return this.Update(this.AsyncKeyword, this.DelegateKeyword, parameterList, this.Body);
    }

    public AnonymousMethodExpressionSyntax WithBody(CSharpSyntaxNode body)
    {
        return this.Update(this.AsyncKeyword, this.DelegateKeyword, this.ParameterList, body);
    }

    public AnonymousMethodExpressionSyntax AddParameterListParameters(params ParameterSyntax[] items)
    {
        var parameterList = this.ParameterList ?? SyntaxFactory.ParameterList();
        return this.WithParameterList(parameterList.WithParameters(parameterList.Parameters.AddRange(items)));
    }
  }

  /// <summary>Provides the base class from which the classes that represent lambda expressions are derived.</summary>
  public abstract partial class LambdaExpressionSyntax : AnonymousFunctionExpressionSyntax
  {
    internal LambdaExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing equals greater than.</summary>
    public abstract SyntaxToken ArrowToken { get; }
  }

  /// <summary>Class which represents the syntax node for a simple lambda expression.</summary>
  public sealed partial class SimpleLambdaExpressionSyntax : LambdaExpressionSyntax
  {
    private ParameterSyntax parameter;
    private CSharpSyntaxNode body;

    internal SimpleLambdaExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the "async" token.</summary>
    public override SyntaxToken AsyncKeyword 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SimpleLambdaExpressionSyntax)this.Green).asyncKeyword;
            if (slot != null)
                return new SyntaxToken(this, slot, this.Position, 0);

            return default(SyntaxToken);
        }
    }

    /// <summary>ParameterSyntax node representing the parameter of the lambda expression.</summary>
    public ParameterSyntax Parameter 
    {
        get
        {
            return this.GetRed(ref this.parameter, 1);
        }
    }

    /// <summary>SyntaxToken representing equals greater than.</summary>
    public override SyntaxToken ArrowToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SimpleLambdaExpressionSyntax)this.Green).arrowToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    /// <summary>SyntaxNode representing the body of the lambda expression.</summary>
    public override CSharpSyntaxNode Body 
    {
        get
        {
            return this.GetRed(ref this.body, 3);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.parameter, 1);
            case 3: return this.GetRed(ref this.body, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.parameter;
            case 3: return this.body;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitSimpleLambdaExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitSimpleLambdaExpression(this);
    }

    public SimpleLambdaExpressionSyntax Update(SyntaxToken asyncKeyword, ParameterSyntax parameter, SyntaxToken arrowToken, CSharpSyntaxNode body)
    {
        if (asyncKeyword != this.AsyncKeyword || parameter != this.Parameter || arrowToken != this.ArrowToken || body != this.Body)
        {
            var newNode = SyntaxFactory.SimpleLambdaExpression(asyncKeyword, parameter, arrowToken, body);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public SimpleLambdaExpressionSyntax WithAsyncKeyword(SyntaxToken asyncKeyword)
    {
        return this.Update(asyncKeyword, this.Parameter, this.ArrowToken, this.Body);
    }

    public SimpleLambdaExpressionSyntax WithParameter(ParameterSyntax parameter)
    {
        return this.Update(this.AsyncKeyword, parameter, this.ArrowToken, this.Body);
    }

    public SimpleLambdaExpressionSyntax WithArrowToken(SyntaxToken arrowToken)
    {
        return this.Update(this.AsyncKeyword, this.Parameter, arrowToken, this.Body);
    }

    public SimpleLambdaExpressionSyntax WithBody(CSharpSyntaxNode body)
    {
        return this.Update(this.AsyncKeyword, this.Parameter, this.ArrowToken, body);
    }

    public SimpleLambdaExpressionSyntax AddParameterAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithParameter(this.Parameter.WithAttributeLists(this.Parameter.AttributeLists.AddRange(items)));
    }

    public SimpleLambdaExpressionSyntax AddParameterModifiers(params SyntaxToken[] items)
    {
        return this.WithParameter(this.Parameter.WithModifiers(this.Parameter.Modifiers.AddRange(items)));
    }
  }

  public sealed partial class RefExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;

    internal RefExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken RefKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RefExpressionSyntax)this.Green).refKeyword, this.Position, 0); }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.expression, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRefExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitRefExpression(this);
    }

    public RefExpressionSyntax Update(SyntaxToken refKeyword, ExpressionSyntax expression)
    {
        if (refKeyword != this.RefKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.RefExpression(refKeyword, expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public RefExpressionSyntax WithRefKeyword(SyntaxToken refKeyword)
    {
        return this.Update(refKeyword, this.Expression);
    }

    public RefExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.RefKeyword, expression);
    }
  }

  /// <summary>Class which represents the syntax node for parenthesized lambda expression.</summary>
  public sealed partial class ParenthesizedLambdaExpressionSyntax : LambdaExpressionSyntax
  {
    private ParameterListSyntax parameterList;
    private CSharpSyntaxNode body;

    internal ParenthesizedLambdaExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the "async" token.</summary>
    public override SyntaxToken AsyncKeyword 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ParenthesizedLambdaExpressionSyntax)this.Green).asyncKeyword;
            if (slot != null)
                return new SyntaxToken(this, slot, this.Position, 0);

            return default(SyntaxToken);
        }
    }

    /// <summary>ParameterListSyntax node representing the list of parameters for the lambda expression.</summary>
    public ParameterListSyntax ParameterList 
    {
        get
        {
            return this.GetRed(ref this.parameterList, 1);
        }
    }

    /// <summary>SyntaxToken representing equals greater than.</summary>
    public override SyntaxToken ArrowToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ParenthesizedLambdaExpressionSyntax)this.Green).arrowToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    /// <summary>SyntaxNode representing the body of the lambda expression.</summary>
    public override CSharpSyntaxNode Body 
    {
        get
        {
            return this.GetRed(ref this.body, 3);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.parameterList, 1);
            case 3: return this.GetRed(ref this.body, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.parameterList;
            case 3: return this.body;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitParenthesizedLambdaExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitParenthesizedLambdaExpression(this);
    }

    public ParenthesizedLambdaExpressionSyntax Update(SyntaxToken asyncKeyword, ParameterListSyntax parameterList, SyntaxToken arrowToken, CSharpSyntaxNode body)
    {
        if (asyncKeyword != this.AsyncKeyword || parameterList != this.ParameterList || arrowToken != this.ArrowToken || body != this.Body)
        {
            var newNode = SyntaxFactory.ParenthesizedLambdaExpression(asyncKeyword, parameterList, arrowToken, body);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ParenthesizedLambdaExpressionSyntax WithAsyncKeyword(SyntaxToken asyncKeyword)
    {
        return this.Update(asyncKeyword, this.ParameterList, this.ArrowToken, this.Body);
    }

    public ParenthesizedLambdaExpressionSyntax WithParameterList(ParameterListSyntax parameterList)
    {
        return this.Update(this.AsyncKeyword, parameterList, this.ArrowToken, this.Body);
    }

    public ParenthesizedLambdaExpressionSyntax WithArrowToken(SyntaxToken arrowToken)
    {
        return this.Update(this.AsyncKeyword, this.ParameterList, arrowToken, this.Body);
    }

    public ParenthesizedLambdaExpressionSyntax WithBody(CSharpSyntaxNode body)
    {
        return this.Update(this.AsyncKeyword, this.ParameterList, this.ArrowToken, body);
    }

    public ParenthesizedLambdaExpressionSyntax AddParameterListParameters(params ParameterSyntax[] items)
    {
        return this.WithParameterList(this.ParameterList.WithParameters(this.ParameterList.Parameters.AddRange(items)));
    }
  }

  /// <summary>Class which represents the syntax node for initializer expression.</summary>
  public sealed partial class InitializerExpressionSyntax : ExpressionSyntax
  {
    private SyntaxNode expressions;

    internal InitializerExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the open brace.</summary>
    public SyntaxToken OpenBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InitializerExpressionSyntax)this.Green).openBraceToken, this.Position, 0); }
    }

    /// <summary>SeparatedSyntaxList of ExpressionSyntax representing the list of expressions in the initializer expression.</summary>
    public SeparatedSyntaxList<ExpressionSyntax> Expressions 
    {
        get
        {
            var red = this.GetRed(ref this.expressions, 1);
            if (red != null)
                return new SeparatedSyntaxList<ExpressionSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<ExpressionSyntax>);
        }
    }

    /// <summary>SyntaxToken representing the close brace.</summary>
    public SyntaxToken CloseBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InitializerExpressionSyntax)this.Green).closeBraceToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.expressions, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.expressions;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitInitializerExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitInitializerExpression(this);
    }

    public InitializerExpressionSyntax Update(SyntaxToken openBraceToken, SeparatedSyntaxList<ExpressionSyntax> expressions, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || expressions != this.Expressions || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.InitializerExpression(this.Kind(), openBraceToken, expressions, closeBraceToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public InitializerExpressionSyntax WithOpenBraceToken(SyntaxToken openBraceToken)
    {
        return this.Update(openBraceToken, this.Expressions, this.CloseBraceToken);
    }

    public InitializerExpressionSyntax WithExpressions(SeparatedSyntaxList<ExpressionSyntax> expressions)
    {
        return this.Update(this.OpenBraceToken, expressions, this.CloseBraceToken);
    }

    public InitializerExpressionSyntax WithCloseBraceToken(SyntaxToken closeBraceToken)
    {
        return this.Update(this.OpenBraceToken, this.Expressions, closeBraceToken);
    }

    public InitializerExpressionSyntax AddExpressions(params ExpressionSyntax[] items)
    {
        return this.WithExpressions(this.Expressions.AddRange(items));
    }
  }

  /// <summary>Class which represents the syntax node for object creation expression.</summary>
  public sealed partial class ObjectCreationExpressionSyntax : ExpressionSyntax
  {
    private TypeSyntax type;
    private ArgumentListSyntax argumentList;
    private InitializerExpressionSyntax initializer;

    internal ObjectCreationExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public SyntaxToken NewKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ObjectCreationExpressionSyntax)this.Green).newKeyword, this.Position, 0); }
    }

    /// <summary>TypeSyntax representing the type of the object being created.</summary>
    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 1);
        }
    }

    /// <summary>ArgumentListSyntax representing the list of arguments passed as part of the object creation expression.</summary>
    public ArgumentListSyntax ArgumentList 
    {
        get
        {
            return this.GetRed(ref this.argumentList, 2);
        }
    }

    /// <summary>InitializerExpressionSyntax representing the initializer expression for the object being created.</summary>
    public InitializerExpressionSyntax Initializer 
    {
        get
        {
            return this.GetRed(ref this.initializer, 3);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.type, 1);
            case 2: return this.GetRed(ref this.argumentList, 2);
            case 3: return this.GetRed(ref this.initializer, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.type;
            case 2: return this.argumentList;
            case 3: return this.initializer;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitObjectCreationExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitObjectCreationExpression(this);
    }

    public ObjectCreationExpressionSyntax Update(SyntaxToken newKeyword, TypeSyntax type, ArgumentListSyntax argumentList, InitializerExpressionSyntax initializer)
    {
        if (newKeyword != this.NewKeyword || type != this.Type || argumentList != this.ArgumentList || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ObjectCreationExpression(newKeyword, type, argumentList, initializer);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ObjectCreationExpressionSyntax WithNewKeyword(SyntaxToken newKeyword)
    {
        return this.Update(newKeyword, this.Type, this.ArgumentList, this.Initializer);
    }

    public ObjectCreationExpressionSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.NewKeyword, type, this.ArgumentList, this.Initializer);
    }

    public ObjectCreationExpressionSyntax WithArgumentList(ArgumentListSyntax argumentList)
    {
        return this.Update(this.NewKeyword, this.Type, argumentList, this.Initializer);
    }

    public ObjectCreationExpressionSyntax WithInitializer(InitializerExpressionSyntax initializer)
    {
        return this.Update(this.NewKeyword, this.Type, this.ArgumentList, initializer);
    }

    public ObjectCreationExpressionSyntax AddArgumentListArguments(params ArgumentSyntax[] items)
    {
        var argumentList = this.ArgumentList ?? SyntaxFactory.ArgumentList();
        return this.WithArgumentList(argumentList.WithArguments(argumentList.Arguments.AddRange(items)));
    }
  }

  public sealed partial class AnonymousObjectMemberDeclaratorSyntax : CSharpSyntaxNode
  {
    private NameEqualsSyntax nameEquals;
    private ExpressionSyntax expression;

    internal AnonymousObjectMemberDeclaratorSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>NameEqualsSyntax representing the optional name of the member being initialized.</summary>
    public NameEqualsSyntax NameEquals 
    {
        get
        {
            return this.GetRedAtZero(ref this.nameEquals);
        }
    }

    /// <summary>ExpressionSyntax representing the value the member is initialized with.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.nameEquals);
            case 1: return this.GetRed(ref this.expression, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.nameEquals;
            case 1: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAnonymousObjectMemberDeclarator(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAnonymousObjectMemberDeclarator(this);
    }

    public AnonymousObjectMemberDeclaratorSyntax Update(NameEqualsSyntax nameEquals, ExpressionSyntax expression)
    {
        if (nameEquals != this.NameEquals || expression != this.Expression)
        {
            var newNode = SyntaxFactory.AnonymousObjectMemberDeclarator(nameEquals, expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AnonymousObjectMemberDeclaratorSyntax WithNameEquals(NameEqualsSyntax nameEquals)
    {
        return this.Update(nameEquals, this.Expression);
    }

    public AnonymousObjectMemberDeclaratorSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.NameEquals, expression);
    }
  }

  /// <summary>Class which represents the syntax node for anonymous object creation expression.</summary>
  public sealed partial class AnonymousObjectCreationExpressionSyntax : ExpressionSyntax
  {
    private SyntaxNode initializers;

    internal AnonymousObjectCreationExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public SyntaxToken NewKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AnonymousObjectCreationExpressionSyntax)this.Green).newKeyword, this.Position, 0); }
    }

    /// <summary>SyntaxToken representing the open brace.</summary>
    public SyntaxToken OpenBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AnonymousObjectCreationExpressionSyntax)this.Green).openBraceToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>SeparatedSyntaxList of AnonymousObjectMemberDeclaratorSyntax representing the list of object member initializers.</summary>
    public SeparatedSyntaxList<AnonymousObjectMemberDeclaratorSyntax> Initializers 
    {
        get
        {
            var red = this.GetRed(ref this.initializers, 2);
            if (red != null)
                return new SeparatedSyntaxList<AnonymousObjectMemberDeclaratorSyntax>(red, this.GetChildIndex(2));

            return default(SeparatedSyntaxList<AnonymousObjectMemberDeclaratorSyntax>);
        }
    }

    /// <summary>SyntaxToken representing the close brace.</summary>
    public SyntaxToken CloseBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AnonymousObjectCreationExpressionSyntax)this.Green).closeBraceToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.initializers, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.initializers;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAnonymousObjectCreationExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAnonymousObjectCreationExpression(this);
    }

    public AnonymousObjectCreationExpressionSyntax Update(SyntaxToken newKeyword, SyntaxToken openBraceToken, SeparatedSyntaxList<AnonymousObjectMemberDeclaratorSyntax> initializers, SyntaxToken closeBraceToken)
    {
        if (newKeyword != this.NewKeyword || openBraceToken != this.OpenBraceToken || initializers != this.Initializers || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.AnonymousObjectCreationExpression(newKeyword, openBraceToken, initializers, closeBraceToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AnonymousObjectCreationExpressionSyntax WithNewKeyword(SyntaxToken newKeyword)
    {
        return this.Update(newKeyword, this.OpenBraceToken, this.Initializers, this.CloseBraceToken);
    }

    public AnonymousObjectCreationExpressionSyntax WithOpenBraceToken(SyntaxToken openBraceToken)
    {
        return this.Update(this.NewKeyword, openBraceToken, this.Initializers, this.CloseBraceToken);
    }

    public AnonymousObjectCreationExpressionSyntax WithInitializers(SeparatedSyntaxList<AnonymousObjectMemberDeclaratorSyntax> initializers)
    {
        return this.Update(this.NewKeyword, this.OpenBraceToken, initializers, this.CloseBraceToken);
    }

    public AnonymousObjectCreationExpressionSyntax WithCloseBraceToken(SyntaxToken closeBraceToken)
    {
        return this.Update(this.NewKeyword, this.OpenBraceToken, this.Initializers, closeBraceToken);
    }

    public AnonymousObjectCreationExpressionSyntax AddInitializers(params AnonymousObjectMemberDeclaratorSyntax[] items)
    {
        return this.WithInitializers(this.Initializers.AddRange(items));
    }
  }

  /// <summary>Class which represents the syntax node for array creation expression.</summary>
  public sealed partial class ArrayCreationExpressionSyntax : ExpressionSyntax
  {
    private ArrayTypeSyntax type;
    private InitializerExpressionSyntax initializer;

    internal ArrayCreationExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public SyntaxToken NewKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ArrayCreationExpressionSyntax)this.Green).newKeyword, this.Position, 0); }
    }

    /// <summary>ArrayTypeSyntax node representing the type of the array.</summary>
    public ArrayTypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 1);
        }
    }

    /// <summary>InitializerExpressionSyntax node representing the initializer of the array creation expression.</summary>
    public InitializerExpressionSyntax Initializer 
    {
        get
        {
            return this.GetRed(ref this.initializer, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.type, 1);
            case 2: return this.GetRed(ref this.initializer, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.type;
            case 2: return this.initializer;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitArrayCreationExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitArrayCreationExpression(this);
    }

    public ArrayCreationExpressionSyntax Update(SyntaxToken newKeyword, ArrayTypeSyntax type, InitializerExpressionSyntax initializer)
    {
        if (newKeyword != this.NewKeyword || type != this.Type || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ArrayCreationExpression(newKeyword, type, initializer);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ArrayCreationExpressionSyntax WithNewKeyword(SyntaxToken newKeyword)
    {
        return this.Update(newKeyword, this.Type, this.Initializer);
    }

    public ArrayCreationExpressionSyntax WithType(ArrayTypeSyntax type)
    {
        return this.Update(this.NewKeyword, type, this.Initializer);
    }

    public ArrayCreationExpressionSyntax WithInitializer(InitializerExpressionSyntax initializer)
    {
        return this.Update(this.NewKeyword, this.Type, initializer);
    }

    public ArrayCreationExpressionSyntax AddTypeRankSpecifiers(params ArrayRankSpecifierSyntax[] items)
    {
        return this.WithType(this.Type.WithRankSpecifiers(this.Type.RankSpecifiers.AddRange(items)));
    }
  }

  /// <summary>Class which represents the syntax node for implicit array creation expression.</summary>
  public sealed partial class ImplicitArrayCreationExpressionSyntax : ExpressionSyntax
  {
    private InitializerExpressionSyntax initializer;

    internal ImplicitArrayCreationExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public SyntaxToken NewKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ImplicitArrayCreationExpressionSyntax)this.Green).newKeyword, this.Position, 0); }
    }

    /// <summary>SyntaxToken representing the open bracket.</summary>
    public SyntaxToken OpenBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ImplicitArrayCreationExpressionSyntax)this.Green).openBracketToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>SyntaxList of SyntaxToken representing the commas in the implicit array creation expression.</summary>
    public SyntaxTokenList Commas 
    {
        get
        {
            var slot = this.Green.GetSlot(2);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(2), this.GetChildIndex(2));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>SyntaxToken representing the close bracket.</summary>
    public SyntaxToken CloseBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ImplicitArrayCreationExpressionSyntax)this.Green).closeBracketToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    /// <summary>InitializerExpressionSyntax representing the initializer expression of the implicit array creation expression.</summary>
    public InitializerExpressionSyntax Initializer 
    {
        get
        {
            return this.GetRed(ref this.initializer, 4);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 4: return this.GetRed(ref this.initializer, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 4: return this.initializer;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitImplicitArrayCreationExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitImplicitArrayCreationExpression(this);
    }

    public ImplicitArrayCreationExpressionSyntax Update(SyntaxToken newKeyword, SyntaxToken openBracketToken, SyntaxTokenList commas, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer)
    {
        if (newKeyword != this.NewKeyword || openBracketToken != this.OpenBracketToken || commas != this.Commas || closeBracketToken != this.CloseBracketToken || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ImplicitArrayCreationExpression(newKeyword, openBracketToken, commas, closeBracketToken, initializer);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ImplicitArrayCreationExpressionSyntax WithNewKeyword(SyntaxToken newKeyword)
    {
        return this.Update(newKeyword, this.OpenBracketToken, this.Commas, this.CloseBracketToken, this.Initializer);
    }

    public ImplicitArrayCreationExpressionSyntax WithOpenBracketToken(SyntaxToken openBracketToken)
    {
        return this.Update(this.NewKeyword, openBracketToken, this.Commas, this.CloseBracketToken, this.Initializer);
    }

    public ImplicitArrayCreationExpressionSyntax WithCommas(SyntaxTokenList commas)
    {
        return this.Update(this.NewKeyword, this.OpenBracketToken, commas, this.CloseBracketToken, this.Initializer);
    }

    public ImplicitArrayCreationExpressionSyntax WithCloseBracketToken(SyntaxToken closeBracketToken)
    {
        return this.Update(this.NewKeyword, this.OpenBracketToken, this.Commas, closeBracketToken, this.Initializer);
    }

    public ImplicitArrayCreationExpressionSyntax WithInitializer(InitializerExpressionSyntax initializer)
    {
        return this.Update(this.NewKeyword, this.OpenBracketToken, this.Commas, this.CloseBracketToken, initializer);
    }

    public ImplicitArrayCreationExpressionSyntax AddCommas(params SyntaxToken[] items)
    {
        return this.WithCommas(this.Commas.AddRange(items));
    }

    public ImplicitArrayCreationExpressionSyntax AddInitializerExpressions(params ExpressionSyntax[] items)
    {
        return this.WithInitializer(this.Initializer.WithExpressions(this.Initializer.Expressions.AddRange(items)));
    }
  }

  /// <summary>Class which represents the syntax node for stackalloc array creation expression.</summary>
  public sealed partial class StackAllocArrayCreationExpressionSyntax : ExpressionSyntax
  {
    private TypeSyntax type;

    internal StackAllocArrayCreationExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the stackalloc keyword.</summary>
    public SyntaxToken StackAllocKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.StackAllocArrayCreationExpressionSyntax)this.Green).stackAllocKeyword, this.Position, 0); }
    }

    /// <summary>TypeSyntax node representing the type of the stackalloc array.</summary>
    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.type, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitStackAllocArrayCreationExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitStackAllocArrayCreationExpression(this);
    }

    public StackAllocArrayCreationExpressionSyntax Update(SyntaxToken stackAllocKeyword, TypeSyntax type)
    {
        if (stackAllocKeyword != this.StackAllocKeyword || type != this.Type)
        {
            var newNode = SyntaxFactory.StackAllocArrayCreationExpression(stackAllocKeyword, type);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public StackAllocArrayCreationExpressionSyntax WithStackAllocKeyword(SyntaxToken stackAllocKeyword)
    {
        return this.Update(stackAllocKeyword, this.Type);
    }

    public StackAllocArrayCreationExpressionSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.StackAllocKeyword, type);
    }
  }

  public abstract partial class QueryClauseSyntax : CSharpSyntaxNode
  {
    internal QueryClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  public abstract partial class SelectOrGroupClauseSyntax : CSharpSyntaxNode
  {
    internal SelectOrGroupClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  public sealed partial class QueryExpressionSyntax : ExpressionSyntax
  {
    private FromClauseSyntax fromClause;
    private QueryBodySyntax body;

    internal QueryExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public FromClauseSyntax FromClause 
    {
        get
        {
            return this.GetRedAtZero(ref this.fromClause);
        }
    }

    public QueryBodySyntax Body 
    {
        get
        {
            return this.GetRed(ref this.body, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.fromClause);
            case 1: return this.GetRed(ref this.body, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.fromClause;
            case 1: return this.body;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitQueryExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitQueryExpression(this);
    }

    public QueryExpressionSyntax Update(FromClauseSyntax fromClause, QueryBodySyntax body)
    {
        if (fromClause != this.FromClause || body != this.Body)
        {
            var newNode = SyntaxFactory.QueryExpression(fromClause, body);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public QueryExpressionSyntax WithFromClause(FromClauseSyntax fromClause)
    {
        return this.Update(fromClause, this.Body);
    }

    public QueryExpressionSyntax WithBody(QueryBodySyntax body)
    {
        return this.Update(this.FromClause, body);
    }

    public QueryExpressionSyntax AddBodyClauses(params QueryClauseSyntax[] items)
    {
        return this.WithBody(this.Body.WithClauses(this.Body.Clauses.AddRange(items)));
    }
  }

  public sealed partial class QueryBodySyntax : CSharpSyntaxNode
  {
    private SyntaxNode clauses;
    private SelectOrGroupClauseSyntax selectOrGroup;
    private QueryContinuationSyntax continuation;

    internal QueryBodySyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<QueryClauseSyntax> Clauses 
    {
        get
        {
            return new SyntaxList<QueryClauseSyntax>(this.GetRed(ref this.clauses, 0));
        }
    }

    public SelectOrGroupClauseSyntax SelectOrGroup 
    {
        get
        {
            return this.GetRed(ref this.selectOrGroup, 1);
        }
    }

    public QueryContinuationSyntax Continuation 
    {
        get
        {
            return this.GetRed(ref this.continuation, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.clauses);
            case 1: return this.GetRed(ref this.selectOrGroup, 1);
            case 2: return this.GetRed(ref this.continuation, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.clauses;
            case 1: return this.selectOrGroup;
            case 2: return this.continuation;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitQueryBody(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitQueryBody(this);
    }

    public QueryBodySyntax Update(SyntaxList<QueryClauseSyntax> clauses, SelectOrGroupClauseSyntax selectOrGroup, QueryContinuationSyntax continuation)
    {
        if (clauses != this.Clauses || selectOrGroup != this.SelectOrGroup || continuation != this.Continuation)
        {
            var newNode = SyntaxFactory.QueryBody(clauses, selectOrGroup, continuation);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public QueryBodySyntax WithClauses(SyntaxList<QueryClauseSyntax> clauses)
    {
        return this.Update(clauses, this.SelectOrGroup, this.Continuation);
    }

    public QueryBodySyntax WithSelectOrGroup(SelectOrGroupClauseSyntax selectOrGroup)
    {
        return this.Update(this.Clauses, selectOrGroup, this.Continuation);
    }

    public QueryBodySyntax WithContinuation(QueryContinuationSyntax continuation)
    {
        return this.Update(this.Clauses, this.SelectOrGroup, continuation);
    }

    public QueryBodySyntax AddClauses(params QueryClauseSyntax[] items)
    {
        return this.WithClauses(this.Clauses.AddRange(items));
    }
  }

  public sealed partial class FromClauseSyntax : QueryClauseSyntax
  {
    private TypeSyntax type;
    private ExpressionSyntax expression;

    internal FromClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken FromKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.FromClauseSyntax)this.Green).fromKeyword, this.Position, 0); }
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 1);
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.FromClauseSyntax)this.Green).identifier, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public SyntaxToken InKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.FromClauseSyntax)this.Green).inKeyword, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 4);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.type, 1);
            case 4: return this.GetRed(ref this.expression, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.type;
            case 4: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitFromClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitFromClause(this);
    }

    public FromClauseSyntax Update(SyntaxToken fromKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression)
    {
        if (fromKeyword != this.FromKeyword || type != this.Type || identifier != this.Identifier || inKeyword != this.InKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.FromClause(fromKeyword, type, identifier, inKeyword, expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public FromClauseSyntax WithFromKeyword(SyntaxToken fromKeyword)
    {
        return this.Update(fromKeyword, this.Type, this.Identifier, this.InKeyword, this.Expression);
    }

    public FromClauseSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.FromKeyword, type, this.Identifier, this.InKeyword, this.Expression);
    }

    public FromClauseSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.FromKeyword, this.Type, identifier, this.InKeyword, this.Expression);
    }

    public FromClauseSyntax WithInKeyword(SyntaxToken inKeyword)
    {
        return this.Update(this.FromKeyword, this.Type, this.Identifier, inKeyword, this.Expression);
    }

    public FromClauseSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.FromKeyword, this.Type, this.Identifier, this.InKeyword, expression);
    }
  }

  public sealed partial class LetClauseSyntax : QueryClauseSyntax
  {
    private ExpressionSyntax expression;

    internal LetClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken LetKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LetClauseSyntax)this.Green).letKeyword, this.Position, 0); }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LetClauseSyntax)this.Green).identifier, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public SyntaxToken EqualsToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LetClauseSyntax)this.Green).equalsToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 3);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 3: return this.GetRed(ref this.expression, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 3: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitLetClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitLetClause(this);
    }

    public LetClauseSyntax Update(SyntaxToken letKeyword, SyntaxToken identifier, SyntaxToken equalsToken, ExpressionSyntax expression)
    {
        if (letKeyword != this.LetKeyword || identifier != this.Identifier || equalsToken != this.EqualsToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.LetClause(letKeyword, identifier, equalsToken, expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public LetClauseSyntax WithLetKeyword(SyntaxToken letKeyword)
    {
        return this.Update(letKeyword, this.Identifier, this.EqualsToken, this.Expression);
    }

    public LetClauseSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.LetKeyword, identifier, this.EqualsToken, this.Expression);
    }

    public LetClauseSyntax WithEqualsToken(SyntaxToken equalsToken)
    {
        return this.Update(this.LetKeyword, this.Identifier, equalsToken, this.Expression);
    }

    public LetClauseSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.LetKeyword, this.Identifier, this.EqualsToken, expression);
    }
  }

  public sealed partial class JoinClauseSyntax : QueryClauseSyntax
  {
    private TypeSyntax type;
    private ExpressionSyntax inExpression;
    private ExpressionSyntax leftExpression;
    private ExpressionSyntax rightExpression;
    private JoinIntoClauseSyntax into;

    internal JoinClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken JoinKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.JoinClauseSyntax)this.Green).joinKeyword, this.Position, 0); }
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 1);
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.JoinClauseSyntax)this.Green).identifier, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public SyntaxToken InKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.JoinClauseSyntax)this.Green).inKeyword, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public ExpressionSyntax InExpression 
    {
        get
        {
            return this.GetRed(ref this.inExpression, 4);
        }
    }

    public SyntaxToken OnKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.JoinClauseSyntax)this.Green).onKeyword, this.GetChildPosition(5), this.GetChildIndex(5)); }
    }

    public ExpressionSyntax LeftExpression 
    {
        get
        {
            return this.GetRed(ref this.leftExpression, 6);
        }
    }

    public SyntaxToken EqualsKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.JoinClauseSyntax)this.Green).equalsKeyword, this.GetChildPosition(7), this.GetChildIndex(7)); }
    }

    public ExpressionSyntax RightExpression 
    {
        get
        {
            return this.GetRed(ref this.rightExpression, 8);
        }
    }

    public JoinIntoClauseSyntax Into 
    {
        get
        {
            return this.GetRed(ref this.into, 9);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.type, 1);
            case 4: return this.GetRed(ref this.inExpression, 4);
            case 6: return this.GetRed(ref this.leftExpression, 6);
            case 8: return this.GetRed(ref this.rightExpression, 8);
            case 9: return this.GetRed(ref this.into, 9);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.type;
            case 4: return this.inExpression;
            case 6: return this.leftExpression;
            case 8: return this.rightExpression;
            case 9: return this.into;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitJoinClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitJoinClause(this);
    }

    public JoinClauseSyntax Update(SyntaxToken joinKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax inExpression, SyntaxToken onKeyword, ExpressionSyntax leftExpression, SyntaxToken equalsKeyword, ExpressionSyntax rightExpression, JoinIntoClauseSyntax into)
    {
        if (joinKeyword != this.JoinKeyword || type != this.Type || identifier != this.Identifier || inKeyword != this.InKeyword || inExpression != this.InExpression || onKeyword != this.OnKeyword || leftExpression != this.LeftExpression || equalsKeyword != this.EqualsKeyword || rightExpression != this.RightExpression || into != this.Into)
        {
            var newNode = SyntaxFactory.JoinClause(joinKeyword, type, identifier, inKeyword, inExpression, onKeyword, leftExpression, equalsKeyword, rightExpression, into);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public JoinClauseSyntax WithJoinKeyword(SyntaxToken joinKeyword)
    {
        return this.Update(joinKeyword, this.Type, this.Identifier, this.InKeyword, this.InExpression, this.OnKeyword, this.LeftExpression, this.EqualsKeyword, this.RightExpression, this.Into);
    }

    public JoinClauseSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.JoinKeyword, type, this.Identifier, this.InKeyword, this.InExpression, this.OnKeyword, this.LeftExpression, this.EqualsKeyword, this.RightExpression, this.Into);
    }

    public JoinClauseSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.JoinKeyword, this.Type, identifier, this.InKeyword, this.InExpression, this.OnKeyword, this.LeftExpression, this.EqualsKeyword, this.RightExpression, this.Into);
    }

    public JoinClauseSyntax WithInKeyword(SyntaxToken inKeyword)
    {
        return this.Update(this.JoinKeyword, this.Type, this.Identifier, inKeyword, this.InExpression, this.OnKeyword, this.LeftExpression, this.EqualsKeyword, this.RightExpression, this.Into);
    }

    public JoinClauseSyntax WithInExpression(ExpressionSyntax inExpression)
    {
        return this.Update(this.JoinKeyword, this.Type, this.Identifier, this.InKeyword, inExpression, this.OnKeyword, this.LeftExpression, this.EqualsKeyword, this.RightExpression, this.Into);
    }

    public JoinClauseSyntax WithOnKeyword(SyntaxToken onKeyword)
    {
        return this.Update(this.JoinKeyword, this.Type, this.Identifier, this.InKeyword, this.InExpression, onKeyword, this.LeftExpression, this.EqualsKeyword, this.RightExpression, this.Into);
    }

    public JoinClauseSyntax WithLeftExpression(ExpressionSyntax leftExpression)
    {
        return this.Update(this.JoinKeyword, this.Type, this.Identifier, this.InKeyword, this.InExpression, this.OnKeyword, leftExpression, this.EqualsKeyword, this.RightExpression, this.Into);
    }

    public JoinClauseSyntax WithEqualsKeyword(SyntaxToken equalsKeyword)
    {
        return this.Update(this.JoinKeyword, this.Type, this.Identifier, this.InKeyword, this.InExpression, this.OnKeyword, this.LeftExpression, equalsKeyword, this.RightExpression, this.Into);
    }

    public JoinClauseSyntax WithRightExpression(ExpressionSyntax rightExpression)
    {
        return this.Update(this.JoinKeyword, this.Type, this.Identifier, this.InKeyword, this.InExpression, this.OnKeyword, this.LeftExpression, this.EqualsKeyword, rightExpression, this.Into);
    }

    public JoinClauseSyntax WithInto(JoinIntoClauseSyntax into)
    {
        return this.Update(this.JoinKeyword, this.Type, this.Identifier, this.InKeyword, this.InExpression, this.OnKeyword, this.LeftExpression, this.EqualsKeyword, this.RightExpression, into);
    }
  }

  public sealed partial class JoinIntoClauseSyntax : CSharpSyntaxNode
  {
    internal JoinIntoClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken IntoKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.JoinIntoClauseSyntax)this.Green).intoKeyword, this.Position, 0); }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.JoinIntoClauseSyntax)this.Green).identifier, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitJoinIntoClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitJoinIntoClause(this);
    }

    public JoinIntoClauseSyntax Update(SyntaxToken intoKeyword, SyntaxToken identifier)
    {
        if (intoKeyword != this.IntoKeyword || identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.JoinIntoClause(intoKeyword, identifier);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public JoinIntoClauseSyntax WithIntoKeyword(SyntaxToken intoKeyword)
    {
        return this.Update(intoKeyword, this.Identifier);
    }

    public JoinIntoClauseSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.IntoKeyword, identifier);
    }
  }

  public sealed partial class WhereClauseSyntax : QueryClauseSyntax
  {
    private ExpressionSyntax condition;

    internal WhereClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken WhereKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.WhereClauseSyntax)this.Green).whereKeyword, this.Position, 0); }
    }

    public ExpressionSyntax Condition 
    {
        get
        {
            return this.GetRed(ref this.condition, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.condition, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.condition;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitWhereClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitWhereClause(this);
    }

    public WhereClauseSyntax Update(SyntaxToken whereKeyword, ExpressionSyntax condition)
    {
        if (whereKeyword != this.WhereKeyword || condition != this.Condition)
        {
            var newNode = SyntaxFactory.WhereClause(whereKeyword, condition);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public WhereClauseSyntax WithWhereKeyword(SyntaxToken whereKeyword)
    {
        return this.Update(whereKeyword, this.Condition);
    }

    public WhereClauseSyntax WithCondition(ExpressionSyntax condition)
    {
        return this.Update(this.WhereKeyword, condition);
    }
  }

  public sealed partial class OrderByClauseSyntax : QueryClauseSyntax
  {
    private SyntaxNode orderings;

    internal OrderByClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OrderByKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.OrderByClauseSyntax)this.Green).orderByKeyword, this.Position, 0); }
    }

    public SeparatedSyntaxList<OrderingSyntax> Orderings 
    {
        get
        {
            var red = this.GetRed(ref this.orderings, 1);
            if (red != null)
                return new SeparatedSyntaxList<OrderingSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<OrderingSyntax>);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.orderings, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.orderings;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitOrderByClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitOrderByClause(this);
    }

    public OrderByClauseSyntax Update(SyntaxToken orderByKeyword, SeparatedSyntaxList<OrderingSyntax> orderings)
    {
        if (orderByKeyword != this.OrderByKeyword || orderings != this.Orderings)
        {
            var newNode = SyntaxFactory.OrderByClause(orderByKeyword, orderings);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public OrderByClauseSyntax WithOrderByKeyword(SyntaxToken orderByKeyword)
    {
        return this.Update(orderByKeyword, this.Orderings);
    }

    public OrderByClauseSyntax WithOrderings(SeparatedSyntaxList<OrderingSyntax> orderings)
    {
        return this.Update(this.OrderByKeyword, orderings);
    }

    public OrderByClauseSyntax AddOrderings(params OrderingSyntax[] items)
    {
        return this.WithOrderings(this.Orderings.AddRange(items));
    }
  }

  public sealed partial class OrderingSyntax : CSharpSyntaxNode
  {
    private ExpressionSyntax expression;

    internal OrderingSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRedAtZero(ref this.expression);
        }
    }

    public SyntaxToken AscendingOrDescendingKeyword 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.OrderingSyntax)this.Green).ascendingOrDescendingKeyword;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.expression);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitOrdering(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitOrdering(this);
    }

    public OrderingSyntax Update(ExpressionSyntax expression, SyntaxToken ascendingOrDescendingKeyword)
    {
        if (expression != this.Expression || ascendingOrDescendingKeyword != this.AscendingOrDescendingKeyword)
        {
            var newNode = SyntaxFactory.Ordering(this.Kind(), expression, ascendingOrDescendingKeyword);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public OrderingSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(expression, this.AscendingOrDescendingKeyword);
    }

    public OrderingSyntax WithAscendingOrDescendingKeyword(SyntaxToken ascendingOrDescendingKeyword)
    {
        return this.Update(this.Expression, ascendingOrDescendingKeyword);
    }
  }

  public sealed partial class SelectClauseSyntax : SelectOrGroupClauseSyntax
  {
    private ExpressionSyntax expression;

    internal SelectClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken SelectKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SelectClauseSyntax)this.Green).selectKeyword, this.Position, 0); }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.expression, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitSelectClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitSelectClause(this);
    }

    public SelectClauseSyntax Update(SyntaxToken selectKeyword, ExpressionSyntax expression)
    {
        if (selectKeyword != this.SelectKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.SelectClause(selectKeyword, expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public SelectClauseSyntax WithSelectKeyword(SyntaxToken selectKeyword)
    {
        return this.Update(selectKeyword, this.Expression);
    }

    public SelectClauseSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.SelectKeyword, expression);
    }
  }

  public sealed partial class GroupClauseSyntax : SelectOrGroupClauseSyntax
  {
    private ExpressionSyntax groupExpression;
    private ExpressionSyntax byExpression;

    internal GroupClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken GroupKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.GroupClauseSyntax)this.Green).groupKeyword, this.Position, 0); }
    }

    public ExpressionSyntax GroupExpression 
    {
        get
        {
            return this.GetRed(ref this.groupExpression, 1);
        }
    }

    public SyntaxToken ByKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.GroupClauseSyntax)this.Green).byKeyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public ExpressionSyntax ByExpression 
    {
        get
        {
            return this.GetRed(ref this.byExpression, 3);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.groupExpression, 1);
            case 3: return this.GetRed(ref this.byExpression, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.groupExpression;
            case 3: return this.byExpression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitGroupClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitGroupClause(this);
    }

    public GroupClauseSyntax Update(SyntaxToken groupKeyword, ExpressionSyntax groupExpression, SyntaxToken byKeyword, ExpressionSyntax byExpression)
    {
        if (groupKeyword != this.GroupKeyword || groupExpression != this.GroupExpression || byKeyword != this.ByKeyword || byExpression != this.ByExpression)
        {
            var newNode = SyntaxFactory.GroupClause(groupKeyword, groupExpression, byKeyword, byExpression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public GroupClauseSyntax WithGroupKeyword(SyntaxToken groupKeyword)
    {
        return this.Update(groupKeyword, this.GroupExpression, this.ByKeyword, this.ByExpression);
    }

    public GroupClauseSyntax WithGroupExpression(ExpressionSyntax groupExpression)
    {
        return this.Update(this.GroupKeyword, groupExpression, this.ByKeyword, this.ByExpression);
    }

    public GroupClauseSyntax WithByKeyword(SyntaxToken byKeyword)
    {
        return this.Update(this.GroupKeyword, this.GroupExpression, byKeyword, this.ByExpression);
    }

    public GroupClauseSyntax WithByExpression(ExpressionSyntax byExpression)
    {
        return this.Update(this.GroupKeyword, this.GroupExpression, this.ByKeyword, byExpression);
    }
  }

  public sealed partial class QueryContinuationSyntax : CSharpSyntaxNode
  {
    private QueryBodySyntax body;

    internal QueryContinuationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken IntoKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.QueryContinuationSyntax)this.Green).intoKeyword, this.Position, 0); }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.QueryContinuationSyntax)this.Green).identifier, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public QueryBodySyntax Body 
    {
        get
        {
            return this.GetRed(ref this.body, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.body, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.body;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitQueryContinuation(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitQueryContinuation(this);
    }

    public QueryContinuationSyntax Update(SyntaxToken intoKeyword, SyntaxToken identifier, QueryBodySyntax body)
    {
        if (intoKeyword != this.IntoKeyword || identifier != this.Identifier || body != this.Body)
        {
            var newNode = SyntaxFactory.QueryContinuation(intoKeyword, identifier, body);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public QueryContinuationSyntax WithIntoKeyword(SyntaxToken intoKeyword)
    {
        return this.Update(intoKeyword, this.Identifier, this.Body);
    }

    public QueryContinuationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.IntoKeyword, identifier, this.Body);
    }

    public QueryContinuationSyntax WithBody(QueryBodySyntax body)
    {
        return this.Update(this.IntoKeyword, this.Identifier, body);
    }

    public QueryContinuationSyntax AddBodyClauses(params QueryClauseSyntax[] items)
    {
        return this.WithBody(this.Body.WithClauses(this.Body.Clauses.AddRange(items)));
    }
  }

  /// <summary>Class which represents a placeholder in an array size list.</summary>
  public sealed partial class OmittedArraySizeExpressionSyntax : ExpressionSyntax
  {
    internal OmittedArraySizeExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the omitted array size expression.</summary>
    public SyntaxToken OmittedArraySizeExpressionToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.OmittedArraySizeExpressionSyntax)this.Green).omittedArraySizeExpressionToken, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitOmittedArraySizeExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitOmittedArraySizeExpression(this);
    }

    public OmittedArraySizeExpressionSyntax Update(SyntaxToken omittedArraySizeExpressionToken)
    {
        if (omittedArraySizeExpressionToken != this.OmittedArraySizeExpressionToken)
        {
            var newNode = SyntaxFactory.OmittedArraySizeExpression(omittedArraySizeExpressionToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public OmittedArraySizeExpressionSyntax WithOmittedArraySizeExpressionToken(SyntaxToken omittedArraySizeExpressionToken)
    {
        return this.Update(omittedArraySizeExpressionToken);
    }
  }

  public sealed partial class InterpolatedStringExpressionSyntax : ExpressionSyntax
  {
    private SyntaxNode contents;

    internal InterpolatedStringExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>The first part of an interpolated string, $" or $@"</summary>
    public SyntaxToken StringStartToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterpolatedStringExpressionSyntax)this.Green).stringStartToken, this.Position, 0); }
    }

    /// <summary>List of parts of the interpolated string, each one is either a literal part or an interpolation.</summary>
    public SyntaxList<InterpolatedStringContentSyntax> Contents 
    {
        get
        {
            return new SyntaxList<InterpolatedStringContentSyntax>(this.GetRed(ref this.contents, 1));
        }
    }

    /// <summary>The closing quote of the interpolated string.</summary>
    public SyntaxToken StringEndToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterpolatedStringExpressionSyntax)this.Green).stringEndToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.contents, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.contents;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitInterpolatedStringExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitInterpolatedStringExpression(this);
    }

    public InterpolatedStringExpressionSyntax Update(SyntaxToken stringStartToken, SyntaxList<InterpolatedStringContentSyntax> contents, SyntaxToken stringEndToken)
    {
        if (stringStartToken != this.StringStartToken || contents != this.Contents || stringEndToken != this.StringEndToken)
        {
            var newNode = SyntaxFactory.InterpolatedStringExpression(stringStartToken, contents, stringEndToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public InterpolatedStringExpressionSyntax WithStringStartToken(SyntaxToken stringStartToken)
    {
        return this.Update(stringStartToken, this.Contents, this.StringEndToken);
    }

    public InterpolatedStringExpressionSyntax WithContents(SyntaxList<InterpolatedStringContentSyntax> contents)
    {
        return this.Update(this.StringStartToken, contents, this.StringEndToken);
    }

    public InterpolatedStringExpressionSyntax WithStringEndToken(SyntaxToken stringEndToken)
    {
        return this.Update(this.StringStartToken, this.Contents, stringEndToken);
    }

    public InterpolatedStringExpressionSyntax AddContents(params InterpolatedStringContentSyntax[] items)
    {
        return this.WithContents(this.Contents.AddRange(items));
    }
  }

  /// <summary>Class which represents a simple pattern-maching expresion using the "is" keyword.</summary>
  public sealed partial class IsPatternExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;
    private PatternSyntax pattern;

    internal IsPatternExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>ExpressionSyntax node representing the expression on the left of the "is" operator.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRedAtZero(ref this.expression);
        }
    }

    public SyntaxToken IsKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IsPatternExpressionSyntax)this.Green).isKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>PatternSyntax node representing the pattern on the right of the "is" operator.</summary>
    public PatternSyntax Pattern 
    {
        get
        {
            return this.GetRed(ref this.pattern, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.expression);
            case 2: return this.GetRed(ref this.pattern, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 2: return this.pattern;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitIsPatternExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitIsPatternExpression(this);
    }

    public IsPatternExpressionSyntax Update(ExpressionSyntax expression, SyntaxToken isKeyword, PatternSyntax pattern)
    {
        if (expression != this.Expression || isKeyword != this.IsKeyword || pattern != this.Pattern)
        {
            var newNode = SyntaxFactory.IsPatternExpression(expression, isKeyword, pattern);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public IsPatternExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(expression, this.IsKeyword, this.Pattern);
    }

    public IsPatternExpressionSyntax WithIsKeyword(SyntaxToken isKeyword)
    {
        return this.Update(this.Expression, isKeyword, this.Pattern);
    }

    public IsPatternExpressionSyntax WithPattern(PatternSyntax pattern)
    {
        return this.Update(this.Expression, this.IsKeyword, pattern);
    }
  }

  public sealed partial class ThrowExpressionSyntax : ExpressionSyntax
  {
    private ExpressionSyntax expression;

    internal ThrowExpressionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken ThrowKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ThrowExpressionSyntax)this.Green).throwKeyword, this.Position, 0); }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.expression, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitThrowExpression(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitThrowExpression(this);
    }

    public ThrowExpressionSyntax Update(SyntaxToken throwKeyword, ExpressionSyntax expression)
    {
        if (throwKeyword != this.ThrowKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.ThrowExpression(throwKeyword, expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ThrowExpressionSyntax WithThrowKeyword(SyntaxToken throwKeyword)
    {
        return this.Update(throwKeyword, this.Expression);
    }

    public ThrowExpressionSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.ThrowKeyword, expression);
    }
  }

  public sealed partial class WhenClauseSyntax : CSharpSyntaxNode
  {
    private ExpressionSyntax condition;

    internal WhenClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken WhenKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.WhenClauseSyntax)this.Green).whenKeyword, this.Position, 0); }
    }

    public ExpressionSyntax Condition 
    {
        get
        {
            return this.GetRed(ref this.condition, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.condition, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.condition;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitWhenClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitWhenClause(this);
    }

    public WhenClauseSyntax Update(SyntaxToken whenKeyword, ExpressionSyntax condition)
    {
        if (whenKeyword != this.WhenKeyword || condition != this.Condition)
        {
            var newNode = SyntaxFactory.WhenClause(whenKeyword, condition);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public WhenClauseSyntax WithWhenKeyword(SyntaxToken whenKeyword)
    {
        return this.Update(whenKeyword, this.Condition);
    }

    public WhenClauseSyntax WithCondition(ExpressionSyntax condition)
    {
        return this.Update(this.WhenKeyword, condition);
    }
  }

  public abstract partial class PatternSyntax : CSharpSyntaxNode
  {
    internal PatternSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  public sealed partial class DeclarationPatternSyntax : PatternSyntax
  {
    private TypeSyntax type;
    private VariableDesignationSyntax designation;

    internal DeclarationPatternSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRedAtZero(ref this.type);
        }
    }

    public VariableDesignationSyntax Designation 
    {
        get
        {
            return this.GetRed(ref this.designation, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.type);
            case 1: return this.GetRed(ref this.designation, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            case 1: return this.designation;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitDeclarationPattern(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitDeclarationPattern(this);
    }

    public DeclarationPatternSyntax Update(TypeSyntax type, VariableDesignationSyntax designation)
    {
        if (type != this.Type || designation != this.Designation)
        {
            var newNode = SyntaxFactory.DeclarationPattern(type, designation);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public DeclarationPatternSyntax WithType(TypeSyntax type)
    {
        return this.Update(type, this.Designation);
    }

    public DeclarationPatternSyntax WithDesignation(VariableDesignationSyntax designation)
    {
        return this.Update(this.Type, designation);
    }
  }

  public sealed partial class ConstantPatternSyntax : PatternSyntax
  {
    private ExpressionSyntax expression;

    internal ConstantPatternSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>ExpressionSyntax node representing the constant expression.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRedAtZero(ref this.expression);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.expression);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitConstantPattern(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitConstantPattern(this);
    }

    public ConstantPatternSyntax Update(ExpressionSyntax expression)
    {
        if (expression != this.Expression)
        {
            var newNode = SyntaxFactory.ConstantPattern(expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ConstantPatternSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(expression);
    }
  }

  public abstract partial class InterpolatedStringContentSyntax : CSharpSyntaxNode
  {
    internal InterpolatedStringContentSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  public sealed partial class InterpolatedStringTextSyntax : InterpolatedStringContentSyntax
  {
    internal InterpolatedStringTextSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>The text contents of a part of the interpolated string.</summary>
    public SyntaxToken TextToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterpolatedStringTextSyntax)this.Green).textToken, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitInterpolatedStringText(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitInterpolatedStringText(this);
    }

    public InterpolatedStringTextSyntax Update(SyntaxToken textToken)
    {
        if (textToken != this.TextToken)
        {
            var newNode = SyntaxFactory.InterpolatedStringText(textToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public InterpolatedStringTextSyntax WithTextToken(SyntaxToken textToken)
    {
        return this.Update(textToken);
    }
  }

  public sealed partial class InterpolationSyntax : InterpolatedStringContentSyntax
  {
    private ExpressionSyntax expression;
    private InterpolationAlignmentClauseSyntax alignmentClause;
    private InterpolationFormatClauseSyntax formatClause;

    internal InterpolationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OpenBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterpolationSyntax)this.Green).openBraceToken, this.Position, 0); }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 1);
        }
    }

    public InterpolationAlignmentClauseSyntax AlignmentClause 
    {
        get
        {
            return this.GetRed(ref this.alignmentClause, 2);
        }
    }

    public InterpolationFormatClauseSyntax FormatClause 
    {
        get
        {
            return this.GetRed(ref this.formatClause, 3);
        }
    }

    public SyntaxToken CloseBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterpolationSyntax)this.Green).closeBraceToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.expression, 1);
            case 2: return this.GetRed(ref this.alignmentClause, 2);
            case 3: return this.GetRed(ref this.formatClause, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.expression;
            case 2: return this.alignmentClause;
            case 3: return this.formatClause;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitInterpolation(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitInterpolation(this);
    }

    public InterpolationSyntax Update(SyntaxToken openBraceToken, ExpressionSyntax expression, InterpolationAlignmentClauseSyntax alignmentClause, InterpolationFormatClauseSyntax formatClause, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || expression != this.Expression || alignmentClause != this.AlignmentClause || formatClause != this.FormatClause || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.Interpolation(openBraceToken, expression, alignmentClause, formatClause, closeBraceToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public InterpolationSyntax WithOpenBraceToken(SyntaxToken openBraceToken)
    {
        return this.Update(openBraceToken, this.Expression, this.AlignmentClause, this.FormatClause, this.CloseBraceToken);
    }

    public InterpolationSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.OpenBraceToken, expression, this.AlignmentClause, this.FormatClause, this.CloseBraceToken);
    }

    public InterpolationSyntax WithAlignmentClause(InterpolationAlignmentClauseSyntax alignmentClause)
    {
        return this.Update(this.OpenBraceToken, this.Expression, alignmentClause, this.FormatClause, this.CloseBraceToken);
    }

    public InterpolationSyntax WithFormatClause(InterpolationFormatClauseSyntax formatClause)
    {
        return this.Update(this.OpenBraceToken, this.Expression, this.AlignmentClause, formatClause, this.CloseBraceToken);
    }

    public InterpolationSyntax WithCloseBraceToken(SyntaxToken closeBraceToken)
    {
        return this.Update(this.OpenBraceToken, this.Expression, this.AlignmentClause, this.FormatClause, closeBraceToken);
    }
  }

  public sealed partial class InterpolationAlignmentClauseSyntax : CSharpSyntaxNode
  {
    private ExpressionSyntax value;

    internal InterpolationAlignmentClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken CommaToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterpolationAlignmentClauseSyntax)this.Green).commaToken, this.Position, 0); }
    }

    public ExpressionSyntax Value 
    {
        get
        {
            return this.GetRed(ref this.value, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.value, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.value;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitInterpolationAlignmentClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitInterpolationAlignmentClause(this);
    }

    public InterpolationAlignmentClauseSyntax Update(SyntaxToken commaToken, ExpressionSyntax value)
    {
        if (commaToken != this.CommaToken || value != this.Value)
        {
            var newNode = SyntaxFactory.InterpolationAlignmentClause(commaToken, value);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public InterpolationAlignmentClauseSyntax WithCommaToken(SyntaxToken commaToken)
    {
        return this.Update(commaToken, this.Value);
    }

    public InterpolationAlignmentClauseSyntax WithValue(ExpressionSyntax value)
    {
        return this.Update(this.CommaToken, value);
    }
  }

  public sealed partial class InterpolationFormatClauseSyntax : CSharpSyntaxNode
  {
    internal InterpolationFormatClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterpolationFormatClauseSyntax)this.Green).colonToken, this.Position, 0); }
    }

    /// <summary>The text contents of the format specifier for an interpolation.</summary>
    public SyntaxToken FormatStringToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterpolationFormatClauseSyntax)this.Green).formatStringToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitInterpolationFormatClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitInterpolationFormatClause(this);
    }

    public InterpolationFormatClauseSyntax Update(SyntaxToken colonToken, SyntaxToken formatStringToken)
    {
        if (colonToken != this.ColonToken || formatStringToken != this.FormatStringToken)
        {
            var newNode = SyntaxFactory.InterpolationFormatClause(colonToken, formatStringToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public InterpolationFormatClauseSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(colonToken, this.FormatStringToken);
    }

    public InterpolationFormatClauseSyntax WithFormatStringToken(SyntaxToken formatStringToken)
    {
        return this.Update(this.ColonToken, formatStringToken);
    }
  }

  public sealed partial class GlobalStatementSyntax : MemberDeclarationSyntax
  {
    private StatementSyntax statement;

    internal GlobalStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public StatementSyntax Statement 
    {
        get
        {
            return this.GetRedAtZero(ref this.statement);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.statement);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.statement;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitGlobalStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitGlobalStatement(this);
    }

    public GlobalStatementSyntax Update(StatementSyntax statement)
    {
        if (statement != this.Statement)
        {
            var newNode = SyntaxFactory.GlobalStatement(statement);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public GlobalStatementSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(statement);
    }
  }

  /// <summary>Represents the base class for all statements syntax classes.</summary>
  public abstract partial class StatementSyntax : CSharpSyntaxNode
  {
    internal StatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  public sealed partial class BlockSyntax : StatementSyntax
  {
    private SyntaxNode statements;

    internal BlockSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OpenBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BlockSyntax)this.Green).openBraceToken, this.Position, 0); }
    }

    public SyntaxList<StatementSyntax> Statements 
    {
        get
        {
            return new SyntaxList<StatementSyntax>(this.GetRed(ref this.statements, 1));
        }
    }

    public SyntaxToken CloseBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BlockSyntax)this.Green).closeBraceToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.statements, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.statements;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitBlock(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitBlock(this);
    }

    public BlockSyntax Update(SyntaxToken openBraceToken, SyntaxList<StatementSyntax> statements, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || statements != this.Statements || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.Block(openBraceToken, statements, closeBraceToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public BlockSyntax WithOpenBraceToken(SyntaxToken openBraceToken)
    {
        return this.Update(openBraceToken, this.Statements, this.CloseBraceToken);
    }

    public BlockSyntax WithStatements(SyntaxList<StatementSyntax> statements)
    {
        return this.Update(this.OpenBraceToken, statements, this.CloseBraceToken);
    }

    public BlockSyntax WithCloseBraceToken(SyntaxToken closeBraceToken)
    {
        return this.Update(this.OpenBraceToken, this.Statements, closeBraceToken);
    }

    public BlockSyntax AddStatements(params StatementSyntax[] items)
    {
        return this.WithStatements(this.Statements.AddRange(items));
    }
  }

  public sealed partial class LocalFunctionStatementSyntax : StatementSyntax
  {
    private TypeSyntax returnType;
    private TypeParameterListSyntax typeParameterList;
    private ParameterListSyntax parameterList;
    private SyntaxNode constraintClauses;
    private BlockSyntax body;
    private ArrowExpressionClauseSyntax expressionBody;

    internal LocalFunctionStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(0);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.Position, 0);

            return default(SyntaxTokenList);
        }
    }

    public TypeSyntax ReturnType 
    {
        get
        {
            return this.GetRed(ref this.returnType, 1);
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LocalFunctionStatementSyntax)this.Green).identifier, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public TypeParameterListSyntax TypeParameterList 
    {
        get
        {
            return this.GetRed(ref this.typeParameterList, 3);
        }
    }

    public ParameterListSyntax ParameterList 
    {
        get
        {
            return this.GetRed(ref this.parameterList, 4);
        }
    }

    public SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses 
    {
        get
        {
            return new SyntaxList<TypeParameterConstraintClauseSyntax>(this.GetRed(ref this.constraintClauses, 5));
        }
    }

    public BlockSyntax Body 
    {
        get
        {
            return this.GetRed(ref this.body, 6);
        }
    }

    public ArrowExpressionClauseSyntax ExpressionBody 
    {
        get
        {
            return this.GetRed(ref this.expressionBody, 7);
        }
    }

    /// <summary>Gets the optional semicolon token.</summary>
    public SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LocalFunctionStatementSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(8), this.GetChildIndex(8));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.returnType, 1);
            case 3: return this.GetRed(ref this.typeParameterList, 3);
            case 4: return this.GetRed(ref this.parameterList, 4);
            case 5: return this.GetRed(ref this.constraintClauses, 5);
            case 6: return this.GetRed(ref this.body, 6);
            case 7: return this.GetRed(ref this.expressionBody, 7);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.returnType;
            case 3: return this.typeParameterList;
            case 4: return this.parameterList;
            case 5: return this.constraintClauses;
            case 6: return this.body;
            case 7: return this.expressionBody;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitLocalFunctionStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitLocalFunctionStatement(this);
    }

    public LocalFunctionStatementSyntax Update(SyntaxTokenList modifiers, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (modifiers != this.Modifiers || returnType != this.ReturnType || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || constraintClauses != this.ConstraintClauses || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.LocalFunctionStatement(modifiers, returnType, identifier, typeParameterList, parameterList, constraintClauses, body, expressionBody, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public LocalFunctionStatementSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(modifiers, this.ReturnType, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public LocalFunctionStatementSyntax WithReturnType(TypeSyntax returnType)
    {
        return this.Update(this.Modifiers, returnType, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public LocalFunctionStatementSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.Modifiers, this.ReturnType, identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public LocalFunctionStatementSyntax WithTypeParameterList(TypeParameterListSyntax typeParameterList)
    {
        return this.Update(this.Modifiers, this.ReturnType, this.Identifier, typeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public LocalFunctionStatementSyntax WithParameterList(ParameterListSyntax parameterList)
    {
        return this.Update(this.Modifiers, this.ReturnType, this.Identifier, this.TypeParameterList, parameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public LocalFunctionStatementSyntax WithConstraintClauses(SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses)
    {
        return this.Update(this.Modifiers, this.ReturnType, this.Identifier, this.TypeParameterList, this.ParameterList, constraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public LocalFunctionStatementSyntax WithBody(BlockSyntax body)
    {
        return this.Update(this.Modifiers, this.ReturnType, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, body, this.ExpressionBody, this.SemicolonToken);
    }

    public LocalFunctionStatementSyntax WithExpressionBody(ArrowExpressionClauseSyntax expressionBody)
    {
        return this.Update(this.Modifiers, this.ReturnType, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, expressionBody, this.SemicolonToken);
    }

    public LocalFunctionStatementSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.Modifiers, this.ReturnType, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, semicolonToken);
    }

    public LocalFunctionStatementSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public LocalFunctionStatementSyntax AddTypeParameterListParameters(params TypeParameterSyntax[] items)
    {
        var typeParameterList = this.TypeParameterList ?? SyntaxFactory.TypeParameterList();
        return this.WithTypeParameterList(typeParameterList.WithParameters(typeParameterList.Parameters.AddRange(items)));
    }

    public LocalFunctionStatementSyntax AddParameterListParameters(params ParameterSyntax[] items)
    {
        return this.WithParameterList(this.ParameterList.WithParameters(this.ParameterList.Parameters.AddRange(items)));
    }

    public LocalFunctionStatementSyntax AddConstraintClauses(params TypeParameterConstraintClauseSyntax[] items)
    {
        return this.WithConstraintClauses(this.ConstraintClauses.AddRange(items));
    }

    public LocalFunctionStatementSyntax AddBodyStatements(params StatementSyntax[] items)
    {
        var body = this.Body ?? SyntaxFactory.Block();
        return this.WithBody(body.WithStatements(body.Statements.AddRange(items)));
    }
  }

  public sealed partial class LocalDeclarationStatementSyntax : StatementSyntax
  {
    private VariableDeclarationSyntax declaration;

    internal LocalDeclarationStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the modifier list.</summary>
    public SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(0);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.Position, 0);

            return default(SyntaxTokenList);
        }
    }

    public VariableDeclarationSyntax Declaration 
    {
        get
        {
            return this.GetRed(ref this.declaration, 1);
        }
    }

    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LocalDeclarationStatementSyntax)this.Green).semicolonToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.declaration, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.declaration;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitLocalDeclarationStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitLocalDeclarationStatement(this);
    }

    public LocalDeclarationStatementSyntax Update(SyntaxTokenList modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
    {
        if (modifiers != this.Modifiers || declaration != this.Declaration || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.LocalDeclarationStatement(modifiers, declaration, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public LocalDeclarationStatementSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(modifiers, this.Declaration, this.SemicolonToken);
    }

    public LocalDeclarationStatementSyntax WithDeclaration(VariableDeclarationSyntax declaration)
    {
        return this.Update(this.Modifiers, declaration, this.SemicolonToken);
    }

    public LocalDeclarationStatementSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.Modifiers, this.Declaration, semicolonToken);
    }

    public LocalDeclarationStatementSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public LocalDeclarationStatementSyntax AddDeclarationVariables(params VariableDeclaratorSyntax[] items)
    {
        return this.WithDeclaration(this.Declaration.WithVariables(this.Declaration.Variables.AddRange(items)));
    }
  }

  public sealed partial class VariableDeclarationSyntax : CSharpSyntaxNode
  {
    private TypeSyntax type;
    private SyntaxNode variables;

    internal VariableDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRedAtZero(ref this.type);
        }
    }

    public SeparatedSyntaxList<VariableDeclaratorSyntax> Variables 
    {
        get
        {
            var red = this.GetRed(ref this.variables, 1);
            if (red != null)
                return new SeparatedSyntaxList<VariableDeclaratorSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<VariableDeclaratorSyntax>);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.type);
            case 1: return this.GetRed(ref this.variables, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            case 1: return this.variables;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitVariableDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitVariableDeclaration(this);
    }

    public VariableDeclarationSyntax Update(TypeSyntax type, SeparatedSyntaxList<VariableDeclaratorSyntax> variables)
    {
        if (type != this.Type || variables != this.Variables)
        {
            var newNode = SyntaxFactory.VariableDeclaration(type, variables);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public VariableDeclarationSyntax WithType(TypeSyntax type)
    {
        return this.Update(type, this.Variables);
    }

    public VariableDeclarationSyntax WithVariables(SeparatedSyntaxList<VariableDeclaratorSyntax> variables)
    {
        return this.Update(this.Type, variables);
    }

    public VariableDeclarationSyntax AddVariables(params VariableDeclaratorSyntax[] items)
    {
        return this.WithVariables(this.Variables.AddRange(items));
    }
  }

  public sealed partial class VariableDeclaratorSyntax : CSharpSyntaxNode
  {
    private BracketedArgumentListSyntax argumentList;
    private EqualsValueClauseSyntax initializer;

    internal VariableDeclaratorSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.VariableDeclaratorSyntax)this.Green).identifier, this.Position, 0); }
    }

    public BracketedArgumentListSyntax ArgumentList 
    {
        get
        {
            return this.GetRed(ref this.argumentList, 1);
        }
    }

    public EqualsValueClauseSyntax Initializer 
    {
        get
        {
            return this.GetRed(ref this.initializer, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.argumentList, 1);
            case 2: return this.GetRed(ref this.initializer, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.argumentList;
            case 2: return this.initializer;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitVariableDeclarator(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitVariableDeclarator(this);
    }

    public VariableDeclaratorSyntax Update(SyntaxToken identifier, BracketedArgumentListSyntax argumentList, EqualsValueClauseSyntax initializer)
    {
        if (identifier != this.Identifier || argumentList != this.ArgumentList || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.VariableDeclarator(identifier, argumentList, initializer);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public VariableDeclaratorSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(identifier, this.ArgumentList, this.Initializer);
    }

    public VariableDeclaratorSyntax WithArgumentList(BracketedArgumentListSyntax argumentList)
    {
        return this.Update(this.Identifier, argumentList, this.Initializer);
    }

    public VariableDeclaratorSyntax WithInitializer(EqualsValueClauseSyntax initializer)
    {
        return this.Update(this.Identifier, this.ArgumentList, initializer);
    }

    public VariableDeclaratorSyntax AddArgumentListArguments(params ArgumentSyntax[] items)
    {
        var argumentList = this.ArgumentList ?? SyntaxFactory.BracketedArgumentList();
        return this.WithArgumentList(argumentList.WithArguments(argumentList.Arguments.AddRange(items)));
    }
  }

  public sealed partial class EqualsValueClauseSyntax : CSharpSyntaxNode
  {
    private ExpressionSyntax value;

    internal EqualsValueClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken EqualsToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EqualsValueClauseSyntax)this.Green).equalsToken, this.Position, 0); }
    }

    public ExpressionSyntax Value 
    {
        get
        {
            return this.GetRed(ref this.value, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.value, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.value;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitEqualsValueClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitEqualsValueClause(this);
    }

    public EqualsValueClauseSyntax Update(SyntaxToken equalsToken, ExpressionSyntax value)
    {
        if (equalsToken != this.EqualsToken || value != this.Value)
        {
            var newNode = SyntaxFactory.EqualsValueClause(equalsToken, value);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public EqualsValueClauseSyntax WithEqualsToken(SyntaxToken equalsToken)
    {
        return this.Update(equalsToken, this.Value);
    }

    public EqualsValueClauseSyntax WithValue(ExpressionSyntax value)
    {
        return this.Update(this.EqualsToken, value);
    }
  }

  public abstract partial class VariableDesignationSyntax : CSharpSyntaxNode
  {
    internal VariableDesignationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  public sealed partial class SingleVariableDesignationSyntax : VariableDesignationSyntax
  {
    internal SingleVariableDesignationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SingleVariableDesignationSyntax)this.Green).identifier, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitSingleVariableDesignation(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitSingleVariableDesignation(this);
    }

    public SingleVariableDesignationSyntax Update(SyntaxToken identifier)
    {
        if (identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.SingleVariableDesignation(identifier);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public SingleVariableDesignationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(identifier);
    }
  }

  public sealed partial class DiscardDesignationSyntax : VariableDesignationSyntax
  {
    internal DiscardDesignationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken UnderscoreToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DiscardDesignationSyntax)this.Green).underscoreToken, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitDiscardDesignation(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitDiscardDesignation(this);
    }

    public DiscardDesignationSyntax Update(SyntaxToken underscoreToken)
    {
        if (underscoreToken != this.UnderscoreToken)
        {
            var newNode = SyntaxFactory.DiscardDesignation(underscoreToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public DiscardDesignationSyntax WithUnderscoreToken(SyntaxToken underscoreToken)
    {
        return this.Update(underscoreToken);
    }
  }

  public sealed partial class ParenthesizedVariableDesignationSyntax : VariableDesignationSyntax
  {
    private SyntaxNode variables;

    internal ParenthesizedVariableDesignationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ParenthesizedVariableDesignationSyntax)this.Green).openParenToken, this.Position, 0); }
    }

    public SeparatedSyntaxList<VariableDesignationSyntax> Variables 
    {
        get
        {
            var red = this.GetRed(ref this.variables, 1);
            if (red != null)
                return new SeparatedSyntaxList<VariableDesignationSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<VariableDesignationSyntax>);
        }
    }

    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ParenthesizedVariableDesignationSyntax)this.Green).closeParenToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.variables, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.variables;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitParenthesizedVariableDesignation(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitParenthesizedVariableDesignation(this);
    }

    public ParenthesizedVariableDesignationSyntax Update(SyntaxToken openParenToken, SeparatedSyntaxList<VariableDesignationSyntax> variables, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || variables != this.Variables || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ParenthesizedVariableDesignation(openParenToken, variables, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ParenthesizedVariableDesignationSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(openParenToken, this.Variables, this.CloseParenToken);
    }

    public ParenthesizedVariableDesignationSyntax WithVariables(SeparatedSyntaxList<VariableDesignationSyntax> variables)
    {
        return this.Update(this.OpenParenToken, variables, this.CloseParenToken);
    }

    public ParenthesizedVariableDesignationSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.OpenParenToken, this.Variables, closeParenToken);
    }

    public ParenthesizedVariableDesignationSyntax AddVariables(params VariableDesignationSyntax[] items)
    {
        return this.WithVariables(this.Variables.AddRange(items));
    }
  }

  public sealed partial class ExpressionStatementSyntax : StatementSyntax
  {
    private ExpressionSyntax expression;

    internal ExpressionStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRedAtZero(ref this.expression);
        }
    }

    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ExpressionStatementSyntax)this.Green).semicolonToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.expression);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitExpressionStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitExpressionStatement(this);
    }

    public ExpressionStatementSyntax Update(ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ExpressionStatement(expression, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ExpressionStatementSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(expression, this.SemicolonToken);
    }

    public ExpressionStatementSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.Expression, semicolonToken);
    }
  }

  public sealed partial class EmptyStatementSyntax : StatementSyntax
  {
    internal EmptyStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EmptyStatementSyntax)this.Green).semicolonToken, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitEmptyStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitEmptyStatement(this);
    }

    public EmptyStatementSyntax Update(SyntaxToken semicolonToken)
    {
        if (semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.EmptyStatement(semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public EmptyStatementSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(semicolonToken);
    }
  }

  /// <summary>Represents a labeled statement syntax.</summary>
  public sealed partial class LabeledStatementSyntax : StatementSyntax
  {
    private StatementSyntax statement;

    internal LabeledStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LabeledStatementSyntax)this.Green).identifier, this.Position, 0); }
    }

    /// <summary>Gets a SyntaxToken that represents the colon succeeding the statement's label.</summary>
    public SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LabeledStatementSyntax)this.Green).colonToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public StatementSyntax Statement 
    {
        get
        {
            return this.GetRed(ref this.statement, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.statement, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.statement;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitLabeledStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitLabeledStatement(this);
    }

    public LabeledStatementSyntax Update(SyntaxToken identifier, SyntaxToken colonToken, StatementSyntax statement)
    {
        if (identifier != this.Identifier || colonToken != this.ColonToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.LabeledStatement(identifier, colonToken, statement);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public LabeledStatementSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(identifier, this.ColonToken, this.Statement);
    }

    public LabeledStatementSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(this.Identifier, colonToken, this.Statement);
    }

    public LabeledStatementSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(this.Identifier, this.ColonToken, statement);
    }
  }

  /// <summary>
  /// Represents a goto statement syntax
  /// </summary>
  public sealed partial class GotoStatementSyntax : StatementSyntax
  {
    private ExpressionSyntax expression;

    internal GotoStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the goto keyword.
    /// </summary>
    public SyntaxToken GotoKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.GotoStatementSyntax)this.Green).gotoKeyword, this.Position, 0); }
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the case or default keywords if any exists.
    /// </summary>
    public SyntaxToken CaseOrDefaultKeyword 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.GotoStatementSyntax)this.Green).caseOrDefaultKeyword;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxToken);
        }
    }

    /// <summary>
    /// Gets a constant expression for a goto case statement.
    /// </summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 2);
        }
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the semi-colon at the end of the statement.
    /// </summary>
    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.GotoStatementSyntax)this.Green).semicolonToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.expression, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitGotoStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitGotoStatement(this);
    }

    public GotoStatementSyntax Update(SyntaxToken gotoKeyword, SyntaxToken caseOrDefaultKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (gotoKeyword != this.GotoKeyword || caseOrDefaultKeyword != this.CaseOrDefaultKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.GotoStatement(this.Kind(), gotoKeyword, caseOrDefaultKeyword, expression, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public GotoStatementSyntax WithGotoKeyword(SyntaxToken gotoKeyword)
    {
        return this.Update(gotoKeyword, this.CaseOrDefaultKeyword, this.Expression, this.SemicolonToken);
    }

    public GotoStatementSyntax WithCaseOrDefaultKeyword(SyntaxToken caseOrDefaultKeyword)
    {
        return this.Update(this.GotoKeyword, caseOrDefaultKeyword, this.Expression, this.SemicolonToken);
    }

    public GotoStatementSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.GotoKeyword, this.CaseOrDefaultKeyword, expression, this.SemicolonToken);
    }

    public GotoStatementSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.GotoKeyword, this.CaseOrDefaultKeyword, this.Expression, semicolonToken);
    }
  }

  public sealed partial class BreakStatementSyntax : StatementSyntax
  {
    internal BreakStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken BreakKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BreakStatementSyntax)this.Green).breakKeyword, this.Position, 0); }
    }

    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BreakStatementSyntax)this.Green).semicolonToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitBreakStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitBreakStatement(this);
    }

    public BreakStatementSyntax Update(SyntaxToken breakKeyword, SyntaxToken semicolonToken)
    {
        if (breakKeyword != this.BreakKeyword || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.BreakStatement(breakKeyword, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public BreakStatementSyntax WithBreakKeyword(SyntaxToken breakKeyword)
    {
        return this.Update(breakKeyword, this.SemicolonToken);
    }

    public BreakStatementSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.BreakKeyword, semicolonToken);
    }
  }

  public sealed partial class ContinueStatementSyntax : StatementSyntax
  {
    internal ContinueStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken ContinueKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ContinueStatementSyntax)this.Green).continueKeyword, this.Position, 0); }
    }

    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ContinueStatementSyntax)this.Green).semicolonToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitContinueStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitContinueStatement(this);
    }

    public ContinueStatementSyntax Update(SyntaxToken continueKeyword, SyntaxToken semicolonToken)
    {
        if (continueKeyword != this.ContinueKeyword || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ContinueStatement(continueKeyword, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ContinueStatementSyntax WithContinueKeyword(SyntaxToken continueKeyword)
    {
        return this.Update(continueKeyword, this.SemicolonToken);
    }

    public ContinueStatementSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.ContinueKeyword, semicolonToken);
    }
  }

  public sealed partial class ReturnStatementSyntax : StatementSyntax
  {
    private ExpressionSyntax expression;

    internal ReturnStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken ReturnKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ReturnStatementSyntax)this.Green).returnKeyword, this.Position, 0); }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 1);
        }
    }

    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ReturnStatementSyntax)this.Green).semicolonToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.expression, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitReturnStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitReturnStatement(this);
    }

    public ReturnStatementSyntax Update(SyntaxToken returnKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (returnKeyword != this.ReturnKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ReturnStatement(returnKeyword, expression, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ReturnStatementSyntax WithReturnKeyword(SyntaxToken returnKeyword)
    {
        return this.Update(returnKeyword, this.Expression, this.SemicolonToken);
    }

    public ReturnStatementSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.ReturnKeyword, expression, this.SemicolonToken);
    }

    public ReturnStatementSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.ReturnKeyword, this.Expression, semicolonToken);
    }
  }

  public sealed partial class ThrowStatementSyntax : StatementSyntax
  {
    private ExpressionSyntax expression;

    internal ThrowStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken ThrowKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ThrowStatementSyntax)this.Green).throwKeyword, this.Position, 0); }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 1);
        }
    }

    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ThrowStatementSyntax)this.Green).semicolonToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.expression, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitThrowStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitThrowStatement(this);
    }

    public ThrowStatementSyntax Update(SyntaxToken throwKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (throwKeyword != this.ThrowKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ThrowStatement(throwKeyword, expression, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ThrowStatementSyntax WithThrowKeyword(SyntaxToken throwKeyword)
    {
        return this.Update(throwKeyword, this.Expression, this.SemicolonToken);
    }

    public ThrowStatementSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.ThrowKeyword, expression, this.SemicolonToken);
    }

    public ThrowStatementSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.ThrowKeyword, this.Expression, semicolonToken);
    }
  }

  public sealed partial class YieldStatementSyntax : StatementSyntax
  {
    private ExpressionSyntax expression;

    internal YieldStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken YieldKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.YieldStatementSyntax)this.Green).yieldKeyword, this.Position, 0); }
    }

    public SyntaxToken ReturnOrBreakKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.YieldStatementSyntax)this.Green).returnOrBreakKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 2);
        }
    }

    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.YieldStatementSyntax)this.Green).semicolonToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.expression, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitYieldStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitYieldStatement(this);
    }

    public YieldStatementSyntax Update(SyntaxToken yieldKeyword, SyntaxToken returnOrBreakKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (yieldKeyword != this.YieldKeyword || returnOrBreakKeyword != this.ReturnOrBreakKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.YieldStatement(this.Kind(), yieldKeyword, returnOrBreakKeyword, expression, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public YieldStatementSyntax WithYieldKeyword(SyntaxToken yieldKeyword)
    {
        return this.Update(yieldKeyword, this.ReturnOrBreakKeyword, this.Expression, this.SemicolonToken);
    }

    public YieldStatementSyntax WithReturnOrBreakKeyword(SyntaxToken returnOrBreakKeyword)
    {
        return this.Update(this.YieldKeyword, returnOrBreakKeyword, this.Expression, this.SemicolonToken);
    }

    public YieldStatementSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.YieldKeyword, this.ReturnOrBreakKeyword, expression, this.SemicolonToken);
    }

    public YieldStatementSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.YieldKeyword, this.ReturnOrBreakKeyword, this.Expression, semicolonToken);
    }
  }

  public sealed partial class WhileStatementSyntax : StatementSyntax
  {
    private ExpressionSyntax condition;
    private StatementSyntax statement;

    internal WhileStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken WhileKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.WhileStatementSyntax)this.Green).whileKeyword, this.Position, 0); }
    }

    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.WhileStatementSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public ExpressionSyntax Condition 
    {
        get
        {
            return this.GetRed(ref this.condition, 2);
        }
    }

    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.WhileStatementSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public StatementSyntax Statement 
    {
        get
        {
            return this.GetRed(ref this.statement, 4);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.condition, 2);
            case 4: return this.GetRed(ref this.statement, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.condition;
            case 4: return this.statement;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitWhileStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitWhileStatement(this);
    }

    public WhileStatementSyntax Update(SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (whileKeyword != this.WhileKeyword || openParenToken != this.OpenParenToken || condition != this.Condition || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.WhileStatement(whileKeyword, openParenToken, condition, closeParenToken, statement);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public WhileStatementSyntax WithWhileKeyword(SyntaxToken whileKeyword)
    {
        return this.Update(whileKeyword, this.OpenParenToken, this.Condition, this.CloseParenToken, this.Statement);
    }

    public WhileStatementSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.WhileKeyword, openParenToken, this.Condition, this.CloseParenToken, this.Statement);
    }

    public WhileStatementSyntax WithCondition(ExpressionSyntax condition)
    {
        return this.Update(this.WhileKeyword, this.OpenParenToken, condition, this.CloseParenToken, this.Statement);
    }

    public WhileStatementSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.WhileKeyword, this.OpenParenToken, this.Condition, closeParenToken, this.Statement);
    }

    public WhileStatementSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(this.WhileKeyword, this.OpenParenToken, this.Condition, this.CloseParenToken, statement);
    }
  }

  public sealed partial class DoStatementSyntax : StatementSyntax
  {
    private StatementSyntax statement;
    private ExpressionSyntax condition;

    internal DoStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken DoKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DoStatementSyntax)this.Green).doKeyword, this.Position, 0); }
    }

    public StatementSyntax Statement 
    {
        get
        {
            return this.GetRed(ref this.statement, 1);
        }
    }

    public SyntaxToken WhileKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DoStatementSyntax)this.Green).whileKeyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DoStatementSyntax)this.Green).openParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public ExpressionSyntax Condition 
    {
        get
        {
            return this.GetRed(ref this.condition, 4);
        }
    }

    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DoStatementSyntax)this.Green).closeParenToken, this.GetChildPosition(5), this.GetChildIndex(5)); }
    }

    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DoStatementSyntax)this.Green).semicolonToken, this.GetChildPosition(6), this.GetChildIndex(6)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.statement, 1);
            case 4: return this.GetRed(ref this.condition, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.statement;
            case 4: return this.condition;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitDoStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitDoStatement(this);
    }

    public DoStatementSyntax Update(SyntaxToken doKeyword, StatementSyntax statement, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, SyntaxToken semicolonToken)
    {
        if (doKeyword != this.DoKeyword || statement != this.Statement || whileKeyword != this.WhileKeyword || openParenToken != this.OpenParenToken || condition != this.Condition || closeParenToken != this.CloseParenToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.DoStatement(doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public DoStatementSyntax WithDoKeyword(SyntaxToken doKeyword)
    {
        return this.Update(doKeyword, this.Statement, this.WhileKeyword, this.OpenParenToken, this.Condition, this.CloseParenToken, this.SemicolonToken);
    }

    public DoStatementSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(this.DoKeyword, statement, this.WhileKeyword, this.OpenParenToken, this.Condition, this.CloseParenToken, this.SemicolonToken);
    }

    public DoStatementSyntax WithWhileKeyword(SyntaxToken whileKeyword)
    {
        return this.Update(this.DoKeyword, this.Statement, whileKeyword, this.OpenParenToken, this.Condition, this.CloseParenToken, this.SemicolonToken);
    }

    public DoStatementSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.DoKeyword, this.Statement, this.WhileKeyword, openParenToken, this.Condition, this.CloseParenToken, this.SemicolonToken);
    }

    public DoStatementSyntax WithCondition(ExpressionSyntax condition)
    {
        return this.Update(this.DoKeyword, this.Statement, this.WhileKeyword, this.OpenParenToken, condition, this.CloseParenToken, this.SemicolonToken);
    }

    public DoStatementSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.DoKeyword, this.Statement, this.WhileKeyword, this.OpenParenToken, this.Condition, closeParenToken, this.SemicolonToken);
    }

    public DoStatementSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.DoKeyword, this.Statement, this.WhileKeyword, this.OpenParenToken, this.Condition, this.CloseParenToken, semicolonToken);
    }
  }

  public sealed partial class ForStatementSyntax : StatementSyntax
  {
    private VariableDeclarationSyntax declaration;
    private SyntaxNode initializers;
    private ExpressionSyntax condition;
    private SyntaxNode incrementors;
    private StatementSyntax statement;

    internal ForStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken ForKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForStatementSyntax)this.Green).forKeyword, this.Position, 0); }
    }

    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForStatementSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public VariableDeclarationSyntax Declaration 
    {
        get
        {
            return this.GetRed(ref this.declaration, 2);
        }
    }

    public SeparatedSyntaxList<ExpressionSyntax> Initializers 
    {
        get
        {
            var red = this.GetRed(ref this.initializers, 3);
            if (red != null)
                return new SeparatedSyntaxList<ExpressionSyntax>(red, this.GetChildIndex(3));

            return default(SeparatedSyntaxList<ExpressionSyntax>);
        }
    }

    public SyntaxToken FirstSemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForStatementSyntax)this.Green).firstSemicolonToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    public ExpressionSyntax Condition 
    {
        get
        {
            return this.GetRed(ref this.condition, 5);
        }
    }

    public SyntaxToken SecondSemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForStatementSyntax)this.Green).secondSemicolonToken, this.GetChildPosition(6), this.GetChildIndex(6)); }
    }

    public SeparatedSyntaxList<ExpressionSyntax> Incrementors 
    {
        get
        {
            var red = this.GetRed(ref this.incrementors, 7);
            if (red != null)
                return new SeparatedSyntaxList<ExpressionSyntax>(red, this.GetChildIndex(7));

            return default(SeparatedSyntaxList<ExpressionSyntax>);
        }
    }

    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForStatementSyntax)this.Green).closeParenToken, this.GetChildPosition(8), this.GetChildIndex(8)); }
    }

    public StatementSyntax Statement 
    {
        get
        {
            return this.GetRed(ref this.statement, 9);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.declaration, 2);
            case 3: return this.GetRed(ref this.initializers, 3);
            case 5: return this.GetRed(ref this.condition, 5);
            case 7: return this.GetRed(ref this.incrementors, 7);
            case 9: return this.GetRed(ref this.statement, 9);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.declaration;
            case 3: return this.initializers;
            case 5: return this.condition;
            case 7: return this.incrementors;
            case 9: return this.statement;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitForStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitForStatement(this);
    }

    public ForStatementSyntax Update(SyntaxToken forKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, SeparatedSyntaxList<ExpressionSyntax> initializers, SyntaxToken firstSemicolonToken, ExpressionSyntax condition, SyntaxToken secondSemicolonToken, SeparatedSyntaxList<ExpressionSyntax> incrementors, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (forKeyword != this.ForKeyword || openParenToken != this.OpenParenToken || declaration != this.Declaration || initializers != this.Initializers || firstSemicolonToken != this.FirstSemicolonToken || condition != this.Condition || secondSemicolonToken != this.SecondSemicolonToken || incrementors != this.Incrementors || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ForStatement(forKeyword, openParenToken, declaration, initializers, firstSemicolonToken, condition, secondSemicolonToken, incrementors, closeParenToken, statement);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ForStatementSyntax WithForKeyword(SyntaxToken forKeyword)
    {
        return this.Update(forKeyword, this.OpenParenToken, this.Declaration, this.Initializers, this.FirstSemicolonToken, this.Condition, this.SecondSemicolonToken, this.Incrementors, this.CloseParenToken, this.Statement);
    }

    public ForStatementSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.ForKeyword, openParenToken, this.Declaration, this.Initializers, this.FirstSemicolonToken, this.Condition, this.SecondSemicolonToken, this.Incrementors, this.CloseParenToken, this.Statement);
    }

    public ForStatementSyntax WithDeclaration(VariableDeclarationSyntax declaration)
    {
        return this.Update(this.ForKeyword, this.OpenParenToken, declaration, this.Initializers, this.FirstSemicolonToken, this.Condition, this.SecondSemicolonToken, this.Incrementors, this.CloseParenToken, this.Statement);
    }

    public ForStatementSyntax WithInitializers(SeparatedSyntaxList<ExpressionSyntax> initializers)
    {
        return this.Update(this.ForKeyword, this.OpenParenToken, this.Declaration, initializers, this.FirstSemicolonToken, this.Condition, this.SecondSemicolonToken, this.Incrementors, this.CloseParenToken, this.Statement);
    }

    public ForStatementSyntax WithFirstSemicolonToken(SyntaxToken firstSemicolonToken)
    {
        return this.Update(this.ForKeyword, this.OpenParenToken, this.Declaration, this.Initializers, firstSemicolonToken, this.Condition, this.SecondSemicolonToken, this.Incrementors, this.CloseParenToken, this.Statement);
    }

    public ForStatementSyntax WithCondition(ExpressionSyntax condition)
    {
        return this.Update(this.ForKeyword, this.OpenParenToken, this.Declaration, this.Initializers, this.FirstSemicolonToken, condition, this.SecondSemicolonToken, this.Incrementors, this.CloseParenToken, this.Statement);
    }

    public ForStatementSyntax WithSecondSemicolonToken(SyntaxToken secondSemicolonToken)
    {
        return this.Update(this.ForKeyword, this.OpenParenToken, this.Declaration, this.Initializers, this.FirstSemicolonToken, this.Condition, secondSemicolonToken, this.Incrementors, this.CloseParenToken, this.Statement);
    }

    public ForStatementSyntax WithIncrementors(SeparatedSyntaxList<ExpressionSyntax> incrementors)
    {
        return this.Update(this.ForKeyword, this.OpenParenToken, this.Declaration, this.Initializers, this.FirstSemicolonToken, this.Condition, this.SecondSemicolonToken, incrementors, this.CloseParenToken, this.Statement);
    }

    public ForStatementSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.ForKeyword, this.OpenParenToken, this.Declaration, this.Initializers, this.FirstSemicolonToken, this.Condition, this.SecondSemicolonToken, this.Incrementors, closeParenToken, this.Statement);
    }

    public ForStatementSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(this.ForKeyword, this.OpenParenToken, this.Declaration, this.Initializers, this.FirstSemicolonToken, this.Condition, this.SecondSemicolonToken, this.Incrementors, this.CloseParenToken, statement);
    }

    public ForStatementSyntax AddInitializers(params ExpressionSyntax[] items)
    {
        return this.WithInitializers(this.Initializers.AddRange(items));
    }

    public ForStatementSyntax AddIncrementors(params ExpressionSyntax[] items)
    {
        return this.WithIncrementors(this.Incrementors.AddRange(items));
    }
  }

  public abstract partial class CommonForEachStatementSyntax : StatementSyntax
  {
    internal CommonForEachStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    public abstract SyntaxToken ForEachKeyword { get; }

    public abstract SyntaxToken OpenParenToken { get; }

    public abstract SyntaxToken InKeyword { get; }

    public abstract ExpressionSyntax Expression { get; }

    public abstract SyntaxToken CloseParenToken { get; }

    public abstract StatementSyntax Statement { get; }
  }

  public sealed partial class ForEachStatementSyntax : CommonForEachStatementSyntax
  {
    private TypeSyntax type;
    private ExpressionSyntax expression;
    private StatementSyntax statement;

    internal ForEachStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken ForEachKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForEachStatementSyntax)this.Green).forEachKeyword, this.Position, 0); }
    }

    public override SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForEachStatementSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 2);
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForEachStatementSyntax)this.Green).identifier, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override SyntaxToken InKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForEachStatementSyntax)this.Green).inKeyword, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    public override ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 5);
        }
    }

    public override SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForEachStatementSyntax)this.Green).closeParenToken, this.GetChildPosition(6), this.GetChildIndex(6)); }
    }

    public override StatementSyntax Statement 
    {
        get
        {
            return this.GetRed(ref this.statement, 7);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.type, 2);
            case 5: return this.GetRed(ref this.expression, 5);
            case 7: return this.GetRed(ref this.statement, 7);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.type;
            case 5: return this.expression;
            case 7: return this.statement;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitForEachStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitForEachStatement(this);
    }

    public ForEachStatementSyntax Update(SyntaxToken forEachKeyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (forEachKeyword != this.ForEachKeyword || openParenToken != this.OpenParenToken || type != this.Type || identifier != this.Identifier || inKeyword != this.InKeyword || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ForEachStatement(forEachKeyword, openParenToken, type, identifier, inKeyword, expression, closeParenToken, statement);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ForEachStatementSyntax WithForEachKeyword(SyntaxToken forEachKeyword)
    {
        return this.Update(forEachKeyword, this.OpenParenToken, this.Type, this.Identifier, this.InKeyword, this.Expression, this.CloseParenToken, this.Statement);
    }

    public ForEachStatementSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.ForEachKeyword, openParenToken, this.Type, this.Identifier, this.InKeyword, this.Expression, this.CloseParenToken, this.Statement);
    }

    public ForEachStatementSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.ForEachKeyword, this.OpenParenToken, type, this.Identifier, this.InKeyword, this.Expression, this.CloseParenToken, this.Statement);
    }

    public ForEachStatementSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.ForEachKeyword, this.OpenParenToken, this.Type, identifier, this.InKeyword, this.Expression, this.CloseParenToken, this.Statement);
    }

    public ForEachStatementSyntax WithInKeyword(SyntaxToken inKeyword)
    {
        return this.Update(this.ForEachKeyword, this.OpenParenToken, this.Type, this.Identifier, inKeyword, this.Expression, this.CloseParenToken, this.Statement);
    }

    public ForEachStatementSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.ForEachKeyword, this.OpenParenToken, this.Type, this.Identifier, this.InKeyword, expression, this.CloseParenToken, this.Statement);
    }

    public ForEachStatementSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.ForEachKeyword, this.OpenParenToken, this.Type, this.Identifier, this.InKeyword, this.Expression, closeParenToken, this.Statement);
    }

    public ForEachStatementSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(this.ForEachKeyword, this.OpenParenToken, this.Type, this.Identifier, this.InKeyword, this.Expression, this.CloseParenToken, statement);
    }
  }

  public sealed partial class ForEachVariableStatementSyntax : CommonForEachStatementSyntax
  {
    private ExpressionSyntax variable;
    private ExpressionSyntax expression;
    private StatementSyntax statement;

    internal ForEachVariableStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken ForEachKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForEachVariableStatementSyntax)this.Green).forEachKeyword, this.Position, 0); }
    }

    public override SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForEachVariableStatementSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>
    /// The variable(s) of the loop. In correct code this is a tuple
    /// literal, declaration expression with a tuple designator, or
    /// a wildcard syntax in the form of a simple identifier. In broken
    /// code it could be something else.
    /// </summary>
    public ExpressionSyntax Variable 
    {
        get
        {
            return this.GetRed(ref this.variable, 2);
        }
    }

    public override SyntaxToken InKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForEachVariableStatementSyntax)this.Green).inKeyword, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 4);
        }
    }

    public override SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ForEachVariableStatementSyntax)this.Green).closeParenToken, this.GetChildPosition(5), this.GetChildIndex(5)); }
    }

    public override StatementSyntax Statement 
    {
        get
        {
            return this.GetRed(ref this.statement, 6);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.variable, 2);
            case 4: return this.GetRed(ref this.expression, 4);
            case 6: return this.GetRed(ref this.statement, 6);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.variable;
            case 4: return this.expression;
            case 6: return this.statement;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitForEachVariableStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitForEachVariableStatement(this);
    }

    public ForEachVariableStatementSyntax Update(SyntaxToken forEachKeyword, SyntaxToken openParenToken, ExpressionSyntax variable, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (forEachKeyword != this.ForEachKeyword || openParenToken != this.OpenParenToken || variable != this.Variable || inKeyword != this.InKeyword || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ForEachVariableStatement(forEachKeyword, openParenToken, variable, inKeyword, expression, closeParenToken, statement);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ForEachVariableStatementSyntax WithForEachKeyword(SyntaxToken forEachKeyword)
    {
        return this.Update(forEachKeyword, this.OpenParenToken, this.Variable, this.InKeyword, this.Expression, this.CloseParenToken, this.Statement);
    }

    public ForEachVariableStatementSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.ForEachKeyword, openParenToken, this.Variable, this.InKeyword, this.Expression, this.CloseParenToken, this.Statement);
    }

    public ForEachVariableStatementSyntax WithVariable(ExpressionSyntax variable)
    {
        return this.Update(this.ForEachKeyword, this.OpenParenToken, variable, this.InKeyword, this.Expression, this.CloseParenToken, this.Statement);
    }

    public ForEachVariableStatementSyntax WithInKeyword(SyntaxToken inKeyword)
    {
        return this.Update(this.ForEachKeyword, this.OpenParenToken, this.Variable, inKeyword, this.Expression, this.CloseParenToken, this.Statement);
    }

    public ForEachVariableStatementSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.ForEachKeyword, this.OpenParenToken, this.Variable, this.InKeyword, expression, this.CloseParenToken, this.Statement);
    }

    public ForEachVariableStatementSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.ForEachKeyword, this.OpenParenToken, this.Variable, this.InKeyword, this.Expression, closeParenToken, this.Statement);
    }

    public ForEachVariableStatementSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(this.ForEachKeyword, this.OpenParenToken, this.Variable, this.InKeyword, this.Expression, this.CloseParenToken, statement);
    }
  }

  public sealed partial class UsingStatementSyntax : StatementSyntax
  {
    private VariableDeclarationSyntax declaration;
    private ExpressionSyntax expression;
    private StatementSyntax statement;

    internal UsingStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken UsingKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UsingStatementSyntax)this.Green).usingKeyword, this.Position, 0); }
    }

    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UsingStatementSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public VariableDeclarationSyntax Declaration 
    {
        get
        {
            return this.GetRed(ref this.declaration, 2);
        }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 3);
        }
    }

    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UsingStatementSyntax)this.Green).closeParenToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    public StatementSyntax Statement 
    {
        get
        {
            return this.GetRed(ref this.statement, 5);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.declaration, 2);
            case 3: return this.GetRed(ref this.expression, 3);
            case 5: return this.GetRed(ref this.statement, 5);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.declaration;
            case 3: return this.expression;
            case 5: return this.statement;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitUsingStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitUsingStatement(this);
    }

    public UsingStatementSyntax Update(SyntaxToken usingKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (usingKeyword != this.UsingKeyword || openParenToken != this.OpenParenToken || declaration != this.Declaration || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.UsingStatement(usingKeyword, openParenToken, declaration, expression, closeParenToken, statement);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public UsingStatementSyntax WithUsingKeyword(SyntaxToken usingKeyword)
    {
        return this.Update(usingKeyword, this.OpenParenToken, this.Declaration, this.Expression, this.CloseParenToken, this.Statement);
    }

    public UsingStatementSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.UsingKeyword, openParenToken, this.Declaration, this.Expression, this.CloseParenToken, this.Statement);
    }

    public UsingStatementSyntax WithDeclaration(VariableDeclarationSyntax declaration)
    {
        return this.Update(this.UsingKeyword, this.OpenParenToken, declaration, this.Expression, this.CloseParenToken, this.Statement);
    }

    public UsingStatementSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.UsingKeyword, this.OpenParenToken, this.Declaration, expression, this.CloseParenToken, this.Statement);
    }

    public UsingStatementSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.UsingKeyword, this.OpenParenToken, this.Declaration, this.Expression, closeParenToken, this.Statement);
    }

    public UsingStatementSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(this.UsingKeyword, this.OpenParenToken, this.Declaration, this.Expression, this.CloseParenToken, statement);
    }
  }

  public sealed partial class FixedStatementSyntax : StatementSyntax
  {
    private VariableDeclarationSyntax declaration;
    private StatementSyntax statement;

    internal FixedStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken FixedKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.FixedStatementSyntax)this.Green).fixedKeyword, this.Position, 0); }
    }

    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.FixedStatementSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public VariableDeclarationSyntax Declaration 
    {
        get
        {
            return this.GetRed(ref this.declaration, 2);
        }
    }

    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.FixedStatementSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public StatementSyntax Statement 
    {
        get
        {
            return this.GetRed(ref this.statement, 4);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.declaration, 2);
            case 4: return this.GetRed(ref this.statement, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.declaration;
            case 4: return this.statement;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitFixedStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitFixedStatement(this);
    }

    public FixedStatementSyntax Update(SyntaxToken fixedKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (fixedKeyword != this.FixedKeyword || openParenToken != this.OpenParenToken || declaration != this.Declaration || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.FixedStatement(fixedKeyword, openParenToken, declaration, closeParenToken, statement);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public FixedStatementSyntax WithFixedKeyword(SyntaxToken fixedKeyword)
    {
        return this.Update(fixedKeyword, this.OpenParenToken, this.Declaration, this.CloseParenToken, this.Statement);
    }

    public FixedStatementSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.FixedKeyword, openParenToken, this.Declaration, this.CloseParenToken, this.Statement);
    }

    public FixedStatementSyntax WithDeclaration(VariableDeclarationSyntax declaration)
    {
        return this.Update(this.FixedKeyword, this.OpenParenToken, declaration, this.CloseParenToken, this.Statement);
    }

    public FixedStatementSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.FixedKeyword, this.OpenParenToken, this.Declaration, closeParenToken, this.Statement);
    }

    public FixedStatementSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(this.FixedKeyword, this.OpenParenToken, this.Declaration, this.CloseParenToken, statement);
    }

    public FixedStatementSyntax AddDeclarationVariables(params VariableDeclaratorSyntax[] items)
    {
        return this.WithDeclaration(this.Declaration.WithVariables(this.Declaration.Variables.AddRange(items)));
    }
  }

  public sealed partial class CheckedStatementSyntax : StatementSyntax
  {
    private BlockSyntax block;

    internal CheckedStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CheckedStatementSyntax)this.Green).keyword, this.Position, 0); }
    }

    public BlockSyntax Block 
    {
        get
        {
            return this.GetRed(ref this.block, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.block, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.block;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCheckedStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCheckedStatement(this);
    }

    public CheckedStatementSyntax Update(SyntaxToken keyword, BlockSyntax block)
    {
        if (keyword != this.Keyword || block != this.Block)
        {
            var newNode = SyntaxFactory.CheckedStatement(this.Kind(), keyword, block);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CheckedStatementSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword, this.Block);
    }

    public CheckedStatementSyntax WithBlock(BlockSyntax block)
    {
        return this.Update(this.Keyword, block);
    }

    public CheckedStatementSyntax AddBlockStatements(params StatementSyntax[] items)
    {
        return this.WithBlock(this.Block.WithStatements(this.Block.Statements.AddRange(items)));
    }
  }

  public sealed partial class UnsafeStatementSyntax : StatementSyntax
  {
    private BlockSyntax block;

    internal UnsafeStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken UnsafeKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UnsafeStatementSyntax)this.Green).unsafeKeyword, this.Position, 0); }
    }

    public BlockSyntax Block 
    {
        get
        {
            return this.GetRed(ref this.block, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.block, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.block;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitUnsafeStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitUnsafeStatement(this);
    }

    public UnsafeStatementSyntax Update(SyntaxToken unsafeKeyword, BlockSyntax block)
    {
        if (unsafeKeyword != this.UnsafeKeyword || block != this.Block)
        {
            var newNode = SyntaxFactory.UnsafeStatement(unsafeKeyword, block);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public UnsafeStatementSyntax WithUnsafeKeyword(SyntaxToken unsafeKeyword)
    {
        return this.Update(unsafeKeyword, this.Block);
    }

    public UnsafeStatementSyntax WithBlock(BlockSyntax block)
    {
        return this.Update(this.UnsafeKeyword, block);
    }

    public UnsafeStatementSyntax AddBlockStatements(params StatementSyntax[] items)
    {
        return this.WithBlock(this.Block.WithStatements(this.Block.Statements.AddRange(items)));
    }
  }

  public sealed partial class LockStatementSyntax : StatementSyntax
  {
    private ExpressionSyntax expression;
    private StatementSyntax statement;

    internal LockStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken LockKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LockStatementSyntax)this.Green).lockKeyword, this.Position, 0); }
    }

    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LockStatementSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 2);
        }
    }

    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LockStatementSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public StatementSyntax Statement 
    {
        get
        {
            return this.GetRed(ref this.statement, 4);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.expression, 2);
            case 4: return this.GetRed(ref this.statement, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.expression;
            case 4: return this.statement;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitLockStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitLockStatement(this);
    }

    public LockStatementSyntax Update(SyntaxToken lockKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (lockKeyword != this.LockKeyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.LockStatement(lockKeyword, openParenToken, expression, closeParenToken, statement);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public LockStatementSyntax WithLockKeyword(SyntaxToken lockKeyword)
    {
        return this.Update(lockKeyword, this.OpenParenToken, this.Expression, this.CloseParenToken, this.Statement);
    }

    public LockStatementSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.LockKeyword, openParenToken, this.Expression, this.CloseParenToken, this.Statement);
    }

    public LockStatementSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.LockKeyword, this.OpenParenToken, expression, this.CloseParenToken, this.Statement);
    }

    public LockStatementSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.LockKeyword, this.OpenParenToken, this.Expression, closeParenToken, this.Statement);
    }

    public LockStatementSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(this.LockKeyword, this.OpenParenToken, this.Expression, this.CloseParenToken, statement);
    }
  }

  /// <summary>
  /// Represents an if statement syntax.
  /// </summary>
  public sealed partial class IfStatementSyntax : StatementSyntax
  {
    private ExpressionSyntax condition;
    private StatementSyntax statement;
    private ElseClauseSyntax @else;

    internal IfStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the if keyword.
    /// </summary>
    public SyntaxToken IfKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IfStatementSyntax)this.Green).ifKeyword, this.Position, 0); }
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the open parenthesis before the if statement's condition expression.
    /// </summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IfStatementSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>
    /// Gets an ExpressionSyntax that represents the condition of the if statement.
    /// </summary>
    public ExpressionSyntax Condition 
    {
        get
        {
            return this.GetRed(ref this.condition, 2);
        }
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the close parenthesis after the if statement's condition expression.
    /// </summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IfStatementSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    /// <summary>
    /// Gets a StatementSyntax the represents the statement to be executed when the condition is true.
    /// </summary>
    public StatementSyntax Statement 
    {
        get
        {
            return this.GetRed(ref this.statement, 4);
        }
    }

    /// <summary>
    /// Gets an ElseClauseSyntax that represents the statement to be executed when the condition is false if such statement exists.
    /// </summary>
    public ElseClauseSyntax Else 
    {
        get
        {
            return this.GetRed(ref this.@else, 5);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.condition, 2);
            case 4: return this.GetRed(ref this.statement, 4);
            case 5: return this.GetRed(ref this.@else, 5);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.condition;
            case 4: return this.statement;
            case 5: return this.@else;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitIfStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitIfStatement(this);
    }

    public IfStatementSyntax Update(SyntaxToken ifKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, ElseClauseSyntax @else)
    {
        if (ifKeyword != this.IfKeyword || openParenToken != this.OpenParenToken || condition != this.Condition || closeParenToken != this.CloseParenToken || statement != this.Statement || @else != this.Else)
        {
            var newNode = SyntaxFactory.IfStatement(ifKeyword, openParenToken, condition, closeParenToken, statement, @else);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public IfStatementSyntax WithIfKeyword(SyntaxToken ifKeyword)
    {
        return this.Update(ifKeyword, this.OpenParenToken, this.Condition, this.CloseParenToken, this.Statement, this.Else);
    }

    public IfStatementSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.IfKeyword, openParenToken, this.Condition, this.CloseParenToken, this.Statement, this.Else);
    }

    public IfStatementSyntax WithCondition(ExpressionSyntax condition)
    {
        return this.Update(this.IfKeyword, this.OpenParenToken, condition, this.CloseParenToken, this.Statement, this.Else);
    }

    public IfStatementSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.IfKeyword, this.OpenParenToken, this.Condition, closeParenToken, this.Statement, this.Else);
    }

    public IfStatementSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(this.IfKeyword, this.OpenParenToken, this.Condition, this.CloseParenToken, statement, this.Else);
    }

    public IfStatementSyntax WithElse(ElseClauseSyntax @else)
    {
        return this.Update(this.IfKeyword, this.OpenParenToken, this.Condition, this.CloseParenToken, this.Statement, @else);
    }
  }

  /// <summary>Represents an else statement syntax.</summary>
  public sealed partial class ElseClauseSyntax : CSharpSyntaxNode
  {
    private StatementSyntax statement;

    internal ElseClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>
    /// Gets a syntax token
    /// </summary>
    public SyntaxToken ElseKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElseClauseSyntax)this.Green).elseKeyword, this.Position, 0); }
    }

    public StatementSyntax Statement 
    {
        get
        {
            return this.GetRed(ref this.statement, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.statement, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.statement;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitElseClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitElseClause(this);
    }

    public ElseClauseSyntax Update(SyntaxToken elseKeyword, StatementSyntax statement)
    {
        if (elseKeyword != this.ElseKeyword || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ElseClause(elseKeyword, statement);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ElseClauseSyntax WithElseKeyword(SyntaxToken elseKeyword)
    {
        return this.Update(elseKeyword, this.Statement);
    }

    public ElseClauseSyntax WithStatement(StatementSyntax statement)
    {
        return this.Update(this.ElseKeyword, statement);
    }
  }

  /// <summary>Represents a switch statement syntax.</summary>
  public sealed partial class SwitchStatementSyntax : StatementSyntax
  {
    private ExpressionSyntax expression;
    private SyntaxNode sections;

    internal SwitchStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the switch keyword.
    /// </summary>
    public SyntaxToken SwitchKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SwitchStatementSyntax)this.Green).switchKeyword, this.Position, 0); }
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the open parenthesis preceding the switch expression.
    /// </summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SwitchStatementSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>
    /// Gets an ExpressionSyntax representing the expression of the switch statement.
    /// </summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 2);
        }
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the close parenthesis succeeding the switch expression.
    /// </summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SwitchStatementSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the open braces preceding the switch sections.
    /// </summary>
    public SyntaxToken OpenBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SwitchStatementSyntax)this.Green).openBraceToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    /// <summary>
    /// Gets a SyntaxList of SwitchSectionSyntax's that represents the switch sections of the switch statement.
    /// </summary>
    public SyntaxList<SwitchSectionSyntax> Sections 
    {
        get
        {
            return new SyntaxList<SwitchSectionSyntax>(this.GetRed(ref this.sections, 5));
        }
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the open braces succeeding the switch sections.
    /// </summary>
    public SyntaxToken CloseBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.SwitchStatementSyntax)this.Green).closeBraceToken, this.GetChildPosition(6), this.GetChildIndex(6)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.expression, 2);
            case 5: return this.GetRed(ref this.sections, 5);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.expression;
            case 5: return this.sections;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitSwitchStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitSwitchStatement(this);
    }

    public SwitchStatementSyntax Update(SyntaxToken switchKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxToken openBraceToken, SyntaxList<SwitchSectionSyntax> sections, SyntaxToken closeBraceToken)
    {
        if (switchKeyword != this.SwitchKeyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken || openBraceToken != this.OpenBraceToken || sections != this.Sections || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.SwitchStatement(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, sections, closeBraceToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public SwitchStatementSyntax WithSwitchKeyword(SyntaxToken switchKeyword)
    {
        return this.Update(switchKeyword, this.OpenParenToken, this.Expression, this.CloseParenToken, this.OpenBraceToken, this.Sections, this.CloseBraceToken);
    }

    public SwitchStatementSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.SwitchKeyword, openParenToken, this.Expression, this.CloseParenToken, this.OpenBraceToken, this.Sections, this.CloseBraceToken);
    }

    public SwitchStatementSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.SwitchKeyword, this.OpenParenToken, expression, this.CloseParenToken, this.OpenBraceToken, this.Sections, this.CloseBraceToken);
    }

    public SwitchStatementSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.SwitchKeyword, this.OpenParenToken, this.Expression, closeParenToken, this.OpenBraceToken, this.Sections, this.CloseBraceToken);
    }

    public SwitchStatementSyntax WithOpenBraceToken(SyntaxToken openBraceToken)
    {
        return this.Update(this.SwitchKeyword, this.OpenParenToken, this.Expression, this.CloseParenToken, openBraceToken, this.Sections, this.CloseBraceToken);
    }

    public SwitchStatementSyntax WithSections(SyntaxList<SwitchSectionSyntax> sections)
    {
        return this.Update(this.SwitchKeyword, this.OpenParenToken, this.Expression, this.CloseParenToken, this.OpenBraceToken, sections, this.CloseBraceToken);
    }

    public SwitchStatementSyntax WithCloseBraceToken(SyntaxToken closeBraceToken)
    {
        return this.Update(this.SwitchKeyword, this.OpenParenToken, this.Expression, this.CloseParenToken, this.OpenBraceToken, this.Sections, closeBraceToken);
    }

    public SwitchStatementSyntax AddSections(params SwitchSectionSyntax[] items)
    {
        return this.WithSections(this.Sections.AddRange(items));
    }
  }

  /// <summary>Represents a switch section syntax of a switch statement.</summary>
  public sealed partial class SwitchSectionSyntax : CSharpSyntaxNode
  {
    private SyntaxNode labels;
    private SyntaxNode statements;

    internal SwitchSectionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>
    /// Gets a SyntaxList of SwitchLabelSyntax's the represents the possible labels that control can transfer to within the section.
    /// </summary>
    public SyntaxList<SwitchLabelSyntax> Labels 
    {
        get
        {
            return new SyntaxList<SwitchLabelSyntax>(this.GetRed(ref this.labels, 0));
        }
    }

    /// <summary>
    /// Gets a SyntaxList of StatementSyntax's the represents the statements to be executed when control transfer to a label the belongs to the section.
    /// </summary>
    public SyntaxList<StatementSyntax> Statements 
    {
        get
        {
            return new SyntaxList<StatementSyntax>(this.GetRed(ref this.statements, 1));
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.labels);
            case 1: return this.GetRed(ref this.statements, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.labels;
            case 1: return this.statements;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitSwitchSection(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitSwitchSection(this);
    }

    public SwitchSectionSyntax Update(SyntaxList<SwitchLabelSyntax> labels, SyntaxList<StatementSyntax> statements)
    {
        if (labels != this.Labels || statements != this.Statements)
        {
            var newNode = SyntaxFactory.SwitchSection(labels, statements);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public SwitchSectionSyntax WithLabels(SyntaxList<SwitchLabelSyntax> labels)
    {
        return this.Update(labels, this.Statements);
    }

    public SwitchSectionSyntax WithStatements(SyntaxList<StatementSyntax> statements)
    {
        return this.Update(this.Labels, statements);
    }

    public SwitchSectionSyntax AddLabels(params SwitchLabelSyntax[] items)
    {
        return this.WithLabels(this.Labels.AddRange(items));
    }

    public SwitchSectionSyntax AddStatements(params StatementSyntax[] items)
    {
        return this.WithStatements(this.Statements.AddRange(items));
    }
  }

  /// <summary>Represents a switch label within a switch statement.</summary>
  public abstract partial class SwitchLabelSyntax : CSharpSyntaxNode
  {
    internal SwitchLabelSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>
    /// Gets a SyntaxToken that represents a case or default keyword that belongs to a switch label.
    /// </summary>
    public abstract SyntaxToken Keyword { get; }

    /// <summary>
    /// Gets a SyntaxToken that represents the colon that terminates the switch label.
    /// </summary>
    public abstract SyntaxToken ColonToken { get; }
  }

  /// <summary>Represents a case label within a switch statement.</summary>
  public sealed partial class CasePatternSwitchLabelSyntax : SwitchLabelSyntax
  {
    private PatternSyntax pattern;
    private WhenClauseSyntax whenClause;

    internal CasePatternSwitchLabelSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the case keyword token.</summary>
    public override SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CasePatternSwitchLabelSyntax)this.Green).keyword, this.Position, 0); }
    }

    /// <summary>
    /// Gets a PatternSyntax that represents the pattern that gets matched for the case label.
    /// </summary>
    public PatternSyntax Pattern 
    {
        get
        {
            return this.GetRed(ref this.pattern, 1);
        }
    }

    public WhenClauseSyntax WhenClause 
    {
        get
        {
            return this.GetRed(ref this.whenClause, 2);
        }
    }

    public override SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CasePatternSwitchLabelSyntax)this.Green).colonToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.pattern, 1);
            case 2: return this.GetRed(ref this.whenClause, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.pattern;
            case 2: return this.whenClause;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCasePatternSwitchLabel(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCasePatternSwitchLabel(this);
    }

    public CasePatternSwitchLabelSyntax Update(SyntaxToken keyword, PatternSyntax pattern, WhenClauseSyntax whenClause, SyntaxToken colonToken)
    {
        if (keyword != this.Keyword || pattern != this.Pattern || whenClause != this.WhenClause || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.CasePatternSwitchLabel(keyword, pattern, whenClause, colonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CasePatternSwitchLabelSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword, this.Pattern, this.WhenClause, this.ColonToken);
    }

    public CasePatternSwitchLabelSyntax WithPattern(PatternSyntax pattern)
    {
        return this.Update(this.Keyword, pattern, this.WhenClause, this.ColonToken);
    }

    public CasePatternSwitchLabelSyntax WithWhenClause(WhenClauseSyntax whenClause)
    {
        return this.Update(this.Keyword, this.Pattern, whenClause, this.ColonToken);
    }

    public CasePatternSwitchLabelSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(this.Keyword, this.Pattern, this.WhenClause, colonToken);
    }
  }

  /// <summary>Represents a case label within a switch statement.</summary>
  public sealed partial class CaseSwitchLabelSyntax : SwitchLabelSyntax
  {
    private ExpressionSyntax value;

    internal CaseSwitchLabelSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the case keyword token.</summary>
    public override SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CaseSwitchLabelSyntax)this.Green).keyword, this.Position, 0); }
    }

    /// <summary>
    /// Gets an ExpressionSyntax that represents the constant expression that gets matched for the case label.
    /// </summary>
    public ExpressionSyntax Value 
    {
        get
        {
            return this.GetRed(ref this.value, 1);
        }
    }

    public override SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CaseSwitchLabelSyntax)this.Green).colonToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.value, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.value;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCaseSwitchLabel(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCaseSwitchLabel(this);
    }

    public CaseSwitchLabelSyntax Update(SyntaxToken keyword, ExpressionSyntax value, SyntaxToken colonToken)
    {
        if (keyword != this.Keyword || value != this.Value || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.CaseSwitchLabel(keyword, value, colonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CaseSwitchLabelSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword, this.Value, this.ColonToken);
    }

    public CaseSwitchLabelSyntax WithValue(ExpressionSyntax value)
    {
        return this.Update(this.Keyword, value, this.ColonToken);
    }

    public CaseSwitchLabelSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(this.Keyword, this.Value, colonToken);
    }
  }

  /// <summary>Represents a default label within a switch statement.</summary>
  public sealed partial class DefaultSwitchLabelSyntax : SwitchLabelSyntax
  {
    internal DefaultSwitchLabelSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the default keyword token.</summary>
    public override SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DefaultSwitchLabelSyntax)this.Green).keyword, this.Position, 0); }
    }

    public override SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DefaultSwitchLabelSyntax)this.Green).colonToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitDefaultSwitchLabel(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitDefaultSwitchLabel(this);
    }

    public DefaultSwitchLabelSyntax Update(SyntaxToken keyword, SyntaxToken colonToken)
    {
        if (keyword != this.Keyword || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.DefaultSwitchLabel(keyword, colonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public DefaultSwitchLabelSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(keyword, this.ColonToken);
    }

    public DefaultSwitchLabelSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(this.Keyword, colonToken);
    }
  }

  public sealed partial class TryStatementSyntax : StatementSyntax
  {
    private BlockSyntax block;
    private SyntaxNode catches;
    private FinallyClauseSyntax @finally;

    internal TryStatementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken TryKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TryStatementSyntax)this.Green).tryKeyword, this.Position, 0); }
    }

    public BlockSyntax Block 
    {
        get
        {
            return this.GetRed(ref this.block, 1);
        }
    }

    public SyntaxList<CatchClauseSyntax> Catches 
    {
        get
        {
            return new SyntaxList<CatchClauseSyntax>(this.GetRed(ref this.catches, 2));
        }
    }

    public FinallyClauseSyntax Finally 
    {
        get
        {
            return this.GetRed(ref this.@finally, 3);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.block, 1);
            case 2: return this.GetRed(ref this.catches, 2);
            case 3: return this.GetRed(ref this.@finally, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.block;
            case 2: return this.catches;
            case 3: return this.@finally;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitTryStatement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitTryStatement(this);
    }

    public TryStatementSyntax Update(SyntaxToken tryKeyword, BlockSyntax block, SyntaxList<CatchClauseSyntax> catches, FinallyClauseSyntax @finally)
    {
        if (tryKeyword != this.TryKeyword || block != this.Block || catches != this.Catches || @finally != this.Finally)
        {
            var newNode = SyntaxFactory.TryStatement(tryKeyword, block, catches, @finally);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public TryStatementSyntax WithTryKeyword(SyntaxToken tryKeyword)
    {
        return this.Update(tryKeyword, this.Block, this.Catches, this.Finally);
    }

    public TryStatementSyntax WithBlock(BlockSyntax block)
    {
        return this.Update(this.TryKeyword, block, this.Catches, this.Finally);
    }

    public TryStatementSyntax WithCatches(SyntaxList<CatchClauseSyntax> catches)
    {
        return this.Update(this.TryKeyword, this.Block, catches, this.Finally);
    }

    public TryStatementSyntax WithFinally(FinallyClauseSyntax @finally)
    {
        return this.Update(this.TryKeyword, this.Block, this.Catches, @finally);
    }

    public TryStatementSyntax AddBlockStatements(params StatementSyntax[] items)
    {
        return this.WithBlock(this.Block.WithStatements(this.Block.Statements.AddRange(items)));
    }

    public TryStatementSyntax AddCatches(params CatchClauseSyntax[] items)
    {
        return this.WithCatches(this.Catches.AddRange(items));
    }
  }

  public sealed partial class CatchClauseSyntax : CSharpSyntaxNode
  {
    private CatchDeclarationSyntax declaration;
    private CatchFilterClauseSyntax filter;
    private BlockSyntax block;

    internal CatchClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken CatchKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CatchClauseSyntax)this.Green).catchKeyword, this.Position, 0); }
    }

    public CatchDeclarationSyntax Declaration 
    {
        get
        {
            return this.GetRed(ref this.declaration, 1);
        }
    }

    public CatchFilterClauseSyntax Filter 
    {
        get
        {
            return this.GetRed(ref this.filter, 2);
        }
    }

    public BlockSyntax Block 
    {
        get
        {
            return this.GetRed(ref this.block, 3);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.declaration, 1);
            case 2: return this.GetRed(ref this.filter, 2);
            case 3: return this.GetRed(ref this.block, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.declaration;
            case 2: return this.filter;
            case 3: return this.block;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCatchClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCatchClause(this);
    }

    public CatchClauseSyntax Update(SyntaxToken catchKeyword, CatchDeclarationSyntax declaration, CatchFilterClauseSyntax filter, BlockSyntax block)
    {
        if (catchKeyword != this.CatchKeyword || declaration != this.Declaration || filter != this.Filter || block != this.Block)
        {
            var newNode = SyntaxFactory.CatchClause(catchKeyword, declaration, filter, block);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CatchClauseSyntax WithCatchKeyword(SyntaxToken catchKeyword)
    {
        return this.Update(catchKeyword, this.Declaration, this.Filter, this.Block);
    }

    public CatchClauseSyntax WithDeclaration(CatchDeclarationSyntax declaration)
    {
        return this.Update(this.CatchKeyword, declaration, this.Filter, this.Block);
    }

    public CatchClauseSyntax WithFilter(CatchFilterClauseSyntax filter)
    {
        return this.Update(this.CatchKeyword, this.Declaration, filter, this.Block);
    }

    public CatchClauseSyntax WithBlock(BlockSyntax block)
    {
        return this.Update(this.CatchKeyword, this.Declaration, this.Filter, block);
    }

    public CatchClauseSyntax AddBlockStatements(params StatementSyntax[] items)
    {
        return this.WithBlock(this.Block.WithStatements(this.Block.Statements.AddRange(items)));
    }
  }

  public sealed partial class CatchDeclarationSyntax : CSharpSyntaxNode
  {
    private TypeSyntax type;

    internal CatchDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CatchDeclarationSyntax)this.Green).openParenToken, this.Position, 0); }
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 1);
        }
    }

    public SyntaxToken Identifier 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CatchDeclarationSyntax)this.Green).identifier;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(2), this.GetChildIndex(2));

            return default(SyntaxToken);
        }
    }

    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CatchDeclarationSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.type, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCatchDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCatchDeclaration(this);
    }

    public CatchDeclarationSyntax Update(SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || type != this.Type || identifier != this.Identifier || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.CatchDeclaration(openParenToken, type, identifier, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CatchDeclarationSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(openParenToken, this.Type, this.Identifier, this.CloseParenToken);
    }

    public CatchDeclarationSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.OpenParenToken, type, this.Identifier, this.CloseParenToken);
    }

    public CatchDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.OpenParenToken, this.Type, identifier, this.CloseParenToken);
    }

    public CatchDeclarationSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.OpenParenToken, this.Type, this.Identifier, closeParenToken);
    }
  }

  public sealed partial class CatchFilterClauseSyntax : CSharpSyntaxNode
  {
    private ExpressionSyntax filterExpression;

    internal CatchFilterClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken WhenKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CatchFilterClauseSyntax)this.Green).whenKeyword, this.Position, 0); }
    }

    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CatchFilterClauseSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public ExpressionSyntax FilterExpression 
    {
        get
        {
            return this.GetRed(ref this.filterExpression, 2);
        }
    }

    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CatchFilterClauseSyntax)this.Green).closeParenToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.filterExpression, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.filterExpression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCatchFilterClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCatchFilterClause(this);
    }

    public CatchFilterClauseSyntax Update(SyntaxToken whenKeyword, SyntaxToken openParenToken, ExpressionSyntax filterExpression, SyntaxToken closeParenToken)
    {
        if (whenKeyword != this.WhenKeyword || openParenToken != this.OpenParenToken || filterExpression != this.FilterExpression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.CatchFilterClause(whenKeyword, openParenToken, filterExpression, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CatchFilterClauseSyntax WithWhenKeyword(SyntaxToken whenKeyword)
    {
        return this.Update(whenKeyword, this.OpenParenToken, this.FilterExpression, this.CloseParenToken);
    }

    public CatchFilterClauseSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.WhenKeyword, openParenToken, this.FilterExpression, this.CloseParenToken);
    }

    public CatchFilterClauseSyntax WithFilterExpression(ExpressionSyntax filterExpression)
    {
        return this.Update(this.WhenKeyword, this.OpenParenToken, filterExpression, this.CloseParenToken);
    }

    public CatchFilterClauseSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.WhenKeyword, this.OpenParenToken, this.FilterExpression, closeParenToken);
    }
  }

  public sealed partial class FinallyClauseSyntax : CSharpSyntaxNode
  {
    private BlockSyntax block;

    internal FinallyClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken FinallyKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.FinallyClauseSyntax)this.Green).finallyKeyword, this.Position, 0); }
    }

    public BlockSyntax Block 
    {
        get
        {
            return this.GetRed(ref this.block, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.block, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.block;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitFinallyClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitFinallyClause(this);
    }

    public FinallyClauseSyntax Update(SyntaxToken finallyKeyword, BlockSyntax block)
    {
        if (finallyKeyword != this.FinallyKeyword || block != this.Block)
        {
            var newNode = SyntaxFactory.FinallyClause(finallyKeyword, block);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public FinallyClauseSyntax WithFinallyKeyword(SyntaxToken finallyKeyword)
    {
        return this.Update(finallyKeyword, this.Block);
    }

    public FinallyClauseSyntax WithBlock(BlockSyntax block)
    {
        return this.Update(this.FinallyKeyword, block);
    }

    public FinallyClauseSyntax AddBlockStatements(params StatementSyntax[] items)
    {
        return this.WithBlock(this.Block.WithStatements(this.Block.Statements.AddRange(items)));
    }
  }

  public sealed partial class CompilationUnitSyntax : CSharpSyntaxNode
  {
    private SyntaxNode externs;
    private SyntaxNode usings;
    private SyntaxNode attributeLists;
    private SyntaxNode members;

    internal CompilationUnitSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<ExternAliasDirectiveSyntax> Externs 
    {
        get
        {
            return new SyntaxList<ExternAliasDirectiveSyntax>(this.GetRed(ref this.externs, 0));
        }
    }

    public SyntaxList<UsingDirectiveSyntax> Usings 
    {
        get
        {
            return new SyntaxList<UsingDirectiveSyntax>(this.GetRed(ref this.usings, 1));
        }
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 2));
        }
    }

    public SyntaxList<MemberDeclarationSyntax> Members 
    {
        get
        {
            return new SyntaxList<MemberDeclarationSyntax>(this.GetRed(ref this.members, 3));
        }
    }

    public SyntaxToken EndOfFileToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CompilationUnitSyntax)this.Green).endOfFileToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.externs);
            case 1: return this.GetRed(ref this.usings, 1);
            case 2: return this.GetRed(ref this.attributeLists, 2);
            case 3: return this.GetRed(ref this.members, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.externs;
            case 1: return this.usings;
            case 2: return this.attributeLists;
            case 3: return this.members;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCompilationUnit(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCompilationUnit(this);
    }

    public CompilationUnitSyntax Update(SyntaxList<ExternAliasDirectiveSyntax> externs, SyntaxList<UsingDirectiveSyntax> usings, SyntaxList<AttributeListSyntax> attributeLists, SyntaxList<MemberDeclarationSyntax> members, SyntaxToken endOfFileToken)
    {
        if (externs != this.Externs || usings != this.Usings || attributeLists != this.AttributeLists || members != this.Members || endOfFileToken != this.EndOfFileToken)
        {
            var newNode = SyntaxFactory.CompilationUnit(externs, usings, attributeLists, members, endOfFileToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CompilationUnitSyntax WithExterns(SyntaxList<ExternAliasDirectiveSyntax> externs)
    {
        return this.Update(externs, this.Usings, this.AttributeLists, this.Members, this.EndOfFileToken);
    }

    public CompilationUnitSyntax WithUsings(SyntaxList<UsingDirectiveSyntax> usings)
    {
        return this.Update(this.Externs, usings, this.AttributeLists, this.Members, this.EndOfFileToken);
    }

    public CompilationUnitSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(this.Externs, this.Usings, attributeLists, this.Members, this.EndOfFileToken);
    }

    public CompilationUnitSyntax WithMembers(SyntaxList<MemberDeclarationSyntax> members)
    {
        return this.Update(this.Externs, this.Usings, this.AttributeLists, members, this.EndOfFileToken);
    }

    public CompilationUnitSyntax WithEndOfFileToken(SyntaxToken endOfFileToken)
    {
        return this.Update(this.Externs, this.Usings, this.AttributeLists, this.Members, endOfFileToken);
    }

    public CompilationUnitSyntax AddExterns(params ExternAliasDirectiveSyntax[] items)
    {
        return this.WithExterns(this.Externs.AddRange(items));
    }

    public CompilationUnitSyntax AddUsings(params UsingDirectiveSyntax[] items)
    {
        return this.WithUsings(this.Usings.AddRange(items));
    }

    public CompilationUnitSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public CompilationUnitSyntax AddMembers(params MemberDeclarationSyntax[] items)
    {
        return this.WithMembers(this.Members.AddRange(items));
    }
  }

  /// <summary>
  /// Represents an ExternAlias directive syntax, e.g. "extern alias MyAlias;" with specifying "/r:MyAlias=SomeAssembly.dll " on the compiler command line.
  /// </summary>
  public sealed partial class ExternAliasDirectiveSyntax : CSharpSyntaxNode
  {
    internal ExternAliasDirectiveSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>SyntaxToken representing the extern keyword.</summary>
    public SyntaxToken ExternKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ExternAliasDirectiveSyntax)this.Green).externKeyword, this.Position, 0); }
    }

    /// <summary>SyntaxToken representing the alias keyword.</summary>
    public SyntaxToken AliasKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ExternAliasDirectiveSyntax)this.Green).aliasKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ExternAliasDirectiveSyntax)this.Green).identifier, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    /// <summary>SyntaxToken representing the semicolon token.</summary>
    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ExternAliasDirectiveSyntax)this.Green).semicolonToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitExternAliasDirective(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitExternAliasDirective(this);
    }

    public ExternAliasDirectiveSyntax Update(SyntaxToken externKeyword, SyntaxToken aliasKeyword, SyntaxToken identifier, SyntaxToken semicolonToken)
    {
        if (externKeyword != this.ExternKeyword || aliasKeyword != this.AliasKeyword || identifier != this.Identifier || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ExternAliasDirective(externKeyword, aliasKeyword, identifier, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ExternAliasDirectiveSyntax WithExternKeyword(SyntaxToken externKeyword)
    {
        return this.Update(externKeyword, this.AliasKeyword, this.Identifier, this.SemicolonToken);
    }

    public ExternAliasDirectiveSyntax WithAliasKeyword(SyntaxToken aliasKeyword)
    {
        return this.Update(this.ExternKeyword, aliasKeyword, this.Identifier, this.SemicolonToken);
    }

    public ExternAliasDirectiveSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.ExternKeyword, this.AliasKeyword, identifier, this.SemicolonToken);
    }

    public ExternAliasDirectiveSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.ExternKeyword, this.AliasKeyword, this.Identifier, semicolonToken);
    }
  }

  public sealed partial class UsingDirectiveSyntax : CSharpSyntaxNode
  {
    private NameEqualsSyntax alias;
    private NameSyntax name;

    internal UsingDirectiveSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken UsingKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UsingDirectiveSyntax)this.Green).usingKeyword, this.Position, 0); }
    }

    public SyntaxToken StaticKeyword 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UsingDirectiveSyntax)this.Green).staticKeyword;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxToken);
        }
    }

    public NameEqualsSyntax Alias 
    {
        get
        {
            return this.GetRed(ref this.alias, 2);
        }
    }

    public NameSyntax Name 
    {
        get
        {
            return this.GetRed(ref this.name, 3);
        }
    }

    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UsingDirectiveSyntax)this.Green).semicolonToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.alias, 2);
            case 3: return this.GetRed(ref this.name, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.alias;
            case 3: return this.name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitUsingDirective(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitUsingDirective(this);
    }

    public UsingDirectiveSyntax Update(SyntaxToken usingKeyword, SyntaxToken staticKeyword, NameEqualsSyntax alias, NameSyntax name, SyntaxToken semicolonToken)
    {
        if (usingKeyword != this.UsingKeyword || staticKeyword != this.StaticKeyword || alias != this.Alias || name != this.Name || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.UsingDirective(usingKeyword, staticKeyword, alias, name, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public UsingDirectiveSyntax WithUsingKeyword(SyntaxToken usingKeyword)
    {
        return this.Update(usingKeyword, this.StaticKeyword, this.Alias, this.Name, this.SemicolonToken);
    }

    public UsingDirectiveSyntax WithStaticKeyword(SyntaxToken staticKeyword)
    {
        return this.Update(this.UsingKeyword, staticKeyword, this.Alias, this.Name, this.SemicolonToken);
    }

    public UsingDirectiveSyntax WithAlias(NameEqualsSyntax alias)
    {
        return this.Update(this.UsingKeyword, this.StaticKeyword, alias, this.Name, this.SemicolonToken);
    }

    public UsingDirectiveSyntax WithName(NameSyntax name)
    {
        return this.Update(this.UsingKeyword, this.StaticKeyword, this.Alias, name, this.SemicolonToken);
    }

    public UsingDirectiveSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.UsingKeyword, this.StaticKeyword, this.Alias, this.Name, semicolonToken);
    }
  }

  /// <summary>Member declaration syntax.</summary>
  public abstract partial class MemberDeclarationSyntax : CSharpSyntaxNode
  {
    internal MemberDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  public sealed partial class NamespaceDeclarationSyntax : MemberDeclarationSyntax
  {
    private NameSyntax name;
    private SyntaxNode externs;
    private SyntaxNode usings;
    private SyntaxNode members;

    internal NamespaceDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken NamespaceKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.NamespaceDeclarationSyntax)this.Green).namespaceKeyword, this.Position, 0); }
    }

    public NameSyntax Name 
    {
        get
        {
            return this.GetRed(ref this.name, 1);
        }
    }

    public SyntaxToken OpenBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.NamespaceDeclarationSyntax)this.Green).openBraceToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public SyntaxList<ExternAliasDirectiveSyntax> Externs 
    {
        get
        {
            return new SyntaxList<ExternAliasDirectiveSyntax>(this.GetRed(ref this.externs, 3));
        }
    }

    public SyntaxList<UsingDirectiveSyntax> Usings 
    {
        get
        {
            return new SyntaxList<UsingDirectiveSyntax>(this.GetRed(ref this.usings, 4));
        }
    }

    public SyntaxList<MemberDeclarationSyntax> Members 
    {
        get
        {
            return new SyntaxList<MemberDeclarationSyntax>(this.GetRed(ref this.members, 5));
        }
    }

    public SyntaxToken CloseBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.NamespaceDeclarationSyntax)this.Green).closeBraceToken, this.GetChildPosition(6), this.GetChildIndex(6)); }
    }

    /// <summary>Gets the optional semicolon token.</summary>
    public SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.NamespaceDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(7), this.GetChildIndex(7));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.name, 1);
            case 3: return this.GetRed(ref this.externs, 3);
            case 4: return this.GetRed(ref this.usings, 4);
            case 5: return this.GetRed(ref this.members, 5);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.name;
            case 3: return this.externs;
            case 4: return this.usings;
            case 5: return this.members;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitNamespaceDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitNamespaceDeclaration(this);
    }

    public NamespaceDeclarationSyntax Update(SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken openBraceToken, SyntaxList<ExternAliasDirectiveSyntax> externs, SyntaxList<UsingDirectiveSyntax> usings, SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (namespaceKeyword != this.NamespaceKeyword || name != this.Name || openBraceToken != this.OpenBraceToken || externs != this.Externs || usings != this.Usings || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.NamespaceDeclaration(namespaceKeyword, name, openBraceToken, externs, usings, members, closeBraceToken, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public NamespaceDeclarationSyntax WithNamespaceKeyword(SyntaxToken namespaceKeyword)
    {
        return this.Update(namespaceKeyword, this.Name, this.OpenBraceToken, this.Externs, this.Usings, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public NamespaceDeclarationSyntax WithName(NameSyntax name)
    {
        return this.Update(this.NamespaceKeyword, name, this.OpenBraceToken, this.Externs, this.Usings, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public NamespaceDeclarationSyntax WithOpenBraceToken(SyntaxToken openBraceToken)
    {
        return this.Update(this.NamespaceKeyword, this.Name, openBraceToken, this.Externs, this.Usings, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public NamespaceDeclarationSyntax WithExterns(SyntaxList<ExternAliasDirectiveSyntax> externs)
    {
        return this.Update(this.NamespaceKeyword, this.Name, this.OpenBraceToken, externs, this.Usings, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public NamespaceDeclarationSyntax WithUsings(SyntaxList<UsingDirectiveSyntax> usings)
    {
        return this.Update(this.NamespaceKeyword, this.Name, this.OpenBraceToken, this.Externs, usings, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public NamespaceDeclarationSyntax WithMembers(SyntaxList<MemberDeclarationSyntax> members)
    {
        return this.Update(this.NamespaceKeyword, this.Name, this.OpenBraceToken, this.Externs, this.Usings, members, this.CloseBraceToken, this.SemicolonToken);
    }

    public NamespaceDeclarationSyntax WithCloseBraceToken(SyntaxToken closeBraceToken)
    {
        return this.Update(this.NamespaceKeyword, this.Name, this.OpenBraceToken, this.Externs, this.Usings, this.Members, closeBraceToken, this.SemicolonToken);
    }

    public NamespaceDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.NamespaceKeyword, this.Name, this.OpenBraceToken, this.Externs, this.Usings, this.Members, this.CloseBraceToken, semicolonToken);
    }

    public NamespaceDeclarationSyntax AddExterns(params ExternAliasDirectiveSyntax[] items)
    {
        return this.WithExterns(this.Externs.AddRange(items));
    }

    public NamespaceDeclarationSyntax AddUsings(params UsingDirectiveSyntax[] items)
    {
        return this.WithUsings(this.Usings.AddRange(items));
    }

    public NamespaceDeclarationSyntax AddMembers(params MemberDeclarationSyntax[] items)
    {
        return this.WithMembers(this.Members.AddRange(items));
    }
  }

  /// <summary>Class representing one or more attributes applied to a language construct.</summary>
  public sealed partial class AttributeListSyntax : CSharpSyntaxNode
  {
    private AttributeTargetSpecifierSyntax target;
    private SyntaxNode attributes;

    internal AttributeListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the open bracket token.</summary>
    public SyntaxToken OpenBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AttributeListSyntax)this.Green).openBracketToken, this.Position, 0); }
    }

    /// <summary>Gets the optional construct targeted by the attribute.</summary>
    public AttributeTargetSpecifierSyntax Target 
    {
        get
        {
            return this.GetRed(ref this.target, 1);
        }
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public SeparatedSyntaxList<AttributeSyntax> Attributes 
    {
        get
        {
            var red = this.GetRed(ref this.attributes, 2);
            if (red != null)
                return new SeparatedSyntaxList<AttributeSyntax>(red, this.GetChildIndex(2));

            return default(SeparatedSyntaxList<AttributeSyntax>);
        }
    }

    /// <summary>Gets the close bracket token.</summary>
    public SyntaxToken CloseBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AttributeListSyntax)this.Green).closeBracketToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.target, 1);
            case 2: return this.GetRed(ref this.attributes, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.target;
            case 2: return this.attributes;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAttributeList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAttributeList(this);
    }

    public AttributeListSyntax Update(SyntaxToken openBracketToken, AttributeTargetSpecifierSyntax target, SeparatedSyntaxList<AttributeSyntax> attributes, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || target != this.Target || attributes != this.Attributes || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.AttributeList(openBracketToken, target, attributes, closeBracketToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AttributeListSyntax WithOpenBracketToken(SyntaxToken openBracketToken)
    {
        return this.Update(openBracketToken, this.Target, this.Attributes, this.CloseBracketToken);
    }

    public AttributeListSyntax WithTarget(AttributeTargetSpecifierSyntax target)
    {
        return this.Update(this.OpenBracketToken, target, this.Attributes, this.CloseBracketToken);
    }

    public AttributeListSyntax WithAttributes(SeparatedSyntaxList<AttributeSyntax> attributes)
    {
        return this.Update(this.OpenBracketToken, this.Target, attributes, this.CloseBracketToken);
    }

    public AttributeListSyntax WithCloseBracketToken(SyntaxToken closeBracketToken)
    {
        return this.Update(this.OpenBracketToken, this.Target, this.Attributes, closeBracketToken);
    }

    public AttributeListSyntax AddAttributes(params AttributeSyntax[] items)
    {
        return this.WithAttributes(this.Attributes.AddRange(items));
    }
  }

  /// <summary>Class representing what language construct an attribute targets.</summary>
  public sealed partial class AttributeTargetSpecifierSyntax : CSharpSyntaxNode
  {
    internal AttributeTargetSpecifierSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AttributeTargetSpecifierSyntax)this.Green).identifier, this.Position, 0); }
    }

    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AttributeTargetSpecifierSyntax)this.Green).colonToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAttributeTargetSpecifier(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAttributeTargetSpecifier(this);
    }

    public AttributeTargetSpecifierSyntax Update(SyntaxToken identifier, SyntaxToken colonToken)
    {
        if (identifier != this.Identifier || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.AttributeTargetSpecifier(identifier, colonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AttributeTargetSpecifierSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(identifier, this.ColonToken);
    }

    public AttributeTargetSpecifierSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(this.Identifier, colonToken);
    }
  }

  /// <summary>Attribute syntax.</summary>
  public sealed partial class AttributeSyntax : CSharpSyntaxNode
  {
    private NameSyntax name;
    private AttributeArgumentListSyntax argumentList;

    internal AttributeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the name.</summary>
    public NameSyntax Name 
    {
        get
        {
            return this.GetRedAtZero(ref this.name);
        }
    }

    public AttributeArgumentListSyntax ArgumentList 
    {
        get
        {
            return this.GetRed(ref this.argumentList, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.name);
            case 1: return this.GetRed(ref this.argumentList, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            case 1: return this.argumentList;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAttribute(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAttribute(this);
    }

    public AttributeSyntax Update(NameSyntax name, AttributeArgumentListSyntax argumentList)
    {
        if (name != this.Name || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.Attribute(name, argumentList);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AttributeSyntax WithName(NameSyntax name)
    {
        return this.Update(name, this.ArgumentList);
    }

    public AttributeSyntax WithArgumentList(AttributeArgumentListSyntax argumentList)
    {
        return this.Update(this.Name, argumentList);
    }

    public AttributeSyntax AddArgumentListArguments(params AttributeArgumentSyntax[] items)
    {
        var argumentList = this.ArgumentList ?? SyntaxFactory.AttributeArgumentList();
        return this.WithArgumentList(argumentList.WithArguments(argumentList.Arguments.AddRange(items)));
    }
  }

  /// <summary>Attribute argument list syntax.</summary>
  public sealed partial class AttributeArgumentListSyntax : CSharpSyntaxNode
  {
    private SyntaxNode arguments;

    internal AttributeArgumentListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the open paren token.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AttributeArgumentListSyntax)this.Green).openParenToken, this.Position, 0); }
    }

    /// <summary>Gets the arguments syntax list.</summary>
    public SeparatedSyntaxList<AttributeArgumentSyntax> Arguments 
    {
        get
        {
            var red = this.GetRed(ref this.arguments, 1);
            if (red != null)
                return new SeparatedSyntaxList<AttributeArgumentSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<AttributeArgumentSyntax>);
        }
    }

    /// <summary>Gets the close paren token.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AttributeArgumentListSyntax)this.Green).closeParenToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.arguments, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.arguments;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAttributeArgumentList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAttributeArgumentList(this);
    }

    public AttributeArgumentListSyntax Update(SyntaxToken openParenToken, SeparatedSyntaxList<AttributeArgumentSyntax> arguments, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || arguments != this.Arguments || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.AttributeArgumentList(openParenToken, arguments, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AttributeArgumentListSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(openParenToken, this.Arguments, this.CloseParenToken);
    }

    public AttributeArgumentListSyntax WithArguments(SeparatedSyntaxList<AttributeArgumentSyntax> arguments)
    {
        return this.Update(this.OpenParenToken, arguments, this.CloseParenToken);
    }

    public AttributeArgumentListSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.OpenParenToken, this.Arguments, closeParenToken);
    }

    public AttributeArgumentListSyntax AddArguments(params AttributeArgumentSyntax[] items)
    {
        return this.WithArguments(this.Arguments.AddRange(items));
    }
  }

  /// <summary>Attribute argument syntax.</summary>
  public sealed partial class AttributeArgumentSyntax : CSharpSyntaxNode
  {
    private NameEqualsSyntax nameEquals;
    private NameColonSyntax nameColon;
    private ExpressionSyntax expression;

    internal AttributeArgumentSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public NameEqualsSyntax NameEquals 
    {
        get
        {
            return this.GetRedAtZero(ref this.nameEquals);
        }
    }

    public NameColonSyntax NameColon 
    {
        get
        {
            return this.GetRed(ref this.nameColon, 1);
        }
    }

    /// <summary>Gets the expression.</summary>
    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.nameEquals);
            case 1: return this.GetRed(ref this.nameColon, 1);
            case 2: return this.GetRed(ref this.expression, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.nameEquals;
            case 1: return this.nameColon;
            case 2: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAttributeArgument(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAttributeArgument(this);
    }

    public AttributeArgumentSyntax Update(NameEqualsSyntax nameEquals, NameColonSyntax nameColon, ExpressionSyntax expression)
    {
        if (nameEquals != this.NameEquals || nameColon != this.NameColon || expression != this.Expression)
        {
            var newNode = SyntaxFactory.AttributeArgument(nameEquals, nameColon, expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AttributeArgumentSyntax WithNameEquals(NameEqualsSyntax nameEquals)
    {
        return this.Update(nameEquals, this.NameColon, this.Expression);
    }

    public AttributeArgumentSyntax WithNameColon(NameColonSyntax nameColon)
    {
        return this.Update(this.NameEquals, nameColon, this.Expression);
    }

    public AttributeArgumentSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.NameEquals, this.NameColon, expression);
    }
  }

  /// <summary>Class representing an identifier name followed by an equals token.</summary>
  public sealed partial class NameEqualsSyntax : CSharpSyntaxNode
  {
    private IdentifierNameSyntax name;

    internal NameEqualsSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the identifier name.</summary>
    public IdentifierNameSyntax Name 
    {
        get
        {
            return this.GetRedAtZero(ref this.name);
        }
    }

    public SyntaxToken EqualsToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.NameEqualsSyntax)this.Green).equalsToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.name);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitNameEquals(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitNameEquals(this);
    }

    public NameEqualsSyntax Update(IdentifierNameSyntax name, SyntaxToken equalsToken)
    {
        if (name != this.Name || equalsToken != this.EqualsToken)
        {
            var newNode = SyntaxFactory.NameEquals(name, equalsToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public NameEqualsSyntax WithName(IdentifierNameSyntax name)
    {
        return this.Update(name, this.EqualsToken);
    }

    public NameEqualsSyntax WithEqualsToken(SyntaxToken equalsToken)
    {
        return this.Update(this.Name, equalsToken);
    }
  }

  /// <summary>Type parameter list syntax.</summary>
  public sealed partial class TypeParameterListSyntax : CSharpSyntaxNode
  {
    private SyntaxNode parameters;

    internal TypeParameterListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the &lt; token.</summary>
    public SyntaxToken LessThanToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TypeParameterListSyntax)this.Green).lessThanToken, this.Position, 0); }
    }

    /// <summary>Gets the parameter list.</summary>
    public SeparatedSyntaxList<TypeParameterSyntax> Parameters 
    {
        get
        {
            var red = this.GetRed(ref this.parameters, 1);
            if (red != null)
                return new SeparatedSyntaxList<TypeParameterSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<TypeParameterSyntax>);
        }
    }

    /// <summary>Gets the &gt; token.</summary>
    public SyntaxToken GreaterThanToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TypeParameterListSyntax)this.Green).greaterThanToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.parameters, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.parameters;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitTypeParameterList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitTypeParameterList(this);
    }

    public TypeParameterListSyntax Update(SyntaxToken lessThanToken, SeparatedSyntaxList<TypeParameterSyntax> parameters, SyntaxToken greaterThanToken)
    {
        if (lessThanToken != this.LessThanToken || parameters != this.Parameters || greaterThanToken != this.GreaterThanToken)
        {
            var newNode = SyntaxFactory.TypeParameterList(lessThanToken, parameters, greaterThanToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public TypeParameterListSyntax WithLessThanToken(SyntaxToken lessThanToken)
    {
        return this.Update(lessThanToken, this.Parameters, this.GreaterThanToken);
    }

    public TypeParameterListSyntax WithParameters(SeparatedSyntaxList<TypeParameterSyntax> parameters)
    {
        return this.Update(this.LessThanToken, parameters, this.GreaterThanToken);
    }

    public TypeParameterListSyntax WithGreaterThanToken(SyntaxToken greaterThanToken)
    {
        return this.Update(this.LessThanToken, this.Parameters, greaterThanToken);
    }

    public TypeParameterListSyntax AddParameters(params TypeParameterSyntax[] items)
    {
        return this.WithParameters(this.Parameters.AddRange(items));
    }
  }

  /// <summary>Type parameter syntax.</summary>
  public sealed partial class TypeParameterSyntax : CSharpSyntaxNode
  {
    private SyntaxNode attributeLists;

    internal TypeParameterSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public SyntaxToken VarianceKeyword 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TypeParameterSyntax)this.Green).varianceKeyword;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxToken);
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TypeParameterSyntax)this.Green).identifier, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitTypeParameter(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitTypeParameter(this);
    }

    public TypeParameterSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken varianceKeyword, SyntaxToken identifier)
    {
        if (attributeLists != this.AttributeLists || varianceKeyword != this.VarianceKeyword || identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.TypeParameter(attributeLists, varianceKeyword, identifier);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public TypeParameterSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.VarianceKeyword, this.Identifier);
    }

    public TypeParameterSyntax WithVarianceKeyword(SyntaxToken varianceKeyword)
    {
        return this.Update(this.AttributeLists, varianceKeyword, this.Identifier);
    }

    public TypeParameterSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.VarianceKeyword, identifier);
    }

    public TypeParameterSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }
  }

  /// <summary>Base class for type declaration syntax.</summary>
  public abstract partial class BaseTypeDeclarationSyntax : MemberDeclarationSyntax
  {
    internal BaseTypeDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public abstract SyntaxList<AttributeListSyntax> AttributeLists { get; }

    /// <summary>Gets the modifier list.</summary>
    public abstract SyntaxTokenList Modifiers { get; }

    /// <summary>Gets the identifier.</summary>
    public abstract SyntaxToken Identifier { get; }

    /// <summary>Gets the base type list.</summary>
    public abstract BaseListSyntax BaseList { get; }

    /// <summary>Gets the open brace token.</summary>
    public abstract SyntaxToken OpenBraceToken { get; }

    /// <summary>Gets the close brace token.</summary>
    public abstract SyntaxToken CloseBraceToken { get; }

    /// <summary>Gets the optional semicolon token.</summary>
    public abstract SyntaxToken SemicolonToken { get; }
  }

  /// <summary>Base class for type declaration syntax (class, struct, interface).</summary>
  public abstract partial class TypeDeclarationSyntax : BaseTypeDeclarationSyntax
  {
    internal TypeDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>Gets the type keyword token ("class", "struct", "interface").</summary>
    public abstract SyntaxToken Keyword { get; }

    public abstract TypeParameterListSyntax TypeParameterList { get; }

    /// <summary>Gets the type constraint list.</summary>
    public abstract SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses { get; }

    /// <summary>Gets the member declarations.</summary>
    public abstract SyntaxList<MemberDeclarationSyntax> Members { get; }
  }

  /// <summary>Class type declaration syntax.</summary>
  public sealed partial class ClassDeclarationSyntax : TypeDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private TypeParameterListSyntax typeParameterList;
    private BaseListSyntax baseList;
    private SyntaxNode constraintClauses;
    private SyntaxNode members;

    internal ClassDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>Gets the class keyword token.</summary>
    public override SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ClassDeclarationSyntax)this.Green).keyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ClassDeclarationSyntax)this.Green).identifier, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override TypeParameterListSyntax TypeParameterList 
    {
        get
        {
            return this.GetRed(ref this.typeParameterList, 4);
        }
    }

    public override BaseListSyntax BaseList 
    {
        get
        {
            return this.GetRed(ref this.baseList, 5);
        }
    }

    public override SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses 
    {
        get
        {
            return new SyntaxList<TypeParameterConstraintClauseSyntax>(this.GetRed(ref this.constraintClauses, 6));
        }
    }

    public override SyntaxToken OpenBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ClassDeclarationSyntax)this.Green).openBraceToken, this.GetChildPosition(7), this.GetChildIndex(7)); }
    }

    public override SyntaxList<MemberDeclarationSyntax> Members 
    {
        get
        {
            return new SyntaxList<MemberDeclarationSyntax>(this.GetRed(ref this.members, 8));
        }
    }

    public override SyntaxToken CloseBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ClassDeclarationSyntax)this.Green).closeBraceToken, this.GetChildPosition(9), this.GetChildIndex(9)); }
    }

    public override SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ClassDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(10), this.GetChildIndex(10));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 4: return this.GetRed(ref this.typeParameterList, 4);
            case 5: return this.GetRed(ref this.baseList, 5);
            case 6: return this.GetRed(ref this.constraintClauses, 6);
            case 8: return this.GetRed(ref this.members, 8);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 4: return this.typeParameterList;
            case 5: return this.baseList;
            case 6: return this.constraintClauses;
            case 8: return this.members;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitClassDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitClassDeclaration(this);
    }

    public ClassDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken openBraceToken, SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || identifier != this.Identifier || typeParameterList != this.TypeParameterList || baseList != this.BaseList || constraintClauses != this.ConstraintClauses || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ClassDeclaration(attributeLists, modifiers, keyword, identifier, typeParameterList, baseList, constraintClauses, openBraceToken, members, closeBraceToken, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ClassDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public ClassDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public ClassDeclarationSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public ClassDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public ClassDeclarationSyntax WithTypeParameterList(TypeParameterListSyntax typeParameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, typeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public ClassDeclarationSyntax WithBaseList(BaseListSyntax baseList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, baseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public ClassDeclarationSyntax WithConstraintClauses(SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, constraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public ClassDeclarationSyntax WithOpenBraceToken(SyntaxToken openBraceToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, openBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public ClassDeclarationSyntax WithMembers(SyntaxList<MemberDeclarationSyntax> members)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, members, this.CloseBraceToken, this.SemicolonToken);
    }

    public ClassDeclarationSyntax WithCloseBraceToken(SyntaxToken closeBraceToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, closeBraceToken, this.SemicolonToken);
    }

    public ClassDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, semicolonToken);
    }

    public ClassDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public ClassDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public ClassDeclarationSyntax AddTypeParameterListParameters(params TypeParameterSyntax[] items)
    {
        var typeParameterList = this.TypeParameterList ?? SyntaxFactory.TypeParameterList();
        return this.WithTypeParameterList(typeParameterList.WithParameters(typeParameterList.Parameters.AddRange(items)));
    }

    public ClassDeclarationSyntax AddBaseListTypes(params BaseTypeSyntax[] items)
    {
        var baseList = this.BaseList ?? SyntaxFactory.BaseList();
        return this.WithBaseList(baseList.WithTypes(baseList.Types.AddRange(items)));
    }

    public ClassDeclarationSyntax AddConstraintClauses(params TypeParameterConstraintClauseSyntax[] items)
    {
        return this.WithConstraintClauses(this.ConstraintClauses.AddRange(items));
    }

    public ClassDeclarationSyntax AddMembers(params MemberDeclarationSyntax[] items)
    {
        return this.WithMembers(this.Members.AddRange(items));
    }
  }

  /// <summary>Struct type declaration syntax.</summary>
  public sealed partial class StructDeclarationSyntax : TypeDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private TypeParameterListSyntax typeParameterList;
    private BaseListSyntax baseList;
    private SyntaxNode constraintClauses;
    private SyntaxNode members;

    internal StructDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>Gets the struct keyword token.</summary>
    public override SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.StructDeclarationSyntax)this.Green).keyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.StructDeclarationSyntax)this.Green).identifier, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override TypeParameterListSyntax TypeParameterList 
    {
        get
        {
            return this.GetRed(ref this.typeParameterList, 4);
        }
    }

    public override BaseListSyntax BaseList 
    {
        get
        {
            return this.GetRed(ref this.baseList, 5);
        }
    }

    public override SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses 
    {
        get
        {
            return new SyntaxList<TypeParameterConstraintClauseSyntax>(this.GetRed(ref this.constraintClauses, 6));
        }
    }

    public override SyntaxToken OpenBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.StructDeclarationSyntax)this.Green).openBraceToken, this.GetChildPosition(7), this.GetChildIndex(7)); }
    }

    public override SyntaxList<MemberDeclarationSyntax> Members 
    {
        get
        {
            return new SyntaxList<MemberDeclarationSyntax>(this.GetRed(ref this.members, 8));
        }
    }

    public override SyntaxToken CloseBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.StructDeclarationSyntax)this.Green).closeBraceToken, this.GetChildPosition(9), this.GetChildIndex(9)); }
    }

    public override SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.StructDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(10), this.GetChildIndex(10));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 4: return this.GetRed(ref this.typeParameterList, 4);
            case 5: return this.GetRed(ref this.baseList, 5);
            case 6: return this.GetRed(ref this.constraintClauses, 6);
            case 8: return this.GetRed(ref this.members, 8);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 4: return this.typeParameterList;
            case 5: return this.baseList;
            case 6: return this.constraintClauses;
            case 8: return this.members;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitStructDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitStructDeclaration(this);
    }

    public StructDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken openBraceToken, SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || identifier != this.Identifier || typeParameterList != this.TypeParameterList || baseList != this.BaseList || constraintClauses != this.ConstraintClauses || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.StructDeclaration(attributeLists, modifiers, keyword, identifier, typeParameterList, baseList, constraintClauses, openBraceToken, members, closeBraceToken, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public StructDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public StructDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public StructDeclarationSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public StructDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public StructDeclarationSyntax WithTypeParameterList(TypeParameterListSyntax typeParameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, typeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public StructDeclarationSyntax WithBaseList(BaseListSyntax baseList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, baseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public StructDeclarationSyntax WithConstraintClauses(SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, constraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public StructDeclarationSyntax WithOpenBraceToken(SyntaxToken openBraceToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, openBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public StructDeclarationSyntax WithMembers(SyntaxList<MemberDeclarationSyntax> members)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, members, this.CloseBraceToken, this.SemicolonToken);
    }

    public StructDeclarationSyntax WithCloseBraceToken(SyntaxToken closeBraceToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, closeBraceToken, this.SemicolonToken);
    }

    public StructDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, semicolonToken);
    }

    public StructDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public StructDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public StructDeclarationSyntax AddTypeParameterListParameters(params TypeParameterSyntax[] items)
    {
        var typeParameterList = this.TypeParameterList ?? SyntaxFactory.TypeParameterList();
        return this.WithTypeParameterList(typeParameterList.WithParameters(typeParameterList.Parameters.AddRange(items)));
    }

    public StructDeclarationSyntax AddBaseListTypes(params BaseTypeSyntax[] items)
    {
        var baseList = this.BaseList ?? SyntaxFactory.BaseList();
        return this.WithBaseList(baseList.WithTypes(baseList.Types.AddRange(items)));
    }

    public StructDeclarationSyntax AddConstraintClauses(params TypeParameterConstraintClauseSyntax[] items)
    {
        return this.WithConstraintClauses(this.ConstraintClauses.AddRange(items));
    }

    public StructDeclarationSyntax AddMembers(params MemberDeclarationSyntax[] items)
    {
        return this.WithMembers(this.Members.AddRange(items));
    }
  }

  /// <summary>Interface type declaration syntax.</summary>
  public sealed partial class InterfaceDeclarationSyntax : TypeDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private TypeParameterListSyntax typeParameterList;
    private BaseListSyntax baseList;
    private SyntaxNode constraintClauses;
    private SyntaxNode members;

    internal InterfaceDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>Gets the interface keyword token.</summary>
    public override SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterfaceDeclarationSyntax)this.Green).keyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterfaceDeclarationSyntax)this.Green).identifier, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override TypeParameterListSyntax TypeParameterList 
    {
        get
        {
            return this.GetRed(ref this.typeParameterList, 4);
        }
    }

    public override BaseListSyntax BaseList 
    {
        get
        {
            return this.GetRed(ref this.baseList, 5);
        }
    }

    public override SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses 
    {
        get
        {
            return new SyntaxList<TypeParameterConstraintClauseSyntax>(this.GetRed(ref this.constraintClauses, 6));
        }
    }

    public override SyntaxToken OpenBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterfaceDeclarationSyntax)this.Green).openBraceToken, this.GetChildPosition(7), this.GetChildIndex(7)); }
    }

    public override SyntaxList<MemberDeclarationSyntax> Members 
    {
        get
        {
            return new SyntaxList<MemberDeclarationSyntax>(this.GetRed(ref this.members, 8));
        }
    }

    public override SyntaxToken CloseBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterfaceDeclarationSyntax)this.Green).closeBraceToken, this.GetChildPosition(9), this.GetChildIndex(9)); }
    }

    public override SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.InterfaceDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(10), this.GetChildIndex(10));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 4: return this.GetRed(ref this.typeParameterList, 4);
            case 5: return this.GetRed(ref this.baseList, 5);
            case 6: return this.GetRed(ref this.constraintClauses, 6);
            case 8: return this.GetRed(ref this.members, 8);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 4: return this.typeParameterList;
            case 5: return this.baseList;
            case 6: return this.constraintClauses;
            case 8: return this.members;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitInterfaceDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitInterfaceDeclaration(this);
    }

    public InterfaceDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken openBraceToken, SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || identifier != this.Identifier || typeParameterList != this.TypeParameterList || baseList != this.BaseList || constraintClauses != this.ConstraintClauses || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.InterfaceDeclaration(attributeLists, modifiers, keyword, identifier, typeParameterList, baseList, constraintClauses, openBraceToken, members, closeBraceToken, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public InterfaceDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public InterfaceDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public InterfaceDeclarationSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public InterfaceDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public InterfaceDeclarationSyntax WithTypeParameterList(TypeParameterListSyntax typeParameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, typeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public InterfaceDeclarationSyntax WithBaseList(BaseListSyntax baseList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, baseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public InterfaceDeclarationSyntax WithConstraintClauses(SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, constraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public InterfaceDeclarationSyntax WithOpenBraceToken(SyntaxToken openBraceToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, openBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public InterfaceDeclarationSyntax WithMembers(SyntaxList<MemberDeclarationSyntax> members)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, members, this.CloseBraceToken, this.SemicolonToken);
    }

    public InterfaceDeclarationSyntax WithCloseBraceToken(SyntaxToken closeBraceToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, closeBraceToken, this.SemicolonToken);
    }

    public InterfaceDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Identifier, this.TypeParameterList, this.BaseList, this.ConstraintClauses, this.OpenBraceToken, this.Members, this.CloseBraceToken, semicolonToken);
    }

    public InterfaceDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public InterfaceDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public InterfaceDeclarationSyntax AddTypeParameterListParameters(params TypeParameterSyntax[] items)
    {
        var typeParameterList = this.TypeParameterList ?? SyntaxFactory.TypeParameterList();
        return this.WithTypeParameterList(typeParameterList.WithParameters(typeParameterList.Parameters.AddRange(items)));
    }

    public InterfaceDeclarationSyntax AddBaseListTypes(params BaseTypeSyntax[] items)
    {
        var baseList = this.BaseList ?? SyntaxFactory.BaseList();
        return this.WithBaseList(baseList.WithTypes(baseList.Types.AddRange(items)));
    }

    public InterfaceDeclarationSyntax AddConstraintClauses(params TypeParameterConstraintClauseSyntax[] items)
    {
        return this.WithConstraintClauses(this.ConstraintClauses.AddRange(items));
    }

    public InterfaceDeclarationSyntax AddMembers(params MemberDeclarationSyntax[] items)
    {
        return this.WithMembers(this.Members.AddRange(items));
    }
  }

  /// <summary>Enum type declaration syntax.</summary>
  public sealed partial class EnumDeclarationSyntax : BaseTypeDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private BaseListSyntax baseList;
    private SyntaxNode members;

    internal EnumDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>Gets the enum keyword token.</summary>
    public SyntaxToken EnumKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EnumDeclarationSyntax)this.Green).enumKeyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EnumDeclarationSyntax)this.Green).identifier, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override BaseListSyntax BaseList 
    {
        get
        {
            return this.GetRed(ref this.baseList, 4);
        }
    }

    public override SyntaxToken OpenBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EnumDeclarationSyntax)this.Green).openBraceToken, this.GetChildPosition(5), this.GetChildIndex(5)); }
    }

    /// <summary>Gets the members declaration list.</summary>
    public SeparatedSyntaxList<EnumMemberDeclarationSyntax> Members 
    {
        get
        {
            var red = this.GetRed(ref this.members, 6);
            if (red != null)
                return new SeparatedSyntaxList<EnumMemberDeclarationSyntax>(red, this.GetChildIndex(6));

            return default(SeparatedSyntaxList<EnumMemberDeclarationSyntax>);
        }
    }

    public override SyntaxToken CloseBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EnumDeclarationSyntax)this.Green).closeBraceToken, this.GetChildPosition(7), this.GetChildIndex(7)); }
    }

    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EnumDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(8), this.GetChildIndex(8));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 4: return this.GetRed(ref this.baseList, 4);
            case 6: return this.GetRed(ref this.members, 6);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 4: return this.baseList;
            case 6: return this.members;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitEnumDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitEnumDeclaration(this);
    }

    public EnumDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, SyntaxToken enumKeyword, SyntaxToken identifier, BaseListSyntax baseList, SyntaxToken openBraceToken, SeparatedSyntaxList<EnumMemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || enumKeyword != this.EnumKeyword || identifier != this.Identifier || baseList != this.BaseList || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.EnumDeclaration(attributeLists, modifiers, enumKeyword, identifier, baseList, openBraceToken, members, closeBraceToken, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public EnumDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.EnumKeyword, this.Identifier, this.BaseList, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public EnumDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.EnumKeyword, this.Identifier, this.BaseList, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public EnumDeclarationSyntax WithEnumKeyword(SyntaxToken enumKeyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, enumKeyword, this.Identifier, this.BaseList, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public EnumDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EnumKeyword, identifier, this.BaseList, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public EnumDeclarationSyntax WithBaseList(BaseListSyntax baseList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EnumKeyword, this.Identifier, baseList, this.OpenBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public EnumDeclarationSyntax WithOpenBraceToken(SyntaxToken openBraceToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EnumKeyword, this.Identifier, this.BaseList, openBraceToken, this.Members, this.CloseBraceToken, this.SemicolonToken);
    }

    public EnumDeclarationSyntax WithMembers(SeparatedSyntaxList<EnumMemberDeclarationSyntax> members)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EnumKeyword, this.Identifier, this.BaseList, this.OpenBraceToken, members, this.CloseBraceToken, this.SemicolonToken);
    }

    public EnumDeclarationSyntax WithCloseBraceToken(SyntaxToken closeBraceToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EnumKeyword, this.Identifier, this.BaseList, this.OpenBraceToken, this.Members, closeBraceToken, this.SemicolonToken);
    }

    public EnumDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EnumKeyword, this.Identifier, this.BaseList, this.OpenBraceToken, this.Members, this.CloseBraceToken, semicolonToken);
    }

    public EnumDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public EnumDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public EnumDeclarationSyntax AddBaseListTypes(params BaseTypeSyntax[] items)
    {
        var baseList = this.BaseList ?? SyntaxFactory.BaseList();
        return this.WithBaseList(baseList.WithTypes(baseList.Types.AddRange(items)));
    }

    public EnumDeclarationSyntax AddMembers(params EnumMemberDeclarationSyntax[] items)
    {
        return this.WithMembers(this.Members.AddRange(items));
    }
  }

  /// <summary>Delegate declaration syntax.</summary>
  public sealed partial class DelegateDeclarationSyntax : MemberDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private TypeSyntax returnType;
    private TypeParameterListSyntax typeParameterList;
    private ParameterListSyntax parameterList;
    private SyntaxNode constraintClauses;

    internal DelegateDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    /// <summary>Gets the modifier list.</summary>
    public SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>Gets the "delegate" keyword.</summary>
    public SyntaxToken DelegateKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DelegateDeclarationSyntax)this.Green).delegateKeyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    /// <summary>Gets the return type.</summary>
    public TypeSyntax ReturnType 
    {
        get
        {
            return this.GetRed(ref this.returnType, 3);
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DelegateDeclarationSyntax)this.Green).identifier, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    public TypeParameterListSyntax TypeParameterList 
    {
        get
        {
            return this.GetRed(ref this.typeParameterList, 5);
        }
    }

    /// <summary>Gets the parameter list.</summary>
    public ParameterListSyntax ParameterList 
    {
        get
        {
            return this.GetRed(ref this.parameterList, 6);
        }
    }

    /// <summary>Gets the constraint clause list.</summary>
    public SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses 
    {
        get
        {
            return new SyntaxList<TypeParameterConstraintClauseSyntax>(this.GetRed(ref this.constraintClauses, 7));
        }
    }

    /// <summary>Gets the semicolon token.</summary>
    public SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DelegateDeclarationSyntax)this.Green).semicolonToken, this.GetChildPosition(8), this.GetChildIndex(8)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 3: return this.GetRed(ref this.returnType, 3);
            case 5: return this.GetRed(ref this.typeParameterList, 5);
            case 6: return this.GetRed(ref this.parameterList, 6);
            case 7: return this.GetRed(ref this.constraintClauses, 7);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 3: return this.returnType;
            case 5: return this.typeParameterList;
            case 6: return this.parameterList;
            case 7: return this.constraintClauses;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitDelegateDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitDelegateDeclaration(this);
    }

    public DelegateDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, SyntaxToken delegateKeyword, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || delegateKeyword != this.DelegateKeyword || returnType != this.ReturnType || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || constraintClauses != this.ConstraintClauses || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.DelegateDeclaration(attributeLists, modifiers, delegateKeyword, returnType, identifier, typeParameterList, parameterList, constraintClauses, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public DelegateDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.DelegateKeyword, this.ReturnType, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.SemicolonToken);
    }

    public DelegateDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.DelegateKeyword, this.ReturnType, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.SemicolonToken);
    }

    public DelegateDeclarationSyntax WithDelegateKeyword(SyntaxToken delegateKeyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, delegateKeyword, this.ReturnType, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.SemicolonToken);
    }

    public DelegateDeclarationSyntax WithReturnType(TypeSyntax returnType)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.DelegateKeyword, returnType, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.SemicolonToken);
    }

    public DelegateDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.DelegateKeyword, this.ReturnType, identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.SemicolonToken);
    }

    public DelegateDeclarationSyntax WithTypeParameterList(TypeParameterListSyntax typeParameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.DelegateKeyword, this.ReturnType, this.Identifier, typeParameterList, this.ParameterList, this.ConstraintClauses, this.SemicolonToken);
    }

    public DelegateDeclarationSyntax WithParameterList(ParameterListSyntax parameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.DelegateKeyword, this.ReturnType, this.Identifier, this.TypeParameterList, parameterList, this.ConstraintClauses, this.SemicolonToken);
    }

    public DelegateDeclarationSyntax WithConstraintClauses(SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.DelegateKeyword, this.ReturnType, this.Identifier, this.TypeParameterList, this.ParameterList, constraintClauses, this.SemicolonToken);
    }

    public DelegateDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.DelegateKeyword, this.ReturnType, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, semicolonToken);
    }

    public DelegateDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public DelegateDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public DelegateDeclarationSyntax AddTypeParameterListParameters(params TypeParameterSyntax[] items)
    {
        var typeParameterList = this.TypeParameterList ?? SyntaxFactory.TypeParameterList();
        return this.WithTypeParameterList(typeParameterList.WithParameters(typeParameterList.Parameters.AddRange(items)));
    }

    public DelegateDeclarationSyntax AddParameterListParameters(params ParameterSyntax[] items)
    {
        return this.WithParameterList(this.ParameterList.WithParameters(this.ParameterList.Parameters.AddRange(items)));
    }

    public DelegateDeclarationSyntax AddConstraintClauses(params TypeParameterConstraintClauseSyntax[] items)
    {
        return this.WithConstraintClauses(this.ConstraintClauses.AddRange(items));
    }
  }

  public sealed partial class EnumMemberDeclarationSyntax : MemberDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private EqualsValueClauseSyntax equalsValue;

    internal EnumMemberDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EnumMemberDeclarationSyntax)this.Green).identifier, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public EqualsValueClauseSyntax EqualsValue 
    {
        get
        {
            return this.GetRed(ref this.equalsValue, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 2: return this.GetRed(ref this.equalsValue, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 2: return this.equalsValue;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitEnumMemberDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitEnumMemberDeclaration(this);
    }

    public EnumMemberDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken identifier, EqualsValueClauseSyntax equalsValue)
    {
        if (attributeLists != this.AttributeLists || identifier != this.Identifier || equalsValue != this.EqualsValue)
        {
            var newNode = SyntaxFactory.EnumMemberDeclaration(attributeLists, identifier, equalsValue);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public EnumMemberDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Identifier, this.EqualsValue);
    }

    public EnumMemberDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, identifier, this.EqualsValue);
    }

    public EnumMemberDeclarationSyntax WithEqualsValue(EqualsValueClauseSyntax equalsValue)
    {
        return this.Update(this.AttributeLists, this.Identifier, equalsValue);
    }

    public EnumMemberDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }
  }

  /// <summary>Base list syntax.</summary>
  public sealed partial class BaseListSyntax : CSharpSyntaxNode
  {
    private SyntaxNode types;

    internal BaseListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BaseListSyntax)this.Green).colonToken, this.Position, 0); }
    }

    /// <summary>Gets the base type references.</summary>
    public SeparatedSyntaxList<BaseTypeSyntax> Types 
    {
        get
        {
            var red = this.GetRed(ref this.types, 1);
            if (red != null)
                return new SeparatedSyntaxList<BaseTypeSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<BaseTypeSyntax>);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.types, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.types;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitBaseList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitBaseList(this);
    }

    public BaseListSyntax Update(SyntaxToken colonToken, SeparatedSyntaxList<BaseTypeSyntax> types)
    {
        if (colonToken != this.ColonToken || types != this.Types)
        {
            var newNode = SyntaxFactory.BaseList(colonToken, types);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public BaseListSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(colonToken, this.Types);
    }

    public BaseListSyntax WithTypes(SeparatedSyntaxList<BaseTypeSyntax> types)
    {
        return this.Update(this.ColonToken, types);
    }

    public BaseListSyntax AddTypes(params BaseTypeSyntax[] items)
    {
        return this.WithTypes(this.Types.AddRange(items));
    }
  }

  /// <summary>Provides the base class from which the classes that represent base type syntax nodes are derived. This is an abstract class.</summary>
  public abstract partial class BaseTypeSyntax : CSharpSyntaxNode
  {
    internal BaseTypeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    public abstract TypeSyntax Type { get; }
  }

  public sealed partial class SimpleBaseTypeSyntax : BaseTypeSyntax
  {
    private TypeSyntax type;

    internal SimpleBaseTypeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override TypeSyntax Type 
    {
        get
        {
            return this.GetRedAtZero(ref this.type);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.type);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitSimpleBaseType(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitSimpleBaseType(this);
    }

    public SimpleBaseTypeSyntax Update(TypeSyntax type)
    {
        if (type != this.Type)
        {
            var newNode = SyntaxFactory.SimpleBaseType(type);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public SimpleBaseTypeSyntax WithType(TypeSyntax type)
    {
        return this.Update(type);
    }
  }

  /// <summary>Type parameter constraint clause.</summary>
  public sealed partial class TypeParameterConstraintClauseSyntax : CSharpSyntaxNode
  {
    private IdentifierNameSyntax name;
    private SyntaxNode constraints;

    internal TypeParameterConstraintClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken WhereKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TypeParameterConstraintClauseSyntax)this.Green).whereKeyword, this.Position, 0); }
    }

    /// <summary>Gets the identifier.</summary>
    public IdentifierNameSyntax Name 
    {
        get
        {
            return this.GetRed(ref this.name, 1);
        }
    }

    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.TypeParameterConstraintClauseSyntax)this.Green).colonToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    /// <summary>Gets the constraints list.</summary>
    public SeparatedSyntaxList<TypeParameterConstraintSyntax> Constraints 
    {
        get
        {
            var red = this.GetRed(ref this.constraints, 3);
            if (red != null)
                return new SeparatedSyntaxList<TypeParameterConstraintSyntax>(red, this.GetChildIndex(3));

            return default(SeparatedSyntaxList<TypeParameterConstraintSyntax>);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.name, 1);
            case 3: return this.GetRed(ref this.constraints, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.name;
            case 3: return this.constraints;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitTypeParameterConstraintClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitTypeParameterConstraintClause(this);
    }

    public TypeParameterConstraintClauseSyntax Update(SyntaxToken whereKeyword, IdentifierNameSyntax name, SyntaxToken colonToken, SeparatedSyntaxList<TypeParameterConstraintSyntax> constraints)
    {
        if (whereKeyword != this.WhereKeyword || name != this.Name || colonToken != this.ColonToken || constraints != this.Constraints)
        {
            var newNode = SyntaxFactory.TypeParameterConstraintClause(whereKeyword, name, colonToken, constraints);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public TypeParameterConstraintClauseSyntax WithWhereKeyword(SyntaxToken whereKeyword)
    {
        return this.Update(whereKeyword, this.Name, this.ColonToken, this.Constraints);
    }

    public TypeParameterConstraintClauseSyntax WithName(IdentifierNameSyntax name)
    {
        return this.Update(this.WhereKeyword, name, this.ColonToken, this.Constraints);
    }

    public TypeParameterConstraintClauseSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(this.WhereKeyword, this.Name, colonToken, this.Constraints);
    }

    public TypeParameterConstraintClauseSyntax WithConstraints(SeparatedSyntaxList<TypeParameterConstraintSyntax> constraints)
    {
        return this.Update(this.WhereKeyword, this.Name, this.ColonToken, constraints);
    }

    public TypeParameterConstraintClauseSyntax AddConstraints(params TypeParameterConstraintSyntax[] items)
    {
        return this.WithConstraints(this.Constraints.AddRange(items));
    }
  }

  /// <summary>Base type for type parameter constraint syntax.</summary>
  public abstract partial class TypeParameterConstraintSyntax : CSharpSyntaxNode
  {
    internal TypeParameterConstraintSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  /// <summary>Constructor constraint syntax.</summary>
  public sealed partial class ConstructorConstraintSyntax : TypeParameterConstraintSyntax
  {
    internal ConstructorConstraintSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the "new" keyword.</summary>
    public SyntaxToken NewKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConstructorConstraintSyntax)this.Green).newKeyword, this.Position, 0); }
    }

    /// <summary>Gets the open paren keyword.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConstructorConstraintSyntax)this.Green).openParenToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    /// <summary>Gets the close paren keyword.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConstructorConstraintSyntax)this.Green).closeParenToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitConstructorConstraint(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitConstructorConstraint(this);
    }

    public ConstructorConstraintSyntax Update(SyntaxToken newKeyword, SyntaxToken openParenToken, SyntaxToken closeParenToken)
    {
        if (newKeyword != this.NewKeyword || openParenToken != this.OpenParenToken || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ConstructorConstraint(newKeyword, openParenToken, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ConstructorConstraintSyntax WithNewKeyword(SyntaxToken newKeyword)
    {
        return this.Update(newKeyword, this.OpenParenToken, this.CloseParenToken);
    }

    public ConstructorConstraintSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(this.NewKeyword, openParenToken, this.CloseParenToken);
    }

    public ConstructorConstraintSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.NewKeyword, this.OpenParenToken, closeParenToken);
    }
  }

  /// <summary>Base type for class or struct constraint syntax.</summary>
  public sealed partial class ClassOrStructConstraintSyntax : TypeParameterConstraintSyntax
  {
    internal ClassOrStructConstraintSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the constraint keyword ("class" or "struct").</summary>
    public SyntaxToken ClassOrStructKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ClassOrStructConstraintSyntax)this.Green).classOrStructKeyword, this.Position, 0); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitClassOrStructConstraint(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitClassOrStructConstraint(this);
    }

    public ClassOrStructConstraintSyntax Update(SyntaxToken classOrStructKeyword)
    {
        if (classOrStructKeyword != this.ClassOrStructKeyword)
        {
            var newNode = SyntaxFactory.ClassOrStructConstraint(this.Kind(), classOrStructKeyword);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ClassOrStructConstraintSyntax WithClassOrStructKeyword(SyntaxToken classOrStructKeyword)
    {
        return this.Update(classOrStructKeyword);
    }
  }

  /// <summary>Type constraint syntax.</summary>
  public sealed partial class TypeConstraintSyntax : TypeParameterConstraintSyntax
  {
    private TypeSyntax type;

    internal TypeConstraintSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the type syntax.</summary>
    public TypeSyntax Type 
    {
        get
        {
            return this.GetRedAtZero(ref this.type);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.type);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitTypeConstraint(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitTypeConstraint(this);
    }

    public TypeConstraintSyntax Update(TypeSyntax type)
    {
        if (type != this.Type)
        {
            var newNode = SyntaxFactory.TypeConstraint(type);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public TypeConstraintSyntax WithType(TypeSyntax type)
    {
        return this.Update(type);
    }
  }

  public abstract partial class BaseFieldDeclarationSyntax : MemberDeclarationSyntax
  {
    internal BaseFieldDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public abstract SyntaxList<AttributeListSyntax> AttributeLists { get; }

    /// <summary>Gets the modifier list.</summary>
    public abstract SyntaxTokenList Modifiers { get; }

    public abstract VariableDeclarationSyntax Declaration { get; }

    public abstract SyntaxToken SemicolonToken { get; }
  }

  public sealed partial class FieldDeclarationSyntax : BaseFieldDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private VariableDeclarationSyntax declaration;

    internal FieldDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    /// <summary>Gets the modifier list.</summary>
    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    public override VariableDeclarationSyntax Declaration 
    {
        get
        {
            return this.GetRed(ref this.declaration, 2);
        }
    }

    public override SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.FieldDeclarationSyntax)this.Green).semicolonToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 2: return this.GetRed(ref this.declaration, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 2: return this.declaration;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitFieldDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitFieldDeclaration(this);
    }

    public FieldDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || declaration != this.Declaration || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.FieldDeclaration(attributeLists, modifiers, declaration, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public FieldDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.Declaration, this.SemicolonToken);
    }

    public FieldDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.Declaration, this.SemicolonToken);
    }

    public FieldDeclarationSyntax WithDeclaration(VariableDeclarationSyntax declaration)
    {
        return this.Update(this.AttributeLists, this.Modifiers, declaration, this.SemicolonToken);
    }

    public FieldDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Declaration, semicolonToken);
    }

    public FieldDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public FieldDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public FieldDeclarationSyntax AddDeclarationVariables(params VariableDeclaratorSyntax[] items)
    {
        return this.WithDeclaration(this.Declaration.WithVariables(this.Declaration.Variables.AddRange(items)));
    }
  }

  public sealed partial class EventFieldDeclarationSyntax : BaseFieldDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private VariableDeclarationSyntax declaration;

    internal EventFieldDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    /// <summary>Gets the modifier list.</summary>
    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    public SyntaxToken EventKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EventFieldDeclarationSyntax)this.Green).eventKeyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override VariableDeclarationSyntax Declaration 
    {
        get
        {
            return this.GetRed(ref this.declaration, 3);
        }
    }

    public override SyntaxToken SemicolonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EventFieldDeclarationSyntax)this.Green).semicolonToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 3: return this.GetRed(ref this.declaration, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 3: return this.declaration;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitEventFieldDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitEventFieldDeclaration(this);
    }

    public EventFieldDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, SyntaxToken eventKeyword, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || eventKeyword != this.EventKeyword || declaration != this.Declaration || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.EventFieldDeclaration(attributeLists, modifiers, eventKeyword, declaration, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public EventFieldDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.EventKeyword, this.Declaration, this.SemicolonToken);
    }

    public EventFieldDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.EventKeyword, this.Declaration, this.SemicolonToken);
    }

    public EventFieldDeclarationSyntax WithEventKeyword(SyntaxToken eventKeyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, eventKeyword, this.Declaration, this.SemicolonToken);
    }

    public EventFieldDeclarationSyntax WithDeclaration(VariableDeclarationSyntax declaration)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EventKeyword, declaration, this.SemicolonToken);
    }

    public EventFieldDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EventKeyword, this.Declaration, semicolonToken);
    }

    public EventFieldDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public EventFieldDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public EventFieldDeclarationSyntax AddDeclarationVariables(params VariableDeclaratorSyntax[] items)
    {
        return this.WithDeclaration(this.Declaration.WithVariables(this.Declaration.Variables.AddRange(items)));
    }
  }

  public sealed partial class ExplicitInterfaceSpecifierSyntax : CSharpSyntaxNode
  {
    private NameSyntax name;

    internal ExplicitInterfaceSpecifierSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public NameSyntax Name 
    {
        get
        {
            return this.GetRedAtZero(ref this.name);
        }
    }

    public SyntaxToken DotToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ExplicitInterfaceSpecifierSyntax)this.Green).dotToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.name);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitExplicitInterfaceSpecifier(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitExplicitInterfaceSpecifier(this);
    }

    public ExplicitInterfaceSpecifierSyntax Update(NameSyntax name, SyntaxToken dotToken)
    {
        if (name != this.Name || dotToken != this.DotToken)
        {
            var newNode = SyntaxFactory.ExplicitInterfaceSpecifier(name, dotToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ExplicitInterfaceSpecifierSyntax WithName(NameSyntax name)
    {
        return this.Update(name, this.DotToken);
    }

    public ExplicitInterfaceSpecifierSyntax WithDotToken(SyntaxToken dotToken)
    {
        return this.Update(this.Name, dotToken);
    }
  }

  /// <summary>Base type for method declaration syntax.</summary>
  public abstract partial class BaseMethodDeclarationSyntax : MemberDeclarationSyntax
  {
    internal BaseMethodDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public abstract SyntaxList<AttributeListSyntax> AttributeLists { get; }

    /// <summary>Gets the modifier list.</summary>
    public abstract SyntaxTokenList Modifiers { get; }

    /// <summary>Gets the parameter list.</summary>
    public abstract ParameterListSyntax ParameterList { get; }

    public abstract BlockSyntax Body { get; }

    public abstract ArrowExpressionClauseSyntax ExpressionBody { get; }

    /// <summary>Gets the optional semicolon token.</summary>
    public abstract SyntaxToken SemicolonToken { get; }
  }

  /// <summary>Method declaration syntax.</summary>
  public sealed partial class MethodDeclarationSyntax : BaseMethodDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private TypeSyntax returnType;
    private ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier;
    private TypeParameterListSyntax typeParameterList;
    private ParameterListSyntax parameterList;
    private SyntaxNode constraintClauses;
    private BlockSyntax body;
    private ArrowExpressionClauseSyntax expressionBody;

    internal MethodDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>Gets the return type syntax.</summary>
    public TypeSyntax ReturnType 
    {
        get
        {
            return this.GetRed(ref this.returnType, 2);
        }
    }

    public ExplicitInterfaceSpecifierSyntax ExplicitInterfaceSpecifier 
    {
        get
        {
            return this.GetRed(ref this.explicitInterfaceSpecifier, 3);
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.MethodDeclarationSyntax)this.Green).identifier, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    public TypeParameterListSyntax TypeParameterList 
    {
        get
        {
            return this.GetRed(ref this.typeParameterList, 5);
        }
    }

    public override ParameterListSyntax ParameterList 
    {
        get
        {
            return this.GetRed(ref this.parameterList, 6);
        }
    }

    /// <summary>Gets the constraint clause list.</summary>
    public SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses 
    {
        get
        {
            return new SyntaxList<TypeParameterConstraintClauseSyntax>(this.GetRed(ref this.constraintClauses, 7));
        }
    }

    public override BlockSyntax Body 
    {
        get
        {
            return this.GetRed(ref this.body, 8);
        }
    }

    public override ArrowExpressionClauseSyntax ExpressionBody 
    {
        get
        {
            return this.GetRed(ref this.expressionBody, 9);
        }
    }

    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.MethodDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(10), this.GetChildIndex(10));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 2: return this.GetRed(ref this.returnType, 2);
            case 3: return this.GetRed(ref this.explicitInterfaceSpecifier, 3);
            case 5: return this.GetRed(ref this.typeParameterList, 5);
            case 6: return this.GetRed(ref this.parameterList, 6);
            case 7: return this.GetRed(ref this.constraintClauses, 7);
            case 8: return this.GetRed(ref this.body, 8);
            case 9: return this.GetRed(ref this.expressionBody, 9);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 2: return this.returnType;
            case 3: return this.explicitInterfaceSpecifier;
            case 5: return this.typeParameterList;
            case 6: return this.parameterList;
            case 7: return this.constraintClauses;
            case 8: return this.body;
            case 9: return this.expressionBody;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMethodDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitMethodDeclaration(this);
    }

    public MethodDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || returnType != this.ReturnType || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || constraintClauses != this.ConstraintClauses || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.MethodDeclaration(attributeLists, modifiers, returnType, explicitInterfaceSpecifier, identifier, typeParameterList, parameterList, constraintClauses, body, expressionBody, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MethodDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.ReturnType, this.ExplicitInterfaceSpecifier, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public MethodDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.ReturnType, this.ExplicitInterfaceSpecifier, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public MethodDeclarationSyntax WithReturnType(TypeSyntax returnType)
    {
        return this.Update(this.AttributeLists, this.Modifiers, returnType, this.ExplicitInterfaceSpecifier, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public MethodDeclarationSyntax WithExplicitInterfaceSpecifier(ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, explicitInterfaceSpecifier, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public MethodDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.ExplicitInterfaceSpecifier, identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public MethodDeclarationSyntax WithTypeParameterList(TypeParameterListSyntax typeParameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.ExplicitInterfaceSpecifier, this.Identifier, typeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public MethodDeclarationSyntax WithParameterList(ParameterListSyntax parameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.ExplicitInterfaceSpecifier, this.Identifier, this.TypeParameterList, parameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public MethodDeclarationSyntax WithConstraintClauses(SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.ExplicitInterfaceSpecifier, this.Identifier, this.TypeParameterList, this.ParameterList, constraintClauses, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public MethodDeclarationSyntax WithBody(BlockSyntax body)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.ExplicitInterfaceSpecifier, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, body, this.ExpressionBody, this.SemicolonToken);
    }

    public MethodDeclarationSyntax WithExpressionBody(ArrowExpressionClauseSyntax expressionBody)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.ExplicitInterfaceSpecifier, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, expressionBody, this.SemicolonToken);
    }

    public MethodDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.ExplicitInterfaceSpecifier, this.Identifier, this.TypeParameterList, this.ParameterList, this.ConstraintClauses, this.Body, this.ExpressionBody, semicolonToken);
    }

    public MethodDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public MethodDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public MethodDeclarationSyntax AddTypeParameterListParameters(params TypeParameterSyntax[] items)
    {
        var typeParameterList = this.TypeParameterList ?? SyntaxFactory.TypeParameterList();
        return this.WithTypeParameterList(typeParameterList.WithParameters(typeParameterList.Parameters.AddRange(items)));
    }

    public MethodDeclarationSyntax AddParameterListParameters(params ParameterSyntax[] items)
    {
        return this.WithParameterList(this.ParameterList.WithParameters(this.ParameterList.Parameters.AddRange(items)));
    }

    public MethodDeclarationSyntax AddConstraintClauses(params TypeParameterConstraintClauseSyntax[] items)
    {
        return this.WithConstraintClauses(this.ConstraintClauses.AddRange(items));
    }

    public MethodDeclarationSyntax AddBodyStatements(params StatementSyntax[] items)
    {
        var body = this.Body ?? SyntaxFactory.Block();
        return this.WithBody(body.WithStatements(body.Statements.AddRange(items)));
    }
  }

  /// <summary>Operator declaration syntax.</summary>
  public sealed partial class OperatorDeclarationSyntax : BaseMethodDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private TypeSyntax returnType;
    private ParameterListSyntax parameterList;
    private BlockSyntax body;
    private ArrowExpressionClauseSyntax expressionBody;

    internal OperatorDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>Gets the return type.</summary>
    public TypeSyntax ReturnType 
    {
        get
        {
            return this.GetRed(ref this.returnType, 2);
        }
    }

    /// <summary>Gets the "operator" keyword.</summary>
    public SyntaxToken OperatorKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.OperatorDeclarationSyntax)this.Green).operatorKeyword, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    /// <summary>Gets the operator token.</summary>
    public SyntaxToken OperatorToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.OperatorDeclarationSyntax)this.Green).operatorToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    public override ParameterListSyntax ParameterList 
    {
        get
        {
            return this.GetRed(ref this.parameterList, 5);
        }
    }

    public override BlockSyntax Body 
    {
        get
        {
            return this.GetRed(ref this.body, 6);
        }
    }

    public override ArrowExpressionClauseSyntax ExpressionBody 
    {
        get
        {
            return this.GetRed(ref this.expressionBody, 7);
        }
    }

    public override SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.OperatorDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(8), this.GetChildIndex(8));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 2: return this.GetRed(ref this.returnType, 2);
            case 5: return this.GetRed(ref this.parameterList, 5);
            case 6: return this.GetRed(ref this.body, 6);
            case 7: return this.GetRed(ref this.expressionBody, 7);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 2: return this.returnType;
            case 5: return this.parameterList;
            case 6: return this.body;
            case 7: return this.expressionBody;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitOperatorDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitOperatorDeclaration(this);
    }

    public OperatorDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, TypeSyntax returnType, SyntaxToken operatorKeyword, SyntaxToken operatorToken, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || returnType != this.ReturnType || operatorKeyword != this.OperatorKeyword || operatorToken != this.OperatorToken || parameterList != this.ParameterList || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.OperatorDeclaration(attributeLists, modifiers, returnType, operatorKeyword, operatorToken, parameterList, body, expressionBody, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public OperatorDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.ReturnType, this.OperatorKeyword, this.OperatorToken, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public OperatorDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.ReturnType, this.OperatorKeyword, this.OperatorToken, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public OperatorDeclarationSyntax WithReturnType(TypeSyntax returnType)
    {
        return this.Update(this.AttributeLists, this.Modifiers, returnType, this.OperatorKeyword, this.OperatorToken, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public OperatorDeclarationSyntax WithOperatorKeyword(SyntaxToken operatorKeyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, operatorKeyword, this.OperatorToken, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public OperatorDeclarationSyntax WithOperatorToken(SyntaxToken operatorToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.OperatorKeyword, operatorToken, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public OperatorDeclarationSyntax WithParameterList(ParameterListSyntax parameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.OperatorKeyword, this.OperatorToken, parameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public OperatorDeclarationSyntax WithBody(BlockSyntax body)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.OperatorKeyword, this.OperatorToken, this.ParameterList, body, this.ExpressionBody, this.SemicolonToken);
    }

    public OperatorDeclarationSyntax WithExpressionBody(ArrowExpressionClauseSyntax expressionBody)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.OperatorKeyword, this.OperatorToken, this.ParameterList, this.Body, expressionBody, this.SemicolonToken);
    }

    public OperatorDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ReturnType, this.OperatorKeyword, this.OperatorToken, this.ParameterList, this.Body, this.ExpressionBody, semicolonToken);
    }

    public OperatorDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public OperatorDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public OperatorDeclarationSyntax AddParameterListParameters(params ParameterSyntax[] items)
    {
        return this.WithParameterList(this.ParameterList.WithParameters(this.ParameterList.Parameters.AddRange(items)));
    }

    public OperatorDeclarationSyntax AddBodyStatements(params StatementSyntax[] items)
    {
        var body = this.Body ?? SyntaxFactory.Block();
        return this.WithBody(body.WithStatements(body.Statements.AddRange(items)));
    }
  }

  /// <summary>Conversion operator declaration syntax.</summary>
  public sealed partial class ConversionOperatorDeclarationSyntax : BaseMethodDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private TypeSyntax type;
    private ParameterListSyntax parameterList;
    private BlockSyntax body;
    private ArrowExpressionClauseSyntax expressionBody;

    internal ConversionOperatorDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>Gets the "implicit" or "explicit" token.</summary>
    public SyntaxToken ImplicitOrExplicitKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConversionOperatorDeclarationSyntax)this.Green).implicitOrExplicitKeyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    /// <summary>Gets the "operator" token.</summary>
    public SyntaxToken OperatorKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConversionOperatorDeclarationSyntax)this.Green).operatorKeyword, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    /// <summary>Gets the type.</summary>
    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 4);
        }
    }

    public override ParameterListSyntax ParameterList 
    {
        get
        {
            return this.GetRed(ref this.parameterList, 5);
        }
    }

    public override BlockSyntax Body 
    {
        get
        {
            return this.GetRed(ref this.body, 6);
        }
    }

    public override ArrowExpressionClauseSyntax ExpressionBody 
    {
        get
        {
            return this.GetRed(ref this.expressionBody, 7);
        }
    }

    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConversionOperatorDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(8), this.GetChildIndex(8));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 4: return this.GetRed(ref this.type, 4);
            case 5: return this.GetRed(ref this.parameterList, 5);
            case 6: return this.GetRed(ref this.body, 6);
            case 7: return this.GetRed(ref this.expressionBody, 7);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 4: return this.type;
            case 5: return this.parameterList;
            case 6: return this.body;
            case 7: return this.expressionBody;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitConversionOperatorDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitConversionOperatorDeclaration(this);
    }

    public ConversionOperatorDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, SyntaxToken implicitOrExplicitKeyword, SyntaxToken operatorKeyword, TypeSyntax type, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || implicitOrExplicitKeyword != this.ImplicitOrExplicitKeyword || operatorKeyword != this.OperatorKeyword || type != this.Type || parameterList != this.ParameterList || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ConversionOperatorDeclaration(attributeLists, modifiers, implicitOrExplicitKeyword, operatorKeyword, type, parameterList, body, expressionBody, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ConversionOperatorDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.ImplicitOrExplicitKeyword, this.OperatorKeyword, this.Type, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConversionOperatorDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.ImplicitOrExplicitKeyword, this.OperatorKeyword, this.Type, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConversionOperatorDeclarationSyntax WithImplicitOrExplicitKeyword(SyntaxToken implicitOrExplicitKeyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, implicitOrExplicitKeyword, this.OperatorKeyword, this.Type, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConversionOperatorDeclarationSyntax WithOperatorKeyword(SyntaxToken operatorKeyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ImplicitOrExplicitKeyword, operatorKeyword, this.Type, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConversionOperatorDeclarationSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ImplicitOrExplicitKeyword, this.OperatorKeyword, type, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConversionOperatorDeclarationSyntax WithParameterList(ParameterListSyntax parameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ImplicitOrExplicitKeyword, this.OperatorKeyword, this.Type, parameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConversionOperatorDeclarationSyntax WithBody(BlockSyntax body)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ImplicitOrExplicitKeyword, this.OperatorKeyword, this.Type, this.ParameterList, body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConversionOperatorDeclarationSyntax WithExpressionBody(ArrowExpressionClauseSyntax expressionBody)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ImplicitOrExplicitKeyword, this.OperatorKeyword, this.Type, this.ParameterList, this.Body, expressionBody, this.SemicolonToken);
    }

    public ConversionOperatorDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.ImplicitOrExplicitKeyword, this.OperatorKeyword, this.Type, this.ParameterList, this.Body, this.ExpressionBody, semicolonToken);
    }

    public ConversionOperatorDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public ConversionOperatorDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public ConversionOperatorDeclarationSyntax AddParameterListParameters(params ParameterSyntax[] items)
    {
        return this.WithParameterList(this.ParameterList.WithParameters(this.ParameterList.Parameters.AddRange(items)));
    }

    public ConversionOperatorDeclarationSyntax AddBodyStatements(params StatementSyntax[] items)
    {
        var body = this.Body ?? SyntaxFactory.Block();
        return this.WithBody(body.WithStatements(body.Statements.AddRange(items)));
    }
  }

  /// <summary>Constructor declaration syntax.</summary>
  public sealed partial class ConstructorDeclarationSyntax : BaseMethodDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private ParameterListSyntax parameterList;
    private ConstructorInitializerSyntax initializer;
    private BlockSyntax body;
    private ArrowExpressionClauseSyntax expressionBody;

    internal ConstructorDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConstructorDeclarationSyntax)this.Green).identifier, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override ParameterListSyntax ParameterList 
    {
        get
        {
            return this.GetRed(ref this.parameterList, 3);
        }
    }

    public ConstructorInitializerSyntax Initializer 
    {
        get
        {
            return this.GetRed(ref this.initializer, 4);
        }
    }

    public override BlockSyntax Body 
    {
        get
        {
            return this.GetRed(ref this.body, 5);
        }
    }

    public override ArrowExpressionClauseSyntax ExpressionBody 
    {
        get
        {
            return this.GetRed(ref this.expressionBody, 6);
        }
    }

    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConstructorDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(7), this.GetChildIndex(7));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 3: return this.GetRed(ref this.parameterList, 3);
            case 4: return this.GetRed(ref this.initializer, 4);
            case 5: return this.GetRed(ref this.body, 5);
            case 6: return this.GetRed(ref this.expressionBody, 6);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 3: return this.parameterList;
            case 4: return this.initializer;
            case 5: return this.body;
            case 6: return this.expressionBody;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitConstructorDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitConstructorDeclaration(this);
    }

    public ConstructorDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, SyntaxToken identifier, ParameterListSyntax parameterList, ConstructorInitializerSyntax initializer, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || identifier != this.Identifier || parameterList != this.ParameterList || initializer != this.Initializer || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ConstructorDeclaration(attributeLists, modifiers, identifier, parameterList, initializer, body, expressionBody, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ConstructorDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.Identifier, this.ParameterList, this.Initializer, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConstructorDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.Identifier, this.ParameterList, this.Initializer, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConstructorDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, identifier, this.ParameterList, this.Initializer, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConstructorDeclarationSyntax WithParameterList(ParameterListSyntax parameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Identifier, parameterList, this.Initializer, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConstructorDeclarationSyntax WithInitializer(ConstructorInitializerSyntax initializer)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Identifier, this.ParameterList, initializer, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConstructorDeclarationSyntax WithBody(BlockSyntax body)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Identifier, this.ParameterList, this.Initializer, body, this.ExpressionBody, this.SemicolonToken);
    }

    public ConstructorDeclarationSyntax WithExpressionBody(ArrowExpressionClauseSyntax expressionBody)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Identifier, this.ParameterList, this.Initializer, this.Body, expressionBody, this.SemicolonToken);
    }

    public ConstructorDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Identifier, this.ParameterList, this.Initializer, this.Body, this.ExpressionBody, semicolonToken);
    }

    public ConstructorDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public ConstructorDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public ConstructorDeclarationSyntax AddParameterListParameters(params ParameterSyntax[] items)
    {
        return this.WithParameterList(this.ParameterList.WithParameters(this.ParameterList.Parameters.AddRange(items)));
    }

    public ConstructorDeclarationSyntax AddBodyStatements(params StatementSyntax[] items)
    {
        var body = this.Body ?? SyntaxFactory.Block();
        return this.WithBody(body.WithStatements(body.Statements.AddRange(items)));
    }
  }

  /// <summary>Constructor initializer syntax.</summary>
  public sealed partial class ConstructorInitializerSyntax : CSharpSyntaxNode
  {
    private ArgumentListSyntax argumentList;

    internal ConstructorInitializerSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConstructorInitializerSyntax)this.Green).colonToken, this.Position, 0); }
    }

    /// <summary>Gets the "this" or "base" keyword.</summary>
    public SyntaxToken ThisOrBaseKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConstructorInitializerSyntax)this.Green).thisOrBaseKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public ArgumentListSyntax ArgumentList 
    {
        get
        {
            return this.GetRed(ref this.argumentList, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.argumentList, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.argumentList;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitConstructorInitializer(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitConstructorInitializer(this);
    }

    public ConstructorInitializerSyntax Update(SyntaxToken colonToken, SyntaxToken thisOrBaseKeyword, ArgumentListSyntax argumentList)
    {
        if (colonToken != this.ColonToken || thisOrBaseKeyword != this.ThisOrBaseKeyword || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ConstructorInitializer(this.Kind(), colonToken, thisOrBaseKeyword, argumentList);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ConstructorInitializerSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(colonToken, this.ThisOrBaseKeyword, this.ArgumentList);
    }

    public ConstructorInitializerSyntax WithThisOrBaseKeyword(SyntaxToken thisOrBaseKeyword)
    {
        return this.Update(this.ColonToken, thisOrBaseKeyword, this.ArgumentList);
    }

    public ConstructorInitializerSyntax WithArgumentList(ArgumentListSyntax argumentList)
    {
        return this.Update(this.ColonToken, this.ThisOrBaseKeyword, argumentList);
    }

    public ConstructorInitializerSyntax AddArgumentListArguments(params ArgumentSyntax[] items)
    {
        return this.WithArgumentList(this.ArgumentList.WithArguments(this.ArgumentList.Arguments.AddRange(items)));
    }
  }

  /// <summary>Destructor declaration syntax.</summary>
  public sealed partial class DestructorDeclarationSyntax : BaseMethodDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private ParameterListSyntax parameterList;
    private BlockSyntax body;
    private ArrowExpressionClauseSyntax expressionBody;

    internal DestructorDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>Gets the tilde token.</summary>
    public SyntaxToken TildeToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DestructorDeclarationSyntax)this.Green).tildeToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DestructorDeclarationSyntax)this.Green).identifier, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override ParameterListSyntax ParameterList 
    {
        get
        {
            return this.GetRed(ref this.parameterList, 4);
        }
    }

    public override BlockSyntax Body 
    {
        get
        {
            return this.GetRed(ref this.body, 5);
        }
    }

    public override ArrowExpressionClauseSyntax ExpressionBody 
    {
        get
        {
            return this.GetRed(ref this.expressionBody, 6);
        }
    }

    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DestructorDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(7), this.GetChildIndex(7));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 4: return this.GetRed(ref this.parameterList, 4);
            case 5: return this.GetRed(ref this.body, 5);
            case 6: return this.GetRed(ref this.expressionBody, 6);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 4: return this.parameterList;
            case 5: return this.body;
            case 6: return this.expressionBody;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitDestructorDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitDestructorDeclaration(this);
    }

    public DestructorDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, SyntaxToken tildeToken, SyntaxToken identifier, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || tildeToken != this.TildeToken || identifier != this.Identifier || parameterList != this.ParameterList || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.DestructorDeclaration(attributeLists, modifiers, tildeToken, identifier, parameterList, body, expressionBody, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public DestructorDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.TildeToken, this.Identifier, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public DestructorDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.TildeToken, this.Identifier, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public DestructorDeclarationSyntax WithTildeToken(SyntaxToken tildeToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, tildeToken, this.Identifier, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public DestructorDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.TildeToken, identifier, this.ParameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public DestructorDeclarationSyntax WithParameterList(ParameterListSyntax parameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.TildeToken, this.Identifier, parameterList, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public DestructorDeclarationSyntax WithBody(BlockSyntax body)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.TildeToken, this.Identifier, this.ParameterList, body, this.ExpressionBody, this.SemicolonToken);
    }

    public DestructorDeclarationSyntax WithExpressionBody(ArrowExpressionClauseSyntax expressionBody)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.TildeToken, this.Identifier, this.ParameterList, this.Body, expressionBody, this.SemicolonToken);
    }

    public DestructorDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.TildeToken, this.Identifier, this.ParameterList, this.Body, this.ExpressionBody, semicolonToken);
    }

    public DestructorDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public DestructorDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public DestructorDeclarationSyntax AddParameterListParameters(params ParameterSyntax[] items)
    {
        return this.WithParameterList(this.ParameterList.WithParameters(this.ParameterList.Parameters.AddRange(items)));
    }

    public DestructorDeclarationSyntax AddBodyStatements(params StatementSyntax[] items)
    {
        var body = this.Body ?? SyntaxFactory.Block();
        return this.WithBody(body.WithStatements(body.Statements.AddRange(items)));
    }
  }

  /// <summary>Base type for property declaration syntax.</summary>
  public abstract partial class BasePropertyDeclarationSyntax : MemberDeclarationSyntax
  {
    internal BasePropertyDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public abstract SyntaxList<AttributeListSyntax> AttributeLists { get; }

    /// <summary>Gets the modifier list.</summary>
    public abstract SyntaxTokenList Modifiers { get; }

    /// <summary>Gets the type syntax.</summary>
    public abstract TypeSyntax Type { get; }

    /// <summary>Gets the optional explicit interface specifier.</summary>
    public abstract ExplicitInterfaceSpecifierSyntax ExplicitInterfaceSpecifier { get; }

    public abstract AccessorListSyntax AccessorList { get; }
  }

  public sealed partial class PropertyDeclarationSyntax : BasePropertyDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private TypeSyntax type;
    private ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier;
    private AccessorListSyntax accessorList;
    private ArrowExpressionClauseSyntax expressionBody;
    private EqualsValueClauseSyntax initializer;

    internal PropertyDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    public override TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 2);
        }
    }

    public override ExplicitInterfaceSpecifierSyntax ExplicitInterfaceSpecifier 
    {
        get
        {
            return this.GetRed(ref this.explicitInterfaceSpecifier, 3);
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PropertyDeclarationSyntax)this.Green).identifier, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    public override AccessorListSyntax AccessorList 
    {
        get
        {
            return this.GetRed(ref this.accessorList, 5);
        }
    }

    public ArrowExpressionClauseSyntax ExpressionBody 
    {
        get
        {
            return this.GetRed(ref this.expressionBody, 6);
        }
    }

    public EqualsValueClauseSyntax Initializer 
    {
        get
        {
            return this.GetRed(ref this.initializer, 7);
        }
    }

    public SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PropertyDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(8), this.GetChildIndex(8));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 2: return this.GetRed(ref this.type, 2);
            case 3: return this.GetRed(ref this.explicitInterfaceSpecifier, 3);
            case 5: return this.GetRed(ref this.accessorList, 5);
            case 6: return this.GetRed(ref this.expressionBody, 6);
            case 7: return this.GetRed(ref this.initializer, 7);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 2: return this.type;
            case 3: return this.explicitInterfaceSpecifier;
            case 5: return this.accessorList;
            case 6: return this.expressionBody;
            case 7: return this.initializer;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitPropertyDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitPropertyDeclaration(this);
    }

    public PropertyDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList, ArrowExpressionClauseSyntax expressionBody, EqualsValueClauseSyntax initializer, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || type != this.Type || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || identifier != this.Identifier || accessorList != this.AccessorList || expressionBody != this.ExpressionBody || initializer != this.Initializer || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.PropertyDeclaration(attributeLists, modifiers, type, explicitInterfaceSpecifier, identifier, accessorList, expressionBody, initializer, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public PropertyDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.Identifier, this.AccessorList, this.ExpressionBody, this.Initializer, this.SemicolonToken);
    }

    public PropertyDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.Identifier, this.AccessorList, this.ExpressionBody, this.Initializer, this.SemicolonToken);
    }

    public PropertyDeclarationSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.AttributeLists, this.Modifiers, type, this.ExplicitInterfaceSpecifier, this.Identifier, this.AccessorList, this.ExpressionBody, this.Initializer, this.SemicolonToken);
    }

    public PropertyDeclarationSyntax WithExplicitInterfaceSpecifier(ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, explicitInterfaceSpecifier, this.Identifier, this.AccessorList, this.ExpressionBody, this.Initializer, this.SemicolonToken);
    }

    public PropertyDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, identifier, this.AccessorList, this.ExpressionBody, this.Initializer, this.SemicolonToken);
    }

    public PropertyDeclarationSyntax WithAccessorList(AccessorListSyntax accessorList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.Identifier, accessorList, this.ExpressionBody, this.Initializer, this.SemicolonToken);
    }

    public PropertyDeclarationSyntax WithExpressionBody(ArrowExpressionClauseSyntax expressionBody)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.Identifier, this.AccessorList, expressionBody, this.Initializer, this.SemicolonToken);
    }

    public PropertyDeclarationSyntax WithInitializer(EqualsValueClauseSyntax initializer)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.Identifier, this.AccessorList, this.ExpressionBody, initializer, this.SemicolonToken);
    }

    public PropertyDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.Identifier, this.AccessorList, this.ExpressionBody, this.Initializer, semicolonToken);
    }

    public PropertyDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public PropertyDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public PropertyDeclarationSyntax AddAccessorListAccessors(params AccessorDeclarationSyntax[] items)
    {
        var accessorList = this.AccessorList ?? SyntaxFactory.AccessorList();
        return this.WithAccessorList(accessorList.WithAccessors(accessorList.Accessors.AddRange(items)));
    }
  }

  /// <summary>The syntax for the expression body of an expression-bodied member.</summary>
  public sealed partial class ArrowExpressionClauseSyntax : CSharpSyntaxNode
  {
    private ExpressionSyntax expression;

    internal ArrowExpressionClauseSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken ArrowToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ArrowExpressionClauseSyntax)this.Green).arrowToken, this.Position, 0); }
    }

    public ExpressionSyntax Expression 
    {
        get
        {
            return this.GetRed(ref this.expression, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.expression, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.expression;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitArrowExpressionClause(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitArrowExpressionClause(this);
    }

    public ArrowExpressionClauseSyntax Update(SyntaxToken arrowToken, ExpressionSyntax expression)
    {
        if (arrowToken != this.ArrowToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.ArrowExpressionClause(arrowToken, expression);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ArrowExpressionClauseSyntax WithArrowToken(SyntaxToken arrowToken)
    {
        return this.Update(arrowToken, this.Expression);
    }

    public ArrowExpressionClauseSyntax WithExpression(ExpressionSyntax expression)
    {
        return this.Update(this.ArrowToken, expression);
    }
  }

  public sealed partial class EventDeclarationSyntax : BasePropertyDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private TypeSyntax type;
    private ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier;
    private AccessorListSyntax accessorList;

    internal EventDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    public SyntaxToken EventKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EventDeclarationSyntax)this.Green).eventKeyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 3);
        }
    }

    public override ExplicitInterfaceSpecifierSyntax ExplicitInterfaceSpecifier 
    {
        get
        {
            return this.GetRed(ref this.explicitInterfaceSpecifier, 4);
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EventDeclarationSyntax)this.Green).identifier, this.GetChildPosition(5), this.GetChildIndex(5)); }
    }

    public override AccessorListSyntax AccessorList 
    {
        get
        {
            return this.GetRed(ref this.accessorList, 6);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 3: return this.GetRed(ref this.type, 3);
            case 4: return this.GetRed(ref this.explicitInterfaceSpecifier, 4);
            case 6: return this.GetRed(ref this.accessorList, 6);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 3: return this.type;
            case 4: return this.explicitInterfaceSpecifier;
            case 6: return this.accessorList;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitEventDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitEventDeclaration(this);
    }

    public EventDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, SyntaxToken eventKeyword, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || eventKeyword != this.EventKeyword || type != this.Type || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || identifier != this.Identifier || accessorList != this.AccessorList)
        {
            var newNode = SyntaxFactory.EventDeclaration(attributeLists, modifiers, eventKeyword, type, explicitInterfaceSpecifier, identifier, accessorList);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public EventDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.EventKeyword, this.Type, this.ExplicitInterfaceSpecifier, this.Identifier, this.AccessorList);
    }

    public EventDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.EventKeyword, this.Type, this.ExplicitInterfaceSpecifier, this.Identifier, this.AccessorList);
    }

    public EventDeclarationSyntax WithEventKeyword(SyntaxToken eventKeyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, eventKeyword, this.Type, this.ExplicitInterfaceSpecifier, this.Identifier, this.AccessorList);
    }

    public EventDeclarationSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EventKeyword, type, this.ExplicitInterfaceSpecifier, this.Identifier, this.AccessorList);
    }

    public EventDeclarationSyntax WithExplicitInterfaceSpecifier(ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EventKeyword, this.Type, explicitInterfaceSpecifier, this.Identifier, this.AccessorList);
    }

    public EventDeclarationSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EventKeyword, this.Type, this.ExplicitInterfaceSpecifier, identifier, this.AccessorList);
    }

    public EventDeclarationSyntax WithAccessorList(AccessorListSyntax accessorList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.EventKeyword, this.Type, this.ExplicitInterfaceSpecifier, this.Identifier, accessorList);
    }

    public EventDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public EventDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public EventDeclarationSyntax AddAccessorListAccessors(params AccessorDeclarationSyntax[] items)
    {
        return this.WithAccessorList(this.AccessorList.WithAccessors(this.AccessorList.Accessors.AddRange(items)));
    }
  }

  public sealed partial class IndexerDeclarationSyntax : BasePropertyDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private TypeSyntax type;
    private ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier;
    private BracketedParameterListSyntax parameterList;
    private AccessorListSyntax accessorList;
    private ArrowExpressionClauseSyntax expressionBody;

    internal IndexerDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    public override SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    public override TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 2);
        }
    }

    public override ExplicitInterfaceSpecifierSyntax ExplicitInterfaceSpecifier 
    {
        get
        {
            return this.GetRed(ref this.explicitInterfaceSpecifier, 3);
        }
    }

    public SyntaxToken ThisKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IndexerDeclarationSyntax)this.Green).thisKeyword, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    /// <summary>Gets the parameter list.</summary>
    public BracketedParameterListSyntax ParameterList 
    {
        get
        {
            return this.GetRed(ref this.parameterList, 5);
        }
    }

    public override AccessorListSyntax AccessorList 
    {
        get
        {
            return this.GetRed(ref this.accessorList, 6);
        }
    }

    public ArrowExpressionClauseSyntax ExpressionBody 
    {
        get
        {
            return this.GetRed(ref this.expressionBody, 7);
        }
    }

    public SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IndexerDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(8), this.GetChildIndex(8));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 2: return this.GetRed(ref this.type, 2);
            case 3: return this.GetRed(ref this.explicitInterfaceSpecifier, 3);
            case 5: return this.GetRed(ref this.parameterList, 5);
            case 6: return this.GetRed(ref this.accessorList, 6);
            case 7: return this.GetRed(ref this.expressionBody, 7);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 2: return this.type;
            case 3: return this.explicitInterfaceSpecifier;
            case 5: return this.parameterList;
            case 6: return this.accessorList;
            case 7: return this.expressionBody;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitIndexerDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitIndexerDeclaration(this);
    }

    public IndexerDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken thisKeyword, BracketedParameterListSyntax parameterList, AccessorListSyntax accessorList, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || type != this.Type || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || thisKeyword != this.ThisKeyword || parameterList != this.ParameterList || accessorList != this.AccessorList || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.IndexerDeclaration(attributeLists, modifiers, type, explicitInterfaceSpecifier, thisKeyword, parameterList, accessorList, expressionBody, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public IndexerDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.ThisKeyword, this.ParameterList, this.AccessorList, this.ExpressionBody, this.SemicolonToken);
    }

    public IndexerDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.ThisKeyword, this.ParameterList, this.AccessorList, this.ExpressionBody, this.SemicolonToken);
    }

    public IndexerDeclarationSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.AttributeLists, this.Modifiers, type, this.ExplicitInterfaceSpecifier, this.ThisKeyword, this.ParameterList, this.AccessorList, this.ExpressionBody, this.SemicolonToken);
    }

    public IndexerDeclarationSyntax WithExplicitInterfaceSpecifier(ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, explicitInterfaceSpecifier, this.ThisKeyword, this.ParameterList, this.AccessorList, this.ExpressionBody, this.SemicolonToken);
    }

    public IndexerDeclarationSyntax WithThisKeyword(SyntaxToken thisKeyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, thisKeyword, this.ParameterList, this.AccessorList, this.ExpressionBody, this.SemicolonToken);
    }

    public IndexerDeclarationSyntax WithParameterList(BracketedParameterListSyntax parameterList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.ThisKeyword, parameterList, this.AccessorList, this.ExpressionBody, this.SemicolonToken);
    }

    public IndexerDeclarationSyntax WithAccessorList(AccessorListSyntax accessorList)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.ThisKeyword, this.ParameterList, accessorList, this.ExpressionBody, this.SemicolonToken);
    }

    public IndexerDeclarationSyntax WithExpressionBody(ArrowExpressionClauseSyntax expressionBody)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.ThisKeyword, this.ParameterList, this.AccessorList, expressionBody, this.SemicolonToken);
    }

    public IndexerDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, this.ExplicitInterfaceSpecifier, this.ThisKeyword, this.ParameterList, this.AccessorList, this.ExpressionBody, semicolonToken);
    }

    public IndexerDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public IndexerDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public IndexerDeclarationSyntax AddParameterListParameters(params ParameterSyntax[] items)
    {
        return this.WithParameterList(this.ParameterList.WithParameters(this.ParameterList.Parameters.AddRange(items)));
    }

    public IndexerDeclarationSyntax AddAccessorListAccessors(params AccessorDeclarationSyntax[] items)
    {
        var accessorList = this.AccessorList ?? SyntaxFactory.AccessorList();
        return this.WithAccessorList(accessorList.WithAccessors(accessorList.Accessors.AddRange(items)));
    }
  }

  public sealed partial class AccessorListSyntax : CSharpSyntaxNode
  {
    private SyntaxNode accessors;

    internal AccessorListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OpenBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AccessorListSyntax)this.Green).openBraceToken, this.Position, 0); }
    }

    public SyntaxList<AccessorDeclarationSyntax> Accessors 
    {
        get
        {
            return new SyntaxList<AccessorDeclarationSyntax>(this.GetRed(ref this.accessors, 1));
        }
    }

    public SyntaxToken CloseBraceToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AccessorListSyntax)this.Green).closeBraceToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.accessors, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.accessors;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAccessorList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAccessorList(this);
    }

    public AccessorListSyntax Update(SyntaxToken openBraceToken, SyntaxList<AccessorDeclarationSyntax> accessors, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || accessors != this.Accessors || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.AccessorList(openBraceToken, accessors, closeBraceToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AccessorListSyntax WithOpenBraceToken(SyntaxToken openBraceToken)
    {
        return this.Update(openBraceToken, this.Accessors, this.CloseBraceToken);
    }

    public AccessorListSyntax WithAccessors(SyntaxList<AccessorDeclarationSyntax> accessors)
    {
        return this.Update(this.OpenBraceToken, accessors, this.CloseBraceToken);
    }

    public AccessorListSyntax WithCloseBraceToken(SyntaxToken closeBraceToken)
    {
        return this.Update(this.OpenBraceToken, this.Accessors, closeBraceToken);
    }

    public AccessorListSyntax AddAccessors(params AccessorDeclarationSyntax[] items)
    {
        return this.WithAccessors(this.Accessors.AddRange(items));
    }
  }

  public sealed partial class AccessorDeclarationSyntax : CSharpSyntaxNode
  {
    private SyntaxNode attributeLists;
    private BlockSyntax body;
    private ArrowExpressionClauseSyntax expressionBody;

    internal AccessorDeclarationSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    /// <summary>Gets the modifier list.</summary>
    public SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    /// <summary>Gets the keyword token, or identifier if an erroneous accessor declaration.</summary>
    public SyntaxToken Keyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AccessorDeclarationSyntax)this.Green).keyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    /// <summary>Gets the optional body block which may be empty, but it is null if there are no braces.</summary>
    public BlockSyntax Body 
    {
        get
        {
            return this.GetRed(ref this.body, 3);
        }
    }

    /// <summary>Gets the optional expression body.</summary>
    public ArrowExpressionClauseSyntax ExpressionBody 
    {
        get
        {
            return this.GetRed(ref this.expressionBody, 4);
        }
    }

    /// <summary>Gets the optional semicolon token.</summary>
    public SyntaxToken SemicolonToken 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.AccessorDeclarationSyntax)this.Green).semicolonToken;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(5), this.GetChildIndex(5));

            return default(SyntaxToken);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 3: return this.GetRed(ref this.body, 3);
            case 4: return this.GetRed(ref this.expressionBody, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 3: return this.body;
            case 4: return this.expressionBody;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitAccessorDeclaration(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitAccessorDeclaration(this);
    }

    public AccessorDeclarationSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, SyntaxToken keyword, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.AccessorDeclaration(this.Kind(), attributeLists, modifiers, keyword, body, expressionBody, semicolonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public AccessorDeclarationSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.Keyword, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public AccessorDeclarationSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.Keyword, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public AccessorDeclarationSyntax WithKeyword(SyntaxToken keyword)
    {
        return this.Update(this.AttributeLists, this.Modifiers, keyword, this.Body, this.ExpressionBody, this.SemicolonToken);
    }

    public AccessorDeclarationSyntax WithBody(BlockSyntax body)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, body, this.ExpressionBody, this.SemicolonToken);
    }

    public AccessorDeclarationSyntax WithExpressionBody(ArrowExpressionClauseSyntax expressionBody)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Body, expressionBody, this.SemicolonToken);
    }

    public AccessorDeclarationSyntax WithSemicolonToken(SyntaxToken semicolonToken)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Keyword, this.Body, this.ExpressionBody, semicolonToken);
    }

    public AccessorDeclarationSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public AccessorDeclarationSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }

    public AccessorDeclarationSyntax AddBodyStatements(params StatementSyntax[] items)
    {
        var body = this.Body ?? SyntaxFactory.Block();
        return this.WithBody(body.WithStatements(body.Statements.AddRange(items)));
    }
  }

  /// <summary>Base type for parameter list syntax.</summary>
  public abstract partial class BaseParameterListSyntax : CSharpSyntaxNode
  {
    internal BaseParameterListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>Gets the parameter list.</summary>
    public abstract SeparatedSyntaxList<ParameterSyntax> Parameters { get; }
  }

  /// <summary>Parameter list syntax.</summary>
  public sealed partial class ParameterListSyntax : BaseParameterListSyntax
  {
    private SyntaxNode parameters;

    internal ParameterListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the open paren token.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ParameterListSyntax)this.Green).openParenToken, this.Position, 0); }
    }

    public override SeparatedSyntaxList<ParameterSyntax> Parameters 
    {
        get
        {
            var red = this.GetRed(ref this.parameters, 1);
            if (red != null)
                return new SeparatedSyntaxList<ParameterSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<ParameterSyntax>);
        }
    }

    /// <summary>Gets the close paren token.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ParameterListSyntax)this.Green).closeParenToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.parameters, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.parameters;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitParameterList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitParameterList(this);
    }

    public ParameterListSyntax Update(SyntaxToken openParenToken, SeparatedSyntaxList<ParameterSyntax> parameters, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || parameters != this.Parameters || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ParameterList(openParenToken, parameters, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ParameterListSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(openParenToken, this.Parameters, this.CloseParenToken);
    }

    public ParameterListSyntax WithParameters(SeparatedSyntaxList<ParameterSyntax> parameters)
    {
        return this.Update(this.OpenParenToken, parameters, this.CloseParenToken);
    }

    public ParameterListSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.OpenParenToken, this.Parameters, closeParenToken);
    }

    public ParameterListSyntax AddParameters(params ParameterSyntax[] items)
    {
        return this.WithParameters(this.Parameters.AddRange(items));
    }
  }

  /// <summary>Parameter list syntax with surrounding brackets.</summary>
  public sealed partial class BracketedParameterListSyntax : BaseParameterListSyntax
  {
    private SyntaxNode parameters;

    internal BracketedParameterListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the open bracket token.</summary>
    public SyntaxToken OpenBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BracketedParameterListSyntax)this.Green).openBracketToken, this.Position, 0); }
    }

    public override SeparatedSyntaxList<ParameterSyntax> Parameters 
    {
        get
        {
            var red = this.GetRed(ref this.parameters, 1);
            if (red != null)
                return new SeparatedSyntaxList<ParameterSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<ParameterSyntax>);
        }
    }

    /// <summary>Gets the close bracket token.</summary>
    public SyntaxToken CloseBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BracketedParameterListSyntax)this.Green).closeBracketToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.parameters, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.parameters;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitBracketedParameterList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitBracketedParameterList(this);
    }

    public BracketedParameterListSyntax Update(SyntaxToken openBracketToken, SeparatedSyntaxList<ParameterSyntax> parameters, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || parameters != this.Parameters || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.BracketedParameterList(openBracketToken, parameters, closeBracketToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public BracketedParameterListSyntax WithOpenBracketToken(SyntaxToken openBracketToken)
    {
        return this.Update(openBracketToken, this.Parameters, this.CloseBracketToken);
    }

    public BracketedParameterListSyntax WithParameters(SeparatedSyntaxList<ParameterSyntax> parameters)
    {
        return this.Update(this.OpenBracketToken, parameters, this.CloseBracketToken);
    }

    public BracketedParameterListSyntax WithCloseBracketToken(SyntaxToken closeBracketToken)
    {
        return this.Update(this.OpenBracketToken, this.Parameters, closeBracketToken);
    }

    public BracketedParameterListSyntax AddParameters(params ParameterSyntax[] items)
    {
        return this.WithParameters(this.Parameters.AddRange(items));
    }
  }

  /// <summary>Parameter syntax.</summary>
  public sealed partial class ParameterSyntax : CSharpSyntaxNode
  {
    private SyntaxNode attributeLists;
    private TypeSyntax type;
    private EqualsValueClauseSyntax @default;

    internal ParameterSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    /// <summary>Gets the modifier list.</summary>
    public SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 2);
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ParameterSyntax)this.Green).identifier, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public EqualsValueClauseSyntax Default 
    {
        get
        {
            return this.GetRed(ref this.@default, 4);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 2: return this.GetRed(ref this.type, 2);
            case 4: return this.GetRed(ref this.@default, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 2: return this.type;
            case 4: return this.@default;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitParameter(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitParameter(this);
    }

    public ParameterSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, TypeSyntax type, SyntaxToken identifier, EqualsValueClauseSyntax @default)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || type != this.Type || identifier != this.Identifier || @default != this.Default)
        {
            var newNode = SyntaxFactory.Parameter(attributeLists, modifiers, type, identifier, @default);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ParameterSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.Type, this.Identifier, this.Default);
    }

    public ParameterSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.Type, this.Identifier, this.Default);
    }

    public ParameterSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.AttributeLists, this.Modifiers, type, this.Identifier, this.Default);
    }

    public ParameterSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, identifier, this.Default);
    }

    public ParameterSyntax WithDefault(EqualsValueClauseSyntax @default)
    {
        return this.Update(this.AttributeLists, this.Modifiers, this.Type, this.Identifier, @default);
    }

    public ParameterSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public ParameterSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }
  }

  public sealed partial class IncompleteMemberSyntax : MemberDeclarationSyntax
  {
    private SyntaxNode attributeLists;
    private TypeSyntax type;

    internal IncompleteMemberSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public SyntaxList<AttributeListSyntax> AttributeLists 
    {
        get
        {
            return new SyntaxList<AttributeListSyntax>(this.GetRed(ref this.attributeLists, 0));
        }
    }

    /// <summary>Gets the modifier list.</summary>
    public SyntaxTokenList Modifiers 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.attributeLists);
            case 2: return this.GetRed(ref this.type, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 2: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitIncompleteMember(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitIncompleteMember(this);
    }

    public IncompleteMemberSyntax Update(SyntaxList<AttributeListSyntax> attributeLists, SyntaxTokenList modifiers, TypeSyntax type)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || type != this.Type)
        {
            var newNode = SyntaxFactory.IncompleteMember(attributeLists, modifiers, type);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public IncompleteMemberSyntax WithAttributeLists(SyntaxList<AttributeListSyntax> attributeLists)
    {
        return this.Update(attributeLists, this.Modifiers, this.Type);
    }

    public IncompleteMemberSyntax WithModifiers(SyntaxTokenList modifiers)
    {
        return this.Update(this.AttributeLists, modifiers, this.Type);
    }

    public IncompleteMemberSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.AttributeLists, this.Modifiers, type);
    }

    public IncompleteMemberSyntax AddAttributeLists(params AttributeListSyntax[] items)
    {
        return this.WithAttributeLists(this.AttributeLists.AddRange(items));
    }

    public IncompleteMemberSyntax AddModifiers(params SyntaxToken[] items)
    {
        return this.WithModifiers(this.Modifiers.AddRange(items));
    }
  }

  public sealed partial class SkippedTokensTriviaSyntax : StructuredTriviaSyntax
  {
    internal SkippedTokensTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxTokenList Tokens 
    {
        get
        {
            var slot = this.Green.GetSlot(0);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.Position, 0);

            return default(SyntaxTokenList);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitSkippedTokensTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitSkippedTokensTrivia(this);
    }

    public SkippedTokensTriviaSyntax Update(SyntaxTokenList tokens)
    {
        if (tokens != this.Tokens)
        {
            var newNode = SyntaxFactory.SkippedTokensTrivia(tokens);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public SkippedTokensTriviaSyntax WithTokens(SyntaxTokenList tokens)
    {
        return this.Update(tokens);
    }

    public SkippedTokensTriviaSyntax AddTokens(params SyntaxToken[] items)
    {
        return this.WithTokens(this.Tokens.AddRange(items));
    }
  }

  public sealed partial class DocumentationCommentTriviaSyntax : StructuredTriviaSyntax
  {
    private SyntaxNode content;

    internal DocumentationCommentTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<XmlNodeSyntax> Content 
    {
        get
        {
            return new SyntaxList<XmlNodeSyntax>(this.GetRed(ref this.content, 0));
        }
    }

    public SyntaxToken EndOfComment 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DocumentationCommentTriviaSyntax)this.Green).endOfComment, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.content);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.content;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitDocumentationCommentTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitDocumentationCommentTrivia(this);
    }

    public DocumentationCommentTriviaSyntax Update(SyntaxList<XmlNodeSyntax> content, SyntaxToken endOfComment)
    {
        if (content != this.Content || endOfComment != this.EndOfComment)
        {
            var newNode = SyntaxFactory.DocumentationCommentTrivia(this.Kind(), content, endOfComment);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public DocumentationCommentTriviaSyntax WithContent(SyntaxList<XmlNodeSyntax> content)
    {
        return this.Update(content, this.EndOfComment);
    }

    public DocumentationCommentTriviaSyntax WithEndOfComment(SyntaxToken endOfComment)
    {
        return this.Update(this.Content, endOfComment);
    }

    public DocumentationCommentTriviaSyntax AddContent(params XmlNodeSyntax[] items)
    {
        return this.WithContent(this.Content.AddRange(items));
    }
  }

  /// <summary>
  /// A symbol referenced by a cref attribute (e.g. in a &lt;see&gt; or &lt;seealso&gt; documentation comment tag).
  /// For example, the M in &lt;see cref="M" /&gt;.
  /// </summary>
  public abstract partial class CrefSyntax : CSharpSyntaxNode
  {
    internal CrefSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  /// <summary>
  /// A symbol reference that definitely refers to a type.
  /// For example, "int", "A::B", "A.B", "A&lt;T&gt;", but not "M()" (has parameter list) or "this" (indexer).
  /// NOTE: TypeCrefSyntax, QualifiedCrefSyntax, and MemberCrefSyntax overlap.  The syntax in a TypeCrefSyntax
  /// will always be bound as type, so it's safer to use QualifiedCrefSyntax or MemberCrefSyntax if the symbol
  /// might be a non-type member.
  /// </summary>
  public sealed partial class TypeCrefSyntax : CrefSyntax
  {
    private TypeSyntax type;

    internal TypeCrefSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRedAtZero(ref this.type);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.type);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitTypeCref(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitTypeCref(this);
    }

    public TypeCrefSyntax Update(TypeSyntax type)
    {
        if (type != this.Type)
        {
            var newNode = SyntaxFactory.TypeCref(type);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public TypeCrefSyntax WithType(TypeSyntax type)
    {
        return this.Update(type);
    }
  }

  /// <summary>
  /// A symbol reference to a type or non-type member that is qualified by an enclosing type or namespace.
  /// For example, cref="System.String.ToString()".
  /// NOTE: TypeCrefSyntax, QualifiedCrefSyntax, and MemberCrefSyntax overlap.  The syntax in a TypeCrefSyntax
  /// will always be bound as type, so it's safer to use QualifiedCrefSyntax or MemberCrefSyntax if the symbol
  /// might be a non-type member.
  /// </summary>
  public sealed partial class QualifiedCrefSyntax : CrefSyntax
  {
    private TypeSyntax container;
    private MemberCrefSyntax member;

    internal QualifiedCrefSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public TypeSyntax Container 
    {
        get
        {
            return this.GetRedAtZero(ref this.container);
        }
    }

    public SyntaxToken DotToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.QualifiedCrefSyntax)this.Green).dotToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public MemberCrefSyntax Member 
    {
        get
        {
            return this.GetRed(ref this.member, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.container);
            case 2: return this.GetRed(ref this.member, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.container;
            case 2: return this.member;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitQualifiedCref(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitQualifiedCref(this);
    }

    public QualifiedCrefSyntax Update(TypeSyntax container, SyntaxToken dotToken, MemberCrefSyntax member)
    {
        if (container != this.Container || dotToken != this.DotToken || member != this.Member)
        {
            var newNode = SyntaxFactory.QualifiedCref(container, dotToken, member);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public QualifiedCrefSyntax WithContainer(TypeSyntax container)
    {
        return this.Update(container, this.DotToken, this.Member);
    }

    public QualifiedCrefSyntax WithDotToken(SyntaxToken dotToken)
    {
        return this.Update(this.Container, dotToken, this.Member);
    }

    public QualifiedCrefSyntax WithMember(MemberCrefSyntax member)
    {
        return this.Update(this.Container, this.DotToken, member);
    }
  }

  /// <summary>
  /// The unqualified part of a CrefSyntax.
  /// For example, "ToString()" in "object.ToString()".
  /// NOTE: TypeCrefSyntax, QualifiedCrefSyntax, and MemberCrefSyntax overlap.  The syntax in a TypeCrefSyntax
  /// will always be bound as type, so it's safer to use QualifiedCrefSyntax or MemberCrefSyntax if the symbol
  /// might be a non-type member.
  /// </summary>
  public abstract partial class MemberCrefSyntax : CrefSyntax
  {
    internal MemberCrefSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  /// <summary>
  /// A MemberCrefSyntax specified by a name (an identifier, predefined type keyword, or an alias-qualified name,
  /// with an optional type parameter list) and an optional parameter list.
  /// For example, "M", "M&lt;T&gt;" or "M(int)".
  /// Also, "A::B()" or "string()".
  /// </summary>
  public sealed partial class NameMemberCrefSyntax : MemberCrefSyntax
  {
    private TypeSyntax name;
    private CrefParameterListSyntax parameters;

    internal NameMemberCrefSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public TypeSyntax Name 
    {
        get
        {
            return this.GetRedAtZero(ref this.name);
        }
    }

    public CrefParameterListSyntax Parameters 
    {
        get
        {
            return this.GetRed(ref this.parameters, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.name);
            case 1: return this.GetRed(ref this.parameters, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            case 1: return this.parameters;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitNameMemberCref(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitNameMemberCref(this);
    }

    public NameMemberCrefSyntax Update(TypeSyntax name, CrefParameterListSyntax parameters)
    {
        if (name != this.Name || parameters != this.Parameters)
        {
            var newNode = SyntaxFactory.NameMemberCref(name, parameters);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public NameMemberCrefSyntax WithName(TypeSyntax name)
    {
        return this.Update(name, this.Parameters);
    }

    public NameMemberCrefSyntax WithParameters(CrefParameterListSyntax parameters)
    {
        return this.Update(this.Name, parameters);
    }

    public NameMemberCrefSyntax AddParametersParameters(params CrefParameterSyntax[] items)
    {
        var parameters = this.Parameters ?? SyntaxFactory.CrefParameterList();
        return this.WithParameters(parameters.WithParameters(parameters.Parameters.AddRange(items)));
    }
  }

  /// <summary>
  /// A MemberCrefSyntax specified by a this keyword and an optional parameter list.
  /// For example, "this" or "this[int]".
  /// </summary>
  public sealed partial class IndexerMemberCrefSyntax : MemberCrefSyntax
  {
    private CrefBracketedParameterListSyntax parameters;

    internal IndexerMemberCrefSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken ThisKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IndexerMemberCrefSyntax)this.Green).thisKeyword, this.Position, 0); }
    }

    public CrefBracketedParameterListSyntax Parameters 
    {
        get
        {
            return this.GetRed(ref this.parameters, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.parameters, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.parameters;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitIndexerMemberCref(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitIndexerMemberCref(this);
    }

    public IndexerMemberCrefSyntax Update(SyntaxToken thisKeyword, CrefBracketedParameterListSyntax parameters)
    {
        if (thisKeyword != this.ThisKeyword || parameters != this.Parameters)
        {
            var newNode = SyntaxFactory.IndexerMemberCref(thisKeyword, parameters);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public IndexerMemberCrefSyntax WithThisKeyword(SyntaxToken thisKeyword)
    {
        return this.Update(thisKeyword, this.Parameters);
    }

    public IndexerMemberCrefSyntax WithParameters(CrefBracketedParameterListSyntax parameters)
    {
        return this.Update(this.ThisKeyword, parameters);
    }

    public IndexerMemberCrefSyntax AddParametersParameters(params CrefParameterSyntax[] items)
    {
        var parameters = this.Parameters ?? SyntaxFactory.CrefBracketedParameterList();
        return this.WithParameters(parameters.WithParameters(parameters.Parameters.AddRange(items)));
    }
  }

  /// <summary>
  /// A MemberCrefSyntax specified by an operator keyword, an operator symbol and an optional parameter list.
  /// For example, "operator +" or "operator -[int]".
  /// NOTE: the operator must be overloadable.
  /// </summary>
  public sealed partial class OperatorMemberCrefSyntax : MemberCrefSyntax
  {
    private CrefParameterListSyntax parameters;

    internal OperatorMemberCrefSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OperatorKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.OperatorMemberCrefSyntax)this.Green).operatorKeyword, this.Position, 0); }
    }

    /// <summary>Gets the operator token.</summary>
    public SyntaxToken OperatorToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.OperatorMemberCrefSyntax)this.Green).operatorToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public CrefParameterListSyntax Parameters 
    {
        get
        {
            return this.GetRed(ref this.parameters, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.parameters, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.parameters;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitOperatorMemberCref(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitOperatorMemberCref(this);
    }

    public OperatorMemberCrefSyntax Update(SyntaxToken operatorKeyword, SyntaxToken operatorToken, CrefParameterListSyntax parameters)
    {
        if (operatorKeyword != this.OperatorKeyword || operatorToken != this.OperatorToken || parameters != this.Parameters)
        {
            var newNode = SyntaxFactory.OperatorMemberCref(operatorKeyword, operatorToken, parameters);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public OperatorMemberCrefSyntax WithOperatorKeyword(SyntaxToken operatorKeyword)
    {
        return this.Update(operatorKeyword, this.OperatorToken, this.Parameters);
    }

    public OperatorMemberCrefSyntax WithOperatorToken(SyntaxToken operatorToken)
    {
        return this.Update(this.OperatorKeyword, operatorToken, this.Parameters);
    }

    public OperatorMemberCrefSyntax WithParameters(CrefParameterListSyntax parameters)
    {
        return this.Update(this.OperatorKeyword, this.OperatorToken, parameters);
    }

    public OperatorMemberCrefSyntax AddParametersParameters(params CrefParameterSyntax[] items)
    {
        var parameters = this.Parameters ?? SyntaxFactory.CrefParameterList();
        return this.WithParameters(parameters.WithParameters(parameters.Parameters.AddRange(items)));
    }
  }

  /// <summary>
  /// A MemberCrefSyntax specified by an implicit or explicit keyword, an operator keyword, a destination type, and an optional parameter list.
  /// For example, "implicit operator int" or "explicit operator MyType(int)".
  /// </summary>
  public sealed partial class ConversionOperatorMemberCrefSyntax : MemberCrefSyntax
  {
    private TypeSyntax type;
    private CrefParameterListSyntax parameters;

    internal ConversionOperatorMemberCrefSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken ImplicitOrExplicitKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConversionOperatorMemberCrefSyntax)this.Green).implicitOrExplicitKeyword, this.Position, 0); }
    }

    public SyntaxToken OperatorKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ConversionOperatorMemberCrefSyntax)this.Green).operatorKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 2);
        }
    }

    public CrefParameterListSyntax Parameters 
    {
        get
        {
            return this.GetRed(ref this.parameters, 3);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.type, 2);
            case 3: return this.GetRed(ref this.parameters, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.type;
            case 3: return this.parameters;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitConversionOperatorMemberCref(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitConversionOperatorMemberCref(this);
    }

    public ConversionOperatorMemberCrefSyntax Update(SyntaxToken implicitOrExplicitKeyword, SyntaxToken operatorKeyword, TypeSyntax type, CrefParameterListSyntax parameters)
    {
        if (implicitOrExplicitKeyword != this.ImplicitOrExplicitKeyword || operatorKeyword != this.OperatorKeyword || type != this.Type || parameters != this.Parameters)
        {
            var newNode = SyntaxFactory.ConversionOperatorMemberCref(implicitOrExplicitKeyword, operatorKeyword, type, parameters);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ConversionOperatorMemberCrefSyntax WithImplicitOrExplicitKeyword(SyntaxToken implicitOrExplicitKeyword)
    {
        return this.Update(implicitOrExplicitKeyword, this.OperatorKeyword, this.Type, this.Parameters);
    }

    public ConversionOperatorMemberCrefSyntax WithOperatorKeyword(SyntaxToken operatorKeyword)
    {
        return this.Update(this.ImplicitOrExplicitKeyword, operatorKeyword, this.Type, this.Parameters);
    }

    public ConversionOperatorMemberCrefSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.ImplicitOrExplicitKeyword, this.OperatorKeyword, type, this.Parameters);
    }

    public ConversionOperatorMemberCrefSyntax WithParameters(CrefParameterListSyntax parameters)
    {
        return this.Update(this.ImplicitOrExplicitKeyword, this.OperatorKeyword, this.Type, parameters);
    }

    public ConversionOperatorMemberCrefSyntax AddParametersParameters(params CrefParameterSyntax[] items)
    {
        var parameters = this.Parameters ?? SyntaxFactory.CrefParameterList();
        return this.WithParameters(parameters.WithParameters(parameters.Parameters.AddRange(items)));
    }
  }

  /// <summary>
  /// A list of cref parameters with surrounding punctuation.
  /// Unlike regular parameters, cref parameters do not have names.
  /// </summary>
  public abstract partial class BaseCrefParameterListSyntax : CSharpSyntaxNode
  {
    internal BaseCrefParameterListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    /// <summary>Gets the parameter list.</summary>
    public abstract SeparatedSyntaxList<CrefParameterSyntax> Parameters { get; }
  }

  /// <summary>
  /// A parenthesized list of cref parameters.
  /// </summary>
  public sealed partial class CrefParameterListSyntax : BaseCrefParameterListSyntax
  {
    private SyntaxNode parameters;

    internal CrefParameterListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the open paren token.</summary>
    public SyntaxToken OpenParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CrefParameterListSyntax)this.Green).openParenToken, this.Position, 0); }
    }

    public override SeparatedSyntaxList<CrefParameterSyntax> Parameters 
    {
        get
        {
            var red = this.GetRed(ref this.parameters, 1);
            if (red != null)
                return new SeparatedSyntaxList<CrefParameterSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<CrefParameterSyntax>);
        }
    }

    /// <summary>Gets the close paren token.</summary>
    public SyntaxToken CloseParenToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CrefParameterListSyntax)this.Green).closeParenToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.parameters, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.parameters;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCrefParameterList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCrefParameterList(this);
    }

    public CrefParameterListSyntax Update(SyntaxToken openParenToken, SeparatedSyntaxList<CrefParameterSyntax> parameters, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || parameters != this.Parameters || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.CrefParameterList(openParenToken, parameters, closeParenToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CrefParameterListSyntax WithOpenParenToken(SyntaxToken openParenToken)
    {
        return this.Update(openParenToken, this.Parameters, this.CloseParenToken);
    }

    public CrefParameterListSyntax WithParameters(SeparatedSyntaxList<CrefParameterSyntax> parameters)
    {
        return this.Update(this.OpenParenToken, parameters, this.CloseParenToken);
    }

    public CrefParameterListSyntax WithCloseParenToken(SyntaxToken closeParenToken)
    {
        return this.Update(this.OpenParenToken, this.Parameters, closeParenToken);
    }

    public CrefParameterListSyntax AddParameters(params CrefParameterSyntax[] items)
    {
        return this.WithParameters(this.Parameters.AddRange(items));
    }
  }

  /// <summary>
  /// A bracketed list of cref parameters.
  /// </summary>
  public sealed partial class CrefBracketedParameterListSyntax : BaseCrefParameterListSyntax
  {
    private SyntaxNode parameters;

    internal CrefBracketedParameterListSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    /// <summary>Gets the open bracket token.</summary>
    public SyntaxToken OpenBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CrefBracketedParameterListSyntax)this.Green).openBracketToken, this.Position, 0); }
    }

    public override SeparatedSyntaxList<CrefParameterSyntax> Parameters 
    {
        get
        {
            var red = this.GetRed(ref this.parameters, 1);
            if (red != null)
                return new SeparatedSyntaxList<CrefParameterSyntax>(red, this.GetChildIndex(1));

            return default(SeparatedSyntaxList<CrefParameterSyntax>);
        }
    }

    /// <summary>Gets the close bracket token.</summary>
    public SyntaxToken CloseBracketToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CrefBracketedParameterListSyntax)this.Green).closeBracketToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.parameters, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.parameters;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCrefBracketedParameterList(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCrefBracketedParameterList(this);
    }

    public CrefBracketedParameterListSyntax Update(SyntaxToken openBracketToken, SeparatedSyntaxList<CrefParameterSyntax> parameters, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || parameters != this.Parameters || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.CrefBracketedParameterList(openBracketToken, parameters, closeBracketToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CrefBracketedParameterListSyntax WithOpenBracketToken(SyntaxToken openBracketToken)
    {
        return this.Update(openBracketToken, this.Parameters, this.CloseBracketToken);
    }

    public CrefBracketedParameterListSyntax WithParameters(SeparatedSyntaxList<CrefParameterSyntax> parameters)
    {
        return this.Update(this.OpenBracketToken, parameters, this.CloseBracketToken);
    }

    public CrefBracketedParameterListSyntax WithCloseBracketToken(SyntaxToken closeBracketToken)
    {
        return this.Update(this.OpenBracketToken, this.Parameters, closeBracketToken);
    }

    public CrefBracketedParameterListSyntax AddParameters(params CrefParameterSyntax[] items)
    {
        return this.WithParameters(this.Parameters.AddRange(items));
    }
  }

  /// <summary>
  /// An element of a BaseCrefParameterListSyntax.
  /// Unlike a regular parameter, a cref parameter has only an optional ref or out keyword and a type -
  /// there is no name and there are no attributes or other modifiers.
  /// </summary>
  public sealed partial class CrefParameterSyntax : CSharpSyntaxNode
  {
    private TypeSyntax type;

    internal CrefParameterSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken RefOrOutKeyword 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CrefParameterSyntax)this.Green).refOrOutKeyword;
            if (slot != null)
                return new SyntaxToken(this, slot, this.Position, 0);

            return default(SyntaxToken);
        }
    }

    public TypeSyntax Type 
    {
        get
        {
            return this.GetRed(ref this.type, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.type, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.type;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCrefParameter(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitCrefParameter(this);
    }

    public CrefParameterSyntax Update(SyntaxToken refOrOutKeyword, TypeSyntax type)
    {
        if (refOrOutKeyword != this.RefOrOutKeyword || type != this.Type)
        {
            var newNode = SyntaxFactory.CrefParameter(refOrOutKeyword, type);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CrefParameterSyntax WithRefOrOutKeyword(SyntaxToken refOrOutKeyword)
    {
        return this.Update(refOrOutKeyword, this.Type);
    }

    public CrefParameterSyntax WithType(TypeSyntax type)
    {
        return this.Update(this.RefOrOutKeyword, type);
    }
  }

  public abstract partial class XmlNodeSyntax : CSharpSyntaxNode
  {
    internal XmlNodeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  public sealed partial class XmlElementSyntax : XmlNodeSyntax
  {
    private XmlElementStartTagSyntax startTag;
    private SyntaxNode content;
    private XmlElementEndTagSyntax endTag;

    internal XmlElementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public XmlElementStartTagSyntax StartTag 
    {
        get
        {
            return this.GetRedAtZero(ref this.startTag);
        }
    }

    public SyntaxList<XmlNodeSyntax> Content 
    {
        get
        {
            return new SyntaxList<XmlNodeSyntax>(this.GetRed(ref this.content, 1));
        }
    }

    public XmlElementEndTagSyntax EndTag 
    {
        get
        {
            return this.GetRed(ref this.endTag, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.startTag);
            case 1: return this.GetRed(ref this.content, 1);
            case 2: return this.GetRed(ref this.endTag, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.startTag;
            case 1: return this.content;
            case 2: return this.endTag;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlElement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlElement(this);
    }

    public XmlElementSyntax Update(XmlElementStartTagSyntax startTag, SyntaxList<XmlNodeSyntax> content, XmlElementEndTagSyntax endTag)
    {
        if (startTag != this.StartTag || content != this.Content || endTag != this.EndTag)
        {
            var newNode = SyntaxFactory.XmlElement(startTag, content, endTag);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlElementSyntax WithStartTag(XmlElementStartTagSyntax startTag)
    {
        return this.Update(startTag, this.Content, this.EndTag);
    }

    public XmlElementSyntax WithContent(SyntaxList<XmlNodeSyntax> content)
    {
        return this.Update(this.StartTag, content, this.EndTag);
    }

    public XmlElementSyntax WithEndTag(XmlElementEndTagSyntax endTag)
    {
        return this.Update(this.StartTag, this.Content, endTag);
    }

    public XmlElementSyntax AddStartTagAttributes(params XmlAttributeSyntax[] items)
    {
        return this.WithStartTag(this.StartTag.WithAttributes(this.StartTag.Attributes.AddRange(items)));
    }

    public XmlElementSyntax AddContent(params XmlNodeSyntax[] items)
    {
        return this.WithContent(this.Content.AddRange(items));
    }
  }

  public sealed partial class XmlElementStartTagSyntax : CSharpSyntaxNode
  {
    private XmlNameSyntax name;
    private SyntaxNode attributes;

    internal XmlElementStartTagSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken LessThanToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlElementStartTagSyntax)this.Green).lessThanToken, this.Position, 0); }
    }

    public XmlNameSyntax Name 
    {
        get
        {
            return this.GetRed(ref this.name, 1);
        }
    }

    public SyntaxList<XmlAttributeSyntax> Attributes 
    {
        get
        {
            return new SyntaxList<XmlAttributeSyntax>(this.GetRed(ref this.attributes, 2));
        }
    }

    public SyntaxToken GreaterThanToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlElementStartTagSyntax)this.Green).greaterThanToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.name, 1);
            case 2: return this.GetRed(ref this.attributes, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.name;
            case 2: return this.attributes;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlElementStartTag(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlElementStartTag(this);
    }

    public XmlElementStartTagSyntax Update(SyntaxToken lessThanToken, XmlNameSyntax name, SyntaxList<XmlAttributeSyntax> attributes, SyntaxToken greaterThanToken)
    {
        if (lessThanToken != this.LessThanToken || name != this.Name || attributes != this.Attributes || greaterThanToken != this.GreaterThanToken)
        {
            var newNode = SyntaxFactory.XmlElementStartTag(lessThanToken, name, attributes, greaterThanToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlElementStartTagSyntax WithLessThanToken(SyntaxToken lessThanToken)
    {
        return this.Update(lessThanToken, this.Name, this.Attributes, this.GreaterThanToken);
    }

    public XmlElementStartTagSyntax WithName(XmlNameSyntax name)
    {
        return this.Update(this.LessThanToken, name, this.Attributes, this.GreaterThanToken);
    }

    public XmlElementStartTagSyntax WithAttributes(SyntaxList<XmlAttributeSyntax> attributes)
    {
        return this.Update(this.LessThanToken, this.Name, attributes, this.GreaterThanToken);
    }

    public XmlElementStartTagSyntax WithGreaterThanToken(SyntaxToken greaterThanToken)
    {
        return this.Update(this.LessThanToken, this.Name, this.Attributes, greaterThanToken);
    }

    public XmlElementStartTagSyntax AddAttributes(params XmlAttributeSyntax[] items)
    {
        return this.WithAttributes(this.Attributes.AddRange(items));
    }
  }

  public sealed partial class XmlElementEndTagSyntax : CSharpSyntaxNode
  {
    private XmlNameSyntax name;

    internal XmlElementEndTagSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken LessThanSlashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlElementEndTagSyntax)this.Green).lessThanSlashToken, this.Position, 0); }
    }

    public XmlNameSyntax Name 
    {
        get
        {
            return this.GetRed(ref this.name, 1);
        }
    }

    public SyntaxToken GreaterThanToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlElementEndTagSyntax)this.Green).greaterThanToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.name, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlElementEndTag(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlElementEndTag(this);
    }

    public XmlElementEndTagSyntax Update(SyntaxToken lessThanSlashToken, XmlNameSyntax name, SyntaxToken greaterThanToken)
    {
        if (lessThanSlashToken != this.LessThanSlashToken || name != this.Name || greaterThanToken != this.GreaterThanToken)
        {
            var newNode = SyntaxFactory.XmlElementEndTag(lessThanSlashToken, name, greaterThanToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlElementEndTagSyntax WithLessThanSlashToken(SyntaxToken lessThanSlashToken)
    {
        return this.Update(lessThanSlashToken, this.Name, this.GreaterThanToken);
    }

    public XmlElementEndTagSyntax WithName(XmlNameSyntax name)
    {
        return this.Update(this.LessThanSlashToken, name, this.GreaterThanToken);
    }

    public XmlElementEndTagSyntax WithGreaterThanToken(SyntaxToken greaterThanToken)
    {
        return this.Update(this.LessThanSlashToken, this.Name, greaterThanToken);
    }
  }

  public sealed partial class XmlEmptyElementSyntax : XmlNodeSyntax
  {
    private XmlNameSyntax name;
    private SyntaxNode attributes;

    internal XmlEmptyElementSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken LessThanToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlEmptyElementSyntax)this.Green).lessThanToken, this.Position, 0); }
    }

    public XmlNameSyntax Name 
    {
        get
        {
            return this.GetRed(ref this.name, 1);
        }
    }

    public SyntaxList<XmlAttributeSyntax> Attributes 
    {
        get
        {
            return new SyntaxList<XmlAttributeSyntax>(this.GetRed(ref this.attributes, 2));
        }
    }

    public SyntaxToken SlashGreaterThanToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlEmptyElementSyntax)this.Green).slashGreaterThanToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.name, 1);
            case 2: return this.GetRed(ref this.attributes, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.name;
            case 2: return this.attributes;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlEmptyElement(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlEmptyElement(this);
    }

    public XmlEmptyElementSyntax Update(SyntaxToken lessThanToken, XmlNameSyntax name, SyntaxList<XmlAttributeSyntax> attributes, SyntaxToken slashGreaterThanToken)
    {
        if (lessThanToken != this.LessThanToken || name != this.Name || attributes != this.Attributes || slashGreaterThanToken != this.SlashGreaterThanToken)
        {
            var newNode = SyntaxFactory.XmlEmptyElement(lessThanToken, name, attributes, slashGreaterThanToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlEmptyElementSyntax WithLessThanToken(SyntaxToken lessThanToken)
    {
        return this.Update(lessThanToken, this.Name, this.Attributes, this.SlashGreaterThanToken);
    }

    public XmlEmptyElementSyntax WithName(XmlNameSyntax name)
    {
        return this.Update(this.LessThanToken, name, this.Attributes, this.SlashGreaterThanToken);
    }

    public XmlEmptyElementSyntax WithAttributes(SyntaxList<XmlAttributeSyntax> attributes)
    {
        return this.Update(this.LessThanToken, this.Name, attributes, this.SlashGreaterThanToken);
    }

    public XmlEmptyElementSyntax WithSlashGreaterThanToken(SyntaxToken slashGreaterThanToken)
    {
        return this.Update(this.LessThanToken, this.Name, this.Attributes, slashGreaterThanToken);
    }

    public XmlEmptyElementSyntax AddAttributes(params XmlAttributeSyntax[] items)
    {
        return this.WithAttributes(this.Attributes.AddRange(items));
    }
  }

  public sealed partial class XmlNameSyntax : CSharpSyntaxNode
  {
    private XmlPrefixSyntax prefix;

    internal XmlNameSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public XmlPrefixSyntax Prefix 
    {
        get
        {
            return this.GetRedAtZero(ref this.prefix);
        }
    }

    public SyntaxToken LocalName 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlNameSyntax)this.Green).localName, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.prefix);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.prefix;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlName(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlName(this);
    }

    public XmlNameSyntax Update(XmlPrefixSyntax prefix, SyntaxToken localName)
    {
        if (prefix != this.Prefix || localName != this.LocalName)
        {
            var newNode = SyntaxFactory.XmlName(prefix, localName);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlNameSyntax WithPrefix(XmlPrefixSyntax prefix)
    {
        return this.Update(prefix, this.LocalName);
    }

    public XmlNameSyntax WithLocalName(SyntaxToken localName)
    {
        return this.Update(this.Prefix, localName);
    }
  }

  public sealed partial class XmlPrefixSyntax : CSharpSyntaxNode
  {
    internal XmlPrefixSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken Prefix 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlPrefixSyntax)this.Green).prefix, this.Position, 0); }
    }

    public SyntaxToken ColonToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlPrefixSyntax)this.Green).colonToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlPrefix(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlPrefix(this);
    }

    public XmlPrefixSyntax Update(SyntaxToken prefix, SyntaxToken colonToken)
    {
        if (prefix != this.Prefix || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.XmlPrefix(prefix, colonToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlPrefixSyntax WithPrefix(SyntaxToken prefix)
    {
        return this.Update(prefix, this.ColonToken);
    }

    public XmlPrefixSyntax WithColonToken(SyntaxToken colonToken)
    {
        return this.Update(this.Prefix, colonToken);
    }
  }

  public abstract partial class XmlAttributeSyntax : CSharpSyntaxNode
  {
    internal XmlAttributeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    public abstract XmlNameSyntax Name { get; }

    public abstract SyntaxToken EqualsToken { get; }

    public abstract SyntaxToken StartQuoteToken { get; }

    public abstract SyntaxToken EndQuoteToken { get; }
  }

  public sealed partial class XmlTextAttributeSyntax : XmlAttributeSyntax
  {
    private XmlNameSyntax name;

    internal XmlTextAttributeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override XmlNameSyntax Name 
    {
        get
        {
            return this.GetRedAtZero(ref this.name);
        }
    }

    public override SyntaxToken EqualsToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlTextAttributeSyntax)this.Green).equalsToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override SyntaxToken StartQuoteToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlTextAttributeSyntax)this.Green).startQuoteToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public SyntaxTokenList TextTokens 
    {
        get
        {
            var slot = this.Green.GetSlot(3);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(3), this.GetChildIndex(3));

            return default(SyntaxTokenList);
        }
    }

    public override SyntaxToken EndQuoteToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlTextAttributeSyntax)this.Green).endQuoteToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.name);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlTextAttribute(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlTextAttribute(this);
    }

    public XmlTextAttributeSyntax Update(XmlNameSyntax name, SyntaxToken equalsToken, SyntaxToken startQuoteToken, SyntaxTokenList textTokens, SyntaxToken endQuoteToken)
    {
        if (name != this.Name || equalsToken != this.EqualsToken || startQuoteToken != this.StartQuoteToken || textTokens != this.TextTokens || endQuoteToken != this.EndQuoteToken)
        {
            var newNode = SyntaxFactory.XmlTextAttribute(name, equalsToken, startQuoteToken, textTokens, endQuoteToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlTextAttributeSyntax WithName(XmlNameSyntax name)
    {
        return this.Update(name, this.EqualsToken, this.StartQuoteToken, this.TextTokens, this.EndQuoteToken);
    }

    public XmlTextAttributeSyntax WithEqualsToken(SyntaxToken equalsToken)
    {
        return this.Update(this.Name, equalsToken, this.StartQuoteToken, this.TextTokens, this.EndQuoteToken);
    }

    public XmlTextAttributeSyntax WithStartQuoteToken(SyntaxToken startQuoteToken)
    {
        return this.Update(this.Name, this.EqualsToken, startQuoteToken, this.TextTokens, this.EndQuoteToken);
    }

    public XmlTextAttributeSyntax WithTextTokens(SyntaxTokenList textTokens)
    {
        return this.Update(this.Name, this.EqualsToken, this.StartQuoteToken, textTokens, this.EndQuoteToken);
    }

    public XmlTextAttributeSyntax WithEndQuoteToken(SyntaxToken endQuoteToken)
    {
        return this.Update(this.Name, this.EqualsToken, this.StartQuoteToken, this.TextTokens, endQuoteToken);
    }

    public XmlTextAttributeSyntax AddTextTokens(params SyntaxToken[] items)
    {
        return this.WithTextTokens(this.TextTokens.AddRange(items));
    }
  }

  public sealed partial class XmlCrefAttributeSyntax : XmlAttributeSyntax
  {
    private XmlNameSyntax name;
    private CrefSyntax cref;

    internal XmlCrefAttributeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override XmlNameSyntax Name 
    {
        get
        {
            return this.GetRedAtZero(ref this.name);
        }
    }

    public override SyntaxToken EqualsToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlCrefAttributeSyntax)this.Green).equalsToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override SyntaxToken StartQuoteToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlCrefAttributeSyntax)this.Green).startQuoteToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public CrefSyntax Cref 
    {
        get
        {
            return this.GetRed(ref this.cref, 3);
        }
    }

    public override SyntaxToken EndQuoteToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlCrefAttributeSyntax)this.Green).endQuoteToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.name);
            case 3: return this.GetRed(ref this.cref, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            case 3: return this.cref;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlCrefAttribute(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlCrefAttribute(this);
    }

    public XmlCrefAttributeSyntax Update(XmlNameSyntax name, SyntaxToken equalsToken, SyntaxToken startQuoteToken, CrefSyntax cref, SyntaxToken endQuoteToken)
    {
        if (name != this.Name || equalsToken != this.EqualsToken || startQuoteToken != this.StartQuoteToken || cref != this.Cref || endQuoteToken != this.EndQuoteToken)
        {
            var newNode = SyntaxFactory.XmlCrefAttribute(name, equalsToken, startQuoteToken, cref, endQuoteToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlCrefAttributeSyntax WithName(XmlNameSyntax name)
    {
        return this.Update(name, this.EqualsToken, this.StartQuoteToken, this.Cref, this.EndQuoteToken);
    }

    public XmlCrefAttributeSyntax WithEqualsToken(SyntaxToken equalsToken)
    {
        return this.Update(this.Name, equalsToken, this.StartQuoteToken, this.Cref, this.EndQuoteToken);
    }

    public XmlCrefAttributeSyntax WithStartQuoteToken(SyntaxToken startQuoteToken)
    {
        return this.Update(this.Name, this.EqualsToken, startQuoteToken, this.Cref, this.EndQuoteToken);
    }

    public XmlCrefAttributeSyntax WithCref(CrefSyntax cref)
    {
        return this.Update(this.Name, this.EqualsToken, this.StartQuoteToken, cref, this.EndQuoteToken);
    }

    public XmlCrefAttributeSyntax WithEndQuoteToken(SyntaxToken endQuoteToken)
    {
        return this.Update(this.Name, this.EqualsToken, this.StartQuoteToken, this.Cref, endQuoteToken);
    }
  }

  public sealed partial class XmlNameAttributeSyntax : XmlAttributeSyntax
  {
    private XmlNameSyntax name;
    private IdentifierNameSyntax identifier;

    internal XmlNameAttributeSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override XmlNameSyntax Name 
    {
        get
        {
            return this.GetRedAtZero(ref this.name);
        }
    }

    public override SyntaxToken EqualsToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlNameAttributeSyntax)this.Green).equalsToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override SyntaxToken StartQuoteToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlNameAttributeSyntax)this.Green).startQuoteToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public IdentifierNameSyntax Identifier 
    {
        get
        {
            return this.GetRed(ref this.identifier, 3);
        }
    }

    public override SyntaxToken EndQuoteToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlNameAttributeSyntax)this.Green).endQuoteToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return this.GetRedAtZero(ref this.name);
            case 3: return this.GetRed(ref this.identifier, 3);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            case 3: return this.identifier;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlNameAttribute(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlNameAttribute(this);
    }

    public XmlNameAttributeSyntax Update(XmlNameSyntax name, SyntaxToken equalsToken, SyntaxToken startQuoteToken, IdentifierNameSyntax identifier, SyntaxToken endQuoteToken)
    {
        if (name != this.Name || equalsToken != this.EqualsToken || startQuoteToken != this.StartQuoteToken || identifier != this.Identifier || endQuoteToken != this.EndQuoteToken)
        {
            var newNode = SyntaxFactory.XmlNameAttribute(name, equalsToken, startQuoteToken, identifier, endQuoteToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlNameAttributeSyntax WithName(XmlNameSyntax name)
    {
        return this.Update(name, this.EqualsToken, this.StartQuoteToken, this.Identifier, this.EndQuoteToken);
    }

    public XmlNameAttributeSyntax WithEqualsToken(SyntaxToken equalsToken)
    {
        return this.Update(this.Name, equalsToken, this.StartQuoteToken, this.Identifier, this.EndQuoteToken);
    }

    public XmlNameAttributeSyntax WithStartQuoteToken(SyntaxToken startQuoteToken)
    {
        return this.Update(this.Name, this.EqualsToken, startQuoteToken, this.Identifier, this.EndQuoteToken);
    }

    public XmlNameAttributeSyntax WithIdentifier(IdentifierNameSyntax identifier)
    {
        return this.Update(this.Name, this.EqualsToken, this.StartQuoteToken, identifier, this.EndQuoteToken);
    }

    public XmlNameAttributeSyntax WithEndQuoteToken(SyntaxToken endQuoteToken)
    {
        return this.Update(this.Name, this.EqualsToken, this.StartQuoteToken, this.Identifier, endQuoteToken);
    }
  }

  public sealed partial class XmlTextSyntax : XmlNodeSyntax
  {
    internal XmlTextSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxTokenList TextTokens 
    {
        get
        {
            var slot = this.Green.GetSlot(0);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.Position, 0);

            return default(SyntaxTokenList);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlText(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlText(this);
    }

    public XmlTextSyntax Update(SyntaxTokenList textTokens)
    {
        if (textTokens != this.TextTokens)
        {
            var newNode = SyntaxFactory.XmlText(textTokens);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlTextSyntax WithTextTokens(SyntaxTokenList textTokens)
    {
        return this.Update(textTokens);
    }

    public XmlTextSyntax AddTextTokens(params SyntaxToken[] items)
    {
        return this.WithTextTokens(this.TextTokens.AddRange(items));
    }
  }

  public sealed partial class XmlCDataSectionSyntax : XmlNodeSyntax
  {
    internal XmlCDataSectionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken StartCDataToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlCDataSectionSyntax)this.Green).startCDataToken, this.Position, 0); }
    }

    public SyntaxTokenList TextTokens 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    public SyntaxToken EndCDataToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlCDataSectionSyntax)this.Green).endCDataToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlCDataSection(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlCDataSection(this);
    }

    public XmlCDataSectionSyntax Update(SyntaxToken startCDataToken, SyntaxTokenList textTokens, SyntaxToken endCDataToken)
    {
        if (startCDataToken != this.StartCDataToken || textTokens != this.TextTokens || endCDataToken != this.EndCDataToken)
        {
            var newNode = SyntaxFactory.XmlCDataSection(startCDataToken, textTokens, endCDataToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlCDataSectionSyntax WithStartCDataToken(SyntaxToken startCDataToken)
    {
        return this.Update(startCDataToken, this.TextTokens, this.EndCDataToken);
    }

    public XmlCDataSectionSyntax WithTextTokens(SyntaxTokenList textTokens)
    {
        return this.Update(this.StartCDataToken, textTokens, this.EndCDataToken);
    }

    public XmlCDataSectionSyntax WithEndCDataToken(SyntaxToken endCDataToken)
    {
        return this.Update(this.StartCDataToken, this.TextTokens, endCDataToken);
    }

    public XmlCDataSectionSyntax AddTextTokens(params SyntaxToken[] items)
    {
        return this.WithTextTokens(this.TextTokens.AddRange(items));
    }
  }

  public sealed partial class XmlProcessingInstructionSyntax : XmlNodeSyntax
  {
    private XmlNameSyntax name;

    internal XmlProcessingInstructionSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken StartProcessingInstructionToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlProcessingInstructionSyntax)this.Green).startProcessingInstructionToken, this.Position, 0); }
    }

    public XmlNameSyntax Name 
    {
        get
        {
            return this.GetRed(ref this.name, 1);
        }
    }

    public SyntaxTokenList TextTokens 
    {
        get
        {
            var slot = this.Green.GetSlot(2);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(2), this.GetChildIndex(2));

            return default(SyntaxTokenList);
        }
    }

    public SyntaxToken EndProcessingInstructionToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlProcessingInstructionSyntax)this.Green).endProcessingInstructionToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 1: return this.GetRed(ref this.name, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 1: return this.name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlProcessingInstruction(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlProcessingInstruction(this);
    }

    public XmlProcessingInstructionSyntax Update(SyntaxToken startProcessingInstructionToken, XmlNameSyntax name, SyntaxTokenList textTokens, SyntaxToken endProcessingInstructionToken)
    {
        if (startProcessingInstructionToken != this.StartProcessingInstructionToken || name != this.Name || textTokens != this.TextTokens || endProcessingInstructionToken != this.EndProcessingInstructionToken)
        {
            var newNode = SyntaxFactory.XmlProcessingInstruction(startProcessingInstructionToken, name, textTokens, endProcessingInstructionToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlProcessingInstructionSyntax WithStartProcessingInstructionToken(SyntaxToken startProcessingInstructionToken)
    {
        return this.Update(startProcessingInstructionToken, this.Name, this.TextTokens, this.EndProcessingInstructionToken);
    }

    public XmlProcessingInstructionSyntax WithName(XmlNameSyntax name)
    {
        return this.Update(this.StartProcessingInstructionToken, name, this.TextTokens, this.EndProcessingInstructionToken);
    }

    public XmlProcessingInstructionSyntax WithTextTokens(SyntaxTokenList textTokens)
    {
        return this.Update(this.StartProcessingInstructionToken, this.Name, textTokens, this.EndProcessingInstructionToken);
    }

    public XmlProcessingInstructionSyntax WithEndProcessingInstructionToken(SyntaxToken endProcessingInstructionToken)
    {
        return this.Update(this.StartProcessingInstructionToken, this.Name, this.TextTokens, endProcessingInstructionToken);
    }

    public XmlProcessingInstructionSyntax AddTextTokens(params SyntaxToken[] items)
    {
        return this.WithTextTokens(this.TextTokens.AddRange(items));
    }
  }

  public sealed partial class XmlCommentSyntax : XmlNodeSyntax
  {
    internal XmlCommentSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken LessThanExclamationMinusMinusToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlCommentSyntax)this.Green).lessThanExclamationMinusMinusToken, this.Position, 0); }
    }

    public SyntaxTokenList TextTokens 
    {
        get
        {
            var slot = this.Green.GetSlot(1);
            if (slot != null)
                return new SyntaxTokenList(this, slot, this.GetChildPosition(1), this.GetChildIndex(1));

            return default(SyntaxTokenList);
        }
    }

    public SyntaxToken MinusMinusGreaterThanToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.XmlCommentSyntax)this.Green).minusMinusGreaterThanToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitXmlComment(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitXmlComment(this);
    }

    public XmlCommentSyntax Update(SyntaxToken lessThanExclamationMinusMinusToken, SyntaxTokenList textTokens, SyntaxToken minusMinusGreaterThanToken)
    {
        if (lessThanExclamationMinusMinusToken != this.LessThanExclamationMinusMinusToken || textTokens != this.TextTokens || minusMinusGreaterThanToken != this.MinusMinusGreaterThanToken)
        {
            var newNode = SyntaxFactory.XmlComment(lessThanExclamationMinusMinusToken, textTokens, minusMinusGreaterThanToken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public XmlCommentSyntax WithLessThanExclamationMinusMinusToken(SyntaxToken lessThanExclamationMinusMinusToken)
    {
        return this.Update(lessThanExclamationMinusMinusToken, this.TextTokens, this.MinusMinusGreaterThanToken);
    }

    public XmlCommentSyntax WithTextTokens(SyntaxTokenList textTokens)
    {
        return this.Update(this.LessThanExclamationMinusMinusToken, textTokens, this.MinusMinusGreaterThanToken);
    }

    public XmlCommentSyntax WithMinusMinusGreaterThanToken(SyntaxToken minusMinusGreaterThanToken)
    {
        return this.Update(this.LessThanExclamationMinusMinusToken, this.TextTokens, minusMinusGreaterThanToken);
    }

    public XmlCommentSyntax AddTextTokens(params SyntaxToken[] items)
    {
        return this.WithTextTokens(this.TextTokens.AddRange(items));
    }
  }

  public abstract partial class DirectiveTriviaSyntax : StructuredTriviaSyntax
  {
    internal DirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    public abstract SyntaxToken HashToken { get; }

    public abstract SyntaxToken EndOfDirectiveToken { get; }

    public abstract bool IsActive { get; }
  }

  public abstract partial class BranchingDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal BranchingDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    public abstract bool BranchTaken { get; }
  }

  public abstract partial class ConditionalDirectiveTriviaSyntax : BranchingDirectiveTriviaSyntax
  {
    internal ConditionalDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    public abstract ExpressionSyntax Condition { get; }

    public abstract bool ConditionValue { get; }
  }

  public sealed partial class IfDirectiveTriviaSyntax : ConditionalDirectiveTriviaSyntax
  {
    private ExpressionSyntax condition;

    internal IfDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IfDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken IfKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IfDirectiveTriviaSyntax)this.Green).ifKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override ExpressionSyntax Condition 
    {
        get
        {
            return this.GetRed(ref this.condition, 2);
        }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IfDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IfDirectiveTriviaSyntax)this.Green).IsActive; } }

    public override bool BranchTaken { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IfDirectiveTriviaSyntax)this.Green).BranchTaken; } }

    public override bool ConditionValue { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.IfDirectiveTriviaSyntax)this.Green).ConditionValue; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.condition, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.condition;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitIfDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitIfDirectiveTrivia(this);
    }

    public IfDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken ifKeyword, ExpressionSyntax condition, SyntaxToken endOfDirectiveToken, bool isActive, bool branchTaken, bool conditionValue)
    {
        if (hashToken != this.HashToken || ifKeyword != this.IfKeyword || condition != this.Condition || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.IfDirectiveTrivia(hashToken, ifKeyword, condition, endOfDirectiveToken, isActive, branchTaken, conditionValue);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public IfDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.IfKeyword, this.Condition, this.EndOfDirectiveToken, this.IsActive, this.BranchTaken, this.ConditionValue);
    }

    public IfDirectiveTriviaSyntax WithIfKeyword(SyntaxToken ifKeyword)
    {
        return this.Update(this.HashToken, ifKeyword, this.Condition, this.EndOfDirectiveToken, this.IsActive, this.BranchTaken, this.ConditionValue);
    }

    public IfDirectiveTriviaSyntax WithCondition(ExpressionSyntax condition)
    {
        return this.Update(this.HashToken, this.IfKeyword, condition, this.EndOfDirectiveToken, this.IsActive, this.BranchTaken, this.ConditionValue);
    }

    public IfDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.IfKeyword, this.Condition, endOfDirectiveToken, this.IsActive, this.BranchTaken, this.ConditionValue);
    }

    public IfDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.IfKeyword, this.Condition, this.EndOfDirectiveToken, isActive, this.BranchTaken, this.ConditionValue);
    }

    public IfDirectiveTriviaSyntax WithBranchTaken(bool branchTaken)
    {
        return this.Update(this.HashToken, this.IfKeyword, this.Condition, this.EndOfDirectiveToken, this.IsActive, branchTaken, this.ConditionValue);
    }

    public IfDirectiveTriviaSyntax WithConditionValue(bool conditionValue)
    {
        return this.Update(this.HashToken, this.IfKeyword, this.Condition, this.EndOfDirectiveToken, this.IsActive, this.BranchTaken, conditionValue);
    }
  }

  public sealed partial class ElifDirectiveTriviaSyntax : ConditionalDirectiveTriviaSyntax
  {
    private ExpressionSyntax condition;

    internal ElifDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElifDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken ElifKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElifDirectiveTriviaSyntax)this.Green).elifKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override ExpressionSyntax Condition 
    {
        get
        {
            return this.GetRed(ref this.condition, 2);
        }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElifDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElifDirectiveTriviaSyntax)this.Green).IsActive; } }

    public override bool BranchTaken { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElifDirectiveTriviaSyntax)this.Green).BranchTaken; } }

    public override bool ConditionValue { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElifDirectiveTriviaSyntax)this.Green).ConditionValue; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 2: return this.GetRed(ref this.condition, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 2: return this.condition;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitElifDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitElifDirectiveTrivia(this);
    }

    public ElifDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken elifKeyword, ExpressionSyntax condition, SyntaxToken endOfDirectiveToken, bool isActive, bool branchTaken, bool conditionValue)
    {
        if (hashToken != this.HashToken || elifKeyword != this.ElifKeyword || condition != this.Condition || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.ElifDirectiveTrivia(hashToken, elifKeyword, condition, endOfDirectiveToken, isActive, branchTaken, conditionValue);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ElifDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.ElifKeyword, this.Condition, this.EndOfDirectiveToken, this.IsActive, this.BranchTaken, this.ConditionValue);
    }

    public ElifDirectiveTriviaSyntax WithElifKeyword(SyntaxToken elifKeyword)
    {
        return this.Update(this.HashToken, elifKeyword, this.Condition, this.EndOfDirectiveToken, this.IsActive, this.BranchTaken, this.ConditionValue);
    }

    public ElifDirectiveTriviaSyntax WithCondition(ExpressionSyntax condition)
    {
        return this.Update(this.HashToken, this.ElifKeyword, condition, this.EndOfDirectiveToken, this.IsActive, this.BranchTaken, this.ConditionValue);
    }

    public ElifDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.ElifKeyword, this.Condition, endOfDirectiveToken, this.IsActive, this.BranchTaken, this.ConditionValue);
    }

    public ElifDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.ElifKeyword, this.Condition, this.EndOfDirectiveToken, isActive, this.BranchTaken, this.ConditionValue);
    }

    public ElifDirectiveTriviaSyntax WithBranchTaken(bool branchTaken)
    {
        return this.Update(this.HashToken, this.ElifKeyword, this.Condition, this.EndOfDirectiveToken, this.IsActive, branchTaken, this.ConditionValue);
    }

    public ElifDirectiveTriviaSyntax WithConditionValue(bool conditionValue)
    {
        return this.Update(this.HashToken, this.ElifKeyword, this.Condition, this.EndOfDirectiveToken, this.IsActive, this.BranchTaken, conditionValue);
    }
  }

  public sealed partial class ElseDirectiveTriviaSyntax : BranchingDirectiveTriviaSyntax
  {
    internal ElseDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElseDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken ElseKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElseDirectiveTriviaSyntax)this.Green).elseKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElseDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElseDirectiveTriviaSyntax)this.Green).IsActive; } }

    public override bool BranchTaken { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ElseDirectiveTriviaSyntax)this.Green).BranchTaken; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitElseDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitElseDirectiveTrivia(this);
    }

    public ElseDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken elseKeyword, SyntaxToken endOfDirectiveToken, bool isActive, bool branchTaken)
    {
        if (hashToken != this.HashToken || elseKeyword != this.ElseKeyword || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.ElseDirectiveTrivia(hashToken, elseKeyword, endOfDirectiveToken, isActive, branchTaken);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ElseDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.ElseKeyword, this.EndOfDirectiveToken, this.IsActive, this.BranchTaken);
    }

    public ElseDirectiveTriviaSyntax WithElseKeyword(SyntaxToken elseKeyword)
    {
        return this.Update(this.HashToken, elseKeyword, this.EndOfDirectiveToken, this.IsActive, this.BranchTaken);
    }

    public ElseDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.ElseKeyword, endOfDirectiveToken, this.IsActive, this.BranchTaken);
    }

    public ElseDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.ElseKeyword, this.EndOfDirectiveToken, isActive, this.BranchTaken);
    }

    public ElseDirectiveTriviaSyntax WithBranchTaken(bool branchTaken)
    {
        return this.Update(this.HashToken, this.ElseKeyword, this.EndOfDirectiveToken, this.IsActive, branchTaken);
    }
  }

  public sealed partial class EndIfDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal EndIfDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EndIfDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken EndIfKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EndIfDirectiveTriviaSyntax)this.Green).endIfKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EndIfDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EndIfDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitEndIfDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitEndIfDirectiveTrivia(this);
    }

    public EndIfDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken endIfKeyword, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || endIfKeyword != this.EndIfKeyword || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.EndIfDirectiveTrivia(hashToken, endIfKeyword, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public EndIfDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.EndIfKeyword, this.EndOfDirectiveToken, this.IsActive);
    }

    public EndIfDirectiveTriviaSyntax WithEndIfKeyword(SyntaxToken endIfKeyword)
    {
        return this.Update(this.HashToken, endIfKeyword, this.EndOfDirectiveToken, this.IsActive);
    }

    public EndIfDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.EndIfKeyword, endOfDirectiveToken, this.IsActive);
    }

    public EndIfDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.EndIfKeyword, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class RegionDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal RegionDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RegionDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken RegionKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RegionDirectiveTriviaSyntax)this.Green).regionKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RegionDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.RegionDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRegionDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitRegionDirectiveTrivia(this);
    }

    public RegionDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken regionKeyword, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || regionKeyword != this.RegionKeyword || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.RegionDirectiveTrivia(hashToken, regionKeyword, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public RegionDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.RegionKeyword, this.EndOfDirectiveToken, this.IsActive);
    }

    public RegionDirectiveTriviaSyntax WithRegionKeyword(SyntaxToken regionKeyword)
    {
        return this.Update(this.HashToken, regionKeyword, this.EndOfDirectiveToken, this.IsActive);
    }

    public RegionDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.RegionKeyword, endOfDirectiveToken, this.IsActive);
    }

    public RegionDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.RegionKeyword, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class EndRegionDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal EndRegionDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EndRegionDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken EndRegionKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EndRegionDirectiveTriviaSyntax)this.Green).endRegionKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EndRegionDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.EndRegionDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitEndRegionDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitEndRegionDirectiveTrivia(this);
    }

    public EndRegionDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken endRegionKeyword, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || endRegionKeyword != this.EndRegionKeyword || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.EndRegionDirectiveTrivia(hashToken, endRegionKeyword, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public EndRegionDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.EndRegionKeyword, this.EndOfDirectiveToken, this.IsActive);
    }

    public EndRegionDirectiveTriviaSyntax WithEndRegionKeyword(SyntaxToken endRegionKeyword)
    {
        return this.Update(this.HashToken, endRegionKeyword, this.EndOfDirectiveToken, this.IsActive);
    }

    public EndRegionDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.EndRegionKeyword, endOfDirectiveToken, this.IsActive);
    }

    public EndRegionDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.EndRegionKeyword, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class ErrorDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal ErrorDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ErrorDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken ErrorKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ErrorDirectiveTriviaSyntax)this.Green).errorKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ErrorDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ErrorDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitErrorDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitErrorDirectiveTrivia(this);
    }

    public ErrorDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken errorKeyword, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || errorKeyword != this.ErrorKeyword || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.ErrorDirectiveTrivia(hashToken, errorKeyword, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ErrorDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.ErrorKeyword, this.EndOfDirectiveToken, this.IsActive);
    }

    public ErrorDirectiveTriviaSyntax WithErrorKeyword(SyntaxToken errorKeyword)
    {
        return this.Update(this.HashToken, errorKeyword, this.EndOfDirectiveToken, this.IsActive);
    }

    public ErrorDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.ErrorKeyword, endOfDirectiveToken, this.IsActive);
    }

    public ErrorDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.ErrorKeyword, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class WarningDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal WarningDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.WarningDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken WarningKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.WarningDirectiveTriviaSyntax)this.Green).warningKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.WarningDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.WarningDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitWarningDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitWarningDirectiveTrivia(this);
    }

    public WarningDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken warningKeyword, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || warningKeyword != this.WarningKeyword || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.WarningDirectiveTrivia(hashToken, warningKeyword, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public WarningDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.WarningKeyword, this.EndOfDirectiveToken, this.IsActive);
    }

    public WarningDirectiveTriviaSyntax WithWarningKeyword(SyntaxToken warningKeyword)
    {
        return this.Update(this.HashToken, warningKeyword, this.EndOfDirectiveToken, this.IsActive);
    }

    public WarningDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.WarningKeyword, endOfDirectiveToken, this.IsActive);
    }

    public WarningDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.WarningKeyword, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class BadDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal BadDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BadDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken Identifier 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BadDirectiveTriviaSyntax)this.Green).identifier, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BadDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.BadDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitBadDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitBadDirectiveTrivia(this);
    }

    public BadDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken identifier, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || identifier != this.Identifier || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.BadDirectiveTrivia(hashToken, identifier, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public BadDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.Identifier, this.EndOfDirectiveToken, this.IsActive);
    }

    public BadDirectiveTriviaSyntax WithIdentifier(SyntaxToken identifier)
    {
        return this.Update(this.HashToken, identifier, this.EndOfDirectiveToken, this.IsActive);
    }

    public BadDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.Identifier, endOfDirectiveToken, this.IsActive);
    }

    public BadDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.Identifier, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class DefineDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal DefineDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DefineDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken DefineKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DefineDirectiveTriviaSyntax)this.Green).defineKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public SyntaxToken Name 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DefineDirectiveTriviaSyntax)this.Green).name, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DefineDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.DefineDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitDefineDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitDefineDirectiveTrivia(this);
    }

    public DefineDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken defineKeyword, SyntaxToken name, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || defineKeyword != this.DefineKeyword || name != this.Name || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.DefineDirectiveTrivia(hashToken, defineKeyword, name, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public DefineDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.DefineKeyword, this.Name, this.EndOfDirectiveToken, this.IsActive);
    }

    public DefineDirectiveTriviaSyntax WithDefineKeyword(SyntaxToken defineKeyword)
    {
        return this.Update(this.HashToken, defineKeyword, this.Name, this.EndOfDirectiveToken, this.IsActive);
    }

    public DefineDirectiveTriviaSyntax WithName(SyntaxToken name)
    {
        return this.Update(this.HashToken, this.DefineKeyword, name, this.EndOfDirectiveToken, this.IsActive);
    }

    public DefineDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.DefineKeyword, this.Name, endOfDirectiveToken, this.IsActive);
    }

    public DefineDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.DefineKeyword, this.Name, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class UndefDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal UndefDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UndefDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken UndefKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UndefDirectiveTriviaSyntax)this.Green).undefKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public SyntaxToken Name 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UndefDirectiveTriviaSyntax)this.Green).name, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UndefDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.UndefDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitUndefDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitUndefDirectiveTrivia(this);
    }

    public UndefDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken undefKeyword, SyntaxToken name, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || undefKeyword != this.UndefKeyword || name != this.Name || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.UndefDirectiveTrivia(hashToken, undefKeyword, name, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public UndefDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.UndefKeyword, this.Name, this.EndOfDirectiveToken, this.IsActive);
    }

    public UndefDirectiveTriviaSyntax WithUndefKeyword(SyntaxToken undefKeyword)
    {
        return this.Update(this.HashToken, undefKeyword, this.Name, this.EndOfDirectiveToken, this.IsActive);
    }

    public UndefDirectiveTriviaSyntax WithName(SyntaxToken name)
    {
        return this.Update(this.HashToken, this.UndefKeyword, name, this.EndOfDirectiveToken, this.IsActive);
    }

    public UndefDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.UndefKeyword, this.Name, endOfDirectiveToken, this.IsActive);
    }

    public UndefDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.UndefKeyword, this.Name, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class LineDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal LineDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LineDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken LineKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LineDirectiveTriviaSyntax)this.Green).lineKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public SyntaxToken Line 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LineDirectiveTriviaSyntax)this.Green).line, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public SyntaxToken File 
    {
        get
        {
            var slot = ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LineDirectiveTriviaSyntax)this.Green).file;
            if (slot != null)
                return new SyntaxToken(this, slot, this.GetChildPosition(3), this.GetChildIndex(3));

            return default(SyntaxToken);
        }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LineDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LineDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitLineDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitLineDirectiveTrivia(this);
    }

    public LineDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken lineKeyword, SyntaxToken line, SyntaxToken file, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || lineKeyword != this.LineKeyword || line != this.Line || file != this.File || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.LineDirectiveTrivia(hashToken, lineKeyword, line, file, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public LineDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.LineKeyword, this.Line, this.File, this.EndOfDirectiveToken, this.IsActive);
    }

    public LineDirectiveTriviaSyntax WithLineKeyword(SyntaxToken lineKeyword)
    {
        return this.Update(this.HashToken, lineKeyword, this.Line, this.File, this.EndOfDirectiveToken, this.IsActive);
    }

    public LineDirectiveTriviaSyntax WithLine(SyntaxToken line)
    {
        return this.Update(this.HashToken, this.LineKeyword, line, this.File, this.EndOfDirectiveToken, this.IsActive);
    }

    public LineDirectiveTriviaSyntax WithFile(SyntaxToken file)
    {
        return this.Update(this.HashToken, this.LineKeyword, this.Line, file, this.EndOfDirectiveToken, this.IsActive);
    }

    public LineDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.LineKeyword, this.Line, this.File, endOfDirectiveToken, this.IsActive);
    }

    public LineDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.LineKeyword, this.Line, this.File, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class PragmaWarningDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    private SyntaxNode errorCodes;

    internal PragmaWarningDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaWarningDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken PragmaKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaWarningDirectiveTriviaSyntax)this.Green).pragmaKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public SyntaxToken WarningKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaWarningDirectiveTriviaSyntax)this.Green).warningKeyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public SyntaxToken DisableOrRestoreKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaWarningDirectiveTriviaSyntax)this.Green).disableOrRestoreKeyword, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public SeparatedSyntaxList<ExpressionSyntax> ErrorCodes 
    {
        get
        {
            var red = this.GetRed(ref this.errorCodes, 4);
            if (red != null)
                return new SeparatedSyntaxList<ExpressionSyntax>(red, this.GetChildIndex(4));

            return default(SeparatedSyntaxList<ExpressionSyntax>);
        }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaWarningDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(5), this.GetChildIndex(5)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaWarningDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 4: return this.GetRed(ref this.errorCodes, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 4: return this.errorCodes;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitPragmaWarningDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitPragmaWarningDirectiveTrivia(this);
    }

    public PragmaWarningDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken pragmaKeyword, SyntaxToken warningKeyword, SyntaxToken disableOrRestoreKeyword, SeparatedSyntaxList<ExpressionSyntax> errorCodes, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || pragmaKeyword != this.PragmaKeyword || warningKeyword != this.WarningKeyword || disableOrRestoreKeyword != this.DisableOrRestoreKeyword || errorCodes != this.ErrorCodes || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.PragmaWarningDirectiveTrivia(hashToken, pragmaKeyword, warningKeyword, disableOrRestoreKeyword, errorCodes, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public PragmaWarningDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.PragmaKeyword, this.WarningKeyword, this.DisableOrRestoreKeyword, this.ErrorCodes, this.EndOfDirectiveToken, this.IsActive);
    }

    public PragmaWarningDirectiveTriviaSyntax WithPragmaKeyword(SyntaxToken pragmaKeyword)
    {
        return this.Update(this.HashToken, pragmaKeyword, this.WarningKeyword, this.DisableOrRestoreKeyword, this.ErrorCodes, this.EndOfDirectiveToken, this.IsActive);
    }

    public PragmaWarningDirectiveTriviaSyntax WithWarningKeyword(SyntaxToken warningKeyword)
    {
        return this.Update(this.HashToken, this.PragmaKeyword, warningKeyword, this.DisableOrRestoreKeyword, this.ErrorCodes, this.EndOfDirectiveToken, this.IsActive);
    }

    public PragmaWarningDirectiveTriviaSyntax WithDisableOrRestoreKeyword(SyntaxToken disableOrRestoreKeyword)
    {
        return this.Update(this.HashToken, this.PragmaKeyword, this.WarningKeyword, disableOrRestoreKeyword, this.ErrorCodes, this.EndOfDirectiveToken, this.IsActive);
    }

    public PragmaWarningDirectiveTriviaSyntax WithErrorCodes(SeparatedSyntaxList<ExpressionSyntax> errorCodes)
    {
        return this.Update(this.HashToken, this.PragmaKeyword, this.WarningKeyword, this.DisableOrRestoreKeyword, errorCodes, this.EndOfDirectiveToken, this.IsActive);
    }

    public PragmaWarningDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.PragmaKeyword, this.WarningKeyword, this.DisableOrRestoreKeyword, this.ErrorCodes, endOfDirectiveToken, this.IsActive);
    }

    public PragmaWarningDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.PragmaKeyword, this.WarningKeyword, this.DisableOrRestoreKeyword, this.ErrorCodes, this.EndOfDirectiveToken, isActive);
    }

    public PragmaWarningDirectiveTriviaSyntax AddErrorCodes(params ExpressionSyntax[] items)
    {
        return this.WithErrorCodes(this.ErrorCodes.AddRange(items));
    }
  }

  public sealed partial class PragmaChecksumDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal PragmaChecksumDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaChecksumDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken PragmaKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaChecksumDirectiveTriviaSyntax)this.Green).pragmaKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public SyntaxToken ChecksumKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaChecksumDirectiveTriviaSyntax)this.Green).checksumKeyword, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public SyntaxToken File 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaChecksumDirectiveTriviaSyntax)this.Green).file, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public SyntaxToken Guid 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaChecksumDirectiveTriviaSyntax)this.Green).guid, this.GetChildPosition(4), this.GetChildIndex(4)); }
    }

    public SyntaxToken Bytes 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaChecksumDirectiveTriviaSyntax)this.Green).bytes, this.GetChildPosition(5), this.GetChildIndex(5)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaChecksumDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(6), this.GetChildIndex(6)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.PragmaChecksumDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitPragmaChecksumDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitPragmaChecksumDirectiveTrivia(this);
    }

    public PragmaChecksumDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken pragmaKeyword, SyntaxToken checksumKeyword, SyntaxToken file, SyntaxToken guid, SyntaxToken bytes, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || pragmaKeyword != this.PragmaKeyword || checksumKeyword != this.ChecksumKeyword || file != this.File || guid != this.Guid || bytes != this.Bytes || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.PragmaChecksumDirectiveTrivia(hashToken, pragmaKeyword, checksumKeyword, file, guid, bytes, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public PragmaChecksumDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.PragmaKeyword, this.ChecksumKeyword, this.File, this.Guid, this.Bytes, this.EndOfDirectiveToken, this.IsActive);
    }

    public PragmaChecksumDirectiveTriviaSyntax WithPragmaKeyword(SyntaxToken pragmaKeyword)
    {
        return this.Update(this.HashToken, pragmaKeyword, this.ChecksumKeyword, this.File, this.Guid, this.Bytes, this.EndOfDirectiveToken, this.IsActive);
    }

    public PragmaChecksumDirectiveTriviaSyntax WithChecksumKeyword(SyntaxToken checksumKeyword)
    {
        return this.Update(this.HashToken, this.PragmaKeyword, checksumKeyword, this.File, this.Guid, this.Bytes, this.EndOfDirectiveToken, this.IsActive);
    }

    public PragmaChecksumDirectiveTriviaSyntax WithFile(SyntaxToken file)
    {
        return this.Update(this.HashToken, this.PragmaKeyword, this.ChecksumKeyword, file, this.Guid, this.Bytes, this.EndOfDirectiveToken, this.IsActive);
    }

    public PragmaChecksumDirectiveTriviaSyntax WithGuid(SyntaxToken guid)
    {
        return this.Update(this.HashToken, this.PragmaKeyword, this.ChecksumKeyword, this.File, guid, this.Bytes, this.EndOfDirectiveToken, this.IsActive);
    }

    public PragmaChecksumDirectiveTriviaSyntax WithBytes(SyntaxToken bytes)
    {
        return this.Update(this.HashToken, this.PragmaKeyword, this.ChecksumKeyword, this.File, this.Guid, bytes, this.EndOfDirectiveToken, this.IsActive);
    }

    public PragmaChecksumDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.PragmaKeyword, this.ChecksumKeyword, this.File, this.Guid, this.Bytes, endOfDirectiveToken, this.IsActive);
    }

    public PragmaChecksumDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.PragmaKeyword, this.ChecksumKeyword, this.File, this.Guid, this.Bytes, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class ReferenceDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal ReferenceDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ReferenceDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken ReferenceKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ReferenceDirectiveTriviaSyntax)this.Green).referenceKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public SyntaxToken File 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ReferenceDirectiveTriviaSyntax)this.Green).file, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ReferenceDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ReferenceDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitReferenceDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitReferenceDirectiveTrivia(this);
    }

    public ReferenceDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken referenceKeyword, SyntaxToken file, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || referenceKeyword != this.ReferenceKeyword || file != this.File || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.ReferenceDirectiveTrivia(hashToken, referenceKeyword, file, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ReferenceDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.ReferenceKeyword, this.File, this.EndOfDirectiveToken, this.IsActive);
    }

    public ReferenceDirectiveTriviaSyntax WithReferenceKeyword(SyntaxToken referenceKeyword)
    {
        return this.Update(this.HashToken, referenceKeyword, this.File, this.EndOfDirectiveToken, this.IsActive);
    }

    public ReferenceDirectiveTriviaSyntax WithFile(SyntaxToken file)
    {
        return this.Update(this.HashToken, this.ReferenceKeyword, file, this.EndOfDirectiveToken, this.IsActive);
    }

    public ReferenceDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.ReferenceKeyword, this.File, endOfDirectiveToken, this.IsActive);
    }

    public ReferenceDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.ReferenceKeyword, this.File, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class LoadDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal LoadDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LoadDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken LoadKeyword 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LoadDirectiveTriviaSyntax)this.Green).loadKeyword, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public SyntaxToken File 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LoadDirectiveTriviaSyntax)this.Green).file, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LoadDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(3), this.GetChildIndex(3)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.LoadDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitLoadDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitLoadDirectiveTrivia(this);
    }

    public LoadDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken loadKeyword, SyntaxToken file, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || loadKeyword != this.LoadKeyword || file != this.File || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.LoadDirectiveTrivia(hashToken, loadKeyword, file, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public LoadDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.LoadKeyword, this.File, this.EndOfDirectiveToken, this.IsActive);
    }

    public LoadDirectiveTriviaSyntax WithLoadKeyword(SyntaxToken loadKeyword)
    {
        return this.Update(this.HashToken, loadKeyword, this.File, this.EndOfDirectiveToken, this.IsActive);
    }

    public LoadDirectiveTriviaSyntax WithFile(SyntaxToken file)
    {
        return this.Update(this.HashToken, this.LoadKeyword, file, this.EndOfDirectiveToken, this.IsActive);
    }

    public LoadDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.LoadKeyword, this.File, endOfDirectiveToken, this.IsActive);
    }

    public LoadDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.LoadKeyword, this.File, this.EndOfDirectiveToken, isActive);
    }
  }

  public sealed partial class ShebangDirectiveTriviaSyntax : DirectiveTriviaSyntax
  {
    internal ShebangDirectiveTriviaSyntax(Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.CSharpSyntaxNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken HashToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ShebangDirectiveTriviaSyntax)this.Green).hashToken, this.Position, 0); }
    }

    public SyntaxToken ExclamationToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ShebangDirectiveTriviaSyntax)this.Green).exclamationToken, this.GetChildPosition(1), this.GetChildIndex(1)); }
    }

    public override SyntaxToken EndOfDirectiveToken 
    {
      get { return new SyntaxToken(this, ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ShebangDirectiveTriviaSyntax)this.Green).endOfDirectiveToken, this.GetChildPosition(2), this.GetChildIndex(2)); }
    }

    public override bool IsActive { get { return ((Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax.ShebangDirectiveTriviaSyntax)this.Green).IsActive; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            default: return null;
        }
    }

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitShebangDirectiveTrivia(this);
    }

    public override void Accept(CSharpSyntaxVisitor visitor)
    {
        visitor.VisitShebangDirectiveTrivia(this);
    }

    public ShebangDirectiveTriviaSyntax Update(SyntaxToken hashToken, SyntaxToken exclamationToken, SyntaxToken endOfDirectiveToken, bool isActive)
    {
        if (hashToken != this.HashToken || exclamationToken != this.ExclamationToken || endOfDirectiveToken != this.EndOfDirectiveToken)
        {
            var newNode = SyntaxFactory.ShebangDirectiveTrivia(hashToken, exclamationToken, endOfDirectiveToken, isActive);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public ShebangDirectiveTriviaSyntax WithHashToken(SyntaxToken hashToken)
    {
        return this.Update(hashToken, this.ExclamationToken, this.EndOfDirectiveToken, this.IsActive);
    }

    public ShebangDirectiveTriviaSyntax WithExclamationToken(SyntaxToken exclamationToken)
    {
        return this.Update(this.HashToken, exclamationToken, this.EndOfDirectiveToken, this.IsActive);
    }

    public ShebangDirectiveTriviaSyntax WithEndOfDirectiveToken(SyntaxToken endOfDirectiveToken)
    {
        return this.Update(this.HashToken, this.ExclamationToken, endOfDirectiveToken, this.IsActive);
    }

    public ShebangDirectiveTriviaSyntax WithIsActive(bool isActive)
    {
        return this.Update(this.HashToken, this.ExclamationToken, this.EndOfDirectiveToken, isActive);
    }
  }
}
