' Definition of syntax model.
' Generated by a tool from SHA256 content 9D091EE1836DB2615BAE4E547B1E3FE8ABC441987B6BCF397032C14E99EDB971
' DO NOT HAND EDIT

Imports System.Collections.Generic
Imports System.Collections.Immutable
Imports System.Runtime.CompilerServices
Imports Microsoft.CodeAnalysis.Syntax.InternalSyntax
Imports Microsoft.CodeAnalysis.VisualBasic.Syntax
Imports Roslyn.Utilities

Namespace Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax

    ''' <summary>
    ''' The base class for all nodes in the VB syntax tree.
    ''' </summary>
    Partial Friend MustInherit Class VisualBasicSyntaxNode


        Public Overridable Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitVisualBasicSyntaxNode(Me)
        End Function


    End Class

    ''' <summary>
    ''' The base class for all nodes that represent statements. This includes both
    ''' declaration statements, such as class declarations as well as executable
    ''' statements.
    ''' </summary>
    Friend MustInherit Class StatementSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' The base class for all nodes that represent executable statements.
    ''' </summary>
    Friend MustInherit Class ExecutableStatementSyntax
        Inherits StatementSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' The base class for all nodes that represent statements that declare options,
    ''' imports, members, etc.
    ''' </summary>
    Friend MustInherit Class DeclarationStatementSyntax
        Inherits StatementSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' A class to represent an empty statement. This can occur when a colon is on a
    ''' line without anything else.
    ''' </summary>
    Friend NotInheritable Class EmptyStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _empty as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, empty As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, empty As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), empty As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _empty = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _empty isnot Nothing 
             AdjustFlagsAndWidth(_empty)
             Me._empty = _empty
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New EmptyStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._empty)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(EmptyStatementSyntax), Function(r) New EmptyStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EmptyStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' An empty token because all non terminals must have a token.
        ''' </summary>
        Friend  ReadOnly Property Empty As InternalSyntax.PunctuationSyntax
            Get
                Return Me._empty
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._empty
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EmptyStatementSyntax(Me.Kind, newErrors, GetAnnotations, _empty)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EmptyStatementSyntax(Me.Kind, GetDiagnostics, annotations, _empty)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEmptyStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "End XXX" statement, where XXX is a single keyword.
    ''' </summary>
    Friend NotInheritable Class EndBlockStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _endKeyword as KeywordSyntax
        Friend ReadOnly _blockKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, endKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(endKeyword)
            Me._endKeyword = endKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, endKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(endKeyword)
            Me._endKeyword = endKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), endKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(endKeyword)
            Me._endKeyword = endKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _endKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _endKeyword isnot Nothing 
             AdjustFlagsAndWidth(_endKeyword)
             Me._endKeyword = _endKeyword
          End If
          Dim _blockKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _blockKeyword isnot Nothing 
             AdjustFlagsAndWidth(_blockKeyword)
             Me._blockKeyword = _blockKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New EndBlockStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._endKeyword)
          writer.WriteValue(Me._blockKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(EndBlockStatementSyntax), Function(r) New EndBlockStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EndBlockStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "End" keyword
        ''' </summary>
        Friend  ReadOnly Property EndKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._endKeyword
            End Get
        End Property

        ''' <summary>
        ''' The keyword that ends the block. Must be one of: "If", "Using", "With",
        ''' "Select", "Structure", "Enum", "Interface", "Class", "Module", "Namespace",
        ''' "Sub", "Function", "Get, "Set", "Property", "Operator", "Event", "AddHandler",
        ''' "RemoveHandler", "RaiseEvent", "While", "Try" or "SyncLock".
        ''' </summary>
        Friend  ReadOnly Property BlockKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._blockKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._endKeyword
                Case 1
                    Return Me._blockKeyword
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EndBlockStatementSyntax(Me.Kind, newErrors, GetAnnotations, _endKeyword, _blockKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EndBlockStatementSyntax(Me.Kind, GetDiagnostics, annotations, _endKeyword, _blockKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEndBlockStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an entire source file of VB code.
    ''' </summary>
    Partial Friend NotInheritable Class CompilationUnitSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _options as GreenNode
        Friend ReadOnly _imports as GreenNode
        Friend ReadOnly _attributes as GreenNode
        Friend ReadOnly _members as GreenNode
        Friend ReadOnly _endOfFileToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, options As GreenNode, [imports] As GreenNode, attributes As GreenNode, members As GreenNode, endOfFileToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 5

            If options IsNot Nothing Then
                AdjustFlagsAndWidth(options)
                Me._options = options
            End If
            If [imports] IsNot Nothing Then
                AdjustFlagsAndWidth([imports])
                Me._imports = [imports]
            End If
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endOfFileToken)
            Me._endOfFileToken = endOfFileToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, options As GreenNode, [imports] As GreenNode, attributes As GreenNode, members As GreenNode, endOfFileToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            If options IsNot Nothing Then
                AdjustFlagsAndWidth(options)
                Me._options = options
            End If
            If [imports] IsNot Nothing Then
                AdjustFlagsAndWidth([imports])
                Me._imports = [imports]
            End If
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endOfFileToken)
            Me._endOfFileToken = endOfFileToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), options As GreenNode, [imports] As GreenNode, attributes As GreenNode, members As GreenNode, endOfFileToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 5

            If options IsNot Nothing Then
                AdjustFlagsAndWidth(options)
                Me._options = options
            End If
            If [imports] IsNot Nothing Then
                AdjustFlagsAndWidth([imports])
                Me._imports = [imports]
            End If
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endOfFileToken)
            Me._endOfFileToken = endOfFileToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _options = DirectCast(reader.ReadValue(), GreenNode)
          If _options isnot Nothing 
             AdjustFlagsAndWidth(_options)
             Me._options = _options
          End If
          Dim _imports = DirectCast(reader.ReadValue(), GreenNode)
          If _imports isnot Nothing 
             AdjustFlagsAndWidth(_imports)
             Me._imports = _imports
          End If
          Dim _attributes = DirectCast(reader.ReadValue(), GreenNode)
          If _attributes isnot Nothing 
             AdjustFlagsAndWidth(_attributes)
             Me._attributes = _attributes
          End If
          Dim _members = DirectCast(reader.ReadValue(), GreenNode)
          If _members isnot Nothing 
             AdjustFlagsAndWidth(_members)
             Me._members = _members
          End If
          Dim _endOfFileToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _endOfFileToken isnot Nothing 
             AdjustFlagsAndWidth(_endOfFileToken)
             Me._endOfFileToken = _endOfFileToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New CompilationUnitSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._options)
          writer.WriteValue(Me._imports)
          writer.WriteValue(Me._attributes)
          writer.WriteValue(Me._members)
          writer.WriteValue(Me._endOfFileToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(CompilationUnitSyntax), Function(r) New CompilationUnitSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CompilationUnitSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' Represents the list of Option statements at the beginning of a source file.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Options As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of OptionStatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of OptionStatementSyntax)(Me._options)
            End Get
        End Property

        ''' <summary>
        ''' Represents the list of Imports statements at the beginning of a source file.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property [Imports] As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ImportsStatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ImportsStatementSyntax)(Me._imports)
            End Get
        End Property

        ''' <summary>
        ''' Represents the list of AttributeStatements at the beginning of a source file
        ''' that contain the Assembly and Module attributes.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Attributes As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributesStatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributesStatementSyntax)(Me._attributes)
            End Get
        End Property

        ''' <summary>
        ''' Represents the members of the default namespace for this source file: all the
        ''' top-level type and namespace declarations in the file. May also contain
        ''' Statements that are not valid
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Members As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._members)
            End Get
        End Property

        ''' <summary>
        ''' Represents the end of the source file. This token may have trivia (whitespace,
        ''' comments, ...) attached to it.
        ''' </summary>
        Friend  ReadOnly Property EndOfFileToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._endOfFileToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._options
                Case 1
                    Return Me._imports
                Case 2
                    Return Me._attributes
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endOfFileToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CompilationUnitSyntax(Me.Kind, newErrors, GetAnnotations, _options, _imports, _attributes, _members, _endOfFileToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CompilationUnitSyntax(Me.Kind, GetDiagnostics, annotations, _options, _imports, _attributes, _members, _endOfFileToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCompilationUnit(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an Option statement, such as "Option Strict On".
    ''' </summary>
    Friend NotInheritable Class OptionStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _optionKeyword as KeywordSyntax
        Friend ReadOnly _nameKeyword as KeywordSyntax
        Friend ReadOnly _valueKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, optionKeyword As InternalSyntax.KeywordSyntax, nameKeyword As InternalSyntax.KeywordSyntax, valueKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(optionKeyword)
            Me._optionKeyword = optionKeyword
            AdjustFlagsAndWidth(nameKeyword)
            Me._nameKeyword = nameKeyword
            If valueKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(valueKeyword)
                Me._valueKeyword = valueKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, optionKeyword As InternalSyntax.KeywordSyntax, nameKeyword As InternalSyntax.KeywordSyntax, valueKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(optionKeyword)
            Me._optionKeyword = optionKeyword
            AdjustFlagsAndWidth(nameKeyword)
            Me._nameKeyword = nameKeyword
            If valueKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(valueKeyword)
                Me._valueKeyword = valueKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), optionKeyword As InternalSyntax.KeywordSyntax, nameKeyword As InternalSyntax.KeywordSyntax, valueKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(optionKeyword)
            Me._optionKeyword = optionKeyword
            AdjustFlagsAndWidth(nameKeyword)
            Me._nameKeyword = nameKeyword
            If valueKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(valueKeyword)
                Me._valueKeyword = valueKeyword
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _optionKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _optionKeyword isnot Nothing 
             AdjustFlagsAndWidth(_optionKeyword)
             Me._optionKeyword = _optionKeyword
          End If
          Dim _nameKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _nameKeyword isnot Nothing 
             AdjustFlagsAndWidth(_nameKeyword)
             Me._nameKeyword = _nameKeyword
          End If
          Dim _valueKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _valueKeyword isnot Nothing 
             AdjustFlagsAndWidth(_valueKeyword)
             Me._valueKeyword = _valueKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New OptionStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._optionKeyword)
          writer.WriteValue(Me._nameKeyword)
          writer.WriteValue(Me._valueKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(OptionStatementSyntax), Function(r) New OptionStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OptionStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Option" keyword.
        ''' </summary>
        Friend  ReadOnly Property OptionKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._optionKeyword
            End Get
        End Property

        ''' <summary>
        ''' The keyword that identifies the option being set: Explicit, Strict, Compare or
        ''' Infer.
        ''' </summary>
        Friend  ReadOnly Property NameKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._nameKeyword
            End Get
        End Property

        ''' <summary>
        ''' The keyword that identifiers the value being set for the option: On, Off, Text
        ''' or Binary.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ValueKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._valueKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._optionKeyword
                Case 1
                    Return Me._nameKeyword
                Case 2
                    Return Me._valueKeyword
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OptionStatementSyntax(Me.Kind, newErrors, GetAnnotations, _optionKeyword, _nameKeyword, _valueKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OptionStatementSyntax(Me.Kind, GetDiagnostics, annotations, _optionKeyword, _nameKeyword, _valueKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOptionStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an Imports statement, which has one or more imports clauses.
    ''' </summary>
    Friend NotInheritable Class ImportsStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _importsKeyword as KeywordSyntax
        Friend ReadOnly _importsClauses as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, importsKeyword As InternalSyntax.KeywordSyntax, importsClauses As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(importsKeyword)
            Me._importsKeyword = importsKeyword
            If importsClauses IsNot Nothing Then
                AdjustFlagsAndWidth(importsClauses)
                Me._importsClauses = importsClauses
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, importsKeyword As InternalSyntax.KeywordSyntax, importsClauses As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(importsKeyword)
            Me._importsKeyword = importsKeyword
            If importsClauses IsNot Nothing Then
                AdjustFlagsAndWidth(importsClauses)
                Me._importsClauses = importsClauses
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), importsKeyword As InternalSyntax.KeywordSyntax, importsClauses As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(importsKeyword)
            Me._importsKeyword = importsKeyword
            If importsClauses IsNot Nothing Then
                AdjustFlagsAndWidth(importsClauses)
                Me._importsClauses = importsClauses
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _importsKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _importsKeyword isnot Nothing 
             AdjustFlagsAndWidth(_importsKeyword)
             Me._importsKeyword = _importsKeyword
          End If
          Dim _importsClauses = DirectCast(reader.ReadValue(), GreenNode)
          If _importsClauses isnot Nothing 
             AdjustFlagsAndWidth(_importsClauses)
             Me._importsClauses = _importsClauses
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ImportsStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._importsKeyword)
          writer.WriteValue(Me._importsClauses)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ImportsStatementSyntax), Function(r) New ImportsStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ImportsStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Imports" keyword.
        ''' </summary>
        Friend  ReadOnly Property ImportsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._importsKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of one or more import clauses. Each clause is either an alias, namespace
        ''' or XML namespace import.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property ImportsClauses As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ImportsClauseSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ImportsClauseSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ImportsClauseSyntax)(Me._importsClauses))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._importsKeyword
                Case 1
                    Return Me._importsClauses
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ImportsStatementSyntax(Me.Kind, newErrors, GetAnnotations, _importsKeyword, _importsClauses)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ImportsStatementSyntax(Me.Kind, GetDiagnostics, annotations, _importsKeyword, _importsClauses)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitImportsStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' The base class for the possible clauses of an Imports statement.
    ''' </summary>
    Friend MustInherit Class ImportsClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' Represents the clause of an Imports statement that imports all members of a
    ''' type or namespace or aliases a type or namespace.
    ''' </summary>
    Friend NotInheritable Class SimpleImportsClauseSyntax
        Inherits ImportsClauseSyntax

        Friend ReadOnly _alias as ImportAliasClauseSyntax
        Friend ReadOnly _name as NameSyntax

        Friend Sub New(ByVal kind As SyntaxKind, [alias] As ImportAliasClauseSyntax, name As NameSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            If [alias] IsNot Nothing Then
                AdjustFlagsAndWidth([alias])
                Me._alias = [alias]
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, [alias] As ImportAliasClauseSyntax, name As NameSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            If [alias] IsNot Nothing Then
                AdjustFlagsAndWidth([alias])
                Me._alias = [alias]
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), [alias] As ImportAliasClauseSyntax, name As NameSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            If [alias] IsNot Nothing Then
                AdjustFlagsAndWidth([alias])
                Me._alias = [alias]
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _alias = DirectCast(reader.ReadValue(), ImportAliasClauseSyntax)
          If _alias isnot Nothing 
             AdjustFlagsAndWidth(_alias)
             Me._alias = _alias
          End If
          Dim _name = DirectCast(reader.ReadValue(), NameSyntax)
          If _name isnot Nothing 
             AdjustFlagsAndWidth(_name)
             Me._name = _name
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SimpleImportsClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._alias)
          writer.WriteValue(Me._name)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SimpleImportsClauseSyntax), Function(r) New SimpleImportsClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SimpleImportsClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' An optional alias for the namespace or type being imported.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property [Alias] As InternalSyntax.ImportAliasClauseSyntax
            Get
                Return Me._alias
            End Get
        End Property

        ''' <summary>
        ''' The namespace or type being imported.
        ''' </summary>
        Friend  ReadOnly Property Name As InternalSyntax.NameSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._alias
                Case 1
                    Return Me._name
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SimpleImportsClauseSyntax(Me.Kind, newErrors, GetAnnotations, _alias, _name)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SimpleImportsClauseSyntax(Me.Kind, GetDiagnostics, annotations, _alias, _name)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSimpleImportsClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an alias identifier followed by an "=" token in an Imports clause.
    ''' </summary>
    Friend NotInheritable Class ImportAliasClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _equalsToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, equalsToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, equalsToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax, equalsToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _equalsToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _equalsToken isnot Nothing 
             AdjustFlagsAndWidth(_equalsToken)
             Me._equalsToken = _equalsToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ImportAliasClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._equalsToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ImportAliasClauseSyntax), Function(r) New ImportAliasClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ImportAliasClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The identifier being introduced.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Friend  ReadOnly Property EqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._equalsToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._identifier
                Case 1
                    Return Me._equalsToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ImportAliasClauseSyntax(Me.Kind, newErrors, GetAnnotations, _identifier, _equalsToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ImportAliasClauseSyntax(Me.Kind, GetDiagnostics, annotations, _identifier, _equalsToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitImportAliasClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Defines a XML namespace for XML expressions.
    ''' </summary>
    Friend NotInheritable Class XmlNamespaceImportsClauseSyntax
        Inherits ImportsClauseSyntax

        Friend ReadOnly _lessThanToken as PunctuationSyntax
        Friend ReadOnly _xmlNamespace as XmlAttributeSyntax
        Friend ReadOnly _greaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, xmlNamespace As XmlAttributeSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(xmlNamespace)
            Me._xmlNamespace = xmlNamespace
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, xmlNamespace As XmlAttributeSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(xmlNamespace)
            Me._xmlNamespace = xmlNamespace
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanToken As InternalSyntax.PunctuationSyntax, xmlNamespace As XmlAttributeSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(xmlNamespace)
            Me._xmlNamespace = xmlNamespace
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _lessThanToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _lessThanToken isnot Nothing 
             AdjustFlagsAndWidth(_lessThanToken)
             Me._lessThanToken = _lessThanToken
          End If
          Dim _xmlNamespace = DirectCast(reader.ReadValue(), XmlAttributeSyntax)
          If _xmlNamespace isnot Nothing 
             AdjustFlagsAndWidth(_xmlNamespace)
             Me._xmlNamespace = _xmlNamespace
          End If
          Dim _greaterThanToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _greaterThanToken isnot Nothing 
             AdjustFlagsAndWidth(_greaterThanToken)
             Me._greaterThanToken = _greaterThanToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New XmlNamespaceImportsClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._lessThanToken)
          writer.WriteValue(Me._xmlNamespace)
          writer.WriteValue(Me._greaterThanToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(XmlNamespaceImportsClauseSyntax), Function(r) New XmlNamespaceImportsClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlNamespaceImportsClauseSyntax(Me, parent, startLocation)
        End Function

        Friend  ReadOnly Property LessThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanToken
            End Get
        End Property

        ''' <summary>
        ''' Identifies the XML namespace alias and URI.
        ''' </summary>
        Friend  ReadOnly Property XmlNamespace As InternalSyntax.XmlAttributeSyntax
            Get
                Return Me._xmlNamespace
            End Get
        End Property

        Friend  ReadOnly Property GreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._greaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanToken
                Case 1
                    Return Me._xmlNamespace
                Case 2
                    Return Me._greaterThanToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlNamespaceImportsClauseSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanToken, _xmlNamespace, _greaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlNamespaceImportsClauseSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanToken, _xmlNamespace, _greaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlNamespaceImportsClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Namespace statement, its contents and the End Namespace statement.
    ''' </summary>
    Friend NotInheritable Class NamespaceBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _namespaceStatement as NamespaceStatementSyntax
        Friend ReadOnly _members as GreenNode
        Friend ReadOnly _endNamespaceStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, namespaceStatement As NamespaceStatementSyntax, members As GreenNode, endNamespaceStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(namespaceStatement)
            Me._namespaceStatement = namespaceStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endNamespaceStatement)
            Me._endNamespaceStatement = endNamespaceStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, namespaceStatement As NamespaceStatementSyntax, members As GreenNode, endNamespaceStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(namespaceStatement)
            Me._namespaceStatement = namespaceStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endNamespaceStatement)
            Me._endNamespaceStatement = endNamespaceStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), namespaceStatement As NamespaceStatementSyntax, members As GreenNode, endNamespaceStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(namespaceStatement)
            Me._namespaceStatement = namespaceStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endNamespaceStatement)
            Me._endNamespaceStatement = endNamespaceStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _namespaceStatement = DirectCast(reader.ReadValue(), NamespaceStatementSyntax)
          If _namespaceStatement isnot Nothing 
             AdjustFlagsAndWidth(_namespaceStatement)
             Me._namespaceStatement = _namespaceStatement
          End If
          Dim _members = DirectCast(reader.ReadValue(), GreenNode)
          If _members isnot Nothing 
             AdjustFlagsAndWidth(_members)
             Me._members = _members
          End If
          Dim _endNamespaceStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endNamespaceStatement isnot Nothing 
             AdjustFlagsAndWidth(_endNamespaceStatement)
             Me._endNamespaceStatement = _endNamespaceStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New NamespaceBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._namespaceStatement)
          writer.WriteValue(Me._members)
          writer.WriteValue(Me._endNamespaceStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(NamespaceBlockSyntax), Function(r) New NamespaceBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NamespaceBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The statement that begins the NamespaceBlock.
        ''' </summary>
        Friend  ReadOnly Property NamespaceStatement As InternalSyntax.NamespaceStatementSyntax
            Get
                Return Me._namespaceStatement
            End Get
        End Property

        ''' <summary>
        ''' The declarations contained in the namespace statement.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Members As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._members)
            End Get
        End Property

        ''' <summary>
        ''' The End Namespace statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndNamespaceStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endNamespaceStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._namespaceStatement
                Case 1
                    Return Me._members
                Case 2
                    Return Me._endNamespaceStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NamespaceBlockSyntax(Me.Kind, newErrors, GetAnnotations, _namespaceStatement, _members, _endNamespaceStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NamespaceBlockSyntax(Me.Kind, GetDiagnostics, annotations, _namespaceStatement, _members, _endNamespaceStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNamespaceBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a namespace declaration. This node always
    ''' appears as the Begin of a BlockStatement with Kind=NamespaceBlock.
    ''' </summary>
    Friend NotInheritable Class NamespaceStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _namespaceKeyword as KeywordSyntax
        Friend ReadOnly _name as NameSyntax

        Friend Sub New(ByVal kind As SyntaxKind, namespaceKeyword As InternalSyntax.KeywordSyntax, name As NameSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(namespaceKeyword)
            Me._namespaceKeyword = namespaceKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, namespaceKeyword As InternalSyntax.KeywordSyntax, name As NameSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(namespaceKeyword)
            Me._namespaceKeyword = namespaceKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), namespaceKeyword As InternalSyntax.KeywordSyntax, name As NameSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(namespaceKeyword)
            Me._namespaceKeyword = namespaceKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _namespaceKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _namespaceKeyword isnot Nothing 
             AdjustFlagsAndWidth(_namespaceKeyword)
             Me._namespaceKeyword = _namespaceKeyword
          End If
          Dim _name = DirectCast(reader.ReadValue(), NameSyntax)
          If _name isnot Nothing 
             AdjustFlagsAndWidth(_name)
             Me._name = _name
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New NamespaceStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._namespaceKeyword)
          writer.WriteValue(Me._name)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(NamespaceStatementSyntax), Function(r) New NamespaceStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NamespaceStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Namespace" keyword.
        ''' </summary>
        Friend  ReadOnly Property NamespaceKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._namespaceKeyword
            End Get
        End Property

        ''' <summary>
        ''' A (possibly dotted) name denoting the namespace being declared.
        ''' </summary>
        Friend  ReadOnly Property Name As InternalSyntax.NameSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._namespaceKeyword
                Case 1
                    Return Me._name
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NamespaceStatementSyntax(Me.Kind, newErrors, GetAnnotations, _namespaceKeyword, _name)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NamespaceStatementSyntax(Me.Kind, GetDiagnostics, annotations, _namespaceKeyword, _name)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNamespaceStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Class, Interface, Structure, Module, its contents
    ''' and the End statement that ends it.
    ''' </summary>
    Friend MustInherit Class TypeBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _inherits as GreenNode
        Friend ReadOnly _implements as GreenNode
        Friend ReadOnly _members as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode)
            MyBase.New(kind)

            If [inherits] IsNot Nothing Then
                AdjustFlagsAndWidth([inherits])
                Me._inherits = [inherits]
            End If
            If [implements] IsNot Nothing Then
                AdjustFlagsAndWidth([implements])
                Me._implements = [implements]
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If [inherits] IsNot Nothing Then
                AdjustFlagsAndWidth([inherits])
                Me._inherits = [inherits]
            End If
            If [implements] IsNot Nothing Then
                AdjustFlagsAndWidth([implements])
                Me._implements = [implements]
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode)
            MyBase.New(kind, errors, annotations)

            If [inherits] IsNot Nothing Then
                AdjustFlagsAndWidth([inherits])
                Me._inherits = [inherits]
            End If
            If [implements] IsNot Nothing Then
                AdjustFlagsAndWidth([implements])
                Me._implements = [implements]
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _inherits = DirectCast(reader.ReadValue(), GreenNode)
          If _inherits isnot Nothing 
             AdjustFlagsAndWidth(_inherits)
             Me._inherits = _inherits
          End If
          Dim _implements = DirectCast(reader.ReadValue(), GreenNode)
          If _implements isnot Nothing 
             AdjustFlagsAndWidth(_implements)
             Me._implements = _implements
          End If
          Dim _members = DirectCast(reader.ReadValue(), GreenNode)
          If _members isnot Nothing 
             AdjustFlagsAndWidth(_members)
             Me._members = _members
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._inherits)
          writer.WriteValue(Me._implements)
          writer.WriteValue(Me._members)
        End Sub

        ''' <summary>
        ''' A list of the Inherits declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property [Inherits] As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of InheritsStatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of InheritsStatementSyntax)(Me._inherits)
            End Get
        End Property

        ''' <summary>
        ''' A list of the Implements declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property [Implements] As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ImplementsStatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ImplementsStatementSyntax)(Me._implements)
            End Get
        End Property

        ''' <summary>
        ''' The declarations contained in the type or module.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Members As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._members)
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents a declaration of Module, its contents and the End statement that
    ''' ends it.
    ''' </summary>
    Friend NotInheritable Class ModuleBlockSyntax
        Inherits TypeBlockSyntax

        Friend ReadOnly _moduleStatement as ModuleStatementSyntax
        Friend ReadOnly _endModuleStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, moduleStatement As ModuleStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endModuleStatement As EndBlockStatementSyntax)
            MyBase.New(kind, [inherits], [implements], members)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(moduleStatement)
            Me._moduleStatement = moduleStatement
            AdjustFlagsAndWidth(endModuleStatement)
            Me._endModuleStatement = endModuleStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, moduleStatement As ModuleStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endModuleStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, [inherits], [implements], members)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(moduleStatement)
            Me._moduleStatement = moduleStatement
            AdjustFlagsAndWidth(endModuleStatement)
            Me._endModuleStatement = endModuleStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), moduleStatement As ModuleStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endModuleStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, [inherits], [implements], members)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(moduleStatement)
            Me._moduleStatement = moduleStatement
            AdjustFlagsAndWidth(endModuleStatement)
            Me._endModuleStatement = endModuleStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _moduleStatement = DirectCast(reader.ReadValue(), ModuleStatementSyntax)
          If _moduleStatement isnot Nothing 
             AdjustFlagsAndWidth(_moduleStatement)
             Me._moduleStatement = _moduleStatement
          End If
          Dim _endModuleStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endModuleStatement isnot Nothing 
             AdjustFlagsAndWidth(_endModuleStatement)
             Me._endModuleStatement = _endModuleStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ModuleBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._moduleStatement)
          writer.WriteValue(Me._endModuleStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ModuleBlockSyntax), Function(r) New ModuleBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ModuleBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Module" statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property ModuleStatement As InternalSyntax.ModuleStatementSyntax
            Get
                Return Me._moduleStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Module" statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndModuleStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endModuleStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._moduleStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endModuleStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ModuleBlockSyntax(Me.Kind, newErrors, GetAnnotations, _moduleStatement, _inherits, _implements, _members, _endModuleStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ModuleBlockSyntax(Me.Kind, GetDiagnostics, annotations, _moduleStatement, _inherits, _implements, _members, _endModuleStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitModuleBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Structure, its contents and the End statement
    ''' that ends it.
    ''' </summary>
    Friend NotInheritable Class StructureBlockSyntax
        Inherits TypeBlockSyntax

        Friend ReadOnly _structureStatement as StructureStatementSyntax
        Friend ReadOnly _endStructureStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, structureStatement As StructureStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endStructureStatement As EndBlockStatementSyntax)
            MyBase.New(kind, [inherits], [implements], members)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(structureStatement)
            Me._structureStatement = structureStatement
            AdjustFlagsAndWidth(endStructureStatement)
            Me._endStructureStatement = endStructureStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, structureStatement As StructureStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endStructureStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, [inherits], [implements], members)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(structureStatement)
            Me._structureStatement = structureStatement
            AdjustFlagsAndWidth(endStructureStatement)
            Me._endStructureStatement = endStructureStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), structureStatement As StructureStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endStructureStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, [inherits], [implements], members)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(structureStatement)
            Me._structureStatement = structureStatement
            AdjustFlagsAndWidth(endStructureStatement)
            Me._endStructureStatement = endStructureStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _structureStatement = DirectCast(reader.ReadValue(), StructureStatementSyntax)
          If _structureStatement isnot Nothing 
             AdjustFlagsAndWidth(_structureStatement)
             Me._structureStatement = _structureStatement
          End If
          Dim _endStructureStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endStructureStatement isnot Nothing 
             AdjustFlagsAndWidth(_endStructureStatement)
             Me._endStructureStatement = _endStructureStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New StructureBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._structureStatement)
          writer.WriteValue(Me._endStructureStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(StructureBlockSyntax), Function(r) New StructureBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.StructureBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Structure" statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property StructureStatement As InternalSyntax.StructureStatementSyntax
            Get
                Return Me._structureStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Structure" statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndStructureStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endStructureStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._structureStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endStructureStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new StructureBlockSyntax(Me.Kind, newErrors, GetAnnotations, _structureStatement, _inherits, _implements, _members, _endStructureStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new StructureBlockSyntax(Me.Kind, GetDiagnostics, annotations, _structureStatement, _inherits, _implements, _members, _endStructureStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitStructureBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Interface, its contents and the End statement
    ''' that ends it.
    ''' </summary>
    Friend NotInheritable Class InterfaceBlockSyntax
        Inherits TypeBlockSyntax

        Friend ReadOnly _interfaceStatement as InterfaceStatementSyntax
        Friend ReadOnly _endInterfaceStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, interfaceStatement As InterfaceStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endInterfaceStatement As EndBlockStatementSyntax)
            MyBase.New(kind, [inherits], [implements], members)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(interfaceStatement)
            Me._interfaceStatement = interfaceStatement
            AdjustFlagsAndWidth(endInterfaceStatement)
            Me._endInterfaceStatement = endInterfaceStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, interfaceStatement As InterfaceStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endInterfaceStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, [inherits], [implements], members)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(interfaceStatement)
            Me._interfaceStatement = interfaceStatement
            AdjustFlagsAndWidth(endInterfaceStatement)
            Me._endInterfaceStatement = endInterfaceStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), interfaceStatement As InterfaceStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endInterfaceStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, [inherits], [implements], members)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(interfaceStatement)
            Me._interfaceStatement = interfaceStatement
            AdjustFlagsAndWidth(endInterfaceStatement)
            Me._endInterfaceStatement = endInterfaceStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _interfaceStatement = DirectCast(reader.ReadValue(), InterfaceStatementSyntax)
          If _interfaceStatement isnot Nothing 
             AdjustFlagsAndWidth(_interfaceStatement)
             Me._interfaceStatement = _interfaceStatement
          End If
          Dim _endInterfaceStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endInterfaceStatement isnot Nothing 
             AdjustFlagsAndWidth(_endInterfaceStatement)
             Me._endInterfaceStatement = _endInterfaceStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New InterfaceBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._interfaceStatement)
          writer.WriteValue(Me._endInterfaceStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(InterfaceBlockSyntax), Function(r) New InterfaceBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.InterfaceBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Interface" statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property InterfaceStatement As InternalSyntax.InterfaceStatementSyntax
            Get
                Return Me._interfaceStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Interface" statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndInterfaceStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endInterfaceStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._interfaceStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endInterfaceStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new InterfaceBlockSyntax(Me.Kind, newErrors, GetAnnotations, _interfaceStatement, _inherits, _implements, _members, _endInterfaceStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new InterfaceBlockSyntax(Me.Kind, GetDiagnostics, annotations, _interfaceStatement, _inherits, _implements, _members, _endInterfaceStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitInterfaceBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Class its contents and the End statement that
    ''' ends it.
    ''' </summary>
    Friend NotInheritable Class ClassBlockSyntax
        Inherits TypeBlockSyntax

        Friend ReadOnly _classStatement as ClassStatementSyntax
        Friend ReadOnly _endClassStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, classStatement As ClassStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endClassStatement As EndBlockStatementSyntax)
            MyBase.New(kind, [inherits], [implements], members)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(classStatement)
            Me._classStatement = classStatement
            AdjustFlagsAndWidth(endClassStatement)
            Me._endClassStatement = endClassStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, classStatement As ClassStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endClassStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, [inherits], [implements], members)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(classStatement)
            Me._classStatement = classStatement
            AdjustFlagsAndWidth(endClassStatement)
            Me._endClassStatement = endClassStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), classStatement As ClassStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endClassStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, [inherits], [implements], members)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(classStatement)
            Me._classStatement = classStatement
            AdjustFlagsAndWidth(endClassStatement)
            Me._endClassStatement = endClassStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _classStatement = DirectCast(reader.ReadValue(), ClassStatementSyntax)
          If _classStatement isnot Nothing 
             AdjustFlagsAndWidth(_classStatement)
             Me._classStatement = _classStatement
          End If
          Dim _endClassStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endClassStatement isnot Nothing 
             AdjustFlagsAndWidth(_endClassStatement)
             Me._endClassStatement = _endClassStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ClassBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._classStatement)
          writer.WriteValue(Me._endClassStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ClassBlockSyntax), Function(r) New ClassBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ClassBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Class" statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property ClassStatement As InternalSyntax.ClassStatementSyntax
            Get
                Return Me._classStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Class" statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndClassStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endClassStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._classStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endClassStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ClassBlockSyntax(Me.Kind, newErrors, GetAnnotations, _classStatement, _inherits, _implements, _members, _endClassStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ClassBlockSyntax(Me.Kind, GetDiagnostics, annotations, _classStatement, _inherits, _implements, _members, _endClassStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitClassBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of an Enum, its contents and the End Enum statement
    ''' that ends it.
    ''' </summary>
    Friend NotInheritable Class EnumBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _enumStatement as EnumStatementSyntax
        Friend ReadOnly _members as GreenNode
        Friend ReadOnly _endEnumStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, enumStatement As EnumStatementSyntax, members As GreenNode, endEnumStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(enumStatement)
            Me._enumStatement = enumStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endEnumStatement)
            Me._endEnumStatement = endEnumStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, enumStatement As EnumStatementSyntax, members As GreenNode, endEnumStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(enumStatement)
            Me._enumStatement = enumStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endEnumStatement)
            Me._endEnumStatement = endEnumStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), enumStatement As EnumStatementSyntax, members As GreenNode, endEnumStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(enumStatement)
            Me._enumStatement = enumStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endEnumStatement)
            Me._endEnumStatement = endEnumStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _enumStatement = DirectCast(reader.ReadValue(), EnumStatementSyntax)
          If _enumStatement isnot Nothing 
             AdjustFlagsAndWidth(_enumStatement)
             Me._enumStatement = _enumStatement
          End If
          Dim _members = DirectCast(reader.ReadValue(), GreenNode)
          If _members isnot Nothing 
             AdjustFlagsAndWidth(_members)
             Me._members = _members
          End If
          Dim _endEnumStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endEnumStatement isnot Nothing 
             AdjustFlagsAndWidth(_endEnumStatement)
             Me._endEnumStatement = _endEnumStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New EnumBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._enumStatement)
          writer.WriteValue(Me._members)
          writer.WriteValue(Me._endEnumStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(EnumBlockSyntax), Function(r) New EnumBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EnumBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The statement that begins the type or module.
        ''' </summary>
        Friend  ReadOnly Property EnumStatement As InternalSyntax.EnumStatementSyntax
            Get
                Return Me._enumStatement
            End Get
        End Property

        ''' <summary>
        ''' The declarations contained in the enumeration.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Members As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._members)
            End Get
        End Property

        ''' <summary>
        ''' The End XXX statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndEnumStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endEnumStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._enumStatement
                Case 1
                    Return Me._members
                Case 2
                    Return Me._endEnumStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EnumBlockSyntax(Me.Kind, newErrors, GetAnnotations, _enumStatement, _members, _endEnumStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EnumBlockSyntax(Me.Kind, GetDiagnostics, annotations, _enumStatement, _members, _endEnumStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEnumBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an Inherits or Implements statement in a Class, Structure or
    ''' Interface.
    ''' </summary>
    Friend MustInherit Class InheritsOrImplementsStatementSyntax
        Inherits DeclarationStatementSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' Represents an Inherits statement in a Class, Structure or Interface.
    ''' </summary>
    Friend NotInheritable Class InheritsStatementSyntax
        Inherits InheritsOrImplementsStatementSyntax

        Friend ReadOnly _inheritsKeyword as KeywordSyntax
        Friend ReadOnly _types as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, inheritsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(inheritsKeyword)
            Me._inheritsKeyword = inheritsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, inheritsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(inheritsKeyword)
            Me._inheritsKeyword = inheritsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), inheritsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(inheritsKeyword)
            Me._inheritsKeyword = inheritsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _inheritsKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _inheritsKeyword isnot Nothing 
             AdjustFlagsAndWidth(_inheritsKeyword)
             Me._inheritsKeyword = _inheritsKeyword
          End If
          Dim _types = DirectCast(reader.ReadValue(), GreenNode)
          If _types isnot Nothing 
             AdjustFlagsAndWidth(_types)
             Me._types = _types
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New InheritsStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._inheritsKeyword)
          writer.WriteValue(Me._types)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(InheritsStatementSyntax), Function(r) New InheritsStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.InheritsStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Inherits" keyword.
        ''' </summary>
        Friend  ReadOnly Property InheritsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._inheritsKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of the types being inherited.
        ''' </summary>
        Friend  ReadOnly Property Types As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of TypeSyntax)(Me._types))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._inheritsKeyword
                Case 1
                    Return Me._types
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new InheritsStatementSyntax(Me.Kind, newErrors, GetAnnotations, _inheritsKeyword, _types)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new InheritsStatementSyntax(Me.Kind, GetDiagnostics, annotations, _inheritsKeyword, _types)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitInheritsStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an Implements statement in a Class or Structure.
    ''' </summary>
    Friend NotInheritable Class ImplementsStatementSyntax
        Inherits InheritsOrImplementsStatementSyntax

        Friend ReadOnly _implementsKeyword as KeywordSyntax
        Friend ReadOnly _types as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, implementsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, implementsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), implementsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _implementsKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _implementsKeyword isnot Nothing 
             AdjustFlagsAndWidth(_implementsKeyword)
             Me._implementsKeyword = _implementsKeyword
          End If
          Dim _types = DirectCast(reader.ReadValue(), GreenNode)
          If _types isnot Nothing 
             AdjustFlagsAndWidth(_types)
             Me._types = _types
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ImplementsStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._implementsKeyword)
          writer.WriteValue(Me._types)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ImplementsStatementSyntax), Function(r) New ImplementsStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ImplementsStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Implements" keyword.
        ''' </summary>
        Friend  ReadOnly Property ImplementsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._implementsKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of the types being implemented.
        ''' </summary>
        Friend  ReadOnly Property Types As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of TypeSyntax)(Me._types))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._implementsKeyword
                Case 1
                    Return Me._types
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ImplementsStatementSyntax(Me.Kind, newErrors, GetAnnotations, _implementsKeyword, _types)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ImplementsStatementSyntax(Me.Kind, GetDiagnostics, annotations, _implementsKeyword, _types)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitImplementsStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Abstract class for the beginning statement of a Module, Class, Interface or
    ''' Structure declaration. This node always appears as the Begin of a TypeBlock
    ''' with Kind=ModuleDeclarationBlock, ClassDeclarationBlock,
    ''' InterfaceDeclarationBlock or StructureDeclarationBlock.
    ''' </summary>
    Friend MustInherit Class TypeStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _typeParameterList as TypeParameterListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, errors, annotations)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _attributeLists = DirectCast(reader.ReadValue(), GreenNode)
          If _attributeLists isnot Nothing 
             AdjustFlagsAndWidth(_attributeLists)
             Me._attributeLists = _attributeLists
          End If
          Dim _modifiers = DirectCast(reader.ReadValue(), GreenNode)
          If _modifiers isnot Nothing 
             AdjustFlagsAndWidth(_modifiers)
             Me._modifiers = _modifiers
          End If
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _typeParameterList = DirectCast(reader.ReadValue(), TypeParameterListSyntax)
          If _typeParameterList isnot Nothing 
             AdjustFlagsAndWidth(_typeParameterList)
             Me._typeParameterList = _typeParameterList
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._attributeLists)
          writer.WriteValue(Me._modifiers)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._typeParameterList)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The name of the type being declared.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' If present, a type parameter list with generic parameters for this type. If no
        ''' generic parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property TypeParameterList As InternalSyntax.TypeParameterListSyntax
            Get
                Return Me._typeParameterList
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Module declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=ModuleDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class ModuleStatementSyntax
        Inherits TypeStatementSyntax

        Friend ReadOnly _moduleKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, moduleKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(moduleKeyword)
            Me._moduleKeyword = moduleKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, moduleKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(moduleKeyword)
            Me._moduleKeyword = moduleKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, moduleKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(moduleKeyword)
            Me._moduleKeyword = moduleKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _moduleKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _moduleKeyword isnot Nothing 
             AdjustFlagsAndWidth(_moduleKeyword)
             Me._moduleKeyword = _moduleKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ModuleStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._moduleKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ModuleStatementSyntax), Function(r) New ModuleStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ModuleStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Module" keyword.
        ''' </summary>
        Friend  ReadOnly Property ModuleKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._moduleKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._moduleKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._typeParameterList
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ModuleStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _moduleKeyword, _identifier, _typeParameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ModuleStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _moduleKeyword, _identifier, _typeParameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitModuleStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Structure declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=StructureDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class StructureStatementSyntax
        Inherits TypeStatementSyntax

        Friend ReadOnly _structureKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, structureKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(structureKeyword)
            Me._structureKeyword = structureKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, structureKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(structureKeyword)
            Me._structureKeyword = structureKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, structureKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(structureKeyword)
            Me._structureKeyword = structureKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _structureKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _structureKeyword isnot Nothing 
             AdjustFlagsAndWidth(_structureKeyword)
             Me._structureKeyword = _structureKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New StructureStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._structureKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(StructureStatementSyntax), Function(r) New StructureStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.StructureStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Structure" keyword.
        ''' </summary>
        Friend  ReadOnly Property StructureKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._structureKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._structureKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._typeParameterList
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new StructureStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _structureKeyword, _identifier, _typeParameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new StructureStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _structureKeyword, _identifier, _typeParameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitStructureStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Interface declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=InterfaceDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class InterfaceStatementSyntax
        Inherits TypeStatementSyntax

        Friend ReadOnly _interfaceKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, interfaceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(interfaceKeyword)
            Me._interfaceKeyword = interfaceKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, interfaceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(interfaceKeyword)
            Me._interfaceKeyword = interfaceKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, interfaceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(interfaceKeyword)
            Me._interfaceKeyword = interfaceKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _interfaceKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _interfaceKeyword isnot Nothing 
             AdjustFlagsAndWidth(_interfaceKeyword)
             Me._interfaceKeyword = _interfaceKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New InterfaceStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._interfaceKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(InterfaceStatementSyntax), Function(r) New InterfaceStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.InterfaceStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Interface" keyword.
        ''' </summary>
        Friend  ReadOnly Property InterfaceKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._interfaceKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._interfaceKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._typeParameterList
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new InterfaceStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _interfaceKeyword, _identifier, _typeParameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new InterfaceStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _interfaceKeyword, _identifier, _typeParameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitInterfaceStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Class declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=ClassDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class ClassStatementSyntax
        Inherits TypeStatementSyntax

        Friend ReadOnly _classKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, classKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(classKeyword)
            Me._classKeyword = classKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, classKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(classKeyword)
            Me._classKeyword = classKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, classKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, identifier, typeParameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(classKeyword)
            Me._classKeyword = classKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _classKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _classKeyword isnot Nothing 
             AdjustFlagsAndWidth(_classKeyword)
             Me._classKeyword = _classKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ClassStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._classKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ClassStatementSyntax), Function(r) New ClassStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ClassStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Class" keyword.
        ''' </summary>
        Friend  ReadOnly Property ClassKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._classKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._classKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._typeParameterList
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ClassStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _classKeyword, _identifier, _typeParameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ClassStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _classKeyword, _identifier, _typeParameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitClassStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of an Enum declaration. This node always
    ''' appears as the Begin of an EnumBlock with Kind=EnumDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class EnumStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _enumKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _underlyingType as AsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, enumKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, underlyingType As AsClauseSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 5

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(enumKeyword)
            Me._enumKeyword = enumKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If underlyingType IsNot Nothing Then
                AdjustFlagsAndWidth(underlyingType)
                Me._underlyingType = underlyingType
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, enumKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, underlyingType As AsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(enumKeyword)
            Me._enumKeyword = enumKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If underlyingType IsNot Nothing Then
                AdjustFlagsAndWidth(underlyingType)
                Me._underlyingType = underlyingType
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, enumKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, underlyingType As AsClauseSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 5

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(enumKeyword)
            Me._enumKeyword = enumKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If underlyingType IsNot Nothing Then
                AdjustFlagsAndWidth(underlyingType)
                Me._underlyingType = underlyingType
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _attributeLists = DirectCast(reader.ReadValue(), GreenNode)
          If _attributeLists isnot Nothing 
             AdjustFlagsAndWidth(_attributeLists)
             Me._attributeLists = _attributeLists
          End If
          Dim _modifiers = DirectCast(reader.ReadValue(), GreenNode)
          If _modifiers isnot Nothing 
             AdjustFlagsAndWidth(_modifiers)
             Me._modifiers = _modifiers
          End If
          Dim _enumKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _enumKeyword isnot Nothing 
             AdjustFlagsAndWidth(_enumKeyword)
             Me._enumKeyword = _enumKeyword
          End If
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _underlyingType = DirectCast(reader.ReadValue(), AsClauseSyntax)
          If _underlyingType isnot Nothing 
             AdjustFlagsAndWidth(_underlyingType)
             Me._underlyingType = _underlyingType
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New EnumStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._attributeLists)
          writer.WriteValue(Me._modifiers)
          writer.WriteValue(Me._enumKeyword)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._underlyingType)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(EnumStatementSyntax), Function(r) New EnumStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EnumStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The "Enum" keyword.
        ''' </summary>
        Friend  ReadOnly Property EnumKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._enumKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the enum being declared.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' Optional "As XXX" clause describing the underlying type of the enumeration. If
        ''' no As clause was specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property UnderlyingType As InternalSyntax.AsClauseSyntax
            Get
                Return Me._underlyingType
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._enumKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._underlyingType
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EnumStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _enumKeyword, _identifier, _underlyingType)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EnumStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _enumKeyword, _identifier, _underlyingType)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEnumStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the type parameter list in a declaration.
    ''' </summary>
    Friend NotInheritable Class TypeParameterListSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _ofKeyword as KeywordSyntax
        Friend ReadOnly _parameters as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, ofKeyword As InternalSyntax.KeywordSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(ofKeyword)
            Me._ofKeyword = ofKeyword
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, ofKeyword As InternalSyntax.KeywordSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(ofKeyword)
            Me._ofKeyword = ofKeyword
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, ofKeyword As InternalSyntax.KeywordSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(ofKeyword)
            Me._ofKeyword = ofKeyword
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _ofKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _ofKeyword isnot Nothing 
             AdjustFlagsAndWidth(_ofKeyword)
             Me._ofKeyword = _ofKeyword
          End If
          Dim _parameters = DirectCast(reader.ReadValue(), GreenNode)
          If _parameters isnot Nothing 
             AdjustFlagsAndWidth(_parameters)
             Me._parameters = _parameters
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TypeParameterListSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._ofKeyword)
          writer.WriteValue(Me._parameters)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TypeParameterListSyntax), Function(r) New TypeParameterListSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeParameterListSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The "Of" keyword.
        ''' </summary>
        Friend  ReadOnly Property OfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._ofKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of the type parameters. There must be at least one type parameter in the
        ''' list.
        ''' </summary>
        Friend  ReadOnly Property Parameters As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeParameterSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeParameterSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of TypeParameterSyntax)(Me._parameters))
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._ofKeyword
                Case 2
                    Return Me._parameters
                Case 3
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeParameterListSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _ofKeyword, _parameters, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeParameterListSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _ofKeyword, _parameters, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeParameterList(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a type parameter on a generic type declaration.
    ''' </summary>
    Friend NotInheritable Class TypeParameterSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _varianceKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _typeParameterConstraintClause as TypeParameterConstraintClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, varianceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterConstraintClause As TypeParameterConstraintClauseSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            If varianceKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(varianceKeyword)
                Me._varianceKeyword = varianceKeyword
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterConstraintClause IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterConstraintClause)
                Me._typeParameterConstraintClause = typeParameterConstraintClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, varianceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterConstraintClause As TypeParameterConstraintClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            If varianceKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(varianceKeyword)
                Me._varianceKeyword = varianceKeyword
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterConstraintClause IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterConstraintClause)
                Me._typeParameterConstraintClause = typeParameterConstraintClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), varianceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterConstraintClause As TypeParameterConstraintClauseSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            If varianceKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(varianceKeyword)
                Me._varianceKeyword = varianceKeyword
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterConstraintClause IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterConstraintClause)
                Me._typeParameterConstraintClause = typeParameterConstraintClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _varianceKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _varianceKeyword isnot Nothing 
             AdjustFlagsAndWidth(_varianceKeyword)
             Me._varianceKeyword = _varianceKeyword
          End If
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _typeParameterConstraintClause = DirectCast(reader.ReadValue(), TypeParameterConstraintClauseSyntax)
          If _typeParameterConstraintClause isnot Nothing 
             AdjustFlagsAndWidth(_typeParameterConstraintClause)
             Me._typeParameterConstraintClause = _typeParameterConstraintClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TypeParameterSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._varianceKeyword)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._typeParameterConstraintClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TypeParameterSyntax), Function(r) New TypeParameterSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeParameterSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' Represents the "In" or "Out" variance keyword on a type parameter, if present.
        ''' If no variance modifier was present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property VarianceKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._varianceKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the type parameter
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "As" keyword, if any type constraints were supplied. If no type constraints
        ''' were supplied, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property TypeParameterConstraintClause As InternalSyntax.TypeParameterConstraintClauseSyntax
            Get
                Return Me._typeParameterConstraintClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._varianceKeyword
                Case 1
                    Return Me._identifier
                Case 2
                    Return Me._typeParameterConstraintClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeParameterSyntax(Me.Kind, newErrors, GetAnnotations, _varianceKeyword, _identifier, _typeParameterConstraintClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeParameterSyntax(Me.Kind, GetDiagnostics, annotations, _varianceKeyword, _identifier, _typeParameterConstraintClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeParameter(Me)
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that is the parent of classes that describe type
    ''' parameter constraint clauses.
    ''' </summary>
    Friend MustInherit Class TypeParameterConstraintClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' One of the type parameter constraints clauses. This represents a constraint
    ''' clause in the form of "As Constraint".
    ''' </summary>
    Friend NotInheritable Class TypeParameterSingleConstraintClauseSyntax
        Inherits TypeParameterConstraintClauseSyntax

        Friend ReadOnly _asKeyword as KeywordSyntax
        Friend ReadOnly _constraint as ConstraintSyntax

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, constraint As ConstraintSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(constraint)
            Me._constraint = constraint

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, constraint As ConstraintSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(constraint)
            Me._constraint = constraint

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, constraint As ConstraintSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(constraint)
            Me._constraint = constraint

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _asKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _asKeyword isnot Nothing 
             AdjustFlagsAndWidth(_asKeyword)
             Me._asKeyword = _asKeyword
          End If
          Dim _constraint = DirectCast(reader.ReadValue(), ConstraintSyntax)
          If _constraint isnot Nothing 
             AdjustFlagsAndWidth(_constraint)
             Me._constraint = _constraint
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TypeParameterSingleConstraintClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._asKeyword)
          writer.WriteValue(Me._constraint)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TypeParameterSingleConstraintClauseSyntax), Function(r) New TypeParameterSingleConstraintClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeParameterSingleConstraintClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "As" keyword, if any type constraints were supplied. If no type constraints
        ''' were supplied, Nothing is returned.
        ''' </summary>
        Friend  ReadOnly Property AsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._asKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of the supplied constraints. If no constraints were supplied, Nothing is
        ''' returned.
        ''' </summary>
        Friend  ReadOnly Property Constraint As InternalSyntax.ConstraintSyntax
            Get
                Return Me._constraint
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._asKeyword
                Case 1
                    Return Me._constraint
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeParameterSingleConstraintClauseSyntax(Me.Kind, newErrors, GetAnnotations, _asKeyword, _constraint)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeParameterSingleConstraintClauseSyntax(Me.Kind, GetDiagnostics, annotations, _asKeyword, _constraint)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeParameterSingleConstraintClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' One of the type parameter constraints clauses. This represents a constraint
    ''' clause in the form of "As { Constraints }".
    ''' </summary>
    Friend NotInheritable Class TypeParameterMultipleConstraintClauseSyntax
        Inherits TypeParameterConstraintClauseSyntax

        Friend ReadOnly _asKeyword as KeywordSyntax
        Friend ReadOnly _openBraceToken as PunctuationSyntax
        Friend ReadOnly _constraints as GreenNode
        Friend ReadOnly _closeBraceToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, constraints As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If constraints IsNot Nothing Then
                AdjustFlagsAndWidth(constraints)
                Me._constraints = constraints
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, constraints As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If constraints IsNot Nothing Then
                AdjustFlagsAndWidth(constraints)
                Me._constraints = constraints
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, constraints As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If constraints IsNot Nothing Then
                AdjustFlagsAndWidth(constraints)
                Me._constraints = constraints
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _asKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _asKeyword isnot Nothing 
             AdjustFlagsAndWidth(_asKeyword)
             Me._asKeyword = _asKeyword
          End If
          Dim _openBraceToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openBraceToken isnot Nothing 
             AdjustFlagsAndWidth(_openBraceToken)
             Me._openBraceToken = _openBraceToken
          End If
          Dim _constraints = DirectCast(reader.ReadValue(), GreenNode)
          If _constraints isnot Nothing 
             AdjustFlagsAndWidth(_constraints)
             Me._constraints = _constraints
          End If
          Dim _closeBraceToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeBraceToken isnot Nothing 
             AdjustFlagsAndWidth(_closeBraceToken)
             Me._closeBraceToken = _closeBraceToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TypeParameterMultipleConstraintClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._asKeyword)
          writer.WriteValue(Me._openBraceToken)
          writer.WriteValue(Me._constraints)
          writer.WriteValue(Me._closeBraceToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TypeParameterMultipleConstraintClauseSyntax), Function(r) New TypeParameterMultipleConstraintClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeParameterMultipleConstraintClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "As" keyword.
        ''' </summary>
        Friend  ReadOnly Property AsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._asKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "{" token.
        ''' </summary>
        Friend  ReadOnly Property OpenBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openBraceToken
            End Get
        End Property

        ''' <summary>
        ''' A list of the supplied constraints. If no constraints were supplied, an empty
        ''' list is returned.
        ''' </summary>
        Friend  ReadOnly Property Constraints As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ConstraintSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ConstraintSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ConstraintSyntax)(Me._constraints))
            End Get
        End Property

        ''' <summary>
        ''' The "}" token.
        ''' </summary>
        Friend  ReadOnly Property CloseBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeBraceToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._asKeyword
                Case 1
                    Return Me._openBraceToken
                Case 2
                    Return Me._constraints
                Case 3
                    Return Me._closeBraceToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeParameterMultipleConstraintClauseSyntax(Me.Kind, newErrors, GetAnnotations, _asKeyword, _openBraceToken, _constraints, _closeBraceToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeParameterMultipleConstraintClauseSyntax(Me.Kind, GetDiagnostics, annotations, _asKeyword, _openBraceToken, _constraints, _closeBraceToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeParameterMultipleConstraintClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that is the parent of classes that describe type
    ''' parameter constraints.
    ''' </summary>
    Friend MustInherit Class ConstraintSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' One of the special type parameter constraints: New, Class or Structure. Which
    ''' kind of special constraint it is can be obtained from the Kind property and is
    ''' one of: NewConstraint, ReferenceConstraint or ValueConstraint.
    ''' </summary>
    Friend NotInheritable Class SpecialConstraintSyntax
        Inherits ConstraintSyntax

        Friend ReadOnly _constraintKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, constraintKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(constraintKeyword)
            Me._constraintKeyword = constraintKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, constraintKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(constraintKeyword)
            Me._constraintKeyword = constraintKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), constraintKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(constraintKeyword)
            Me._constraintKeyword = constraintKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _constraintKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _constraintKeyword isnot Nothing 
             AdjustFlagsAndWidth(_constraintKeyword)
             Me._constraintKeyword = _constraintKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SpecialConstraintSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._constraintKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SpecialConstraintSyntax), Function(r) New SpecialConstraintSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SpecialConstraintSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "New", "Class" or "Structure" keyword that denotes the kind of special
        ''' constraint.
        ''' </summary>
        Friend  ReadOnly Property ConstraintKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._constraintKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._constraintKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SpecialConstraintSyntax(Me.Kind, newErrors, GetAnnotations, _constraintKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SpecialConstraintSyntax(Me.Kind, GetDiagnostics, annotations, _constraintKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSpecialConstraint(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a type parameter constraint that is a type.
    ''' </summary>
    Friend NotInheritable Class TypeConstraintSyntax
        Inherits ConstraintSyntax

        Friend ReadOnly _type as TypeSyntax

        Friend Sub New(ByVal kind As SyntaxKind, type As TypeSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, type As TypeSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), type As TypeSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _type = DirectCast(reader.ReadValue(), TypeSyntax)
          If _type isnot Nothing 
             AdjustFlagsAndWidth(_type)
             Me._type = _type
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TypeConstraintSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._type)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TypeConstraintSyntax), Function(r) New TypeConstraintSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeConstraintSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The type describing the constraint.
        ''' </summary>
        Friend  ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._type
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeConstraintSyntax(Me.Kind, newErrors, GetAnnotations, _type)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeConstraintSyntax(Me.Kind, GetDiagnostics, annotations, _type)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeConstraint(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a name and value in an EnumDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class EnumMemberDeclarationSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _initializer as EqualsValueSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, initializer As EqualsValueSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, initializer As EqualsValueSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, initializer As EqualsValueSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _attributeLists = DirectCast(reader.ReadValue(), GreenNode)
          If _attributeLists isnot Nothing 
             AdjustFlagsAndWidth(_attributeLists)
             Me._attributeLists = _attributeLists
          End If
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _initializer = DirectCast(reader.ReadValue(), EqualsValueSyntax)
          If _initializer isnot Nothing 
             AdjustFlagsAndWidth(_initializer)
             Me._initializer = _initializer
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New EnumMemberDeclarationSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._attributeLists)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._initializer)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(EnumMemberDeclarationSyntax), Function(r) New EnumMemberDeclarationSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EnumMemberDeclarationSyntax(Me, parent, startLocation)
        End Function

        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' An optional value for the enum member.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Initializer As InternalSyntax.EqualsValueSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._identifier
                Case 2
                    Return Me._initializer
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EnumMemberDeclarationSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _identifier, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EnumMemberDeclarationSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _identifier, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEnumMemberDeclaration(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a block member declaration: A declaration that has a beginning
    ''' declaration, a body of executable statements and an end statement. Examples
    ''' include methods, constructors, operators, property accessors and custom event
    ''' accessors.
    ''' </summary>
    Friend MustInherit Class MethodBlockBaseSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, statements As GreenNode)
            MyBase.New(kind)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), statements As GreenNode)
            MyBase.New(kind, errors, annotations)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._statements)
        End Sub

        ''' <summary>
        ''' The statements contained in the block statement. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents a Function or Sub block declaration: A declaration that has a
    ''' beginning declaration, a body of executable statements and an end statement.
    ''' </summary>
    Friend NotInheritable Class MethodBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend ReadOnly _subOrFunctionStatement as MethodStatementSyntax
        Friend ReadOnly _endSubOrFunctionStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionStatement As MethodStatementSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax)
            MyBase.New(kind, statements)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(subOrFunctionStatement)
            Me._subOrFunctionStatement = subOrFunctionStatement
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionStatement As MethodStatementSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subOrFunctionStatement)
            Me._subOrFunctionStatement = subOrFunctionStatement
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subOrFunctionStatement As MethodStatementSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, statements)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(subOrFunctionStatement)
            Me._subOrFunctionStatement = subOrFunctionStatement
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _subOrFunctionStatement = DirectCast(reader.ReadValue(), MethodStatementSyntax)
          If _subOrFunctionStatement isnot Nothing 
             AdjustFlagsAndWidth(_subOrFunctionStatement)
             Me._subOrFunctionStatement = _subOrFunctionStatement
          End If
          Dim _endSubOrFunctionStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endSubOrFunctionStatement isnot Nothing 
             AdjustFlagsAndWidth(_endSubOrFunctionStatement)
             Me._endSubOrFunctionStatement = _endSubOrFunctionStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New MethodBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._subOrFunctionStatement)
          writer.WriteValue(Me._endSubOrFunctionStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(MethodBlockSyntax), Function(r) New MethodBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MethodBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Sub" or "Function" statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property SubOrFunctionStatement As InternalSyntax.MethodStatementSyntax
            Get
                Return Me._subOrFunctionStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Sub" or "End Function" statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndSubOrFunctionStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endSubOrFunctionStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._subOrFunctionStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endSubOrFunctionStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MethodBlockSyntax(Me.Kind, newErrors, GetAnnotations, _subOrFunctionStatement, _statements, _endSubOrFunctionStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MethodBlockSyntax(Me.Kind, GetDiagnostics, annotations, _subOrFunctionStatement, _statements, _endSubOrFunctionStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMethodBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a constructor block declaration: A declaration that has a beginning
    ''' declaration, a body of executable statements and an end statement.
    ''' </summary>
    Friend NotInheritable Class ConstructorBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend ReadOnly _subNewStatement as SubNewStatementSyntax
        Friend ReadOnly _endSubStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, subNewStatement As SubNewStatementSyntax, statements As GreenNode, endSubStatement As EndBlockStatementSyntax)
            MyBase.New(kind, statements)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(subNewStatement)
            Me._subNewStatement = subNewStatement
            AdjustFlagsAndWidth(endSubStatement)
            Me._endSubStatement = endSubStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, subNewStatement As SubNewStatementSyntax, statements As GreenNode, endSubStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subNewStatement)
            Me._subNewStatement = subNewStatement
            AdjustFlagsAndWidth(endSubStatement)
            Me._endSubStatement = endSubStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subNewStatement As SubNewStatementSyntax, statements As GreenNode, endSubStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, statements)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(subNewStatement)
            Me._subNewStatement = subNewStatement
            AdjustFlagsAndWidth(endSubStatement)
            Me._endSubStatement = endSubStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _subNewStatement = DirectCast(reader.ReadValue(), SubNewStatementSyntax)
          If _subNewStatement isnot Nothing 
             AdjustFlagsAndWidth(_subNewStatement)
             Me._subNewStatement = _subNewStatement
          End If
          Dim _endSubStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endSubStatement isnot Nothing 
             AdjustFlagsAndWidth(_endSubStatement)
             Me._endSubStatement = _endSubStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ConstructorBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._subNewStatement)
          writer.WriteValue(Me._endSubStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ConstructorBlockSyntax), Function(r) New ConstructorBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ConstructorBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Sub New" statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property SubNewStatement As InternalSyntax.SubNewStatementSyntax
            Get
                Return Me._subNewStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Sub" statement that ends the block declaration.
        ''' </summary>
        Friend  ReadOnly Property EndSubStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endSubStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._subNewStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endSubStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ConstructorBlockSyntax(Me.Kind, newErrors, GetAnnotations, _subNewStatement, _statements, _endSubStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ConstructorBlockSyntax(Me.Kind, GetDiagnostics, annotations, _subNewStatement, _statements, _endSubStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitConstructorBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an Operator block member declaration: A declaration that has a
    ''' beginning declaration, a body of executable statements and an end statement.
    ''' </summary>
    Friend NotInheritable Class OperatorBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend ReadOnly _operatorStatement as OperatorStatementSyntax
        Friend ReadOnly _endOperatorStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, operatorStatement As OperatorStatementSyntax, statements As GreenNode, endOperatorStatement As EndBlockStatementSyntax)
            MyBase.New(kind, statements)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(operatorStatement)
            Me._operatorStatement = operatorStatement
            AdjustFlagsAndWidth(endOperatorStatement)
            Me._endOperatorStatement = endOperatorStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, operatorStatement As OperatorStatementSyntax, statements As GreenNode, endOperatorStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(operatorStatement)
            Me._operatorStatement = operatorStatement
            AdjustFlagsAndWidth(endOperatorStatement)
            Me._endOperatorStatement = endOperatorStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), operatorStatement As OperatorStatementSyntax, statements As GreenNode, endOperatorStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, statements)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(operatorStatement)
            Me._operatorStatement = operatorStatement
            AdjustFlagsAndWidth(endOperatorStatement)
            Me._endOperatorStatement = endOperatorStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _operatorStatement = DirectCast(reader.ReadValue(), OperatorStatementSyntax)
          If _operatorStatement isnot Nothing 
             AdjustFlagsAndWidth(_operatorStatement)
             Me._operatorStatement = _operatorStatement
          End If
          Dim _endOperatorStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endOperatorStatement isnot Nothing 
             AdjustFlagsAndWidth(_endOperatorStatement)
             Me._endOperatorStatement = _endOperatorStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New OperatorBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._operatorStatement)
          writer.WriteValue(Me._endOperatorStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(OperatorBlockSyntax), Function(r) New OperatorBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OperatorBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Operator" statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property OperatorStatement As InternalSyntax.OperatorStatementSyntax
            Get
                Return Me._operatorStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Operator" statement that ends the block declaration.
        ''' </summary>
        Friend  ReadOnly Property EndOperatorStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endOperatorStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._operatorStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endOperatorStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OperatorBlockSyntax(Me.Kind, newErrors, GetAnnotations, _operatorStatement, _statements, _endOperatorStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OperatorBlockSyntax(Me.Kind, GetDiagnostics, annotations, _operatorStatement, _statements, _endOperatorStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOperatorBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an accessor block member declaration: A declaration that has a
    ''' beginning declaration, a body of executable statements and an end statement.
    ''' Examples include property accessors and custom event accessors.
    ''' </summary>
    Friend NotInheritable Class AccessorBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend ReadOnly _accessorStatement as AccessorStatementSyntax
        Friend ReadOnly _endAccessorStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, accessorStatement As AccessorStatementSyntax, statements As GreenNode, endAccessorStatement As EndBlockStatementSyntax)
            MyBase.New(kind, statements)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(accessorStatement)
            Me._accessorStatement = accessorStatement
            AdjustFlagsAndWidth(endAccessorStatement)
            Me._endAccessorStatement = endAccessorStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, accessorStatement As AccessorStatementSyntax, statements As GreenNode, endAccessorStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(accessorStatement)
            Me._accessorStatement = accessorStatement
            AdjustFlagsAndWidth(endAccessorStatement)
            Me._endAccessorStatement = endAccessorStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), accessorStatement As AccessorStatementSyntax, statements As GreenNode, endAccessorStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, statements)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(accessorStatement)
            Me._accessorStatement = accessorStatement
            AdjustFlagsAndWidth(endAccessorStatement)
            Me._endAccessorStatement = endAccessorStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _accessorStatement = DirectCast(reader.ReadValue(), AccessorStatementSyntax)
          If _accessorStatement isnot Nothing 
             AdjustFlagsAndWidth(_accessorStatement)
             Me._accessorStatement = _accessorStatement
          End If
          Dim _endAccessorStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endAccessorStatement isnot Nothing 
             AdjustFlagsAndWidth(_endAccessorStatement)
             Me._endAccessorStatement = _endAccessorStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New AccessorBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._accessorStatement)
          writer.WriteValue(Me._endAccessorStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(AccessorBlockSyntax), Function(r) New AccessorBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AccessorBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Get", "Set", "AddHandler", "RemoveHandler", or "RaiseEvent" statement that
        ''' begins the accessor block.
        ''' </summary>
        Friend  ReadOnly Property AccessorStatement As InternalSyntax.AccessorStatementSyntax
            Get
                Return Me._accessorStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Get", "End Set", "End AddHandler", "End RemoveHandler", or "End
        ''' RaiseEvent" statement that ends the accessor block.
        ''' </summary>
        Friend  ReadOnly Property EndAccessorStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endAccessorStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._accessorStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endAccessorStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AccessorBlockSyntax(Me.Kind, newErrors, GetAnnotations, _accessorStatement, _statements, _endAccessorStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AccessorBlockSyntax(Me.Kind, GetDiagnostics, annotations, _accessorStatement, _statements, _endAccessorStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAccessorBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a block property declaration: A declaration that has a beginning
    ''' declaration, some get or set accessor blocks and an end statement.
    ''' </summary>
    Friend NotInheritable Class PropertyBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _propertyStatement as PropertyStatementSyntax
        Friend ReadOnly _accessors as GreenNode
        Friend ReadOnly _endPropertyStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, propertyStatement As PropertyStatementSyntax, accessors As GreenNode, endPropertyStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(propertyStatement)
            Me._propertyStatement = propertyStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endPropertyStatement)
            Me._endPropertyStatement = endPropertyStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, propertyStatement As PropertyStatementSyntax, accessors As GreenNode, endPropertyStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(propertyStatement)
            Me._propertyStatement = propertyStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endPropertyStatement)
            Me._endPropertyStatement = endPropertyStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), propertyStatement As PropertyStatementSyntax, accessors As GreenNode, endPropertyStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(propertyStatement)
            Me._propertyStatement = propertyStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endPropertyStatement)
            Me._endPropertyStatement = endPropertyStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _propertyStatement = DirectCast(reader.ReadValue(), PropertyStatementSyntax)
          If _propertyStatement isnot Nothing 
             AdjustFlagsAndWidth(_propertyStatement)
             Me._propertyStatement = _propertyStatement
          End If
          Dim _accessors = DirectCast(reader.ReadValue(), GreenNode)
          If _accessors isnot Nothing 
             AdjustFlagsAndWidth(_accessors)
             Me._accessors = _accessors
          End If
          Dim _endPropertyStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endPropertyStatement isnot Nothing 
             AdjustFlagsAndWidth(_endPropertyStatement)
             Me._endPropertyStatement = _endPropertyStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New PropertyBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._propertyStatement)
          writer.WriteValue(Me._accessors)
          writer.WriteValue(Me._endPropertyStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(PropertyBlockSyntax), Function(r) New PropertyBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.PropertyBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The property declaration that begins the block.
        ''' </summary>
        Friend  ReadOnly Property PropertyStatement As InternalSyntax.PropertyStatementSyntax
            Get
                Return Me._propertyStatement
            End Get
        End Property

        ''' <summary>
        ''' The accessor blocks contained in the property, between the Property and the End
        ''' Property statements.
        ''' </summary>
        Friend  ReadOnly Property Accessors As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AccessorBlockSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AccessorBlockSyntax)(Me._accessors)
            End Get
        End Property

        ''' <summary>
        ''' The End Property statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndPropertyStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endPropertyStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._propertyStatement
                Case 1
                    Return Me._accessors
                Case 2
                    Return Me._endPropertyStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new PropertyBlockSyntax(Me.Kind, newErrors, GetAnnotations, _propertyStatement, _accessors, _endPropertyStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new PropertyBlockSyntax(Me.Kind, GetDiagnostics, annotations, _propertyStatement, _accessors, _endPropertyStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitPropertyBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a custom event declaration: A declaration that has a beginning event
    ''' declaration, some accessor blocks and an end statement.
    ''' </summary>
    Friend NotInheritable Class EventBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _eventStatement as EventStatementSyntax
        Friend ReadOnly _accessors as GreenNode
        Friend ReadOnly _endEventStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, eventStatement As EventStatementSyntax, accessors As GreenNode, endEventStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(eventStatement)
            Me._eventStatement = eventStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endEventStatement)
            Me._endEventStatement = endEventStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, eventStatement As EventStatementSyntax, accessors As GreenNode, endEventStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(eventStatement)
            Me._eventStatement = eventStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endEventStatement)
            Me._endEventStatement = endEventStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), eventStatement As EventStatementSyntax, accessors As GreenNode, endEventStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(eventStatement)
            Me._eventStatement = eventStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endEventStatement)
            Me._endEventStatement = endEventStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _eventStatement = DirectCast(reader.ReadValue(), EventStatementSyntax)
          If _eventStatement isnot Nothing 
             AdjustFlagsAndWidth(_eventStatement)
             Me._eventStatement = _eventStatement
          End If
          Dim _accessors = DirectCast(reader.ReadValue(), GreenNode)
          If _accessors isnot Nothing 
             AdjustFlagsAndWidth(_accessors)
             Me._accessors = _accessors
          End If
          Dim _endEventStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endEventStatement isnot Nothing 
             AdjustFlagsAndWidth(_endEventStatement)
             Me._endEventStatement = _endEventStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New EventBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._eventStatement)
          writer.WriteValue(Me._accessors)
          writer.WriteValue(Me._endEventStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(EventBlockSyntax), Function(r) New EventBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EventBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The event declaration that begins the block.
        ''' </summary>
        Friend  ReadOnly Property EventStatement As InternalSyntax.EventStatementSyntax
            Get
                Return Me._eventStatement
            End Get
        End Property

        ''' <summary>
        ''' The accessor blocks contained in the custom event declaration, between the
        ''' Event statement and the End Event statement.
        ''' </summary>
        Friend  ReadOnly Property Accessors As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AccessorBlockSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AccessorBlockSyntax)(Me._accessors)
            End Get
        End Property

        ''' <summary>
        ''' The End Event statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndEventStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endEventStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._eventStatement
                Case 1
                    Return Me._accessors
                Case 2
                    Return Me._endEventStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EventBlockSyntax(Me.Kind, newErrors, GetAnnotations, _eventStatement, _accessors, _endEventStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EventBlockSyntax(Me.Kind, GetDiagnostics, annotations, _eventStatement, _accessors, _endEventStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEventBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that is the parent for declarations that are
    ''' "method-like"; i.e., that have a parameter list and return type. This includes
    ''' methods, constructors, properties, events, operators, declares, delegates,
    ''' property accessors and custom event accessors.
    ''' </summary>
    Friend MustInherit Class MethodBaseSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _parameterList as ParameterListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, parameterList As ParameterListSyntax)
            MyBase.New(kind)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If parameterList IsNot Nothing Then
                AdjustFlagsAndWidth(parameterList)
                Me._parameterList = parameterList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, parameterList As ParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If parameterList IsNot Nothing Then
                AdjustFlagsAndWidth(parameterList)
                Me._parameterList = parameterList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, parameterList As ParameterListSyntax)
            MyBase.New(kind, errors, annotations)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If parameterList IsNot Nothing Then
                AdjustFlagsAndWidth(parameterList)
                Me._parameterList = parameterList
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _attributeLists = DirectCast(reader.ReadValue(), GreenNode)
          If _attributeLists isnot Nothing 
             AdjustFlagsAndWidth(_attributeLists)
             Me._attributeLists = _attributeLists
          End If
          Dim _modifiers = DirectCast(reader.ReadValue(), GreenNode)
          If _modifiers isnot Nothing 
             AdjustFlagsAndWidth(_modifiers)
             Me._modifiers = _modifiers
          End If
          Dim _parameterList = DirectCast(reader.ReadValue(), ParameterListSyntax)
          If _parameterList isnot Nothing 
             AdjustFlagsAndWidth(_parameterList)
             Me._parameterList = _parameterList
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._attributeLists)
          writer.WriteValue(Me._modifiers)
          writer.WriteValue(Me._parameterList)
        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned. A bitfield version of all
        ''' the modifiers ORed together, which is in many cases easier to use, can be
        ''' obtained with the Modifiers property.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The method's parameter list including the parentheses. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ParameterList As InternalSyntax.ParameterListSyntax
            Get
                Return Me._parameterList
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents the parameter list in a method declaration.
    ''' </summary>
    Friend NotInheritable Class ParameterListSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _parameters as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _parameters = DirectCast(reader.ReadValue(), GreenNode)
          If _parameters isnot Nothing 
             AdjustFlagsAndWidth(_parameters)
             Me._parameters = _parameters
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ParameterListSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._parameters)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ParameterListSyntax), Function(r) New ParameterListSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ParameterListSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token that introduces the parameter list. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The list of parameters. If no parameter list was present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Parameters As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ParameterSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ParameterSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ParameterSyntax)(Me._parameters))
            End Get
        End Property

        ''' <summary>
        ''' The ")" token that concludes the parameter list. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._parameters
                Case 2
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ParameterListSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _parameters, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ParameterListSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _parameters, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitParameterList(Me)
        End Function

    End Class

    ''' <summary>
    ''' The statement that declares a Sub or Function. If this method has a body, this
    ''' statement will be the Begin of a BlockStatement with
    ''' Kind=MethodDeclarationBlock, and the body of the method will be the Body of
    ''' that BlockStatement.
    ''' </summary>
    Friend NotInheritable Class MethodStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _subOrFunctionKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _typeParameterList as TypeParameterListSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax
        Friend ReadOnly _handlesClause as HandlesClauseSyntax
        Friend ReadOnly _implementsClause as ImplementsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, handlesClause As HandlesClauseSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 9

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If handlesClause IsNot Nothing Then
                AdjustFlagsAndWidth(handlesClause)
                Me._handlesClause = handlesClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, handlesClause As HandlesClauseSyntax, implementsClause As ImplementsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 9
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If handlesClause IsNot Nothing Then
                AdjustFlagsAndWidth(handlesClause)
                Me._handlesClause = handlesClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, handlesClause As HandlesClauseSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 9

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If handlesClause IsNot Nothing Then
                AdjustFlagsAndWidth(handlesClause)
                Me._handlesClause = handlesClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 9
          Dim _subOrFunctionKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _subOrFunctionKeyword isnot Nothing 
             AdjustFlagsAndWidth(_subOrFunctionKeyword)
             Me._subOrFunctionKeyword = _subOrFunctionKeyword
          End If
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _typeParameterList = DirectCast(reader.ReadValue(), TypeParameterListSyntax)
          If _typeParameterList isnot Nothing 
             AdjustFlagsAndWidth(_typeParameterList)
             Me._typeParameterList = _typeParameterList
          End If
          Dim _asClause = DirectCast(reader.ReadValue(), SimpleAsClauseSyntax)
          If _asClause isnot Nothing 
             AdjustFlagsAndWidth(_asClause)
             Me._asClause = _asClause
          End If
          Dim _handlesClause = DirectCast(reader.ReadValue(), HandlesClauseSyntax)
          If _handlesClause isnot Nothing 
             AdjustFlagsAndWidth(_handlesClause)
             Me._handlesClause = _handlesClause
          End If
          Dim _implementsClause = DirectCast(reader.ReadValue(), ImplementsClauseSyntax)
          If _implementsClause isnot Nothing 
             AdjustFlagsAndWidth(_implementsClause)
             Me._implementsClause = _implementsClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New MethodStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._subOrFunctionKeyword)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._typeParameterList)
          writer.WriteValue(Me._asClause)
          writer.WriteValue(Me._handlesClause)
          writer.WriteValue(Me._implementsClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(MethodStatementSyntax), Function(r) New MethodStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MethodStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Sub" or "Function" keyword that introduces this method declaration.
        ''' </summary>
        Friend  ReadOnly Property SubOrFunctionKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._subOrFunctionKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the method being declared.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' If present, a type parameter list with generic type parameters for this method.
        ''' If no generic type parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property TypeParameterList As InternalSyntax.TypeParameterListSyntax
            Get
                Return Me._typeParameterList
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' If present, a Handles clause indicated the events that this method handles.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property HandlesClause As InternalSyntax.HandlesClauseSyntax
            Get
                Return Me._handlesClause
            End Get
        End Property

        ''' <summary>
        ''' If present, an Implements clause indicated the interface methods that this
        ''' method implements.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ImplementsClause As InternalSyntax.ImplementsClauseSyntax
            Get
                Return Me._implementsClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._subOrFunctionKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._typeParameterList
                Case 5
                    Return Me._parameterList
                Case 6
                    Return Me._asClause
                Case 7
                    Return Me._handlesClause
                Case 8
                    Return Me._implementsClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MethodStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _subOrFunctionKeyword, _identifier, _typeParameterList, _parameterList, _asClause, _handlesClause, _implementsClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MethodStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _subOrFunctionKeyword, _identifier, _typeParameterList, _parameterList, _asClause, _handlesClause, _implementsClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMethodStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares a constructor. This statement will be the Begin of a
    ''' BlockStatement with Kind=MethodDeclarationBlock, and the body of the method
    ''' will be the Body of that BlockStatement.
    ''' </summary>
    Friend NotInheritable Class SubNewStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _subKeyword as KeywordSyntax
        Friend ReadOnly _newKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subKeyword As InternalSyntax.KeywordSyntax, newKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(subKeyword)
            Me._subKeyword = subKeyword
            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subKeyword As InternalSyntax.KeywordSyntax, newKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subKeyword)
            Me._subKeyword = subKeyword
            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, subKeyword As InternalSyntax.KeywordSyntax, newKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(subKeyword)
            Me._subKeyword = subKeyword
            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _subKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _subKeyword isnot Nothing 
             AdjustFlagsAndWidth(_subKeyword)
             Me._subKeyword = _subKeyword
          End If
          Dim _newKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _newKeyword isnot Nothing 
             AdjustFlagsAndWidth(_newKeyword)
             Me._newKeyword = _newKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SubNewStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._subKeyword)
          writer.WriteValue(Me._newKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SubNewStatementSyntax), Function(r) New SubNewStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SubNewStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Sub" keyword.
        ''' </summary>
        Friend  ReadOnly Property SubKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._subKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "New" keyword in the constructor declaration.
        ''' </summary>
        Friend  ReadOnly Property NewKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._newKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._subKeyword
                Case 3
                    Return Me._newKeyword
                Case 4
                    Return Me._parameterList
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SubNewStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _subKeyword, _newKeyword, _parameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SubNewStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _subKeyword, _newKeyword, _parameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSubNewStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A Declare statement that declares an external DLL method.
    ''' </summary>
    Friend NotInheritable Class DeclareStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _declareKeyword as KeywordSyntax
        Friend ReadOnly _charsetKeyword as KeywordSyntax
        Friend ReadOnly _subOrFunctionKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _libKeyword as KeywordSyntax
        Friend ReadOnly _libraryName as LiteralExpressionSyntax
        Friend ReadOnly _aliasKeyword as KeywordSyntax
        Friend ReadOnly _aliasName as LiteralExpressionSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, declareKeyword As InternalSyntax.KeywordSyntax, charsetKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, libKeyword As InternalSyntax.KeywordSyntax, libraryName As LiteralExpressionSyntax, aliasKeyword As InternalSyntax.KeywordSyntax, aliasName As LiteralExpressionSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 12

            AdjustFlagsAndWidth(declareKeyword)
            Me._declareKeyword = declareKeyword
            If charsetKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(charsetKeyword)
                Me._charsetKeyword = charsetKeyword
            End If
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(libKeyword)
            Me._libKeyword = libKeyword
            AdjustFlagsAndWidth(libraryName)
            Me._libraryName = libraryName
            If aliasKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(aliasKeyword)
                Me._aliasKeyword = aliasKeyword
            End If
            If aliasName IsNot Nothing Then
                AdjustFlagsAndWidth(aliasName)
                Me._aliasName = aliasName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, declareKeyword As InternalSyntax.KeywordSyntax, charsetKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, libKeyword As InternalSyntax.KeywordSyntax, libraryName As LiteralExpressionSyntax, aliasKeyword As InternalSyntax.KeywordSyntax, aliasName As LiteralExpressionSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 12
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(declareKeyword)
            Me._declareKeyword = declareKeyword
            If charsetKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(charsetKeyword)
                Me._charsetKeyword = charsetKeyword
            End If
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(libKeyword)
            Me._libKeyword = libKeyword
            AdjustFlagsAndWidth(libraryName)
            Me._libraryName = libraryName
            If aliasKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(aliasKeyword)
                Me._aliasKeyword = aliasKeyword
            End If
            If aliasName IsNot Nothing Then
                AdjustFlagsAndWidth(aliasName)
                Me._aliasName = aliasName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, declareKeyword As InternalSyntax.KeywordSyntax, charsetKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, libKeyword As InternalSyntax.KeywordSyntax, libraryName As LiteralExpressionSyntax, aliasKeyword As InternalSyntax.KeywordSyntax, aliasName As LiteralExpressionSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 12

            AdjustFlagsAndWidth(declareKeyword)
            Me._declareKeyword = declareKeyword
            If charsetKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(charsetKeyword)
                Me._charsetKeyword = charsetKeyword
            End If
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(libKeyword)
            Me._libKeyword = libKeyword
            AdjustFlagsAndWidth(libraryName)
            Me._libraryName = libraryName
            If aliasKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(aliasKeyword)
                Me._aliasKeyword = aliasKeyword
            End If
            If aliasName IsNot Nothing Then
                AdjustFlagsAndWidth(aliasName)
                Me._aliasName = aliasName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 12
          Dim _declareKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _declareKeyword isnot Nothing 
             AdjustFlagsAndWidth(_declareKeyword)
             Me._declareKeyword = _declareKeyword
          End If
          Dim _charsetKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _charsetKeyword isnot Nothing 
             AdjustFlagsAndWidth(_charsetKeyword)
             Me._charsetKeyword = _charsetKeyword
          End If
          Dim _subOrFunctionKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _subOrFunctionKeyword isnot Nothing 
             AdjustFlagsAndWidth(_subOrFunctionKeyword)
             Me._subOrFunctionKeyword = _subOrFunctionKeyword
          End If
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _libKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _libKeyword isnot Nothing 
             AdjustFlagsAndWidth(_libKeyword)
             Me._libKeyword = _libKeyword
          End If
          Dim _libraryName = DirectCast(reader.ReadValue(), LiteralExpressionSyntax)
          If _libraryName isnot Nothing 
             AdjustFlagsAndWidth(_libraryName)
             Me._libraryName = _libraryName
          End If
          Dim _aliasKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _aliasKeyword isnot Nothing 
             AdjustFlagsAndWidth(_aliasKeyword)
             Me._aliasKeyword = _aliasKeyword
          End If
          Dim _aliasName = DirectCast(reader.ReadValue(), LiteralExpressionSyntax)
          If _aliasName isnot Nothing 
             AdjustFlagsAndWidth(_aliasName)
             Me._aliasName = _aliasName
          End If
          Dim _asClause = DirectCast(reader.ReadValue(), SimpleAsClauseSyntax)
          If _asClause isnot Nothing 
             AdjustFlagsAndWidth(_asClause)
             Me._asClause = _asClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New DeclareStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._declareKeyword)
          writer.WriteValue(Me._charsetKeyword)
          writer.WriteValue(Me._subOrFunctionKeyword)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._libKeyword)
          writer.WriteValue(Me._libraryName)
          writer.WriteValue(Me._aliasKeyword)
          writer.WriteValue(Me._aliasName)
          writer.WriteValue(Me._asClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(DeclareStatementSyntax), Function(r) New DeclareStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.DeclareStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Declare" keyword.
        ''' </summary>
        Friend  ReadOnly Property DeclareKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._declareKeyword
            End Get
        End Property

        ''' <summary>
        ''' If present, the keyword that defines the string translation semantics of the
        ''' external method.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property CharsetKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._charsetKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Sub" or "Function" keyword.
        ''' </summary>
        Friend  ReadOnly Property SubOrFunctionKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._subOrFunctionKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the method being declared.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "Lib" keyword.
        ''' </summary>
        Friend  ReadOnly Property LibKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._libKeyword
            End Get
        End Property

        ''' <summary>
        ''' The string literal with the library name.
        ''' </summary>
        Friend  ReadOnly Property LibraryName As InternalSyntax.LiteralExpressionSyntax
            Get
                Return Me._libraryName
            End Get
        End Property

        ''' <summary>
        ''' If present, the "Alias" keyword. If not present, returns Nothing.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AliasKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._aliasKeyword
            End Get
        End Property

        ''' <summary>
        ''' The string literal with the alias. If not present, returns Nothing.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AliasName As InternalSyntax.LiteralExpressionSyntax
            Get
                Return Me._aliasName
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._declareKeyword
                Case 3
                    Return Me._charsetKeyword
                Case 4
                    Return Me._subOrFunctionKeyword
                Case 5
                    Return Me._identifier
                Case 6
                    Return Me._libKeyword
                Case 7
                    Return Me._libraryName
                Case 8
                    Return Me._aliasKeyword
                Case 9
                    Return Me._aliasName
                Case 10
                    Return Me._parameterList
                Case 11
                    Return Me._asClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new DeclareStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _declareKeyword, _charsetKeyword, _subOrFunctionKeyword, _identifier, _libKeyword, _libraryName, _aliasKeyword, _aliasName, _parameterList, _asClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new DeclareStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _declareKeyword, _charsetKeyword, _subOrFunctionKeyword, _identifier, _libKeyword, _libraryName, _aliasKeyword, _aliasName, _parameterList, _asClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitDeclareStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares a delegate type.
    ''' </summary>
    Friend NotInheritable Class DelegateStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _delegateKeyword as KeywordSyntax
        Friend ReadOnly _subOrFunctionKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _typeParameterList as TypeParameterListSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, delegateKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 8

            AdjustFlagsAndWidth(delegateKeyword)
            Me._delegateKeyword = delegateKeyword
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, delegateKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 8
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(delegateKeyword)
            Me._delegateKeyword = delegateKeyword
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, delegateKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 8

            AdjustFlagsAndWidth(delegateKeyword)
            Me._delegateKeyword = delegateKeyword
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 8
          Dim _delegateKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _delegateKeyword isnot Nothing 
             AdjustFlagsAndWidth(_delegateKeyword)
             Me._delegateKeyword = _delegateKeyword
          End If
          Dim _subOrFunctionKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _subOrFunctionKeyword isnot Nothing 
             AdjustFlagsAndWidth(_subOrFunctionKeyword)
             Me._subOrFunctionKeyword = _subOrFunctionKeyword
          End If
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _typeParameterList = DirectCast(reader.ReadValue(), TypeParameterListSyntax)
          If _typeParameterList isnot Nothing 
             AdjustFlagsAndWidth(_typeParameterList)
             Me._typeParameterList = _typeParameterList
          End If
          Dim _asClause = DirectCast(reader.ReadValue(), SimpleAsClauseSyntax)
          If _asClause isnot Nothing 
             AdjustFlagsAndWidth(_asClause)
             Me._asClause = _asClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New DelegateStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._delegateKeyword)
          writer.WriteValue(Me._subOrFunctionKeyword)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._typeParameterList)
          writer.WriteValue(Me._asClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(DelegateStatementSyntax), Function(r) New DelegateStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.DelegateStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Delegate" keyword.
        ''' </summary>
        Friend  ReadOnly Property DelegateKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._delegateKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Sub" or "Function" keyword.
        ''' </summary>
        Friend  ReadOnly Property SubOrFunctionKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._subOrFunctionKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the delegate being declared.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' If present, a type parameter list with generic type parameters for this
        ''' delegate. If no generic type parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property TypeParameterList As InternalSyntax.TypeParameterListSyntax
            Get
                Return Me._typeParameterList
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._delegateKeyword
                Case 3
                    Return Me._subOrFunctionKeyword
                Case 4
                    Return Me._identifier
                Case 5
                    Return Me._typeParameterList
                Case 6
                    Return Me._parameterList
                Case 7
                    Return Me._asClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new DelegateStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _delegateKeyword, _subOrFunctionKeyword, _identifier, _typeParameterList, _parameterList, _asClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new DelegateStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _delegateKeyword, _subOrFunctionKeyword, _identifier, _typeParameterList, _parameterList, _asClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitDelegateStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares an event. If the event being declared is a custom
    ''' event, this statement will be the Begin of a PropertyOrEventBlock, and the
    ''' accessors will be part of the Accessors of that node.
    ''' </summary>
    Friend NotInheritable Class EventStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _customKeyword as KeywordSyntax
        Friend ReadOnly _eventKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax
        Friend ReadOnly _implementsClause as ImplementsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, customKeyword As InternalSyntax.KeywordSyntax, eventKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 8

            If customKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(customKeyword)
                Me._customKeyword = customKeyword
            End If
            AdjustFlagsAndWidth(eventKeyword)
            Me._eventKeyword = eventKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, customKeyword As InternalSyntax.KeywordSyntax, eventKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, implementsClause As ImplementsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 8
            Me.SetFactoryContext(context)

            If customKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(customKeyword)
                Me._customKeyword = customKeyword
            End If
            AdjustFlagsAndWidth(eventKeyword)
            Me._eventKeyword = eventKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, customKeyword As InternalSyntax.KeywordSyntax, eventKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 8

            If customKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(customKeyword)
                Me._customKeyword = customKeyword
            End If
            AdjustFlagsAndWidth(eventKeyword)
            Me._eventKeyword = eventKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 8
          Dim _customKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _customKeyword isnot Nothing 
             AdjustFlagsAndWidth(_customKeyword)
             Me._customKeyword = _customKeyword
          End If
          Dim _eventKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _eventKeyword isnot Nothing 
             AdjustFlagsAndWidth(_eventKeyword)
             Me._eventKeyword = _eventKeyword
          End If
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _asClause = DirectCast(reader.ReadValue(), SimpleAsClauseSyntax)
          If _asClause isnot Nothing 
             AdjustFlagsAndWidth(_asClause)
             Me._asClause = _asClause
          End If
          Dim _implementsClause = DirectCast(reader.ReadValue(), ImplementsClauseSyntax)
          If _implementsClause isnot Nothing 
             AdjustFlagsAndWidth(_implementsClause)
             Me._implementsClause = _implementsClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New EventStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._customKeyword)
          writer.WriteValue(Me._eventKeyword)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._asClause)
          writer.WriteValue(Me._implementsClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(EventStatementSyntax), Function(r) New EventStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EventStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The optional Custom keyword for custom event declarations.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property CustomKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._customKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Event" keyword that introduces this event declaration.
        ''' </summary>
        Friend  ReadOnly Property EventKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._eventKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the event being declared.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' If present, an Implements clause indicates the interface methods that this
        ''' method implements.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ImplementsClause As InternalSyntax.ImplementsClauseSyntax
            Get
                Return Me._implementsClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._customKeyword
                Case 3
                    Return Me._eventKeyword
                Case 4
                    Return Me._identifier
                Case 5
                    Return Me._parameterList
                Case 6
                    Return Me._asClause
                Case 7
                    Return Me._implementsClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EventStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _customKeyword, _eventKeyword, _identifier, _parameterList, _asClause, _implementsClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EventStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _customKeyword, _eventKeyword, _identifier, _parameterList, _asClause, _implementsClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEventStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares an operator. If this operator has a body, this
    ''' statement will be the Begin of a BlockStatement with
    ''' Kind=MethodDeclarationBlock, and the body of the method will be the Body of
    ''' that BlockStatement.
    ''' </summary>
    Friend NotInheritable Class OperatorStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _operatorKeyword as KeywordSyntax
        Friend ReadOnly _operatorToken as SyntaxToken
        Friend ReadOnly _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, operatorKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.SyntaxToken, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 6

            AdjustFlagsAndWidth(operatorKeyword)
            Me._operatorKeyword = operatorKeyword
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, operatorKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.SyntaxToken, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 6
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(operatorKeyword)
            Me._operatorKeyword = operatorKeyword
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, operatorKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.SyntaxToken, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 6

            AdjustFlagsAndWidth(operatorKeyword)
            Me._operatorKeyword = operatorKeyword
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 6
          Dim _operatorKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _operatorKeyword isnot Nothing 
             AdjustFlagsAndWidth(_operatorKeyword)
             Me._operatorKeyword = _operatorKeyword
          End If
          Dim _operatorToken = DirectCast(reader.ReadValue(), SyntaxToken)
          If _operatorToken isnot Nothing 
             AdjustFlagsAndWidth(_operatorToken)
             Me._operatorToken = _operatorToken
          End If
          Dim _asClause = DirectCast(reader.ReadValue(), SimpleAsClauseSyntax)
          If _asClause isnot Nothing 
             AdjustFlagsAndWidth(_asClause)
             Me._asClause = _asClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New OperatorStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._operatorKeyword)
          writer.WriteValue(Me._operatorToken)
          writer.WriteValue(Me._asClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(OperatorStatementSyntax), Function(r) New OperatorStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OperatorStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Operator" keyword that introduces this operator declaration.
        ''' </summary>
        Friend  ReadOnly Property OperatorKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._operatorKeyword
            End Get
        End Property

        ''' <summary>
        ''' The operator being defined.
        ''' </summary>
        Friend  ReadOnly Property OperatorToken As InternalSyntax.SyntaxToken
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._operatorKeyword
                Case 3
                    Return Me._operatorToken
                Case 4
                    Return Me._parameterList
                Case 5
                    Return Me._asClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OperatorStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _operatorKeyword, _operatorToken, _parameterList, _asClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OperatorStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _operatorKeyword, _operatorToken, _parameterList, _asClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOperatorStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Statement that declares a property. If this property has accessors declared,
    ''' this statement will be the Begin of a BlockNode, and the accessors will be the
    ''' Body of that node. Auto properties are property declarations without a
    ''' PropertyBlock.
    ''' </summary>
    Friend NotInheritable Class PropertyStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _propertyKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _asClause as AsClauseSyntax
        Friend ReadOnly _initializer as EqualsValueSyntax
        Friend ReadOnly _implementsClause as ImplementsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, propertyKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As AsClauseSyntax, initializer As EqualsValueSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 8

            AdjustFlagsAndWidth(propertyKeyword)
            Me._propertyKeyword = propertyKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, propertyKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As AsClauseSyntax, initializer As EqualsValueSyntax, implementsClause As ImplementsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 8
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(propertyKeyword)
            Me._propertyKeyword = propertyKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, propertyKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As AsClauseSyntax, initializer As EqualsValueSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 8

            AdjustFlagsAndWidth(propertyKeyword)
            Me._propertyKeyword = propertyKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 8
          Dim _propertyKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _propertyKeyword isnot Nothing 
             AdjustFlagsAndWidth(_propertyKeyword)
             Me._propertyKeyword = _propertyKeyword
          End If
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _asClause = DirectCast(reader.ReadValue(), AsClauseSyntax)
          If _asClause isnot Nothing 
             AdjustFlagsAndWidth(_asClause)
             Me._asClause = _asClause
          End If
          Dim _initializer = DirectCast(reader.ReadValue(), EqualsValueSyntax)
          If _initializer isnot Nothing 
             AdjustFlagsAndWidth(_initializer)
             Me._initializer = _initializer
          End If
          Dim _implementsClause = DirectCast(reader.ReadValue(), ImplementsClauseSyntax)
          If _implementsClause isnot Nothing 
             AdjustFlagsAndWidth(_implementsClause)
             Me._implementsClause = _implementsClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New PropertyStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._propertyKeyword)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._asClause)
          writer.WriteValue(Me._initializer)
          writer.WriteValue(Me._implementsClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(PropertyStatementSyntax), Function(r) New PropertyStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.PropertyStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Property" keyword that introduces this property declaration.
        ''' </summary>
        Friend  ReadOnly Property PropertyKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._propertyKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the property being declared.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AsClause As InternalSyntax.AsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' If present, an "= initial-value" clause describing the initial value of the
        ''' property.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Initializer As InternalSyntax.EqualsValueSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        ''' <summary>
        ''' If present, an Implements clause indicated the interface methods that this
        ''' method implements.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ImplementsClause As InternalSyntax.ImplementsClauseSyntax
            Get
                Return Me._implementsClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._propertyKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._parameterList
                Case 5
                    Return Me._asClause
                Case 6
                    Return Me._initializer
                Case 7
                    Return Me._implementsClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new PropertyStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _propertyKeyword, _identifier, _parameterList, _asClause, _initializer, _implementsClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new PropertyStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _propertyKeyword, _identifier, _parameterList, _asClause, _initializer, _implementsClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitPropertyStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Get or Set accessor on a property declaration or an AddHandler,
    ''' RemoveHandler or RaiseEvent accessor on a custom event declaration. The Kind of
    ''' the node determines what kind of accessor this is. This statement is always the
    ''' Begin of a BlockNode, and the body of the accessor is the Body of that node.
    ''' </summary>
    Friend NotInheritable Class AccessorStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _accessorKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, accessorKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(accessorKeyword)
            Me._accessorKeyword = accessorKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, accessorKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(accessorKeyword)
            Me._accessorKeyword = accessorKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, accessorKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(accessorKeyword)
            Me._accessorKeyword = accessorKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _accessorKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _accessorKeyword isnot Nothing 
             AdjustFlagsAndWidth(_accessorKeyword)
             Me._accessorKeyword = _accessorKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New AccessorStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._accessorKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(AccessorStatementSyntax), Function(r) New AccessorStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AccessorStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Get", "Set", "AddHandler", "RemoveHandler", or "RaiseEvent" keyword that
        ''' introduces this accessor declaration.
        ''' </summary>
        Friend  ReadOnly Property AccessorKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._accessorKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._accessorKeyword
                Case 3
                    Return Me._parameterList
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AccessorStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _accessorKeyword, _parameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AccessorStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _accessorKeyword, _parameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAccessorStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Implements ..." clause on a type member, which describes which
    ''' interface members this member implements.
    ''' </summary>
    Friend NotInheritable Class ImplementsClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _implementsKeyword as KeywordSyntax
        Friend ReadOnly _interfaceMembers as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, implementsKeyword As InternalSyntax.KeywordSyntax, interfaceMembers As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If interfaceMembers IsNot Nothing Then
                AdjustFlagsAndWidth(interfaceMembers)
                Me._interfaceMembers = interfaceMembers
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, implementsKeyword As InternalSyntax.KeywordSyntax, interfaceMembers As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If interfaceMembers IsNot Nothing Then
                AdjustFlagsAndWidth(interfaceMembers)
                Me._interfaceMembers = interfaceMembers
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), implementsKeyword As InternalSyntax.KeywordSyntax, interfaceMembers As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If interfaceMembers IsNot Nothing Then
                AdjustFlagsAndWidth(interfaceMembers)
                Me._interfaceMembers = interfaceMembers
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _implementsKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _implementsKeyword isnot Nothing 
             AdjustFlagsAndWidth(_implementsKeyword)
             Me._implementsKeyword = _implementsKeyword
          End If
          Dim _interfaceMembers = DirectCast(reader.ReadValue(), GreenNode)
          If _interfaceMembers isnot Nothing 
             AdjustFlagsAndWidth(_interfaceMembers)
             Me._interfaceMembers = _interfaceMembers
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ImplementsClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._implementsKeyword)
          writer.WriteValue(Me._interfaceMembers)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ImplementsClauseSyntax), Function(r) New ImplementsClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ImplementsClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Implements" keyword.
        ''' </summary>
        Friend  ReadOnly Property ImplementsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._implementsKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of interface members being implemented.
        ''' </summary>
        Friend  ReadOnly Property InterfaceMembers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of QualifiedNameSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of QualifiedNameSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of QualifiedNameSyntax)(Me._interfaceMembers))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._implementsKeyword
                Case 1
                    Return Me._interfaceMembers
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ImplementsClauseSyntax(Me.Kind, newErrors, GetAnnotations, _implementsKeyword, _interfaceMembers)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ImplementsClauseSyntax(Me.Kind, GetDiagnostics, annotations, _implementsKeyword, _interfaceMembers)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitImplementsClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Handles ..." clause on a method declaration that describes
    ''' which events this method handles.
    ''' </summary>
    Friend NotInheritable Class HandlesClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _handlesKeyword as KeywordSyntax
        Friend ReadOnly _events as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, handlesKeyword As InternalSyntax.KeywordSyntax, events As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(handlesKeyword)
            Me._handlesKeyword = handlesKeyword
            If events IsNot Nothing Then
                AdjustFlagsAndWidth(events)
                Me._events = events
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, handlesKeyword As InternalSyntax.KeywordSyntax, events As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(handlesKeyword)
            Me._handlesKeyword = handlesKeyword
            If events IsNot Nothing Then
                AdjustFlagsAndWidth(events)
                Me._events = events
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), handlesKeyword As InternalSyntax.KeywordSyntax, events As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(handlesKeyword)
            Me._handlesKeyword = handlesKeyword
            If events IsNot Nothing Then
                AdjustFlagsAndWidth(events)
                Me._events = events
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _handlesKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _handlesKeyword isnot Nothing 
             AdjustFlagsAndWidth(_handlesKeyword)
             Me._handlesKeyword = _handlesKeyword
          End If
          Dim _events = DirectCast(reader.ReadValue(), GreenNode)
          If _events isnot Nothing 
             AdjustFlagsAndWidth(_events)
             Me._events = _events
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New HandlesClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._handlesKeyword)
          writer.WriteValue(Me._events)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(HandlesClauseSyntax), Function(r) New HandlesClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.HandlesClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Handles" keyword.
        ''' </summary>
        Friend  ReadOnly Property HandlesKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._handlesKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of event members being handled.
        ''' </summary>
        Friend  ReadOnly Property Events As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of HandlesClauseItemSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of HandlesClauseItemSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of HandlesClauseItemSyntax)(Me._events))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._handlesKeyword
                Case 1
                    Return Me._events
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new HandlesClauseSyntax(Me.Kind, newErrors, GetAnnotations, _handlesKeyword, _events)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new HandlesClauseSyntax(Me.Kind, GetDiagnostics, annotations, _handlesKeyword, _events)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitHandlesClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents container of an event in a Handles clause item.
    ''' </summary>
    Friend MustInherit Class EventContainerSyntax
        Inherits ExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' Represents event container specified through special keywords "Me", "MyBase" or
    ''' "MyClass"..
    ''' </summary>
    Friend NotInheritable Class KeywordEventContainerSyntax
        Inherits EventContainerSyntax

        Friend ReadOnly _keyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _keyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _keyword isnot Nothing 
             AdjustFlagsAndWidth(_keyword)
             Me._keyword = _keyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New KeywordEventContainerSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._keyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(KeywordEventContainerSyntax), Function(r) New KeywordEventContainerSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.KeywordEventContainerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The container of the event. This can be one of the special keywords: "Me",
        ''' "MyBase" or "MyClass".
        ''' </summary>
        Friend  ReadOnly Property Keyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._keyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._keyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new KeywordEventContainerSyntax(Me.Kind, newErrors, GetAnnotations, _keyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new KeywordEventContainerSyntax(Me.Kind, GetDiagnostics, annotations, _keyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitKeywordEventContainer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents event container that refers to a WithEvents member.
    ''' </summary>
    Friend NotInheritable Class WithEventsEventContainerSyntax
        Inherits EventContainerSyntax

        Friend ReadOnly _identifier as IdentifierTokenSyntax

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New WithEventsEventContainerSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._identifier)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(WithEventsEventContainerSyntax), Function(r) New WithEventsEventContainerSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WithEventsEventContainerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The container of the event. It is a simple identifier that refers to a
        ''' WithEvents member of the containing type.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._identifier
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WithEventsEventContainerSyntax(Me.Kind, newErrors, GetAnnotations, _identifier)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WithEventsEventContainerSyntax(Me.Kind, GetDiagnostics, annotations, _identifier)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWithEventsEventContainer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents event container that refers to a WithEvents member's property.
    ''' </summary>
    Friend NotInheritable Class WithEventsPropertyEventContainerSyntax
        Inherits EventContainerSyntax

        Friend ReadOnly _withEventsContainer as WithEventsEventContainerSyntax
        Friend ReadOnly _dotToken as PunctuationSyntax
        Friend ReadOnly _property as IdentifierNameSyntax

        Friend Sub New(ByVal kind As SyntaxKind, withEventsContainer As WithEventsEventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, [property] As IdentifierNameSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(withEventsContainer)
            Me._withEventsContainer = withEventsContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth([property])
            Me._property = [property]

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, withEventsContainer As WithEventsEventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, [property] As IdentifierNameSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(withEventsContainer)
            Me._withEventsContainer = withEventsContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth([property])
            Me._property = [property]

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withEventsContainer As WithEventsEventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, [property] As IdentifierNameSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(withEventsContainer)
            Me._withEventsContainer = withEventsContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth([property])
            Me._property = [property]

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _withEventsContainer = DirectCast(reader.ReadValue(), WithEventsEventContainerSyntax)
          If _withEventsContainer isnot Nothing 
             AdjustFlagsAndWidth(_withEventsContainer)
             Me._withEventsContainer = _withEventsContainer
          End If
          Dim _dotToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _dotToken isnot Nothing 
             AdjustFlagsAndWidth(_dotToken)
             Me._dotToken = _dotToken
          End If
          Dim _property = DirectCast(reader.ReadValue(), IdentifierNameSyntax)
          If _property isnot Nothing 
             AdjustFlagsAndWidth(_property)
             Me._property = _property
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New WithEventsPropertyEventContainerSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._withEventsContainer)
          writer.WriteValue(Me._dotToken)
          writer.WriteValue(Me._property)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(WithEventsPropertyEventContainerSyntax), Function(r) New WithEventsPropertyEventContainerSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WithEventsPropertyEventContainerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The container of the event.
        ''' </summary>
        Friend  ReadOnly Property WithEventsContainer As InternalSyntax.WithEventsEventContainerSyntax
            Get
                Return Me._withEventsContainer
            End Get
        End Property

        ''' <summary>
        ''' The "." token.
        ''' </summary>
        Friend  ReadOnly Property DotToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._dotToken
            End Get
        End Property

        ''' <summary>
        ''' The provider of the event. It is a property of a WithEvents member of the
        ''' containing type.
        ''' </summary>
        Friend  ReadOnly Property [Property] As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._property
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._withEventsContainer
                Case 1
                    Return Me._dotToken
                Case 2
                    Return Me._property
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WithEventsPropertyEventContainerSyntax(Me.Kind, newErrors, GetAnnotations, _withEventsContainer, _dotToken, _property)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WithEventsPropertyEventContainerSyntax(Me.Kind, GetDiagnostics, annotations, _withEventsContainer, _dotToken, _property)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWithEventsPropertyEventContainer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single handled event in a "Handles ..." clause.
    ''' </summary>
    Friend NotInheritable Class HandlesClauseItemSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _eventContainer as EventContainerSyntax
        Friend ReadOnly _dotToken as PunctuationSyntax
        Friend ReadOnly _eventMember as IdentifierNameSyntax

        Friend Sub New(ByVal kind As SyntaxKind, eventContainer As EventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, eventMember As IdentifierNameSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(eventContainer)
            Me._eventContainer = eventContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(eventMember)
            Me._eventMember = eventMember

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, eventContainer As EventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, eventMember As IdentifierNameSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(eventContainer)
            Me._eventContainer = eventContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(eventMember)
            Me._eventMember = eventMember

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), eventContainer As EventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, eventMember As IdentifierNameSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(eventContainer)
            Me._eventContainer = eventContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(eventMember)
            Me._eventMember = eventMember

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _eventContainer = DirectCast(reader.ReadValue(), EventContainerSyntax)
          If _eventContainer isnot Nothing 
             AdjustFlagsAndWidth(_eventContainer)
             Me._eventContainer = _eventContainer
          End If
          Dim _dotToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _dotToken isnot Nothing 
             AdjustFlagsAndWidth(_dotToken)
             Me._dotToken = _dotToken
          End If
          Dim _eventMember = DirectCast(reader.ReadValue(), IdentifierNameSyntax)
          If _eventMember isnot Nothing 
             AdjustFlagsAndWidth(_eventMember)
             Me._eventMember = _eventMember
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New HandlesClauseItemSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._eventContainer)
          writer.WriteValue(Me._dotToken)
          writer.WriteValue(Me._eventMember)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(HandlesClauseItemSyntax), Function(r) New HandlesClauseItemSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.HandlesClauseItemSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The container of the event. This can either be a simple identifier (identifying
        ''' a members of the containing type) or one of the special keywords "Me", "MyBase"
        ''' or "MyClass".
        ''' </summary>
        Friend  ReadOnly Property EventContainer As InternalSyntax.EventContainerSyntax
            Get
                Return Me._eventContainer
            End Get
        End Property

        ''' <summary>
        ''' The "." token.
        ''' </summary>
        Friend  ReadOnly Property DotToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._dotToken
            End Get
        End Property

        ''' <summary>
        ''' The event being handled. This must be a simple identifier.
        ''' </summary>
        Friend  ReadOnly Property EventMember As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._eventMember
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._eventContainer
                Case 1
                    Return Me._dotToken
                Case 2
                    Return Me._eventMember
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new HandlesClauseItemSyntax(Me.Kind, newErrors, GetAnnotations, _eventContainer, _dotToken, _eventMember)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new HandlesClauseItemSyntax(Me.Kind, GetDiagnostics, annotations, _eventContainer, _dotToken, _eventMember)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitHandlesClauseItem(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning of a declaration. However, not enough syntax is
    ''' detected to classify this as a field, method, property or event. This is node
    ''' always represents a syntax error.
    ''' </summary>
    Friend NotInheritable Class IncompleteMemberSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _missingIdentifier as IdentifierTokenSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, missingIdentifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If missingIdentifier IsNot Nothing Then
                AdjustFlagsAndWidth(missingIdentifier)
                Me._missingIdentifier = missingIdentifier
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, missingIdentifier As InternalSyntax.IdentifierTokenSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If missingIdentifier IsNot Nothing Then
                AdjustFlagsAndWidth(missingIdentifier)
                Me._missingIdentifier = missingIdentifier
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, missingIdentifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If missingIdentifier IsNot Nothing Then
                AdjustFlagsAndWidth(missingIdentifier)
                Me._missingIdentifier = missingIdentifier
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _attributeLists = DirectCast(reader.ReadValue(), GreenNode)
          If _attributeLists isnot Nothing 
             AdjustFlagsAndWidth(_attributeLists)
             Me._attributeLists = _attributeLists
          End If
          Dim _modifiers = DirectCast(reader.ReadValue(), GreenNode)
          If _modifiers isnot Nothing 
             AdjustFlagsAndWidth(_modifiers)
             Me._modifiers = _modifiers
          End If
          Dim _missingIdentifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _missingIdentifier isnot Nothing 
             AdjustFlagsAndWidth(_missingIdentifier)
             Me._missingIdentifier = _missingIdentifier
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New IncompleteMemberSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._attributeLists)
          writer.WriteValue(Me._modifiers)
          writer.WriteValue(Me._missingIdentifier)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(IncompleteMemberSyntax), Function(r) New IncompleteMemberSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.IncompleteMemberSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The missing identifier token for this incomplete member. Should only be used to
        ''' have a location for error reporting.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property MissingIdentifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._missingIdentifier
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._missingIdentifier
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new IncompleteMemberSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _missingIdentifier)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new IncompleteMemberSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _missingIdentifier)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitIncompleteMember(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the declaration of one or more variables or constants, either as
    ''' local variables or as class/structure members. In the case of a constant, it is
    ''' represented by having "Const" in the Modifiers (although technically "Const" is
    ''' not a modifier, it is represented as one in the parse trees.)
    ''' </summary>
    Friend NotInheritable Class FieldDeclarationSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _declarators as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, declarators As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, declarators As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, declarators As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _attributeLists = DirectCast(reader.ReadValue(), GreenNode)
          If _attributeLists isnot Nothing 
             AdjustFlagsAndWidth(_attributeLists)
             Me._attributeLists = _attributeLists
          End If
          Dim _modifiers = DirectCast(reader.ReadValue(), GreenNode)
          If _modifiers isnot Nothing 
             AdjustFlagsAndWidth(_modifiers)
             Me._modifiers = _modifiers
          End If
          Dim _declarators = DirectCast(reader.ReadValue(), GreenNode)
          If _declarators isnot Nothing 
             AdjustFlagsAndWidth(_declarators)
             Me._declarators = _declarators
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New FieldDeclarationSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._attributeLists)
          writer.WriteValue(Me._modifiers)
          writer.WriteValue(Me._declarators)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(FieldDeclarationSyntax), Function(r) New FieldDeclarationSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.FieldDeclarationSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The list of variable declarator. Each declarator specifies one or more variable
        ''' names along with a type and/or initializer.
        ''' </summary>
        Friend  ReadOnly Property Declarators As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of VariableDeclaratorSyntax)(Me._declarators))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._declarators
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new FieldDeclarationSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _declarators)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new FieldDeclarationSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _declarators)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitFieldDeclaration(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the part of a variable or constant declaration statement that
    ''' associated one or more variable names with a type.
    ''' </summary>
    Friend NotInheritable Class VariableDeclaratorSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _names as GreenNode
        Friend ReadOnly _asClause as AsClauseSyntax
        Friend ReadOnly _initializer as EqualsValueSyntax

        Friend Sub New(ByVal kind As SyntaxKind, names As GreenNode, asClause As AsClauseSyntax, initializer As EqualsValueSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            If names IsNot Nothing Then
                AdjustFlagsAndWidth(names)
                Me._names = names
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, names As GreenNode, asClause As AsClauseSyntax, initializer As EqualsValueSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            If names IsNot Nothing Then
                AdjustFlagsAndWidth(names)
                Me._names = names
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), names As GreenNode, asClause As AsClauseSyntax, initializer As EqualsValueSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            If names IsNot Nothing Then
                AdjustFlagsAndWidth(names)
                Me._names = names
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _names = DirectCast(reader.ReadValue(), GreenNode)
          If _names isnot Nothing 
             AdjustFlagsAndWidth(_names)
             Me._names = _names
          End If
          Dim _asClause = DirectCast(reader.ReadValue(), AsClauseSyntax)
          If _asClause isnot Nothing 
             AdjustFlagsAndWidth(_asClause)
             Me._asClause = _asClause
          End If
          Dim _initializer = DirectCast(reader.ReadValue(), EqualsValueSyntax)
          If _initializer isnot Nothing 
             AdjustFlagsAndWidth(_initializer)
             Me._initializer = _initializer
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New VariableDeclaratorSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._names)
          writer.WriteValue(Me._asClause)
          writer.WriteValue(Me._initializer)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(VariableDeclaratorSyntax), Function(r) New VariableDeclaratorSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.VariableDeclaratorSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The names of the variables being declared. Each name might have a "?" or "()"
        ''' modifier(s) attached.
        ''' </summary>
        Friend  ReadOnly Property Names As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ModifiedIdentifierSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ModifiedIdentifierSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ModifiedIdentifierSyntax)(Me._names))
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type, and possibly includes "New",
        ''' "With" or "From". If no As clause was present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AsClause As InternalSyntax.AsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' If present, an "= initial-value" clause describing the initial value of the
        ''' variable or the value of the constant.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Initializer As InternalSyntax.EqualsValueSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._names
                Case 1
                    Return Me._asClause
                Case 2
                    Return Me._initializer
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new VariableDeclaratorSyntax(Me.Kind, newErrors, GetAnnotations, _names, _asClause, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new VariableDeclaratorSyntax(Me.Kind, GetDiagnostics, annotations, _names, _asClause, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitVariableDeclarator(Me)
        End Function

    End Class

    ''' <summary>
    ''' Abstract node class that represents the different kinds of "As {type-name}"
    ''' clauses in a declaration: simple "As" clauses and "As New" clauses. The type
    ''' has optional attributes associated with it, although attributes are not
    ''' permitted in all possible places where this node occurs.
    ''' </summary>
    Friend MustInherit Class AsClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _asKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _asKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _asKeyword isnot Nothing 
             AdjustFlagsAndWidth(_asKeyword)
             Me._asKeyword = _asKeyword
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._asKeyword)
        End Sub

        ''' <summary>
        ''' The "As" keyword.
        ''' </summary>
        Friend  ReadOnly Property AsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._asKeyword
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents an "As {type-name}" clause that does not have an initializer or
    ''' "New". The type has optional attributes associated with it, although attributes
    ''' are not permitted in all possible places where this node occurs.
    ''' </summary>
    Friend NotInheritable Class SimpleAsClauseSyntax
        Inherits AsClauseSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _type as TypeSyntax

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax)
            MyBase.New(kind, asKeyword)
            MyBase._slotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, asKeyword)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax)
            MyBase.New(kind, errors, annotations, asKeyword)
            MyBase._slotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _attributeLists = DirectCast(reader.ReadValue(), GreenNode)
          If _attributeLists isnot Nothing 
             AdjustFlagsAndWidth(_attributeLists)
             Me._attributeLists = _attributeLists
          End If
          Dim _type = DirectCast(reader.ReadValue(), TypeSyntax)
          If _type isnot Nothing 
             AdjustFlagsAndWidth(_type)
             Me._type = _type
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SimpleAsClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._attributeLists)
          writer.WriteValue(Me._type)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SimpleAsClauseSyntax), Function(r) New SimpleAsClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SimpleAsClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on the type. If no attributes were specified, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' The type-name part of the As clause.
        ''' </summary>
        Friend  ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._asKeyword
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._type
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SimpleAsClauseSyntax(Me.Kind, newErrors, GetAnnotations, _asKeyword, _attributeLists, _type)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SimpleAsClauseSyntax(Me.Kind, GetDiagnostics, annotations, _asKeyword, _attributeLists, _type)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSimpleAsClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "As New {type-name} [arguments] [initializers]" clause in a
    ''' declaration. The type has optional attributes associated with it, although
    ''' attributes are not permitted in many places where this node occurs (they are
    ''' permitted, for example, on automatically implemented properties.)
    ''' </summary>
    Friend NotInheritable Class AsNewClauseSyntax
        Inherits AsClauseSyntax

        Friend ReadOnly _newExpression as NewExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, newExpression As NewExpressionSyntax)
            MyBase.New(kind, asKeyword)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(newExpression)
            Me._newExpression = newExpression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, newExpression As NewExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, asKeyword)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(newExpression)
            Me._newExpression = newExpression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, newExpression As NewExpressionSyntax)
            MyBase.New(kind, errors, annotations, asKeyword)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(newExpression)
            Me._newExpression = newExpression

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _newExpression = DirectCast(reader.ReadValue(), NewExpressionSyntax)
          If _newExpression isnot Nothing 
             AdjustFlagsAndWidth(_newExpression)
             Me._newExpression = _newExpression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New AsNewClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._newExpression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(AsNewClauseSyntax), Function(r) New AsNewClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AsNewClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The New expression
        ''' </summary>
        Friend  ReadOnly Property NewExpression As InternalSyntax.NewExpressionSyntax
            Get
                Return Me._newExpression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._asKeyword
                Case 1
                    Return Me._newExpression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AsNewClauseSyntax(Me.Kind, newErrors, GetAnnotations, _asKeyword, _newExpression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AsNewClauseSyntax(Me.Kind, GetDiagnostics, annotations, _asKeyword, _newExpression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAsNewClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that represents a "With" or "From" clause used to
    ''' initializer an new object.
    ''' </summary>
    Friend MustInherit Class ObjectCreationInitializerSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' Represents a "With {...} clause used to initialize a new object's members.
    ''' </summary>
    Friend NotInheritable Class ObjectMemberInitializerSyntax
        Inherits ObjectCreationInitializerSyntax

        Friend ReadOnly _withKeyword as KeywordSyntax
        Friend ReadOnly _openBraceToken as PunctuationSyntax
        Friend ReadOnly _initializers as GreenNode
        Friend ReadOnly _closeBraceToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, withKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, withKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _withKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _withKeyword isnot Nothing 
             AdjustFlagsAndWidth(_withKeyword)
             Me._withKeyword = _withKeyword
          End If
          Dim _openBraceToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openBraceToken isnot Nothing 
             AdjustFlagsAndWidth(_openBraceToken)
             Me._openBraceToken = _openBraceToken
          End If
          Dim _initializers = DirectCast(reader.ReadValue(), GreenNode)
          If _initializers isnot Nothing 
             AdjustFlagsAndWidth(_initializers)
             Me._initializers = _initializers
          End If
          Dim _closeBraceToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeBraceToken isnot Nothing 
             AdjustFlagsAndWidth(_closeBraceToken)
             Me._closeBraceToken = _closeBraceToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ObjectMemberInitializerSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._withKeyword)
          writer.WriteValue(Me._openBraceToken)
          writer.WriteValue(Me._initializers)
          writer.WriteValue(Me._closeBraceToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ObjectMemberInitializerSyntax), Function(r) New ObjectMemberInitializerSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ObjectMemberInitializerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "With" keyword.
        ''' </summary>
        Friend  ReadOnly Property WithKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._withKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "{" token.
        ''' </summary>
        Friend  ReadOnly Property OpenBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openBraceToken
            End Get
        End Property

        ''' <summary>
        ''' The comma-separated list of field initializers.
        ''' </summary>
        Friend  ReadOnly Property Initializers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of FieldInitializerSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of FieldInitializerSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of FieldInitializerSyntax)(Me._initializers))
            End Get
        End Property

        ''' <summary>
        ''' The "}" token.
        ''' </summary>
        Friend  ReadOnly Property CloseBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeBraceToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._withKeyword
                Case 1
                    Return Me._openBraceToken
                Case 2
                    Return Me._initializers
                Case 3
                    Return Me._closeBraceToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ObjectMemberInitializerSyntax(Me.Kind, newErrors, GetAnnotations, _withKeyword, _openBraceToken, _initializers, _closeBraceToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ObjectMemberInitializerSyntax(Me.Kind, GetDiagnostics, annotations, _withKeyword, _openBraceToken, _initializers, _closeBraceToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitObjectMemberInitializer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "From {...} clause used to initialize a new collection object's
    ''' elements.
    ''' </summary>
    Friend NotInheritable Class ObjectCollectionInitializerSyntax
        Inherits ObjectCreationInitializerSyntax

        Friend ReadOnly _fromKeyword as KeywordSyntax
        Friend ReadOnly _initializer as CollectionInitializerSyntax

        Friend Sub New(ByVal kind As SyntaxKind, fromKeyword As InternalSyntax.KeywordSyntax, initializer As CollectionInitializerSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(fromKeyword)
            Me._fromKeyword = fromKeyword
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, fromKeyword As InternalSyntax.KeywordSyntax, initializer As CollectionInitializerSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(fromKeyword)
            Me._fromKeyword = fromKeyword
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), fromKeyword As InternalSyntax.KeywordSyntax, initializer As CollectionInitializerSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(fromKeyword)
            Me._fromKeyword = fromKeyword
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _fromKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _fromKeyword isnot Nothing 
             AdjustFlagsAndWidth(_fromKeyword)
             Me._fromKeyword = _fromKeyword
          End If
          Dim _initializer = DirectCast(reader.ReadValue(), CollectionInitializerSyntax)
          If _initializer isnot Nothing 
             AdjustFlagsAndWidth(_initializer)
             Me._initializer = _initializer
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ObjectCollectionInitializerSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._fromKeyword)
          writer.WriteValue(Me._initializer)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ObjectCollectionInitializerSyntax), Function(r) New ObjectCollectionInitializerSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ObjectCollectionInitializerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "From" keyword.
        ''' </summary>
        Friend  ReadOnly Property FromKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._fromKeyword
            End Get
        End Property

        ''' <summary>
        ''' The initializer including the braces.
        ''' </summary>
        Friend  ReadOnly Property Initializer As InternalSyntax.CollectionInitializerSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._fromKeyword
                Case 1
                    Return Me._initializer
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ObjectCollectionInitializerSyntax(Me.Kind, newErrors, GetAnnotations, _fromKeyword, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ObjectCollectionInitializerSyntax(Me.Kind, GetDiagnostics, annotations, _fromKeyword, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitObjectCollectionInitializer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Abstract class that represent a single field initializer used in a "With {...}"
    ''' field initializer list.
    ''' </summary>
    Friend MustInherit Class FieldInitializerSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _keyKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)

            If keyKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(keyKeyword)
                Me._keyKeyword = keyKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If keyKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(keyKeyword)
                Me._keyKeyword = keyKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)

            If keyKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(keyKeyword)
                Me._keyKeyword = keyKeyword
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _keyKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _keyKeyword isnot Nothing 
             AdjustFlagsAndWidth(_keyKeyword)
             Me._keyKeyword = _keyKeyword
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._keyKeyword)
        End Sub

        ''' <summary>
        ''' The optional "Key" keyword.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property KeyKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._keyKeyword
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represent a field initializer in a With {...} initializer where the field name
    ''' is inferred from the initializer expression.
    ''' </summary>
    Friend NotInheritable Class InferredFieldInitializerSyntax
        Inherits FieldInitializerSyntax

        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, keyKeyword)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyKeyword)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations, keyKeyword)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New InferredFieldInitializerSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._expression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(InferredFieldInitializerSyntax), Function(r) New InferredFieldInitializerSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.InferredFieldInitializerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The value being assigned.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyKeyword
                Case 1
                    Return Me._expression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new InferredFieldInitializerSyntax(Me.Kind, newErrors, GetAnnotations, _keyKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new InferredFieldInitializerSyntax(Me.Kind, GetDiagnostics, annotations, _keyKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitInferredFieldInitializer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent a named field initializer in a With {...} initializer, such as ".x =
    ''' expr".
    ''' </summary>
    Friend NotInheritable Class NamedFieldInitializerSyntax
        Inherits FieldInitializerSyntax

        Friend ReadOnly _dotToken as PunctuationSyntax
        Friend ReadOnly _name as IdentifierNameSyntax
        Friend ReadOnly _equalsToken as PunctuationSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax, dotToken As InternalSyntax.PunctuationSyntax, name As IdentifierNameSyntax, equalsToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, keyKeyword)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax, dotToken As InternalSyntax.PunctuationSyntax, name As IdentifierNameSyntax, equalsToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyKeyword)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyKeyword As InternalSyntax.KeywordSyntax, dotToken As InternalSyntax.PunctuationSyntax, name As IdentifierNameSyntax, equalsToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations, keyKeyword)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _dotToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _dotToken isnot Nothing 
             AdjustFlagsAndWidth(_dotToken)
             Me._dotToken = _dotToken
          End If
          Dim _name = DirectCast(reader.ReadValue(), IdentifierNameSyntax)
          If _name isnot Nothing 
             AdjustFlagsAndWidth(_name)
             Me._name = _name
          End If
          Dim _equalsToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _equalsToken isnot Nothing 
             AdjustFlagsAndWidth(_equalsToken)
             Me._equalsToken = _equalsToken
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New NamedFieldInitializerSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._dotToken)
          writer.WriteValue(Me._name)
          writer.WriteValue(Me._equalsToken)
          writer.WriteValue(Me._expression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(NamedFieldInitializerSyntax), Function(r) New NamedFieldInitializerSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NamedFieldInitializerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "." token.
        ''' </summary>
        Friend  ReadOnly Property DotToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._dotToken
            End Get
        End Property

        ''' <summary>
        ''' The name of the field being initialized.
        ''' </summary>
        Friend  ReadOnly Property Name As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Friend  ReadOnly Property EqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._equalsToken
            End Get
        End Property

        ''' <summary>
        ''' The value being assigned to the field.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyKeyword
                Case 1
                    Return Me._dotToken
                Case 2
                    Return Me._name
                Case 3
                    Return Me._equalsToken
                Case 4
                    Return Me._expression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NamedFieldInitializerSyntax(Me.Kind, newErrors, GetAnnotations, _keyKeyword, _dotToken, _name, _equalsToken, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NamedFieldInitializerSyntax(Me.Kind, GetDiagnostics, annotations, _keyKeyword, _dotToken, _name, _equalsToken, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNamedFieldInitializer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "= initializer" clause in a declaration for a variable, parameter
    ''' or automatic property.
    ''' </summary>
    Friend NotInheritable Class EqualsValueSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _equalsToken as PunctuationSyntax
        Friend ReadOnly _value as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, equalsToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, equalsToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), equalsToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _equalsToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _equalsToken isnot Nothing 
             AdjustFlagsAndWidth(_equalsToken)
             Me._equalsToken = _equalsToken
          End If
          Dim _value = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _value isnot Nothing 
             AdjustFlagsAndWidth(_value)
             Me._value = _value
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New EqualsValueSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._equalsToken)
          writer.WriteValue(Me._value)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(EqualsValueSyntax), Function(r) New EqualsValueSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EqualsValueSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Friend  ReadOnly Property EqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._equalsToken
            End Get
        End Property

        ''' <summary>
        ''' The expression used as the initial value.
        ''' </summary>
        Friend  ReadOnly Property Value As InternalSyntax.ExpressionSyntax
            Get
                Return Me._value
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._equalsToken
                Case 1
                    Return Me._value
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EqualsValueSyntax(Me.Kind, newErrors, GetAnnotations, _equalsToken, _value)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EqualsValueSyntax(Me.Kind, GetDiagnostics, annotations, _equalsToken, _value)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEqualsValue(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent a parameter to a method, property, constructor, etc.
    ''' </summary>
    Friend NotInheritable Class ParameterSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _identifier as ModifiedIdentifierSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax
        Friend ReadOnly _default as EqualsValueSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, [default] As EqualsValueSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 5

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If [default] IsNot Nothing Then
                AdjustFlagsAndWidth([default])
                Me._default = [default]
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, [default] As EqualsValueSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If [default] IsNot Nothing Then
                AdjustFlagsAndWidth([default])
                Me._default = [default]
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, [default] As EqualsValueSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 5

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If [default] IsNot Nothing Then
                AdjustFlagsAndWidth([default])
                Me._default = [default]
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _attributeLists = DirectCast(reader.ReadValue(), GreenNode)
          If _attributeLists isnot Nothing 
             AdjustFlagsAndWidth(_attributeLists)
             Me._attributeLists = _attributeLists
          End If
          Dim _modifiers = DirectCast(reader.ReadValue(), GreenNode)
          If _modifiers isnot Nothing 
             AdjustFlagsAndWidth(_modifiers)
             Me._modifiers = _modifiers
          End If
          Dim _identifier = DirectCast(reader.ReadValue(), ModifiedIdentifierSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _asClause = DirectCast(reader.ReadValue(), SimpleAsClauseSyntax)
          If _asClause isnot Nothing 
             AdjustFlagsAndWidth(_asClause)
             Me._asClause = _asClause
          End If
          Dim _default = DirectCast(reader.ReadValue(), EqualsValueSyntax)
          If _default isnot Nothing 
             AdjustFlagsAndWidth(_default)
             Me._default = _default
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ParameterSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._attributeLists)
          writer.WriteValue(Me._modifiers)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._asClause)
          writer.WriteValue(Me._default)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ParameterSyntax), Function(r) New ParameterSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ParameterSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on this parameter. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of the modifier tokens "ByVal", "ByRef", "Optional" or "ParamArray" that
        ''' modify this parameter.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The name of the parameter, including any "?" or "()" modifiers.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.ModifiedIdentifierSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' If present, the "As type-name" clause describing the type of the parameter. If
        ''' no As clause is present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' If present, an initializer with the default value of the parameter. If no
        ''' default value is present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property [Default] As InternalSyntax.EqualsValueSyntax
            Get
                Return Me._default
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._identifier
                Case 3
                    Return Me._asClause
                Case 4
                    Return Me._default
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ParameterSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _identifier, _asClause, _default)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ParameterSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _identifier, _asClause, _default)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitParameter(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an identifier with optional "?" or "()" or "(,,,)" modifiers, as
    ''' used in parameter declarations and variable declarations.
    ''' </summary>
    Friend NotInheritable Class ModifiedIdentifierSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _nullable as PunctuationSyntax
        Friend ReadOnly _arrayBounds as ArgumentListSyntax
        Friend ReadOnly _arrayRankSpecifiers as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, nullable As InternalSyntax.PunctuationSyntax, arrayBounds As ArgumentListSyntax, arrayRankSpecifiers As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If nullable IsNot Nothing Then
                AdjustFlagsAndWidth(nullable)
                Me._nullable = nullable
            End If
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If arrayRankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(arrayRankSpecifiers)
                Me._arrayRankSpecifiers = arrayRankSpecifiers
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, nullable As InternalSyntax.PunctuationSyntax, arrayBounds As ArgumentListSyntax, arrayRankSpecifiers As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If nullable IsNot Nothing Then
                AdjustFlagsAndWidth(nullable)
                Me._nullable = nullable
            End If
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If arrayRankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(arrayRankSpecifiers)
                Me._arrayRankSpecifiers = arrayRankSpecifiers
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax, nullable As InternalSyntax.PunctuationSyntax, arrayBounds As ArgumentListSyntax, arrayRankSpecifiers As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If nullable IsNot Nothing Then
                AdjustFlagsAndWidth(nullable)
                Me._nullable = nullable
            End If
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If arrayRankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(arrayRankSpecifiers)
                Me._arrayRankSpecifiers = arrayRankSpecifiers
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _nullable = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _nullable isnot Nothing 
             AdjustFlagsAndWidth(_nullable)
             Me._nullable = _nullable
          End If
          Dim _arrayBounds = DirectCast(reader.ReadValue(), ArgumentListSyntax)
          If _arrayBounds isnot Nothing 
             AdjustFlagsAndWidth(_arrayBounds)
             Me._arrayBounds = _arrayBounds
          End If
          Dim _arrayRankSpecifiers = DirectCast(reader.ReadValue(), GreenNode)
          If _arrayRankSpecifiers isnot Nothing 
             AdjustFlagsAndWidth(_arrayRankSpecifiers)
             Me._arrayRankSpecifiers = _arrayRankSpecifiers
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ModifiedIdentifierSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._nullable)
          writer.WriteValue(Me._arrayBounds)
          writer.WriteValue(Me._arrayRankSpecifiers)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ModifiedIdentifierSyntax), Function(r) New ModifiedIdentifierSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ModifiedIdentifierSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The identifier that names the item being declared.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "?" token that indicates a nullable type.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Nullable As InternalSyntax.PunctuationSyntax
            Get
                Return Me._nullable
            End Get
        End Property

        ''' <summary>
        ''' The optional array bounds, such as "(4)" or "(0 to 5, 0 To 6)".
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ArrayBounds As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._arrayBounds
            End Get
        End Property

        ''' <summary>
        ''' A list of array modifiers for the type. If no array modifiers were present, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property ArrayRankSpecifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ArrayRankSpecifierSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ArrayRankSpecifierSyntax)(Me._arrayRankSpecifiers)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._identifier
                Case 1
                    Return Me._nullable
                Case 2
                    Return Me._arrayBounds
                Case 3
                    Return Me._arrayRankSpecifiers
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ModifiedIdentifierSyntax(Me.Kind, newErrors, GetAnnotations, _identifier, _nullable, _arrayBounds, _arrayRankSpecifiers)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ModifiedIdentifierSyntax(Me.Kind, GetDiagnostics, annotations, _identifier, _nullable, _arrayBounds, _arrayRankSpecifiers)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitModifiedIdentifier(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a modifier that describes an array type, without bounds, such as
    ''' "()" or "(,)".
    ''' </summary>
    Friend NotInheritable Class ArrayRankSpecifierSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _commaTokens as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, commaTokens As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If commaTokens IsNot Nothing Then
                AdjustFlagsAndWidth(commaTokens)
                Me._commaTokens = commaTokens
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, commaTokens As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If commaTokens IsNot Nothing Then
                AdjustFlagsAndWidth(commaTokens)
                Me._commaTokens = commaTokens
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, commaTokens As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If commaTokens IsNot Nothing Then
                AdjustFlagsAndWidth(commaTokens)
                Me._commaTokens = commaTokens
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _commaTokens = DirectCast(reader.ReadValue(), GreenNode)
          If _commaTokens isnot Nothing 
             AdjustFlagsAndWidth(_commaTokens)
             Me._commaTokens = _commaTokens
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ArrayRankSpecifierSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._commaTokens)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ArrayRankSpecifierSyntax), Function(r) New ArrayRankSpecifierSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ArrayRankSpecifierSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The comma tokens in the array type. There is one less comma than the rank.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property CommaTokens As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of PunctuationSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._commaTokens)
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._commaTokens
                Case 2
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ArrayRankSpecifierSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _commaTokens, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ArrayRankSpecifierSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _commaTokens, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitArrayRankSpecifier(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a group of attributes within "&lt;" and "&gt;" brackets.
    ''' </summary>
    Friend NotInheritable Class AttributeListSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _lessThanToken as PunctuationSyntax
        Friend ReadOnly _attributes as GreenNode
        Friend ReadOnly _greaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, attributes As GreenNode, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, attributes As GreenNode, greaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanToken As InternalSyntax.PunctuationSyntax, attributes As GreenNode, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _lessThanToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _lessThanToken isnot Nothing 
             AdjustFlagsAndWidth(_lessThanToken)
             Me._lessThanToken = _lessThanToken
          End If
          Dim _attributes = DirectCast(reader.ReadValue(), GreenNode)
          If _attributes isnot Nothing 
             AdjustFlagsAndWidth(_attributes)
             Me._attributes = _attributes
          End If
          Dim _greaterThanToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _greaterThanToken isnot Nothing 
             AdjustFlagsAndWidth(_greaterThanToken)
             Me._greaterThanToken = _greaterThanToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New AttributeListSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._lessThanToken)
          writer.WriteValue(Me._attributes)
          writer.WriteValue(Me._greaterThanToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(AttributeListSyntax), Function(r) New AttributeListSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AttributeListSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "&lt;" token.
        ''' </summary>
        Friend  ReadOnly Property LessThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanToken
            End Get
        End Property

        ''' <summary>
        ''' A comma separated list of attribute declarations in this attribute list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Attributes As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of AttributeSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of AttributeSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of AttributeSyntax)(Me._attributes))
            End Get
        End Property

        ''' <summary>
        ''' The "&gt;" token.
        ''' </summary>
        Friend  ReadOnly Property GreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._greaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanToken
                Case 1
                    Return Me._attributes
                Case 2
                    Return Me._greaterThanToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AttributeListSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanToken, _attributes, _greaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AttributeListSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanToken, _attributes, _greaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAttributeList(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single attribute declaration within an attribute list.
    ''' </summary>
    Friend NotInheritable Class AttributeSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _target as AttributeTargetSyntax
        Friend ReadOnly _name as TypeSyntax
        Friend ReadOnly _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, target As AttributeTargetSyntax, name As TypeSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            If target IsNot Nothing Then
                AdjustFlagsAndWidth(target)
                Me._target = target
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, target As AttributeTargetSyntax, name As TypeSyntax, argumentList As ArgumentListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            If target IsNot Nothing Then
                AdjustFlagsAndWidth(target)
                Me._target = target
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), target As AttributeTargetSyntax, name As TypeSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            If target IsNot Nothing Then
                AdjustFlagsAndWidth(target)
                Me._target = target
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _target = DirectCast(reader.ReadValue(), AttributeTargetSyntax)
          If _target isnot Nothing 
             AdjustFlagsAndWidth(_target)
             Me._target = _target
          End If
          Dim _name = DirectCast(reader.ReadValue(), TypeSyntax)
          If _name isnot Nothing 
             AdjustFlagsAndWidth(_name)
             Me._name = _name
          End If
          Dim _argumentList = DirectCast(reader.ReadValue(), ArgumentListSyntax)
          If _argumentList isnot Nothing 
             AdjustFlagsAndWidth(_argumentList)
             Me._argumentList = _argumentList
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New AttributeSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._target)
          writer.WriteValue(Me._name)
          writer.WriteValue(Me._argumentList)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(AttributeSyntax), Function(r) New AttributeSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AttributeSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' Optional attribute target. Assembly|Module :
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Target As InternalSyntax.AttributeTargetSyntax
            Get
                Return Me._target
            End Get
        End Property

        ''' <summary>
        ''' The name of the attribute.
        ''' </summary>
        Friend  ReadOnly Property Name As InternalSyntax.TypeSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <summary>
        ''' The argument list, if present. If no argument list was supplied, Nothing is
        ''' returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ArgumentList As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._argumentList
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._target
                Case 1
                    Return Me._name
                Case 2
                    Return Me._argumentList
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AttributeSyntax(Me.Kind, newErrors, GetAnnotations, _target, _name, _argumentList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AttributeSyntax(Me.Kind, GetDiagnostics, annotations, _target, _name, _argumentList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAttribute(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single attribute declaration within an attribute list.
    ''' </summary>
    Friend NotInheritable Class AttributeTargetSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _attributeModifier as KeywordSyntax
        Friend ReadOnly _colonToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeModifier As InternalSyntax.KeywordSyntax, colonToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(attributeModifier)
            Me._attributeModifier = attributeModifier
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeModifier As InternalSyntax.KeywordSyntax, colonToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(attributeModifier)
            Me._attributeModifier = attributeModifier
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeModifier As InternalSyntax.KeywordSyntax, colonToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(attributeModifier)
            Me._attributeModifier = attributeModifier
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _attributeModifier = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _attributeModifier isnot Nothing 
             AdjustFlagsAndWidth(_attributeModifier)
             Me._attributeModifier = _attributeModifier
          End If
          Dim _colonToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _colonToken isnot Nothing 
             AdjustFlagsAndWidth(_colonToken)
             Me._colonToken = _colonToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New AttributeTargetSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._attributeModifier)
          writer.WriteValue(Me._colonToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(AttributeTargetSyntax), Function(r) New AttributeTargetSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AttributeTargetSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Assembly" or "Module" attribute modifier, is present. If no attribute
        ''' modifier is present, Nothing is returned.
        ''' </summary>
        Friend  ReadOnly Property AttributeModifier As InternalSyntax.KeywordSyntax
            Get
                Return Me._attributeModifier
            End Get
        End Property

        ''' <summary>
        ''' The ":" token, if an attribute modifier is present. If no attribute modifier is
        ''' present, Nothing is returned.
        ''' </summary>
        Friend  ReadOnly Property ColonToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._colonToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeModifier
                Case 1
                    Return Me._colonToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AttributeTargetSyntax(Me.Kind, newErrors, GetAnnotations, _attributeModifier, _colonToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AttributeTargetSyntax(Me.Kind, GetDiagnostics, annotations, _attributeModifier, _colonToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAttributeTarget(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a file-level attribute, in which the attributes have no other
    ''' syntactic element they are attached to.
    ''' </summary>
    Friend NotInheritable Class AttributesStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 1

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _attributeLists = DirectCast(reader.ReadValue(), GreenNode)
          If _attributeLists isnot Nothing 
             AdjustFlagsAndWidth(_attributeLists)
             Me._attributeLists = _attributeLists
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New AttributesStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._attributeLists)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(AttributesStatementSyntax), Function(r) New AttributesStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AttributesStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The list of attribute lists.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._attributeLists
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AttributesStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AttributesStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAttributesStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent an expression in a statement context. This may only be a invocation
    ''' or await expression in standard code but may be any expression in VB
    ''' Interactive code.
    ''' </summary>
    Friend NotInheritable Class ExpressionStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ExpressionStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._expression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ExpressionStatementSyntax), Function(r) New ExpressionStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ExpressionStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The expression.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._expression
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ExpressionStatementSyntax(Me.Kind, newErrors, GetAnnotations, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ExpressionStatementSyntax(Me.Kind, GetDiagnostics, annotations, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitExpressionStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent a "? expression" "Print" statement in VB Interactive code.
    ''' </summary>
    Friend NotInheritable Class PrintStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _questionToken as PunctuationSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, questionToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(questionToken)
            Me._questionToken = questionToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, questionToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(questionToken)
            Me._questionToken = questionToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), questionToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(questionToken)
            Me._questionToken = questionToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _questionToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _questionToken isnot Nothing 
             AdjustFlagsAndWidth(_questionToken)
             Me._questionToken = _questionToken
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New PrintStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._questionToken)
          writer.WriteValue(Me._expression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(PrintStatementSyntax), Function(r) New PrintStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.PrintStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' "?" token.
        ''' </summary>
        Friend  ReadOnly Property QuestionToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._questionToken
            End Get
        End Property

        ''' <summary>
        ''' The expression whose value is being output.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._questionToken
                Case 1
                    Return Me._expression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new PrintStatementSyntax(Me.Kind, newErrors, GetAnnotations, _questionToken, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new PrintStatementSyntax(Me.Kind, GetDiagnostics, annotations, _questionToken, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitPrintStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a While...End While statement, including the While, body and End
    ''' While.
    ''' </summary>
    Friend NotInheritable Class WhileBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _whileStatement as WhileStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _endWhileStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, whileStatement As WhileStatementSyntax, statements As GreenNode, endWhileStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(whileStatement)
            Me._whileStatement = whileStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWhileStatement)
            Me._endWhileStatement = endWhileStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, whileStatement As WhileStatementSyntax, statements As GreenNode, endWhileStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(whileStatement)
            Me._whileStatement = whileStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWhileStatement)
            Me._endWhileStatement = endWhileStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whileStatement As WhileStatementSyntax, statements As GreenNode, endWhileStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(whileStatement)
            Me._whileStatement = whileStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWhileStatement)
            Me._endWhileStatement = endWhileStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _whileStatement = DirectCast(reader.ReadValue(), WhileStatementSyntax)
          If _whileStatement isnot Nothing 
             AdjustFlagsAndWidth(_whileStatement)
             Me._whileStatement = _whileStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
          Dim _endWhileStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endWhileStatement isnot Nothing 
             AdjustFlagsAndWidth(_endWhileStatement)
             Me._endWhileStatement = _endWhileStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New WhileBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._whileStatement)
          writer.WriteValue(Me._statements)
          writer.WriteValue(Me._endWhileStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(WhileBlockSyntax), Function(r) New WhileBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WhileBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The While statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property WhileStatement As InternalSyntax.WhileStatementSyntax
            Get
                Return Me._whileStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the While...End While. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The End While statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndWhileStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endWhileStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._whileStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endWhileStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WhileBlockSyntax(Me.Kind, newErrors, GetAnnotations, _whileStatement, _statements, _endWhileStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WhileBlockSyntax(Me.Kind, GetDiagnostics, annotations, _whileStatement, _statements, _endWhileStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWhileBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an entire Using...End Using statement, including the Using, body and
    ''' End Using statements.
    ''' </summary>
    Friend NotInheritable Class UsingBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _usingStatement as UsingStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _endUsingStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, usingStatement As UsingStatementSyntax, statements As GreenNode, endUsingStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(usingStatement)
            Me._usingStatement = usingStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endUsingStatement)
            Me._endUsingStatement = endUsingStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, usingStatement As UsingStatementSyntax, statements As GreenNode, endUsingStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(usingStatement)
            Me._usingStatement = usingStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endUsingStatement)
            Me._endUsingStatement = endUsingStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), usingStatement As UsingStatementSyntax, statements As GreenNode, endUsingStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(usingStatement)
            Me._usingStatement = usingStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endUsingStatement)
            Me._endUsingStatement = endUsingStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _usingStatement = DirectCast(reader.ReadValue(), UsingStatementSyntax)
          If _usingStatement isnot Nothing 
             AdjustFlagsAndWidth(_usingStatement)
             Me._usingStatement = _usingStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
          Dim _endUsingStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endUsingStatement isnot Nothing 
             AdjustFlagsAndWidth(_endUsingStatement)
             Me._endUsingStatement = _endUsingStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New UsingBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._usingStatement)
          writer.WriteValue(Me._statements)
          writer.WriteValue(Me._endUsingStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(UsingBlockSyntax), Function(r) New UsingBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.UsingBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The UsingStatement that begins the Using...End Using block.
        ''' </summary>
        Friend  ReadOnly Property UsingStatement As InternalSyntax.UsingStatementSyntax
            Get
                Return Me._usingStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the Using...End Using block. This might be an empty
        ''' list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The End Using statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndUsingStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endUsingStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._usingStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endUsingStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new UsingBlockSyntax(Me.Kind, newErrors, GetAnnotations, _usingStatement, _statements, _endUsingStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new UsingBlockSyntax(Me.Kind, GetDiagnostics, annotations, _usingStatement, _statements, _endUsingStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitUsingBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a entire SyncLock...End SyncLock block, including the SyncLock
    ''' statement, the enclosed statements, and the End SyncLock statement.
    ''' </summary>
    Friend NotInheritable Class SyncLockBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _syncLockStatement as SyncLockStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _endSyncLockStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, syncLockStatement As SyncLockStatementSyntax, statements As GreenNode, endSyncLockStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(syncLockStatement)
            Me._syncLockStatement = syncLockStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSyncLockStatement)
            Me._endSyncLockStatement = endSyncLockStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, syncLockStatement As SyncLockStatementSyntax, statements As GreenNode, endSyncLockStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(syncLockStatement)
            Me._syncLockStatement = syncLockStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSyncLockStatement)
            Me._endSyncLockStatement = endSyncLockStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), syncLockStatement As SyncLockStatementSyntax, statements As GreenNode, endSyncLockStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(syncLockStatement)
            Me._syncLockStatement = syncLockStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSyncLockStatement)
            Me._endSyncLockStatement = endSyncLockStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _syncLockStatement = DirectCast(reader.ReadValue(), SyncLockStatementSyntax)
          If _syncLockStatement isnot Nothing 
             AdjustFlagsAndWidth(_syncLockStatement)
             Me._syncLockStatement = _syncLockStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
          Dim _endSyncLockStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endSyncLockStatement isnot Nothing 
             AdjustFlagsAndWidth(_endSyncLockStatement)
             Me._endSyncLockStatement = _endSyncLockStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SyncLockBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._syncLockStatement)
          writer.WriteValue(Me._statements)
          writer.WriteValue(Me._endSyncLockStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SyncLockBlockSyntax), Function(r) New SyncLockBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SyncLockBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The SyncLock statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property SyncLockStatement As InternalSyntax.SyncLockStatementSyntax
            Get
                Return Me._syncLockStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the SyncLock...End SyncLock statement. This might
        ''' be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The End SyncLock statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndSyncLockStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endSyncLockStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._syncLockStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endSyncLockStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SyncLockBlockSyntax(Me.Kind, newErrors, GetAnnotations, _syncLockStatement, _statements, _endSyncLockStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SyncLockBlockSyntax(Me.Kind, GetDiagnostics, annotations, _syncLockStatement, _statements, _endSyncLockStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSyncLockBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a With...End With block, include the With statement, the body of the
    ''' block and the End With statement.
    ''' </summary>
    Friend NotInheritable Class WithBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _withStatement as WithStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _endWithStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, withStatement As WithStatementSyntax, statements As GreenNode, endWithStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(withStatement)
            Me._withStatement = withStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWithStatement)
            Me._endWithStatement = endWithStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, withStatement As WithStatementSyntax, statements As GreenNode, endWithStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(withStatement)
            Me._withStatement = withStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWithStatement)
            Me._endWithStatement = endWithStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withStatement As WithStatementSyntax, statements As GreenNode, endWithStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(withStatement)
            Me._withStatement = withStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWithStatement)
            Me._endWithStatement = endWithStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _withStatement = DirectCast(reader.ReadValue(), WithStatementSyntax)
          If _withStatement isnot Nothing 
             AdjustFlagsAndWidth(_withStatement)
             Me._withStatement = _withStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
          Dim _endWithStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endWithStatement isnot Nothing 
             AdjustFlagsAndWidth(_endWithStatement)
             Me._endWithStatement = _endWithStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New WithBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._withStatement)
          writer.WriteValue(Me._statements)
          writer.WriteValue(Me._endWithStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(WithBlockSyntax), Function(r) New WithBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WithBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The WithStatement that begins the With...End With block.
        ''' </summary>
        Friend  ReadOnly Property WithStatement As InternalSyntax.WithStatementSyntax
            Get
                Return Me._withStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the With...End With block. This might be an empty
        ''' list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The End With statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndWithStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endWithStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._withStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endWithStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WithBlockSyntax(Me.Kind, newErrors, GetAnnotations, _withStatement, _statements, _endWithStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WithBlockSyntax(Me.Kind, GetDiagnostics, annotations, _withStatement, _statements, _endWithStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWithBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the declaration of one or more local variables or constants.
    ''' </summary>
    Friend NotInheritable Class LocalDeclarationStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _declarators as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, modifiers As GreenNode, declarators As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, modifiers As GreenNode, declarators As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), modifiers As GreenNode, declarators As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _modifiers = DirectCast(reader.ReadValue(), GreenNode)
          If _modifiers isnot Nothing 
             AdjustFlagsAndWidth(_modifiers)
             Me._modifiers = _modifiers
          End If
          Dim _declarators = DirectCast(reader.ReadValue(), GreenNode)
          If _declarators isnot Nothing 
             AdjustFlagsAndWidth(_declarators)
             Me._declarators = _declarators
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New LocalDeclarationStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._modifiers)
          writer.WriteValue(Me._declarators)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(LocalDeclarationStatementSyntax), Function(r) New LocalDeclarationStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LocalDeclarationStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The modifier token (Static, Dim or Const) that introduces this local variable
        ''' declaration.
        ''' </summary>
        Friend  ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The list of variable declarator. Each declarator specifies one or more variable
        ''' names along with a type and/or initializer.
        ''' </summary>
        Friend  ReadOnly Property Declarators As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of VariableDeclaratorSyntax)(Me._declarators))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._modifiers
                Case 1
                    Return Me._declarators
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LocalDeclarationStatementSyntax(Me.Kind, newErrors, GetAnnotations, _modifiers, _declarators)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LocalDeclarationStatementSyntax(Me.Kind, GetDiagnostics, annotations, _modifiers, _declarators)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLocalDeclarationStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a label statement.
    ''' </summary>
    Friend NotInheritable Class LabelStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _labelToken as SyntaxToken
        Friend ReadOnly _colonToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, labelToken As InternalSyntax.SyntaxToken, colonToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, labelToken As InternalSyntax.SyntaxToken, colonToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), labelToken As InternalSyntax.SyntaxToken, colonToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _labelToken = DirectCast(reader.ReadValue(), SyntaxToken)
          If _labelToken isnot Nothing 
             AdjustFlagsAndWidth(_labelToken)
             Me._labelToken = _labelToken
          End If
          Dim _colonToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _colonToken isnot Nothing 
             AdjustFlagsAndWidth(_colonToken)
             Me._colonToken = _colonToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New LabelStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._labelToken)
          writer.WriteValue(Me._colonToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(LabelStatementSyntax), Function(r) New LabelStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LabelStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The name of the label. If the label is a line number, returns an IntegerLiteral
        ''' that is the line number, otherwise, returns an Identifier.
        ''' </summary>
        Friend  ReadOnly Property LabelToken As InternalSyntax.SyntaxToken
            Get
                Return Me._labelToken
            End Get
        End Property

        ''' <summary>
        ''' The ":" token of the label statement.
        ''' </summary>
        Friend  ReadOnly Property ColonToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._colonToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._labelToken
                Case 1
                    Return Me._colonToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LabelStatementSyntax(Me.Kind, newErrors, GetAnnotations, _labelToken, _colonToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LabelStatementSyntax(Me.Kind, GetDiagnostics, annotations, _labelToken, _colonToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLabelStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "GoTo" statement.
    ''' </summary>
    Friend NotInheritable Class GoToStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _goToKeyword as KeywordSyntax
        Friend ReadOnly _label as LabelSyntax

        Friend Sub New(ByVal kind As SyntaxKind, goToKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, goToKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), goToKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _goToKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _goToKeyword isnot Nothing 
             AdjustFlagsAndWidth(_goToKeyword)
             Me._goToKeyword = _goToKeyword
          End If
          Dim _label = DirectCast(reader.ReadValue(), LabelSyntax)
          If _label isnot Nothing 
             AdjustFlagsAndWidth(_label)
             Me._label = _label
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New GoToStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._goToKeyword)
          writer.WriteValue(Me._label)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(GoToStatementSyntax), Function(r) New GoToStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.GoToStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "GoTo" keyword.
        ''' </summary>
        Friend  ReadOnly Property GoToKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._goToKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the label. If the label is a line number, wraps an IntegerLiteral
        ''' that is the line number, otherwise, wraps an Identifier.
        ''' </summary>
        Friend  ReadOnly Property Label As InternalSyntax.LabelSyntax
            Get
                Return Me._label
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._goToKeyword
                Case 1
                    Return Me._label
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new GoToStatementSyntax(Me.Kind, newErrors, GetAnnotations, _goToKeyword, _label)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new GoToStatementSyntax(Me.Kind, GetDiagnostics, annotations, _goToKeyword, _label)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitGoToStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A label for a GoTo, Resume, or On Error statement. An identifier, line number,
    ''' or next keyword.
    ''' </summary>
    Friend NotInheritable Class LabelSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _labelToken as SyntaxToken

        Friend Sub New(ByVal kind As SyntaxKind, labelToken As InternalSyntax.SyntaxToken)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, labelToken As InternalSyntax.SyntaxToken, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), labelToken As InternalSyntax.SyntaxToken)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _labelToken = DirectCast(reader.ReadValue(), SyntaxToken)
          If _labelToken isnot Nothing 
             AdjustFlagsAndWidth(_labelToken)
             Me._labelToken = _labelToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New LabelSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._labelToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(LabelSyntax), Function(r) New LabelSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LabelSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The label name (identifier), line number (integer literal), or next keyword
        ''' token.
        ''' </summary>
        Friend  ReadOnly Property LabelToken As InternalSyntax.SyntaxToken
            Get
                Return Me._labelToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._labelToken
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LabelSyntax(Me.Kind, newErrors, GetAnnotations, _labelToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LabelSyntax(Me.Kind, GetDiagnostics, annotations, _labelToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLabel(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Stop" or "End" statement. The Kind can be used to determine which
    ''' kind of statement this is.
    ''' </summary>
    Friend NotInheritable Class StopOrEndStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _stopOrEndKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, stopOrEndKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(stopOrEndKeyword)
            Me._stopOrEndKeyword = stopOrEndKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, stopOrEndKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(stopOrEndKeyword)
            Me._stopOrEndKeyword = stopOrEndKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), stopOrEndKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(stopOrEndKeyword)
            Me._stopOrEndKeyword = stopOrEndKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _stopOrEndKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _stopOrEndKeyword isnot Nothing 
             AdjustFlagsAndWidth(_stopOrEndKeyword)
             Me._stopOrEndKeyword = _stopOrEndKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New StopOrEndStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._stopOrEndKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(StopOrEndStatementSyntax), Function(r) New StopOrEndStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.StopOrEndStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Stop" or "End" keyword.
        ''' </summary>
        Friend  ReadOnly Property StopOrEndKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._stopOrEndKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._stopOrEndKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new StopOrEndStatementSyntax(Me.Kind, newErrors, GetAnnotations, _stopOrEndKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new StopOrEndStatementSyntax(Me.Kind, GetDiagnostics, annotations, _stopOrEndKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitStopOrEndStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' An exit statement. The kind of block being exited can be found by examining the
    ''' Kind.
    ''' </summary>
    Friend NotInheritable Class ExitStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _exitKeyword as KeywordSyntax
        Friend ReadOnly _blockKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, exitKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(exitKeyword)
            Me._exitKeyword = exitKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, exitKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(exitKeyword)
            Me._exitKeyword = exitKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), exitKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(exitKeyword)
            Me._exitKeyword = exitKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _exitKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _exitKeyword isnot Nothing 
             AdjustFlagsAndWidth(_exitKeyword)
             Me._exitKeyword = _exitKeyword
          End If
          Dim _blockKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _blockKeyword isnot Nothing 
             AdjustFlagsAndWidth(_blockKeyword)
             Me._blockKeyword = _blockKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ExitStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._exitKeyword)
          writer.WriteValue(Me._blockKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ExitStatementSyntax), Function(r) New ExitStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ExitStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Exit" keyword.
        ''' </summary>
        Friend  ReadOnly Property ExitKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._exitKeyword
            End Get
        End Property

        ''' <summary>
        ''' The keyword describing the block to exit.
        ''' </summary>
        Friend  ReadOnly Property BlockKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._blockKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._exitKeyword
                Case 1
                    Return Me._blockKeyword
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ExitStatementSyntax(Me.Kind, newErrors, GetAnnotations, _exitKeyword, _blockKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ExitStatementSyntax(Me.Kind, GetDiagnostics, annotations, _exitKeyword, _blockKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitExitStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Continue (block)" statement. THe kind of block referenced can be
    ''' determined by examining the Kind.
    ''' </summary>
    Friend NotInheritable Class ContinueStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _continueKeyword as KeywordSyntax
        Friend ReadOnly _blockKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, continueKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(continueKeyword)
            Me._continueKeyword = continueKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, continueKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(continueKeyword)
            Me._continueKeyword = continueKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), continueKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(continueKeyword)
            Me._continueKeyword = continueKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _continueKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _continueKeyword isnot Nothing 
             AdjustFlagsAndWidth(_continueKeyword)
             Me._continueKeyword = _continueKeyword
          End If
          Dim _blockKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _blockKeyword isnot Nothing 
             AdjustFlagsAndWidth(_blockKeyword)
             Me._blockKeyword = _blockKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ContinueStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._continueKeyword)
          writer.WriteValue(Me._blockKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ContinueStatementSyntax), Function(r) New ContinueStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ContinueStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Continue" keyword.
        ''' </summary>
        Friend  ReadOnly Property ContinueKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._continueKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Do", "For" or "While" keyword that identifies the kind of loop being
        ''' continued.
        ''' </summary>
        Friend  ReadOnly Property BlockKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._blockKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._continueKeyword
                Case 1
                    Return Me._blockKeyword
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ContinueStatementSyntax(Me.Kind, newErrors, GetAnnotations, _continueKeyword, _blockKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ContinueStatementSyntax(Me.Kind, GetDiagnostics, annotations, _continueKeyword, _blockKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitContinueStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Return" statement.
    ''' </summary>
    Friend NotInheritable Class ReturnStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _returnKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, returnKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(returnKeyword)
            Me._returnKeyword = returnKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, returnKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(returnKeyword)
            Me._returnKeyword = returnKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), returnKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(returnKeyword)
            Me._returnKeyword = returnKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _returnKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _returnKeyword isnot Nothing 
             AdjustFlagsAndWidth(_returnKeyword)
             Me._returnKeyword = _returnKeyword
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ReturnStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._returnKeyword)
          writer.WriteValue(Me._expression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ReturnStatementSyntax), Function(r) New ReturnStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ReturnStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Return" keyword.
        ''' </summary>
        Friend  ReadOnly Property ReturnKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._returnKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression being returned, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._returnKeyword
                Case 1
                    Return Me._expression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ReturnStatementSyntax(Me.Kind, newErrors, GetAnnotations, _returnKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ReturnStatementSyntax(Me.Kind, GetDiagnostics, annotations, _returnKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitReturnStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single-line "If ... Then ... Else ..." statement.
    ''' </summary>
    Friend NotInheritable Class SingleLineIfStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _ifKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax
        Friend ReadOnly _thenKeyword as KeywordSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _elseClause as SingleLineElseClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode, elseClause As SingleLineElseClauseSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(thenKeyword)
            Me._thenKeyword = thenKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseClause IsNot Nothing Then
                AdjustFlagsAndWidth(elseClause)
                Me._elseClause = elseClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode, elseClause As SingleLineElseClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(thenKeyword)
            Me._thenKeyword = thenKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseClause IsNot Nothing Then
                AdjustFlagsAndWidth(elseClause)
                Me._elseClause = elseClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode, elseClause As SingleLineElseClauseSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(thenKeyword)
            Me._thenKeyword = thenKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseClause IsNot Nothing Then
                AdjustFlagsAndWidth(elseClause)
                Me._elseClause = elseClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _ifKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _ifKeyword isnot Nothing 
             AdjustFlagsAndWidth(_ifKeyword)
             Me._ifKeyword = _ifKeyword
          End If
          Dim _condition = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _condition isnot Nothing 
             AdjustFlagsAndWidth(_condition)
             Me._condition = _condition
          End If
          Dim _thenKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _thenKeyword isnot Nothing 
             AdjustFlagsAndWidth(_thenKeyword)
             Me._thenKeyword = _thenKeyword
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
          Dim _elseClause = DirectCast(reader.ReadValue(), SingleLineElseClauseSyntax)
          If _elseClause isnot Nothing 
             AdjustFlagsAndWidth(_elseClause)
             Me._elseClause = _elseClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SingleLineIfStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._ifKeyword)
          writer.WriteValue(Me._condition)
          writer.WriteValue(Me._thenKeyword)
          writer.WriteValue(Me._statements)
          writer.WriteValue(Me._elseClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SingleLineIfStatementSyntax), Function(r) New SingleLineIfStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SingleLineIfStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "If" keyword.
        ''' </summary>
        Friend  ReadOnly Property IfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._ifKeyword
            End Get
        End Property

        ''' <summary>
        ''' The condition expression to be evaluated.
        ''' </summary>
        Friend  ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        ''' <summary>
        ''' The "Then" keyword.
        ''' </summary>
        Friend  ReadOnly Property ThenKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._thenKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed if the condition expression evaluates as
        ''' true. Multiple statements must be separated by colons.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' An "Else" clause to be executed if the condition expression evaluates as false.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ElseClause As InternalSyntax.SingleLineElseClauseSyntax
            Get
                Return Me._elseClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._ifKeyword
                Case 1
                    Return Me._condition
                Case 2
                    Return Me._thenKeyword
                Case 3
                    Return Me._statements
                Case 4
                    Return Me._elseClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SingleLineIfStatementSyntax(Me.Kind, newErrors, GetAnnotations, _ifKeyword, _condition, _thenKeyword, _statements, _elseClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SingleLineIfStatementSyntax(Me.Kind, GetDiagnostics, annotations, _ifKeyword, _condition, _thenKeyword, _statements, _elseClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSingleLineIfStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Else ..." clause of a single-line "If" statement.
    ''' </summary>
    Friend NotInheritable Class SingleLineElseClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _elseKeyword as KeywordSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _elseKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _elseKeyword isnot Nothing 
             AdjustFlagsAndWidth(_elseKeyword)
             Me._elseKeyword = _elseKeyword
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SingleLineElseClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._elseKeyword)
          writer.WriteValue(Me._statements)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SingleLineElseClauseSyntax), Function(r) New SingleLineElseClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SingleLineElseClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Else" keyword.
        ''' </summary>
        Friend  ReadOnly Property ElseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._elseKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed. Multiple statements must be separated by
        ''' colons.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._elseKeyword
                Case 1
                    Return Me._statements
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SingleLineElseClauseSyntax(Me.Kind, newErrors, GetAnnotations, _elseKeyword, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SingleLineElseClauseSyntax(Me.Kind, GetDiagnostics, annotations, _elseKeyword, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSingleLineElseClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a multi-line "If ... Then ... ElseIf ... Then ... Else ... End If"
    ''' block.
    ''' </summary>
    Friend NotInheritable Class MultiLineIfBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _ifStatement as IfStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _elseIfBlocks as GreenNode
        Friend ReadOnly _elseBlock as ElseBlockSyntax
        Friend ReadOnly _endIfStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, ifStatement As IfStatementSyntax, statements As GreenNode, elseIfBlocks As GreenNode, elseBlock As ElseBlockSyntax, endIfStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(ifStatement)
            Me._ifStatement = ifStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseIfBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(elseIfBlocks)
                Me._elseIfBlocks = elseIfBlocks
            End If
            If elseBlock IsNot Nothing Then
                AdjustFlagsAndWidth(elseBlock)
                Me._elseBlock = elseBlock
            End If
            AdjustFlagsAndWidth(endIfStatement)
            Me._endIfStatement = endIfStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ifStatement As IfStatementSyntax, statements As GreenNode, elseIfBlocks As GreenNode, elseBlock As ElseBlockSyntax, endIfStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(ifStatement)
            Me._ifStatement = ifStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseIfBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(elseIfBlocks)
                Me._elseIfBlocks = elseIfBlocks
            End If
            If elseBlock IsNot Nothing Then
                AdjustFlagsAndWidth(elseBlock)
                Me._elseBlock = elseBlock
            End If
            AdjustFlagsAndWidth(endIfStatement)
            Me._endIfStatement = endIfStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifStatement As IfStatementSyntax, statements As GreenNode, elseIfBlocks As GreenNode, elseBlock As ElseBlockSyntax, endIfStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(ifStatement)
            Me._ifStatement = ifStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseIfBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(elseIfBlocks)
                Me._elseIfBlocks = elseIfBlocks
            End If
            If elseBlock IsNot Nothing Then
                AdjustFlagsAndWidth(elseBlock)
                Me._elseBlock = elseBlock
            End If
            AdjustFlagsAndWidth(endIfStatement)
            Me._endIfStatement = endIfStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _ifStatement = DirectCast(reader.ReadValue(), IfStatementSyntax)
          If _ifStatement isnot Nothing 
             AdjustFlagsAndWidth(_ifStatement)
             Me._ifStatement = _ifStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
          Dim _elseIfBlocks = DirectCast(reader.ReadValue(), GreenNode)
          If _elseIfBlocks isnot Nothing 
             AdjustFlagsAndWidth(_elseIfBlocks)
             Me._elseIfBlocks = _elseIfBlocks
          End If
          Dim _elseBlock = DirectCast(reader.ReadValue(), ElseBlockSyntax)
          If _elseBlock isnot Nothing 
             AdjustFlagsAndWidth(_elseBlock)
             Me._elseBlock = _elseBlock
          End If
          Dim _endIfStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endIfStatement isnot Nothing 
             AdjustFlagsAndWidth(_endIfStatement)
             Me._endIfStatement = _endIfStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New MultiLineIfBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._ifStatement)
          writer.WriteValue(Me._statements)
          writer.WriteValue(Me._elseIfBlocks)
          writer.WriteValue(Me._elseBlock)
          writer.WriteValue(Me._endIfStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(MultiLineIfBlockSyntax), Function(r) New MultiLineIfBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MultiLineIfBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "If" statement that begins the "If" block.
        ''' </summary>
        Friend  ReadOnly Property IfStatement As InternalSyntax.IfStatementSyntax
            Get
                Return Me._ifStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed if the condition expression evaluates as
        ''' true.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' A list of "ElseIf" blocks to be evaluated, in order, if the condition
        ''' expression of the "If" statement evaluates as false.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property ElseIfBlocks As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ElseIfBlockSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ElseIfBlockSyntax)(Me._elseIfBlocks)
            End Get
        End Property

        ''' <summary>
        ''' An "Else" block to be executed if the condition expression of the "If"
        ''' statement and all "ElseIf" blocks evaluate as false.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ElseBlock As InternalSyntax.ElseBlockSyntax
            Get
                Return Me._elseBlock
            End Get
        End Property

        ''' <summary>
        ''' Then "End If" statement.
        ''' </summary>
        Friend  ReadOnly Property EndIfStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endIfStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._ifStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._elseIfBlocks
                Case 3
                    Return Me._elseBlock
                Case 4
                    Return Me._endIfStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MultiLineIfBlockSyntax(Me.Kind, newErrors, GetAnnotations, _ifStatement, _statements, _elseIfBlocks, _elseBlock, _endIfStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MultiLineIfBlockSyntax(Me.Kind, GetDiagnostics, annotations, _ifStatement, _statements, _elseIfBlocks, _elseBlock, _endIfStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMultiLineIfBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "If ... Then" statement that begins a multi-line "If" block.
    ''' </summary>
    Friend NotInheritable Class IfStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _ifKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax
        Friend ReadOnly _thenKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _ifKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _ifKeyword isnot Nothing 
             AdjustFlagsAndWidth(_ifKeyword)
             Me._ifKeyword = _ifKeyword
          End If
          Dim _condition = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _condition isnot Nothing 
             AdjustFlagsAndWidth(_condition)
             Me._condition = _condition
          End If
          Dim _thenKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _thenKeyword isnot Nothing 
             AdjustFlagsAndWidth(_thenKeyword)
             Me._thenKeyword = _thenKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New IfStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._ifKeyword)
          writer.WriteValue(Me._condition)
          writer.WriteValue(Me._thenKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(IfStatementSyntax), Function(r) New IfStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.IfStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "If" keyword.
        ''' </summary>
        Friend  ReadOnly Property IfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._ifKeyword
            End Get
        End Property

        ''' <summary>
        ''' The condition expression to be evaluated.
        ''' </summary>
        Friend  ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        ''' <summary>
        ''' The "Then" keyword.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ThenKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._thenKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._ifKeyword
                Case 1
                    Return Me._condition
                Case 2
                    Return Me._thenKeyword
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new IfStatementSyntax(Me.Kind, newErrors, GetAnnotations, _ifKeyword, _condition, _thenKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new IfStatementSyntax(Me.Kind, GetDiagnostics, annotations, _ifKeyword, _condition, _thenKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitIfStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "ElseIf ... Then ..." block.
    ''' </summary>
    Friend NotInheritable Class ElseIfBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _elseIfStatement as ElseIfStatementSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, elseIfStatement As ElseIfStatementSyntax, statements As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(elseIfStatement)
            Me._elseIfStatement = elseIfStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseIfStatement As ElseIfStatementSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseIfStatement)
            Me._elseIfStatement = elseIfStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseIfStatement As ElseIfStatementSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(elseIfStatement)
            Me._elseIfStatement = elseIfStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _elseIfStatement = DirectCast(reader.ReadValue(), ElseIfStatementSyntax)
          If _elseIfStatement isnot Nothing 
             AdjustFlagsAndWidth(_elseIfStatement)
             Me._elseIfStatement = _elseIfStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ElseIfBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._elseIfStatement)
          writer.WriteValue(Me._statements)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ElseIfBlockSyntax), Function(r) New ElseIfBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ElseIfBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "ElseIf ... Then" statement the begins the "ElseIf" block.
        ''' </summary>
        Friend  ReadOnly Property ElseIfStatement As InternalSyntax.ElseIfStatementSyntax
            Get
                Return Me._elseIfStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed if the condition expression of the "ElseIf"
        ''' statement evaluates as true.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._elseIfStatement
                Case 1
                    Return Me._statements
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ElseIfBlockSyntax(Me.Kind, newErrors, GetAnnotations, _elseIfStatement, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ElseIfBlockSyntax(Me.Kind, GetDiagnostics, annotations, _elseIfStatement, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitElseIfBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "ElseIf ... Then" statement that begins an "ElseIf" block.
    ''' </summary>
    Friend NotInheritable Class ElseIfStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _elseIfKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax
        Friend ReadOnly _thenKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, elseIfKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(elseIfKeyword)
            Me._elseIfKeyword = elseIfKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseIfKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseIfKeyword)
            Me._elseIfKeyword = elseIfKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseIfKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(elseIfKeyword)
            Me._elseIfKeyword = elseIfKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _elseIfKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _elseIfKeyword isnot Nothing 
             AdjustFlagsAndWidth(_elseIfKeyword)
             Me._elseIfKeyword = _elseIfKeyword
          End If
          Dim _condition = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _condition isnot Nothing 
             AdjustFlagsAndWidth(_condition)
             Me._condition = _condition
          End If
          Dim _thenKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _thenKeyword isnot Nothing 
             AdjustFlagsAndWidth(_thenKeyword)
             Me._thenKeyword = _thenKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ElseIfStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._elseIfKeyword)
          writer.WriteValue(Me._condition)
          writer.WriteValue(Me._thenKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ElseIfStatementSyntax), Function(r) New ElseIfStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ElseIfStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "ElseIf" keyword.
        ''' </summary>
        Friend  ReadOnly Property ElseIfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._elseIfKeyword
            End Get
        End Property

        ''' <summary>
        ''' The condition expression to be evaluated.
        ''' </summary>
        Friend  ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        ''' <summary>
        ''' The "Then" keyword.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ThenKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._thenKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._elseIfKeyword
                Case 1
                    Return Me._condition
                Case 2
                    Return Me._thenKeyword
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ElseIfStatementSyntax(Me.Kind, newErrors, GetAnnotations, _elseIfKeyword, _condition, _thenKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ElseIfStatementSyntax(Me.Kind, GetDiagnostics, annotations, _elseIfKeyword, _condition, _thenKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitElseIfStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "Else ..." block.
    ''' </summary>
    Friend NotInheritable Class ElseBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _elseStatement as ElseStatementSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, elseStatement As ElseStatementSyntax, statements As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(elseStatement)
            Me._elseStatement = elseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseStatement As ElseStatementSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseStatement)
            Me._elseStatement = elseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseStatement As ElseStatementSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(elseStatement)
            Me._elseStatement = elseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _elseStatement = DirectCast(reader.ReadValue(), ElseStatementSyntax)
          If _elseStatement isnot Nothing 
             AdjustFlagsAndWidth(_elseStatement)
             Me._elseStatement = _elseStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ElseBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._elseStatement)
          writer.WriteValue(Me._statements)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ElseBlockSyntax), Function(r) New ElseBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ElseBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Else" statement that begins the "Else" block.
        ''' </summary>
        Friend  ReadOnly Property ElseStatement As InternalSyntax.ElseStatementSyntax
            Get
                Return Me._elseStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._elseStatement
                Case 1
                    Return Me._statements
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ElseBlockSyntax(Me.Kind, newErrors, GetAnnotations, _elseStatement, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ElseBlockSyntax(Me.Kind, GetDiagnostics, annotations, _elseStatement, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitElseBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Else" statement that begins an "Else" block.
    ''' </summary>
    Friend NotInheritable Class ElseStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _elseKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _elseKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _elseKeyword isnot Nothing 
             AdjustFlagsAndWidth(_elseKeyword)
             Me._elseKeyword = _elseKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ElseStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._elseKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ElseStatementSyntax), Function(r) New ElseStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ElseStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Else" keyword.
        ''' </summary>
        Friend  ReadOnly Property ElseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._elseKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._elseKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ElseStatementSyntax(Me.Kind, newErrors, GetAnnotations, _elseKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ElseStatementSyntax(Me.Kind, GetDiagnostics, annotations, _elseKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitElseStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Try ... Catch ... Finally ... End Try" block.
    ''' </summary>
    Friend NotInheritable Class TryBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _tryStatement as TryStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _catchBlocks as GreenNode
        Friend ReadOnly _finallyBlock as FinallyBlockSyntax
        Friend ReadOnly _endTryStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, tryStatement As TryStatementSyntax, statements As GreenNode, catchBlocks As GreenNode, finallyBlock As FinallyBlockSyntax, endTryStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(tryStatement)
            Me._tryStatement = tryStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If catchBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(catchBlocks)
                Me._catchBlocks = catchBlocks
            End If
            If finallyBlock IsNot Nothing Then
                AdjustFlagsAndWidth(finallyBlock)
                Me._finallyBlock = finallyBlock
            End If
            AdjustFlagsAndWidth(endTryStatement)
            Me._endTryStatement = endTryStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, tryStatement As TryStatementSyntax, statements As GreenNode, catchBlocks As GreenNode, finallyBlock As FinallyBlockSyntax, endTryStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(tryStatement)
            Me._tryStatement = tryStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If catchBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(catchBlocks)
                Me._catchBlocks = catchBlocks
            End If
            If finallyBlock IsNot Nothing Then
                AdjustFlagsAndWidth(finallyBlock)
                Me._finallyBlock = finallyBlock
            End If
            AdjustFlagsAndWidth(endTryStatement)
            Me._endTryStatement = endTryStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), tryStatement As TryStatementSyntax, statements As GreenNode, catchBlocks As GreenNode, finallyBlock As FinallyBlockSyntax, endTryStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(tryStatement)
            Me._tryStatement = tryStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If catchBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(catchBlocks)
                Me._catchBlocks = catchBlocks
            End If
            If finallyBlock IsNot Nothing Then
                AdjustFlagsAndWidth(finallyBlock)
                Me._finallyBlock = finallyBlock
            End If
            AdjustFlagsAndWidth(endTryStatement)
            Me._endTryStatement = endTryStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _tryStatement = DirectCast(reader.ReadValue(), TryStatementSyntax)
          If _tryStatement isnot Nothing 
             AdjustFlagsAndWidth(_tryStatement)
             Me._tryStatement = _tryStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
          Dim _catchBlocks = DirectCast(reader.ReadValue(), GreenNode)
          If _catchBlocks isnot Nothing 
             AdjustFlagsAndWidth(_catchBlocks)
             Me._catchBlocks = _catchBlocks
          End If
          Dim _finallyBlock = DirectCast(reader.ReadValue(), FinallyBlockSyntax)
          If _finallyBlock isnot Nothing 
             AdjustFlagsAndWidth(_finallyBlock)
             Me._finallyBlock = _finallyBlock
          End If
          Dim _endTryStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endTryStatement isnot Nothing 
             AdjustFlagsAndWidth(_endTryStatement)
             Me._endTryStatement = _endTryStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TryBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._tryStatement)
          writer.WriteValue(Me._statements)
          writer.WriteValue(Me._catchBlocks)
          writer.WriteValue(Me._finallyBlock)
          writer.WriteValue(Me._endTryStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TryBlockSyntax), Function(r) New TryBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TryBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Try" statement that begins the "Try" block.
        ''' </summary>
        Friend  ReadOnly Property TryStatement As InternalSyntax.TryStatementSyntax
            Get
                Return Me._tryStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' A list of "Catch" blocks which may be executed if an exception is thrown while
        ''' executing the statements in the "Try" block.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property CatchBlocks As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of CatchBlockSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of CatchBlockSyntax)(Me._catchBlocks)
            End Get
        End Property

        ''' <summary>
        ''' A "Finally" block to be executed before execution leaves the "Try" block.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property FinallyBlock As InternalSyntax.FinallyBlockSyntax
            Get
                Return Me._finallyBlock
            End Get
        End Property

        ''' <summary>
        ''' The "End Try" statement.
        ''' </summary>
        Friend  ReadOnly Property EndTryStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endTryStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._tryStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._catchBlocks
                Case 3
                    Return Me._finallyBlock
                Case 4
                    Return Me._endTryStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TryBlockSyntax(Me.Kind, newErrors, GetAnnotations, _tryStatement, _statements, _catchBlocks, _finallyBlock, _endTryStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TryBlockSyntax(Me.Kind, GetDiagnostics, annotations, _tryStatement, _statements, _catchBlocks, _finallyBlock, _endTryStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTryBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Try" statement that begins a "Try" block.
    ''' </summary>
    Friend NotInheritable Class TryStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _tryKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, tryKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(tryKeyword)
            Me._tryKeyword = tryKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, tryKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(tryKeyword)
            Me._tryKeyword = tryKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), tryKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(tryKeyword)
            Me._tryKeyword = tryKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _tryKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _tryKeyword isnot Nothing 
             AdjustFlagsAndWidth(_tryKeyword)
             Me._tryKeyword = _tryKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TryStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._tryKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TryStatementSyntax), Function(r) New TryStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TryStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Try" keyword.
        ''' </summary>
        Friend  ReadOnly Property TryKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._tryKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._tryKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TryStatementSyntax(Me.Kind, newErrors, GetAnnotations, _tryKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TryStatementSyntax(Me.Kind, GetDiagnostics, annotations, _tryKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTryStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Catch ..." block.
    ''' </summary>
    Friend NotInheritable Class CatchBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _catchStatement as CatchStatementSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, catchStatement As CatchStatementSyntax, statements As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(catchStatement)
            Me._catchStatement = catchStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, catchStatement As CatchStatementSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(catchStatement)
            Me._catchStatement = catchStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), catchStatement As CatchStatementSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(catchStatement)
            Me._catchStatement = catchStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _catchStatement = DirectCast(reader.ReadValue(), CatchStatementSyntax)
          If _catchStatement isnot Nothing 
             AdjustFlagsAndWidth(_catchStatement)
             Me._catchStatement = _catchStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New CatchBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._catchStatement)
          writer.WriteValue(Me._statements)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(CatchBlockSyntax), Function(r) New CatchBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CatchBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Catch" statement that begins the "Catch" block.
        ''' </summary>
        Friend  ReadOnly Property CatchStatement As InternalSyntax.CatchStatementSyntax
            Get
                Return Me._catchStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed if an exception is caught by the "Catch"
        ''' block.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._catchStatement
                Case 1
                    Return Me._statements
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CatchBlockSyntax(Me.Kind, newErrors, GetAnnotations, _catchStatement, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CatchBlockSyntax(Me.Kind, GetDiagnostics, annotations, _catchStatement, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCatchBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Catch ... When ..." statement that begins a "Catch" block.
    ''' </summary>
    Friend NotInheritable Class CatchStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _catchKeyword as KeywordSyntax
        Friend ReadOnly _identifierName as IdentifierNameSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax
        Friend ReadOnly _whenClause as CatchFilterClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, catchKeyword As InternalSyntax.KeywordSyntax, identifierName As IdentifierNameSyntax, asClause As SimpleAsClauseSyntax, whenClause As CatchFilterClauseSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(catchKeyword)
            Me._catchKeyword = catchKeyword
            If identifierName IsNot Nothing Then
                AdjustFlagsAndWidth(identifierName)
                Me._identifierName = identifierName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If whenClause IsNot Nothing Then
                AdjustFlagsAndWidth(whenClause)
                Me._whenClause = whenClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, catchKeyword As InternalSyntax.KeywordSyntax, identifierName As IdentifierNameSyntax, asClause As SimpleAsClauseSyntax, whenClause As CatchFilterClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(catchKeyword)
            Me._catchKeyword = catchKeyword
            If identifierName IsNot Nothing Then
                AdjustFlagsAndWidth(identifierName)
                Me._identifierName = identifierName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If whenClause IsNot Nothing Then
                AdjustFlagsAndWidth(whenClause)
                Me._whenClause = whenClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), catchKeyword As InternalSyntax.KeywordSyntax, identifierName As IdentifierNameSyntax, asClause As SimpleAsClauseSyntax, whenClause As CatchFilterClauseSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(catchKeyword)
            Me._catchKeyword = catchKeyword
            If identifierName IsNot Nothing Then
                AdjustFlagsAndWidth(identifierName)
                Me._identifierName = identifierName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If whenClause IsNot Nothing Then
                AdjustFlagsAndWidth(whenClause)
                Me._whenClause = whenClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _catchKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _catchKeyword isnot Nothing 
             AdjustFlagsAndWidth(_catchKeyword)
             Me._catchKeyword = _catchKeyword
          End If
          Dim _identifierName = DirectCast(reader.ReadValue(), IdentifierNameSyntax)
          If _identifierName isnot Nothing 
             AdjustFlagsAndWidth(_identifierName)
             Me._identifierName = _identifierName
          End If
          Dim _asClause = DirectCast(reader.ReadValue(), SimpleAsClauseSyntax)
          If _asClause isnot Nothing 
             AdjustFlagsAndWidth(_asClause)
             Me._asClause = _asClause
          End If
          Dim _whenClause = DirectCast(reader.ReadValue(), CatchFilterClauseSyntax)
          If _whenClause isnot Nothing 
             AdjustFlagsAndWidth(_whenClause)
             Me._whenClause = _whenClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New CatchStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._catchKeyword)
          writer.WriteValue(Me._identifierName)
          writer.WriteValue(Me._asClause)
          writer.WriteValue(Me._whenClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(CatchStatementSyntax), Function(r) New CatchStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CatchStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Catch" keyword.
        ''' </summary>
        Friend  ReadOnly Property CatchKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._catchKeyword
            End Get
        End Property

        ''' <summary>
        ''' An identifier declaring a new variable or naming an existing variable to store
        ''' the exception caught by the "Catch" statement.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property IdentifierName As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._identifierName
            End Get
        End Property

        ''' <summary>
        ''' A simple "As" clause specifying the type of exception to catch.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' A "When" clause to filter exceptions before catching.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property WhenClause As InternalSyntax.CatchFilterClauseSyntax
            Get
                Return Me._whenClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._catchKeyword
                Case 1
                    Return Me._identifierName
                Case 2
                    Return Me._asClause
                Case 3
                    Return Me._whenClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CatchStatementSyntax(Me.Kind, newErrors, GetAnnotations, _catchKeyword, _identifierName, _asClause, _whenClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CatchStatementSyntax(Me.Kind, GetDiagnostics, annotations, _catchKeyword, _identifierName, _asClause, _whenClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCatchStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "When ..." clause of a "Catch" statement.
    ''' </summary>
    Friend NotInheritable Class CatchFilterClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _whenKeyword as KeywordSyntax
        Friend ReadOnly _filter as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, whenKeyword As InternalSyntax.KeywordSyntax, filter As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(whenKeyword)
            Me._whenKeyword = whenKeyword
            AdjustFlagsAndWidth(filter)
            Me._filter = filter

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, whenKeyword As InternalSyntax.KeywordSyntax, filter As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(whenKeyword)
            Me._whenKeyword = whenKeyword
            AdjustFlagsAndWidth(filter)
            Me._filter = filter

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whenKeyword As InternalSyntax.KeywordSyntax, filter As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(whenKeyword)
            Me._whenKeyword = whenKeyword
            AdjustFlagsAndWidth(filter)
            Me._filter = filter

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _whenKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _whenKeyword isnot Nothing 
             AdjustFlagsAndWidth(_whenKeyword)
             Me._whenKeyword = _whenKeyword
          End If
          Dim _filter = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _filter isnot Nothing 
             AdjustFlagsAndWidth(_filter)
             Me._filter = _filter
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New CatchFilterClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._whenKeyword)
          writer.WriteValue(Me._filter)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(CatchFilterClauseSyntax), Function(r) New CatchFilterClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CatchFilterClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "When" keyword.
        ''' </summary>
        Friend  ReadOnly Property WhenKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._whenKeyword
            End Get
        End Property

        ''' <summary>
        ''' The filter expression to be evaluated.
        ''' </summary>
        Friend  ReadOnly Property Filter As InternalSyntax.ExpressionSyntax
            Get
                Return Me._filter
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._whenKeyword
                Case 1
                    Return Me._filter
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CatchFilterClauseSyntax(Me.Kind, newErrors, GetAnnotations, _whenKeyword, _filter)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CatchFilterClauseSyntax(Me.Kind, GetDiagnostics, annotations, _whenKeyword, _filter)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCatchFilterClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Finally ..." block of a "Try" block.
    ''' </summary>
    Friend NotInheritable Class FinallyBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _finallyStatement as FinallyStatementSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, finallyStatement As FinallyStatementSyntax, statements As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(finallyStatement)
            Me._finallyStatement = finallyStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, finallyStatement As FinallyStatementSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(finallyStatement)
            Me._finallyStatement = finallyStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), finallyStatement As FinallyStatementSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(finallyStatement)
            Me._finallyStatement = finallyStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _finallyStatement = DirectCast(reader.ReadValue(), FinallyStatementSyntax)
          If _finallyStatement isnot Nothing 
             AdjustFlagsAndWidth(_finallyStatement)
             Me._finallyStatement = _finallyStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New FinallyBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._finallyStatement)
          writer.WriteValue(Me._statements)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(FinallyBlockSyntax), Function(r) New FinallyBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.FinallyBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Finally" statement that begins the "Finally" block.
        ''' </summary>
        Friend  ReadOnly Property FinallyStatement As InternalSyntax.FinallyStatementSyntax
            Get
                Return Me._finallyStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._finallyStatement
                Case 1
                    Return Me._statements
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new FinallyBlockSyntax(Me.Kind, newErrors, GetAnnotations, _finallyStatement, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new FinallyBlockSyntax(Me.Kind, GetDiagnostics, annotations, _finallyStatement, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitFinallyBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Finally" statement that begins a "Finally" block.
    ''' </summary>
    Friend NotInheritable Class FinallyStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _finallyKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, finallyKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(finallyKeyword)
            Me._finallyKeyword = finallyKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, finallyKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(finallyKeyword)
            Me._finallyKeyword = finallyKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), finallyKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(finallyKeyword)
            Me._finallyKeyword = finallyKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _finallyKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _finallyKeyword isnot Nothing 
             AdjustFlagsAndWidth(_finallyKeyword)
             Me._finallyKeyword = _finallyKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New FinallyStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._finallyKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(FinallyStatementSyntax), Function(r) New FinallyStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.FinallyStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Finally" keyword.
        ''' </summary>
        Friend  ReadOnly Property FinallyKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._finallyKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._finallyKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new FinallyStatementSyntax(Me.Kind, newErrors, GetAnnotations, _finallyKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new FinallyStatementSyntax(Me.Kind, GetDiagnostics, annotations, _finallyKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitFinallyStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Error" statement.
    ''' </summary>
    Friend NotInheritable Class ErrorStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _errorKeyword as KeywordSyntax
        Friend ReadOnly _errorNumber as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, errorKeyword As InternalSyntax.KeywordSyntax, errorNumber As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(errorNumber)
            Me._errorNumber = errorNumber

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, errorKeyword As InternalSyntax.KeywordSyntax, errorNumber As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(errorNumber)
            Me._errorNumber = errorNumber

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), errorKeyword As InternalSyntax.KeywordSyntax, errorNumber As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(errorNumber)
            Me._errorNumber = errorNumber

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _errorKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _errorKeyword isnot Nothing 
             AdjustFlagsAndWidth(_errorKeyword)
             Me._errorKeyword = _errorKeyword
          End If
          Dim _errorNumber = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _errorNumber isnot Nothing 
             AdjustFlagsAndWidth(_errorNumber)
             Me._errorNumber = _errorNumber
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ErrorStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._errorKeyword)
          writer.WriteValue(Me._errorNumber)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ErrorStatementSyntax), Function(r) New ErrorStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ErrorStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Error" keyword.
        ''' </summary>
        Friend  ReadOnly Property ErrorKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._errorKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression that represents the error number.
        ''' </summary>
        Friend  ReadOnly Property ErrorNumber As InternalSyntax.ExpressionSyntax
            Get
                Return Me._errorNumber
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._errorKeyword
                Case 1
                    Return Me._errorNumber
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ErrorStatementSyntax(Me.Kind, newErrors, GetAnnotations, _errorKeyword, _errorNumber)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ErrorStatementSyntax(Me.Kind, GetDiagnostics, annotations, _errorKeyword, _errorNumber)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitErrorStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an OnError Goto statement.
    ''' </summary>
    Friend NotInheritable Class OnErrorGoToStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _onKeyword as KeywordSyntax
        Friend ReadOnly _errorKeyword as KeywordSyntax
        Friend ReadOnly _goToKeyword as KeywordSyntax
        Friend ReadOnly _minus as PunctuationSyntax
        Friend ReadOnly _label as LabelSyntax

        Friend Sub New(ByVal kind As SyntaxKind, onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, goToKeyword As InternalSyntax.KeywordSyntax, minus As InternalSyntax.PunctuationSyntax, label As LabelSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            If minus IsNot Nothing Then
                AdjustFlagsAndWidth(minus)
                Me._minus = minus
            End If
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, goToKeyword As InternalSyntax.KeywordSyntax, minus As InternalSyntax.PunctuationSyntax, label As LabelSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            If minus IsNot Nothing Then
                AdjustFlagsAndWidth(minus)
                Me._minus = minus
            End If
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, goToKeyword As InternalSyntax.KeywordSyntax, minus As InternalSyntax.PunctuationSyntax, label As LabelSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            If minus IsNot Nothing Then
                AdjustFlagsAndWidth(minus)
                Me._minus = minus
            End If
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _onKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _onKeyword isnot Nothing 
             AdjustFlagsAndWidth(_onKeyword)
             Me._onKeyword = _onKeyword
          End If
          Dim _errorKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _errorKeyword isnot Nothing 
             AdjustFlagsAndWidth(_errorKeyword)
             Me._errorKeyword = _errorKeyword
          End If
          Dim _goToKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _goToKeyword isnot Nothing 
             AdjustFlagsAndWidth(_goToKeyword)
             Me._goToKeyword = _goToKeyword
          End If
          Dim _minus = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _minus isnot Nothing 
             AdjustFlagsAndWidth(_minus)
             Me._minus = _minus
          End If
          Dim _label = DirectCast(reader.ReadValue(), LabelSyntax)
          If _label isnot Nothing 
             AdjustFlagsAndWidth(_label)
             Me._label = _label
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New OnErrorGoToStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._onKeyword)
          writer.WriteValue(Me._errorKeyword)
          writer.WriteValue(Me._goToKeyword)
          writer.WriteValue(Me._minus)
          writer.WriteValue(Me._label)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(OnErrorGoToStatementSyntax), Function(r) New OnErrorGoToStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OnErrorGoToStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "On" keyword
        ''' </summary>
        Friend  ReadOnly Property OnKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._onKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Error" keyword.
        ''' </summary>
        Friend  ReadOnly Property ErrorKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._errorKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "GoTo" keyword
        ''' </summary>
        Friend  ReadOnly Property GoToKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._goToKeyword
            End Get
        End Property

        ''' <summary>
        ''' An optional minus for On Error Goto -1
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Minus As InternalSyntax.PunctuationSyntax
            Get
                Return Me._minus
            End Get
        End Property

        ''' <summary>
        ''' The name of the label. If the label is a line number, 0 or -1, wraps an
        ''' IntegerLiteralToken that is the line number, otherwise, wraps an Identifier.
        ''' </summary>
        Friend  ReadOnly Property Label As InternalSyntax.LabelSyntax
            Get
                Return Me._label
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._onKeyword
                Case 1
                    Return Me._errorKeyword
                Case 2
                    Return Me._goToKeyword
                Case 3
                    Return Me._minus
                Case 4
                    Return Me._label
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OnErrorGoToStatementSyntax(Me.Kind, newErrors, GetAnnotations, _onKeyword, _errorKeyword, _goToKeyword, _minus, _label)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OnErrorGoToStatementSyntax(Me.Kind, GetDiagnostics, annotations, _onKeyword, _errorKeyword, _goToKeyword, _minus, _label)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOnErrorGoToStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an OnError Resume Next statement.
    ''' </summary>
    Friend NotInheritable Class OnErrorResumeNextStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _onKeyword as KeywordSyntax
        Friend ReadOnly _errorKeyword as KeywordSyntax
        Friend ReadOnly _resumeKeyword as KeywordSyntax
        Friend ReadOnly _nextKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, resumeKeyword As InternalSyntax.KeywordSyntax, nextKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, resumeKeyword As InternalSyntax.KeywordSyntax, nextKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, resumeKeyword As InternalSyntax.KeywordSyntax, nextKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _onKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _onKeyword isnot Nothing 
             AdjustFlagsAndWidth(_onKeyword)
             Me._onKeyword = _onKeyword
          End If
          Dim _errorKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _errorKeyword isnot Nothing 
             AdjustFlagsAndWidth(_errorKeyword)
             Me._errorKeyword = _errorKeyword
          End If
          Dim _resumeKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _resumeKeyword isnot Nothing 
             AdjustFlagsAndWidth(_resumeKeyword)
             Me._resumeKeyword = _resumeKeyword
          End If
          Dim _nextKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _nextKeyword isnot Nothing 
             AdjustFlagsAndWidth(_nextKeyword)
             Me._nextKeyword = _nextKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New OnErrorResumeNextStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._onKeyword)
          writer.WriteValue(Me._errorKeyword)
          writer.WriteValue(Me._resumeKeyword)
          writer.WriteValue(Me._nextKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(OnErrorResumeNextStatementSyntax), Function(r) New OnErrorResumeNextStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OnErrorResumeNextStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "On" keyword
        ''' </summary>
        Friend  ReadOnly Property OnKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._onKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Error" keyword.
        ''' </summary>
        Friend  ReadOnly Property ErrorKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._errorKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Resume" keyword.
        ''' </summary>
        Friend  ReadOnly Property ResumeKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._resumeKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Next"
        ''' </summary>
        Friend  ReadOnly Property NextKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._nextKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._onKeyword
                Case 1
                    Return Me._errorKeyword
                Case 2
                    Return Me._resumeKeyword
                Case 3
                    Return Me._nextKeyword
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OnErrorResumeNextStatementSyntax(Me.Kind, newErrors, GetAnnotations, _onKeyword, _errorKeyword, _resumeKeyword, _nextKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OnErrorResumeNextStatementSyntax(Me.Kind, GetDiagnostics, annotations, _onKeyword, _errorKeyword, _resumeKeyword, _nextKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOnErrorResumeNextStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Resume" statement. The Kind property can be used to determine if
    ''' this is a "Resume", "Resume Next" or "Resume label" statement.
    ''' </summary>
    Friend NotInheritable Class ResumeStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _resumeKeyword as KeywordSyntax
        Friend ReadOnly _label as LabelSyntax

        Friend Sub New(ByVal kind As SyntaxKind, resumeKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            If label IsNot Nothing Then
                AdjustFlagsAndWidth(label)
                Me._label = label
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, resumeKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            If label IsNot Nothing Then
                AdjustFlagsAndWidth(label)
                Me._label = label
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), resumeKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            If label IsNot Nothing Then
                AdjustFlagsAndWidth(label)
                Me._label = label
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _resumeKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _resumeKeyword isnot Nothing 
             AdjustFlagsAndWidth(_resumeKeyword)
             Me._resumeKeyword = _resumeKeyword
          End If
          Dim _label = DirectCast(reader.ReadValue(), LabelSyntax)
          If _label isnot Nothing 
             AdjustFlagsAndWidth(_label)
             Me._label = _label
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ResumeStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._resumeKeyword)
          writer.WriteValue(Me._label)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ResumeStatementSyntax), Function(r) New ResumeStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ResumeStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Resume" keyword.
        ''' </summary>
        Friend  ReadOnly Property ResumeKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._resumeKeyword
            End Get
        End Property

        ''' <summary>
        ''' The label. The value of this depends on the Kind. If Kind=Resume, returns
        ''' Nothing. If Kind=ResumeNext, wraps the keyword "Next", If Kind=ResumeLabel,
        ''' wraps an Identifier or IntegerLiteralToken with the label or line number.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Label As InternalSyntax.LabelSyntax
            Get
                Return Me._label
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._resumeKeyword
                Case 1
                    Return Me._label
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ResumeStatementSyntax(Me.Kind, newErrors, GetAnnotations, _resumeKeyword, _label)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ResumeStatementSyntax(Me.Kind, GetDiagnostics, annotations, _resumeKeyword, _label)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitResumeStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Select Case block, including the Select Case that begins it, the
    ''' contains Case blocks and the End Select.
    ''' </summary>
    Friend NotInheritable Class SelectBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _selectStatement as SelectStatementSyntax
        Friend ReadOnly _caseBlocks as GreenNode
        Friend ReadOnly _endSelectStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, selectStatement As SelectStatementSyntax, caseBlocks As GreenNode, endSelectStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(selectStatement)
            Me._selectStatement = selectStatement
            If caseBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(caseBlocks)
                Me._caseBlocks = caseBlocks
            End If
            AdjustFlagsAndWidth(endSelectStatement)
            Me._endSelectStatement = endSelectStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, selectStatement As SelectStatementSyntax, caseBlocks As GreenNode, endSelectStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(selectStatement)
            Me._selectStatement = selectStatement
            If caseBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(caseBlocks)
                Me._caseBlocks = caseBlocks
            End If
            AdjustFlagsAndWidth(endSelectStatement)
            Me._endSelectStatement = endSelectStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), selectStatement As SelectStatementSyntax, caseBlocks As GreenNode, endSelectStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(selectStatement)
            Me._selectStatement = selectStatement
            If caseBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(caseBlocks)
                Me._caseBlocks = caseBlocks
            End If
            AdjustFlagsAndWidth(endSelectStatement)
            Me._endSelectStatement = endSelectStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _selectStatement = DirectCast(reader.ReadValue(), SelectStatementSyntax)
          If _selectStatement isnot Nothing 
             AdjustFlagsAndWidth(_selectStatement)
             Me._selectStatement = _selectStatement
          End If
          Dim _caseBlocks = DirectCast(reader.ReadValue(), GreenNode)
          If _caseBlocks isnot Nothing 
             AdjustFlagsAndWidth(_caseBlocks)
             Me._caseBlocks = _caseBlocks
          End If
          Dim _endSelectStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endSelectStatement isnot Nothing 
             AdjustFlagsAndWidth(_endSelectStatement)
             Me._endSelectStatement = _endSelectStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SelectBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._selectStatement)
          writer.WriteValue(Me._caseBlocks)
          writer.WriteValue(Me._endSelectStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SelectBlockSyntax), Function(r) New SelectBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SelectBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The Select Case statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property SelectStatement As InternalSyntax.SelectStatementSyntax
            Get
                Return Me._selectStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of the contained Case blocks.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property CaseBlocks As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of CaseBlockSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of CaseBlockSyntax)(Me._caseBlocks)
            End Get
        End Property

        ''' <summary>
        ''' The End Select statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property EndSelectStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endSelectStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._selectStatement
                Case 1
                    Return Me._caseBlocks
                Case 2
                    Return Me._endSelectStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SelectBlockSyntax(Me.Kind, newErrors, GetAnnotations, _selectStatement, _caseBlocks, _endSelectStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SelectBlockSyntax(Me.Kind, GetDiagnostics, annotations, _selectStatement, _caseBlocks, _endSelectStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSelectBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Select Case statement. This statement always occurs as the Begin
    ''' of a SelectBlock.
    ''' </summary>
    Friend NotInheritable Class SelectStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _selectKeyword as KeywordSyntax
        Friend ReadOnly _caseKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, selectKeyword As InternalSyntax.KeywordSyntax, caseKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(selectKeyword)
            Me._selectKeyword = selectKeyword
            If caseKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(caseKeyword)
                Me._caseKeyword = caseKeyword
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, selectKeyword As InternalSyntax.KeywordSyntax, caseKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(selectKeyword)
            Me._selectKeyword = selectKeyword
            If caseKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(caseKeyword)
                Me._caseKeyword = caseKeyword
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), selectKeyword As InternalSyntax.KeywordSyntax, caseKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(selectKeyword)
            Me._selectKeyword = selectKeyword
            If caseKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(caseKeyword)
                Me._caseKeyword = caseKeyword
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _selectKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _selectKeyword isnot Nothing 
             AdjustFlagsAndWidth(_selectKeyword)
             Me._selectKeyword = _selectKeyword
          End If
          Dim _caseKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _caseKeyword isnot Nothing 
             AdjustFlagsAndWidth(_caseKeyword)
             Me._caseKeyword = _caseKeyword
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SelectStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._selectKeyword)
          writer.WriteValue(Me._caseKeyword)
          writer.WriteValue(Me._expression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SelectStatementSyntax), Function(r) New SelectStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SelectStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Select" keyword.
        ''' </summary>
        Friend  ReadOnly Property SelectKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._selectKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Case" keyword, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property CaseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._caseKeyword
            End Get
        End Property

        ''' <summary>
        ''' The value that branching is based on.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._selectKeyword
                Case 1
                    Return Me._caseKeyword
                Case 2
                    Return Me._expression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SelectStatementSyntax(Me.Kind, newErrors, GetAnnotations, _selectKeyword, _caseKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SelectStatementSyntax(Me.Kind, GetDiagnostics, annotations, _selectKeyword, _caseKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSelectStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a case statement and its subsequent block.
    ''' </summary>
    Friend NotInheritable Class CaseBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _caseStatement as CaseStatementSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, caseStatement As CaseStatementSyntax, statements As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(caseStatement)
            Me._caseStatement = caseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, caseStatement As CaseStatementSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(caseStatement)
            Me._caseStatement = caseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), caseStatement As CaseStatementSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(caseStatement)
            Me._caseStatement = caseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _caseStatement = DirectCast(reader.ReadValue(), CaseStatementSyntax)
          If _caseStatement isnot Nothing 
             AdjustFlagsAndWidth(_caseStatement)
             Me._caseStatement = _caseStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New CaseBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._caseStatement)
          writer.WriteValue(Me._statements)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(CaseBlockSyntax), Function(r) New CaseBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CaseBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The statement that begins the case block.
        ''' </summary>
        Friend  ReadOnly Property CaseStatement As InternalSyntax.CaseStatementSyntax
            Get
                Return Me._caseStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the case block. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._caseStatement
                Case 1
                    Return Me._statements
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CaseBlockSyntax(Me.Kind, newErrors, GetAnnotations, _caseStatement, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CaseBlockSyntax(Me.Kind, GetDiagnostics, annotations, _caseStatement, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCaseBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Case or Case Else statement. This statement is always the Begin of
    ''' a CaseBlock. If this is a Case Else statement, the Kind=CaseElse, otherwise the
    ''' Kind=Case.
    ''' </summary>
    Friend NotInheritable Class CaseStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _caseKeyword as KeywordSyntax
        Friend ReadOnly _cases as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, caseKeyword As InternalSyntax.KeywordSyntax, cases As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(caseKeyword)
            Me._caseKeyword = caseKeyword
            If cases IsNot Nothing Then
                AdjustFlagsAndWidth(cases)
                Me._cases = cases
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, caseKeyword As InternalSyntax.KeywordSyntax, cases As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(caseKeyword)
            Me._caseKeyword = caseKeyword
            If cases IsNot Nothing Then
                AdjustFlagsAndWidth(cases)
                Me._cases = cases
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), caseKeyword As InternalSyntax.KeywordSyntax, cases As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(caseKeyword)
            Me._caseKeyword = caseKeyword
            If cases IsNot Nothing Then
                AdjustFlagsAndWidth(cases)
                Me._cases = cases
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _caseKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _caseKeyword isnot Nothing 
             AdjustFlagsAndWidth(_caseKeyword)
             Me._caseKeyword = _caseKeyword
          End If
          Dim _cases = DirectCast(reader.ReadValue(), GreenNode)
          If _cases isnot Nothing 
             AdjustFlagsAndWidth(_cases)
             Me._cases = _cases
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New CaseStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._caseKeyword)
          writer.WriteValue(Me._cases)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(CaseStatementSyntax), Function(r) New CaseStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CaseStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Case" keyword
        ''' </summary>
        Friend  ReadOnly Property CaseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._caseKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of clauses associated with this Case. If Kind=CaseElse, then this list
        ''' has exactly one child, which is a ElseCaseClause.
        ''' </summary>
        Friend  ReadOnly Property Cases As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of CaseClauseSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of CaseClauseSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of CaseClauseSyntax)(Me._cases))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._caseKeyword
                Case 1
                    Return Me._cases
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CaseStatementSyntax(Me.Kind, newErrors, GetAnnotations, _caseKeyword, _cases)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CaseStatementSyntax(Me.Kind, GetDiagnostics, annotations, _caseKeyword, _cases)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCaseStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single clause in a case statement. An abstract node that is the
    ''' parent of different kinds of Case clauses.
    ''' </summary>
    Friend MustInherit Class CaseClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' The "Else" part in a Case Else statement.
    ''' </summary>
    Friend NotInheritable Class ElseCaseClauseSyntax
        Inherits CaseClauseSyntax

        Friend ReadOnly _elseKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _elseKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _elseKeyword isnot Nothing 
             AdjustFlagsAndWidth(_elseKeyword)
             Me._elseKeyword = _elseKeyword
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ElseCaseClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._elseKeyword)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ElseCaseClauseSyntax), Function(r) New ElseCaseClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ElseCaseClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Else" keyword.
        ''' </summary>
        Friend  ReadOnly Property ElseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._elseKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._elseKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ElseCaseClauseSyntax(Me.Kind, newErrors, GetAnnotations, _elseKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ElseCaseClauseSyntax(Me.Kind, GetDiagnostics, annotations, _elseKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitElseCaseClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single value in a Case.
    ''' </summary>
    Friend NotInheritable Class SimpleCaseClauseSyntax
        Inherits CaseClauseSyntax

        Friend ReadOnly _value as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, value As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, value As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), value As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _value = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _value isnot Nothing 
             AdjustFlagsAndWidth(_value)
             Me._value = _value
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SimpleCaseClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._value)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SimpleCaseClauseSyntax), Function(r) New SimpleCaseClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SimpleCaseClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The expression that denotes the value being tested against.
        ''' </summary>
        Friend  ReadOnly Property Value As InternalSyntax.ExpressionSyntax
            Get
                Return Me._value
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._value
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SimpleCaseClauseSyntax(Me.Kind, newErrors, GetAnnotations, _value)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SimpleCaseClauseSyntax(Me.Kind, GetDiagnostics, annotations, _value)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSimpleCaseClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a range "expression To expression" in a Case.
    ''' </summary>
    Friend NotInheritable Class RangeCaseClauseSyntax
        Inherits CaseClauseSyntax

        Friend ReadOnly _lowerBound as ExpressionSyntax
        Friend ReadOnly _toKeyword as KeywordSyntax
        Friend ReadOnly _upperBound as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(lowerBound)
            Me._lowerBound = lowerBound
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(upperBound)
            Me._upperBound = upperBound

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lowerBound)
            Me._lowerBound = lowerBound
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(upperBound)
            Me._upperBound = upperBound

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(lowerBound)
            Me._lowerBound = lowerBound
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(upperBound)
            Me._upperBound = upperBound

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _lowerBound = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _lowerBound isnot Nothing 
             AdjustFlagsAndWidth(_lowerBound)
             Me._lowerBound = _lowerBound
          End If
          Dim _toKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _toKeyword isnot Nothing 
             AdjustFlagsAndWidth(_toKeyword)
             Me._toKeyword = _toKeyword
          End If
          Dim _upperBound = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _upperBound isnot Nothing 
             AdjustFlagsAndWidth(_upperBound)
             Me._upperBound = _upperBound
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New RangeCaseClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._lowerBound)
          writer.WriteValue(Me._toKeyword)
          writer.WriteValue(Me._upperBound)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(RangeCaseClauseSyntax), Function(r) New RangeCaseClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.RangeCaseClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The lower bound of the range.
        ''' </summary>
        Friend  ReadOnly Property LowerBound As InternalSyntax.ExpressionSyntax
            Get
                Return Me._lowerBound
            End Get
        End Property

        ''' <summary>
        ''' The "To" keyword
        ''' </summary>
        Friend  ReadOnly Property ToKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._toKeyword
            End Get
        End Property

        ''' <summary>
        ''' The upper bound of the range.
        ''' </summary>
        Friend  ReadOnly Property UpperBound As InternalSyntax.ExpressionSyntax
            Get
                Return Me._upperBound
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lowerBound
                Case 1
                    Return Me._toKeyword
                Case 2
                    Return Me._upperBound
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new RangeCaseClauseSyntax(Me.Kind, newErrors, GetAnnotations, _lowerBound, _toKeyword, _upperBound)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new RangeCaseClauseSyntax(Me.Kind, GetDiagnostics, annotations, _lowerBound, _toKeyword, _upperBound)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitRangeCaseClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a relation clause in a Case statement, such as "Is &gt; expression".
    ''' </summary>
    Friend NotInheritable Class RelationalCaseClauseSyntax
        Inherits CaseClauseSyntax

        Friend ReadOnly _isKeyword as KeywordSyntax
        Friend ReadOnly _operatorToken as PunctuationSyntax
        Friend ReadOnly _value as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, isKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            If isKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(isKeyword)
                Me._isKeyword = isKeyword
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, isKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            If isKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(isKeyword)
                Me._isKeyword = isKeyword
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), isKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            If isKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(isKeyword)
                Me._isKeyword = isKeyword
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _isKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _isKeyword isnot Nothing 
             AdjustFlagsAndWidth(_isKeyword)
             Me._isKeyword = _isKeyword
          End If
          Dim _operatorToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _operatorToken isnot Nothing 
             AdjustFlagsAndWidth(_operatorToken)
             Me._operatorToken = _operatorToken
          End If
          Dim _value = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _value isnot Nothing 
             AdjustFlagsAndWidth(_value)
             Me._value = _value
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New RelationalCaseClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._isKeyword)
          writer.WriteValue(Me._operatorToken)
          writer.WriteValue(Me._value)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(RelationalCaseClauseSyntax), Function(r) New RelationalCaseClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.RelationalCaseClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Is" keyword, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property IsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._isKeyword
            End Get
        End Property

        ''' <summary>
        ''' The operator in the relational clause. One of "=", "&lt;", "&gt;", "&lt;=" or
        ''' "&gt;=".
        ''' </summary>
        Friend  ReadOnly Property OperatorToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The expression that denotes the value being tested against.
        ''' </summary>
        Friend  ReadOnly Property Value As InternalSyntax.ExpressionSyntax
            Get
                Return Me._value
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._isKeyword
                Case 1
                    Return Me._operatorToken
                Case 2
                    Return Me._value
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new RelationalCaseClauseSyntax(Me.Kind, newErrors, GetAnnotations, _isKeyword, _operatorToken, _value)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new RelationalCaseClauseSyntax(Me.Kind, GetDiagnostics, annotations, _isKeyword, _operatorToken, _value)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitRelationalCaseClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "SyncLock" statement. This statement always occurs as the Begin
    ''' of a SyncLockBlock.
    ''' </summary>
    Friend NotInheritable Class SyncLockStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _syncLockKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, syncLockKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(syncLockKeyword)
            Me._syncLockKeyword = syncLockKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, syncLockKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(syncLockKeyword)
            Me._syncLockKeyword = syncLockKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), syncLockKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(syncLockKeyword)
            Me._syncLockKeyword = syncLockKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _syncLockKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _syncLockKeyword isnot Nothing 
             AdjustFlagsAndWidth(_syncLockKeyword)
             Me._syncLockKeyword = _syncLockKeyword
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SyncLockStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._syncLockKeyword)
          writer.WriteValue(Me._expression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SyncLockStatementSyntax), Function(r) New SyncLockStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SyncLockStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "SyncLock" keyword.
        ''' </summary>
        Friend  ReadOnly Property SyncLockKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._syncLockKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression being synchronized on.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._syncLockKeyword
                Case 1
                    Return Me._expression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SyncLockStatementSyntax(Me.Kind, newErrors, GetAnnotations, _syncLockKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SyncLockStatementSyntax(Me.Kind, GetDiagnostics, annotations, _syncLockKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSyncLockStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Do-Loop block. The Kind property can be used to determine if this
    ''' is a Do While, Do Until, Do Loop While, Do Loop Until, or infinite Do Loop.
    ''' </summary>
    Friend NotInheritable Class DoLoopBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _doStatement as DoStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _loopStatement as LoopStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, doStatement As DoStatementSyntax, statements As GreenNode, loopStatement As LoopStatementSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(doStatement)
            Me._doStatement = doStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(loopStatement)
            Me._loopStatement = loopStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, doStatement As DoStatementSyntax, statements As GreenNode, loopStatement As LoopStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(doStatement)
            Me._doStatement = doStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(loopStatement)
            Me._loopStatement = loopStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), doStatement As DoStatementSyntax, statements As GreenNode, loopStatement As LoopStatementSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(doStatement)
            Me._doStatement = doStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(loopStatement)
            Me._loopStatement = loopStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _doStatement = DirectCast(reader.ReadValue(), DoStatementSyntax)
          If _doStatement isnot Nothing 
             AdjustFlagsAndWidth(_doStatement)
             Me._doStatement = _doStatement
          End If
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
          Dim _loopStatement = DirectCast(reader.ReadValue(), LoopStatementSyntax)
          If _loopStatement isnot Nothing 
             AdjustFlagsAndWidth(_loopStatement)
             Me._loopStatement = _loopStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New DoLoopBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._doStatement)
          writer.WriteValue(Me._statements)
          writer.WriteValue(Me._loopStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(DoLoopBlockSyntax), Function(r) New DoLoopBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.DoLoopBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The Do statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property DoStatement As InternalSyntax.DoStatementSyntax
            Get
                Return Me._doStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the block statement. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The Loop statement that ends the block.
        ''' </summary>
        Friend  ReadOnly Property LoopStatement As InternalSyntax.LoopStatementSyntax
            Get
                Return Me._loopStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._doStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._loopStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new DoLoopBlockSyntax(Me.Kind, newErrors, GetAnnotations, _doStatement, _statements, _loopStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new DoLoopBlockSyntax(Me.Kind, GetDiagnostics, annotations, _doStatement, _statements, _loopStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitDoLoopBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' The Do statement that begins a Do-Loop block.
    ''' </summary>
    Friend NotInheritable Class DoStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _doKeyword as KeywordSyntax
        Friend ReadOnly _whileOrUntilClause as WhileOrUntilClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, doKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(doKeyword)
            Me._doKeyword = doKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, doKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(doKeyword)
            Me._doKeyword = doKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), doKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(doKeyword)
            Me._doKeyword = doKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _doKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _doKeyword isnot Nothing 
             AdjustFlagsAndWidth(_doKeyword)
             Me._doKeyword = _doKeyword
          End If
          Dim _whileOrUntilClause = DirectCast(reader.ReadValue(), WhileOrUntilClauseSyntax)
          If _whileOrUntilClause isnot Nothing 
             AdjustFlagsAndWidth(_whileOrUntilClause)
             Me._whileOrUntilClause = _whileOrUntilClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New DoStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._doKeyword)
          writer.WriteValue(Me._whileOrUntilClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(DoStatementSyntax), Function(r) New DoStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.DoStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Do" keyword.
        ''' </summary>
        Friend  ReadOnly Property DoKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._doKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "While expression" or "Until expression" clause of the Do statement, if
        ''' present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property WhileOrUntilClause As InternalSyntax.WhileOrUntilClauseSyntax
            Get
                Return Me._whileOrUntilClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._doKeyword
                Case 1
                    Return Me._whileOrUntilClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new DoStatementSyntax(Me.Kind, newErrors, GetAnnotations, _doKeyword, _whileOrUntilClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new DoStatementSyntax(Me.Kind, GetDiagnostics, annotations, _doKeyword, _whileOrUntilClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitDoStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' The Loop statement that begins a Do-Loop block.
    ''' </summary>
    Friend NotInheritable Class LoopStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _loopKeyword as KeywordSyntax
        Friend ReadOnly _whileOrUntilClause as WhileOrUntilClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, loopKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(loopKeyword)
            Me._loopKeyword = loopKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, loopKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(loopKeyword)
            Me._loopKeyword = loopKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), loopKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(loopKeyword)
            Me._loopKeyword = loopKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _loopKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _loopKeyword isnot Nothing 
             AdjustFlagsAndWidth(_loopKeyword)
             Me._loopKeyword = _loopKeyword
          End If
          Dim _whileOrUntilClause = DirectCast(reader.ReadValue(), WhileOrUntilClauseSyntax)
          If _whileOrUntilClause isnot Nothing 
             AdjustFlagsAndWidth(_whileOrUntilClause)
             Me._whileOrUntilClause = _whileOrUntilClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New LoopStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._loopKeyword)
          writer.WriteValue(Me._whileOrUntilClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(LoopStatementSyntax), Function(r) New LoopStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LoopStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Loop" keyword.
        ''' </summary>
        Friend  ReadOnly Property LoopKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._loopKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "While expression" or "Until expression" clause of the Loop statement, if
        ''' present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property WhileOrUntilClause As InternalSyntax.WhileOrUntilClauseSyntax
            Get
                Return Me._whileOrUntilClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._loopKeyword
                Case 1
                    Return Me._whileOrUntilClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LoopStatementSyntax(Me.Kind, newErrors, GetAnnotations, _loopKeyword, _whileOrUntilClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LoopStatementSyntax(Me.Kind, GetDiagnostics, annotations, _loopKeyword, _whileOrUntilClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLoopStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "While expression" or "Until expression" in a Do or Loop
    ''' statement. The Kind of the clause can be "WhileClause" or "UntilClause" to
    ''' indicate which kind of clause.
    ''' </summary>
    Friend NotInheritable Class WhileOrUntilClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _whileOrUntilKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, whileOrUntilKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(whileOrUntilKeyword)
            Me._whileOrUntilKeyword = whileOrUntilKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, whileOrUntilKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(whileOrUntilKeyword)
            Me._whileOrUntilKeyword = whileOrUntilKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whileOrUntilKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(whileOrUntilKeyword)
            Me._whileOrUntilKeyword = whileOrUntilKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _whileOrUntilKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _whileOrUntilKeyword isnot Nothing 
             AdjustFlagsAndWidth(_whileOrUntilKeyword)
             Me._whileOrUntilKeyword = _whileOrUntilKeyword
          End If
          Dim _condition = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _condition isnot Nothing 
             AdjustFlagsAndWidth(_condition)
             Me._condition = _condition
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New WhileOrUntilClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._whileOrUntilKeyword)
          writer.WriteValue(Me._condition)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(WhileOrUntilClauseSyntax), Function(r) New WhileOrUntilClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WhileOrUntilClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "While" or "Until" keyword.
        ''' </summary>
        Friend  ReadOnly Property WhileOrUntilKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._whileOrUntilKeyword
            End Get
        End Property

        ''' <summary>
        ''' The boolean expression after the While or Until.
        ''' </summary>
        Friend  ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._whileOrUntilKeyword
                Case 1
                    Return Me._condition
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WhileOrUntilClauseSyntax(Me.Kind, newErrors, GetAnnotations, _whileOrUntilKeyword, _condition)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WhileOrUntilClauseSyntax(Me.Kind, GetDiagnostics, annotations, _whileOrUntilKeyword, _condition)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWhileOrUntilClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' The While statement that begins a While...End While block. This statement
    ''' always occurs as the Begin of a WhileBlock.
    ''' </summary>
    Friend NotInheritable Class WhileStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _whileKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, whileKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(whileKeyword)
            Me._whileKeyword = whileKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, whileKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(whileKeyword)
            Me._whileKeyword = whileKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whileKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(whileKeyword)
            Me._whileKeyword = whileKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _whileKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _whileKeyword isnot Nothing 
             AdjustFlagsAndWidth(_whileKeyword)
             Me._whileKeyword = _whileKeyword
          End If
          Dim _condition = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _condition isnot Nothing 
             AdjustFlagsAndWidth(_condition)
             Me._condition = _condition
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New WhileStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._whileKeyword)
          writer.WriteValue(Me._condition)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(WhileStatementSyntax), Function(r) New WhileStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WhileStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "While" keyword.
        ''' </summary>
        Friend  ReadOnly Property WhileKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._whileKeyword
            End Get
        End Property

        ''' <summary>
        ''' The boolean expression that controls the While loop.
        ''' </summary>
        Friend  ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._whileKeyword
                Case 1
                    Return Me._condition
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WhileStatementSyntax(Me.Kind, newErrors, GetAnnotations, _whileKeyword, _condition)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WhileStatementSyntax(Me.Kind, GetDiagnostics, annotations, _whileKeyword, _condition)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWhileStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a For or For Each block.
    ''' </summary>
    Friend MustInherit Class ForOrForEachBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _nextStatement as NextStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If nextStatement IsNot Nothing Then
                AdjustFlagsAndWidth(nextStatement)
                Me._nextStatement = nextStatement
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, statements As GreenNode, nextStatement As NextStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If nextStatement IsNot Nothing Then
                AdjustFlagsAndWidth(nextStatement)
                Me._nextStatement = nextStatement
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind, errors, annotations)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If nextStatement IsNot Nothing Then
                AdjustFlagsAndWidth(nextStatement)
                Me._nextStatement = nextStatement
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
          Dim _nextStatement = DirectCast(reader.ReadValue(), NextStatementSyntax)
          If _nextStatement isnot Nothing 
             AdjustFlagsAndWidth(_nextStatement)
             Me._nextStatement = _nextStatement
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._statements)
          writer.WriteValue(Me._nextStatement)
        End Sub

        ''' <summary>
        ''' The statements contained in the For or For Each loop. This might be an empty
        ''' list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The Next statement that ends the block. If two For or For Each statements are
        ''' ended by a single Next statement, the inner For will not have a Next statement.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property NextStatement As InternalSyntax.NextStatementSyntax
            Get
                Return Me._nextStatement
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents a For block, including the introducing statement, the body and the
    ''' "Next" (which can be omitted if a containing For has a Next with multiple
    ''' variables).
    ''' </summary>
    Friend NotInheritable Class ForBlockSyntax
        Inherits ForOrForEachBlockSyntax

        Friend ReadOnly _forStatement as ForStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, forStatement As ForStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind, statements, nextStatement)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(forStatement)
            Me._forStatement = forStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, forStatement As ForStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements, nextStatement)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(forStatement)
            Me._forStatement = forStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forStatement As ForStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind, errors, annotations, statements, nextStatement)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(forStatement)
            Me._forStatement = forStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _forStatement = DirectCast(reader.ReadValue(), ForStatementSyntax)
          If _forStatement isnot Nothing 
             AdjustFlagsAndWidth(_forStatement)
             Me._forStatement = _forStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ForBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._forStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ForBlockSyntax), Function(r) New ForBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ForBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The For statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property ForStatement As InternalSyntax.ForStatementSyntax
            Get
                Return Me._forStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._forStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._nextStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ForBlockSyntax(Me.Kind, newErrors, GetAnnotations, _forStatement, _statements, _nextStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ForBlockSyntax(Me.Kind, GetDiagnostics, annotations, _forStatement, _statements, _nextStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitForBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a For Each block, including the introducing statement, the body and
    ''' the "Next" (which can be omitted if a containing For has a Next with multiple
    ''' variables).
    ''' </summary>
    Friend NotInheritable Class ForEachBlockSyntax
        Inherits ForOrForEachBlockSyntax

        Friend ReadOnly _forEachStatement as ForEachStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, forEachStatement As ForEachStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind, statements, nextStatement)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(forEachStatement)
            Me._forEachStatement = forEachStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, forEachStatement As ForEachStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements, nextStatement)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(forEachStatement)
            Me._forEachStatement = forEachStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forEachStatement As ForEachStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind, errors, annotations, statements, nextStatement)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(forEachStatement)
            Me._forEachStatement = forEachStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _forEachStatement = DirectCast(reader.ReadValue(), ForEachStatementSyntax)
          If _forEachStatement isnot Nothing 
             AdjustFlagsAndWidth(_forEachStatement)
             Me._forEachStatement = _forEachStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ForEachBlockSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._forEachStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ForEachBlockSyntax), Function(r) New ForEachBlockSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ForEachBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The For Each statement that begins the block.
        ''' </summary>
        Friend  ReadOnly Property ForEachStatement As InternalSyntax.ForEachStatementSyntax
            Get
                Return Me._forEachStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._forEachStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._nextStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ForEachBlockSyntax(Me.Kind, newErrors, GetAnnotations, _forEachStatement, _statements, _nextStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ForEachBlockSyntax(Me.Kind, GetDiagnostics, annotations, _forEachStatement, _statements, _nextStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitForEachBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a For or For Each statement.
    ''' </summary>
    Friend MustInherit Class ForOrForEachStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _forKeyword as KeywordSyntax
        Friend ReadOnly _controlVariable as VisualBasicSyntaxNode

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode)
            MyBase.New(kind)

            AdjustFlagsAndWidth(forKeyword)
            Me._forKeyword = forKeyword
            AdjustFlagsAndWidth(controlVariable)
            Me._controlVariable = controlVariable

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(forKeyword)
            Me._forKeyword = forKeyword
            AdjustFlagsAndWidth(controlVariable)
            Me._controlVariable = controlVariable

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(forKeyword)
            Me._forKeyword = forKeyword
            AdjustFlagsAndWidth(controlVariable)
            Me._controlVariable = controlVariable

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _forKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _forKeyword isnot Nothing 
             AdjustFlagsAndWidth(_forKeyword)
             Me._forKeyword = _forKeyword
          End If
          Dim _controlVariable = DirectCast(reader.ReadValue(), VisualBasicSyntaxNode)
          If _controlVariable isnot Nothing 
             AdjustFlagsAndWidth(_controlVariable)
             Me._controlVariable = _controlVariable
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._forKeyword)
          writer.WriteValue(Me._controlVariable)
        End Sub

        ''' <summary>
        ''' The "For" keyword.
        ''' </summary>
        Friend  ReadOnly Property ForKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._forKeyword
            End Get
        End Property

        ''' <summary>
        ''' If the For or For Each statement is of a form that does not declare a new loop
        ''' control variable, this is the expression that denotes the loop control
        ''' variable. If this loop is of a form that does declare a new control variable,
        ''' this is a VariableDeclarator that has the variable being declared.
        ''' </summary>
        Friend  ReadOnly Property ControlVariable As InternalSyntax.VisualBasicSyntaxNode
            Get
                Return Me._controlVariable
            End Get
        End Property

    End Class

    ''' <summary>
    ''' The For statement that begins a For-Next block. This statement always occurs as
    ''' the Begin of a ForBlock. Most of the time, the End of that ForBlock is the
    ''' corresponding Next statement. However, multiple nested For statements are ended
    ''' by a single Next statement with multiple variables, then the inner For
    ''' statements will have End set to Nothing, and the Next statement is the End of
    ''' the outermost For statement that is being ended.
    ''' </summary>
    Friend NotInheritable Class ForStatementSyntax
        Inherits ForOrForEachStatementSyntax

        Friend ReadOnly _equalsToken as PunctuationSyntax
        Friend ReadOnly _fromValue as ExpressionSyntax
        Friend ReadOnly _toKeyword as KeywordSyntax
        Friend ReadOnly _toValue as ExpressionSyntax
        Friend ReadOnly _stepClause as ForStepClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, equalsToken As InternalSyntax.PunctuationSyntax, fromValue As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, toValue As ExpressionSyntax, stepClause As ForStepClauseSyntax)
            MyBase.New(kind, forKeyword, controlVariable)
            MyBase._slotCount = 7

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(fromValue)
            Me._fromValue = fromValue
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(toValue)
            Me._toValue = toValue
            If stepClause IsNot Nothing Then
                AdjustFlagsAndWidth(stepClause)
                Me._stepClause = stepClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, equalsToken As InternalSyntax.PunctuationSyntax, fromValue As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, toValue As ExpressionSyntax, stepClause As ForStepClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, forKeyword, controlVariable)
            MyBase._slotCount = 7
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(fromValue)
            Me._fromValue = fromValue
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(toValue)
            Me._toValue = toValue
            If stepClause IsNot Nothing Then
                AdjustFlagsAndWidth(stepClause)
                Me._stepClause = stepClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, equalsToken As InternalSyntax.PunctuationSyntax, fromValue As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, toValue As ExpressionSyntax, stepClause As ForStepClauseSyntax)
            MyBase.New(kind, errors, annotations, forKeyword, controlVariable)
            MyBase._slotCount = 7

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(fromValue)
            Me._fromValue = fromValue
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(toValue)
            Me._toValue = toValue
            If stepClause IsNot Nothing Then
                AdjustFlagsAndWidth(stepClause)
                Me._stepClause = stepClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 7
          Dim _equalsToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _equalsToken isnot Nothing 
             AdjustFlagsAndWidth(_equalsToken)
             Me._equalsToken = _equalsToken
          End If
          Dim _fromValue = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _fromValue isnot Nothing 
             AdjustFlagsAndWidth(_fromValue)
             Me._fromValue = _fromValue
          End If
          Dim _toKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _toKeyword isnot Nothing 
             AdjustFlagsAndWidth(_toKeyword)
             Me._toKeyword = _toKeyword
          End If
          Dim _toValue = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _toValue isnot Nothing 
             AdjustFlagsAndWidth(_toValue)
             Me._toValue = _toValue
          End If
          Dim _stepClause = DirectCast(reader.ReadValue(), ForStepClauseSyntax)
          If _stepClause isnot Nothing 
             AdjustFlagsAndWidth(_stepClause)
             Me._stepClause = _stepClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ForStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._equalsToken)
          writer.WriteValue(Me._fromValue)
          writer.WriteValue(Me._toKeyword)
          writer.WriteValue(Me._toValue)
          writer.WriteValue(Me._stepClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ForStatementSyntax), Function(r) New ForStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ForStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Friend  ReadOnly Property EqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._equalsToken
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the initial value of the iteration.
        ''' </summary>
        Friend  ReadOnly Property FromValue As InternalSyntax.ExpressionSyntax
            Get
                Return Me._fromValue
            End Get
        End Property

        ''' <summary>
        ''' The "To" keyword.
        ''' </summary>
        Friend  ReadOnly Property ToKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._toKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the final value of the iteration.
        ''' </summary>
        Friend  ReadOnly Property ToValue As InternalSyntax.ExpressionSyntax
            Get
                Return Me._toValue
            End Get
        End Property

        ''' <summary>
        ''' The optional Step clause.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property StepClause As InternalSyntax.ForStepClauseSyntax
            Get
                Return Me._stepClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._forKeyword
                Case 1
                    Return Me._controlVariable
                Case 2
                    Return Me._equalsToken
                Case 3
                    Return Me._fromValue
                Case 4
                    Return Me._toKeyword
                Case 5
                    Return Me._toValue
                Case 6
                    Return Me._stepClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ForStatementSyntax(Me.Kind, newErrors, GetAnnotations, _forKeyword, _controlVariable, _equalsToken, _fromValue, _toKeyword, _toValue, _stepClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ForStatementSyntax(Me.Kind, GetDiagnostics, annotations, _forKeyword, _controlVariable, _equalsToken, _fromValue, _toKeyword, _toValue, _stepClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitForStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' The Step clause in a For Statement.
    ''' </summary>
    Friend NotInheritable Class ForStepClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _stepKeyword as KeywordSyntax
        Friend ReadOnly _stepValue as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, stepKeyword As InternalSyntax.KeywordSyntax, stepValue As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(stepKeyword)
            Me._stepKeyword = stepKeyword
            AdjustFlagsAndWidth(stepValue)
            Me._stepValue = stepValue

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, stepKeyword As InternalSyntax.KeywordSyntax, stepValue As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(stepKeyword)
            Me._stepKeyword = stepKeyword
            AdjustFlagsAndWidth(stepValue)
            Me._stepValue = stepValue

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), stepKeyword As InternalSyntax.KeywordSyntax, stepValue As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(stepKeyword)
            Me._stepKeyword = stepKeyword
            AdjustFlagsAndWidth(stepValue)
            Me._stepValue = stepValue

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _stepKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _stepKeyword isnot Nothing 
             AdjustFlagsAndWidth(_stepKeyword)
             Me._stepKeyword = _stepKeyword
          End If
          Dim _stepValue = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _stepValue isnot Nothing 
             AdjustFlagsAndWidth(_stepValue)
             Me._stepValue = _stepValue
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ForStepClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._stepKeyword)
          writer.WriteValue(Me._stepValue)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ForStepClauseSyntax), Function(r) New ForStepClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ForStepClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Step" keyword.
        ''' </summary>
        Friend  ReadOnly Property StepKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._stepKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the step increment.
        ''' </summary>
        Friend  ReadOnly Property StepValue As InternalSyntax.ExpressionSyntax
            Get
                Return Me._stepValue
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._stepKeyword
                Case 1
                    Return Me._stepValue
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ForStepClauseSyntax(Me.Kind, newErrors, GetAnnotations, _stepKeyword, _stepValue)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ForStepClauseSyntax(Me.Kind, GetDiagnostics, annotations, _stepKeyword, _stepValue)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitForStepClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' The For Each statement that begins a For Each-Next block. This statement always
    ''' occurs as the Begin of a ForBlock, and the body of the For Each-Next is the
    ''' Body of that ForBlock. Most of the time, the End of that ForBlock is the
    ''' corresponding Next statement. However, multiple nested For statements are ended
    ''' by a single Next statement with multiple variables, then the inner For
    ''' statements will have End set to Nothing, and the Next statement is the End of
    ''' the outermost For statement that is being ended.
    ''' </summary>
    Friend NotInheritable Class ForEachStatementSyntax
        Inherits ForOrForEachStatementSyntax

        Friend ReadOnly _eachKeyword as KeywordSyntax
        Friend ReadOnly _inKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, eachKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, inKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, forKeyword, controlVariable)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(eachKeyword)
            Me._eachKeyword = eachKeyword
            AdjustFlagsAndWidth(inKeyword)
            Me._inKeyword = inKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, eachKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, inKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, forKeyword, controlVariable)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(eachKeyword)
            Me._eachKeyword = eachKeyword
            AdjustFlagsAndWidth(inKeyword)
            Me._inKeyword = inKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forKeyword As InternalSyntax.KeywordSyntax, eachKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, inKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations, forKeyword, controlVariable)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(eachKeyword)
            Me._eachKeyword = eachKeyword
            AdjustFlagsAndWidth(inKeyword)
            Me._inKeyword = inKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _eachKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _eachKeyword isnot Nothing 
             AdjustFlagsAndWidth(_eachKeyword)
             Me._eachKeyword = _eachKeyword
          End If
          Dim _inKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _inKeyword isnot Nothing 
             AdjustFlagsAndWidth(_inKeyword)
             Me._inKeyword = _inKeyword
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ForEachStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._eachKeyword)
          writer.WriteValue(Me._inKeyword)
          writer.WriteValue(Me._expression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ForEachStatementSyntax), Function(r) New ForEachStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ForEachStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Each" keyword.
        ''' </summary>
        Friend  ReadOnly Property EachKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._eachKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "In" keyword.
        ''' </summary>
        Friend  ReadOnly Property InKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._inKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the collection to iterate over.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._forKeyword
                Case 1
                    Return Me._eachKeyword
                Case 2
                    Return Me._controlVariable
                Case 3
                    Return Me._inKeyword
                Case 4
                    Return Me._expression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ForEachStatementSyntax(Me.Kind, newErrors, GetAnnotations, _forKeyword, _eachKeyword, _controlVariable, _inKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ForEachStatementSyntax(Me.Kind, GetDiagnostics, annotations, _forKeyword, _eachKeyword, _controlVariable, _inKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitForEachStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' The Next statement that ends a For-Next or For Each-Next block. This statement
    ''' always occurs as the End of a ForBlock (with Kind=ForBlock or ForEachBlock),
    ''' and the body of the For-Next is the Body of that ForBlock. The Begin of that
    ''' ForBlock has the corresponding For or For Each statement.
    ''' </summary>
    Friend NotInheritable Class NextStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _nextKeyword as KeywordSyntax
        Friend ReadOnly _controlVariables as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, nextKeyword As InternalSyntax.KeywordSyntax, controlVariables As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword
            If controlVariables IsNot Nothing Then
                AdjustFlagsAndWidth(controlVariables)
                Me._controlVariables = controlVariables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, nextKeyword As InternalSyntax.KeywordSyntax, controlVariables As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword
            If controlVariables IsNot Nothing Then
                AdjustFlagsAndWidth(controlVariables)
                Me._controlVariables = controlVariables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), nextKeyword As InternalSyntax.KeywordSyntax, controlVariables As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword
            If controlVariables IsNot Nothing Then
                AdjustFlagsAndWidth(controlVariables)
                Me._controlVariables = controlVariables
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _nextKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _nextKeyword isnot Nothing 
             AdjustFlagsAndWidth(_nextKeyword)
             Me._nextKeyword = _nextKeyword
          End If
          Dim _controlVariables = DirectCast(reader.ReadValue(), GreenNode)
          If _controlVariables isnot Nothing 
             AdjustFlagsAndWidth(_controlVariables)
             Me._controlVariables = _controlVariables
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New NextStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._nextKeyword)
          writer.WriteValue(Me._controlVariables)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(NextStatementSyntax), Function(r) New NextStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NextStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Next" keyword.
        ''' </summary>
        Friend  ReadOnly Property NextKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._nextKeyword
            End Get
        End Property

        ''' <summary>
        ''' The variables in the Next statement, if present
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property ControlVariables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ExpressionSyntax)(Me._controlVariables))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._nextKeyword
                Case 1
                    Return Me._controlVariables
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NextStatementSyntax(Me.Kind, newErrors, GetAnnotations, _nextKeyword, _controlVariables)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NextStatementSyntax(Me.Kind, GetDiagnostics, annotations, _nextKeyword, _controlVariables)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNextStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' The Using statement that begins a Using block. This statement always occurs as
    ''' the Begin of a UsingBlock, and the body of the Using is the Body of that
    ''' UsingBlock.
    ''' </summary>
    Friend NotInheritable Class UsingStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _usingKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _variables as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, usingKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, variables As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(usingKeyword)
            Me._usingKeyword = usingKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, usingKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, variables As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(usingKeyword)
            Me._usingKeyword = usingKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), usingKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, variables As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(usingKeyword)
            Me._usingKeyword = usingKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _usingKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _usingKeyword isnot Nothing 
             AdjustFlagsAndWidth(_usingKeyword)
             Me._usingKeyword = _usingKeyword
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
          Dim _variables = DirectCast(reader.ReadValue(), GreenNode)
          If _variables isnot Nothing 
             AdjustFlagsAndWidth(_variables)
             Me._variables = _variables
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New UsingStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._usingKeyword)
          writer.WriteValue(Me._expression)
          writer.WriteValue(Me._variables)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(UsingStatementSyntax), Function(r) New UsingStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.UsingStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Using" keyword.
        ''' </summary>
        Friend  ReadOnly Property UsingKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._usingKeyword
            End Get
        End Property

        ''' <summary>
        ''' If the Using statement is of a form that does not declare a new variable, this
        ''' is the expression used in the using. Otherwise, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' If the Using statement is of a form that declares one or more new variables,
        ''' this is the list of variable declarations. Otherwise, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Variables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of VariableDeclaratorSyntax)(Me._variables))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._usingKeyword
                Case 1
                    Return Me._expression
                Case 2
                    Return Me._variables
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new UsingStatementSyntax(Me.Kind, newErrors, GetAnnotations, _usingKeyword, _expression, _variables)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new UsingStatementSyntax(Me.Kind, GetDiagnostics, annotations, _usingKeyword, _expression, _variables)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitUsingStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Throw statement.
    ''' </summary>
    Friend NotInheritable Class ThrowStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _throwKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, throwKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(throwKeyword)
            Me._throwKeyword = throwKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, throwKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(throwKeyword)
            Me._throwKeyword = throwKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), throwKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(throwKeyword)
            Me._throwKeyword = throwKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _throwKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _throwKeyword isnot Nothing 
             AdjustFlagsAndWidth(_throwKeyword)
             Me._throwKeyword = _throwKeyword
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ThrowStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._throwKeyword)
          writer.WriteValue(Me._expression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ThrowStatementSyntax), Function(r) New ThrowStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ThrowStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Throw" keyword
        ''' </summary>
        Friend  ReadOnly Property ThrowKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._throwKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the value being thrown.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._throwKeyword
                Case 1
                    Return Me._expression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ThrowStatementSyntax(Me.Kind, newErrors, GetAnnotations, _throwKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ThrowStatementSyntax(Me.Kind, GetDiagnostics, annotations, _throwKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitThrowStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a simple, compound, or Mid assignment statement. Which one can be
    ''' determined by checking the Kind.
    ''' </summary>
    Friend NotInheritable Class AssignmentStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _left as ExpressionSyntax
        Friend ReadOnly _operatorToken as PunctuationSyntax
        Friend ReadOnly _right as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, left As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, right As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, left As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, right As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), left As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, right As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _left = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _left isnot Nothing 
             AdjustFlagsAndWidth(_left)
             Me._left = _left
          End If
          Dim _operatorToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _operatorToken isnot Nothing 
             AdjustFlagsAndWidth(_operatorToken)
             Me._operatorToken = _operatorToken
          End If
          Dim _right = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _right isnot Nothing 
             AdjustFlagsAndWidth(_right)
             Me._right = _right
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New AssignmentStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._left)
          writer.WriteValue(Me._operatorToken)
          writer.WriteValue(Me._right)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(AssignmentStatementSyntax), Function(r) New AssignmentStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AssignmentStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The target (left hand side) of the assignment.
        ''' </summary>
        Friend  ReadOnly Property Left As InternalSyntax.ExpressionSyntax
            Get
                Return Me._left
            End Get
        End Property

        ''' <summary>
        ''' The operator used in the assignment statement. One of "=", "+=", "-=", "*=",
        ''' "/=", "\=", "^=", "&amp;=", "&lt;&lt;=" or "&gt;&gt;=".
        ''' </summary>
        Friend  ReadOnly Property OperatorToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The source (right hand side) of the assignment.
        ''' </summary>
        Friend  ReadOnly Property Right As InternalSyntax.ExpressionSyntax
            Get
                Return Me._right
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._left
                Case 1
                    Return Me._operatorToken
                Case 2
                    Return Me._right
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AssignmentStatementSyntax(Me.Kind, newErrors, GetAnnotations, _left, _operatorToken, _right)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AssignmentStatementSyntax(Me.Kind, GetDiagnostics, annotations, _left, _operatorToken, _right)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAssignmentStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a left-hand side of a MidAssignment statement.
    ''' </summary>
    Friend NotInheritable Class MidExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _mid as IdentifierTokenSyntax
        Friend ReadOnly _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, mid As InternalSyntax.IdentifierTokenSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(mid)
            Me._mid = mid
            AdjustFlagsAndWidth(argumentList)
            Me._argumentList = argumentList

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, mid As InternalSyntax.IdentifierTokenSyntax, argumentList As ArgumentListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(mid)
            Me._mid = mid
            AdjustFlagsAndWidth(argumentList)
            Me._argumentList = argumentList

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), mid As InternalSyntax.IdentifierTokenSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(mid)
            Me._mid = mid
            AdjustFlagsAndWidth(argumentList)
            Me._argumentList = argumentList

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _mid = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _mid isnot Nothing 
             AdjustFlagsAndWidth(_mid)
             Me._mid = _mid
          End If
          Dim _argumentList = DirectCast(reader.ReadValue(), ArgumentListSyntax)
          If _argumentList isnot Nothing 
             AdjustFlagsAndWidth(_argumentList)
             Me._argumentList = _argumentList
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New MidExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._mid)
          writer.WriteValue(Me._argumentList)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(MidExpressionSyntax), Function(r) New MidExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MidExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Mid" possibly followed by a type character.
        ''' </summary>
        Friend  ReadOnly Property Mid As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._mid
            End Get
        End Property

        ''' <summary>
        ''' The argument list.
        ''' </summary>
        Friend  ReadOnly Property ArgumentList As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._argumentList
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._mid
                Case 1
                    Return Me._argumentList
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MidExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _mid, _argumentList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MidExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _mid, _argumentList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMidExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent an call statement (also known as a invocation statement).
    ''' </summary>
    Friend NotInheritable Class CallStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _callKeyword as KeywordSyntax
        Friend ReadOnly _invocation as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, callKeyword As InternalSyntax.KeywordSyntax, invocation As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(callKeyword)
            Me._callKeyword = callKeyword
            AdjustFlagsAndWidth(invocation)
            Me._invocation = invocation

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, callKeyword As InternalSyntax.KeywordSyntax, invocation As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(callKeyword)
            Me._callKeyword = callKeyword
            AdjustFlagsAndWidth(invocation)
            Me._invocation = invocation

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), callKeyword As InternalSyntax.KeywordSyntax, invocation As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(callKeyword)
            Me._callKeyword = callKeyword
            AdjustFlagsAndWidth(invocation)
            Me._invocation = invocation

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _callKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _callKeyword isnot Nothing 
             AdjustFlagsAndWidth(_callKeyword)
             Me._callKeyword = _callKeyword
          End If
          Dim _invocation = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _invocation isnot Nothing 
             AdjustFlagsAndWidth(_invocation)
             Me._invocation = _invocation
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New CallStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._callKeyword)
          writer.WriteValue(Me._invocation)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(CallStatementSyntax), Function(r) New CallStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CallStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Call" keyword.
        ''' </summary>
        Friend  ReadOnly Property CallKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._callKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the call. This could be an Invocation or a MemberAccess
        ''' (in the case where no parentheses were supplied.)
        ''' </summary>
        Friend  ReadOnly Property Invocation As InternalSyntax.ExpressionSyntax
            Get
                Return Me._invocation
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._callKeyword
                Case 1
                    Return Me._invocation
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CallStatementSyntax(Me.Kind, newErrors, GetAnnotations, _callKeyword, _invocation)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CallStatementSyntax(Me.Kind, GetDiagnostics, annotations, _callKeyword, _invocation)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCallStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an AddHandler or RemoveHandler statement. The Kind property
    ''' determines which one.
    ''' </summary>
    Friend NotInheritable Class AddRemoveHandlerStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _addHandlerOrRemoveHandlerKeyword as KeywordSyntax
        Friend ReadOnly _eventExpression as ExpressionSyntax
        Friend ReadOnly _commaToken as PunctuationSyntax
        Friend ReadOnly _delegateExpression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, addHandlerOrRemoveHandlerKeyword As InternalSyntax.KeywordSyntax, eventExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, delegateExpression As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(addHandlerOrRemoveHandlerKeyword)
            Me._addHandlerOrRemoveHandlerKeyword = addHandlerOrRemoveHandlerKeyword
            AdjustFlagsAndWidth(eventExpression)
            Me._eventExpression = eventExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(delegateExpression)
            Me._delegateExpression = delegateExpression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, addHandlerOrRemoveHandlerKeyword As InternalSyntax.KeywordSyntax, eventExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, delegateExpression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(addHandlerOrRemoveHandlerKeyword)
            Me._addHandlerOrRemoveHandlerKeyword = addHandlerOrRemoveHandlerKeyword
            AdjustFlagsAndWidth(eventExpression)
            Me._eventExpression = eventExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(delegateExpression)
            Me._delegateExpression = delegateExpression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), addHandlerOrRemoveHandlerKeyword As InternalSyntax.KeywordSyntax, eventExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, delegateExpression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(addHandlerOrRemoveHandlerKeyword)
            Me._addHandlerOrRemoveHandlerKeyword = addHandlerOrRemoveHandlerKeyword
            AdjustFlagsAndWidth(eventExpression)
            Me._eventExpression = eventExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(delegateExpression)
            Me._delegateExpression = delegateExpression

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _addHandlerOrRemoveHandlerKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _addHandlerOrRemoveHandlerKeyword isnot Nothing 
             AdjustFlagsAndWidth(_addHandlerOrRemoveHandlerKeyword)
             Me._addHandlerOrRemoveHandlerKeyword = _addHandlerOrRemoveHandlerKeyword
          End If
          Dim _eventExpression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _eventExpression isnot Nothing 
             AdjustFlagsAndWidth(_eventExpression)
             Me._eventExpression = _eventExpression
          End If
          Dim _commaToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _commaToken isnot Nothing 
             AdjustFlagsAndWidth(_commaToken)
             Me._commaToken = _commaToken
          End If
          Dim _delegateExpression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _delegateExpression isnot Nothing 
             AdjustFlagsAndWidth(_delegateExpression)
             Me._delegateExpression = _delegateExpression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New AddRemoveHandlerStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._addHandlerOrRemoveHandlerKeyword)
          writer.WriteValue(Me._eventExpression)
          writer.WriteValue(Me._commaToken)
          writer.WriteValue(Me._delegateExpression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(AddRemoveHandlerStatementSyntax), Function(r) New AddRemoveHandlerStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AddRemoveHandlerStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "AddHandler" or "RemoveHandler" keyword.
        ''' </summary>
        Friend  ReadOnly Property AddHandlerOrRemoveHandlerKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._addHandlerOrRemoveHandlerKeyword
            End Get
        End Property

        ''' <summary>
        ''' The event being accessed.
        ''' </summary>
        Friend  ReadOnly Property EventExpression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._eventExpression
            End Get
        End Property

        ''' <summary>
        ''' The "," token.
        ''' </summary>
        Friend  ReadOnly Property CommaToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._commaToken
            End Get
        End Property

        ''' <summary>
        ''' The delegate being added or removed.
        ''' </summary>
        Friend  ReadOnly Property DelegateExpression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._delegateExpression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._addHandlerOrRemoveHandlerKeyword
                Case 1
                    Return Me._eventExpression
                Case 2
                    Return Me._commaToken
                Case 3
                    Return Me._delegateExpression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AddRemoveHandlerStatementSyntax(Me.Kind, newErrors, GetAnnotations, _addHandlerOrRemoveHandlerKeyword, _eventExpression, _commaToken, _delegateExpression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AddRemoveHandlerStatementSyntax(Me.Kind, GetDiagnostics, annotations, _addHandlerOrRemoveHandlerKeyword, _eventExpression, _commaToken, _delegateExpression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAddRemoveHandlerStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent a RaiseEvent statement.
    ''' </summary>
    Friend NotInheritable Class RaiseEventStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _raiseEventKeyword as KeywordSyntax
        Friend ReadOnly _name as IdentifierNameSyntax
        Friend ReadOnly _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, raiseEventKeyword As InternalSyntax.KeywordSyntax, name As IdentifierNameSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(raiseEventKeyword)
            Me._raiseEventKeyword = raiseEventKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, raiseEventKeyword As InternalSyntax.KeywordSyntax, name As IdentifierNameSyntax, argumentList As ArgumentListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(raiseEventKeyword)
            Me._raiseEventKeyword = raiseEventKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), raiseEventKeyword As InternalSyntax.KeywordSyntax, name As IdentifierNameSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(raiseEventKeyword)
            Me._raiseEventKeyword = raiseEventKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _raiseEventKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _raiseEventKeyword isnot Nothing 
             AdjustFlagsAndWidth(_raiseEventKeyword)
             Me._raiseEventKeyword = _raiseEventKeyword
          End If
          Dim _name = DirectCast(reader.ReadValue(), IdentifierNameSyntax)
          If _name isnot Nothing 
             AdjustFlagsAndWidth(_name)
             Me._name = _name
          End If
          Dim _argumentList = DirectCast(reader.ReadValue(), ArgumentListSyntax)
          If _argumentList isnot Nothing 
             AdjustFlagsAndWidth(_argumentList)
             Me._argumentList = _argumentList
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New RaiseEventStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._raiseEventKeyword)
          writer.WriteValue(Me._name)
          writer.WriteValue(Me._argumentList)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(RaiseEventStatementSyntax), Function(r) New RaiseEventStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.RaiseEventStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "RaiseEvent" keyword
        ''' </summary>
        Friend  ReadOnly Property RaiseEventKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._raiseEventKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the event being raised.
        ''' </summary>
        Friend  ReadOnly Property Name As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <summary>
        ''' The argument list, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ArgumentList As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._argumentList
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._raiseEventKeyword
                Case 1
                    Return Me._name
                Case 2
                    Return Me._argumentList
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new RaiseEventStatementSyntax(Me.Kind, newErrors, GetAnnotations, _raiseEventKeyword, _name, _argumentList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new RaiseEventStatementSyntax(Me.Kind, GetDiagnostics, annotations, _raiseEventKeyword, _name, _argumentList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitRaiseEventStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "With" statement. This statement always occurs as the
    ''' BeginStatement of a WithBlock, and the body of the With is the Body of that
    ''' WithBlock.
    ''' </summary>
    Friend NotInheritable Class WithStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _withKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, withKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, withKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _withKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _withKeyword isnot Nothing 
             AdjustFlagsAndWidth(_withKeyword)
             Me._withKeyword = _withKeyword
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New WithStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._withKeyword)
          writer.WriteValue(Me._expression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(WithStatementSyntax), Function(r) New WithStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WithStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "With" keyword.
        ''' </summary>
        Friend  ReadOnly Property WithKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._withKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression that is the operand of the With statement.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._withKeyword
                Case 1
                    Return Me._expression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WithStatementSyntax(Me.Kind, newErrors, GetAnnotations, _withKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WithStatementSyntax(Me.Kind, GetDiagnostics, annotations, _withKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWithStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a ReDim statement.
    ''' </summary>
    Friend NotInheritable Class ReDimStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _reDimKeyword as KeywordSyntax
        Friend ReadOnly _preserveKeyword as KeywordSyntax
        Friend ReadOnly _clauses as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, reDimKeyword As InternalSyntax.KeywordSyntax, preserveKeyword As InternalSyntax.KeywordSyntax, clauses As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(reDimKeyword)
            Me._reDimKeyword = reDimKeyword
            If preserveKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(preserveKeyword)
                Me._preserveKeyword = preserveKeyword
            End If
            If clauses IsNot Nothing Then
                AdjustFlagsAndWidth(clauses)
                Me._clauses = clauses
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, reDimKeyword As InternalSyntax.KeywordSyntax, preserveKeyword As InternalSyntax.KeywordSyntax, clauses As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(reDimKeyword)
            Me._reDimKeyword = reDimKeyword
            If preserveKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(preserveKeyword)
                Me._preserveKeyword = preserveKeyword
            End If
            If clauses IsNot Nothing Then
                AdjustFlagsAndWidth(clauses)
                Me._clauses = clauses
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), reDimKeyword As InternalSyntax.KeywordSyntax, preserveKeyword As InternalSyntax.KeywordSyntax, clauses As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(reDimKeyword)
            Me._reDimKeyword = reDimKeyword
            If preserveKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(preserveKeyword)
                Me._preserveKeyword = preserveKeyword
            End If
            If clauses IsNot Nothing Then
                AdjustFlagsAndWidth(clauses)
                Me._clauses = clauses
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _reDimKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _reDimKeyword isnot Nothing 
             AdjustFlagsAndWidth(_reDimKeyword)
             Me._reDimKeyword = _reDimKeyword
          End If
          Dim _preserveKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _preserveKeyword isnot Nothing 
             AdjustFlagsAndWidth(_preserveKeyword)
             Me._preserveKeyword = _preserveKeyword
          End If
          Dim _clauses = DirectCast(reader.ReadValue(), GreenNode)
          If _clauses isnot Nothing 
             AdjustFlagsAndWidth(_clauses)
             Me._clauses = _clauses
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ReDimStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._reDimKeyword)
          writer.WriteValue(Me._preserveKeyword)
          writer.WriteValue(Me._clauses)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ReDimStatementSyntax), Function(r) New ReDimStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ReDimStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "ReDim" keyword.
        ''' </summary>
        Friend  ReadOnly Property ReDimKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._reDimKeyword
            End Get
        End Property

        ''' <summary>
        ''' Returns Nothing if Kind=ReDim, returns the "Preserve" keyword if
        ''' Kind=RedimPreserve.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property PreserveKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._preserveKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of ReDim clauses.
        ''' </summary>
        Friend  ReadOnly Property Clauses As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of RedimClauseSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of RedimClauseSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of RedimClauseSyntax)(Me._clauses))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._reDimKeyword
                Case 1
                    Return Me._preserveKeyword
                Case 2
                    Return Me._clauses
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ReDimStatementSyntax(Me.Kind, newErrors, GetAnnotations, _reDimKeyword, _preserveKeyword, _clauses)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ReDimStatementSyntax(Me.Kind, GetDiagnostics, annotations, _reDimKeyword, _preserveKeyword, _clauses)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitReDimStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a ReDim statement clause.
    ''' </summary>
    Friend NotInheritable Class RedimClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _arrayBounds as ArgumentListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, arrayBounds As ArgumentListSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(arrayBounds)
            Me._arrayBounds = arrayBounds

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, arrayBounds As ArgumentListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(arrayBounds)
            Me._arrayBounds = arrayBounds

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax, arrayBounds As ArgumentListSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(arrayBounds)
            Me._arrayBounds = arrayBounds

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
          Dim _arrayBounds = DirectCast(reader.ReadValue(), ArgumentListSyntax)
          If _arrayBounds isnot Nothing 
             AdjustFlagsAndWidth(_arrayBounds)
             Me._arrayBounds = _arrayBounds
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New RedimClauseSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._expression)
          writer.WriteValue(Me._arrayBounds)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(RedimClauseSyntax), Function(r) New RedimClauseSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.RedimClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The target of the ReDim statement.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The ArraySizeInitializationModifier.
        ''' </summary>
        Friend  ReadOnly Property ArrayBounds As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._arrayBounds
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._expression
                Case 1
                    Return Me._arrayBounds
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new RedimClauseSyntax(Me.Kind, newErrors, GetAnnotations, _expression, _arrayBounds)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new RedimClauseSyntax(Me.Kind, GetDiagnostics, annotations, _expression, _arrayBounds)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitRedimClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "Erase" statement.
    ''' </summary>
    Friend NotInheritable Class EraseStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _eraseKeyword as KeywordSyntax
        Friend ReadOnly _expressions as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, eraseKeyword As InternalSyntax.KeywordSyntax, expressions As GreenNode)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(eraseKeyword)
            Me._eraseKeyword = eraseKeyword
            If expressions IsNot Nothing Then
                AdjustFlagsAndWidth(expressions)
                Me._expressions = expressions
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, eraseKeyword As InternalSyntax.KeywordSyntax, expressions As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(eraseKeyword)
            Me._eraseKeyword = eraseKeyword
            If expressions IsNot Nothing Then
                AdjustFlagsAndWidth(expressions)
                Me._expressions = expressions
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), eraseKeyword As InternalSyntax.KeywordSyntax, expressions As GreenNode)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(eraseKeyword)
            Me._eraseKeyword = eraseKeyword
            If expressions IsNot Nothing Then
                AdjustFlagsAndWidth(expressions)
                Me._expressions = expressions
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _eraseKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _eraseKeyword isnot Nothing 
             AdjustFlagsAndWidth(_eraseKeyword)
             Me._eraseKeyword = _eraseKeyword
          End If
          Dim _expressions = DirectCast(reader.ReadValue(), GreenNode)
          If _expressions isnot Nothing 
             AdjustFlagsAndWidth(_expressions)
             Me._expressions = _expressions
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New EraseStatementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._eraseKeyword)
          writer.WriteValue(Me._expressions)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(EraseStatementSyntax), Function(r) New EraseStatementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EraseStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Erase" keyword.
        ''' </summary>
        Friend  ReadOnly Property EraseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._eraseKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of expressions denoting the arrays to erase.
        ''' </summary>
        Friend  ReadOnly Property Expressions As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ExpressionSyntax)(Me._expressions))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._eraseKeyword
                Case 1
                    Return Me._expressions
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EraseStatementSyntax(Me.Kind, newErrors, GetAnnotations, _eraseKeyword, _expressions)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EraseStatementSyntax(Me.Kind, GetDiagnostics, annotations, _eraseKeyword, _expressions)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEraseStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' An abstract base class for all node classes that define expressions.
    ''' </summary>
    Friend MustInherit Class ExpressionSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' Represents a literal. The kind of literal is determined by the Kind property:
    ''' IntegerLiteral, CharacterLiteral, BooleanLiteral, DecimalLiteral,
    ''' FloatingLiteral, DateLiteral or StringLiteral. The value of the literal can be
    ''' determined by casting the associated Token to the correct type and getting the
    ''' value from the token.
    ''' </summary>
    Friend NotInheritable Class LiteralExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _token as SyntaxToken

        Friend Sub New(ByVal kind As SyntaxKind, token As InternalSyntax.SyntaxToken)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(token)
            Me._token = token

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, token As InternalSyntax.SyntaxToken, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(token)
            Me._token = token

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), token As InternalSyntax.SyntaxToken)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(token)
            Me._token = token

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _token = DirectCast(reader.ReadValue(), SyntaxToken)
          If _token isnot Nothing 
             AdjustFlagsAndWidth(_token)
             Me._token = _token
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New LiteralExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._token)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(LiteralExpressionSyntax), Function(r) New LiteralExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LiteralExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The token that represents the literal. The Kind property determines what type
        ''' this property returns: Kind=IntegerLiteral ==&gt; Returns IntegerLiteralToken.
        ''' Kind=CharacterLiteral ==&gt; Returns CharacterLiteralToken. Kind=DecimalLiteral
        ''' ==&gt; Returns DecimalLiteralToken Kind=FloatingLiteral ==&gt; Returns
        ''' FloatingLiteralToken Kind=DateLiteral ==&gt; Returns DateLiteralToken
        ''' Kind=StringLiteral ==&gt; Returns StringLiteralToken Kind=BooleanLiteral ==&gt;
        ''' Returns Keyword (with it's kind being TrueKeyword or FalseKeyword)
        ''' Kind=NothingLiteral ==&gt; Returns Keyword (with it's kind being
        ''' NothingKeyword)
        ''' </summary>
        Friend  ReadOnly Property Token As InternalSyntax.SyntaxToken
            Get
                Return Me._token
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._token
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LiteralExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _token)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LiteralExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _token)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLiteralExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a parenthesized expression.
    ''' </summary>
    Friend NotInheritable Class ParenthesizedExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ParenthesizedExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._expression)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ParenthesizedExpressionSyntax), Function(r) New ParenthesizedExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ParenthesizedExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The expression inside the parentheses.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._expression
                Case 2
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ParenthesizedExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _expression, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ParenthesizedExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _expression, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitParenthesizedExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a tuple literal expression.
    ''' </summary>
    Friend NotInheritable Class TupleExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _arguments as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _arguments = DirectCast(reader.ReadValue(), GreenNode)
          If _arguments isnot Nothing 
             AdjustFlagsAndWidth(_arguments)
             Me._arguments = _arguments
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TupleExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._arguments)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TupleExpressionSyntax), Function(r) New TupleExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TupleExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The list of tuple arguments.
        ''' </summary>
        Friend  ReadOnly Property Arguments As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of SimpleArgumentSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of SimpleArgumentSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of SimpleArgumentSyntax)(Me._arguments))
            End Get
        End Property

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._arguments
                Case 2
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TupleExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _arguments, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TupleExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _arguments, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTupleExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a tuple type expression.
    ''' </summary>
    Friend NotInheritable Class TupleTypeSyntax
        Inherits TypeSyntax

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _elements as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, elements As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If elements IsNot Nothing Then
                AdjustFlagsAndWidth(elements)
                Me._elements = elements
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, elements As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If elements IsNot Nothing Then
                AdjustFlagsAndWidth(elements)
                Me._elements = elements
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, elements As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If elements IsNot Nothing Then
                AdjustFlagsAndWidth(elements)
                Me._elements = elements
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _elements = DirectCast(reader.ReadValue(), GreenNode)
          If _elements isnot Nothing 
             AdjustFlagsAndWidth(_elements)
             Me._elements = _elements
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TupleTypeSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._elements)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TupleTypeSyntax), Function(r) New TupleTypeSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TupleTypeSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The list of tuple elements.
        ''' </summary>
        Friend  ReadOnly Property Elements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TupleElementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TupleElementSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of TupleElementSyntax)(Me._elements))
            End Get
        End Property

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._elements
                Case 2
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TupleTypeSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _elements, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TupleTypeSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _elements, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTupleType(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single declaration of a tuple element.
    ''' </summary>
    Friend MustInherit Class TupleElementSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' Represents a single declaration of a tuple element supplying only the type.
    ''' </summary>
    Friend NotInheritable Class TypedTupleElementSyntax
        Inherits TupleElementSyntax

        Friend ReadOnly _type as TypeSyntax

        Friend Sub New(ByVal kind As SyntaxKind, type As TypeSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, type As TypeSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), type As TypeSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _type = DirectCast(reader.ReadValue(), TypeSyntax)
          If _type isnot Nothing 
             AdjustFlagsAndWidth(_type)
             Me._type = _type
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TypedTupleElementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._type)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TypedTupleElementSyntax), Function(r) New TypedTupleElementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypedTupleElementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The type-name part of the tuple element syntax.
        ''' </summary>
        Friend  ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._type
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypedTupleElementSyntax(Me.Kind, newErrors, GetAnnotations, _type)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypedTupleElementSyntax(Me.Kind, GetDiagnostics, annotations, _type)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypedTupleElement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single declaration of a tuple element supplying element name and
    ''' optionally a type.
    ''' </summary>
    Friend NotInheritable Class NamedTupleElementSyntax
        Inherits TupleElementSyntax

        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, asClause As SimpleAsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _identifier = DirectCast(reader.ReadValue(), IdentifierTokenSyntax)
          If _identifier isnot Nothing 
             AdjustFlagsAndWidth(_identifier)
             Me._identifier = _identifier
          End If
          Dim _asClause = DirectCast(reader.ReadValue(), SimpleAsClauseSyntax)
          If _asClause isnot Nothing 
             AdjustFlagsAndWidth(_asClause)
             Me._asClause = _asClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New NamedTupleElementSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._identifier)
          writer.WriteValue(Me._asClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(NamedTupleElementSyntax), Function(r) New NamedTupleElementSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NamedTupleElementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The name of the element.
        ''' </summary>
        Friend  ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' A simple "As" clause specifying the type of the tuple element.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._identifier
                Case 1
                    Return Me._asClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NamedTupleElementSyntax(Me.Kind, newErrors, GetAnnotations, _identifier, _asClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NamedTupleElementSyntax(Me.Kind, GetDiagnostics, annotations, _identifier, _asClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNamedTupleElement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Identifies one of the special instances "Me", "MyClass" or "MyBase". The Kind
    ''' property identifies which.
    ''' </summary>
    Friend MustInherit Class InstanceExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _keyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _keyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _keyword isnot Nothing 
             AdjustFlagsAndWidth(_keyword)
             Me._keyword = _keyword
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._keyword)
        End Sub

        ''' <summary>
        ''' The "Me", "MyClass" or "MyBase" keyword.
        ''' </summary>
        Friend  ReadOnly Property Keyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._keyword
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Identifies the special instance "Me"
    ''' </summary>
    Friend NotInheritable Class MeExpressionSyntax
        Inherits InstanceExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, keyword)
            MyBase._slotCount = 1
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations, keyword)
            MyBase._slotCount = 1
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New MeExpressionSyntax(o)


        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(MeExpressionSyntax), Function(r) New MeExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MeExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._keyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MeExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MeExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMeExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Identifies the special instance "MyBase"
    ''' </summary>
    Friend NotInheritable Class MyBaseExpressionSyntax
        Inherits InstanceExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, keyword)
            MyBase._slotCount = 1
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations, keyword)
            MyBase._slotCount = 1
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New MyBaseExpressionSyntax(o)


        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(MyBaseExpressionSyntax), Function(r) New MyBaseExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MyBaseExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._keyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MyBaseExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MyBaseExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMyBaseExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Identifies the special instance "MyClass"
    ''' </summary>
    Friend NotInheritable Class MyClassExpressionSyntax
        Inherits InstanceExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, keyword)
            MyBase._slotCount = 1
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations, keyword)
            MyBase._slotCount = 1
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New MyClassExpressionSyntax(o)


        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(MyClassExpressionSyntax), Function(r) New MyClassExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MyClassExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._keyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MyClassExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MyClassExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMyClassExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a GetType expression.
    ''' </summary>
    Friend NotInheritable Class GetTypeExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _getTypeKeyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _type as TypeSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, getTypeKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(getTypeKeyword)
            Me._getTypeKeyword = getTypeKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, getTypeKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(getTypeKeyword)
            Me._getTypeKeyword = getTypeKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), getTypeKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(getTypeKeyword)
            Me._getTypeKeyword = getTypeKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _getTypeKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _getTypeKeyword isnot Nothing 
             AdjustFlagsAndWidth(_getTypeKeyword)
             Me._getTypeKeyword = _getTypeKeyword
          End If
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _type = DirectCast(reader.ReadValue(), TypeSyntax)
          If _type isnot Nothing 
             AdjustFlagsAndWidth(_type)
             Me._type = _type
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New GetTypeExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._getTypeKeyword)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._type)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(GetTypeExpressionSyntax), Function(r) New GetTypeExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.GetTypeExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "GetType" keyword.
        ''' </summary>
        Friend  ReadOnly Property GetTypeKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._getTypeKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The type to get the Type object for. This can be an open generic type.
        ''' </summary>
        Friend  ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._getTypeKeyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._type
                Case 3
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new GetTypeExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _getTypeKeyword, _openParenToken, _type, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new GetTypeExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _getTypeKeyword, _openParenToken, _type, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitGetTypeExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a TypeOf...Is or IsNot expression.
    ''' </summary>
    Friend NotInheritable Class TypeOfExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _typeOfKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _operatorToken as KeywordSyntax
        Friend ReadOnly _type as TypeSyntax

        Friend Sub New(ByVal kind As SyntaxKind, typeOfKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, operatorToken As InternalSyntax.KeywordSyntax, type As TypeSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(typeOfKeyword)
            Me._typeOfKeyword = typeOfKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, typeOfKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, operatorToken As InternalSyntax.KeywordSyntax, type As TypeSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(typeOfKeyword)
            Me._typeOfKeyword = typeOfKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), typeOfKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, operatorToken As InternalSyntax.KeywordSyntax, type As TypeSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(typeOfKeyword)
            Me._typeOfKeyword = typeOfKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _typeOfKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _typeOfKeyword isnot Nothing 
             AdjustFlagsAndWidth(_typeOfKeyword)
             Me._typeOfKeyword = _typeOfKeyword
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
          Dim _operatorToken = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _operatorToken isnot Nothing 
             AdjustFlagsAndWidth(_operatorToken)
             Me._operatorToken = _operatorToken
          End If
          Dim _type = DirectCast(reader.ReadValue(), TypeSyntax)
          If _type isnot Nothing 
             AdjustFlagsAndWidth(_type)
             Me._type = _type
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TypeOfExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._typeOfKeyword)
          writer.WriteValue(Me._expression)
          writer.WriteValue(Me._operatorToken)
          writer.WriteValue(Me._type)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TypeOfExpressionSyntax), Function(r) New TypeOfExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeOfExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "TypeOf" keyword.
        ''' </summary>
        Friend  ReadOnly Property TypeOfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._typeOfKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression being tested.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The "Is" or "IsNot" keyword.
        ''' </summary>
        Friend  ReadOnly Property OperatorToken As InternalSyntax.KeywordSyntax
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The name of the type being tested against.
        ''' </summary>
        Friend  ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._typeOfKeyword
                Case 1
                    Return Me._expression
                Case 2
                    Return Me._operatorToken
                Case 3
                    Return Me._type
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeOfExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _typeOfKeyword, _expression, _operatorToken, _type)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeOfExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _typeOfKeyword, _expression, _operatorToken, _type)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeOfExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a GetXmlNamespace expression.
    ''' </summary>
    Friend NotInheritable Class GetXmlNamespaceExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _getXmlNamespaceKeyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _name as XmlPrefixNameSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, getXmlNamespaceKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, name As XmlPrefixNameSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(getXmlNamespaceKeyword)
            Me._getXmlNamespaceKeyword = getXmlNamespaceKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If name IsNot Nothing Then
                AdjustFlagsAndWidth(name)
                Me._name = name
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, getXmlNamespaceKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, name As XmlPrefixNameSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(getXmlNamespaceKeyword)
            Me._getXmlNamespaceKeyword = getXmlNamespaceKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If name IsNot Nothing Then
                AdjustFlagsAndWidth(name)
                Me._name = name
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), getXmlNamespaceKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, name As XmlPrefixNameSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(getXmlNamespaceKeyword)
            Me._getXmlNamespaceKeyword = getXmlNamespaceKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If name IsNot Nothing Then
                AdjustFlagsAndWidth(name)
                Me._name = name
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _getXmlNamespaceKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _getXmlNamespaceKeyword isnot Nothing 
             AdjustFlagsAndWidth(_getXmlNamespaceKeyword)
             Me._getXmlNamespaceKeyword = _getXmlNamespaceKeyword
          End If
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _name = DirectCast(reader.ReadValue(), XmlPrefixNameSyntax)
          If _name isnot Nothing 
             AdjustFlagsAndWidth(_name)
             Me._name = _name
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New GetXmlNamespaceExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._getXmlNamespaceKeyword)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._name)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(GetXmlNamespaceExpressionSyntax), Function(r) New GetXmlNamespaceExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.GetXmlNamespaceExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "GetXmlNamespace" keyword.
        ''' </summary>
        Friend  ReadOnly Property GetXmlNamespaceKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._getXmlNamespaceKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The Xml namespace name being referenced.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Name As InternalSyntax.XmlPrefixNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._getXmlNamespaceKeyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._name
                Case 3
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new GetXmlNamespaceExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _getXmlNamespaceKeyword, _openParenToken, _name, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new GetXmlNamespaceExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _getXmlNamespaceKeyword, _openParenToken, _name, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitGetXmlNamespaceExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents member access (.name) or dictionary access (!name). The Kind
    ''' property determines which kind of access.
    ''' </summary>
    Friend NotInheritable Class MemberAccessExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _operatorToken as PunctuationSyntax
        Friend ReadOnly _name as SimpleNameSyntax

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, name As SimpleNameSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, name As SimpleNameSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, name As SimpleNameSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
          Dim _operatorToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _operatorToken isnot Nothing 
             AdjustFlagsAndWidth(_operatorToken)
             Me._operatorToken = _operatorToken
          End If
          Dim _name = DirectCast(reader.ReadValue(), SimpleNameSyntax)
          If _name isnot Nothing 
             AdjustFlagsAndWidth(_name)
             Me._name = _name
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New MemberAccessExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._expression)
          writer.WriteValue(Me._operatorToken)
          writer.WriteValue(Me._name)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(MemberAccessExpressionSyntax), Function(r) New MemberAccessExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MemberAccessExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The expression on the left-hand-side of the "." or "!" token.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The "." or "!" token.
        ''' </summary>
        Friend  ReadOnly Property OperatorToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The identifier after the "." or "!" token.
        ''' </summary>
        Friend  ReadOnly Property Name As InternalSyntax.SimpleNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._expression
                Case 1
                    Return Me._operatorToken
                Case 2
                    Return Me._name
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MemberAccessExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _expression, _operatorToken, _name)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MemberAccessExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _expression, _operatorToken, _name)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMemberAccessExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML member element access (node.&lt;Element&gt;), attribute
    ''' access (node.@Attribute) or descendants access (node...&lt;Descendant&gt;). The
    ''' Kind property determines which kind of access.
    ''' </summary>
    Friend NotInheritable Class XmlMemberAccessExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _base as ExpressionSyntax
        Friend ReadOnly _token1 as PunctuationSyntax
        Friend ReadOnly _token2 as PunctuationSyntax
        Friend ReadOnly _token3 as PunctuationSyntax
        Friend ReadOnly _name as XmlNodeSyntax

        Friend Sub New(ByVal kind As SyntaxKind, base As ExpressionSyntax, token1 As InternalSyntax.PunctuationSyntax, token2 As InternalSyntax.PunctuationSyntax, token3 As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 5

            If base IsNot Nothing Then
                AdjustFlagsAndWidth(base)
                Me._base = base
            End If
            AdjustFlagsAndWidth(token1)
            Me._token1 = token1
            If token2 IsNot Nothing Then
                AdjustFlagsAndWidth(token2)
                Me._token2 = token2
            End If
            If token3 IsNot Nothing Then
                AdjustFlagsAndWidth(token3)
                Me._token3 = token3
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, base As ExpressionSyntax, token1 As InternalSyntax.PunctuationSyntax, token2 As InternalSyntax.PunctuationSyntax, token3 As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            If base IsNot Nothing Then
                AdjustFlagsAndWidth(base)
                Me._base = base
            End If
            AdjustFlagsAndWidth(token1)
            Me._token1 = token1
            If token2 IsNot Nothing Then
                AdjustFlagsAndWidth(token2)
                Me._token2 = token2
            End If
            If token3 IsNot Nothing Then
                AdjustFlagsAndWidth(token3)
                Me._token3 = token3
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), base As ExpressionSyntax, token1 As InternalSyntax.PunctuationSyntax, token2 As InternalSyntax.PunctuationSyntax, token3 As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 5

            If base IsNot Nothing Then
                AdjustFlagsAndWidth(base)
                Me._base = base
            End If
            AdjustFlagsAndWidth(token1)
            Me._token1 = token1
            If token2 IsNot Nothing Then
                AdjustFlagsAndWidth(token2)
                Me._token2 = token2
            End If
            If token3 IsNot Nothing Then
                AdjustFlagsAndWidth(token3)
                Me._token3 = token3
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _base = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _base isnot Nothing 
             AdjustFlagsAndWidth(_base)
             Me._base = _base
          End If
          Dim _token1 = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _token1 isnot Nothing 
             AdjustFlagsAndWidth(_token1)
             Me._token1 = _token1
          End If
          Dim _token2 = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _token2 isnot Nothing 
             AdjustFlagsAndWidth(_token2)
             Me._token2 = _token2
          End If
          Dim _token3 = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _token3 isnot Nothing 
             AdjustFlagsAndWidth(_token3)
             Me._token3 = _token3
          End If
          Dim _name = DirectCast(reader.ReadValue(), XmlNodeSyntax)
          If _name isnot Nothing 
             AdjustFlagsAndWidth(_name)
             Me._name = _name
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New XmlMemberAccessExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._base)
          writer.WriteValue(Me._token1)
          writer.WriteValue(Me._token2)
          writer.WriteValue(Me._token3)
          writer.WriteValue(Me._name)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(XmlMemberAccessExpressionSyntax), Function(r) New XmlMemberAccessExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlMemberAccessExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The expression on the left-hand-side of the ".", ".@" or "..." .
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Base As InternalSyntax.ExpressionSyntax
            Get
                Return Me._base
            End Get
        End Property

        ''' <summary>
        ''' The initial dot "." part of the separator.
        ''' </summary>
        Friend  ReadOnly Property Token1 As InternalSyntax.PunctuationSyntax
            Get
                Return Me._token1
            End Get
        End Property

        ''' <summary>
        ''' The "@" part of .@ or the second "." of "...".
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Token2 As InternalSyntax.PunctuationSyntax
            Get
                Return Me._token2
            End Get
        End Property

        ''' <summary>
        ''' The third "." in a "..." separator.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Token3 As InternalSyntax.PunctuationSyntax
            Get
                Return Me._token3
            End Get
        End Property

        ''' <summary>
        ''' The identifier after the ".", ".@" or "..."
        ''' </summary>
        Friend  ReadOnly Property Name As InternalSyntax.XmlNodeSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._base
                Case 1
                    Return Me._token1
                Case 2
                    Return Me._token2
                Case 3
                    Return Me._token3
                Case 4
                    Return Me._name
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlMemberAccessExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _base, _token1, _token2, _token3, _name)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlMemberAccessExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _base, _token1, _token2, _token3, _name)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlMemberAccessExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an invocation expression consisting of an invocation target and an
    ''' optional argument list or an array, parameterized property or object default
    ''' property index.
    ''' </summary>
    Friend NotInheritable Class InvocationExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, argumentList As ArgumentListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
          Dim _argumentList = DirectCast(reader.ReadValue(), ArgumentListSyntax)
          If _argumentList isnot Nothing 
             AdjustFlagsAndWidth(_argumentList)
             Me._argumentList = _argumentList
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New InvocationExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._expression)
          writer.WriteValue(Me._argumentList)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(InvocationExpressionSyntax), Function(r) New InvocationExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.InvocationExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The target of the call or index expression.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The argument list.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ArgumentList As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._argumentList
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._expression
                Case 1
                    Return Me._argumentList
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new InvocationExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _expression, _argumentList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new InvocationExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _expression, _argumentList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitInvocationExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Base class for object, array and anonymous object creation expressions
    ''' </summary>
    Partial Friend MustInherit Class NewExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _newKeyword as KeywordSyntax
        Friend ReadOnly _attributeLists as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode)
            MyBase.New(kind)

            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword
            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword
            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword
            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _newKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _newKeyword isnot Nothing 
             AdjustFlagsAndWidth(_newKeyword)
             Me._newKeyword = _newKeyword
          End If
          Dim _attributeLists = DirectCast(reader.ReadValue(), GreenNode)
          If _attributeLists isnot Nothing 
             AdjustFlagsAndWidth(_attributeLists)
             Me._attributeLists = _attributeLists
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._newKeyword)
          writer.WriteValue(Me._attributeLists)
        End Sub

        ''' <summary>
        ''' The "New" keyword.
        ''' </summary>
        Friend  ReadOnly Property NewKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._newKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of all attribute lists on the type. If no attributes were specified, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents a New expression that creates a new non-array object, possibly with
    ''' a "With" or "From" clause.
    ''' </summary>
    Friend NotInheritable Class ObjectCreationExpressionSyntax
        Inherits NewExpressionSyntax

        Friend ReadOnly _type as TypeSyntax
        Friend ReadOnly _argumentList as ArgumentListSyntax
        Friend ReadOnly _initializer as ObjectCreationInitializerSyntax

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, argumentList As ArgumentListSyntax, initializer As ObjectCreationInitializerSyntax)
            MyBase.New(kind, newKeyword, attributeLists)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(type)
            Me._type = type
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, argumentList As ArgumentListSyntax, initializer As ObjectCreationInitializerSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, newKeyword, attributeLists)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(type)
            Me._type = type
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, argumentList As ArgumentListSyntax, initializer As ObjectCreationInitializerSyntax)
            MyBase.New(kind, errors, annotations, newKeyword, attributeLists)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(type)
            Me._type = type
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _type = DirectCast(reader.ReadValue(), TypeSyntax)
          If _type isnot Nothing 
             AdjustFlagsAndWidth(_type)
             Me._type = _type
          End If
          Dim _argumentList = DirectCast(reader.ReadValue(), ArgumentListSyntax)
          If _argumentList isnot Nothing 
             AdjustFlagsAndWidth(_argumentList)
             Me._argumentList = _argumentList
          End If
          Dim _initializer = DirectCast(reader.ReadValue(), ObjectCreationInitializerSyntax)
          If _initializer isnot Nothing 
             AdjustFlagsAndWidth(_initializer)
             Me._initializer = _initializer
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ObjectCreationExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._type)
          writer.WriteValue(Me._argumentList)
          writer.WriteValue(Me._initializer)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ObjectCreationExpressionSyntax), Function(r) New ObjectCreationExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ObjectCreationExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The type of the object being initialized.
        ''' </summary>
        Friend  ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        ''' <summary>
        ''' The argument list, if present. If no argument list was supplied, Nothing is
        ''' returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ArgumentList As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._argumentList
            End Get
        End Property

        ''' <summary>
        ''' An optional From or With clause to initialize the new object.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property Initializer As InternalSyntax.ObjectCreationInitializerSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._newKeyword
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._type
                Case 3
                    Return Me._argumentList
                Case 4
                    Return Me._initializer
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ObjectCreationExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _newKeyword, _attributeLists, _type, _argumentList, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ObjectCreationExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _newKeyword, _attributeLists, _type, _argumentList, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitObjectCreationExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a New expression that create an object of anonymous type.
    ''' </summary>
    Friend NotInheritable Class AnonymousObjectCreationExpressionSyntax
        Inherits NewExpressionSyntax

        Friend ReadOnly _initializer as ObjectMemberInitializerSyntax

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, initializer As ObjectMemberInitializerSyntax)
            MyBase.New(kind, newKeyword, attributeLists)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, initializer As ObjectMemberInitializerSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, newKeyword, attributeLists)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, initializer As ObjectMemberInitializerSyntax)
            MyBase.New(kind, errors, annotations, newKeyword, attributeLists)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _initializer = DirectCast(reader.ReadValue(), ObjectMemberInitializerSyntax)
          If _initializer isnot Nothing 
             AdjustFlagsAndWidth(_initializer)
             Me._initializer = _initializer
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New AnonymousObjectCreationExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._initializer)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(AnonymousObjectCreationExpressionSyntax), Function(r) New AnonymousObjectCreationExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AnonymousObjectCreationExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The With clause to initialize the new object.
        ''' </summary>
        Friend  ReadOnly Property Initializer As InternalSyntax.ObjectMemberInitializerSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._newKeyword
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._initializer
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AnonymousObjectCreationExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _newKeyword, _attributeLists, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AnonymousObjectCreationExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _newKeyword, _attributeLists, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAnonymousObjectCreationExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an expression that creates a new array.
    ''' </summary>
    Friend NotInheritable Class ArrayCreationExpressionSyntax
        Inherits NewExpressionSyntax

        Friend ReadOnly _type as TypeSyntax
        Friend ReadOnly _arrayBounds as ArgumentListSyntax
        Friend ReadOnly _rankSpecifiers as GreenNode
        Friend ReadOnly _initializer as CollectionInitializerSyntax

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, arrayBounds As ArgumentListSyntax, rankSpecifiers As GreenNode, initializer As CollectionInitializerSyntax)
            MyBase.New(kind, newKeyword, attributeLists)
            MyBase._slotCount = 6

            AdjustFlagsAndWidth(type)
            Me._type = type
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If rankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(rankSpecifiers)
                Me._rankSpecifiers = rankSpecifiers
            End If
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, arrayBounds As ArgumentListSyntax, rankSpecifiers As GreenNode, initializer As CollectionInitializerSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, newKeyword, attributeLists)
            MyBase._slotCount = 6
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(type)
            Me._type = type
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If rankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(rankSpecifiers)
                Me._rankSpecifiers = rankSpecifiers
            End If
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, arrayBounds As ArgumentListSyntax, rankSpecifiers As GreenNode, initializer As CollectionInitializerSyntax)
            MyBase.New(kind, errors, annotations, newKeyword, attributeLists)
            MyBase._slotCount = 6

            AdjustFlagsAndWidth(type)
            Me._type = type
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If rankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(rankSpecifiers)
                Me._rankSpecifiers = rankSpecifiers
            End If
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 6
          Dim _type = DirectCast(reader.ReadValue(), TypeSyntax)
          If _type isnot Nothing 
             AdjustFlagsAndWidth(_type)
             Me._type = _type
          End If
          Dim _arrayBounds = DirectCast(reader.ReadValue(), ArgumentListSyntax)
          If _arrayBounds isnot Nothing 
             AdjustFlagsAndWidth(_arrayBounds)
             Me._arrayBounds = _arrayBounds
          End If
          Dim _rankSpecifiers = DirectCast(reader.ReadValue(), GreenNode)
          If _rankSpecifiers isnot Nothing 
             AdjustFlagsAndWidth(_rankSpecifiers)
             Me._rankSpecifiers = _rankSpecifiers
          End If
          Dim _initializer = DirectCast(reader.ReadValue(), CollectionInitializerSyntax)
          If _initializer isnot Nothing 
             AdjustFlagsAndWidth(_initializer)
             Me._initializer = _initializer
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ArrayCreationExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._type)
          writer.WriteValue(Me._arrayBounds)
          writer.WriteValue(Me._rankSpecifiers)
          writer.WriteValue(Me._initializer)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ArrayCreationExpressionSyntax), Function(r) New ArrayCreationExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ArrayCreationExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The element type of the array being created.
        ''' </summary>
        Friend  ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        ''' <summary>
        ''' The optional array bounds, such as "(4)" or "(0 to 5, 0 To 6)".
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property ArrayBounds As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._arrayBounds
            End Get
        End Property

        ''' <summary>
        ''' A list of array modifiers such as "()" or "(,)". If no array modifiers were
        ''' present, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property RankSpecifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ArrayRankSpecifierSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ArrayRankSpecifierSyntax)(Me._rankSpecifiers)
            End Get
        End Property

        ''' <summary>
        ''' The initializer including the braces.
        ''' </summary>
        Friend  ReadOnly Property Initializer As InternalSyntax.CollectionInitializerSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._newKeyword
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._type
                Case 3
                    Return Me._arrayBounds
                Case 4
                    Return Me._rankSpecifiers
                Case 5
                    Return Me._initializer
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ArrayCreationExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _newKeyword, _attributeLists, _type, _arrayBounds, _rankSpecifiers, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ArrayCreationExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _newKeyword, _attributeLists, _type, _arrayBounds, _rankSpecifiers, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitArrayCreationExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an expression that creates a new array without naming the element
    ''' type.
    ''' </summary>
    Friend NotInheritable Class CollectionInitializerSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _openBraceToken as PunctuationSyntax
        Friend ReadOnly _initializers as GreenNode
        Friend ReadOnly _closeBraceToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _openBraceToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openBraceToken isnot Nothing 
             AdjustFlagsAndWidth(_openBraceToken)
             Me._openBraceToken = _openBraceToken
          End If
          Dim _initializers = DirectCast(reader.ReadValue(), GreenNode)
          If _initializers isnot Nothing 
             AdjustFlagsAndWidth(_initializers)
             Me._initializers = _initializers
          End If
          Dim _closeBraceToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeBraceToken isnot Nothing 
             AdjustFlagsAndWidth(_closeBraceToken)
             Me._closeBraceToken = _closeBraceToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New CollectionInitializerSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._openBraceToken)
          writer.WriteValue(Me._initializers)
          writer.WriteValue(Me._closeBraceToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(CollectionInitializerSyntax), Function(r) New CollectionInitializerSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CollectionInitializerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "{" token.
        ''' </summary>
        Friend  ReadOnly Property OpenBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openBraceToken
            End Get
        End Property

        ''' <summary>
        ''' The list of initializers between the braces.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Initializers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ExpressionSyntax)(Me._initializers))
            End Get
        End Property

        ''' <summary>
        ''' The "}" token.
        ''' </summary>
        Friend  ReadOnly Property CloseBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeBraceToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openBraceToken
                Case 1
                    Return Me._initializers
                Case 2
                    Return Me._closeBraceToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CollectionInitializerSyntax(Me.Kind, newErrors, GetAnnotations, _openBraceToken, _initializers, _closeBraceToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CollectionInitializerSyntax(Me.Kind, GetDiagnostics, annotations, _openBraceToken, _initializers, _closeBraceToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCollectionInitializer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a CType, DirectCast or TryCast conversion expression. The Kind
    ''' property determines which kind of cast it is.
    ''' </summary>
    Friend MustInherit Class CastExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _keyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _commaToken as PunctuationSyntax
        Friend ReadOnly _type as TypeSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _keyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _keyword isnot Nothing 
             AdjustFlagsAndWidth(_keyword)
             Me._keyword = _keyword
          End If
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
          Dim _commaToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _commaToken isnot Nothing 
             AdjustFlagsAndWidth(_commaToken)
             Me._commaToken = _commaToken
          End If
          Dim _type = DirectCast(reader.ReadValue(), TypeSyntax)
          If _type isnot Nothing 
             AdjustFlagsAndWidth(_type)
             Me._type = _type
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._keyword)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._expression)
          writer.WriteValue(Me._commaToken)
          writer.WriteValue(Me._type)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        ''' <summary>
        ''' The "CType", "DirectCast" or "TryCast" keyword.
        ''' </summary>
        Friend  ReadOnly Property Keyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._keyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The expression being cast.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The "," token.
        ''' </summary>
        Friend  ReadOnly Property CommaToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._commaToken
            End Get
        End Property

        ''' <summary>
        ''' The type the expression is being cast to.
        ''' </summary>
        Friend  ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

    End Class

    Friend NotInheritable Class CTypeExpressionSyntax
        Inherits CastExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            MyBase._slotCount = 6
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            MyBase._slotCount = 6
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            MyBase._slotCount = 6
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 6
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New CTypeExpressionSyntax(o)


        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(CTypeExpressionSyntax), Function(r) New CTypeExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CTypeExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._expression
                Case 3
                    Return Me._commaToken
                Case 4
                    Return Me._type
                Case 5
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CTypeExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CTypeExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCTypeExpression(Me)
        End Function

    End Class

    Friend NotInheritable Class DirectCastExpressionSyntax
        Inherits CastExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            MyBase._slotCount = 6
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            MyBase._slotCount = 6
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            MyBase._slotCount = 6
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 6
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New DirectCastExpressionSyntax(o)


        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(DirectCastExpressionSyntax), Function(r) New DirectCastExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.DirectCastExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._expression
                Case 3
                    Return Me._commaToken
                Case 4
                    Return Me._type
                Case 5
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new DirectCastExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new DirectCastExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitDirectCastExpression(Me)
        End Function

    End Class

    Friend NotInheritable Class TryCastExpressionSyntax
        Inherits CastExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            MyBase._slotCount = 6
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            MyBase._slotCount = 6
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            MyBase._slotCount = 6
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 6
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TryCastExpressionSyntax(o)


        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TryCastExpressionSyntax), Function(r) New TryCastExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TryCastExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._expression
                Case 3
                    Return Me._commaToken
                Case 4
                    Return Me._type
                Case 5
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TryCastExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TryCastExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTryCastExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a cast to a pre-defined type using a pre-defined cast expression,
    ''' such as CInt or CLng.
    ''' </summary>
    Friend NotInheritable Class PredefinedCastExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _keyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 4

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 4
          Dim _keyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _keyword isnot Nothing 
             AdjustFlagsAndWidth(_keyword)
             Me._keyword = _keyword
          End If
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New PredefinedCastExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._keyword)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._expression)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(PredefinedCastExpressionSyntax), Function(r) New PredefinedCastExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.PredefinedCastExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The keyword that was used in the cast operation.
        ''' </summary>
        Friend  ReadOnly Property Keyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._keyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The expression being cast.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._expression
                Case 3
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new PredefinedCastExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword, _openParenToken, _expression, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new PredefinedCastExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword, _openParenToken, _expression, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitPredefinedCastExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a binary operator. The Kind property classifies the operators into
    ''' similar kind of operators (arithmetic, relational, logical or string); the
    ''' exact operation being performed is determined by the Operator property.
    ''' </summary>
    Friend NotInheritable Class BinaryExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _left as ExpressionSyntax
        Friend ReadOnly _operatorToken as SyntaxToken
        Friend ReadOnly _right as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, left As ExpressionSyntax, operatorToken As InternalSyntax.SyntaxToken, right As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, left As ExpressionSyntax, operatorToken As InternalSyntax.SyntaxToken, right As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), left As ExpressionSyntax, operatorToken As InternalSyntax.SyntaxToken, right As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _left = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _left isnot Nothing 
             AdjustFlagsAndWidth(_left)
             Me._left = _left
          End If
          Dim _operatorToken = DirectCast(reader.ReadValue(), SyntaxToken)
          If _operatorToken isnot Nothing 
             AdjustFlagsAndWidth(_operatorToken)
             Me._operatorToken = _operatorToken
          End If
          Dim _right = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _right isnot Nothing 
             AdjustFlagsAndWidth(_right)
             Me._right = _right
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New BinaryExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._left)
          writer.WriteValue(Me._operatorToken)
          writer.WriteValue(Me._right)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(BinaryExpressionSyntax), Function(r) New BinaryExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.BinaryExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The left operand.
        ''' </summary>
        Friend  ReadOnly Property Left As InternalSyntax.ExpressionSyntax
            Get
                Return Me._left
            End Get
        End Property

        Friend  ReadOnly Property OperatorToken As InternalSyntax.SyntaxToken
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The right operand.
        ''' </summary>
        Friend  ReadOnly Property Right As InternalSyntax.ExpressionSyntax
            Get
                Return Me._right
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._left
                Case 1
                    Return Me._operatorToken
                Case 2
                    Return Me._right
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new BinaryExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _left, _operatorToken, _right)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new BinaryExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _left, _operatorToken, _right)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitBinaryExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Describes a unary operator: Plus, Negate, Not or AddressOf.
    ''' </summary>
    Friend NotInheritable Class UnaryExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _operatorToken as SyntaxToken
        Friend ReadOnly _operand as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, operatorToken As InternalSyntax.SyntaxToken, operand As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(operand)
            Me._operand = operand

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, operatorToken As InternalSyntax.SyntaxToken, operand As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(operand)
            Me._operand = operand

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), operatorToken As InternalSyntax.SyntaxToken, operand As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(operand)
            Me._operand = operand

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _operatorToken = DirectCast(reader.ReadValue(), SyntaxToken)
          If _operatorToken isnot Nothing 
             AdjustFlagsAndWidth(_operatorToken)
             Me._operatorToken = _operatorToken
          End If
          Dim _operand = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _operand isnot Nothing 
             AdjustFlagsAndWidth(_operand)
             Me._operand = _operand
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New UnaryExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._operatorToken)
          writer.WriteValue(Me._operand)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(UnaryExpressionSyntax), Function(r) New UnaryExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.UnaryExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The token that is the operator.
        ''' </summary>
        Friend  ReadOnly Property OperatorToken As InternalSyntax.SyntaxToken
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The expression being operated on.
        ''' </summary>
        Friend  ReadOnly Property Operand As InternalSyntax.ExpressionSyntax
            Get
                Return Me._operand
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._operatorToken
                Case 1
                    Return Me._operand
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new UnaryExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _operatorToken, _operand)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new UnaryExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _operatorToken, _operand)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitUnaryExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a conditional expression, If(condition, true-expr, false-expr) or
    ''' If(expr, nothing-expr).
    ''' </summary>
    Friend NotInheritable Class BinaryConditionalExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _ifKeyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _firstExpression as ExpressionSyntax
        Friend ReadOnly _commaToken as PunctuationSyntax
        Friend ReadOnly _secondExpression as ExpressionSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, firstExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, secondExpression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 6

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(firstExpression)
            Me._firstExpression = firstExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(secondExpression)
            Me._secondExpression = secondExpression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, firstExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, secondExpression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 6
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(firstExpression)
            Me._firstExpression = firstExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(secondExpression)
            Me._secondExpression = secondExpression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, firstExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, secondExpression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 6

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(firstExpression)
            Me._firstExpression = firstExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(secondExpression)
            Me._secondExpression = secondExpression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 6
          Dim _ifKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _ifKeyword isnot Nothing 
             AdjustFlagsAndWidth(_ifKeyword)
             Me._ifKeyword = _ifKeyword
          End If
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _firstExpression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _firstExpression isnot Nothing 
             AdjustFlagsAndWidth(_firstExpression)
             Me._firstExpression = _firstExpression
          End If
          Dim _commaToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _commaToken isnot Nothing 
             AdjustFlagsAndWidth(_commaToken)
             Me._commaToken = _commaToken
          End If
          Dim _secondExpression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _secondExpression isnot Nothing 
             AdjustFlagsAndWidth(_secondExpression)
             Me._secondExpression = _secondExpression
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New BinaryConditionalExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._ifKeyword)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._firstExpression)
          writer.WriteValue(Me._commaToken)
          writer.WriteValue(Me._secondExpression)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(BinaryConditionalExpressionSyntax), Function(r) New BinaryConditionalExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.BinaryConditionalExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "If" keyword
        ''' </summary>
        Friend  ReadOnly Property IfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._ifKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The first expression inside the parentheses.
        ''' </summary>
        Friend  ReadOnly Property FirstExpression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._firstExpression
            End Get
        End Property

        ''' <summary>
        ''' The "," token.
        ''' </summary>
        Friend  ReadOnly Property CommaToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._commaToken
            End Get
        End Property

        ''' <summary>
        ''' The second expression inside the parentheses.
        ''' </summary>
        Friend  ReadOnly Property SecondExpression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._secondExpression
            End Get
        End Property

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._ifKeyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._firstExpression
                Case 3
                    Return Me._commaToken
                Case 4
                    Return Me._secondExpression
                Case 5
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new BinaryConditionalExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _ifKeyword, _openParenToken, _firstExpression, _commaToken, _secondExpression, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new BinaryConditionalExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _ifKeyword, _openParenToken, _firstExpression, _commaToken, _secondExpression, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitBinaryConditionalExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a conditional expression, If(condition, true-expr, false-expr) or
    ''' If(expr, nothing-expr).
    ''' </summary>
    Friend NotInheritable Class TernaryConditionalExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _ifKeyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _condition as ExpressionSyntax
        Friend ReadOnly _firstCommaToken as PunctuationSyntax
        Friend ReadOnly _whenTrue as ExpressionSyntax
        Friend ReadOnly _secondCommaToken as PunctuationSyntax
        Friend ReadOnly _whenFalse as ExpressionSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, condition As ExpressionSyntax, firstCommaToken As InternalSyntax.PunctuationSyntax, whenTrue As ExpressionSyntax, secondCommaToken As InternalSyntax.PunctuationSyntax, whenFalse As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 8

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(firstCommaToken)
            Me._firstCommaToken = firstCommaToken
            AdjustFlagsAndWidth(whenTrue)
            Me._whenTrue = whenTrue
            AdjustFlagsAndWidth(secondCommaToken)
            Me._secondCommaToken = secondCommaToken
            AdjustFlagsAndWidth(whenFalse)
            Me._whenFalse = whenFalse
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, condition As ExpressionSyntax, firstCommaToken As InternalSyntax.PunctuationSyntax, whenTrue As ExpressionSyntax, secondCommaToken As InternalSyntax.PunctuationSyntax, whenFalse As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 8
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(firstCommaToken)
            Me._firstCommaToken = firstCommaToken
            AdjustFlagsAndWidth(whenTrue)
            Me._whenTrue = whenTrue
            AdjustFlagsAndWidth(secondCommaToken)
            Me._secondCommaToken = secondCommaToken
            AdjustFlagsAndWidth(whenFalse)
            Me._whenFalse = whenFalse
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, condition As ExpressionSyntax, firstCommaToken As InternalSyntax.PunctuationSyntax, whenTrue As ExpressionSyntax, secondCommaToken As InternalSyntax.PunctuationSyntax, whenFalse As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 8

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(firstCommaToken)
            Me._firstCommaToken = firstCommaToken
            AdjustFlagsAndWidth(whenTrue)
            Me._whenTrue = whenTrue
            AdjustFlagsAndWidth(secondCommaToken)
            Me._secondCommaToken = secondCommaToken
            AdjustFlagsAndWidth(whenFalse)
            Me._whenFalse = whenFalse
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 8
          Dim _ifKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _ifKeyword isnot Nothing 
             AdjustFlagsAndWidth(_ifKeyword)
             Me._ifKeyword = _ifKeyword
          End If
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _condition = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _condition isnot Nothing 
             AdjustFlagsAndWidth(_condition)
             Me._condition = _condition
          End If
          Dim _firstCommaToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _firstCommaToken isnot Nothing 
             AdjustFlagsAndWidth(_firstCommaToken)
             Me._firstCommaToken = _firstCommaToken
          End If
          Dim _whenTrue = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _whenTrue isnot Nothing 
             AdjustFlagsAndWidth(_whenTrue)
             Me._whenTrue = _whenTrue
          End If
          Dim _secondCommaToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _secondCommaToken isnot Nothing 
             AdjustFlagsAndWidth(_secondCommaToken)
             Me._secondCommaToken = _secondCommaToken
          End If
          Dim _whenFalse = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _whenFalse isnot Nothing 
             AdjustFlagsAndWidth(_whenFalse)
             Me._whenFalse = _whenFalse
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New TernaryConditionalExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._ifKeyword)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._condition)
          writer.WriteValue(Me._firstCommaToken)
          writer.WriteValue(Me._whenTrue)
          writer.WriteValue(Me._secondCommaToken)
          writer.WriteValue(Me._whenFalse)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(TernaryConditionalExpressionSyntax), Function(r) New TernaryConditionalExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TernaryConditionalExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "If" keyword
        ''' </summary>
        Friend  ReadOnly Property IfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._ifKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The first expression inside the parentheses.
        ''' </summary>
        Friend  ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        ''' <summary>
        ''' The "," token.
        ''' </summary>
        Friend  ReadOnly Property FirstCommaToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._firstCommaToken
            End Get
        End Property

        ''' <summary>
        ''' The second expression inside the parentheses.
        ''' </summary>
        Friend  ReadOnly Property WhenTrue As InternalSyntax.ExpressionSyntax
            Get
                Return Me._whenTrue
            End Get
        End Property

        ''' <summary>
        ''' The "," token.
        ''' </summary>
        Friend  ReadOnly Property SecondCommaToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._secondCommaToken
            End Get
        End Property

        ''' <summary>
        ''' The second expression inside the parentheses.
        ''' </summary>
        Friend  ReadOnly Property WhenFalse As InternalSyntax.ExpressionSyntax
            Get
                Return Me._whenFalse
            End Get
        End Property

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._ifKeyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._condition
                Case 3
                    Return Me._firstCommaToken
                Case 4
                    Return Me._whenTrue
                Case 5
                    Return Me._secondCommaToken
                Case 6
                    Return Me._whenFalse
                Case 7
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TernaryConditionalExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _ifKeyword, _openParenToken, _condition, _firstCommaToken, _whenTrue, _secondCommaToken, _whenFalse, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TernaryConditionalExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _ifKeyword, _openParenToken, _condition, _firstCommaToken, _whenTrue, _secondCommaToken, _whenFalse, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTernaryConditionalExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a lambda expression, either single line or multi-line.
    ''' </summary>
    Friend MustInherit Class LambdaExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _subOrFunctionHeader as LambdaHeaderSyntax

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax)
            MyBase.New(kind)

            AdjustFlagsAndWidth(subOrFunctionHeader)
            Me._subOrFunctionHeader = subOrFunctionHeader

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subOrFunctionHeader)
            Me._subOrFunctionHeader = subOrFunctionHeader

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subOrFunctionHeader As LambdaHeaderSyntax)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(subOrFunctionHeader)
            Me._subOrFunctionHeader = subOrFunctionHeader

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
          Dim _subOrFunctionHeader = DirectCast(reader.ReadValue(), LambdaHeaderSyntax)
          If _subOrFunctionHeader isnot Nothing 
             AdjustFlagsAndWidth(_subOrFunctionHeader)
             Me._subOrFunctionHeader = _subOrFunctionHeader
          End If
        End Sub

        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._subOrFunctionHeader)
        End Sub

        ''' <summary>
        ''' The header part of the lambda that includes the "Sub" or "Function" keyword,
        ''' the argument list and return type.
        ''' </summary>
        Friend  ReadOnly Property SubOrFunctionHeader As InternalSyntax.LambdaHeaderSyntax
            Get
                Return Me._subOrFunctionHeader
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents a single line lambda expression.
    ''' </summary>
    Friend NotInheritable Class SingleLineLambdaExpressionSyntax
        Inherits LambdaExpressionSyntax

        Friend ReadOnly _body as VisualBasicSyntaxNode

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax, body As VisualBasicSyntaxNode)
            MyBase.New(kind, subOrFunctionHeader)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(body)
            Me._body = body

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax, body As VisualBasicSyntaxNode, context As ISyntaxFactoryContext)
            MyBase.New(kind, subOrFunctionHeader)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(body)
            Me._body = body

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subOrFunctionHeader As LambdaHeaderSyntax, body As VisualBasicSyntaxNode)
            MyBase.New(kind, errors, annotations, subOrFunctionHeader)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(body)
            Me._body = body

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _body = DirectCast(reader.ReadValue(), VisualBasicSyntaxNode)
          If _body isnot Nothing 
             AdjustFlagsAndWidth(_body)
             Me._body = _body
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SingleLineLambdaExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._body)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SingleLineLambdaExpressionSyntax), Function(r) New SingleLineLambdaExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SingleLineLambdaExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The body of the lambda. Depending on the kind of lambda, this is either a
        ''' Statement (single-line Sub lambda) or Expression (single-line Function).
        ''' </summary>
        Friend  ReadOnly Property Body As InternalSyntax.VisualBasicSyntaxNode
            Get
                Return Me._body
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._subOrFunctionHeader
                Case 1
                    Return Me._body
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SingleLineLambdaExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _subOrFunctionHeader, _body)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SingleLineLambdaExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _subOrFunctionHeader, _body)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSingleLineLambdaExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a multi-line lambda expression.
    ''' </summary>
    Friend NotInheritable Class MultiLineLambdaExpressionSyntax
        Inherits LambdaExpressionSyntax

        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _endSubOrFunctionStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax)
            MyBase.New(kind, subOrFunctionHeader)
            MyBase._slotCount = 3

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, subOrFunctionHeader)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subOrFunctionHeader As LambdaHeaderSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, subOrFunctionHeader)
            MyBase._slotCount = 3

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _statements = DirectCast(reader.ReadValue(), GreenNode)
          If _statements isnot Nothing 
             AdjustFlagsAndWidth(_statements)
             Me._statements = _statements
          End If
          Dim _endSubOrFunctionStatement = DirectCast(reader.ReadValue(), EndBlockStatementSyntax)
          If _endSubOrFunctionStatement isnot Nothing 
             AdjustFlagsAndWidth(_endSubOrFunctionStatement)
             Me._endSubOrFunctionStatement = _endSubOrFunctionStatement
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New MultiLineLambdaExpressionSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._statements)
          writer.WriteValue(Me._endSubOrFunctionStatement)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(MultiLineLambdaExpressionSyntax), Function(r) New MultiLineLambdaExpressionSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MultiLineLambdaExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The body of the lambda. Depending on the kind of lambda, this is either a
        ''' StatementBody (multi-line lambda), Statement (single-line Sub lambda) or
        ''' Expression (single-line Function). This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' Returns the "End Sub" or "End Function" statement if this is a multi-line
        ''' lambda.
        ''' </summary>
        Friend  ReadOnly Property EndSubOrFunctionStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endSubOrFunctionStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._subOrFunctionHeader
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endSubOrFunctionStatement
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MultiLineLambdaExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _subOrFunctionHeader, _statements, _endSubOrFunctionStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MultiLineLambdaExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _subOrFunctionHeader, _statements, _endSubOrFunctionStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMultiLineLambdaExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the header part of a lambda expression
    ''' </summary>
    Friend NotInheritable Class LambdaHeaderSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _subOrFunctionKeyword as KeywordSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            MyBase._slotCount = 5

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 5
          Dim _subOrFunctionKeyword = DirectCast(reader.ReadValue(), KeywordSyntax)
          If _subOrFunctionKeyword isnot Nothing 
             AdjustFlagsAndWidth(_subOrFunctionKeyword)
             Me._subOrFunctionKeyword = _subOrFunctionKeyword
          End If
          Dim _asClause = DirectCast(reader.ReadValue(), SimpleAsClauseSyntax)
          If _asClause isnot Nothing 
             AdjustFlagsAndWidth(_asClause)
             Me._asClause = _asClause
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New LambdaHeaderSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._subOrFunctionKeyword)
          writer.WriteValue(Me._asClause)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(LambdaHeaderSyntax), Function(r) New LambdaHeaderSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LambdaHeaderSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Sub" or "Function" keyword that introduces this lambda expression.
        ''' </summary>
        Friend  ReadOnly Property SubOrFunctionKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._subOrFunctionKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._subOrFunctionKeyword
                Case 3
                    Return Me._parameterList
                Case 4
                    Return Me._asClause
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LambdaHeaderSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _subOrFunctionKeyword, _parameterList, _asClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LambdaHeaderSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _subOrFunctionKeyword, _parameterList, _asClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLambdaHeader(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a parenthesized argument list.
    ''' </summary>
    Friend NotInheritable Class ArgumentListSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _arguments as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 3
          Dim _openParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _openParenToken isnot Nothing 
             AdjustFlagsAndWidth(_openParenToken)
             Me._openParenToken = _openParenToken
          End If
          Dim _arguments = DirectCast(reader.ReadValue(), GreenNode)
          If _arguments isnot Nothing 
             AdjustFlagsAndWidth(_arguments)
             Me._arguments = _arguments
          End If
          Dim _closeParenToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _closeParenToken isnot Nothing 
             AdjustFlagsAndWidth(_closeParenToken)
             Me._closeParenToken = _closeParenToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New ArgumentListSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._openParenToken)
          writer.WriteValue(Me._arguments)
          writer.WriteValue(Me._closeParenToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(ArgumentListSyntax), Function(r) New ArgumentListSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ArgumentListSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend  ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The list of arguments. This may be empty. Omitted argument are represented by
        ''' an OmittedArgumentSyntax node.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend  ReadOnly Property Arguments As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ArgumentSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ArgumentSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ArgumentSyntax)(Me._arguments))
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend  ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._arguments
                Case 2
                    Return Me._closeParenToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ArgumentListSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _arguments, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ArgumentListSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _arguments, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitArgumentList(Me)
        End Function

    End Class

    ''' <summary>
    ''' Base class for the possible kinds of arguments that can appear in an argument
    ''' list.
    ''' </summary>
    Friend MustInherit Class ArgumentSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
        End Sub

    End Class

    ''' <summary>
    ''' Represents an omitted argument in an argument list. An omitted argument is not
    ''' considered a syntax error but a valid case when no argument is required.
    ''' </summary>
    Friend NotInheritable Class OmittedArgumentSyntax
        Inherits ArgumentSyntax

        Friend ReadOnly _empty as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, empty As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, empty As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), empty As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 1

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 1
          Dim _empty = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _empty isnot Nothing 
             AdjustFlagsAndWidth(_empty)
             Me._empty = _empty
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New OmittedArgumentSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._empty)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(OmittedArgumentSyntax), Function(r) New OmittedArgumentSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OmittedArgumentSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' An empty token because all non terminals must have a token.
        ''' </summary>
        Friend  ReadOnly Property Empty As InternalSyntax.PunctuationSyntax
            Get
                Return Me._empty
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._empty
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OmittedArgumentSyntax(Me.Kind, newErrors, GetAnnotations, _empty)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OmittedArgumentSyntax(Me.Kind, GetDiagnostics, annotations, _empty)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOmittedArgument(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an argument that is just an optional argument name and an
    ''' expression.
    ''' </summary>
    Friend NotInheritable Class SimpleArgumentSyntax
        Inherits ArgumentSyntax

        Friend ReadOnly _nameColonEquals as NameColonEqualsSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, nameColonEquals As NameColonEqualsSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            If nameColonEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameColonEquals)
                Me._nameColonEquals = nameColonEquals
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, nameColonEquals As NameColonEqualsSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            If nameColonEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameColonEquals)
                Me._nameColonEquals = nameColonEquals
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), nameColonEquals As NameColonEqualsSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            If nameColonEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameColonEquals)
                Me._nameColonEquals = nameColonEquals
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _nameColonEquals = DirectCast(reader.ReadValue(), NameColonEqualsSyntax)
          If _nameColonEquals isnot Nothing 
             AdjustFlagsAndWidth(_nameColonEquals)
             Me._nameColonEquals = _nameColonEquals
          End If
          Dim _expression = DirectCast(reader.ReadValue(), ExpressionSyntax)
          If _expression isnot Nothing 
             AdjustFlagsAndWidth(_expression)
             Me._expression = _expression
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New SimpleArgumentSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._nameColonEquals)
          writer.WriteValue(Me._expression)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(SimpleArgumentSyntax), Function(r) New SimpleArgumentSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SimpleArgumentSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The optional name and ":=" prefix of a named argument.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend  ReadOnly Property NameColonEquals As InternalSyntax.NameColonEqualsSyntax
            Get
                Return Me._nameColonEquals
            End Get
        End Property

        ''' <summary>
        ''' The expression that is the argument.
        ''' </summary>
        Friend  ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._nameColonEquals
                Case 1
                    Return Me._expression
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SimpleArgumentSyntax(Me.Kind, newErrors, GetAnnotations, _nameColonEquals, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SimpleArgumentSyntax(Me.Kind, GetDiagnostics, annotations, _nameColonEquals, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSimpleArgument(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an identifier name followed by a ":=" token in a named argument.
    ''' </summary>
    Friend NotInheritable Class NameColonEqualsSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _name as IdentifierNameSyntax
        Friend ReadOnly _colonEqualsToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, name As IdentifierNameSyntax, colonEqualsToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(colonEqualsToken)
            Me._colonEqualsToken = colonEqualsToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, name As IdentifierNameSyntax, colonEqualsToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(colonEqualsToken)
            Me._colonEqualsToken = colonEqualsToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), name As IdentifierNameSyntax, colonEqualsToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            MyBase._slotCount = 2

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(colonEqualsToken)
            Me._colonEqualsToken = colonEqualsToken

        End Sub

        Friend Sub New(reader as ObjectReader)
          MyBase.New(reader)
            MyBase._slotCount = 2
          Dim _name = DirectCast(reader.ReadValue(), IdentifierNameSyntax)
          If _name isnot Nothing 
             AdjustFlagsAndWidth(_name)
             Me._name = _name
          End If
          Dim _colonEqualsToken = DirectCast(reader.ReadValue(), PunctuationSyntax)
          If _colonEqualsToken isnot Nothing 
             AdjustFlagsAndWidth(_colonEqualsToken)
             Me._colonEqualsToken = _colonEqualsToken
          End If
        End Sub
        Friend Shared CreateInstance As Func(Of ObjectReader, Object) = Function(o) New NameColonEqualsSyntax(o)


        Friend Overrides Sub WriteTo(writer as ObjectWriter)
          MyBase.WriteTo(writer)
          writer.WriteValue(Me._name)
          writer.WriteValue(Me._colonEqualsToken)
        End Sub

        Shared Sub New()
          ObjectBinder.RegisterTypeReader(GetType(NameColonEqualsSyntax), Function(r) New NameColonEqualsSyntax(r))
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NameColonEqualsSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The name used to identify the named argument.
        ''' </summary>
        Friend  ReadOnly Property Name As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <summary>
        ''' The ":=" token.
        ''' </summary>
        Friend  ReadOnly Property ColonEqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._colonEqualsToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._name
                Case 1
                    Return Me._colonEqualsToken
                Case Else
                     Debug.Assert(false, "child index out of range")
                     Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NameColonEqualsSyntax(Me.Kind, newErrors, GetAnnotations, _name, _colonEqualsToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NameColonEqualsSyntax(Me.Kind, GetDiagnostics, annotations, _name, _colonEqualsToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNameColonEquals(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a range argument, such as "0 to 5", used in array bounds. The
    ''' "Value" property represents the upper bound of the range.
    ''' </summary>
    Friend NotInheritable Class RangeArgumentSyntax
        Inherits ArgumentSyntax

        Friend ReadOnly _lowerBound as ExpressionSyntax
        Friend ReadOnly _toKeyword as KeywordSyntax
        Friend ReadOnly _upperBound as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax)
            MyBase.New(kind)
            MyBase._slotCount = 3

            AdjustFlagsAndWidth(lowerBound)
            Me._lowerBound = lowerBound
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(upperBound)
            Me._upperBound = upperBound

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            MyBase._slotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lowerBound)
            Me._lowerBound = lowerBound
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(upperBound)
            Me._upperBound = upperBound

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lowerBound As ExpressionSyntax, toKeyword As 