﻿// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Collections.Generic;
using NuGet.Common;

namespace NuGet.ProjectModel
{
    public interface IAssetsLogMessage
    {
        /// <summary>
        /// Level to indicate if this is an error or wanring.
        /// </summary>
        LogLevel Level { get; }

        /// <summary>
        /// Indicates the NuGet error code.
        /// </summary>
        NuGetLogCode Code { get; }

        /// <summary>
        /// Indicates the staring generated by the code to go with the error code.
        /// </summary>
        string Message { get; }

        /// <summary>
        /// Indicates the project for which the error was thrown.
        /// </summary>
        string ProjectPath { get; }

        /// <summary>
        /// Level to indicate the warning level for the message.
        /// This is relevant only if the Level == LogLevel.Warning.
        /// </summary>
        WarningLevel WarningLevel { get; }

        /// <summary>
        /// Indicates the file for which the error was thrown.
        /// </summary>
        string FilePath { get; }

        /// <summary>
        /// Indicates the starting line for which the error was thrown.
        /// </summary>
        int StartLineNumber { get; }

        /// <summary>
        /// Indicates the starting column for which the error was thrown.
        /// </summary>
        int StartColumnNumber { get; }

        /// <summary>
        /// Indicates the ending line for which the error was thrown.
        /// </summary>
        int EndLineNumber { get; }

        /// <summary>
        /// Indicates the ending column for which the error was thrown.
        /// </summary>
        int EndColumnNumber { get; }

        /// <summary>
        /// Project or Package Id
        /// </summary>
        string LibraryId { get; }

        /// <summary>
        /// List of TargetGraphs
        /// </summary>
        IReadOnlyList<string> TargetGraphs { get; }
    }
}
