"""Generated message classes for securitycenter version v1beta1.

Cloud Security Command Center API provides access to temporal views of assets
and findings within an organization.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'securitycenter'


class Asset(_messages.Message):
  r"""Cloud Security Command Center's (Cloud SCC) representation of a Google
  Cloud Platform (GCP) resource.  The Asset is a Cloud SCC resource that
  captures information about a single GCP resource. All modifications to an
  Asset are only within the context of Cloud SCC and don't affect the
  referenced GCP resource.

  Messages:
    ResourcePropertiesValue: Resource managed properties. These properties are
      managed and defined by the GCP resource and cannot be modified by the
      user.

  Fields:
    createTime: The time at which the asset was created in Cloud SCC.
    name: The relative resource name of this asset. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/123/assets/456".
    resourceProperties: Resource managed properties. These properties are
      managed and defined by the GCP resource and cannot be modified by the
      user.
    securityCenterProperties: Cloud SCC managed properties. These properties
      are managed by Cloud SCC and cannot be modified by the user.
    securityMarks: User specified security marks. These marks are entirely
      managed by the user and come from the SecurityMarks resource that
      belongs to the asset.
    updateTime: The time at which the asset was last updated, added, or
      deleted in Cloud SCC.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourcePropertiesValue(_messages.Message):
    r"""Resource managed properties. These properties are managed and defined
    by the GCP resource and cannot be modified by the user.

    Messages:
      AdditionalProperty: An additional property for a ResourcePropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ResourcePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourcePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  resourceProperties = _messages.MessageField('ResourcePropertiesValue', 3)
  securityCenterProperties = _messages.MessageField('SecurityCenterProperties', 4)
  securityMarks = _messages.MessageField('SecurityMarks', 5)
  updateTime = _messages.StringField(6)


class AssetDiscoveryConfig(_messages.Message):
  r"""The configuration used for Asset Discovery runs.

  Enums:
    InclusionModeValueValuesEnum: The mode to use for filtering asset
      discovery.

  Fields:
    inclusionMode: The mode to use for filtering asset discovery.
    projectIds: The project ids to use for filtering asset discovery.
  """

  class InclusionModeValueValuesEnum(_messages.Enum):
    r"""The mode to use for filtering asset discovery.

    Values:
      INCLUSION_MODE_UNSPECIFIED: Unspecified. Setting the mode with this
        value will disable inclusion/exclusion filtering for Asset Discovery.
      INCLUDE_ONLY: Asset Discovery will capture only the resources within the
        projects specified. All other resources will be ignored.
      EXCLUDE: Asset Discovery will ignore all resources under the projects
        specified. All other resources will be retrieved.
    """
    INCLUSION_MODE_UNSPECIFIED = 0
    INCLUDE_ONLY = 1
    EXCLUDE = 2

  inclusionMode = _messages.EnumField('InclusionModeValueValuesEnum', 1)
  projectIds = _messages.StringField(2, repeated=True)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:foo@gmail.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "fooservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:bar@gmail.com"               ]             }           ]         }
  ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: an
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      .   * `serviceAccount:{emailid}`: An email address that represents a
      service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: The G Suite domain (primary) that represents all
      the    users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class Finding(_messages.Message):
  r"""Cloud Security Command Center (Cloud SCC) finding.  A finding is a
  record of assessment data (security, risk, health or privacy) ingested into
  Cloud SCC for presentation, notification, analysis, policy testing, and
  enforcement. For example, an XSS vulnerability in an App Engine application
  is a finding.

  Enums:
    StateValueValuesEnum: The state of the finding.

  Messages:
    SourcePropertiesValue: Source specific properties. These properties are
      managed by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.

  Fields:
    category: The additional taxonomy group within findings from a given
      source. This field is immutable after creation time. Example:
      "XSS_FLASH_INJECTION"
    createTime: The time at which the finding was created in Cloud SCC.
    eventTime: The time at which the event took place. For example, if the
      finding represents an open firewall it would capture the time the open
      firewall was detected.
    externalUri: The URI that, if available, points to a web page outside of
      Cloud SCC where additional information about the finding can be found.
      This field is guaranteed to be either empty or a well formed URL.
    name: The relative resource name of this finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/123/sources/456/findings/789"
    parent: The relative resource name of the source the finding belongs to.
      See: https://cloud.google.com/apis/design/resource_names#relative_resour
      ce_name This field is immutable after creation time. For example:
      "organizations/123/sources/456"
    resourceName: The full resource name of the Google Cloud Platform (GCP)
      resource this finding is for. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
      This field is immutable after creation time.
    securityMarks: Output only. User specified security marks. These marks are
      entirely managed by the user and come from the SecurityMarks resource
      that belongs to the finding.
    sourceProperties: Source specific properties. These properties are managed
      by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.
    state: The state of the finding.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the finding.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: The finding requires attention and has not been addressed yet.
      INACTIVE: The finding has been fixed, triaged as a non-issue or
        otherwise addressed and is no longer active.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SourcePropertiesValue(_messages.Message):
    r"""Source specific properties. These properties are managed by the source
    that writes the finding. The key names in the source_properties map must
    be between 1 and 255 characters, and must start with a letter and contain
    alphanumeric characters or underscores only.

    Messages:
      AdditionalProperty: An additional property for a SourcePropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SourcePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SourcePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  category = _messages.StringField(1)
  createTime = _messages.StringField(2)
  eventTime = _messages.StringField(3)
  externalUri = _messages.StringField(4)
  name = _messages.StringField(5)
  parent = _messages.StringField(6)
  resourceName = _messages.StringField(7)
  securityMarks = _messages.MessageField('SecurityMarks', 8)
  sourceProperties = _messages.MessageField('SourcePropertiesValue', 9)
  state = _messages.EnumField('StateValueValuesEnum', 10)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method."""


class GroupAssetsRequest(_messages.Message):
  r"""Request message for grouping by assets.

  Fields:
    compareDuration: When compare_duration is set, the Asset's "state"
      property is updated to indicate whether the asset was added, removed, or
      remained present during the compare_duration period of time that
      precedes the read_time. This is the time between (read_time -
      compare_duration) and read_time.  The state value is derived based on
      the presence of the asset at the two points in time. Intermediate state
      changes between the two times don't affect the result. For example, the
      results aren't affected if the asset is removed and re-created again.
      Possible "state" values when compare_duration is specified:  * "ADDED":
      indicates that the asset was not present before
      compare_duration, but present at reference_time. * "REMOVED": indicates
      that the asset was present at the start of
      compare_duration, but not present at reference_time. * "ACTIVE":
      indicates that the asset was present at both the              start and
      the end of the time period defined by              compare_duration and
      reference_time.  This field is ignored if `state` is not a field in
      `group_by`.
    filter: Expression that defines the filter to apply across assets. The
      expression is a list of zero or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are not supported, and `OR` has
      higher precedence than `AND`.  Restrictions have the form `<field>
      <operator> <value>` and may have a `-` character in front of them to
      indicate negation. The fields map to those defined in the Asset
      resource. Examples include:  * name *
      security_center_properties.resource_name *
      resource_properties.a_property * security_marks.marks.marka  The
      supported operators are:  * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are:  * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes.  For example, `resource_properties.size = 100` is a valid filter
      string.
    groupBy: Expression that defines what assets fields to use for grouping.
      The string value should follow SQL syntax: comma separated list of
      fields. For example: "security_center_properties.resource_project,securi
      ty_center_properties.project".  The following fields are supported when
      compare_duration is not set:  *
      security_center_properties.resource_project *
      security_center_properties.resource_type *
      security_center_properties.resource_parent  The following fields are
      supported when compare_duration is set:  *
      security_center_properties.resource_type
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `GroupAssetsResponse`; indicates
      that this is a continuation of a prior `GroupAssets` call, and that the
      system should return the next page of data.
    readTime: Time used as a reference point when filtering assets. The filter
      is limited to assets existing at the supplied time and their values are
      those at that specific time. Absence of this field will default to the
      API's version of NOW.
  """

  compareDuration = _messages.StringField(1)
  filter = _messages.StringField(2)
  groupBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  readTime = _messages.StringField(6)


class GroupAssetsResponse(_messages.Message):
  r"""Response message for grouping by assets.

  Fields:
    groupByResults: Group results. There exists an element for each existing
      unique combination of property/values. The element contains a count for
      the number of times those specific property/values appear.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
    readTime: Time used for executing the groupBy request.
  """

  groupByResults = _messages.MessageField('GroupResult', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  readTime = _messages.StringField(3)


class GroupFindingsRequest(_messages.Message):
  r"""Request message for grouping by findings.

  Fields:
    filter: Expression that defines the filter to apply across findings. The
      expression is a list of one or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are not supported, and `OR` has
      higher precedence than `AND`.  Restrictions have the form `<field>
      <operator> <value>` and may have a `-` character in front of them to
      indicate negation. Examples include:   * name  *
      source_properties.a_property  * security_marks.marks.marka  The
      supported operators are:  * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are:  * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes.  For example, `source_properties.size = 100` is a valid filter
      string.
    groupBy: Expression that defines what assets fields to use for grouping
      (including `state`). The string value should follow SQL syntax: comma
      separated list of fields. For example: "parent,resource_name".  The
      following fields are supported:  * resource_name * category * state *
      parent
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `GroupFindingsResponse`;
      indicates that this is a continuation of a prior `GroupFindings` call,
      and that the system should return the next page of data.
    readTime: Time used as a reference point when filtering findings. The
      filter is limited to findings existing at the supplied time and their
      values are those at that specific time. Absence of this field will
      default to the API's version of NOW.
  """

  filter = _messages.StringField(1)
  groupBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  readTime = _messages.StringField(5)


class GroupFindingsResponse(_messages.Message):
  r"""Response message for group by findings.

  Fields:
    groupByResults: Group results. There exists an element for each existing
      unique combination of property/values. The element contains a count for
      the number of times those specific property/values appear.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
    readTime: Time used for executing the groupBy request.
  """

  groupByResults = _messages.MessageField('GroupResult', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  readTime = _messages.StringField(3)


class GroupResult(_messages.Message):
  r"""Result containing the properties and count of a groupBy request.

  Messages:
    PropertiesValue: Properties matching the groupBy fields in the request.

  Fields:
    count: Total count of resources for the given properties.
    properties: Properties matching the groupBy fields in the request.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Properties matching the groupBy fields in the request.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  count = _messages.IntegerField(1)
  properties = _messages.MessageField('PropertiesValue', 2)


class ListAssetsResponse(_messages.Message):
  r"""Response message for listing assets.

  Fields:
    listAssetsResults: Assets matching the list request.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
    readTime: Time used for executing the list request.
    totalSize: The total number of assets matching the query.
  """

  listAssetsResults = _messages.MessageField('ListAssetsResult', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  readTime = _messages.StringField(3)
  totalSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ListAssetsResult(_messages.Message):
  r"""Result containing the Asset and its State.

  Enums:
    StateValueValuesEnum: State of the asset.

  Fields:
    asset: Asset matching the search request.
    state: State of the asset.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the asset.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      UNUSED: Request did not specify use of this field in the result.
      ADDED: Asset was added between the points in time.
      REMOVED: Asset was removed between the points in time.
      ACTIVE: Asset was active at both point(s) in time.
    """
    STATE_UNSPECIFIED = 0
    UNUSED = 1
    ADDED = 2
    REMOVED = 3
    ACTIVE = 4

  asset = _messages.MessageField('Asset', 1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class ListFindingsResponse(_messages.Message):
  r"""Response message for listing findings.

  Fields:
    findings: Findings matching the list request.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
    readTime: Time used for executing the list request.
    totalSize: The total number of findings matching the query.
  """

  findings = _messages.MessageField('Finding', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  readTime = _messages.StringField(3)
  totalSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListSourcesResponse(_messages.Message):
  r"""Response message for listing sources.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
    sources: Sources belonging to the requested parent.
  """

  nextPageToken = _messages.StringField(1)
  sources = _messages.MessageField('Source', 2, repeated=True)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OrganizationSettings(_messages.Message):
  r"""User specified settings that are attached to the Cloud Security Command
  Center (Cloud SCC) organization.

  Fields:
    assetDiscoveryConfig: The configuration used for Asset Discovery runs.
    enableAssetDiscovery: A flag that indicates if Asset Discovery should be
      enabled. If the flag is set to `true`, then discovery of assets will
      occur. If it is set to `false, all historical assets will remain, but
      discovery of future assets will not occur.
    name: The relative resource name of the settings. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/123/organizationSettings".
  """

  assetDiscoveryConfig = _messages.MessageField('AssetDiscoveryConfig', 1)
  enableAssetDiscovery = _messages.BooleanField(2)
  name = _messages.StringField(3)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    version: Deprecated.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class RunAssetDiscoveryRequest(_messages.Message):
  r"""Request message for running asset discovery for an organization."""


class SecurityCenterProperties(_messages.Message):
  r"""Cloud SCC managed properties. These properties are managed by Cloud SCC
  and cannot be modified by the user.

  Fields:
    resourceName: The full resource name of the GCP resource this asset
      represents. This field is immutable after create time. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceOwners: Owners of the Google Cloud resource.
    resourceParent: The full resource name of the immediate parent of the
      resource. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceProject: The full resource name of the project the resource
      belongs to. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceType: The type of the GCP resource. Examples include: APPLICATION,
      PROJECT, and ORGANIZATION. This is a case insensitive field defined by
      Cloud SCC and/or the producer of the resource and is immutable after
      create time.
  """

  resourceName = _messages.StringField(1)
  resourceOwners = _messages.StringField(2, repeated=True)
  resourceParent = _messages.StringField(3)
  resourceProject = _messages.StringField(4)
  resourceType = _messages.StringField(5)


class SecurityMarks(_messages.Message):
  r"""User specified security marks that are attached to the parent Cloud
  Security Command Center (Cloud SCC) resource. Security marks are scoped
  within a Cloud SCC organization -- they can be modified and viewed by all
  users who have proper permissions on the organization.

  Messages:
    MarksValue: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows:   - Keys and values are treated as
      case insensitive   - Keys must be between 1 - 256 characters (inclusive)
      - Keys must be letters, numbers, underscores, or dashes   - Values have
      leading and trailing whitespace trimmed, remaining     characters must
      be between 1 - 4096 characters (inclusive)

  Fields:
    marks: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows:   - Keys and values are treated as
      case insensitive   - Keys must be between 1 - 256 characters (inclusive)
      - Keys must be letters, numbers, underscores, or dashes   - Values have
      leading and trailing whitespace trimmed, remaining     characters must
      be between 1 - 4096 characters (inclusive)
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples: "organizations/123/assets/456/securityMarks"
      "organizations/123/sources/456/findings/789/securityMarks".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MarksValue(_messages.Message):
    r"""Mutable user specified security marks belonging to the parent
    resource. Constraints are as follows:   - Keys and values are treated as
    case insensitive   - Keys must be between 1 - 256 characters (inclusive)
    - Keys must be letters, numbers, underscores, or dashes   - Values have
    leading and trailing whitespace trimmed, remaining     characters must be
    between 1 - 4096 characters (inclusive)

    Messages:
      AdditionalProperty: An additional property for a MarksValue object.

    Fields:
      additionalProperties: Additional properties of type MarksValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MarksValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  marks = _messages.MessageField('MarksValue', 1)
  name = _messages.StringField(2)


class SecuritycenterOrganizationsAssetsGroupRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsAssetsGroupRequest object.

  Fields:
    groupAssetsRequest: A GroupAssetsRequest resource to be passed as the
      request body.
    parent: Name of the organization to groupBy. Its format is
      "organizations/[organization_id]".
  """

  groupAssetsRequest = _messages.MessageField('GroupAssetsRequest', 1)
  parent = _messages.StringField(2, required=True)


class SecuritycenterOrganizationsAssetsListRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsAssetsListRequest object.

  Fields:
    compareDuration: When compare_duration is set, the ListAssetResult's
      "state" attribute is updated to indicate whether the asset was added,
      removed, or remained present during the compare_duration period of time
      that precedes the read_time. This is the time between (read_time -
      compare_duration) and read_time.  The state value is derived based on
      the presence of the asset at the two points in time. Intermediate state
      changes between the two times don't affect the result. For example, the
      results aren't affected if the asset is removed and re-created again.
      Possible "state" values when compare_duration is specified:  * "ADDED":
      indicates that the asset was not present before
      compare_duration, but present at read_time. * "REMOVED": indicates that
      the asset was present at the start of              compare_duration, but
      not present at read_time. * "ACTIVE": indicates that the asset was
      present at both the              start and the end of the time period
      defined by              compare_duration and read_time.  If
      compare_duration is not specified, then the only possible state is
      "UNUSED", which indicates that the asset is present at read_time.
    fieldMask: Optional.  A field mask to specify the ListAssetsResult fields
      to be listed in the response. An empty field mask will list all fields.
    filter: Expression that defines the filter to apply across assets. The
      expression is a list of zero or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are not supported, and `OR` has
      higher precedence than `AND`.  Restrictions have the form `<field>
      <operator> <value>` and may have a `-` character in front of them to
      indicate negation. The fields map to those defined in the Asset
      resource. Examples include:  * name *
      security_center_properties.resource_name *
      resource_properties.a_property * security_marks.marks.marka  The
      supported operators are:  * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are:  * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes.  For example, `resource_properties.size = 100` is a valid filter
      string.
    orderBy: Expression that defines what fields and order to use for sorting.
      The string value should follow SQL syntax: comma separated list of
      fields. For example: "name,resource_properties.a_property". The default
      sorting order is ascending. To specify descending order for a field, a
      suffix " desc" should be appended to the field name. For example: "name
      desc,resource_properties.a_property". Redundant space characters in the
      syntax are insignificant. "name desc,resource_properties.a_property" and
      " name     desc  ,   resource_properties.a_property  " are equivalent.
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListAssetsResponse`; indicates
      that this is a continuation of a prior `ListAssets` call, and that the
      system should return the next page of data.
    parent: Name of the organization assets should belong to. Its format is
      "organizations/[organization_id]".
    readTime: Time used as a reference point when filtering assets. The filter
      is limited to assets existing at the supplied time and their values are
      those at that specific time. Absence of this field will default to the
      API's version of NOW.
  """

  compareDuration = _messages.StringField(1)
  fieldMask = _messages.StringField(2)
  filter = _messages.StringField(3)
  orderBy = _messages.StringField(4)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)
  parent = _messages.StringField(7, required=True)
  readTime = _messages.StringField(8)


class SecuritycenterOrganizationsAssetsRunDiscoveryRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsAssetsRunDiscoveryRequest object.

  Fields:
    parent: Name of the organization to run asset discovery for. Its format is
      "organizations/[organization_id]".
    runAssetDiscoveryRequest: A RunAssetDiscoveryRequest resource to be passed
      as the request body.
  """

  parent = _messages.StringField(1, required=True)
  runAssetDiscoveryRequest = _messages.MessageField('RunAssetDiscoveryRequest', 2)


class SecuritycenterOrganizationsAssetsUpdateSecurityMarksRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsAssetsUpdateSecurityMarksRequest object.

  Fields:
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples: "organizations/123/assets/456/securityMarks"
      "organizations/123/sources/456/findings/789/securityMarks".
    securityMarks: A SecurityMarks resource to be passed as the request body.
    startTime: The time at which the updated SecurityMarks take effect.
    updateMask: The FieldMask to use when updating the security marks
      resource.
  """

  name = _messages.StringField(1, required=True)
  securityMarks = _messages.MessageField('SecurityMarks', 2)
  startTime = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class SecuritycenterOrganizationsGetOrganizationSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetOrganizationSettingsRequest object.

  Fields:
    name: Name of the organization to get organization settings for. Its
      format is "organizations/[organization_id]/organizationSettings".
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsOperationsCancelRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class SecuritycenterOrganizationsOperationsDeleteRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsOperationsGetRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsOperationsListRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class SecuritycenterOrganizationsSourcesCreateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesCreateRequest object.

  Fields:
    parent: Resource name of the new source's parent. Its format should be
      "organizations/[organization_id]".
    source: A Source resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  source = _messages.MessageField('Source', 2)


class SecuritycenterOrganizationsSourcesFindingsCreateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsCreateRequest object.

  Fields:
    finding: A Finding resource to be passed as the request body.
    findingId: Unique identifier provided by the client within the parent
      scope. It must be alphanumeric and less than or equal to 32 characters
      and greater than 0 characters in length.
    parent: Resource name of the new finding's parent. Its format should be
      "organizations/[organization_id]/sources/[source_id]".
  """

  finding = _messages.MessageField('Finding', 1)
  findingId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycenterOrganizationsSourcesFindingsGroupRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsGroupRequest object.

  Fields:
    groupFindingsRequest: A GroupFindingsRequest resource to be passed as the
      request body.
    parent: Name of the source to groupBy. Its format is
      "organizations/[organization_id]/sources/[source_id]". To groupBy across
      all sources provide a source_id of `-`. For example:
      organizations/123/sources/-
  """

  groupFindingsRequest = _messages.MessageField('GroupFindingsRequest', 1)
  parent = _messages.StringField(2, required=True)


class SecuritycenterOrganizationsSourcesFindingsListRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsListRequest object.

  Fields:
    fieldMask: Optional.  A field mask to specify the Finding fields to be
      listed in the response. An empty field mask will list all fields.
    filter: Expression that defines the filter to apply across findings. The
      expression is a list of one or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are not supported, and `OR` has
      higher precedence than `AND`.  Restrictions have the form `<field>
      <operator> <value>` and may have a `-` character in front of them to
      indicate negation. Examples include:   * name  *
      source_properties.a_property  * security_marks.marks.marka  The
      supported operators are:  * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are:  * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes.  For example, `source_properties.size = 100` is a valid filter
      string.
    orderBy: Expression that defines what fields and order to use for sorting.
      The string value should follow SQL syntax: comma separated list of
      fields. For example: "name,resource_properties.a_property". The default
      sorting order is ascending. To specify descending order for a field, a
      suffix " desc" should be appended to the field name. For example: "name
      desc,source_properties.a_property". Redundant space characters in the
      syntax are insignificant. "name desc,source_properties.a_property" and "
      name     desc  ,   source_properties.a_property  " are equivalent.
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListFindingsResponse`;
      indicates that this is a continuation of a prior `ListFindings` call,
      and that the system should return the next page of data.
    parent: Name of the source the findings belong to. Its format is
      "organizations/[organization_id]/sources/[source_id]". To list across
      all sources provide a source_id of `-`. For example:
      organizations/123/sources/-
    readTime: Time used as a reference point when filtering findings. The
      filter is limited to findings existing at the supplied time and their
      values are those at that specific time. Absence of this field will
      default to the API's version of NOW.
  """

  fieldMask = _messages.StringField(1)
  filter = _messages.StringField(2)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  parent = _messages.StringField(6, required=True)
  readTime = _messages.StringField(7)


class SecuritycenterOrganizationsSourcesFindingsPatchRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsPatchRequest object.

  Fields:
    finding: A Finding resource to be passed as the request body.
    name: The relative resource name of this finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/123/sources/456/findings/789"
    updateMask: The FieldMask to use when updating the finding resource. This
      field should not be specified when creating a finding.
  """

  finding = _messages.MessageField('Finding', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsSourcesFindingsSetStateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsSetStateRequest object.

  Fields:
    name: The relative resource name of the finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/123/sources/456/finding/789".
    setFindingStateRequest: A SetFindingStateRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  setFindingStateRequest = _messages.MessageField('SetFindingStateRequest', 2)


class SecuritycenterOrganizationsSourcesFindingsUpdateSecurityMarksRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsUpdateSecurityMarksRequest
  object.

  Fields:
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples: "organizations/123/assets/456/securityMarks"
      "organizations/123/sources/456/findings/789/securityMarks".
    securityMarks: A SecurityMarks resource to be passed as the request body.
    startTime: The time at which the updated SecurityMarks take effect.
    updateMask: The FieldMask to use when updating the security marks
      resource.
  """

  name = _messages.StringField(1, required=True)
  securityMarks = _messages.MessageField('SecurityMarks', 2)
  startTime = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class SecuritycenterOrganizationsSourcesGetIamPolicyRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class SecuritycenterOrganizationsSourcesGetRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesGetRequest object.

  Fields:
    name: Relative resource name of the source. Its format is
      "organizations/[organization_id]/source/[source_id]".
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsSourcesListRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesListRequest object.

  Fields:
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListSourcesResponse`; indicates
      that this is a continuation of a prior `ListSources` call, and that the
      system should return the next page of data.
    parent: Resource name of the parent of sources to list. Its format should
      be "organizations/[organization_id]".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycenterOrganizationsSourcesPatchRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesPatchRequest object.

  Fields:
    name: The relative resource name of this source. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/123/sources/456"
    source: A Source resource to be passed as the request body.
    updateMask: The FieldMask to use when updating the source resource.
  """

  name = _messages.StringField(1, required=True)
  source = _messages.MessageField('Source', 2)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsSourcesSetIamPolicyRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class SecuritycenterOrganizationsSourcesTestIamPermissionsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class SecuritycenterOrganizationsUpdateOrganizationSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsUpdateOrganizationSettingsRequest object.

  Fields:
    name: The relative resource name of the settings. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/123/organizationSettings".
    organizationSettings: A OrganizationSettings resource to be passed as the
      request body.
    updateMask: The FieldMask to use when updating the settings resource.
  """

  name = _messages.StringField(1, required=True)
  organizationSettings = _messages.MessageField('OrganizationSettings', 2)
  updateMask = _messages.StringField(3)


class SetFindingStateRequest(_messages.Message):
  r"""Request message for updating a finding's state.

  Enums:
    StateValueValuesEnum: The desired State of the finding.

  Fields:
    startTime: The time at which the updated state takes effect.
    state: The desired State of the finding.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The desired State of the finding.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: The finding requires attention and has not been addressed yet.
      INACTIVE: The finding has been fixed, triaged as a non-issue or
        otherwise addressed and is no longer active.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  startTime = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class Source(_messages.Message):
  r"""Cloud Security Command Center's (Cloud SCC) finding source. A finding
  source is an entity or a mechanism that can produce a finding. A source is
  like a container of findings that come from the same scanner, logger,
  monitor, etc.

  Fields:
    description: The description of the source (max of 1024 characters).
      Example: "Cloud Security Scanner is a web security scanner for common
      vulnerabilities in App Engine applications. It can automatically scan
      and detect four common vulnerabilities, including cross-site-scripting
      (XSS), Flash injection, mixed content (HTTP in HTTPS), and
      outdated/insecure libraries."
    displayName: The source's display name. A source's display name must be
      unique amongst its siblings, for example, two sources with the same
      parent can't share the same display name. The display name must start
      and end with a letter or digit, may contain letters, digits, spaces,
      hyphens, and underscores, and can be no longer than 32 characters. This
      is captured by the regular expression: [\p{L}\p{N}]({\p{L}\p{N}_-
      ]{0,30}[\p{L}\p{N}])?.
    name: The relative resource name of this source. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/123/sources/456"
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  name = _messages.StringField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
