"""Generated message classes for alloydb version v1alpha1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'alloydb'


class AlloydbProjectsLocationsBackupsGetIamPolicyRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsBackupsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AlloydbProjectsLocationsBackupsSetIamPolicyRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsBackupsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class AlloydbProjectsLocationsBackupsTestIamPermissionsRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsBackupsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class AlloydbProjectsLocationsClustersBackupsCreateRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersBackupsCreateRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    backupId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and backup_id from the method_signature
      of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  backup = _messages.MessageField('Backup', 1)
  backupId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class AlloydbProjectsLocationsClustersBackupsDeleteRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersBackupsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class AlloydbProjectsLocationsClustersBackupsGetRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersBackupsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsClustersBackupsListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersBackupsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListBackupsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AlloydbProjectsLocationsClustersBackupsPatchRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersBackupsPatchRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    name: Output only. The name of the backup resource with the format: * proj
      ects/{project}/locations/{region}/clusters/{cluster_id}/backups/{backup_
      id} where the cluster and backup ID segments should satisfy the regex
      expression "[a-z0-9-]+". For more details see
      https://google.aip.dev/122. The prefix of the backup resource name is
      the name of the parent resource: *
      projects/{project}/locations/{region}/clusters/{cluster_id}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Backup resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  backup = _messages.MessageField('Backup', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class AlloydbProjectsLocationsClustersCreateRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and cluster_id from the method_signature
      of Create RPC
    parent: Required. The name of the parent resource. For the required
      format, see the comment on the Cluster.name field.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class AlloydbProjectsLocationsClustersDeleteRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersDeleteRequest object.

  Fields:
    force: Optional. Whether to cascade delete child instances for given
      cluster.
    name: Required. The name of the resource. For the required format, see the
      comment on the Cluster.name field.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class AlloydbProjectsLocationsClustersFailoverRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersFailoverRequest object.

  Fields:
    failoverClusterRequest: A FailoverClusterRequest resource to be passed as
      the request body.
    name: Required. The name of the resource. For the required format, see the
      comment on the Cluster.name field.
  """

  failoverClusterRequest = _messages.MessageField('FailoverClusterRequest', 1)
  name = _messages.StringField(2, required=True)


class AlloydbProjectsLocationsClustersGetIamPolicyRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AlloydbProjectsLocationsClustersGetRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersGetRequest object.

  Fields:
    name: Required. The name of the resource. For the required format, see the
      comment on the Cluster.name field.
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsClustersImportClusterRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersImportClusterRequest object.

  Fields:
    backupSource_backupName: Required. The name of the backup resource with
      the format: * projects/{project}/locations/{region}/clusters/{cluster_id
      }/backups/{backup_id}
    cluster: A Cluster resource to be passed as the request body.
    clusterId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and cluster_id from the method_signature
      of Create RPC
    parent: Required. The name of the parent resource. For the required
      format, see the comment on the Cluster.name field.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  backupSource_backupName = _messages.StringField(1)
  cluster = _messages.MessageField('Cluster', 2)
  clusterId = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class AlloydbProjectsLocationsClustersInstancesBatchCreateRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesBatchCreateRequest object.

  Fields:
    createInstanceRequests: A CreateInstanceRequests resource to be passed as
      the request body.
    parent: Required. The name of the parent resource.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  createInstanceRequests = _messages.MessageField('CreateInstanceRequests', 1)
  parent = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class AlloydbProjectsLocationsClustersInstancesCreateRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesCreateRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    instanceId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and instance_id from the method_signature
      of Create RPC
    parent: Required. The name of the parent resource. For the required
      format, see the comment on the Instance.name field.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  instance = _messages.MessageField('Instance', 1)
  instanceId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class AlloydbProjectsLocationsClustersInstancesDeleteRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesDeleteRequest object.

  Fields:
    name: Required. The name of the resource. For the required format, see the
      comment on the Instance.name field.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class AlloydbProjectsLocationsClustersInstancesFailoverRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesFailoverRequest object.

  Fields:
    failoverInstanceRequest: A FailoverInstanceRequest resource to be passed
      as the request body.
    name: Required. The name of the resource. For the required format, see the
      comment on the Instance.name field.
  """

  failoverInstanceRequest = _messages.MessageField('FailoverInstanceRequest', 1)
  name = _messages.StringField(2, required=True)


class AlloydbProjectsLocationsClustersInstancesGetRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesGetRequest object.

  Fields:
    name: Required. The name of the resource. For the required format, see the
      comment on the Instance.name field.
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsClustersInstancesListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. The name of the parent resource. For the required
      format, see the comment on the Instance.name field. Additionally, you
      can perform an aggregated list operation by specifying a value with one
      of the following formats: * projects/{project}/locations/-/clusters/- *
      projects/{project}/locations/{region}/clusters/-
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AlloydbProjectsLocationsClustersInstancesPatchRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesPatchRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    name: Output only. The name of the instance resource with the format: * pr
      ojects/{project}/locations/{region}/clusters/{cluster_id}/instances/{ins
      tance_id} where the cluster and instance ID segments should satisfy the
      regex expression "[a-z0-9-]+". For more details see
      https://google.aip.dev/122. The prefix of the instance resource name is
      the name of the parent resource: *
      projects/{project}/locations/{region}/clusters/{cluster_id}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Instance resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  instance = _messages.MessageField('Instance', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class AlloydbProjectsLocationsClustersInstancesRestartRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesRestartRequest object.

  Fields:
    name: Required. The name of the resource. For the required format, see the
      comment on the Instance.name field.
    restartInstanceRequest: A RestartInstanceRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  restartInstanceRequest = _messages.MessageField('RestartInstanceRequest', 2)


class AlloydbProjectsLocationsClustersListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. The name of the parent resource. For the required
      format, see the comment on the Cluster.name field. Additionally, you can
      perform an aggregated list operation by specifying a value with the
      following format: * projects/{project}/locations/-
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AlloydbProjectsLocationsClustersPatchRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersPatchRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    name: Output only. The name of the cluster resource with the format: *
      projects/{project}/locations/{region}/clusters/{cluster_id} where the
      cluster ID segment should satisfy the regex expression "[a-z0-9-]+". For
      more details see https://google.aip.dev/122. The prefix of the cluster
      resource name is the name of the parent resource: *
      projects/{project}/locations/{region}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Cluster resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  cluster = _messages.MessageField('Cluster', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class AlloydbProjectsLocationsClustersSetIamPolicyRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class AlloydbProjectsLocationsClustersTestIamPermissionsRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class AlloydbProjectsLocationsClustersUsersCreateRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersUsersCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    user: A User resource to be passed as the request body.
    userId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and user_id from the method_signature of
      Create RPC
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  user = _messages.MessageField('User', 3)
  userId = _messages.StringField(4)


class AlloydbProjectsLocationsClustersUsersDeleteRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersUsersDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class AlloydbProjectsLocationsClustersUsersGetRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersUsersGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsClustersUsersListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersUsersListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListUsersRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AlloydbProjectsLocationsClustersUsersPatchRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersUsersPatchRequest object.

  Fields:
    name: Output only. name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the User resource by the update. The fields specified in
      the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
    user: A User resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  updateMask = _messages.StringField(3)
  user = _messages.MessageField('User', 4)


class AlloydbProjectsLocationsGetRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsInstancesGetIamPolicyRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsInstancesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AlloydbProjectsLocationsInstancesSetIamPolicyRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsInstancesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class AlloydbProjectsLocationsInstancesTestIamPermissionsRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsInstancesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class AlloydbProjectsLocationsListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AlloydbProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class AlloydbProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AlloydbProjectsLocationsSupportedDatabaseFlagsListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsSupportedDatabaseFlagsListRequest object.

  Fields:
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. The name of the parent resource. The required format is:
      * projects/{project}/locations/{location} Regardless of the parent
      specified here, as long it is contains a valid project and location, the
      service will return a static list of supported flags resources.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AlloydbProjectsLocationsUsersGetIamPolicyRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsUsersGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AlloydbProjectsLocationsUsersSetIamPolicyRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsUsersSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class AlloydbProjectsLocationsUsersTestIamPermissionsRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsUsersTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Backup(_messages.Message):
  r"""Message describing Backup object

  Enums:
    StateValueValuesEnum: Output only. The current state of the backup.
    TypeValueValuesEnum: The backup type, which suggests the trigger for the
      backup.

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. Create time stamp
    labels: Labels as key value pairs
    name: Output only. The name of the backup resource with the format: * proj
      ects/{project}/locations/{region}/clusters/{cluster_id}/backups/{backup_
      id} where the cluster and backup ID segments should satisfy the regex
      expression "[a-z0-9-]+". For more details see
      https://google.aip.dev/122. The prefix of the backup resource name is
      the name of the parent resource: *
      projects/{project}/locations/{region}/clusters/{cluster_id}
    state: Output only. The current state of the backup.
    type: The backup type, which suggests the trigger for the backup.
    updateTime: Output only. Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the backup.

    Values:
      STATE_UNSPECIFIED: The state of the backup is unknown.
      READY: The backup is ready.
      CREATING: The backup is creating.
      FAILED: The backup failed.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    CREATING = 2
    FAILED = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""The backup type, which suggests the trigger for the backup.

    Values:
      TYPE_UNSPECIFIED: <no description>
      ON_DEMAND: ON_DEMAND backups that were triggered by the customer (e.g.,
        not AUTOMATED).
      AUTOMATED: AUTOMATED backups triggered by the backup scheduler.
    """
    TYPE_UNSPECIFIED = 0
    ON_DEMAND = 1
    AUTOMATED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  type = _messages.EnumField('TypeValueValuesEnum', 5)
  updateTime = _messages.StringField(6)


class BatchCreateInstanceStatus(_messages.Message):
  r"""Message for current status of an instance in the BatchCreateInstances
  operation. For example, lets say a BatchCreateInstances workflow has 4
  instances, Instance1 through Instance4. Lets also assume that 2 instances
  succeeded but the third failed to create and the 4th was never picked up for
  creation because of failure of the previous one. Then, resulting states
  would look something like: 1. Instance1 = ROLLED_BACK 2. Instance2 =
  ROLLED_BACK 3. Instance3 = FAILED 4. Instance4 = PENDING_CREATE However,
  while the operation is running, the instance might be in other states
  including ACTIVE, DELETING and CREATING.

  Enums:
    StateValueValuesEnum: The current state of an instance involved in the
      batch create operation. Once the operation is complete, the final state
      of the instances in the LRO can be one of: 1. ACTIVE, indicating that
      instances were created successfully 2. FAILED, indicating that a
      particular instance failed creation 3. ROLLED_BACK indicating that
      although the instance was created successfully, it had to be rolled back
      and deleted due to failure in other steps of the workflow. 4.
      PENDING_CREATE, indicating that the instance was never picked up for
      creation due to some error in a preceding operation that caused the
      BatchCreateInstances operation to stop.
    TypeValueValuesEnum:

  Fields:
    errorMsg: Error, if any error occurred and is available, during instance
      creation.
    state: The current state of an instance involved in the batch create
      operation. Once the operation is complete, the final state of the
      instances in the LRO can be one of: 1. ACTIVE, indicating that instances
      were created successfully 2. FAILED, indicating that a particular
      instance failed creation 3. ROLLED_BACK indicating that although the
      instance was created successfully, it had to be rolled back and deleted
      due to failure in other steps of the workflow. 4. PENDING_CREATE,
      indicating that the instance was never picked up for creation due to
      some error in a preceding operation that caused the BatchCreateInstances
      operation to stop.
    type: A TypeValueValuesEnum attribute.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of an instance involved in the batch create
    operation. Once the operation is complete, the final state of the
    instances in the LRO can be one of: 1. ACTIVE, indicating that instances
    were created successfully 2. FAILED, indicating that a particular instance
    failed creation 3. ROLLED_BACK indicating that although the instance was
    created successfully, it had to be rolled back and deleted due to failure
    in other steps of the workflow. 4. PENDING_CREATE, indicating that the
    instance was never picked up for creation due to some error in a preceding
    operation that caused the BatchCreateInstances operation to stop.

    Values:
      STATE_UNSPECIFIED: The state of the instance is unknown.
      PENDING_CREATE: Instance is pending creation and has not yet been picked
        up for processsing in the backend.
      ACTIVE: The instance is active and running.
      CREATING: The instance is being created.
      DELETING: The instance is being deleted.
      FAILED: The creation of the instance failed or a fatal error occurred
        during an operation on the instance.
      ROLLED_BACK: The instance was created successfully, but was rolled back
        and deleted due to some other failure during BatchCreateInstances
        operation.
    """
    STATE_UNSPECIFIED = 0
    PENDING_CREATE = 1
    ACTIVE = 2
    CREATING = 3
    DELETING = 4
    FAILED = 5
    ROLLED_BACK = 6

  class TypeValueValuesEnum(_messages.Enum):
    r"""TypeValueValuesEnum enum type.

    Values:
      INSTANCE_TYPE_UNSPECIFIED: <no description>
      PRIMARY: PRIMARY instances support read and write operations.
      READ: READ instances support read operations only. Each read instance
        consists of one or more homogeneous read replicas. * READ instance of
        size 1 can only have zonal availability. * READ instances with replica
        count of 2 or more can have regional availability (replicas are
        present in 2 or more zones in a region).
    """
    INSTANCE_TYPE_UNSPECIFIED = 0
    PRIMARY = 1
    READ = 2

  errorMsg = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class BatchCreateInstancesMetadata(_messages.Message):
  r"""Message for metadata that is specific to BatchCreateInstances API.

  Messages:
    InstanceStatusesValue: A map representing current state of the instances
      involved in the BatchCreateInstances operation. The instance state will
      be in STATE_UNSPECIFIED state if the instance has not yet been picked up
      for processing. The key of the map is the name of the instance resource.
      For the required format, see the comment on the Instance.name field.

  Fields:
    instanceStatuses: A map representing current state of the instances
      involved in the BatchCreateInstances operation. The instance state will
      be in STATE_UNSPECIFIED state if the instance has not yet been picked up
      for processing. The key of the map is the name of the instance resource.
      For the required format, see the comment on the Instance.name field.
    instanceTargets: The instances being created in the API call. Each string
      in this list is the server defined resource path for target instances in
      the request and for the format of each string, see the comment on the
      Instance.name field.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InstanceStatusesValue(_messages.Message):
    r"""A map representing current state of the instances involved in the
    BatchCreateInstances operation. The instance state will be in
    STATE_UNSPECIFIED state if the instance has not yet been picked up for
    processing. The key of the map is the name of the instance resource. For
    the required format, see the comment on the Instance.name field.

    Messages:
      AdditionalProperty: An additional property for a InstanceStatusesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        InstanceStatusesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InstanceStatusesValue object.

      Fields:
        key: Name of the additional property.
        value: A BatchCreateInstanceStatus attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('BatchCreateInstanceStatus', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  instanceStatuses = _messages.MessageField('InstanceStatusesValue', 1)
  instanceTargets = _messages.StringField(2, repeated=True)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Cluster(_messages.Message):
  r"""Message describing Cluster object NEXT_ID: 9

  Enums:
    DatabaseVersionValueValuesEnum: The database engine major version.
      Specified by customer at creation time. This field cannot be changed
      after cluster creation.
    StateValueValuesEnum: Output only. The current serving state of the
      cluster.

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. Create time stamp
    databaseVersion: The database engine major version. Specified by customer
      at creation time. This field cannot be changed after cluster creation.
    initialUser: Input only. Initial user to setup during cluster creation.
      Required. We intend to deprecate this post private preview, once we have
      separate User resources.
    labels: Labels as key value pairs
    name: Output only. The name of the cluster resource with the format: *
      projects/{project}/locations/{region}/clusters/{cluster_id} where the
      cluster ID segment should satisfy the regex expression "[a-z0-9-]+". For
      more details see https://google.aip.dev/122. The prefix of the cluster
      resource name is the name of the parent resource: *
      projects/{project}/locations/{region}
    network: The resource link for the VPC network in which cluster resources
      are created and from which they are accessible via Private IP. The
      network must belong to the same project as the cluster. It is specified
      in the form: "projects/{project_number}/global/networks/{network_id}".
      This is required to create a cluster. It can be updated, but it cannot
      be removed.
    state: Output only. The current serving state of the cluster.
    updateTime: Output only. Update time stamp
  """

  class DatabaseVersionValueValuesEnum(_messages.Enum):
    r"""The database engine major version. Specified by customer at creation
    time. This field cannot be changed after cluster creation.

    Values:
      DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      POSTGRES_12: The database version is Postgres 12.
    """
    DATABASE_VERSION_UNSPECIFIED = 0
    POSTGRES_12 = 1

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current serving state of the cluster.

    Values:
      STATE_UNSPECIFIED: The state of the cluster is unknown.
      ACTIVE: The cluster is active and running.
      STOPPED: The cluster is stopped. All instances in the cluster are
        stopped. Customers can start a stopped cluster at any point and all
        their instances will come back to life with same names and IP
        resources. In this state, customer pays for storage.
      EMPTY: The cluster is empty and has no associated resources. All
        instances, associated storage and backups have been deleted.
      CREATING: The cluster is being created.
      DELETING: The cluster is being deleted.
      FAILED: The creation of the cluster failed.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    STOPPED = 2
    EMPTY = 3
    CREATING = 4
    DELETING = 5
    FAILED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  databaseVersion = _messages.EnumField('DatabaseVersionValueValuesEnum', 2)
  initialUser = _messages.MessageField('UserPassword', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  network = _messages.StringField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  updateTime = _messages.StringField(8)


class CreateInstanceRequest(_messages.Message):
  r"""Message for creating a Instance

  Fields:
    instance: Required. The resource being created
    instanceId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and instance_id from the method_signature
      of Create RPC
    parent: Required. The name of the parent resource. For the required
      format, see the comment on the Instance.name field.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  instance = _messages.MessageField('Instance', 1)
  instanceId = _messages.StringField(2)
  parent = _messages.StringField(3)
  requestId = _messages.StringField(4)


class CreateInstanceRequests(_messages.Message):
  r"""See usage below for notes.

  Fields:
    createInstanceRequests: Required. Primary and read replica instances to be
      created. This list should not be empty.
  """

  createInstanceRequests = _messages.MessageField('CreateInstanceRequest', 1, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FailoverClusterRequest(_messages.Message):
  r"""A FailoverClusterRequest object.

  Fields:
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  requestId = _messages.StringField(1)


class FailoverInstanceRequest(_messages.Message):
  r"""Message for triggering failover on an Instance

  Fields:
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  requestId = _messages.StringField(1)


class Instance(_messages.Message):
  r"""Message describing Instance object NEXT ID: 14

  Enums:
    AvailabilityTypeValueValuesEnum: Availability type of an Instance.
      Defaults to REGIONAL for both primary and read instances. Note that
      primary and read instances can have different availability types.
    InstanceTypeValueValuesEnum:
    StateValueValuesEnum: Output only. The current serving state of the
      instance.

  Messages:
    DatabaseFlagsValue: Database flags. Set at instance level. * They are
      copied from primary instance on read instance creation. * Read instances
      can set new or override existing flags that are relevant for reads, e.g.
      for enabling columnar cache on a read instance. Flags set on read
      instance may or may not be present on primary.
    LabelsValue: Labels as key value pairs

  Fields:
    availabilityType: Availability type of an Instance. Defaults to REGIONAL
      for both primary and read instances. Note that primary and read
      instances can have different availability types.
    createTime: Output only. Create time stamp
    databaseFlags: Database flags. Set at instance level. * They are copied
      from primary instance on read instance creation. * Read instances can
      set new or override existing flags that are relevant for reads, e.g. for
      enabling columnar cache on a read instance. Flags set on read instance
      may or may not be present on primary.
    gceZone: The GCE zone that the instance should serve from. Optional. This
      can ONLY be specified for ZONAL instances. If present for a REGIONAL
      instance, an error will be thrown. If this is absent for a ZONAL
      instance, instance is created in a random zone with available capacity.
    instanceType: A InstanceTypeValueValuesEnum attribute.
    ipAddress: Output only. The IP address for the Instance. This is the
      connection endpoint for an end-user application.
    labels: Labels as key value pairs
    name: Output only. The name of the instance resource with the format: * pr
      ojects/{project}/locations/{region}/clusters/{cluster_id}/instances/{ins
      tance_id} where the cluster and instance ID segments should satisfy the
      regex expression "[a-z0-9-]+". For more details see
      https://google.aip.dev/122. The prefix of the instance resource name is
      the name of the parent resource: *
      projects/{project}/locations/{region}/clusters/{cluster_id}
    networkConfig: The settings for Network / IP Management. This allows to
      enable/disable public IP, enable/disable SSL and manage which external
      networks can connect to the instance.
    readPoolConfig: Read pool specific config.
    state: Output only. The current serving state of the instance.
    tier: The tier (or machine type) for this instance, for example
      *n2-standard-2* (PostgreSQL instances). Required for new instances and
      can be updated.
    updateTime: Output only. Update time stamp
  """

  class AvailabilityTypeValueValuesEnum(_messages.Enum):
    r"""Availability type of an Instance. Defaults to REGIONAL for both
    primary and read instances. Note that primary and read instances can have
    different availability types.

    Values:
      AVAILABILITY_TYPE_UNSPECIFIED: This is an unknown Availability type.
      ZONAL: Zonal available instance.
      REGIONAL: Regional (or Highly) available instance.
    """
    AVAILABILITY_TYPE_UNSPECIFIED = 0
    ZONAL = 1
    REGIONAL = 2

  class InstanceTypeValueValuesEnum(_messages.Enum):
    r"""InstanceTypeValueValuesEnum enum type.

    Values:
      INSTANCE_TYPE_UNSPECIFIED: <no description>
      PRIMARY: PRIMARY instances support read and write operations.
      READ: READ instances support read operations only. Each read instance
        consists of one or more homogeneous read replicas. * READ instance of
        size 1 can only have zonal availability. * READ instances with replica
        count of 2 or more can have regional availability (replicas are
        present in 2 or more zones in a region).
    """
    INSTANCE_TYPE_UNSPECIFIED = 0
    PRIMARY = 1
    READ = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current serving state of the instance.

    Values:
      STATE_UNSPECIFIED: The state of the instance is unknown.
      ACTIVE: The instance is active and running.
      STOPPED: The instance is stopped. Instance name and IP resources are
        preserved.
      CREATING: The instance is being created.
      DELETING: The instance is being deleted.
      MAINTENANCE: The instance is down for maintenance.
      FAILED: The creation of the instance failed or a fatal error occurred
        during an operation on the instance. Note: Instances in this state
        would tried to be auto-repaired. And Customers should be able to
        restart, update or delete these instances.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    STOPPED = 2
    CREATING = 3
    DELETING = 4
    MAINTENANCE = 5
    FAILED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DatabaseFlagsValue(_messages.Message):
    r"""Database flags. Set at instance level. * They are copied from primary
    instance on read instance creation. * Read instances can set new or
    override existing flags that are relevant for reads, e.g. for enabling
    columnar cache on a read instance. Flags set on read instance may or may
    not be present on primary.

    Messages:
      AdditionalProperty: An additional property for a DatabaseFlagsValue
        object.

    Fields:
      additionalProperties: Additional properties of type DatabaseFlagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DatabaseFlagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  availabilityType = _messages.EnumField('AvailabilityTypeValueValuesEnum', 1)
  createTime = _messages.StringField(2)
  databaseFlags = _messages.MessageField('DatabaseFlagsValue', 3)
  gceZone = _messages.StringField(4)
  instanceType = _messages.EnumField('InstanceTypeValueValuesEnum', 5)
  ipAddress = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  networkConfig = _messages.MessageField('NetworkConfig', 9)
  readPoolConfig = _messages.MessageField('ReadPoolConfig', 10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  tier = _messages.StringField(12)
  updateTime = _messages.StringField(13)


class IntegerRestrictions(_messages.Message):
  r"""Restrictions on INTEGER type values.

  Fields:
    maxValue: The maximum value that can be specified, if applicable.
    minValue: The minimum value that can be specified, if applicable.
  """

  maxValue = _messages.IntegerField(1)
  minValue = _messages.IntegerField(2)


class ListBackupsResponse(_messages.Message):
  r"""Message for response to listing Backups

  Fields:
    backups: The list of Backup
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  backups = _messages.MessageField('Backup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListClustersResponse(_messages.Message):
  r"""Message for response to listing Clusters

  Fields:
    clusters: The list of Cluster
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListInstancesResponse(_messages.Message):
  r"""Message for response to listing Instances

  Fields:
    instances: The list of Instance
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListSupportedDatabaseFlagsResponse(_messages.Message):
  r"""Message for response to listing SupportedDatabaseFlags.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    supportedDatabaseFlags: The list of SupportedDatabaseFlags.
  """

  nextPageToken = _messages.StringField(1)
  supportedDatabaseFlags = _messages.MessageField('SupportedDatabaseFlag', 2, repeated=True)


class ListUsersResponse(_messages.Message):
  r"""Message for response to listing Users

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
    users: The list of User
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  users = _messages.MessageField('User', 3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class NetworkConfig(_messages.Message):
  r"""Network Management configuration.

  Fields:
    publicIpEnabled: Whether the instance is assigned a public IP address or
      not.
    sslRequired: Whether SSL connections over IP are enforced or not.
  """

  publicIpEnabled = _messages.BooleanField(1)
  sslRequired = _messages.BooleanField(2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    batchCreateInstancesMetadata: A BatchCreateInstancesMetadata attribute.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  batchCreateInstancesMetadata = _messages.MessageField('BatchCreateInstancesMetadata', 2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  requestedCancellation = _messages.BooleanField(5)
  statusMessage = _messages.StringField(6)
  target = _messages.StringField(7)
  verb = _messages.StringField(8)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ReadPoolConfig(_messages.Message):
  r"""Read pool configuration for an instance.

  Fields:
    readPoolSize: Read pool size.
  """

  readPoolSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class RestartInstanceRequest(_messages.Message):
  r"""A RestartInstanceRequest object.

  Fields:
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  requestId = _messages.StringField(1)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StringRestrictions(_messages.Message):
  r"""Restrictions on STRING type values

  Fields:
    allowedValues: The list of allowed values, if bounded. This field will be
      empty if there is a unbounded number of allowed values.
  """

  allowedValues = _messages.StringField(1, repeated=True)


class SupportedDatabaseFlag(_messages.Message):
  r"""SupportedDatabaseFlag gives general information about a database flag,
  like type and allowed values. This is a static value that is defined on the
  server side, and it cannot be modified by callers. To set the Database flags
  on a particular Instance, a caller should modify the Instance.database_flags
  field.

  Enums:
    SupportedDbVersionsValueListEntryValuesEnum:
    ValueTypeValueValuesEnum:

  Fields:
    acceptsMultipleValues: Whether the database flag accepts multiple values.
      If true, a comma-separated list of stringified values may be specified.
    flagName: The name of the database flag, e.g. "max_allowed_packets". The
      is a possibly key for the Instance.database_flags map field.
    integerRestrictions: A IntegerRestrictions attribute.
    name: The name of the flag resource, following GCP conventions, e.g.: *
      projects/{project}/locations/{location}/flags/{flag_id} This field
      currently has no semantic meaning.
    requiresDbRestart: Whether setting or updating this flag on an Instance
      requires a database restart. If a flag that requires database restart is
      set, the backend will automatically restart the database (making sure to
      satisfy any availability SLO's).
    stringRestrictions: A StringRestrictions attribute.
    supportedDbVersions: Major database engine versions for which this flag is
      supported.
    valueType: A ValueTypeValueValuesEnum attribute.
  """

  class SupportedDbVersionsValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedDbVersionsValueListEntryValuesEnum enum type.

    Values:
      DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      POSTGRES_12: The database version is Postgres 12.
    """
    DATABASE_VERSION_UNSPECIFIED = 0
    POSTGRES_12 = 1

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""ValueTypeValueValuesEnum enum type.

    Values:
      TYPE_UNSPECIFIED: This is an unknown flag type.
      STRING: String type flag.
      INTEGER: Integer type flag.
      FLOAT: Float type flag.
      NONE: Denotes that the flag does not accept any values.
    """
    TYPE_UNSPECIFIED = 0
    STRING = 1
    INTEGER = 2
    FLOAT = 3
    NONE = 4

  acceptsMultipleValues = _messages.BooleanField(1)
  flagName = _messages.StringField(2)
  integerRestrictions = _messages.MessageField('IntegerRestrictions', 3)
  name = _messages.StringField(4)
  requiresDbRestart = _messages.BooleanField(5)
  stringRestrictions = _messages.MessageField('StringRestrictions', 6)
  supportedDbVersions = _messages.EnumField('SupportedDbVersionsValueListEntryValuesEnum', 7, repeated=True)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 8)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class User(_messages.Message):
  r"""Message describing User object

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. Create time stamp
    labels: Labels as key value pairs
    name: Output only. name of resource
    updateTime: Output only. Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class UserPassword(_messages.Message):
  r"""The username/password for a database user. Used for specifying initial
  users at cluster creation time.

  Fields:
    password: The initial password for the user.
    user: The database username.
  """

  password = _messages.StringField(1)
  user = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
