# Copyright 2018 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""The command group for managing a Cloud Composer environment's DAGs."""

from __future__ import absolute_import
from __future__ import unicode_literals
from googlecloudsdk.calliope import base


class Dags(base.Group):
  """Manage DAGs for Cloud Composer environments.

  The {command} command group lets you import, export, list, and delete DAGs for
  your Cloud Composer environment.
  """
