#!/usr/bin/env python
"""CLI for servicemanagement, version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

import code
import os
import platform
import sys

from apitools.base.protorpclite import message_types
from apitools.base.protorpclite import messages

from google.apputils import appcommands
import gflags as flags

import apitools.base.py as apitools_base
from apitools.base.py import cli as apitools_base_cli
import servicemanagement_v1_client as client_lib
import servicemanagement_v1_messages as messages


def _DeclareServicemanagementFlags():
  """Declare global flags in an idempotent way."""
  if 'api_endpoint' in flags.FLAGS:
    return
  flags.DEFINE_string(
      'api_endpoint',
      u'https://servicemanagement.googleapis.com/',
      'URL of the API endpoint to use.',
      short_name='servicemanagement_url')
  flags.DEFINE_string(
      'history_file',
      u'~/.servicemanagement.v1.history',
      'File with interactive shell history.')
  flags.DEFINE_multistring(
      'add_header', [],
      'Additional http headers (as key=value strings). '
      'Can be specified multiple times.')
  flags.DEFINE_string(
      'service_account_json_keyfile', '',
      'Filename for a JSON service account key downloaded'
      ' from the Developer Console.')
  flags.DEFINE_enum(
      'f__xgafv',
      u'_1',
      [u'_1', u'_2'],
      u'V1 error format.')
  flags.DEFINE_string(
      'access_token',
      None,
      u'OAuth access token.')
  flags.DEFINE_enum(
      'alt',
      u'json',
      [u'json', u'media', u'proto'],
      u'Data format for response.')
  flags.DEFINE_string(
      'bearer_token',
      None,
      u'OAuth bearer token.')
  flags.DEFINE_string(
      'callback',
      None,
      u'JSONP')
  flags.DEFINE_string(
      'fields',
      None,
      u'Selector specifying which fields to include in a partial response.')
  flags.DEFINE_string(
      'key',
      None,
      u'API key. Your API key identifies your project and provides you with '
      u'API access, quota, and reports. Required unless you provide an OAuth '
      u'2.0 token.')
  flags.DEFINE_string(
      'oauth_token',
      None,
      u'OAuth 2.0 token for the current user.')
  flags.DEFINE_boolean(
      'pp',
      'True',
      u'Pretty-print response.')
  flags.DEFINE_boolean(
      'prettyPrint',
      'True',
      u'Returns response with indentations and line breaks.')
  flags.DEFINE_string(
      'quotaUser',
      None,
      u'Available to use for quota purposes for server-side applications. Can'
      u' be any arbitrary string assigned to a user, but should not exceed 40'
      u' characters.')
  flags.DEFINE_string(
      'trace',
      None,
      'A tracing token of the form "token:<tokenid>" to include in api '
      'requests.')
  flags.DEFINE_string(
      'uploadType',
      None,
      u'Legacy upload protocol for media (e.g. "media", "multipart").')
  flags.DEFINE_string(
      'upload_protocol',
      None,
      u'Upload protocol for media (e.g. "raw", "multipart").')


FLAGS = flags.FLAGS
apitools_base_cli.DeclareBaseFlags()
_DeclareServicemanagementFlags()


def GetGlobalParamsFromFlags():
  """Return a StandardQueryParameters based on flags."""
  result = messages.StandardQueryParameters()
  if FLAGS['f__xgafv'].present:
    result.f__xgafv = messages.StandardQueryParameters.FXgafvValueValuesEnum(FLAGS.f__xgafv)
  if FLAGS['access_token'].present:
    result.access_token = FLAGS.access_token.decode('utf8')
  if FLAGS['alt'].present:
    result.alt = messages.StandardQueryParameters.AltValueValuesEnum(FLAGS.alt)
  if FLAGS['bearer_token'].present:
    result.bearer_token = FLAGS.bearer_token.decode('utf8')
  if FLAGS['callback'].present:
    result.callback = FLAGS.callback.decode('utf8')
  if FLAGS['fields'].present:
    result.fields = FLAGS.fields.decode('utf8')
  if FLAGS['key'].present:
    result.key = FLAGS.key.decode('utf8')
  if FLAGS['oauth_token'].present:
    result.oauth_token = FLAGS.oauth_token.decode('utf8')
  if FLAGS['pp'].present:
    result.pp = FLAGS.pp
  if FLAGS['prettyPrint'].present:
    result.prettyPrint = FLAGS.prettyPrint
  if FLAGS['quotaUser'].present:
    result.quotaUser = FLAGS.quotaUser.decode('utf8')
  if FLAGS['trace'].present:
    result.trace = FLAGS.trace.decode('utf8')
  if FLAGS['uploadType'].present:
    result.uploadType = FLAGS.uploadType.decode('utf8')
  if FLAGS['upload_protocol'].present:
    result.upload_protocol = FLAGS.upload_protocol.decode('utf8')
  return result


def GetClientFromFlags():
  """Return a client object, configured from flags."""
  log_request = FLAGS.log_request or FLAGS.log_request_response
  log_response = FLAGS.log_response or FLAGS.log_request_response
  api_endpoint = apitools_base.NormalizeApiEndpoint(FLAGS.api_endpoint)
  additional_http_headers = dict(x.split('=', 1) for x in FLAGS.add_header)
  credentials_args = {
      'service_account_json_keyfile': os.path.expanduser(FLAGS.service_account_json_keyfile)
  }
  try:
    client = client_lib.ServicemanagementV1(
        api_endpoint, log_request=log_request,
        log_response=log_response,
        credentials_args=credentials_args,
        additional_http_headers=additional_http_headers)
  except apitools_base.CredentialsError as e:
    print 'Error creating credentials: %s' % e
    sys.exit(1)
  return client


class PyShell(appcommands.Cmd):

  def Run(self, _):
    """Run an interactive python shell with the client."""
    client = GetClientFromFlags()
    params = GetGlobalParamsFromFlags()
    for field in params.all_fields():
      value = params.get_assigned_value(field.name)
      if value != field.default:
        client.AddGlobalParam(field.name, value)
    banner = """
           == servicemanagement interactive console ==
                 client: a servicemanagement client
          apitools_base: base apitools module
         messages: the generated messages module
    """
    local_vars = {
        'apitools_base': apitools_base,
        'client': client,
        'client_lib': client_lib,
        'messages': messages,
    }
    if platform.system() == 'Linux':
      console = apitools_base_cli.ConsoleWithReadline(
          local_vars, histfile=FLAGS.history_file)
    else:
      console = code.InteractiveConsole(local_vars)
    try:
      console.interact(banner)
    except SystemExit as e:
      return e.code


class OperationsGet(apitools_base_cli.NewCmd):
  """Command wrapping operations.Get."""

  usage = """operations_get <operationsId>"""

  def __init__(self, name, fv):
    super(OperationsGet, self).__init__(name, fv)

  def RunWithArgs(self, operationsId):
    """Gets the latest state of a long-running operation.  Clients can use
    this method to poll the operation result at intervals as recommended by
    the API service.

    Args:
      operationsId: Part of `name`. The name of the operation resource.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementOperationsGetRequest(
        operationsId=operationsId.decode('utf8'),
        )
    result = client.operations.Get(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesConvertConfig(apitools_base_cli.NewCmd):
  """Command wrapping services.ConvertConfig."""

  usage = """services_convertConfig"""

  def __init__(self, name, fv):
    super(ServicesConvertConfig, self).__init__(name, fv)
    flags.DEFINE_string(
        'configSpec',
        None,
        u'Input configuration For this version of API, the supported type is '
        u'OpenApiSpec',
        flag_values=fv)
    flags.DEFINE_string(
        'openApiSpec',
        None,
        u'The OpenAPI specification for an API.',
        flag_values=fv)
    flags.DEFINE_string(
        'serviceName',
        None,
        u'The service name to use for constructing the normalized service '
        u'configuration equivalent of the provided configuration '
        u'specification.',
        flag_values=fv)
    flags.DEFINE_string(
        'swaggerSpec',
        None,
        u'The swagger specification for an API.',
        flag_values=fv)

  def RunWithArgs(self):
    """DEPRECATED. `SubmitConfigSource` with `validate_only=true` will provide
    config conversion moving forward.  Converts an API specification (e.g.
    Swagger spec) to an equivalent `google.api.Service`.

    Flags:
      configSpec: Input configuration For this version of API, the supported
        type is OpenApiSpec
      openApiSpec: The OpenAPI specification for an API.
      serviceName: The service name to use for constructing the normalized
        service configuration equivalent of the provided configuration
        specification.
      swaggerSpec: The swagger specification for an API.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ConvertConfigRequest(
        )
    if FLAGS['configSpec'].present:
      request.configSpec = apitools_base.JsonToMessage(messages.ConvertConfigRequest.ConfigSpecValue, FLAGS.configSpec)
    if FLAGS['openApiSpec'].present:
      request.openApiSpec = apitools_base.JsonToMessage(messages.OpenApiSpec, FLAGS.openApiSpec)
    if FLAGS['serviceName'].present:
      request.serviceName = FLAGS.serviceName.decode('utf8')
    if FLAGS['swaggerSpec'].present:
      request.swaggerSpec = apitools_base.JsonToMessage(messages.SwaggerSpec, FLAGS.swaggerSpec)
    result = client.services.ConvertConfig(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesCreate(apitools_base_cli.NewCmd):
  """Command wrapping services.Create."""

  usage = """services_create"""

  def __init__(self, name, fv):
    super(ServicesCreate, self).__init__(name, fv)
    flags.DEFINE_string(
        'configSource',
        None,
        u'User-supplied source configuration for the service. This is '
        u'distinct from the generated configuration provided in '
        u'`google.api.Service`. This is NOT populated on GetService calls at '
        u'the moment. NOTE: Any upsert operation that contains both a '
        u'service_config and a config_source is considered invalid and will '
        u'result in an error being returned.',
        flag_values=fv)
    flags.DEFINE_string(
        'generation',
        None,
        u'A server-assigned monotonically increasing number that changes '
        u'whenever a mutation is made to the `ManagedService` or any of its '
        u'components via the `ServiceManager` API.',
        flag_values=fv)
    flags.DEFINE_string(
        'operations',
        None,
        u'Read-only view of pending operations affecting this resource, if '
        u'requested.',
        flag_values=fv)
    flags.DEFINE_string(
        'producerProjectId',
        None,
        u'ID of the project that produces and owns this service.',
        flag_values=fv)
    flags.DEFINE_string(
        'projectSettings',
        None,
        u'Read-only view of settings for a particular consumer project, if '
        u'requested.',
        flag_values=fv)
    flags.DEFINE_string(
        'serviceConfig',
        None,
        u"The service's generated configuration.",
        flag_values=fv)
    flags.DEFINE_string(
        'serviceName',
        None,
        u'The name of the service.  See the `ServiceManager` overview for '
        u'naming requirements.  This name must match '
        u'`google.api.Service.name` in the `service_config` field.',
        flag_values=fv)

  def RunWithArgs(self):
    """Creates a new managed service.  Operation<response: ManagedService>

    Flags:
      configSource: User-supplied source configuration for the service. This
        is distinct from the generated configuration provided in
        `google.api.Service`. This is NOT populated on GetService calls at the
        moment. NOTE: Any upsert operation that contains both a service_config
        and a config_source is considered invalid and will result in an error
        being returned.
      generation: A server-assigned monotonically increasing number that
        changes whenever a mutation is made to the `ManagedService` or any of
        its components via the `ServiceManager` API.
      operations: Read-only view of pending operations affecting this
        resource, if requested.
      producerProjectId: ID of the project that produces and owns this
        service.
      projectSettings: Read-only view of settings for a particular consumer
        project, if requested.
      serviceConfig: The service's generated configuration.
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  This name must match
        `google.api.Service.name` in the `service_config` field.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ManagedService(
        )
    if FLAGS['configSource'].present:
      request.configSource = apitools_base.JsonToMessage(messages.ConfigSource, FLAGS.configSource)
    if FLAGS['generation'].present:
      request.generation = int(FLAGS.generation)
    if FLAGS['operations'].present:
      request.operations = [apitools_base.JsonToMessage(messages.Operation, x) for x in FLAGS.operations]
    if FLAGS['producerProjectId'].present:
      request.producerProjectId = FLAGS.producerProjectId.decode('utf8')
    if FLAGS['projectSettings'].present:
      request.projectSettings = apitools_base.JsonToMessage(messages.ProjectSettings, FLAGS.projectSettings)
    if FLAGS['serviceConfig'].present:
      request.serviceConfig = apitools_base.JsonToMessage(messages.Service, FLAGS.serviceConfig)
    if FLAGS['serviceName'].present:
      request.serviceName = FLAGS.serviceName.decode('utf8')
    result = client.services.Create(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesDelete(apitools_base_cli.NewCmd):
  """Command wrapping services.Delete."""

  usage = """services_delete <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesDelete, self).__init__(name, fv)

  def RunWithArgs(self, serviceName):
    """Deletes a managed service.  Operation<response: google.protobuf.Empty>

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesDeleteRequest(
        serviceName=serviceName.decode('utf8'),
        )
    result = client.services.Delete(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesDisable(apitools_base_cli.NewCmd):
  """Command wrapping services.Disable."""

  usage = """services_disable <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesDisable, self).__init__(name, fv)
    flags.DEFINE_string(
        'disableServiceRequest',
        None,
        u'A DisableServiceRequest resource to be passed as the request body.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Disable a managed service for a project. Google Service Management will
    only disable the managed service even if there are other services depend
    on the managed service.  Operation<response: DisableServiceResponse>

    Args:
      serviceName: Name of the service to disable. Specifying an unknown
        service name will cause the request to fail.

    Flags:
      disableServiceRequest: A DisableServiceRequest resource to be passed as
        the request body.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesDisableRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['disableServiceRequest'].present:
      request.disableServiceRequest = apitools_base.JsonToMessage(messages.DisableServiceRequest, FLAGS.disableServiceRequest)
    result = client.services.Disable(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesEnable(apitools_base_cli.NewCmd):
  """Command wrapping services.Enable."""

  usage = """services_enable <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesEnable, self).__init__(name, fv)
    flags.DEFINE_string(
        'enableServiceRequest',
        None,
        u'A EnableServiceRequest resource to be passed as the request body.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Enable a managed service for a project with default setting. If the
    managed service has dependencies, they will be enabled as well.
    Operation<response: EnableServiceResponse>

    Args:
      serviceName: Name of the service to enable. Specifying an unknown
        service name will cause the request to fail.

    Flags:
      enableServiceRequest: A EnableServiceRequest resource to be passed as
        the request body.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesEnableRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['enableServiceRequest'].present:
      request.enableServiceRequest = apitools_base.JsonToMessage(messages.EnableServiceRequest, FLAGS.enableServiceRequest)
    result = client.services.Enable(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesGet(apitools_base_cli.NewCmd):
  """Command wrapping services.Get."""

  usage = """services_get <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesGet, self).__init__(name, fv)
    flags.DEFINE_string(
        'consumerProjectId',
        None,
        u'If project_settings is expanded, return settings for the specified '
        u'consumer project.',
        flag_values=fv)
    flags.DEFINE_string(
        'expand',
        None,
        u'Fields to expand in any results.  By default, the following fields '
        u'are not present in the result: - `operations` - `project_settings` '
        u'- `project_settings.operations` - `quota_usage` (It requires '
        u'`project_settings`) - `historical_quota_usage` (It requires '
        u'`project_settings`)',
        flag_values=fv)
    flags.DEFINE_enum(
        'view',
        u'PROJECT_SETTINGS_VIEW_UNSPECIFIED',
        [u'PROJECT_SETTINGS_VIEW_UNSPECIFIED', u'CONSUMER_VIEW', u'PRODUCER_VIEW', u'ALL'],
        u'If project_settings is expanded, request only fields for the '
        u'specified view.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Gets a managed service. If the `consumer_project_id` is specified, the
    project's settings for the specified service are also returned.

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.

    Flags:
      consumerProjectId: If project_settings is expanded, return settings for
        the specified consumer project.
      expand: Fields to expand in any results.  By default, the following
        fields are not present in the result: - `operations` -
        `project_settings` - `project_settings.operations` - `quota_usage` (It
        requires `project_settings`) - `historical_quota_usage` (It requires
        `project_settings`)
      view: If project_settings is expanded, request only fields for the
        specified view.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesGetRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['consumerProjectId'].present:
      request.consumerProjectId = FLAGS.consumerProjectId.decode('utf8')
    if FLAGS['expand'].present:
      request.expand = FLAGS.expand.decode('utf8')
    if FLAGS['view'].present:
      request.view = messages.ServicemanagementServicesGetRequest.ViewValueValuesEnum(FLAGS.view)
    result = client.services.Get(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesGetAccessPolicy(apitools_base_cli.NewCmd):
  """Command wrapping services.GetAccessPolicy."""

  usage = """services_getAccessPolicy <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesGetAccessPolicy, self).__init__(name, fv)

  def RunWithArgs(self, serviceName):
    """Producer method to retrieve current policy.

    Args:
      serviceName: The name of the service.  For example:
        `example.googleapis.com`.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesGetAccessPolicyRequest(
        serviceName=serviceName.decode('utf8'),
        )
    result = client.services.GetAccessPolicy(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesGetConfig(apitools_base_cli.NewCmd):
  """Command wrapping services.GetConfig."""

  usage = """services_getConfig <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesGetConfig, self).__init__(name, fv)
    flags.DEFINE_string(
        'configId',
        None,
        u'The id of the service config resource. Optional. If it is not '
        u'specified, the latest version of config will be returned.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Gets a service config (version) for a managed service. If `config_id`
    is not specified, the latest service config will be returned.

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.

    Flags:
      configId: The id of the service config resource. Optional. If it is not
        specified, the latest version of config will be returned.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesGetConfigRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['configId'].present:
      request.configId = FLAGS.configId.decode('utf8')
    result = client.services.GetConfig(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesList(apitools_base_cli.NewCmd):
  """Command wrapping services.List."""

  usage = """services_list"""

  def __init__(self, name, fv):
    super(ServicesList, self).__init__(name, fv)
    flags.DEFINE_string(
        'category',
        None,
        u'Include services only in the specified category. Supported '
        u'categories are servicemanagement.googleapis.com/categories/google-'
        u'services or servicemanagement.googleapis.com/categories/play-games.',
        flag_values=fv)
    flags.DEFINE_string(
        'consumerProjectId',
        None,
        u'Include services consumed by the specified project.  If '
        u'project_settings is expanded, then this field controls which '
        u'project project_settings is populated for.',
        flag_values=fv)
    flags.DEFINE_string(
        'expand',
        None,
        u'Fields to expand in any results.  By default, the following fields '
        u'are not fully included in list results: - `operations` - '
        u'`project_settings` - `project_settings.operations` - `quota_usage` '
        u'(It requires `project_settings`)',
        flag_values=fv)
    flags.DEFINE_integer(
        'pageSize',
        None,
        u'Requested size of the next page of data.',
        flag_values=fv)
    flags.DEFINE_string(
        'pageToken',
        None,
        u'Token identifying which result to start with; returned by a '
        u'previous list call.',
        flag_values=fv)
    flags.DEFINE_string(
        'producerProjectId',
        None,
        u'Include services produced by the specified project.',
        flag_values=fv)

  def RunWithArgs(self):
    """Lists all managed services. If the `consumer_project_id` is specified,
    the project's settings for the specified service are also returned.

    Flags:
      category: Include services only in the specified category. Supported
        categories are servicemanagement.googleapis.com/categories/google-
        services or servicemanagement.googleapis.com/categories/play-games.
      consumerProjectId: Include services consumed by the specified project.
        If project_settings is expanded, then this field controls which
        project project_settings is populated for.
      expand: Fields to expand in any results.  By default, the following
        fields are not fully included in list results: - `operations` -
        `project_settings` - `project_settings.operations` - `quota_usage` (It
        requires `project_settings`)
      pageSize: Requested size of the next page of data.
      pageToken: Token identifying which result to start with; returned by a
        previous list call.
      producerProjectId: Include services produced by the specified project.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesListRequest(
        )
    if FLAGS['category'].present:
      request.category = FLAGS.category.decode('utf8')
    if FLAGS['consumerProjectId'].present:
      request.consumerProjectId = FLAGS.consumerProjectId.decode('utf8')
    if FLAGS['expand'].present:
      request.expand = FLAGS.expand.decode('utf8')
    if FLAGS['pageSize'].present:
      request.pageSize = FLAGS.pageSize
    if FLAGS['pageToken'].present:
      request.pageToken = FLAGS.pageToken.decode('utf8')
    if FLAGS['producerProjectId'].present:
      request.producerProjectId = FLAGS.producerProjectId.decode('utf8')
    result = client.services.List(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesPatch(apitools_base_cli.NewCmd):
  """Command wrapping services.Patch."""

  usage = """services_patch <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesPatch, self).__init__(name, fv)
    flags.DEFINE_string(
        'managedService',
        None,
        u'A ManagedService resource to be passed as the request body.',
        flag_values=fv)
    flags.DEFINE_string(
        'updateMask',
        None,
        u'A mask specifying which fields to update.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Updates the specified subset of the configuration. If the specified
    service does not exists the patch operation fails.  Operation<response:
    ManagedService>

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.

    Flags:
      managedService: A ManagedService resource to be passed as the request
        body.
      updateMask: A mask specifying which fields to update.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesPatchRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['managedService'].present:
      request.managedService = apitools_base.JsonToMessage(messages.ManagedService, FLAGS.managedService)
    if FLAGS['updateMask'].present:
      request.updateMask = FLAGS.updateMask.decode('utf8')
    result = client.services.Patch(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesPatchConfig(apitools_base_cli.NewCmd):
  """Command wrapping services.PatchConfig."""

  usage = """services_patchConfig <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesPatchConfig, self).__init__(name, fv)
    flags.DEFINE_string(
        'service',
        None,
        u'A Service resource to be passed as the request body.',
        flag_values=fv)
    flags.DEFINE_string(
        'updateMask',
        None,
        u'A mask specifying which fields to update.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Updates the specified subset of the service resource. Equivalent to
    calling `PatchService` with only the `service_config` field updated.
    Operation<response: google.api.Service>

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.

    Flags:
      service: A Service resource to be passed as the request body.
      updateMask: A mask specifying which fields to update.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesPatchConfigRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['service'].present:
      request.service = apitools_base.JsonToMessage(messages.Service, FLAGS.service)
    if FLAGS['updateMask'].present:
      request.updateMask = FLAGS.updateMask.decode('utf8')
    result = client.services.PatchConfig(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesUpdate(apitools_base_cli.NewCmd):
  """Command wrapping services.Update."""

  usage = """services_update <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesUpdate, self).__init__(name, fv)
    flags.DEFINE_string(
        'managedService',
        None,
        u'A ManagedService resource to be passed as the request body.',
        flag_values=fv)
    flags.DEFINE_string(
        'updateMask',
        None,
        u'A mask specifying which fields to update. Update mask has been '
        u'deprecated on UpdateService service method. Please use PatchService'
        u' method instead to do partial updates.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Updates the configuration of a service.  If the specified service does
    not already exist, then it is created.  Operation<response:
    ManagedService>

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.

    Flags:
      managedService: A ManagedService resource to be passed as the request
        body.
      updateMask: A mask specifying which fields to update. Update mask has
        been deprecated on UpdateService service method. Please use
        PatchService method instead to do partial updates.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesUpdateRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['managedService'].present:
      request.managedService = apitools_base.JsonToMessage(messages.ManagedService, FLAGS.managedService)
    if FLAGS['updateMask'].present:
      request.updateMask = FLAGS.updateMask.decode('utf8')
    result = client.services.Update(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesUpdateAccessPolicy(apitools_base_cli.NewCmd):
  """Command wrapping services.UpdateAccessPolicy."""

  usage = """services_updateAccessPolicy <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesUpdateAccessPolicy, self).__init__(name, fv)
    flags.DEFINE_string(
        'accessList',
        None,
        u'ACL for access to the unrestricted surface of the service.',
        flag_values=fv)
    flags.DEFINE_string(
        'visibilityLabelAccessLists',
        None,
        u'ACLs for access to restricted parts of the service.  The map key is'
        u' the visibility label that is being controlled.  Note that access '
        u'to any label also implies access to the unrestricted surface.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Producer method to update the current policy.  This method will return
    an error if the policy is too large (more than 50 entries across all
    lists).

    Args:
      serviceName: The service protected by this policy.

    Flags:
      accessList: ACL for access to the unrestricted surface of the service.
      visibilityLabelAccessLists: ACLs for access to restricted parts of the
        service.  The map key is the visibility label that is being
        controlled.  Note that access to any label also implies access to the
        unrestricted surface.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServiceAccessPolicy(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['accessList'].present:
      request.accessList = apitools_base.JsonToMessage(messages.ServiceAccessList, FLAGS.accessList)
    if FLAGS['visibilityLabelAccessLists'].present:
      request.visibilityLabelAccessLists = apitools_base.JsonToMessage(messages.ServiceAccessPolicy.VisibilityLabelAccessListsValue, FLAGS.visibilityLabelAccessLists)
    result = client.services.UpdateAccessPolicy(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesUpdateConfig(apitools_base_cli.NewCmd):
  """Command wrapping services.UpdateConfig."""

  usage = """services_updateConfig <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesUpdateConfig, self).__init__(name, fv)
    flags.DEFINE_string(
        'service',
        None,
        u'A Service resource to be passed as the request body.',
        flag_values=fv)
    flags.DEFINE_string(
        'updateMask',
        None,
        u'A mask specifying which fields to update. Update mask has been '
        u'deprecated on UpdateServiceConfig service method. Please use '
        u'PatchServiceConfig method instead to do partial updates.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Updates the specified subset of the service resource. Equivalent to
    calling `UpdateService` with only the `service_config` field updated.
    Operation<response: google.api.Service>

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.

    Flags:
      service: A Service resource to be passed as the request body.
      updateMask: A mask specifying which fields to update. Update mask has
        been deprecated on UpdateServiceConfig service method. Please use
        PatchServiceConfig method instead to do partial updates.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesUpdateConfigRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['service'].present:
      request.service = apitools_base.JsonToMessage(messages.Service, FLAGS.service)
    if FLAGS['updateMask'].present:
      request.updateMask = FLAGS.updateMask.decode('utf8')
    result = client.services.UpdateConfig(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesAccessPolicyQuery(apitools_base_cli.NewCmd):
  """Command wrapping services_accessPolicy.Query."""

  usage = """services_accessPolicy_query <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesAccessPolicyQuery, self).__init__(name, fv)
    flags.DEFINE_string(
        'userEmail',
        None,
        u'The user to query access for.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Method to query the accessibility of a service and any associated
    visibility labels for a specified user.  Members of the producer project
    may call this method and specify any user.  Any user may call this method,
    but must specify their own email address. In this case the method will
    return NOT_FOUND if the user has no access to the service.

    Args:
      serviceName: The service to query access for.

    Flags:
      userEmail: The user to query access for.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesAccessPolicyQueryRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['userEmail'].present:
      request.userEmail = FLAGS.userEmail.decode('utf8')
    result = client.services_accessPolicy.Query(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesConfigsCreate(apitools_base_cli.NewCmd):
  """Command wrapping services_configs.Create."""

  usage = """services_configs_create <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesConfigsCreate, self).__init__(name, fv)
    flags.DEFINE_string(
        'service',
        None,
        u'A Service resource to be passed as the request body.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Creates a new service config (version) for a managed service. This
    method only stores the service config, but does not apply the service
    config to any backend services.

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.

    Flags:
      service: A Service resource to be passed as the request body.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesConfigsCreateRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['service'].present:
      request.service = apitools_base.JsonToMessage(messages.Service, FLAGS.service)
    result = client.services_configs.Create(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesConfigsGet(apitools_base_cli.NewCmd):
  """Command wrapping services_configs.Get."""

  usage = """services_configs_get <serviceName> <configId>"""

  def __init__(self, name, fv):
    super(ServicesConfigsGet, self).__init__(name, fv)

  def RunWithArgs(self, serviceName, configId):
    """Gets a service config (version) for a managed service. If `config_id`
    is not specified, the latest service config will be returned.

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.
      configId: The id of the service config resource. Optional. If it is not
        specified, the latest version of config will be returned.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesConfigsGetRequest(
        serviceName=serviceName.decode('utf8'),
        configId=configId.decode('utf8'),
        )
    result = client.services_configs.Get(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesConfigsList(apitools_base_cli.NewCmd):
  """Command wrapping services_configs.List."""

  usage = """services_configs_list <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesConfigsList, self).__init__(name, fv)
    flags.DEFINE_integer(
        'pageSize',
        None,
        u'The max number of items to include in the response list.',
        flag_values=fv)
    flags.DEFINE_string(
        'pageToken',
        None,
        u'The token of the page to retrieve.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Lists the history of the service config for a managed service, from the
    newest to the oldest.

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.

    Flags:
      pageSize: The max number of items to include in the response list.
      pageToken: The token of the page to retrieve.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesConfigsListRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['pageSize'].present:
      request.pageSize = FLAGS.pageSize
    if FLAGS['pageToken'].present:
      request.pageToken = FLAGS.pageToken.decode('utf8')
    result = client.services_configs.List(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesConfigsSubmit(apitools_base_cli.NewCmd):
  """Command wrapping services_configs.Submit."""

  usage = """services_configs_submit <serviceName>"""

  def __init__(self, name, fv):
    super(ServicesConfigsSubmit, self).__init__(name, fv)
    flags.DEFINE_string(
        'submitConfigSourceRequest',
        None,
        u'A SubmitConfigSourceRequest resource to be passed as the request '
        u'body.',
        flag_values=fv)

  def RunWithArgs(self, serviceName):
    """Creates a new service config (version) for a managed service based on
    user-supplied configuration sources files (for example: OpenAPI
    Specification). This method stores the source configurations as well as
    the generated service config. It does NOT apply the service config to any
    backend services.  Operation<response: SubmitConfigSourceResponse>

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.

    Flags:
      submitConfigSourceRequest: A SubmitConfigSourceRequest resource to be
        passed as the request body.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesConfigsSubmitRequest(
        serviceName=serviceName.decode('utf8'),
        )
    if FLAGS['submitConfigSourceRequest'].present:
      request.submitConfigSourceRequest = apitools_base.JsonToMessage(messages.SubmitConfigSourceRequest, FLAGS.submitConfigSourceRequest)
    result = client.services_configs.Submit(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesCustomerSettingsGet(apitools_base_cli.NewCmd):
  """Command wrapping services_customerSettings.Get."""

  usage = """services_customerSettings_get <serviceName> <customerId>"""

  def __init__(self, name, fv):
    super(ServicesCustomerSettingsGet, self).__init__(name, fv)
    flags.DEFINE_string(
        'expand',
        None,
        u'Fields to expand in any results.',
        flag_values=fv)
    flags.DEFINE_enum(
        'view',
        u'PROJECT_SETTINGS_VIEW_UNSPECIFIED',
        [u'PROJECT_SETTINGS_VIEW_UNSPECIFIED', u'CONSUMER_VIEW', u'PRODUCER_VIEW', u'ALL'],
        u'Request only fields for the specified view.',
        flag_values=fv)

  def RunWithArgs(self, serviceName, customerId):
    """Retrieves the settings that control the specified customer's usage of
    the service.

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`. This
        field is required.
      customerId: ID for the customer. See the comment for
        `CustomerSettings.customer_id` field of message for its format. This
        field is required.

    Flags:
      expand: Fields to expand in any results.
      view: Request only fields for the specified view.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesCustomerSettingsGetRequest(
        serviceName=serviceName.decode('utf8'),
        customerId=customerId.decode('utf8'),
        )
    if FLAGS['expand'].present:
      request.expand = FLAGS.expand.decode('utf8')
    if FLAGS['view'].present:
      request.view = messages.ServicemanagementServicesCustomerSettingsGetRequest.ViewValueValuesEnum(FLAGS.view)
    result = client.services_customerSettings.Get(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesCustomerSettingsPatch(apitools_base_cli.NewCmd):
  """Command wrapping services_customerSettings.Patch."""

  usage = """services_customerSettings_patch <serviceName> <customerId>"""

  def __init__(self, name, fv):
    super(ServicesCustomerSettingsPatch, self).__init__(name, fv)
    flags.DEFINE_string(
        'customerSettings',
        None,
        u'A CustomerSettings resource to be passed as the request body.',
        flag_values=fv)
    flags.DEFINE_string(
        'updateMask',
        None,
        u'The field mask specifying which fields are to be updated.',
        flag_values=fv)

  def RunWithArgs(self, serviceName, customerId):
    """Updates specified subset of the settings that control the specified
    customer's usage of the service.  Attempts to update a field not
    controlled by the caller will result in an access denied error.
    Operation<response: CustomerSettings>

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`. This
        field is required.
      customerId: ID for the customer. See the comment for
        `CustomerSettings.customer_id` field of message for its format. This
        field is required.

    Flags:
      customerSettings: A CustomerSettings resource to be passed as the
        request body.
      updateMask: The field mask specifying which fields are to be updated.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesCustomerSettingsPatchRequest(
        serviceName=serviceName.decode('utf8'),
        customerId=customerId.decode('utf8'),
        )
    if FLAGS['customerSettings'].present:
      request.customerSettings = apitools_base.JsonToMessage(messages.CustomerSettings, FLAGS.customerSettings)
    if FLAGS['updateMask'].present:
      request.updateMask = FLAGS.updateMask.decode('utf8')
    result = client.services_customerSettings.Patch(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesProjectSettingsGet(apitools_base_cli.NewCmd):
  """Command wrapping services_projectSettings.Get."""

  usage = """services_projectSettings_get <serviceName> <consumerProjectId>"""

  def __init__(self, name, fv):
    super(ServicesProjectSettingsGet, self).__init__(name, fv)
    flags.DEFINE_string(
        'expand',
        None,
        u'Fields to expand in any results.  By default, the following fields '
        u'are not present in the result: - `operations` - `quota_usage`',
        flag_values=fv)
    flags.DEFINE_enum(
        'view',
        u'PROJECT_SETTINGS_VIEW_UNSPECIFIED',
        [u'PROJECT_SETTINGS_VIEW_UNSPECIFIED', u'CONSUMER_VIEW', u'PRODUCER_VIEW', u'ALL'],
        u'Request only the fields for the specified view.',
        flag_values=fv)

  def RunWithArgs(self, serviceName, consumerProjectId):
    """Retrieves the settings that control the specified consumer project's
    usage of the service.

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.
      consumerProjectId: The project ID of the consumer.

    Flags:
      expand: Fields to expand in any results.  By default, the following
        fields are not present in the result: - `operations` - `quota_usage`
      view: Request only the fields for the specified view.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesProjectSettingsGetRequest(
        serviceName=serviceName.decode('utf8'),
        consumerProjectId=consumerProjectId.decode('utf8'),
        )
    if FLAGS['expand'].present:
      request.expand = FLAGS.expand.decode('utf8')
    if FLAGS['view'].present:
      request.view = messages.ServicemanagementServicesProjectSettingsGetRequest.ViewValueValuesEnum(FLAGS.view)
    result = client.services_projectSettings.Get(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesProjectSettingsPatch(apitools_base_cli.NewCmd):
  """Command wrapping services_projectSettings.Patch."""

  usage = """services_projectSettings_patch <serviceName> <consumerProjectId>"""

  def __init__(self, name, fv):
    super(ServicesProjectSettingsPatch, self).__init__(name, fv)
    flags.DEFINE_string(
        'projectSettings',
        None,
        u'A ProjectSettings resource to be passed as the request body.',
        flag_values=fv)
    flags.DEFINE_string(
        'updateMask',
        None,
        u'The field mask specifying which fields are to be updated.',
        flag_values=fv)

  def RunWithArgs(self, serviceName, consumerProjectId):
    """Updates specified subset of the settings that control the specified
    consumer project's usage of the service.  Attempts to update a field not
    controlled by the caller will result in an access denied error.
    Operation<response: ProjectSettings>

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.  For example: `example.googleapis.com`.
      consumerProjectId: The project ID of the consumer.

    Flags:
      projectSettings: A ProjectSettings resource to be passed as the request
        body.
      updateMask: The field mask specifying which fields are to be updated.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ServicemanagementServicesProjectSettingsPatchRequest(
        serviceName=serviceName.decode('utf8'),
        consumerProjectId=consumerProjectId.decode('utf8'),
        )
    if FLAGS['projectSettings'].present:
      request.projectSettings = apitools_base.JsonToMessage(messages.ProjectSettings, FLAGS.projectSettings)
    if FLAGS['updateMask'].present:
      request.updateMask = FLAGS.updateMask.decode('utf8')
    result = client.services_projectSettings.Patch(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ServicesProjectSettingsUpdate(apitools_base_cli.NewCmd):
  """Command wrapping services_projectSettings.Update."""

  usage = """services_projectSettings_update <serviceName> <consumerProjectId>"""

  def __init__(self, name, fv):
    super(ServicesProjectSettingsUpdate, self).__init__(name, fv)
    flags.DEFINE_string(
        'operations',
        None,
        u'Read-only view of pending operations affecting this resource, if '
        u'requested.',
        flag_values=fv)
    flags.DEFINE_string(
        'properties',
        None,
        u'Service-defined per-consumer properties.  A key-value mapping a '
        u'string key to a google.protobuf.ListValue proto. Values in the list'
        u" are typed as defined in the Service configuration's "
        u'consumer.properties field.',
        flag_values=fv)
    flags.DEFINE_string(
        'quotaSettings',
        None,
        u'Settings that control how much or how fast the service can be used '
        u'by the consumer project.',
        flag_values=fv)
    flags.DEFINE_string(
        'usageSettings',
        None,
        u'Settings that control whether this service is usable by the '
        u'consumer project.',
        flag_values=fv)
    flags.DEFINE_string(
        'visibilitySettings',
        None,
        u'Settings that control which features of the service are visible to '
        u'the consumer project.',
        flag_values=fv)

  def RunWithArgs(self, serviceName, consumerProjectId):
    """NOTE: Currently unsupported.  Use PatchProjectSettings instead.
    Updates the settings that control the specified consumer project's usage
    of the service.  Attempts to update a field not controlled by the caller
    will result in an access denied error.  Operation<response:
    ProjectSettings>

    Args:
      serviceName: The name of the service.  See the `ServiceManager` overview
        for naming requirements.
      consumerProjectId: ID for the project consuming this service.

    Flags:
      operations: Read-only view of pending operations affecting this
        resource, if requested.
      properties: Service-defined per-consumer properties.  A key-value
        mapping a string key to a google.protobuf.ListValue proto. Values in
        the list are typed as defined in the Service configuration's
        consumer.properties field.
      quotaSettings: Settings that control how much or how fast the service
        can be used by the consumer project.
      usageSettings: Settings that control whether this service is usable by
        the consumer project.
      visibilitySettings: Settings that control which features of the service
        are visible to the consumer project.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ProjectSettings(
        serviceName=serviceName.decode('utf8'),
        consumerProjectId=consumerProjectId.decode('utf8'),
        )
    if FLAGS['operations'].present:
      request.operations = [apitools_base.JsonToMessage(messages.Operation, x) for x in FLAGS.operations]
    if FLAGS['properties'].present:
      request.properties = apitools_base.JsonToMessage(messages.ProjectSettings.PropertiesValue, FLAGS.properties)
    if FLAGS['quotaSettings'].present:
      request.quotaSettings = apitools_base.JsonToMessage(messages.QuotaSettings, FLAGS.quotaSettings)
    if FLAGS['usageSettings'].present:
      request.usageSettings = apitools_base.JsonToMessage(messages.UsageSettings, FLAGS.usageSettings)
    if FLAGS['visibilitySettings'].present:
      request.visibilitySettings = apitools_base.JsonToMessage(messages.VisibilitySettings, FLAGS.visibilitySettings)
    result = client.services_projectSettings.Update(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


class ConvertConfig(apitools_base_cli.NewCmd):
  """Command wrapping v1.ConvertConfig."""

  usage = """convertConfig"""

  def __init__(self, name, fv):
    super(ConvertConfig, self).__init__(name, fv)
    flags.DEFINE_string(
        'configSpec',
        None,
        u'Input configuration For this version of API, the supported type is '
        u'OpenApiSpec',
        flag_values=fv)
    flags.DEFINE_string(
        'openApiSpec',
        None,
        u'The OpenAPI specification for an API.',
        flag_values=fv)
    flags.DEFINE_string(
        'serviceName',
        None,
        u'The service name to use for constructing the normalized service '
        u'configuration equivalent of the provided configuration '
        u'specification.',
        flag_values=fv)
    flags.DEFINE_string(
        'swaggerSpec',
        None,
        u'The swagger specification for an API.',
        flag_values=fv)

  def RunWithArgs(self):
    """DEPRECATED. `SubmitConfigSource` with `validate_only=true` will provide
    config conversion moving forward.  Converts an API specification (e.g.
    Swagger spec) to an equivalent `google.api.Service`.

    Flags:
      configSpec: Input configuration For this version of API, the supported
        type is OpenApiSpec
      openApiSpec: The OpenAPI specification for an API.
      serviceName: The service name to use for constructing the normalized
        service configuration equivalent of the provided configuration
        specification.
      swaggerSpec: The swagger specification for an API.
    """
    client = GetClientFromFlags()
    global_params = GetGlobalParamsFromFlags()
    request = messages.ConvertConfigRequest(
        )
    if FLAGS['configSpec'].present:
      request.configSpec = apitools_base.JsonToMessage(messages.ConvertConfigRequest.ConfigSpecValue, FLAGS.configSpec)
    if FLAGS['openApiSpec'].present:
      request.openApiSpec = apitools_base.JsonToMessage(messages.OpenApiSpec, FLAGS.openApiSpec)
    if FLAGS['serviceName'].present:
      request.serviceName = FLAGS.serviceName.decode('utf8')
    if FLAGS['swaggerSpec'].present:
      request.swaggerSpec = apitools_base.JsonToMessage(messages.SwaggerSpec, FLAGS.swaggerSpec)
    result = client.v1.ConvertConfig(
        request, global_params=global_params)
    print apitools_base_cli.FormatOutput(result)


def main(_):
  appcommands.AddCmd('pyshell', PyShell)
  appcommands.AddCmd('operations_get', OperationsGet)
  appcommands.AddCmd('services_convertConfig', ServicesConvertConfig)
  appcommands.AddCmd('services_create', ServicesCreate)
  appcommands.AddCmd('services_delete', ServicesDelete)
  appcommands.AddCmd('services_disable', ServicesDisable)
  appcommands.AddCmd('services_enable', ServicesEnable)
  appcommands.AddCmd('services_get', ServicesGet)
  appcommands.AddCmd('services_getAccessPolicy', ServicesGetAccessPolicy)
  appcommands.AddCmd('services_getConfig', ServicesGetConfig)
  appcommands.AddCmd('services_list', ServicesList)
  appcommands.AddCmd('services_patch', ServicesPatch)
  appcommands.AddCmd('services_patchConfig', ServicesPatchConfig)
  appcommands.AddCmd('services_update', ServicesUpdate)
  appcommands.AddCmd('services_updateAccessPolicy', ServicesUpdateAccessPolicy)
  appcommands.AddCmd('services_updateConfig', ServicesUpdateConfig)
  appcommands.AddCmd('services_accessPolicy_query', ServicesAccessPolicyQuery)
  appcommands.AddCmd('services_configs_create', ServicesConfigsCreate)
  appcommands.AddCmd('services_configs_get', ServicesConfigsGet)
  appcommands.AddCmd('services_configs_list', ServicesConfigsList)
  appcommands.AddCmd('services_configs_submit', ServicesConfigsSubmit)
  appcommands.AddCmd('services_customerSettings_get', ServicesCustomerSettingsGet)
  appcommands.AddCmd('services_customerSettings_patch', ServicesCustomerSettingsPatch)
  appcommands.AddCmd('services_projectSettings_get', ServicesProjectSettingsGet)
  appcommands.AddCmd('services_projectSettings_patch', ServicesProjectSettingsPatch)
  appcommands.AddCmd('services_projectSettings_update', ServicesProjectSettingsUpdate)
  appcommands.AddCmd('convertConfig', ConvertConfig)

  apitools_base_cli.SetupLogger()
  if hasattr(appcommands, 'SetDefaultCommand'):
    appcommands.SetDefaultCommand('pyshell')


run_main = apitools_base_cli.run_main

if __name__ == '__main__':
  appcommands.Run()
