"""Generated message classes for categorymanager version v1alpha2.

Google Cloud Category Manager API.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'categorymanager'


class Annotation(_messages.Message):
  r"""Each annotation denotes one category in a taxonomy (e.g. ssn).
  Annotations can be defined in a hierarchy. For example, consider the
  following hierachy:               Geolocation                    |
  ------------------------------------   |                |                 |
  LatLong          City              ZipCode Annotation "Geolocation" contains
  three child annotations: "LatLong", "City", and "ZipCode".

  Fields:
    childAnnotationIds: Ids of child annotations of this annotation.
    description: Description of the annotation. Length of the description is
      limited to 1000 characters.
    displayName: Human readable name of this annotation. Max 100 characters.
    name: Resource name of the annotation, whose format is one of the
      followings:
      "taxonomyStores/{store_id}/taxonomies/{taxonomy_id}/annotations/{id}"
      "projects/{project_id}/taxonomies/{taxonomy_id}/annotations/{id}".
    parentAnnotationId: Id of the parent annotation to this annotation. If
      empty, it means this annotation is a top level annotation.
    taxonomyDisplayName: Output only. Human readable name of the enclosing
      taxonomy.
  """

  childAnnotationIds = _messages.StringField(1, repeated=True)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)
  parentAnnotationId = _messages.StringField(5)
  taxonomyDisplayName = _messages.StringField(6)


class AnnotationTag(_messages.Message):
  r"""An annotation tag on an asset (e.g. a Cloud spanner table).  Each asset
  can have multiple annotation tags, but only one annotation tag from each
  taxonomy.

  Fields:
    annotation: Output only. Resource name of the annotation.
    annotationDisplayName: Output only. Human readable name of the annotation
      corresponding to this tag.
    asset: Output only. Resource name of the asset.
    subAsset: Output only. A finer grained sub asset that this annotation tag
      is applied to. For Bigquery, provide the name of the column you want to
      annotate. If this field is empty, the given annotation tag is associated
      with the entire asset.
    taxonomyDisplayName: Output only. Human readable name of the taxonomy
      enclosing the annotation corresponding to this tag.
  """

  annotation = _messages.StringField(1)
  annotationDisplayName = _messages.StringField(2)
  asset = _messages.StringField(3)
  subAsset = _messages.StringField(4)
  taxonomyDisplayName = _messages.StringField(5)


class ApplyAnnotationTagRequest(_messages.Message):
  r"""Request message for "TaggingApi.ApplyAnnotationTag".

  Fields:
    annotation: [Required] Resource name of the annotation tag.
    subAsset: A finer grained sub asset that this annotation tag is applied
      to. For Bigquery, provide the name of the column you want to annotate.
      If this field is empty, the given annotation tag is associated with the
      entire asset.
  """

  annotation = _messages.StringField(1)
  subAsset = _messages.StringField(2)


class Asset(_messages.Message):
  r"""A message that include asset resource name and some auxiliary
  information.

  Enums:
    TypeValueValuesEnum: Type of the asset, if available.

  Fields:
    annotatable: Whether the asset is annotatable.
    createTime: The creation time.
    description: Description of the asset, if available.
    displayName: Display name of the asset, if available.
    name: Resource name of the asset.
    projectId: Id of the project that owns the asset, if available.
    subAsset: A finer grained sub asset. If one asset is a bigquery table this
      sub asset contains the column name. If this field is empty, the message
      denotes the entire asset.
    type: Type of the asset, if available.
    updateTime: The last modified time.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of the asset, if available.

    Values:
      TYPE_UNSPECIFIED: Unknown type.
      BIGQUERY_TABLE: BigQuery table.
      BIGQUERY_TABLE_COLUMN: A column in a BigQuery table.
      GCS_FILESET: A GCS file set.
      PUBSUB_TOPIC: A Pubsub topic.
    """
    TYPE_UNSPECIFIED = 0
    BIGQUERY_TABLE = 1
    BIGQUERY_TABLE_COLUMN = 2
    GCS_FILESET = 3
    PUBSUB_TOPIC = 4

  annotatable = _messages.BooleanField(1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  name = _messages.StringField(5)
  projectId = _messages.StringField(6)
  subAsset = _messages.StringField(7)
  type = _messages.EnumField('TypeValueValuesEnum', 8)
  updateTime = _messages.StringField(9)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:foo@gmail.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "fooservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:bar@gmail.com"               ]             }           ]         }
  ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      .   * `serviceAccount:{emailid}`: An email address that represents a
      service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`. Required
  """

  members = _messages.StringField(1, repeated=True)
  role = _messages.StringField(2)


class CategorymanagerAssetsAnnotationTagsListRequest(_messages.Message):
  r"""A CategorymanagerAssetsAnnotationTagsListRequest object.

  Fields:
    name: [Required] Resource name of the asset, must be RFC3986 escaped.
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    subAsset: A finer grained sub asset of the asset to list annotation tags.
      For Bigquery, provide the name of the column you list annotation tags.
      If this field is empty, list annotation tags that are associated with
      the entire asset.
  """

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  subAsset = _messages.StringField(4)


class CategorymanagerAssetsApplyAnnotationTagRequest(_messages.Message):
  r"""A CategorymanagerAssetsApplyAnnotationTagRequest object.

  Fields:
    applyAnnotationTagRequest: A ApplyAnnotationTagRequest resource to be
      passed as the request body.
    name: [Required] Resource name of the asset to annotate, must be RFC3986
      escaped.
  """

  applyAnnotationTagRequest = _messages.MessageField('ApplyAnnotationTagRequest', 1)
  name = _messages.StringField(2, required=True)


class CategorymanagerAssetsDeleteAnnotationTagRequest(_messages.Message):
  r"""A CategorymanagerAssetsDeleteAnnotationTagRequest object.

  Fields:
    annotation: [Required] Resource name of the annotation tag to be removed.
      The request will be failed with a NOT_FOUND error if the annotation is
      not tagged on the given asset / sub asset.
    name: [Required] Resource name of the asset whose annotation tag is to be
      removed, must be RFC3986 escaped.
    subAsset: A finer grained sub asset whose annotation tag is to be removed.
      For Bigquery, provide the name of the column that contains the
      annotation tag. If this field is empty, it means given annotation tag is
      associated with the entire asset.
  """

  annotation = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  subAsset = _messages.StringField(3)


class CategorymanagerAssetsSearchRequest(_messages.Message):
  r"""A CategorymanagerAssetsSearchRequest object.

  Fields:
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    query_annotatableOnly: Filter on whether to exclude assets that are not
      annotatable.
    query_annotations: Resource names of annotations to be looked up.
    query_createAgeFilter_maxAge: The maximum age.
    query_createAgeFilter_minAge: The minimum age.
    query_filter: A filter string that includes additional predicates for
      assets.
    query_includeAnnotatedByGroup: If set to true, for any annotation with
      child annotations, also list assets that are annotated by those child
      annotations.
    query_updateAgeFilter_maxAge: The maximum age.
    query_updateAgeFilter_minAge: The minimum age.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  query_annotatableOnly = _messages.BooleanField(3)
  query_annotations = _messages.StringField(4, repeated=True)
  query_createAgeFilter_maxAge = _messages.StringField(5)
  query_createAgeFilter_minAge = _messages.StringField(6)
  query_filter = _messages.StringField(7)
  query_includeAnnotatedByGroup = _messages.BooleanField(8)
  query_updateAgeFilter_maxAge = _messages.StringField(9)
  query_updateAgeFilter_minAge = _messages.StringField(10)


class CategorymanagerOperationsGetRequest(_messages.Message):
  r"""A CategorymanagerOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CategorymanagerOrganizationsGetTaxonomyStoreRequest(_messages.Message):
  r"""A CategorymanagerOrganizationsGetTaxonomyStoreRequest object.

  Fields:
    parent: [Required] id of the organization that contains the taxonomy
      store.
  """

  parent = _messages.StringField(1, required=True)


class CategorymanagerProjectsCopyRequest(_messages.Message):
  r"""A CategorymanagerProjectsCopyRequest object.

  Fields:
    copyTaxonomyRequest: A CopyTaxonomyRequest resource to be passed as the
      request body.
    parent: [Required] Resource name of the taxonomy store that the taxonomy
      is copied to.
  """

  copyTaxonomyRequest = _messages.MessageField('CopyTaxonomyRequest', 1)
  parent = _messages.StringField(2, required=True)


class CategorymanagerProjectsTaxonomiesAnnotationsCreateRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesAnnotationsCreateRequest object.

  Fields:
    annotation: A Annotation resource to be passed as the request body.
    parent: [Required] Resource name of the taxonomy that the newly created
      annotation belongs to.
  """

  annotation = _messages.MessageField('Annotation', 1)
  parent = _messages.StringField(2, required=True)


class CategorymanagerProjectsTaxonomiesAnnotationsDeleteRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesAnnotationsDeleteRequest object.

  Fields:
    name: [Required] Resource name of the annotation to be deleted.
  """

  name = _messages.StringField(1, required=True)


class CategorymanagerProjectsTaxonomiesAnnotationsGetRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesAnnotationsGetRequest object.

  Fields:
    name: [Required] Resource name of the annotation to be returned.
  """

  name = _messages.StringField(1, required=True)


class CategorymanagerProjectsTaxonomiesAnnotationsListRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesAnnotationsListRequest object.

  Fields:
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: [Required] Resource name of a taxonomy.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CategorymanagerProjectsTaxonomiesAnnotationsPatchRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesAnnotationsPatchRequest object.

  Fields:
    annotation: A Annotation resource to be passed as the request body.
    name: [Required] Resource name of the annotation to be updated.
    updateMask: The update mask applies to the resource. Only description and
      parent_annotation_id can be updated and thus can be listed in the mask.
      If update_mask is not provided, all allowed fields (i.e., description
      and parent_id) will be updated. For more information including the
      `FieldMask` definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  annotation = _messages.MessageField('Annotation', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CategorymanagerProjectsTaxonomiesCopyRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesCopyRequest object.

  Fields:
    copyAnnotationRequest: A CopyAnnotationRequest resource to be passed as
      the request body.
    parent: [Required] Resource name of the taxonomy that the annotation is
      copied to.
  """

  copyAnnotationRequest = _messages.MessageField('CopyAnnotationRequest', 1)
  parent = _messages.StringField(2, required=True)


class CategorymanagerProjectsTaxonomiesCreateRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesCreateRequest object.

  Fields:
    parent: [Required] Resource name of the taxonomy store that the newly
      created taxonomy belongs to.
    taxonomy: A Taxonomy resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  taxonomy = _messages.MessageField('Taxonomy', 2)


class CategorymanagerProjectsTaxonomiesDeleteRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesDeleteRequest object.

  Fields:
    name: [Required] Resource name of the taxonomy to be deleted.
  """

  name = _messages.StringField(1, required=True)


class CategorymanagerProjectsTaxonomiesGetIamPolicyRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class CategorymanagerProjectsTaxonomiesGetRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesGetRequest object.

  Fields:
    name: [Required] Resource name of the taxonomy to be returned.
  """

  name = _messages.StringField(1, required=True)


class CategorymanagerProjectsTaxonomiesListRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesListRequest object.

  Fields:
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous list
      request, if any.
    parent: [Required] Resource name of a taxonomy store.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CategorymanagerProjectsTaxonomiesPatchRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesPatchRequest object.

  Fields:
    name: [Required] Resource name of the taxonomy to be updated.
    taxonomy: A Taxonomy resource to be passed as the request body.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask Will only update
      description if update_mask is not provided.
  """

  name = _messages.StringField(1, required=True)
  taxonomy = _messages.MessageField('Taxonomy', 2)
  updateMask = _messages.StringField(3)


class CategorymanagerProjectsTaxonomiesSetIamPolicyRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CategorymanagerProjectsTaxonomiesTestIamPermissionsRequest(_messages.Message):
  r"""A CategorymanagerProjectsTaxonomiesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CategorymanagerTaxonomiesSearchRequest(_messages.Message):
  r"""A CategorymanagerTaxonomiesSearchRequest object.

  Fields:
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous list
      request, if any.
    parent: [Required] id of the resource to search taxonomies from.
    query: Regular expression query pattern for search taxonomies. An empty
      pattern will match all taxonomies.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3)
  query = _messages.StringField(4)


class CategorymanagerTaxonomyStoresCopyRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresCopyRequest object.

  Fields:
    copyTaxonomyRequest: A CopyTaxonomyRequest resource to be passed as the
      request body.
    parent: [Required] Resource name of the taxonomy store that the taxonomy
      is copied to.
  """

  copyTaxonomyRequest = _messages.MessageField('CopyTaxonomyRequest', 1)
  parent = _messages.StringField(2, required=True)


class CategorymanagerTaxonomyStoresGetCommonRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresGetCommonRequest object."""


class CategorymanagerTaxonomyStoresGetIamPolicyRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class CategorymanagerTaxonomyStoresSetIamPolicyRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CategorymanagerTaxonomyStoresTaxonomiesAnnotationsCreateRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesAnnotationsCreateRequest
  object.

  Fields:
    annotation: A Annotation resource to be passed as the request body.
    parent: [Required] Resource name of the taxonomy that the newly created
      annotation belongs to.
  """

  annotation = _messages.MessageField('Annotation', 1)
  parent = _messages.StringField(2, required=True)


class CategorymanagerTaxonomyStoresTaxonomiesAnnotationsDeleteRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesAnnotationsDeleteRequest
  object.

  Fields:
    name: [Required] Resource name of the annotation to be deleted.
  """

  name = _messages.StringField(1, required=True)


class CategorymanagerTaxonomyStoresTaxonomiesAnnotationsGetRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesAnnotationsGetRequest object.

  Fields:
    name: [Required] Resource name of the annotation to be returned.
  """

  name = _messages.StringField(1, required=True)


class CategorymanagerTaxonomyStoresTaxonomiesAnnotationsListRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesAnnotationsListRequest object.

  Fields:
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: [Required] Resource name of a taxonomy.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CategorymanagerTaxonomyStoresTaxonomiesAnnotationsPatchRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesAnnotationsPatchRequest object.

  Fields:
    annotation: A Annotation resource to be passed as the request body.
    name: [Required] Resource name of the annotation to be updated.
    updateMask: The update mask applies to the resource. Only description and
      parent_annotation_id can be updated and thus can be listed in the mask.
      If update_mask is not provided, all allowed fields (i.e., description
      and parent_id) will be updated. For more information including the
      `FieldMask` definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  annotation = _messages.MessageField('Annotation', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CategorymanagerTaxonomyStoresTaxonomiesCopyRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesCopyRequest object.

  Fields:
    copyAnnotationRequest: A CopyAnnotationRequest resource to be passed as
      the request body.
    parent: [Required] Resource name of the taxonomy that the annotation is
      copied to.
  """

  copyAnnotationRequest = _messages.MessageField('CopyAnnotationRequest', 1)
  parent = _messages.StringField(2, required=True)


class CategorymanagerTaxonomyStoresTaxonomiesCreateRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesCreateRequest object.

  Fields:
    parent: [Required] Resource name of the taxonomy store that the newly
      created taxonomy belongs to.
    taxonomy: A Taxonomy resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  taxonomy = _messages.MessageField('Taxonomy', 2)


class CategorymanagerTaxonomyStoresTaxonomiesDeleteRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesDeleteRequest object.

  Fields:
    name: [Required] Resource name of the taxonomy to be deleted.
  """

  name = _messages.StringField(1, required=True)


class CategorymanagerTaxonomyStoresTaxonomiesGetIamPolicyRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class CategorymanagerTaxonomyStoresTaxonomiesGetRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesGetRequest object.

  Fields:
    name: [Required] Resource name of the taxonomy to be returned.
  """

  name = _messages.StringField(1, required=True)


class CategorymanagerTaxonomyStoresTaxonomiesListRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesListRequest object.

  Fields:
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous list
      request, if any.
    parent: [Required] Resource name of a taxonomy store.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CategorymanagerTaxonomyStoresTaxonomiesPatchRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesPatchRequest object.

  Fields:
    name: [Required] Resource name of the taxonomy to be updated.
    taxonomy: A Taxonomy resource to be passed as the request body.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask Will only update
      description if update_mask is not provided.
  """

  name = _messages.StringField(1, required=True)
  taxonomy = _messages.MessageField('Taxonomy', 2)
  updateMask = _messages.StringField(3)


class CategorymanagerTaxonomyStoresTaxonomiesSetIamPolicyRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CategorymanagerTaxonomyStoresTaxonomiesTestIamPermissionsRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTaxonomiesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CategorymanagerTaxonomyStoresTestIamPermissionsRequest(_messages.Message):
  r"""A CategorymanagerTaxonomyStoresTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CopyAnnotationRequest(_messages.Message):
  r"""Request message for "CategoryApi.CopyAnnotation".

  Fields:
    parentAnnotationId: If provided, the copied annotation will be a child
      annotation of the given annotation.
    sourceAnnotation: [Required] Resource name of the annotation to be copied
      from.
  """

  parentAnnotationId = _messages.StringField(1)
  sourceAnnotation = _messages.StringField(2)


class CopyTaxonomyRequest(_messages.Message):
  r"""Request message for "CategoryApi.CopyTaxonomy".

  Fields:
    sourceTaxonomy: [Required] Resource name of the taxonomy to be copied
      from.
  """

  sourceTaxonomy = _messages.StringField(1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method."""


class ListAnnotationTagsResponse(_messages.Message):
  r"""Response message for "TaggingApi.ListAnnotationTags".

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    tags: Annotation tags on the asset.
  """

  nextPageToken = _messages.StringField(1)
  tags = _messages.MessageField('AnnotationTag', 2, repeated=True)


class ListAnnotationsResponse(_messages.Message):
  r"""Response message for "CategoryApi.ListAnnotations".

  Fields:
    annotations: Annotations that are in this taxonomy.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  annotations = _messages.MessageField('Annotation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListTaxonomiesResponse(_messages.Message):
  r"""Response message for "CategoryApi.ListTaxonomies".

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    taxonomies: Taxonomies that the taxonomy store or the project contains.
  """

  nextPageToken = _messages.StringField(1)
  taxonomies = _messages.MessageField('Taxonomy', 2, repeated=True)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    version: Deprecated.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class SearchAssetsResponse(_messages.Message):
  r"""Response message for "TaggingApi.SearchAssets".

  Fields:
    assets: A list of asset resource names with auxiliary information.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  assets = _messages.MessageField('Asset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SearchTaxonomiesResponse(_messages.Message):
  r"""Response message for "CategoryApi.SearchTaxonomies".

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    taxonomies: Taxonomies whose display name matches given regular
      expression.
  """

  nextPageToken = _messages.StringField(1)
  taxonomies = _messages.MessageField('Taxonomy', 2, repeated=True)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Taxonomy(_messages.Message):
  r"""A taxonomy is a collection of categories of business significance,
  typically associated with the substance of the category (e.g. credit card,
  SSN), or how it is used (e.g. account name, user ID).

  Fields:
    description: Description of the taxonomy. Length of the description is
      limited to 1000 characters.
    displayName: Name of the taxonomy. Should be no more than 100 characters.
    name: Resource name of the taxonomy, whose format is one of the
      followings: "taxonomyStores/{store_id}/taxonomies/{id}"
      "projects/{project_id}/taxonomies/{id}".
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  name = _messages.StringField(3)


class TaxonomyStore(_messages.Message):
  r"""A taxonomy store keeps a collection of taxonomies. Each organization or
  each project that does not belong to any organization can have at most one
  taxonomy store.

  Fields:
    crmNodeName: Resource name of the CRM node to which this store is
      attached. Only organizations are supported; the crm_node_name will be of
      the form "organizations/{org_id}".
    name: Resource name of the taxonomy store, which has the format of
      "taxonomyStores/{store_id}".
  """

  crmNodeName = _messages.StringField(1)
  name = _messages.StringField(2)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
