# Copyright 2017 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Command group for cloud category manager."""

from __future__ import absolute_import
from __future__ import unicode_literals
from googlecloudsdk.calliope import base


@base.Hidden
@base.ReleaseTracks(base.ReleaseTrack.ALPHA)
class DataPolEAP(base.Group):
  """Cloud category manager command groups.

  Commands to create / update / delete data taxonomies and labels, and tag
  data objects in cloud storage.
  """

  def Filter(self, context, args):
    del context, args
    base.DisableUserProjectQuota()
