"""
Classes in this file
1. Product.
2. Version
3. CaseAttachment
4. CaseGroup
5. Entitlement
6. Comment
7. CaseResourceLink
8. Case
9. KCSDescription
10. Contact
11. Values
12. KCSSearch
13. CaseFilter
14. Solution
15. Article
16. Recommendation
"""


def from_int(x):
    assert isinstance(x, int) and not isinstance(x, bool)
    return x


def from_bool(x):
    assert isinstance(x, bool)
    return x


def from_float(x):
    assert isinstance(x, (float, int)) and not isinstance(x, bool)
    return float(x)


def from_none(x):
    assert x is None
    return x


def from_union(fs, x):
    for f in fs:
        try:
            return f(x)
        except:
            pass
    assert False


def from_str(x):
    assert isinstance(x, str)
    return x


def from_list(f, x):
    assert isinstance(x, list)
    return [f(y) for y in x]


def to_class(c, x):
    assert isinstance(x, c)
    return x.to_dict()


def to_float(x):
    assert isinstance(x, float)
    return x


def from_any(x):
    return x


class Product:
    '''
    Product class
    '''

    def __init__(self, productId=None, name=None, supportedForCustomer=None,
                 openShiftClusterIdRelevantInCases=None, recentlyFiledAgainst=None):
        self.productId = productId
        self.name = name
        self.supportedForCustomer = supportedForCustomer
        self.openShiftClusterIdRelevantInCases = openShiftClusterIdRelevantInCases
        self.recentlyFiledAgainst = recentlyFiledAgainst

    def get_productId(self): return self.productId
    def get_name(self): return self.name
    def get_supportedForCustomer(self): return self.supportedForCustomer
    def get_openShiftClusterIdRelevantInCases(self): return self.openShiftClusterIdRelevantInCases
    def get_recentlyFiledAgainst(self): return self.recentlyFiledAgainst
    def set_productId(self, productId): self.productId = productId
    def set_name(self, name): self.name = name
    def set_supportedForCustomer(self, supportedForCustomer): self.supportedForCustomer = supportedForCustomer
    def set_openShiftClusterIdRelevantInCases(self, openShiftClusterIdRelevantInCases):
        self.openShiftClusterIdRelevantInCases = openShiftClusterIdRelevantInCases
    def set_recentlyFiledAgainst(self, recentlyFiledAgainst): self.recentlyFiledAgainst = recentlyFiledAgainst

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        productId = from_union([from_str, from_none], obj.get("productId"))
        name = from_union([from_str, from_none], obj.get("name"))
        supportedForCustomer = from_union([from_bool, from_none], obj.get("supportedForCustomer"))
        openShiftClusterIdRelevantInCases = from_union([from_bool, from_none], obj.get("openShiftClusterIdRelevantInCases"))
        recentlyFiledAgainst = from_union([from_bool, from_none], obj.get("recentlyFiledAgainst"))
        return Product(productId, name, supportedForCustomer, openShiftClusterIdRelevantInCases, recentlyFiledAgainst)

    def to_dict(self):
        result: dict = {}
        result["productId"] = from_union([from_str, from_none], self.productId)
        result["name"] = from_union([from_str, from_none], self.name)
        result["supportedForCustomer"] = from_union([from_bool, from_none], self.supportedForCustomer)
        result["openShiftClusterIdRelevantInCases"] = from_union([from_bool, from_none], self.openShiftClusterIdRelevantInCases)
        result["recentlyFiledAgainst"] = from_union([from_bool, from_none], self.recentlyFiledAgainst)
        return result


def Productsfromdict(s):
    return from_list(Product.from_dict, s)


def Productstodict(x):
    return from_list(lambda x: to_class(Product, x), x)


def Productfromdict(s):
    return Product.from_dict(s)


def Producttodict(x):
    return to_class(Product, x)


class Version:
    '''
    Used for product versions.
    '''

    def __init__(self, id=None, name=None, availableForCertifications=None,
                 doNotShowIRT=None):
        self.id = id
        self.name = name
        self.availableForCertifications = availableForCertifications
        self.doNotShowIRT = doNotShowIRT


    def get_id(self): return self.id
    def get_name(self): return self.name
    def get_availableForCertifications(self): return self.availableForCertifications
    def get_doNotShowIRT(self): return self.doNotShowIRT
    def set_id(self, id): self.id=id
    def set_name(self, name): self.name=name
    def set_availableForCertifications(self, availableForCertifications): self.availableForCertifications=availableForCertifications
    def set_doNotShowIRT(self, doNotShowIRT): self.doNotShowIRT=doNotShowIRT


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        id = from_union([from_str, from_none], obj.get("id"))
        name = from_union([from_str, from_none], obj.get("name"))
        availableForCertifications = from_union([from_bool, from_none], obj.get("availableForCertifications"))
        doNotShowIRT = from_union([from_bool, from_none], obj.get("doNotShowIRT"))
        return Version(id, name, availableForCertifications, doNotShowIRT)

    def to_dict(self):
        result: dict = {}
        result["id"] = from_union([from_str, from_none], self.id)
        result["name"] = from_union([from_str, from_none], self.name)
        result["availableForCertifications"] = from_union([from_bool, from_none], self.availableForCertifications)
        result["doNotShowIRT"] = from_union([from_bool, from_none], self.doNotShowIRT)
        return result


def Versionsfromdict(s):
    return from_list(Version.from_dict, s)


def Versionstodict(x):
    return from_list(lambda x: to_class(Version, x), x)


def Versionfromdict(s):
    return Version.from_dict(s)


def Versiontodict(x):
    return to_class(Version, x)


def version_list(f, x):
    assert isinstance(x, list)
    return [f(y).name for y in x]


def get_version(s):
    return version_list(Version.from_dict, s)


class CaseAttachment:
    """
    Case Attachment class
    """

    def __init__(self, caseNumber=None, uuid=None, checksum=None,
                 createdDate=None, createdBy=None, description=None, fileName=None,
                 fileType=None, id=None, isArchived=None, isDeprecated=None,
                 isPrivate=None, lastModifiedDate=None, link=None, modifiedBy=None,
                 size=None, sizeKB=None, downloadRestricted=None):
        self.caseNumber = caseNumber
        self.uuid = uuid
        self.checksum = checksum
        self.createdDate = createdDate
        self.createdBy = createdBy
        self.description = description
        self.fileName = fileName
        self.fileType = fileType
        self.id = id
        self.isArchived = isArchived
        self.isDeprecated = isDeprecated
        self.isPrivate = isPrivate
        self.lastModifiedDate = lastModifiedDate
        self.link = link
        self.modifiedBy = modifiedBy
        self.size = size
        self.sizeKB = sizeKB
        self.downloadRestricted = downloadRestricted

    def get_caseNumber(self): return self.caseNumber
    def get_uuid(self): return self.uuid
    def get_checksum(self): return self.checksum
    def get_createdDate(self): return self.createdDate
    def get_createdBy(self): return self.createdBy
    def get_description(self): return self.description
    def get_fileName(self): return self.fileName
    def get_fileType(self): return self.fileType
    def get_id(self): return self.id
    def get_isArchived(self): return self.isArchived
    def get_isDeprecated(self): return self.isDeprecated
    def get_isPrivate(self): return self.isPrivate
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_link(self): return self.link
    def get_modifiedBy(self): return self.modifiedBy
    def get_size(self): return self.size
    def get_sizeKB(self): return self.sizeKB
    def get_downloadRestricted(self): return self.downloadRestricted
    def set_caseNumber(self, caseNumber): self.caseNumber = caseNumber
    def set_uuid(self, uuid): self.uuid = uuid
    def set_checksum(self, checksum): self.checksum = checksum
    def set_createdDate(self, createdDate): self.createdDate = createdDate
    def set_createdBy(self, createdBy): self.createdBy = createdBy
    def set_fileName(self, fileName): self.fileName = fileName
    def set_fileType(self, fileType): self.fileType = fileType
    def set_id(self, id): self.id = id
    def set_isArchived(self, isArchived): self.isArchived = isArchived
    def set_isDeprecated(self, isDeprecated): self.isDeprecated = isDeprecated
    def set_isPrivate(self, isPrivate): self.isPrivate = isPrivate
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate = lastModifiedDate
    def set_link(self, link): self.link = link
    def set_modifiedBy(self, modifiedBy): self.modifiedBy = modifiedBy
    def set_description(self, description): self.description = description
    def set_size(self, size): self.size = size
    def set_sizeKB(self, sizeKB): self.sizeKB = sizeKB
    def set_downloadRestricted(self, downloadRestricted): self.downloadRestricted = downloadRestricted

    # to maintain consistency
    def get_length(self): return self.size
    def get_uri(self): return self.link
    def set_length(self, length): self.size = length
    def set_uri(self, uri): self.link = uri

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        caseNumber = from_union([from_str, from_none], obj.get("caseNumber"))
        uuid = from_union([from_str, from_none], obj.get("uuid"))
        checksum = from_union([from_str, from_none], obj.get("checksum"))
        createdDate = from_union([from_any, from_none], obj.get("createdDate"))
        createdBy = from_union([from_str, from_none], obj.get("createdBy"))
        description = from_union([from_str, from_none], obj.get("description"))
        fileName = from_union([from_str, from_none], obj.get("fileName"))
        fileType = from_union([from_str, from_none], obj.get("fileType"))
        id = from_union([from_str, from_none], obj.get("id"))
        isArchived = from_union([from_bool, from_none], obj.get("isArchived"))
        isDeprecated = from_union([from_bool, from_none], obj.get("isDeprecated"))
        isPrivate = from_union([from_bool, from_none], obj.get("isPrivate"))
        lastModifiedDate = from_union([from_any, from_none], obj.get("lastModifiedDate"))
        link = from_union([from_str, from_none], obj.get("link"))
        modifiedBy = from_union([from_str, from_none], obj.get("modifiedBy"))
        size = from_union([from_any, from_none], obj.get("size"))
        sizeKB = from_union([from_any, from_none], obj.get("sizeKB"))
        downloadRestricted = from_union([from_bool, from_none], obj.get("downloadRestricted"))
        return CaseAttachment(caseNumber, uuid, checksum, createdDate, createdBy, description, fileName, fileType, id,
                              isArchived, isDeprecated, isPrivate, lastModifiedDate, link, modifiedBy, size, sizeKB,
                              downloadRestricted)

    def to_dict(self):
        result: dict = {}
        result["caseNumber"] = from_union([from_str, from_none], self.caseNumber)
        result["uuid"] = from_union([from_str, from_none], self.uuid)
        result["checksum"] = from_union([from_str, from_none], self.checksum)
        result["createdDate"] = from_union([from_any, from_none], self.createdDate)
        result["createdBy"] = from_union([from_str, from_none], self.createdBy)
        result["description"] = from_union([from_str, from_none], self.description)
        result["fileName"] = from_union([from_str, from_none], self.fileName)
        result["fileType"] = from_union([from_str, from_none], self.fileType)
        result["id"] = from_union([from_str, from_none], self.id)
        result["isArchived"] = from_union([from_bool, from_none], self.isArchived)
        result["isDeprecated"] = from_union([from_bool, from_none], self.isDeprecated)
        result["isPrivate"] = from_union([from_bool, from_none], self.isPrivate)
        result["lastModifiedDate"] = from_union([from_any, from_none], self.lastModifiedDate)
        result["link"] = from_union([from_str, from_none], self.link)
        result["modifiedBy"] = from_union([from_str, from_none], self.modifiedBy)
        result["size"] = from_union([from_any, from_none], self.size)
        result["sizeKB"] = from_union([from_any, from_none], self.sizeKB)
        result["downloadRestricted"] = from_union([from_bool, from_none], self.downloadRestricted)
        return result


def CaseAttachmentsfromdict(s):
    return from_list(CaseAttachment.from_dict, s)


def CaseAttachmentstodict(x):
    return from_list(lambda x: to_class(CaseAttachment, x), x)


def CaseAttachmentfromdict(s):
    return CaseAttachment.from_dict(s)


def CaseAttachmenttodict(x):
    return to_class(CaseAttachment, x)


class CaseGroup:
    """
    Case Group class
    """
    def __init__(self, groupNum=None, isDefault=None, isPrivate=None,
                 name=None):
        self.groupNum = groupNum
        self.isDefault = isDefault
        self.isPrivate = isPrivate
        self.name = name

    def get_groupNum(self): return self.groupNum
    def get_isDefault(self): return self.isDefault
    def get_isPrivate(self): return self.isPrivate
    def get_name(self): return self.name
    def set_groupNum(self, groupNum): self.groupNum=groupNum
    def set_isDefault(self, isDefault): self.isDefault=isDefault
    def set_isPrivate(self, isPrivate): self.isPrivate=isPrivate
    def set_name(self, name): self.name=name


    ## to keep consistency
    def get_number(self): return self.groupNum
    def set_number(self, groupNum): self.groupNum=groupNum

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        groupNum = from_union([from_str, from_none], obj.get("groupNum"))
        isDefault = from_union([from_bool, from_none], obj.get("isDefault"))
        isPrivate = from_union([from_bool, from_none], obj.get("isPrivate"))
        name = from_union([from_str, from_none], obj.get("name"))
        return CaseGroup(groupNum, isDefault, isPrivate, name)

    def to_dict(self):
        result: dict = {}
        result["groupNum"] = from_union([from_str, from_none], self.groupNum)
        result["isDefault"] = from_union([from_bool, from_none], self.isDefault)
        result["isPrivate"] = from_union([from_bool, from_none], self.isPrivate)
        result["name"] = from_union([from_str, from_none], self.name)
        return result


def CaseGroupsfromdict(s):
    return from_list(CaseGroup.from_dict, s)


def CaseGroupstodict(x):
    return from_list(lambda x: to_class(CaseGroup, x), x)


def CaseGroupfromdict(s):
    return CaseGroup.from_dict(s)


def CaseGrouptodict(x):
    return to_class(CaseGroup, x)


class Entitlement:
    """
    Entitlement class
    """
    def __init__(self, id=None, name=None, endDate=None,
                 serviceLevel=None, slaProcessId=None, startDate=None,
                 supportLevel=None):
        self.id = id
        self.name = name
        self.endDate = endDate
        self.serviceLevel = serviceLevel
        self.slaProcessId = slaProcessId
        self.startDate = startDate
        self.supportLevel = supportLevel

    def get_id(self): return self.id
    def get_name(self): return self.name
    def get_endDate(self): return self.endDate
    def get_serviceLevel(self): return self.serviceLevel
    def get_slaProcessId(self): return self.slaProcessId
    def get_sla(self): return self.slaProcessId  # to maintain consistency
    def get_startDate(self): return self.startDate
    def get_supportLevel(self): return self.supportLevel
    def set_id(self, id): self.id = id
    def set_name(self, name): self.name = name
    def set_endDate(self, endDate): self.endDate = endDate
    def set_serviceLevel(self, serviceLevel): self.serviceLevel = serviceLevel
    def set_slaProcessId(self, slaProcessId): self.slaProcessId = slaProcessId
    def set_sla(self, slaProcessId): self.slaProcessId = slaProcessId
    def set_startDate(self, startDate): self.startDate = startDate
    def set_supportLevel(self, supportLevel): self.supportLevel = supportLevel

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        id = from_union([from_str, from_none], obj.get("id"))
        name = from_union([from_str, from_none], obj.get("name"))
        endDate = from_union([from_str, from_none], obj.get("endDate"))
        serviceLevel = from_union([from_str, from_none], obj.get("serviceLevel"))
        slaProcessId = from_union([from_str, from_none], obj.get("slaProcessId"))
        startDate = from_union([from_str, from_none], obj.get("startDate"))
        supportLevel = from_union([from_str, from_none], obj.get("supportLevel"))
        return Entitlement(id, name, endDate, serviceLevel, slaProcessId, startDate, supportLevel)

    def to_dict(self):
        result: dict = {}
        result["id"] = from_union([from_str, from_none], self.id)
        result["name"] = from_union([from_str, from_none], self.name)
        result["endDate"] = from_union([from_str, from_none], self.endDate)
        result["serviceLevel"] = from_union([from_str, from_none], self.serviceLevel)
        result["slaProcessId"] = from_union([from_str, from_none], self.slaProcessId)
        result["startDate"] = from_union([from_str, from_none], self.startDate)
        result["supportLevel"] = from_union([from_str, from_none], self.supportLevel)
        return result


def Entitlementsfromdict(s):
    return from_list(Entitlement.from_dict, s)


def Entitlementstodict(x):
    return from_list(lambda x: to_class(Entitlement, x), x)


def Entitlementfromdict(s):
    return Entitlement.from_dict(s)


def Entitlementtodict(x):
    return to_class(Entitlement, x)


class Comment:

    def __init__(self, doNotChangeSBT=None, isPublic=None, id=None,
                 caseNumber=None, commentBody=None, createdDate=None,
                 createdByType=None, isDraft=None, lastModifiedById=None,
                 lastModifiedDate=None, publishedDate=None, createdBy=None,
                 contentType=None):
        self.doNotChangeSBT = doNotChangeSBT
        self.isPublic = isPublic
        self.id = id
        self.caseNumber = caseNumber
        self.commentBody = commentBody
        self.createdDate = createdDate
        self.createdByType = createdByType
        self.isDraft = isDraft
        self.lastModifiedById = lastModifiedById
        self.lastModifiedDate = lastModifiedDate
        self.publishedDate = publishedDate
        self.createdBy = createdBy
        self.contentType = contentType


    def get_doNotChangeSBT(self): return self.doNotChangeSBT
    def get_isPublic(self): return self.isPublic
    def get_id(self): return self.id
    def get_caseNumber(self): return self.caseNumber
    def get_commentBody(self): return self.commentBody
    def get_createdDate(self): return self.createdDate
    def get_createdByType(self): return self.createdByType
    def get_isDraft(self): return self.isDraft
    def get_lastModifiedById(self): return self.lastModifiedById
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_publishedDate(self): return self.publishedDate
    def get_createdBy(self): return self.createdBy
    def get_contentType(self): return self.contentType
    def set_doNotChangeSBT(self, doNotChangeSBT): self.doNotChangeSBT=doNotChangeSBT
    def set_isPublic(self, isPublic): self.isPublic=isPublic
    def set_id(self, id): self.id = id
    def set_caseNumber(self, caseNumber): self.caseNumber = caseNumber
    def set_commentBody(self, commentBody): self.commentBody=commentBody
    def set_createdDate(self, createdDate): self.createdDate=createdDate
    def set_createdByType(self, createdByType): self.createdByType=createdByType
    def set_isDraft(self, isDraft): self.isDraft=isDraft
    def set_lastModifiedById(self, lastModifiedById): self.lastModifiedById=lastModifiedById
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate=lastModifiedDate
    def set_publishedDate(self, publishedDate): self.publishedDate=publishedDate
    def set_createdBy(self, createdBy): self.createdBy=createdBy
    def set_contentType(self, contentType): self.contentType=contentType

    ####maintain consistency
    def get_lastModifiedBy(self): return self.lastModifiedById

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        doNotChangeSBT = from_union([from_bool, from_none], obj.get("doNotChangeSBT"))
        isPublic = from_union([from_bool, from_none], obj.get("isPublic"))
        id = from_union([from_str, from_none], obj.get("id"))
        caseNumber = from_union([from_str, from_none], obj.get("caseNumber"))
        commentBody = from_union([from_str, from_none], obj.get("commentBody"))
        createdDate = from_union([from_str, from_none], obj.get("createdDate"))
        createdByType = from_union([from_str, from_none], obj.get("createdByType"))
        isDraft = from_union([from_bool, from_none], obj.get("isDraft"))
        lastModifiedById = from_union([from_str, from_none], obj.get("lastModifiedById"))
        lastModifiedDate = from_union([from_str, from_none], obj.get("lastModifiedDate"))
        publishedDate = from_union([from_str, from_none], obj.get("publishedDate"))
        createdBy = from_union([from_str, from_none], obj.get("createdBy"))
        contentType = from_union([from_str, from_none], obj.get("contentType"))
        return Comment(doNotChangeSBT, isPublic, id, caseNumber, commentBody, createdDate,
                       createdByType, isDraft, lastModifiedById, lastModifiedDate, publishedDate, createdBy, contentType)

    def to_dict(self):
        result: dict = {}
        result["doNotChangeSBT"] = from_union([from_bool, from_none], self.doNotChangeSBT)
        result["isPublic"] = from_union([from_bool, from_none], self.isPublic)
        result["id"] = from_union([from_str, from_none], self.id)
        result["caseNumber"] = from_union([from_str, from_none], self.caseNumber)
        result["commentBody"] = from_union([from_str, from_none], self.commentBody)
        result["createdDate"] = from_union([from_str, from_none], self.createdDate)
        result["createdByType"] = from_union([from_str, from_none], self.createdByType)
        result["isDraft"] = from_union([from_bool, from_none], self.isDraft)
        result["lastModifiedById"] = from_union([from_str, from_none], self.lastModifiedById)
        result["lastModifiedDate"] = from_union([from_str, from_none], self.lastModifiedDate)
        result["publishedDate"] = from_union([from_str, from_none], self.publishedDate)
        result["createdBy"] = from_union([from_str, from_none], self.createdBy)
        result["contentType"] = from_union([from_str, from_none], self.contentType)
        return result


def Commentfromdict(s):
    return Comment.from_dict(s)


def Commenttodict(x):
    return to_class(Comment, x)


def Commentsfromdict(s):
    return from_list(Comment.from_dict, s)


def Commentstodict(x):
    return from_list(lambda x: to_class(Comment, x), x)


class CaseResourceLink:
    """
    CaseResourceLink Class
    """

    def __init__(self, bucket=None, caseNumber=None, caseURI=None,
                 externalCaseURI=None, isExact=None, linked=None,
                 linkedAt=None, linkedBy=None, origin=None,
                 resourceId=None, resourceType=None, resourceURI=None,
                 resourceViewURI=None, title=None, solutionAbstract=None,solutionKcsState=None):
        self.bucket = bucket
        self.caseNumber = caseNumber
        self.caseURI = caseURI
        self.externalCaseURI = externalCaseURI
        self.isExact = isExact
        self.linked = linked
        self.linkedAt = linkedAt
        self.linkedBy = linkedBy
        self.origin = origin
        self.resourceId = resourceId
        self.resourceType = resourceType
        self.resourceURI = resourceURI
        self.resourceViewURI = resourceViewURI
        self.title = title
        self.solutionAbstract = solutionAbstract
        self.solutionKcsState = solutionKcsState

    def get_bucket(self): return self.bucket
    def get_caseNumber(self): return self.caseNumber
    def get_caseURI(self): return self.caseURI
    def get_externalCaseURI(self): return self.externalCaseURI
    def get_isExact(self): return self.isExact
    def get_linked(self): return self.linked
    def get_linkedAt(self): return self.linkedAt
    def get_linkedBy(self): return self.linkedBy
    def get_origin(self): return self.origin
    def get_resourceId(self): return self.resourceId
    def get_resourceType(self): return self.resourceType
    def get_resourceURI(self): return self.resourceURI
    def get_resourceViewURI(self): return self.resourceViewURI
    def get_title(self): return self.title
    def set_bucket(self, bucket): self.bucket=bucket
    def set_caseNumber(self, caseNumber): self.caseNumber=caseNumber
    def set_caseURI(self, caseURI): self.caseURI=caseURI
    def set_externalCaseURI(self, externalCaseURI): self.externalCaseURI=externalCaseURI
    def set_isExact(self, isExact): self.isExact=isExact
    def set_linked(self, linked): self.linked=linked
    def set_linkedAt(self, linkedAt): self.linkedAt=linkedAt
    def set_linkedBy(self, linkedBy): self.linkedBy=linkedBy
    def set_origin(self, origin): self.origin=origin
    def set_resourceId(self, resourceId): self.resourceId=resourceId
    def set_resourceType(self, resourceType): self.resourceType=resourceType
    def set_resourceURI(self, resourceURI): self.resourceURI=resourceURI
    def set_resourceViewURI(self, resourceViewURI): self.resourceViewURI=resourceViewURI
    def set_title(self, title): self.title=title
    def get_solutionKcsState(self): return self.solutionKcsState
    def get_solutionAbstract(self): return self.solutionAbstract
    def set_solutionKcsState(self, solutionKcsState): self.solutionKcsState=solutionKcsState
    def set_solutionAbstract(self, solutionAbstract): self.solutionAbstract=solutionAbstract


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        bucket = from_union([from_str, from_none], obj.get("bucket"))
        caseNumber = from_union([from_str, from_none], obj.get("caseNumber"))
        caseURI = from_union([from_str, from_none], obj.get("caseURI"))
        externalCaseURI = from_union([from_str, from_none], obj.get("externalCaseURI"))
        isExact = from_union([from_bool, from_none], obj.get("isExact"))
        linked = from_union([from_bool, from_none], obj.get("linked"))
        linkedAt = from_union([from_str, from_none], obj.get("linkedAt"))
        linkedBy = from_union([from_str, from_none], obj.get("linkedBy"))
        origin = from_union([from_str, from_none], obj.get("origin"))
        resourceId = from_union([from_str, from_none], obj.get("resourceId"))
        resourceType = from_union([from_str, from_none], obj.get("resourceType"))
        resourceURI = from_union([from_str, from_none], obj.get("resourceURI"))
        resourceViewURI = from_union([from_str, from_none], obj.get("resourceViewURI"))
        title = from_union([from_str, from_none], obj.get("title"))
        solutionAbstract = from_union([from_str, from_none], obj.get("solutionAbstract"))
        solutionKcsState = from_union([from_str, from_none], obj.get("solutionKcsState"))
        return CaseResourceLink(bucket, caseNumber, caseURI, externalCaseURI, isExact, linked, linkedAt, linkedBy,
                                origin, resourceId, resourceType, resourceURI, resourceViewURI, title,
                                solutionAbstract, solutionKcsState)

    def to_dict(self):
        result: dict = {}
        result["bucket"] = from_union([from_str, from_none], self.bucket)
        result["caseNumber"] = from_union([from_str, from_none], self.caseNumber)
        result["caseURI"] = from_union([from_str, from_none], self.caseURI)
        result["externalCaseURI"] = from_union([from_str, from_none], self.externalCaseURI)
        result["isExact"] = from_union([from_bool, from_none], self.isExact)
        result["linked"] = from_union([from_bool, from_none], self.linked)
        result["linkedAt"] = from_union([from_str, from_none], self.linkedAt)
        result["linkedBy"] = from_union([from_str, from_none], self.linkedBy)
        result["origin"] = from_union([from_str, from_none], self.origin)
        result["resourceId"] = from_union([from_str, from_none], self.resourceId)
        result["resourceType"] = from_union([from_str, from_none], self.resourceType)
        result["resourceURI"] = from_union([from_str, from_none], self.resourceURI)
        result["resourceViewURI"] = from_union([from_str, from_none], self.resourceViewURI)
        result["title"] = from_union([from_str, from_none], self.title)
        result["solutionKcsState"] = from_union([from_str, from_none], self.solutionKcsState)
        result["solutionAbstract"] = from_union([from_str, from_none], self.solutionAbstract)
        return result


class Case:

    def __init__(self, alternateId=None, caseNumber=None,
                 isClosed=None, id=None, summary=None, status=None,
                 product=None, version=None, caseType=None, accountNumberRef=None,
                 description=None, uri=None, internalStatus=None, comments=None,
                 fts=None, entitlementSla=None, severity=None,
                 groupNumber=None, groupName=None, caseResourceLinks=None,
                 origin=None, contactSSOName=None, contactName=None,
                 createdById=None, createdDate=None, lastModifiedById=None,
                 lastModifiedDate=None, ownerId=None):
        self.alternateId = alternateId
        self.caseNumber = caseNumber
        self.isClosed = isClosed
        self.id = id
        self.summary = summary
        self.status = status
        self.product = product
        self.version = version
        self.caseType = caseType
        self.accountNumberRef = accountNumberRef
        self.description = description
        self.uri = uri
        self.internalStatus = internalStatus
        self.comments = comments
        self.fts = fts
        self.entitlementSla = entitlementSla
        self.severity = severity
        self.groupNumber = groupNumber
        self.groupName = groupName
        self.caseResourceLinks = caseResourceLinks
        self.origin = origin
        self.contactSSOName = contactSSOName
        self.contactName = contactName
        self.createdById = createdById
        self.createdDate = createdDate
        self.lastModifiedById = lastModifiedById
        self.lastModifiedDate = lastModifiedDate
        self.ownerId = ownerId


    def get_alternateId(self): return self.alternateId
    def get_caseNumber(self): return self.caseNumber
    def get_isClosed(self): return self.isClosed
    def get_id(self): return self.id
    def get_summary(self): return self.summary
    def get_status(self): return self.status
    def get_product(self): return self.product
    def get_version(self): return self.version
    def get_caseType(self): return self.caseType
    def get_accountNumberRef(self): return self.accountNumberRef
    def get_description(self): return self.description
    def get_uri(self): return self.uri
    def get_internalStatus(self): return self.internalStatus
    def get_comments(self): return self.comments
    def get_fts(self): return self.fts
    def get_entitlementSla(self): return self.entitlementSla
    def get_severity(self): return self.severity
    def get_groupNumber(self): return self.groupNumber
    def get_groupName(self): return self.groupName
    def get_caseResourceLinks(self): return self.caseResourceLinks
    def get_origin(self): return self.origin
    def get_contactSSOName(self): return self.contactSSOName
    def get_contactName(self): return self.contactName
    def get_createdById(self): return self.createdById
    def get_createdDate(self): return self.createdDate
    def get_lastModifiedById(self): return self.lastModifiedById
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_ownerId(self): return self.ownerId
    def set_alternateId(self, alternateId): self.alternateId=alternateId
    def set_caseNumber(self, caseNumber): self.caseNumber=caseNumber
    def set_isClosed(self, isClosed): self.isClosed=isClosed
    def set_id(self, id): self.id=id
    def set_summary(self, summary): self.summary=summary
    def set_status(self, status): self.status=status
    def set_product(self, product): self.product=product
    def set_version(self, version): self.version=version
    def set_caseType(self, caseType): self.caseType=caseType
    def set_accountNumberRef(self, accountNumberRef): self.accountNumberRef=accountNumberRef
    def set_description(self, description): self.description=description
    def set_uri(self, uri): self.uri=uri
    def set_internalStatus(self, internalStatus): self.internalStatus=internalStatus
    def set_comments(self, comments): self.comments=comments
    def set_fts(self, fts): self.fts=fts
    def set_entitlementSla(self, entitlementSla): self.entitlementSla=entitlementSla
    def set_severity(self, severity): self.severity=severity
    def set_groupNumber(self, groupNumber): self.groupNumber=groupNumber
    def set_groupName(self, groupName): self.groupName=groupName
    def set_caseResourceLinks(self, caseResourceLinks): self.caseResourceLinks=caseResourceLinks
    def set_origin(self, origin): self.origin=origin
    def set_contactSSOName(self, contactSSOName): self.contactSSOName=contactSSOName
    def set_contactName(self, contactName): self.contactName=contactName
    def set_createdById(self, createdById): self.createdById=createdById
    def set_createdDate(self, createdDate): self.createdDate=createdDate
    def set_lastModifiedById(self, lastModifiedById): self.lastModifiedById=lastModifiedById
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate=lastModifiedDate
    def set_ownerId(self, ownerId): self.ownerId=ownerId
    def get_view_uri(self): return None # to maintain consistency.


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        alternateId = from_union([from_str, from_none], obj.get("alternateId"))
        caseNumber = from_union([from_str, from_none], obj.get("caseNumber"))
        isClosed = from_union([from_bool, from_none], obj.get("isClosed"))
        id = from_union([from_str, from_none], obj.get("id"))
        summary = from_union([from_str, from_none], obj.get("summary"))
        status = from_union([from_str, from_none], obj.get("status"))
        product = from_union([from_str, from_none], obj.get("product"))
        version = from_union([from_str, from_none], obj.get("version"))
        caseType = from_union([from_str, from_none], obj.get("caseType"))
        accountNumberRef = from_union([from_str, from_none], obj.get("accountNumberRef"))
        description = from_union([from_str, from_none], obj.get("description"))
        uri = from_union([from_str, from_none], obj.get("uri"))
        internalStatus = from_union([from_str, from_none], obj.get("internalStatus"))
        comments = from_union([lambda x: from_list(Comment.from_dict, x), from_none], obj.get("comments"))
        fts = from_union([from_bool, from_none], obj.get("fts"))
        entitlementSla = from_union([from_str, from_none], obj.get("entitlementSla"))
        severity = from_union([from_str, from_none], obj.get("severity"))
        groupNumber = from_union([from_str, from_none], obj.get("groupNumber"))
        groupName = from_union([from_str, from_none], obj.get("groupName"))
        caseResourceLinks = from_union([lambda x: from_list(CaseResourceLink.from_dict, x), from_none], obj.get("caseResourceLinks"))
        origin = from_union([from_str, from_none], obj.get("origin"))
        contactSSOName = from_union([from_str, from_none], obj.get("contactSSOName"))
        contactName = from_union([from_str, from_none], obj.get("contactName"))
        createdById = from_union([from_str, from_none], obj.get("createdById"))
        createdDate = from_union([from_str, from_none], obj.get("createdDate"))
        lastModifiedById = from_union([from_str, from_none], obj.get("lastModifiedById"))
        lastModifiedDate = from_union([from_str, from_none], obj.get("lastModifiedDate"))
        ownerId = from_union([from_str, from_none], obj.get("ownerId"))
        return Case(alternateId, caseNumber, isClosed, id, summary, status, product, version, caseType,
                          accountNumberRef, description, uri, internalStatus, comments, fts, entitlementSla, severity,
                          groupNumber, groupName, caseResourceLinks, origin, contactSSOName,
                          contactName, createdById, createdDate, lastModifiedById, lastModifiedDate, ownerId)

    def to_dict(self):
        result: dict = {}
        result["alternateId"] = from_union([from_str, from_none], self.alternateId)
        result["caseNumber"] = from_union([from_str, from_none], self.caseNumber)
        result["isClosed"] = from_union([from_bool, from_none], self.isClosed)
        result["id"] = from_union([from_str, from_none], self.id)
        result["summary"] = from_union([from_str, from_none], self.summary)
        result["status"] = from_union([from_str, from_none], self.status)
        result["product"] = from_union([from_str, from_none], self.product)
        result["version"] = from_union([from_str, from_none], self.version)
        result["caseType"] = from_union([from_str, from_none], self.caseType)
        result["accountNumberRef"] = from_union([from_str, from_none], self.accountNumberRef)
        result["description"] = from_union([from_str, from_none], self.description)
        result["uri"] = from_union([from_str, from_none], self.uri)
        result["internalStatus"] = from_union([from_str, from_none], self.internalStatus)
        result["comments"] = from_union([lambda x: from_list(lambda x: to_class(Comment, x), x), from_none], self.comments)
        result["fts"] = from_union([from_bool, from_none], self.fts)
        result["entitlementSla"] = from_union([from_str, from_none], self.entitlementSla)
        result["severity"] = from_union([from_str, from_none], self.severity)
        result["groupNumber"] = from_union([from_str, from_none], self.groupNumber)
        result["groupName"] = from_union([from_str, from_none], self.groupName)
        result["caseResourceLinks"] = from_union([lambda x: from_list(lambda x: to_class(CaseResourceLink, x), x), from_none], self.caseResourceLinks)
        result["origin"] = from_union([from_str, from_none], self.origin)
        result["contactSSOName"] = from_union([from_str, from_none], self.contactSSOName)
        result["contactName"] = from_union([from_str, from_none], self.contactName)
        result["createdById"] = from_union([from_str, from_none], self.createdById)
        result["createdDate"] = from_union([from_str, from_none], self.createdDate)
        result["lastModifiedById"] = from_union([from_str, from_none], self.lastModifiedById)
        result["lastModifiedDate"] = from_union([from_str, from_none], self.lastModifiedDate)
        result["ownerId"] = from_union([from_str, from_none], self.ownerId)
        return result

    def convert_to_dict(self):
        return Casetodict(self)


def Casefromdict(s):
    return Case.from_dict(s)


def Casetodict(x):
    return to_class(Case, x)


def Casesfromdict(s):
    return from_list(Case.from_dict, s)


def Casestodict(x):
    return from_list(lambda x: to_class(Case, x), x)


class KCSDescription:

    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html

    def get_text(self): return self.text
    def get_html(self): return self.html
    def set_text(self, text): self.text=text
    def set_html(self, html): self.html=html

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        text = from_union([from_str, from_none], obj.get("text"))
        html = from_union([from_str, from_none], obj.get("html"))
        return KCSDescription(text, html)

    def to_dict(self):
        result: dict = {}
        result["text"] = from_union([from_str, from_none], self.text)
        result["html"] = from_union([from_str, from_none], self.html)
        return result


def KCSDescriptionfromdict(s):
    return KCSDescription.from_dict(s)


def KCSDescriptiontodict(x):
    return to_class(KCSDescription, x)


class Contact:

    def __init__(self, canAccessAllAccounts=None, canAddAttachments=None, email=None,
                 firstName=None, hasChat=None, hasUser=None, isEntitled=None,
                 isInternal=None, isOrgAdmin=None, lastName=None, name=None,
                 normalizedTZ=None, phone=None, secureSupportTech=None, ssoUsername=None,
                 timezone=None):
        self.canAccessAllAccounts = canAccessAllAccounts
        self.canAddAttachments = canAddAttachments
        self.email = email
        self.firstName = firstName
        self.hasChat = hasChat
        self.hasUser = hasUser
        self.isEntitled = isEntitled
        self.isInternal = isInternal
        self.isOrgAdmin = isOrgAdmin
        self.lastName = lastName
        self.name = name
        self.normalizedTZ = normalizedTZ
        self.phone = phone
        self.secureSupportTech = secureSupportTech
        self.ssoUsername = ssoUsername
        self.timezone = timezone

    def get_canAccessAllAccounts(self): return self.canAccessAllAccounts
    def get_canAddAttachments(self): return self.canAddAttachments
    def get_email(self): return self.email
    def get_firstName(self): return self.firstName
    def get_hasChat(self): return self.hasChat
    def get_hasUser(self): return self.hasUser
    def get_isEntitled(self): return self.isEntitled
    def get_isInternal(self): return self.isInternal
    def get_isOrgAdmin(self): return self.isOrgAdmin
    def get_lastName(self): return self.lastName
    def get_name(self): return self.name
    def get_normalizedTZ(self): return self.normalizedTZ
    def get_phone(self): return self.phone
    def get_secureSupportTech(self): return self.secureSupportTech
    def get_ssoUsername(self): return self.ssoUsername
    def get_timezone(self): return self.timezone
    def set_canAccessAllAccounts(self, canAccessAllAccounts): self.canAccessAllAccounts=canAccessAllAccounts
    def set_canAddAttachments(self, canAddAttachments): self.canAddAttachments=canAddAttachments
    def set_email(self, email): self.email=email
    def set_firstName(self, firstName): self.firstName=firstName
    def set_hasChat(self, hasChat): self.hasChat=hasChat
    def set_hasUser(self, hasUser): self.hasUser=hasUser
    def set_isEntitled(self, isEntitled): self.isEntitled=isEntitled
    def set_isInternal(self, isInternal): self.isInternal=isInternal
    def set_isOrgAdmin(self, isOrgAdmin): self.isOrgAdmin=isOrgAdmin
    def set_lastName(self, lastName): self.lastName=lastName
    def set_name(self, name): self.name=name
    def set_normalizedTZ(self, normalizedTZ): self.normalizedTZ=normalizedTZ
    def set_phone(self, phone): self.phone=phone
    def set_secureSupportTech(self, secureSupportTech): self.secureSupportTech=secureSupportTech
    def set_ssoUsername(self, ssoUsername): self.ssoUsername=ssoUsername
    def set_timezone(self, timezone): self.timezone=timezone

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        canAccessAllAccounts = from_union([from_bool, from_none], obj.get("canAccessAllAccounts"))
        canAddAttachments = from_union([from_bool, from_none], obj.get("canAddAttachments"))
        email = from_union([from_str, from_none], obj.get("email"))
        firstName = from_union([from_str, from_none], obj.get("firstName"))
        hasChat = from_union([from_bool, from_none], obj.get("hasChat"))
        hasUser = from_union([from_bool, from_none], obj.get("hasUser"))
        isEntitled = from_union([from_bool, from_none], obj.get("isEntitled"))
        isInternal = from_union([from_bool, from_none], obj.get("isInternal"))
        isOrgAdmin = from_union([from_bool, from_none], obj.get("isOrgAdmin"))
        lastName = from_union([from_str, from_none], obj.get("lastName"))
        name = from_union([from_str, from_none], obj.get("name"))
        normalizedTZ = from_union([from_str, from_none], obj.get("normalizedTZ"))
        phone = from_union([from_str, from_none], obj.get("phone"))
        secureSupportTech = from_union([from_bool, from_none], obj.get("secureSupportTech"))
        ssoUsername = from_union([from_str, from_none], obj.get("ssoUsername"))
        timezone = from_union([from_str, from_none], obj.get("timezone"))
        return Contact(canAccessAllAccounts, canAddAttachments, email, firstName, hasChat, hasUser, isEntitled, isInternal,
                       isOrgAdmin, lastName, name, normalizedTZ, phone, secureSupportTech, ssoUsername, timezone)

    def to_dict(self):
        result: dict = {}
        result["canAccessAllAccounts"] = from_union([from_bool, from_none], self.canAccessAllAccounts)
        result["canAddAttachments"] = from_union([from_bool, from_none], self.canAddAttachments)
        result["email"] = from_union([from_str, from_none], self.email)
        result["firstName"] = from_union([from_str, from_none], self.firstName)
        result["hasChat"] = from_union([from_bool, from_none], self.hasChat)
        result["hasUser"] = from_union([from_bool, from_none], self.hasUser)
        result["isEntitled"] = from_union([from_bool, from_none], self.isEntitled)
        result["isInternal"] = from_union([from_bool, from_none], self.isInternal)
        result["isOrgAdmin"] = from_union([from_bool, from_none], self.isOrgAdmin)
        result["lastName"] = from_union([from_str, from_none], self.lastName)
        result["name"] = from_union([from_str, from_none], self.name)
        result["normalizedTZ"] = from_union([from_str, from_none], self.normalizedTZ)
        result["phone"] = from_union([from_str, from_none], self.phone)
        result["secureSupportTech"] = from_union([from_bool, from_none], self.secureSupportTech)
        result["ssoUsername"] = from_union([from_str, from_none], self.ssoUsername)
        result["timezone"] = from_union([from_str, from_none], self.timezone)
        return result


def Contactfromdict(s):
    return Contact.from_dict(s)


def Contacttodict(x):
    return to_class(Contact, x)


def Contactsfromdict(s):
    return from_list(Contact.from_dict, s)


def Contactstodict(x):
    return from_list(lambda x: to_class(Contact, x), x)


class Values:
    """
    Values Class for mapping list of strings
    """

    def __init__(self, items=None):
        self.items = items

    def get_values(self): return self.items

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        items = from_union([lambda x: from_list(from_str, x), from_none], obj.get("items"))
        return Values(items)

    def to_dict(self):
        result: dict = {}
        result["items"] = from_union([lambda x: from_list(from_str, x), from_none], self.items)
        return result


def Valuesfromdict(s):
    return Values.from_dict(s)


def Valuestodict(x):
    return to_class(Values, x)


class KCSSearch:

    def __init__(self, documentKind=None, uri=None, path=None, viewuri=None,
                 title=None, allTitle=None, sortTitle=None, id=None,
                 solutionid=None, authorSSOName=None, lastModifiedBySSOName=None,
                 hasPublishedRevision=None, body=None, issue=None,
                 issueTag=None, lastModifiedDate=None, displayDate=None,
                 createdDate=None, kcsState=None, ModerationState=None,
                 accessState=None, abstract=None, publishedTitle=None,
                 publishedAbstract=None, publicationstate=None, titlestring=None,
                 issuestring=None, resourceuri=None):
        self.documentKind = documentKind
        self.uri = uri
        self.path = path
        self.viewuri = viewuri
        self.title = title
        self.allTitle = allTitle
        self.sortTitle = sortTitle
        self.id = id
        self.solutionid = solutionid
        self.authorSSOName = authorSSOName
        self.lastModifiedBySSOName = lastModifiedBySSOName
        self.hasPublishedRevision = hasPublishedRevision
        self.body = body
        self.issue = issue
        self.issueTag = issueTag
        self.lastModifiedDate = lastModifiedDate
        self.displayDate = displayDate
        self.createdDate = createdDate
        self.kcsState = kcsState
        self.ModerationState = ModerationState
        self.accessState = accessState
        self.abstract = abstract
        self.publishedTitle = publishedTitle
        self.publishedAbstract = publishedAbstract
        self.publicationstate = publicationstate
        self.titlestring = titlestring
        self.issuestring = issuestring
        self.resourceuri = resourceuri

    def get_title(self): return self.title
    def get_abstract(self): return self.abstract
    def get_id(self): return self.id
    def get_kcsState(self): return self.kcsState
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_view_uri(self): return self.viewuri
    def get_uri(self): return self.uri
    def get_resource_uri(self): return self.resourceuri
    def get_ModerationState(self): return self.ModerationState
    def get_publishedAbstract(self): return self.publishedAbstract
    def get_documentKind(self): return self.documentKind
    def get_path(self): return self.path
    def get_allTitle(self): return self.allTitle
    def get_sortTitle(self): return self.sortTitle
    def get_solutionid(self): return self.solutionid
    def get_authorSSOName(self): return self.authorSSOName
    def get_lastModifiedBySSOName(self): return self.lastModifiedBySSOName
    def get_hasPublishedRevision(self): return self.hasPublishedRevision
    def get_body(self): return self.body
    def get_issue(self): return self.issue
    def get_issueTag(self): return self.issueTag
    def get_displayDate(self): return self.displayDate
    def get_createdDate(self): return self.createdDate
    def get_accessState(self): return self.accessState
    def get_publishedTitle(self): return self.publishedTitle
    def get_publication_state(self): return self.publicationstate
    def get_title_string(self): return self.titlestring
    def get_issue_string(self): return self.issuestring
    def set_documentKind(self, documentKind): self.documentKind=documentKind
    def set_uri(self, uri): self.uri=uri
    def set_path(self, path): self.path=path
    def set_view_uri(self, view_uri): self.viewuri=view_uri
    def set_resource_uri(self, resource_uri): self.resourceuri = resource_uri
    def set_title(self, title): self.title=title
    def set_allTitle(self, allTitle): self.allTitle=allTitle
    def set_sortTitle(self, sortTitle): self.sortTitle=sortTitle
    def set_id(self, id): self.id=id
    def set_solutionid(self, solutionid): self.solutionid=solutionid
    def set_authorSSOName(self, authorSSOName): self.authorSSOName=authorSSOName
    def set_lastModifiedBySSOName(self, lastModifiedBySSOName): self.lastModifiedBySSOName=lastModifiedBySSOName
    def set_hasPublishedRevision(self, hasPublishedRevision): self.hasPublishedRevision=hasPublishedRevision
    def set_body(self, body): self.body=body
    def set_issue(self, issue): self.issue=issue
    def set_issueTag(self, issueTag): self.issueTag=issueTag
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate=lastModifiedDate
    def set_displayDate(self, displayDate): self.displayDate=displayDate
    def set_createdDate(self, createdDate): self.createdDate=createdDate
    def set_kcsState(self, kcsState): self.kcsState=kcsState
    def set_ModerationState(self, ModerationState): self.ModerationState=ModerationState
    def set_accessState(self, accessState): self.accessState=accessState
    def set_abstract(self, abstract): self.abstract=abstract
    def set_publishedTitle(self, publishedTitle): self.publishedTitle=publishedTitle
    def set_publishedAbstract(self, publishedAbstract): self.publishedAbstract=publishedAbstract
    def set_publication_state(self, publication_state): self.publicationstate=publication_state
    def set_title_string(self, title_string): self.titlestring=title_string
    def set_issue_string(self, issue_string): self.issuestring=issue_string


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        documentKind = from_union([from_str, from_none], obj.get("documentKind"))
        uri = from_union([from_str, from_none], obj.get("uri"))
        path = from_union([from_str, from_none], obj.get("path"))
        viewuri = from_union([from_str, from_none], obj.get("view_uri"))
        resourceuri = from_union([from_str, from_none], obj.get("resource_uri"))
        title = from_union([from_str, from_none], obj.get("title"))
        allTitle = from_union([from_str, from_none], obj.get("allTitle"))
        sortTitle = from_union([from_str, from_none], obj.get("sortTitle"))
        id = from_union([from_str, from_none], obj.get("id"))
        solutionid = from_union([from_str, from_none], obj.get("solution.id"))
        authorSSOName = from_union([from_str, from_none], obj.get("authorSSOName"))
        lastModifiedBySSOName = from_union([from_str, from_none], obj.get("lastModifiedBySSOName"))
        hasPublishedRevision = from_union([from_any, from_none], obj.get("hasPublishedRevision"))
        body = from_union([lambda x: from_list(from_str, x), from_none], obj.get("body"))
        issue = from_union([lambda x: from_list(from_str, x), from_none], obj.get("issue"))
        issueTag = from_union([lambda x: from_list(from_str, x), from_none], obj.get("issueTag"))
        lastModifiedDate = from_union([from_str, from_none], obj.get("lastModifiedDate"))
        displayDate = from_union([from_str, from_none], obj.get("displayDate"))
        createdDate = from_union([from_str, from_none], obj.get("createdDate"))
        kcsState = from_union([from_str, from_none], obj.get("kcsState"))
        ModerationState = from_union([from_str, from_none], obj.get("ModerationState"))
        accessState = from_union([from_str, from_none], obj.get("accessState"))
        abstract = from_union([from_str, from_none], obj.get("abstract"))
        publishedTitle = from_union([from_str, from_none], obj.get("publishedTitle"))
        publishedAbstract = from_union([from_str, from_none], obj.get("publishedAbstract"))
        publicationstate = from_union([from_str, from_none], obj.get("publication_state"))
        titlestring = from_union([from_str, from_none], obj.get("title_string"))
        issuestring = from_union([from_str, from_none], obj.get("issue_string"))
        return KCSSearch(documentKind, uri, path, viewuri, title, allTitle, sortTitle, id, solutionid,
                         authorSSOName, lastModifiedBySSOName, hasPublishedRevision, body, issue, issueTag,
                         lastModifiedDate, displayDate, createdDate, kcsState, ModerationState, accessState,
                         abstract, publishedTitle, publishedAbstract, publicationstate, titlestring, issuestring,
                         resourceuri)

    def to_dict(self):
        result: dict = {}
        result["documentKind"] = from_union([from_str, from_none], self.documentKind)
        result["uri"] = from_union([from_str, from_none], self.uri)
        result["path"] = from_union([from_str, from_none], self.path)
        result["view_uri"] = from_union([from_str, from_none], self.viewuri)
        result["resource_uri"] = from_union([from_str, from_none], self.resourceuri)
        result["title"] = from_union([from_str, from_none], self.title)
        result["allTitle"] = from_union([from_str, from_none], self.allTitle)
        result["sortTitle"] = from_union([from_str, from_none], self.sortTitle)
        result["id"] = from_union([from_str, from_none], self.id)
        result["solution.id"] = from_union([from_str, from_none], self.solutionid)
        result["authorSSOName"] = from_union([from_str, from_none], self.authorSSOName)
        result["lastModifiedBySSOName"] = from_union([from_str, from_none], self.lastModifiedBySSOName)
        result["hasPublishedRevision"] = from_union([from_any, from_none], self.hasPublishedRevision)
        result["body"] = from_union([lambda x: from_list(from_str, x), from_none], self.body)
        result["issue"] = from_union([lambda x: from_list(from_str, x), from_none], self.issue)
        result["issueTag"] = from_union([lambda x: from_list(from_str, x), from_none], self.issueTag)
        result["lastModifiedDate"] = from_union([from_str, from_none], self.lastModifiedDate)
        result["displayDate"] = from_union([from_str, from_none], self.displayDate)
        result["createdDate"] = from_union([from_str, from_none], self.createdDate)
        result["kcsState"] = from_union([from_str, from_none], self.kcsState)
        result["ModerationState"] = from_union([from_str, from_none], self.ModerationState)
        result["accessState"] = from_union([from_str, from_none], self.accessState)
        result["abstract"] = from_union([from_str, from_none], self.abstract)
        result["publishedTitle"] = from_union([from_str, from_none], self.publishedTitle)
        result["publishedAbstract"] = from_union([from_str, from_none], self.publishedAbstract)
        result["publication_state"] = from_union([from_str, from_none], self.publicationstate)
        result["title_string"] = from_union([from_str, from_none], self.titlestring)
        result["issue_string"] = from_union([from_str, from_none], self.issuestring)
        return result


def KCSSearchesfromdict(s):
    return from_list(KCSSearch.from_dict, s)


def KCSSearchestodict(x):
    return from_list(lambda x: to_class(KCSSearch, x), x)


class CaseFilter:
    '''
    Case Filter class
    '''

    def __init__(self, associateSSOName=None, endDate=None, includeClosed=None,
                 maxResults=None, offset=None, severity=None, sortField=None,
                 sortOrder=None, startDate=None, status=None, view=None,
                 accountNumber=None, groupNumber=None, groupNumbers=None,
                 includePrivate=None, keyword=None, onlyUngrouped=None,
                 ownerSSOName=None, product=None, type=None):
        self.associateSSOName = associateSSOName
        self.endDate = endDate
        self.includeClosed = includeClosed
        self.maxResults = maxResults
        self.offset = offset
        self.severity = severity
        self.sortField = sortField
        self.sortOrder = sortOrder
        self.startDate = startDate
        self.status = status
        self.view = view
        self.accountNumber = accountNumber
        self.groupNumber = groupNumber
        self.groupNumbers = groupNumbers
        self.includePrivate = includePrivate
        self.keyword = keyword
        self.onlyUngrouped = onlyUngrouped
        self.ownerSSOName = ownerSSOName
        self.product = product
        self.type = type

    def get_associateSSOName(self): return self.associateSSOName
    def get_endDate(self): return self.endDate
    def get_includeClosed(self): return self.includeClosed
    def get_maxResults(self): return self.maxResults
    def get_offset(self): return self.offset
    def get_severity(self): return self.severity
    def get_sortField(self): return self.sortField
    def get_sortOrder(self): return self.sortOrder
    def get_startDate(self): return self.startDate
    def get_status(self): return self.status
    def get_view(self): return self.view
    def get_accountNumber(self): return self.accountNumber
    def get_groupNumber(self): return self.groupNumber
    def get_groupNumbers(self): return self.groupNumbers
    def get_includePrivate(self): return self.includePrivate
    def get_keyword(self): return self.keyword
    def get_onlyUngrouped(self): return self.onlyUngrouped
    def get_ownerSSOName(self): return self.ownerSSOName
    def get_product(self): return self.product
    def get_type(self): return self.type
    def set_associateSSOName(self, associateSSOName): self.associateSSOName=associateSSOName
    def set_endDate(self, endDate): self.endDate=endDate
    def set_includeClosed(self, includeClosed): self.includeClosed=includeClosed
    def set_maxResults(self, maxResults): self.maxResults=maxResults
    def set_offset(self, offset): self.offset=offset
    def set_severity(self, severity): self.severity=severity
    def set_sortField(self, sortField): self.sortField=sortField
    def set_sortOrder(self, sortOrder): self.sortOrder=sortOrder
    def set_startDate(self, startDate): self.startDate=startDate
    def set_status(self, status): self.status=status
    def set_view(self, view): self.view=view
    def set_accountNumber(self, accountNumber): self.accountNumber=accountNumber
    def set_groupNumber(self, groupNumber): self.groupNumber=groupNumber
    def set_groupNumbers(self, groupNumbers): self.groupNumbers=groupNumbers
    def set_includePrivate(self, includePrivate): self.includePrivate=includePrivate
    def set_keyword(self, keyword): self.keyword=keyword
    def set_onlyUngrouped(self, onlyUngrouped): self.onlyUngrouped=onlyUngrouped
    def set_ownerSSOName(self, ownerSSOName): self.ownerSSOName=ownerSSOName
    def set_product(self, product): self.product=product
    def set_type(self, type): self.type=type


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        associateSSOName = from_union([from_str, from_none], obj.get("associateSSOName"))
        endDate = from_union([from_str, from_none], obj.get("endDate"))
        includeClosed = from_union([from_bool, from_none], obj.get("includeClosed"))
        maxResults = from_union([from_any, from_none], obj.get("maxResults"))
        offset = from_union([from_any, from_none], obj.get("offset"))
        severity = from_union([from_str, from_none], obj.get("severity"))
        sortField = from_union([from_str, from_none], obj.get("sortField"))
        sortOrder = from_union([from_str, from_none], obj.get("sortOrder"))
        startDate = from_union([from_str, from_none], obj.get("startDate"))
        status = from_union([from_str, from_none], obj.get("status"))
        view = from_union([from_str, from_none], obj.get("view"))
        accountNumber = from_union([from_str, from_none], obj.get("accountNumber"))
        groupNumber = from_union([from_str, from_none], obj.get("groupNumber"))
        groupNumbers = from_union([lambda x: from_list(from_str, x), from_none], obj.get("groupNumbers"))
        includePrivate = from_union([from_bool, from_none], obj.get("includePrivate"))
        keyword = from_union([from_str, from_none], obj.get("keyword"))
        onlyUngrouped = from_union([from_bool, from_none], obj.get("onlyUngrouped"))
        ownerSSOName = from_union([from_str, from_none], obj.get("ownerSSOName"))
        product = from_union([from_str, from_none], obj.get("product"))
        type = from_union([from_str, from_none], obj.get("type"))
        return CaseFilter(associateSSOName, endDate, includeClosed, maxResults, offset, severity, sortField, sortOrder,
                          startDate, status, view, accountNumber, groupNumber, groupNumbers, includePrivate, keyword,
                          onlyUngrouped, ownerSSOName, product, type)

    def to_dict(self):
        result: dict = {}
        result["associateSSOName"] = from_union([from_str, from_none], self.associateSSOName)
        result["endDate"] = from_union([from_str, from_none], self.endDate)
        result["includeClosed"] = from_union([from_bool, from_none], self.includeClosed)
        result["maxResults"] = from_union([from_any, from_none], self.maxResults)
        result["offset"] = from_union([from_any, from_none], self.offset)
        result["severity"] = from_union([from_str, from_none], self.severity)
        result["sortField"] = from_union([from_str, from_none], self.sortField)
        result["sortOrder"] = from_union([from_str, from_none], self.sortOrder)
        result["startDate"] = from_union([from_str, from_none], self.startDate)
        result["status"] = from_union([from_str, from_none], self.status)
        result["view"] = from_union([from_str, from_none], self.view)
        result["accountNumber"] = from_union([from_str, from_none], self.accountNumber)
        result["groupNumber"] = from_union([from_str, from_none], self.groupNumber)
        result["groupNumbers"] = from_union([lambda x: from_list(from_str, x), from_none], self.groupNumbers)
        result["includePrivate"] = from_union([from_bool, from_none], self.includePrivate)
        result["keyword"] = from_union([from_str, from_none], self.keyword)
        result["onlyUngrouped"] = from_union([from_bool, from_none], self.onlyUngrouped)
        result["ownerSSOName"] = from_union([from_str, from_none], self.ownerSSOName)
        result["product"] = from_union([from_str, from_none], self.product)
        result["type"] = from_union([from_str, from_none], self.type)
        return result


def CaseFilterfromdict(s):
    return CaseFilter.from_dict(s)


def CaseFiltertodict(x):
    return to_class(CaseFilter, x)


def CaseFiltersfromdict(s):
    return from_list(CaseFilter.from_dict, s)


def CaseFilterstodict(x):
    return from_list(lambda x: to_class(CaseFilter, x), x)


class Solution:
    def __init__(self, issue=None, environment=None,
                 resolution=None, rootCause=None, diagnosticSteps=None,
                 kcsState=None, uri=None, id=None, title=None, language=None,
                 authorSSOName=None, lastModifiedBySSOName=None, viewURI=None,
                 privateNotes=None, hasPublishedRevision=None, moderationState=None,
                 accessState=None, lastModifiedDate=None, createdDate=None):
        self.issue = issue
        self.environment = environment
        self.resolution = resolution
        self.rootCause = rootCause
        self.diagnosticSteps = diagnosticSteps
        self.kcsState = kcsState
        self.uri = uri
        self.id = id
        self.title = title
        self.language = language
        self.authorSSOName = authorSSOName
        self.lastModifiedBySSOName = lastModifiedBySSOName
        self.viewURI = viewURI
        self.privateNotes = privateNotes
        self.hasPublishedRevision = hasPublishedRevision
        self.moderationState = moderationState
        self.accessState = accessState
        self.lastModifiedDate = lastModifiedDate
        self.createdDate = createdDate

    def get_issue(self): return self.issue
    def get_environment(self): return self.environment
    def get_resolution(self): return self.resolution
    def get_rootCause(self): return self.rootCause
    def get_diagnosticSteps(self): return self.diagnosticSteps
    def get_kcsState(self): return self.kcsState
    def get_uri(self): return self.uri
    def get_id(self): return self.id
    def get_title(self): return self.title
    def get_language(self): return self.language
    def get_authorSSOName(self): return self.authorSSOName
    def get_lastModifiedBySSOName(self): return self.lastModifiedBySSOName
    def get_viewURI(self): return self.viewURI
    def get_privateNotes(self): return self.privateNotes
    def get_hasPublishedRevision(self): return self.hasPublishedRevision
    def get_moderationState(self): return self.moderationState
    def get_accessState(self): return self.accessState
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_createdDate(self): return self.createdDate
    def set_issue(self, issue): self.issue=issue
    def set_environment(self, environment): self.environment=environment
    def set_resolution(self, resolution): self.resolution=resolution
    def set_rootCause(self, rootCause): self.rootCause=rootCause
    def set_diagnosticSteps(self, diagnosticSteps): self.diagnosticSteps=diagnosticSteps
    def set_kcsState(self, kcsState): self.kcsState=kcsState
    def set_uri(self, uri): self.uri=uri
    def set_id(self, id): self.id=id
    def set_title(self, title): self.title=title
    def set_language(self, language): self.language=language
    def set_authorSSOName(self, authorSSOName): self.authorSSOName=authorSSOName
    def set_lastModifiedBySSOName(self, lastModifiedBySSOName): self.lastModifiedBySSOName=lastModifiedBySSOName
    def set_viewURI(self, viewURI): self.viewURI=viewURI
    def set_privateNotes(self, privateNotes): self.privateNotes=privateNotes
    def set_hasPublishedRevision(self, hasPublishedRevision): self.hasPublishedRevision=hasPublishedRevision
    def set_moderationState(self, moderationState): self.moderationState=moderationState
    def set_accessState(self, accessState): self.accessState=accessState
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate=lastModifiedDate
    def set_createdDate(self, createdDate): self.createdDate=createdDate


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        issue = from_union([KCSDescription.from_dict, from_none], obj.get("issue"))
        environment = from_union([KCSDescription.from_dict, from_none], obj.get("environment"))
        resolution = from_union([KCSDescription.from_dict, from_none], obj.get("resolution"))
        rootCause = from_union([KCSDescription.from_dict, from_none], obj.get("rootCause"))
        diagnosticSteps = from_union([KCSDescription.from_dict, from_none], obj.get("diagnosticSteps"))
        kcsState = from_union([from_str, from_none], obj.get("kcsState"))
        uri = from_union([from_str, from_none], obj.get("uri"))
        id = from_union([from_any, from_none], obj.get("id"))
        title = from_union([from_str, from_none], obj.get("title"))
        language = from_union([from_str, from_none], obj.get("language"))
        authorSSOName = from_union([from_str, from_none], obj.get("authorSSOName"))
        lastModifiedBySSOName = from_union([from_str, from_none], obj.get("lastModifiedBySSOName"))
        viewURI = from_union([from_str, from_none], obj.get("viewURI"))
        privateNotes = from_union([KCSDescription.from_dict, from_none], obj.get("privateNotes"))
        hasPublishedRevision = from_union([from_bool, from_none], obj.get("hasPublishedRevision"))
        moderationState = from_union([from_str, from_none], obj.get("moderationState"))
        accessState = from_union([from_str, from_none], obj.get("accessState"))
        lastModifiedDate = from_union([from_str, from_none], obj.get("lastModifiedDate"))
        createdDate = from_union([from_str, from_none], obj.get("createdDate"))
        return Solution(issue, environment, resolution, rootCause, diagnosticSteps, kcsState, uri, id, title,
                        language, authorSSOName, lastModifiedBySSOName, viewURI, privateNotes, hasPublishedRevision,
                        moderationState, accessState, lastModifiedDate, createdDate)

    def to_dict(self):
        result: dict = {}
        result["issue"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.issue)
        result["environment"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.environment)
        result["resolution"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.resolution)
        result["rootCause"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.rootCause)
        result["diagnosticSteps"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.diagnosticSteps)
        result["kcsState"] = from_union([from_str, from_none], self.kcsState)
        result["uri"] = from_union([from_str, from_none], self.uri)
        result["id"] = from_union([from_any, from_none], self.id)
        result["title"] = from_union([from_str, from_none], self.title)
        result["language"] = from_union([from_str, from_none], self.language)
        result["authorSSOName"] = from_union([from_str, from_none], self.authorSSOName)
        result["lastModifiedBySSOName"] = from_union([from_str, from_none], self.lastModifiedBySSOName)
        result["viewURI"] = from_union([from_str, from_none], self.viewURI)
        result["privateNotes"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.privateNotes)
        result["hasPublishedRevision"] = from_union([from_bool, from_none], self.hasPublishedRevision)
        result["moderationState"] = from_union([from_str, from_none], self.moderationState)
        result["accessState"] = from_union([from_str, from_none], self.accessState)
        result["lastModifiedDate"] = from_union([from_str, from_none], self.lastModifiedDate)
        result["createdDate"] = from_union([from_str, from_none], self.createdDate)
        return result


def Solutionfromdict(s):
    return Solution.from_dict(s)


def Solutiontodict(x):
    return to_class(Solution, x)


def Solutionsfromdict(s):
    return from_list(Solution.from_dict, s)


def Solutionstodict(x):
    return from_list(lambda x: to_class(Solution, x), x)


class Article:

    def __init__(self, body=None, bodyAbstract=None, uri=None, id=None,
                 title=None, language=None, authorSSOName=None, lastModifiedBySSOName=None,
                 viewURI=None, privateNotes=None, hasPublishedRevision=None,
                 moderationState=None, accessState=None, lastModifiedDate=None, createdDate=None):
        self.body = body
        self.bodyAbstract = bodyAbstract
        self.uri = uri
        self.id = id
        self.title = title
        self.language = language
        self.authorSSOName = authorSSOName
        self.lastModifiedBySSOName = lastModifiedBySSOName
        self.viewURI = viewURI
        self.privateNotes = privateNotes
        self.hasPublishedRevision = hasPublishedRevision
        self.moderationState = moderationState
        self.accessState = accessState
        self.lastModifiedDate = lastModifiedDate
        self.createdDate = createdDate

    def get_body(self): return self.body
    def get_bodyAbstract(self): return self.bodyAbstract
    def get_uri(self): return self.uri
    def get_id(self): return self.id
    def get_title(self): return self.title
    def get_language(self): return self.language
    def get_authorSSOName(self): return self.authorSSOName
    def get_lastModifiedBySSOName(self): return self.lastModifiedBySSOName
    def get_viewURI(self): return self.viewURI
    def get_privateNotes(self): return self.privateNotes
    def get_hasPublishedRevision(self): return self.hasPublishedRevision
    def get_moderationState(self): return self.moderationState
    def get_accessState(self): return self.accessState
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_createdDate(self): return self.createdDate
    def set_body(self, body): self.body=body
    def set_bodyAbstract(self, bodyAbstract): self.bodyAbstract=bodyAbstract
    def set_uri(self, uri): self.uri=uri
    def set_id(self, id): self.id=id
    def set_title(self, title): self.title=title
    def set_language(self, language): self.language=language
    def set_authorSSOName(self, authorSSOName): self.authorSSOName=authorSSOName
    def set_lastModifiedBySSOName(self, lastModifiedBySSOName): self.lastModifiedBySSOName=lastModifiedBySSOName
    def set_viewURI(self, viewURI): self.viewURI=viewURI
    def set_privateNotes(self, privateNotes): self.privateNotes=privateNotes
    def set_hasPublishedRevision(self, hasPublishedRevision): self.hasPublishedRevision=hasPublishedRevision
    def set_moderationState(self, moderationState): self.moderationState=moderationState
    def set_accessState(self, accessState): self.accessState=accessState
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate=lastModifiedDate
    def set_createdDate(self, createdDate): self.createdDate=createdDate

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        body = from_union([KCSDescription.from_dict, from_none], obj.get("body"))
        bodyAbstract = from_union([KCSDescription.from_dict, from_none], obj.get("bodyAbstract"))
        uri = from_union([from_str, from_none], obj.get("uri"))
        id = from_union([from_any, from_none], obj.get("id"))
        title = from_union([from_str, from_none], obj.get("title"))
        language = from_union([from_str, from_none], obj.get("language"))
        authorSSOName = from_union([from_str, from_none], obj.get("authorSSOName"))
        lastModifiedBySSOName = from_union([from_str, from_none], obj.get("lastModifiedBySSOName"))
        viewURI = from_union([from_str, from_none], obj.get("viewURI"))
        privateNotes = from_union([KCSDescription.from_dict, from_none], obj.get("privateNotes"))
        hasPublishedRevision = from_union([from_bool, from_none], obj.get("hasPublishedRevision"))
        moderationState = from_union([from_str, from_none], obj.get("moderationState"))
        accessState = from_union([from_str, from_none], obj.get("accessState"))
        lastModifiedDate = from_union([from_str, from_none], obj.get("lastModifiedDate"))
        createdDate = from_union([from_str, from_none], obj.get("createdDate"))
        return Article(body, bodyAbstract, uri, id, title, language, authorSSOName, lastModifiedBySSOName,
                       viewURI, privateNotes, hasPublishedRevision, moderationState, accessState, lastModifiedDate, createdDate)

    def to_dict(self):
        result: dict = {}
        result["body"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.body)
        result["bodyAbstract"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.bodyAbstract)
        result["uri"] = from_union([from_str, from_none], self.uri)
        result["id"] = from_union([from_any, from_none], self.id)
        result["title"] = from_union([from_str, from_none], self.title)
        result["language"] = from_union([from_str, from_none], self.language)
        result["authorSSOName"] = from_union([from_str, from_none], self.authorSSOName)
        result["lastModifiedBySSOName"] = from_union([from_str, from_none], self.lastModifiedBySSOName)
        result["viewURI"] = from_union([from_str, from_none], self.viewURI)
        result["privateNotes"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.privateNotes)
        result["hasPublishedRevision"] = from_union([from_bool, from_none], self.hasPublishedRevision)
        result["moderationState"] = from_union([from_str, from_none], self.moderationState)
        result["accessState"] = from_union([from_str, from_none], self.accessState)
        result["lastModifiedDate"] = from_union([from_str, from_none], self.lastModifiedDate)
        result["createdDate"] = from_union([from_str, from_none], self.createdDate)
        return result


def Articlefromdict(s):
    return Article.from_dict(s)


def Articletodict(x):
    return to_class(Article, x)


def Articlesfromdict(s):
    return from_list(Article.from_dict, s)


def Articlestodict(x):
    return from_list(lambda x: to_class(Article, x), x)


class Recommendation:
    '''
    The Recommendation class. It maps the response of the /recommendations endpoint
    '''

    def __init__(self, documentKind=None, allTitle=None, kcsState=None,
                 uri=None, viewuri=None, resourceuri=None, id=None,
                 abstract=None, linked=None):
        self.documentKind = documentKind
        self.allTitle = allTitle
        self.kcsState = kcsState
        self.uri = uri
        self.viewuri = viewuri
        self.resourceuri = resourceuri
        self.id = id
        self.abstract = abstract
        self.linked = linked

    def get_documentKind(self): return self.documentKind
    def get_allTitle(self): return self.allTitle
    def get_kcsState(self): return self.kcsState
    def get_uri(self): return self.uri
    def get_view_uri(self): return self.viewuri
    def get_resource_uri(self): return self.resourceuri
    def get_id(self): return self.id
    def get_abstract(self): return self.abstract
    def get_linked(self): return self.linked
    def set_documentKind(self, documentKind): self.documentKind=documentKind
    def set_allTitle(self, allTitle): self.allTitle=allTitle
    def set_kcsState(self, kcsState): self.kcsState=kcsState
    def set_uri(self, uri): self.uri=uri
    def set_view_uri(self, view_uri): self.viewuri=view_uri
    def set_resource_uri(self, resource_uri): self.resourceuri=resource_uri
    def set_id(self, id): self.id=id
    def set_abstract(self, abstract): self.abstract=abstract
    def set_linked(self, linked): self.linked=linked

    # to maintain consistency with the recommendationprompter.py
    def get_title(self): return self.allTitle
    def get_resourceViewURI(self): return self.viewuri
    def get_solutionAbstract(self): return self.abstract
    def get_solutionKcsState(self): return self.kcsState
    def get_resourceId(self): return self.id

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        documentKind = from_union([from_str, from_none], obj.get("documentKind"))
        allTitle = from_union([from_str, from_none], obj.get("allTitle"))
        kcsState = from_union([from_str, from_none], obj.get("kcsState"))
        uri = from_union([from_str, from_none], obj.get("uri"))
        viewuri = from_union([from_str, from_none], obj.get("view_uri"))
        resourceuri = from_union([from_str, from_none], obj.get("resource_uri"))
        id = from_union([from_str, from_none], obj.get("id"))
        abstract = from_union([from_str, from_none], obj.get("abstract"))
        linked = from_union([from_bool, from_none], obj.get("linked"))
        return Recommendation(documentKind, allTitle, kcsState, uri, viewuri, resourceuri, id, abstract, linked)

    def to_dict(self):
        result: dict = {}
        result["documentKind"] = from_union([from_str, from_none], self.documentKind)
        result["allTitle"] = from_union([from_str, from_none], self.allTitle)
        result["kcsState"] = from_union([from_str, from_none], self.kcsState)
        result["uri"] = from_union([from_str, from_none], self.uri)
        result["view_uri"] = from_union([from_str, from_none], self.viewuri)
        result["resource_uri"] = from_union([from_str, from_none], self.resourceuri)
        result["id"] = from_union([from_str, from_none], self.id)
        result["abstract"] = from_union([from_str, from_none], self.abstract)
        result["linked"] = from_union([from_bool, from_none], self.linked)
        return result


def Recommendationsfromdict(s):
    return from_list(Recommendation.from_dict, s)


def Recommendationstodict(x):
    return from_list(lambda x: to_class(Recommendation, x), x)


def Recommendationfromdict(s):
    return Recommendation.from_dict(s)


def Recommendationtodict(x):
    return to_class(Recommendation, x)
