#
# Copyright (c) 2010 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#           http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from redhat_support_lib.utils.parsehelper import ParseHelper
from redhat_support_lib.infrastructure import contextmanager
from redhat_support_lib.utils.reflectionhelper import ReflectionHelper
import sys


class Base(object):
    ''' Returns the proxy to connections pool '''
    def _getProxy(self):
        return contextmanager.get('proxy')

    def __getattr__(self, item):
        return self.superclass.__getattribute__(item)

    def __setattr__(self, item, value):
        if value is not None and not isinstance(value, list) and \
                ReflectionHelper.isModuleMember(sys.modules['redhat_support_lib.infrastructure.brokers'],
                                                type(value)) and \
                not ReflectionHelper.isModuleMember(sys.modules['redhat_support_lib.json.paramsjson'], type(value)) and \
                'superclass' in value.__dict__ and value.superclass is not None:
            if ReflectionHelper.isModuleMember(sys.modules['redhat_support_lib.infrastructure.brokers'], type(self)) and \
                    'superclass' in self.__dict__ and self.superclass is not None:
                object.__setattr__(self.superclass, item, value.superclass)
            else:
                object.__setattr__(self, item, value.superclass)
        elif not isinstance(value, list) and \
                ReflectionHelper.isModuleMember(sys.modules['redhat_support_lib.infrastructure.brokers'],
                                                type(self)) and \
                'superclass' in self.__dict__ and self.superclass is not None and \
                not ReflectionHelper.isModuleMember(sys.modules['redhat_support_lib.infrastructure.brokers'],
                                                    type(value)) and \
                item is not 'superclass' and \
                item is not 'parentclass':
            object.__setattr__(self.superclass, item, value)
        elif isinstance(value, list):
            parsed_list = []
            for obj in value:
                if ReflectionHelper.isModuleMember(sys.modules['redhat_support_lib.infrastructure.brokers'],
                                                   type(obj)) and \
                        'superclass' in obj.__dict__ and obj.superclass is not None and \
                        item is not 'superclass' and item is not 'parentclass':
                    parsed_list.append(obj.superclass)
                else:
                    parsed_list.append(obj)
            object.__setattr__(self, item, parsed_list)
        else:
            object.__setattr__(self, item, value)

    def toXml(self):
        '''
        A utility method to print this object's superclass as XML.
        The superclass property should be a member of redhat_support_lib.xml.params.
        '''
        return ParseHelper.toXml(self.superclass)


def ignore_none_values(original):
    return {k: v for k, v in original.items() if v is not None}
