#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Wed Mar 20 12:28:42 2013 by generateDS.py version 2.7b.
#
## IMPORTANT!!!

# This file was created by generateDS.  It has been modified
# in a few places as denoted by the NOT_GENERATED comments

import sys
import getopt
import re as re_

# Begin NOT_GENERATED
from redhat_support_lib.utils.reflectionhelper import ReflectionHelper
def set_docstring(doctext):
    def docstring(function):
        function.__doc__ = doctext
        return function
    return docstring
# End NOT_GENERATED

etree_ = None
Verbose_import_ = False
(XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError("Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0',):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None

# Begin NOT_GENERATED
        def __setattr__(self, item, value):
            if value is not None and not isinstance(value, list) and \
               ReflectionHelper.isModuleMember(sys.modules['redhat_support_lib.infrastructure.brokers'], type(value)) and \
               not ReflectionHelper.isModuleMember(sys.modules[__name__], type(value)) and \
               value.__dict__.has_key('superclass') and value.superclass is not None:
                if ReflectionHelper.isModuleMember(sys.modules['redhat_support_lib.infrastructure.brokers'], type(self)) and \
                   self.__dict__.has_key('superclass') and self.superclass is not None:
                    object.__setattr__(self.superclass, item, value.superclass)
                else:
                    object.__setattr__(self, item, value.superclass)
            elif not isinstance(value, list) and  \
                 ReflectionHelper.isModuleMember(sys.modules['redhat_support_lib.infrastructure.brokers'], type(self)) and \
                 self.__dict__.has_key('superclass') and self.superclass is not None and \
                 not ReflectionHelper.isModuleMember(sys.modules['redhat_support_lib.infrastructure.brokers'], type(value)) and\
                  item is not 'superclass' and \
                  item is not 'parentclass' :
                object.__setattr__(self.superclass, item, value)
            elif isinstance(value, list):
                parsed_list = []
                for obj in value:
                    if ReflectionHelper.isModuleMember(sys.modules['redhat_support_lib.infrastructure.brokers'], type(obj)) and \
                       obj.__dict__.has_key('superclass') and obj.superclass is not None and \
                       item is not 'superclass' and item is not 'parentclass' :
                        parsed_list.append(obj.superclass)
                    else:
                        parsed_list.append(obj)
                object.__setattr__(self, item, parsed_list)
            else:
                object.__setattr__(self, item, value)
# End NOT_GENERATED


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

# # from IPython.Shell import IPShellEmbed
# # args = ''
# # ipshell = IPShellEmbed(args,
# #     banner = 'Dropping into IPython',
# #     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

# Begin NOT_GENERATED
# External encoding must be utf-8 for Stata and not ascii.
ExternalEncoding = 'utf-8'
# End NOT_GENERATED
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name,))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline,)
    else:
        msg = '%s (element %s)' % (msg, node.tag,)
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:  # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:  # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class strataEntity(GeneratedsSuper):
    """The base type for all API entities."""
    subclass = None
    superclass = None
    def __init__(self, extensiontype_=None):
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if strataEntity.subclass:
            return strataEntity.subclass(*args_, **kwargs_)
        else:
            return strataEntity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='tns:', name_='strataEntity', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='strataEntity')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='strataEntity'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='strataEntity', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='strataEntity'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class strataEntity


class trackedEntity(strataEntity):
    """The base type for entities that maintain create and update
    information."""
    subclass = None
    superclass = strataEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, extensiontype_=None):
        super(trackedEntity, self).__init__(extensiontype_,)
        self.createdBy = createdBy
        self.createdDate = createdDate
        self.lastModifiedBy = lastModifiedBy
        self.lastModifiedDate = lastModifiedDate
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if trackedEntity.subclass:
            return trackedEntity.subclass(*args_, **kwargs_)
        else:
            return trackedEntity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_createdBy(self): return self.createdBy
    def set_createdBy(self, createdBy): self.createdBy = createdBy
    def get_createdDate(self): return self.createdDate
    def set_createdDate(self, createdDate): self.createdDate = createdDate
    def get_lastModifiedBy(self): return self.lastModifiedBy
    def set_lastModifiedBy(self, lastModifiedBy): self.lastModifiedBy = lastModifiedBy
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate = lastModifiedDate
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='tns:', name_='trackedEntity', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='trackedEntity')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='trackedEntity'):
        super(trackedEntity, self).exportAttributes(outfile, level, already_processed, namespace_, name_='trackedEntity')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='tns:', name_='trackedEntity', fromsubclass_=False):
        super(trackedEntity, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.createdBy is not None:
            showIndent(outfile, level)
            outfile.write('<%screatedBy>%s</%screatedBy>\n' % (namespace_, self.gds_format_string(quote_xml(self.createdBy).encode(ExternalEncoding), input_name='createdBy'), namespace_))
        if self.createdDate is not None:
            showIndent(outfile, level)
            outfile.write('<%screatedDate>%s</%screatedDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.createdDate).encode(ExternalEncoding), input_name='createdDate'), namespace_))
        if self.lastModifiedBy is not None:
            showIndent(outfile, level)
            outfile.write('<%slastModifiedBy>%s</%slastModifiedBy>\n' % (namespace_, self.gds_format_string(quote_xml(self.lastModifiedBy).encode(ExternalEncoding), input_name='lastModifiedBy'), namespace_))
        if self.lastModifiedDate is not None:
            showIndent(outfile, level)
            outfile.write('<%slastModifiedDate>%s</%slastModifiedDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.lastModifiedDate).encode(ExternalEncoding), input_name='lastModifiedDate'), namespace_))
    def hasContent_(self):
        if (
            self.createdBy is not None or
            self.createdDate is not None or
            self.lastModifiedBy is not None or
            self.lastModifiedDate is not None or
            super(trackedEntity, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='trackedEntity'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(trackedEntity, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(trackedEntity, self).exportLiteralChildren(outfile, level, name_)
        if self.createdBy is not None:
            showIndent(outfile, level)
            outfile.write('createdBy=%s,\n' % quote_python(self.createdBy).encode(ExternalEncoding))
        if self.createdDate is not None:
            showIndent(outfile, level)
            outfile.write('createdDate=%s,\n' % quote_python(self.createdDate).encode(ExternalEncoding))
        if self.lastModifiedBy is not None:
            showIndent(outfile, level)
            outfile.write('lastModifiedBy=%s,\n' % quote_python(self.lastModifiedBy).encode(ExternalEncoding))
        if self.lastModifiedDate is not None:
            showIndent(outfile, level)
            outfile.write('lastModifiedDate=%s,\n' % quote_python(self.lastModifiedDate).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
        super(trackedEntity, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'createdBy':
            createdBy_ = child_.text
            createdBy_ = self.gds_validate_string(createdBy_, node, 'createdBy')
            self.createdBy = createdBy_
        elif nodeName_ == 'createdDate':
            createdDate_ = child_.text
            createdDate_ = self.gds_validate_string(createdDate_, node, 'createdDate')
            self.createdDate = createdDate_
        elif nodeName_ == 'lastModifiedBy':
            lastModifiedBy_ = child_.text
            lastModifiedBy_ = self.gds_validate_string(lastModifiedBy_, node, 'lastModifiedBy')
            self.lastModifiedBy = lastModifiedBy_
        elif nodeName_ == 'lastModifiedDate':
            lastModifiedDate_ = child_.text
            lastModifiedDate_ = self.gds_validate_string(lastModifiedDate_, node, 'lastModifiedDate')
            self.lastModifiedDate = lastModifiedDate_
        super(trackedEntity, self).buildChildren(child_, node, nodeName_, True)
# end class trackedEntity


class base_link(strataEntity):
    """ATOM link type."""
    subclass = None
    superclass = strataEntity
    def __init__(self, href=None, type_=None, uri=None, rel=None, title=None, value=None, extensiontype_=None):
        super(base_link, self).__init__(extensiontype_,)
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        self.uri = _cast(None, uri)
        self.rel = _cast(None, rel)
        self.title = _cast(None, title)
        self.value = value
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if base_link.subclass:
            return base_link.subclass(*args_, **kwargs_)
        else:
            return base_link(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='tns:', name_='base_link', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='base_link')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='base_link'):
        super(base_link, self).exportAttributes(outfile, level, already_processed, namespace_, name_='base_link')
        if self.href is not None and 'href' not in already_processed:
            already_processed.append('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'),))
        if self.uri is not None and 'uri' not in already_processed:
            already_processed.append('uri')
            outfile.write(' uri=%s' % (self.gds_format_string(quote_attrib(self.uri).encode(ExternalEncoding), input_name='uri'),))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.append('title')
            outfile.write(' title=%s' % (self.gds_format_string(quote_attrib(self.title).encode(ExternalEncoding), input_name='title'),))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='tns:', name_='base_link', fromsubclass_=False):
        super(base_link, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('<%svalue>%s</%svalue>\n' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_))
    def hasContent_(self):
        if (
            self.value is not None or
            super(base_link, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='base_link'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.append('href')
            showIndent(outfile, level)
            outfile.write('href = "%s",\n' % (self.href,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.uri is not None and 'uri' not in already_processed:
            already_processed.append('uri')
            showIndent(outfile, level)
            outfile.write('uri = "%s",\n' % (self.uri,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            showIndent(outfile, level)
            outfile.write('rel = "%s",\n' % (self.rel,))
        if self.title is not None and 'title' not in already_processed:
            already_processed.append('title')
            showIndent(outfile, level)
            outfile.write('title = "%s",\n' % (self.title,))
        super(base_link, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(base_link, self).exportLiteralChildren(outfile, level, name_)
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.append('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('uri', node)
        if value is not None and 'uri' not in already_processed:
            already_processed.append('uri')
            self.uri = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            self.rel = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.append('title')
            self.title = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
        super(base_link, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
        super(base_link, self).buildChildren(child_, node, nodeName_, True)
# end class base_link


class problems(GeneratedsSuper):
    """A list of problem reports."""
    subclass = None
    superclass = None
    def __init__(self, source=None, link=None, problem=None):
        self.source = source
        if link is None:
            self.link = []
        else:
            self.link = link
        if problem is None:
            self.problem = []
        else:
            self.problem = problem
    def factory(*args_, **kwargs_):
        if problems.subclass:
            return problems.subclass(*args_, **kwargs_)
        else:
            return problems(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def get_problem(self): return self.problem
    def set_problem(self, problem): self.problem = problem
    def add_problem(self, value): self.problem.append(value)
    def insert_problem(self, index, value): self.problem[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='problems', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='problems')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='problems'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='problems', fromsubclass_=False):
        if self.source is not None:
            showIndent(outfile, level)
            outfile.write('<%ssource>%s</%ssource>\n' % (namespace_, self.gds_format_string(quote_xml(self.source).encode(ExternalEncoding), input_name='source'), namespace_))
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link')
        for problem_ in self.problem:
            problem_.export(outfile, level, namespace_, name_='problem')
    def hasContent_(self):
        if (
            self.source is not None or
            self.link or
            self.problem
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='problems'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.source is not None:
            showIndent(outfile, level)
            outfile.write('source=%s,\n' % quote_python(self.source).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.link(\n')
            link_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('problem=[\n')
        level += 1
        for problem_ in self.problem:
            showIndent(outfile, level)
            outfile.write('model_.problem(\n')
            problem_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'source':
            source_ = child_.text
            source_ = self.gds_validate_string(source_, node, 'source')
            self.source = source_
        elif nodeName_ == 'link':
            obj_ = link.factory()
            obj_.build(child_)
            self.link.append(obj_)
        elif nodeName_ == 'problem':
            obj_ = problem.factory()
            obj_.build(child_)
            self.problem.append(obj_)
# end class problems


class problem(GeneratedsSuper):
    """A problem report."""
    subclass = None
    superclass = None
    def __init__(self, source=None, link=None):
        self.source = source
        if link is None:
            self.link = []
        else:
            self.link = link
    def factory(*args_, **kwargs_):
        if problem.subclass:
            return problem.subclass(*args_, **kwargs_)
        else:
            return problem(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='problem', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='problem')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='problem'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='problem', fromsubclass_=False):
        if self.source is not None:
            showIndent(outfile, level)
            outfile.write('<%ssource>%s</%ssource>\n' % (namespace_, self.gds_format_string(quote_xml(self.source).encode(ExternalEncoding), input_name='source'), namespace_))
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link')
    def hasContent_(self):
        if (
            self.source is not None or
            self.link
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='problem'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.source is not None:
            showIndent(outfile, level)
            outfile.write('source=%s,\n' % quote_python(self.source).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.link(\n')
            link_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'source':
            source_ = child_.text
            source_ = self.gds_validate_string(source_, node, 'source')
            self.source = source_
        elif nodeName_ == 'link':
            obj_ = link.factory()
            obj_.build(child_)
            self.link.append(obj_)
# end class problem


class solutions(GeneratedsSuper):
    """A list of solutions."""
    subclass = None
    superclass = None
    def __init__(self, solution=None):
        if solution is None:
            self.solution = []
        else:
            self.solution = solution
    def factory(*args_, **kwargs_):
        if solutions.subclass:
            return solutions.subclass(*args_, **kwargs_)
        else:
            return solutions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_solution(self): return self.solution
    def set_solution(self, solution): self.solution = solution
    def add_solution(self, value): self.solution.append(value)
    def insert_solution(self, index, value): self.solution[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='solutions', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='solutions')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='solutions'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='solutions', fromsubclass_=False):
        for solution_ in self.solution:
            solution_.export(outfile, level, namespace_, name_='solution')
    def hasContent_(self):
        if (
            self.solution
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='solutions'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('solution=[\n')
        level += 1
        for solution_ in self.solution:
            showIndent(outfile, level)
            outfile.write('model_.solution(\n')
            solution_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'solution':
            obj_ = solution.factory()
            obj_.build(child_)
            self.solution.append(obj_)
# end class solutions


class articles(GeneratedsSuper):
    """A list of articles."""
    subclass = None
    superclass = None
    def __init__(self, article=None):
        if article is None:
            self.article = []
        else:
            self.article = article
    def factory(*args_, **kwargs_):
        if articles.subclass:
            return articles.subclass(*args_, **kwargs_)
        else:
            return articles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_article(self): return self.article
    def set_article(self, article): self.article = article
    def add_article(self, value): self.article.append(value)
    def insert_article(self, index, value): self.article[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='articles', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='articles')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='articles'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='articles', fromsubclass_=False):
        for article_ in self.article:
            article_.export(outfile, level, namespace_, name_='article')
    def hasContent_(self):
        if (
            self.article
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='articles'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('article=[\n')
        level += 1
        for article_ in self.article:
            showIndent(outfile, level)
            outfile.write('model_.article(\n')
            article_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'article':
            obj_ = article.factory()
            obj_.build(child_)
            self.article.append(obj_)
# end class articles


class sqiRating(trackedEntity):
    """An SQI Rating for a KCS Solution."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, solution=None, completeTitle=None, adheresToContentStandard=None, accuratelyReflectsProblem=None, isUnique=None, clearAndConcise=None, metadataSetCorrectly=None):
        super(sqiRating, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.solution = solution
        self.completeTitle = completeTitle
        self.adheresToContentStandard = adheresToContentStandard
        self.accuratelyReflectsProblem = accuratelyReflectsProblem
        self.isUnique = isUnique
        self.clearAndConcise = clearAndConcise
        self.metadataSetCorrectly = metadataSetCorrectly
    def factory(*args_, **kwargs_):
        if sqiRating.subclass:
            return sqiRating.subclass(*args_, **kwargs_)
        else:
            return sqiRating(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_solution(self): return self.solution
    def set_solution(self, solution): self.solution = solution
    def get_completeTitle(self): return self.completeTitle
    def set_completeTitle(self, completeTitle): self.completeTitle = completeTitle
    def get_adheresToContentStandard(self): return self.adheresToContentStandard
    def set_adheresToContentStandard(self, adheresToContentStandard): self.adheresToContentStandard = adheresToContentStandard
    def get_accuratelyReflectsProblem(self): return self.accuratelyReflectsProblem
    def set_accuratelyReflectsProblem(self, accuratelyReflectsProblem): self.accuratelyReflectsProblem = accuratelyReflectsProblem
    def get_isUnique(self): return self.isUnique
    def set_isUnique(self, isUnique): self.isUnique = isUnique
    def get_clearAndConcise(self): return self.clearAndConcise
    def set_clearAndConcise(self, clearAndConcise): self.clearAndConcise = clearAndConcise
    def get_metadataSetCorrectly(self): return self.metadataSetCorrectly
    def set_metadataSetCorrectly(self, metadataSetCorrectly): self.metadataSetCorrectly = metadataSetCorrectly
    def export(self, outfile, level, namespace_='tns:', name_='sqiRating', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sqiRating')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='sqiRating'):
        super(sqiRating, self).exportAttributes(outfile, level, already_processed, namespace_, name_='sqiRating')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='sqiRating', fromsubclass_=False):
        super(sqiRating, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.solution is not None:
            self.solution.export(outfile, level, namespace_, name_='solution',)
        if self.completeTitle is not None:
            showIndent(outfile, level)
            outfile.write('<%scompleteTitle>%s</%scompleteTitle>\n' % (namespace_, self.gds_format_integer(self.completeTitle, input_name='completeTitle'), namespace_))
        if self.adheresToContentStandard is not None:
            showIndent(outfile, level)
            outfile.write('<%sadheresToContentStandard>%s</%sadheresToContentStandard>\n' % (namespace_, self.gds_format_integer(self.adheresToContentStandard, input_name='adheresToContentStandard'), namespace_))
        if self.accuratelyReflectsProblem is not None:
            showIndent(outfile, level)
            outfile.write('<%saccuratelyReflectsProblem>%s</%saccuratelyReflectsProblem>\n' % (namespace_, self.gds_format_integer(self.accuratelyReflectsProblem, input_name='accuratelyReflectsProblem'), namespace_))
        if self.isUnique is not None:
            showIndent(outfile, level)
            outfile.write('<%sisUnique>%s</%sisUnique>\n' % (namespace_, self.gds_format_integer(self.isUnique, input_name='isUnique'), namespace_))
        if self.clearAndConcise is not None:
            showIndent(outfile, level)
            outfile.write('<%sclearAndConcise>%s</%sclearAndConcise>\n' % (namespace_, self.gds_format_integer(self.clearAndConcise, input_name='clearAndConcise'), namespace_))
        if self.metadataSetCorrectly is not None:
            showIndent(outfile, level)
            outfile.write('<%smetadataSetCorrectly>%s</%smetadataSetCorrectly>\n' % (namespace_, self.gds_format_integer(self.metadataSetCorrectly, input_name='metadataSetCorrectly'), namespace_))
    def hasContent_(self):
        if (
            self.solution is not None or
            self.completeTitle is not None or
            self.adheresToContentStandard is not None or
            self.accuratelyReflectsProblem is not None or
            self.isUnique is not None or
            self.clearAndConcise is not None or
            self.metadataSetCorrectly is not None or
            super(sqiRating, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='sqiRating'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(sqiRating, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(sqiRating, self).exportLiteralChildren(outfile, level, name_)
        if self.solution is not None:
            showIndent(outfile, level)
            outfile.write('solution=model_.solutionType(\n')
            self.solution.exportLiteral(outfile, level, name_='solution')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.completeTitle is not None:
            showIndent(outfile, level)
            outfile.write('completeTitle=%d,\n' % self.completeTitle)
        if self.adheresToContentStandard is not None:
            showIndent(outfile, level)
            outfile.write('adheresToContentStandard=%d,\n' % self.adheresToContentStandard)
        if self.accuratelyReflectsProblem is not None:
            showIndent(outfile, level)
            outfile.write('accuratelyReflectsProblem=%d,\n' % self.accuratelyReflectsProblem)
        if self.isUnique is not None:
            showIndent(outfile, level)
            outfile.write('isUnique=%d,\n' % self.isUnique)
        if self.clearAndConcise is not None:
            showIndent(outfile, level)
            outfile.write('clearAndConcise=%d,\n' % self.clearAndConcise)
        if self.metadataSetCorrectly is not None:
            showIndent(outfile, level)
            outfile.write('metadataSetCorrectly=%d,\n' % self.metadataSetCorrectly)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(sqiRating, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'solution':
            obj_ = solutionType.factory()
            obj_.build(child_)
            self.set_solution(obj_)
        elif nodeName_ == 'completeTitle':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'completeTitle')
            self.completeTitle = ival_
        elif nodeName_ == 'adheresToContentStandard':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'adheresToContentStandard')
            self.adheresToContentStandard = ival_
        elif nodeName_ == 'accuratelyReflectsProblem':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'accuratelyReflectsProblem')
            self.accuratelyReflectsProblem = ival_
        elif nodeName_ == 'isUnique':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'isUnique')
            self.isUnique = ival_
        elif nodeName_ == 'clearAndConcise':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'clearAndConcise')
            self.clearAndConcise = ival_
        elif nodeName_ == 'metadataSetCorrectly':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'metadataSetCorrectly')
            self.metadataSetCorrectly = ival_
        super(sqiRating, self).buildChildren(child_, node, nodeName_, True)
# end class sqiRating


class solution(trackedEntity):
    """A KCS Solution. Some elements have subelements called "html" and
    "text". The "html" field is a "safe value" field. It is the text
    field containing HTML markup rendered from the markdown stored
    in "value". The "html" field is not editable. The "text" field
    is the editable field that may contain markdown."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, id=None, uri=None, uidName=None, view_uri=None, title=None, authorSSOName=None, lastModifiedBySSOName=None, language=None, issue=None, environment=None, resolution=None, rootCause=None, internalDiagnosticSteps=None, externalDiagnosticSteps=None, summary=None, tags=None, case=None, supportNeed=None, tag=None, published=None, hasPublishedRevision=None, isLocked=None, lockedBy=None, lockedAt=None, lockExpiresAt=None, duplicateOf=None, body=None, kcsState=None, sbrs=None, products=None, ModerationState=None, caseCount=None, abstract=None, extract=None, explanation=None, detectedLanguage=None, setLanguage=None, indexedDate=None):
        super(solution, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.id = id
        self.uri = uri
        self.uidName = uidName
        self.view_uri = view_uri
        self.title = title
        self.authorSSOName = authorSSOName
        self.lastModifiedBySSOName = lastModifiedBySSOName
        self.language = language
        self.issue = issue
        self.environment = environment
        self.resolution = resolution
        self.rootCause = rootCause
        self.internalDiagnosticSteps = internalDiagnosticSteps
        self.externalDiagnosticSteps = externalDiagnosticSteps
        self.summary = summary
        if tags is None:
            self.tags = []
        else:
            self.tags = tags
        if case is None:
            self.case = []
        else:
            self.case = case
        if supportNeed is None:
            self.supportNeed = []
        else:
            self.supportNeed = supportNeed
        if tag is None:
            self.tag = []
        else:
            self.tag = tag
        self.published = published
        self.hasPublishedRevision = hasPublishedRevision
        self.isLocked = isLocked
        self.lockedBy = lockedBy
        self.lockedAt = lockedAt
        self.lockExpiresAt = lockExpiresAt
        if duplicateOf is None:
            self.duplicateOf = []
        else:
            self.duplicateOf = duplicateOf
        self.body = body
        self.kcsState = kcsState
        self.sbrs = sbrs
        self.products = products
        self.ModerationState = ModerationState
        self.caseCount = caseCount
        self.abstract = abstract
        self.extract = extract
        self.explanation = explanation
        self.detectedLanguage = detectedLanguage
        self.setLanguage = setLanguage
        self.indexedDate = indexedDate
    def factory(*args_, **kwargs_):
        if solution.subclass:
            return solution.subclass(*args_, **kwargs_)
        else:
            return solution(*args_, **kwargs_)
    factory = staticmethod(factory)
    @set_docstring('''
    Get the solution ID number

    :returns: solution ID
    :rtype: integer''')
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    @set_docstring('''
    Get the solution REST API URI

    :returns: API URL for solution object
    :rtype: string''')
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_uidName(self): return self.uidName
    def set_uidName(self, uidName): self.uidName = uidName
    @set_docstring('''
    Get the public solution URL

    :returns: Red Hat Customer Portal URL for the solution
    :rtype: string''')
    def get_view_uri(self): return self.view_uri
    def set_view_uri(self, view_uri): self.view_uri = view_uri
    @set_docstring('''
    Get the solution title field

    :returns: Solution title
    :rtype: string''')
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_authorSSOName(self): return self.authorSSOName
    def set_authorSSOName(self, authorSSOName): self.authorSSOName = authorSSOName
    def get_lastModifiedBySSOName(self): return self.lastModifiedBySSOName
    def set_lastModifiedBySSOName(self, lastModifiedBySSOName): self.lastModifiedBySSOName = lastModifiedBySSOName
    @set_docstring('''
    Get the solution language

    :returns: Language of the retrieved solution
    :rtype: string''')
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    @set_docstring('''
    Get the solution issue field

    :returns: Plain text formatted contents of the solution issue
    :rtype: string or None''')
    def get_issue(self): return self.issue
    def set_issue(self, issue): self.issue = issue
    @set_docstring('''
    Get the solution environment field

    :returns: Plain text formatted contents of the solution environment
    :rtype: string or None''')
    def get_environment(self): return self.environment
    def set_environment(self, environment): self.environment = environment
    @set_docstring('''
    Get the solution resolution field

    :returns: Plain text formatted contents of the solution resolution
    :rtype: string or None''')
    def get_resolution(self): return self.resolution
    def set_resolution(self, resolution): self.resolution = resolution
    @set_docstring('''
    Get the solution root cause field

    :returns: Plain text formatted contents of the solution root cause
    :rtype: string or None''')
    def get_rootCause(self): return self.rootCause
    def set_rootCause(self, rootCause): self.rootCause = rootCause
    def get_internalDiagnosticSteps(self): return self.internalDiagnosticSteps
    def set_internalDiagnosticSteps(self, internalDiagnosticSteps): self.internalDiagnosticSteps = internalDiagnosticSteps
    @set_docstring('''
    Get the solution diagnostic steps field

    :returns: Plain text formatted contents of the solution diagnostic steps
    :rtype: string or None''')
    def get_externalDiagnosticSteps(self): return self.externalDiagnosticSteps
    def set_externalDiagnosticSteps(self, externalDiagnosticSteps): self.externalDiagnosticSteps = externalDiagnosticSteps
    def get_summary(self): return self.summary
    def set_summary(self, summary): self.summary = summary
    def get_tags(self): return self.tags
    def set_tags(self, tags): self.tags = tags
    def add_tags(self, value): self.tags.append(value)
    def insert_tags(self, index, value): self.tags[index] = value
    def get_case(self): return self.case
    def set_case(self, case): self.case = case
    def add_case(self, value): self.case.append(value)
    def insert_case(self, index, value): self.case[index] = value
    def get_supportNeed(self): return self.supportNeed
    def set_supportNeed(self, supportNeed): self.supportNeed = supportNeed
    def add_supportNeed(self, value): self.supportNeed.append(value)
    def insert_supportNeed(self, index, value): self.supportNeed[index] = value
    def get_tag(self): return self.tag
    def set_tag(self, tag): self.tag = tag
    def add_tag(self, value): self.tag.append(value)
    def insert_tag(self, index, value): self.tag[index] = value
    def get_published(self): return self.published
    def set_published(self, published): self.published = published
    def get_hasPublishedRevision(self): return self.hasPublishedRevision
    def set_hasPublishedRevision(self, hasPublishedRevision): self.hasPublishedRevision = hasPublishedRevision
    def get_isLocked(self): return self.isLocked
    def set_isLocked(self, isLocked): self.isLocked = isLocked
    def get_lockedBy(self): return self.lockedBy
    def set_lockedBy(self, lockedBy): self.lockedBy = lockedBy
    def get_lockedAt(self): return self.lockedAt
    def set_lockedAt(self, lockedAt): self.lockedAt = lockedAt
    def get_lockExpiresAt(self): return self.lockExpiresAt
    def set_lockExpiresAt(self, lockExpiresAt): self.lockExpiresAt = lockExpiresAt
    def get_duplicateOf(self): return self.duplicateOf
    def set_duplicateOf(self, duplicateOf): self.duplicateOf = duplicateOf
    def add_duplicateOf(self, value): self.duplicateOf.append(value)
    def insert_duplicateOf(self, index, value): self.duplicateOf[index] = value
    def get_body(self): return self.body
    def set_body(self, body): self.body = body
    @set_docstring('''
    Get the state of the solution

    :returns: The article state, either 'wip', 'unverified' or 'verified'
    :rtype: string''')
    def get_kcsState(self): return self.kcsState
    def set_kcsState(self, kcsState): self.kcsState = kcsState
    def get_sbrs(self): return self.sbrs
    def set_sbrs(self, sbrs): self.sbrs = sbrs
    def get_products(self): return self.products
    def set_products(self, products): self.products = products
    def get_ModerationState(self): return self.ModerationState
    def set_ModerationState(self, ModerationState): self.ModerationState = ModerationState
    def get_caseCount(self): return self.caseCount
    def set_caseCount(self, caseCount): self.caseCount = caseCount
    def get_abstract(self): return self.abstract
    def set_abstract(self, abstract): self.abstract = abstract
    def get_extract(self): return self.extract
    def set_extract(self, extract): self.extract = extract
    def get_explanation(self): return self.explanation
    def set_explanation(self, explanation): self.explanation = explanation
    def get_detectedLanguage(self): return self.detectedLanguage
    def set_detectedLanguage(self, detectedLanguage): self.detectedLanguage = detectedLanguage
    def get_setLanguage(self): return self.setLanguage
    def set_setLanguage(self, setLanguage): self.setLanguage = setLanguage
    def get_indexedDate(self): return self.indexedDate
    def set_indexedDate(self, indexedDate): self.indexedDate = indexedDate
    def export(self, outfile, level, namespace_='tns:', name_='solution', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='solution')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='solution'):
        super(solution, self).exportAttributes(outfile, level, already_processed, namespace_, name_='solution')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='solution', fromsubclass_=False):
        super(solution, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('<%sid>%s</%sid>\n' % (namespace_, self.gds_format_string(quote_xml(self.id).encode(ExternalEncoding), input_name='id'), namespace_))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('<%suri>%s</%suri>\n' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_))
        if self.uidName is not None:
            showIndent(outfile, level)
            outfile.write('<%suidName>%s</%suidName>\n' % (namespace_, self.gds_format_string(quote_xml(self.uidName).encode(ExternalEncoding), input_name='uidName'), namespace_))
        if self.view_uri is not None:
            showIndent(outfile, level)
            outfile.write('<%sview_uri>%s</%sview_uri>\n' % (namespace_, self.gds_format_string(quote_xml(self.view_uri).encode(ExternalEncoding), input_name='view_uri'), namespace_))
        if self.title is not None:
            showIndent(outfile, level)
            outfile.write('<%stitle>%s</%stitle>\n' % (namespace_, self.gds_format_string(quote_xml(self.title).encode(ExternalEncoding), input_name='title'), namespace_))
        if self.authorSSOName is not None:
            showIndent(outfile, level)
            outfile.write('<%sauthorSSOName>%s</%sauthorSSOName>\n' % (namespace_, self.gds_format_string(quote_xml(self.authorSSOName).encode(ExternalEncoding), input_name='authorSSOName'), namespace_))
        if self.lastModifiedBySSOName is not None:
            showIndent(outfile, level)
            outfile.write('<%slastModifiedBySSOName>%s</%slastModifiedBySSOName>\n' % (namespace_, self.gds_format_string(quote_xml(self.lastModifiedBySSOName).encode(ExternalEncoding), input_name='lastModifiedBySSOName'), namespace_))
        if self.language is not None:
            showIndent(outfile, level)
            outfile.write('<%slanguage>%s</%slanguage>\n' % (namespace_, self.gds_format_string(quote_xml(self.language).encode(ExternalEncoding), input_name='language'), namespace_))
        if self.issue is not None:
            self.issue.export(outfile, level, namespace_, name_='issue')
        if self.environment is not None:
            self.environment.export(outfile, level, namespace_, name_='environment')
        if self.resolution is not None:
            self.resolution.export(outfile, level, namespace_, name_='resolution')
        if self.rootCause is not None:
            self.rootCause.export(outfile, level, namespace_, name_='rootCause')
        if self.internalDiagnosticSteps is not None:
            self.internalDiagnosticSteps.export(outfile, level, namespace_, name_='internalDiagnosticSteps')
        if self.externalDiagnosticSteps is not None:
            showIndent(outfile, level)
            outfile.write('<%sexternalDiagnosticSteps>%s</%sexternalDiagnosticSteps>\n' % (namespace_, self.gds_format_string(quote_xml(self.externalDiagnosticSteps).encode(ExternalEncoding), input_name='externalDiagnosticSteps'), namespace_))
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('<%ssummary>%s</%ssummary>\n' % (namespace_, self.gds_format_string(quote_xml(self.summary).encode(ExternalEncoding), input_name='summary'), namespace_))
        for tags_ in self.tags:
            showIndent(outfile, level)
            outfile.write('<%stags>%s</%stags>\n' % (namespace_, self.gds_format_string(quote_xml(tags_).encode(ExternalEncoding), input_name='tags'), namespace_))
        for case_ in self.case:
            showIndent(outfile, level)
            outfile.write('<%scase>%s</%scase>\n' % (namespace_, self.gds_format_string(quote_xml(case_).encode(ExternalEncoding), input_name='case'), namespace_))
        for supportNeed_ in self.supportNeed:
            showIndent(outfile, level)
            outfile.write('<%ssupportNeed>%s</%ssupportNeed>\n' % (namespace_, self.gds_format_string(quote_xml(supportNeed_).encode(ExternalEncoding), input_name='supportNeed'), namespace_))
        for tag_ in self.tag:
            tag_.export(outfile, level, namespace_, name_='tag')
        if self.published is not None:
            showIndent(outfile, level)
            outfile.write('<%spublished>%s</%spublished>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.published)), input_name='published'), namespace_))
        if self.hasPublishedRevision is not None:
            showIndent(outfile, level)
            outfile.write('<%shasPublishedRevision>%s</%shasPublishedRevision>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.hasPublishedRevision)), input_name='hasPublishedRevision'), namespace_))
        if self.isLocked is not None:
            showIndent(outfile, level)
            outfile.write('<%sisLocked>%s</%sisLocked>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.isLocked)), input_name='isLocked'), namespace_))
        if self.lockedBy is not None:
            showIndent(outfile, level)
            outfile.write('<%slockedBy>%s</%slockedBy>\n' % (namespace_, self.gds_format_string(quote_xml(self.lockedBy).encode(ExternalEncoding), input_name='lockedBy'), namespace_))
        if self.lockedAt is not None:
            showIndent(outfile, level)
            outfile.write('<%slockedAt>%s</%slockedAt>\n' % (namespace_, self.gds_format_string(quote_xml(self.lockedAt).encode(ExternalEncoding), input_name='lockedAt'), namespace_))
        if self.lockExpiresAt is not None:
            showIndent(outfile, level)
            outfile.write('<%slockExpiresAt>%s</%slockExpiresAt>\n' % (namespace_, self.gds_format_string(quote_xml(self.lockExpiresAt).encode(ExternalEncoding), input_name='lockExpiresAt'), namespace_))
        for duplicateOf_ in self.duplicateOf:
            duplicateOf_.export(outfile, level, namespace_, name_='duplicateOf')
        if self.body is not None:
            self.body.export(outfile, level, namespace_, name_='body')
        if self.kcsState is not None:
            showIndent(outfile, level)
            outfile.write('<%skcsState>%s</%skcsState>\n' % (namespace_, self.gds_format_string(quote_xml(self.kcsState).encode(ExternalEncoding), input_name='kcsState'), namespace_))
        if self.sbrs is not None:
            self.sbrs.export(outfile, level, namespace_, name_='sbrs',)
        if self.products is not None:
            self.products.export(outfile, level, namespace_, name_='products',)
        if self.ModerationState is not None:
            showIndent(outfile, level)
            outfile.write('<%sModerationState>%s</%sModerationState>\n' % (namespace_, self.gds_format_string(quote_xml(self.ModerationState).encode(ExternalEncoding), input_name='ModerationState'), namespace_))
        if self.caseCount is not None:
            showIndent(outfile, level)
            outfile.write('<%scaseCount>%s</%scaseCount>\n' % (namespace_, self.gds_format_integer(self.caseCount, input_name='caseCount'), namespace_))
        if self.abstract is not None:
            showIndent(outfile, level)
            outfile.write('<%sabstract>%s</%sabstract>\n' % (namespace_, self.gds_format_string(quote_xml(self.abstract).encode(ExternalEncoding), input_name='abstract'), namespace_))
        if self.extract is not None:
            showIndent(outfile, level)
            outfile.write('<%sextract>%s</%sextract>\n' % (namespace_, self.gds_format_string(quote_xml(self.extract).encode(ExternalEncoding), input_name='extract'), namespace_))
        if self.explanation is not None:
            showIndent(outfile, level)
            outfile.write('<%sexplanation>%s</%sexplanation>\n' % (namespace_, self.gds_format_string(quote_xml(self.explanation).encode(ExternalEncoding), input_name='explanation'), namespace_))
        if self.detectedLanguage is not None:
            showIndent(outfile, level)
            outfile.write('<%sdetectedLanguage>%s</%sdetectedLanguage>\n' % (namespace_, self.gds_format_string(quote_xml(self.detectedLanguage).encode(ExternalEncoding), input_name='detectedLanguage'), namespace_))
        if self.setLanguage is not None:
            showIndent(outfile, level)
            outfile.write('<%ssetLanguage>%s</%ssetLanguage>\n' % (namespace_, self.gds_format_string(quote_xml(self.setLanguage).encode(ExternalEncoding), input_name='setLanguage'), namespace_))
        if self.indexedDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sindexedDate>%s</%sindexedDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.indexedDate).encode(ExternalEncoding), input_name='indexedDate'), namespace_))
    def hasContent_(self):
        if (
            self.id is not None or
            self.uri is not None or
            self.uidName is not None or
            self.view_uri is not None or
            self.title is not None or
            self.authorSSOName is not None or
            self.lastModifiedBySSOName is not None or
            self.language is not None or
            self.issue is not None or
            self.environment is not None or
            self.resolution is not None or
            self.rootCause is not None or
            self.internalDiagnosticSteps is not None or
            self.externalDiagnosticSteps is not None or
            self.summary is not None or
            self.tags or
            self.case or
            self.supportNeed or
            self.tag or
            self.published is not None or
            self.hasPublishedRevision is not None or
            self.isLocked is not None or
            self.lockedBy is not None or
            self.lockedAt is not None or
            self.lockExpiresAt is not None or
            self.duplicateOf or
            self.body is not None or
            self.kcsState is not None or
            self.sbrs is not None or
            self.products is not None or
            self.ModerationState is not None or
            self.caseCount is not None or
            self.abstract is not None or
            self.extract is not None or
            self.explanation is not None or
            self.detectedLanguage is not None or
            self.setLanguage is not None or
            self.indexedDate is not None or
            super(solution, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='solution'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(solution, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(solution, self).exportLiteralChildren(outfile, level, name_)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id=%s,\n' % quote_python(self.id).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.uidName is not None:
            showIndent(outfile, level)
            outfile.write('uidName=%s,\n' % quote_python(self.uidName).encode(ExternalEncoding))
        if self.view_uri is not None:
            showIndent(outfile, level)
            outfile.write('view_uri=%s,\n' % quote_python(self.view_uri).encode(ExternalEncoding))
        if self.title is not None:
            showIndent(outfile, level)
            outfile.write('title=%s,\n' % quote_python(self.title).encode(ExternalEncoding))
        if self.authorSSOName is not None:
            showIndent(outfile, level)
            outfile.write('authorSSOName=%s,\n' % quote_python(self.authorSSOName).encode(ExternalEncoding))
        if self.lastModifiedBySSOName is not None:
            showIndent(outfile, level)
            outfile.write('lastModifiedBySSOName=%s,\n' % quote_python(self.lastModifiedBySSOName).encode(ExternalEncoding))
        if self.language is not None:
            showIndent(outfile, level)
            outfile.write('language=%s,\n' % quote_python(self.language).encode(ExternalEncoding))
        if self.issue is not None:
            showIndent(outfile, level)
            outfile.write('issue=model_.issueType(\n')
            self.issue.exportLiteral(outfile, level, name_='issue')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.environment is not None:
            showIndent(outfile, level)
            outfile.write('environment=model_.environmentType(\n')
            self.environment.exportLiteral(outfile, level, name_='environment')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.resolution is not None:
            showIndent(outfile, level)
            outfile.write('resolution=model_.resolutionType(\n')
            self.resolution.exportLiteral(outfile, level, name_='resolution')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.rootCause is not None:
            showIndent(outfile, level)
            outfile.write('rootCause=model_.rootCauseType(\n')
            self.rootCause.exportLiteral(outfile, level, name_='rootCause')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.internalDiagnosticSteps is not None:
            showIndent(outfile, level)
            outfile.write('internalDiagnosticSteps=model_.internalDiagnosticStepsType(\n')
            self.internalDiagnosticSteps.exportLiteral(outfile, level, name_='internalDiagnosticSteps')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.externalDiagnosticSteps is not None:
            showIndent(outfile, level)
            outfile.write('externalDiagnosticSteps=%s,\n' % quote_python(self.externalDiagnosticSteps).encode(ExternalEncoding))
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('summary=%s,\n' % quote_python(self.summary).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('tags=[\n')
        level += 1
        for tags_ in self.tags:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(tags_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('case=[\n')
        level += 1
        for case_ in self.case:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(case_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('supportNeed=[\n')
        level += 1
        for supportNeed_ in self.supportNeed:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(supportNeed_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('tag=[\n')
        level += 1
        for tag_ in self.tag:
            showIndent(outfile, level)
            outfile.write('model_.tagType(\n')
            tag_.exportLiteral(outfile, level, name_='tagType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.published is not None:
            showIndent(outfile, level)
            outfile.write('published=%s,\n' % self.published)
        if self.hasPublishedRevision is not None:
            showIndent(outfile, level)
            outfile.write('hasPublishedRevision=%s,\n' % self.hasPublishedRevision)
        if self.isLocked is not None:
            showIndent(outfile, level)
            outfile.write('isLocked=%s,\n' % self.isLocked)
        if self.lockedBy is not None:
            showIndent(outfile, level)
            outfile.write('lockedBy=%s,\n' % quote_python(self.lockedBy).encode(ExternalEncoding))
        if self.lockedAt is not None:
            showIndent(outfile, level)
            outfile.write('lockedAt=%s,\n' % quote_python(self.lockedAt).encode(ExternalEncoding))
        if self.lockExpiresAt is not None:
            showIndent(outfile, level)
            outfile.write('lockExpiresAt=%s,\n' % quote_python(self.lockExpiresAt).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('duplicateOf=[\n')
        level += 1
        for duplicateOf_ in self.duplicateOf:
            showIndent(outfile, level)
            outfile.write('model_.duplicateOfType(\n')
            duplicateOf_.exportLiteral(outfile, level, name_='duplicateOfType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.body is not None:
            showIndent(outfile, level)
            outfile.write('body=model_.bodyType(\n')
            self.body.exportLiteral(outfile, level, name_='body')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.kcsState is not None:
            showIndent(outfile, level)
            outfile.write('kcsState=%s,\n' % quote_python(self.kcsState).encode(ExternalEncoding))
        if self.sbrs is not None:
            showIndent(outfile, level)
            outfile.write('sbrs=model_.sbrsType(\n')
            self.sbrs.exportLiteral(outfile, level, name_='sbrs')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.products is not None:
            showIndent(outfile, level)
            outfile.write('products=model_.productsType(\n')
            self.products.exportLiteral(outfile, level, name_='products')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ModerationState is not None:
            showIndent(outfile, level)
            outfile.write('ModerationState=%s,\n' % quote_python(self.ModerationState).encode(ExternalEncoding))
        if self.caseCount is not None:
            showIndent(outfile, level)
            outfile.write('caseCount=%d,\n' % self.caseCount)
        if self.abstract is not None:
            showIndent(outfile, level)
            outfile.write('abstract=%s,\n' % quote_python(self.abstract).encode(ExternalEncoding))
        if self.extract is not None:
            showIndent(outfile, level)
            outfile.write('extract=%s,\n' % quote_python(self.extract).encode(ExternalEncoding))
        if self.explanation is not None:
            showIndent(outfile, level)
            outfile.write('explanation=%s,\n' % quote_python(self.explanation).encode(ExternalEncoding))
        if self.detectedLanguage is not None:
            showIndent(outfile, level)
            outfile.write('detectedLanguage=%s,\n' % quote_python(self.detectedLanguage).encode(ExternalEncoding))
        if self.setLanguage is not None:
            showIndent(outfile, level)
            outfile.write('setLanguage=%s,\n' % quote_python(self.setLanguage).encode(ExternalEncoding))
        if self.indexedDate is not None:
            showIndent(outfile, level)
            outfile.write('indexedDate=%s,\n' % quote_python(self.indexedDate).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(solution, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'id':
            id_ = child_.text
            id_ = self.gds_validate_string(id_, node, 'id')
            self.id = id_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'uidName':
            uidName_ = child_.text
            uidName_ = self.gds_validate_string(uidName_, node, 'uidName')
            self.uidName = uidName_
        elif nodeName_ == 'view_uri':
            view_uri_ = child_.text
            view_uri_ = self.gds_validate_string(view_uri_, node, 'view_uri')
            self.view_uri = view_uri_
        elif nodeName_ == 'title':
            title_ = child_.text
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
        elif nodeName_ == 'authorSSOName':
            authorSSOName_ = child_.text
            authorSSOName_ = self.gds_validate_string(authorSSOName_, node, 'authorSSOName')
            self.authorSSOName = authorSSOName_
        elif nodeName_ == 'lastModifiedBySSOName':
            lastModifiedBySSOName_ = child_.text
            lastModifiedBySSOName_ = self.gds_validate_string(lastModifiedBySSOName_, node, 'lastModifiedBySSOName')
            self.lastModifiedBySSOName = lastModifiedBySSOName_
        elif nodeName_ == 'language':
            language_ = child_.text
            language_ = self.gds_validate_string(language_, node, 'language')
            self.language = language_
        elif nodeName_ == 'issue':
            obj_ = issueType.factory()
            obj_.build(child_)
            self.set_issue(obj_)
        elif nodeName_ == 'environment':
            obj_ = environmentType.factory()
            obj_.build(child_)
            self.set_environment(obj_)
        elif nodeName_ == 'resolution':
            obj_ = resolutionType.factory()
            obj_.build(child_)
            self.set_resolution(obj_)
        elif nodeName_ == 'rootCause':
            obj_ = rootCauseType.factory()
            obj_.build(child_)
            self.set_rootCause(obj_)
        elif nodeName_ == 'internalDiagnosticSteps':
            obj_ = internalDiagnosticStepsType.factory()
            obj_.build(child_)
            self.set_internalDiagnosticSteps(obj_)
        elif nodeName_ == 'externalDiagnosticSteps':
            externalDiagnosticSteps_ = child_.text
            externalDiagnosticSteps_ = self.gds_validate_string(externalDiagnosticSteps_, node, 'externalDiagnosticSteps')
            self.externalDiagnosticSteps = externalDiagnosticSteps_
        elif nodeName_ == 'summary':
            summary_ = child_.text
            summary_ = self.gds_validate_string(summary_, node, 'summary')
            self.summary = summary_
        elif nodeName_ == 'tags':
            tags_ = child_.text
            tags_ = self.gds_validate_string(tags_, node, 'tags')
            self.tags.append(tags_)
        elif nodeName_ == 'case':
            case_ = child_.text
            case_ = self.gds_validate_string(case_, node, 'case')
            self.case.append(case_)
        elif nodeName_ == 'supportNeed':
            supportNeed_ = child_.text
            supportNeed_ = self.gds_validate_string(supportNeed_, node, 'supportNeed')
            self.supportNeed.append(supportNeed_)
        elif nodeName_ == 'tag':
            obj_ = tagType.factory()
            obj_.build(child_)
            self.tag.append(obj_)
        elif nodeName_ == 'published':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'published')
            self.published = ival_
        elif nodeName_ == 'hasPublishedRevision':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'hasPublishedRevision')
            self.hasPublishedRevision = ival_
        elif nodeName_ == 'isLocked':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'isLocked')
            self.isLocked = ival_
        elif nodeName_ == 'lockedBy':
            lockedBy_ = child_.text
            lockedBy_ = self.gds_validate_string(lockedBy_, node, 'lockedBy')
            self.lockedBy = lockedBy_
        elif nodeName_ == 'lockedAt':
            lockedAt_ = child_.text
            lockedAt_ = self.gds_validate_string(lockedAt_, node, 'lockedAt')
            self.lockedAt = lockedAt_
        elif nodeName_ == 'lockExpiresAt':
            lockExpiresAt_ = child_.text
            lockExpiresAt_ = self.gds_validate_string(lockExpiresAt_, node, 'lockExpiresAt')
            self.lockExpiresAt = lockExpiresAt_
        elif nodeName_ == 'duplicateOf':
            obj_ = duplicateOfType.factory()
            obj_.build(child_)
            self.duplicateOf.append(obj_)
        elif nodeName_ == 'body':
            obj_ = bodyType.factory()
            obj_.build(child_)
            self.set_body(obj_)
        elif nodeName_ == 'kcsState':
            kcsState_ = child_.text
            kcsState_ = self.gds_validate_string(kcsState_, node, 'kcsState')
            self.kcsState = kcsState_
        elif nodeName_ == 'sbrs':
            obj_ = sbrsType.factory()
            obj_.build(child_)
            self.set_sbrs(obj_)
        elif nodeName_ == 'products':
            obj_ = productsType.factory()
            obj_.build(child_)
            self.set_products(obj_)
        elif nodeName_ == 'ModerationState':
            ModerationState_ = child_.text
            ModerationState_ = self.gds_validate_string(ModerationState_, node, 'ModerationState')
            self.ModerationState = ModerationState_
        elif nodeName_ == 'caseCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'caseCount')
            self.caseCount = ival_
        elif nodeName_ == 'abstract':
            abstract_ = child_.text
            abstract_ = self.gds_validate_string(abstract_, node, 'abstract')
            self.abstract = abstract_
        elif nodeName_ == 'extract':
            extract_ = child_.text
            extract_ = self.gds_validate_string(extract_, node, 'extract')
            self.extract = extract_
        elif nodeName_ == 'explanation':
            explanation_ = child_.text
            explanation_ = self.gds_validate_string(explanation_, node, 'explanation')
            self.explanation = explanation_
        elif nodeName_ == 'detectedLanguage':
            detectedLanguage_ = child_.text
            detectedLanguage_ = self.gds_validate_string(detectedLanguage_, node, 'detectedLanguage')
            self.detectedLanguage = detectedLanguage_
        elif nodeName_ == 'setLanguage':
            setLanguage_ = child_.text
            setLanguage_ = self.gds_validate_string(setLanguage_, node, 'setLanguage')
            self.setLanguage = setLanguage_
        elif nodeName_ == 'indexedDate':
            indexedDate_ = child_.text
            indexedDate_ = self.gds_validate_string(indexedDate_, node, 'indexedDate')
            self.indexedDate = indexedDate_
        super(solution, self).buildChildren(child_, node, nodeName_, True)
# end class solution


class article(trackedEntity):
    """A KCS Article. Some elements have subelements called "html" and
    "text". The "html" field is "safe value" field. It is the text
    field rendered as HTML so there is no markup in the "html" field
    and it is not editable. The "text" field is an editable field
    that may contain HTML markup."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, id=None, uri=None, uidName=None, view_uri=None, title=None, authorSSOName=None, lastModifiedBySSOName=None, language=None, issue=None, environment=None, resolution=None, rootCause=None, internalDiagnosticSteps=None, articleBody=None, externalDiagnosticSteps=None, summary=None, tags=None, case=None, tag=None, published=None, duplicateOf=None, kcsState=None, body=None, explanation=None):
        super(article, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.id = id
        self.uri = uri
        self.uidName = uidName
        self.view_uri = view_uri
        self.title = title
        self.authorSSOName = authorSSOName
        self.lastModifiedBySSOName = lastModifiedBySSOName
        self.language = language
        self.issue = issue
        self.environment = environment
        self.resolution = resolution
        self.rootCause = rootCause
        self.internalDiagnosticSteps = internalDiagnosticSteps
        self.articleBody = articleBody
        self.externalDiagnosticSteps = externalDiagnosticSteps
        self.summary = summary
        if tags is None:
            self.tags = []
        else:
            self.tags = tags
        if case is None:
            self.case = []
        else:
            self.case = case
        if tag is None:
            self.tag = []
        else:
            self.tag = tag
        self.published = published
        if duplicateOf is None:
            self.duplicateOf = []
        else:
            self.duplicateOf = duplicateOf
        self.kcsState = kcsState
        self.body = body
        self.explanation = explanation
    def factory(*args_, **kwargs_):
        if article.subclass:
            return article.subclass(*args_, **kwargs_)
        else:
            return article(*args_, **kwargs_)
    factory = staticmethod(factory)
    @set_docstring('''
    Get the article ID number

    :returns: article ID
    :rtype: integer''')
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    @set_docstring('''
    Get the article's REST API URI

    :returns: API URL for article object
    :rtype: string''')
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_uidName(self): return self.uidName
    def set_uidName(self, uidName): self.uidName = uidName
    @set_docstring('''
    Get the public article URL

    :returns: Red Hat Customer Portal URL for the article
    :rtype: string''')
    def get_view_uri(self): return self.view_uri
    def set_view_uri(self, view_uri): self.view_uri = view_uri
    @set_docstring('''
    Get the article title field

    :returns: Article title
    :rtype: string''')
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_authorSSOName(self): return self.authorSSOName
    def set_authorSSOName(self, authorSSOName): self.authorSSOName = authorSSOName
    def get_lastModifiedBySSOName(self): return self.lastModifiedBySSOName
    def set_lastModifiedBySSOName(self, lastModifiedBySSOName): self.lastModifiedBySSOName = lastModifiedBySSOName
    @set_docstring('''
    Get the article language

    :returns: Language of the retrieved article
    :rtype: string''')
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_issue(self): return self.issue
    def set_issue(self, issue): self.issue = issue
    def get_environment(self): return self.environment
    def set_environment(self, environment): self.environment = environment
    def get_resolution(self): return self.resolution
    def set_resolution(self, resolution): self.resolution = resolution
    def get_rootCause(self): return self.rootCause
    def set_rootCause(self, rootCause): self.rootCause = rootCause
    def get_internalDiagnosticSteps(self): return self.internalDiagnosticSteps
    def set_internalDiagnosticSteps(self, internalDiagnosticSteps): self.internalDiagnosticSteps = internalDiagnosticSteps
    @set_docstring('''
    Get the article content

    :returns: Plain text formatted contents of the article
    :rtype: string or None''')
    def get_articleBody(self): return self.articleBody
    def set_articleBody(self, articleBody): self.articleBody = articleBody
    def get_externalDiagnosticSteps(self): return self.externalDiagnosticSteps
    def set_externalDiagnosticSteps(self, externalDiagnosticSteps): self.externalDiagnosticSteps = externalDiagnosticSteps
    def get_summary(self): return self.summary
    def set_summary(self, summary): self.summary = summary
    def get_tags(self): return self.tags
    def set_tags(self, tags): self.tags = tags
    def add_tags(self, value): self.tags.append(value)
    def insert_tags(self, index, value): self.tags[index] = value
    def get_case(self): return self.case
    def set_case(self, case): self.case = case
    def add_case(self, value): self.case.append(value)
    def insert_case(self, index, value): self.case[index] = value
    def get_tag(self): return self.tag
    def set_tag(self, tag): self.tag = tag
    def add_tag(self, value): self.tag.append(value)
    def insert_tag(self, index, value): self.tag[index] = value
    def get_published(self): return self.published
    def set_published(self, published): self.published = published
    def get_duplicateOf(self): return self.duplicateOf
    def set_duplicateOf(self, duplicateOf): self.duplicateOf = duplicateOf
    def add_duplicateOf(self, value): self.duplicateOf.append(value)
    def insert_duplicateOf(self, index, value): self.duplicateOf[index] = value
    def get_kcsState(self): return self.kcsState
    def set_kcsState(self, kcsState): self.kcsState = kcsState
    def get_body(self): return self.body
    def set_body(self, body): self.body = body
    def get_explanation(self): return self.explanation
    def set_explanation(self, explanation): self.explanation = explanation
    def export(self, outfile, level, namespace_='tns:', name_='article', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='article')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='article'):
        super(article, self).exportAttributes(outfile, level, already_processed, namespace_, name_='article')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='article', fromsubclass_=False):
        super(article, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('<%sid>%s</%sid>\n' % (namespace_, self.gds_format_string(quote_xml(self.id).encode(ExternalEncoding), input_name='id'), namespace_))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('<%suri>%s</%suri>\n' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_))
        if self.uidName is not None:
            showIndent(outfile, level)
            outfile.write('<%suidName>%s</%suidName>\n' % (namespace_, self.gds_format_string(quote_xml(self.uidName).encode(ExternalEncoding), input_name='uidName'), namespace_))
        if self.view_uri is not None:
            showIndent(outfile, level)
            outfile.write('<%sview_uri>%s</%sview_uri>\n' % (namespace_, self.gds_format_string(quote_xml(self.view_uri).encode(ExternalEncoding), input_name='view_uri'), namespace_))
        if self.title is not None:
            showIndent(outfile, level)
            outfile.write('<%stitle>%s</%stitle>\n' % (namespace_, self.gds_format_string(quote_xml(self.title).encode(ExternalEncoding), input_name='title'), namespace_))
        if self.authorSSOName is not None:
            showIndent(outfile, level)
            outfile.write('<%sauthorSSOName>%s</%sauthorSSOName>\n' % (namespace_, self.gds_format_string(quote_xml(self.authorSSOName).encode(ExternalEncoding), input_name='authorSSOName'), namespace_))
        if self.lastModifiedBySSOName is not None:
            showIndent(outfile, level)
            outfile.write('<%slastModifiedBySSOName>%s</%slastModifiedBySSOName>\n' % (namespace_, self.gds_format_string(quote_xml(self.lastModifiedBySSOName).encode(ExternalEncoding), input_name='lastModifiedBySSOName'), namespace_))
        if self.language is not None:
            showIndent(outfile, level)
            outfile.write('<%slanguage>%s</%slanguage>\n' % (namespace_, self.gds_format_string(quote_xml(self.language).encode(ExternalEncoding), input_name='language'), namespace_))
        if self.issue is not None:
            self.issue.export(outfile, level, namespace_, name_='issue')
        if self.environment is not None:
            self.environment.export(outfile, level, namespace_, name_='environment')
        if self.resolution is not None:
            self.resolution.export(outfile, level, namespace_, name_='resolution')
        if self.rootCause is not None:
            self.rootCause.export(outfile, level, namespace_, name_='rootCause')
        if self.internalDiagnosticSteps is not None:
            self.internalDiagnosticSteps.export(outfile, level, namespace_, name_='internalDiagnosticSteps')
        if self.articleBody is not None:
            self.articleBody.export(outfile, level, namespace_, name_='articleBody')
        if self.externalDiagnosticSteps is not None:
            showIndent(outfile, level)
            outfile.write('<%sexternalDiagnosticSteps>%s</%sexternalDiagnosticSteps>\n' % (namespace_, self.gds_format_string(quote_xml(self.externalDiagnosticSteps).encode(ExternalEncoding), input_name='externalDiagnosticSteps'), namespace_))
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('<%ssummary>%s</%ssummary>\n' % (namespace_, self.gds_format_string(quote_xml(self.summary).encode(ExternalEncoding), input_name='summary'), namespace_))
        for tags_ in self.tags:
            showIndent(outfile, level)
            outfile.write('<%stags>%s</%stags>\n' % (namespace_, self.gds_format_string(quote_xml(tags_).encode(ExternalEncoding), input_name='tags'), namespace_))
        for case_ in self.case:
            showIndent(outfile, level)
            outfile.write('<%scase>%s</%scase>\n' % (namespace_, self.gds_format_string(quote_xml(case_).encode(ExternalEncoding), input_name='case'), namespace_))
        for tag_ in self.tag:
            tag_.export(outfile, level, namespace_, name_='tag')
        if self.published is not None:
            showIndent(outfile, level)
            outfile.write('<%spublished>%s</%spublished>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.published)), input_name='published'), namespace_))
        for duplicateOf_ in self.duplicateOf:
            duplicateOf_.export(outfile, level, namespace_, name_='duplicateOf')
        if self.kcsState is not None:
            showIndent(outfile, level)
            outfile.write('<%skcsState>%s</%skcsState>\n' % (namespace_, self.gds_format_string(quote_xml(self.kcsState).encode(ExternalEncoding), input_name='kcsState'), namespace_))
        if self.body is not None:
            showIndent(outfile, level)
            outfile.write('<%sbody>%s</%sbody>\n' % (namespace_, self.gds_format_string(quote_xml(self.body).encode(ExternalEncoding), input_name='body'), namespace_))
        if self.explanation is not None:
            showIndent(outfile, level)
            outfile.write('<%sexplanation>%s</%sexplanation>\n' % (namespace_, self.gds_format_string(quote_xml(self.explanation).encode(ExternalEncoding), input_name='explanation'), namespace_))
    def hasContent_(self):
        if (
            self.id is not None or
            self.uri is not None or
            self.uidName is not None or
            self.view_uri is not None or
            self.title is not None or
            self.authorSSOName is not None or
            self.lastModifiedBySSOName is not None or
            self.language is not None or
            self.issue is not None or
            self.environment is not None or
            self.resolution is not None or
            self.rootCause is not None or
            self.internalDiagnosticSteps is not None or
            self.articleBody is not None or
            self.externalDiagnosticSteps is not None or
            self.summary is not None or
            self.tags or
            self.case or
            self.tag or
            self.published is not None or
            self.duplicateOf or
            self.kcsState is not None or
            self.body is not None or
            self.explanation is not None or
            super(article, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='article'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(article, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(article, self).exportLiteralChildren(outfile, level, name_)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id=%s,\n' % quote_python(self.id).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.uidName is not None:
            showIndent(outfile, level)
            outfile.write('uidName=%s,\n' % quote_python(self.uidName).encode(ExternalEncoding))
        if self.view_uri is not None:
            showIndent(outfile, level)
            outfile.write('view_uri=%s,\n' % quote_python(self.view_uri).encode(ExternalEncoding))
        if self.title is not None:
            showIndent(outfile, level)
            outfile.write('title=%s,\n' % quote_python(self.title).encode(ExternalEncoding))
        if self.authorSSOName is not None:
            showIndent(outfile, level)
            outfile.write('authorSSOName=%s,\n' % quote_python(self.authorSSOName).encode(ExternalEncoding))
        if self.lastModifiedBySSOName is not None:
            showIndent(outfile, level)
            outfile.write('lastModifiedBySSOName=%s,\n' % quote_python(self.lastModifiedBySSOName).encode(ExternalEncoding))
        if self.language is not None:
            showIndent(outfile, level)
            outfile.write('language=%s,\n' % quote_python(self.language).encode(ExternalEncoding))
        if self.issue is not None:
            showIndent(outfile, level)
            outfile.write('issue=model_.issueType1(\n')
            self.issue.exportLiteral(outfile, level, name_='issue')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.environment is not None:
            showIndent(outfile, level)
            outfile.write('environment=model_.environmentType1(\n')
            self.environment.exportLiteral(outfile, level, name_='environment')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.resolution is not None:
            showIndent(outfile, level)
            outfile.write('resolution=model_.resolutionType1(\n')
            self.resolution.exportLiteral(outfile, level, name_='resolution')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.rootCause is not None:
            showIndent(outfile, level)
            outfile.write('rootCause=model_.rootCauseType1(\n')
            self.rootCause.exportLiteral(outfile, level, name_='rootCause')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.internalDiagnosticSteps is not None:
            showIndent(outfile, level)
            outfile.write('internalDiagnosticSteps=model_.internalDiagnosticStepsType1(\n')
            self.internalDiagnosticSteps.exportLiteral(outfile, level, name_='internalDiagnosticSteps')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.articleBody is not None:
            showIndent(outfile, level)
            outfile.write('articleBody=model_.articleBodyType(\n')
            self.articleBody.exportLiteral(outfile, level, name_='articleBody')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.externalDiagnosticSteps is not None:
            showIndent(outfile, level)
            outfile.write('externalDiagnosticSteps=%s,\n' % quote_python(self.externalDiagnosticSteps).encode(ExternalEncoding))
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('summary=%s,\n' % quote_python(self.summary).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('tags=[\n')
        level += 1
        for tags_ in self.tags:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(tags_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('case=[\n')
        level += 1
        for case_ in self.case:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(case_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('tag=[\n')
        level += 1
        for tag_ in self.tag:
            showIndent(outfile, level)
            outfile.write('model_.tagType1(\n')
            tag_.exportLiteral(outfile, level, name_='tagType1')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.published is not None:
            showIndent(outfile, level)
            outfile.write('published=%s,\n' % self.published)
        showIndent(outfile, level)
        outfile.write('duplicateOf=[\n')
        level += 1
        for duplicateOf_ in self.duplicateOf:
            showIndent(outfile, level)
            outfile.write('model_.duplicateOfType1(\n')
            duplicateOf_.exportLiteral(outfile, level, name_='duplicateOfType1')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.kcsState is not None:
            showIndent(outfile, level)
            outfile.write('kcsState=%s,\n' % quote_python(self.kcsState).encode(ExternalEncoding))
        if self.body is not None:
            showIndent(outfile, level)
            outfile.write('body=%s,\n' % quote_python(self.body).encode(ExternalEncoding))
        if self.explanation is not None:
            showIndent(outfile, level)
            outfile.write('explanation=%s,\n' % quote_python(self.explanation).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(article, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'id':
            id_ = child_.text
            id_ = self.gds_validate_string(id_, node, 'id')
            self.id = id_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'uidName':
            uidName_ = child_.text
            uidName_ = self.gds_validate_string(uidName_, node, 'uidName')
            self.uidName = uidName_
        elif nodeName_ == 'view_uri':
            view_uri_ = child_.text
            view_uri_ = self.gds_validate_string(view_uri_, node, 'view_uri')
            self.view_uri = view_uri_
        elif nodeName_ == 'title':
            title_ = child_.text
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
        elif nodeName_ == 'authorSSOName':
            authorSSOName_ = child_.text
            authorSSOName_ = self.gds_validate_string(authorSSOName_, node, 'authorSSOName')
            self.authorSSOName = authorSSOName_
        elif nodeName_ == 'lastModifiedBySSOName':
            lastModifiedBySSOName_ = child_.text
            lastModifiedBySSOName_ = self.gds_validate_string(lastModifiedBySSOName_, node, 'lastModifiedBySSOName')
            self.lastModifiedBySSOName = lastModifiedBySSOName_
        elif nodeName_ == 'language':
            language_ = child_.text
            language_ = self.gds_validate_string(language_, node, 'language')
            self.language = language_
        elif nodeName_ == 'issue':
            obj_ = issueType1.factory()
            obj_.build(child_)
            self.set_issue(obj_)
        elif nodeName_ == 'environment':
            obj_ = environmentType1.factory()
            obj_.build(child_)
            self.set_environment(obj_)
        elif nodeName_ == 'resolution':
            obj_ = resolutionType1.factory()
            obj_.build(child_)
            self.set_resolution(obj_)
        elif nodeName_ == 'rootCause':
            obj_ = rootCauseType1.factory()
            obj_.build(child_)
            self.set_rootCause(obj_)
        elif nodeName_ == 'internalDiagnosticSteps':
            obj_ = internalDiagnosticStepsType1.factory()
            obj_.build(child_)
            self.set_internalDiagnosticSteps(obj_)
        elif nodeName_ == 'articleBody':
            obj_ = articleBodyType.factory()
            obj_.build(child_)
            self.set_articleBody(obj_)
        elif nodeName_ == 'externalDiagnosticSteps':
            externalDiagnosticSteps_ = child_.text
            externalDiagnosticSteps_ = self.gds_validate_string(externalDiagnosticSteps_, node, 'externalDiagnosticSteps')
            self.externalDiagnosticSteps = externalDiagnosticSteps_
        elif nodeName_ == 'summary':
            summary_ = child_.text
            summary_ = self.gds_validate_string(summary_, node, 'summary')
            self.summary = summary_
        elif nodeName_ == 'tags':
            tags_ = child_.text
            tags_ = self.gds_validate_string(tags_, node, 'tags')
            self.tags.append(tags_)
        elif nodeName_ == 'case':
            case_ = child_.text
            case_ = self.gds_validate_string(case_, node, 'case')
            self.case.append(case_)
        elif nodeName_ == 'tag':
            obj_ = tagType1.factory()
            obj_.build(child_)
            self.tag.append(obj_)
        elif nodeName_ == 'published':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'published')
            self.published = ival_
        elif nodeName_ == 'duplicateOf':
            obj_ = duplicateOfType1.factory()
            obj_.build(child_)
            self.duplicateOf.append(obj_)
        elif nodeName_ == 'kcsState':
            kcsState_ = child_.text
            kcsState_ = self.gds_validate_string(kcsState_, node, 'kcsState')
            self.kcsState = kcsState_
        elif nodeName_ == 'body':
            body_ = child_.text
            body_ = self.gds_validate_string(body_, node, 'body')
            self.body = body_
        elif nodeName_ == 'explanation':
            explanation_ = child_.text
            explanation_ = self.gds_validate_string(explanation_, node, 'explanation')
            self.explanation = explanation_
        super(article, self).buildChildren(child_, node, nodeName_, True)
# end class article


class link(base_link):
    """Simple ATOM link type."""
    subclass = None
    superclass = base_link
    def __init__(self, href=None, type_=None, uri=None, rel=None, title=None, value=None, ssoUsername=None, explanation=None):
        super(link, self).__init__(href, type_, uri, rel, title, value,)
        self.ssoUsername = _cast(None, ssoUsername)
        self.explanation = _cast(None, explanation)
        pass
    def factory(*args_, **kwargs_):
        if link.subclass:
            return link.subclass(*args_, **kwargs_)
        else:
            return link(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ssoUsername(self): return self.ssoUsername
    def set_ssoUsername(self, ssoUsername): self.ssoUsername = ssoUsername
    def get_explanation(self): return self.explanation
    def set_explanation(self, explanation): self.explanation = explanation
    def export(self, outfile, level, namespace_='tns:', name_='link', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='link')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='link'):
        super(link, self).exportAttributes(outfile, level, already_processed, namespace_, name_='link')
        if self.ssoUsername is not None and 'ssoUsername' not in already_processed:
            already_processed.append('ssoUsername')
            outfile.write(' ssoUsername=%s' % (self.gds_format_string(quote_attrib(self.ssoUsername).encode(ExternalEncoding), input_name='ssoUsername'),))
        if self.explanation is not None and 'explanation' not in already_processed:
            already_processed.append('explanation')
            outfile.write(' explanation=%s' % (self.gds_format_string(quote_attrib(self.explanation).encode(ExternalEncoding), input_name='explanation'),))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='link', fromsubclass_=False):
        super(link, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(link, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='link'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.ssoUsername is not None and 'ssoUsername' not in already_processed:
            already_processed.append('ssoUsername')
            showIndent(outfile, level)
            outfile.write('ssoUsername = "%s",\n' % (self.ssoUsername,))
        if self.explanation is not None and 'explanation' not in already_processed:
            already_processed.append('explanation')
            showIndent(outfile, level)
            outfile.write('explanation = "%s",\n' % (self.explanation,))
        super(link, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(link, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ssoUsername', node)
        if value is not None and 'ssoUsername' not in already_processed:
            already_processed.append('ssoUsername')
            self.ssoUsername = value
        value = find_attr_value_('explanation', node)
        if value is not None and 'explanation' not in already_processed:
            already_processed.append('explanation')
            self.explanation = value
        super(link, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(link, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class link


class source(GeneratedsSuper):
    """The source of a problem"""
    subclass = None
    superclass = None
    def __init__(self, name=None, valueOf_=None):
        self.name = _cast(None, name)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if source.subclass:
            return source.subclass(*args_, **kwargs_)
        else:
            return source(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='tns:', name_='source', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='source')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='source'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'),))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='source', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='source'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class source


class attachments(strataEntity):
    """A list of attachments."""
    subclass = None
    superclass = strataEntity
    def __init__(self, attachment=None):
        super(attachments, self).__init__()
        if attachment is None:
            self.attachment = []
        else:
            self.attachment = attachment
    def factory(*args_, **kwargs_):
        if attachments.subclass:
            return attachments.subclass(*args_, **kwargs_)
        else:
            return attachments(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_attachment(self): return self.attachment
    def set_attachment(self, attachment): self.attachment = attachment
    def add_attachment(self, value): self.attachment.append(value)
    def insert_attachment(self, index, value): self.attachment[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='attachments', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='attachments')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='attachments'):
        super(attachments, self).exportAttributes(outfile, level, already_processed, namespace_, name_='attachments')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='attachments', fromsubclass_=False):
        super(attachments, self).exportChildren(outfile, level, namespace_, name_, True)
        for attachment_ in self.attachment:
            attachment_.export(outfile, level, namespace_, name_='attachment')
    def hasContent_(self):
        if (
            self.attachment or
            super(attachments, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='attachments'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(attachments, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(attachments, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('attachment=[\n')
        level += 1
        for attachment_ in self.attachment:
            showIndent(outfile, level)
            outfile.write('model_.attachment(\n')
            attachment_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(attachments, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'attachment':
            obj_ = attachment.factory()
            obj_.build(child_)
            self.attachment.append(obj_)
        super(attachments, self).buildChildren(child_, node, nodeName_, True)
# end class attachments


class attachment(trackedEntity):
    """A file attachment and related meta data."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, caseNumber=None, caseId=None, uuid=None, etag=None, uri=None, fileDate=None, fileName=None, description=None, mimeType=None, length=None, active=None, deprecated=None, private=False):
        super(attachment, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.caseNumber = _cast(None, caseNumber)
        self.caseId = caseId
        self.uuid = uuid
        self.etag = etag
        self.uri = uri
        self.fileDate = fileDate
        self.fileName = fileName
        self.description = description
        self.mimeType = mimeType
        self.length = length
        self.active = active
        self.deprecated = deprecated
        self.private = private
    def factory(*args_, **kwargs_):
        if attachment.subclass:
            return attachment.subclass(*args_, **kwargs_)
        else:
            return attachment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_caseId(self): return self.caseId
    def set_caseId(self, caseId): self.caseId = caseId
    @set_docstring('''
    Get the attachment UUID

    :returns: attachment UUID
    :rtype: string (uuid)''')
    def get_uuid(self): return self.uuid
    def set_uuid(self, uuid): self.uuid = uuid
    def get_etag(self): return self.etag
    def set_etag(self, etag): self.etag = etag
    @set_docstring('''
    Get the attachment REST API URI

    :returns: API URL for attachment object
    :rtype: string''')
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_fileDate(self): return self.fileDate
    def set_fileDate(self, fileDate): self.fileDate = fileDate
    @set_docstring('''
    Get the attachment filename

    :returns: Filename of the attachment
    :rtype: string''')
    def get_fileName(self): return self.fileName
    def set_fileName(self, fileName): self.fileName = fileName
    @set_docstring('''
    Get the attachment description

    :returns: The description of the attachment object
    :rtype: string''')
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    @set_docstring('''
    Get the MIME type of the attached file

    :returns: Attachment's MIME type
    :rtype: string''')
    def get_mimeType(self): return self.mimeType
    def set_mimeType(self, mimeType): self.mimeType = mimeType
    @set_docstring('''
    Get the file length of the attached file

    :returns: File length in bytes
    :rtype: int''')
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_deprecated(self): return self.deprecated
    def set_deprecated(self, deprecated): self.deprecated = deprecated
    def get_private(self): return self.private
    def set_private(self, private): self.private = private
    def get_caseNumber(self): return self.caseNumber
    def set_caseNumber(self, caseNumber): self.caseNumber = caseNumber
    def export(self, outfile, level, namespace_='tns:', name_='attachment', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='attachment')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='attachment'):
        super(attachment, self).exportAttributes(outfile, level, already_processed, namespace_, name_='attachment')
        if self.caseNumber is not None and 'caseNumber' not in already_processed:
            already_processed.append('caseNumber')
            outfile.write(' caseNumber=%s' % (self.gds_format_string(quote_attrib(self.caseNumber).encode(ExternalEncoding), input_name='caseNumber'),))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='attachment', fromsubclass_=False):
        super(attachment, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.caseId is not None:
            showIndent(outfile, level)
            outfile.write('<%scaseId>%s</%scaseId>\n' % (namespace_, self.gds_format_string(quote_xml(self.caseId).encode(ExternalEncoding), input_name='caseId'), namespace_))
        if self.uuid is not None:
            showIndent(outfile, level)
            outfile.write('<%suuid>%s</%suuid>\n' % (namespace_, self.gds_format_string(quote_xml(self.uuid).encode(ExternalEncoding), input_name='uuid'), namespace_))
        if self.etag is not None:
            showIndent(outfile, level)
            outfile.write('<%setag>%s</%setag>\n' % (namespace_, self.gds_format_string(quote_xml(self.etag).encode(ExternalEncoding), input_name='etag'), namespace_))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('<%suri>%s</%suri>\n' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_))
        if self.fileDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sfileDate>%s</%sfileDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.fileDate).encode(ExternalEncoding), input_name='fileDate'), namespace_))
        if self.fileName is not None:
            showIndent(outfile, level)
            outfile.write('<%sfileName>%s</%sfileName>\n' % (namespace_, self.gds_format_string(quote_xml(self.fileName).encode(ExternalEncoding), input_name='fileName'), namespace_))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('<%sdescription>%s</%sdescription>\n' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_))
        if self.mimeType is not None:
            showIndent(outfile, level)
            outfile.write('<%smimeType>%s</%smimeType>\n' % (namespace_, self.gds_format_string(quote_xml(self.mimeType).encode(ExternalEncoding), input_name='mimeType'), namespace_))
        if self.length is not None:
            showIndent(outfile, level)
            outfile.write('<%slength>%s</%slength>\n' % (namespace_, self.gds_format_integer(self.length, input_name='length'), namespace_))
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('<%sactive>%s</%sactive>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.active)), input_name='active'), namespace_))
        if self.deprecated is not None:
            showIndent(outfile, level)
            outfile.write('<%sdeprecated>%s</%sdeprecated>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.deprecated)), input_name='deprecated'), namespace_))
        if self.private is not None:
            showIndent(outfile, level)
            outfile.write('<%sprivate>%s</%sprivate>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.private)), input_name='private'), namespace_))
    def hasContent_(self):
        if (
            self.caseId is not None or
            self.uuid is not None or
            self.etag is not None or
            self.uri is not None or
            self.fileDate is not None or
            self.fileName is not None or
            self.description is not None or
            self.mimeType is not None or
            self.length is not None or
            self.active is not None or
            self.deprecated is not None or
            self.private is not None or
            super(attachment, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='attachment'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.caseNumber is not None and 'caseNumber' not in already_processed:
            already_processed.append('caseNumber')
            showIndent(outfile, level)
            outfile.write('caseNumber = "%s",\n' % (self.caseNumber,))
        super(attachment, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(attachment, self).exportLiteralChildren(outfile, level, name_)
        if self.caseId is not None:
            showIndent(outfile, level)
            outfile.write('caseId=%s,\n' % quote_python(self.caseId).encode(ExternalEncoding))
        if self.uuid is not None:
            showIndent(outfile, level)
            outfile.write('uuid=%s,\n' % quote_python(self.uuid).encode(ExternalEncoding))
        if self.etag is not None:
            showIndent(outfile, level)
            outfile.write('etag=%s,\n' % quote_python(self.etag).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.fileDate is not None:
            showIndent(outfile, level)
            outfile.write('fileDate=%s,\n' % quote_python(self.fileDate).encode(ExternalEncoding))
        if self.fileName is not None:
            showIndent(outfile, level)
            outfile.write('fileName=%s,\n' % quote_python(self.fileName).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.mimeType is not None:
            showIndent(outfile, level)
            outfile.write('mimeType=%s,\n' % quote_python(self.mimeType).encode(ExternalEncoding))
        if self.length is not None:
            showIndent(outfile, level)
            outfile.write('length=%d,\n' % self.length)
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%s,\n' % self.active)
        if self.deprecated is not None:
            showIndent(outfile, level)
            outfile.write('deprecated=%s,\n' % self.deprecated)
        if self.private is not None:
            showIndent(outfile, level)
            outfile.write('private=%s,\n' % self.private)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('caseNumber', node)
        if value is not None and 'caseNumber' not in already_processed:
            already_processed.append('caseNumber')
            self.caseNumber = value
        super(attachment, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'caseId':
            caseId_ = child_.text
            caseId_ = self.gds_validate_string(caseId_, node, 'caseId')
            self.caseId = caseId_
        elif nodeName_ == 'uuid':
            uuid_ = child_.text
            uuid_ = self.gds_validate_string(uuid_, node, 'uuid')
            self.uuid = uuid_
        elif nodeName_ == 'etag':
            etag_ = child_.text
            etag_ = self.gds_validate_string(etag_, node, 'etag')
            self.etag = etag_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'fileDate':
            fileDate_ = child_.text
            fileDate_ = self.gds_validate_string(fileDate_, node, 'fileDate')
            self.fileDate = fileDate_
        elif nodeName_ == 'fileName':
            fileName_ = child_.text
            fileName_ = self.gds_validate_string(fileName_, node, 'fileName')
            self.fileName = fileName_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'mimeType':
            mimeType_ = child_.text
            mimeType_ = self.gds_validate_string(mimeType_, node, 'mimeType')
            self.mimeType = mimeType_
        elif nodeName_ == 'length':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'length')
            self.length = ival_
        elif nodeName_ == 'active':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'deprecated':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'deprecated')
            self.deprecated = ival_
        elif nodeName_ == 'private':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'private')
            self.private = ival_
        super(attachment, self).buildChildren(child_, node, nodeName_, True)
# end class attachment


class backtrace(trackedEntity):
    """An extracted backtrace."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, uri=None, taskid=None, password=None, filename=None, bt=None, status=None):
        super(backtrace, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.uri = uri
        self.taskid = taskid
        self.password = password
        self.filename = filename
        self.bt = bt
        self.status = status
    def factory(*args_, **kwargs_):
        if backtrace.subclass:
            return backtrace.subclass(*args_, **kwargs_)
        else:
            return backtrace(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_taskid(self): return self.taskid
    def set_taskid(self, taskid): self.taskid = taskid
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_filename(self): return self.filename
    def set_filename(self, filename): self.filename = filename
    def get_bt(self): return self.bt
    def set_bt(self, bt): self.bt = bt
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def export(self, outfile, level, namespace_='tns:', name_='backtrace', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='backtrace')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='backtrace'):
        super(backtrace, self).exportAttributes(outfile, level, already_processed, namespace_, name_='backtrace')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='backtrace', fromsubclass_=False):
        super(backtrace, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('<%suri>%s</%suri>\n' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_))
        if self.taskid is not None:
            showIndent(outfile, level)
            outfile.write('<%staskid>%s</%staskid>\n' % (namespace_, self.gds_format_integer(self.taskid, input_name='taskid'), namespace_))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('<%spassword>%s</%spassword>\n' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_))
        if self.filename is not None:
            showIndent(outfile, level)
            outfile.write('<%sfilename>%s</%sfilename>\n' % (namespace_, self.gds_format_string(quote_xml(self.filename).encode(ExternalEncoding), input_name='filename'), namespace_))
        if self.bt is not None:
            showIndent(outfile, level)
            outfile.write('<%sbt>%s</%sbt>\n' % (namespace_, self.gds_format_string(quote_xml(self.bt).encode(ExternalEncoding), input_name='bt'), namespace_))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('<%sstatus>%s</%sstatus>\n' % (namespace_, self.gds_format_string(quote_xml(self.status).encode(ExternalEncoding), input_name='status'), namespace_))
    def hasContent_(self):
        if (
            self.uri is not None or
            self.taskid is not None or
            self.password is not None or
            self.filename is not None or
            self.bt is not None or
            self.status is not None or
            super(backtrace, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='backtrace'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(backtrace, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(backtrace, self).exportLiteralChildren(outfile, level, name_)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.taskid is not None:
            showIndent(outfile, level)
            outfile.write('taskid=%d,\n' % self.taskid)
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.filename is not None:
            showIndent(outfile, level)
            outfile.write('filename=%s,\n' % quote_python(self.filename).encode(ExternalEncoding))
        if self.bt is not None:
            showIndent(outfile, level)
            outfile.write('bt=%s,\n' % quote_python(self.bt).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=%s,\n' % quote_python(self.status).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(backtrace, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'taskid':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'taskid')
            self.taskid = ival_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'filename':
            filename_ = child_.text
            filename_ = self.gds_validate_string(filename_, node, 'filename')
            self.filename = filename_
        elif nodeName_ == 'bt':
            bt_ = child_.text
            bt_ = self.gds_validate_string(bt_, node, 'bt')
            self.bt = bt_
        elif nodeName_ == 'status':
            status_ = child_.text
            status_ = self.gds_validate_string(status_, node, 'status')
            self.status = status_
        super(backtrace, self).buildChildren(child_, node, nodeName_, True)
# end class backtrace


class recommendations(strataEntity):
    """A list of suggestions."""
    subclass = None
    superclass = strataEntity
    def __init__(self, recommendation=None):
        super(recommendations, self).__init__()
        if recommendation is None:
            self.recommendation = []
        else:
            self.recommendation = recommendation
    def factory(*args_, **kwargs_):
        if recommendations.subclass:
            return recommendations.subclass(*args_, **kwargs_)
        else:
            return recommendations(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_recommendation(self): return self.recommendation
    def set_recommendation(self, recommendation): self.recommendation = recommendation
    def add_recommendation(self, value): self.recommendation.append(value)
    def insert_recommendation(self, index, value): self.recommendation[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='recommendations', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='recommendations')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='recommendations'):
        super(recommendations, self).exportAttributes(outfile, level, already_processed, namespace_, name_='recommendations')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='recommendations', fromsubclass_=False):
        super(recommendations, self).exportChildren(outfile, level, namespace_, name_, True)
        for recommendation_ in self.recommendation:
            recommendation_.export(outfile, level, namespace_, name_='recommendation')
    def hasContent_(self):
        if (
            self.recommendation or
            super(recommendations, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='recommendations'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(recommendations, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(recommendations, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('recommendation=[\n')
        level += 1
        for recommendation_ in self.recommendation:
            showIndent(outfile, level)
            outfile.write('model_.recommendation(\n')
            recommendation_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(recommendations, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'recommendation':
            obj_ = recommendation.factory()
            obj_.build(child_)
            self.recommendation.append(obj_)
        super(recommendations, self).buildChildren(child_, node, nodeName_, True)
# end class recommendations


class recommendation(trackedEntity):
    """A suggestion referring to a solution and related meta data."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, algorithmScore=None, analysisAlgorithm=None, analysisAlgorithmVersion=None, analysisCategory=None, analysisModule=None, analysisService=None, analysisServiceVersion=None, bucket=None, caseNumber=None, client=None, clientVersion=None, display=None, analysisStatus=None, firstSuggestedDate=None, keywords=None, lastSuggestedDate=None, linked=None, linkedAt=None, linkedBy=None, location=None, luceneScore=None, message=None, note=None, origin=None, pinnedAt=None, pinnedBy=None, relevanceScore=None, resource=None, resourceId=None, resourceType=None, resourceURI=None, resourceViewURI=None, rule=None, ruleVersion=None, scoringAlgorithmVersion=None, solutionId=None, solutionKcsState=None, solutionOwnerSSOName=None, solutionTitle=None, solutionAbstract=None, solutionUrl=None, suggestedCount=None, suggestionRelevanceScore=None, explanation=None, title=None, tracebackUrl=None, solutionCaseCount=None, language=None, detectedLanguage=None, setLanguage=None, ModerationState=None, hasPublishedVersion=None, product=None, indexedDate=None, sbrs=None, tags=None, products=None):
        super(recommendation, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.algorithmScore = algorithmScore
        self.analysisAlgorithm = analysisAlgorithm
        self.analysisAlgorithmVersion = analysisAlgorithmVersion
        self.analysisCategory = analysisCategory
        self.analysisModule = analysisModule
        self.analysisService = analysisService
        self.analysisServiceVersion = analysisServiceVersion
        self.bucket = bucket
        self.caseNumber = caseNumber
        self.client = client
        self.clientVersion = clientVersion
        self.display = display
        self.analysisStatus = analysisStatus
        self.firstSuggestedDate = firstSuggestedDate
        self.keywords = keywords
        self.lastSuggestedDate = lastSuggestedDate
        self.linked = linked
        self.linkedAt = linkedAt
        self.linkedBy = linkedBy
        self.location = location
        self.luceneScore = luceneScore
        self.message = message
        self.note = note
        self.origin = origin
        self.pinnedAt = pinnedAt
        self.pinnedBy = pinnedBy
        self.relevanceScore = relevanceScore
        self.resource = resource
        self.resourceId = resourceId
        self.resourceType = resourceType
        self.resourceURI = resourceURI
        self.resourceViewURI = resourceViewURI
        self.rule = rule
        self.ruleVersion = ruleVersion
        self.scoringAlgorithmVersion = scoringAlgorithmVersion
        self.solutionId = solutionId
        self.solutionKcsState = solutionKcsState
        self.solutionOwnerSSOName = solutionOwnerSSOName
        self.solutionTitle = solutionTitle
        self.solutionAbstract = solutionAbstract
        self.solutionUrl = solutionUrl
        self.suggestedCount = suggestedCount
        self.suggestionRelevanceScore = suggestionRelevanceScore
        self.explanation = explanation
        self.title = title
        self.tracebackUrl = tracebackUrl
        self.solutionCaseCount = solutionCaseCount
        self.language = language
        self.detectedLanguage = detectedLanguage
        self.setLanguage = setLanguage
        self.ModerationState = ModerationState
        self.hasPublishedVersion = hasPublishedVersion
        self.product = product
        self.indexedDate = indexedDate
        self.sbrs = sbrs
        self.tags = tags
        self.products = products
    def factory(*args_, **kwargs_):
        if recommendation.subclass:
            return recommendation.subclass(*args_, **kwargs_)
        else:
            return recommendation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_algorithmScore(self): return self.algorithmScore
    def set_algorithmScore(self, algorithmScore): self.algorithmScore = algorithmScore
    def get_analysisAlgorithm(self): return self.analysisAlgorithm
    def set_analysisAlgorithm(self, analysisAlgorithm): self.analysisAlgorithm = analysisAlgorithm
    def get_analysisAlgorithmVersion(self): return self.analysisAlgorithmVersion
    def set_analysisAlgorithmVersion(self, analysisAlgorithmVersion): self.analysisAlgorithmVersion = analysisAlgorithmVersion
    def get_analysisCategory(self): return self.analysisCategory
    def set_analysisCategory(self, analysisCategory): self.analysisCategory = analysisCategory
    def get_analysisModule(self): return self.analysisModule
    def set_analysisModule(self, analysisModule): self.analysisModule = analysisModule
    def get_analysisService(self): return self.analysisService
    def set_analysisService(self, analysisService): self.analysisService = analysisService
    def get_analysisServiceVersion(self): return self.analysisServiceVersion
    def set_analysisServiceVersion(self, analysisServiceVersion): self.analysisServiceVersion = analysisServiceVersion
    def get_bucket(self): return self.bucket
    def set_bucket(self, bucket): self.bucket = bucket
    def get_caseNumber(self): return self.caseNumber
    def set_caseNumber(self, caseNumber): self.caseNumber = caseNumber
    def get_client(self): return self.client
    def set_client(self, client): self.client = client
    def get_clientVersion(self): return self.clientVersion
    def set_clientVersion(self, clientVersion): self.clientVersion = clientVersion
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_analysisStatus(self): return self.analysisStatus
    def set_analysisStatus(self, analysisStatus): self.analysisStatus = analysisStatus
    def get_firstSuggestedDate(self): return self.firstSuggestedDate
    def set_firstSuggestedDate(self, firstSuggestedDate): self.firstSuggestedDate = firstSuggestedDate
    def get_keywords(self): return self.keywords
    def set_keywords(self, keywords): self.keywords = keywords
    def get_lastSuggestedDate(self): return self.lastSuggestedDate
    def set_lastSuggestedDate(self, lastSuggestedDate): self.lastSuggestedDate = lastSuggestedDate
    def get_linked(self): return self.linked
    def set_linked(self, linked): self.linked = linked
    def get_linkedAt(self): return self.linkedAt
    def set_linkedAt(self, linkedAt): self.linkedAt = linkedAt
    def get_linkedBy(self): return self.linkedBy
    def set_linkedBy(self, linkedBy): self.linkedBy = linkedBy
    def get_location(self): return self.location
    def set_location(self, location): self.location = location
    def get_luceneScore(self): return self.luceneScore
    def set_luceneScore(self, luceneScore): self.luceneScore = luceneScore
    def get_message(self): return self.message
    def set_message(self, message): self.message = message
    def get_note(self): return self.note
    def set_note(self, note): self.note = note
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_pinnedAt(self): return self.pinnedAt
    def set_pinnedAt(self, pinnedAt): self.pinnedAt = pinnedAt
    def get_pinnedBy(self): return self.pinnedBy
    def set_pinnedBy(self, pinnedBy): self.pinnedBy = pinnedBy
    def get_relevanceScore(self): return self.relevanceScore
    def set_relevanceScore(self, relevanceScore): self.relevanceScore = relevanceScore
    def get_resource(self): return self.resource
    def set_resource(self, resource): self.resource = resource
    def get_resourceId(self): return self.resourceId
    def set_resourceId(self, resourceId): self.resourceId = resourceId
    def get_resourceType(self): return self.resourceType
    def set_resourceType(self, resourceType): self.resourceType = resourceType
    def get_resourceURI(self): return self.resourceURI
    def set_resourceURI(self, resourceURI): self.resourceURI = resourceURI
    def get_resourceViewURI(self): return self.resourceViewURI
    def set_resourceViewURI(self, resourceViewURI): self.resourceViewURI = resourceViewURI
    def get_rule(self): return self.rule
    def set_rule(self, rule): self.rule = rule
    def get_ruleVersion(self): return self.ruleVersion
    def set_ruleVersion(self, ruleVersion): self.ruleVersion = ruleVersion
    def get_scoringAlgorithmVersion(self): return self.scoringAlgorithmVersion
    def set_scoringAlgorithmVersion(self, scoringAlgorithmVersion): self.scoringAlgorithmVersion = scoringAlgorithmVersion
    def get_solutionId(self): return self.solutionId
    def set_solutionId(self, solutionId): self.solutionId = solutionId
    def get_solutionKcsState(self): return self.solutionKcsState
    def set_solutionKcsState(self, solutionKcsState): self.solutionKcsState = solutionKcsState
    def get_solutionOwnerSSOName(self): return self.solutionOwnerSSOName
    def set_solutionOwnerSSOName(self, solutionOwnerSSOName): self.solutionOwnerSSOName = solutionOwnerSSOName
    def get_solutionTitle(self): return self.solutionTitle
    def set_solutionTitle(self, solutionTitle): self.solutionTitle = solutionTitle
    def get_solutionAbstract(self): return self.solutionAbstract
    def set_solutionAbstract(self, solutionAbstract): self.solutionAbstract = solutionAbstract
    def get_solutionUrl(self): return self.solutionUrl
    def set_solutionUrl(self, solutionUrl): self.solutionUrl = solutionUrl
    def get_suggestedCount(self): return self.suggestedCount
    def set_suggestedCount(self, suggestedCount): self.suggestedCount = suggestedCount
    def get_suggestionRelevanceScore(self): return self.suggestionRelevanceScore
    def set_suggestionRelevanceScore(self, suggestionRelevanceScore): self.suggestionRelevanceScore = suggestionRelevanceScore
    def get_explanation(self): return self.explanation
    def set_explanation(self, explanation): self.explanation = explanation
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_tracebackUrl(self): return self.tracebackUrl
    def set_tracebackUrl(self, tracebackUrl): self.tracebackUrl = tracebackUrl
    def get_solutionCaseCount(self): return self.solutionCaseCount
    def set_solutionCaseCount(self, solutionCaseCount): self.solutionCaseCount = solutionCaseCount
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_detectedLanguage(self): return self.detectedLanguage
    def set_detectedLanguage(self, detectedLanguage): self.detectedLanguage = detectedLanguage
    def get_setLanguage(self): return self.setLanguage
    def set_setLanguage(self, setLanguage): self.setLanguage = setLanguage
    def get_ModerationState(self): return self.ModerationState
    def set_ModerationState(self, ModerationState): self.ModerationState = ModerationState
    def get_hasPublishedVersion(self): return self.hasPublishedVersion
    def set_hasPublishedVersion(self, hasPublishedVersion): self.hasPublishedVersion = hasPublishedVersion
    def get_product(self): return self.product
    def set_product(self, product): self.product = product
    def get_indexedDate(self): return self.indexedDate
    def set_indexedDate(self, indexedDate): self.indexedDate = indexedDate
    def get_sbrs(self): return self.sbrs
    def set_sbrs(self, sbrs): self.sbrs = sbrs
    def get_tags(self): return self.tags
    def set_tags(self, tags): self.tags = tags
    def get_products(self): return self.products
    def set_products(self, products): self.products = products
    def export(self, outfile, level, namespace_='tns:', name_='recommendation', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='recommendation')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='recommendation'):
        super(recommendation, self).exportAttributes(outfile, level, already_processed, namespace_, name_='recommendation')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='recommendation', fromsubclass_=False):
        super(recommendation, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.algorithmScore is not None:
            showIndent(outfile, level)
            outfile.write('<%salgorithmScore>%s</%salgorithmScore>\n' % (namespace_, self.gds_format_double(self.algorithmScore, input_name='algorithmScore'), namespace_))
        if self.analysisAlgorithm is not None:
            showIndent(outfile, level)
            outfile.write('<%sanalysisAlgorithm>%s</%sanalysisAlgorithm>\n' % (namespace_, self.gds_format_string(quote_xml(self.analysisAlgorithm).encode(ExternalEncoding), input_name='analysisAlgorithm'), namespace_))
        if self.analysisAlgorithmVersion is not None:
            showIndent(outfile, level)
            outfile.write('<%sanalysisAlgorithmVersion>%s</%sanalysisAlgorithmVersion>\n' % (namespace_, self.gds_format_string(quote_xml(self.analysisAlgorithmVersion).encode(ExternalEncoding), input_name='analysisAlgorithmVersion'), namespace_))
        if self.analysisCategory is not None:
            showIndent(outfile, level)
            outfile.write('<%sanalysisCategory>%s</%sanalysisCategory>\n' % (namespace_, self.gds_format_string(quote_xml(self.analysisCategory).encode(ExternalEncoding), input_name='analysisCategory'), namespace_))
        if self.analysisModule is not None:
            showIndent(outfile, level)
            outfile.write('<%sanalysisModule>%s</%sanalysisModule>\n' % (namespace_, self.gds_format_string(quote_xml(self.analysisModule).encode(ExternalEncoding), input_name='analysisModule'), namespace_))
        if self.analysisService is not None:
            showIndent(outfile, level)
            outfile.write('<%sanalysisService>%s</%sanalysisService>\n' % (namespace_, self.gds_format_string(quote_xml(self.analysisService).encode(ExternalEncoding), input_name='analysisService'), namespace_))
        if self.analysisServiceVersion is not None:
            showIndent(outfile, level)
            outfile.write('<%sanalysisServiceVersion>%s</%sanalysisServiceVersion>\n' % (namespace_, self.gds_format_string(quote_xml(self.analysisServiceVersion).encode(ExternalEncoding), input_name='analysisServiceVersion'), namespace_))
        if self.bucket is not None:
            showIndent(outfile, level)
            outfile.write('<%sbucket>%s</%sbucket>\n' % (namespace_, self.gds_format_string(quote_xml(self.bucket).encode(ExternalEncoding), input_name='bucket'), namespace_))
        if self.caseNumber is not None:
            showIndent(outfile, level)
            outfile.write('<%scaseNumber>%s</%scaseNumber>\n' % (namespace_, self.gds_format_string(quote_xml(self.caseNumber).encode(ExternalEncoding), input_name='caseNumber'), namespace_))
        if self.client is not None:
            showIndent(outfile, level)
            outfile.write('<%sclient>%s</%sclient>\n' % (namespace_, self.gds_format_string(quote_xml(self.client).encode(ExternalEncoding), input_name='client'), namespace_))
        if self.clientVersion is not None:
            showIndent(outfile, level)
            outfile.write('<%sclientVersion>%s</%sclientVersion>\n' % (namespace_, self.gds_format_string(quote_xml(self.clientVersion).encode(ExternalEncoding), input_name='clientVersion'), namespace_))
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('<%sdisplay>%s</%sdisplay>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.display)), input_name='display'), namespace_))
        if self.analysisStatus is not None:
            showIndent(outfile, level)
            outfile.write('<%sanalysisStatus>%s</%sanalysisStatus>\n' % (namespace_, self.gds_format_string(quote_xml(self.analysisStatus).encode(ExternalEncoding), input_name='analysisStatus'), namespace_))
        if self.firstSuggestedDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sfirstSuggestedDate>%s</%sfirstSuggestedDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.firstSuggestedDate).encode(ExternalEncoding), input_name='firstSuggestedDate'), namespace_))
        if self.keywords is not None:
            showIndent(outfile, level)
            outfile.write('<%skeywords>%s</%skeywords>\n' % (namespace_, self.gds_format_string(quote_xml(self.keywords).encode(ExternalEncoding), input_name='keywords'), namespace_))
        if self.lastSuggestedDate is not None:
            showIndent(outfile, level)
            outfile.write('<%slastSuggestedDate>%s</%slastSuggestedDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.lastSuggestedDate).encode(ExternalEncoding), input_name='lastSuggestedDate'), namespace_))
        if self.linked is not None:
            showIndent(outfile, level)
            outfile.write('<%slinked>%s</%slinked>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.linked)), input_name='linked'), namespace_))
        if self.linkedAt is not None:
            showIndent(outfile, level)
            outfile.write('<%slinkedAt>%s</%slinkedAt>\n' % (namespace_, self.gds_format_string(quote_xml(self.linkedAt).encode(ExternalEncoding), input_name='linkedAt'), namespace_))
        if self.linkedBy is not None:
            showIndent(outfile, level)
            outfile.write('<%slinkedBy>%s</%slinkedBy>\n' % (namespace_, self.gds_format_string(quote_xml(self.linkedBy).encode(ExternalEncoding), input_name='linkedBy'), namespace_))
        if self.location is not None:
            showIndent(outfile, level)
            outfile.write('<%slocation>%s</%slocation>\n' % (namespace_, self.gds_format_string(quote_xml(self.location).encode(ExternalEncoding), input_name='location'), namespace_))
        if self.luceneScore is not None:
            showIndent(outfile, level)
            outfile.write('<%sluceneScore>%s</%sluceneScore>\n' % (namespace_, self.gds_format_double(self.luceneScore, input_name='luceneScore'), namespace_))
        if self.message is not None:
            showIndent(outfile, level)
            outfile.write('<%smessage>%s</%smessage>\n' % (namespace_, self.gds_format_string(quote_xml(self.message).encode(ExternalEncoding), input_name='message'), namespace_))
        if self.note is not None:
            showIndent(outfile, level)
            outfile.write('<%snote>%s</%snote>\n' % (namespace_, self.gds_format_string(quote_xml(self.note).encode(ExternalEncoding), input_name='note'), namespace_))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('<%sorigin>%s</%sorigin>\n' % (namespace_, self.gds_format_string(quote_xml(self.origin).encode(ExternalEncoding), input_name='origin'), namespace_))
        if self.pinnedAt is not None:
            showIndent(outfile, level)
            outfile.write('<%spinnedAt>%s</%spinnedAt>\n' % (namespace_, self.gds_format_string(quote_xml(self.pinnedAt).encode(ExternalEncoding), input_name='pinnedAt'), namespace_))
        if self.pinnedBy is not None:
            showIndent(outfile, level)
            outfile.write('<%spinnedBy>%s</%spinnedBy>\n' % (namespace_, self.gds_format_string(quote_xml(self.pinnedBy).encode(ExternalEncoding), input_name='pinnedBy'), namespace_))
        if self.relevanceScore is not None:
            showIndent(outfile, level)
            outfile.write('<%srelevanceScore>%s</%srelevanceScore>\n' % (namespace_, self.gds_format_integer(self.relevanceScore, input_name='relevanceScore'), namespace_))
        if self.resource is not None:
            showIndent(outfile, level)
            outfile.write('<%sresource>%s</%sresource>\n' % (namespace_, self.gds_format_string(quote_xml(self.resource).encode(ExternalEncoding), input_name='resource'), namespace_))
        if self.resourceId is not None:
            showIndent(outfile, level)
            outfile.write('<%sresourceId>%s</%sresourceId>\n' % (namespace_, self.gds_format_string(quote_xml(self.resourceId).encode(ExternalEncoding), input_name='resourceId'), namespace_))
        if self.resourceType is not None:
            showIndent(outfile, level)
            outfile.write('<%sresourceType>%s</%sresourceType>\n' % (namespace_, self.gds_format_string(quote_xml(self.resourceType).encode(ExternalEncoding), input_name='resourceType'), namespace_))
        if self.resourceURI is not None:
            showIndent(outfile, level)
            outfile.write('<%sresourceURI>%s</%sresourceURI>\n' % (namespace_, self.gds_format_string(quote_xml(self.resourceURI).encode(ExternalEncoding), input_name='resourceURI'), namespace_))
        if self.resourceViewURI is not None:
            showIndent(outfile, level)
            outfile.write('<%sresourceViewURI>%s</%sresourceViewURI>\n' % (namespace_, self.gds_format_string(quote_xml(self.resourceViewURI).encode(ExternalEncoding), input_name='resourceViewURI'), namespace_))
        if self.rule is not None:
            showIndent(outfile, level)
            outfile.write('<%srule>%s</%srule>\n' % (namespace_, self.gds_format_string(quote_xml(self.rule).encode(ExternalEncoding), input_name='rule'), namespace_))
        if self.ruleVersion is not None:
            showIndent(outfile, level)
            outfile.write('<%sruleVersion>%s</%sruleVersion>\n' % (namespace_, self.gds_format_string(quote_xml(self.ruleVersion).encode(ExternalEncoding), input_name='ruleVersion'), namespace_))
        if self.scoringAlgorithmVersion is not None:
            showIndent(outfile, level)
            outfile.write('<%sscoringAlgorithmVersion>%s</%sscoringAlgorithmVersion>\n' % (namespace_, self.gds_format_double(self.scoringAlgorithmVersion, input_name='scoringAlgorithmVersion'), namespace_))
        if self.solutionId is not None:
            showIndent(outfile, level)
            outfile.write('<%ssolutionId>%s</%ssolutionId>\n' % (namespace_, self.gds_format_string(quote_xml(self.solutionId).encode(ExternalEncoding), input_name='solutionId'), namespace_))
        if self.solutionKcsState is not None:
            showIndent(outfile, level)
            outfile.write('<%ssolutionKcsState>%s</%ssolutionKcsState>\n' % (namespace_, self.gds_format_string(quote_xml(self.solutionKcsState).encode(ExternalEncoding), input_name='solutionKcsState'), namespace_))
        if self.solutionOwnerSSOName is not None:
            showIndent(outfile, level)
            outfile.write('<%ssolutionOwnerSSOName>%s</%ssolutionOwnerSSOName>\n' % (namespace_, self.gds_format_string(quote_xml(self.solutionOwnerSSOName).encode(ExternalEncoding), input_name='solutionOwnerSSOName'), namespace_))
        if self.solutionTitle is not None:
            showIndent(outfile, level)
            outfile.write('<%ssolutionTitle>%s</%ssolutionTitle>\n' % (namespace_, self.gds_format_string(quote_xml(self.solutionTitle).encode(ExternalEncoding), input_name='solutionTitle'), namespace_))
        if self.solutionAbstract is not None:
            showIndent(outfile, level)
            outfile.write('<%ssolutionAbstract>%s</%ssolutionAbstract>\n' % (namespace_, self.gds_format_string(quote_xml(self.solutionAbstract).encode(ExternalEncoding), input_name='solutionAbstract'), namespace_))
        if self.solutionUrl is not None:
            showIndent(outfile, level)
            outfile.write('<%ssolutionUrl>%s</%ssolutionUrl>\n' % (namespace_, self.gds_format_string(quote_xml(self.solutionUrl).encode(ExternalEncoding), input_name='solutionUrl'), namespace_))
        if self.suggestedCount is not None:
            showIndent(outfile, level)
            outfile.write('<%ssuggestedCount>%s</%ssuggestedCount>\n' % (namespace_, self.gds_format_double(self.suggestedCount, input_name='suggestedCount'), namespace_))
        if self.suggestionRelevanceScore is not None:
            showIndent(outfile, level)
            outfile.write('<%ssuggestionRelevanceScore>%s</%ssuggestionRelevanceScore>\n' % (namespace_, self.gds_format_double(self.suggestionRelevanceScore, input_name='suggestionRelevanceScore'), namespace_))
        if self.explanation is not None:
            showIndent(outfile, level)
            outfile.write('<%sexplanation>%s</%sexplanation>\n' % (namespace_, self.gds_format_string(quote_xml(self.explanation).encode(ExternalEncoding), input_name='explanation'), namespace_))
        if self.title is not None:
            showIndent(outfile, level)
            outfile.write('<%stitle>%s</%stitle>\n' % (namespace_, self.gds_format_string(quote_xml(self.title).encode(ExternalEncoding), input_name='title'), namespace_))
        if self.tracebackUrl is not None:
            showIndent(outfile, level)
            outfile.write('<%stracebackUrl>%s</%stracebackUrl>\n' % (namespace_, self.gds_format_string(quote_xml(self.tracebackUrl).encode(ExternalEncoding), input_name='tracebackUrl'), namespace_))
        if self.solutionCaseCount is not None:
            showIndent(outfile, level)
            outfile.write('<%ssolutionCaseCount>%s</%ssolutionCaseCount>\n' % (namespace_, self.gds_format_integer(self.solutionCaseCount, input_name='solutionCaseCount'), namespace_))
        if self.language is not None:
            showIndent(outfile, level)
            outfile.write('<%slanguage>%s</%slanguage>\n' % (namespace_, self.gds_format_string(quote_xml(self.language).encode(ExternalEncoding), input_name='language'), namespace_))
        if self.detectedLanguage is not None:
            showIndent(outfile, level)
            outfile.write('<%sdetectedLanguage>%s</%sdetectedLanguage>\n' % (namespace_, self.gds_format_string(quote_xml(self.detectedLanguage).encode(ExternalEncoding), input_name='detectedLanguage'), namespace_))
        if self.setLanguage is not None:
            showIndent(outfile, level)
            outfile.write('<%ssetLanguage>%s</%ssetLanguage>\n' % (namespace_, self.gds_format_string(quote_xml(self.setLanguage).encode(ExternalEncoding), input_name='setLanguage'), namespace_))
        if self.ModerationState is not None:
            showIndent(outfile, level)
            outfile.write('<%sModerationState>%s</%sModerationState>\n' % (namespace_, self.gds_format_string(quote_xml(self.ModerationState).encode(ExternalEncoding), input_name='ModerationState'), namespace_))
        if self.hasPublishedVersion is not None:
            showIndent(outfile, level)
            outfile.write('<%shasPublishedVersion>%s</%shasPublishedVersion>\n' % (namespace_, self.gds_format_string(quote_xml(self.hasPublishedVersion).encode(ExternalEncoding), input_name='hasPublishedVersion'), namespace_))
        if self.product is not None:
            showIndent(outfile, level)
            outfile.write('<%sproduct>%s</%sproduct>\n' % (namespace_, self.gds_format_string(quote_xml(self.product).encode(ExternalEncoding), input_name='product'), namespace_))
        if self.indexedDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sindexedDate>%s</%sindexedDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.indexedDate).encode(ExternalEncoding), input_name='indexedDate'), namespace_))
        if self.sbrs is not None:
            self.sbrs.export(outfile, level, namespace_, name_='sbrs',)
        if self.tags is not None:
            self.tags.export(outfile, level, namespace_, name_='tags',)
        if self.products is not None:
            self.products.export(outfile, level, namespace_, name_='products',)
    def hasContent_(self):
        if (
            self.algorithmScore is not None or
            self.analysisAlgorithm is not None or
            self.analysisAlgorithmVersion is not None or
            self.analysisCategory is not None or
            self.analysisModule is not None or
            self.analysisService is not None or
            self.analysisServiceVersion is not None or
            self.bucket is not None or
            self.caseNumber is not None or
            self.client is not None or
            self.clientVersion is not None or
            self.display is not None or
            self.analysisStatus is not None or
            self.firstSuggestedDate is not None or
            self.keywords is not None or
            self.lastSuggestedDate is not None or
            self.linked is not None or
            self.linkedAt is not None or
            self.linkedBy is not None or
            self.location is not None or
            self.luceneScore is not None or
            self.message is not None or
            self.note is not None or
            self.origin is not None or
            self.pinnedAt is not None or
            self.pinnedBy is not None or
            self.relevanceScore is not None or
            self.resource is not None or
            self.resourceId is not None or
            self.resourceType is not None or
            self.resourceURI is not None or
            self.resourceViewURI is not None or
            self.rule is not None or
            self.ruleVersion is not None or
            self.scoringAlgorithmVersion is not None or
            self.solutionId is not None or
            self.solutionKcsState is not None or
            self.solutionOwnerSSOName is not None or
            self.solutionTitle is not None or
            self.solutionAbstract is not None or
            self.solutionUrl is not None or
            self.suggestedCount is not None or
            self.suggestionRelevanceScore is not None or
            self.explanation is not None or
            self.title is not None or
            self.tracebackUrl is not None or
            self.solutionCaseCount is not None or
            self.language is not None or
            self.detectedLanguage is not None or
            self.setLanguage is not None or
            self.ModerationState is not None or
            self.hasPublishedVersion is not None or
            self.product is not None or
            self.indexedDate is not None or
            self.sbrs is not None or
            self.tags is not None or
            self.products is not None or
            super(recommendation, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='recommendation'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(recommendation, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(recommendation, self).exportLiteralChildren(outfile, level, name_)
        if self.algorithmScore is not None:
            showIndent(outfile, level)
            outfile.write('algorithmScore=%e,\n' % self.algorithmScore)
        if self.analysisAlgorithm is not None:
            showIndent(outfile, level)
            outfile.write('analysisAlgorithm=%s,\n' % quote_python(self.analysisAlgorithm).encode(ExternalEncoding))
        if self.analysisAlgorithmVersion is not None:
            showIndent(outfile, level)
            outfile.write('analysisAlgorithmVersion=%s,\n' % quote_python(self.analysisAlgorithmVersion).encode(ExternalEncoding))
        if self.analysisCategory is not None:
            showIndent(outfile, level)
            outfile.write('analysisCategory=%s,\n' % quote_python(self.analysisCategory).encode(ExternalEncoding))
        if self.analysisModule is not None:
            showIndent(outfile, level)
            outfile.write('analysisModule=%s,\n' % quote_python(self.analysisModule).encode(ExternalEncoding))
        if self.analysisService is not None:
            showIndent(outfile, level)
            outfile.write('analysisService=%s,\n' % quote_python(self.analysisService).encode(ExternalEncoding))
        if self.analysisServiceVersion is not None:
            showIndent(outfile, level)
            outfile.write('analysisServiceVersion=%s,\n' % quote_python(self.analysisServiceVersion).encode(ExternalEncoding))
        if self.bucket is not None:
            showIndent(outfile, level)
            outfile.write('bucket=%s,\n' % quote_python(self.bucket).encode(ExternalEncoding))
        if self.caseNumber is not None:
            showIndent(outfile, level)
            outfile.write('caseNumber=%s,\n' % quote_python(self.caseNumber).encode(ExternalEncoding))
        if self.client is not None:
            showIndent(outfile, level)
            outfile.write('client=%s,\n' % quote_python(self.client).encode(ExternalEncoding))
        if self.clientVersion is not None:
            showIndent(outfile, level)
            outfile.write('clientVersion=%s,\n' % quote_python(self.clientVersion).encode(ExternalEncoding))
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=%s,\n' % self.display)
        if self.analysisStatus is not None:
            showIndent(outfile, level)
            outfile.write('analysisStatus=%s,\n' % quote_python(self.analysisStatus).encode(ExternalEncoding))
        if self.firstSuggestedDate is not None:
            showIndent(outfile, level)
            outfile.write('firstSuggestedDate=%s,\n' % quote_python(self.firstSuggestedDate).encode(ExternalEncoding))
        if self.keywords is not None:
            showIndent(outfile, level)
            outfile.write('keywords=%s,\n' % quote_python(self.keywords).encode(ExternalEncoding))
        if self.lastSuggestedDate is not None:
            showIndent(outfile, level)
            outfile.write('lastSuggestedDate=%s,\n' % quote_python(self.lastSuggestedDate).encode(ExternalEncoding))
        if self.linked is not None:
            showIndent(outfile, level)
            outfile.write('linked=%s,\n' % self.linked)
        if self.linkedAt is not None:
            showIndent(outfile, level)
            outfile.write('linkedAt=%s,\n' % quote_python(self.linkedAt).encode(ExternalEncoding))
        if self.linkedBy is not None:
            showIndent(outfile, level)
            outfile.write('linkedBy=%s,\n' % quote_python(self.linkedBy).encode(ExternalEncoding))
        if self.location is not None:
            showIndent(outfile, level)
            outfile.write('location=%s,\n' % quote_python(self.location).encode(ExternalEncoding))
        if self.luceneScore is not None:
            showIndent(outfile, level)
            outfile.write('luceneScore=%e,\n' % self.luceneScore)
        if self.message is not None:
            showIndent(outfile, level)
            outfile.write('message=%s,\n' % quote_python(self.message).encode(ExternalEncoding))
        if self.note is not None:
            showIndent(outfile, level)
            outfile.write('note=%s,\n' % quote_python(self.note).encode(ExternalEncoding))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('origin=%s,\n' % quote_python(self.origin).encode(ExternalEncoding))
        if self.pinnedAt is not None:
            showIndent(outfile, level)
            outfile.write('pinnedAt=%s,\n' % quote_python(self.pinnedAt).encode(ExternalEncoding))
        if self.pinnedBy is not None:
            showIndent(outfile, level)
            outfile.write('pinnedBy=%s,\n' % quote_python(self.pinnedBy).encode(ExternalEncoding))
        if self.relevanceScore is not None:
            showIndent(outfile, level)
            outfile.write('relevanceScore=%d,\n' % self.relevanceScore)
        if self.resource is not None:
            showIndent(outfile, level)
            outfile.write('resource=%s,\n' % quote_python(self.resource).encode(ExternalEncoding))
        if self.resourceId is not None:
            showIndent(outfile, level)
            outfile.write('resourceId=%s,\n' % quote_python(self.resourceId).encode(ExternalEncoding))
        if self.resourceType is not None:
            showIndent(outfile, level)
            outfile.write('resourceType=%s,\n' % quote_python(self.resourceType).encode(ExternalEncoding))
        if self.resourceURI is not None:
            showIndent(outfile, level)
            outfile.write('resourceURI=%s,\n' % quote_python(self.resourceURI).encode(ExternalEncoding))
        if self.resourceViewURI is not None:
            showIndent(outfile, level)
            outfile.write('resourceViewURI=%s,\n' % quote_python(self.resourceViewURI).encode(ExternalEncoding))
        if self.rule is not None:
            showIndent(outfile, level)
            outfile.write('rule=%s,\n' % quote_python(self.rule).encode(ExternalEncoding))
        if self.ruleVersion is not None:
            showIndent(outfile, level)
            outfile.write('ruleVersion=%s,\n' % quote_python(self.ruleVersion).encode(ExternalEncoding))
        if self.scoringAlgorithmVersion is not None:
            showIndent(outfile, level)
            outfile.write('scoringAlgorithmVersion=%e,\n' % self.scoringAlgorithmVersion)
        if self.solutionId is not None:
            showIndent(outfile, level)
            outfile.write('solutionId=%s,\n' % quote_python(self.solutionId).encode(ExternalEncoding))
        if self.solutionKcsState is not None:
            showIndent(outfile, level)
            outfile.write('solutionKcsState=%s,\n' % quote_python(self.solutionKcsState).encode(ExternalEncoding))
        if self.solutionOwnerSSOName is not None:
            showIndent(outfile, level)
            outfile.write('solutionOwnerSSOName=%s,\n' % quote_python(self.solutionOwnerSSOName).encode(ExternalEncoding))
        if self.solutionTitle is not None:
            showIndent(outfile, level)
            outfile.write('solutionTitle=%s,\n' % quote_python(self.solutionTitle).encode(ExternalEncoding))
        if self.solutionAbstract is not None:
            showIndent(outfile, level)
            outfile.write('solutionAbstract=%s,\n' % quote_python(self.solutionAbstract).encode(ExternalEncoding))
        if self.solutionUrl is not None:
            showIndent(outfile, level)
            outfile.write('solutionUrl=%s,\n' % quote_python(self.solutionUrl).encode(ExternalEncoding))
        if self.suggestedCount is not None:
            showIndent(outfile, level)
            outfile.write('suggestedCount=%e,\n' % self.suggestedCount)
        if self.suggestionRelevanceScore is not None:
            showIndent(outfile, level)
            outfile.write('suggestionRelevanceScore=%e,\n' % self.suggestionRelevanceScore)
        if self.explanation is not None:
            showIndent(outfile, level)
            outfile.write('explanation=%s,\n' % quote_python(self.explanation).encode(ExternalEncoding))
        if self.title is not None:
            showIndent(outfile, level)
            outfile.write('title=%s,\n' % quote_python(self.title).encode(ExternalEncoding))
        if self.tracebackUrl is not None:
            showIndent(outfile, level)
            outfile.write('tracebackUrl=%s,\n' % quote_python(self.tracebackUrl).encode(ExternalEncoding))
        if self.solutionCaseCount is not None:
            showIndent(outfile, level)
            outfile.write('solutionCaseCount=%d,\n' % self.solutionCaseCount)
        if self.language is not None:
            showIndent(outfile, level)
            outfile.write('language=%s,\n' % quote_python(self.language).encode(ExternalEncoding))
        if self.detectedLanguage is not None:
            showIndent(outfile, level)
            outfile.write('detectedLanguage=%s,\n' % quote_python(self.detectedLanguage).encode(ExternalEncoding))
        if self.setLanguage is not None:
            showIndent(outfile, level)
            outfile.write('setLanguage=%s,\n' % quote_python(self.setLanguage).encode(ExternalEncoding))
        if self.ModerationState is not None:
            showIndent(outfile, level)
            outfile.write('ModerationState=%s,\n' % quote_python(self.ModerationState).encode(ExternalEncoding))
        if self.hasPublishedVersion is not None:
            showIndent(outfile, level)
            outfile.write('hasPublishedVersion=%s,\n' % quote_python(self.hasPublishedVersion).encode(ExternalEncoding))
        if self.product is not None:
            showIndent(outfile, level)
            outfile.write('product=%s,\n' % quote_python(self.product).encode(ExternalEncoding))
        if self.indexedDate is not None:
            showIndent(outfile, level)
            outfile.write('indexedDate=%s,\n' % quote_python(self.indexedDate).encode(ExternalEncoding))
        if self.sbrs is not None:
            showIndent(outfile, level)
            outfile.write('sbrs=model_.sbrsType1(\n')
            self.sbrs.exportLiteral(outfile, level, name_='sbrs')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.tags is not None:
            showIndent(outfile, level)
            outfile.write('tags=model_.tagsType2(\n')
            self.tags.exportLiteral(outfile, level, name_='tags')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.products is not None:
            showIndent(outfile, level)
            outfile.write('products=model_.productsType1(\n')
            self.products.exportLiteral(outfile, level, name_='products')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(recommendation, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'algorithmScore':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'algorithmScore')
            self.algorithmScore = fval_
        elif nodeName_ == 'analysisAlgorithm':
            analysisAlgorithm_ = child_.text
            analysisAlgorithm_ = self.gds_validate_string(analysisAlgorithm_, node, 'analysisAlgorithm')
            self.analysisAlgorithm = analysisAlgorithm_
        elif nodeName_ == 'analysisAlgorithmVersion':
            analysisAlgorithmVersion_ = child_.text
            analysisAlgorithmVersion_ = self.gds_validate_string(analysisAlgorithmVersion_, node, 'analysisAlgorithmVersion')
            self.analysisAlgorithmVersion = analysisAlgorithmVersion_
        elif nodeName_ == 'analysisCategory':
            analysisCategory_ = child_.text
            analysisCategory_ = self.gds_validate_string(analysisCategory_, node, 'analysisCategory')
            self.analysisCategory = analysisCategory_
        elif nodeName_ == 'analysisModule':
            analysisModule_ = child_.text
            analysisModule_ = self.gds_validate_string(analysisModule_, node, 'analysisModule')
            self.analysisModule = analysisModule_
        elif nodeName_ == 'analysisService':
            analysisService_ = child_.text
            analysisService_ = self.gds_validate_string(analysisService_, node, 'analysisService')
            self.analysisService = analysisService_
        elif nodeName_ == 'analysisServiceVersion':
            analysisServiceVersion_ = child_.text
            analysisServiceVersion_ = self.gds_validate_string(analysisServiceVersion_, node, 'analysisServiceVersion')
            self.analysisServiceVersion = analysisServiceVersion_
        elif nodeName_ == 'bucket':
            bucket_ = child_.text
            bucket_ = self.gds_validate_string(bucket_, node, 'bucket')
            self.bucket = bucket_
        elif nodeName_ == 'caseNumber':
            caseNumber_ = child_.text
            caseNumber_ = self.gds_validate_string(caseNumber_, node, 'caseNumber')
            self.caseNumber = caseNumber_
        elif nodeName_ == 'client':
            client_ = child_.text
            client_ = self.gds_validate_string(client_, node, 'client')
            self.client = client_
        elif nodeName_ == 'clientVersion':
            clientVersion_ = child_.text
            clientVersion_ = self.gds_validate_string(clientVersion_, node, 'clientVersion')
            self.clientVersion = clientVersion_
        elif nodeName_ == 'display':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'display')
            self.display = ival_
        elif nodeName_ == 'analysisStatus':
            analysisStatus_ = child_.text
            analysisStatus_ = self.gds_validate_string(analysisStatus_, node, 'analysisStatus')
            self.analysisStatus = analysisStatus_
        elif nodeName_ == 'firstSuggestedDate':
            firstSuggestedDate_ = child_.text
            firstSuggestedDate_ = self.gds_validate_string(firstSuggestedDate_, node, 'firstSuggestedDate')
            self.firstSuggestedDate = firstSuggestedDate_
        elif nodeName_ == 'keywords':
            keywords_ = child_.text
            keywords_ = self.gds_validate_string(keywords_, node, 'keywords')
            self.keywords = keywords_
        elif nodeName_ == 'lastSuggestedDate':
            lastSuggestedDate_ = child_.text
            lastSuggestedDate_ = self.gds_validate_string(lastSuggestedDate_, node, 'lastSuggestedDate')
            self.lastSuggestedDate = lastSuggestedDate_
        elif nodeName_ == 'linked':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'linked')
            self.linked = ival_
        elif nodeName_ == 'linkedAt':
            linkedAt_ = child_.text
            linkedAt_ = self.gds_validate_string(linkedAt_, node, 'linkedAt')
            self.linkedAt = linkedAt_
        elif nodeName_ == 'linkedBy':
            linkedBy_ = child_.text
            linkedBy_ = self.gds_validate_string(linkedBy_, node, 'linkedBy')
            self.linkedBy = linkedBy_
        elif nodeName_ == 'location':
            location_ = child_.text
            location_ = self.gds_validate_string(location_, node, 'location')
            self.location = location_
        elif nodeName_ == 'luceneScore':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'luceneScore')
            self.luceneScore = fval_
        elif nodeName_ == 'message':
            message_ = child_.text
            message_ = self.gds_validate_string(message_, node, 'message')
            self.message = message_
        elif nodeName_ == 'note':
            note_ = child_.text
            note_ = self.gds_validate_string(note_, node, 'note')
            self.note = note_
        elif nodeName_ == 'origin':
            origin_ = child_.text
            origin_ = self.gds_validate_string(origin_, node, 'origin')
            self.origin = origin_
        elif nodeName_ == 'pinnedAt':
            pinnedAt_ = child_.text
            pinnedAt_ = self.gds_validate_string(pinnedAt_, node, 'pinnedAt')
            self.pinnedAt = pinnedAt_
        elif nodeName_ == 'pinnedBy':
            pinnedBy_ = child_.text
            pinnedBy_ = self.gds_validate_string(pinnedBy_, node, 'pinnedBy')
            self.pinnedBy = pinnedBy_
        elif nodeName_ == 'relevanceScore':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'relevanceScore')
            self.relevanceScore = ival_
        elif nodeName_ == 'resource':
            resource_ = child_.text
            resource_ = self.gds_validate_string(resource_, node, 'resource')
            self.resource = resource_
        elif nodeName_ == 'resourceId':
            resourceId_ = child_.text
            resourceId_ = self.gds_validate_string(resourceId_, node, 'resourceId')
            self.resourceId = resourceId_
        elif nodeName_ == 'resourceType':
            resourceType_ = child_.text
            resourceType_ = self.gds_validate_string(resourceType_, node, 'resourceType')
            self.resourceType = resourceType_
        elif nodeName_ == 'resourceURI':
            resourceURI_ = child_.text
            resourceURI_ = self.gds_validate_string(resourceURI_, node, 'resourceURI')
            self.resourceURI = resourceURI_
        elif nodeName_ == 'resourceViewURI':
            resourceViewURI_ = child_.text
            resourceViewURI_ = self.gds_validate_string(resourceViewURI_, node, 'resourceViewURI')
            self.resourceViewURI = resourceViewURI_
        elif nodeName_ == 'rule':
            rule_ = child_.text
            rule_ = self.gds_validate_string(rule_, node, 'rule')
            self.rule = rule_
        elif nodeName_ == 'ruleVersion':
            ruleVersion_ = child_.text
            ruleVersion_ = self.gds_validate_string(ruleVersion_, node, 'ruleVersion')
            self.ruleVersion = ruleVersion_
        elif nodeName_ == 'scoringAlgorithmVersion':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'scoringAlgorithmVersion')
            self.scoringAlgorithmVersion = fval_
        elif nodeName_ == 'solutionId':
            solutionId_ = child_.text
            solutionId_ = self.gds_validate_string(solutionId_, node, 'solutionId')
            self.solutionId = solutionId_
        elif nodeName_ == 'solutionKcsState':
            solutionKcsState_ = child_.text
            solutionKcsState_ = self.gds_validate_string(solutionKcsState_, node, 'solutionKcsState')
            self.solutionKcsState = solutionKcsState_
        elif nodeName_ == 'solutionOwnerSSOName':
            solutionOwnerSSOName_ = child_.text
            solutionOwnerSSOName_ = self.gds_validate_string(solutionOwnerSSOName_, node, 'solutionOwnerSSOName')
            self.solutionOwnerSSOName = solutionOwnerSSOName_
        elif nodeName_ == 'solutionTitle':
            solutionTitle_ = child_.text
            solutionTitle_ = self.gds_validate_string(solutionTitle_, node, 'solutionTitle')
            self.solutionTitle = solutionTitle_
        elif nodeName_ == 'solutionAbstract':
            solutionAbstract_ = child_.text
            solutionAbstract_ = self.gds_validate_string(solutionAbstract_, node, 'solutionAbstract')
            self.solutionAbstract = solutionAbstract_
        elif nodeName_ == 'solutionUrl':
            solutionUrl_ = child_.text
            solutionUrl_ = self.gds_validate_string(solutionUrl_, node, 'solutionUrl')
            self.solutionUrl = solutionUrl_
        elif nodeName_ == 'suggestedCount':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'suggestedCount')
            self.suggestedCount = fval_
        elif nodeName_ == 'suggestionRelevanceScore':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'suggestionRelevanceScore')
            self.suggestionRelevanceScore = fval_
        elif nodeName_ == 'explanation':
            explanation_ = child_.text
            explanation_ = self.gds_validate_string(explanation_, node, 'explanation')
            self.explanation = explanation_
        elif nodeName_ == 'title':
            title_ = child_.text
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
        elif nodeName_ == 'tracebackUrl':
            tracebackUrl_ = child_.text
            tracebackUrl_ = self.gds_validate_string(tracebackUrl_, node, 'tracebackUrl')
            self.tracebackUrl = tracebackUrl_
        elif nodeName_ == 'solutionCaseCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'solutionCaseCount')
            self.solutionCaseCount = ival_
        elif nodeName_ == 'language':
            language_ = child_.text
            language_ = self.gds_validate_string(language_, node, 'language')
            self.language = language_
        elif nodeName_ == 'detectedLanguage':
            detectedLanguage_ = child_.text
            detectedLanguage_ = self.gds_validate_string(detectedLanguage_, node, 'detectedLanguage')
            self.detectedLanguage = detectedLanguage_
        elif nodeName_ == 'setLanguage':
            setLanguage_ = child_.text
            setLanguage_ = self.gds_validate_string(setLanguage_, node, 'setLanguage')
            self.setLanguage = setLanguage_
        elif nodeName_ == 'ModerationState':
            ModerationState_ = child_.text
            ModerationState_ = self.gds_validate_string(ModerationState_, node, 'ModerationState')
            self.ModerationState = ModerationState_
        elif nodeName_ == 'hasPublishedVersion':
            hasPublishedVersion_ = child_.text
            hasPublishedVersion_ = self.gds_validate_string(hasPublishedVersion_, node, 'hasPublishedVersion')
            self.hasPublishedVersion = hasPublishedVersion_
        elif nodeName_ == 'product':
            product_ = child_.text
            product_ = self.gds_validate_string(product_, node, 'product')
            self.product = product_
        elif nodeName_ == 'indexedDate':
            indexedDate_ = child_.text
            indexedDate_ = self.gds_validate_string(indexedDate_, node, 'indexedDate')
            self.indexedDate = indexedDate_
        elif nodeName_ == 'sbrs':
            obj_ = sbrsType1.factory()
            obj_.build(child_)
            self.set_sbrs(obj_)
        elif nodeName_ == 'tags':
            obj_ = tagsType2.factory()
            obj_.build(child_)
            self.set_tags(obj_)
        elif nodeName_ == 'products':
            obj_ = productsType1.factory()
            obj_.build(child_)
            self.set_products(obj_)
        super(recommendation, self).buildChildren(child_, node, nodeName_, True)
# end class recommendation


class groups(strataEntity):
    """A list of groups."""
    subclass = None
    superclass = strataEntity
    def __init__(self, group=None):
        super(groups, self).__init__()
        if group is None:
            self.group = []
        else:
            self.group = group
    def factory(*args_, **kwargs_):
        if groups.subclass:
            return groups.subclass(*args_, **kwargs_)
        else:
            return groups(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_group(self): return self.group
    def set_group(self, group): self.group = group
    def add_group(self, value): self.group.append(value)
    def insert_group(self, index, value): self.group[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='groups', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='groups')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='groups'):
        super(groups, self).exportAttributes(outfile, level, already_processed, namespace_, name_='groups')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='groups', fromsubclass_=False):
        super(groups, self).exportChildren(outfile, level, namespace_, name_, True)
        for group_ in self.group:
            group_.export(outfile, level, namespace_, name_='group')
    def hasContent_(self):
        if (
            self.group or
            super(groups, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='groups'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(groups, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(groups, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('group=[\n')
        level += 1
        for group_ in self.group:
            showIndent(outfile, level)
            outfile.write('model_.group(\n')
            group_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(groups, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'group':
            obj_ = group.factory()
            obj_.build(child_)
            self.group.append(obj_)
        super(groups, self).buildChildren(child_, node, nodeName_, True)
# end class groups


class group(strataEntity):
    """A group that may contain zero or more cases."""
    subclass = None
    superclass = strataEntity
    def __init__(self, number=None, name=None, uri=None, isPrivate=None):
        super(group, self).__init__()
        self.number = number
        self.name = name
        self.uri = uri
        self.isPrivate = isPrivate
    def factory(*args_, **kwargs_):
        if group.subclass:
            return group.subclass(*args_, **kwargs_)
        else:
            return group(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_number(self): return self.number
    def set_number(self, number): self.number = number
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_isPrivate(self): return self.isPrivate
    def set_isPrivate(self, isPrivate): self.isPrivate = isPrivate
    def export(self, outfile, level, namespace_='tns:', name_='group', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='group')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='group'):
        super(group, self).exportAttributes(outfile, level, already_processed, namespace_, name_='group')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='group', fromsubclass_=False):
        super(group, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.number is not None:
            showIndent(outfile, level)
            outfile.write('<%snumber>%s</%snumber>\n' % (namespace_, self.gds_format_string(quote_xml(self.number).encode(ExternalEncoding), input_name='number'), namespace_))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('<%suri>%s</%suri>\n' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_))
        if self.isPrivate is not None:
            showIndent(outfile, level)
            outfile.write('<%sisPrivate>%s</%sisPrivate>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.isPrivate)), input_name='isPrivate'), namespace_))
    def hasContent_(self):
        if (
            self.number is not None or
            self.name is not None or
            self.uri is not None or
            self.isPrivate is not None or
            super(group, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='group'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(group, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(group, self).exportLiteralChildren(outfile, level, name_)
        if self.number is not None:
            showIndent(outfile, level)
            outfile.write('number=%s,\n' % quote_python(self.number).encode(ExternalEncoding))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.isPrivate is not None:
            showIndent(outfile, level)
            outfile.write('isPrivate=%s,\n' % self.isPrivate)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(group, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'number':
            number_ = child_.text
            number_ = self.gds_validate_string(number_, node, 'number')
            self.number = number_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'isPrivate':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'isPrivate')
            self.isPrivate = ival_
        super(group, self).buildChildren(child_, node, nodeName_, True)
# end class group


class account(strataEntity):
    """An account that may organizes users. It is represented in a
    simplified manner on the Strata API."""
    subclass = None
    superclass = strataEntity
    def __init__(self, number=None, hasGroupACLs=None, isSecure=None):
        super(account, self).__init__()
        self.number = _cast(None, number)
        self.hasGroupACLs = hasGroupACLs
        self.isSecure = isSecure
    def factory(*args_, **kwargs_):
        if account.subclass:
            return account.subclass(*args_, **kwargs_)
        else:
            return account(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_hasGroupACLs(self): return self.hasGroupACLs
    def set_hasGroupACLs(self, hasGroupACLs): self.hasGroupACLs = hasGroupACLs
    def get_isSecure(self): return self.isSecure
    def set_isSecure(self, isSecure): self.isSecure = isSecure
    def get_number(self): return self.number
    def set_number(self, number): self.number = number
    def export(self, outfile, level, namespace_='tns:', name_='account', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='account')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='account'):
        super(account, self).exportAttributes(outfile, level, already_processed, namespace_, name_='account')
        if self.number is not None and 'number' not in already_processed:
            already_processed.append('number')
            outfile.write(' number=%s' % (self.gds_format_string(quote_attrib(self.number).encode(ExternalEncoding), input_name='number'),))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='account', fromsubclass_=False):
        super(account, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.hasGroupACLs is not None:
            showIndent(outfile, level)
            outfile.write('<%shasGroupACLs>%s</%shasGroupACLs>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.hasGroupACLs)), input_name='hasGroupACLs'), namespace_))
        if self.isSecure is not None:
            showIndent(outfile, level)
            outfile.write('<%sisSecure>%s</%sisSecure>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.isSecure)), input_name='isSecure'), namespace_))
    def hasContent_(self):
        if (
            self.hasGroupACLs is not None or
            self.isSecure is not None or
            super(account, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='account'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.number is not None and 'number' not in already_processed:
            already_processed.append('number')
            showIndent(outfile, level)
            outfile.write('number = "%s",\n' % (self.number,))
        super(account, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(account, self).exportLiteralChildren(outfile, level, name_)
        if self.hasGroupACLs is not None:
            showIndent(outfile, level)
            outfile.write('hasGroupACLs=%s,\n' % self.hasGroupACLs)
        if self.isSecure is not None:
            showIndent(outfile, level)
            outfile.write('isSecure=%s,\n' % self.isSecure)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('number', node)
        if value is not None and 'number' not in already_processed:
            already_processed.append('number')
            self.number = value
        super(account, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'hasGroupACLs':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'hasGroupACLs')
            self.hasGroupACLs = ival_
        elif nodeName_ == 'isSecure':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'isSecure')
            self.isSecure = ival_
        super(account, self).buildChildren(child_, node, nodeName_, True)
# end class account


class users(strataEntity):
    """A list of users."""
    subclass = None
    superclass = strataEntity
    def __init__(self, user=None):
        super(users, self).__init__()
        if user is None:
            self.user = []
        else:
            self.user = user
    def factory(*args_, **kwargs_):
        if users.subclass:
            return users.subclass(*args_, **kwargs_)
        else:
            return users(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def add_user(self, value): self.user.append(value)
    def insert_user(self, index, value): self.user[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='users', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='users')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='users'):
        super(users, self).exportAttributes(outfile, level, already_processed, namespace_, name_='users')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='users', fromsubclass_=False):
        super(users, self).exportChildren(outfile, level, namespace_, name_, True)
        for user_ in self.user:
            user_.export(outfile, level, namespace_, name_='user')
    def hasContent_(self):
        if (
            self.user or
            super(users, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='users'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(users, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(users, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('user=[\n')
        level += 1
        for user_ in self.user:
            showIndent(outfile, level)
            outfile.write('model_.user(\n')
            user_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(users, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'user':
            obj_ = user.factory()
            obj_.build(child_)
            self.user.append(obj_)
        super(users, self).buildChildren(child_, node, nodeName_, True)
# end class users


class user(strataEntity):
    """The user entity reflects a Red Hat Login user."""
    subclass = None
    superclass = strataEntity
    def __init__(self, ssoUsername=None, uri=None, id=None, firstName=None, lastName=None, email=None, accountId=None, preferredLanguage=None, title=None, timezone=None, orgAdmin=None, tamContact=None, access=None, hasChat=None, sessionId=None):
        super(user, self).__init__()
        self.ssoUsername = _cast(None, ssoUsername)
        self.uri = _cast(None, uri)
        self.id = id
        self.firstName = firstName
        self.lastName = lastName
        self.email = email
        self.accountId = accountId
        self.preferredLanguage = preferredLanguage
        self.title = title
        self.timezone = timezone
        self.orgAdmin = orgAdmin
        self.tamContact = tamContact
        self.access = access
        self.hasChat = hasChat
        self.sessionId = sessionId
    def factory(*args_, **kwargs_):
        if user.subclass:
            return user.subclass(*args_, **kwargs_)
        else:
            return user(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_firstName(self): return self.firstName
    def set_firstName(self, firstName): self.firstName = firstName
    def get_lastName(self): return self.lastName
    def set_lastName(self, lastName): self.lastName = lastName
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_accountId(self): return self.accountId
    def set_accountId(self, accountId): self.accountId = accountId
    def get_preferredLanguage(self): return self.preferredLanguage
    def set_preferredLanguage(self, preferredLanguage): self.preferredLanguage = preferredLanguage
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_timezone(self): return self.timezone
    def set_timezone(self, timezone): self.timezone = timezone
    def get_orgAdmin(self): return self.orgAdmin
    def set_orgAdmin(self, orgAdmin): self.orgAdmin = orgAdmin
    def get_tamContact(self): return self.tamContact
    def set_tamContact(self, tamContact): self.tamContact = tamContact
    def get_access(self): return self.access
    def set_access(self, access): self.access = access
    def get_hasChat(self): return self.hasChat
    def set_hasChat(self, hasChat): self.hasChat = hasChat
    def get_sessionId(self): return self.sessionId
    def set_sessionId(self, sessionId): self.sessionId = sessionId
    def get_ssoUsername(self): return self.ssoUsername
    def set_ssoUsername(self, ssoUsername): self.ssoUsername = ssoUsername
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def export(self, outfile, level, namespace_='tns:', name_='user', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='user')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='user'):
        super(user, self).exportAttributes(outfile, level, already_processed, namespace_, name_='user')
        if self.ssoUsername is not None and 'ssoUsername' not in already_processed:
            already_processed.append('ssoUsername')
            outfile.write(' ssoUsername=%s' % (self.gds_format_string(quote_attrib(self.ssoUsername).encode(ExternalEncoding), input_name='ssoUsername'),))
        if self.uri is not None and 'uri' not in already_processed:
            already_processed.append('uri')
            outfile.write(' uri=%s' % (self.gds_format_string(quote_attrib(self.uri).encode(ExternalEncoding), input_name='uri'),))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='user', fromsubclass_=False):
        super(user, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('<%sid>%s</%sid>\n' % (namespace_, self.gds_format_string(quote_xml(self.id).encode(ExternalEncoding), input_name='id'), namespace_))
        if self.firstName is not None:
            showIndent(outfile, level)
            outfile.write('<%sfirstName>%s</%sfirstName>\n' % (namespace_, self.gds_format_string(quote_xml(self.firstName).encode(ExternalEncoding), input_name='firstName'), namespace_))
        if self.lastName is not None:
            showIndent(outfile, level)
            outfile.write('<%slastName>%s</%slastName>\n' % (namespace_, self.gds_format_string(quote_xml(self.lastName).encode(ExternalEncoding), input_name='lastName'), namespace_))
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('<%semail>%s</%semail>\n' % (namespace_, self.gds_format_string(quote_xml(self.email).encode(ExternalEncoding), input_name='email'), namespace_))
        if self.accountId is not None:
            showIndent(outfile, level)
            outfile.write('<%saccountId>%s</%saccountId>\n' % (namespace_, self.gds_format_string(quote_xml(self.accountId).encode(ExternalEncoding), input_name='accountId'), namespace_))
        if self.preferredLanguage is not None:
            showIndent(outfile, level)
            outfile.write('<%spreferredLanguage>%s</%spreferredLanguage>\n' % (namespace_, self.gds_format_string(quote_xml(self.preferredLanguage).encode(ExternalEncoding), input_name='preferredLanguage'), namespace_))
        if self.title is not None:
            showIndent(outfile, level)
            outfile.write('<%stitle>%s</%stitle>\n' % (namespace_, self.gds_format_string(quote_xml(self.title).encode(ExternalEncoding), input_name='title'), namespace_))
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('<%stimezone>%s</%stimezone>\n' % (namespace_, self.gds_format_string(quote_xml(self.timezone).encode(ExternalEncoding), input_name='timezone'), namespace_))
        if self.orgAdmin is not None:
            showIndent(outfile, level)
            outfile.write('<%sorgAdmin>%s</%sorgAdmin>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.orgAdmin)), input_name='orgAdmin'), namespace_))
        if self.tamContact is not None:
            showIndent(outfile, level)
            outfile.write('<%stamContact>%s</%stamContact>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.tamContact)), input_name='tamContact'), namespace_))
        if self.access is not None:
            showIndent(outfile, level)
            outfile.write('<%saccess>%s</%saccess>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.access)), input_name='access'), namespace_))
        if self.hasChat is not None:
            showIndent(outfile, level)
            outfile.write('<%shasChat>%s</%shasChat>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.hasChat)), input_name='hasChat'), namespace_))
        if self.sessionId is not None:
            showIndent(outfile, level)
            outfile.write('<%ssessionId>%s</%ssessionId>\n' % (namespace_, self.gds_format_string(quote_xml(self.sessionId).encode(ExternalEncoding), input_name='sessionId'), namespace_))
    def hasContent_(self):
        if (
            self.id is not None or
            self.firstName is not None or
            self.lastName is not None or
            self.email is not None or
            self.accountId is not None or
            self.preferredLanguage is not None or
            self.title is not None or
            self.timezone is not None or
            self.orgAdmin is not None or
            self.tamContact is not None or
            self.access is not None or
            self.hasChat is not None or
            self.sessionId is not None or
            super(user, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='user'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.ssoUsername is not None and 'ssoUsername' not in already_processed:
            already_processed.append('ssoUsername')
            showIndent(outfile, level)
            outfile.write('ssoUsername = "%s",\n' % (self.ssoUsername,))
        if self.uri is not None and 'uri' not in already_processed:
            already_processed.append('uri')
            showIndent(outfile, level)
            outfile.write('uri = "%s",\n' % (self.uri,))
        super(user, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(user, self).exportLiteralChildren(outfile, level, name_)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id=%s,\n' % quote_python(self.id).encode(ExternalEncoding))
        if self.firstName is not None:
            showIndent(outfile, level)
            outfile.write('firstName=%s,\n' % quote_python(self.firstName).encode(ExternalEncoding))
        if self.lastName is not None:
            showIndent(outfile, level)
            outfile.write('lastName=%s,\n' % quote_python(self.lastName).encode(ExternalEncoding))
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('email=%s,\n' % quote_python(self.email).encode(ExternalEncoding))
        if self.accountId is not None:
            showIndent(outfile, level)
            outfile.write('accountId=%s,\n' % quote_python(self.accountId).encode(ExternalEncoding))
        if self.preferredLanguage is not None:
            showIndent(outfile, level)
            outfile.write('preferredLanguage=%s,\n' % quote_python(self.preferredLanguage).encode(ExternalEncoding))
        if self.title is not None:
            showIndent(outfile, level)
            outfile.write('title=%s,\n' % quote_python(self.title).encode(ExternalEncoding))
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('timezone=%s,\n' % quote_python(self.timezone).encode(ExternalEncoding))
        if self.orgAdmin is not None:
            showIndent(outfile, level)
            outfile.write('orgAdmin=%s,\n' % self.orgAdmin)
        if self.tamContact is not None:
            showIndent(outfile, level)
            outfile.write('tamContact=%s,\n' % self.tamContact)
        if self.access is not None:
            showIndent(outfile, level)
            outfile.write('access=%s,\n' % self.access)
        if self.hasChat is not None:
            showIndent(outfile, level)
            outfile.write('hasChat=%s,\n' % self.hasChat)
        if self.sessionId is not None:
            showIndent(outfile, level)
            outfile.write('sessionId=%s,\n' % quote_python(self.sessionId).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ssoUsername', node)
        if value is not None and 'ssoUsername' not in already_processed:
            already_processed.append('ssoUsername')
            self.ssoUsername = value
        value = find_attr_value_('uri', node)
        if value is not None and 'uri' not in already_processed:
            already_processed.append('uri')
            self.uri = value
        super(user, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'id':
            id_ = child_.text
            id_ = self.gds_validate_string(id_, node, 'id')
            self.id = id_
        elif nodeName_ == 'firstName':
            firstName_ = child_.text
            firstName_ = self.gds_validate_string(firstName_, node, 'firstName')
            self.firstName = firstName_
        elif nodeName_ == 'lastName':
            lastName_ = child_.text
            lastName_ = self.gds_validate_string(lastName_, node, 'lastName')
            self.lastName = lastName_
        elif nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
        elif nodeName_ == 'accountId':
            accountId_ = child_.text
            accountId_ = self.gds_validate_string(accountId_, node, 'accountId')
            self.accountId = accountId_
        elif nodeName_ == 'preferredLanguage':
            preferredLanguage_ = child_.text
            preferredLanguage_ = self.gds_validate_string(preferredLanguage_, node, 'preferredLanguage')
            self.preferredLanguage = preferredLanguage_
        elif nodeName_ == 'title':
            title_ = child_.text
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
        elif nodeName_ == 'timezone':
            timezone_ = child_.text
            timezone_ = self.gds_validate_string(timezone_, node, 'timezone')
            self.timezone = timezone_
        elif nodeName_ == 'orgAdmin':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'orgAdmin')
            self.orgAdmin = ival_
        elif nodeName_ == 'tamContact':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'tamContact')
            self.tamContact = ival_
        elif nodeName_ == 'access':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'access')
            self.access = ival_
        elif nodeName_ == 'hasChat':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'hasChat')
            self.hasChat = ival_
        elif nodeName_ == 'sessionId':
            sessionId_ = child_.text
            sessionId_ = self.gds_validate_string(sessionId_, node, 'sessionId')
            self.sessionId = sessionId_
        super(user, self).buildChildren(child_, node, nodeName_, True)
# end class user


class cases(strataEntity):
    """A list of support cases. This type serves as both a top-level
    construct in the case that a query returns a list of support
    cases as well as an embedded construct as part of a larger item.
    This element is not required to contain any child case elements.
    A list of support cases. This type serves as both a top-level
    construct in the case that a query returns a list of support
    cases as well as an embedded construct as part of a larger item.
    This element is not required to contain any child case elements."""
    subclass = None
    superclass = strataEntity
    def __init__(self, case=None, previous=None, next=None):
        super(cases, self).__init__()
        if case is None:
            self.case = []
        else:
            self.case = case
        self.previous = previous
        self.next = next
    def factory(*args_, **kwargs_):
        if cases.subclass:
            return cases.subclass(*args_, **kwargs_)
        else:
            return cases(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_case(self): return self.case
    def set_case(self, case): self.case = case
    def add_case(self, value): self.case.append(value)
    def insert_case(self, index, value): self.case[index] = value
    def get_previous(self): return self.previous
    def set_previous(self, previous): self.previous = previous
    def get_next(self): return self.next
    def set_next(self, next): self.next = next
    def export(self, outfile, level, namespace_='tns:', name_='cases', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cases')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='cases'):
        super(cases, self).exportAttributes(outfile, level, already_processed, namespace_, name_='cases')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='cases', fromsubclass_=False):
        super(cases, self).exportChildren(outfile, level, namespace_, name_, True)
        for case_ in self.case:
            case_.export(outfile, level, namespace_, name_='case')
        if self.previous is not None:
            showIndent(outfile, level)
            outfile.write('<%sprevious>%s</%sprevious>\n' % (namespace_, self.gds_format_string(quote_xml(self.previous).encode(ExternalEncoding), input_name='previous'), namespace_))
        if self.next is not None:
            showIndent(outfile, level)
            outfile.write('<%snext>%s</%snext>\n' % (namespace_, self.gds_format_string(quote_xml(self.next).encode(ExternalEncoding), input_name='next'), namespace_))
    def hasContent_(self):
        if (
            self.case or
            self.previous is not None or
            self.next is not None or
            super(cases, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='cases'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(cases, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(cases, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('case=[\n')
        level += 1
        for case_ in self.case:
            showIndent(outfile, level)
            outfile.write('model_.case(\n')
            case_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.previous is not None:
            showIndent(outfile, level)
            outfile.write('previous=%s,\n' % quote_python(self.previous).encode(ExternalEncoding))
        if self.next is not None:
            showIndent(outfile, level)
            outfile.write('next=%s,\n' % quote_python(self.next).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(cases, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'case':
            obj_ = case.factory()
            obj_.build(child_)
            self.case.append(obj_)
        elif nodeName_ == 'previous':
            previous_ = child_.text
            previous_ = self.gds_validate_string(previous_, node, 'previous')
            self.previous = previous_
        elif nodeName_ == 'next':
            next_ = child_.text
            next_ = self.gds_validate_string(next_, node, 'next')
            self.next = next_
        super(cases, self).buildChildren(child_, node, nodeName_, True)
# end class cases


class case(trackedEntity):
    """A support case."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, alternateId=None, caseNumber=None, closed=None, id=None, uri=None, summary=None, description=None, status=None, product=None, component=None, version=None, type_=None, accountNumber=None, view_uri=None, reference=None, notes=None, escalated=None, contactName=None, contactSsoUsername=None, origin=None, owner=None, internalPriority=None, internalStatus=None, suppliedName=None, suppliedPhone=None, suppliedEmail=None, severity=None, folderNumber=None, comments=None, notified_users=None, entitlement=None, recommendations=None, fts=None):
        super(case, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.alternateId = _cast(None, alternateId)
        self.caseNumber = _cast(None, caseNumber)
        self.closed = _cast(bool, closed)
        self.id = id
        self.uri = uri
        self.summary = summary
        self.description = description
        self.status = status
        self.product = product
        self.component = component
        self.version = version
        self.type_ = type_
        self.accountNumber = accountNumber
        self.view_uri = view_uri
        self.reference = reference
        self.notes = notes
        self.escalated = escalated
        self.contactName = contactName
        self.contactSsoUsername = contactSsoUsername
        self.origin = origin
        self.owner = owner
        self.internalPriority = internalPriority
        self.internalStatus = internalStatus
        self.suppliedName = suppliedName
        self.suppliedPhone = suppliedPhone
        self.suppliedEmail = suppliedEmail
        self.severity = severity
        self.folderNumber = folderNumber
        self.comments = comments
        self.notified_users = notified_users
        self.entitlement = entitlement
        self.recommendations = recommendations
        self.fts = fts
    def factory(*args_, **kwargs_):
        if case.subclass:
            return case.subclass(*args_, **kwargs_)
        else:
            return case(*args_, **kwargs_)
    factory = staticmethod(factory)
    @set_docstring('''
    Get the case ID number

    :returns: Case number for the case object
    :rtype: string''')
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    @set_docstring('''
    Get the case REST API URI

    :returns: API URL for case object
    :rtype: string''')
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    @set_docstring('''
    Get the case's one-line summary/title

    :returns: Title/Summary of the case object
    :rtype: string''')
    def get_summary(self): return self.summary
    def set_summary(self, summary): self.summary = summary
    @set_docstring('''
    Get the case description/initial opening text

    :returns: Case description from the support case
    :rtype: string''')
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    @set_docstring('''
    Get the case status

    Possible values are:
      * Waiting on Red Hat
      * Waiting on Customer
      * Pending Closure
      * Closed

    :returns: Current status of the support case
    :rtype: string''')
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    @set_docstring('''
    Get the product name that the case object relates to

    :returns: Name of the associated product
    :rtype: string''')
    def get_product(self): return self.product
    @set_docstring('''
    Set a different product on the case

    .. IMPORTANT::
        If the version (:func:`get_version`) set on the case is not valid
        for the set product, updating the case object without calling
        :func:`set_version` will result in failure.

    :param product: The name of the product to set
    :type product: string
    :returns: Nothing''')
    def set_product(self, product): self.product = product
    def get_component(self): return self.component
    def set_component(self, component): self.component = component
    @set_docstring('''
    Get the version that the case object relates to

    :returns: Version of the product set by :func:`set_product`
    :rtype: string''')
    def get_version(self): return self.version
    @set_docstring('''
    Set a different version number on the case

    :param version: The version number to set
    :type version: string
    :returns: Nothing''')
    def set_version(self, version): self.version = version
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    @set_docstring('''
    Get the account number associated with the case

    :returns: Case number
    :rtype: string''')
    def get_accountNumber(self): return self.accountNumber
    def set_accountNumber(self, accountNumber): self.accountNumber = accountNumber
    @set_docstring('''
    Get the public case URL

    :returns: Red Hat Customer Portal URL for the case
    :rtype: string''')
    def get_view_uri(self): return self.view_uri
    def set_view_uri(self, view_uri): self.view_uri = view_uri
    def get_reference(self): return self.reference
    def set_reference(self, reference): self.reference = reference
    def get_notes(self): return self.notes
    def set_notes(self, notes): self.notes = notes
    def get_escalated(self): return self.escalated
    def set_escalated(self, escalated): self.escalated = escalated
    @set_docstring('''
    Get the customer contact associated with the case

    :returns: Name of the customer contact
    :rtype: string''')
    def get_contactName(self): return self.contactName
    def set_contactName(self, contactName): self.contactName = contactName
    @set_docstring('''
    Get the customer contact's Customer Portal username

    :returns: Red Hat Customer Portal username of the customer contact
    :rtype: string''')
    def get_contactSsoUsername(self): return self.contactSsoUsername
    def set_contactSsoUsername(self, contactSsoUsername): self.contactSsoUsername = contactSsoUsername
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    @set_docstring('''
    Get the Red Hat Support case owner

    :returns: Name of the Red Hat Support Representative assigned to the case
    :rtype: string''')
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_internalPriority(self): return self.internalPriority
    def set_internalPriority(self, internalPriority): self.internalPriority = internalPriority
    def get_internalStatus(self): return self.internalStatus
    def set_internalStatus(self, internalStatus): self.internalStatus = internalStatus
    def get_suppliedName(self): return self.suppliedName
    def set_suppliedName(self, suppliedName): self.suppliedName = suppliedName
    def get_suppliedPhone(self): return self.suppliedPhone
    def set_suppliedPhone(self, suppliedPhone): self.suppliedPhone = suppliedPhone
    def get_suppliedEmail(self): return self.suppliedEmail
    def set_suppliedEmail(self, suppliedEmail): self.suppliedEmail = suppliedEmail
    @set_docstring('''
    Get the case severity

    :returns: Severity level of the case
    :rtype: string''')
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def get_folderNumber(self): return self.folderNumber
    def set_folderNumber(self, folderNumber): self.folderNumber = folderNumber
    @set_docstring('''
    Get the comments associated with the case

    :returns: A list of :mod:`comment` objects
    :rtype: string''')
    def get_comments(self): return self.comments
    def set_comments(self, comments): self.comments = comments
    def get_notified_users(self): return self.notified_users
    def set_notified_users(self, notified_users): self.notified_users = notified_users
    def get_entitlement(self): return self.entitlement
    def set_entitlement(self, entitlement): self.entitlement = entitlement
    @set_docstring('''
    Get recommendations from Red Hat based on the case

    :returns: A list of :mod:`recommendation` objects
    :rtype: string''')
    def get_recommendations(self): return self.recommendations
    def set_recommendations(self, recommendations): self.recommendations = recommendations
    def get_fts(self): return self.fts
    def set_fts(self, fts): self.fts = fts
    def get_alternateId(self): return self.alternateId
    def set_alternateId(self, alternateId): self.alternateId = alternateId
    def get_caseNumber(self): return self.caseNumber
    def set_caseNumber(self, caseNumber): self.caseNumber = caseNumber
    @set_docstring('''
    Get the case number

    :returns: The case number for the related case object
    :rtype: string''')
    def get_closed(self): return self.closed
    def set_closed(self, closed): self.closed = closed
    def export(self, outfile, level, namespace_='tns:', name_='case', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='case')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='case'):
        super(case, self).exportAttributes(outfile, level, already_processed, namespace_, name_='case')
        if self.alternateId is not None and 'alternateId' not in already_processed:
            already_processed.append('alternateId')
            outfile.write(' alternateId=%s' % (self.gds_format_string(quote_attrib(self.alternateId).encode(ExternalEncoding), input_name='alternateId'),))
        if self.caseNumber is not None and 'caseNumber' not in already_processed:
            already_processed.append('caseNumber')
            outfile.write(' caseNumber=%s' % (self.gds_format_string(quote_attrib(self.caseNumber).encode(ExternalEncoding), input_name='caseNumber'),))
        if self.closed is not None and 'closed' not in already_processed:
            already_processed.append('closed')
            outfile.write(' closed="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.closed)), input_name='closed'))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='case', fromsubclass_=False):
        super(case, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('<%sid>%s</%sid>\n' % (namespace_, self.gds_format_string(quote_xml(self.id).encode(ExternalEncoding), input_name='id'), namespace_))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('<%suri>%s</%suri>\n' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_))
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('<%ssummary>%s</%ssummary>\n' % (namespace_, self.gds_format_string(quote_xml(self.summary).encode(ExternalEncoding), input_name='summary'), namespace_))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('<%sdescription>%s</%sdescription>\n' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('<%sstatus>%s</%sstatus>\n' % (namespace_, self.gds_format_string(quote_xml(self.status).encode(ExternalEncoding), input_name='status'), namespace_))
        if self.product is not None:
            showIndent(outfile, level)
            outfile.write('<%sproduct>%s</%sproduct>\n' % (namespace_, self.gds_format_string(quote_xml(self.product).encode(ExternalEncoding), input_name='product'), namespace_))
        if self.component is not None:
            showIndent(outfile, level)
            outfile.write('<%scomponent>%s</%scomponent>\n' % (namespace_, self.gds_format_string(quote_xml(self.component).encode(ExternalEncoding), input_name='component'), namespace_))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('<%sversion>%s</%sversion>\n' % (namespace_, self.gds_format_string(quote_xml(self.version).encode(ExternalEncoding), input_name='version'), namespace_))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        if self.accountNumber is not None:
            showIndent(outfile, level)
            outfile.write('<%saccountNumber>%s</%saccountNumber>\n' % (namespace_, self.gds_format_string(quote_xml(self.accountNumber).encode(ExternalEncoding), input_name='accountNumber'), namespace_))
        if self.view_uri is not None:
            showIndent(outfile, level)
            outfile.write('<%sview_uri>%s</%sview_uri>\n' % (namespace_, self.gds_format_string(quote_xml(self.view_uri).encode(ExternalEncoding), input_name='view_uri'), namespace_))
        if self.reference is not None:
            showIndent(outfile, level)
            outfile.write('<%sreference>%s</%sreference>\n' % (namespace_, self.gds_format_string(quote_xml(self.reference).encode(ExternalEncoding), input_name='reference'), namespace_))
        if self.notes is not None:
            showIndent(outfile, level)
            outfile.write('<%snotes>%s</%snotes>\n' % (namespace_, self.gds_format_string(quote_xml(self.notes).encode(ExternalEncoding), input_name='notes'), namespace_))
        if self.escalated is not None:
            showIndent(outfile, level)
            outfile.write('<%sescalated>%s</%sescalated>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.escalated)), input_name='escalated'), namespace_))
        if self.contactName is not None:
            showIndent(outfile, level)
            outfile.write('<%scontactName>%s</%scontactName>\n' % (namespace_, self.gds_format_string(quote_xml(self.contactName).encode(ExternalEncoding), input_name='contactName'), namespace_))
        if self.contactSsoUsername is not None:
            showIndent(outfile, level)
            outfile.write('<%scontactSsoUsername>%s</%scontactSsoUsername>\n' % (namespace_, self.gds_format_string(quote_xml(self.contactSsoUsername).encode(ExternalEncoding), input_name='contactSsoUsername'), namespace_))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('<%sorigin>%s</%sorigin>\n' % (namespace_, self.gds_format_string(quote_xml(self.origin).encode(ExternalEncoding), input_name='origin'), namespace_))
        if self.owner is not None:
            showIndent(outfile, level)
            outfile.write('<%sowner>%s</%sowner>\n' % (namespace_, self.gds_format_string(quote_xml(self.owner).encode(ExternalEncoding), input_name='owner'), namespace_))
        if self.internalPriority is not None:
            showIndent(outfile, level)
            outfile.write('<%sinternalPriority>%s</%sinternalPriority>\n' % (namespace_, self.gds_format_string(quote_xml(self.internalPriority).encode(ExternalEncoding), input_name='internalPriority'), namespace_))
        if self.internalStatus is not None:
            showIndent(outfile, level)
            outfile.write('<%sinternalStatus>%s</%sinternalStatus>\n' % (namespace_, self.gds_format_string(quote_xml(self.internalStatus).encode(ExternalEncoding), input_name='internalStatus'), namespace_))
        if self.suppliedName is not None:
            showIndent(outfile, level)
            outfile.write('<%ssuppliedName>%s</%ssuppliedName>\n' % (namespace_, self.gds_format_string(quote_xml(self.suppliedName).encode(ExternalEncoding), input_name='suppliedName'), namespace_))
        if self.suppliedPhone is not None:
            showIndent(outfile, level)
            outfile.write('<%ssuppliedPhone>%s</%ssuppliedPhone>\n' % (namespace_, self.gds_format_string(quote_xml(self.suppliedPhone).encode(ExternalEncoding), input_name='suppliedPhone'), namespace_))
        if self.suppliedEmail is not None:
            showIndent(outfile, level)
            outfile.write('<%ssuppliedEmail>%s</%ssuppliedEmail>\n' % (namespace_, self.gds_format_string(quote_xml(self.suppliedEmail).encode(ExternalEncoding), input_name='suppliedEmail'), namespace_))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('<%sseverity>%s</%sseverity>\n' % (namespace_, self.gds_format_string(quote_xml(self.severity).encode(ExternalEncoding), input_name='severity'), namespace_))
        if self.folderNumber is not None:
            showIndent(outfile, level)
            outfile.write('<%sfolderNumber>%s</%sfolderNumber>\n' % (namespace_, self.gds_format_string(quote_xml(self.folderNumber).encode(ExternalEncoding), input_name='folderNumber'), namespace_))
        if self.comments is not None:
            self.comments.export(outfile, level, namespace_, name_='comments')
        if self.notified_users is not None:
            self.notified_users.export(outfile, level, namespace_, name_='notified_users')
        if self.entitlement is not None:
            self.entitlement.export(outfile, level, namespace_, name_='entitlement',)
        if self.recommendations is not None:
            self.recommendations.export(outfile, level, namespace_, name_='recommendations')
        if self.fts is not None:
            showIndent(outfile, level)
            outfile.write('<%sfts>%s</%sfts>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.fts)), input_name='fts'), namespace_))
    def hasContent_(self):
        if (
            self.id is not None or
            self.uri is not None or
            self.summary is not None or
            self.description is not None or
            self.status is not None or
            self.product is not None or
            self.component is not None or
            self.version is not None or
            self.type_ is not None or
            self.accountNumber is not None or
            self.view_uri is not None or
            self.reference is not None or
            self.notes is not None or
            self.escalated is not None or
            self.contactName is not None or
            self.contactSsoUsername is not None or
            self.origin is not None or
            self.owner is not None or
            self.internalPriority is not None or
            self.internalStatus is not None or
            self.suppliedName is not None or
            self.suppliedPhone is not None or
            self.suppliedEmail is not None or
            self.severity is not None or
            self.folderNumber is not None or
            self.comments is not None or
            self.notified_users is not None or
            self.entitlement is not None or
            self.recommendations is not None or
            self.fts is not None or
            super(case, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='case'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.alternateId is not None and 'alternateId' not in already_processed:
            already_processed.append('alternateId')
            showIndent(outfile, level)
            outfile.write('alternateId = "%s",\n' % (self.alternateId,))
        if self.caseNumber is not None and 'caseNumber' not in already_processed:
            already_processed.append('caseNumber')
            showIndent(outfile, level)
            outfile.write('caseNumber = "%s",\n' % (self.caseNumber,))
        if self.closed is not None and 'closed' not in already_processed:
            already_processed.append('closed')
            showIndent(outfile, level)
            outfile.write('closed = %s,\n' % (self.closed,))
        super(case, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(case, self).exportLiteralChildren(outfile, level, name_)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id=%s,\n' % quote_python(self.id).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('summary=%s,\n' % quote_python(self.summary).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=%s,\n' % quote_python(self.status).encode(ExternalEncoding))
        if self.product is not None:
            showIndent(outfile, level)
            outfile.write('product=%s,\n' % quote_python(self.product).encode(ExternalEncoding))
        if self.component is not None:
            showIndent(outfile, level)
            outfile.write('component=%s,\n' % quote_python(self.component).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.accountNumber is not None:
            showIndent(outfile, level)
            outfile.write('accountNumber=%s,\n' % quote_python(self.accountNumber).encode(ExternalEncoding))
        if self.view_uri is not None:
            showIndent(outfile, level)
            outfile.write('view_uri=%s,\n' % quote_python(self.view_uri).encode(ExternalEncoding))
        if self.reference is not None:
            showIndent(outfile, level)
            outfile.write('reference=%s,\n' % quote_python(self.reference).encode(ExternalEncoding))
        if self.notes is not None:
            showIndent(outfile, level)
            outfile.write('notes=%s,\n' % quote_python(self.notes).encode(ExternalEncoding))
        if self.escalated is not None:
            showIndent(outfile, level)
            outfile.write('escalated=%s,\n' % self.escalated)
        if self.contactName is not None:
            showIndent(outfile, level)
            outfile.write('contactName=%s,\n' % quote_python(self.contactName).encode(ExternalEncoding))
        if self.contactSsoUsername is not None:
            showIndent(outfile, level)
            outfile.write('contactSsoUsername=%s,\n' % quote_python(self.contactSsoUsername).encode(ExternalEncoding))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('origin=%s,\n' % quote_python(self.origin).encode(ExternalEncoding))
        if self.owner is not None:
            showIndent(outfile, level)
            outfile.write('owner=%s,\n' % quote_python(self.owner).encode(ExternalEncoding))
        if self.internalPriority is not None:
            showIndent(outfile, level)
            outfile.write('internalPriority=%s,\n' % quote_python(self.internalPriority).encode(ExternalEncoding))
        if self.internalStatus is not None:
            showIndent(outfile, level)
            outfile.write('internalStatus=%s,\n' % quote_python(self.internalStatus).encode(ExternalEncoding))
        if self.suppliedName is not None:
            showIndent(outfile, level)
            outfile.write('suppliedName=%s,\n' % quote_python(self.suppliedName).encode(ExternalEncoding))
        if self.suppliedPhone is not None:
            showIndent(outfile, level)
            outfile.write('suppliedPhone=%s,\n' % quote_python(self.suppliedPhone).encode(ExternalEncoding))
        if self.suppliedEmail is not None:
            showIndent(outfile, level)
            outfile.write('suppliedEmail=%s,\n' % quote_python(self.suppliedEmail).encode(ExternalEncoding))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('severity=%s,\n' % quote_python(self.severity).encode(ExternalEncoding))
        if self.folderNumber is not None:
            showIndent(outfile, level)
            outfile.write('folderNumber=%s,\n' % quote_python(self.folderNumber).encode(ExternalEncoding))
        if self.comments is not None:
            showIndent(outfile, level)
            outfile.write('comments=model_.comments(\n')
            self.comments.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.notified_users is not None:
            showIndent(outfile, level)
            outfile.write('notified_users=model_.notified_users(\n')
            self.notified_users.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.entitlement is not None:
            showIndent(outfile, level)
            outfile.write('entitlement=model_.entitlement(\n')
            self.entitlement.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.recommendations is not None:
            showIndent(outfile, level)
            outfile.write('recommendations=model_.recommendations(\n')
            self.recommendations.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.fts is not None:
            showIndent(outfile, level)
            outfile.write('fts=%s,\n' % self.fts)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('alternateId', node)
        if value is not None and 'alternateId' not in already_processed:
            already_processed.append('alternateId')
            self.alternateId = value
        value = find_attr_value_('caseNumber', node)
        if value is not None and 'caseNumber' not in already_processed:
            already_processed.append('caseNumber')
            self.caseNumber = value
        value = find_attr_value_('closed', node)
        if value is not None and 'closed' not in already_processed:
            already_processed.append('closed')
            if value in ('true', '1'):
                self.closed = True
            elif value in ('false', '0'):
                self.closed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(case, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'id':
            id_ = child_.text
            id_ = self.gds_validate_string(id_, node, 'id')
            self.id = id_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'summary':
            summary_ = child_.text
            summary_ = self.gds_validate_string(summary_, node, 'summary')
            self.summary = summary_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'status':
            status_ = child_.text
            status_ = self.gds_validate_string(status_, node, 'status')
            self.status = status_
        elif nodeName_ == 'product':
            product_ = child_.text
            product_ = self.gds_validate_string(product_, node, 'product')
            self.product = product_
        elif nodeName_ == 'component':
            component_ = child_.text
            component_ = self.gds_validate_string(component_, node, 'component')
            self.component = component_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'accountNumber':
            accountNumber_ = child_.text
            accountNumber_ = self.gds_validate_string(accountNumber_, node, 'accountNumber')
            self.accountNumber = accountNumber_
        elif nodeName_ == 'view_uri':
            view_uri_ = child_.text
            view_uri_ = self.gds_validate_string(view_uri_, node, 'view_uri')
            self.view_uri = view_uri_
        elif nodeName_ == 'reference':
            reference_ = child_.text
            reference_ = self.gds_validate_string(reference_, node, 'reference')
            self.reference = reference_
        elif nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
        elif nodeName_ == 'escalated':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'escalated')
            self.escalated = ival_
        elif nodeName_ == 'contactName':
            contactName_ = child_.text
            contactName_ = self.gds_validate_string(contactName_, node, 'contactName')
            self.contactName = contactName_
        elif nodeName_ == 'contactSsoUsername':
            contactSsoUsername_ = child_.text
            contactSsoUsername_ = self.gds_validate_string(contactSsoUsername_, node, 'contactSsoUsername')
            self.contactSsoUsername = contactSsoUsername_
        elif nodeName_ == 'origin':
            origin_ = child_.text
            origin_ = self.gds_validate_string(origin_, node, 'origin')
            self.origin = origin_
        elif nodeName_ == 'owner':
            owner_ = child_.text
            owner_ = self.gds_validate_string(owner_, node, 'owner')
            self.owner = owner_
        elif nodeName_ == 'internalPriority':
            internalPriority_ = child_.text
            internalPriority_ = self.gds_validate_string(internalPriority_, node, 'internalPriority')
            self.internalPriority = internalPriority_
        elif nodeName_ == 'internalStatus':
            internalStatus_ = child_.text
            internalStatus_ = self.gds_validate_string(internalStatus_, node, 'internalStatus')
            self.internalStatus = internalStatus_
        elif nodeName_ == 'suppliedName':
            suppliedName_ = child_.text
            suppliedName_ = self.gds_validate_string(suppliedName_, node, 'suppliedName')
            self.suppliedName = suppliedName_
        elif nodeName_ == 'suppliedPhone':
            suppliedPhone_ = child_.text
            suppliedPhone_ = self.gds_validate_string(suppliedPhone_, node, 'suppliedPhone')
            self.suppliedPhone = suppliedPhone_
        elif nodeName_ == 'suppliedEmail':
            suppliedEmail_ = child_.text
            suppliedEmail_ = self.gds_validate_string(suppliedEmail_, node, 'suppliedEmail')
            self.suppliedEmail = suppliedEmail_
        elif nodeName_ == 'severity':
            severity_ = child_.text
            severity_ = self.gds_validate_string(severity_, node, 'severity')
            self.severity = severity_
        elif nodeName_ == 'folderNumber':
            folderNumber_ = child_.text
            folderNumber_ = self.gds_validate_string(folderNumber_, node, 'folderNumber')
            self.folderNumber = folderNumber_
        elif nodeName_ == 'comments':
            obj_ = comments.factory()
            obj_.build(child_)
            self.set_comments(obj_)
        elif nodeName_ == 'notified_users':
            obj_ = notified_users.factory()
            obj_.build(child_)
            self.set_notified_users(obj_)
        elif nodeName_ == 'entitlement':
            obj_ = entitlement.factory()
            obj_.build(child_)
            self.set_entitlement(obj_)
        elif nodeName_ == 'recommendations':
            obj_ = recommendations.factory()
            obj_.build(child_)
            self.set_recommendations(obj_)
        elif nodeName_ == 'fts':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'fts')
            self.fts = ival_
        super(case, self).buildChildren(child_, node, nodeName_, True)
# end class case


class supportNeed(trackedEntity):
    """A support need."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, alternateId=None, id=None, uri=None, summary=None, description=None, status=None, product=None, component=None, version=None, type_=None, accountNumber=None, view_uri=None, reference=None, notes=None, escalated=None, contactName=None, contactSsoUsername=None, origin=None, owner=None, internalPriority=None, internalStatus=None, suppliedName=None, suppliedPhone=None, suppliedEmail=None, severity=None, folderNumber=None, comments=None, notified_users=None, entitlement=None, solutions=None):
        super(supportNeed, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.alternateId = _cast(None, alternateId)
        self.id = id
        self.uri = uri
        self.summary = summary
        self.description = description
        self.status = status
        self.product = product
        self.component = component
        self.version = version
        self.type_ = type_
        self.accountNumber = accountNumber
        self.view_uri = view_uri
        self.reference = reference
        self.notes = notes
        self.escalated = escalated
        self.contactName = contactName
        self.contactSsoUsername = contactSsoUsername
        self.origin = origin
        self.owner = owner
        self.internalPriority = internalPriority
        self.internalStatus = internalStatus
        self.suppliedName = suppliedName
        self.suppliedPhone = suppliedPhone
        self.suppliedEmail = suppliedEmail
        self.severity = severity
        self.folderNumber = folderNumber
        self.comments = comments
        self.notified_users = notified_users
        self.entitlement = entitlement
        self.solutions = solutions
    def factory(*args_, **kwargs_):
        if supportNeed.subclass:
            return supportNeed.subclass(*args_, **kwargs_)
        else:
            return supportNeed(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_summary(self): return self.summary
    def set_summary(self, summary): self.summary = summary
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_product(self): return self.product
    def set_product(self, product): self.product = product
    def get_component(self): return self.component
    def set_component(self, component): self.component = component
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_accountNumber(self): return self.accountNumber
    def set_accountNumber(self, accountNumber): self.accountNumber = accountNumber
    def get_view_uri(self): return self.view_uri
    def set_view_uri(self, view_uri): self.view_uri = view_uri
    def get_reference(self): return self.reference
    def set_reference(self, reference): self.reference = reference
    def get_notes(self): return self.notes
    def set_notes(self, notes): self.notes = notes
    def get_escalated(self): return self.escalated
    def set_escalated(self, escalated): self.escalated = escalated
    def get_contactName(self): return self.contactName
    def set_contactName(self, contactName): self.contactName = contactName
    def get_contactSsoUsername(self): return self.contactSsoUsername
    def set_contactSsoUsername(self, contactSsoUsername): self.contactSsoUsername = contactSsoUsername
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_internalPriority(self): return self.internalPriority
    def set_internalPriority(self, internalPriority): self.internalPriority = internalPriority
    def get_internalStatus(self): return self.internalStatus
    def set_internalStatus(self, internalStatus): self.internalStatus = internalStatus
    def get_suppliedName(self): return self.suppliedName
    def set_suppliedName(self, suppliedName): self.suppliedName = suppliedName
    def get_suppliedPhone(self): return self.suppliedPhone
    def set_suppliedPhone(self, suppliedPhone): self.suppliedPhone = suppliedPhone
    def get_suppliedEmail(self): return self.suppliedEmail
    def set_suppliedEmail(self, suppliedEmail): self.suppliedEmail = suppliedEmail
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def get_folderNumber(self): return self.folderNumber
    def set_folderNumber(self, folderNumber): self.folderNumber = folderNumber
    def get_comments(self): return self.comments
    def set_comments(self, comments): self.comments = comments
    def get_notified_users(self): return self.notified_users
    def set_notified_users(self, notified_users): self.notified_users = notified_users
    def get_entitlement(self): return self.entitlement
    def set_entitlement(self, entitlement): self.entitlement = entitlement
    def get_solutions(self): return self.solutions
    def set_solutions(self, solutions): self.solutions = solutions
    def get_alternateId(self): return self.alternateId
    def set_alternateId(self, alternateId): self.alternateId = alternateId
    def export(self, outfile, level, namespace_='tns:', name_='supportNeed', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='supportNeed')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='supportNeed'):
        super(supportNeed, self).exportAttributes(outfile, level, already_processed, namespace_, name_='supportNeed')
        if self.alternateId is not None and 'alternateId' not in already_processed:
            already_processed.append('alternateId')
            outfile.write(' alternateId=%s' % (self.gds_format_string(quote_attrib(self.alternateId).encode(ExternalEncoding), input_name='alternateId'),))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='supportNeed', fromsubclass_=False):
        super(supportNeed, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('<%sid>%s</%sid>\n' % (namespace_, self.gds_format_string(quote_xml(self.id).encode(ExternalEncoding), input_name='id'), namespace_))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('<%suri>%s</%suri>\n' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_))
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('<%ssummary>%s</%ssummary>\n' % (namespace_, self.gds_format_string(quote_xml(self.summary).encode(ExternalEncoding), input_name='summary'), namespace_))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('<%sdescription>%s</%sdescription>\n' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('<%sstatus>%s</%sstatus>\n' % (namespace_, self.gds_format_string(quote_xml(self.status).encode(ExternalEncoding), input_name='status'), namespace_))
        if self.product is not None:
            showIndent(outfile, level)
            outfile.write('<%sproduct>%s</%sproduct>\n' % (namespace_, self.gds_format_string(quote_xml(self.product).encode(ExternalEncoding), input_name='product'), namespace_))
        if self.component is not None:
            showIndent(outfile, level)
            outfile.write('<%scomponent>%s</%scomponent>\n' % (namespace_, self.gds_format_string(quote_xml(self.component).encode(ExternalEncoding), input_name='component'), namespace_))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('<%sversion>%s</%sversion>\n' % (namespace_, self.gds_format_string(quote_xml(self.version).encode(ExternalEncoding), input_name='version'), namespace_))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        if self.accountNumber is not None:
            showIndent(outfile, level)
            outfile.write('<%saccountNumber>%s</%saccountNumber>\n' % (namespace_, self.gds_format_string(quote_xml(self.accountNumber).encode(ExternalEncoding), input_name='accountNumber'), namespace_))
        if self.view_uri is not None:
            showIndent(outfile, level)
            outfile.write('<%sview_uri>%s</%sview_uri>\n' % (namespace_, self.gds_format_string(quote_xml(self.view_uri).encode(ExternalEncoding), input_name='view_uri'), namespace_))
        if self.reference is not None:
            showIndent(outfile, level)
            outfile.write('<%sreference>%s</%sreference>\n' % (namespace_, self.gds_format_string(quote_xml(self.reference).encode(ExternalEncoding), input_name='reference'), namespace_))
        if self.notes is not None:
            showIndent(outfile, level)
            outfile.write('<%snotes>%s</%snotes>\n' % (namespace_, self.gds_format_string(quote_xml(self.notes).encode(ExternalEncoding), input_name='notes'), namespace_))
        if self.escalated is not None:
            showIndent(outfile, level)
            outfile.write('<%sescalated>%s</%sescalated>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.escalated)), input_name='escalated'), namespace_))
        if self.contactName is not None:
            showIndent(outfile, level)
            outfile.write('<%scontactName>%s</%scontactName>\n' % (namespace_, self.gds_format_string(quote_xml(self.contactName).encode(ExternalEncoding), input_name='contactName'), namespace_))
        if self.contactSsoUsername is not None:
            showIndent(outfile, level)
            outfile.write('<%scontactSsoUsername>%s</%scontactSsoUsername>\n' % (namespace_, self.gds_format_string(quote_xml(self.contactSsoUsername).encode(ExternalEncoding), input_name='contactSsoUsername'), namespace_))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('<%sorigin>%s</%sorigin>\n' % (namespace_, self.gds_format_string(quote_xml(self.origin).encode(ExternalEncoding), input_name='origin'), namespace_))
        if self.owner is not None:
            showIndent(outfile, level)
            outfile.write('<%sowner>%s</%sowner>\n' % (namespace_, self.gds_format_string(quote_xml(self.owner).encode(ExternalEncoding), input_name='owner'), namespace_))
        if self.internalPriority is not None:
            showIndent(outfile, level)
            outfile.write('<%sinternalPriority>%s</%sinternalPriority>\n' % (namespace_, self.gds_format_string(quote_xml(self.internalPriority).encode(ExternalEncoding), input_name='internalPriority'), namespace_))
        if self.internalStatus is not None:
            showIndent(outfile, level)
            outfile.write('<%sinternalStatus>%s</%sinternalStatus>\n' % (namespace_, self.gds_format_string(quote_xml(self.internalStatus).encode(ExternalEncoding), input_name='internalStatus'), namespace_))
        if self.suppliedName is not None:
            showIndent(outfile, level)
            outfile.write('<%ssuppliedName>%s</%ssuppliedName>\n' % (namespace_, self.gds_format_string(quote_xml(self.suppliedName).encode(ExternalEncoding), input_name='suppliedName'), namespace_))
        if self.suppliedPhone is not None:
            showIndent(outfile, level)
            outfile.write('<%ssuppliedPhone>%s</%ssuppliedPhone>\n' % (namespace_, self.gds_format_string(quote_xml(self.suppliedPhone).encode(ExternalEncoding), input_name='suppliedPhone'), namespace_))
        if self.suppliedEmail is not None:
            showIndent(outfile, level)
            outfile.write('<%ssuppliedEmail>%s</%ssuppliedEmail>\n' % (namespace_, self.gds_format_string(quote_xml(self.suppliedEmail).encode(ExternalEncoding), input_name='suppliedEmail'), namespace_))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('<%sseverity>%s</%sseverity>\n' % (namespace_, self.gds_format_string(quote_xml(self.severity).encode(ExternalEncoding), input_name='severity'), namespace_))
        if self.folderNumber is not None:
            showIndent(outfile, level)
            outfile.write('<%sfolderNumber>%s</%sfolderNumber>\n' % (namespace_, self.gds_format_string(quote_xml(self.folderNumber).encode(ExternalEncoding), input_name='folderNumber'), namespace_))
        if self.comments is not None:
            self.comments.export(outfile, level, namespace_, name_='comments')
        if self.notified_users is not None:
            self.notified_users.export(outfile, level, namespace_, name_='notified_users')
        if self.entitlement is not None:
            self.entitlement.export(outfile, level, namespace_, name_='entitlement',)
        if self.solutions is not None:
            self.solutions.export(outfile, level, namespace_, name_='solutions',)
    def hasContent_(self):
        if (
            self.id is not None or
            self.uri is not None or
            self.summary is not None or
            self.description is not None or
            self.status is not None or
            self.product is not None or
            self.component is not None or
            self.version is not None or
            self.type_ is not None or
            self.accountNumber is not None or
            self.view_uri is not None or
            self.reference is not None or
            self.notes is not None or
            self.escalated is not None or
            self.contactName is not None or
            self.contactSsoUsername is not None or
            self.origin is not None or
            self.owner is not None or
            self.internalPriority is not None or
            self.internalStatus is not None or
            self.suppliedName is not None or
            self.suppliedPhone is not None or
            self.suppliedEmail is not None or
            self.severity is not None or
            self.folderNumber is not None or
            self.comments is not None or
            self.notified_users is not None or
            self.entitlement is not None or
            self.solutions is not None or
            super(supportNeed, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='supportNeed'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.alternateId is not None and 'alternateId' not in already_processed:
            already_processed.append('alternateId')
            showIndent(outfile, level)
            outfile.write('alternateId = "%s",\n' % (self.alternateId,))
        super(supportNeed, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(supportNeed, self).exportLiteralChildren(outfile, level, name_)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id=%s,\n' % quote_python(self.id).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('summary=%s,\n' % quote_python(self.summary).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=%s,\n' % quote_python(self.status).encode(ExternalEncoding))
        if self.product is not None:
            showIndent(outfile, level)
            outfile.write('product=%s,\n' % quote_python(self.product).encode(ExternalEncoding))
        if self.component is not None:
            showIndent(outfile, level)
            outfile.write('component=%s,\n' % quote_python(self.component).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.accountNumber is not None:
            showIndent(outfile, level)
            outfile.write('accountNumber=%s,\n' % quote_python(self.accountNumber).encode(ExternalEncoding))
        if self.view_uri is not None:
            showIndent(outfile, level)
            outfile.write('view_uri=%s,\n' % quote_python(self.view_uri).encode(ExternalEncoding))
        if self.reference is not None:
            showIndent(outfile, level)
            outfile.write('reference=%s,\n' % quote_python(self.reference).encode(ExternalEncoding))
        if self.notes is not None:
            showIndent(outfile, level)
            outfile.write('notes=%s,\n' % quote_python(self.notes).encode(ExternalEncoding))
        if self.escalated is not None:
            showIndent(outfile, level)
            outfile.write('escalated=%s,\n' % self.escalated)
        if self.contactName is not None:
            showIndent(outfile, level)
            outfile.write('contactName=%s,\n' % quote_python(self.contactName).encode(ExternalEncoding))
        if self.contactSsoUsername is not None:
            showIndent(outfile, level)
            outfile.write('contactSsoUsername=%s,\n' % quote_python(self.contactSsoUsername).encode(ExternalEncoding))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('origin=%s,\n' % quote_python(self.origin).encode(ExternalEncoding))
        if self.owner is not None:
            showIndent(outfile, level)
            outfile.write('owner=%s,\n' % quote_python(self.owner).encode(ExternalEncoding))
        if self.internalPriority is not None:
            showIndent(outfile, level)
            outfile.write('internalPriority=%s,\n' % quote_python(self.internalPriority).encode(ExternalEncoding))
        if self.internalStatus is not None:
            showIndent(outfile, level)
            outfile.write('internalStatus=%s,\n' % quote_python(self.internalStatus).encode(ExternalEncoding))
        if self.suppliedName is not None:
            showIndent(outfile, level)
            outfile.write('suppliedName=%s,\n' % quote_python(self.suppliedName).encode(ExternalEncoding))
        if self.suppliedPhone is not None:
            showIndent(outfile, level)
            outfile.write('suppliedPhone=%s,\n' % quote_python(self.suppliedPhone).encode(ExternalEncoding))
        if self.suppliedEmail is not None:
            showIndent(outfile, level)
            outfile.write('suppliedEmail=%s,\n' % quote_python(self.suppliedEmail).encode(ExternalEncoding))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('severity=%s,\n' % quote_python(self.severity).encode(ExternalEncoding))
        if self.folderNumber is not None:
            showIndent(outfile, level)
            outfile.write('folderNumber=%s,\n' % quote_python(self.folderNumber).encode(ExternalEncoding))
        if self.comments is not None:
            showIndent(outfile, level)
            outfile.write('comments=model_.comments(\n')
            self.comments.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.notified_users is not None:
            showIndent(outfile, level)
            outfile.write('notified_users=model_.notified_users(\n')
            self.notified_users.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.entitlement is not None:
            showIndent(outfile, level)
            outfile.write('entitlement=model_.entitlement(\n')
            self.entitlement.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.solutions is not None:
            showIndent(outfile, level)
            outfile.write('solutions=model_.solutions(\n')
            self.solutions.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('alternateId', node)
        if value is not None and 'alternateId' not in already_processed:
            already_processed.append('alternateId')
            self.alternateId = value
        super(supportNeed, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'id':
            id_ = child_.text
            id_ = self.gds_validate_string(id_, node, 'id')
            self.id = id_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'summary':
            summary_ = child_.text
            summary_ = self.gds_validate_string(summary_, node, 'summary')
            self.summary = summary_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'status':
            status_ = child_.text
            status_ = self.gds_validate_string(status_, node, 'status')
            self.status = status_
        elif nodeName_ == 'product':
            product_ = child_.text
            product_ = self.gds_validate_string(product_, node, 'product')
            self.product = product_
        elif nodeName_ == 'component':
            component_ = child_.text
            component_ = self.gds_validate_string(component_, node, 'component')
            self.component = component_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'accountNumber':
            accountNumber_ = child_.text
            accountNumber_ = self.gds_validate_string(accountNumber_, node, 'accountNumber')
            self.accountNumber = accountNumber_
        elif nodeName_ == 'view_uri':
            view_uri_ = child_.text
            view_uri_ = self.gds_validate_string(view_uri_, node, 'view_uri')
            self.view_uri = view_uri_
        elif nodeName_ == 'reference':
            reference_ = child_.text
            reference_ = self.gds_validate_string(reference_, node, 'reference')
            self.reference = reference_
        elif nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
        elif nodeName_ == 'escalated':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'escalated')
            self.escalated = ival_
        elif nodeName_ == 'contactName':
            contactName_ = child_.text
            contactName_ = self.gds_validate_string(contactName_, node, 'contactName')
            self.contactName = contactName_
        elif nodeName_ == 'contactSsoUsername':
            contactSsoUsername_ = child_.text
            contactSsoUsername_ = self.gds_validate_string(contactSsoUsername_, node, 'contactSsoUsername')
            self.contactSsoUsername = contactSsoUsername_
        elif nodeName_ == 'origin':
            origin_ = child_.text
            origin_ = self.gds_validate_string(origin_, node, 'origin')
            self.origin = origin_
        elif nodeName_ == 'owner':
            owner_ = child_.text
            owner_ = self.gds_validate_string(owner_, node, 'owner')
            self.owner = owner_
        elif nodeName_ == 'internalPriority':
            internalPriority_ = child_.text
            internalPriority_ = self.gds_validate_string(internalPriority_, node, 'internalPriority')
            self.internalPriority = internalPriority_
        elif nodeName_ == 'internalStatus':
            internalStatus_ = child_.text
            internalStatus_ = self.gds_validate_string(internalStatus_, node, 'internalStatus')
            self.internalStatus = internalStatus_
        elif nodeName_ == 'suppliedName':
            suppliedName_ = child_.text
            suppliedName_ = self.gds_validate_string(suppliedName_, node, 'suppliedName')
            self.suppliedName = suppliedName_
        elif nodeName_ == 'suppliedPhone':
            suppliedPhone_ = child_.text
            suppliedPhone_ = self.gds_validate_string(suppliedPhone_, node, 'suppliedPhone')
            self.suppliedPhone = suppliedPhone_
        elif nodeName_ == 'suppliedEmail':
            suppliedEmail_ = child_.text
            suppliedEmail_ = self.gds_validate_string(suppliedEmail_, node, 'suppliedEmail')
            self.suppliedEmail = suppliedEmail_
        elif nodeName_ == 'severity':
            severity_ = child_.text
            severity_ = self.gds_validate_string(severity_, node, 'severity')
            self.severity = severity_
        elif nodeName_ == 'folderNumber':
            folderNumber_ = child_.text
            folderNumber_ = self.gds_validate_string(folderNumber_, node, 'folderNumber')
            self.folderNumber = folderNumber_
        elif nodeName_ == 'comments':
            obj_ = comments.factory()
            obj_.build(child_)
            self.set_comments(obj_)
        elif nodeName_ == 'notified_users':
            obj_ = notified_users.factory()
            obj_.build(child_)
            self.set_notified_users(obj_)
        elif nodeName_ == 'entitlement':
            obj_ = entitlement.factory()
            obj_.build(child_)
            self.set_entitlement(obj_)
        elif nodeName_ == 'solutions':
            obj_ = solutions.factory()
            obj_.build(child_)
            self.set_solutions(obj_)
        super(supportNeed, self).buildChildren(child_, node, nodeName_, True)
# end class supportNeed


class comments(strataEntity):
    """A list of comments"""
    subclass = None
    superclass = strataEntity
    def __init__(self, comment=None):
        super(comments, self).__init__()
        if comment is None:
            self.comment = []
        else:
            self.comment = comment
    def factory(*args_, **kwargs_):
        if comments.subclass:
            return comments.subclass(*args_, **kwargs_)
        else:
            return comments(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_comment(self): return self.comment
    def set_comment(self, comment): self.comment = comment
    def add_comment(self, value): self.comment.append(value)
    def insert_comment(self, index, value): self.comment[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='comments', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='comments')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='comments'):
        super(comments, self).exportAttributes(outfile, level, already_processed, namespace_, name_='comments')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='comments', fromsubclass_=False):
        super(comments, self).exportChildren(outfile, level, namespace_, name_, True)
        for comment_ in self.comment:
            comment_.export(outfile, level, namespace_, name_='comment')
    def hasContent_(self):
        if (
            self.comment or
            super(comments, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='comments'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(comments, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(comments, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('comment=[\n')
        level += 1
        for comment_ in self.comment:
            showIndent(outfile, level)
            outfile.write('model_.comment(\n')
            comment_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(comments, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'comment':
            obj_ = comment.factory()
            obj_.build(child_)
            self.comment.append(obj_)
        super(comments, self).buildChildren(child_, node, nodeName_, True)
# end class comments


class comment(trackedEntity):
    """A support case comment and associated metadata."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, id=None, caseNumber=None, text=None, uri=None, public=True, draft=False, publishedDate=None, view_uri=None):
        super(comment, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.id = _cast(None, id)
        self.caseNumber = _cast(None, caseNumber)
        self.text = text
        self.uri = uri
        self.public = public
        self.draft = draft
        self.publishedDate = publishedDate
        self.view_uri = view_uri
    def factory(*args_, **kwargs_):
        if comment.subclass:
            return comment.subclass(*args_, **kwargs_)
        else:
            return comment(*args_, **kwargs_)
    factory = staticmethod(factory)
    @set_docstring('''
    Get the comment text

    :returns: The text of the comment
    :rtype: string''')
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    @set_docstring('''
    Get the comment REST API URI

    :returns: API URL for comment object
    :rtype: string''')
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_public(self): return self.public
    def set_public(self, public): self.public = public
    def get_draft(self): return self.draft
    def set_draft(self, draft): self.draft = draft
    def get_publishedDate(self): return self.publishedDate
    def set_publishedDate(self, publishedDate): self.publishedDate = publishedDate
    @set_docstring('''
    Get the comment publish date/time

    :returns: The date when the comment was published
    :rtype: ISO 8601 formatted string''')
    def get_view_uri(self): return self.view_uri
    def set_view_uri(self, view_uri): self.view_uri = view_uri
    @set_docstring('''
    Get the comment ID number

    :returns: Comment ID
    :rtype: string''')
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    @set_docstring('''
    Get the case number for the associated comment

    :returns: Case number
    :rtype: string''')
    def get_caseNumber(self): return self.caseNumber
    def set_caseNumber(self, caseNumber): self.caseNumber = caseNumber
    def export(self, outfile, level, namespace_='tns:', name_='comment', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='comment')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='comment'):
        super(comment, self).exportAttributes(outfile, level, already_processed, namespace_, name_='comment')
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'),))
        if self.caseNumber is not None and 'caseNumber' not in already_processed:
            already_processed.append('caseNumber')
            outfile.write(' caseNumber=%s' % (self.gds_format_string(quote_attrib(self.caseNumber).encode(ExternalEncoding), input_name='caseNumber'),))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='comment', fromsubclass_=False):
        super(comment, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('<%suri>%s</%suri>\n' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_))
        if self.public is not None:
            showIndent(outfile, level)
            outfile.write('<%spublic>%s</%spublic>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.public)), input_name='public'), namespace_))
        if self.draft is not None:
            showIndent(outfile, level)
            outfile.write('<%sdraft>%s</%sdraft>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.draft)), input_name='draft'), namespace_))
        if self.publishedDate is not None:
            showIndent(outfile, level)
            outfile.write('<%spublishedDate>%s</%spublishedDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.publishedDate).encode(ExternalEncoding), input_name='publishedDate'), namespace_))
        if self.view_uri is not None:
            showIndent(outfile, level)
            outfile.write('<%sview_uri>%s</%sview_uri>\n' % (namespace_, self.gds_format_string(quote_xml(self.view_uri).encode(ExternalEncoding), input_name='view_uri'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.uri is not None or
            self.public is not None or
            self.draft is not None or
            self.publishedDate is not None or
            self.view_uri is not None or
            super(comment, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='comment'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
        if self.caseNumber is not None and 'caseNumber' not in already_processed:
            already_processed.append('caseNumber')
            showIndent(outfile, level)
            outfile.write('caseNumber = "%s",\n' % (self.caseNumber,))
        super(comment, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(comment, self).exportLiteralChildren(outfile, level, name_)
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.public is not None:
            showIndent(outfile, level)
            outfile.write('public=%s,\n' % self.public)
        if self.draft is not None:
            showIndent(outfile, level)
            outfile.write('draft=%s,\n' % self.draft)
        if self.publishedDate is not None:
            showIndent(outfile, level)
            outfile.write('publishedDate=%s,\n' % quote_python(self.publishedDate).encode(ExternalEncoding))
        if self.view_uri is not None:
            showIndent(outfile, level)
            outfile.write('view_uri=%s,\n' % quote_python(self.view_uri).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        value = find_attr_value_('caseNumber', node)
        if value is not None and 'caseNumber' not in already_processed:
            already_processed.append('caseNumber')
            self.caseNumber = value
        super(comment, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'public':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'public')
            self.public = ival_
        elif nodeName_ == 'draft':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'draft')
            self.draft = ival_
        elif nodeName_ == 'publishedDate':
            publishedDate_ = child_.text
            publishedDate_ = self.gds_validate_string(publishedDate_, node, 'publishedDate')
            self.publishedDate = publishedDate_
        elif nodeName_ == 'view_uri':
            view_uri_ = child_.text
            view_uri_ = self.gds_validate_string(view_uri_, node, 'view_uri')
            self.view_uri = view_uri_
        super(comment, self).buildChildren(child_, node, nodeName_, True)
# end class comment


class notified_users(strataEntity):
    """A list of users notified by email when the parent case is modified"""
    subclass = None
    superclass = strataEntity
    def __init__(self, link=None):
        super(notified_users, self).__init__()
        if link is None:
            self.link = []
        else:
            self.link = link
    def factory(*args_, **kwargs_):
        if notified_users.subclass:
            return notified_users.subclass(*args_, **kwargs_)
        else:
            return notified_users(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='notified_users', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='notified_users')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='notified_users'):
        super(notified_users, self).exportAttributes(outfile, level, already_processed, namespace_, name_='notified_users')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='notified_users', fromsubclass_=False):
        super(notified_users, self).exportChildren(outfile, level, namespace_, name_, True)
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link')
    def hasContent_(self):
        if (
            self.link or
            super(notified_users, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='notified_users'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(notified_users, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(notified_users, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.link(\n')
            link_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(notified_users, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'link':
            obj_ = link.factory()
            obj_.build(child_)
            self.link.append(obj_)
        super(notified_users, self).buildChildren(child_, node, nodeName_, True)
# end class notified_users


class products(GeneratedsSuper):
    """A list of products."""
    subclass = None
    superclass = None
    def __init__(self, product=None):
        if product is None:
            self.product = []
        else:
            self.product = product
    def factory(*args_, **kwargs_):
        if products.subclass:
            return products.subclass(*args_, **kwargs_)
        else:
            return products(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_product(self): return self.product
    def set_product(self, product): self.product = product
    def add_product(self, value): self.product.append(value)
    def insert_product(self, index, value): self.product[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='products', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='products')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='products'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='products', fromsubclass_=False):
        for product_ in self.product:
            product_.export(outfile, level, namespace_, name_='product')
    def hasContent_(self):
        if (
            self.product
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='products'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('product=[\n')
        level += 1
        for product_ in self.product:
            showIndent(outfile, level)
            outfile.write('model_.product(\n')
            product_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'product':
            obj_ = product.factory()
            obj_.build(child_)
            self.product.append(obj_)
# end class products


class product(GeneratedsSuper):
    """A product."""
    subclass = None
    superclass = None
    def __init__(self, code=None, name=None, suggested_artifacts=None):
        self.code = code
        self.name = name
        self.suggested_artifacts = suggested_artifacts
    def factory(*args_, **kwargs_):
        if product.subclass:
            return product.subclass(*args_, **kwargs_)
        else:
            return product(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_suggested_artifacts(self): return self.suggested_artifacts
    def set_suggested_artifacts(self, suggested_artifacts): self.suggested_artifacts = suggested_artifacts
    def export(self, outfile, level, namespace_='tns:', name_='product', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='product')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='product'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='product', fromsubclass_=False):
        if self.code is not None:
            showIndent(outfile, level)
            outfile.write('<%scode>%s</%scode>\n' % (namespace_, self.gds_format_string(quote_xml(self.code).encode(ExternalEncoding), input_name='code'), namespace_))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.suggested_artifacts is not None:
            self.suggested_artifacts.export(outfile, level, namespace_, name_='suggested_artifacts')
    def hasContent_(self):
        if (
            self.code is not None or
            self.name is not None or
            self.suggested_artifacts is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='product'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.code is not None:
            showIndent(outfile, level)
            outfile.write('code=%s,\n' % quote_python(self.code).encode(ExternalEncoding))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.suggested_artifacts is not None:
            showIndent(outfile, level)
            outfile.write('suggested_artifacts=model_.suggested_artifacts(\n')
            self.suggested_artifacts.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'code':
            code_ = child_.text
            code_ = self.gds_validate_string(code_, node, 'code')
            self.code = code_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'suggested_artifacts':
            obj_ = suggested_artifacts.factory()
            obj_.build(child_)
            self.set_suggested_artifacts(obj_)
# end class product


class suggested_artifacts(GeneratedsSuper):
    """A list of Artifacts."""
    subclass = None
    superclass = None
    def __init__(self, suggested_artifact=None):
        if suggested_artifact is None:
            self.suggested_artifact = []
        else:
            self.suggested_artifact = suggested_artifact
    def factory(*args_, **kwargs_):
        if suggested_artifacts.subclass:
            return suggested_artifacts.subclass(*args_, **kwargs_)
        else:
            return suggested_artifacts(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_suggested_artifact(self): return self.suggested_artifact
    def set_suggested_artifact(self, suggested_artifact): self.suggested_artifact = suggested_artifact
    def add_suggested_artifact(self, value): self.suggested_artifact.append(value)
    def insert_suggested_artifact(self, index, value): self.suggested_artifact[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='suggested_artifacts', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='suggested_artifacts')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='suggested_artifacts'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='suggested_artifacts', fromsubclass_=False):
        for suggested_artifact_ in self.suggested_artifact:
            suggested_artifact_.export(outfile, level, namespace_, name_='suggested_artifact')
    def hasContent_(self):
        if (
            self.suggested_artifact
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='suggested_artifacts'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('suggested_artifact=[\n')
        level += 1
        for suggested_artifact_ in self.suggested_artifact:
            showIndent(outfile, level)
            outfile.write('model_.suggested_artifact(\n')
            suggested_artifact_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'suggested_artifact':
            obj_ = suggested_artifact.factory()
            obj_.build(child_)
            self.suggested_artifact.append(obj_)
# end class suggested_artifacts


class suggested_artifact(GeneratedsSuper):
    """A Artifact."""
    subclass = None
    superclass = None
    def __init__(self, name=None, description=None):
        self.name = name
        self.description = description
    def factory(*args_, **kwargs_):
        if suggested_artifact.subclass:
            return suggested_artifact.subclass(*args_, **kwargs_)
        else:
            return suggested_artifact(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def export(self, outfile, level, namespace_='tns:', name_='suggested_artifact', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='suggested_artifact')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='suggested_artifact'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='suggested_artifact', fromsubclass_=False):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('<%sdescription>%s</%sdescription>\n' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_))
    def hasContent_(self):
        if (
            self.name is not None or
            self.description is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='suggested_artifact'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
# end class suggested_artifact


class versions(GeneratedsSuper):
    """A list of product versions."""
    subclass = None
    superclass = None
    def __init__(self, version=None):
        if version is None:
            self.version = []
        else:
            self.version = version
    def factory(*args_, **kwargs_):
        if versions.subclass:
            return versions.subclass(*args_, **kwargs_)
        else:
            return versions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def add_version(self, value): self.version.append(value)
    def insert_version(self, index, value): self.version[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='versions', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='versions')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='versions'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='versions', fromsubclass_=False):
        for version_ in self.version:
            showIndent(outfile, level)
            outfile.write('<%sversion>%s</%sversion>\n' % (namespace_, self.gds_format_string(quote_xml(version_).encode(ExternalEncoding), input_name='version'), namespace_))
    def hasContent_(self):
        if (
            self.version
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='versions'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('version=[\n')
        level += 1
        for version_ in self.version:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(version_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version.append(version_)
# end class versions


class values(GeneratedsSuper):
    """A list of name/value pairs. Both names and values are String typed.
    List can contain zero or more elements. Values are nullable."""
    subclass = None
    superclass = None
    def __init__(self, value=None):
        if value is None:
            self.value = []
        else:
            self.value = value
    def factory(*args_, **kwargs_):
        if values.subclass:
            return values.subclass(*args_, **kwargs_)
        else:
            return values(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value(self, index, value): self.value[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='values', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='values')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='values'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='values', fromsubclass_=False):
        for value_ in self.value:
            value_.export(outfile, level, namespace_, name_='value')
    def hasContent_(self):
        if (
            self.value
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='values'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('value=[\n')
        level += 1
        for value_ in self.value:
            showIndent(outfile, level)
            outfile.write('model_.valueType(\n')
            value_.exportLiteral(outfile, level, name_='valueType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            obj_ = valueType.factory()
            obj_.build(child_)
            self.value.append(obj_)
# end class values


class entitlements(strataEntity):
    """A list of Entitlements."""
    subclass = None
    superclass = strataEntity
    def __init__(self, entitlement=None):
        super(entitlements, self).__init__()
        if entitlement is None:
            self.entitlement = []
        else:
            self.entitlement = entitlement
    def factory(*args_, **kwargs_):
        if entitlements.subclass:
            return entitlements.subclass(*args_, **kwargs_)
        else:
            return entitlements(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_entitlement(self): return self.entitlement
    def set_entitlement(self, entitlement): self.entitlement = entitlement
    def add_entitlement(self, value): self.entitlement.append(value)
    def insert_entitlement(self, index, value): self.entitlement[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='entitlements', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='entitlements')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='entitlements'):
        super(entitlements, self).exportAttributes(outfile, level, already_processed, namespace_, name_='entitlements')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='entitlements', fromsubclass_=False):
        super(entitlements, self).exportChildren(outfile, level, namespace_, name_, True)
        for entitlement_ in self.entitlement:
            entitlement_.export(outfile, level, namespace_, name_='entitlement')
    def hasContent_(self):
        if (
            self.entitlement or
            super(entitlements, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='entitlements'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(entitlements, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(entitlements, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('entitlement=[\n')
        level += 1
        for entitlement_ in self.entitlement:
            showIndent(outfile, level)
            outfile.write('model_.entitlement(\n')
            entitlement_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(entitlements, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'entitlement':
            obj_ = entitlement.factory()
            obj_.build(child_)
            self.entitlement.append(obj_)
        super(entitlements, self).buildChildren(child_, node, nodeName_, True)
# end class entitlements


class entitlement(trackedEntity):
    """entitlement and related meta data."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, id=None, uri=None, name=None, sla=None, supportLevel=None, serviceLevel=None, startDate=None, endDate=None):
        super(entitlement, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.id = id
        self.uri = uri
        self.name = name
        self.sla = sla
        self.supportLevel = supportLevel
        self.serviceLevel = serviceLevel
        self.startDate = startDate
        self.endDate = endDate
    def factory(*args_, **kwargs_):
        if entitlement.subclass:
            return entitlement.subclass(*args_, **kwargs_)
        else:
            return entitlement(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_sla(self): return self.sla
    def set_sla(self, sla): self.sla = sla
    def get_supportLevel(self): return self.supportLevel
    def set_supportLevel(self, supportLevel): self.supportLevel = supportLevel
    def get_serviceLevel(self): return self.serviceLevel
    def set_serviceLevel(self, serviceLevel): self.serviceLevel = serviceLevel
    def get_startDate(self): return self.startDate
    def set_startDate(self, startDate): self.startDate = startDate
    def get_endDate(self): return self.endDate
    def set_endDate(self, endDate): self.endDate = endDate
    def export(self, outfile, level, namespace_='tns:', name_='entitlement', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='entitlement')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='entitlement'):
        super(entitlement, self).exportAttributes(outfile, level, already_processed, namespace_, name_='entitlement')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='entitlement', fromsubclass_=False):
        super(entitlement, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('<%sid>%s</%sid>\n' % (namespace_, self.gds_format_string(quote_xml(self.id).encode(ExternalEncoding), input_name='id'), namespace_))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('<%suri>%s</%suri>\n' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.sla is not None:
            showIndent(outfile, level)
            outfile.write('<%ssla>%s</%ssla>\n' % (namespace_, self.gds_format_string(quote_xml(self.sla).encode(ExternalEncoding), input_name='sla'), namespace_))
        if self.supportLevel is not None:
            showIndent(outfile, level)
            outfile.write('<%ssupportLevel>%s</%ssupportLevel>\n' % (namespace_, self.gds_format_string(quote_xml(self.supportLevel).encode(ExternalEncoding), input_name='supportLevel'), namespace_))
        if self.serviceLevel is not None:
            showIndent(outfile, level)
            outfile.write('<%sserviceLevel>%s</%sserviceLevel>\n' % (namespace_, self.gds_format_string(quote_xml(self.serviceLevel).encode(ExternalEncoding), input_name='serviceLevel'), namespace_))
        if self.startDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sstartDate>%s</%sstartDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.startDate).encode(ExternalEncoding), input_name='startDate'), namespace_))
        if self.endDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sendDate>%s</%sendDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.endDate).encode(ExternalEncoding), input_name='endDate'), namespace_))
    def hasContent_(self):
        if (
            self.id is not None or
            self.uri is not None or
            self.name is not None or
            self.sla is not None or
            self.supportLevel is not None or
            self.serviceLevel is not None or
            self.startDate is not None or
            self.endDate is not None or
            super(entitlement, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='entitlement'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(entitlement, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(entitlement, self).exportLiteralChildren(outfile, level, name_)
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id=%s,\n' % quote_python(self.id).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.sla is not None:
            showIndent(outfile, level)
            outfile.write('sla=%s,\n' % quote_python(self.sla).encode(ExternalEncoding))
        if self.supportLevel is not None:
            showIndent(outfile, level)
            outfile.write('supportLevel=%s,\n' % quote_python(self.supportLevel).encode(ExternalEncoding))
        if self.serviceLevel is not None:
            showIndent(outfile, level)
            outfile.write('serviceLevel=%s,\n' % quote_python(self.serviceLevel).encode(ExternalEncoding))
        if self.startDate is not None:
            showIndent(outfile, level)
            outfile.write('startDate=%s,\n' % quote_python(self.startDate).encode(ExternalEncoding))
        if self.endDate is not None:
            showIndent(outfile, level)
            outfile.write('endDate=%s,\n' % quote_python(self.endDate).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(entitlement, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'id':
            id_ = child_.text
            id_ = self.gds_validate_string(id_, node, 'id')
            self.id = id_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'sla':
            sla_ = child_.text
            sla_ = self.gds_validate_string(sla_, node, 'sla')
            self.sla = sla_
        elif nodeName_ == 'supportLevel':
            supportLevel_ = child_.text
            supportLevel_ = self.gds_validate_string(supportLevel_, node, 'supportLevel')
            self.supportLevel = supportLevel_
        elif nodeName_ == 'serviceLevel':
            serviceLevel_ = child_.text
            serviceLevel_ = self.gds_validate_string(serviceLevel_, node, 'serviceLevel')
            self.serviceLevel = serviceLevel_
        elif nodeName_ == 'startDate':
            startDate_ = child_.text
            startDate_ = self.gds_validate_string(startDate_, node, 'startDate')
            self.startDate = startDate_
        elif nodeName_ == 'endDate':
            endDate_ = child_.text
            endDate_ = self.gds_validate_string(endDate_, node, 'endDate')
            self.endDate = endDate_
        super(entitlement, self).buildChildren(child_, node, nodeName_, True)
# end class entitlement


class error(GeneratedsSuper):
    """Provides error code and description for Starta API"""
    subclass = None
    superclass = None
    def __init__(self, code=None, message=None):
        self.code = code
        self.message = message
    def factory(*args_, **kwargs_):
        if error.subclass:
            return error.subclass(*args_, **kwargs_)
        else:
            return error(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_message(self): return self.message
    def set_message(self, message): self.message = message
    def export(self, outfile, level, namespace_='tns:', name_='error', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='error')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='error'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='error', fromsubclass_=False):
        if self.code is not None:
            showIndent(outfile, level)
            outfile.write('<%scode>%s</%scode>\n' % (namespace_, self.gds_format_string(quote_xml(self.code).encode(ExternalEncoding), input_name='code'), namespace_))
        if self.message is not None:
            showIndent(outfile, level)
            outfile.write('<%smessage>%s</%smessage>\n' % (namespace_, self.gds_format_string(quote_xml(self.message).encode(ExternalEncoding), input_name='message'), namespace_))
    def hasContent_(self):
        if (
            self.code is not None or
            self.message is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='error'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.code is not None:
            showIndent(outfile, level)
            outfile.write('code=%s,\n' % quote_python(self.code).encode(ExternalEncoding))
        if self.message is not None:
            showIndent(outfile, level)
            outfile.write('message=%s,\n' % quote_python(self.message).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'code':
            code_ = child_.text
            code_ = self.gds_validate_string(code_, node, 'code')
            self.code = code_
        elif nodeName_ == 'message':
            message_ = child_.text
            message_ = self.gds_validate_string(message_, node, 'message')
            self.message = message_
# end class error


class systemProfiles(strataEntity):
    """A list of systemProfiles."""
    subclass = None
    superclass = strataEntity
    def __init__(self, systemProfile=None):
        super(systemProfiles, self).__init__()
        if systemProfile is None:
            self.systemProfile = []
        else:
            self.systemProfile = systemProfile
    def factory(*args_, **kwargs_):
        if systemProfiles.subclass:
            return systemProfiles.subclass(*args_, **kwargs_)
        else:
            return systemProfiles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_systemProfile(self): return self.systemProfile
    def set_systemProfile(self, systemProfile): self.systemProfile = systemProfile
    def add_systemProfile(self, value): self.systemProfile.append(value)
    def insert_systemProfile(self, index, value): self.systemProfile[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='systemProfiles', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='systemProfiles')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='systemProfiles'):
        super(systemProfiles, self).exportAttributes(outfile, level, already_processed, namespace_, name_='systemProfiles')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='systemProfiles', fromsubclass_=False):
        super(systemProfiles, self).exportChildren(outfile, level, namespace_, name_, True)
        for systemProfile_ in self.systemProfile:
            systemProfile_.export(outfile, level, namespace_, name_='systemProfile')
    def hasContent_(self):
        if (
            self.systemProfile or
            super(systemProfiles, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='systemProfiles'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(systemProfiles, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(systemProfiles, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('systemProfile=[\n')
        level += 1
        for systemProfile_ in self.systemProfile:
            showIndent(outfile, level)
            outfile.write('model_.systemProfile(\n')
            systemProfile_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(systemProfiles, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'systemProfile':
            obj_ = systemProfile.factory()
            obj_.build(child_)
            self.systemProfile.append(obj_)
        super(systemProfiles, self).buildChildren(child_, node, nodeName_, True)
# end class systemProfiles


class systemProfile(trackedEntity):
    """systemProfile and related meta data."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, accountNumber=None, caseNumber=None, attachmentHash=None, deprecated=None, hash=None, SystemProfileCategory=None):
        super(systemProfile, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.accountNumber = accountNumber
        self.caseNumber = caseNumber
        self.attachmentHash = attachmentHash
        self.deprecated = deprecated
        self.hash = hash
        if SystemProfileCategory is None:
            self.SystemProfileCategory = []
        else:
            self.SystemProfileCategory = SystemProfileCategory
    def factory(*args_, **kwargs_):
        if systemProfile.subclass:
            return systemProfile.subclass(*args_, **kwargs_)
        else:
            return systemProfile(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_accountNumber(self): return self.accountNumber
    def set_accountNumber(self, accountNumber): self.accountNumber = accountNumber
    def get_caseNumber(self): return self.caseNumber
    def set_caseNumber(self, caseNumber): self.caseNumber = caseNumber
    def get_attachmentHash(self): return self.attachmentHash
    def set_attachmentHash(self, attachmentHash): self.attachmentHash = attachmentHash
    def get_deprecated(self): return self.deprecated
    def set_deprecated(self, deprecated): self.deprecated = deprecated
    def get_hash(self): return self.hash
    def set_hash(self, hash): self.hash = hash
    def get_SystemProfileCategory(self): return self.SystemProfileCategory
    def set_SystemProfileCategory(self, SystemProfileCategory): self.SystemProfileCategory = SystemProfileCategory
    def add_SystemProfileCategory(self, value): self.SystemProfileCategory.append(value)
    def insert_SystemProfileCategory(self, index, value): self.SystemProfileCategory[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='systemProfile', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='systemProfile')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='systemProfile'):
        super(systemProfile, self).exportAttributes(outfile, level, already_processed, namespace_, name_='systemProfile')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='systemProfile', fromsubclass_=False):
        super(systemProfile, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.accountNumber is not None:
            showIndent(outfile, level)
            outfile.write('<%saccountNumber>%s</%saccountNumber>\n' % (namespace_, self.gds_format_string(quote_xml(self.accountNumber).encode(ExternalEncoding), input_name='accountNumber'), namespace_))
        if self.caseNumber is not None:
            showIndent(outfile, level)
            outfile.write('<%scaseNumber>%s</%scaseNumber>\n' % (namespace_, self.gds_format_string(quote_xml(self.caseNumber).encode(ExternalEncoding), input_name='caseNumber'), namespace_))
        if self.attachmentHash is not None:
            showIndent(outfile, level)
            outfile.write('<%sattachmentHash>%s</%sattachmentHash>\n' % (namespace_, self.gds_format_string(quote_xml(self.attachmentHash).encode(ExternalEncoding), input_name='attachmentHash'), namespace_))
        if self.deprecated is not None:
            showIndent(outfile, level)
            outfile.write('<%sdeprecated>%s</%sdeprecated>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.deprecated)), input_name='deprecated'), namespace_))
        if self.hash is not None:
            showIndent(outfile, level)
            outfile.write('<%shash>%s</%shash>\n' % (namespace_, self.gds_format_string(quote_xml(self.hash).encode(ExternalEncoding), input_name='hash'), namespace_))
        for SystemProfileCategory_ in self.SystemProfileCategory:
            SystemProfileCategory_.export(outfile, level, namespace_, name_='SystemProfileCategory')
    def hasContent_(self):
        if (
            self.accountNumber is not None or
            self.caseNumber is not None or
            self.attachmentHash is not None or
            self.deprecated is not None or
            self.hash is not None or
            self.SystemProfileCategory or
            super(systemProfile, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='systemProfile'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(systemProfile, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(systemProfile, self).exportLiteralChildren(outfile, level, name_)
        if self.accountNumber is not None:
            showIndent(outfile, level)
            outfile.write('accountNumber=%s,\n' % quote_python(self.accountNumber).encode(ExternalEncoding))
        if self.caseNumber is not None:
            showIndent(outfile, level)
            outfile.write('caseNumber=%s,\n' % quote_python(self.caseNumber).encode(ExternalEncoding))
        if self.attachmentHash is not None:
            showIndent(outfile, level)
            outfile.write('attachmentHash=%s,\n' % quote_python(self.attachmentHash).encode(ExternalEncoding))
        if self.deprecated is not None:
            showIndent(outfile, level)
            outfile.write('deprecated=%s,\n' % self.deprecated)
        if self.hash is not None:
            showIndent(outfile, level)
            outfile.write('hash=%s,\n' % quote_python(self.hash).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('SystemProfileCategory=[\n')
        level += 1
        for SystemProfileCategory_ in self.SystemProfileCategory:
            showIndent(outfile, level)
            outfile.write('model_.SystemProfileCategory(\n')
            SystemProfileCategory_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(systemProfile, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'accountNumber':
            accountNumber_ = child_.text
            accountNumber_ = self.gds_validate_string(accountNumber_, node, 'accountNumber')
            self.accountNumber = accountNumber_
        elif nodeName_ == 'caseNumber':
            caseNumber_ = child_.text
            caseNumber_ = self.gds_validate_string(caseNumber_, node, 'caseNumber')
            self.caseNumber = caseNumber_
        elif nodeName_ == 'attachmentHash':
            attachmentHash_ = child_.text
            attachmentHash_ = self.gds_validate_string(attachmentHash_, node, 'attachmentHash')
            self.attachmentHash = attachmentHash_
        elif nodeName_ == 'deprecated':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'deprecated')
            self.deprecated = ival_
        elif nodeName_ == 'hash':
            hash_ = child_.text
            hash_ = self.gds_validate_string(hash_, node, 'hash')
            self.hash = hash_
        elif nodeName_ == 'SystemProfileCategory':
            obj_ = SystemProfileCategory.factory()
            obj_.build(child_)
            self.SystemProfileCategory.append(obj_)
        super(systemProfile, self).buildChildren(child_, node, nodeName_, True)
# end class systemProfile


class symptoms(strataEntity):
    """A list of Symptoms."""
    subclass = None
    superclass = strataEntity
    def __init__(self, symptom=None):
        super(symptoms, self).__init__()
        if symptom is None:
            self.symptom = []
        else:
            self.symptom = symptom
    def factory(*args_, **kwargs_):
        if symptoms.subclass:
            return symptoms.subclass(*args_, **kwargs_)
        else:
            return symptoms(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_symptom(self): return self.symptom
    def set_symptom(self, symptom): self.symptom = symptom
    def add_symptom(self, value): self.symptom.append(value)
    def insert_symptom(self, index, value): self.symptom[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='symptoms', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='symptoms')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='symptoms'):
        super(symptoms, self).exportAttributes(outfile, level, already_processed, namespace_, name_='symptoms')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='symptoms', fromsubclass_=False):
        super(symptoms, self).exportChildren(outfile, level, namespace_, name_, True)
        for symptom_ in self.symptom:
            symptom_.export(outfile, level, namespace_, name_='symptom')
    def hasContent_(self):
        if (
            self.symptom or
            super(symptoms, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='symptoms'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(symptoms, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(symptoms, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('symptom=[\n')
        level += 1
        for symptom_ in self.symptom:
            showIndent(outfile, level)
            outfile.write('model_.symptom(\n')
            symptom_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(symptoms, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'symptom':
            obj_ = symptom.factory()
            obj_.build(child_)
            self.symptom.append(obj_)
        super(symptoms, self).buildChildren(child_, node, nodeName_, True)
# end class symptoms


class symptom(trackedEntity):
    """symptom and related meta data."""
    subclass = None
    superclass = trackedEntity
    def __init__(self, createdBy=None, createdDate=None, lastModifiedBy=None, lastModifiedDate=None, caseNumber=None, category=None, data=None, description=None, display=None, location=None, problemSymptomParameters=None, summary=None, timestamp=None, uri=None):
        super(symptom, self).__init__(createdBy, createdDate, lastModifiedBy, lastModifiedDate,)
        self.caseNumber = caseNumber
        self.category = category
        self.data = data
        self.description = description
        self.display = display
        self.location = location
        if problemSymptomParameters is None:
            self.problemSymptomParameters = []
        else:
            self.problemSymptomParameters = problemSymptomParameters
        self.summary = summary
        self.timestamp = timestamp
        self.uri = uri
    def factory(*args_, **kwargs_):
        if symptom.subclass:
            return symptom.subclass(*args_, **kwargs_)
        else:
            return symptom(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_caseNumber(self): return self.caseNumber
    def set_caseNumber(self, caseNumber): self.caseNumber = caseNumber
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_data(self): return self.data
    def set_data(self, data): self.data = data
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_location(self): return self.location
    def set_location(self, location): self.location = location
    def get_problemSymptomParameters(self): return self.problemSymptomParameters
    def set_problemSymptomParameters(self, problemSymptomParameters): self.problemSymptomParameters = problemSymptomParameters
    def add_problemSymptomParameters(self, value): self.problemSymptomParameters.append(value)
    def insert_problemSymptomParameters(self, index, value): self.problemSymptomParameters[index] = value
    def get_summary(self): return self.summary
    def set_summary(self, summary): self.summary = summary
    def get_timestamp(self): return self.timestamp
    def set_timestamp(self, timestamp): self.timestamp = timestamp
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def export(self, outfile, level, namespace_='tns:', name_='symptom', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='symptom')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='symptom'):
        super(symptom, self).exportAttributes(outfile, level, already_processed, namespace_, name_='symptom')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='symptom', fromsubclass_=False):
        super(symptom, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.caseNumber is not None:
            showIndent(outfile, level)
            outfile.write('<%scaseNumber>%s</%scaseNumber>\n' % (namespace_, self.gds_format_string(quote_xml(self.caseNumber).encode(ExternalEncoding), input_name='caseNumber'), namespace_))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('<%scategory>%s</%scategory>\n' % (namespace_, self.gds_format_string(quote_xml(self.category).encode(ExternalEncoding), input_name='category'), namespace_))
        if self.data is not None:
            showIndent(outfile, level)
            outfile.write('<%sdata>%s</%sdata>\n' % (namespace_, self.gds_format_string(quote_xml(self.data).encode(ExternalEncoding), input_name='data'), namespace_))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('<%sdescription>%s</%sdescription>\n' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_))
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('<%sdisplay>%s</%sdisplay>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.display)), input_name='display'), namespace_))
        if self.location is not None:
            showIndent(outfile, level)
            outfile.write('<%slocation>%s</%slocation>\n' % (namespace_, self.gds_format_string(quote_xml(self.location).encode(ExternalEncoding), input_name='location'), namespace_))
        for problemSymptomParameters_ in self.problemSymptomParameters:
            problemSymptomParameters_.export(outfile, level, namespace_, name_='problemSymptomParameters')
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('<%ssummary>%s</%ssummary>\n' % (namespace_, self.gds_format_string(quote_xml(self.summary).encode(ExternalEncoding), input_name='summary'), namespace_))
        if self.timestamp is not None:
            showIndent(outfile, level)
            outfile.write('<%stimestamp>%s</%stimestamp>\n' % (namespace_, self.gds_format_string(quote_xml(self.timestamp).encode(ExternalEncoding), input_name='timestamp'), namespace_))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('<%suri>%s</%suri>\n' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_))
    def hasContent_(self):
        if (
            self.caseNumber is not None or
            self.category is not None or
            self.data is not None or
            self.description is not None or
            self.display is not None or
            self.location is not None or
            self.problemSymptomParameters or
            self.summary is not None or
            self.timestamp is not None or
            self.uri is not None or
            super(symptom, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='symptom'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(symptom, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(symptom, self).exportLiteralChildren(outfile, level, name_)
        if self.caseNumber is not None:
            showIndent(outfile, level)
            outfile.write('caseNumber=%s,\n' % quote_python(self.caseNumber).encode(ExternalEncoding))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category=%s,\n' % quote_python(self.category).encode(ExternalEncoding))
        if self.data is not None:
            showIndent(outfile, level)
            outfile.write('data=%s,\n' % quote_python(self.data).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=%s,\n' % self.display)
        if self.location is not None:
            showIndent(outfile, level)
            outfile.write('location=%s,\n' % quote_python(self.location).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('problemSymptomParameters=[\n')
        level += 1
        for problemSymptomParameters_ in self.problemSymptomParameters:
            showIndent(outfile, level)
            outfile.write('model_.problemSymptomParameters(\n')
            problemSymptomParameters_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('summary=%s,\n' % quote_python(self.summary).encode(ExternalEncoding))
        if self.timestamp is not None:
            showIndent(outfile, level)
            outfile.write('timestamp=%s,\n' % quote_python(self.timestamp).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(symptom, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'caseNumber':
            caseNumber_ = child_.text
            caseNumber_ = self.gds_validate_string(caseNumber_, node, 'caseNumber')
            self.caseNumber = caseNumber_
        elif nodeName_ == 'category':
            category_ = child_.text
            category_ = self.gds_validate_string(category_, node, 'category')
            self.category = category_
        elif nodeName_ == 'data':
            data_ = child_.text
            data_ = self.gds_validate_string(data_, node, 'data')
            self.data = data_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'display':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'display')
            self.display = ival_
        elif nodeName_ == 'location':
            location_ = child_.text
            location_ = self.gds_validate_string(location_, node, 'location')
            self.location = location_
        elif nodeName_ == 'problemSymptomParameters':
            obj_ = problemSymptomParameters.factory()
            obj_.build(child_)
            self.problemSymptomParameters.append(obj_)
        elif nodeName_ == 'summary':
            summary_ = child_.text
            summary_ = self.gds_validate_string(summary_, node, 'summary')
            self.summary = summary_
        elif nodeName_ == 'timestamp':
            timestamp_ = child_.text
            timestamp_ = self.gds_validate_string(timestamp_, node, 'timestamp')
            self.timestamp = timestamp_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(symptom, self).buildChildren(child_, node, nodeName_, True)
# end class symptom


class problemSymptomParameters(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if problemSymptomParameters.subclass:
            return problemSymptomParameters.subclass(*args_, **kwargs_)
        else:
            return problemSymptomParameters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def export(self, outfile, level, namespace_='tns:', name_='problemSymptomParameters', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='problemSymptomParameters')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='problemSymptomParameters'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='problemSymptomParameters', fromsubclass_=False):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('<%skey>%s</%skey>\n' % (namespace_, self.gds_format_string(quote_xml(self.key).encode(ExternalEncoding), input_name='key'), namespace_))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('<%svalue>%s</%svalue>\n' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_))
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='problemSymptomParameters'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class problemSymptomParameters


class SystemProfileCategory(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, SystemProfileCategoryName=None, SystemProfileCategorySummary=None, SystemProfileCategoryDetails=None):
        self.SystemProfileCategoryName = SystemProfileCategoryName
        self.SystemProfileCategorySummary = SystemProfileCategorySummary
        if SystemProfileCategoryDetails is None:
            self.SystemProfileCategoryDetails = []
        else:
            self.SystemProfileCategoryDetails = SystemProfileCategoryDetails
    def factory(*args_, **kwargs_):
        if SystemProfileCategory.subclass:
            return SystemProfileCategory.subclass(*args_, **kwargs_)
        else:
            return SystemProfileCategory(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SystemProfileCategoryName(self): return self.SystemProfileCategoryName
    def set_SystemProfileCategoryName(self, SystemProfileCategoryName): self.SystemProfileCategoryName = SystemProfileCategoryName
    def get_SystemProfileCategorySummary(self): return self.SystemProfileCategorySummary
    def set_SystemProfileCategorySummary(self, SystemProfileCategorySummary): self.SystemProfileCategorySummary = SystemProfileCategorySummary
    def get_SystemProfileCategoryDetails(self): return self.SystemProfileCategoryDetails
    def set_SystemProfileCategoryDetails(self, SystemProfileCategoryDetails): self.SystemProfileCategoryDetails = SystemProfileCategoryDetails
    def add_SystemProfileCategoryDetails(self, value): self.SystemProfileCategoryDetails.append(value)
    def insert_SystemProfileCategoryDetails(self, index, value): self.SystemProfileCategoryDetails[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='SystemProfileCategory', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SystemProfileCategory')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='SystemProfileCategory'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='SystemProfileCategory', fromsubclass_=False):
        if self.SystemProfileCategoryName is not None:
            showIndent(outfile, level)
            outfile.write('<%sSystemProfileCategoryName>%s</%sSystemProfileCategoryName>\n' % (namespace_, self.gds_format_string(quote_xml(self.SystemProfileCategoryName).encode(ExternalEncoding), input_name='SystemProfileCategoryName'), namespace_))
        if self.SystemProfileCategorySummary is not None:
            showIndent(outfile, level)
            outfile.write('<%sSystemProfileCategorySummary>%s</%sSystemProfileCategorySummary>\n' % (namespace_, self.gds_format_string(quote_xml(self.SystemProfileCategorySummary).encode(ExternalEncoding), input_name='SystemProfileCategorySummary'), namespace_))
        for SystemProfileCategoryDetails_ in self.SystemProfileCategoryDetails:
            SystemProfileCategoryDetails_.export(outfile, level, namespace_, name_='SystemProfileCategoryDetails')
    def hasContent_(self):
        if (
            self.SystemProfileCategoryName is not None or
            self.SystemProfileCategorySummary is not None or
            self.SystemProfileCategoryDetails
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SystemProfileCategory'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.SystemProfileCategoryName is not None:
            showIndent(outfile, level)
            outfile.write('SystemProfileCategoryName=%s,\n' % quote_python(self.SystemProfileCategoryName).encode(ExternalEncoding))
        if self.SystemProfileCategorySummary is not None:
            showIndent(outfile, level)
            outfile.write('SystemProfileCategorySummary=%s,\n' % quote_python(self.SystemProfileCategorySummary).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('SystemProfileCategoryDetails=[\n')
        level += 1
        for SystemProfileCategoryDetails_ in self.SystemProfileCategoryDetails:
            showIndent(outfile, level)
            outfile.write('model_.SystemProfileCategoryDetails(\n')
            SystemProfileCategoryDetails_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SystemProfileCategoryName':
            SystemProfileCategoryName_ = child_.text
            SystemProfileCategoryName_ = self.gds_validate_string(SystemProfileCategoryName_, node, 'SystemProfileCategoryName')
            self.SystemProfileCategoryName = SystemProfileCategoryName_
        elif nodeName_ == 'SystemProfileCategorySummary':
            SystemProfileCategorySummary_ = child_.text
            SystemProfileCategorySummary_ = self.gds_validate_string(SystemProfileCategorySummary_, node, 'SystemProfileCategorySummary')
            self.SystemProfileCategorySummary = SystemProfileCategorySummary_
        elif nodeName_ == 'SystemProfileCategoryDetails':
            obj_ = SystemProfileCategoryDetails.factory()
            obj_.build(child_)
            self.SystemProfileCategoryDetails.append(obj_)
# end class SystemProfileCategory


class SystemProfileCategoryDetails(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if SystemProfileCategoryDetails.subclass:
            return SystemProfileCategoryDetails.subclass(*args_, **kwargs_)
        else:
            return SystemProfileCategoryDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def export(self, outfile, level, namespace_='tns:', name_='SystemProfileCategoryDetails', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SystemProfileCategoryDetails')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='SystemProfileCategoryDetails'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='SystemProfileCategoryDetails', fromsubclass_=False):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('<%skey>%s</%skey>\n' % (namespace_, self.gds_format_string(quote_xml(self.key).encode(ExternalEncoding), input_name='key'), namespace_))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('<%svalue>%s</%svalue>\n' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_))
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SystemProfileCategoryDetails'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class SystemProfileCategoryDetails


class caseFilter(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, endDate=None, accountNumber=None, includeClosed=None, groupNumbers=None, includePrivate=None, keyword=None, count=None, start=None, onlyUngrouped=None, ownerSSOName=None, product=None, severity=None, sortField=None, sortOrder=None, startDate=None, status=None, type_=None):
        self.endDate = endDate
        self.accountNumber = accountNumber
        self.includeClosed = includeClosed
        self.groupNumbers = groupNumbers
        self.includePrivate = includePrivate
        self.keyword = keyword
        self.count = count
        self.start = start
        self.onlyUngrouped = onlyUngrouped
        self.ownerSSOName = ownerSSOName
        self.product = product
        self.severity = severity
        self.sortField = sortField
        self.sortOrder = sortOrder
        self.startDate = startDate
        self.status = status
        self.type_ = type_
    def factory(*args_, **kwargs_):
        if caseFilter.subclass:
            return caseFilter.subclass(*args_, **kwargs_)
        else:
            return caseFilter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_endDate(self): return self.endDate
    def set_endDate(self, endDate): self.endDate = endDate
    def get_accountNumber(self): return self.accountNumber
    def set_accountNumber(self, accountNumber): self.accountNumber = accountNumber
    def get_includeClosed(self): return self.includeClosed
    def set_includeClosed(self, includeClosed): self.includeClosed = includeClosed
    def get_groupNumbers(self): return self.groupNumbers
    def set_groupNumbers(self, groupNumbers): self.groupNumbers = groupNumbers
    def get_includePrivate(self): return self.includePrivate
    def set_includePrivate(self, includePrivate): self.includePrivate = includePrivate
    def get_keyword(self): return self.keyword
    def set_keyword(self, keyword): self.keyword = keyword
    def get_count(self): return self.count
    def set_count(self, count): self.count = count
    def get_start(self): return self.start
    def set_start(self, start): self.start = start
    def get_onlyUngrouped(self): return self.onlyUngrouped
    def set_onlyUngrouped(self, onlyUngrouped): self.onlyUngrouped = onlyUngrouped
    def get_ownerSSOName(self): return self.ownerSSOName
    def set_ownerSSOName(self, ownerSSOName): self.ownerSSOName = ownerSSOName
    def get_product(self): return self.product
    def set_product(self, product): self.product = product
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def get_sortField(self): return self.sortField
    def set_sortField(self, sortField): self.sortField = sortField
    def get_sortOrder(self): return self.sortOrder
    def set_sortOrder(self, sortOrder): self.sortOrder = sortOrder
    def get_startDate(self): return self.startDate
    def set_startDate(self, startDate): self.startDate = startDate
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='tns:', name_='caseFilter', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='caseFilter')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='caseFilter'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='caseFilter', fromsubclass_=False):
        if self.endDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sendDate>%s</%sendDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.endDate).encode(ExternalEncoding), input_name='endDate'), namespace_))
        if self.accountNumber is not None:
            showIndent(outfile, level)
            outfile.write('<%saccountNumber>%s</%saccountNumber>\n' % (namespace_, self.gds_format_string(quote_xml(self.accountNumber).encode(ExternalEncoding), input_name='accountNumber'), namespace_))
        if self.includeClosed is not None:
            showIndent(outfile, level)
            outfile.write('<%sincludeClosed>%s</%sincludeClosed>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.includeClosed)), input_name='includeClosed'), namespace_))
        if self.groupNumbers is not None:
            self.groupNumbers.export(outfile, level, namespace_, name_='groupNumbers',)
        if self.includePrivate is not None:
            showIndent(outfile, level)
            outfile.write('<%sincludePrivate>%s</%sincludePrivate>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.includePrivate)), input_name='includePrivate'), namespace_))
        if self.keyword is not None:
            showIndent(outfile, level)
            outfile.write('<%skeyword>%s</%skeyword>\n' % (namespace_, self.gds_format_string(quote_xml(self.keyword).encode(ExternalEncoding), input_name='keyword'), namespace_))
        if self.count is not None:
            showIndent(outfile, level)
            outfile.write('<%scount>%s</%scount>\n' % (namespace_, self.gds_format_integer(self.count, input_name='count'), namespace_))
        if self.start is not None:
            showIndent(outfile, level)
            outfile.write('<%sstart>%s</%sstart>\n' % (namespace_, self.gds_format_integer(self.start, input_name='start'), namespace_))
        if self.onlyUngrouped is not None:
            showIndent(outfile, level)
            outfile.write('<%sonlyUngrouped>%s</%sonlyUngrouped>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.onlyUngrouped)), input_name='onlyUngrouped'), namespace_))
        if self.ownerSSOName is not None:
            showIndent(outfile, level)
            outfile.write('<%sownerSSOName>%s</%sownerSSOName>\n' % (namespace_, self.gds_format_string(quote_xml(self.ownerSSOName).encode(ExternalEncoding), input_name='ownerSSOName'), namespace_))
        if self.product is not None:
            showIndent(outfile, level)
            outfile.write('<%sproduct>%s</%sproduct>\n' % (namespace_, self.gds_format_string(quote_xml(self.product).encode(ExternalEncoding), input_name='product'), namespace_))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('<%sseverity>%s</%sseverity>\n' % (namespace_, self.gds_format_string(quote_xml(self.severity).encode(ExternalEncoding), input_name='severity'), namespace_))
        if self.sortField is not None:
            showIndent(outfile, level)
            outfile.write('<%ssortField>%s</%ssortField>\n' % (namespace_, self.gds_format_string(quote_xml(self.sortField).encode(ExternalEncoding), input_name='sortField'), namespace_))
        if self.sortOrder is not None:
            showIndent(outfile, level)
            outfile.write('<%ssortOrder>%s</%ssortOrder>\n' % (namespace_, self.gds_format_string(quote_xml(self.sortOrder).encode(ExternalEncoding), input_name='sortOrder'), namespace_))
        if self.startDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sstartDate>%s</%sstartDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.startDate).encode(ExternalEncoding), input_name='startDate'), namespace_))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('<%sstatus>%s</%sstatus>\n' % (namespace_, self.gds_format_string(quote_xml(self.status).encode(ExternalEncoding), input_name='status'), namespace_))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
    def hasContent_(self):
        if (
            self.endDate is not None or
            self.accountNumber is not None or
            self.includeClosed is not None or
            self.groupNumbers is not None or
            self.includePrivate is not None or
            self.keyword is not None or
            self.count is not None or
            self.start is not None or
            self.onlyUngrouped is not None or
            self.ownerSSOName is not None or
            self.product is not None or
            self.severity is not None or
            self.sortField is not None or
            self.sortOrder is not None or
            self.startDate is not None or
            self.status is not None or
            self.type_ is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='caseFilter'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.endDate is not None:
            showIndent(outfile, level)
            outfile.write('endDate=%s,\n' % quote_python(self.endDate).encode(ExternalEncoding))
        if self.accountNumber is not None:
            showIndent(outfile, level)
            outfile.write('accountNumber=%s,\n' % quote_python(self.accountNumber).encode(ExternalEncoding))
        if self.includeClosed is not None:
            showIndent(outfile, level)
            outfile.write('includeClosed=%s,\n' % self.includeClosed)
        if self.groupNumbers is not None:
            showIndent(outfile, level)
            outfile.write('groupNumbers=model_.groupNumbers(\n')
            self.groupNumbers.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.includePrivate is not None:
            showIndent(outfile, level)
            outfile.write('includePrivate=%s,\n' % self.includePrivate)
        if self.keyword is not None:
            showIndent(outfile, level)
            outfile.write('keyword=%s,\n' % quote_python(self.keyword).encode(ExternalEncoding))
        if self.count is not None:
            showIndent(outfile, level)
            outfile.write('count=%d,\n' % self.count)
        if self.start is not None:
            showIndent(outfile, level)
            outfile.write('start=%d,\n' % self.start)
        if self.onlyUngrouped is not None:
            showIndent(outfile, level)
            outfile.write('onlyUngrouped=%s,\n' % self.onlyUngrouped)
        if self.ownerSSOName is not None:
            showIndent(outfile, level)
            outfile.write('ownerSSOName=%s,\n' % quote_python(self.ownerSSOName).encode(ExternalEncoding))
        if self.product is not None:
            showIndent(outfile, level)
            outfile.write('product=%s,\n' % quote_python(self.product).encode(ExternalEncoding))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('severity=%s,\n' % quote_python(self.severity).encode(ExternalEncoding))
        if self.sortField is not None:
            showIndent(outfile, level)
            outfile.write('sortField=%s,\n' % quote_python(self.sortField).encode(ExternalEncoding))
        if self.sortOrder is not None:
            showIndent(outfile, level)
            outfile.write('sortOrder=%s,\n' % quote_python(self.sortOrder).encode(ExternalEncoding))
        if self.startDate is not None:
            showIndent(outfile, level)
            outfile.write('startDate=%s,\n' % quote_python(self.startDate).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=%s,\n' % quote_python(self.status).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'endDate':
            endDate_ = child_.text
            endDate_ = self.gds_validate_string(endDate_, node, 'endDate')
            self.endDate = endDate_
        elif nodeName_ == 'accountNumber':
            accountNumber_ = child_.text
            accountNumber_ = self.gds_validate_string(accountNumber_, node, 'accountNumber')
            self.accountNumber = accountNumber_
        elif nodeName_ == 'includeClosed':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'includeClosed')
            self.includeClosed = ival_
        elif nodeName_ == 'groupNumbers':
            obj_ = groupNumbers.factory()
            obj_.build(child_)
            self.set_groupNumbers(obj_)
        elif nodeName_ == 'includePrivate':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'includePrivate')
            self.includePrivate = ival_
        elif nodeName_ == 'keyword':
            keyword_ = child_.text
            keyword_ = self.gds_validate_string(keyword_, node, 'keyword')
            self.keyword = keyword_
        elif nodeName_ == 'count':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'count')
            self.count = ival_
        elif nodeName_ == 'start':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'start')
            self.start = ival_
        elif nodeName_ == 'onlyUngrouped':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'onlyUngrouped')
            self.onlyUngrouped = ival_
        elif nodeName_ == 'ownerSSOName':
            ownerSSOName_ = child_.text
            ownerSSOName_ = self.gds_validate_string(ownerSSOName_, node, 'ownerSSOName')
            self.ownerSSOName = ownerSSOName_
        elif nodeName_ == 'product':
            product_ = child_.text
            product_ = self.gds_validate_string(product_, node, 'product')
            self.product = product_
        elif nodeName_ == 'severity':
            severity_ = child_.text
            severity_ = self.gds_validate_string(severity_, node, 'severity')
            self.severity = severity_
        elif nodeName_ == 'sortField':
            sortField_ = child_.text
            sortField_ = self.gds_validate_string(sortField_, node, 'sortField')
            self.sortField = sortField_
        elif nodeName_ == 'sortOrder':
            sortOrder_ = child_.text
            sortOrder_ = self.gds_validate_string(sortOrder_, node, 'sortOrder')
            self.sortOrder = sortOrder_
        elif nodeName_ == 'startDate':
            startDate_ = child_.text
            startDate_ = self.gds_validate_string(startDate_, node, 'startDate')
            self.startDate = startDate_
        elif nodeName_ == 'status':
            status_ = child_.text
            status_ = self.gds_validate_string(status_, node, 'status')
            self.status = status_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
# end class caseFilter


class groupNumbers(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, groupNumber=None):
        if groupNumber is None:
            self.groupNumber = []
        else:
            self.groupNumber = groupNumber
    def factory(*args_, **kwargs_):
        if groupNumbers.subclass:
            return groupNumbers.subclass(*args_, **kwargs_)
        else:
            return groupNumbers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_groupNumber(self): return self.groupNumber
    def set_groupNumber(self, groupNumber): self.groupNumber = groupNumber
    def add_groupNumber(self, value): self.groupNumber.append(value)
    def insert_groupNumber(self, index, value): self.groupNumber[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='groupNumbers', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='groupNumbers')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='groupNumbers'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='groupNumbers', fromsubclass_=False):
        for groupNumber_ in self.groupNumber:
            showIndent(outfile, level)
            outfile.write('<%sgroupNumber>%s</%sgroupNumber>\n' % (namespace_, self.gds_format_string(quote_xml(groupNumber_).encode(ExternalEncoding), input_name='groupNumber'), namespace_))
    def hasContent_(self):
        if (
            self.groupNumber
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='groupNumbers'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('groupNumber=[\n')
        level += 1
        for groupNumber_ in self.groupNumber:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(groupNumber_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'groupNumber':
            groupNumber_ = child_.text
            groupNumber_ = self.gds_validate_string(groupNumber_, node, 'groupNumber')
            self.groupNumber.append(groupNumber_)
# end class groupNumbers


class solutionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, solutionId=None, rel='solution', valueOf_=None):
        self.solutionId = _cast(None, solutionId)
        self.rel = _cast(None, rel)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if solutionType.subclass:
            return solutionType.subclass(*args_, **kwargs_)
        else:
            return solutionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_solutionId(self): return self.solutionId
    def set_solutionId(self, solutionId): self.solutionId = solutionId
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='tns:', name_='solutionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='solutionType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='solutionType'):
        if self.solutionId is not None and 'solutionId' not in already_processed:
            already_processed.append('solutionId')
            outfile.write(' solutionId=%s' % (self.gds_format_string(quote_attrib(self.solutionId).encode(ExternalEncoding), input_name='solutionId'),))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'),))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='solutionType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='solutionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.solutionId is not None and 'solutionId' not in already_processed:
            already_processed.append('solutionId')
            showIndent(outfile, level)
            outfile.write('solutionId = "%s",\n' % (self.solutionId,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            showIndent(outfile, level)
            outfile.write('rel = "%s",\n' % (self.rel,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('solutionId', node)
        if value is not None and 'solutionId' not in already_processed:
            already_processed.append('solutionId')
            self.solutionId = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            self.rel = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class solutionType


class issueType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if issueType.subclass:
            return issueType.subclass(*args_, **kwargs_)
        else:
            return issueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='issueType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='issueType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='issueType'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='issueType', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='issueType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class issueType


class environmentType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if environmentType.subclass:
            return environmentType.subclass(*args_, **kwargs_)
        else:
            return environmentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='environmentType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='environmentType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='environmentType'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='environmentType', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='environmentType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class environmentType


class resolutionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if resolutionType.subclass:
            return resolutionType.subclass(*args_, **kwargs_)
        else:
            return resolutionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='resolutionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='resolutionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='resolutionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='resolutionType', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='resolutionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class resolutionType


class rootCauseType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if rootCauseType.subclass:
            return rootCauseType.subclass(*args_, **kwargs_)
        else:
            return rootCauseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='rootCauseType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='rootCauseType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='rootCauseType'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='rootCauseType', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='rootCauseType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class rootCauseType


class internalDiagnosticStepsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if internalDiagnosticStepsType.subclass:
            return internalDiagnosticStepsType.subclass(*args_, **kwargs_)
        else:
            return internalDiagnosticStepsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='internalDiagnosticStepsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='internalDiagnosticStepsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='internalDiagnosticStepsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='internalDiagnosticStepsType', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='internalDiagnosticStepsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class internalDiagnosticStepsType


class tagType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if tagType.subclass:
            return tagType.subclass(*args_, **kwargs_)
        else:
            return tagType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='tagType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tagType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='tagType'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='tagType', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='tagType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class tagType


class duplicateOfType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, solutionId=None, rel='solution', valueOf_=None):
        self.solutionId = _cast(None, solutionId)
        self.rel = _cast(None, rel)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if duplicateOfType.subclass:
            return duplicateOfType.subclass(*args_, **kwargs_)
        else:
            return duplicateOfType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_solutionId(self): return self.solutionId
    def set_solutionId(self, solutionId): self.solutionId = solutionId
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='tns:', name_='duplicateOfType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='duplicateOfType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='duplicateOfType'):
        if self.solutionId is not None and 'solutionId' not in already_processed:
            already_processed.append('solutionId')
            outfile.write(' solutionId=%s' % (self.gds_format_string(quote_attrib(self.solutionId).encode(ExternalEncoding), input_name='solutionId'),))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'),))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='duplicateOfType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='duplicateOfType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.solutionId is not None and 'solutionId' not in already_processed:
            already_processed.append('solutionId')
            showIndent(outfile, level)
            outfile.write('solutionId = "%s",\n' % (self.solutionId,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            showIndent(outfile, level)
            outfile.write('rel = "%s",\n' % (self.rel,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('solutionId', node)
        if value is not None and 'solutionId' not in already_processed:
            already_processed.append('solutionId')
            self.solutionId = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            self.rel = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class duplicateOfType


class bodyType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if bodyType.subclass:
            return bodyType.subclass(*args_, **kwargs_)
        else:
            return bodyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='bodyType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='bodyType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='bodyType'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='bodyType', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='bodyType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class bodyType


class sbrsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, sbr=None):
        if sbr is None:
            self.sbr = []
        else:
            self.sbr = sbr
    def factory(*args_, **kwargs_):
        if sbrsType.subclass:
            return sbrsType.subclass(*args_, **kwargs_)
        else:
            return sbrsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sbr(self): return self.sbr
    def set_sbr(self, sbr): self.sbr = sbr
    def add_sbr(self, value): self.sbr.append(value)
    def insert_sbr(self, index, value): self.sbr[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='sbrsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sbrsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='sbrsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='sbrsType', fromsubclass_=False):
        for sbr_ in self.sbr:
            showIndent(outfile, level)
            outfile.write('<%ssbr>%s</%ssbr>\n' % (namespace_, self.gds_format_string(quote_xml(sbr_).encode(ExternalEncoding), input_name='sbr'), namespace_))
    def hasContent_(self):
        if (
            self.sbr
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='sbrsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('sbr=[\n')
        level += 1
        for sbr_ in self.sbr:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(sbr_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sbr':
            sbr_ = child_.text
            sbr_ = self.gds_validate_string(sbr_, node, 'sbr')
            self.sbr.append(sbr_)
# end class sbrsType


class productsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, product=None):
        if product is None:
            self.product = []
        else:
            self.product = product
    def factory(*args_, **kwargs_):
        if productsType.subclass:
            return productsType.subclass(*args_, **kwargs_)
        else:
            return productsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_product(self): return self.product
    def set_product(self, product): self.product = product
    def add_product(self, value): self.product.append(value)
    def insert_product(self, index, value): self.product[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='productsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='productsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='productsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='productsType', fromsubclass_=False):
        for product_ in self.product:
            showIndent(outfile, level)
            outfile.write('<%sproduct>%s</%sproduct>\n' % (namespace_, self.gds_format_string(quote_xml(product_).encode(ExternalEncoding), input_name='product'), namespace_))
    def hasContent_(self):
        if (
            self.product
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='productsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('product=[\n')
        level += 1
        for product_ in self.product:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(product_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'product':
            product_ = child_.text
            product_ = self.gds_validate_string(product_, node, 'product')
            self.product.append(product_)
# end class productsType


class issueType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if issueType1.subclass:
            return issueType1.subclass(*args_, **kwargs_)
        else:
            return issueType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='issueType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='issueType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='issueType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='issueType1', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='issueType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class issueType1


class environmentType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if environmentType1.subclass:
            return environmentType1.subclass(*args_, **kwargs_)
        else:
            return environmentType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='environmentType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='environmentType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='environmentType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='environmentType1', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='environmentType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class environmentType1


class resolutionType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if resolutionType1.subclass:
            return resolutionType1.subclass(*args_, **kwargs_)
        else:
            return resolutionType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='resolutionType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='resolutionType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='resolutionType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='resolutionType1', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='resolutionType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class resolutionType1


class rootCauseType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if rootCauseType1.subclass:
            return rootCauseType1.subclass(*args_, **kwargs_)
        else:
            return rootCauseType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='rootCauseType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='rootCauseType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='rootCauseType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='rootCauseType1', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='rootCauseType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class rootCauseType1


class internalDiagnosticStepsType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if internalDiagnosticStepsType1.subclass:
            return internalDiagnosticStepsType1.subclass(*args_, **kwargs_)
        else:
            return internalDiagnosticStepsType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='internalDiagnosticStepsType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='internalDiagnosticStepsType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='internalDiagnosticStepsType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='internalDiagnosticStepsType1', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='internalDiagnosticStepsType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class internalDiagnosticStepsType1


class articleBodyType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if articleBodyType.subclass:
            return articleBodyType.subclass(*args_, **kwargs_)
        else:
            return articleBodyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='articleBodyType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='articleBodyType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='articleBodyType'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='articleBodyType', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='articleBodyType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class articleBodyType


class tagType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html
    def factory(*args_, **kwargs_):
        if tagType1.subclass:
            return tagType1.subclass(*args_, **kwargs_)
        else:
            return tagType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_html(self): return self.html
    def set_html(self, html): self.html = html
    def export(self, outfile, level, namespace_='tns:', name_='tagType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tagType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='tagType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='tagType1', fromsubclass_=False):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('<%stext>%s</%stext>\n' % (namespace_, self.gds_format_string(quote_xml(self.text).encode(ExternalEncoding), input_name='text'), namespace_))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('<%shtml>%s</%shtml>\n' % (namespace_, self.gds_format_string(quote_xml(self.html).encode(ExternalEncoding), input_name='html'), namespace_))
    def hasContent_(self):
        if (
            self.text is not None or
            self.html is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='tagType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.text is not None:
            showIndent(outfile, level)
            outfile.write('text=%s,\n' % quote_python(self.text).encode(ExternalEncoding))
        if self.html is not None:
            showIndent(outfile, level)
            outfile.write('html=%s,\n' % quote_python(self.html).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'text':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'text')
            self.text = text_
        elif nodeName_ == 'html':
            html_ = child_.text
            html_ = self.gds_validate_string(html_, node, 'html')
            self.html = html_
# end class tagType1


class duplicateOfType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, solutionId=None, rel='solution', valueOf_=None):
        self.solutionId = _cast(None, solutionId)
        self.rel = _cast(None, rel)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if duplicateOfType1.subclass:
            return duplicateOfType1.subclass(*args_, **kwargs_)
        else:
            return duplicateOfType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_solutionId(self): return self.solutionId
    def set_solutionId(self, solutionId): self.solutionId = solutionId
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='tns:', name_='duplicateOfType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='duplicateOfType1')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='duplicateOfType1'):
        if self.solutionId is not None and 'solutionId' not in already_processed:
            already_processed.append('solutionId')
            outfile.write(' solutionId=%s' % (self.gds_format_string(quote_attrib(self.solutionId).encode(ExternalEncoding), input_name='solutionId'),))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'),))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='duplicateOfType1', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='duplicateOfType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.solutionId is not None and 'solutionId' not in already_processed:
            already_processed.append('solutionId')
            showIndent(outfile, level)
            outfile.write('solutionId = "%s",\n' % (self.solutionId,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            showIndent(outfile, level)
            outfile.write('rel = "%s",\n' % (self.rel,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('solutionId', node)
        if value is not None and 'solutionId' not in already_processed:
            already_processed.append('solutionId')
            self.solutionId = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            self.rel = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class duplicateOfType1


class sbrsType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, sbr=None):
        if sbr is None:
            self.sbr = []
        else:
            self.sbr = sbr
    def factory(*args_, **kwargs_):
        if sbrsType1.subclass:
            return sbrsType1.subclass(*args_, **kwargs_)
        else:
            return sbrsType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sbr(self): return self.sbr
    def set_sbr(self, sbr): self.sbr = sbr
    def add_sbr(self, value): self.sbr.append(value)
    def insert_sbr(self, index, value): self.sbr[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='sbrsType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sbrsType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='sbrsType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='sbrsType1', fromsubclass_=False):
        for sbr_ in self.sbr:
            showIndent(outfile, level)
            outfile.write('<%ssbr>%s</%ssbr>\n' % (namespace_, self.gds_format_string(quote_xml(sbr_).encode(ExternalEncoding), input_name='sbr'), namespace_))
    def hasContent_(self):
        if (
            self.sbr
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='sbrsType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('sbr=[\n')
        level += 1
        for sbr_ in self.sbr:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(sbr_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sbr':
            sbr_ = child_.text
            sbr_ = self.gds_validate_string(sbr_, node, 'sbr')
            self.sbr.append(sbr_)
# end class sbrsType1


class tagsType2(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, tag=None):
        if tag is None:
            self.tag = []
        else:
            self.tag = tag
    def factory(*args_, **kwargs_):
        if tagsType2.subclass:
            return tagsType2.subclass(*args_, **kwargs_)
        else:
            return tagsType2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tag(self): return self.tag
    def set_tag(self, tag): self.tag = tag
    def add_tag(self, value): self.tag.append(value)
    def insert_tag(self, index, value): self.tag[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='tagsType2', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tagsType2')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='tagsType2'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='tagsType2', fromsubclass_=False):
        for tag_ in self.tag:
            showIndent(outfile, level)
            outfile.write('<%stag>%s</%stag>\n' % (namespace_, self.gds_format_string(quote_xml(tag_).encode(ExternalEncoding), input_name='tag'), namespace_))
    def hasContent_(self):
        if (
            self.tag
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='tagsType2'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('tag=[\n')
        level += 1
        for tag_ in self.tag:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(tag_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'tag':
            tag_ = child_.text
            tag_ = self.gds_validate_string(tag_, node, 'tag')
            self.tag.append(tag_)
# end class tagsType2


class productsType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, product=None):
        if product is None:
            self.product = []
        else:
            self.product = product
    def factory(*args_, **kwargs_):
        if productsType1.subclass:
            return productsType1.subclass(*args_, **kwargs_)
        else:
            return productsType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_product(self): return self.product
    def set_product(self, product): self.product = product
    def add_product(self, value): self.product.append(value)
    def insert_product(self, index, value): self.product[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='productsType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='productsType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='productsType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='productsType1', fromsubclass_=False):
        for product_ in self.product:
            showIndent(outfile, level)
            outfile.write('<%sproduct>%s</%sproduct>\n' % (namespace_, self.gds_format_string(quote_xml(product_).encode(ExternalEncoding), input_name='product'), namespace_))
    def hasContent_(self):
        if (
            self.product
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='productsType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('product=[\n')
        level += 1
        for product_ in self.product:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(product_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'product':
            product_ = child_.text
            product_ = self.gds_validate_string(product_, node, 'product')
            self.product.append(product_)
# end class productsType1


class valueType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, name=None, value=None):
        self.type_ = _cast(None, type_)
        self.name = name
        self.value = value
    def factory(*args_, **kwargs_):
        if valueType.subclass:
            return valueType.subclass(*args_, **kwargs_)
        else:
            return valueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='tns:', name_='valueType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='valueType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='valueType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'),))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='valueType', fromsubclass_=False):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('<%svalue>%s</%svalue>\n' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_))
    def hasContent_(self):
        if (
            self.name is not None or
            self.value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='valueType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class valueType


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    # rootClass = globals().get(tag)
    # Begin NOT_GENERATED
    # The api XSD does not define a single root tag.
    # We need to map the classes in this file to the possible
    # element roots in the XSD.
    # rootClass = globals().get(tag)
    rootClass = findRootClass(tag)
    # End NOT_GENERATED
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'strataEntity'
        rootClass = strataEntity
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='')
    return rootObj


def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'strataEntity'
        rootClass = strataEntity
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    # Begin NOT_GENERATED
    # Let's shut up the echoing of the received XML
    # to stdout.
#    sys.stdout.write('<?xml version="1.0" ?>\n')
#    rootObj.export(sys.stdout, 0, name_="link",
#        namespacedef_='')
    # End NOT_GENERATED
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'strataEntity'
        rootClass = strataEntity
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from params import *\n\n')
    sys.stdout.write('import params as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    # import pdb; pdb.set_trace()
    main()


__all__ = [
    "SystemProfileCategory",
    "SystemProfileCategoryDetails",
    "account",
    "article",
    "articleBodyType",
    "articles",
    "attachment",
    "attachments",
    "backtrace",
    "base_link",
    "bodyType",
    "case",
    "caseFilter",
    "cases",
    "comment",
    "comments",
    "duplicateOfType",
    "duplicateOfType1",
    "entitlement",
    "entitlements",
    "environmentType",
    "environmentType1",
    "error",
    "group",
    "groupNumbers",
    "groups",
    "internalDiagnosticStepsType",
    "internalDiagnosticStepsType1",
    "issueType",
    "issueType1",
    "link",
    "notified_users",
    "problem",
    "problemSymptomParameters",
    "problems",
    "product",
    "products",
    "productsType",
    "productsType1",
    "recommendation",
    "recommendations",
    "resolutionType",
    "resolutionType1",
    "rootCauseType",
    "rootCauseType1",
    "sbrsType",
    "sbrsType1",
    "solution",
    "solutionType",
    "solutions",
    "source",
    "sqiRating",
    "strataEntity",
    "suggested_artifact",
    "suggested_artifacts",
    "supportNeed",
    "symptom",
    "symptoms",
    "systemProfile",
    "systemProfiles",
    "tagType",
    "tagType1",
    "trackedEntity",
    "user",
    "users",
    "valueType",
    "values",
    "versions"
    ]

# Begin NOT_GENERATED
_rootClassMap = {
                "SystemProfileCategory"          : SystemProfileCategory,
                "SystemProfileCategoryDetails"   : SystemProfileCategoryDetails,
                "account"                        : account,
                "article"                        : article,
                "articleBodyType"                : articleBodyType,
                "articles"                       : articles,
                "attachment"                     : attachment,
                "attachments"                    : attachments,
                "backtrace"                      : backtrace,
                "base_link"                      : base_link,
                "bodyType"                       : bodyType,
                "case"                           : case,
                "caseFilter"                     : caseFilter,
                "cases"                          : cases,
                "comment"                        : comment,
                "comments"                       : comments,
                "duplicateOfType"                : duplicateOfType,
                "duplicateOfType1"               : duplicateOfType1,
                "entitlement"                    : entitlement,
                "entitlements"                   : entitlements,
                "environmentType"                : environmentType,
                "environmentType1"               : environmentType1,
                "error"                          : error,
                "group"                          : group,
                "groupNumbers"                   : groupNumbers,
                "groups"                         : groups,
                "internalDiagnosticStepsType"    : internalDiagnosticStepsType,
                "internalDiagnosticStepsType1"   : internalDiagnosticStepsType1,
                "issueType"                      : issueType,
                "issueType1"                     : issueType1,
                "link"                           : link,
                "notified_users"                 : notified_users,
                "problem"                        : problem,
                "problemSymptomParameters"       : problemSymptomParameters,
                "problems"                       : problems,
                "product"                        : product,
                "products"                       : products,
                "productsType"                   : productsType,
                "productsType1"                  : productsType1,
                "recommendation"                 : recommendation,
                "recommendations"                : recommendations,
                "resolutionType"                 : resolutionType,
                "resolutionType1"                : resolutionType1,
                "rootCauseType"                  : rootCauseType,
                "rootCauseType1"                 : rootCauseType1,
                "sbrsType"                       : sbrsType,
                "sbrsType1"                      : sbrsType1,
                "solution"                       : solution,
                "solutionType"                   : solutionType,
                "solutions"                      : solutions,
                "source"                         : source,
                "sqiRating"                      : sqiRating,
                "strataEntity"                   : strataEntity,
                "suggested_artifact"             : suggested_artifact,
                "suggested_artifacts"            : suggested_artifacts,
                "supportNeed"                    : supportNeed,
                "symptom"                        : symptom,
                "symptoms"                       : symptoms,
                "systemProfile"                  : systemProfile,
                "systemProfiles"                 : systemProfiles,
                "tagType"                        : tagType,
                "tagType1"                       : tagType1,
                "trackedEntity"                  : trackedEntity,
                "user"                           : user,
                "users"                          : users,
                "valueType"                      : valueType,
                "values"                         : values,
                "versions"                       : versions
    }
def findRootClass(rootTag):
    """
    Helper function that enables the generated code to locate the
    root element.  The api does not explicitly list a root
    element; hence, the generated code has a hard time deducing
    which one it actually is.  This function will map the first
    tag in the XML (i.e. the root) to an internal class.
    """
    res = _rootClassMap.get(rootTag)
    return res
# End NOT_GENERATED
