#
# Copyright (c) 2010 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#           http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#


class ConnectionError(Exception):
    def __init__(self, expect):
        Exception.__init__(self, 'Hydra API connection failure, %s' % expect)


class RequestError(Exception):
    def __init__(self, status, reason, response):
        self.status = status
        self.reason = reason
        self.response = response
        Exception.__init__(self, 'Hydra API request failure, %s' % response)


class ImmutableError(Exception):
    def __init__(self, key):
        Exception.__init__(self, 'Hydra error \'%s\' is immutable.' % key)


class S3UploadFailedError(Exception):
    def __init__(self, message=None):
        Exception.__init__(self, message)


class DontWaitForCompletion(Exception):
    def __init__(self, message=None):
        Exception.__init__(self, message)


class MetadataException(Exception):
    def __init__(self, message=None):
        Exception.__init__(self, message)


class SftpUploadWarnings(Exception):
    def __init__(self, message=None):
        Exception.__init__(self, message)


class SftpError(Exception):
    def __init__(self, message=None):
        Exception.__init__(self, message)
