%global         package_version 1.0.0-6
%global         package_name redhat-access-gui

Name:           %{package_name}
Version:        1.0.0
Release:        6%{?release_suffix}%{?dist}
Summary:        Red Hat Support Software Development Library
Vendor:         Red Hat, Inc.
Group:          Development/Libraries
License:        ASL 2.0
URL:            https://api.access.redhat.com
Source0:        http://people.redhat.com/dvarga/projects/redhat-access-gui/%{package_name}-%{package_version}.tar.gz

BuildRequires: python2-devel
BuildRequires: python-setuptools
BuildRequires: desktop-file-utils
BuildArch: noarch
%{!?dist:BuildRequires: buildsys-macros}


Requires: python
Requires: gtk3
Requires: redhat-support-lib-python

%if 0%{?rhel} && 0%{?rhel} <= 5
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
BuildRoot: %{_topdir}/BUILDROOT/%{name}-%{version}-%{release}.%{_arch}
%endif

%description
This package contains the Red Hat Access GUI.
The Red Hat Access GUI provides Gtk based access to
Red Hat's subscriber services. These services include, but are not limited to,
access to knowledge-base solutions.

%prep
%setup -q -n %{package_name}-%{package_version}

%build
%configure \
        --disable-python-syntax-check

make %{?_smp_mflags}

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"
desktop-file-install                                    \
--dir=${RPM_BUILD_ROOT}%{_datadir}/applications         \
data/redhat-access-gui.desktop
desktop-file-validate %{buildroot}/%{_datadir}/applications/redhat-access-gui.desktop

%files
%doc AUTHORS README
%{python_sitelib}/redhat_access_gui/
%{_bindir}/redhat-access-gui
/usr/share/applications/redhat-access-gui.desktop

%changelog
* Tue Feb 25 2014 Dan Varga <dvarga@redhat.com> - 1.0.0-6
- Fix treeview sensitivity
- Resolves: bz1042983

* Thu Feb 6 2014 Dan Varga <dvarga@redhat.com> - 1.0.0-5
- Multiple UI tweaks, additional helper text, login fix
- Resolves: bz1042928, bz1042940, bz1042983, bz1042988, bz1042931, bz1040394, bz1040361

* Fri Dec 27 2013 Daniel Mach <dmach@redhat.com> - 1.0.0-4
- Mass rebuild 2013-12-27

* Fri Dec 27 2013 Daniel Mach <dmach@redhat.com> - 1.0.0-4
- Mass rebuild 2013-12-27

* Thu Nov 7 2013 Dan Varga <dvarga@redhat.com> - 1.0.0-3
- Use scalable icons instead of stock icons
- Resolves: bz985846

* Tue Nov 5 2013 Dan Varga <dvarga@redhat.com> - 1.0.0-2
- A few bugfixes, minor UI tweaks
- Resolves: bz985846

* Mon Nov 4 2013 Dan Varga <dvarga@redhat.com> - 1.0.0-1
- A few minor bugfixes
- Resolves: bz985846

* Fri Oct 18 2013 Dan Varga <dvarga@redhat.com> - 1.0.0-0
- Initial release
- Resolves: bz985846
