# kmod-qcom-scmi

Out of tree modules for enabling Qualcomm 8775 with CS10.

The reference kernel, which contains all Qualcomm out of tree patches is available at:
https://gitlab.com/echanude/linux/-/tree/clo-la-kernel-qcom-1.0.r2-03800?ref_type=heads

## Build testing with CS10

We can cross compile cs10 for aarch64 architecture on fedora.

Install `build-kernel.sh`:
```console
$ git clone https://gitlab.com/CentOS/automotive/src/kernel-scripts.git ~/work/auto/src/kernel-scripts
$ alias build-kernel=~/work/auto/src/kernel-scripts/build-kernel/build-kernel.sh # Make sure to add this to ~/.bashrc or equivalent
```

Fetch the kernel sources, the out of tree modules and the downstream device-tree blobs:
```console
$ git clone https://gitlab.com/echanude/centos-stream-10.git -b el10iv-qcom ~/work/auto/src/cs10-qcom
$ git clone https://gitlab.com/CentOS/automotive/src/kmod-qcom-scmi.git ~/work/auto/src/kmod-qcom-scmi
$ git clone https://gitlab.com/CentOS/automotive/src/downstream-dtbs.git ~/work/auto/src/downstream-dtbs
```

Generate the kernel .config for automotive
```console
$ cd ~/work/auto/src/cs10-qcom
$ make -j $(nproc) dist-configs && cp redhat/configs/kernel-6.12.0-aarch64-automotive.config .config
```

Build the kernel, the modules, and the out of tree modules
```console
$ cd ~/work/auto/src/cs10-qcom
$ build-kernel -z ~/work/auto/src/kmod-qcom-scmi ../downstream-dtbs/qcom/sa8775p-ride-scmi.dtb
```

Note: this will fail at the end because `sa8775p-ride-scmi.dtb` has not been build yet.

Build downstream device-tree blobs
```console
$ cd ~/work/auto/src/downstream-dtbs
$ make KERNEL_SRC=../cs10-qcom
```

## Boot testing on sa8775p reference board

After building all required binaries, we can generate an `aboot.img`.
Use `build-kernel.sh` to do so:

```console
$ cd ~/work/auto/src/cs10-qcom
$ build-kernel -z ~/work/auto/src/kmod-qcom-scmi ../downstream-dtbs/qcom/sa8775p-ride-scmi.dtb

```
Then we can flash `aboot.img` with `fastboot`:
```console
$ fastboot flash boot_a arch/arm64/boot/aboot.img
$ fastboot continue
```

## Build AutoSD10 with automotive image builder

Proceed with the following guide to install automotive image builder (a-i-b):
https://sigs.centos.org/automotive/getting-started/quick-start-guide/#step-1-install-automotive-image-builder-2-minutes

Then, run:
```console
sudo ./auto-image-builder.sh --dev build \
         --target ridesx4_scmi --distro autosd10-latest-sig \
         --define 'use_debug=true' \
         --format simg --separate-partitions ./sample-images/images/developer.mpp.yml ridesx4_scmi.simg
```

## Adding a new module

To add a new out-of-tree module, the `scripts/ksrc-sync.sh` tool must be used.

One will end up in two situations: either the module exists already in the RHEL
repository, and we need to move it out-of-tree to integrate more downstream
patches, or we need to take a downstream driver and make it out-of-tree.

Either way, one needs to add two variables describing the new module
in the tool: `SCRS_$module_name` and `HDRS["$module_name"]`. Then we
need to list that new module in the `MODULES_DFL` variable.

### Extracting an upstream driver into an out-of-tree module

```console
$ ./scripts/ksrc-sync.sh -K $PATH_TO_CENTOS_REPO -m $MODULE_NAME
```

### Converting a downstream driver to an out-of-tree module

```console
$ ./scripts/ksrc-sync.sh \
    -K $PATH_TO_DOWNSTREAM_REPO \
    -t $DOWNSTREAM_TAG \
    -m $MODULE_NAME
```
