/******************************************************************************
 *
 *   BSD LICENSE
 * 
 *   Copyright(c) 2007-2020 Intel Corporation. All rights reserved.
 *   All rights reserved.
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 * 
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 *
 *****************************************************************************/

/**
 *****************************************************************************
 * @file lac_ec_nist_curves.c
 *
 * @ingroup Lac_Ec
 *
 * Definitions for the following NIST recommended elliptic curves:
 *  - PRIME 256 (P256)
 *  - PRIME 384 (P384)
 *  - PRIME 521 (P521)
 *  - KOBLITZ 163 (K163)
 *  - BINARY 163 (B163)
 *  - KOBLITZ 233 (K233)
 *  - BINARY 233 (B233)
 *  - KOBLITZ 571 (K571)
 *  - BINARY 571 (B571)
 *
 *****************************************************************************/

#include "lac_ec_nist_curves.h"

/*********** NIST PRIME 256 CURVE ****************/
const Cpa8U nist_p256_p[] = {0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                             0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                             0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

const Cpa8U nist_p256_a[] = {0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                             0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                             0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc};

const Cpa8U nist_p256_b[] = {0x5a, 0xc6, 0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7,
                             0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98, 0x86, 0xbc,
                             0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6,
                             0x3b, 0xce, 0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b};

const Cpa8U nist_p256_r[] = {0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                             0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                             0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
                             0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51};

const Cpa8U nist_p256_h[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01};

const Cpa8U nist_p256_gX[] = {0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47,
                              0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2,
                              0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0,
                              0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96};

const Cpa8U nist_p256_gY[] = {0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f, 0x9b,
                              0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16,
                              0x2b, 0xce, 0x33, 0x57, 0x6b, 0x31, 0x5e, 0xce,
                              0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51, 0xf5};

/*********** NIST PRIME 384 CURVE ****************/
const Cpa8U nist_p384_p[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff};

const Cpa8U nist_p384_a[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfc};

const Cpa8U nist_p384_b[] = {
    0xb3, 0x31, 0x2f, 0xa7, 0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b,
    0xe3, 0xf8, 0x2d, 0x19, 0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12,
    0x03, 0x14, 0x08, 0x8f, 0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d,
    0x8a, 0x2e, 0xd1, 0x9d, 0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef};

const Cpa8U nist_p384_r[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2,
    0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73};

const Cpa8U nist_p384_h[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01};

const Cpa8U nist_p384_gX[] = {
    0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e,
    0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98,
    0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d,
    0xbf, 0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7};

const Cpa8U nist_p384_gY[] = {
    0x36, 0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf,
    0x92, 0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c,
    0xe9, 0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce,
    0x1d, 0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f};

/*********** NIST PRIME 521 CURVE ****************/
const Cpa8U nist_p521_q[] = {
    0x1,  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

const Cpa8U nist_p521_a[] = {
    0x1,  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc};

const Cpa8U nist_p521_b[] = {
    0x51, 0x95, 0x3e, 0xb9, 0x61, 0x8e, 0x1c, 0x9a, 0x1f, 0x92, 0x9a,
    0x21, 0xa0, 0xb6, 0x85, 0x40, 0xee, 0xa2, 0xda, 0x72, 0x5b, 0x99,
    0xb3, 0x15, 0xf3, 0xb8, 0xb4, 0x89, 0x91, 0x8e, 0xf1, 0x9,  0xe1,
    0x56, 0x19, 0x39, 0x51, 0xec, 0x7e, 0x93, 0x7b, 0x16, 0x52, 0xc0,
    0xbd, 0x3b, 0xb1, 0xbf, 0x7,  0x35, 0x73, 0xdf, 0x88, 0x3d, 0x2c,
    0x34, 0xf1, 0xef, 0x45, 0x1f, 0xd4, 0x6b, 0x50, 0x3f, 0x0};

const Cpa8U nist_p521_r[] = {
    0x1,  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc,
    0x1,  0x48, 0xf7, 0x9,  0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
    0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x9};

/*********** NIST 163 KOBLITZ AND BINARY CURVES ****************/
const Cpa8U nist_gf2_163_q[] = {0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc9};

const Cpa8U nist_gf2_163_a[] = {0x1};

const Cpa8U nist_gf2_163_h[] = {0x2};

/*********** NIST 163 KOBLITZ CURVE ****************/
const Cpa8U nist_koblitz_gf2_163_b[] = {0x1};

const Cpa8U nist_koblitz_gf2_163_r[] = {
    0x4, 0x0, 0x0,  0x0,  0x0,  0x0, 0x0,  0x0,  0x0,  0x0, 0x2,
    0x1, 0x8, 0xa2, 0xe0, 0xcc, 0xd, 0x99, 0xf8, 0xa5, 0xef};

/*********** NIST 163 BINARY CURVE ****************/
const Cpa8U nist_binary_gf2_163_b[] = {
    0x2,  0xa,  0x60, 0x19, 0x7,  0xb8, 0xc9, 0x53, 0xca, 0x14, 0x81,
    0xeb, 0x10, 0x51, 0x2f, 0x78, 0x74, 0x4a, 0x32, 0x5,  0xfd};

const Cpa8U nist_binary_gf2_163_r[] = {0x4,  0x0, 0x0,  0x0,  0x0,  0x0,  0x0,
                                       0x0,  0x0, 0x0,  0x2,  0x92, 0xfe, 0x77,
                                       0xe7, 0xc, 0x12, 0xa4, 0x23, 0x4c, 0x33};

/*********** NIST 233 KOBLITZ AND BINARY CURVES ****************/
const Cpa8U nist_gf2_233_q[] = {
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1};

/*********** NIST 233 KOBLITZ CURVE ****************/
const Cpa8U nist_koblitz_gf2_233_h[] = {0x4};

const Cpa8U nist_koblitz_gf2_233_a[] = {0x0};

const Cpa8U nist_koblitz_gf2_233_b[] = {0x1};

const Cpa8U nist_koblitz_gf2_233_r[] = {
    0x80, 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
    0x0,  0x0,  0x0,  0x0,  0x6,  0x9d, 0x5b, 0xb9, 0x15, 0xbc,
    0xd4, 0x6e, 0xfb, 0x1a, 0xd5, 0xf1, 0x73, 0xab, 0xdf};

/*********** NIST 233 BINARY CURVE ****************/
const Cpa8U nist_binary_gf2_233_h[] = {0x2};

const Cpa8U nist_binary_gf2_233_a[] = {0x1};

const Cpa8U nist_binary_gf2_233_b[] = {
    0x66, 0x64, 0x7e, 0xde, 0x6c, 0x33, 0x2c, 0x7f, 0x8c, 0x9,
    0x23, 0xbb, 0x58, 0x21, 0x3b, 0x33, 0x3b, 0x20, 0xe9, 0xce,
    0x42, 0x81, 0xfe, 0x11, 0x5f, 0x7d, 0x8f, 0x90, 0xad};

const Cpa8U nist_binary_gf2_233_r[] = {
    0x1,  0x0,  0x0,  0x0, 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
    0x0,  0x0,  0x0,  0x0, 0x0,  0x13, 0xe9, 0x74, 0xe7, 0x2f,
    0x8a, 0x69, 0x22, 0x3, 0x1d, 0x26, 0x3,  0xcf, 0xe0, 0xd7};

/*********** NIST 571 KOBLITZ AND BINARY CURVES ****************/
const Cpa8U nist_gf2_571_q[] = {
    0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x25};

/*********** NIST 571 KOBLITZ CURVE ****************/
const Cpa8U nist_koblitz_gf2_571_h[] = {0x4};

const Cpa8U nist_koblitz_gf2_571_r[] = {
    0x2,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
    0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
    0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
    0x13, 0x18, 0x50, 0xe1, 0xf1, 0x9a, 0x63, 0xe4, 0xb3, 0x91, 0xa8, 0xdb,
    0x91, 0x7f, 0x41, 0x38, 0xb6, 0x30, 0xd8, 0x4b, 0xe5, 0xd6, 0x39, 0x38,
    0x1e, 0x91, 0xde, 0xb4, 0x5c, 0xfe, 0x77, 0x8f, 0x63, 0x7c, 0x10, 0x1};

/*********** NIST 571 BINARY CURVE ****************/
const Cpa8U nist_binary_gf2_571_b[] = {
    0x2,  0xf4, 0xe,  0x7e, 0x22, 0x21, 0xf2, 0x95, 0xde, 0x29, 0x71, 0x17,
    0xb7, 0xf3, 0xd6, 0x2f, 0x5c, 0x6a, 0x97, 0xff, 0xcb, 0x8c, 0xef, 0xf1,
    0xcd, 0x6b, 0xa8, 0xce, 0x4a, 0x9a, 0x18, 0xad, 0x84, 0xff, 0xab, 0xbd,
    0x8e, 0xfa, 0x59, 0x33, 0x2b, 0xe7, 0xad, 0x67, 0x56, 0xa6, 0x6e, 0x29,
    0x4a, 0xfd, 0x18, 0x5a, 0x78, 0xff, 0x12, 0xaa, 0x52, 0xe,  0x4d, 0xe7,
    0x39, 0xba, 0xca, 0xc,  0x7f, 0xfe, 0xff, 0x7f, 0x29, 0x55, 0x72, 0x7a};

const Cpa8U nist_binary_gf2_571_h[] = {0x2};

const Cpa8U nist_binary_gf2_571_r[] = {
    0x3,  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe6, 0x61, 0xce, 0x18, 0xff, 0x55, 0x98, 0x73, 0x8,  0x5,  0x9b, 0x18,
    0x68, 0x23, 0x85, 0x1e, 0xc7, 0xdd, 0x9c, 0xa1, 0x16, 0x1d, 0xe9, 0x3d,
    0x51, 0x74, 0xd6, 0x6e, 0x83, 0x82, 0xe9, 0xbb, 0x2f, 0xe8, 0x4e, 0x47};
