# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationHealthPolicyMapItem(Model):
    """Defines an item in ApplicationHealthPolicyMap.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. The key of the application health policy map item.
     This is the name of the application.
    :type key: str
    :param value: Required. The value of the application health policy map
     item. This is the ApplicationHealthPolicy for this application.
    :type value: ~azure.servicefabric.models.ApplicationHealthPolicy
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'ApplicationHealthPolicy'},
    }

    def __init__(self, *, key: str, value, **kwargs) -> None:
        super(ApplicationHealthPolicyMapItem, self).__init__(**kwargs)
        self.key = key
        self.value = value
