# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource import ProxyOnlyResource


class ProcessInfo(ProxyOnlyResource):
    """Process Information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param process_info_id: ARM Identifier for deployment.
    :type process_info_id: int
    :param process_info_name: Deployment name.
    :type process_info_name: str
    :param href: HRef URI.
    :type href: str
    :param mini_dump: Minidump URI.
    :type mini_dump: str
    :param is_profile_running: Is profile running?
    :type is_profile_running: bool
    :param is_iis_profile_running: Is the IIS Profile running?
    :type is_iis_profile_running: bool
    :param iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
    :type iis_profile_timeout_in_seconds: float
    :param parent: Parent process.
    :type parent: str
    :param children: Child process list.
    :type children: list[str]
    :param threads: Thread list.
    :type threads: list[~azure.mgmt.web.models.ProcessThreadInfo]
    :param open_file_handles: List of open files.
    :type open_file_handles: list[str]
    :param modules: List of modules.
    :type modules: list[~azure.mgmt.web.models.ProcessModuleInfo]
    :param file_name: File name of this process.
    :type file_name: str
    :param command_line: Command line.
    :type command_line: str
    :param user_name: User name.
    :type user_name: str
    :param handle_count: Handle count.
    :type handle_count: int
    :param module_count: Module count.
    :type module_count: int
    :param thread_count: Thread count.
    :type thread_count: int
    :param start_time: Start time.
    :type start_time: datetime
    :param total_processor_time: Total CPU time.
    :type total_processor_time: str
    :param user_processor_time: User CPU time.
    :type user_processor_time: str
    :param privileged_processor_time: Privileged CPU time.
    :type privileged_processor_time: str
    :param working_set64: Working set.
    :type working_set64: long
    :param peak_working_set64: Peak working set.
    :type peak_working_set64: long
    :param private_memory_size64: Private memory size.
    :type private_memory_size64: long
    :param virtual_memory_size64: Virtual memory size.
    :type virtual_memory_size64: long
    :param peak_virtual_memory_size64: Peak virtual memory usage.
    :type peak_virtual_memory_size64: long
    :param paged_system_memory_size64: Paged system memory.
    :type paged_system_memory_size64: long
    :param nonpaged_system_memory_size64: Non-paged system memory.
    :type nonpaged_system_memory_size64: long
    :param paged_memory_size64: Paged memory.
    :type paged_memory_size64: long
    :param peak_paged_memory_size64: Peak paged memory.
    :type peak_paged_memory_size64: long
    :param time_stamp: Time stamp.
    :type time_stamp: datetime
    :param environment_variables: List of environment variables.
    :type environment_variables: dict[str, str]
    :param is_scm_site: Is this the SCM site?
    :type is_scm_site: bool
    :param is_web_job: Is this a Web Job?
    :type is_web_job: bool
    :param description: Description of process.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'process_info_id': {'key': 'properties.id', 'type': 'int'},
        'process_info_name': {'key': 'properties.name', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'mini_dump': {'key': 'properties.miniDump', 'type': 'str'},
        'is_profile_running': {'key': 'properties.isProfileRunning', 'type': 'bool'},
        'is_iis_profile_running': {'key': 'properties.isIisProfileRunning', 'type': 'bool'},
        'iis_profile_timeout_in_seconds': {'key': 'properties.iisProfileTimeoutInSeconds', 'type': 'float'},
        'parent': {'key': 'properties.parent', 'type': 'str'},
        'children': {'key': 'properties.children', 'type': '[str]'},
        'threads': {'key': 'properties.threads', 'type': '[ProcessThreadInfo]'},
        'open_file_handles': {'key': 'properties.openFileHandles', 'type': '[str]'},
        'modules': {'key': 'properties.modules', 'type': '[ProcessModuleInfo]'},
        'file_name': {'key': 'properties.fileName', 'type': 'str'},
        'command_line': {'key': 'properties.commandLine', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'handle_count': {'key': 'properties.handleCount', 'type': 'int'},
        'module_count': {'key': 'properties.moduleCount', 'type': 'int'},
        'thread_count': {'key': 'properties.threadCount', 'type': 'int'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'total_processor_time': {'key': 'properties.totalProcessorTime', 'type': 'str'},
        'user_processor_time': {'key': 'properties.userProcessorTime', 'type': 'str'},
        'privileged_processor_time': {'key': 'properties.privilegedProcessorTime', 'type': 'str'},
        'working_set64': {'key': 'properties.workingSet64', 'type': 'long'},
        'peak_working_set64': {'key': 'properties.peakWorkingSet64', 'type': 'long'},
        'private_memory_size64': {'key': 'properties.privateMemorySize64', 'type': 'long'},
        'virtual_memory_size64': {'key': 'properties.virtualMemorySize64', 'type': 'long'},
        'peak_virtual_memory_size64': {'key': 'properties.peakVirtualMemorySize64', 'type': 'long'},
        'paged_system_memory_size64': {'key': 'properties.pagedSystemMemorySize64', 'type': 'long'},
        'nonpaged_system_memory_size64': {'key': 'properties.nonpagedSystemMemorySize64', 'type': 'long'},
        'paged_memory_size64': {'key': 'properties.pagedMemorySize64', 'type': 'long'},
        'peak_paged_memory_size64': {'key': 'properties.peakPagedMemorySize64', 'type': 'long'},
        'time_stamp': {'key': 'properties.timeStamp', 'type': 'iso-8601'},
        'environment_variables': {'key': 'properties.environmentVariables', 'type': '{str}'},
        'is_scm_site': {'key': 'properties.isScmSite', 'type': 'bool'},
        'is_web_job': {'key': 'properties.isWebJob', 'type': 'bool'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(self, kind=None, process_info_id=None, process_info_name=None, href=None, mini_dump=None, is_profile_running=None, is_iis_profile_running=None, iis_profile_timeout_in_seconds=None, parent=None, children=None, threads=None, open_file_handles=None, modules=None, file_name=None, command_line=None, user_name=None, handle_count=None, module_count=None, thread_count=None, start_time=None, total_processor_time=None, user_processor_time=None, privileged_processor_time=None, working_set64=None, peak_working_set64=None, private_memory_size64=None, virtual_memory_size64=None, peak_virtual_memory_size64=None, paged_system_memory_size64=None, nonpaged_system_memory_size64=None, paged_memory_size64=None, peak_paged_memory_size64=None, time_stamp=None, environment_variables=None, is_scm_site=None, is_web_job=None, description=None):
        super(ProcessInfo, self).__init__(kind=kind)
        self.process_info_id = process_info_id
        self.process_info_name = process_info_name
        self.href = href
        self.mini_dump = mini_dump
        self.is_profile_running = is_profile_running
        self.is_iis_profile_running = is_iis_profile_running
        self.iis_profile_timeout_in_seconds = iis_profile_timeout_in_seconds
        self.parent = parent
        self.children = children
        self.threads = threads
        self.open_file_handles = open_file_handles
        self.modules = modules
        self.file_name = file_name
        self.command_line = command_line
        self.user_name = user_name
        self.handle_count = handle_count
        self.module_count = module_count
        self.thread_count = thread_count
        self.start_time = start_time
        self.total_processor_time = total_processor_time
        self.user_processor_time = user_processor_time
        self.privileged_processor_time = privileged_processor_time
        self.working_set64 = working_set64
        self.peak_working_set64 = peak_working_set64
        self.private_memory_size64 = private_memory_size64
        self.virtual_memory_size64 = virtual_memory_size64
        self.peak_virtual_memory_size64 = peak_virtual_memory_size64
        self.paged_system_memory_size64 = paged_system_memory_size64
        self.nonpaged_system_memory_size64 = nonpaged_system_memory_size64
        self.paged_memory_size64 = paged_memory_size64
        self.peak_paged_memory_size64 = peak_paged_memory_size64
        self.time_stamp = time_stamp
        self.environment_variables = environment_variables
        self.is_scm_site = is_scm_site
        self.is_web_job = is_web_job
        self.description = description
