# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FacebookChannelProperties(Model):
    """The parameters to provide for the Facebook channel.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar verify_token: Verify token
    :vartype verify_token: str
    :param page_id: Page id
    :type page_id: str
    :param app_id: Facebook application id
    :type app_id: str
    :param app_secret: Facebook application secret
    :type app_secret: str
    :param access_token: Facebook application access token
    :type access_token: str
    :ivar callback_url: Callback Url
    :vartype callback_url: str
    :param is_enabled: Whether this channel is enabled for the bot
    :type is_enabled: bool
    """

    _validation = {
        'verify_token': {'readonly': True},
        'page_id': {'required': True},
        'app_id': {'required': True},
        'app_secret': {'required': True},
        'callback_url': {'readonly': True},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'verify_token': {'key': 'verifyToken', 'type': 'str'},
        'page_id': {'key': 'pageId', 'type': 'str'},
        'app_id': {'key': 'appId', 'type': 'str'},
        'app_secret': {'key': 'appSecret', 'type': 'str'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'callback_url': {'key': 'callbackUrl', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(self, page_id, app_id, app_secret, is_enabled, access_token=None):
        self.verify_token = None
        self.page_id = page_id
        self.app_id = app_id
        self.app_secret = app_secret
        self.access_token = access_token
        self.callback_url = None
        self.is_enabled = is_enabled
