# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StorageAccountItem(Model):
    """The storage account item containing storage account metadata.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Storage identifier.
    :vartype id: str
    :ivar resource_id: Storage account resource Id.
    :vartype resource_id: str
    :ivar attributes: The storage account management attributes.
    :vartype attributes: ~azure.keyvault.models.StorageAccountAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'resource_id': {'readonly': True},
        'attributes': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'StorageAccountAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs) -> None:
        super(StorageAccountItem, self).__init__(**kwargs)
        self.id = None
        self.resource_id = None
        self.attributes = None
        self.tags = None
