# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SimilarFace(Model):
    """Response body for find similar face operation.

    :param face_id: FaceId of candidate face when find by faceIds. faceId is
     created by Face - Detect and will expire 24 hours after the detection call
    :type face_id: str
    :param persisted_face_id: PersistedFaceId of candidate face when find by
     faceListId. persistedFaceId in face list is persisted and will not expire.
     As showed in below response
    :type persisted_face_id: str
    :param confidence: Similarity confidence of the candidate face. The higher
     confidence, the more similar. Range between [0,1].
    :type confidence: float
    """

    _validation = {
        'confidence': {'required': True},
    }

    _attribute_map = {
        'face_id': {'key': 'faceId', 'type': 'str'},
        'persisted_face_id': {'key': 'persistedFaceId', 'type': 'str'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(self, confidence, face_id=None, persisted_face_id=None):
        super(SimilarFace, self).__init__()
        self.face_id = face_id
        self.persisted_face_id = persisted_face_id
        self.confidence = confidence
