# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VideoFrameBodyItem(Model):
    """Schema items of the body.

    :param timestamp: Timestamp of the frame.
    :type timestamp: str
    :param frame_image: Content to review.
    :type frame_image: str
    :param reviewer_result_tags:
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.VideoFrameBodyItemReviewerResultTagsItem]
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.VideoFrameBodyItemMetadataItem]
    """

    _validation = {
        'timestamp': {'required': True},
        'frame_image': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'Timestamp', 'type': 'str'},
        'frame_image': {'key': 'FrameImage', 'type': 'str'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[VideoFrameBodyItemReviewerResultTagsItem]'},
        'metadata': {'key': 'Metadata', 'type': '[VideoFrameBodyItemMetadataItem]'},
    }

    def __init__(self, timestamp, frame_image, reviewer_result_tags=None, metadata=None):
        super(VideoFrameBodyItem, self).__init__()
        self.timestamp = timestamp
        self.frame_image = frame_image
        self.reviewer_result_tags = reviewer_result_tags
        self.metadata = metadata
