# V1ValidationRule

ValidationRule describes a validation rule written in the CEL expression language.
## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**message** | **str** | Message represents the message displayed when validation fails. The message is required if the Rule contains line breaks. The message must not contain line breaks. If unset, the message is \&quot;failed rule: {Rule}\&quot;. e.g. \&quot;must be a URL with the host matching spec.host\&quot; | [optional] 
**rule** | **str** | Rule represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec The Rule is scoped to the location of the x-kubernetes-validations extension in the schema. The &#x60;self&#x60; variable in the CEL expression is bound to the scoped value. Example: - Rule scoped to the root of a resource with a status subresource: {\&quot;rule\&quot;: \&quot;self.status.actual &lt;&#x3D; self.spec.maxDesired\&quot;}  If the Rule is scoped to an object with properties, the accessible properties of the object are field selectable via &#x60;self.field&#x60; and field presence can be checked via &#x60;has(self.field)&#x60;. Null valued fields are treated as absent fields in CEL expressions. If the Rule is scoped to an object with additionalProperties (i.e. a map) the value of the map are accessible via &#x60;self[mapKey]&#x60;, map containment can be checked via &#x60;mapKey in self&#x60; and all entries of the map are accessible via CEL macros and functions such as &#x60;self.all(...)&#x60;. If the Rule is scoped to an array, the elements of the array are accessible via &#x60;self[i]&#x60; and also by macros and functions. If the Rule is scoped to a scalar, &#x60;self&#x60; is bound to the scalar value. Examples: - Rule scoped to a map of objects: {\&quot;rule\&quot;: \&quot;self.components[&#39;Widget&#39;].priority &lt; 10\&quot;} - Rule scoped to a list of integers: {\&quot;rule\&quot;: \&quot;self.values.all(value, value &gt;&#x3D; 0 &amp;&amp; value &lt; 100)\&quot;} - Rule scoped to a string value: {\&quot;rule\&quot;: \&quot;self.startsWith(&#39;kube&#39;)\&quot;}  The &#x60;apiVersion&#x60;, &#x60;kind&#x60;, &#x60;metadata.name&#x60; and &#x60;metadata.generateName&#x60; are always accessible from the root of the object and from any x-kubernetes-embedded-resource annotated objects. No other metadata properties are accessible.  Unknown data preserved in custom resources via x-kubernetes-preserve-unknown-fields is not accessible in CEL expressions. This includes: - Unknown field values that are preserved by object schemas with x-kubernetes-preserve-unknown-fields. - Object properties where the property schema is of an \&quot;unknown type\&quot;. An \&quot;unknown type\&quot; is recursively defined as:   - A schema with no type and x-kubernetes-preserve-unknown-fields set to true   - An array where the items schema is of an \&quot;unknown type\&quot;   - An object where the additionalProperties schema is of an \&quot;unknown type\&quot;  Only property names of the form &#x60;[a-zA-Z_.-/][a-zA-Z0-9_.-/]*&#x60; are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - &#39;__&#39; escapes to &#39;__underscores__&#39; - &#39;.&#39; escapes to &#39;__dot__&#39; - &#39;-&#39; escapes to &#39;__dash__&#39; - &#39;/&#39; escapes to &#39;__slash__&#39; - Property names that exactly match a CEL RESERVED keyword escape to &#39;__{keyword}__&#39;. The keywords are:    \&quot;true\&quot;, \&quot;false\&quot;, \&quot;null\&quot;, \&quot;in\&quot;, \&quot;as\&quot;, \&quot;break\&quot;, \&quot;const\&quot;, \&quot;continue\&quot;, \&quot;else\&quot;, \&quot;for\&quot;, \&quot;function\&quot;, \&quot;if\&quot;,    \&quot;import\&quot;, \&quot;let\&quot;, \&quot;loop\&quot;, \&quot;package\&quot;, \&quot;namespace\&quot;, \&quot;return\&quot;. Examples:   - Rule accessing a property named \&quot;namespace\&quot;: {\&quot;rule\&quot;: \&quot;self.__namespace__ &gt; 0\&quot;}   - Rule accessing a property named \&quot;x-prop\&quot;: {\&quot;rule\&quot;: \&quot;self.x__dash__prop &gt; 0\&quot;}   - Rule accessing a property named \&quot;redact__d\&quot;: {\&quot;rule\&quot;: \&quot;self.redact__underscores__d &gt; 0\&quot;}  Equality on arrays with x-kubernetes-list-type of &#39;set&#39; or &#39;map&#39; ignores element order, i.e. [1, 2] &#x3D;&#x3D; [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:   - &#39;set&#39;: &#x60;X + Y&#x60; performs a union where the array positions of all elements in &#x60;X&#x60; are preserved and     non-intersecting elements in &#x60;Y&#x60; are appended, retaining their partial order.   - &#39;map&#39;: &#x60;X + Y&#x60; performs a merge where the array positions of all keys in &#x60;X&#x60; are preserved but the values     are overwritten by values in &#x60;Y&#x60; when the key sets of &#x60;X&#x60; and &#x60;Y&#x60; intersect. Elements in &#x60;Y&#x60; with     non-intersecting keys are appended, retaining their partial order. | 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


