# V1alpha3CELDeviceSelector

CELDeviceSelector contains a CEL expression for selecting a device.
## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**expression** | **str** | Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.  The expression&#39;s input is an object named \&quot;device\&quot;, which carries the following properties:  - driver (string): the name of the driver which defines this device.  - attributes (map[string]object): the device&#39;s attributes, grouped by prefix    (e.g. device.attributes[\&quot;dra.example.com\&quot;] evaluates to an object with all    of the attributes which were prefixed by \&quot;dra.example.com\&quot;.  - capacity (map[string]object): the device&#39;s capacities, grouped by prefix.  Example: Consider a device with driver&#x3D;\&quot;dra.example.com\&quot;, which exposes two attributes named \&quot;model\&quot; and \&quot;ext.example.com/family\&quot; and which exposes one capacity named \&quot;modules\&quot;. This input to this expression would have the following fields:      device.driver     device.attributes[\&quot;dra.example.com\&quot;].model     device.attributes[\&quot;ext.example.com\&quot;].family     device.capacity[\&quot;dra.example.com\&quot;].modules  The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.  The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.  If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.  A robust expression should check for the existence of attributes before referencing them.  For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:      cel.bind(dra, device.attributes[\&quot;dra.example.com\&quot;], dra.someBool &amp;&amp; dra.anotherBool) | 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


