# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class VariablesService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """VariablesService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def delete_variables_id(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_variables_id(variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_variables_id_with_http_info(variable_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_variables_id_with_http_info(variable_id, **kwargs)  # noqa: E501
            return data

    def delete_variables_id_with_http_info(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_variables_id_with_http_info(variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_variables_id_prepare(variable_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/variables/{variableID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_variables_id_async(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a variable.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_variables_id_prepare(variable_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/variables/{variableID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_variables_id_prepare(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['variable_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_variables_id', all_params, local_var_params)
        # verify the required parameter 'variable_id' is set
        if ('variable_id' not in local_var_params or
                local_var_params['variable_id'] is None):
            raise ValueError("Missing the required parameter `variable_id` when calling `delete_variables_id`")  # noqa: E501

        path_params = {}
        if 'variable_id' in local_var_params:
            path_params['variableID'] = local_var_params['variable_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_variables_id_labels_id(self, variable_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_variables_id_labels_id(variable_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str label_id: The label ID to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_variables_id_labels_id_with_http_info(variable_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_variables_id_labels_id_with_http_info(variable_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_variables_id_labels_id_with_http_info(self, variable_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_variables_id_labels_id_with_http_info(variable_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str label_id: The label ID to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_variables_id_labels_id_prepare(variable_id, label_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/variables/{variableID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_variables_id_labels_id_async(self, variable_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a variable.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str label_id: The label ID to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_variables_id_labels_id_prepare(variable_id, label_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/variables/{variableID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_variables_id_labels_id_prepare(self, variable_id, label_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['variable_id', 'label_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_variables_id_labels_id', all_params, local_var_params)
        # verify the required parameter 'variable_id' is set
        if ('variable_id' not in local_var_params or
                local_var_params['variable_id'] is None):
            raise ValueError("Missing the required parameter `variable_id` when calling `delete_variables_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_variables_id_labels_id`")  # noqa: E501

        path_params = {}
        if 'variable_id' in local_var_params:
            path_params['variableID'] = local_var_params['variable_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_variables(self, **kwargs):  # noqa: E501,D401,D403
        """List all variables.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_variables(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :param str org_id: The organization ID.
        :return: Variables
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_variables_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_variables_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_variables_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List all variables.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_variables_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :param str org_id: The organization ID.
        :return: Variables
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_variables_prepare(**kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Variables',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_variables_async(self, **kwargs):  # noqa: E501,D401,D403
        """List all variables.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :param str org_id: The organization ID.
        :return: Variables
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_variables_prepare(**kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Variables',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_variables_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'org', 'org_id']  # noqa: E501
        self._check_operation_params('get_variables', all_params, local_var_params)

        path_params = {}

        query_params = []
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_variables_id(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_variables_id(variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_variables_id_with_http_info(variable_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_variables_id_with_http_info(variable_id, **kwargs)  # noqa: E501
            return data

    def get_variables_id_with_http_info(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_variables_id_with_http_info(variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_variables_id_prepare(variable_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/variables/{variableID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Variable',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_variables_id_async(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a variable.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_variables_id_prepare(variable_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/variables/{variableID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Variable',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_variables_id_prepare(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['variable_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_variables_id', all_params, local_var_params)
        # verify the required parameter 'variable_id' is set
        if ('variable_id' not in local_var_params or
                local_var_params['variable_id'] is None):
            raise ValueError("Missing the required parameter `variable_id` when calling `get_variables_id`")  # noqa: E501

        path_params = {}
        if 'variable_id' in local_var_params:
            path_params['variableID'] = local_var_params['variable_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_variables_id_labels(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_variables_id_labels(variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_variables_id_labels_with_http_info(variable_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_variables_id_labels_with_http_info(variable_id, **kwargs)  # noqa: E501
            return data

    def get_variables_id_labels_with_http_info(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_variables_id_labels_with_http_info(variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_variables_id_labels_prepare(variable_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/variables/{variableID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_variables_id_labels_async(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a variable.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_variables_id_labels_prepare(variable_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/variables/{variableID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_variables_id_labels_prepare(self, variable_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['variable_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_variables_id_labels', all_params, local_var_params)
        # verify the required parameter 'variable_id' is set
        if ('variable_id' not in local_var_params or
                local_var_params['variable_id'] is None):
            raise ValueError("Missing the required parameter `variable_id` when calling `get_variables_id_labels`")  # noqa: E501

        path_params = {}
        if 'variable_id' in local_var_params:
            path_params['variableID'] = local_var_params['variable_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_variables_id(self, variable_id, variable, **kwargs):  # noqa: E501,D401,D403
        """Update a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_variables_id(variable_id, variable, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param Variable variable: Variable update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_variables_id_with_http_info(variable_id, variable, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_variables_id_with_http_info(variable_id, variable, **kwargs)  # noqa: E501
            return data

    def patch_variables_id_with_http_info(self, variable_id, variable, **kwargs):  # noqa: E501,D401,D403
        """Update a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_variables_id_with_http_info(variable_id, variable, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param Variable variable: Variable update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_variables_id_prepare(variable_id, variable, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/variables/{variableID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Variable',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_variables_id_async(self, variable_id, variable, **kwargs):  # noqa: E501,D401,D403
        """Update a variable.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param Variable variable: Variable update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_variables_id_prepare(variable_id, variable, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/variables/{variableID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Variable',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_variables_id_prepare(self, variable_id, variable, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['variable_id', 'variable', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_variables_id', all_params, local_var_params)
        # verify the required parameter 'variable_id' is set
        if ('variable_id' not in local_var_params or
                local_var_params['variable_id'] is None):
            raise ValueError("Missing the required parameter `variable_id` when calling `patch_variables_id`")  # noqa: E501
        # verify the required parameter 'variable' is set
        if ('variable' not in local_var_params or
                local_var_params['variable'] is None):
            raise ValueError("Missing the required parameter `variable` when calling `patch_variables_id`")  # noqa: E501

        path_params = {}
        if 'variable_id' in local_var_params:
            path_params['variableID'] = local_var_params['variable_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'variable' in local_var_params:
            body_params = local_var_params['variable']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_variables(self, variable, **kwargs):  # noqa: E501,D401,D403
        """Create a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_variables(variable, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Variable variable: Variable to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_variables_with_http_info(variable, **kwargs)  # noqa: E501
        else:
            (data) = self.post_variables_with_http_info(variable, **kwargs)  # noqa: E501
            return data

    def post_variables_with_http_info(self, variable, **kwargs):  # noqa: E501,D401,D403
        """Create a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_variables_with_http_info(variable, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Variable variable: Variable to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_variables_prepare(variable, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Variable',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_variables_async(self, variable, **kwargs):  # noqa: E501,D401,D403
        """Create a variable.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param Variable variable: Variable to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_variables_prepare(variable, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Variable',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_variables_prepare(self, variable, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['variable', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_variables', all_params, local_var_params)
        # verify the required parameter 'variable' is set
        if ('variable' not in local_var_params or
                local_var_params['variable'] is None):
            raise ValueError("Missing the required parameter `variable` when calling `post_variables`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'variable' in local_var_params:
            body_params = local_var_params['variable']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_variables_id_labels(self, variable_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_variables_id_labels(variable_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_variables_id_labels_with_http_info(variable_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_variables_id_labels_with_http_info(variable_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_variables_id_labels_with_http_info(self, variable_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_variables_id_labels_with_http_info(variable_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_variables_id_labels_prepare(variable_id, label_mapping, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/variables/{variableID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_variables_id_labels_async(self, variable_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a variable.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_variables_id_labels_prepare(variable_id, label_mapping, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/variables/{variableID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_variables_id_labels_prepare(self, variable_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['variable_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_variables_id_labels', all_params, local_var_params)
        # verify the required parameter 'variable_id' is set
        if ('variable_id' not in local_var_params or
                local_var_params['variable_id'] is None):
            raise ValueError("Missing the required parameter `variable_id` when calling `post_variables_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_variables_id_labels`")  # noqa: E501

        path_params = {}
        if 'variable_id' in local_var_params:
            path_params['variableID'] = local_var_params['variable_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def put_variables_id(self, variable_id, variable, **kwargs):  # noqa: E501,D401,D403
        """Replace a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_variables_id(variable_id, variable, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param Variable variable: Variable to replace (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_variables_id_with_http_info(variable_id, variable, **kwargs)  # noqa: E501
        else:
            (data) = self.put_variables_id_with_http_info(variable_id, variable, **kwargs)  # noqa: E501
            return data

    def put_variables_id_with_http_info(self, variable_id, variable, **kwargs):  # noqa: E501,D401,D403
        """Replace a variable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_variables_id_with_http_info(variable_id, variable, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param Variable variable: Variable to replace (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_variables_id_prepare(variable_id, variable, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/variables/{variableID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Variable',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def put_variables_id_async(self, variable_id, variable, **kwargs):  # noqa: E501,D401,D403
        """Replace a variable.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str variable_id: The variable ID. (required)
        :param Variable variable: Variable to replace (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_variables_id_prepare(variable_id, variable, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/variables/{variableID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Variable',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _put_variables_id_prepare(self, variable_id, variable, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['variable_id', 'variable', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('put_variables_id', all_params, local_var_params)
        # verify the required parameter 'variable_id' is set
        if ('variable_id' not in local_var_params or
                local_var_params['variable_id'] is None):
            raise ValueError("Missing the required parameter `variable_id` when calling `put_variables_id`")  # noqa: E501
        # verify the required parameter 'variable' is set
        if ('variable' not in local_var_params or
                local_var_params['variable'] is None):
            raise ValueError("Missing the required parameter `variable` when calling `put_variables_id`")  # noqa: E501

        path_params = {}
        if 'variable_id' in local_var_params:
            path_params['variableID'] = local_var_params['variable_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'variable' in local_var_params:
            body_params = local_var_params['variable']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
