# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401


class Run(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'task_id': 'str',
        'status': 'str',
        'scheduled_for': 'datetime',
        'log': 'list[LogEvent]',
        'started_at': 'datetime',
        'finished_at': 'datetime',
        'requested_at': 'datetime',
        'links': 'RunLinks'
    }

    attribute_map = {
        'id': 'id',
        'task_id': 'taskID',
        'status': 'status',
        'scheduled_for': 'scheduledFor',
        'log': 'log',
        'started_at': 'startedAt',
        'finished_at': 'finishedAt',
        'requested_at': 'requestedAt',
        'links': 'links'
    }

    def __init__(self, id=None, task_id=None, status=None, scheduled_for=None, log=None, started_at=None, finished_at=None, requested_at=None, links=None):  # noqa: E501,D401,D403
        """Run - a model defined in OpenAPI."""  # noqa: E501
        self._id = None
        self._task_id = None
        self._status = None
        self._scheduled_for = None
        self._log = None
        self._started_at = None
        self._finished_at = None
        self._requested_at = None
        self._links = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if task_id is not None:
            self.task_id = task_id
        if status is not None:
            self.status = status
        if scheduled_for is not None:
            self.scheduled_for = scheduled_for
        if log is not None:
            self.log = log
        if started_at is not None:
            self.started_at = started_at
        if finished_at is not None:
            self.finished_at = finished_at
        if requested_at is not None:
            self.requested_at = requested_at
        if links is not None:
            self.links = links

    @property
    def id(self):
        """Get the id of this Run.

        :return: The id of this Run.
        :rtype: str
        """  # noqa: E501
        return self._id

    @id.setter
    def id(self, id):
        """Set the id of this Run.

        :param id: The id of this Run.
        :type: str
        """  # noqa: E501
        self._id = id

    @property
    def task_id(self):
        """Get the task_id of this Run.

        :return: The task_id of this Run.
        :rtype: str
        """  # noqa: E501
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Set the task_id of this Run.

        :param task_id: The task_id of this Run.
        :type: str
        """  # noqa: E501
        self._task_id = task_id

    @property
    def status(self):
        """Get the status of this Run.

        :return: The status of this Run.
        :rtype: str
        """  # noqa: E501
        return self._status

    @status.setter
    def status(self, status):
        """Set the status of this Run.

        :param status: The status of this Run.
        :type: str
        """  # noqa: E501
        self._status = status

    @property
    def scheduled_for(self):
        """Get the scheduled_for of this Run.

        Time used for run's "now" option, RFC3339.

        :return: The scheduled_for of this Run.
        :rtype: datetime
        """  # noqa: E501
        return self._scheduled_for

    @scheduled_for.setter
    def scheduled_for(self, scheduled_for):
        """Set the scheduled_for of this Run.

        Time used for run's "now" option, RFC3339.

        :param scheduled_for: The scheduled_for of this Run.
        :type: datetime
        """  # noqa: E501
        self._scheduled_for = scheduled_for

    @property
    def log(self):
        """Get the log of this Run.

        An array of logs associated with the run.

        :return: The log of this Run.
        :rtype: list[LogEvent]
        """  # noqa: E501
        return self._log

    @log.setter
    def log(self, log):
        """Set the log of this Run.

        An array of logs associated with the run.

        :param log: The log of this Run.
        :type: list[LogEvent]
        """  # noqa: E501
        self._log = log

    @property
    def started_at(self):
        """Get the started_at of this Run.

        Time run started executing, RFC3339Nano.

        :return: The started_at of this Run.
        :rtype: datetime
        """  # noqa: E501
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Set the started_at of this Run.

        Time run started executing, RFC3339Nano.

        :param started_at: The started_at of this Run.
        :type: datetime
        """  # noqa: E501
        self._started_at = started_at

    @property
    def finished_at(self):
        """Get the finished_at of this Run.

        Time run finished executing, RFC3339Nano.

        :return: The finished_at of this Run.
        :rtype: datetime
        """  # noqa: E501
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Set the finished_at of this Run.

        Time run finished executing, RFC3339Nano.

        :param finished_at: The finished_at of this Run.
        :type: datetime
        """  # noqa: E501
        self._finished_at = finished_at

    @property
    def requested_at(self):
        """Get the requested_at of this Run.

        Time run was manually requested, RFC3339Nano.

        :return: The requested_at of this Run.
        :rtype: datetime
        """  # noqa: E501
        return self._requested_at

    @requested_at.setter
    def requested_at(self, requested_at):
        """Set the requested_at of this Run.

        Time run was manually requested, RFC3339Nano.

        :param requested_at: The requested_at of this Run.
        :type: datetime
        """  # noqa: E501
        self._requested_at = requested_at

    @property
    def links(self):
        """Get the links of this Run.

        :return: The links of this Run.
        :rtype: RunLinks
        """  # noqa: E501
        return self._links

    @links.setter
    def links(self, links):
        """Set the links of this Run.

        :param links: The links of this Run.
        :type: RunLinks
        """  # noqa: E501
        self._links = links

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, Run):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
