# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PromptFieldDescription(Model):
    """Field description for the implementation of PSHostUserInterface.Prompt.

    :param name: The name of the prompt.
    :type name: str
    :param label: The label text of the prompt.
    :type label: str
    :param help_message: The help message of the prompt.
    :type help_message: str
    :param prompt_field_type_is_list: When set to 'true' the prompt field type
     is a list of values.
    :type prompt_field_type_is_list: bool
    :param prompt_field_type: Possible values include: 'String',
     'SecureString', 'Credential'
    :type prompt_field_type: str or :class:`PromptFieldType
     <azure.mgmt.servermanager.models.PromptFieldType>`
    """ 

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'help_message': {'key': 'helpMessage', 'type': 'str'},
        'prompt_field_type_is_list': {'key': 'promptFieldTypeIsList', 'type': 'bool'},
        'prompt_field_type': {'key': 'promptFieldType', 'type': 'PromptFieldType'},
    }

    def __init__(self, name=None, label=None, help_message=None, prompt_field_type_is_list=None, prompt_field_type=None):
        self.name = name
        self.label = label
        self.help_message = help_message
        self.prompt_field_type_is_list = prompt_field_type_is_list
        self.prompt_field_type = prompt_field_type
