# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GalleryImageIdentifier(Model):
    """This is the gallery Image Definition identifier.

    All required parameters must be populated in order to send to Azure.

    :param publisher: Required. The name of the gallery Image Definition
     publisher.
    :type publisher: str
    :param offer: Required. The name of the gallery Image Definition offer.
    :type offer: str
    :param sku: Required. The name of the gallery Image Definition SKU.
    :type sku: str
    """

    _validation = {
        'publisher': {'required': True},
        'offer': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GalleryImageIdentifier, self).__init__(**kwargs)
        self.publisher = kwargs.get('publisher', None)
        self.offer = kwargs.get('offer', None)
        self.sku = kwargs.get('sku', None)
