#!/usr/bin/python
# -*- Mode: Python; python-indent: 8; indent-tabs-mode: t -*-

import sys, os, errno
import datetime
import re

devel_time = False
if devel_time:
	def log_debug(x):
		print x

        def log_slight_risk(x):
		print x

        def log_warning(x):
		print x

	def log_error(x):
		print x

	def exit_pass():
		sys.exit(0)

	def exit_fail():
		sys.exit(1)

	def exit_error():
		sys.exit(-1)
else:
	from preup.script_api import *

"""Preupgrade Assistant performs system upgradability assessment
and gathers information required for successful operating system upgrade.
Copyright (C) 2013 Red Hat Inc.
Frantisek Kluknavsky <fkluknav@redhat.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>."""
check_rpm_to (check_rpm="filesystem",check_bin="")
set_component("distribution")
#END GENERATED SECTION

# exit functions are exit_{pass,not_applicable, fixed, fail, etc.}
# logging functions are log_{error, warning, info, etc.}
# for logging in-place risk use functions log_{extreme, high, medium, slight}_risk

def cgroup_daemon():
	cgroup_re = re.compile(r"\bCGROUP_DAEMON\b") #\b  Matches the empty string, but only at the beginning or end of a word. A word is defined as a sequence of alphanumeric or underscore characters,
	found = False
	for root, dirs, files in os.walk('/etc/sysconfig'):
		for filename in files:
			with open(root+"/"+filename, "r") as f:
				data = f.read()
			if cgroup_re.search(data):
				found = True
				log_slight_risk("File '" + filename + "' mentions CGROUP_DAEMON.")

	return found


if __name__ == "__main__":
	if cgroup_daemon():
		exit_fail()
	else:
		exit_pass()
