#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to ""
COMPONENT=""
#END GENERATED SECTION

COMPONENT="distribution"
ADD_ONS=\
"83.pem|HighAvailability|/content/htb/rhel/server/7/\$basearch/highavailability/os 
90.pem|ResilientStorage|/content/htb/rhel/server/7/\$basearch/resilientstorage/os"

PART_RHEL7="92.pem|ScalableFileSystem 85.pem|LoadBalancer"
found=0
found_info=0
cd /etc/pki/product
for addon in $PART_RHEL7
do
    PEM_NAME=`echo $addon | cut -d'|' -f1`
    NAME=`echo $addon | cut -d'|' -f2`
    PEM=`ls -1 *.pem 2>/dev/null`
    echo "$PEM" | grep "$PEM_NAME" > /dev/null
    if [ $? -eq 0 ]; then
        found_info=1
        log_info "Content detects $NAME Add-On. No action is needed for RHEL 7."
    continue
    fi

done

for addon in $ADD_ONS
do
    PEM_NAME=`echo $addon | cut -d'|' -f1`
    NAME=`echo $addon | cut -d'|' -f2`
    PEM=`ls -1 *.pem 2>/dev/null`
    echo "$PEM" | grep "$PEM_NAME" > /dev/null
    if [ $? -eq 0 ]; then
        found=1
        log_high_risk "Content detects $NAME Add-On. If you would like to do an in-place upgrade, please specify $NAME repo to as --addrepo option in redhat-upgrade-tool"
        continue
    fi

done
if [ $found -eq 1 ]; then
    exit_fail
fi

if [ $found_info -eq 1 ]; then
  exit_informational
fi

exit_pass

