#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to ""
COMPONENT=""
#END GENERATED SECTION

if [ ! -f "$VALUE_RPM_RHSIGNED" ]; then
    log_error "File $VALUE_RPM_RHSIGNED is required."
    exit_error
fi

PACKAGE_LIST="modcluster cluster clustermon corosync luci pacemaker pcs rgmanager ricci openais foghorn ccs cluster-glue"

CLUSTER_CONFIG="/etc/cluster/cluster.conf"
COROSYNC_CONFIG="/etc/corosync/corosync.conf"

found=0
packages=""
for pkg in $PACKAGE_LIST;
do
    grep -q "^$pkg[[:space:]]" $VALUE_RPM_QA && is_dist_native $pkg
    if [ $? -eq 0 ]; then
        log_info "Package $pkg is installed."
        packages="$packages $pkg"
        found=1
    fi
done
if [ $found -eq 1 ]; then
    log_extreme_risk "High Availability AddOn packages are installed. Upgrade is not possible."
    echo "If you don't use following cluster&HA related packages:$packages , uninstall them and re-run preupgrade-assistant." >>hacluster.txt
    exit_fail
fi

if [ -f "$CLUSTER_CONFIG" ] || [ -f "$COROSYNC_CONFIG" ]; then
    log_extreme_risk "High Availability AddOn config files $CLUSTER_CONFIG or $COROSYNC_CONFIG exist. Upgrade is not possible."
    exit_fail
fi

exit_pass

