#!/bin/bash

#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Jakub Mazanek <jmazanek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "openldap-servers"
COMPONENT="openldap-servers"
#END GENERATED SECTION
if [ -z $SOLUTION_FILE ]; then
  SOLUTION_FILE="./solution.txt"
fi
cat /dev/null > $SOLUTION_FILE
confile='/etc/openldap/slapd.conf'
confdir='/etc/openldap/'
cust_confile='<your_configuration_file>'
cp --parents -ar $confdir $VALUE_TMP_PREUPGRADE/dirtyconf/


if ! [ -e "$confile" ];then
   echo " $confile doesn't exist, if you have slapd configuration file in alternative location run 
the following command to test it's consistency:
slaptest -v -f $cust_confile" >> $SOLUTION_FILE
   log_medium_risk "It is recommended to use new directory format of slapd configuration on RHEL 7. If you wish to migrate your slapd configuration to the new format use the following commands:
slaptest -f $cust_confile -F $confdir 
chown -R ldap:ldap $confdir"
   exit_informational
else
   echo "It is recommended to use new directory format of slapd configuration on RHEL 7. If you wish to migrate your slapd configuration to the new format use the following commands:
slaptest -f $confile -F $confdir
chown -R ldap:ldap $confdir " >> $SOLUTION_FILE
  slaptest -v -f "$confile" 2>&1 | grep "database ldbm" > /dev/null
   if [[ "$?" -eq 0 ]];then

      echo "Change database directive in $confile to bdb" >> $SOLUTION_FILE
      log_high_risk "back-ldbm database backend is obsolete and should not be used"
      exit_fail
   else
      exit_informational
   fi
fi
