#! /usr/bin/env bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Boris Ranto <branto@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "qemu-guest-agent"
COMPONENT="qemu-guest-agent"
#END GENERATED SECTION

chkconfig qemu-ga
E_CHK=$?
service qemu-ga status > /dev/null 2> /dev/null
E_SRV=$?
if test $E_CHK -eq 0 -o $E_SRV -eq 0; then
	# This is more critical if the service is in fact enabled or running
	log_medium_risk "Several qemu guest agent files and filenames were modified in Red Hat Enterprise Linux 7."
	exit "$RESULT_FAIL"
else
	log_slight_risk "Several qemu guest agent files and filenames were modified in Red Hat Enterprise Linux 7."
	exit "$RESULT_INFORMATIONAL"
fi
