#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" ""
COMPONENT="distribution"
#END GENERATED SECTION

[ ! -r cansave ] && log_error generic Part of the content is missing! && \
  exit $RESULT_ERROR

found=0
#Some of the package have the same version (tarball) in RHEL 6 and RHEL 7.
#Therefore we can store their modified configuration files safely.
while read i
do
  #skip non-rh and unavailable packages
  grep -q "^$i[[:space:]]" $VALUE_RPM_QA && is_dist_native "$i" || continue

  #copy the modified /etc/ located files to the preupgrade destination directory
  for j in $(rpm -ql $i | grep ^/etc/)
  do
    grep " $j$" $VALUE_CONFIGCHANGED >/dev/null && \
      cp --parents -a "$j" "$VALUE_TMP_PREUPGRADE"/cleanconf/ && \
      log_info $i "user modified config file $j stored" && found=1
  done
done < cansave

[ $found -eq 1 ] && exit $RESULT_FIXED

exit $RESULT_PASS
