#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Tomas Hozza <thozza@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "bind-chroot"
COMPONENT="bind-chroot"
#END GENERATED SECTION

chroot_dir=$(grep "^ROOTDIR" /etc/sysconfig/named | awk -F'=' '!/^($|[[:space:]]*#)/{print $2}')

if grep -wq "^ROOTDIR" /etc/sysconfig/named  && [[ -d "$chroot_dir" ]];then
    cp --parents -ar  /etc/sysconfig/named  $VALUE_TMP_PREUPGRADE/dirtyconf
    declare -a bind_chroot_configs=( "$chroot_dir"/etc/rndc.key /etc/rndc.conf "$chroot_dir"/etc/named.conf )
    for file in /var/named/chroot/var/named/db.*;do
        if [[ -e "$file" ]];then
          bind_chroot_configs+=( "$chroot_dir"/var/named/db.* )
        fi
        break
    done
    printf '%s\n' ${bind_chroot_configs[@]} | while IFS= read -r config
    do
        if [[ -e "$config"  ]];then
        cp --parents -ar "$config" $VALUE_TMP_PREUPGRADE/cleanconf/
        fi
    done
    echo "Your bind-chroot setup configuration files have been backed up" >> $SOLUTION_FILE
fi


log_slight_risk "bind-chroot package has been detected"

#We need to make sure that admin reviews the solution.txt
exit $RESULT_FAIL
